       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP411.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     NOV 03,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      *** THIS PROGRAM GENERATES A REPORT TO DISPLAY THE METERS THAT ***        
      *** HAVE MISMATCH WITH THE COMPUTED CONSTANT AND THE CONSTANT  ***        
      *** IN METER CAP TABLE                                         ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT032***  11/03/2015    MS7M727     EZT TO COBOL CONVERSION         ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN  TO UT-S-FCSPT33                                  
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP411'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_METER - EM                                                     
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_CAP - MC                                               *        
      ******************************************************************        
           EXEC SQL                                                     00880000
              INCLUDE TBMTRCAP                                          00890000
           END-EXEC.                                                    00900000
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT - EQ                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_INSTR_XFORMER  - IX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINXFOR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      *******FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077******        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01 WS-LITERAL.                                                   
          05 PROGRAM-NAME                   PIC X(08) VALUE             
                                                       'PCSRP411'.      
      *                                                                         
       01 WS-FILE-STATUS-SW.                                            
          05  WS-FCSPT33-STATUS             PIC  X(02).                 
              88 FCSPT33-SUCCESSFUL                    VALUE '00'.      
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-01                         PIC X(02) VALUE '01'.       
           05 WS-J                          PIC X(01) VALUE 'J'.        
           05 WS-E                          PIC X(01) VALUE 'E'.        
           05 WS-X                          PIC X(01) VALUE 'X'.        
           05 WS-CT                         PIC X(02) VALUE 'CT'.       
           05 WS-PT                         PIC X(02) VALUE 'PT'.       
           05 CT-RATIO-NOT-EQUAL            PIC X(01) VALUE 'Y'.        
           05 PT-RATIO-NOT-EQUAL            PIC X(01) VALUE 'Y'.        
           05 WS-PREV-MTR-NO                PIC X(09) VALUE SPACES.     
           05 WS-CT-NO                      PIC 9(02) VALUE ZERO.       
           05 WS-PT-NO                      PIC 9(02) VALUE ZERO.       
           05 WS-PREV-CT-RATIO              PIC S9(04)V9(03) USAGE      
                                                COMP-3 VALUE +1.        
           05 WS-CUR-CT-RATIO               PIC S9(04)V9(03) USAGE      
                                                COMP-3 VALUE 0.         
           05 WS-PREV-PT-RATIO              PIC S9(04)V9(03) USAGE      
                                                COMP-3 VALUE +1.        
           05 WS-CUR-PT-RATIO               PIC S9(04)V9(03) USAGE      
                                                COMP-3 VALUE 0.         
           05 WS-COMP-CONST                 PIC S9(05)V9(03) USAGE      
                                                COMP-3 VALUE 0.         
           05 WS-METER-CONST                PIC S9(05)V9(03) USAGE      
                                                COMP-3 VALUE 0.         
           05 WS-ACTION                     PIC X(10) VALUE SPACES.     
           05 WS-CURSOR                     PIC X(20) VALUE SPACES.     
           05 WS-DATA-FOUND                 PIC X(01) VALUE 'N'.        
           05 WS-MISMATCH-FOUND             PIC X(01) VALUE 'N'.        
           05 WS-XFRMR-FOUND                PIC X(01) VALUE 'N'.        
           05 WS-CATEGORY-ID                PIC 9(03) VALUE 0.          
           05 WS-WQ-COMMENTS                PIC X(235) VALUE SPACES.    
           05 WS-PAGE-NUM                   PIC 9(02) VALUE 01.         
           05 WS-FIRST                      PIC X(01) VALUE 'Y'.        
           05 WS-LINE-COUNT                 PIC 9(02) VALUE ZERO.       
           05 WS-FIRST-DETAIL-REC           PIC X(01) VALUE 'Y'.        
           05 SCSCB077                      PIC X(08) VALUE 'SCSCB077'. 
           05 RS-RETURN-CODE                PIC S9(09) COMP VALUE +0.   
      *                                                                         
       01 WS-WQ-COMMENTS-1.                                             
          05 WS-WQ-COMMENTS-2               PIC X(33) VALUE             
                                   'INVALID CT/PT RATIO FOR DEVICE # '. 
          05 WS-WQ-COMMENTS-3               PIC X(09) VALUE SPACES.     
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                        PIC 9(02) VALUE ZERO.       
           05  WS-MM                        PIC 9(02) VALUE ZERO.       
           05  WS-SS                        PIC 9(02) VALUE ZERO.       
           05  WS-TT                        PIC 9(02) VALUE ZERO.       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                     PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '.'.        
           05  WS-RT-MM                     PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '.'.        
           05  WS-RT-SS                     PIC X(02) VALUE SPACES.     
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                        PIC 9(04) VALUE ZERO.       
           05  WS-CM                        PIC 9(02) VALUE ZERO.       
           05  WS-CD                        PIC 9(02) VALUE ZERO.       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                     PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RD-DD                     PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RD-YY                     PIC X(04) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER1.                                               
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-PGM-NAME                 PIC X(11) VALUE             
                                                      'PCSRP41101'.     
          05 FILLER                         PIC X(34) VALUE SPACES.     
          05 P-RPT-COMPANY-NAME             PIC X(39) VALUE             
                            'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.  
          05 FILLER                         PIC X(37) VALUE SPACES.     
          05 P-RPT-PAGE-NAME                PIC X(04) VALUE 'PAGE'.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 P-RPT-PAGE-NUMBER              PIC Z(02) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER2.                                               
          05 FILLER                         PIC X(49) VALUE SPACES.     
          05 P-RPT-MTR-CONS-MISMATCH        PIC X(30) VALUE             
                                 'METERS WITH CONSTANT MISMATCH '.      
          05 FILLER                         PIC X(35) VALUE SPACES.     
          05 P-RPT-RUN-DATE                 PIC X(09) VALUE             
                                               'RUN-DATE:'.             
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-RUN-DATE1                PIC X(08) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER3.                                               
          05 FILLER                         PIC X(114) VALUE SPACES.    
          05 P-RPT-RUN-TIME                 PIC X(09) VALUE             
                                               'RUN-TIME:'.             
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-RUN-TIME1                PIC X(08) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER4.                                               
          05 FILLER                         PIC X(133) VALUE SPACES.    
      *                                                                         
       01 WS-RPT-HEADER5.                                               
          05 FILLLER                        PIC X(13) VALUE SPACES.     
          05 P-RPT-METER-NO                 PIC X(12) VALUE             
                                                    'METER NUMBER'.     
          05 FILLER                         PIC X(14) VALUE SPACES.     
          05 P-RPT-CT-RATIO                 PIC X(08) VALUE             
                                                    'CT RATIO'.         
          05 FILLER                         PIC X(12) VALUE SPACES.     
          05 P-RPT-PT-RATIO                 PIC X(08) VALUE             
                                                  'PT RATIO'.           
          05 FILLER                         PIC X(12) VALUE SPACES.     
          05 P-RPT-COMPUTED-CONSTANT                                    
                                            PIC X(17) VALUE             
                                              'COMPUTED CONSTANT'.      
          05 FILLER                         PIC X(10) VALUE SPACES.     
          05 P-RPT-CONSTANT                 PIC X(08) VALUE             
                                                        'CONSTANT'.     
          05 FILLER                         PIC X(19) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER6.                                               
          05 FILLLER                        PIC X(14) VALUE SPACES.     
          05 P-RPT-METER-NO1                PIC X(09) VALUE SPACES.     
                                                                        
          05 FILLER                         PIC X(16) VALUE SPACES.     
          05 P-RPT-CT-RATIO1                PIC ZZZZ.999                
                                                      VALUE ZERO.       
          05 FILLER                         PIC X(12) VALUE SPACES.     
          05 P-RPT-PT-RATIO1                PIC ZZZZ.999                
                                                      VALUE ZERO.       
          05 FILLER                         PIC X(15) VALUE SPACES.     
          05 P-RPT-COMPUTED-CONSTANT1                                   
                                            PIC ZZ,ZZZ.999              
                                                      VALUE ZERO.       
          05 FILLER                         PIC X(12) VALUE SPACES.     
          05 P-RPT-CONSTANT1                PIC ZZ,ZZZ.999              
                                                      VALUE ZERO.       
          05 FILLER                         PIC X(19) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER7.                                               
          05 FILLER                         PIC X(54) VALUE SPACES.     
          05 P-RPT-END-REPORT               PIC X(21) VALUE             
                                             '*** END OF REPORT ***'.   
          05 FILLER                         PIC X(58) VALUE SPACES.     
      *                                                                         
       01 WS-RPT-HEADER8.                                               
          05 FILLER                         PIC X(45) VALUE SPACES.     
          05 P-RPT-NO-DATA                  PIC X(31) VALUE             
                                  '** NO DATA FOUND FOR THIS RUN**'.    
          05 FILLER                         PIC X(57) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      **THIS CURSOR FOR RETRIEVING ROWS FOR CONSTANT.INDUSTIRAL INVOICE*        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CONS_INDUS CURSOR FOR                             
               SELECT MC.CONSTANT                                       
                     ,MA.CODE_ATT_TYPE                                  
                     ,EM.METER_NO                                       
                     ,MA.CT_PT_RATIO                                    
                     ,MA.DEVICE_NO                                      
                 FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                   
                     ,CSS_MTR_CAP MC WITH(READUNCOMMITTED)                      
                     ,CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
                     ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                    
                WHERE MA.COMPANY_NO = EM.COMPANY_NO                     
                  AND MA.COMPANY_NO = MC.COMPANY_NO                     
                  AND MA.COMPANY_NO = EQ.COMPANY_NO                     
                  AND MA.COMPANY_NO = :WS-01                            
                  AND MA.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE             
                  AND MA.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE             
                  AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE             
                  AND MA.CODE_UTIL_TYPE = :WS-E                         
                  AND MA.METER_NO = EM.METER_NO                         
                  AND MA.METER_NO = MC.METER_NO                         
                  AND MA.METER_NO = EQ.DEVICE_NO                        
                  AND EQ.CODE_CRNT_LOC = :WS-J                          
                  AND MC.REG_ID_NO = 1                                  
                  AND EM.OVERRIDE_CONST_FL <> 'Y'                       
                ORDER BY EM.METER_NO                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONS_INDUS CURSOR FOR                                     
MFA-TR*        SELECT MC.CONSTANT                                               
MFA-TR*              ,MA.CODE_ATT_TYPE                                          
MFA-TR*              ,EM.METER_NO                                               
MFA-TR*              ,MA.CT_PT_RATIO                                            
MFA-TR*              ,MA.DEVICE_NO                                              
MFA-TR*          FROM CSS_ELEC_METER EM                                         
MFA-TR*              ,CSS_MTR_CAP MC                                            
MFA-TR*              ,CSS_METER_ATTCHMTS MA                                     
MFA-TR*              ,CSS_EQUIPMENT EQ                                          
MFA-TR*         WHERE MA.COMPANY_NO = EM.COMPANY_NO                             
MFA-TR*           AND MA.COMPANY_NO = MC.COMPANY_NO                             
MFA-TR*           AND MA.COMPANY_NO = EQ.COMPANY_NO                             
MFA-TR*           AND MA.COMPANY_NO = :WS-01                                    
MFA-TR*           AND MA.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                     
MFA-TR*           AND MA.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                     
MFA-TR*           AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                     
MFA-TR*           AND MA.CODE_UTIL_TYPE = :WS-E                                 
MFA-TR*           AND MA.METER_NO = EM.METER_NO                                 
MFA-TR*           AND MA.METER_NO = MC.METER_NO                                 
MFA-TR*           AND MA.METER_NO = EQ.DEVICE_NO                                
MFA-TR*           AND EQ.CODE_CRNT_LOC = :WS-J                                  
MFA-TR*           AND MC.REG_ID_NO = 1                                          
MFA-TR*           AND EM.OVERRIDE_CONST_FL <> 'Y'                               
MFA-TR*         ORDER BY EM.METER_NO                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      ** CONTROLS THE MAIN PATH OF THE PROGRAM                        **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
      *                                                                         
           PERFORM 2000-PROCESS-MAIN-CSR      THRU 2000-EXIT.           
      *                                                                         
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME1.            
      *                                                                         
           ACCEPT WS-CURRENT-DATE  FROM DATE YYYYMMDD.                  
           MOVE WS-CY(3:2)               TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE1.            
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP411******************'         
               DISPLAY '**  ERROR OPENING FCSPT33           **'         
               DISPLAY '**  FILE STATUS = 'WS-FCSPT33-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-MAIN-CSR **                                               
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 7100-OPEN-CONS-INDUS-INFO    THRU 7100-EXIT.         
      *                                                                         
           PERFORM 7200-FETCH-CONS-INDUS-INFO   THRU 7200-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE EM-METER-NO           TO WS-PREV-MTR-NO              
              MOVE MC-CONSTANT           TO WS-METER-CONST              
           END-IF.                                                      
      *                                                                         
           PERFORM 2100-PROCESS-METER-CONSTANT  THRU 2100-EXIT          
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           PERFORM 2300-CHECK-NO-MISMATCH-DATA  THRU 2300-EXIT.         
      *                                                                         
           IF WS-LINE-COUNT >= 1                                        
              MOVE WS-RPT-HEADER7        TO PRT33-RECORD                
              PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7300-CLOSE-CONS-INDUS-INFO   THRU 7300-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-METER-CONSTANT ** **                                      
      ******************************************************************        
      *                                                                         
       2100-PROCESS-METER-CONSTANT.                                     
      *                                                                         
           MOVE 'Y'                      TO WS-DATA-FOUND.              
           IF WS-PREV-MTR-NO NOT EQUAL EM-METER-NO                      
              COMPUTE WS-COMP-CONST = ( WS-PREV-CT-RATIO *              
                                       WS-PREV-PT-RATIO )               
              IF WS-METER-CONST NOT EQUAL WS-COMP-CONST                 
                 MOVE 'Y'                TO WS-MISMATCH-FOUND           
                 PERFORM 2200-WRITE-DETAIL-PROCESS  THRU 2200-EXIT      
              END-IF                                                    
              MOVE  MC-CONSTANT          TO WS-METER-CONST              
              MOVE  EM-METER-NO          TO WS-PREV-MTR-NO              
              MOVE  0                    TO WS-CT-NO                    
              MOVE  0                    TO WS-PT-NO                    
              MOVE  +1                   TO WS-PREV-CT-RATIO            
              MOVE  +1                   TO WS-PREV-PT-RATIO            
           END-IF.                                                      
           IF  MA-CODE-ATT-TYPE EQUAL WS-CT OR                          
               MA-CODE-ATT-TYPE EQUAL WS-PT                             
               MOVE WS-X                 TO IX-CODE-UTIL-TYPE           
               MOVE MA-DEVICE-NO         TO IX-XFORMER-NO               
               MOVE WS-01                TO IX-COMPANY-NO               
      *                                                                         
               PERFORM 7400-SELECT-INTSTR-XFRMR-INFO THRU 7400-EXIT     
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE 'Y'               TO WS-XFRMR-FOUND              
               END-IF                                                   
      *                                                                         
               IF WS-XFRMR-FOUND EQUAL 'Y'                              
                  MOVE 'N'               TO WS-XFRMR-FOUND              
                  IF IX-RTO-UPPER-FRACTION EQUAL 0 OR                   
                     IX-RTO-LOWER-FRACTION EQUAL 0                      
                     MOVE 143            TO WS-CATEGORY-ID              
                     MOVE MA-DEVICE-NO   TO WS-WQ-COMMENTS-3            
                     MOVE WS-WQ-COMMENTS-1 TO WS-WQ-COMMENTS            
                     PERFORM 2400-MOVE-WORKQ-ITEM-TABLE   THRU 2400-EXIT
                     PERFORM 5000-CALL-WORK-QUEUE-INSERT  THRU 5000-EXIT
                                                                        
                  ELSE                                                  
                      IF MA-CODE-ATT-TYPE EQUAL WS-CT                   
                         COMPUTE WS-CT-NO = WS-CT-NO + 1                
                         MOVE 'N'        TO CT-RATIO-NOT-EQUAL          
                         COMPUTE WS-CUR-CT-RATIO =                      
                                 ( IX-RTO-UPPER-FRACTION /              
                                   IX-RTO-LOWER-FRACTION )              
                         IF WS-CT-NO EQUAL 1                            
                            MOVE WS-CUR-CT-RATIO TO  WS-PREV-CT-RATIO   
                         ELSE                                           
                             IF  WS-CUR-CT-RATIO NOT EQUAL              
                                                     WS-PREV-CT-RATIO   
                                MOVE 'Y'         TO                     
                                                  CT-RATIO-NOT-EQUAL    
                             END-IF                                     
                         END-IF                                         
                      ELSE                                              
                          COMPUTE WS-PT-NO = WS-PT-NO + 1               
                          COMPUTE WS-CUR-PT-RATIO =                     
                                             ( IX-RTO-UPPER-FRACTION /  
                                               IX-RTO-LOWER-FRACTION )  
                          IF  WS-PT-NO EQUAL 1                          
                              MOVE WS-CUR-PT-RATIO TO                   
                                                     WS-PREV-PT-RATIO   
                          ELSE                                          
                             IF WS-CUR-PT-RATIO NOT EQUAL               
                                                     WS-PREV-PT-RATIO   
                                MOVE 'Y'           TO                   
                                                  PT-RATIO-NOT-EQUAL    
                             END-IF                                     
                          END-IF                                        
                      END-IF                                            
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
           PERFORM 7200-FETCH-CONS-INDUS-INFO   THRU 7200-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-WRITE-DETAIL-PROCESS.                                             
      ******************************************************************        
      *                                                                         
       2200-WRITE-DETAIL-PROCESS.                                       
      *                                                                         
           IF WS-FIRST EQUAL 'Y'  OR WS-LINE-COUNT >=  50               
              IF WS-LINE-COUNT >=  50                                   
                 MOVE ZERO               TO WS-LINE-COUNT               
              END-IF                                                    
              MOVE WS-PAGE-NUM           TO P-RPT-PAGE-NUMBER           
              ADD 1                      TO WS-PAGE-NUM                 
              MOVE WS-RPT-HEADER1        TO PRT33-RECORD                
              PERFORM 8000-WRITE-FCSPT33         THRU 8000-EXIT         
              MOVE WS-RPT-HEADER2        TO PRT33-RECORD                
              PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT          
              MOVE WS-RPT-HEADER3        TO PRT33-RECORD                
              PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT          
              MOVE WS-RPT-HEADER4        TO PRT33-RECORD                
              PERFORM 8200-WRITE-FCSPT33        THRU 8200-EXIT          
              MOVE WS-RPT-HEADER5        TO PRT33-RECORD                
              PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT          
              MOVE 'Y'                   TO WS-FIRST-DETAIL-REC         
           END-IF.                                                      
             COMPUTE WS-LINE-COUNT  = WS-LINE-COUNT + 1.                
             MOVE 'N'                    TO WS-FIRST.                   
             MOVE WS-PREV-MTR-NO         TO P-RPT-METER-NO1.            
             MOVE WS-PREV-CT-RATIO       TO P-RPT-CT-RATIO1.            
             MOVE WS-PREV-PT-RATIO       TO P-RPT-PT-RATIO1.            
             MOVE WS-COMP-CONST          TO                             
                                            P-RPT-COMPUTED-CONSTANT1.   
                                                                        
             MOVE WS-METER-CONST         TO P-RPT-CONSTANT1.            
             MOVE WS-RPT-HEADER6         TO PRT33-RECORD.               
             IF WS-FIRST-DETAIL-REC EQUAL 'Y'                           
                PERFORM 8300-WRITE-FCSPT33      THRU 8300-EXIT          
             ELSE                                                       
                PERFORM 8100-WRITE-FCSPT33      THRU 8100-EXIT          
             END-IF.                                                    
             MOVE 'N'                    TO WS-FIRST-DETAIL-REC.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-CHECK-NO-MISMATCH-DATA.                                           
      ******************************************************************        
      *                                                                         
       2300-CHECK-NO-MISMATCH-DATA.                                     
      *                                                                         
           IF WS-DATA-FOUND EQUAL 'N' OR                                
              WS-MISMATCH-FOUND EQUAL 'N'                               
              MOVE WS-PAGE-NUM           TO P-RPT-PAGE-NUMBER           
              PERFORM 2500-WRITE-NO-DATA-FOUND  THRU 2500-EXIT          
              MOVE WS-RPT-HEADER8        TO PRT33-RECORD                
              PERFORM 8100-WRITE-FCSPT33        THRU 8100-EXIT          
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-MOVE-WORKQ-ITEM-TABLE.                                 **         
      ******************************************************************        
      *                                                                         
       2400-MOVE-WORKQ-ITEM-TABLE.                                      
      *                                                                         
           MOVE 0                        TO  WS-77-SERV-ORDER-NO.       
           MOVE WS-CATEGORY-ID           TO  WS-77-CATEGORY-ID.         
           MOVE 0                        TO  WS-77-ACCOUNT-NO.          
           MOVE 0                        TO  WS-77-PREMISE-NO.          
           MOVE 0                        TO  WS-77-CUSTOMER-NO.         
           MOVE 'SYSTEM'                 TO  WS-77-USER-ID-ORIG.        
           MOVE SPACES                   TO  WS-77-RESP-AREA-ID.        
           MOVE SPACES                   TO  WS-77-LOCAL-OFFICE.        
           MOVE '4'                      TO  WS-77-ROUTE-CATEGORY.      
           MOVE 'N'                      TO  WS-77-PRIORITY.            
           MOVE PROGRAM-NAME             TO WS-77-CREATED-BY.           
           MOVE LENGTH OF WS-WQ-COMMENTS TO                             
                                          WS-77-COMMENTS-LEN.           
           MOVE WS-WQ-COMMENTS           TO  WS-77-COMMENTS-TEXT.       
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-WRITE-NO-DATA-FOUND.                                              
      ******************************************************************        
      *                                                                         
       2500-WRITE-NO-DATA-FOUND.                                        
      *                                                                         
           MOVE WS-RPT-HEADER1           TO PRT33-RECORD.               
           PERFORM 8000-WRITE-FCSPT33           THRU 8000-EXIT.         
           MOVE WS-RPT-HEADER2           TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33           THRU 8100-EXIT.         
           MOVE WS-RPT-HEADER3           TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33           THRU 8100-EXIT.         
           MOVE WS-RPT-HEADER4           TO PRT33-RECORD.               
           PERFORM 8200-WRITE-FCSPT33           THRU 8200-EXIT.         
           MOVE WS-RPT-HEADER5           TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33           THRU 8100-EXIT.         
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   5000-CALL-WORK-QUEUE-INSERT                                           
      ******************************************************************        
      *                                                                         
       5000-CALL-WORK-QUEUE-INSERT.                                     
                                                                        
           MOVE SPACES                      TO ABEND-FUNCTION.          
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              DISPLAY '******** PCSRP411 ABORT ******'                  
              DISPLAY '**5000-CALL-WORK-QUEUE-INSERT***'                
              DISPLAY '**ACCOUNT_NO    =' WS-77-ACCOUNT-NO              
              DISPLAY '**PREMISE_NO    =' WS-77-PREMISE-NO              
              DISPLAY '**CATEGORY_ID   =' WS-77-CATEGORY-ID             
              DISPLAY '**COMMENTS      =' WS-77-COMMENTS-TEXT           
              DISPLAY '**RETURN CODE   =' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**PROCESSING TERMINATED**'                       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-OPEN-CONS-INDUS-INFO                                              
      ******************************************************************        
      *                                                                         
       7100-OPEN-CONS-INDUS-INFO.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN CONS_INDUS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP411 ABORT ******'                  
              DISPLAY '**  7100-OPEN-CONS-INDUS-INFO ***'               
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-FETCH-CONS-INDUS-INFO                                  **        
      ******************************************************************        
      *                                                                         
       7200-FETCH-CONS-INDUS-INFO.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH CONS_INDUS                                          
               INTO :MC-CONSTANT                                        
                   ,:MA-CODE-ATT-TYPE                                   
                   ,:EM-METER-NO                                        
                   ,:MA-CT-PT-RATIO                                     
                   ,:MA-DEVICE-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP411 ABORT ******'                  
              DISPLAY '**  7200-FETCH-CONS-INDUS-INFO **'               
              DISPLAY '**  COMPANY-NO             **' EM-METER-NO       
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-CLOSE-CONS-INDUS-INFO                                   **        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-CONS-INDUS-INFO.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE CONS_INDUS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP411 ABORT *****'                   
              DISPLAY '**  7300-CLOSE-CONS-INDUS-INFO ***'              
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-SELECT-INTSTR-XFRMR-INFO                                          
      ******************************************************************        
      *                                                                         
       7400-SELECT-INTSTR-XFRMR-INFO.                                   
      *                                                                         
           EXEC SQL                                                     
               SELECT XFORMER_TYPE_CD                                   
                     ,RTO_UPPER_FRACTION                                
                     ,RTO_LOWER_FRACTION                                
                 INTO                                                   
                      :IX-XFORMER-TYPE-CD                               
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                 FROM  CSS_INSTR_XFORMER WITH(READUNCOMMITTED)                  
                WHERE  COMPANY_NO        =  :IX-COMPANY-NO              
                  AND  CODE_UTIL_TYPE    =  :IX-CODE-UTIL-TYPE          
                  AND  XFORMER_NO        =  :IX-XFORMER-NO              
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XFORMER_TYPE_CD                                           
MFA-TR*              ,RTO_UPPER_FRACTION                                        
MFA-TR*              ,RTO_LOWER_FRACTION                                        
MFA-TR*          INTO                                                           
MFA-TR*               :IX-XFORMER-TYPE-CD                                       
MFA-TR*              ,:IX-RTO-UPPER-FRACTION                                    
MFA-TR*              ,:IX-RTO-LOWER-FRACTION                                    
MFA-TR*          FROM  CSS_INSTR_XFORMER                                        
MFA-TR*         WHERE  COMPANY_NO        =  :IX-COMPANY-NO                      
MFA-TR*           AND  CODE_UTIL_TYPE    =  :IX-CODE-UTIL-TYPE                  
MFA-TR*           AND  XFORMER_NO        =  :IX-XFORMER-NO                      
MFA-TR*          WITH  UR                                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP411 ABORT ******'                  
              DISPLAY '**  7400-SELECT-INTSTR-XFRMR-INFO **'            
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  COMPANY_NO          = ' IX-COMPANY-NO        
              DISPLAY '**  CODE_UTIL_TYPE      = ' IX-CODE-UTIL-TYPE    
              DISPLAY '**  XFORMER_NO          = ' IX-XFORMER-NO        
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
