       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP406.                                        
       DATE-WRITTEN.   04/21/1998.                                      
           AUTHOR.         CBSIMDS.                                     
      ******************************************************************00050000
      **              SOUTH CAROLINA ELECTRIC & GAS                   **00060000
      **         COMPLETE BUSINESS SOLUTIONS INC., CHENNAI            **00070000
      **                                                              **00080000
      *********         CUSTOMER SERVICE SYSTEM            *************00090000
      *********                DB2                         *************00100000
      ******************************************************************00110000
      **                                                              **00120000
      **                  PROGRAM MODIFICATION LOG                    **00130000
      **    DATE     INITIALS        REASON                           **00140000
      **    ____     _________       ______                           **00150000
      **                                                              **00160001
C36071**  08/31/07   SV82012         ADDED NAME CHANGE TRANSACTIONS   **00161002
C36071**                             AND CHANGED REPORT LAYOUT.       **00162002
      **                                                              **00170001
      ******************************************************************00180001
      *                                                                 00190001
       REMARKS.                                                         
                                PCSCA406 NARRATIVE                      
                    STATISTICAL REPORT FOR INDUSTRIAL CUSTOMER.         
              THIS PROGRAM READS AN INPUT FILE, MOVE THE RECORDS TO     
         THE PRINT FILE AND GIVES A REPORT.                             
                                                                        
              --------BASIC SEQUENCE STRUCTURE----------                
              0000-0999      MAIN CONTROL PATH AND INITIALIZATION       
              1000-1999      INPUT PROCESSING CONTROL PATH              
              2000-2999      OUTPUT PROCESSING CONTROL PATH             
              9000-9799      TERMINATION MODULES                        
      *                                                                 00380001
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00420001
       COPY CSSCA406.                                                   00421001
      *                                                                 00450001
       COPY CSSPT33.                                                    00460001
                                                                        
                                                                        
      *                                                                 00490001
HPCCDM*SKIP1                                                            00500001
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *                                                                 00540001
       COPY CFDCA406.                                                   00561001
       COPY FIOCA406.                                                   00562001
      *                                                                 00640001
       COPY CFDPT33.                                                    00650001
      *                                                                 00690001
       WORKING-STORAGE SECTION.                                         
      *                                                                 00710001
       01  WS-FEILDS.                                                   
           05  WS-END-OF-FILE                PIC  X(01) VALUE 'N'.      
           05  WS-PRT-LINE-SPACE             PIC  9(01) VALUE  0.       
           05  WS-MAX-LINES                  PIC  9(02) VALUE  56.      
           05  WS-ERR-MSG1                   PIC  X(50).                
           05  WS-LINE-CTR                   PIC  9(02) VALUE  00.      
           05  WS-PAGE                       PIC  9(02) VALUE  00.      
           05  WS-OLD-REC-READ               PIC  9(06) VALUE ZEROS.    
           05  WS-NEW-REC-WRITE              PIC  9(06) VALUE ZEROS.    
       01  WS-DATE.                                                     
           03  WS-DT-YY                      PIC X(02).                 
           03  WS-DT-MM                      PIC X(02).                 
           03  WS-DT-DD                      PIC X(02).                 
      *                                                                 00850001
       01  WS-CUR-CCYY.                                                 
           03  WS-CUR-CC                     PIC 9(02).                 
           03  WS-CUR-YY                     PIC 9(02).                 
      *                                                                 00890001
       01  WS-STATUS.                                                   
           05  WS-FCSCA406-STATUS            PIC X(2).                  
      *                                                                 00920001
       01  WS-HDR1.                                                     
           03  FILLER                        PIC X(08) VALUE            
               'PCSRP406'.                                              
           03  FILLER                        PIC X(39) VALUE SPACES.    
           03  FILLER                        PIC X(39) VALUE            
               'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.               
           03  FILLER                        PIC X(33) VALUE SPACES.    
           03  FILLER                        PIC X(08) VALUE            
               'PAGE -  '.                                              
           03  WS-DET-PAGE                   PIC ZZZZ  VALUE SPACES.    
           03  FILLER                        PIC X(01) VALUE SPACES.    
      *                                                                 01030001
       01  WS-HDR2.                                                     
            03  FILLER                       PIC X(48) VALUE SPACES.    
            03  FILLER                       PIC X(42) VALUE            
                'STATISTICAL REPORT FOR INDUSTRIAL CUSTOMER'.           
            03  FILLER                       PIC X(31) VALUE SPACES.    
            03  WS-RPT-H2-DATE.                                         
                05  WS-RPT-H2-MM             PIC X(02).                 
                05  FILLER                   PIC X(01)  VALUE '/'.      
                05  WS-RPT-H2-DD             PIC X(02).                 
                05  FILLER                   PIC X(01)  VALUE '/'.      
                05  WS-RPT-H2-CCYY           PIC X(04).                 
           03  FILLER                        PIC X(01) VALUE SPACES.    
      *                                                                 01150001
       01  WS-HDR3.                                                     
C36071      03  FILLER                       PIC X(13) VALUE            
C36071          'ACCOUNT NO  '.                                         
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(35) VALUE            
C36071          'CURRENT NAME'.                                         
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(05) VALUE            
C36071          'CURR'.                                                 
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(04) VALUE            
C36071          'CURR'.                                                 
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(07) VALUE            
C36071          'CURRENT'.                                              
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(07) VALUE            
C36071          'CHANGE'.                                               
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(35) VALUE            
C36071          'PREVIOUS VALUE'.                                       
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(11) VALUE            
C36071          'CHANGE DATE'.                                          
C36071      03  FILLER                       PIC X(01) VALUE  SPACES.   
      *                                                                 01240001
C36071 01  WS-HDR3-1.                                                   
C36071      03  FILLER                       PIC X(52) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(05) VALUE            
C36071          'CLASS'.                                                
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(04) VALUE            
C36071          'RATE'.                                                 
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(07) VALUE            
C36071          'SERVICE'.                                              
C36071      03  FILLER                       PIC X(02) VALUE  SPACES.   
C36071      03  FILLER                       PIC X(07) VALUE            
C36071          'ITEM'.                                                 
C36071      03  FILLER                       PIC X(51) VALUE  SPACES.   
      *                                                                 01350001
       01  WS-RPT1.                                                     
            03  FILLER                       PIC X(04) VALUE SPACES.    
            03  FILLER                       PIC X(25) VALUE            
                'NO OF RECORDS READ     = '.                            
            03  WS-READ                      PIC 9(06) VALUE ZEROS.     
            03  FILLER                       PIC X(99) VALUE SPACES.    
      *                                                                 01410001
       01  WS-RPT2.                                                     
            03  FILLER                       PIC X(04) VALUE SPACES.    
            03  FILLER                       PIC X(25) VALUE            
                'NO OF RECORDS WRITTEN  = '.                            
            03  WS-WRITE                     PIC 9(06) VALUE ZEROS.     
            03  FILLER                       PIC X(99) VALUE SPACES.    
      *                                                                 01420001
       01  WS-RPT4.                                                     
           03  FILLER                        PIC X(50) VALUE SPACES.    
           03  FILLER                        PIC X(31) VALUE            
               '******** END OF REPORT ********'.                       
           03  FILLER                        PIC X(51) VALUE SPACES.    
      *                                                                 01530001
C36071 01  WS-DET-PRT.                                                  
C36071      03  WS-ACCT-NO                   PIC X(13).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CURR-NAME                 PIC X(35).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CURR-CLASS                PIC X(05).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CURR-RATE                 PIC X(04).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CURR-SERVICE              PIC X(07).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CHANGE-ITEM               PIC X(07).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-PREVIOUS-VALUES           PIC X(35).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071      03  WS-CHANGED-DATE              PIC X(10).                 
C36071      03  FILLER                       PIC X(02) VALUE SPACES.    
C36071*                                                                 01660006
       PROCEDURE DIVISION.                                              
      *                                                                 01680001
      ******************************************************************01690001
      *   CONTROLS MAIN PATH OF PROGRAM                                *01700001
      ******************************************************************01710001
       0000-MAIN-PARA.                                                  
           PERFORM 1000-INITIALISATION-PARA THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-PARA  THRU 2000-EXIT.                   
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
           STOP RUN.                                                    
      *                                                                 01780001
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01810001
      ******************************************************************01820001
      * THIS PROCESS OPENS THE FILES FCSCA406,PRT-FILE.                *01830001
      ******************************************************************01840001
       1000-INITIALISATION-PARA.                                        
           OPEN  INPUT FCSCA406                                         
                 OUTPUT FCSPT33-FILE.                                   
C36071     IF  WS-FCSCA406-STATUS = '00'                                
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           PERFORM 1100-SET-DATE-IN-HDRS THRU 1100-EXIT.                
      *                                                                 01940001
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01970001
      ******************************************************************01980001
      * THIS PROCESS SETS THE DATE FOR THE REPORT                       01990001
      ******************************************************************02000001
      *                                                                 02010001
       1100-SET-DATE-IN-HDRS.                                           
      *                                                                 02030001
           ACCEPT   WS-DATE FROM DATE.                                  
           IF  WS-DT-YY > 50                                            
               MOVE '19'               TO  WS-CUR-CC                    
           ELSE                                                         
               MOVE '20'               TO  WS-CUR-CC                    
           END-IF                                                       
           MOVE     WS-DT-MM           TO   WS-RPT-H2-MM.               
           MOVE     WS-DT-YY           TO   WS-CUR-YY.                  
           MOVE     WS-CUR-CCYY        TO   WS-RPT-H2-CCYY.             
           MOVE     WS-DT-DD           TO   WS-RPT-H2-DD.               
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02170001
      ******************************************************************02180001
      * PASSES CONTROL TO WRITE HEADINGS AND TO READ FCSCA406          *02190001
      ******************************************************************02200001
      *                                                                 02210001
       2000-PROCESS-PARA.                                               
           PERFORM 2100-WRITE-HEADER-PARA THRU 2100-EXIT.               
           PERFORM 2050-READ-PARA THRU 2050-EXIT UNTIL                  
                                      WS-END-OF-FILE = 'Y'.             
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02280001
      *************************************************************     02290001
      * THIS PARA READS THE FCSCA406 AND PASSES THE CONTROL TO FIND A   02300001
      *  NEW ACCOUNT-NUMBER UNLESS OLD ACCOUNT-N0 IS EQUAL TO 12 9'S.   02310001
      **************************************************************    02320001
      *                                                                 02330001
       2050-READ-PARA.                                                  
           READ FCSCA406                                                
                AT END                                                  
                    MOVE 'Y'                 TO WS-END-OF-FILE          
                    PERFORM 2900-REPORT THRU 2900-EXIT                  
                    GO TO 2050-EXIT.                                    
      *                                                                 02400001
           IF  WS-FCSCA406-STATUS = '00'                                
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
      *                                                                 02460001
           ADD  1                            TO WS-OLD-REC-READ.        
      *                                                                 02480001
              PERFORM 2500-REPORT-PARA THRU 2500-EXIT.                  
      *                                                                 02500001
       2050-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02530001
      ******************************************************************02540001
      * PRINTS PAGE HEADINGS AND COLUMN HEADINGS FOR EACH PAGE.        *02550001
      ******************************************************************02560001
       2100-WRITE-HEADER-PARA.                                          
            MOVE ZEROES                      TO   WS-LINE-CTR           
            ADD 1                            TO   WS-PAGE.              
            MOVE WS-PAGE                     TO   WS-DET-PAGE.          
            MOVE WS-HDR1                     TO   PRT33-DATA.           
            WRITE PRT33-RECORD AFTER ADVANCING PAGE.                    
            MOVE 1                           TO   WS-PRT-LINE-SPACE.    
            MOVE WS-HDR2                     TO   PRT33-DATA.           
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            MOVE 2                           TO   WS-PRT-LINE-SPACE.    
            MOVE WS-HDR3                     TO   PRT33-DATA.           
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            MOVE 1                           TO   WS-PRT-LINE-SPACE.    
            MOVE WS-HDR3-1                   TO   PRT33-DATA.           
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            MOVE 1                           TO   WS-PRT-LINE-SPACE.    
            MOVE SPACES                      TO   PRT33-DATA.           
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            ADD 6                            TO   WS-LINE-CTR.          
      *                                                                 02700001
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02730001
       2200-PRINT-PARA.                                                 
            WRITE PRT33-RECORD AFTER ADVANCING WS-PRT-LINE-SPACE.       
      *                                                                 02760001
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02790001
      ******************************************************************02800001
      * THIS PARA WRITES A REPORT FILE WHEN MATCHING NEW ACCOUNT NUMBER*02810001
      * IS NOT FOUND AND WHEN DUPLICATE RECORD EXISTS.          *       02820001
      ******************************************************************02830001
      *                                                                 02840001
       2500-REPORT-PARA.                                                
C36071*                                                                 02860006
C36071     MOVE FCA406-ACCOUNT-NO        TO WS-ACCT-NO                  
C36071     MOVE FCA406-TRANS-DATE        TO WS-CHANGED-DATE             
C36071     MOVE FCA406-CUR-REV-CLASS     TO WS-CURR-CLASS               
C36071     MOVE FCA406-CUR-RATE          TO WS-CURR-RATE                
C36071     MOVE FCA406-CUR-SRVC-ON-OFF   TO WS-CURR-SERVICE             
C36071     MOVE FCA406-CUR-CUST-NAME     TO WS-CURR-NAME                
C36071     MOVE SPACES                   TO WS-CHANGE-ITEM              
C36071     MOVE SPACES                   TO WS-PREVIOUS-VALUES          
C36071                                                                  
C36071     EVALUATE TRUE                                                
C36071       WHEN FCA406-RATE-CHANGE                                    
C36071            MOVE 'RATE'                 TO WS-CHANGE-ITEM         
C36071            MOVE FCA406-PRE-RATE        TO WS-PREVIOUS-VALUES     
C36071       WHEN FCA406-CLASS-CHANGE                                   
C36071            MOVE 'CLASS'                TO WS-CHANGE-ITEM         
C36071            MOVE FCA406-PRE-REV-CLASS   TO WS-PREVIOUS-VALUES     
C36071       WHEN FCA406-STATUS-CHANGE                                  
C36071            MOVE 'SERVICE'              TO WS-CHANGE-ITEM         
C36071            MOVE FCA406-PRE-SRVC-ON-OFF TO WS-PREVIOUS-VALUES     
C36071       WHEN FCA406-NAME-CHANGE                                    
C36071            MOVE 'NAME'                 TO WS-CHANGE-ITEM         
C36071            MOVE FCA406-PRE-CUST-NAME   TO WS-PREVIOUS-VALUES     
C36071       WHEN OTHER                                                 
C36071            CONTINUE                                              
C36071     END-EVALUATE.                                                
C36071*                                                                 02930006
            IF WS-LINE-CTR  > WS-MAX-LINES                              
               PERFORM 2100-WRITE-HEADER-PARA THRU 2100-EXIT            
            END-IF.                                                     
      *                                                                 02970001
            MOVE  WS-DET-PRT                 TO PRT33-DATA.             
            MOVE 2                           TO WS-PRT-LINE-SPACE.      
            ADD  2                           TO WS-LINE-CTR.            
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            ADD 1                            TO WS-NEW-REC-WRITE.       
      *                                                                 03070001
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03100001
       2900-REPORT.                                                     
            IF WS-LINE-CTR  > 51                                        
               PERFORM 2100-WRITE-HEADER-PARA  THRU 2100-EXIT           
            END-IF.                                                     
      *                                                                 03150001
            MOVE WS-OLD-REC-READ             TO  WS-READ.               
            MOVE WS-RPT1                     TO  PRT33-DATA.            
            MOVE 2                           TO  WS-PRT-LINE-SPACE.     
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            MOVE WS-NEW-REC-WRITE            TO  WS-WRITE.              
            MOVE WS-RPT2                     TO  PRT33-DATA.            
            MOVE 1                           TO  WS-PRT-LINE-SPACE.     
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
            MOVE WS-RPT4                     TO  PRT33-DATA.            
            MOVE 2                           TO  WS-PRT-LINE-SPACE.     
            PERFORM 2200-PRINT-PARA THRU 2200-EXIT.                     
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03370001
      ******************************************************************03380001
      * THIS PARA CLOSES ALL FILES                                     *03390001
      ******************************************************************03400001
       9000-TERMINATE.                                                  
            CLOSE FCSCA406                                              
                  FCSPT33-FILE.                                         
C36071      IF  WS-FCSCA406-STATUS = '00'                               
              NEXT SENTENCE                                             
            ELSE                                                        
              DISPLAY 'ERROR IN CLOSING FCSCA406'                       
              DISPLAY 'ERROR STATUS ' WS-FCSCA406-STATUS                
            END-IF.                                                     
      *                                                                 03500001
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03530001
