       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP393.                                        
       DATE-WRITTEN.   05/03/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **                                                             **         
      **     F U N C T I O N A L    D E S C R I P T I O N            **         
      **                     O F    M O D U L E                      **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  PRINTS TREASURER'S 'A' CHECK RECONCILIATION REPORT        **          
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  READS ALL RECORDS FROM CSS_REFUND FOR DATES AVAILABLE IN   **         
      **  JOB PARM. PRINTS THE RCORDS BREAKS ON COMPANY NUMBER &     **         
      **  PRINTS TOTALS FOR EACH COMPANY NO & EACH STATUS CODE.      **         
      *****************************************************************         
      **                                                             ** 00199303
      **              PROGRAM  MODIFICATION  LOG                     ** 00199403
      **                                                             ** 00199503
      **    DATE    INITIALS    REASON                               ** 00199603
      **  ________  ________    ___________________________________  ** 00199703
T20082**  06/08/99  CB18344     INCREASED WS-RPT1-PAGE-NO TO 5 BYTES.** 00199803
      **                                                             ** 00200003
T20333**  07/23/99  CB18344     CHANGED REPORT TO LIST OUTSTANDING   ** 00199803
      **                        CHECKS BASED ON CALENDAR MONTH.      ** 00199803
      **                        ALSO CHANGED REPORT TO INCLUDE ALL   ** 00199803
      **                        OUTSTANDING CHECKS (CHECK STATUS CODE** 00199803
      **                        'I', 'M', AND 'U').                  ** 00199803
      **                        THIS REPORT IS TO RUN THE LAST       ** 00199803
      **                        BUSINESS DAY OF THE MONTH.           ** 00199803
      **                        ALSO CHANGED ALL DATES ON REPORT TO  ** 00199803
      **                        HAVE 4-DIGIT YEARS INSTEAD OF 2,     ** 00199803
      **                        AND ADDED PAGE AND GRAND TOTALS TO   ** 00200003
      **                        THE REPORT.                          ** 00200003
C23521**  01/17/01  CB18344     MADE CHANGES TO USE SYSTEM DATE      ** 00199803
C23521**                        INSTEAD OF REPORTDATE.               ** 00199803
T35434**  05/16/07  MK92804     REPLACED MODEL_SQL WITH SET STATEMENT**         
T35434**                        AND ADDED WITH UR FOR -911 ABENDS.   **         
ACT144*  09/01/13  BD09555     REPLACE DATE CARD WITH DB2 COMMON DATE  *        
      *   A04524                                                       *        
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP393 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP93.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP93.                                                            
       COPY FIORP93.                                                            
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP393'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP393 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     02610000
               INCLUDE TBJBPARM                                         02620000
           END-EXEC.                                                    02630000
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
               'SOUTH CAROLINA ELEC.& GAS'.                             
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1.                                  
               10  FILLER              PIC X(09)    VALUE 'TREASURER'.  
               10  FILLER              PIC X(01)    VALUE QUOTE.        
               10  FILLER              PIC X(02)    VALUE 'S '.         
               10  FILLER              PIC X(01)    VALUE QUOTE.        
               10  FILLER              PIC X(01)    VALUE 'A'.          
               10  FILLER              PIC X(01)    VALUE QUOTE.        
               10  FILLER              PIC X(21)    VALUE               
                                                ' CHECK RECONCILIATION'.
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE2.                                  
               10  FILLER              PIC X(14)    VALUE               
T20333         'CURRENT AS OF '.                                        
T20333         10  WS-DEFAULT-RPT1-TITLE2-A PIC X(10).                  
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE '  '.         
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR-1      PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FRP93-REC-CNTR       PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FRP93-STATUS         PIC X(02).                       
               88  FRP93-SUCCESSFUL                 VALUE '00'.         
           05  WS-CHK-STAT-CODE        PIC  X(01) VALUE SPACES.         
           05  WS-CHK-STAT-DESC        PIC  X(20) VALUE SPACES.         
      *                                                                         
           05  WS-CHK-OUT-STD-CNTR     PIC 9(09)    VALUE ZERO COMP-3.  
T20333     05  WS-CHK-PGE-STD-CNTR     PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-CHK-I-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
T20333     05  WS-PGE-I-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-CHK-U-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
T20333     05  WS-PGE-U-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-CHK-M-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
T20333     05  WS-PGE-M-CNTR           PIC 9(09)    VALUE ZERO COMP-3.  
      *                                                                         
           05  WS-TOT-CPY-AMOUNT       PIC 9(11)V99  VALUE 0 COMP-3.    
T20333     05  WS-TOT-PGE-AMOUNT       PIC 9(11)V99  VALUE 0 COMP-3.    
           05  WS-TOT-ST-I-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
T20333     05  WS-PGE-ST-I-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
           05  WS-TOT-ST-U-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
T20333     05  WS-PGE-ST-U-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
           05  WS-TOT-ST-M-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
T20333     05  WS-PGE-ST-M-AMOUNT      PIC 9(11)V99  VALUE 0 COMP-3.    
      *                                                                         
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
      * COPYBOOK FOR JC01 DECLARATIONS.                                 01361000
      *                                                                 01361100
       COPY FIOJC01.                                                    01361200
T20333*                                                                 01362400
T20333     EXEC SQL                                                             
T20333       INCLUDE CWS00038                                                   
T20333     END-EXEC.                                                            
      *                                                                 01362500
T20333     EXEC SQL                                                             
T20333       INCLUDE CWS00114                                                   
T20333     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(05)    VALUE 60   COMP-3.  
T20082 01  WS-RPT1-PAGE-NO             PIC 9(05)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-ZIP-CODE.                                                 
           05  WS-ZIP-CODE-1           PIC X(05)    VALUE SPACES.       
           05  WS-ZIP-CODE-2           PIC X(04)    VALUE SPACES.       
      *                                                                         
T20333 01  WS-DATE-TIME-AREA.                                           
T20333     05  WS-CURRENT-TIMESTAMP          PIC X(26).                 
T20333     05  WS-CURRENT-TS-RED REDEFINES WS-CURRENT-TIMESTAMP.        
T20333         10  WS-CURRENT-DATE.                                     
T20333             15  WS-CURRENT-YEAR       PIC 9(04).                 
T20333             15  FILLER                PIC X(01).                 
T20333             15  WS-CURRENT-MONTH      PIC 9(02).                 
T20333             15  FILLER                PIC X(01).                 
T20333             15  WS-CURRENT-DAY        PIC 9(02).                 
T20333         10  FILLER                    PIC X(01).                 
T20333         10  WS-CURRENT-TIME.                                     
T20333             15  WS-CURRENT-HOUR       PIC 9(02).                 
T20333             15  FILLER                PIC X(01).                 
T20333             15  WS-CURRENT-MINUTE     PIC 9(02).                 
T20333             15  FILLER                PIC X(01).                 
T20333             15  WS-CURRENT-SECOND     PIC 9(02).                 
T20333             15  FILLER                PIC X(01).                 
T20333             15  WS-CURRENT-MSECOND    PIC 9(06).                 
T20333     05  WS-RUN-DATE.                                             
T20333         10  WS-RD-MONTH               PIC X(02).                 
T20333         10  FILLER                    PIC X(01) VALUE '/'.       
T20333         10  WS-RD-DAY                 PIC X(02).                 
T20333         10  FILLER                    PIC X(01) VALUE '/'.       
T20333         10  WS-RD-YEAR                PIC X(04).                 
T20333     05  WS-RUN-TIME.                                             
T20333         10  WS-RT-HOUR                PIC X(02).                 
T20333         10  FILLER                    PIC X(01) VALUE ':'.       
T20333         10  WS-RT-MINUTE              PIC X(02).                 
T20333         10  FILLER                    PIC X(01) VALUE ':'.       
T20333         10  WS-RT-SECOND              PIC X(02).                 
      *                                                                         
       01  WS-DATE-10.                                                  
T20333     05  WS-D10-CCYY.                                             
T20333         10  WS-D10-CY           PIC X(02).                       
T20333         10  WS-D10-YY           PIC X(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
T20333 01  WS-DATE-TO.                                                  
T20333     05  WS-TO-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
T20333     05  WS-TO-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
T20333     05  WS-TO-YY                PIC X(04).                       
      *                                                                         
C23521 01  WS-END-DATE.                                                 
C23521     05  WS-END-MM               PIC X(02).                       
C23521     05  FILLER                  PIC X(01)    VALUE '/'.          
C23521     05  WS-END-DD               PIC X(02).                       
C23521     05  FILLER                  PIC X(01)    VALUE '/'.          
ACT144     05  WS-END-YEAR             PIC X(04).                       
ACT144 01  WS-LAST-DAY-OF-PREVIOUS-MONTH PIC X(10).                     
ACT144 01  FILLER REDEFINES WS-LAST-DAY-OF-PREVIOUS-MONTH.              
ACT144     05  WS-LD-YEAR              PIC X(04).                       
ACT144     05  FILLER                  PIC X(01).                       
ACT144     05  WS-LD-MONTH             PIC X(02).                       
ACT144     05  FILLER                  PIC X(01).                       
ACT144     05  WS-LD-DAY               PIC X(02).                       
      *                                                                         
       01  WS-NAME.                                                     
           05  WS-FIRST-NAME           PIC X(15).                       
           05  WS-MID-NAME             PIC X(15).                       
           05  WS-LAST-NAME            PIC X(20).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP393'.   
           05  WS-49                   PIC 9(02)    VALUE 49.           
T20333     05  WS-46                   PIC 9(02)    VALUE 46.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
T20333     05  WS-FIRST-TIME           PIC X(01)    VALUE 'Y'.          
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      ***************** PCSRP393 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACES.       
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
T20333         10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
T20333         10  P-RPT1-RUN-DATE     PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACES.       
T20333         10  FILLER              PIC X(48)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(36).                       
T20333         10  FILLER              PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X        VALUE SPACES.       
T20333         10  FILLER              PIC X(54)    VALUE SPACES.       
T20333         10  P-RPT1-HEAD2        PIC X(24).                       
T20333         10  FILLER              PIC X(39)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-DETAIL-LINE.                              
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                                   'CHECKS OUTSTANDING'.
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(14)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'CHECK NUMBER'.      
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(17)    VALUE               
                                                   'CHECK STATUS CODE'. 
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'AMOUNT'.     
               10  FILLER              PIC X(01)    VALUE SPACE.        
      *                                                                         
      ****************************************************************          
      **          WORKING STORAGE FOR  DETAIL LINES                 **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINE.                                              
      *                                                                         
           05  WS-DETAIL-LINE-CHK.                                      
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER                  PIC X(18)    VALUE SPACES.   
               10  P-WRITE-CHK-OUTSTD      PIC ZZ9.                     
               10  FILLER                  PIC X(07)    VALUE SPACES.   
               10  P-WRITE-ACCOUNT-NO      PIC 9(13).                   
               10  FILLER                  PIC X(14)    VALUE SPACES.   
T20333         10  P-WRITE-DATE            PIC X(10).                   
T20333         10  FILLER                  PIC X(08)    VALUE SPACES.   
               10  P-WRITE-CHECK-CODE      PIC X(09).                   
               10  FILLER                  PIC X(10)    VALUE SPACES.   
T20333         10  P-WRITE-CHECK-STAT      PIC X(20).                   
T20333         10  FILLER                  PIC X(04)    VALUE SPACES.   
               10  P-WRITE-AMOUNT          PIC $$$$,$$$,$$9.99.         
               10  FILLER                  PIC X(01)    VALUE SPACE.    
      *                                                                         
      ****************************************************************          
      **            WORKING STORAGE FOR TOTAL LINES                 **          
      ****************************************************************          
      *                                                                         
       01  WS-TOTAL-LINE.                                               
      *                                                                         
T20333     05  WS-TOTAL-DESCR              PIC X(132)   VALUE SPACES.   
           05  WS-TOT-COMPANY.                                          
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER                  PIC X(31)    VALUE           
                              'NUMBER OF OUTSTANDING CHECKS IS'.        
               10  FILLER                  PIC X(29)    VALUE SPACES.   
               10  P-WRITE-OUTSTD-CHK-CNTR PIC ZZZ,ZZ9.                 
               10  FILLER                  PIC X(02)    VALUE SPACES.   
               10  FILLER                  PIC X(23)    VALUE           
                              'AND AMOUNT OF CHECKS IS'.                
               10  FILLER                  PIC X(21)    VALUE SPACES.   
               10  P-TOT-AMOUNT            PIC $$$,$$$,$$$,$$9.99.      
               10  FILLER                  PIC X(01)    VALUE SPACE.    
      *                                                                         
           05  WS-TOT-CPY-STATUS.                                       
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER                  PIC X(29)    VALUE           
                              'NUMBER OF CHECKS WITH STATUS '.          
               10  P-WRITE-CHK-ST          PIC X(01).                   
               10  FILLER                  PIC X(01)    VALUE SPACES.   
               10  P-WRITE-STAT-DESC       PIC X(20).                   
               10  FILLER                  PIC X(01)    VALUE SPACES.   
               10  FILLER                  PIC X(02)    VALUE 'IS'.     
               10  FILLER                  PIC X(06)    VALUE SPACES.   
               10  P-WRITE-CHK-ST-CNTR     PIC ZZZ,ZZ9.                 
               10  FILLER                  PIC X(02)    VALUE SPACES.   
               10  FILLER                  PIC X(23)    VALUE           
                              'AND AMOUNT OF CHECKS IS'.                
               10  FILLER                  PIC X(21)    VALUE SPACES.   
               10  P-TOT-ST-AMOUNT         PIC $$$,$$$,$$$,$$9.99.      
               10  FILLER                  PIC X(01)    VALUE SPACE.    
      *                                                                         
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP393 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSRP93             THRU 7100-EXIT.        
      *                                                                         
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FRP93-REC-CNTR EQUAL ZERO                          
                   MOVE '01' TO WS-CURRENT-COMP-NO                      
                   PERFORM 8100-PRINT-TITLE      THRU 8100-EXIT         
                   PERFORM 8200-PRINT-HEADER-1   THRU 8200-EXIT         
                   PERFORM 8400-PRINT-COLUMN-HDRS                       
                                                 THRU 8400-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
                   MOVE SPACES TO PRT33-RECORD                          
                   WRITE PRT33-RECORD AFTER ADVANCING 1 LINE            
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   PERFORM 8600-COMPANY-TOTAL    THRU 8600-EXIT         
                   MOVE SPACES TO PRT33-RECORD                          
                   WRITE PRT33-RECORD AFTER ADVANCING 1 LINE            
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF  WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                    
                   PERFORM 8100-PRINT-TITLE      THRU 8100-EXIT         
                   PERFORM 8200-PRINT-HEADER-1   THRU 8200-EXIT         
                   PERFORM 8400-PRINT-COLUMN-HDRS                       
                                                 THRU 8400-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
                   MOVE SPACES TO PRT33-RECORD                          
                   WRITE PRT33-RECORD AFTER ADVANCING 1 LINE            
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   PERFORM 8600-COMPANY-TOTAL    THRU 8600-EXIT         
                   MOVE SPACES TO PRT33-RECORD                          
                   WRITE PRT33-RECORD AFTER ADVANCING 1 LINE            
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP93 PROCESSING ERROR        **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP93 PROCESSING ERROR        **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
T20333     PERFORM 0200-GET-CURRENT-DATE-TIME.                          
      *                                                                         
           OPEN INPUT FCSRP93-FILE.                                     
           IF FRP93-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP393 PROCESSING ERROR       **'    
               DISPLAY '**  OPEN ERROR OF FCSRP93 - INPUT FILE   **'    
               DISPLAY '**    FILE STATUS = ' WS-FRP93-STATUS           
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
T20333*                                                                         
T20333******************************************************************        
T20333*                                                                *        
T20333*  0200-GET-CURRENT-DATE-TIME.                                   *        
T35434*  THIS MODULE RETRIEVE THE CURRENT TIMESTAMP                    *        
T20333*                                                                *        
T20333******************************************************************        
T20333*                                                                         
T20333 0200-GET-CURRENT-DATE-TIME.                                      
T20333                                                                  
T20333     EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
T20333     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20333                                                                  
T20333     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T20333     OR SQLCODE EQUAL NOT-FOUND                                   
T20333        MOVE WS-CURRENT-YEAR   TO WS-RD-YEAR                      
T20333        MOVE WS-CURRENT-MONTH  TO WS-RD-MONTH                     
T20333        MOVE WS-CURRENT-DAY    TO WS-RD-DAY                       
T20333        MOVE WS-CURRENT-HOUR   TO WS-RT-HOUR                      
T20333        MOVE WS-CURRENT-MINUTE TO WS-RT-MINUTE                    
T20333        MOVE WS-CURRENT-SECOND TO WS-RT-SECOND                    
T20333        MOVE WS-RUN-TIME       TO P-RPT1-RUN-TIME                 
T20333        MOVE WS-RUN-DATE       TO P-RPT1-RUN-DATE                 
T20333     ELSE                                                         
T20333         DISPLAY '0200-GET-CURRENT-DATE-TIME'                     
T20333                 ' RETURN CODE = ' SQLCODE                        
T20333         PERFORM 9900-ABEND THRU 9900-EXIT                        
T20333     END-IF.                                                      
T20333                                                                  
T20333 0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSRP93               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-READ-FCSRP93             THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP93-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FRP93-REC-CNTR                        
               SUBTRACT 1 FROM WS-COMP-REC-CNTR-1                       
ACT144         EXEC SQL SELECT
              (SELECT CAST(DATEADD(DAY, -DAY(E), E) AS DATE) 
              FROM (SELECT DATEADD(MONTH, 1, DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) E) T)
            INTO
              :WS-LAST-DAY-OF-PREVIOUS-MONTH                    
ACT144         END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL SET :WS-LAST-DAY-OF-PREVIOUS-MONTH =                    
MFA-TR*            LAST_DAY(CURRENT_DATE - 1 MONTHS)                            
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT144         MOVE WS-LD-MONTH TO WS-END-MM                            
ACT144         MOVE WS-LD-DAY   TO WS-END-DD                            
ACT144         MOVE WS-LD-YEAR  TO WS-END-YEAR                          
ACT144         MOVE WS-END-DATE TO WS-DEFAULT-RPT1-TITLE2-A             
           ELSE                                                         
               DISPLAY '**       PCSRP393 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP393 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           ELSE                                                         
               IF  E-FRP93-CO-KEY-EREC EQUAL HIGH-VALUES OR             
                   E-FRP93-KEY-EREC     EQUAL HIGH-VALUES               
                   PERFORM 1700-CHECK-END-REC    THRU 1700-EXIT         
               ELSE                                                     
                   IF REPORT-STARTED                                    
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       MOVE WS-Y       TO WS-START-REPORT               
                       MOVE E-FRP93-COMPANY-NO                          
                                       TO WS-CURRENT-COMP-NO            
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSRP93             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       IT CHECKS WHETHER PROCESS END REC OR COMPANY END REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           MOVE '1700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP93-CO-NO-KEY-EREC EQUAL HIGH-VALUES                  
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           MOVE '1800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP93-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FRP93-CO-REC-COUNT-EREC          
               IF E-FRP93-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   MOVE WS-Y           TO WS-END-OF-SYSIN-REC           
               END-IF                                                   
           ELSE                                                         
               IF E-FRP93-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   DISPLAY '**      PCSRP393 PROCESSING ERROR       **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP93-CO-NO-KEY-EREC   
                   DISPLAY '**  ACTUAL RECORD COUNT OF THE COMPANY  **' 
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD     **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                      E-FRP93-CO-REC-COUNT-EREC         
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING TERMINATED         **' 
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   DISPLAY '**      PCSRP393 PROCESSING ERROR       **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP93-CO-NO-KEY-EREC   
                   DISPLAY '**  ACTUAL RECORD COUNT OF THE COMPANY  **' 
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD     **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                      E-FRP93-CO-REC-COUNT-EREC         
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING CONTINUES          **' 
               END-IF                                                   
           END-IF.                                                      
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           MOVE '1900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP93-REC-CNTR.                           
           IF WS-FRP93-REC-CNTR EQUAL E-FRP93-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP393 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP93-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP93-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE E-FRP93-COMPANY-NO                                  
                                       TO WS-CURRENT-COMP-NO,           
                                          C7-COMPANY-NO                 
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
               IF SYSIN-DOES-NOT-EXIST                                  
                   PERFORM 8600-COMPANY-TOTAL        THRU 8600-EXIT     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF E-FRP93-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO           
               DISPLAY '**      PCSRP393 PROCESSING ERROR       **'     
               DISPLAY '**  COMPANY DATA RECORDS NOT SEPARATED  **'     
               DISPLAY '**    WITH PROPER COMPANY END-RECORD    **'     
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FRP93-COMPANY-NO  
               DISPLAY '** DATA IS :'  E-FRP93-DATA-REC                 
               DISPLAY '**       PROCESSING TERMINATED          **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                   IF E-FRP93-COMPANY-NO EQUAL WS-SYSIN-COMP-NO         
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT                     
                                                 THRU 2200-EXIT         
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '**   PCSRP393 PROCESSING ERROR   **'
                           DISPLAY '**   FILE NOT SORTED PROPERLY    **'
                           DISPLAY '**  IN ORDER OF COMPANY NUMBERS  **'
                           DISPLAY '**  DATA IS :'  E-FRP93-DATA-REC    
                           DISPLAY '**     PROCESSING TERMINATED     **'
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T20333     IF WS-RPT1-LINE-NO GREATER THAN WS-46                        
T20333        IF WS-FIRST-TIME = 'Y'                                    
                 PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT       
                 PERFORM 8200-PRINT-HEADER-1       THRU 8200-EXIT       
                 PERFORM 8400-PRINT-COLUMN-HDRS    THRU 8400-EXIT       
T20333           MOVE 'N' TO WS-FIRST-TIME                              
T20333        ELSE                                                      
T20333           MOVE '***PAGE TOTALS:' TO WS-TOTAL-DESCR               
T20333           PERFORM 8300-PRINT-PAGE-TOTALS    THRU 8300-EXIT       
T20333           PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT       
T20333           PERFORM 8200-PRINT-HEADER-1       THRU 8200-EXIT       
T20333           PERFORM 8400-PRINT-COLUMN-HDRS    THRU 8400-EXIT       
T20333        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-FORMAT-DETAIL-LINE       THRU 2300-EXIT.        
           PERFORM 8900-PRINT-DETAIL-LINE        THRU 8900-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP393       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-COMP-REC-CNTR-1     TO P-WRITE-CHK-OUTSTD.           
           MOVE E-FRP93-ACCOUNT-NO     TO P-WRITE-ACCOUNT-NO.           
      *                                                                         
           MOVE E-FRP93-TRANS-DATE     TO WS-DATE-10.                   
T20333     MOVE WS-D10-MM              TO WS-TO-MM                      
T20333     MOVE WS-D10-DD              TO WS-TO-DD                      
T20333     MOVE WS-D10-CCYY            TO WS-TO-YY                      
T20333     MOVE WS-DATE-TO             TO P-WRITE-DATE.                 
      *                                                                         
           MOVE E-FRP93-CHECK-NO       TO P-WRITE-CHECK-CODE.           
T20333     MOVE E-FRP93-CHECK-STATUS-NO TO WS-CHK-STAT-CODE.            
T20333     PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT.                  
T20333     MOVE WS-CHK-STAT-DESC       TO P-WRITE-CHECK-STAT.           
           MOVE E-FRP93-CHECK-AMT      TO P-WRITE-AMOUNT.               
      *                                                                         
           ADD  1                      TO WS-CHK-OUT-STD-CNTR           
T20333                                    WS-CHK-PGE-STD-CNTR.          
           ADD  E-FRP93-CHECK-AMT      TO WS-TOT-CPY-AMOUNT             
T20333                                    WS-TOT-PGE-AMOUNT.            
      *                                                                         
           EVALUATE E-FRP93-CHECK-STATUS-NO                             
               WHEN 'I'                                                 
                   ADD 1               TO WS-CHK-I-CNTR                 
T20333                                    WS-PGE-I-CNTR                 
                   ADD E-FRP93-CHECK-AMT                                
                                       TO WS-TOT-ST-I-AMOUNT            
T20333                                    WS-PGE-ST-I-AMOUNT            
               WHEN 'U'                                                 
                   ADD 1               TO WS-CHK-U-CNTR                 
T20333                                    WS-PGE-U-CNTR                 
                   ADD E-FRP93-CHECK-AMT                                
                                       TO WS-TOT-ST-U-AMOUNT            
T20333                                    WS-PGE-ST-U-AMOUNT            
               WHEN 'M'                                                 
                   ADD 1               TO WS-CHK-M-CNTR                 
T20333                                    WS-PGE-M-CNTR                 
                   ADD E-FRP93-CHECK-AMT                                
                                       TO WS-TOT-ST-M-AMOUNT            
T20333                                    WS-PGE-ST-M-AMOUNT            
           END-EVALUATE.                                                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   6000-MOVE-STAT-DESC                                      **          
      **       USING STAT CODE SELECTS STAT DESC.                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       6000-MOVE-STAT-DESC.                                             
      *                                                                         
           EVALUATE WS-CHK-STAT-CODE                                    
               WHEN 'I'                                                 
                   MOVE 'ISSUED' TO WS-CHK-STAT-DESC                    
               WHEN 'U'                                                 
                   MOVE 'UNDELIVERABLE' TO WS-CHK-STAT-DESC             
               WHEN 'M'                                                 
                   MOVE 'REMAILED' TO WS-CHK-STAT-DESC                  
           END-EVALUATE.                                                
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **      6200-GET-PARAMETER-DATE.                               **         
      **      6300-GET-OVERRIDE-DATE.                                **         
      **      6310-GET-DEFAULT-DATE.                                 **         
      **      6320-EDIT-PARM-DATE.                                   **         
      **      6330-GET-START-END-DATE.                               **         
      **      6340-UPDATE-JOB-PARM-TABLE.                            **         
      *****************************************************************         
      *                                                                         
C23521*    EXEC SQL                                                             
C23521*      INCLUDE CPD00114                                                   
C23521*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP93                                        **          
      **       READS THE INPUT FILE FCSRP93-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP93.                                               
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           READ FCSRP93-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP93-SUCCESSFUL                                          
               ADD 1                   TO WS-FRP93-REC-CNTR             
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP93 READ.  STATUS IS '        
                        WS-FRP93-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **      7600-START-FCSJC01.                                    **         
      **      7610-READ-FCSJC01.                                     **         
      **      7611-CLOSE.                                            **         
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                    15110000
                 INCLUDE CPD00038                                       15120000
            END-EXEC.                                                   15130000
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO  :C7-COMPANY-NAME                                 
                 FROM  CSS_COMPANY WITH(READUNCOMMITTED)                        
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
T35434                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NAME                                             
MFA-TR*          INTO  :C7-COMPANY-NAME                                         
MFA-TR*          FROM  CSS_COMPANY                                              
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '** RETURN CODE = ' SQLCODE                  
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8100-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE FOR THE REPORT                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-TITLE.                                                
      *                                                                         
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               MOVE WS-CURRENT-COMP-NO TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-HEADER-1                                      **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-HEADER-1.                                             
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE SPACES TO PRT33-RECORD.                                 
           WRITE PRT33-RECORD AFTER ADVANCING 1 LINE.                   
           MOVE 4                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T20333**   8300-PRINT-PAGE-TOTALS                                   **          
T20333**       PRINTS THE PAGE TOTAL LINE OF THE REPORT             **          
T20333**                                                            **          
T20333****************************************************************          
T20333*                                                                         
T20333 8300-PRINT-PAGE-TOTALS.                                          
T20333*                                                                         
T20333     MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
T20333*                                                                         
T20333     MOVE SPACES TO PRT33-RECORD.                                 
T20333     WRITE PRT33-RECORD AFTER ADVANCING 1 LINE.                   
T20333     MOVE SPACES TO PRT33-RECORD.                                 
T20333     WRITE PRT33-RECORD FROM WS-TOTAL-DESCR                       
T20333           AFTER ADVANCING 1 LINE.                                
T20333     MOVE WS-CHK-PGE-STD-CNTR    TO P-WRITE-OUTSTD-CHK-CNTR.      
T20333     MOVE WS-TOT-PGE-AMOUNT      TO P-TOT-AMOUNT.                 
T20333     WRITE PRT33-RECORD FROM WS-TOT-COMPANY                       
T20333           AFTER ADVANCING 2 LINES.                               
T20333*                                                                         
T20333     IF WS-TOT-ST-I-AMOUNT NOT = ZEROES                           
T20333         MOVE 'I'                TO P-WRITE-CHK-ST                
T20333         MOVE WS-PGE-I-CNTR      TO P-WRITE-CHK-ST-CNTR           
T20333         MOVE WS-PGE-ST-I-AMOUNT TO P-TOT-ST-AMOUNT               
T20333         PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
T20333         MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
T20333         WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
T20333             AFTER ADVANCING 1 LINE
           END-IF.                              
T20333     IF WS-TOT-ST-U-AMOUNT NOT = ZEROES                           
T20333         MOVE 'U'                TO P-WRITE-CHK-ST                
T20333         MOVE WS-PGE-U-CNTR      TO P-WRITE-CHK-ST-CNTR           
T20333         MOVE WS-PGE-ST-U-AMOUNT TO P-TOT-ST-AMOUNT               
T20333         MOVE 'U'                TO WS-CHK-STAT-CODE              
T20333         PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
T20333         MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
T20333         WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
T20333             AFTER ADVANCING 1 LINE
           END-IF.                              
T20333     IF WS-TOT-ST-M-AMOUNT NOT = ZEROES                           
T20333         MOVE 'M'                TO P-WRITE-CHK-ST                
T20333         MOVE WS-PGE-M-CNTR      TO P-WRITE-CHK-ST-CNTR           
T20333         MOVE WS-PGE-ST-M-AMOUNT TO P-TOT-ST-AMOUNT               
T20333         MOVE 'M'                TO WS-CHK-STAT-CODE              
T20333         PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
T20333         MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
T20333         WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
T20333             AFTER ADVANCING 1 LINE
           END-IF.                              
T20333*                                                                         
T20333*                                                                         
T20333     MOVE ZEROS TO WS-CHK-PGE-STD-CNTR                            
T20333                   WS-TOT-PGE-AMOUNT                              
T20333                   WS-PGE-I-CNTR                                  
T20333                   WS-PGE-ST-I-AMOUNT                             
T20333                   WS-PGE-U-CNTR                                  
T20333                   WS-PGE-ST-U-AMOUNT                             
T20333                   WS-PGE-M-CNTR                                  
T20333                   WS-PGE-ST-M-AMOUNT.                            
T20333*                                                                         
T20333     MOVE WS-60                  TO WS-RPT1-LINE-NO.              
T20333*                                                                         
T20333 8300-EXIT.                                                       
T20333     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-COLUMN-HDRS                                   **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-COLUMN-HDRS.                                          
      *                                                                         
           MOVE '8400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-DETAIL-LINE           
                 AFTER ADVANCING 3 LINES.                               
      *                                                                         
           MOVE SPACES TO PRT33-RECORD                                  
           WRITE PRT33-RECORD AFTER ADVANCING 1 LINE.                   
      *                                                                         
           ADD 4                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8600-COMPANY-TOTAL                                       **          
      **       PRINTS THE COMPANY TOTAL LINE OF THE REPORT          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8600-COMPANY-TOTAL.                                              
      *                                                                         
T20333     IF WS-RPT1-LINE-NO GREATER THAN 1                            
T20333         MOVE '***PAGE TOTALS:' TO WS-TOTAL-DESCR                 
T20333         PERFORM 8300-PRINT-PAGE-TOTALS    THRU 8300-EXIT         
               PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT         
               PERFORM 8200-PRINT-HEADER-1       THRU 8200-EXIT         
T20333     ELSE                                                         
T20333         PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT         
T20333         PERFORM 8200-PRINT-HEADER-1       THRU 8200-EXIT         
           END-IF.                                                      
           MOVE '8600' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE SPACES TO PRT33-RECORD.                                 
           WRITE PRT33-RECORD AFTER ADVANCING 1 LINE.                   
           MOVE SPACES TO PRT33-RECORD.                                 
T20333     MOVE '***COMPANY TOTALS:' TO WS-TOTAL-DESCR                  
T20333     WRITE PRT33-RECORD FROM WS-TOTAL-DESCR                       
T20333           AFTER ADVANCING 1 LINE.                                
           MOVE WS-CHK-OUT-STD-CNTR    TO P-WRITE-OUTSTD-CHK-CNTR.      
           MOVE WS-TOT-CPY-AMOUNT      TO P-TOT-AMOUNT.                 
           WRITE PRT33-RECORD FROM WS-TOT-COMPANY                       
T20333           AFTER ADVANCING 2 LINES.                               
      *                                                                         
           IF WS-TOT-ST-I-AMOUNT NOT = ZEROES                           
               MOVE 'I'                TO P-WRITE-CHK-ST                
               MOVE WS-CHK-I-CNTR      TO P-WRITE-CHK-ST-CNTR           
               MOVE WS-TOT-ST-I-AMOUNT TO P-TOT-ST-AMOUNT               
               MOVE 'I'                TO WS-CHK-STAT-CODE              
               PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
               MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
               WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
                   AFTER ADVANCING 1 LINE
           END-IF.                              
           IF WS-TOT-ST-U-AMOUNT NOT = ZEROES                           
               MOVE 'U'                TO P-WRITE-CHK-ST                
               MOVE WS-CHK-U-CNTR      TO P-WRITE-CHK-ST-CNTR           
               MOVE WS-TOT-ST-U-AMOUNT TO P-TOT-ST-AMOUNT               
               MOVE 'U'                TO WS-CHK-STAT-CODE              
               PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
               MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
               WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
                   AFTER ADVANCING 1 LINE
           END-IF.                              
           IF WS-TOT-ST-M-AMOUNT NOT = ZEROES                           
               MOVE 'M'                TO P-WRITE-CHK-ST                
               MOVE WS-CHK-M-CNTR      TO P-WRITE-CHK-ST-CNTR           
               MOVE WS-TOT-ST-M-AMOUNT TO P-TOT-ST-AMOUNT               
               MOVE 'M'                TO WS-CHK-STAT-CODE              
               PERFORM 6000-MOVE-STAT-DESC THRU 6000-EXIT               
               MOVE WS-CHK-STAT-DESC TO P-WRITE-STAT-DESC               
               WRITE PRT33-RECORD FROM WS-TOT-CPY-STATUS                
                   AFTER ADVANCING 1 LINE
           END-IF.                              
      *                                                                         
           MOVE  ZEROES                TO WS-CHK-OUT-STD-CNTR,          
                                          WS-TOT-CPY-AMOUNT,            
                                          WS-CHK-I-CNTR,                
                                          WS-TOT-ST-I-AMOUNT,           
                                          WS-CHK-U-CNTR,                
                                          WS-TOT-ST-U-AMOUNT,           
                                          WS-CHK-M-CNTR,                
                                          WS-TOT-ST-M-AMOUNT.           
      *                                                                         
           MOVE WS-60                  TO WS-RPT1-LINE-NO.              
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP393        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-CHK                   
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           CLOSE FCSRP93-FILE.                                          
           IF FRP93-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSRP393 PROCESSING ERROR  **'              
               DISPLAY '**  CLOSE ERROR FOR FCSRP93 - INPUT FILE'       
               DISPLAY '**  FILE STATUS = ' WS-FRP93-STATUS             
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
