       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      PCSRP372.                                       
       AUTHOR.          SCANA.                                          
       DATE-WRITTEN.    JUNE   2007.                                    
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060000
      ***************************************************************** 00070000
      **                                                             ** 00080000
      **              PROGRAM  MODIFICATION  LOG                     ** 00090000
      **                                                             ** 00100000
      **    DATE    INITIALS     REASON                              ** 00110000
      **    -----   --------     ------                              ** 00120000
      **    06/07   RB97445      INITIAL VERSION OF PROGRAM          ** 00130000
      ***************************************************************** 00140000
      **              PROGRAM NARRATIVE                              ** 00150000
      ***************************************************************** 00160000
      **  THIS PROGRAM READS THE OUTPUT FROM PCSC375 OF RECORDS THAT ** 00170000
      **  FAILED FINALIST AND/OR DPV.                                ** 00180000
      ***************************************************************** 00190000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT UNMATCHED-ADDR                                        
               ASSIGN TO UMCHADDR.                                      
                                                                        
           SELECT DPV-FAIL-RPT                                          
               ASSIGN TO DPVRPT.                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD UNMATCHED-ADDR.                                               
       01 UNMATCHED-ADDR-LINE              PIC X(400).                  
                                                                        
       FD DPV-FAIL-RPT.                                                 
       01 DPVFAIL-RPT-LINE                 PIC X(132).                  
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-UPDATE-FAILED-LINE.                                       
           05  FIN-ADDRESS-ID              PIC 9(13).                   
      *'F' FOR FORMATTED; 'U' FOR FREEFORM                              00430000
           05  FIN-ADDRESS-TYPE            PIC X.                       
      * ORIGINAL FIRST LINE OF ADDRESS                                  00450000
           05  FIN-STREET-ADDR             PIC X(37).                   
      *'P' FOR PREMISE; 'B' FOR BILLING, 'T' FOR THIRD PARTY;           00470000
      *'C' FOR CUSTOMER CONTACT                                         00480000
           05  FIN-ADDRESS-SOURCE          PIC X.                       
      * SECOND LINE OF ADDRESS                                          00500000
           05  FIN-ADDR-OVERFLOW           PIC X(35).                   
           05  FIN-CITY-STATE              PIC X(29).                   
           05  FIN-ZIP-CODE                PIC X(5).                    
      * ORIGINAL ZIP+4                                                  00540000
           05  FIN-PFOUR                   PIC X(4).                    
      * ORIGINAL DELIVERY POINT                                         00560000
           05  FIN-DP                      PIC X(2).                    
      * FINALIST RETURNED FIRST ADDRESS LINE                            00580000
           05  FIN-STREET-RET              PIC X(35).                   
      * FINALIST RETURNED SECOND ADDRESS LINE                           00600000
           05  FIN-OVERFLOW-RET            PIC X(20).                   
      * FINALIST RETURNED CITY AND STATE                                00620000
           05  FIN-CITY-STATE-RET.                                      
               10  FIN-CITY-RET            PIC X(28).                   
               10  FIN-STATE-RET           PIC X(2).                    
      * FINALIST RETURNED ZIP                                           00660000
           05  FIN-ZIP-RET                 PIC X(5).                    
      * FINALIST RETURNED ZIP+4                                         00680000
           05  FIN-PFOUR-RET               PIC X(4).                    
      * FINALIST RETURNED DELIVERY POINT                                00700000
           05  FIN-DP-RET                  PIC X(2).                    
           05  FIN-ACCOUNT-NO              PIC 9(13).                   
           05  FIN-PREMISE                 PIC 9(10).                   
           05  FIN-CUSTOMER-NO             PIC 9(10).                   
           05  FILLER                      PIC X(03).                   
           05  FIN-CUSTOMER-NAME           PIC X(50).                   
           05  FIN-COMPANY                 PIC XX.                      
      * FINALIST RETURN CODE                                            00780000
           05  FIN-FIN-RET-CD              PIC X(4).                    
      * DPV RETURN CODE                                                 00800000
           05  FIN-DPV-RET-CD              PIC X.                       
      * LACS RETURN CODE                                                00820000
           05  FIN-LACS-RET-CD             PIC XX.                      
      * ACCOUNT CREATE DATE                                             00840000
           05  FIN-ACCT-DATE               PIC X(10).                   
           05  FILLER                      PIC X(72).                   
                                                                        
       01  WS-SUBJECT.                                                  
           05  WS-SUB-SYS                  PIC X(04).                   
           05  FILLER                      PIC X(09)  VALUE             
                                                      ' 372 FOR '.      
           05  WS-SUB-DATE                 PIC X(10).                   
                                                                        
       01  WS-LINE                         PIC X(132) VALUE ALL '-'.    
       01  WS-BLANK-LINE                   PIC X(132) VALUE SPACES.     
       01  WS-HEADING-LINES.                                            
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                  PIC X(07)  VALUE ' DATE: '.  
               10  P-RPT-DATE              PIC X(08).                   
               10  FILLER                  PIC X(35)  VALUE SPACES.     
               10  FILLER                  PIC X(29)  VALUE             
                                     '        SCANA ENERGY         '.   
               10  FILLER                  PIC X(40)  VALUE SPACES.     
               10  FILLER                  PIC X(06)  VALUE 'PAGE: '.   
               10  P-RPT-PAGE-NO           PIC ZZ,ZZ9.                  
               10  FILLER                  PIC X      VALUE SPACE.      
                                                                        
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                  PIC X(09)  VALUE ' PCSRP372'.
               10  FILLER                  PIC X(33)  VALUE SPACES.     
               10  FILLER                  PIC X(44)  VALUE             
                        'ACTIVE ACCT ADDRESSES FAILING DPV VALIDATION'. 
               10  FILLER                  PIC X(46)  VALUE SPACES.     
                                                                        
           05  WS-RPT-HEADER-3.                                         
               10  FILLER                  PIC X(03)  VALUE SPACES.     
               10  FILLER                  PIC X(08)  VALUE 'ACCT NBR'. 
               10  FILLER                  PIC X(05)  VALUE SPACES.     
               10  FILLER                  PIC X(08)  VALUE 'CUST NBR'. 
               10  FILLER                  PIC X(06)  VALUE SPACES.     
               10  FILLER                  PIC X(13)  VALUE             
                                           'CUSTOMER NAME'.             
               10  FILLER                  PIC X(18)  VALUE SPACES.     
               10  FILLER                  PIC X(03)  VALUE 'TYP'.      
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  FILLER                  PIC X(04)  VALUE 'MODE'.     
               10  FILLER                  PIC X(08)  VALUE SPACES.     
               10  FILLER                  PIC X(19)  VALUE             
                                           'ADDRESS/CITY/ST/ZIP'.       
               10  FILLER                  PIC X(12)  VALUE SPACES.     
               10  FILLER                  PIC X(16)  VALUE             
                                           'LOCATOR/OVERFLOW'.          
               10  FILLER                  PIC X(08)  VALUE SPACE.      
                                                                        
           05  WS-RPT-HEADER-4.                                         
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  FILLER                  PIC X(13)  VALUE ALL '-'.    
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  FILLER                  PIC X(10)  VALUE             
                                                      '----------'.     
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  FILLER                  PIC X(35)  VALUE ALL '-'.    
               10  FILLER                  PIC X(02)  VALUE SPACE.      
               10  FILLER                  PIC X(01)  VALUE '-'.        
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  FILLER                  PIC X(04)  VALUE '----'.     
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  FILLER                  PIC X(32)  VALUE ALL '-'.    
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  FILLER                  PIC X(29)  VALUE ALL '-'.    
                                                                        
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER                  PIC X(01)  VALUE SPACES.     
               10  D-ACCT-NUM              PIC X(13).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-CUST-NBR              PIC X(10).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-CUST-NAME             PIC X(36).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-ADDR-TYPE             PIC X(01).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-ADDR-FORMAT           PIC X(04).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-ADDR                  PIC X(32).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-ADDR-OVRFLW           PIC X(29).                   
                                                                        
           05  WS-DETAIL-LINE-2.                                        
               10  FILLER                  PIC X(68)  VALUE SPACE.      
               10  D-ADDR-CITY             PIC X(29).                   
               10  FILLER                  PIC X(01)  VALUE SPACE.      
               10  D-ADDR-ZIP              PIC X(05).                   
               10  FILLER                  PIC X(22)  VALUE SPACE.      
               10  FILLER                  PIC X(07)  VALUE SPACE.      
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                       PIC 9(02).                   
           05  WS-CM                       PIC 9(02).                   
           05  WS-CD                       PIC 9(02).                   
                                                                        
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                    PIC X(02).                   
           05  FILLER                      PIC X(01)  VALUE '/'.        
           05  WS-RD-DD                    PIC X(02).                   
           05  FILLER                      PIC X(01)  VALUE '/'.        
           05  WS-RD-YY                    PIC X(02).                   
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                      PIC X(48)  VALUE SPACES.     
           05  FILLER                      PIC X(36)  VALUE             
                     '** THERE IS NO DATA FOR THIS RUN **'.             
           05  FILLER                      PIC X(48)  VALUE SPACES.     
                                                                        
       01  WS-RPT-LINE-NO                  PIC 9(02)  VALUE ZERO.       
       01  WS-RPT-PAGE-NO                  PIC 9(04)  VALUE ZERO.       
                                                                        
       01  WS-MISC.                                                     
           05  WS-END-OF-UNMATCHED         PIC X(1).                    
COB305     05 WS-ADDRESS-ID        PIC S9(7) COMP-3 VALUE 0.           
COB305     05 WS-FREEFORM-COUNTER        PIC S9(7) COMP-3 VALUE 0.           
COB305     05 WS-FORMATTED-COUNTER        PIC S9(7) COMP-3 VALUE 0.           
           05  WS-BYPASSED-COUNTER         PIC S9(7)  COMP-3 VALUE +0.  
           05  WS-RETURN-CODE              PIC S9(3)  VALUE +000.       
           05  WS-SQL-RETURN-CODE          PIC S9(3)  VALUE +000.       
           05  WS-FREEFORM-ZIP-UPDATE.                                  
               10 WS-FREE-ZIP-UPD          PIC X(5).                    
               10 WS-FREE-PFOUR-UPD        PIC X(4).                    
           05  WS-FREE-ZIP-UPDATE                                       
               REDEFINES WS-FREEFORM-ZIP-UPDATE PIC X(9).               
           05  WS-TABLE-ID                 PIC X(20)  VALUE SPACES.     
           05  WS-AUTO-FILE-TYPE           PIC X(1)   VALUE ZEROS.      
               88  AUTO-FREEFORM                      VALUE '1'.        
               88  AUTO-FORMATTED                     VALUE '2'.        
           05  WS-FAIL-FILE-TYPE           PIC X(1)   VALUE ZEROS.      
               88  FAIL-FREEFORM                      VALUE '1'.        
               88  FAIL-FORMATTED                     VALUE '2'.        
           05  WS-FORM-CITY-TEMP.                                       
               10  WS-TEMP-CITY            PIC X(17).                   
               10  FILLER                  PIC X      VALUE ','.        
               10  WS-TEMP-STATE           PIC X(2).                    
           05  WS-FORM-STREET-TEMP.                                     
               10  WS-TEMP-STREET-NUM      PIC X(5).                    
               10  FILLER                  PIC X      VALUE SPACES.     
               10  WS-TEMP-STREET-ADDR     PIC X(26).                   
           05  WS-UPDATED-FLAG             PIC X      VALUE 'T'.        
               88  NOT-UPDATED-RECORD                 VALUE 'F'.        
               88  UPDATED-RECORD                     VALUE 'T'.        
           05  WS-58                       PIC 9(02)  VALUE 58.         
           05  WS-ACCT-NUM                 PIC 9(13).                   
                                                                        
      **************************************************************    02320000
      * COPYBOOKS FOR THE PURPOSE OF DISPLAYING ERROR MESSAGES     *    02330000
      **************************************************************    02340000
           COPY CWS00303.                                               02350000
           COPY CWS0070B.                                               02360000
           COPY CWS09900.                                               02370000
      /                                                                 02380000
           EXEC SQL                                                     02390000
               INCLUDE SQLCA                                            02400000
           END-EXEC.                                                    02410000
      /                                                                 02420000
           EXEC SQL                                                     02430000
               INCLUDE TBADRFMT                                         02440000
           END-EXEC.                                                    02450000
      /                                                                 02460000
           EXEC SQL                                                     02470000
               INCLUDE TBADRFRE                                         02480000
           END-EXEC.                                                    02490000
      /                                                                 02500000
           EXEC SQL                                                     02510000
               INCLUDE TBZIPCD                                          02520000
           END-EXEC.                                                    02530000
      /                                                                 02540000
           EXEC SQL                                                     02550000
                INCLUDE TBBLADRX                                        02560000
           END-EXEC.                                                    02570000
      /                                                                 02580000
           EXEC SQL                                                     02590000
                INCLUDE TBDELQ                                          02600000
           END-EXEC.                                                    02610000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ************************************************************      02660000
      * MAIN-LINE:                                               *      02670000
      *   1) OPEN INPUT/OUPUT FILES                              *      02680000
      *   2) INITIALIZE ALL VARIABLES                            *      02690000
      *   3) READ INPUT FILE AND WRITE OUT REPORT                *      02700000
      *   4) CLOSE FILES AND END PROGRAM                         *      02710000
      ************************************************************      02720000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1100-OPEN-INPUT-FILES                                
                                        THRU 1100-EXIT.                 
                                                                        
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
                                                                        
           PERFORM 2000-PROCESS-DPVFAIL THRU 2000-EXIT                  
                   UNTIL WS-END-OF-UNMATCHED = 'Y'.                     
                                                                        
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
                                                                        
           STOP RUN.                                                    
                                                                        
       0100-INITIALIZE.                                                 
      ************************************************************      02880000
      * INITIALIZE:                                              *      02890000
      *   1) GET CURRENT DATE                                    *      02900000
      *   2) SET VARIABLES TO INITIAL VALUES                     *      02910000
      *   3) PRINT HEADINGS FOR TOP OF PAGE                      *      02920000
      ************************************************************      02930000
                                                                        
           ACCEPT WS-CURRENT-DATE       FROM DATE.                      
                                                                        
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO P-RPT-DATE.                
           MOVE WS-58                     TO WS-RPT-LINE-NO.            
           MOVE 'N'                       TO WS-END-OF-UNMATCHED.       
           MOVE ZEROS                     TO WS-FREEFORM-COUNTER        
                                             WS-FORMATTED-COUNTER.      
           MOVE WS-RUN-DATE               TO WS-SUB-DATE.               
                                                                        
           PERFORM 8000-READ-FREEFORM   THRU 8000-EXIT.                 
           PERFORM 3700-PRINT-TITLE     THRU 3700-EXIT.                 
           PERFORM 3800-PRINT-HEADERS   THRU 3800-EXIT.                 
                                                                        
           IF WS-END-OF-UNMATCHED = 'Y'                                 
               WRITE DPVFAIL-RPT-LINE   FROM WS-NO-DATA-LINE            
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-OPEN-INPUT-FILES.                                           
      ************************************************************      03140000
      * OPEN FILES:                                              *      03150000
      *   1) OPEN INPUT AND OUTPUT FILES                         *      03160000
      ************************************************************      03170000
                                                                        
           OPEN INPUT  UNMATCHED-ADDR.                                  
           OPEN OUTPUT DPV-FAIL-RPT.                                    
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-DPVFAIL.                                            
      ************************************************************      03260000
      * OPEN FILES:                                              *      03270000
      *   1) READS DATA FROM INPUT FILE                          *      03280000
      *   2) IF NOT AT END-OF-FILE AND THIS IS A FAILED          *      03290000
      *      DPV, PERFORM PARAGRAGH TO WRITE OUT DATA            *      03300000
      ************************************************************      03310000
                                                                        
           IF WS-END-OF-UNMATCHED = 'N'                                 
               PERFORM 3000-CREATE-RPT  THRU 3000-EXIT                  
           END-IF.                                                      
                                                                        
           PERFORM 8000-READ-FREEFORM   THRU 8000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-CREATE-RPT.                                                 
      ************************************************************      03430000
      * CREATE REPORT:                                           *      03440000
      *   1) IF LINE COUNT > 58 PERFORM TOP OF PAGE AND          *      03450000
      *      WRITE OUT HEADINGS AGAIN                            *      03460000
      *   2) MOVE CERTAIN INPUT FIELDS TO REPORT FIELDS          *      03470000
      *      AND WRITE OUT FIRST AND SECOND DETAIL LINES         *      03480000
      ************************************************************      03490000
                                                                        
           IF WS-RPT-LINE-NO NOT < WS-58                                
               PERFORM 3700-PRINT-TITLE THRU 3700-EXIT                  
               PERFORM 3800-PRINT-HEADERS                               
                                        THRU 3800-EXIT                  
           END-IF.                                                      
                                                                        
           MOVE FIN-ACCOUNT-NO            TO D-ACCT-NUM.                
           MOVE FIN-CUSTOMER-NO           TO D-CUST-NBR.                
           MOVE FIN-CUSTOMER-NAME         TO D-CUST-NAME.               
           MOVE FIN-ADDRESS-SOURCE        TO D-ADDR-TYPE.               
                                                                        
           IF FIN-ADDRESS-TYPE = 'F'                                    
               MOVE 'FORM'                TO D-ADDR-FORMAT              
           ELSE                                                         
               MOVE 'FREE'                TO D-ADDR-FORMAT              
           END-IF.                                                      
                                                                        
           MOVE FIN-STREET-ADDR           TO D-ADDR.                    
           MOVE FIN-ADDR-OVERFLOW         TO D-ADDR-OVRFLW.             
                                                                        
           PERFORM 3900-DETAIL-LINE1    THRU 3900-EXIT.                 
                                                                        
           MOVE FIN-CITY-STATE            TO D-ADDR-CITY.               
           MOVE FIN-ZIP-CODE              TO D-ADDR-ZIP.                
                                                                        
           PERFORM 3950-DETAIL-LINE2    THRU 3950-EXIT.                 
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3700-PRINT-TITLE.                                                
      ************************************************************      03820000
      * PRINT TITLE:                                             *      03830000
      *   1) RESET LINE NUMBER TO 0 ADD 1 TO PAGE COUNTER        *      03840000
      *   2) WRITE OUT HEADER LINES 1 AND 2                      *      03850000
      ************************************************************      03860000
                                                                        
           MOVE ZEROES                    TO WS-RPT-LINE-NO.            
                                                                        
           ADD 1                          TO WS-RPT-PAGE-NO.            
                                                                        
           MOVE WS-RPT-PAGE-NO            TO P-RPT-PAGE-NO.             
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-RPT-HEADER-1            
                                       AFTER PAGE.                      
           WRITE DPVFAIL-RPT-LINE       FROM WS-RPT-HEADER-2.           
                                                                        
           ADD 2                          TO WS-RPT-LINE-NO.            
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-BLANK-LINE.             
           WRITE DPVFAIL-RPT-LINE       FROM WS-BLANK-LINE.             
                                                                        
           ADD 2                          TO WS-RPT-LINE-NO.            
                                                                        
       3700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3800-PRINT-HEADERS.                                              
      ************************************************************      04090000
      * PRINT HEADERS:                                           *      04100000
      *   1) WRITE HEADER LINES 3 AND 4                          *      04110000
      *   2) WRITE OUT DETAIL LINE                               *      04120000
      ************************************************************      04130000
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-RPT-HEADER-3.           
           WRITE DPVFAIL-RPT-LINE       FROM WS-RPT-HEADER-4.           
                                                                        
           ADD 2                          TO WS-RPT-LINE-NO.            
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-BLANK-LINE.             
                                                                        
           ADD 1                          TO WS-RPT-LINE-NO.            
                                                                        
       3800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3900-DETAIL-LINE1.                                               
      ************************************************************      04280000
      * DETAIL LINE1:                                            *      04290000
      *   1) IF LINE COUNT IS GREATER THEN 58                    *      04300000
      *      WRITE OUT TOP OF PAGE HEADINGS                      *      04310000
      *   2) WRITE OUT DETAIL LINE                               *      04320000
      ************************************************************      04330000
                                                                        
           IF WS-RPT-LINE-NO NOT < WS-58                                
               PERFORM 3700-PRINT-TITLE THRU 3700-EXIT                  
               PERFORM 3800-PRINT-HEADERS                               
                                        THRU 3800-EXIT                  
           END-IF.                                                      
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-DETAIL-LINE-1.          
                                                                        
           ADD 1                          TO WS-RPT-LINE-NO.            
                                                                        
       3900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3950-DETAIL-LINE2.                                               
      ************************************************************      04490000
      * DETAIL LINE2:                                            *      04500000
      *   1) WRITE OUT DETAIL LINE 2                             *      04510000
      *   2) WRITE OUT BLANK LINE                                *      04520000
      ************************************************************      04530000
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-DETAIL-LINE-2.          
                                                                        
           ADD 1                          TO WS-RPT-LINE-NO.            
                                                                        
           WRITE DPVFAIL-RPT-LINE       FROM WS-BLANK-LINE.             
                                                                        
           ADD 1                          TO WS-RPT-LINE-NO.            
                                                                        
       3950-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-READ-FREEFORM.                                              
      ************************************************************      04670000
      * READ FREEFORM:                                           *      04680000
      *   1) READ INPUT FILE                                     *      04690000
      *   2) AT END OF FILE SET INDICATOR TO 'Y'                 *      04700000
      ************************************************************      04710000
                                                                        
           READ UNMATCHED-ADDR INTO WS-UPDATE-FAILED-LINE               
             AT END                                                     
               MOVE 'Y'                   TO WS-END-OF-UNMATCHED.       
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
      ************************************************************      04810000
      * TERMINATE:                                               *      04820000
      *   1) CLOSE INPUT AND OUTPUT FILES                        *      04830000
      ************************************************************      04840000
                                                                        
           CLOSE UNMATCHED-ADDR                                         
                 DPV-FAIL-RPT.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
