       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSRP371.                                         
       DATE-WRITTEN.   01/15/96.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *                                                               *         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  01/15/96     MD        NEW PROGRAM FOR REPORT GENERATION   **         
      **  06/24/97     RAO       TPR 11772 CHANGES INCORPORATED.     **         
T19583**  07/02/99     CJB       TPR19583:                           **         
T19583**                         ADDED SECOND PAGE TO EXISTING RPT   **         
T19583**                         TO SHOW MONTHLY STATISTICAL SUMMARY.**         
T19583**                         ALSO CHANGED SELECT STATEMENT TO    **         
T19583**                         PULL ALL SHARE STATUS CODES SINCE   **         
T19583**                         SECOND REPORT COUNTS ALL CODES, NOT **         
T19583**                         JUST SHARE STATUS CODES 'A' AND 'O' **         
T19583**                         WHICH THE FIRST REPORT DOES.      ' **         
T23684**  07/05/01     JS83520   INCLUDED CHECK FOR SUBSYSTEM TO     **         
T23684**                         MOVE PROJECT SHARES FOR CSR AND     **         
T23684**                         H.E.A.T. FOR SEB                    **         
T27859**  04/08/03     COVANSYS  CHANGED PROGRAM TO MATCH THE        **         
T27859**                         JOURNAL LEDGER AMOUNT               **         
      **                                                             **         
T29532**  01/09/03     COVANSYS  CHANGED PROGRAM ADD THE 2ND REPORT  **         
T29532**                         TO THE JOURNAL LEDGER REPORT        **         
T32671**  07/27/05     VIDHU     2ND REPORT SHOULD JUST SHOW DETAILS **         
T32671**                         OF ACTIVE ACCOUNTS. CHANGES ALSO    **         
T32671**                         MADE TO SHOW PROJECT SHARES IN      **         
T32671**                         PENDING STATUS.                     **         
T33928**  08/10/06     MADHAVI   PERFORMANCE TURNING - ADDED         **         
      **                         FOR FETCH ONLY WITH UR TO CSS_ACCONT**         
      **                                                             **         
C36940**  02/26/08     RC41079   MODIFY TO DISPLAY POSITVE AND       **         
      **                         NEGATIVE AMOUNTS.                   **         
      **                                                             **         
A03967**  25 SEP 12    RF10596   FIX HEADERS                         **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                 ---- REPORT GENERATOR FOR PCSRP371 REPORTS ----        
                 ---- PROJECT SHARE/H.E.A.T. DISTRIBUTION REPORT ----   
                 ---- BASIC SEQUENCE STRUCTURE ----                     
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES                
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
           COPY CSSPT33.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
           COPY CFDPT33.                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP371'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-START                    PIC X(40)    VALUE           
               'WORKING STORAGE FOR PCSRP371 STARTS HERE'.              
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE       PIC X(50)    VALUE           
               'SOUTH CAROLINA ELEC. & GAS                        '.    
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD1       PIC X(50)    VALUE           
               '        PROJECT SHARE DISTRIBUTION REPORT         '.    
      *                                                                         
T23684     05  WS-DEFAULT-RPT1-HEAD1-SEB   PIC X(50)    VALUE           
T23684         '        H.E.A.T. DISTRIBUTION REPORT              '.    
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD2.                                   
A03967         10  FILLER                  PIC X(33)    VALUE           
A03967             '               FOR REVENUE MONTH '.                 
A03967         10  WS-DEFAULT-RPT1-DT      PIC X(06).                   
A03967         10  FILLER                  PIC X(11)    VALUE SPACES.   
      *                                                                         
T19583     05  WS-DEFAULT-RPT2-HEAD1       PIC X(50)    VALUE           
T19583         '        PROJECT SHARE MONTHLY STATISTICAL SUMMARY '.    
T23684*                                                                         
T23684     05  WS-DEFAULT-RPT2-HEAD1-SEB   PIC X(50)    VALUE           
T23684         '    H.E.A.T. MONTHLY STATISTICAL SUMMARY          '.    
T19583*                                                                         
T19583     05  WS-DEFAULT-RPT2-HEAD2       PIC X(50)    VALUE           
T19583         '            MONTHLY STATISTICAL SUMMARY'.               
      *                                                                         
T19583     05  WS-DEFAULT-RPT2-HEAD3.                                   
A03967         10  FILLER                  PIC X(33)    VALUE           
A03967             '               FOR REVENUE MONTH '.                 
A03967         10  WS-DEFAULT-RPT2-DT      PIC X(06).                   
A03967         10  FILLER                  PIC X(11)    VALUE SPACES.   
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05 WS-FCA32-STATUS         PIC X(02)       VALUE '00'.       
               88  FCSCA32-SUCCESSFUL       VALUE '00'.                 
T23684 01  WS-DATABASES                    PIC 9(01)  VALUE ZERO.       
T23684     88  CSR-DATABASE                      VALUE 1.               
T23684     88  SEB-DATABASE                      VALUE 2.               
T29532 01  WS-MTH-SHARE-CUR                PIC 9(01)                    
T29532                                           VALUE ZERO.            
T29532     88  MTH-SHARE-CUR                     VALUE 1.               
      *                                                                         
      *****************************************************************         
      **            GENERIC 132 CHARACTER OUTPUT RECORD              **         
      *****************************************************************         
      *                                                                         
       01  P-OUTPUT-LINE                   PIC X(132).                  
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **      WORKING STORAGE FOR PCSRP371 REPORT HEADERS            **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       01  WS-REPORT-TITLE.                                             
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR REPORT TITLE           **         
      *****************************************************************         
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-PGNM             PIC X(08).                   
T19583         10  P-RPT1-PGNM-SEQ         PIC X(03)    VALUE '-01'.    
               10  FILLER                  PIC X(42)    VALUE SPACES.   
               10  P-RPT1-TITLE            PIC X(50).                   
               10  FILLER                  PIC X(11)    VALUE SPACES.   
               10  FILLER                  PIC X(10)    VALUE           
                   'RUN DATE: '.                                        
               10  P-RPT1-RUN-DATE         PIC X(08).                   
      *                                                                         
T19583     05  WS-RPT2-TITLE.                                           
T19583         10  P-RPT2-PGNM             PIC X(08).                   
T19583         10  P-RPT2-PGNM-SEQ         PIC X(03)    VALUE '-02'.    
A03967         10  FILLER                  PIC X(37)    VALUE SPACES.   
T19583         10  P-RPT2-TITLE            PIC X(50).                   
A03967         10  FILLER                  PIC X(16)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(10)    VALUE           
T19583             'RUN DATE: '.                                        
T19583         10  P-RPT2-RUN-DATE         PIC X(08).                   
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR REPORT HEADER1         **         
      *****************************************************************         
      *                                                                         
           05  WS-REPORT-HEADER-1.                                      
               10  FILLER                  PIC X(06)    VALUE           
                   'DATE: '.                                            
               10  P-RPT1-DATE             PIC X(08).                   
               10  FILLER                  PIC X(27)    VALUE SPACES.   
               10  P-RPT1-HEAD1            PIC X(50).                   
               10  FILLER                  PIC X(23)    VALUE SPACES.   
               10  FILLER                  PIC X(10)    VALUE           
                   'RUN TIME: '.                                        
               10  P-RPT1-RUN-TIME         PIC X(08).                   
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR REPORT HEADER2         **         
      *****************************************************************         
      *                                                                         
           05  WS-REPORT-HEADER-2.                                      
               10  FILLER                  PIC X(41)    VALUE SPACES.   
               10  P-RPT1-HEAD2            PIC X(50).                   
               10  FILLER                  PIC X(27)    VALUE SPACES.   
               10  FILLER                  PIC X(08)    VALUE           
                   'PAGE:   '.                                          
               10  P-RPT1-PAGE-NO          PIC ZZ,ZZ9.                  
      *                                                                         
      *****************************************************************         
T19583**           COMMON WORKING STORAGE FOR REPORT HEADER1         **         
T19583**           FOR THE PROJECT SHARE/H.E.A.T. MONTHLY            **         
T19583**           STATISTICAL SUMMARY REPORT.                       **         
T19583*****************************************************************         
T19583*                                                                         
T19583     05  WS-REPORT-HEADER-21.                                     
T19583         10  FILLER                  PIC X(06)    VALUE           
T19583             'DATE: '.                                            
T19583         10  P-RPT2-DATE             PIC X(08).                   
T19583         10  FILLER                  PIC X(27)    VALUE SPACES.   
T19583         10  P-RPT2-HEAD1            PIC X(50).                   
T19583         10  FILLER                  PIC X(23)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(10)    VALUE           
T19583             'RUN TIME: '.                                        
T19583         10  P-RPT2-RUN-TIME         PIC X(08).                   
T19583*                                                                         
T19583*****************************************************************         
T19583**           COMMON WORKING STORAGE FOR REPORT HEADER22        **         
T19583**           FOR THE PROJECT SHARE/H.E.A.T. MONTHLY            **         
T19583**           STATISTICAL SUMMARY REPORT.                       **         
T19583*****************************************************************         
T19583*                                                                         
T19583     05  WS-REPORT-HEADER-22.                                     
T19583         10  FILLER                  PIC X(41)    VALUE SPACES.   
T19583         10  P-RPT2-HEAD2            PIC X(50).                   
T19583         10  FILLER                  PIC X(27)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(08)    VALUE           
T19583             'PAGE:   '.                                          
T19583         10  P-RPT2-PAGE-NO          PIC ZZ,ZZ9.                  
T19583*                                                                         
      * *                                                                       
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR COLUMN HEADER          **         
      *****************************************************************         
      *                                                                         
           05  WS-COLUMN-HEADER.                                        
               10  FILLER                  PIC X(15)    VALUE SPACES.   
               10  FILLER                  PIC X(13)    VALUE           
                   'LOCAL OFFICE '.                                     
T27859         10  FILLER                  PIC X(28)    VALUE SPACES.   
T27859*        10  FILLER                  PIC X(16)    VALUE                   
T27859*            'REVENUE DISTRICT'.                                          
T27859*        10  FILLER                  PIC X(35)    VALUE SPACES.           
               10  FILLER                  PIC X(06)    VALUE           
                   'AMOUNT'.                                            
               10  FILLER                  PIC X(27)    VALUE SPACES.   
               10  FILLER                  PIC X(06)    VALUE           
                   'TOTALS'.                                            
T27859         10  FILLER                  PIC X(51)    VALUE SPACES.   
      *                                                                         
T19583     05  WS-COLUMN-HEADER-2A.                                     
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(07)    VALUE           
T19583             'MONTHLY'.                                           
T19583         10  FILLER                  PIC X(110)   VALUE SPACES.   
T19583*                                                                         
T19583     05  WS-COLUMN-HEADER-2B.                                     
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(13)    VALUE           
T19583             'CONTRIBUTORS:'.                                     
T19583         10  FILLER                  PIC X(10)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(07)    VALUE           
T32671             'PENDING'.                                           
T19583         10  FILLER                  PIC X(13)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(10)    VALUE           
T19583             'TERMINATED'.                                        
T19583         10  FILLER                  PIC X(13)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(08)    VALUE           
T19583             'ONE-TIME'.                                          
T19583         10  FILLER                  PIC X(16)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(06)    VALUE           
T19583             'ACTIVE'.                                            
T19583         10  FILLER                  PIC X(21)    VALUE SPACES.   
T19583*                                                                         
T19583     05  WS-COLUMN-HEADER-2C.                                     
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(12)    VALUE           
T19583             'CREDIT GROUP'.                                      
T19583         10  FILLER                  PIC X(105)   VALUE SPACES.   
T19583*                                                                         
      *****************************************************************         
      **                                                             **         
      **           WORKING STORAGE FOR PCSRP371 DETAIL LINES         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       01  P-DETAIL-LINES.                                              
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR DETAIL LINE1           **         
      *****************************************************************         
      *                                                                         
           05  P-DETAIL-LINE1.                                          
               10  FILLER                  PIC X(15)    VALUE SPACES.   
               10  P-LOCAL-OFFICE          PIC X(22).                   
               10  FILLER                  PIC X(05)    VALUE SPACES.   
T27859*        10  P-REVENUE-DIST          PIC X(35).                           
T27859*        10  FILLER                  PIC X(02)    VALUE SPACES.           
C36940         10  P-PROJ-SHARE-AMT        PIC -,---,---,---,--9.99.    
T27859         10  FILLER                  PIC X(70)    VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR DETAIL LINE2           **         
      *****************************************************************         
      *                                                                         
           05  P-DETAIL-LINE2.                                          
               10  FILLER                  PIC X(76)    VALUE SPACES.   
               10  FILLER                  PIC X(15)    VALUE           
                   'COMPANY TOTALS:'.                                   
               10  FILLER                  PIC X(21)    VALUE SPACES.   
               10  P-PROJ-SHARE-TOTAL      PIC Z,ZZZ,ZZZ,ZZZ,ZZ9.99.    
      *                                                                         
      *****************************************************************         
T19583**           COMMON WORKING STORAGE FOR DETAIL LINE1 OF RPT 02 **         
T19583*****************************************************************         
T19583*                                                                         
T19583     05  P-DETAIL-LINE12.                                         
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  P-LINE-NAME             PIC X(11).                   
T19583         10  FILLER                  PIC X(07)    VALUE SPACES.   
T19583         10  P-NEW                   PIC ZZZ,ZZ9.                 
T19583         10  FILLER                  PIC X(18)    VALUE SPACES.   
T19583         10  P-TERMINATED            PIC ZZZ,ZZ9.                 
T19583         10  FILLER                  PIC X(13)    VALUE SPACES.   
T19583         10  P-ONE-TIME              PIC ZZZ,ZZ9.                 
T19583         10  FILLER                  PIC X(17)    VALUE SPACES.   
T19583         10  P-ACTIVE                PIC ZZZ,ZZ9.                 
T19583         10  FILLER                  PIC X(23)    VALUE SPACES.   
T19583*                                                                         
T19583*****************************************************************         
T19583**           COMMON WORKING STORAGE FOR TOTAL LINE 1 OF RPT 02 **         
T19583*****************************************************************         
T19583*                                                                         
T19583     05  P-TOTAL-LINE12.                                          
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(07)    VALUE           
T19583             'TOTALS:'.                                           
T19583         10  FILLER                  PIC X(09)    VALUE SPACES.   
T19583         10  T-NEW                   PIC Z,ZZZ,ZZ9.               
T19583         10  FILLER                  PIC X(16)    VALUE SPACES.   
T19583         10  T-TERMINATED            PIC Z,ZZZ,ZZ9.               
T19583         10  FILLER                  PIC X(11)    VALUE SPACES.   
T19583         10  T-ONE-TIME              PIC Z,ZZZ,ZZ9.               
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  T-ACTIVE                PIC Z,ZZZ,ZZ9.               
T19583         10  FILLER                  PIC X(23)    VALUE SPACES.   
T19583*                                                                         
T19583*****************************************************************         
T19583**           COMMON WORKING STORAGE FOR TOTAL LINE 2 OF RPT 02 **         
T19583*****************************************************************         
T19583*                                                                         
T19583     05  P-TOTAL-LINE22.                                          
T19583         10  FILLER                  PIC X(15)    VALUE SPACES.   
T19583         10  FILLER                  PIC X(30)    VALUE           
T19583             'COMPANY TOTAL CONTRIBUTED YTD:'.                    
T19583         10  FILLER                  PIC X(02)    VALUE SPACES.   
T19583         10  T-TOT-PAID-YTD          PIC $,$$$,$$$.99.            
T19583         10  FILLER                  PIC X(73)    VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR END-OF-REPORT          **         
      *****************************************************************         
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                      PIC X(55)    VALUE SPACES.   
           05  FILLER                      PIC X(21)    VALUE           
               '*** END OF REPORT ***'.                                 
           05  FILLER                      PIC X(56)    VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      **           COMMON WORKING STORAGE FOR NO-DATA                **         
      *****************************************************************         
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                      PIC X(55)    VALUE SPACES.   
           05  FILLER                      PIC X(22)    VALUE           
               '** NO DATA THIS RUN **'.                                
           05  FILLER                      PIC X(55)    VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      **           MISCELLANEOUS WORKING STORAGE FOR REPORTS         **         
      *****************************************************************         
      *                                                                         
       01  WS-BLANK-LINE                   PIC X(132)   VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **                    GENERAL WORKING STORAGE                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      **           WORKING STORAGE FOR SYSTEM DATE AND TIME          **         
      *****************************************************************         
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                       PIC 9(02).                   
           05  WS-CM                       PIC 9(02).                   
           05  WS-CD                       PIC 9(02).                   
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE '/'.      
           05  WS-RD-DD                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE '/'.      
           05  WS-RD-YY                    PIC X(02).                   
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                       PIC 9(02).                   
           05  WS-MM                       PIC 9(02).                   
           05  WS-SS                       PIC 9(02).                   
           05  WS-TT                       PIC 9(02).                   
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-MM                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-SS                    PIC X(02).                   
      *                                                                         
       01  WS-DATE-DISPLAY.                                             
           05  WS-DATE-DISPLAY-MM          PIC 9(02).                   
           05  FILLER                      PIC X(01)    VALUE '/'.      
           05  WS-DATE-DISPLAY-DD          PIC 9(02).                   
           05  FILLER                      PIC X(01)    VALUE '/'.      
           05  WS-DATE-DISPLAY-YY          PIC 9(02).                   
      *                                                                         
T27859 01  WS-REVMNTH-SPLIT.                                            
T27859     05  WS-REVMNTH-RUN-DATE.                                     
T27859         10  WS-REVMNTH-YY               PIC 9(04).               
T27859         10  WS-REVMNTH-MM               PIC 9(02).               
T27859     05  WS-REVMNTH-RUN  REDEFINES WS-REVMNTH-RUN-DATE PIC 9(06). 
T27859*                                                                         
      *****************************************************************         
      **           MISCELLANEOUS GENERAL WORKING STORAGE             **         
      *****************************************************************         
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
           05  WS-RECORDS-FOUND            PIC X(01)    VALUE 'N'.      
               88  RECORDS-FOUND                        VALUE 'Y'.      
               88  NO-RECORDS-FOUND                     VALUE 'N'.      
      *                                                                         
           05  WS-SYSIN-COMP-NO            PIC X(02)    VALUE SPACES.   
           05  WS-PREV-COMP-NO             PIC X(02)    VALUE SPACES.   
           05  WS-PREV-LOC-OFFICE          PIC X(03)    VALUE SPACES.   
           05  WS-PREV-REV-DIST-CODE       PIC X(03)    VALUE SPACES.   
      *                                                                         
           05  WS-HOLD-COMPANY-NO          PIC X(02)    VALUE SPACES.   
           05  WS-HOLD-LOCAL-OFFICE        PIC X(03)    VALUE SPACES.   
           05  WS-HOLD-REV-DIST-CODE       PIC X(03)    VALUE SPACES.   
      *                                                                         
           05  WS-SKIP-LINES-NUM           PIC 9(02)    VALUE ZEROES.   
           05  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 65.       
           05  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZEROES.   
T19583     05  WS-RPT2-LINE-NO             PIC 9(02)    VALUE 65.       
T19583     05  WS-RPT2-PAGE-NO             PIC 9(02)    VALUE ZEROES.   
      *                                                                         
           05  WS-REV-DISTRICT-ACCUM       PIC 9(13)V99.                
           05  WS-COMPANY-ACCUM            PIC 9(13)V99.                
T27859     05  WS-LOCAL-OFFICE-ACCUM       PIC S9(09)V99.               
T19583     05  WS-NEW                      PIC X(01)    VALUE 'N'.      
T19583     05  WS-EXEMPT1                  PIC X(01)    VALUE 'C'.      
T19583     05  WS-EXEMPT2                  PIC X(01)    VALUE 'M'.      
T19583     05  WS-EXEMPT3                  PIC X(01)    VALUE 'S'.      
T19583     05  WS-ARREARS                  PIC X(01)    VALUE 'A'.      
T19583     05  WS-BALANCE                  PIC X(01)    VALUE 'B'.      
T19583     05  WS-NONUTIL                  PIC X(01)    VALUE 'D'.      
T19583     05  IND-TERM-DT                 PIC S9(04) COMP.             
C34828     05  WS-LOC-OFFICE-ST            PIC X(03) VALUE SPACES.      
C34828     05  WS-LOC-OFFICE-ED            PIC X(03) VALUE SPACES.      
                                                                        
      *                                                                         
T19583 01  WS-RPT2-ACCUM.                                               
T19583     05  WS-NEW-NEW-ACCUM            PIC 9(06).                   
T19583     05  WS-NEW-TERMINATED-ACCUM     PIC 9(06).                   
T19583     05  WS-NEW-ONE-TIME-ACCUM       PIC 9(06).                   
T19583     05  WS-NEW-ACTIVE-ACCUM         PIC 9(06).                   
T19583     05  WS-EXEMPT-NEW-ACCUM         PIC 9(06).                   
T19583     05  WS-EXEMPT-TERMINATED-ACCUM  PIC 9(06).                   
T19583     05  WS-EXEMPT-ONE-TIME-ACCUM    PIC 9(06).                   
T19583     05  WS-EXEMPT-ACTIVE-ACCUM      PIC 9(06).                   
T19583     05  WS-ARREARS-NEW-ACCUM        PIC 9(06).                   
T19583     05  WS-ARREARS-TERMINATED-ACCUM PIC 9(06).                   
T19583     05  WS-ARREARS-ONE-TIME-ACCUM   PIC 9(06).                   
T19583     05  WS-ARREARS-ACTIVE-ACCUM     PIC 9(06).                   
T19583     05  WS-BALANCE-NEW-ACCUM        PIC 9(06).                   
T19583     05  WS-BALANCE-TERMINATED-ACCUM PIC 9(06).                   
T19583     05  WS-BALANCE-ONE-TIME-ACCUM   PIC 9(06).                   
T19583     05  WS-BALANCE-ACTIVE-ACCUM     PIC 9(06).                   
T19583     05  WS-NONUTIL-NEW-ACCUM        PIC 9(06).                   
T19583     05  WS-NONUTIL-TERMINATED-ACCUM PIC 9(06).                   
T19583     05  WS-NONUTIL-ONE-TIME-ACCUM   PIC 9(06).                   
T19583     05  WS-NONUTIL-ACTIVE-ACCUM     PIC 9(06).                   
T19583     05  WS-TOTAL-NEW-ACCUM          PIC 9(07).                   
T19583     05  WS-TOTAL-TERMINATED-ACCUM   PIC 9(07).                   
T19583     05  WS-TOTAL-ONE-TIME-ACCUM     PIC 9(07).                   
T19583     05  WS-TOTAL-ACTIVE-ACCUM       PIC 9(07).                   
T19583     05  WS-TOTAL-PAID-YTD           PIC 9(07)V99.                
T27859*                                                                         
T27859 01  WS-MISC-VARIABLES.                                           
T27859     05  WS-CREDIT                   PIC X(1).                    
T27859     05  WS-NO-RECORDS               PIC X(1).                    
      *                                                                         
      *****************************************************************         
      **                     PROGRAM LITERALS                        **         
      *****************************************************************         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)    VALUE           
               'PCSRP371'.                                              
           05  WS-Y                        PIC X(01)    VALUE 'Y'.      
           05  WS-N                        PIC X(01)    VALUE 'N'.      
           05  WS-1                        PIC 9(01)    VALUE 1.        
           05  WS-2                        PIC 9(01)    VALUE 2.        
           05  WS-3                        PIC 9(01)    VALUE 3.        
           05  WS-4                        PIC 9(01)    VALUE 4.        
           05  WS-60                       PIC 9(02)    VALUE 60.       
      *                                                                         
      *****************************************************************         
      **                   NECESSARY COPYBOOKS                       **         
      *****************************************************************         
      *                                                                         
      ************************************                                      
      **  MONTHLY REPORTING DATE PARMS  **                                      
      ************************************                                      
      *                                                                         
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      *                                                                         
      *****************************                                             
      **  ABEND SWITCH COPYBOOK  **                                             
      *****************************                                             
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      **********************************                                        
      **  DB2 AND SQL ERROR CHECKING  **                                        
      **********************************                                        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      **************************************                                    
      **  SUPPORT RE-START REQ PARAMETER  **                                    
      **************************************                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00114                                                   
           END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  SUPPORT RE-START REQ PARAMETER  **                                    
      **************************************                                    
      *                                                                         
           COPY CWS00039.                                                       
      *                                                                         
      *****************************************************************         
      **                 COMMON ABEND FUNCTIONALITY                  **         
      *****************************************************************         
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE              PIC X(02)    VALUE SPACE.    
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 99.                      
      *                                                                         
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_PROJ_SHARE  **                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBPRJSHR                                                   
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_PREMISE  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBPREM                                                     
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_ACCOUNT  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_COMPANY  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_REV_DIST **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRVDST                                                    
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *******************                                                       
      **  CSS_LOCAL_OFF**                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBLOCOFC                                                   
           END-EXEC.                                                            
      *                                                                         
T23684*********************                                                     
T23684**  CSS_DELINQUENCY**                                                     
T23684*********************                                                     
T23684*                                                                         
T23684     EXEC SQL                                                             
T23684     INCLUDE TBDELQ                                                       
T23684     END-EXEC.                                                            
T23684*                                                                         
T27859***********************                                                   
T27859**  CSS_GL_ENTRY_CRNT**                                                   
T27859***********************                                                   
T27859*                                                                         
T27859     EXEC SQL                                                             
T27859     INCLUDE TBGLENT                                                      
T27859     END-EXEC.                                                            
T27859*                                                                         
      *****************************************************************         
      **                   CURSOR DECLARATIONS                       **         
      *****************************************************************         
T27859*         CHANGED MAIN CURSOR TO MATCH JOURNAL LEDGER AMOUNT   **         
      *****************************************************************         
           EXEC SQL                                                     
T29532       DECLARE MTH_SHARE_CSR CURSOR FOR                           
      *      SELECT  A.ACCOUNT_NO,                                              
      *              A.MONTHLY_BILL_AM,                                         
      *              B.COMPANY_NO,                                              
      *              B.PREMISE_NO,                                              
      *              C.REV_DISTRICT_CD,                                         
      *              C.LOCAL_OFFICE,                                            
T29532       SELECT  B.CREDIT_GROUP,                                    
T29532               A.SHARE_ENROLL_DT,                                 
T29532               A.SHARE_STATUS_CD,                                 
T29532               A.ACCT_TERM_DT,                                    
T29532               A.TOT_YTD_AM                                       
T29532       FROM    CSS_PROJ_SHARE A WITH(READUNCOMMITTED),                    
T29532               CSS_ACCOUNT B WITH(READUNCOMMITTED),                       
T29532               CSS_PREMISE C WITH(READUNCOMMITTED)                        
T19583*      WHERE   A.SHARE_STATUS_CD   IN ('A','O')                           
T29532       WHERE   A.PYMT_PRIORITY_LVL   = 129                        
T29532         AND   A.ITEM_ID             = 1                          
T29532         AND   A.SHARE_ENROLL_DT     < IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )      
T29532         AND   A.ACCOUNT_NO          = B.ACCOUNT_NO               
T29532         AND   B.PREMISE_NO          = C.PREMISE_NO               
T32671         AND   B.CODE_ACCT_STAT      = 'A'                        
C34828         AND   B.COMPANY_NO          = :WS-SYSIN-COMP-NO          
T29532       ORDER BY B.COMPANY_NO, C.LOCAL_OFFICE, C.REV_DISTRICT_CD   
T33928         FOR READ ONLY                                    
T29532     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MTH_SHARE_CSR CURSOR FOR                                   
MFA-TR*      SELECT  A.ACCOUNT_NO,                                              
MFA-TR*              A.MONTHLY_BILL_AM,                                         
MFA-TR*              B.COMPANY_NO,                                              
MFA-TR*              B.PREMISE_NO,                                              
MFA-TR*              C.REV_DISTRICT_CD,                                         
MFA-TR*              C.LOCAL_OFFICE,                                            
MFA-TR*      SELECT  B.CREDIT_GROUP,                                            
MFA-TR*              A.SHARE_ENROLL_DT,                                         
MFA-TR*              A.SHARE_STATUS_CD,                                         
MFA-TR*              A.ACCT_TERM_DT,                                            
MFA-TR*              A.TOT_YTD_AM                                               
MFA-TR*      FROM    CSS_PROJ_SHARE A,                                          
MFA-TR*              CSS_ACCOUNT B,                                             
MFA-TR*              CSS_PREMISE C                                              
MFA-TR*      WHERE   A.SHARE_STATUS_CD   IN ('A','O')                           
MFA-TR*      WHERE   A.PYMT_PRIORITY_LVL   = 129                                
MFA-TR*        AND   A.ITEM_ID             = 1                                  
MFA-TR*        AND   A.SHARE_ENROLL_DT     < :WS-STNDTE-RPT-END-DT              
MFA-TR*        AND   A.ACCOUNT_NO          = B.ACCOUNT_NO                       
MFA-TR*        AND   B.PREMISE_NO          = C.PREMISE_NO                       
MFA-TR*        AND   B.CODE_ACCT_STAT      = 'A'                                
MFA-TR*        AND   B.COMPANY_NO          = :WS-SYSIN-COMP-NO                  
MFA-TR*      ORDER BY B.COMPANY_NO, C.LOCAL_OFFICE, C.REV_DISTRICT_CD           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T27859*****************************************************************         
T27859*    NEW CURSOR DECLARATION.                                   **         
T27859*****************************************************************         
T27859     EXEC SQL                                                     
T27859       DECLARE SHARE_CSR CURSOR FOR                               
T27859       SELECT AMT_TRAN_ENTRY                                      
T27859             ,GL_CNTRL_DR_CR                                      
T27859             ,COMPANY_NO                                          
T27859             ,LOCAL_OFFICE                                        
T27859         FROM CSS_GL_ENTRY_CRNT                                   
T27859        WHERE GL_ACCT_NO = 232.7400                               
T27859          AND ACCT_PERIOD_AFFCTD = :GE-ACCT-PERIOD-AFFCTD         
T27859*         AND LOCAL_OFFICE < '200'                                        
C34828*         AND COMPANY_NO = :WS-SYSIN-COMP-NO                              
C34828          AND LOCAL_OFFICE BETWEEN :WS-LOC-OFFICE-ST AND          
C34828              :WS-LOC-OFFICE-ED                                   
T27859        ORDER BY COMPANY_NO,LOCAL_OFFICE,GL_CNTRL_DR_CR           
T27859     END-EXEC.                                                    
T27859*                                                                         
C34828*****************************************************************         
C34828*    NEW CURSOR DECLARATION.                                   **         
C34828*****************************************************************         
C34828     EXEC SQL                                                     
C34828       DECLARE SHARE_CSR2 CURSOR FOR                              
C34828       SELECT AMT_TRAN_ENTRY                                      
C34828             ,GL_CNTRL_DR_CR                                      
C34828             ,COMPANY_NO                                          
C34828             ,LOCAL_OFFICE                                        
C34828         FROM CSS_GL_ENTRY_CRNT                                   
C34828        WHERE GL_ACCT_NO = 232.7400                               
C34828          AND ACCT_PERIOD_AFFCTD = :GE-ACCT-PERIOD-AFFCTD         
C34828*         AND LOCAL_OFFICE < '200'                                        
C34828*         AND COMPANY_NO = :WS-SYSIN-COMP-NO                              
C34828          AND LOCAL_OFFICE BETWEEN '200' AND '298'                
C34828        ORDER BY COMPANY_NO,LOCAL_OFFICE,GL_CNTRL_DR_CR           
C34828     END-EXEC.                                                    
C34828*                                                                         
       01  WS-WORKING-STORAGE-END          PIC X(40)    VALUE           
           'WORKING STORAGE FOR PCSRP371 ENDS HERE  '.                  
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0000-MAIN                                                **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0000-MAIN.                                                       
      *                                                                         
           PERFORM 0100-INITIALIZATION                  THRU 0100-EXIT. 
      *                                                                         
T27859     IF WS-NO-RECORDS NOT EQUAL WS-N                              
            PERFORM 1000-PRODUCE-REPORT                  THRU 1000-EXIT 
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
T27859     END-IF.                                                      
      *                                                                         
      *                                                                         
           PERFORM 0200-END-OF-REPORT                   THRU 0200-EXIT. 
      *                                                                         
T29532     PERFORM 7050-OPEN-MTH-SHARE-CURSOR           THRU 7050-EXIT. 
T29532     PERFORM 7150-FETCH-MTH-SHARE-CURSOR          THRU 7150-EXIT. 
T29532     PERFORM 1500-EVALUATE-CREDIT-GROUP           THRU 1500-EXIT  
T29532        UNTIL MTH-SHARE-CUR.                                      
T29532     PERFORM 7250-CLOSE-MTH-SHARE-CURSOR          THRU 7250-EXIT. 
      *                                                                         
T29532     PERFORM 8500-PRINT-SECOND-REPORT             THRU 8500-EXIT. 
           PERFORM 9000-TERMINATE                       THRU 9000-EXIT. 
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0100-INITIALIZATION                                      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 7600-OPEN-REPORT-FILE             THRU 7600A-EXIT.   
      *                                                                         
           PERFORM 6200-GET-PARAMETER-DATE              THRU 6200-EXIT. 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT1-RUN-TIME             
T19583                                      P-RPT2-RUN-TIME.            
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                    TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT1-RUN-DATE             
T19583                                      P-RPT2-RUN-DATE.            
      *                                                                         
           MOVE WS-STNDTE-RPT-END-DT(6:2) TO WS-DATE-DISPLAY-MM.        
           MOVE WS-STNDTE-RPT-END-DT(9:2) TO WS-DATE-DISPLAY-DD.        
           MOVE WS-STNDTE-RPT-END-DT(3:2) TO WS-DATE-DISPLAY-YY.        
T27859     MOVE WS-PARM-YR                TO WS-REVMNTH-YY.             
T27859     MOVE WS-PARM-MONTH             TO WS-REVMNTH-MM.             
T27859     MOVE WS-REVMNTH-RUN            TO GE-ACCT-PERIOD-AFFCTD.     
T27859*                                                                         
           MOVE WS-DATE-DISPLAY          TO P-RPT1-DATE                 
T19583                                      P-RPT2-DATE.                
      *                                                                         
A03967*    MOVE WS-DATE-DISPLAY          TO WS-DEFAULT-RPT1-DT                  
A03967*                                     WS-DEFAULT-RPT2-DT.                 
A03967     MOVE WS-REVMNTH-RUN            TO WS-DEFAULT-RPT1-DT         
A03967                                       WS-DEFAULT-RPT2-DT.        
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
      *                                                                         
T27859     INITIALIZE  WS-LOCAL-OFFICE-ACCUM                            
T27859                 GE-AMT-TRAN-ENTRY.                               
T27859*                                                                         
T27859     MOVE WS-Y                     TO WS-NO-RECORDS.              
T27859*                                                                         
C34828     IF WS-SYSIN-COMP-NO = '01'                                   
C34828        IF SEB-DATABASE                                           
C34828           MOVE '001' TO WS-LOC-OFFICE-ST                         
C34828           MOVE '509' TO WS-LOC-OFFICE-ED                         
C34828        ELSE                                                      
C34828           MOVE '002' TO WS-LOC-OFFICE-ST                         
C34828           MOVE '095' TO WS-LOC-OFFICE-ED                         
C34828        END-IF                                                    
                                                                        
              PERFORM 7000-OPEN-SHARE-CURSOR     THRU 7000-EXIT         
              PERFORM 7100-FETCH-SHARE-CURSOR    THRU 7100-EXIT         
C34828     ELSE                                                         
C34828        PERFORM 7010-OPEN-SHARE-CURSOR2    THRU 7010-EXIT         
C34828        PERFORM 7110-FETCH-SHARE-CURSOR2   THRU 7110-EXIT         
C34828        MOVE '26' TO GE-COMPANY-NO                                
C34828     END-IF.                                                      
                                                                        
T27859*    CHANGED TO USE THE FETCHED VALUES FROM CSS_GL_ENTRY_CRNT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T27859         MOVE GE-COMPANY-NO      TO WS-PREV-COMP-NO               
T27859         MOVE GE-LOCAL-OFFICE    TO WS-PREV-LOC-OFFICE            
T27859*        MOVE PR-REV-DISTRICT-CD TO WS-PREV-REV-DIST-CODE                 
T27859     ELSE                                                         
T27859         MOVE WS-N               TO WS-NO-RECORDS                 
           END-IF.                                                      
      *                                                                         
T19583     INITIALIZE WS-RPT2-ACCUM.                                    
      *                                                                         
T23684     MOVE 'DATABASE'             TO C8-DELINQ-CD                  
C34828     IF WS-SYSIN-COMP-NO = '01'                                   
T23684        MOVE '01'                   TO C8-COMPANY-NO              
C34828     ELSE                                                         
C34828        MOVE '26'                   TO C8-COMPANY-NO              
C34828     END-IF.                                                      
                                                                        
T23684     PERFORM 1505-SELECT-DELINQUENCY                              
T23684     MOVE C8-DELINQ-VALUE             TO WS-DATABASES.            
T27859     MOVE 'C'                         TO WS-CREDIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0200-END-OF-REPORT                                       **         
      **        CLOSES THE DRIVING CURSOR, PRINTS THE ENTIRE REPORT  **         
      **        WITH THE NO-DATA MESSAGE WHEN NO RECORDS ARE FOUND,  **         
      **        AND PRINTS THE FINAL DETAIL AND TOTAL LINES WITH THE **         
      **        END-OF-REPORT MESSAGE WHEN RECORDS ARE FOUND.        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0200-END-OF-REPORT.                                              
      *                                                                         
      *    IF NO-RECORDS-FOUND AND WS-SYSIN-COMP-NO NOT EQUAL '26'              
           IF NO-RECORDS-FOUND                                          
C34828        IF WS-SYSIN-COMP-NO = '26'                                
C34828         MOVE '           HEATCARE DISTRIBUTION REPORT           '
C34828                              TO WS-DEFAULT-RPT1-HEAD1            
A03967         MOVE '                    PSNC '                         
C34828                     TO WS-DEFAULT-RPT1-TITLE                     
C34828        END-IF                                                    
              MOVE WS-DEFAULT-RPT1-TITLE TO P-RPT1-TITLE                
T29532                                      C7-COMPANY-NAME             
      *                                                                         
               PERFORM 8100-PRINT-RPT1-HEADER           THRU 8100-EXIT  
               PERFORM 8200-PRINT-RPT1-TITLE            THRU 8200-EXIT  
               PERFORM 8300-PRINT-RPT1-COL-HEADERS      THRU 8300-EXIT  
      *                                                                         
               MOVE WS-NO-DATA-LINE      TO P-OUTPUT-LINE               
               MOVE WS-2                 TO WS-SKIP-LINES-NUM           
      *                                                                         
               PERFORM 8400-PRINT-RECORD                THRU 8400-EXIT  
           ELSE                                                         
               PERFORM 2300-FORMAT-DETAIL-LINE1         THRU 2300-EXIT  
               PERFORM 8900-PRINT-RPT1-DETAIL1          THRU 8900-EXIT  
      *                                                                         
               PERFORM 2350-FORMAT-DETAIL-LINE2         THRU 2350-EXIT  
               PERFORM 8950-PRINT-RPT1-DETAIL2          THRU 8950-EXIT  
      *                                                                         
               MOVE WS-END-DATA-LINE     TO P-OUTPUT-LINE               
               MOVE WS-2                 TO WS-SKIP-LINES-NUM           
      *                                                                         
               PERFORM 8400-PRINT-RECORD                THRU 8400-EXIT  
           END-IF.                                                      
      *                                                                         
C34828     IF WS-SYSIN-COMP-NO = '01'                                   
              PERFORM 7200-CLOSE-SHARE-CURSOR     THRU 7200-EXIT        
C34828     ELSE                                                         
C34828        PERFORM 7210-CLOSE-SHARE-CURSOR2    THRU 7210-EXIT        
C34828     END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    1000-PRODUCE-REPORT                                      **         
      **        MAIN LOOP TO PRODUCE THE DETAILED REPORT - IT IS     **         
      **        PERFORMED UNTIL A NOT-FOUND CONDITION IS RETURNED    **         
      **        BY THE CURSOR.                                       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1000-PRODUCE-REPORT.                                             
      *                                                                         
T27859*    COMMENTED FOR T27859 CHANGES.                                        
T19583*    IF (PJ-SHARE-STATUS-CD = 'A' OR                                      
T19583*        PJ-SHARE-STATUS-CD = 'O')                                        
T27859        MOVE GE-COMPANY-NO            TO C7-COMPANY-NO            
      *                                                                         
              IF (WS-SYSIN-COMP-NO = (SPACES OR LOW-VALUES) OR          
T27859           (WS-SYSIN-COMP-NO = GE-COMPANY-NO) )                   
      *                                                                         
                 IF WS-RPT1-LINE-NO GREATER WS-60                       
                    PERFORM 7500-SELECT-COMPANY-NAME     THRU 7500-EXIT 
                    PERFORM 8100-PRINT-RPT1-HEADER       THRU 8100-EXIT 
                    PERFORM 8200-PRINT-RPT1-TITLE        THRU 8200-EXIT 
                    PERFORM 8300-PRINT-RPT1-COL-HEADERS                 
                                                         THRU 8300-EXIT 
                 END-IF                                                 
      *                                                                         
      *        ELSE                                                             
T27859           IF GE-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO             
                    PERFORM 2300-FORMAT-DETAIL-LINE1   THRU 2300-EXIT   
                    PERFORM 8900-PRINT-RPT1-DETAIL1    THRU 8900-EXIT   
                                                                        
                    PERFORM 2350-FORMAT-DETAIL-LINE2   THRU 2350-EXIT   
                    PERFORM 8950-PRINT-RPT1-DETAIL2    THRU 8950-EXIT   
                                                                        
                    PERFORM 7500-SELECT-COMPANY-NAME   THRU 7500-EXIT   
                    PERFORM 8100-PRINT-RPT1-HEADER     THRU 8100-EXIT   
                    PERFORM 8200-PRINT-RPT1-TITLE      THRU 8200-EXIT   
                    PERFORM 8300-PRINT-RPT1-COL-HEADERS                 
                                                        THRU 8300-EXIT  
                                                                        
T27859              MOVE GE-COMPANY-NO    TO WS-PREV-COMP-NO            
T27859              MOVE GE-LOCAL-OFFICE  TO WS-PREV-LOC-OFFICE         
T27859*             MOVE PR-REV-DISTRICT-CD                                     
T27859*                                   TO WS-PREV-REV-DIST-CODE              
      *                                                                         
T27859*             MOVE ZEROES           TO WS-REV-DISTRICT-ACCUM              
T27859              MOVE ZEROES           TO WS-LOCAL-OFFICE-ACCUM      
                    MOVE ZEROES           TO WS-COMPANY-ACCUM           
                 ELSE                                                   
T27859*             IF PR-REV-DISTRICT-CD NOT EQUAL                             
T27859*                                        WS-PREV-REV-DIST-CODE            
T27859              IF GE-LOCAL-OFFICE    NOT EQUAL                     
T27859                                         WS-PREV-LOC-OFFICE       
                       PERFORM 2300-FORMAT-DETAIL-LINE1 THRU 2300-EXIT  
                       PERFORM 8900-PRINT-RPT1-DETAIL1  THRU 8900-EXIT  
      *                                                                         
T27859                 MOVE GE-COMPANY-NO    TO WS-PREV-COMP-NO         
T27859                 MOVE GE-LOCAL-OFFICE  TO WS-PREV-LOC-OFFICE      
T27859*                MOVE PR-REV-DISTRICT-CD                                  
T27859*                                      TO WS-PREV-REV-DIST-CODE           
      *                                                                         
T27859                 MOVE ZEROES           TO WS-REV-DISTRICT-ACCUM   
T27859                 MOVE ZEROES           TO WS-LOCAL-OFFICE-ACCUM   
                    END-IF                                              
                 END-IF                                                 
      *        END-IF                                                           
      *                                                                         
                 MOVE WS-Y                 TO WS-RECORDS-FOUND          
      *                                                                         
      *          ADD PJ-MONTHLY-BILL-AM    TO WS-REV-DISTRICT-ACCUM             
      *          ADD PJ-MONTHLY-BILL-AM    TO WS-COMPANY-ACCUM                  
T27859*                                                                         
T27859           IF GE-GL-CNTRL-DR-CR = WS-CREDIT                       
T27859              ADD GE-AMT-TRAN-ENTRY  TO WS-LOCAL-OFFICE-ACCUM     
T27859              ADD GE-AMT-TRAN-ENTRY  TO WS-COMPANY-ACCUM          
T27859           ELSE                                                   
T27859              MULTIPLY -1 BY GE-AMT-TRAN-ENTRY                    
T27859              ADD GE-AMT-TRAN-ENTRY  TO WS-LOCAL-OFFICE-ACCUM     
T27859              ADD GE-AMT-TRAN-ENTRY  TO WS-COMPANY-ACCUM          
T27859           END-IF                                                 
      *                                                                         
T27859        END-IF.                                                   
T27859*    END-IF.                                                              
      *                                                                         
T19583*    PERFORM 1500-EVALUATE-CREDIT-GROUP           THRU 1500-EXIT.         
C34828        IF WS-SYSIN-COMP-NO = '01'                                
                 PERFORM 7100-FETCH-SHARE-CURSOR      THRU 7100-EXIT    
C34828        ELSE                                                      
C34828           PERFORM 7110-FETCH-SHARE-CURSOR2     THRU 7110-EXIT    
C34828           MOVE '26' TO GE-COMPANY-NO                             
C34828        END-IF.                                                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
T19583**    1500-EVALUATE-CREDIT-GROUP                               **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR EACH CREDIT    **         
T19583**        GROUP BY MONTHLY CONTRIBUTOR TYPE (NEW, TERMINATED,  **         
T19583**        ONE-TIME AND ACTIVE.                                 **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 1500-EVALUATE-CREDIT-GROUP.                                      
T19583*                                                                         
T19583     EVALUATE AT-CREDIT-GROUP                                     
T19583        WHEN WS-NEW                                               
T19583                 PERFORM 1600-CALCULATE-NEW     THRU 1600-EXIT    
T19583        WHEN WS-EXEMPT1                                           
T19583        WHEN WS-EXEMPT2                                           
T19583        WHEN WS-EXEMPT3                                           
T19583                 PERFORM 1700-CALCULATE-EXEMPT  THRU 1700-EXIT    
T19583        WHEN WS-ARREARS                                           
T19583                 PERFORM 1800-CALCULATE-ARREARS THRU 1800-EXIT    
T19583        WHEN WS-BALANCE                                           
T19583                 PERFORM 1900-CALCULATE-BALANCE THRU 1900-EXIT    
T19583        WHEN WS-NONUTIL                                           
T19583                 PERFORM 2000-CALCULATE-NONUTIL THRU 2000-EXIT    
T19583     END-EVALUATE.                                                
T29532     PERFORM 7150-FETCH-MTH-SHARE-CURSOR        THRU 7150-EXIT.   
T19583*                                                                         
T19583 1500-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T23684**********************************************************                
T23684* DETERMINE THE SUBSYSTEM, ACCORDINGLY MOVE PROJECT      *                
T23684* SHARES FOR CSR AND H.E.A.T. FOR SEB                    *                
T23684**********************************************************                
T23684 1505-SELECT-DELINQUENCY.                                         
T23684                                                                  
T23684     EXEC SQL                                                     
T23684       SELECT DELINQ_VALUE                                        
T23684         INTO :C8-DELINQ-VALUE                                    
T23684         FROM CSS_DELINQUENCY                                     
T23684        WHERE DELINQ_CD    = :C8-DELINQ-CD                        
T23684          AND COMPANY_NO   = :C8-COMPANY-NO                       
T23684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23684                                                                  
T23684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23684                                                                  
T23684     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T23684        NEXT SENTENCE                                             
T23684     ELSE                                                         
T23684        DISPLAY '******************************************'      
T23684        DISPLAY '** DELINQUENCY TABLE  '                          
T23684        DISPLAY '** 1505 :  RETURN CODE ERROR - SELECT '          
T23684        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
T23684        DISPLAY '******************************************'      
T23684        PERFORM 9900-ABEND THRU 9900-EXIT                         
T23684     END-IF.                                                      
T23684                                                                  
T23684 1505-EXIT.                                                       
T23684     EXIT.                                                        
T19583*****************************************************************         
T19583**                                                             **         
T19583**    1600-CALCULATE-NEW                                       **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR NEW            **         
T19583**        CONTRIBUTORS.                                        **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 1600-CALCULATE-NEW.                                              
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T32671     AND  PJ-SHARE-STATUS-CD = 'P'                                
T19583*    AND  PJ-SHARE-STATUS-CD NOT = 'O'                                    
T19583          ADD 1 TO WS-NEW-NEW-ACCUM                               
T19583          ADD 1 TO WS-TOTAL-NEW-ACCUM                             
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  IND-TERM-DT = 0                                          
T19583     AND (PJ-ACCT-TERM-DT >= WS-STNDTE-RPT-BEG-DT                 
T19583     AND  PJ-ACCT-TERM-DT <  WS-STNDTE-RPT-END-DT)                
T19583     AND  PJ-SHARE-STATUS-CD = 'I'                                
T19583          ADD 1 TO WS-NEW-TERMINATED-ACCUM                        
T19583          ADD 1 TO WS-TOTAL-TERMINATED-ACCUM                      
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T19583     AND  PJ-SHARE-STATUS-CD = 'O'                                
T19583         ADD 1 TO WS-NEW-ONE-TIME-ACCUM                           
T19583         ADD 1 TO WS-TOTAL-ONE-TIME-ACCUM                         
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  PJ-SHARE-STATUS-CD = 'A'                                 
T19583         ADD 1 TO WS-NEW-ACTIVE-ACCUM                             
T19583         ADD 1 TO WS-TOTAL-ACTIVE-ACCUM                           
T19583     END-IF.                                                      
T19583*                                                                         
T19583     ADD PJ-TOT-YTD-AM TO WS-TOTAL-PAID-YTD.                      
T19583*                                                                         
T19583 1600-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    1700-CALCULATE-EXEMPT                                    **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR EXEMPT         **         
T19583**        CONTRIBUTORS.                                        **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 1700-CALCULATE-EXEMPT.                                           
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T32671     AND  PJ-SHARE-STATUS-CD = 'P'                                
T19583*    AND  PJ-SHARE-STATUS-CD NOT = 'O'                                    
T19583          ADD 1 TO WS-EXEMPT-NEW-ACCUM                            
T19583          ADD 1 TO WS-TOTAL-NEW-ACCUM                             
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  IND-TERM-DT = 0                                          
T19583     AND (PJ-ACCT-TERM-DT >= WS-STNDTE-RPT-BEG-DT                 
T19583     AND  PJ-ACCT-TERM-DT <  WS-STNDTE-RPT-END-DT)                
T19583     AND  PJ-SHARE-STATUS-CD = 'I'                                
T19583          ADD 1 TO WS-EXEMPT-TERMINATED-ACCUM                     
T19583          ADD 1 TO WS-TOTAL-TERMINATED-ACCUM                      
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T19583     AND  PJ-SHARE-STATUS-CD = 'O'                                
T19583         ADD 1 TO WS-EXEMPT-ONE-TIME-ACCUM                        
T19583         ADD 1 TO WS-TOTAL-ONE-TIME-ACCUM                         
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  PJ-SHARE-STATUS-CD = 'A'                                 
T19583         ADD 1 TO WS-EXEMPT-ACTIVE-ACCUM                          
T19583         ADD 1 TO WS-TOTAL-ACTIVE-ACCUM                           
T19583     END-IF.                                                      
T19583*                                                                         
T19583     ADD PJ-TOT-YTD-AM TO WS-TOTAL-PAID-YTD.                      
T19583*                                                                         
T19583 1700-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    1800-CALCULATE-ARREARS                                   **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR ARREAR         **         
T19583**        CONTRIBUTORS.                                        **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 1800-CALCULATE-ARREARS.                                          
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T32671     AND  PJ-SHARE-STATUS-CD = 'P'                                
T19583*    AND  PJ-SHARE-STATUS-CD NOT = 'O'                                    
T19583          ADD 1 TO WS-ARREARS-NEW-ACCUM                           
T19583          ADD 1 TO WS-TOTAL-NEW-ACCUM                             
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  IND-TERM-DT = 0                                          
T19583     AND (PJ-ACCT-TERM-DT >= WS-STNDTE-RPT-BEG-DT                 
T19583     AND  PJ-ACCT-TERM-DT <  WS-STNDTE-RPT-END-DT)                
T19583     AND  PJ-SHARE-STATUS-CD = 'I'                                
T19583          ADD 1 TO WS-ARREARS-TERMINATED-ACCUM                    
T19583          ADD 1 TO WS-TOTAL-TERMINATED-ACCUM                      
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T19583     AND  PJ-SHARE-STATUS-CD = 'O'                                
T19583         ADD 1 TO WS-ARREARS-ONE-TIME-ACCUM                       
T19583         ADD 1 TO WS-TOTAL-ONE-TIME-ACCUM                         
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  PJ-SHARE-STATUS-CD = 'A'                                 
T19583         ADD 1 TO WS-ARREARS-ACTIVE-ACCUM                         
T19583         ADD 1 TO WS-TOTAL-ACTIVE-ACCUM                           
T19583     END-IF.                                                      
T19583*                                                                         
T19583     ADD PJ-TOT-YTD-AM TO WS-TOTAL-PAID-YTD.                      
T19583*                                                                         
T19583 1800-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    1900-CALCULATE-BALANCE                                   **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR BALANCE        **         
T19583**        CONTRIBUTORS.                                        **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 1900-CALCULATE-BALANCE.                                          
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T32671     AND  PJ-SHARE-STATUS-CD = 'P'                                
T19583*    AND  PJ-SHARE-STATUS-CD NOT = 'O'                                    
T19583          ADD 1 TO WS-BALANCE-NEW-ACCUM                           
T19583          ADD 1 TO WS-TOTAL-NEW-ACCUM                             
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  IND-TERM-DT = 0                                          
T19583     AND (PJ-ACCT-TERM-DT >= WS-STNDTE-RPT-BEG-DT                 
T19583     AND  PJ-ACCT-TERM-DT <  WS-STNDTE-RPT-END-DT)                
T19583     AND  PJ-SHARE-STATUS-CD = 'I'                                
T19583          ADD 1 TO WS-BALANCE-TERMINATED-ACCUM                    
T19583          ADD 1 TO WS-TOTAL-TERMINATED-ACCUM                      
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T19583     AND  PJ-SHARE-STATUS-CD = 'O'                                
T19583         ADD 1 TO WS-BALANCE-ONE-TIME-ACCUM                       
T19583         ADD 1 TO WS-TOTAL-ONE-TIME-ACCUM                         
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  PJ-SHARE-STATUS-CD = 'A'                                 
T19583         ADD 1 TO WS-BALANCE-ACTIVE-ACCUM                         
T19583         ADD 1 TO WS-TOTAL-ACTIVE-ACCUM                           
T19583     END-IF.                                                      
T19583*                                                                         
T19583     ADD PJ-TOT-YTD-AM TO WS-TOTAL-PAID-YTD.                      
T19583*                                                                         
T19583 1900-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    2000-CALCULATE-NONUTIL                                   **         
T19583**        THIS MODULE CALCULATES THE TOTALS FOR NON-UTILITY    **         
T19583**        CONTRIBUTORS.                                        **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 2000-CALCULATE-NONUTIL.                                          
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T32671     AND  PJ-SHARE-STATUS-CD = 'P'                                
T19583*    AND  PJ-SHARE-STATUS-CD NOT = 'O'                                    
T19583          ADD 1 TO WS-NONUTIL-NEW-ACCUM                           
T19583          ADD 1 TO WS-TOTAL-NEW-ACCUM                             
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  IND-TERM-DT = 0                                          
T19583     AND (PJ-ACCT-TERM-DT >= WS-STNDTE-RPT-BEG-DT                 
T19583     AND  PJ-ACCT-TERM-DT <  WS-STNDTE-RPT-END-DT)                
T19583     AND  PJ-SHARE-STATUS-CD = 'I'                                
T19583          ADD 1 TO WS-NONUTIL-TERMINATED-ACCUM                    
T19583          ADD 1 TO WS-TOTAL-TERMINATED-ACCUM                      
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  (PJ-SHARE-ENROLL-DT >= WS-STNDTE-RPT-BEG-DT              
T19583     AND  PJ-SHARE-ENROLL-DT <  WS-STNDTE-RPT-END-DT)             
T19583     AND  PJ-SHARE-STATUS-CD = 'O'                                
T19583         ADD 1 TO WS-NONUTIL-ONE-TIME-ACCUM                       
T19583         ADD 1 TO WS-TOTAL-ONE-TIME-ACCUM                         
T19583     END-IF.                                                      
T19583*                                                                         
T19583     IF  PJ-SHARE-STATUS-CD = 'A'                                 
T19583         ADD 1 TO WS-NONUTIL-ACTIVE-ACCUM                         
T19583         ADD 1 TO WS-TOTAL-ACTIVE-ACCUM                           
T19583     END-IF.                                                      
T19583*                                                                         
T19583     ADD PJ-TOT-YTD-AM TO WS-TOTAL-PAID-YTD.                      
T19583*                                                                         
T19583 2000-EXIT.                                                       
T19583     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    2300-FORMAT-DETAIL-LINE1                                 **         
      **        THE DETAIL LINE SUMMARIZING REVENUE DISTRICT/LOCAL   **         
      **        OFFICE ACTIVITY IS FORMATTED USING VALUES FETCHED    **         
      **        BY THE CURSOR AND THE REVENUE DISTRICT ACCUMULATOR.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       2300-FORMAT-DETAIL-LINE1.                                        
      *                                                                         
           MOVE WS-PREV-LOC-OFFICE       TO B1-LOCAL-OFFICE.            
T27859     MOVE GE-COMPANY-NO            TO B1-COMPANY-NO.              
           PERFORM 7800-GET-LOC-OFF-DESC  THRU 7800-EXIT.               
T27859*    MOVE WS-PREV-REV-DIST-CODE    TO A9-REV-DISTRICT-CD.                 
T27859*    PERFORM 7900-GET-REV-DIST-DESC  THRU 7900-EXIT.                      
T27859*    MOVE WS-REV-DISTRICT-ACCUM    TO P-PROJ-SHARE-AMT.                   
T27859     MOVE WS-LOCAL-OFFICE-ACCUM    TO P-PROJ-SHARE-AMT.           
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    2350-FORMAT-DETAIL-LINE2                                 **         
      **        THE DETAIL LINE SUMMARIZING COMPANY ACTIVITY IS      **         
      **        FORMATTED USING THE COMPANY PROJECT SHARE/H.E.A.T.   **         
      **        ACCUMULATOR.                                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       2350-FORMAT-DETAIL-LINE2.                                        
      *                                                                         
           MOVE WS-COMPANY-ACCUM         TO P-PROJ-SHARE-TOTAL.         
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
T19583**                                                             **         
T19583**    2400-FORMAT-DETAIL-LINE12                                **         
T19583**        THIS MODULES FORMATS THE DETAIL LINE FOR THE PROJECT **         
T19583**        SHARE/H.E.A.T. MONTHLY STATISTICAL SUMMARY REPORT.   **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 2400-FORMAT-DETAIL-LINE12.                                       
T19583*                                                                         
T19583     MOVE 'NEW'                         TO P-LINE-NAME.           
T19583     MOVE WS-NEW-NEW-ACCUM              TO P-NEW.                 
T19583     MOVE WS-NEW-TERMINATED-ACCUM       TO P-TERMINATED.          
T19583     MOVE WS-NEW-ONE-TIME-ACCUM         TO P-ONE-TIME.            
T19583     MOVE WS-NEW-ACTIVE-ACCUM           TO P-ACTIVE.              
T19583     PERFORM 8960-PRINT-RPT2-DETAIL12 THRU 8960-EXIT.             
T19583     MOVE 'EXEMPT'                      TO P-LINE-NAME.           
T19583     MOVE WS-EXEMPT-NEW-ACCUM           TO P-NEW.                 
T19583     MOVE WS-EXEMPT-TERMINATED-ACCUM    TO P-TERMINATED.          
T19583     MOVE WS-EXEMPT-ONE-TIME-ACCUM      TO P-ONE-TIME.            
T19583     MOVE WS-EXEMPT-ACTIVE-ACCUM        TO P-ACTIVE.              
T19583     PERFORM 8960-PRINT-RPT2-DETAIL12 THRU 8960-EXIT.             
T19583     MOVE 'ARREARS'                     TO P-LINE-NAME.           
T19583     MOVE WS-ARREARS-NEW-ACCUM          TO P-NEW.                 
T19583     MOVE WS-ARREARS-TERMINATED-ACCUM   TO P-TERMINATED.          
T19583     MOVE WS-ARREARS-ONE-TIME-ACCUM     TO P-ONE-TIME.            
T19583     MOVE WS-ARREARS-ACTIVE-ACCUM       TO P-ACTIVE.              
T19583     PERFORM 8960-PRINT-RPT2-DETAIL12 THRU 8960-EXIT.             
T19583     MOVE 'BALANCE'                     TO P-LINE-NAME.           
T19583     MOVE WS-BALANCE-NEW-ACCUM          TO P-NEW.                 
T19583     MOVE WS-BALANCE-TERMINATED-ACCUM   TO P-TERMINATED.          
T19583     MOVE WS-BALANCE-ONE-TIME-ACCUM     TO P-ONE-TIME.            
T19583     MOVE WS-BALANCE-ACTIVE-ACCUM       TO P-ACTIVE.              
T19583     PERFORM 8960-PRINT-RPT2-DETAIL12 THRU 8960-EXIT.             
T19583     MOVE 'NON-UTILITY'                 TO P-LINE-NAME.           
T19583     MOVE WS-NONUTIL-NEW-ACCUM          TO P-NEW.                 
T19583     MOVE WS-NONUTIL-TERMINATED-ACCUM   TO P-TERMINATED.          
T19583     MOVE WS-NONUTIL-ONE-TIME-ACCUM     TO P-ONE-TIME.            
T19583     MOVE WS-NONUTIL-ACTIVE-ACCUM       TO P-ACTIVE.              
T19583     PERFORM 8960-PRINT-RPT2-DETAIL12 THRU 8960-EXIT.             
T19583*                                                                         
T19583 2400-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    2500-FORMAT-TOTAL-LINE12                                 **         
T19583**        THIS MODULES FORMATS THE TOTAL LINE FOR THE PROJECT  **         
T19583**        SHARE/H.E.A.T. MONTHLY STATISTICAL SUMMARY REPORT.   **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 2500-FORMAT-TOTAL-LINE12.                                        
T19583*                                                                         
T19583     MOVE WS-TOTAL-NEW-ACCUM            TO T-NEW.                 
T19583     MOVE WS-TOTAL-TERMINATED-ACCUM     TO T-TERMINATED.          
T19583     MOVE WS-TOTAL-ONE-TIME-ACCUM       TO T-ONE-TIME.            
T19583     MOVE WS-TOTAL-ACTIVE-ACCUM         TO T-ACTIVE.              
T19583     PERFORM 8970-PRINT-RPT2-TOTAL12  THRU 8970-EXIT.             
T19583     MOVE WS-TOTAL-PAID-YTD             TO T-TOT-PAID-YTD.        
T19583     PERFORM 8980-PRINT-RPT2-TOTAL22  THRU 8980-EXIT.             
T19583     MOVE WS-END-DATA-LINE              TO P-OUTPUT-LINE.         
T19583     MOVE WS-2                          TO WS-SKIP-LINES-NUM.     
T19583*                                                                         
T19583     PERFORM 8400-PRINT-RECORD        THRU 8400-EXIT.             
T19583*                                                                         
T19583 2500-EXIT.                                                       
T19583     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **      COPYBOOK TO READ JOB PARM TABLE FOR REPORT DATE        **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00114                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7000-OPEN-SHARE-CURSOR                                   **         
      **        THE DRIVING CURSOR IS OPENED.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7000-OPEN-SHARE-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
             OPEN  SHARE_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7000       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **                                                             **         
      **    7010-OPEN-SHARE-CURSOR2                                  **         
      **        THE DRIVING CURSOR IS OPENED.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7010-OPEN-SHARE-CURSOR2.                                         
                                                                        
           EXEC SQL                                                     
             OPEN  SHARE_CSR2                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7010       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T29532*                                                                         
T29532*****************************************************************         
T29532**                                                             **         
T29532**    7050-OPEN-MTH-SHARE-CURSOR                               **         
T29532**        MONTHLY SHARE CURSOR IS OPENED.                      **         
T29532**                                                             **         
T29532*****************************************************************         
T29532*                                                                         
T29532 7050-OPEN-MTH-SHARE-CURSOR.                                      
T29532*                                                                         
T29532     EXEC SQL                                                     
T29532       OPEN  MTH_SHARE_CSR                                        
T29532     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29532*                                                                         
T29532     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T29532*                                                                         
T29532     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T29532         NEXT SENTENCE                                            
T29532     ELSE                                                         
T29532         DISPLAY '****************************************'       
T29532         DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
T29532         DISPLAY '**      ABEND IN PARAGRAPH 7050       **'       
T29532         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
T29532         DISPLAY '****************************************'       
T29532         PERFORM 9900-ABEND                       THRU 9900-EXIT  
T29532     END-IF.                                                      
T29532*                                                                         
T29532 7050-EXIT.                                                       
T29532     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7100-FETCH-SHARE-CURSOR                                  **         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7100-FETCH-SHARE-CURSOR.                                         
T27859******************************************************************        
T27859** T27859 CHANGES TO FETCH VALUES FOR THE NEW CURSOR DECLARED   **        
T27859******************************************************************        
T27859     EXEC SQL                                                     
T27859       FETCH SHARE_CSR                                            
T27859        INTO :GE-AMT-TRAN-ENTRY,                                  
T27859             :GE-GL-CNTRL-DR-CR,                                  
T27859             :GE-COMPANY-NO,                                      
T27859             :GE-LOCAL-OFFICE                                     
T27859     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27859*                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7100       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **                                                             **         
      **    7110-FETCH-SHARE-CURSOR2                                 **         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7110-FETCH-SHARE-CURSOR2.                                        
           EXEC SQL                                                     
             FETCH SHARE_CSR2                                           
              INTO :GE-AMT-TRAN-ENTRY,                                  
                   :GE-GL-CNTRL-DR-CR,                                  
                   :GE-COMPANY-NO,                                      
                   :GE-LOCAL-OFFICE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7110       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
T29532*****************************************************************         
T29532**                                                             **         
T29532**    7150-FETCH-MTH-SHARE-CURSOR                              **         
T29532**        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
T29532**                                                             **         
T29532*****************************************************************         
T29532*                                                                         
T27859*    COMMENTED FOR T27859 CHANGES.                                        
T29532 7150-FETCH-MTH-SHARE-CURSOR.                                     
T29532     EXEC SQL                                                     
T29532       FETCH  MTH_SHARE_CSR                                       
      *      INTO   :PJ-ACCOUNT-NO,                                             
      *             :PJ-MONTHLY-BILL-AM,                                        
      *             :AT-COMPANY-NO,                                             
      *             :AT-PREMISE-NO,                                             
      *             :PR-REV-DISTRICT-CD,                                        
      *             :PR-LOCAL-OFFICE,                                           
T19583       INTO   :AT-CREDIT-GROUP,                                   
T19583              :PJ-SHARE-ENROLL-DT,                                
T19583              :PJ-SHARE-STATUS-CD,                                
T19583              :PJ-ACCT-TERM-DT :IND-TERM-DT,                       
T19583              :PJ-TOT-YTD-AM                                      
T29532     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29532     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T29532*                                                                         
T29532     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T29532         NEXT SENTENCE                                            
T29532     ELSE                                                         
T29532         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T29532            SET MTH-SHARE-CUR      TO TRUE                        
T29532         ELSE                                                     
T29532            DISPLAY '****************************************'    
T29532            DISPLAY '**     PCSRP371 PROCESSING ERROR      **'    
T29532            DISPLAY '**      ABEND IN PARAGRAPH 7150       **'    
T29532            DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE  
T29532            DISPLAY '****************************************'    
T29532            PERFORM 9900-ABEND     THRU 9900-EXIT                 
T29532         END-IF                                                   
T29532     END-IF.                                                      
T29532*                                                                         
T29532 7150-EXIT.                                                       
T29532     EXIT.                                                        
T29532*                                                                         
      *****************************************************************         
      **                                                             **         
      **    7200-CLOSE-SHARE-CURSOR                                  **         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7200-CLOSE-SHARE-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
             CLOSE  SHARE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **                                                             **         
      **    7210-CLOSE-SHARE-CURSOR2                                 **         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7210-CLOSE-SHARE-CURSOR2.                                        
      *                                                                         
           EXEC SQL                                                     
             CLOSE  SHARE_CSR2                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7210       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
T29532*                                                                         
T29532*****************************************************************         
T29532**                                                             **         
T29532**    7250-CLOSE-MTH-SHARE-CURSOR                              **         
T29532**        THE DRIVING CURSOR IS CLOSED.                        **         
T29532**                                                             **         
T29532*****************************************************************         
T29532*                                                                         
T29532 7250-CLOSE-MTH-SHARE-CURSOR.                                     
T29532*                                                                         
T29532     EXEC SQL                                                     
T29532       CLOSE  MTH_SHARE_CSR                                       
T29532     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29532*                                                                         
T29532     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T29532*                                                                         
T29532     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T29532         NEXT SENTENCE                                            
T29532     ELSE                                                         
T29532         DISPLAY '****************************************'       
T29532         DISPLAY '**     PCSRP371 PROCESSING ERROR      **'       
T29532         DISPLAY '**      ABEND IN PARAGRAPH 7250       **'       
T29532         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
T29532         DISPLAY '****************************************'       
T29532         PERFORM 9900-ABEND                       THRU 9900-EXIT  
T29532     END-IF.                                                      
T29532*                                                                         
T29532 7250-EXIT.                                                       
T29532     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7500-SELECT-COMPANY-NAME                                 **         
      **        THE COMPANY NAME IS RETRIEVED FROM CSS_COMPANY BASED **         
      **        ON THE FETCHED COMPANY NUMBER.                       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7500-SELECT-COMPANY-NAME.                                        
      *                                                                         
           EXEC SQL                                                     
             SELECT    COMPANY_NAME                                     
             INTO      :C7-COMPANY-NAME                                 
             FROM      CSS_COMPANY                                      
             WHERE     COMPANY_NO = :C7-COMPANY-NO                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C34828       IF WS-SYSIN-COMP-NO = '26'                                 
C34828        MOVE '             HEATCARE DISTRIBUTION REPORT         ' 
C34828                              TO WS-DEFAULT-RPT1-HEAD1            
C34828       END-IF                                                     
C34828*                                                                         
              MOVE C7-COMPANY-NAME       TO P-RPT1-TITLE                
T19583                                         P-RPT2-TITLE             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE WS-DEFAULT-RPT1-TITLE TO P-RPT1-TITLE            
T19583                                          P-RPT2-TITLE            
                  DISPLAY '******************************************'  
                  DISPLAY '**      PCSRP371 PROCESS WARNING        **'  
                  DISPLAY '**          COMPANY NO. ' C7-COMPANY-NO      
                  DISPLAY '**      NOT FOUND IN CSS_COMPANY        **'  
                  DISPLAY '**   PROCESSING CONTINUES USING THE     **'  
                  DISPLAY '**            DEFAULT HEADER            **'  
                  DISPLAY '******************************************'  
               ELSE                                                     
                  DISPLAY '******************************************'  
                  DISPLAY '**       PCSRP371 PROCESSING ERROR      **'  
                  DISPLAY '**        ABEND IN PARAGRAPH 7500       **'  
                  DISPLAY '**         SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                  DISPLAY '******************************************'  
                  PERFORM 9900-ABEND                    THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7800-GET-LOC-OFF-DESC.                                   **         
      **        THE LOCAL OFFICE DESCRIPTION SELECT FROM CSS_LOCAL_  **         
      **        OFFICE FOR THE CORRESPONDING LOCAL OFFICE.           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7800-GET-LOC-OFF-DESC.                                           
      *                                                                         
           MOVE SPACES TO P-LOCAL-OFFICE.                               
      *                                                                         
           EXEC SQL                                                     
             SELECT    LOCAL_OFFICE_DESC                                
             INTO      :B1-LOCAL-OFFICE-DESC                            
             FROM      CSS_LOCAL_OFFICE                                 
             WHERE     COMPANY_NO   = :B1-COMPANY-NO  AND               
                       LOCAL_OFFICE = :B1-LOCAL-OFFICE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE B1-LOCAL-OFFICE-DESC TO P-LOCAL-OFFICE              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
               MOVE SPACES               TO P-LOCAL-OFFICE              
                  DISPLAY '******************************************'  
                  DISPLAY '**      PCSRP371 PROCESS WARNING        **'  
                  DISPLAY '**          LOCAL OFFICE' B1-LOCAL-OFFICE    
                  DISPLAY '**      NOT FOUND IN CSS_LOCAL_OFFICE   **'  
                  DISPLAY '**   PROCESSING CONTINUES USING SPACES  **'  
                  DISPLAY '**            FOR THE LOCAL OFFICE DESC **'  
                  DISPLAY '******************************************'  
               ELSE                                                     
                  DISPLAY '******************************************'  
                  DISPLAY '**       PCSRP371 PROCESSING ERROR      **'  
                  DISPLAY '**        ABEND IN PARAGRAPH 7800       **'  
                  DISPLAY '**         SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                  DISPLAY '******************************************'  
                  PERFORM 9900-ABEND                    THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7900-GET-REV-DIST-DESC.                                  **         
      **        THE REVENUE DIST DESCRIPTION SELECT FROM CSS_LOCAL_  **         
      **        OFFICE FOR THE CORRESPONDING REVENUE DISTRICT.       **         
      **                                                             **         
      *****************************************************************         
T27859** COMMENTED FOR T27859 CHANGES AS REPORT IS GENERATED FOR JUST**         
T27859** COMPANY AND LOCAL OFFICE WISE.                              **         
T27859*****************************************************************         
      *                                                                         
      *7900-GET-REV-DIST-DESC.                                                  
      *                                                                         
      *    MOVE SPACES TO P-REVENUE-DIST.                                       
      *                                                                         
      *    EXEC SQL                                                             
      *      SELECT    REV_DISTRICT_DESC                                        
      *      INTO      :A9-REV-DISTRICT-DESC                                    
      *      FROM      CSS_REV_DISTRICT                                         
      *      WHERE     REV_DISTRICT_CD = :A9-REV-DISTRICT-CD                    
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *        MOVE A9-REV-DISTRICT-DESC TO P-REVENUE-DIST                      
      *    ELSE                                                                 
      *        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                         
      *           MOVE SPACES               TO P-REVENUE-DIST                   
      *           DISPLAY '******************************************'          
      *           DISPLAY '**      PCSRP371 PROCESS WARNING        **'          
      *           DISPLAY '**     REV DIESTRICT' A9-REV-DISTRICT-CD             
      *           DISPLAY '**      NOT FOUND IN CSS_REV_DISTRICT   **'          
      *           DISPLAY '**   PROCESSING CONTINUES USING SPACES  **'          
      *           DISPLAY '**            FOR THE REV DISTRICT DESC **'          
      *           DISPLAY '******************************************'          
      *        ELSE                                                             
      *           DISPLAY '******************************************'          
      *           DISPLAY '**       PCSRP371 PROCESSING ERROR      **'          
      *           DISPLAY '**        ABEND IN PARAGRAPH 7900       **'          
      *           DISPLAY '**         SQLCODE = ' WS-ACTIVE-RETURN-CODE         
      *           DISPLAY '******************************************'          
      *           PERFORM 9900-ABEND                    THRU 9900-EXIT          
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *7900-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7600-OPEN-REPORT-FILE.                                   **         
      **        OPENS THE OUTPUT FILE AND TESTS FOR FILE STATUS.     **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7600-OPEN-REPORT-FILE.                                           
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
           IF FCSCA32-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7600-PARA ON FCSCA32 OPEN.  STATUS IS '         
                        WS-FCA32-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7600A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7700-REPORT-FILE-WRITE-TEST.                             **         
      **        TESTS WHETHER WRITE TO REPORT FILE SUCCESSFUL OR NOT.**         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7700-REPORT-FILE-WRITE-TEST.                                     
      *                                                                         
           IF FCSCA32-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7700-PARA ON FCSCA32 WRITE. STATUS IS '         
                        WS-FCA32-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING        **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8100-PRINT-RPT1-HEADER                                   **         
      **        PRINTS PROGRAM NAME, COMPANY NAME, AND RUN DATE TO   **         
      **        THE DETAIL REPORT.                                   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8100-PRINT-RPT1-HEADER.                                          
      *                                                                         
           ADD WS-1                      TO WS-RPT1-PAGE-NO.            
           MOVE WS-PGRMNAME              TO P-RPT1-PGNM.                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
               AFTER ADVANCING TOP-OF-PAGE.                             
           PERFORM 7700-REPORT-FILE-WRITE-TEST  THRU 7700-EXIT.         
      *                                                                         
           MOVE ZEROES                   TO WS-RPT1-LINE-NO.            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8200-PRINT-RPT1-TITLE                                    **         
      **        PRINTS DATE, REPORT TITLE, RUN TIME, CURRENT AS OF   **         
      **        DATE AND PAGE NUMBER TO THE DETAIL REPORT.           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8200-PRINT-RPT1-TITLE.                                           
      *                                                                         
T23684     IF CSR-DATABASE                                              
              MOVE WS-DEFAULT-RPT1-HEAD1 TO P-RPT1-HEAD1                
T23684     ELSE                                                         
T23684        IF SEB-DATABASE                                           
T23684           MOVE WS-DEFAULT-RPT1-HEAD1-SEB TO P-RPT1-HEAD1         
T23684        END-IF                                                    
T23684     END-IF                                                       
           MOVE WS-REPORT-HEADER-1       TO P-OUTPUT-LINE.              
           MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO          TO P-RPT1-PAGE-NO.             
           MOVE WS-DEFAULT-RPT1-HEAD2    TO P-RPT1-HEAD2.               
           MOVE WS-REPORT-HEADER-2       TO P-OUTPUT-LINE.              
           MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8300-PRINT-RPT1-COL-HEADERS                              **         
      **        PRINTS THE COLUMN HEADERS TO THE DETAIL REPORT.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8300-PRINT-RPT1-COL-HEADERS.                                     
      *                                                                         
           MOVE WS-COLUMN-HEADER         TO P-OUTPUT-LINE.              
           MOVE WS-3                     TO WS-SKIP-LINES-NUM.          
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
           MOVE WS-BLANK-LINE            TO P-OUTPUT-LINE.              
           MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8400-PRINT-RECORD                                        **         
      **        PRINTING MODULE - PRINTS ALL DETAIL REPORT LINES     **         
      **        FROM THE GENERIC PRINT LINE P-OUTPUT-LINE.           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8400-PRINT-RECORD.                                               
      *                                                                         
           WRITE PRT33-RECORD FROM P-OUTPUT-LINE                        
               AFTER ADVANCING WS-SKIP-LINES-NUM.                       
           PERFORM 7700-REPORT-FILE-WRITE-TEST  THRU 7700-EXIT.         
      *                                                                         
           ADD WS-SKIP-LINES-NUM         TO WS-RPT1-LINE-NO.            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
T19583**    8500-PRINT-SECOND-REPORT                                 **         
T19583**        THIS MODULE PRINTS ALL DETAIL AND TOTAL LINES FOR THE**         
T19583**        PROJECT SHARE/H.E.A.T. MONTHLY SUMMARY REPORT.       **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8500-PRINT-SECOND-REPORT.                                        
T19583*                                                                         
C34828     IF WS-SYSIN-COMP-NO  EQUAL '26'                              
C34828        MOVE '         HEATCARE MONTHLY STATISTICAL SUMMARY     ' 
C34828                          TO WS-DEFAULT-RPT2-HEAD1                
C34828     END-IF.                                                      
C34828                                                                  
C34828     IF WS-SYSIN-COMP-NO = '26'                                   
C34828        MOVE '      PSNC '               TO P-RPT2-TITLE          
C34828     ELSE                                                         
T19583        MOVE C7-COMPANY-NAME             TO P-RPT2-TITLE          
C34828     END-IF.                                                      
                                                                        
T19583     PERFORM 8550-PRINT-RPT2-HEADER      THRU 8550-EXIT.          
T19583     PERFORM 8600-PRINT-RPT2-TITLE       THRU 8600-EXIT.          
T19583     PERFORM 8650-PRINT-RPT2-COL-HEADERS THRU 8650-EXIT.          
T19583     PERFORM 2400-FORMAT-DETAIL-LINE12   THRU 2400-EXIT.          
T19583     PERFORM 2500-FORMAT-TOTAL-LINE12    THRU 2500-EXIT.          
T19583*                                                                         
T19583 8500-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    8550-PRINT-RPT2-HEADER                                   **         
T19583**        PRINTS PROGRAM NAME, COMPANY NAME, AND RUN DATE TO   **         
T19583**        PROJECT SHARE/H.E.A.T. MONTHLY SUMMARY REPORT.       **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8550-PRINT-RPT2-HEADER.                                          
T19583*                                                                         
T19583     ADD WS-1                      TO WS-RPT2-PAGE-NO.            
T19583     MOVE WS-PGRMNAME              TO P-RPT2-PGNM.                
T19583*                                                                         
T19583     WRITE PRT33-RECORD FROM WS-RPT2-TITLE                        
T19583         AFTER ADVANCING TOP-OF-PAGE.                             
T19583     PERFORM 7700-REPORT-FILE-WRITE-TEST  THRU 7700-EXIT.         
T19583*                                                                         
T19583     MOVE ZEROES                   TO WS-RPT2-LINE-NO.            
T19583*                                                                         
T19583 8550-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    8600-PRINT-RPT2-TITLE                                    **         
T19583**        PRINTS DATE, REPORT TITLE, RUN TIME, CURRENT AS OF   **         
T19583**        DATE AND PAGE NUMBER TO THE PROJECT SHARE/H.E.A.T.   **         
T19583**        MONTHLY SUMMARY REPORT.                              **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8600-PRINT-RPT2-TITLE.                                           
T19583*                                                                         
T23684     IF CSR-DATABASE                                              
T19583        MOVE WS-DEFAULT-RPT2-HEAD1 TO P-RPT2-HEAD1                
T23684     ELSE                                                         
T23684        IF SEB-DATABASE                                           
T23684           MOVE WS-DEFAULT-RPT2-HEAD1-SEB TO P-RPT2-HEAD1         
T23684        END-IF                                                    
T23684     END-IF                                                       
T19583     MOVE WS-REPORT-HEADER-21      TO P-OUTPUT-LINE.              
T19583     MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583     MOVE WS-DEFAULT-RPT2-HEAD3    TO P-RPT2-HEAD2.               
T19583     MOVE WS-RPT2-PAGE-NO          TO P-RPT2-PAGE-NO.             
T19583     MOVE WS-REPORT-HEADER-22      TO P-OUTPUT-LINE.              
T19583     MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583 8600-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    8650-PRINT-RPT2-COL-HEADERS                              **         
T19583**        PRINTS THE COLUMN HEADERS TO THE PROJECT SHARE/      **         
T19583**        H.E.A.T. MONTHLY SUMMARY REPORT.                     **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8650-PRINT-RPT2-COL-HEADERS.                                     
T19583*                                                                         
T19583     MOVE WS-COLUMN-HEADER-2A      TO P-OUTPUT-LINE.              
T19583     MOVE WS-4                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583     MOVE WS-COLUMN-HEADER-2B      TO P-OUTPUT-LINE.              
T19583     MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583     MOVE WS-COLUMN-HEADER-2C      TO P-OUTPUT-LINE.              
T19583     MOVE WS-2                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583     MOVE WS-BLANK-LINE            TO P-OUTPUT-LINE.              
T19583     MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
T19583     PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
T19583*                                                                         
T19583 8650-EXIT.                                                       
T19583     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8900-PRINT-RPT1-DETAIL1                                  **         
      **        PRINTS THE REVENUE DISTRICT/LOCAL OFFICE ACTIVITY    **         
      **        SUMMARY LINE TO THE DETAIL REPORT.                   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8900-PRINT-RPT1-DETAIL1.                                         
      *                                                                         
           MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
           MOVE P-DETAIL-LINE1           TO P-OUTPUT-LINE.              
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8950-PRINT-RPT1-DETAIL2                                  **         
      **        PRINT THE COMPANY ACTIVITY SUMMARY LINE TO THE       **         
      **        DETAIL REPORT.                                       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8950-PRINT-RPT1-DETAIL2.                                         
      *                                                                         
           MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
           MOVE P-DETAIL-LINE2           TO P-OUTPUT-LINE.              
           PERFORM 8400-PRINT-RECORD                    THRU 8400-EXIT. 
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
T19583**    8960-PRINT-RPT2-DETAIL12                                 **         
T19583**        PRINTS THE REVENUE DISTRICT/LOCAL OFFICE ACTIVITY    **         
T19583**        SUMMARY LINE TO THE DETAIL REPORT.                   **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8960-PRINT-RPT2-DETAIL12.                                        
T19583*                                                                         
T19583     MOVE WS-1                     TO WS-SKIP-LINES-NUM.          
T19583     MOVE P-DETAIL-LINE12          TO P-OUTPUT-LINE.              
T19583     PERFORM 8400-PRINT-RECORD   THRU 8400-EXIT.                  
T19583*                                                                         
T19583 8960-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    8970-PRINT-RPT2-TOTAL12                                  **         
T19583**        PRINTS THE TOTAL LINE FOR THE PROJECT SHARE/H.E.A.T. **         
T19583**        MONTHLY STATISTICAL SUMMARY REPORT.                  **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8970-PRINT-RPT2-TOTAL12.                                         
T19583*                                                                         
T19583     MOVE WS-3                    TO WS-SKIP-LINES-NUM.           
T19583     MOVE P-TOTAL-LINE12          TO P-OUTPUT-LINE.               
T19583     PERFORM 8400-PRINT-RECORD  THRU 8400-EXIT.                   
T19583*                                                                         
T19583 8970-EXIT.                                                       
T19583     EXIT.                                                        
T19583*                                                                         
T19583*****************************************************************         
T19583**                                                             **         
T19583**    8980-PRINT-RPT2-TOTAL22                                  **         
T19583**        PRINTS THE GRAND TOTAL LINE FOR THE PROJECT SHARE/   **         
T19583**        H.E.A.T. MONTHLY STATISTICAL SUMMARY REPORT.         **         
T19583**                                                             **         
T19583*****************************************************************         
T19583*                                                                         
T19583 8980-PRINT-RPT2-TOTAL22.                                         
T19583*                                                                         
T19583     MOVE WS-3                    TO WS-SKIP-LINES-NUM.           
T19583     MOVE P-TOTAL-LINE22          TO P-OUTPUT-LINE.               
T19583     PERFORM 8400-PRINT-RECORD  THRU 8400-EXIT.                   
T19583*                                                                         
T19583 8980-EXIT.                                                       
T19583     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9000-TERMINATE                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
