       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP365.                                      
COB303 DATE-WRITTEN.     NOV 13, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- MULTIPLE REPORTS FOR STATELINE ACCOUNTS                    --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  11/13/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT031*--                            CSR365 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN TO UT-S-FCSPT331.                                 
           SELECT FCSPT332-FILE                                         
               ASSIGN TO UT-S-FCSPT332.                                 
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 PRT331-RECORD               PIC X(133).                       
      *                                                                         
       FD  FCSPT332-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 PRT332-RECORD               PIC X(133).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP365'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTL_BILL_REL, UR                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTRD_ENVRNMT, MN                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_IDR_ACCT_MTR, L7                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBIDRATM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * ABEND SWITCH COPYBOOK                                       *           
      ***************************************************************           
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ***************************************************************           
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'              *           
      ***************************************************************           
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-COMMON-DATE            PIC X(10) VALUE SPACES.         
           05 WS-RPT1-LINE-CNT          PIC 9(06) VALUE ZEROES.         
           05 WS-RPT2-LINE-CNT          PIC 9(06) VALUE ZEROES.         
           05 WS-RPT1-PAGE-NUM          PIC 9(06) VALUE ZEROES.         
           05 WS-RPT2-PAGE-NUM          PIC 9(06) VALUE ZEROES.         
           05 WS-RUN-TIME               PIC X(08) VALUE SPACES.         
           05 WS-RUN-DATE               PIC X(10) VALUE SPACES.         
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1 REDEFINES WS-SAVE-ACCT.                  
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
           05 WS-ACCT                   PIC X(13) VALUE SPACES.         
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-COMPANY-NO             PIC X(02) VALUE '01'.           
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-RPT1-HDR-EXIST         PIC X(01) VALUE 'Y'.            
           05 WS-RPT2-HDR-EXIST         PIC X(01) VALUE 'Y'.            
           05 WS-RPT1-NO-DATA           PIC X(01) VALUE 'N'.            
           05 WS-RPT2-NO-DATA           PIC X(01) VALUE 'N'.            
           05 WS-RPT1-PAGE-BREAK        PIC X(01) VALUE 'N'.            
           05 WS-RPT2-PAGE-BREAK        PIC X(01) VALUE 'N'.            
           05 WS-PGRMNAME               PIC X(10) VALUE 'PCSRP365'.     
           05 WS-RPT1-NAME              PIC X(11) VALUE 'PCSRP365-01'.  
           05 WS-RPT2-NAME              PIC X(11) VALUE 'PCSRP365-02'.  
           05 WS-RPT1-DESC              PIC X(41)                       
                    VALUE 'STATELINE ACCTS WITH CODE ACCT BILL FIELD'.  
           05 WS-RPT2-DESC              PIC X(42)                       
                    VALUE 'STATELINE ACCOUNTS WITH METER TYPE FIRST'.   
      *                                                                         
      ***************** PCSRP365 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(56) VALUE SPACES.          
               10  RPT-NAME            PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X(38) VALUE SPACES.          
               10  FILLER              PIC X(04) VALUE 'PAGE'.          
               10  RPT-PGNUM           PIC Z(06)9.                      
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  FILLER              PIC X(14) VALUE 'PROGRAM NAME :'.
               10  RPT-PGM-NAME        PIC X(11) VALUE SPACES.          
               10  FILLER              PIC X(24) VALUE SPACES.          
               10  RPT-DESC            PIC X(63) VALUE SPACES.          
               10  FILLER              PIC X(07) VALUE 'DATE : '.       
               10  RPT-DATE            PIC X(10) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER              PIC X(113) VALUE SPACES.         
               10  FILLER              PIC X(07) VALUE 'TIME : '.       
               10  RPT-TIME            PIC X(08) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER              PIC X(133) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-COLUMN-1.                                         
               10  FILLER              PIC X(11) VALUE SPACES.          
               10  FILLER              PIC X(14) VALUE 'ACCOUNT NO DEP'.
               10  FILLER              PIC X(05) VALUE SPACES.          
               10  FILLER              PIC X(16)                        
                                       VALUE 'CODE ACCT BILLED'.        
               10  FILLER              PIC X(06) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'BILL CYCLE'.    
               10  FILLER              PIC X(06) VALUE SPACES.          
               10  FILLER              PIC X(08) VALUE 'METER NO'.      
               10  FILLER              PIC X(06) VALUE SPACES.          
               10  FILLER              PIC X(18)                        
                                       VALUE 'MTR READ SOURCE CD'.      
               10  FILLER              PIC X(05) VALUE SPACES.          
               10  FILLER              PIC X(12) VALUE 'RATE PLAN NO'.  
               10  FILLER              PIC X(16) VALUE SPACES.          
      *                                                                         
           05  WS-RPT-COLUMN-2.                                         
               10  FILLER              PIC X(16) VALUE SPACES.          
               10  FILLER              PIC X(14) VALUE 'ACCOUNT NO DEP'.
               10  FILLER              PIC X(10) VALUE SPACES.          
               10  FILLER              PIC X(08) VALUE 'METER NO'.      
               10  FILLER              PIC X(10) VALUE SPACES.          
               10  FILLER              PIC X(09) VALUE 'BILL DATE'.     
               10  FILLER              PIC X(08) VALUE SPACES.          
               10  FILLER              PIC X(18)                        
                                       VALUE 'LAST REG READ DATE'.      
               10  FILLER              PIC X(07) VALUE SPACES.          
               10  FILLER              PIC X(20)                        
                                       VALUE 'LAST VALID READ DATE'.    
      *                                                                         
           05  WS-RPT-DETAIL-1.                                         
               10  FILLER                   PIC X(10) VALUE SPACES.     
               10  RPT1-ACCOUNT-NO          PIC X(16) VALUE SPACES.     
               10  FILLER                   PIC X(11) VALUE SPACES.     
               10  RPT1-CODE-ACCT-BILLED    PIC X(01) VALUE SPACES.     
               10  FILLER                   PIC X(18) VALUE SPACES.     
               10  RPT1-BILL-CYCLE          PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(10) VALUE SPACES.     
               10  RPT1-METER-NO            PIC X(09) VALUE SPACES.     
               10  FILLER                   PIC X(13) VALUE SPACES.     
               10  RPT1-MTR-READ-SOURCE-CD  PIC X(01) VALUE SPACES.     
               10  FILLER                   PIC X(18) VALUE SPACES.     
               10  RPT1-RATE-PLAN-NO        PIC X(03) VALUE SPACES.     
      *                                                                         
      *                                                                         
           05  WS-RPT-DETAIL-2.                                         
               10  FILLER                   PIC X(15) VALUE SPACES.     
               10  RPT2-ACCOUNT-NO          PIC X(16) VALUE SPACES.     
               10  FILLER                   PIC X(09) VALUE SPACES.     
               10  RPT2-METER-NO            PIC X(09) VALUE SPACES.     
               10  FILLER                   PIC X(09) VALUE SPACES.     
               10  RPT2-BILL-DATE           PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(11) VALUE SPACES.     
               10  RPT2-LAST-REG-READ-DT    PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(16) VALUE SPACES.     
               10  RPT2-LAST-VALID-READ-DT  PIC X(10) VALUE SPACES.     
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                       PIC X(55) VALUE SPACES.     
           05  FILLER                       PIC X(22) VALUE             
                     '*** END OF REPORT ***'.                           
           05  FILLER                       PIC X(55) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      * THIS PROGRAM HAS 2 CURSORS FETCHING DETAILS FOR 2 REPORTS      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE BASE_CSR1 CURSOR FOR                              
                 SELECT                                                 
                     UR.ACCOUNT_NO_DEP,                                 
                     AT.CODE_ACCT_BILLED,                               
                     AT.BILL_CYCLE,                                     
                     MN.METER_NO,                                       
                     MN.MTR_READ_SOURCE_CD,                             
                     UT.RATE_PLAN_NO                                    
                 FROM                                                   
                     CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED),                 
                     CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                 
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                 WHERE UR.ACCOUNT_NO_MST    = 9210045006892             
                   AND AT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP         
                   AND MN.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP         
                   AND UR.DEP_REL_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )      
                   AND UR.DEP_REL_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )        
                   AND MN.CODE_UTIL_TYPE    = 'E'                       
                   AND UT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP         
                   AND UT.CODE_UTIL_TYPE    = 'E'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BASE_CSR1 CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*              UR.ACCOUNT_NO_DEP,                                         
MFA-TR*              AT.CODE_ACCT_BILLED,                                       
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              MN.METER_NO,                                               
MFA-TR*              MN.MTR_READ_SOURCE_CD,                                     
MFA-TR*              UT.RATE_PLAN_NO                                            
MFA-TR*          FROM                                                           
MFA-TR*              CSS_UTL_BILL_REL UR,                                       
MFA-TR*              CSS_MTRD_ENVRNMT MN,                                       
MFA-TR*              CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_UTIL_ENVRNMT UT                                        
MFA-TR*          WHERE UR.ACCOUNT_NO_MST    = 9210045006892                     
MFA-TR*            AND AT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP                 
MFA-TR*            AND MN.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP                 
MFA-TR*            AND UR.DEP_REL_START_DT <= :UR-DEP-REL-START-DT              
MFA-TR*            AND UR.DEP_REL_END_DT   >= :UR-DEP-REL-END-DT                
MFA-TR*            AND MN.CODE_UTIL_TYPE    = 'E'                               
MFA-TR*            AND UT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP                 
MFA-TR*            AND UT.CODE_UTIL_TYPE    = 'E'                               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE BASE_CSR2 CURSOR FOR                              
                 SELECT                                                 
                     UR.ACCOUNT_NO_DEP,                                 
                     MN.METER_NO,                                       
                     AT.DATE_BILL_DAY_00,                               
                     MN.LAST_REG_READ_DATE,                             
                     MN.LAST_VALID_READ_DT                              
                 FROM                                                   
                     CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED),                 
                     CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                 
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                 WHERE UR.ACCOUNT_NO_MST    = 9210045006892             
                   AND AT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP         
                   AND MN.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP         
                   AND MN.CODE_UTIL_TYPE    = 'E'                       
                   AND UR.DEP_REL_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )      
                   AND UR.DEP_REL_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BASE_CSR2 CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*              UR.ACCOUNT_NO_DEP,                                         
MFA-TR*              MN.METER_NO,                                               
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              MN.LAST_REG_READ_DATE,                                     
MFA-TR*              MN.LAST_VALID_READ_DT                                      
MFA-TR*          FROM                                                           
MFA-TR*              CSS_UTL_BILL_REL UR,                                       
MFA-TR*              CSS_MTRD_ENVRNMT MN,                                       
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*          WHERE UR.ACCOUNT_NO_MST    = 9210045006892                     
MFA-TR*            AND AT.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP                 
MFA-TR*            AND MN.ACCOUNT_NO        = UR.ACCOUNT_NO_DEP                 
MFA-TR*            AND MN.CODE_UTIL_TYPE    = 'E'                               
MFA-TR*            AND UR.DEP_REL_START_DT <= :UR-DEP-REL-START-DT              
MFA-TR*            AND UR.DEP_REL_END_DT   >= :UR-DEP-REL-END-DT                
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 1000-PROCESS-CSR              THRU  1000-EXIT.       
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
           OPEN OUTPUT FCSPT332-FILE.                                   
      *                                                                         
           PERFORM 0200-GET-COMMON-DATE          THRU  0200-EXIT.       
           PERFORM 7100-GET-COMPANY-NAME         THRU  7100-EXIT.       
           MOVE C7-COMPANY-NAME           TO RPT-NAME.                  
      *                                                                         
           PERFORM 7000-GET-CURR-DT-TIME         THRU 7000-EXIT.        
           MOVE WS-RUN-TIME               TO RPT-TIME.                  
           MOVE WS-RUN-DATE               TO RPT-DATE.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 0200-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       0200-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
           MOVE 'COMMONDATE'              TO WS-PGRMNAME.               
           MOVE 'CA00'                    TO WS-COMMAND                 
                                             WS-DATE.                   
           MOVE WS-COMPANY-NO             TO G6-COMPANY-NO.             
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE G6-PARM-DATA(1:10)        TO WS-COMMON-DATE.            
           MOVE WS-COMMON-DATE            TO UR-DEP-REL-START-DT        
                                             UR-DEP-REL-END-DT.         
           MOVE '01'                      TO UR-DEP-REL-START-DT(9:2).  
           MOVE '28'                      TO UR-DEP-REL-END-DT(9:2).    
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-CSR                                             **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-CSR.                                                
      *                                                                         
           PERFORM 1100-PROCESS-CSR1                THRU 1100-EXIT.     
           PERFORM 1200-PROCESS-CSR2                THRU 1200-EXIT.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-PROCESS-CSR1                                            **        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-CSR1.                                               
      *                                                                         
      *****PROCESS 1ST CUSRSOR                                                  
           PERFORM 7150-OPEN-BASE-CSR1              THRU  7150-EXIT.    
           PERFORM 7200-FETCH-BASE-CSR1             THRU  7200-EXIT.    
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-Y                   TO WS-RPT1-NO-DATA            
           END-IF.                                                      
           PERFORM 2000-PROCESS-BASE-CSR1           THRU  2000-EXIT     
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7250-CLOSE-BASE-CSR1             THRU 7250-EXIT.     
           PERFORM 2910-WRITE-TRLR                  THRU  2910-EXIT.    
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-PROCESS-CSR2                                            **        
      ******************************************************************        
      *                                                                         
       1200-PROCESS-CSR2.                                               
      *                                                                         
      *****PROCESS 2ND CUSRSOR                                                  
           PERFORM 7300-OPEN-BASE-CSR2              THRU  7300-EXIT.    
           PERFORM 7350-FETCH-BASE-CSR2             THRU  7350-EXIT.    
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-Y                   TO WS-RPT2-NO-DATA            
           END-IF.                                                      
           PERFORM 2250-PROCESS-BASE-CSR2           THRU  2250-EXIT     
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7400-CLOSE-BASE-CSR2             THRU 7400-EXIT.     
           PERFORM 2920-WRITE-TRLR                  THRU  2920-EXIT.    
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-BASE-CSR1.                                      **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-BASE-CSR1.                                          
      *                                                                         
           MOVE WS-RPT1-NAME              TO RPT-PGM-NAME.              
           MOVE WS-RPT1-DESC              TO RPT-DESC.                  
           PERFORM 2050-RPT1-WRITE-HEADER        THRU 2050-EXIT.        
           PERFORM 2100-RPT1-WRITE-DETAIL        THRU 2100-EXIT.        
           PERFORM 7200-FETCH-BASE-CSR1          THRU 7200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2050-RPT1-WRITE-HEADER.                                      **        
      ******************************************************************        
      *                                                                         
       2050-RPT1-WRITE-HEADER.                                          
      *                                                                         
           IF WS-RPT1-HDR-EXIST EQUAL WS-Y  OR                          
              WS-RPT1-LINE-CNT GREATER THAN 54                          
              MOVE WS-Y                   TO WS-RPT1-PAGE-BREAK         
              MOVE ZEROES                 TO WS-RPT1-LINE-CNT           
              MOVE WS-N                   TO WS-RPT1-HDR-EXIST          
              ADD +1                      TO WS-RPT1-PAGE-NUM           
              MOVE WS-RPT1-PAGE-NUM       TO RPT-PGNUM                  
              MOVE WS-RPT-HEADER-1        TO PRT331-RECORD              
              PERFORM 8100A-WRITE-FCSPT331       THRU 8100A-EXIT        
              MOVE WS-RPT-HEADER-2        TO PRT331-RECORD              
              PERFORM 8000A-WRITE-FCSPT331       THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-3        TO PRT331-RECORD              
              PERFORM 8000A-WRITE-FCSPT331       THRU 8000A-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT331-RECORD              
              PERFORM 8200A-WRITE-FCSPT331       THRU 8200A-EXIT        
              MOVE WS-RPT-COLUMN-1        TO PRT331-RECORD              
              PERFORM 8000A-WRITE-FCSPT331       THRU 8000A-EXIT        
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-RPT1-WRITE-DETAIL.                                      **        
      ******************************************************************        
      *                                                                         
       2100-RPT1-WRITE-DETAIL.                                          
      *                                                                         
           MOVE UR-ACCOUNT-NO-DEP         TO WS-SAVE-ACCT.              
           MOVE WS-SAVE-ACCT1             TO WS-ACCT1.                  
           MOVE WS-SAVE-ACCT2             TO WS-ACCT2.                  
           MOVE WS-SAVE-ACCT3             TO WS-ACCT3.                  
           MOVE WS-SAVE-ACCT4             TO WS-ACCT4.                  
           MOVE WS-ACCOUNT1               TO RPT1-ACCOUNT-NO.           
           MOVE AT-CODE-ACCT-BILLED       TO RPT1-CODE-ACCT-BILLED.     
           MOVE AT-BILL-CYCLE             TO RPT1-BILL-CYCLE.           
           MOVE MN-METER-NO               TO RPT1-METER-NO.             
           MOVE MN-MTR-READ-SOURCE-CD     TO RPT1-MTR-READ-SOURCE-CD.   
           MOVE UT-RATE-PLAN-NO           TO RPT1-RATE-PLAN-NO.         
           MOVE WS-RPT-DETAIL-1           TO PRT331-RECORD.             
           IF WS-RPT1-PAGE-BREAK EQUAL WS-Y                             
              PERFORM 8300A-WRITE-FCSPT331       THRU 8300A-EXIT        
              MOVE WS-N                   TO WS-RPT1-PAGE-BREAK         
           ELSE                                                         
              PERFORM 8000A-WRITE-FCSPT331       THRU 8000A-EXIT        
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2250-PROCESS-BASE-CSR2.                                      **        
      ******************************************************************        
      *                                                                         
       2250-PROCESS-BASE-CSR2.                                          
      *                                                                         
           MOVE WS-RPT2-NAME              TO RPT-PGM-NAME.              
           MOVE WS-RPT2-DESC              TO RPT-DESC.                  
           PERFORM 2300-WRITE-RPT2-HEADER        THRU 2300-EXIT.        
           PERFORM 2350-WRITE-RPT2-DETAIL        THRU 2350-EXIT.        
           PERFORM 7350-FETCH-BASE-CSR2          THRU 7350-EXIT.        
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-WRITE-RPT2-HEADER.                                      **        
      ******************************************************************        
      *                                                                         
       2300-WRITE-RPT2-HEADER.                                          
      *                                                                         
           IF WS-RPT2-HDR-EXIST EQUAL WS-Y  OR                          
              WS-RPT2-LINE-CNT GREATER THAN 54                          
              MOVE WS-Y                   TO WS-RPT2-PAGE-BREAK         
              MOVE ZEROES                 TO WS-RPT2-LINE-CNT           
              MOVE WS-N                   TO WS-RPT2-HDR-EXIST          
              ADD +1                      TO WS-RPT2-PAGE-NUM           
              MOVE WS-RPT2-PAGE-NUM       TO RPT-PGNUM                  
              MOVE WS-RPT-HEADER-1        TO PRT332-RECORD              
              PERFORM 8100F-WRITE-FCSPT332       THRU 8100F-EXIT        
              MOVE WS-RPT-HEADER-2        TO PRT332-RECORD              
              PERFORM 8000F-WRITE-FCSPT332       THRU 8000F-EXIT        
              MOVE WS-RPT-HEADER-3        TO PRT332-RECORD              
              PERFORM 8000F-WRITE-FCSPT332       THRU 8000F-EXIT        
              MOVE WS-RPT-HEADER-4        TO PRT332-RECORD              
              PERFORM 8200F-WRITE-FCSPT332       THRU 8200F-EXIT        
              MOVE WS-RPT-COLUMN-2        TO PRT332-RECORD              
              PERFORM 8000F-WRITE-FCSPT332       THRU 8000F-EXIT        
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2350-WRITE-RPT2-DETAIL                                       **        
      ******************************************************************        
      *                                                                         
       2350-WRITE-RPT2-DETAIL.                                          
      *                                                                         
           MOVE UR-ACCOUNT-NO-DEP         TO WS-SAVE-ACCT.              
           MOVE WS-SAVE-ACCT1             TO WS-ACCT1.                  
           MOVE WS-SAVE-ACCT2             TO WS-ACCT2.                  
           MOVE WS-SAVE-ACCT3             TO WS-ACCT3.                  
           MOVE WS-SAVE-ACCT4             TO WS-ACCT4.                  
           MOVE WS-ACCOUNT1               TO RPT2-ACCOUNT-NO.           
           MOVE MN-METER-NO               TO RPT2-METER-NO.             
           MOVE AT-DATE-BILL-DAY-00       TO RPT2-BILL-DATE.            
           MOVE MN-LAST-REG-READ-DATE     TO RPT2-LAST-REG-READ-DT.     
           MOVE MN-LAST-VALID-READ-DT     TO RPT2-LAST-VALID-READ-DT.   
           MOVE WS-RPT-DETAIL-2           TO PRT332-RECORD.             
           IF WS-RPT2-PAGE-BREAK EQUAL WS-Y                             
              PERFORM 8300F-WRITE-FCSPT332       THRU 8300F-EXIT        
              MOVE WS-N                   TO WS-RPT2-PAGE-BREAK         
           ELSE                                                         
              PERFORM 8000F-WRITE-FCSPT332       THRU 8000F-EXIT        
           END-IF.                                                      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2910-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2910-WRITE-TRLR.                                                 
      *                                                                         
           IF WS-RPT1-NO-DATA EQUAL WS-N                                
              MOVE SPACES                    TO PRT331-RECORD           
              PERFORM 8000A-WRITE-FCSPT331      THRU 8000A-EXIT         
              MOVE SPACES                    TO PRT331-RECORD           
              PERFORM 8000A-WRITE-FCSPT331      THRU 8000A-EXIT         
              MOVE WS-END-DATA               TO PRT331-RECORD           
              PERFORM 8000A-WRITE-FCSPT331      THRU 8000A-EXIT         
              MOVE SPACES                    TO WS-RPT1-NO-DATA         
           END-IF.                                                      
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2920-WRITE-TRLR.                                               *        
      ******************************************************************        
      *                                                                         
       2920-WRITE-TRLR.                                                 
      *                                                                         
           IF WS-RPT2-NO-DATA EQUAL WS-N                                
              MOVE SPACES                    TO PRT332-RECORD           
              PERFORM 8000F-WRITE-FCSPT332      THRU 8000F-EXIT         
              MOVE SPACES                    TO PRT332-RECORD           
              PERFORM 8000F-WRITE-FCSPT332      THRU 8000F-EXIT         
              MOVE WS-END-DATA               TO PRT332-RECORD           
              PERFORM 8000F-WRITE-FCSPT332      THRU 8000F-EXIT         
              MOVE SPACES                    TO WS-RPT2-NO-DATA         
           END-IF.                                                      
      *                                                                         
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7000-GET-CURR-DT-TIME                                  **              
      ************************************************************              
      *                                                                         
       7000-GET-CURR-DT-TIME.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CIS.CHAR2$TIME(CIS.CURRENT$TIME(),'USA'),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-RUN-TIME,
              :WS-RUN-DATE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RUN-TIME = CHAR(CURRENT TIME,USA)                       
MFA-TR*            ,:WS-RUN-DATE = CHAR(CURRENT DATE,USA)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT *****'                   
              DISPLAY '**  7000-GET-CURR-DT-TIME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7100-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = '01'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT *****'                   
              DISPLAY '**  7100-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-OPEN-BASE-CSR1.                                           *        
      ******************************************************************        
      *                                                                         
       7150-OPEN-BASE-CSR1.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN BASE_CSR1                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7150-OPEN-BASE-CSR1     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-BASE-CSR1                                           *        
      ******************************************************************        
      *                                                                         
       7200-FETCH-BASE-CSR1.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH BASE_CSR1                                           
               INTO :UR-ACCOUNT-NO-DEP                                  
                   ,:AT-CODE-ACCT-BILLED                                
                   ,:AT-BILL-CYCLE                                      
                   ,:MN-METER-NO                                        
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:UT-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7200-FETCH-BASE-CSR1    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  UR.DEP_REL_START_DT ' UR-DEP-REL-START-DT    
              DISPLAY '**  UR.DEP_REL_END_DT   ' UR-DEP-REL-END-DT      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-CLOSE-BASE-CSR1.                                          *        
      ******************************************************************        
      *                                                                         
       7250-CLOSE-BASE-CSR1.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE BASE_CSR1                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7250-CLOSE-BASE-CSR1    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-BASE-CSR2.                                           *        
      ******************************************************************        
      *                                                                         
       7300-OPEN-BASE-CSR2.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN BASE_CSR2                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7300-OPEN-BASE-CSR2     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7350-FETCH-BASE-CSR2                                           *        
      ******************************************************************        
      *                                                                         
       7350-FETCH-BASE-CSR2.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH BASE_CSR2                                           
               INTO :UR-ACCOUNT-NO-DEP                                  
                   ,:MN-METER-NO                                        
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:MN-LAST-REG-READ-DATE                              
                   ,:MN-LAST-VALID-READ-DT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7350-FETCH-BASE-CSR2    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  UR.DEP_REL_START_DT ' UR-DEP-REL-START-DT    
              DISPLAY '**  UR.DEP_REL_END_DT   ' UR-DEP-REL-END-DT      
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-CLOSE-BASE-CSR2.                                          *        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-BASE-CSR2.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE BASE_CSR2                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP365 ABORT ******'                  
              DISPLAY '**  7400-CLOSE-BASE-CSR2    **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000A-WRITE-FCSPT331.                                        **        
      ******************************************************************        
      *                                                                         
       8000A-WRITE-FCSPT331.                                            
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100A-WRITE-FCSPT331.                                       **         
      ******************************************************************        
      *                                                                         
       8100A-WRITE-FCSPT331.                                            
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200A-WRITE-FCSPT331.                                        **        
      ******************************************************************        
      *                                                                         
       8200A-WRITE-FCSPT331.                                            
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8200A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300A-WRITE-FCSPT331.                                        **        
      ******************************************************************        
      *                                                                         
       8300A-WRITE-FCSPT331.                                            
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8300A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000F-WRITE-FCSPT332.                                        **        
      ******************************************************************        
      *                                                                         
       8000F-WRITE-FCSPT332.                                            
      *                                                                         
           WRITE PRT332-RECORD.                                         
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8000F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100F-WRITE-FCSPT332.                                       **         
      ******************************************************************        
      *                                                                         
       8100F-WRITE-FCSPT332.                                            
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8100F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200F-WRITE-FCSPT332                                         **        
      ******************************************************************        
      *                                                                         
       8200F-WRITE-FCSPT332.                                            
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8200F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300F-WRITE-FCSPT332                                         **        
      ******************************************************************        
      *                                                                         
       8300F-WRITE-FCSPT332.                                            
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8300F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
           CLOSE FCSPT332-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
