       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP346.                                        
       DATE-WRITTEN.                                                    
       DATE-COMPILED.                                                   
      *****************************************************************         
      *              M O D U L E   I N F O R M A T I O N              *         
      *                                                               *         
      *  MODULE NAME:  PCSRP346                                       *         
      *                                                               *         
      *  MODULE DESC:  CREATES 2 MISMATCH REPORTS FOR SEB REGULATED   *         
      *                1) DETAIL REPORT                               *         
      *                2) SUMMARY REPORT                              *         
      *                                                               *         
      *  LANGUAGE   :  COBOL II / DB2                                 *         
      *                                                               *         
      *****************************************************************         
      *               M A I N T E N A N C E   L O G                   *         
      *                                                               *         
      *  TPR   |PROGRAMMER|            |                              *         
      * NUMBER | USER-ID  |    DATE    |         DESCRIPTION          *         
      *---------------------------------------------------------------*         
      *        |          |            |                              *         
      * 26975  | D PRUET  | 2002-09-12 | INITIAL CODING               *         
      * 27679  | CB18344  | 2002-12-30 | REMOVED FINAL BILL AND WRITE *         
      *        |          |            | OFF STATUS ACCOUNTS FROM RPTS*         
      *        |          |            |                              *         
      * 28462  | VIJAY    | 2003-02-21 | FIX ERRORS IN MESSAGES.      *         
      * 29493  | COVANSYS | 2003-10-15 | FIX SEBP GROUP CODE/MISMATCH *         
      *        |          |            | REPORT ERRORS                *         
      * 35434  | MK92804  | 2007-05-15 | REPLACED MODEL_SQL WITH SET  *         
      * 35434  |          |            | STATEMENT                    *         
C35671* 09/27/07   CVNS       NAME AND ADDRESS FORMAT CHANGES         *         
C35671*            CHENNAI                                            *         
      *****************************************************************         
      *                   M O D U L E   F L O W                       *         
      *                                                               *         
      *   PARAGRAPH                                                   *         
      *  FROM - THRU     DESCRIPTION                                  *         
      *  -----------------------------------------------------------  *         
      *  0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION         *         
      *  1000 - 2999     MAJOR PROCESSING LOOP                        *         
      *  3000 - 3999     COMMON PROCESSING                            *         
      *  4000 - 4999     NAME/ADDRESS PROCESSING                      *         
      *  5000 - 5999     OUTPUT TO FILES / REPORTS                    *         
      *  6000 - 6999     REDUCE EMBEDDED SPACES PROCESSING            *         
      *  7000 - 7999     INQUIRY CALLS TO INPUT FILES / DATABASE      *         
      *  8000 - 8999     UPDATE CALLS TO DATABASE                     *         
      *  9000 - 9999     TERMINATION ROUTINES                         *         
      *                                                               *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *          E N V I R O N M E N T   D I V I S I O N              *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
                                                                        
      *****************************************************************         
      *  C O N F I G U R A T I O N   S E C T I O N                    *         
      *****************************************************************         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
                                                                        
      *****************************************************************         
      *  I N P U T - O U T P U T   S E C T I O N                      *         
      *****************************************************************         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *****                                                                     
      *  DETAIL REPORT                                                          
      *****                                                                     
           SELECT FCRP3461-FILE                                         
               ASSIGN UT-S-FCRP3461.                                    
                                                                        
      *****************************************************************         
      *                    D A T A   D I V I S I O N                  *         
      *****************************************************************         
       DATA DIVISION.                                                   
                                                                        
      *****************************************************************         
      *  F I L E   S E C T I O N                                      *         
      *****************************************************************         
       FILE SECTION.                                                    
                                                                        
      *****                                                                     
      *  DETAIL REPORT                                                          
      *****                                                                     
       FD  FCRP3461-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT3461-RECORD.                                              
           05  PRT3461-CC                PIC X(01).                     
           05  PRT3461-DATA              PIC X(132).                    
      *                                                                         
      *****************************************************************         
      *  W O R K I N G - S T O R A G E   S E C T I O N                *         
      *****************************************************************         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP346'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****                                                                     
      *  START OF WORKING STORAGE                                               
      *****                                                                     
      *                                                                         
       01  WS00-START                    PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP346 STARTS HERE'.                  
      *                                                                         
      *****                                                                     
      *  CONSTANTS AND SWITCHES                                                 
      *****                                                                     
      *                                                                         
       01  WS01-CONSTANTS-AND-SWITCHES.                                 
           05  WS-LO-GROUP1            PIC X(3) VALUE '600'.            
           05  WS-HI-GROUP1            PIC X(3) VALUE '660'.            
           05  WS-GROUP1               PIC X(3) VALUE '100'.            
           05  WS-LO-GROUP2            PIC X(3) VALUE '670'.            
           05  WS-HI-GROUP2            PIC X(3) VALUE '700'.            
           05  WS-GROUP2               PIC X(3) VALUE '200'.            
           05  WS-Y                    PIC X    VALUE 'Y'.              
           05  WS-N                    PIC X    VALUE 'N'.              
           05  PROGRAM-NAME            PIC X(8) VALUE 'PCSRP346'.       
           05  WS-DATA-FOUND           PIC X    VALUE 'N'.              
      *                                                                         
      *****                                                                     
      *  TITLES AND HEADERS                                                     
      *****                                                                     
      *                                                                         
       01  WS02-TITLES-AND-HEADERS.                                     
           05  WS02-TITLES.                                             
               10  WS02-TITLE1.                                         
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  WS02-TITLE1-REPTNAME  PIC X(17).                 
                   15  FILLER                PIC X(34) VALUE SPACES.    
                   15  FILLER                PIC X(31) VALUE            
                       'SCANA ENERGY REGULATED DIVISION'.               
                   15  FILLER                PIC X(30) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'RUN-DATE: '.                              
                   15  WS02-TITLE1-RUN-DT    PIC X(10).                 
               10  WS02-TITLE2.                                         
                   15  FILLER                PIC X(52) VALUE SPACES.    
                   15  FILLER                PIC X(30) VALUE            
                       'RATE DOES NOT MATCH GROUP CODE'.                
                   15  FILLER                PIC X(30) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'RUN-TIME:   '.                            
                   15  WS02-TITLE2-RUN-TM    PIC X(08).                 
                   15  FILLER                PIC X     VALUE SPACES.    
               10  WS02-TITLE3D.                                        
                   15  FILLER                PIC X(54) VALUE SPACES.    
                   15  FILLER                PIC X(19)                  
                       VALUE 'DAILY DETAIL AS OF '.                     
                   15  WS02-TITLE3D-DATE     PIC X(10).                 
                   15  FILLER                PIC X(34) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'PAGE:     '.                              
                   15  WS02-TITLE3D-PAGE-NBR  PIC ZZ,ZZ9.               
      *                                                                         
       01  WS02-HEADER1-DETAIL.                                         
           05  FILLER         PIC X(7)  VALUE SPACES.                   
           05  FILLER         PIC X(10) VALUE 'ACCOUNT NO'.             
           05  FILLER         PIC X(12) VALUE SPACES.                   
           05  FILLER         PIC X(13) VALUE 'CUSTOMER NAME'.          
           05  FILLER         PIC X(14) VALUE SPACES.                   
           05  FILLER         PIC X(4)  VALUE 'RATE'.                   
           05  FILLER         PIC X(5)  VALUE SPACES.                   
           05  FILLER         PIC X(10) VALUE 'GROUP CODE'.             
           05  FILLER         PIC X(58) VALUE SPACES.                   
      *                                                                         
      *****                                                                     
      *  DETAIL LINES                                                           
      *****                                                                     
      *                                                                         
       01  WS03-DET-DETAIL-LINE1.                                       
           15  FILLER                    PIC X(4)  VALUE SPACES.        
           15  WS03-DET-ACCOUNT-NO       PIC X(16).                     
           15  FILLER                    PIC X(4)  VALUE SPACES.        
           15  WS03-DET-CUST-NAME        PIC X(27).                     
           15  FILLER                    PIC X(4)  VALUE SPACES.        
           15  WS03-DET-RATE-PLAN        PIC X(3).                      
           15  FILLER                    PIC X(9)  VALUE SPACES.        
           15  WS03-DET-GROUP-CODE       PIC X(3).                      
           15  FILLER                    PIC X(48) VALUE SPACES.        
      *                                                                         
       01  WS03-BLANK-LINE               PIC X(133) VALUE SPACES.       
      *                                                                         
       01  WS03-NO-FILE-LINE.                                           
           05  FILLER                    PIC X(56) VALUE SPACES.        
           05  FILLER                    PIC X(25)                      
               VALUE '*** NO FILE RECEIVED *** '.                       
           05  FILLER                    PIC X(52) VALUE SPACES.        
      *                                                                         
       01  WS03-NO-DATA-LINE.                                           
           05  FILLER                    PIC X(56) VALUE SPACES.        
           05  FILLER                    PIC X(25)                      
               VALUE '*** NO DATA RECEIVED *** '.                       
           05  FILLER                    PIC X(52) VALUE SPACES.        
      *                                                                         
       01  WS03-END-DATA-LINE.                                          
           05  FILLER                    PIC X(56) VALUE SPACES.        
           05  FILLER                    PIC X(22)                      
               VALUE '*** END OF REPORT *** '.                          
           05  FILLER                    PIC X(55) VALUE SPACES.        
      *                                                                         
      *****                                                                     
      *  DATES, TIMES AND TIMESTAMPS                                            
      *****                                                                     
      *                                                                         
       01  WS04-DATE-TIME-STAMPS.                                       
           05  WS04-LAST-BILL-MTH          PIC X(06).                   
           05  WS04-CURRENT-TS             PIC X(26).                   
           05  WS04-CURRENT-TS-BREAKDOWN   REDEFINES WS04-CURRENT-TS.   
               10  WS04-CURRENT-DATE.                                   
                   15  WS04-CURRENT-YEAR   PIC X(04).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MONTH  PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-DAY    PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS04-CURRENT-TIME.                                   
                   15  WS04-CURRENT-HOUR   PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MIN    PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-SEC    PIC X(02).                   
                   15  FILLER              PIC X(01).                   
                   15  WS04-CURRENT-MSEC   PIC X(06).                   
      *                                                                         
      *****                                                                     
      *  PCSRP346 REPORT WORK AREA                                              
      *****                                                                     
      *                                                                         
       01  WS05-WORK-AREA.                                              
           05  WS-ACCOUNT-NO-LR              PIC 9(13).                 
C35671*    05  WS-FULL-NAME-27               PIC X(50).                         
C35671     05  WS-FULL-NAME-27               PIC X(70).                 
           05  WS-GROUP-CODE                 PIC X(06).                 
           05  WS-CREDIT-GROUP               PIC X(13).                 
           05  WS-CODE-ACCT-STAT             PIC X(12).                 
           05  WS-RATE-PLAN-NO               PIC X(03).                 
           05  WS-RATE-PLAN-NO-NULL          PIC S9(04) COMP VALUE 0.   
           05  WS-PGRMNAME                   PIC X(08).                 
           05  WS-INPUT-DATE                 PIC X(10).                 
           05  WS05-HOLD-AREA                PIC X(133).                
           05  WS05-PAGE-COUNTERS.                                      
               10  WS05-REPORT1-PAGE-NBR     PIC 9(05).                 
       01  WS05-LINE-COUNTERS.                                          
           05  WS05-REPORT1-LINE-CTR     PIC 9(05) VALUE 65.            
      *                                                                         
      *****                                                                     
      *  REPORT INFO VARIABLES                                                  
      *****                                                                     
      *                                                                         
      *****                                                                     
      *  INTERNAL TABLES                                                        
      *****                                                                     
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE +0.        
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  RS-ACCT-XFER-TO         PIC X(13)  VALUE SPACES.         
           05  RS-ITEM-ID              PIC S9(09) COMP VALUE +0.        
      *                                                                         
      *****                                                                     
      *  COPYBOOK FOR ERROR HANDLING                                            
      *****                                                                     
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      *****                                                                     
      *  COPYBOOK FOR ABEND SWITCH                                              
      *****                                                                     
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      *****                                                                     
      *  COPYBOOK FOR DATE CHECK                                                
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE FIOJC01                                                    
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  WORKING STORAGE FOR REDUCING EMBEDDED SPACES                           
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00011                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  WORKING STORAGE FOR JOB PARM INFORMATION                               
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                               
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00074                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  COPYBOOK FOR DB2/SQL ERROR HANDLING                                    
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00303                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  SQLCA                                                                  
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_JOB_PARM                                                           
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_ACCOUNT                                                            
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_UTIL_ENVRNMT                                                       
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_NAME                                                               
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_RATE_PLAN_DESC                                                     
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_CUSTOMER                                                           
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_REG_PROFILE                                                        
      *****                                                                     
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CURSOR FOR REPORT DATA                                               
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE ACCT-CSR   CURSOR FOR                             
              SELECT AT.ACCOUNT_NO,                                     
                     DQ.FULL_NAME,                                      
                     UT.RATE_PLAN_NO,                                   
                     LR.REG_GROUP_CD                                    
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
                     CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED),               
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
               WHERE AT.ACCOUNT_NO     = LR.ACCOUNT_NO                  
                 AND AT.CODE_ACCT_STAT = 'A'                            
                 AND AT.ACCOUNT_NO     = UT.ACCOUNT_NO                  
                 AND AT.PREMISE_NO     = UT.PREMISE_NO                  
                 AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                 
                 AND CU.NAME_ID        = DQ.NAME_ID                     
                 AND UT.CODE_UTIL_TYPE = 'G'                            
                 AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                
                 AND ((UT.RATE_PLAN_NO BETWEEN :WS-LO-GROUP1            
                                           AND :WS-HI-GROUP1            
                 AND RD.REG_GROUP_CD <> LR.REG_GROUP_CD)                
                 OR  (UT.RATE_PLAN_NO   BETWEEN :WS-LO-GROUP2           
                                           AND  :WS-HI-GROUP2           
                 AND RD.REG_GROUP_CD <> LR.REG_GROUP_CD))               
               ORDER BY AT.ACCOUNT_NO                                   
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CSR   CURSOR FOR                                     
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              DQ.FULL_NAME,                                              
MFA-TR*              UT.RATE_PLAN_NO,                                           
MFA-TR*              LR.REG_GROUP_CD                                            
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_RATE_PLAN_DESC RD,                                     
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE AT.ACCOUNT_NO     = LR.ACCOUNT_NO                          
MFA-TR*          AND AT.CODE_ACCT_STAT = 'A'                                    
MFA-TR*          AND AT.ACCOUNT_NO     = UT.ACCOUNT_NO                          
MFA-TR*          AND AT.PREMISE_NO     = UT.PREMISE_NO                          
MFA-TR*          AND AT.CUSTOMER_NO    = CU.CUSTOMER_NO                         
MFA-TR*          AND CU.NAME_ID        = DQ.NAME_ID                             
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                        
MFA-TR*          AND ((UT.RATE_PLAN_NO BETWEEN :WS-LO-GROUP1                    
MFA-TR*                                    AND :WS-HI-GROUP1                    
MFA-TR*          AND RD.REG_GROUP_CD <> LR.REG_GROUP_CD)                        
MFA-TR*          OR  (UT.RATE_PLAN_NO   BETWEEN :WS-LO-GROUP2                   
MFA-TR*                                    AND  :WS-HI-GROUP2                   
MFA-TR*          AND RD.REG_GROUP_CD <> LR.REG_GROUP_CD))                       
MFA-TR*        ORDER BY AT.ACCOUNT_NO                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSRP346 ENDS HERE'.                    
      *                                                                         
      *****************************************************************         
      *             P R O C E D U R E   D I V I S I O N               *         
      *****************************************************************         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) CALLS 0100-INITIALIZATION TO INITIALIZE VARIABLES     *         
      *         AND GET INITIAL INFORMATION TO DRIVE THE PROGRAM      *         
      *      2) CALLS 1000-PROCESS-DETAIL-REPORT WHICH PROCESSES      *         
      *         BOTH THE DETAIL                                       *         
      *      3) CALLS 2000-PROCESS-EXCEPTION-REPORT TO CREATE         *         
      *         EXCEPTION (ERROR) REPORT                              *         
      *      4) CALLS 3000-CHECK-DATA-AND-TOTALS TO CHECK DATA        *         
      *         RECORDS                                               *         
      *      5) CALL 9000-TERMINATE TO END PROCESSING                 *         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-PROCESS-DETAIL-REPORT THRU 1000-EXIT.           
      *                                                                         
           IF WS-DATA-FOUND = 'N'                                       
              MOVE WS03-NO-DATA-LINE TO PRT3461-RECORD                  
              PERFORM 5000-WRITE-FCSR3461-DETAIL1 THRU 5000-EXIT        
              MOVE WS03-END-DATA-LINE TO PRT3461-RECORD                 
              PERFORM 5000-WRITE-FCSR3461-DETAIL1 THRU 5000-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           STOP RUN.                                                    
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) INITIALIZES WORKING-STORAGE                           *         
      *      2) RETRIEVES COMMON PROCESSING DATE                      *         
      *      3) RETRIEVES CURRENT TIMESTAMP                           *         
      *      4) OPENS INPUT & OUTPUT FILES                            *         
      *      5) WRITES FIRST PAGE'S TITLES FOR ALL REPORTS PRODUCED   *         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           INITIALIZE WS04-DATE-TIME-STAMPS                             
                      WS05-WORK-AREA                                    
                                                                        
           OPEN OUTPUT FCRP3461-FILE.                                   
                                                                        
           PERFORM 6240-GET-FCA00-COMMON-DATE        THRU 6240-EXIT.    
           MOVE WS-FCA00-COMMON-DATE          TO WS-INPUT-DATE.         
                                                                        
           PERFORM 0200-SELECT-CURR-TIMESTAMP        THRU 0200-EXIT.    
                                                                        
           PERFORM 0300-POPULATE-TITLES              THRU 0300-EXIT.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) RETRIEVES CURRENT TIMESTAMP FROM DB2                  *         
      *****************************************************************         
      *                                                                         
       0200-SELECT-CURR-TIMESTAMP.                                      
      *                                                                         
           MOVE '0200' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS04-CURRENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS04-CURRENT-TS = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '***********************************'             
              DISPLAY '**   PCSRP346 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 0200    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) POPULATES TITLE VARIABLES THAT WILL BE THE SAME FOR   *         
      *         ALL 3 REPORTS                                         *         
      *****************************************************************         
      *                                                                         
       0300-POPULATE-TITLES.                                            
      *                                                                         
           MOVE '0300'          TO ACTIVE-PARAGRAPH.                    
           STRING WS04-CURRENT-TS(6:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(9:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(1:4)  DELIMITED BY SIZE               
             INTO WS02-TITLE1-RUN-DT.                                   
      *                                                                         
           STRING WS04-CURRENT-TS(12:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(15:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(18:2) DELIMITED BY SIZE               
             INTO WS02-TITLE2-RUN-TM.                                   
      *                                                                         
           STRING WS-INPUT-DATE(6:2)    DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS-INPUT-DATE(9:2)    DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS-INPUT-DATE(1:4)    DELIMITED BY SIZE               
             INTO WS02-TITLE3D-DATE.                                    
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) DRIVES PROCESSING FOR DETAIL                          *         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-DETAIL-REPORT.                                      
      *                                                                         
           INITIALIZE  WS-RATE-PLAN-NO-NULL.                            
      *                                                                         
           PERFORM 7000-OPEN-ACCT-DET-CURSOR   THRU 7000-EXIT.          
           PERFORM 7100-FETCH-ACCT-DET-CURSOR  THRU 7100-EXIT.          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 4200-SCAN-FIELDS-FOR-ERRORS                    
                                          THRU 4200-EXIT                
                 PERFORM 7100-FETCH-ACCT-DET-CURSOR THRU 7100-EXIT      
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7200-CLOSE-ACCT-DET-CURSOR    THRU 7200-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    REPORT HANDLING                                            *         
      *****************************************************************         
      *                                                                         
       3000-REPORT-HANDLING.                                            
      *                                                                         
           MOVE '3000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           PERFORM 3100-POPULATE-DETAIL-LINE THRU 3100-EXIT.            
                                                                        
           MOVE WS03-DET-DETAIL-LINE1 TO PRT3461-RECORD.                
                                                                        
           PERFORM 5000-WRITE-FCSR3461-DETAIL1 THRU 5000-EXIT.          
                                                                        
           MOVE 'Y' TO WS-DATA-FOUND.                                   
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    LOADS THE PRINT LINE                                       *         
      *****************************************************************         
      *                                                                         
       3100-POPULATE-DETAIL-LINE.                                       
      *                                                                         
           MOVE '3100'     TO ACTIVE-PARAGRAPH.                         
      *                                                                         
           MOVE WS-ACCOUNT-NO-LR(1:1)  TO  WS03-DET-ACCOUNT-NO(1:1).    
           MOVE WS-ACCOUNT-NO-LR(2:4)  TO  WS03-DET-ACCOUNT-NO(3:4).    
           MOVE WS-ACCOUNT-NO-LR(6:4)  TO  WS03-DET-ACCOUNT-NO(8:4).    
           MOVE WS-ACCOUNT-NO-LR(10:4) TO  WS03-DET-ACCOUNT-NO(13:4).   
      *                                                                         
C35671*    MOVE WS-FULL-NAME-27(21:12) TO WS03-DET-CUST-NAME(1:12).             
C35671     MOVE WS-FULL-NAME-27(41:12) TO WS03-DET-CUST-NAME(1:12).     
           MOVE WS-FULL-NAME-27(1:15)  TO WS03-DET-CUST-NAME(13:15).    
      *                                                                         
           MOVE UT-RATE-PLAN-NO        TO  WS03-DET-RATE-PLAN.          
           MOVE LR-REG-GROUP-CD        TO  WS03-DET-GROUP-CODE.         
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   NOT REALLY NEEDED.  SORT OF PREPS FOR DETAIL LINE           *         
      *****************************************************************         
      *                                                                         
       4200-SCAN-FIELDS-FOR-ERRORS.                                     
      *                                                                         
           MOVE '4200'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS-RATE-PLAN-NO-NULL = -1                                 
              MOVE SPACES TO UT-RATE-PLAN-NO                            
           END-IF.                                                      
      *                                                                         
           PERFORM 3000-REPORT-HANDLING   THRU 3000-EXIT.               
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *   CHECKS FOR HEADER AND WRITES THE DETAIL LINE.             *           
      ***************************************************************           
      *                                                                         
       5000-WRITE-FCSR3461-DETAIL1.                                     
      *                                                                         
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS05-REPORT1-LINE-CTR GREATER THAN 64                     
              MOVE PRT3461-RECORD TO WS05-HOLD-AREA                     
              PERFORM 5010-WRITE-FCSR3461-TITLES  THRU 5010-EXIT        
              MOVE WS05-HOLD-AREA TO PRT3461-RECORD                     
           END-IF.                                                      
      *                                                                         
           WRITE PRT3461-RECORD                                         
                 AFTER ADVANCING 1 LINES.                               
      *                                                                         
           ADD  1 TO WS05-REPORT1-LINE-CTR.                             
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   HEADERS FOR THE REPORT                                      *         
      *****************************************************************         
      *                                                                         
       5010-WRITE-FCSR3461-TITLES.                                      
      *                                                                         
           MOVE '5010'                TO ACTIVE-PARAGRAPH.              
                                                                        
           ADD  1                     TO WS05-REPORT1-PAGE-NBR.         
                                                                        
           MOVE WS05-REPORT1-PAGE-NBR TO WS02-TITLE3D-PAGE-NBR          
                                                                        
           MOVE 'PCSRP346-PCSR3461'   TO WS02-TITLE1-REPTNAME.          
                                                                        
           WRITE PRT3461-RECORD FROM WS02-TITLE1                        
                 AFTER ADVANCING PAGE.                                  
           WRITE PRT3461-RECORD FROM WS02-TITLE2                        
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT3461-RECORD FROM WS02-TITLE3D                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT3461-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT3461-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT3461-RECORD FROM WS02-HEADER1-DETAIL                
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT3461-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE  7 TO WS05-REPORT1-LINE-CTR.                            
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  PARAGRAPHS 6000 - ?                                          *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00004, WHICH REDUCES EMBEDDED SPACES      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00004                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  6240-GET-FCA00-COMMON-DATE                                   *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00040, WHICH CONTAINS THE DB2 STATEMENTS  *         
      *         NECESSARY TO RETRIEVE PARMS FROM TABLE CSS_JOB_PARM   *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00040                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    OPENS THE CURSOR                                           *         
      *****************************************************************         
      *                                                                         
       7000-OPEN-ACCT-DET-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT-CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP346   ABORT ************'       
               DISPLAY '* 7000-OPEN-ACCT-DET-CURSOR           *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSRP346   ABORT ************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    FETCHES THE CURSOR                                         *         
      *****************************************************************         
      *                                                                         
       7100-FETCH-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT-CSR                                            
                INTO :AT-ACCOUNT-NO,                                    
                     :WS-FULL-NAME-27,                                  
                     :UT-RATE-PLAN-NO :WS-RATE-PLAN-NO-NULL,            
                     :LR-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-LR                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO WS-ACCOUNT-NO-LR                         
                 MOVE SPACES TO WS-FULL-NAME-27                         
              ELSE                                                      
                 DISPLAY '********** PCSRP346   ABORT ************'     
                 DISPLAY '* 7100-FETCH-ACCT-DET-CURSOR          *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSRP346   ABORT ************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    CLOSES THE CURSOR                                          *         
      *****************************************************************         
      *                                                                         
       7200-CLOSE-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT-CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO   WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP346   ABORT ************'       
               DISPLAY '* 7200-CLOSE-ACCT-DET-CURSOR          *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSRP346   ABORT ************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7620-START-FCSCA00                                           *         
      *  7621-READ-FCSCA00                                            *         
      *  7622-CLOSE-CA00-CSR                                          *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00039, WHICH DECLARES, OPENS, FETCHES     *         
      *         AND CLOSES CURSOR TO CSS_JOB_PARM                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    THIS PARAGRAPH:                                            *         
      *      1) CLOSES THE INPUT AND OUTPUT FILES                     *         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO ACTIVE-PARAGRAPH.                             
           CLOSE FCRP3461-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  9900-ABEND                                                   *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          *         
      *         PROCESSING PARAGRAPH                                  *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
