       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP324.                                        
       AUTHOR . CBSI.                                                   
       DATE-WRITTEN.  10/12/01.                                         
       DATE-COMPILED.                                                   
      *                                                                 00060001
      ***************************************************************** 00070001
      **                SOUTH CAROLINA ELECTRICITY & GAS              **00080001
      **            COMPLETE BUSINESS SOLUTIONS INC., MADRAS          **00090001
      **                                                              **00100001
      ********            CUSTOMER SERVICE SYSTEM             ********* 00110001
      ********                      DB2                       ********* 00120001
      ***************************************************************** 00130001
      **                                                             ** 00140001
      **              PROGRAM  MODIFICATION  LOG                     ** 00150001
      **    DATE      USERID     REASON                              ** 00160001
      **    ____      _______    ______                              ** 00170001
      **                                                             ** 00180001
T25051**    10/12/01  KR19687    INITIAL VERSION                     ** 00190001
      **                                                             ** 00200001
      ***************************************************************** 00210001
      *    REMARKS.                                                     00220001
      *                    PCSRP324 NARRATIVE                        ** 00230002
      *                                                              ** 00230003
      *  THIS PROGRAM SUMS THE DDC'S BILLED FOR THE PREVIOUS         ** 00240001
      *  REVENUE MONTH AFTER THE CLOSE OF CYCLE 20/21.  THIS         ** 00240002
      *  DATA IS SAVED TO A DATASET FOR FURTHER MANIPULATION.        ** 00240003
      *                                                              ** 00240004
      ******************************************************************00320000
      *                                                                 00330001
      *              ---- BASIC BATCH SEQUENCE STRUCTURE ----           00340000
      *             1000 - 1999   INPUT PROCESSING CONTROL PATH         00350000
      *             2000 - 2999   OUTPUT PROCESSING CONTROL PATH        00360000
      *             6000 - 6999   COMMON SYSTEM MODULES                 00370001
      *             7000 - 7999   INPUT MODULES                         00380001
      *             9000 - 9799   TERMINATION MODULES                   00390000
      *             9900 - 9999   ABEND/ABORT MODULES                   00400000
      ***************************************************************** 00410000
      *                                                                 00420000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00490001
           SELECT OUTREC ASSIGN TO DA-FCSPT324.                         
      *                                                                 00510000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00540001
       FD  OUTREC.                                                      
       01  FS-OUTREC.                                                   
           05  COUNT-NO-FS                   PIC 9(06).                 
           05  RATE-PLAN-NO-FS               PIC X(03).                 
           05  CODE-REVENUE-CLASS-FS         PIC X(03).                 
           05  SUM-FACTOR-FS                 PIC 9(06)V9999.            
      *                                                                 00610001
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP324'.
MSQ017     COPY MFASQLM.
      ******************************************************************00630001
      ****  APPLICATION TABLE WORKING STORAGE DECLARATIONS   ***********00640001
      ******************************************************************00650001
      *                                                                 00660001
       COPY FIOJC01.                                                    00670001
      *                                                                 00680001
       COPY CWS09900.                                                   00690001
      *-- ABEND SWITCH COPYBOOK                                         00700001
                                                                        
       COPY CWS00303.                                                   00720001
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                00730001
                                                                        
       COPY CWS00038.                                                   00750001
      *-- COPY BOOK TO FORMAT PARM DATA                                 00760001
                                                                        
       COPY CWS00114.                                                   00780001
      *-- COPY BOOK TO READ THE JOB PARM TABLE FOR THE REPORT DATE      00790001
                                                                        
      *                                                                 00810001
       01  WS-START                          PIC X(40)  VALUE           
           'WORKING STORAGE FOR PCSRP324 STARTS HERE'.                  
      *                                                                 00840000
       01  WS-MISC-FIELDS.                                              
           05  WS-END-OF-ROWS                PIC X(01) VALUE 'N'.       
               88  NO-MORE-DATA                        VALUE 'Y'.       
      *                                                                 00880001
       01  WS-HOST-VARIABLES.                                           
           05 WS-COUNT-NO                    PIC S9(06) COMP-3          
                                              VALUE ZEROS.              
           05 WS-SUM-FACTOR                  PIC S9(06)V9999 COMP-3     
                                              VALUE ZEROS.              
       01  WS-LITERALS.                                                 
           05 WS-PGRMNAME                    PIC X(08)  VALUE           
                                                       'PCSRP324'.      
      *                                                                 00970001
      ***   WS-REPORT-VARIABLES.                                        00980001
      *                                                                 00990001
      *                                                                 01000001
      ****************************************************************  01010001
      * WORKING STORAGE FOOTER VARIABLES                                01020001
      ****************************************************************  01030001
      *                                                                 01040001
      *                                                                 01050001
       01  WS-END                            PIC X(40)  VALUE           
           'WORKING STORAGE FOR PCSRP324 ENDS HERE  '.                  
      *                                                                 01080001
           EXEC SQL                                                     01090001
               INCLUDE SQLCA                                            01100001
           END-EXEC.                                                    01110001
      *                                                                 01120001
      *  CSS_ACCOUNT                                                    01130002
      *                                                                 01140001
           EXEC SQL                                                     01150001
               INCLUDE TBACCT                                           01160001
           END-EXEC.                                                    01170001
      *                                                                 01180001
      *  CSS_BILLING_DET                                                01190001
      *                                                                 01200001
           EXEC SQL                                                     01210001
                INCLUDE TBBLLDET                                        01220001
           END-EXEC.                                                    01230001
      *                                                                 01240001
           EXEC SQL                                                     
                DECLARE BILLING_DET CURSOR FOR                          
                 SELECT COUNT(*),                                       
                        C.RATE_PLAN_NO,                                 
                        C.CODE_REVENUE_CLASS,                           
                        SUM (D.FACTOR)                                  
                 FROM   CSS_FIXED_FCTR D WITH(READUNCOMMITTED),                 
                        CSS_ACCOUNT A WITH(READUNCOMMITTED),                    
                        CSS_BILLING_DET C WITH(READUNCOMMITTED)                 
                 WHERE  A.REV_MTH_LST_NRML >                            
                        (YEAR(DATEADD( MONTH, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) * 100) +    
                         MONTH(DATEADD( MONTH, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))            
                 AND    A.ACCOUNT_NO = D.ACCOUNT_NO                     
                 AND    A.ACCOUNT_NO = C.ACCOUNT_NO                     
                 AND    D.FACTOR_ID = 'DDC'                             
                 AND    D.EFF_DATE_TO = IIF(TRY_CONVERT(DATE, 
              '2999-12-31') IS NULL OR (PATINDEX('%.%', '2999-12-31'
              ) <> 0) OR (LEN('2999-12-31') <> 10), CIS.CHAR2DATE(
              '2999-12-31'), CONVERT(DATE, '2999-12-31') )                    
                 AND    C.DATE_ORIG_BILL IS NULL                        
                 AND    C.REVENUE_MONTH =                               
                         (YEAR(DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) * 100) +   
                          MONTH(DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))           
                 AND    C.BILL_NO IN                                    
                         (SELECT MAX (F.BILL_NO)                        
                            FROM CSS_BILLING_DET F WITH(READUNCOMMITTED)        
                           WHERE C.ACCOUNT_NO = F.ACCOUNT_NO            
                             AND F.REVENUE_MONTH =                      
                                (YEAR(DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) *   100) +                
                                 MONTH(DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )))   
                 GROUP BY C.CODE_REVENUE_CLASS,                         
                          C.RATE_PLAN_NO                                
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01250000
MFA-TR*         DECLARE BILLING_DET CURSOR FOR                          01260000
MFA-TR*          SELECT COUNT(*),                                       01270001
MFA-TR*                 C.RATE_PLAN_NO,                                 01280001
MFA-TR*                 C.CODE_REVENUE_CLASS,                           01290001
MFA-TR*                 SUM (D.FACTOR)                                  01300001
MFA-TR*          FROM   CSS_FIXED_FCTR D,                               01310004
MFA-TR*                 CSS_ACCOUNT A,                                  01320004
MFA-TR*                 CSS_BILLING_DET C                               01330004
MFA-TR*          WHERE  A.REV_MTH_LST_NRML >                            01340001
MFA-TR*                 (YEAR(DATE(CURRENT DATE) - 2 MONTH) * 100) +    01350001
MFA-TR*                  MONTH(DATE(CURRENT DATE) - 2 MONTH)            01360001
MFA-TR*          AND    A.ACCOUNT_NO = D.ACCOUNT_NO                     01370001
MFA-TR*          AND    A.ACCOUNT_NO = C.ACCOUNT_NO                     01380001
MFA-TR*          AND    D.FACTOR_ID = 'DDC'                             01390001
MFA-TR*          AND    D.EFF_DATE_TO = '2999-12-31'                    01400001
MFA-TR*          AND    C.DATE_ORIG_BILL IS NULL                        01410001
MFA-TR*          AND    C.REVENUE_MONTH =                               01420001
MFA-TR*                  (YEAR(DATE(CURRENT DATE) - 1 MONTH) * 100) +   01430001
MFA-TR*                   MONTH(DATE(CURRENT DATE) - 1 MONTH)           01440001
MFA-TR*          AND    C.BILL_NO IN                                    01450001
MFA-TR*                  (SELECT MAX (F.BILL_NO)                        01460001
MFA-TR*                     FROM CSS_BILLING_DET F                      01470001
MFA-TR*                    WHERE C.ACCOUNT_NO = F.ACCOUNT_NO            01480001
MFA-TR*                      AND F.REVENUE_MONTH =                      01490001
MFA-TR*                         (YEAR(DATE(CURRENT DATE)                01500001
MFA-TR*                            - 1 MONTH) *   100) +                01510001
MFA-TR*                          MONTH(DATE(CURRENT DATE) - 1 MONTH))   01520001
MFA-TR*          GROUP BY C.CODE_REVENUE_CLASS,                         01530004
MFA-TR*                   C.RATE_PLAN_NO                                01540004
MFA-TR*             WITH  UR                                            01550004
MFA-TR*    END-EXEC.                                                    01560000
      *                                                                 01570001
       PROCEDURE DIVISION.                                              
      ******************************************************************01590001
      * 0000-MAINLINE                                              *****01600001
      ******************************************************************01610001
      *                                                                 01620001
       0000-MAINLINE.                                                   
      *                                                                 01640001
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                 01680001
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01710001
      ***************************************************************** 01720001
      *                                                               * 01730001
      * 1000-INITIALIZATION                                           * 01740001
      * CALLS ALL INITIALIZATION PARAGRAPHS.                          * 01750001
      *                                                               * 01760001
      ***************************************************************** 01770001
      *                                                                 01780001
       1000-INITIALIZATION.                                             
      *                                                                 01800001
           OPEN OUTPUT OUTREC.                                          
      *                                                                 01820000
           PERFORM 1400-OPEN-BILLING-DET THRU 1400-EXIT.                
           PERFORM 1500-FETCH-BILLING-DET                               
               UNTIL WS-END-OF-ROWS = 'Y'.                              
      *                                                                 01860001
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01890001
      *                                                                 01900001
      ***************************************************************** 01910001
      *                                                               * 01920001
      * 1400-OPEN-BILLING-DET                                         * 01930001
      * OPENS BILLING_DET CURSOR.                                     * 01940001
      *                                                               * 01950001
      ***************************************************************** 01960001
      *                                                                 01970001
        1400-OPEN-BILLING-DET.                                          
      *                                                                 01990001
           EXEC SQL                                                     
               OPEN BILLING_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  PCSRP324 PROCESSING ERROR          **'       
              DISPLAY '**  OPEN ERROR ON CURSOR BILLING_DET   **'       
              DISPLAY '**  PARA 1400-OPEN-BILLING-DET         **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 02170001
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02200001
      ***************************************************************** 02210001
      *                                                               * 02220001
      * 1500-FETCH-BILLING-DET                                        * 02230001
      * FETCHES ROWS FROM BILLING_DET CURSOR.                         * 02240001
      *                                                               * 02250001
      ***************************************************************** 02260001
      *                                                                 02270001
        1500-FETCH-BILLING-DET.                                         
      *                                                                 02290001
           EXEC SQL                                                     
               FETCH BILLING_DET                                        
                INTO :WS-COUNT-NO,                                      
                     :BG-RATE-PLAN-NO,                                  
                     :BG-CODE-REVENUE-CLASS,                            
                     :WS-SUM-FACTOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2000-WRITE-OUTPUT THRU 2000-EXIT                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-ROWS                             
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '**  PCSRP324 PROCESSING ERROR          **'    
                 DISPLAY '**  FETCH ERROR ON CURSOR BILLING_DET  **'    
                 DISPLAY '**  PARA 1500-FETCH-BILLING-DET        **'    
                 DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                 02550001
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02580001
      ***************************************************************** 02590001
      *                                                               * 02600001
      * 1600-CLOSE-BILLING-DET                                        * 02610001
      * CLOSES BILLING_DET CURSOR.                                    * 02620001
      *                                                               * 02630001
      ***************************************************************** 02640001
      *                                                                 02650001
       1600-CLOSE-BILLING-DET.                                          
      *                                                                 02670001
            EXEC SQL                                                    
                 CLOSE BILLING_DET                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  PCSRP324 PROCESSING ERROR          **'       
              DISPLAY '**  CLOSE ERROR ON BILLING_DET CURSOR  **'       
              DISPLAY '**  PARA 1600-CLOSE-BILLING-DET        **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 02850001
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02880001
      *                                                                 02890001
      ***************************************************************** 02900001
      *                                                               * 02910001
      * 2000-WRITE-OUTPUT                                             * 02920004
      * WRITES THE OUTPUT FILE.                                       * 02930004
      *                                                               * 02940001
      ***************************************************************** 02950001
      *                                                                 02960001
       2000-WRITE-OUTPUT.                                               
           MOVE WS-COUNT-NO TO COUNT-NO-FS.                             
           MOVE BG-RATE-PLAN-NO TO RATE-PLAN-NO-FS.                     
           MOVE BG-CODE-REVENUE-CLASS TO CODE-REVENUE-CLASS-FS.         
           MOVE WS-SUM-FACTOR TO SUM-FACTOR-FS.                         
           WRITE FS-OUTREC.                                             
      *                                                                 03030001
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03060001
      ***************************************************************** 03070001
      *                                                               * 03080001
      * 9000-TERMINATE                                                * 03090001
      *                                                               * 03100001
      ***************************************************************** 03110001
      *                                                                 03120001
       9000-TERMINATE.                                                  
      *                                                                 03140001
           CLOSE OUTREC.                                                
                                                                        
           PERFORM 1600-CLOSE-BILLING-DET THRU 1600-EXIT.               
      *                                                                 03180001
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03210001
      ***************************************************************** 03220001
      *                                                               * 03230001
      *  ENDS TASK UNDER ABNORMAL TERMINATION                         * 03240001
      *                                                               * 03250001
      ***************************************************************** 03260001
      *                                                                 03270001
           EXEC SQL                                                     03280000
               INCLUDE CPD09900                                         03290000
           END-EXEC.                                                    03300000
      *                                                                 03310001
