       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP306.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     NOV 03, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***THIS PROGRAM IS TO CREATE A REPORT OF 12 MONTHS ACCUMULATED ***        
      ***WRITE OFFS BY PAYMENT PRIORITY LEVEL AND RISK RATING FOR    ***        
      ***CERTAIN ACCOUNTS.THESE ACCOUNTS SHOULD MATCH THE ONES FOR   ***        
      ***PCSCA440.                                                   ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      **                                                               *        
      ** DATE        NITIALS   COMMENTS                                *        
A05268** ----------  --------  ----------------------------------------*        
ACT030** 11/03/2015  VV7M728   CSR306 EZT TO COBOL CONVERSION          *        
A05460** 10/12/2016  SM93554   TOTAL AMOUNT WAS INCORRECT DUE TO       *        
      **             ACT-303   DECLARATION LENGTH WHICH IS CORRECTED.  *        
      **                                                               *        
      ******************************************************************        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP306'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOSS_RESERVE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOSRES                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_MISC_INFO                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CHRG_OFF                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILL_WINDOW                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP306'.     
      *                                                                         
       01 WS-RP306-OUT-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-PPL                   PIC 9(04) VALUE ZEROS.          
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 OUT-LOSS-RESERVE-TX       PIC X(15) VALUE SPACES.         
           05 FILLER                    PIC X(14) VALUE SPACES.         
ACT303     05 OUT-CO-AMT-TRANS          PIC Z,ZZZ,ZZZ.99.               
                                                                        
       01 WS-RP306-OUT-RECX.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-PPLX                  PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-LOSS-RESERVE-TXX.                                     
            49 OUT-LOSS-RESERVE-TX-LENX PIC S9(4) USAGE COMP.           
            49 OUT-LOSS-RESERVE-TX-TEXTX PIC X(15).                     
           05 FILLER                    PIC X(14) VALUE SPACES.         
ACT303     05 OUT-CO-AMT-TRANSX         PIC Z,ZZZ,ZZZ.99.               
                                                                        
       01 WS-RP306-OUT-RECY.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-PPLY                  PIC 9(04) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-LOSS-RESERVE-TXY.                                     
            49 OUT-LOSS-RESERVE-TX-LENY PIC S9(4) USAGE COMP.           
            49 OUT-LOSS-RESERVE-TX-TEXTY PIC X(15).                     
           05 FILLER                    PIC X(14) VALUE SPACES.         
ACT303     05 OUT-CO-AMT-TRANSY         PIC Z,ZZZ,ZZZ.99.               
                                                                        
       01 WS-RP306-HDR-REC-LN1.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN1-NAME              PIC X(08) VALUE 'PCSRP306'.     
           05 FILLER                    PIC X(42) VALUE SPACES.         
           05 HDR-LN1-COMPANY-NAME      PIC X(31)                       
                        VALUE 'SOUTH CAROLINA ELECTRIC AND GAS'.        
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN1-RUN-DATE          PIC X(10) VALUE 'RUN DATE: '.   
           05 HDR-LN1-SYS-DATE          PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(16) VALUE SPACES.         
           05 HDR-LN1-PAGE              PIC X(10) VALUE 'PAGE      '.   
           05 HDR-LN1-PAGE-NO           PIC 9(01) VALUE 1.              
           05 FILLER                    PIC X(01) VALUE SPACES.         
                                                                        
                                                                        
       01 WS-RP306-HDR-REC-LN2.                                         
           05 FILLER                    PIC X(57) VALUE SPACES.         
           05 HDR-LN2-DETAILS           PIC X(20)                       
                        VALUE '12 MONTHS WRITE OFFS'.                   
           05 FILLER                    PIC X(56) VALUE SPACES.         
                                                                        
       01 WS-RP306-HDR-REC-LN3.                                         
           05 FILLER                    PIC X(52) VALUE SPACES.         
           05 HDR-LN3-DETAILS           PIC X(17)                       
                        VALUE 'REVENUE MONTHS = '.                      
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-BEG-REVMONTH          PIC 9(02).                      
           05 HDR-LN3-TO                PIC X(05) VALUE '  TO '.        
           05 HDR-END-REVMONTH          PIC 9(02).                      
           05 FILLER                    PIC X(52) VALUE SPACES.         
                                                                        
       01 WS-RP306-HDR-REC-LN4.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN4-TYPE              PIC X(04) VALUE 'TYPE'.         
           05 HDR-LN4-RISK-RATING       PIC X(23)                       
                        VALUE '      RISK RATING     '.                 
           05 HDR-LN4-RISK-RATING       PIC X(23)                       
                        VALUE '12 MONTHS WRITE OFFS'.                   
           05 FILLER                    PIC X(82) VALUE SPACES.         
                                                                        
       01 WS-RP306-HDR-REC-LN5.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP306-FTR-REC-LN1.                                         
           05 FTR-LN1-DET1              PIC X(50)                       
             VALUE '                                                  '.
           05 FILLER                    PIC X(83)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN2.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET2              PIC X(50)                       
             VALUE ' TYPE DEFINTIONS                                  '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN3.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET3              PIC X(50)                       
             VALUE ' 129  PROJECT SHARE                               '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN4.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET4              PIC X(50)                       
             VALUE '  19  RETURN CHECK CHARGE - NON UTILITY           '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN5.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET5              PIC X(50)                       
             VALUE '  20  RETURN CHECK AMOUNT - UTILITY               '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN6.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET6              PIC X(50)                       
             VALUE '  29  RETURN CHECK AMOUNT - NON UTILITY           '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN7.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET7              PIC X(50)                       
             VALUE '  30  LATE PAYMENT CHARGE - UTILITY               '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN8.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET8              PIC X(50)                       
             VALUE '  39  LATE PAYMENT CHARGE - NON-UTILITY           '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN9.                                         
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET9              PIC X(50)                       
             VALUE '  40  UTILITY - ELECTRIC                          '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN10.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET10             PIC X(50)                       
             VALUE '  45  UTILITY - GAS                               '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN11.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET11             PIC X(50)                       
             VALUE '  47  UTILITY - WATER (NOT USED)                  '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN12.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET12             PIC X(50)                       
             VALUE '  50  EASY PAYMENT PLAN                           '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN13.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET13             PIC X(50)                       
             VALUE '  60  RECONNECT CHARGE                            '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN14.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET14             PIC X(50)                       
             VALUE '  70  CREDIT IN ADVANCE - IE OVERPAYMENTS         '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN15.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET15             PIC X(50)                       
             VALUE '  80  DEPOSIT                                     '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN16.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN1-DET16             PIC X(50)                       
             VALUE '  90  DEFERRED AGREEMENT / DEFERRED PAYMENT PLAN  '.
           05 FILLER                    PIC X(82)  VALUE SPACES.        
      *                                                                         
       01 WS-RP306-FTR-REC-LN17.                                        
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 FTR-LN2-DET17             PIC X(49)                       
              VALUE '***                END OF REPORT              ***'.
           05 FILLER                    PIC X(83)  VALUE SPACES.        
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-SWITCH.                                                    
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
           05  WS-FIRST                 PIC X(01) VALUE 'Y'.            
           05  WS-FIRST-TYM             PIC X(01) VALUE 'Y'.            
           05  WS-CHECK                 PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-PPL                   PIC 9(04) VALUE ZEROS.          
           05  WS-PPL-PREV              PIC 9(04) VALUE ZEROS.          
ACT303     05  WS-CUR-AMT-TRANS         PIC S9(7)V9(2) VALUE ZEROS.     
ACT303     05  WS-SUM-AMT-TRANS         PIC S9(7)V9(2) VALUE ZEROS.     
ACT303     05  WS-SUB-SUM-AMT-TRANS     PIC S9(7)V9(2) VALUE ZEROS.     
ACT303     05  WS-TOT-AMT-TRANS         PIC S9(7)V9(2) VALUE ZEROS.     
ACT303     05  WS-PREV-AMT-TRANS        PIC S9(7)V9(2) VALUE ZEROS.     
           05  WS-RUN-DATE              PIC X(10) VALUE SPACES.         
           05  WS-PGRMNAME              PIC X(10) VALUE SPACES.         
COB305     05 WS-END-REVDATEP        PIC S9(06)V USAGE COMP-3 VALUE 0.       
           05  WS-BEG-REVDATEP          PIC X(06).                      
           05  WS-END-DATE              PIC X(10).                      
           05  WS-BEG-DATE              PIC X(10).                      
           05  WS-END-REVDATE           PIC 9(06).                      
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-LOSS-RESERVE-TX.                                           
           05 WS-LOSS-RESERVE-TX-LEN    PIC S9(4) USAGE COMP.           
           05 WS-LOSS-RESERVE-TX-TEXT   PIC X(15).                      
      *                                                                         
       01 WS-LOSS-RESERVE-TX-PREV.                                      
           05 WS-LOSS-RESERVE-TX-LENP   PIC S9(4) USAGE COMP.           
           05 WS-LOSS-RESERVE-TX-TEXTP  PIC X(15).                      
      *                                                                         
       01 WS-PARM-REVENUE.                                              
           05  WS-PARM-LIT              PIC X(14).                      
           05  WS-PARM-REV-MTH          PIC 9(06).                      
                                                                        
       01 WS-PARM-REV-MONTH.                                            
           05  WS-PARM-YEAR             PIC 9(04).                      
           05  WS-PARM-MONTH            PIC 9(02).                      
      *                                                                         
       01 WS-BEG-REVDATE.                                               
           05  WS-BEG-REVYEAR           PIC 9(04).                      
           05  WS-BEG-REVMONTH          PIC 9(02).                      
      *                                                                         
      ***************************************************************           
      *CURSOR FOR WRITE OFFS - MAIN CURSOR                          *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE WRTOFF_CUR  CURSOR FOR                             
                SELECT AT.ACCOUNT_NO                                    
                      ,AT.CUSTOMER_NO                                   
                      ,CO.PYMT_PRIORITY_LVL                             
                      ,CO.AMT_TRANS                                     
                      ,CO.WO_ORIGINAL_AM                                
                      ,CO.DATE_OF_CHG_OFF                               
                      ,LQ.LOSS_RESERVE_CD                               
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                       ,CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED)             
                       ,CSS_CHRG_OFF CO WITH(READUNCOMMITTED)                   
                  WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                 
                    AND AT.ACCOUNT_NO  = CO.ACCOUNT_NO                  
                    AND AT.CODE_ACCT_STAT = 'S'                         
                    AND AT.COMPANY_NO     = '01'                        
                    AND LQ.LOSS_RESERVE_CD > 0                          
                    AND CO.DATE_OF_CHG_OFF >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-BEG-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEG-DATE
              ) <> 0) OR (LEN(:WS-BEG-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-BEG-DATE
              ), CONVERT(DATE, :WS-BEG-DATE) )              
                    AND CO.DATE_OF_CHG_OFF <  IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )              
                    AND CO.AMT_TRANS <> 0                               
                  ORDER BY CO.PYMT_PRIORITY_LVL ASC                     
                          ,LQ.LOSS_RESERVE_CD   ASC                     
                  FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE WRTOFF_CUR  CURSOR FOR                                     
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,CO.PYMT_PRIORITY_LVL                                     
MFA-TR*               ,CO.AMT_TRANS                                             
MFA-TR*               ,CO.WO_ORIGINAL_AM                                        
MFA-TR*               ,CO.DATE_OF_CHG_OFF                                       
MFA-TR*               ,LQ.LOSS_RESERVE_CD                                       
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*                ,CSS_CUST_MISC_INFO LQ                                   
MFA-TR*                ,CSS_CHRG_OFF CO                                         
MFA-TR*           WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                         
MFA-TR*             AND AT.ACCOUNT_NO  = CO.ACCOUNT_NO                          
MFA-TR*             AND AT.CODE_ACCT_STAT = 'S'                                 
MFA-TR*             AND AT.COMPANY_NO     = '01'                                
MFA-TR*             AND LQ.LOSS_RESERVE_CD > 0                                  
MFA-TR*             AND CO.DATE_OF_CHG_OFF >= :WS-BEG-DATE                      
MFA-TR*             AND CO.DATE_OF_CHG_OFF <  :WS-END-DATE                      
MFA-TR*             AND CO.AMT_TRANS <> 0                                       
MFA-TR*           ORDER BY CO.PYMT_PRIORITY_LVL ASC                             
MFA-TR*                   ,LQ.LOSS_RESERVE_CD   ASC                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-GET-PARM-DATA               THRU  1000-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 08230000
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP306 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
           INITIALIZE PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-GET-PARM-DATA.                                          **        
      ******************************************************************        
      *                                                                         
       1000-GET-PARM-DATA.                                              
      *                                                                         
           PERFORM 1100-GET-COMMON-DATE             THRU 1100-EXIT.     
           PERFORM 1200-GET-REVENUE-MONTH           THRU 1200-EXIT.     
           PERFORM 7100-GET-CUR-REVMAX-EXT          THRU 7100-EXIT.     
           PERFORM 1400-GET-REVENUE-12MTH           THRU 1400-EXIT.     
           PERFORM 7200-GET-CUR-REVMIN-EXT          THRU 7200-EXIT.     
                                                                        
           DISPLAY 'COMMON DATE        = ' WS-RUN-DATE                  
           DISPLAY 'PARM REVENUE MONTH = ' WS-PARM-REV-MONTH            
           DISPLAY 'BEG REVENUE MONTH  = ' WS-BEG-REVDATE               
           DISPLAY 'END REVENUE MONTH  = ' WS-END-REVDATE               
           DISPLAY 'BEG EXTRACT DATE   = ' WS-BEG-DATE                  
           DISPLAY 'END EXTRACT DATE   = ' WS-END-DATE                  
           .                                                            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       1100-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE 'COMMONDATE'                 TO WS-PROGRAM              
                                                WS-PGRMNAME.            
           MOVE 'CA00'                       TO WS-COMMAND              
                                                WS-DATE.                
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE SPACES                       TO WS-INPUT-DATA-BREAKDOWN.
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
      *                                                                         
           MOVE G6-PARM-DATA(1:10)           TO WS-END-DATE.            
           MOVE WS-END-DATE                  TO WS-RUN-DATE             
                                                HDR-LN1-SYS-DATE.       
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-GET-REVENUE-MONTH                                       **        
      ******************************************************************        
      *                                                                         
       1200-GET-REVENUE-MONTH.                                          
      *                                                                         
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE 'COMMON'                     TO WS-PROGRAM.             
           MOVE 'DATE'                       TO WS-COMMAND.             
           MOVE 20                           TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
      *                                                                         
           PERFORM 7600-START-FCSJC01    THRU  7600-EXIT                
      *                                                                         
           PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT                
              UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                    
                    OR END-OF-SYSIPT                                    
      *                                                                         
           IF REVENUE-MONTH AND INPUT-ACTIVE                            
              MOVE WS-REVENUE-MONTH-PARM     TO BN-REVENUE-MONTH        
              PERFORM 7611-CLOSE         THRU  7611-EXIT                
           END-IF.                                                      
      *                                                                         
           MOVE WS-REVENUE-MONTH-PARM(1:4)   TO WS-PARM-YEAR.           
           MOVE WS-REVENUE-MONTH-PARM(5:2)   TO WS-PARM-MONTH.          
           MOVE WS-PARM-REV-MONTH            TO WS-END-REVDATE          
                                                WS-PARM-REV-MTH.        
           MOVE WS-END-REVDATE(5:2)          TO HDR-END-REVMONTH.       
           MOVE WS-END-REVDATE               TO WS-END-REVDATEP.        
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1400-GET-REVENUE-12MTH.                                      **        
      ** GET REVENUE MONTH TWELVE MONTHS AGO                          **        
      ******************************************************************        
      *                                                                         
       1400-GET-REVENUE-12MTH.                                          
      *                                                                         
           COMPUTE WS-BEG-REVMONTH = WS-PARM-MONTH + 1                  
           MOVE WS-BEG-REVMONTH              TO HDR-BEG-REVMONTH        
                                                                        
           IF WS-BEG-REVMONTH = 13                                      
             MOVE WS-PARM-YEAR               TO WS-BEG-REVYEAR          
             MOVE 1                          TO WS-BEG-REVMONTH         
             MOVE WS-BEG-REVMONTH            TO HDR-BEG-REVMONTH        
           ELSE                                                         
             COMPUTE WS-BEG-REVYEAR  = WS-PARM-YEAR - 1                 
           END-IF.                                                      
                                                                        
           MOVE WS-BEG-REVDATE               TO WS-BEG-REVDATEP.        
           MOVE WS-BEG-REVDATEP              TO BN-REVENUE-MONTH.       
           MOVE SPACES                       TO WS-LOSS-RESERVE-TX-PREV.
           MOVE SPACES                       TO ZL-LOSS-RESERVE-TX.     
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
                                                                        
           PERFORM 8100-WRITE-OUTFILE-HEADER        THRU 8100-EXIT.     
           PERFORM 7300-OPEN-MAIN-CSR               THRU 7300-EXIT.     
      *                                                                         
           PERFORM 7400-FETCH-MAIN-CSR              THRU 7400-EXIT.     
           PERFORM 2100-GET-TRANS-AMT               THRU 2100-EXIT      
           UNTIL WS-ALL-ROWS-PROCESD = WS-Y.                            
                                                                        
           PERFORM 2200-PROCESS-LAST-REC            THRU 2200-EXIT.     
           PERFORM 7500-CLOSE-MAIN-CSR              THRU 7500-EXIT.     
           PERFORM 8300-WRITE-FOOTER-DETAILS        THRU 8300-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-GET-TRANS-AMT.                                             *        
      ******************************************************************        
      *                                                                         
       2100-GET-TRANS-AMT.                                              
      *                                                                         
           MOVE CO-PYMT-PRIORITY-LVL         TO WS-PPL                  
                                                OUT-PPL.                
           MOVE CO-AMT-TRANS                 TO WS-CUR-AMT-TRANS        
                                                OUT-CO-AMT-TRANS.       
      *                                                                         
           PERFORM 7700-GET-RESERVE-DETAILS         THRU 7700-EXIT.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE SPACES                     TO WS-LOSS-RESERVE-TX     
                                                 OUT-LOSS-RESERVE-TX    
              MOVE ZL-LOSS-RESERVE-TX         TO WS-LOSS-RESERVE-TX     
              MOVE WS-LOSS-RESERVE-TX-TEXT    TO OUT-LOSS-RESERVE-TX    
              INSPECT OUT-LOSS-RESERVE-TX REPLACING ALL LOW-VALUES      
                                                         BY SPACES      
              IF WS-FIRST = 'Y'                                         
                 MOVE WS-PPL                    TO WS-PPL-PREV          
                 MOVE WS-LOSS-RESERVE-TX        TO                      
                                                WS-LOSS-RESERVE-TX-PREV 
                 MOVE WS-CUR-AMT-TRANS          TO WS-PREV-AMT-TRANS    
                 MOVE 'N'                       TO WS-FIRST             
              END-IF                                                    
                                                                        
              IF WS-PPL = WS-PPL-PREV                                   
                IF WS-LOSS-RESERVE-TX = WS-LOSS-RESERVE-TX-PREV         
                  COMPUTE WS-SUM-AMT-TRANS = WS-SUM-AMT-TRANS +         
                                             WS-CUR-AMT-TRANS           
                ELSE                                                    
                  MOVE WS-PPL-PREV              TO OUT-PPL              
                  MOVE SPACES                   TO OUT-LOSS-RESERVE-TX  
                  MOVE WS-LOSS-RESERVE-TX-TEXTP TO OUT-LOSS-RESERVE-TX  
                                                                        
                  INSPECT OUT-LOSS-RESERVE-TX REPLACING ALL LOW-VALUES  
                                                            BY SPACES   
                  MOVE WS-SUM-AMT-TRANS         TO OUT-CO-AMT-TRANS     
                                                                        
                  IF WS-FIRST-TYM = 'Y'                                 
                     PERFORM 8202-WRITE-OUTFILE-DETAILS THRU 8202-EXIT  
                     MOVE 'N'                   TO WS-FIRST-TYM         
                  ELSE                                                  
                     PERFORM 8203-WRITE-OUTFILE-DETAILS THRU 8203-EXIT  
                  END-IF                                                
                                                                        
                  MOVE SPACES                  TO OUT-LOSS-RESERVE-TX   
                                                  OUT-LOSS-RESERVE-TXX  
                                                  OUT-LOSS-RESERVE-TXY  
                                                                        
                  COMPUTE WS-SUB-SUM-AMT-TRANS = WS-SUM-AMT-TRANS +     
                                                 WS-SUB-SUM-AMT-TRANS   
                  MOVE WS-CUR-AMT-TRANS        TO WS-SUM-AMT-TRANS      
                END-IF                                                  
              ELSE                                                      
                MOVE SPACES                    TO OUT-LOSS-RESERVE-TX   
                MOVE WS-PPL-PREV               TO OUT-PPL               
                MOVE WS-LOSS-RESERVE-TX-TEXTP  TO OUT-LOSS-RESERVE-TX   
                                                                        
                INSPECT OUT-LOSS-RESERVE-TX REPLACING ALL LOW-VALUES    
                                                          BY SPACES     
                MOVE WS-SUM-AMT-TRANS          TO OUT-CO-AMT-TRANS      
                                                                        
                IF WS-FIRST-TYM = 'Y'                                   
                   PERFORM 8202-WRITE-OUTFILE-DETAILS THRU 8202-EXIT    
                   MOVE 'N'                    TO WS-FIRST-TYM          
                ELSE                                                    
                   PERFORM 8203-WRITE-OUTFILE-DETAILS THRU 8203-EXIT    
                END-IF                                                  
                                                                        
                MOVE SPACES                   TO OUT-LOSS-RESERVE-TX    
                                                 OUT-LOSS-RESERVE-TXX   
                                                 OUT-LOSS-RESERVE-TXY   
                                                                        
                COMPUTE WS-SUB-SUM-AMT-TRANS = WS-SUB-SUM-AMT-TRANS +   
                                               WS-SUM-AMT-TRANS         
                MOVE WS-PPL-PREV               TO OUT-PPLY              
                MOVE SPACES                    TO OUT-LOSS-RESERVE-TXY  
                MOVE WS-SUB-SUM-AMT-TRANS      TO OUT-CO-AMT-TRANSY     
                PERFORM 8200-WRITE-OUTFILE-DETAILS  THRU 8200-EXIT      
                MOVE 'Y'                       TO WS-FIRST-TYM          
                                                                        
                MOVE WS-CUR-AMT-TRANS          TO WS-SUM-AMT-TRANS      
                COMPUTE WS-TOT-AMT-TRANS = WS-SUB-SUM-AMT-TRANS +       
                                           WS-TOT-AMT-TRANS             
                MOVE ZEROES                    TO WS-SUB-SUM-AMT-TRANS  
              END-IF                                                    
                                                                        
              MOVE WS-PPL                    TO WS-PPL-PREV             
              MOVE SPACES                    TO WS-LOSS-RESERVE-TX-PREV 
              MOVE WS-LOSS-RESERVE-TX        TO WS-LOSS-RESERVE-TX-PREV 
              MOVE WS-CUR-AMT-TRANS          TO WS-PREV-AMT-TRANS       
              MOVE SPACES                    TO ZL-LOSS-RESERVE-TX      
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TX     
                                                                        
           PERFORM 7400-FETCH-MAIN-CSR              THRU 7400-EXIT.     
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 2200-PROCESS-LAST-REC.                                       **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-LAST-REC.                                           
           MOVE WS-PPL                       TO OUT-PPL.                
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TX     
           MOVE WS-LOSS-RESERVE-TX-TEXT      TO OUT-LOSS-RESERVE-TX     
           INSPECT OUT-LOSS-RESERVE-TX                                  
            REPLACING ALL LOW-VALUES BY SPACES                          
           MOVE WS-SUM-AMT-TRANS             TO OUT-CO-AMT-TRANS.       
                                                                        
           IF WS-FIRST-TYM = 'Y'                                        
            PERFORM 8202-WRITE-OUTFILE-DETAILS       THRU 8202-EXIT     
            MOVE 'N'                         TO WS-FIRST-TYM            
           ELSE                                                         
            PERFORM 8203-WRITE-OUTFILE-DETAILS       THRU 8203-EXIT     
           END-IF                                                       
                                                                        
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TX     
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TXX    
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TXY    
                                                                        
           COMPUTE WS-SUB-SUM-AMT-TRANS = WS-SUB-SUM-AMT-TRANS +        
                                       WS-SUM-AMT-TRANS                 
                                                                        
           MOVE WS-PPL                       TO OUT-PPLY.               
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TXY.   
           MOVE WS-SUB-SUM-AMT-TRANS         TO OUT-CO-AMT-TRANSY.      
                                                                        
           PERFORM 8200-WRITE-OUTFILE-DETAILS       THRU 8200-EXIT.     
                                                                        
           COMPUTE WS-TOT-AMT-TRANS = WS-SUB-SUM-AMT-TRANS +            
                                         WS-TOT-AMT-TRANS               
                                                                        
           MOVE SPACES                       TO OUT-PPLX.               
           MOVE SPACES                       TO OUT-LOSS-RESERVE-TXX.   
           MOVE WS-TOT-AMT-TRANS             TO OUT-CO-AMT-TRANSX.      
                                                                        
           PERFORM 8204-WRITE-OUTFILE-DETAILS       THRU 8204-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      ** 7100-GET-CUR-REVMAX-EXT.                                     **        
      ******************************************************************        
      *                                                                         
       7100-GET-CUR-REVMAX-EXT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT  MAX(DATE_EXTRACT)                                 
                INTO :BN-DATE-EXTRACT                                   
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
               WHERE  CODE_BILL_COND    = 'C'                           
                 AND  REVENUE_MONTH = :BN-REVENUE-MONTH                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(DATE_EXTRACT)                                         
MFA-TR*         INTO :BN-DATE-EXTRACT                                           
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*        WHERE  CODE_BILL_COND    = 'C'                                   
MFA-TR*          AND  REVENUE_MONTH = :BN-REVENUE-MONTH                         
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             MOVE BN-DATE-EXTRACT            TO WS-END-DATE             
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT *********'               
              DISPLAY '** GET-REVMAX-EXTRACT FAILED   **'               
              DISPLAY '** 7100-GET-CURRENT-REVMAX-EXT **'               
              DISPLAY '** REVENUE_MONTH  = ' WS-END-REVDATE             
              DISPLAY '** RETURN CODE    = ' BN-REVENUE-MONTH           
              DISPLAY '** PROCESSING TERMINATED ********'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-GET-CUR-REVMIN-EXT.                                     **        
      ******************************************************************        
      *                                                                         
       7200-GET-CUR-REVMIN-EXT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT  MIN(DATE_EXTRACT)                                 
                INTO :BN-DATE-EXTRACT                                   
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
               WHERE  CODE_BILL_COND = 'R'                              
                 AND  REVENUE_MONTH = :BN-REVENUE-MONTH                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MIN(DATE_EXTRACT)                                         
MFA-TR*         INTO :BN-DATE-EXTRACT                                           
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*        WHERE  CODE_BILL_COND = 'R'                                      
MFA-TR*          AND  REVENUE_MONTH = :BN-REVENUE-MONTH                         
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             MOVE BN-DATE-EXTRACT            TO WS-BEG-DATE             
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT *********'               
              DISPLAY '** GET-REVMIN-EXTRACT FAILED  ***'               
              DISPLAY '** 7200-GET-CURRENT-REVMIN-EXT **'               
              DISPLAY '** REVENUE_MONTH  = ' BN-REVENUE-MONTH           
              DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '** PROCESSING TERMINATED ********'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-OPEN-MAIN-CSR.                                          **        
      ******************************************************************        
      *                                                                         
       7300-OPEN-MAIN-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN WRTOFF_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT *****'                   
              DISPLAY '** OPEN WRTOFF_CUR ERROR   **'                   
              DISPLAY '** 7300-OPEN-MAIN-CSR      **'                   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED   **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-FETCH-GET-MAIN                                          **        
      ******************************************************************        
      *                                                                         
       7400-FETCH-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH WRTOFF_CUR                                          
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:CO-PYMT-PRIORITY-LVL                               
                   ,:CO-AMT-TRANS                                       
                   ,:CO-WO-ORIGINAL-AM                                  
                   ,:CO-DATE-OF-CHG-OFF                                 
                   ,:LQ-LOSS-RESERVE-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
      *                                                                         
           WHEN NOT-FOUND                                               
              MOVE WS-Y                      TO WS-ALL-ROWS-PROCESD     
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT ******'                  
              DISPLAY '**  MAIN CURSOR FETCH ERROR **'                  
              DISPLAY '** 7400-FETCH-MAIN-CSR      **'                  
              DISPLAY '** BEGIN DATE           =' WS-BEG-DATE           
              DISPLAY '** END DATE             =' WS-END-DATE           
              DISPLAY '** RETURN CODE          =' WS-ACTIVE-RETURN-CODE 
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7500-CLOSE-MAIN-CSR                                          **        
      ******************************************************************        
      *                                                                         
       7500-CLOSE-MAIN-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE WRTOFF_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT ******'                  
              DISPLAY '** CLOSE MAIN CURSOR ERROR  **'                  
              DISPLAY '** 7550-CLOSE-MAIN-CSR      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED    **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
                                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-GET-RESERVE-DETAILS.                                    **        
      ******************************************************************        
      *                                                                         
       7700-GET-RESERVE-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT LOSS_RESERVE_PCT                                   
                    ,LOSS_RESERVE_TX                                    
                    ,GROUP_SEQ_NO                                       
                    ,LOSS_REPORT_AMT                                    
                    ,LOSS_REPORT_IND                                    
                    ,SORT_SEQ_NO                                        
               INTO :ZL-LOSS-RESERVE-PCT                                
                   ,:ZL-LOSS-RESERVE-TX                                 
                   ,:ZL-GROUP-SEQ-NO                                    
                   ,:ZL-LOSS-REPORT-AMT                                 
                   ,:ZL-LOSS-REPORT-IND                                 
                   ,:ZL-SORT-SEQ-NO                                     
                FROM CSS_LOSS_RESERVE WITH(READUNCOMMITTED)                     
               WHERE LOSS_RESERVE_CD = :LQ-LOSS-RESERVE-CD              
                 AND COMPANY_NO      = '01'                             
               ORDER BY LOSS_RESERVE_TX ASC                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOSS_RESERVE_PCT                                           
MFA-TR*             ,LOSS_RESERVE_TX                                            
MFA-TR*             ,GROUP_SEQ_NO                                               
MFA-TR*             ,LOSS_REPORT_AMT                                            
MFA-TR*             ,LOSS_REPORT_IND                                            
MFA-TR*             ,SORT_SEQ_NO                                                
MFA-TR*        INTO :ZL-LOSS-RESERVE-PCT                                        
MFA-TR*            ,:ZL-LOSS-RESERVE-TX                                         
MFA-TR*            ,:ZL-GROUP-SEQ-NO                                            
MFA-TR*            ,:ZL-LOSS-REPORT-AMT                                         
MFA-TR*            ,:ZL-LOSS-REPORT-IND                                         
MFA-TR*            ,:ZL-SORT-SEQ-NO                                             
MFA-TR*         FROM CSS_LOSS_RESERVE                                           
MFA-TR*        WHERE LOSS_RESERVE_CD = :LQ-LOSS-RESERVE-CD                      
MFA-TR*          AND COMPANY_NO      = '01'                                     
MFA-TR*        ORDER BY LOSS_RESERVE_TX ASC                                     
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
             CONTINUE                                                   
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP306 ABORT ********'                
              DISPLAY '** GET-RESERVE-DETAILS FAILED **'                
              DISPLAY '** 7700-GET-RESERVE-DETAILS   **'                
              DISPLAY '** LOSS_RESERVE_CD = ' LQ-LOSS-RESERVE-CD        
              DISPLAY '** RETURN CODE     = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '** PROCESSING TERMINATED    ****'                
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE-HEADER                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-HDR-REC-LN1                
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT331-RECORD FROM WS-RP306-HDR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP306-HDR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP306-HDR-REC-LN5                
                  AFTER ADVANCING 3 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP306-HDR-REC-LN4.               
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-OUT-RECY.                  
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8202-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8202-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-OUT-REC                    
                  AFTER ADVANCING 2 LINES.                              
      *                                                                 08335000
       8202-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8203-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8203-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-OUT-REC.                   
      *                                                                 08335000
       8203-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8204-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8204-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-OUT-RECX                   
                  AFTER ADVANCING 2 LINES.                              
      *                                                                 08335000
       8204-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-FOOTER-DETAILS                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-FOOTER-DETAILS.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN1                
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN4.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN5.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN6.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN7.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN8.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN9.               
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN10.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN11.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN12.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN13.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN14.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN15.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN16.              
           WRITE PRT331-RECORD FROM WS-RP306-FTR-REC-LN17.              
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP306 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
