       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP304.                                        
       DATE-WRITTEN.   AUG 1989.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
TP4936**    07/29/96   HAG       TPR4936 - CHANGED TO PRINT CURRENT  **         
TP4936**                         AS OF DATE IN PROPER FORMAT. ALIGNED**         
TP4936**                         HEADER & DATA FIELDS. CORRECT TO    **         
TP4936**                         DISPLAY CHRS AS -VE AMTS.           **         
T15702**    04/07/98   KLP       CORRECTED CURRENT AND RUN DATE      **         
T15702**                         VALUES TO APPEAR IN CORRECT LOCATION**         
T16379**    05/14/98   CBSI      PRINTING CR AND DB GRAND TOTALS AND **         
T16379**               MADRAS    ACCOUNT NUMBER BREAK LOGIC INCLUDED **         
T16379**                         CORRECTED THE SIGN PROBLEM FOR      **         
T16379**                         NET AMOUNT.                         **         
T21415**    01/13/2000 CBSI      REPLACED THE DATE IN HEADER-2 WITH  **         
T21415**               MADRAS    REVENUE MONTH FROM JOB_PARM TABLE   **         
T26989**    08/21/02   R. SPIRES MADE REPORT CHANGES REQUIRED FOR    **         
T26989**                         SEB REGULATED.                      **         
      **                                                             **         
A03967**   22 OCT 12   RF10596   STOP PRINTING DUPLICATE GL/LOC      **         
A03967**                         LINES WITH ZERO AMOUNTS.            **         
      **                                                             **         
      *****************************************************************         
      ** PROGRAM FLOW :                                              **         
      **                                                             **         
      **       THIS PROGRAM WILL READ FCSRP82 FILE AND CSS_COMPANY   **         
      ** TABLE TO PRINT THE PCSRP304 - GENERAL LEDGER SUMMARY REPORT.**         
      ** COMPANY BREAK LOGIC AND PAGE BREAK LOGIC ARE INCLUDED IN    **         
      ** THE PROGRAM.                                                **         
      **                                                             **         
      *****************************************************************         
      * REMARKS ..                                                              
                                                                        
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
     *                                                                  
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP82.                                                            
       COPY CSSPT33.                                                            
HPCCDM*EJECT                                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP82.                                                            
       COPY FIORP82.                                                            
       COPY CFDPT33.                                                            
HPCCDM*EJECT                                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP304'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)           VALUE        
           'WORKING STORAGE FOR PCSRP304 STARTS HERE'.                  
       01  WS-MISC.                                                     
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(50)   VALUE                
               '          GENERAL LEDGER SUMMARY REPORT           '.    
           05  WS-MORE-DATA-SW         PIC X(01)   VALUE 'Y'.           
               88  WS-NO-MORE-DATA                 VALUE 'N'.           
           05  WS-FRP82-STATUS         PIC X(02)   VALUE '00'.          
               88  FRP82-SUCCESSFUL                VALUE '00'.          
           05  WS-FCA32-STATUS         PIC X(02)   VALUE '00'.          
               88  FCA32-SUCCESSFUL                VALUE '00'.          
           05  WS-END-REC-PROCESSED    PIC X(01)   VALUE 'N'.           
           05  WS-FRP82-REC-CNTR       PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FRP82-REC-CNTR-TOT   PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-PREV-COMPANY-NO      PIC X(2)    VALUE SPACES.        
T16379     05  WS-PREV-ACCOUNT-NO      PIC 9(3)    VALUE ZEROES.        
T16379     05  WS-TEMP-NET-AMOUNT      PIC S9(15)V99  VALUE ZEROES.     
T16379     05  WS-TEMP-NET-AMOUNT1     PIC S9(15)V99  VALUE ZEROES.     
T16379     05  WS-NET-CREDITS          PIC S9(15)V99  VALUE ZEROES.     
T16379     05  WS-NET-DEBITS           PIC S9(15)V99  VALUE ZEROES.     
T16379     05  WS-FIRST-READ           PIC X(01)      VALUE 'Y'.        
T26989     05  WS-DATABASE             PIC 9(01)    VALUE ZERO.         
T26989         88  CSR-DATABASE                     VALUE 1.            
T26989         88  SEB-DATABASE                     VALUE 2.            
T26989     05  WS-MULTIPLE-ROWS-FOUND  PIC S9(4) COMP VALUE -811.       
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)   VALUE 'PCSRP304'.    
           05  WS-Y                    PIC X(01)   VALUE 'Y'.           
           05  WS-N                    PIC X(01)   VALUE 'N'.           
           05  WS-1                    PIC X(01)   VALUE '1'.           
           05  WS-2                    PIC X(01)   VALUE '2'.           
           05  FIRST-TIME-SW           PIC X(01)   VALUE 'Y'.           
      *                                                                         
A03967 01  WS-SAVE-GL-ACCOUNT-NO       PIC X(12) VALUE SPACES.          
      *                                                                         
T21415 01  WS-REV-MTH.                                                  
T21415     05  WS-REV-MM               PIC 9(02).                       
T21415     05  FILLER                  PIC X(01)   VALUE '/'.           
T21415     05  WS-REV-CCYY             PIC 9(04).                       
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      *  COPY BOOK TO SUPPORT DB2 AND CICS ERROR CHECKING.            *         
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
T21415 COPY CWS00114.                                                           
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPY BOOK                                        *         
      *****************************************************************         
       COPY CWS09900.                                                           
      ******************************************************************        
      *   FCA00 MISC                                                   *        
      ******************************************************************        
       COPY CWS00039.                                                           
      ******************************************************************        
      *  COPY BOOK FOR REPORT HEADER                                   *        
      ******************************************************************        
       COPY CWS00079.                                                           
      *                                                                         
T21415****************************************************************          
T21415**  COMMON WORKING STORAGE FOR REPORT HEADER1                 **          
T21415****************************************************************          
T21415 01  WS-REPORT-HEADER-1.                                          
           05  FILLER              PIC X        VALUE SPACE.            
T21415     05  FILLER                   PIC X(16) VALUE                 
T21415                                            'REVENUE MONTH : '.   
T21415     05  P-RPT-REVENUE-MONTH      PIC X(07).                      
T21415     05  FILLER                   PIC X(20) VALUE SPACES.         
T21415     05  P-RPT-HEADER             PIC X(50).                      
T21415     05  FILLER                   PIC X(20) VALUE SPACES.         
T21415     05  FILLER                   PIC X(11) VALUE 'RUN TIME:  '.  
T21415     05  P-RPT-RUN-TIME           PIC X(08).                      
T21415*                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER              PIC X        VALUE SPACE.            
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(22)                       
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                   PIC X(55) VALUE SPACES.         
      *                                                                         
       01  WS-END-OF-REPORT.                                            
           05  FILLER              PIC X        VALUE SPACE.            
           05  FILLER                   PIC X(56) VALUE SPACES.         
           05  FILLER                   PIC X(19)                       
               VALUE '** END OF REPORT **'.                             
           05  FILLER                   PIC X(57) VALUE SPACES.         
      *                                                                         
       01  WS-PRINTER-CONTROL.                                          
           05  WS-RPT1-LINE-NO          PIC 9(02) COMP-3 VALUE 60.      
           05  WS-PAGE-SIZE             PIC 9(04) COMP-3 VALUE 52.      
           05  WS-RPT1-PAGE-NO          PIC 9(04) COMP-3 VALUE ZERO.    
      *                                                                         
       01  WS-RPT1-TITLE-LINES.                                         
           05  WS-TITLE-LINE-1.                                         
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER                   PIC X(11)  VALUE            
                   'G/L ACCOUNT'.                                       
TP4936         10  FILLER                   PIC X(51)  VALUE SPACES.    
               10  FILLER                   PIC X(13)  VALUE            
                   'MONTH TO DATE'.                                     
TP4936         10  FILLER                   PIC X(06)  VALUE SPACES.    
               10  FILLER                   PIC X(13)  VALUE            
                   'MONTH TO DATE'.                                     
               10  FILLER                   PIC X(40)  VALUE SPACES.    
           05  WS-TITLE-LINE-2.                                         
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER                   PIC X(6)   VALUE 'NUMBER'.  
TP4936         10  FILLER                   PIC X(19)  VALUE SPACES.    
               10  FILLER                   PIC X(13)  VALUE            
                   'ACCOUNT TITLE'.                                     
TP4936         10  FILLER                   PIC X(06)  VALUE SPACES.    
               10  FILLER                   PIC X(13)  VALUE            
                   'BEGIN BALANCE'.                                     
               10  FILLER                   PIC X(12)  VALUE SPACES.    
               10  FILLER                   PIC X(6)   VALUE            
                   'DEBITS'.                                            
TP4936         10  FILLER                   PIC X(12)  VALUE SPACES.    
               10  FILLER                   PIC X(7)   VALUE            
                   'CREDITS'.                                           
TP4936         10  FILLER                   PIC X(5)   VALUE SPACES.    
               10  FILLER                   PIC X(14)  VALUE            
                   'ENDING BALANCE'.                                    
TP4936         10  FILLER                   PIC X(9)   VALUE SPACES.    
               10  FILLER                   PIC X(10)  VALUE            
                   'NET AMOUNT'.                                        
               10  FILLER                   PIC X(2)   VALUE SPACES.    
      *                                                                         
       01  WS-RPT1-TOTAL-LINE.                                          
           05  FILLER              PIC X        VALUE SPACE.            
           05  WS-ACCOUNT-NUMBER         PIC 999.                       
           05  FILLER                    PIC X      VALUE '.'.          
           05  FILLER                    PIC X(04)  VALUE 'XXXX'.       
           05  FILLER                    PIC X(08)  VALUE               
               '   TOTAL'.                                              
           05  FILLER                    PIC X(98)  VALUE SPACES.       
           05  WS-ACCT-NET-AMOUNT        PIC -(14)9.99.                 
      *                                                                         
T16379 01  WS-PRINT-CREDIT-LINE.                                        
           05  FILLER              PIC X        VALUE SPACE.            
T16379     05  FILLER                    PIC X(23)    VALUE             
T16379         'GRAND NET CREDITS   =  '.                               
T16379     05  WS-GRAND-NET-CREDITS      PIC Z(15)9.99.                 
      *                                                                         
T16379 01  WS-PRINT-DEBIT-LINE.                                         
           05  FILLER              PIC X        VALUE SPACE.            
T16379     05  FILLER                    PIC X(23)    VALUE             
T16379         'GRAND NET DEBITS    =  '.                               
T16379     05  WS-GRAND-NET-DEBITS       PIC Z(15)9.99.                 
      *                                                                         
       01  WS-DETAIL-LINE.                                              
           05  FILLER              PIC X        VALUE SPACE.            
           05  WS-GL-ACCOUNT-NO.                                        
               10  WS-GL-FERC            PIC 999.                       
               10  FILLER                PIC X      VALUE '.'.          
               10  WS-GL-SUBCODE         PIC 9999.                      
               10  FILLER                PIC X      VALUE '.'.          
               10  WS-GL-LOCAL-OFFICE    PIC 999.                       
           05  FILLER                    PIC X      VALUE SPACES.       
           05  WS-ACCOUNT-TITLE          PIC X(25).                     
           05  FILLER                    PIC X      VALUE SPACES.       
TP4936     05  WS-BEGIN-BALANCE          PIC -(14)9.99.                 
           05  FILLER                    PIC X(1)   VALUE SPACES.       
TP4936     05  WS-MTD-DEBITS             PIC -(13)9.99.                 
TP4936     05  FILLER                    PIC X(1)   VALUE SPACES.       
TP4936     05  WS-MTD-CREDITS            PIC -(14)9.99.                 
TP4936     05  FILLER                    PIC X(1)   VALUE SPACES.       
TP4936     05  WS-ENDING-BALANCE         PIC -(14)9.99.                 
TP4936     05  FILLER                    PIC X(1)   VALUE SPACES.       
TP4936     05  WS-NET-AMOUNT             PIC -(14)9.99.                 
      *                                                                         
HPCCDM*EJECT                                                                    
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE              PIC X(02).                   
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 9(02).                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
T26989     EXEC SQL                                                             
T26989         INCLUDE TBDELQ                                                   
T26989     END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)           VALUE        
           'WORKING STORAGE FOR PCSRP304 ENDS HERE'.                    
      *                                                                         
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *        CONTROLS THE MAIN PROCESSING OF THE PROGRAM            *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC THRU 1000-EXIT.               
      *                                                                         
           PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT.                   
           PERFORM 1100-PRODUCE-REPORTS THRU 1100-EXIT                  
               UNTIL WS-NO-MORE-DATA                                    
      *                                                                         
           IF  WS-FRP82-REC-CNTR  EQUAL WS-FRP82-REC-CNTR-TOT           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY  ' '                                             
               DISPLAY  '*   PCSRP304  PROCESSING ERROR             *'  
               DISPLAY  '* ACTUAL REC COUNT DOES NOT MATCH CNTL REC *'  
               DISPLAY  '*   CONTROL REC COUNT - '                      
                         WS-FRP82-REC-CNTR-TOT '        *'              
               DISPLAY  '*   ACTUAL  REC COUNT - '                      
                         WS-FRP82-REC-CNTR '            *'              
               DISPLAY  '*   PROCESSING TERMINATED                  *'  
               PERFORM  9900-ABEND  THRU  9900-EXIT                     
           END-IF.                                                      
      *                                                                         
           IF  WS-FRP82-REC-CNTR EQUAL ZERO                             
               PERFORM 8100-PRINT-RPT1-HEADER THRU 8100-EXIT            
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                  
                   AFTER ADVANCING 2 LINES                              
           END-IF.                                                      
      *                                                                         
T16379     IF WS-NET-CREDITS = ZEROES AND WS-NET-DEBITS = ZEROES        
T16379        CONTINUE                                                  
T16379     ELSE                                                         
T16379        PERFORM 8800-PRINT-GRAND-TOTS  THRU  8800-EXIT            
T16379     END-IF.                                                      
TP4936     WRITE PRT33-RECORD FROM WS-END-OF-REPORT                     
TP4936         AFTER ADVANCING 3 LINES.                                 
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  GET THE COMMON DATE AND THE SYSTEM DATE AND TIME FOR PRINTING *        
      *  REPORT HEADERS. OPEN THE FILE FCSRP82 AND FCSPT33 IN INPUT AND*        
      *  OUTPUT MODES RESPECTIVELY.                                    *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
T21415*    PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                          
T21415*    IF COMMON-DATE-NEEDED                                                
T21415*       PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT                 
T21415*       MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                        
T21415*    END-IF.                                                              
T21415*    MOVE WS-INPUT-DATE(3:2)       TO WS-TD-YY.                           
T21415*    MOVE WS-INPUT-DATE(6:2)       TO WS-TD-MM.                           
T21415*    MOVE WS-INPUT-DATE(9:2)       TO WS-TD-DD.                           
      *                                                                         
           ACCEPT WS-PRESENT-DATE FROM DATE.                            
           MOVE WS-PRESENT-DATE(1:2)     TO WS-RD-YY.                   
           MOVE WS-PRESENT-DATE(3:2)     TO WS-RD-MM.                   
           MOVE WS-PRESENT-DATE(5:2)     TO WS-RD-DD.                   
           ACCEPT WS-PRESENT-TIME FROM TIME.                            
           MOVE WS-PRESENT-TIME(1:2)     TO WS-RT-HH.                   
           MOVE WS-PRESENT-TIME(3:2)     TO WS-RT-MM.                   
           MOVE WS-PRESENT-TIME(5:2)     TO WS-RT-SS.                   
      *                                                                         
           MOVE WS-PGRMNAME              TO P-RPT1-PGRMNAME.            
           MOVE C7-COMPANY-NAME          TO P-RPT1-COMPANY-NAME.        
           MOVE WS-RUN-DATE              TO P-RPT1-RUN-DATE.            
T21415*    MOVE WS-H-TRAN-DATE           TO P-RPT1-TRAN-DATE.                   
T21415     MOVE WS-DEFAULT-RPT1-HEAD1    TO P-RPT-HEADER.               
T21415     MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME.             
      *                                                                         
T21415     INITIALIZE WS-SYSIPT                                         
T21415                WS-INPUT-DATA-BREAKDOWN.                          
T21415*                                                                         
T21415     PERFORM 6200-GET-PARAMETER-DATE                              
T21415                                   THRU 6200-EXIT.                
T21415     MOVE WS-PARM-MONTH            TO WS-REV-MM.                  
T21415     MOVE WS-PARM-YR               TO WS-REV-CCYY.                
T21415     MOVE WS-REV-MTH               TO P-RPT-REVENUE-MONTH.        
T21415                                                                  
T21415     IF NOT END-OF-SYSIPT                                         
T21415         PERFORM 7611-CLOSE        THRU 7611-EXIT                 
T21415     END-IF.                                                      
T21415*                                                                         
           OPEN INPUT FCSRP82-FILE.                                     
           IF FRP82-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP82 OPEN.  STATUS IS '        
                        WS-FRP82-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF FCA32-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSPT33 OPEN.  STATUS IS '        
                        WS-FCA32-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO PRT33-RECORD.                                 
T26989                                                                  
T26989     MOVE ZERO                           TO WS-DATABASE.          
T26989     MOVE '01'                           TO C8-COMPANY-NO.        
T26989     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
T26989     PERFORM 7900-SELECT-DELINQ-VALUE    THRU 7900-EXIT.          
T26989     MOVE C8-DELINQ-VALUE                TO WS-DATABASE.          
T26989                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *    READ FILE FCSRP82 AND PROCESS BEGIN RECORD. THE CREATE DATE *        
      *    IN BEGIN RECORD IS USED IN THE REPORT HEADER. IF THE RECORD *        
      *    IS NOT A BEGIN RECORD THEN ABEND WITH AN ERROR MESSAGE.     *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-BEGIN-REC.                                          
           PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT.                   
      *                                                                         
           IF E-FRP82-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FRP82-REC-CNTR                        
           ELSE                                                         
               DISPLAY '**       PCSRP304 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
TP4936     MOVE E-FRP82-CREATE-DATE-BREC(9:2) TO WS-TD-YY.              
TP4936     MOVE E-FRP82-CREATE-DATE-BREC(1:2) TO WS-TD-MM.              
TP4936     MOVE E-FRP82-CREATE-DATE-BREC(4:2) TO WS-TD-DD.              
           MOVE WS-H-TRAN-DATE                TO P-RPT1-REPORT-DATE.    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  CHECK WHETHER END RECORD IS PROCESSED AND CHECK FOR COMPANY   *        
      *  BREAK ALSO. IF THE RECORD IS A DETAIL RECORD THEN PRINT IT.   *        
      *                                                                *        
      ******************************************************************        
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF WS-END-REC-PROCESSED EQUAL WS-Y                           
              IF E-FRP82-KEY-EREC EQUAL HIGH-VALUES                     
                 PERFORM 1900-PROCESS-END-REC THRU 1900-EXIT            
                 PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT              
                 GO TO 1100-EXIT                                        
              ELSE                                                      
                 DISPLAY '**       PCSRP304 PROCESSING ERROR       **'  
                 DISPLAY '**  LAST RECORD IS NOT A CONTROL RECORD  **'  
                 DISPLAY '**         PROCESSING TERMINATED         **'  
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           ELSE                                                         
              IF E-FRP82-KEY-EREC EQUAL HIGH-VALUES                     
                  PERFORM 1900-PROCESS-END-REC THRU 1900-EXIT           
                  PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT             
                  GO TO 1100-EXIT                                       
              ELSE                                                      
                 IF E-FRP82-CO-KEY-EREC EQUAL HIGH-VALUES               
                    SUBTRACT 1 FROM   WS-FRP82-REC-CNTR                 
                    PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT           
                    GO TO 1100-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
T16379     IF WS-FIRST-READ = 'Y'                                       
              NEXT SENTENCE                                             
           ELSE                                                         
T16379        IF E-FRP82-GL-FERC  EQUAL WS-PREV-ACCOUNT-NO              
T16379            NEXT SENTENCE                                         
T16379        ELSE                                                      
T16379            MOVE WS-PREV-ACCOUNT-NO     TO WS-ACCOUNT-NUMBER      
T16379            MOVE WS-TEMP-NET-AMOUNT1    TO  WS-ACCT-NET-AMOUNT    
T16379            PERFORM 8300-PRINT-RPT1-TOTAL THRU 8300-EXIT          
T16379            MOVE ZEROES                 TO WS-ACCT-NET-AMOUNT     
T16379                                           WS-TEMP-NET-AMOUNT1    
T16379        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF E-FRP82-COMPANY-NO EQUAL WS-PREV-COMPANY-NO               
               NEXT SENTENCE                                            
           ELSE                                                         
T16379         IF WS-NET-CREDITS NOT = ZEROES AND                       
T16379            WS-NET-DEBITS  NOT = ZEROES                           
T16379             PERFORM 8800-PRINT-GRAND-TOTS  THRU  8800-EXIT       
T16379             MOVE  ZEROES                TO WS-NET-CREDITS        
T16379                                            WS-NET-DEBITS         
T16379         END-IF                                                   
               MOVE E-FRP82-COMPANY-NO     TO C7-COMPANY-NO             
T26989         IF SEB-DATABASE                                          
T26989           IF E-FRP82-COMPANY-NO EQUAL 'RE'                       
T26989              MOVE 'SCANA ENERGY - REGULATED '                    
T26989                                     TO P-RPT1-COMPANY-NAME       
T26989              MOVE 'RE'              TO WS-PREV-COMPANY-NO        
T26989           ELSE                                                   
T26989              MOVE 'SCANA ENERGY - DEREGULATED'                   
T26989                                     TO P-RPT1-COMPANY-NAME       
T26989              MOVE C7-COMPANY-NO     TO WS-PREV-COMPANY-NO        
T26989           END-IF                                                 
T26989         ELSE                                                     
                 PERFORM 7300-GET-COMPANY-NAME THRU 7300-EXIT           
                 MOVE C7-COMPANY-NAME      TO P-RPT1-COMPANY-NAME       
                 MOVE C7-COMPANY-NO        TO WS-PREV-COMPANY-NO        
T26989         END-IF                                                   
               MOVE ZERO                   TO WS-RPT1-PAGE-NO           
               PERFORM 8100-PRINT-RPT1-HEADER THRU 8100-EXIT            
           END-IF.                                                      
T26989                                                                  
T16379     COMPUTE WS-TEMP-NET-AMOUNT =                                 
T16379            (E-FRP82-MTD-DEBIT - E-FRP82-MTD-CREDIT).             
T16379     ADD WS-TEMP-NET-AMOUNT             TO  WS-TEMP-NET-AMOUNT1.  
T16379     IF WS-TEMP-NET-AMOUNT  IS POSITIVE                           
T16379         ADD WS-TEMP-NET-AMOUNT    TO  WS-NET-DEBITS              
T16379     ELSE                                                         
T16379         ADD WS-TEMP-NET-AMOUNT    TO  WS-NET-CREDITS             
T16379     END-IF.                                                      
T16379     MOVE    'N'                   TO WS-FIRST-READ.              
           PERFORM 2100-PRODUCE-RPT1   THRU 2100-EXIT.                  
           PERFORM 7100-READ-RPT-FILE THRU 7100-EXIT.                   
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  KEEP TRACK OF THE RECORD TOTAL COUNTER.                       *        
      *                                                                *        
      ******************************************************************        
       1900-PROCESS-END-REC.                                            
           SUBTRACT 1 FROM WS-FRP82-REC-CNTR.                           
           MOVE E-FRP82-RECORD-COUNT-EREC TO WS-FRP82-REC-CNTR-TOT.     
           MOVE WS-Y TO WS-END-REC-PROCESSED.                           
       1900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * PRINT THE REPORT HEADER AND REPORT DETAIL LINES.               *        
      *                                                                *        
      ******************************************************************        
       2100-PRODUCE-RPT1.                                               
           IF WS-RPT1-LINE-NO GREATER THAN WS-PAGE-SIZE                 
              PERFORM 8100-PRINT-RPT1-HEADER THRU 8100-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 8900-PRINT-RPT1-DETAIL THRU 8900-EXIT.               
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
T21415* 6200-GET-PARAMETER-DATE                                                 
T21415* COPY BOOK TO GET REPORT DATE                                            
T21415******************************************************************        
T21415     EXEC SQL                                                             
T21415          INCLUDE CPD00114                                                
T21415     END-EXEC.                                                            
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      * COPY BOOK TO GET COMMON DATE                                   *        
      ******************************************************************        
       COPY CPD00040.                                                           
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      * COPY BOOK TO GET JOB PARM DATE                                 *        
      ******************************************************************        
       COPY CPD00037.                                                           
      ******************************************************************        
      * 7000-START-FJC01 ..                                            *        
      * SQL STATEMENTS TO RETRIEVE DATE FROM JOB PARM TABLE            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      ******************************************************************        
      *                                                                *        
      *      READ THE INPUT FILE AND CHECK THE STATUS OF THE INPUT FILE*        
      *                                                                *        
      ******************************************************************        
       7100-READ-RPT-FILE.                                              
           READ FCSRP82-FILE                                            
               AT END                                                   
                   MOVE WS-N TO WS-MORE-DATA-SW                         
                   GO TO 7100-EXIT.                                     
      *                                                                         
           IF FRP82-SUCCESSFUL                                          
               ADD 1                     TO WS-FRP82-REC-CNTR           
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP82 READ.  STATUS IS '        
                        WS-FRP82-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *          GET COMPANY NAME FROM COMPANY NUMBER                  *        
      *                                                                *        
      ******************************************************************        
       7300-GET-COMPANY-NAME.                                           
           EXEC SQL                                                     
                SELECT COMPANY_NAME                                     
                INTO :C7-COMPANY-NAME                                   
              FROM CSS_COMPANY                                          
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**       PCSRP304 PROCESSING ERROR       **'     
              DISPLAY '**     ERROR IN 7300-GET-COMPANY NAME    **'     
              DISPLAY '**     SQL CODE IS   **' SQLCODE                 
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26989****************************************************************          
T26989**                                                            **          
T26989**  7900-SELECT-DELINQ-VALUE                                  **          
T26989**     READS THE DATABASE FROM THE DELINQUENCY TABLE          **          
T26989**                                                            **          
T26989****************************************************************          
T26989*                                                                         
T26989 7900-SELECT-DELINQ-VALUE.                                        
T26989*                                                                         
T26989     MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                          
T26989                                                                  
T26989     EXEC SQL                                                     
T26989        SELECT DELINQ_VALUE                                       
T26989          INTO :C8-DELINQ-VALUE                                   
T26989          FROM CSS_DELINQUENCY                                    
T26989         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
T26989           AND COMPANY_NO = :C8-COMPANY-NO                        
T26989     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26989                                                                  
T26989     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T26989                                                                  
T26989     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
T26989         WS-MULTIPLE-ROWS-FOUND                                   
T26989         CONTINUE                                                 
T26989     ELSE                                                         
T26989         DISPLAY '**************************************'         
T26989         DISPLAY '**     PCSRP304 PROCESSING ERROR    **'         
T26989         DISPLAY '**       ERROR SELECTING DELINQUENCY**'         
T26989         DISPLAY '**       PROCESSING TERMINATED IN 7900'         
T26989         DISPLAY '**************************************'         
T26989         PERFORM 9900-ABEND         THRU 9900-EXIT                
T26989     END-IF.                                                      
T26989*                                                                         
T26989 7900-EXIT.                                                       
T26989     EXIT.                                                        
T26989*                                                                         
       8100-PRINT-RPT1-HEADER.                                          
           PERFORM 8500-PRINT-HEADER-LINES THRU 8500-EXIT.              
           MOVE SPACES TO PRT33-RECORD.                                 
           WRITE PRT33-RECORD AFTER 1.                                  
           ADD 1 TO WS-RPT1-LINE-NO.                                    
           PERFORM 8600-PRINT-EXTRA-HDR-LN THRU 8600-EXIT.              
           MOVE SPACES TO PRT33-RECORD.                                 
           WRITE PRT33-RECORD AFTER 1.                                  
           ADD 1 TO WS-RPT1-LINE-NO.                                    
           MOVE ZERO TO WS-RPT1-LINE-NO.                                
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     PRINTS TOTAL NET AMOUNT FOR ACCT-NO BREAK                  *        
      *                                                                *        
      ******************************************************************        
T16379 8300-PRINT-RPT1-TOTAL.                                           
T16379     IF WS-RPT1-LINE-NO GREATER THAN WS-PAGE-SIZE                 
T16379        PERFORM 8100-PRINT-RPT1-HEADER THRU 8100-EXIT             
T16379     END-IF.                                                      
T16379     WRITE PRT33-RECORD FROM WS-RPT1-TOTAL-LINE.                  
T16379     MOVE SPACES          TO PRT33-RECORD.                        
T16379     WRITE PRT33-RECORD.                                          
T16379     ADD  2               TO WS-RPT1-LINE-NO.                     
T16379 8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *    PRINT HEADER LINES                                          *        
      *                                                                *        
      ******************************************************************        
       8500-PRINT-HEADER-LINES.                                         
      *                                                                         
           ADD 1 TO WS-RPT1-PAGE-NO.                                    
           MOVE WS-RPT1-PAGE-NO TO P-RPT1-PAGE-NO.                      
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
               AFTER ADVANCING TOP-OF-PAGE.                             
T21415     WRITE PRT33-RECORD FROM WS-REPORT-HEADER-1                   
               AFTER ADVANCING 1.                                       
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
               AFTER ADVANCING 1.                                       
           MOVE 3 TO WS-RPT1-LINE-NO.                                   
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *   PRINT THE EXTRA HEADER LINE                                  *        
      *                                                                *        
      ******************************************************************        
       8600-PRINT-EXTRA-HDR-LN.                                         
           WRITE PRT33-RECORD FROM WS-TITLE-LINE-1.                     
           WRITE PRT33-RECORD FROM WS-TITLE-LINE-2.                     
           ADD 2 TO WS-RPT1-LINE-NO.                                    
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     PRINTS GRAND TOTALS FOR CREDIT AND DEBIT                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
T16379 8800-PRINT-GRAND-TOTS.                                           
T16379      IF WS-RPT1-LINE-NO GREATER THAN WS-PAGE-SIZE                
T16379         PERFORM 8100-PRINT-RPT1-HEADER THRU 8100-EXIT            
T16379      END-IF.                                                     
T16379      MOVE WS-NET-CREDITS TO WS-GRAND-NET-CREDITS.                
T16379      MOVE WS-NET-DEBITS  TO WS-GRAND-NET-DEBITS.                 
T16379      WRITE PRT33-RECORD FROM WS-PRINT-DEBIT-LINE.                
T16379      WRITE PRT33-RECORD FROM WS-PRINT-CREDIT-LINE.               
T16379      ADD 2 TO WS-RPT1-LINE-NO.                                   
T16379 8800-EXIT.                                                       
T16379      EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      *   PRINT THE REPORT DETAIL LINE.                                *        
      *                                                                *        
      ******************************************************************        
       8900-PRINT-RPT1-DETAIL.                                          
      *                                                                         
           MOVE E-FRP82-GL-ACCOUNT-NO(1:3) TO WS-GL-FERC.               
           MOVE E-FRP82-GL-ACCOUNT-NO(4:4) TO WS-GL-SUBCODE.            
           MOVE E-FRP82-GL-ACCOUNT-NO(8:3) TO WS-GL-LOCAL-OFFICE.       
           MOVE E-FRP82-ACCOUNT-TITLE    TO WS-ACCOUNT-TITLE.           
           MOVE E-FRP82-BEGIN-BALANCE    TO WS-BEGIN-BALANCE.           
           MOVE E-FRP82-MTD-DEBIT        TO WS-MTD-DEBITS.              
           MOVE E-FRP82-MTD-CREDIT       TO WS-MTD-CREDITS.             
           MOVE E-FRP82-END-BALANCE      TO WS-ENDING-BALANCE.          
T16379     MOVE WS-TEMP-NET-AMOUNT       TO WS-NET-AMOUNT.              
T16379     MOVE E-FRP82-GL-FERC          TO WS-PREV-ACCOUNT-NO.         
      *                                                                         
A03967     IF WS-GL-ACCOUNT-NO = WS-SAVE-GL-ACCOUNT-NO                  
A03967        IF E-FRP82-BEGIN-BALANCE = 0                              
A03967             AND E-FRP82-MTD-DEBIT = 0                            
A03967             AND E-FRP82-MTD-CREDIT = 0                           
A03967             AND E-FRP82-END-BALANCE = 0                          
A03967             AND E-FRP82-NET-AMOUNT = 0                           
A03967           CONTINUE                                               
A03967        ELSE                                                      
A03967           WRITE PRT33-RECORD FROM WS-DETAIL-LINE                 
A03967           ADD 1 TO WS-RPT1-LINE-NO                               
A03967        END-IF                                                    
A03967     ELSE                                                         
              WRITE PRT33-RECORD FROM WS-DETAIL-LINE                    
              ADD 1 TO WS-RPT1-LINE-NO                                  
A03967        MOVE WS-GL-ACCOUNT-NO TO WS-SAVE-GL-ACCOUNT-NO            
A03967     END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP82-FILE                                           
                 FCSPT33-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
             END-EXEC.                                                          
