       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP301.                                        
       DATE-WRITTEN.   NOVEMBER, 1986.                                  
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **          
      **                     PRICE WATERHOUSE                       **          
      **                1410 NORTH WESTSHORE BLVD                   **          
      **                   TAMPA, FLORIDA  33607                    **          
      **                      (813) 287-9200                        **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **    DATE    INITIALS     REASON                             **          
      **  ________  ________     _________________________________  **          
      **  07/12/95    LMB        CHANGED DEVICE_NO                  **          
      **                              TO DEVICE_TYPE_CD             **          
      **                         CHANGED IX-DEVICE-NO               **          
      **                              TO IX-DEVICE-TYPE-CD          **          
      **  --------  --------     ---------------------------------- **          
      **  03/06/96     DW        ADDED CODE_UTIL_TYPE TO SELECT OF  **          
      **                         CSS_ELEC_METER AND CSS_GAS_METER.  **          
PCR156**  09/96     CBSI         RENAMED WS-LOCAL-OFFICE-1,WS-LOCAL-**          
      **            MADRAS       OFFICE-2,E-FMT01-LOCAL-OFFICE TO   **          
      **                         WS-MTR-STORAGE-FAC-CD-1,           **          
      **                         WS-MTR-STORAGE-FAC-CD-2,           **          
      **                         E-FMT01-MTR-STORAGE-FAC-CD         **          
PCR040**  12/96     CBSI         REMOVED ALL REFERENCES TO          **          
PCR040**            MADRAS       CODE_CO_SIZE FIELD OF CSS_ELEC_METER*          
PCR040**                         AS THIS FIELD IS REMOVED FROM THE  **          
PCR040**                         TABLE                              **          
T14799**   03/98    BAB          MODIFIED WS-DIS-DATE.              **          
T18652**   12/98    CBSI         CHANGES MADE TO EXTRACT THE DETAILS**          
T18652**                         OF THE ELEC, GAS & XFORMERS INTO   **          
T18652**                         THREE FILES INSTEAD OF ONE FILE.   **          
T19027**   02/99    CBSI         CODE CHANGED TO ADD 1 TO A 4-DIGIT **          
T19027**                         YEAR INSTEAD OF A 2-DIGIT YEAR.    **          
T22243**   09/00    CBSI         CHANGES MADE TO IMPLEMENT MULTI-   **          
T22243**            CHENNAI      COMPANY IN METER INVENTORY.        **          
      **                                                            **          
C36457** 11/02/07   RC41079      DELETE REFERENCES TO CSS_WTR_SWR_  **          
C36457**                         METER AND TBWSMTR.                 **          
ACT123** 06/15/15   RS7M249      REMOVED UNUSED COPYBOOKS.          **          
ACT072** 03/08/16   MS7M727      REMOVED COMMENTED CODE AND CONVERTED*          
ACT072**            A05460       EXTRACTS RETIRED ELECTRIC/GAS METERS*          
ACT072**                         XFORMERS,AND ATTACHMENTS IN THE    **          
ACT072**                         CURRENT MONTH                      **          
      **                                                            **          
A05744** 22 FEB 2017 RF10596     ADD RETIREMENT CODE TO MT22 FILE   **          
      **                                                            **          
      ****************************************************************          
T18652     REMARKS.                                                     
T18652                        PCSMT301 NARRATIVE                        
T18652                    PRS-CIS INTERFACE PROGRAM                     
      *                                                                         
T18652           THIS PROGRAM EXTRACTS RETIRED ELECTRIC/GAS METERS,     
T18652           XFORMERS,AND ATTACHMENTS IN THE CURRENT MONTH INTO     
                 FOUR FILES. THESE FILES WILL BE SENT AS INPUT TO       
T18652           ELC300(ELECTRIC), GMC300(GAS), ELC301(XFORMERS),       
                 AND GMC301(ATTACHMENTS) PROGRAMS WHICH PRODUCE         
T18652           REPORTS FOR PRS SYSTEM.                                
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT01.                                                            
ACT072 COPY CSSMT01B.                                                           
ACT072                                                                  
       COPY CSSMT02.                                                            
T18652 COPY CSSMT22.                                                            
T18652 COPY CSSMT23.                                                            
      ******************************************************************        
      * CSSMT26- SELECT STATEMENT FOR FCSMT26 FILE                     *        
      ******************************************************************        
T12999 COPY CSSMT26.                                                            
ACT072 COPY CSSMT26B.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDMT01.                                                            
ACT072 COPY FIOMT01A.                                                           
      *                                                                         
ACT072 COPY CFDMT01B.                                                           
ACT072 COPY FIOMT01B.                                                           
      *                                                                         
       COPY CFDMT02.                                                            
       COPY FIOMT02.                                                            
      *                                                                         
T18652 COPY CFDMT22.                                                            
ACT072 COPY FIOMT22A.                                                           
T18652*                                                                         
T18652 COPY CFDMT23.                                                            
ACT072 COPY FIOMT23A.                                                           
T18652*                                                                         
      ***************************************************************           
      ** CFDMT26 - FILE DESCRIPTION FOR THE FILE FCSMT26           **           
      ***************************************************************           
T12999 COPY CFDMT26.                                                            
      *                                                                         
      ******************************************************************        
      * FIOMT26 - IO AREA FOR THE ATTACHMENT PROPERTY EXTRACT FILE     *        
      ******************************************************************        
ACT072 COPY FIOMT26A.                                                           
                                                                        
ACT072 COPY CFDMT26B.                                                           
ACT072 COPY FIOMT26B.                                                           
T12999*                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP301'.
MSQ017     COPY MFASQLM.
      *                                                                         
       77  WS-MIN-DIV-NO               PIC X(2).                        
       77  WS-MAX-DIV-NO               PIC X(2).                        
       77  WS-MAX-LOC                  PIC S9(04)   COMP.               
       77  WS-MIN-LOC                  PIC S9(04)   COMP.               
       77  WS-MAX-METER-NO             PIC X(09).                       
       77  WS-MIN-METER-NO             PIC X(09).                       
      *                                                                         
       01  WORK-STORAGE-BEGIN.                                          
           05  FILLER                  PIC X(20)    VALUE               
               'WORKING STORAGE FOR '.                                  
           05  WS-PROGRAM-NAME         PIC X(08)    VALUE               
               'PCSMT301'.                                              
           05  FILLER                  PIC X(12)    VALUE               
               ' BEGINS HERE'.                                          
      *                                                                         
ACT072*****************************************************************         
ACT072*    CSS_MTR_STORGE_FAC W9                                                
ACT072*****************************************************************         
ACT072*                                                                         
ACT072     EXEC SQL                                                             
ACT072         INCLUDE  TBMTRFAC                                                
ACT072     END-EXEC.                                                            
ACT072*                                                                         
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00004.                                                           
      *                                                                         
       01  WS-CONSTANTS.                                                
           05  WS-1                    PIC X(01)    VALUE '1'.          
           05  WS-2                    PIC X(01)    VALUE '2'.          
           05  WS-3                    PIC X(01)    VALUE '3'.          
           05  WS-4                    PIC X(01)    VALUE '4'.          
           05  WS-5                    PIC X(01)    VALUE '5'.          
           05  WS-6                    PIC X(01)    VALUE '6'.          
           05  WS-7                    PIC X(01)    VALUE '7'.          
           05  WS-D                    PIC X(01)    VALUE 'D'.          
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-I                    PIC X(01)    VALUE 'I'.          
           05  WS-J                    PIC X(01)    VALUE 'J'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-NO                   PIC X(01)    VALUE 'N'.          
           05  WS-MT                   PIC X(02)    VALUE 'MT'.         
           05  WS-TF                   PIC X(02)    VALUE 'TF'.         
           05  WS-PARAMETER-KEY.                                        
               10  WS-PARM-PROG        PIC X(08)    VALUE 'PCSMT301'.   
               10  WS-PARM-CMND        PIC X(04)    VALUE 'PARM'.       
               10  WS-PARM-SEQ         PIC 9(03)    VALUE ZERO.         
           05  WS-S                    PIC X(01)    VALUE 'S'.          
           05  WS-T                    PIC X(01)    VALUE 'T'.          
           05  WS-W                    PIC X(01)    VALUE 'W'.          
           05  WS-X                    PIC X(01)    VALUE 'X'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-YES                  PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSMT301'.   
           05  WS-PCSMT301             PIC X(08)    VALUE 'PCSMT301'.   
ACT072     05  WS-UTIL-TYPE            PIC X(01)    VALUE SPACES.       
ACT072     05  WS-COMPANY-NO           PIC X(02)    VALUE SPACES.       
ACT072     05  WS-PREV-COMPANY-NO      PIC X(02)    VALUE SPACES.       
ACT072     05  WS-COMMA                PIC X(01)    VALUE ",".          
      *                                                                         
       01  WS-88-LEVEL-FLAGS.                                           
           05  WS-EOF-MT-FLAG          PIC X(01)    VALUE 'N'.          
               88  EOF-MT                           VALUE 'Y'.          
           05  WS-EOF-PARM-FLAG        PIC X(01)    VALUE 'N'.          
               88  EOF-PARM                         VALUE 'Y'.          
           05  WS-PROCESS-ELEC-FLAG    PIC X(01)    VALUE 'N'.          
               88  PROCESS-ELECTRIC                 VALUE 'Y'.          
           05  WS-PROCESS-GAS-FLAG     PIC X(01)    VALUE 'N'.          
               88  PROCESS-GAS                      VALUE 'Y'.          
           05  WS-PROCESS-WATER-FLAG   PIC X(01)    VALUE 'N'.          
               88  PROCESS-WATER                    VALUE 'Y'.          
           05  WS-PROCESS-SEWER-FLAG   PIC X(01)    VALUE 'N'.          
               88  PROCESS-SEWER                    VALUE 'Y'.          
           05  WS-PROCESS-XFORMER-FLAG PIC X(01)    VALUE 'N'.          
               88  PROCESS-XFORMER                  VALUE 'Y'.          
           05  WS-PROCESS-ATTACH-FLAG PIC X(01)     VALUE 'N'.          
               88  PROCESS-ATTACH                   VALUE 'Y'.          
           05  WS-MOVE-ON-HOLD-FLAG    PIC X(01)    VALUE 'N'.          
               88  MOVE-ON-HOLD                     VALUE 'Y'.          
           05  WS-FIRST-A-FOUND-FLAG   PIC X(01)    VALUE 'N'.          
               88  FIRST-A-FOUND                    VALUE 'Y'.          
      *                                                                         
       01  WS-WORKING-VARIABLES.                                        
ACT072     05 WS-COUNT-GAS-PSNC        PIC 9(03) VALUE ZERO.            
ACT072     05 WS-COUNT-GAS-SCEG        PIC 9(03) VALUE ZERO.            
ACT072     05 WS-COUNT-GAS-ATT-SCEG    PIC 9(03) VALUE ZERO.            
ACT072     05 WS-COUNT-GAS-ATT-PSNC    PIC 9(03) VALUE ZERO.            
ACT072     05 WS-COUNT-XFORMER         PIC 9(03) VALUE ZERO.            
ACT072     05 WS-COUNT-ELECTRIC        PIC 9(03) VALUE ZERO.            
ACT072     05 WS-NO-DATA               PIC X(45) VALUE                  
                 '            NO DATA FOUND        '.                   
           05  WS-CURR-DATE-YY-MM.                                      
               10  WS-CURR-DATE-YY     PIC 9(02).                       
               10  WS-CURR-DATE-MM     PIC 9(02).                       
           05  WS-COMPARE-DATE-YY-MM.                                   
               10  WS-COMPARE-DATE-YY  PIC 9(02).                       
               10  WS-COMPARE-DATE-MM  PIC 9(02).                       
T14799     05  WS-DIS-DATE.                                             
T19027         10  WS-DIS-CCYY.                                         
T19027             15  WS-DIS-CC       PIC 9(02).                       
T19027             15  WS-DIS-YY       PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DIS-MM           PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DIS-DD           PIC 9(02).                       
           05  WS-MOVE-DATE-1.                                          
T19027         10 WS-MOVE-CCYY-1       PIC 9(04).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-MM-1         PIC 9(02).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-DD-1         PIC 9(02).                       
           05  WS-MOVE-DATE-2.                                          
T19027         10 WS-MOVE-CCYY-2       PIC 9(04).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-MM-2         PIC 9(02).                       
               10 FILLER               PIC X(01)    VALUE '-'.          
               10 WS-MOVE-DD-2         PIC 9(02).                       
           05  WS-MOVE-TO-DATE-1       PIC X(10).                       
           05  WS-MOVE-TO-DATE-2       PIC X(10).                       
           05  WS-MOVE-TS-1.                                            
               10  WS-MOVE-TS-DATE-1   PIC X(10).                       
               10  FILLER              PIC X(09)    VALUE '-00.00.00'.  
               10  FILLER              PIC X(07)    VALUE '.000001'.    
           05  WS-MOVE-TS-1-R REDEFINES                                 
               WS-MOVE-TS-1            PIC X(26).                       
           05  WS-MOVE-TS-2.                                            
               10  WS-MOVE-TS-DATE-2   PIC X(10).                       
               10  FILLER              PIC X(09)    VALUE '-23.59.59'.  
               10  FILLER              PIC X(07)    VALUE '.999999'.    
           05  WS-MOVE-TS-2-R REDEFINES                                 
               WS-MOVE-TS-2            PIC X(26).                       
           05  WS-FMT01-STATUS         PIC X(02).                       
                                                                        
ACT072     05  WS-FMT01B-STATUS        PIC X(02).                       
ACT072         88 FMT01B-SUCCESSFUL        VALUE '00'.                  
ACT072         88 END-OF-REC               VALUE '10'.                  
                                                                        
ACT072     05  WS-FMT26B-STATUS        PIC X(02).                       
ACT072         88 FMT26B-SUCCESSFUL        VALUE '00'.                  
ACT072         88 END-OF-REC               VALUE '10'.                  
                                                                        
T18652     05  WS-FMT22-STATUS         PIC X(02).                       
T18652     05  WS-FMT23-STATUS         PIC X(02).                       
T12999     05  WS-FMT26-STATUS         PIC X(02).                       
           05  WS-MAX-E-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-E-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-E-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-E-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-G-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-G-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-G-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-G-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-W-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-W-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-W-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-W-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-S-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-S-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-S-METER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-S-METER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-X-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-X-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-XFORMER-NO       PIC X(09)    VALUE               
                                                   '999999999'.         
           05  WS-MIN-XFORMER-NO       PIC X(09)    VALUE SPACES.       
           05  WS-MAX-A-OFF-LOC        PIC 9(03)    VALUE 999.          
           05  WS-MIN-A-OFF-LOC        PIC 9(03)    VALUE ZERO.         
           05  WS-MAX-ATTACH-NO        PIC X(12)    VALUE               
                                                   '999999999999'.      
           05  WS-MIN-ATTACH-NO        PIC X(12)    VALUE SPACES.       
           05  WS-ABEND-SPACE          PIC X(01)    VALUE SPACES.       
           05  WS-ABEND-NUMERIC        REDEFINES                        
               WS-ABEND-SPACE          PIC 9(01).                       
           05  WS-NULLIND-DATE-PURCHASED                                
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-DISPOSED                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-LAST-MOVE                                
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-DATE-OBSOLETE                                 
                                       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-NULLIND-LOC-NO       PIC S9(04)   COMP VALUE ZEROES.  
           05  WS-FIOMT01-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T18652     05  WS-FIOMT22-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T18652     05  WS-FIOMT23-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
T12999     05  WS-FIOMT26-REC-COUNT    PIC 9(07)    COMP-3 VALUE ZEROES.
      *                                                                         
       01  WS-METER-INFO.                                               
PCR156     05  WS-MTR-STORAGE-FAC-CD-1 PIC X(03).                       
PCR156     05  WS-MTR-STORAGE-FAC-CD-2 PIC X(03).                       
           05  WS-CODE-CRNT-LOC-1      PIC X(01).                       
           05  WS-CODE-CRNT-LOC-2      PIC X(01).                       
           05  WS-DATE-MOVE-1.                                          
               10  WS-DATE-MOVE-CC-1   PIC X(2).                        
               10  WS-DATE-MOVE-YY-1   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-MM-1   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-DD-1   PIC X(2).                        
           05  WS-DATE-MOVE-2.                                          
               10  WS-DATE-MOVE-CC-2   PIC X(2).                        
               10  WS-DATE-MOVE-YY-2   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-MM-2   PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DATE-MOVE-DD-2   PIC X(2).                        
      *                                                                         
       01  WS-METER-MOVEMENT-TYPES.                                     
           05  WS-TYPE-1               PIC 9(01)    VALUE 1.            
      *******  PURCHASE METER                                                   
           05  WS-TYPE-2               PIC 9(01)    VALUE 2.            
      *******  REACTIVATE METER                                                 
           05  WS-TYPE-3               PIC 9(01)    VALUE 3.            
      *******  MOVE METER TO                                                    
           05  WS-TYPE-4               PIC 9(01)    VALUE 4.            
      *******  REMOVE METER FROM ACCOUNT                                        
           05  WS-TYPE-5               PIC 9(01)    VALUE 5.            
      *******  JUNK METER                                                       
           05  WS-TYPE-6               PIC 9(01)    VALUE 6.            
      *******  JUNK METER                                                       
           05  WS-TYPE-7               PIC 9(01)    VALUE 7.            
      *******  MOVE FROM DIV TO ANOTHER DIV INVENTORY                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-PARAMETER-NAME       PIC X(22).                       
               88  EXTR-ELEC                        VALUE               
                         'EXTRACT ELEC METERS = '.                      
               88  EXTR-GAS                         VALUE               
                         'EXTRACT GAS  METERS = '.                      
               88  EXTR-WATER                       VALUE               
                         'EXTRACT WTR  METERS = '.                      
               88  EXTR-SEWER                       VALUE               
                         'EXTRACT SWR  METERS = '.                      
               88  EXTR-XFORMER                     VALUE               
                         'EXTRACT    XFORMERS = '.                      
               88  EXTR-ATTACHMENTS                 VALUE               
                         'EXTRACT ATTACHMENTS = '.                      
               88  MIN-ELEC-OFF                     VALUE               
                         'MIN ELEC OFFICE LOC = '.                      
               88  MAX-ELEC-OFF                     VALUE               
                         'MAX ELEC OFFICE LOC = '.                      
               88  MIN-GAS-OFF                      VALUE               
                         'MIN GAS  OFFICE LOC = '.                      
               88  MAX-GAS-OFF                      VALUE               
                         'MAX GAS  OFFICE LOC = '.                      
               88  MIN-WATER-OFF                    VALUE               
                         'MIN WTR  OFFICE LOC = '.                      
               88  MAX-WATER-OFF                    VALUE               
                         'MAX WTR  OFFICE LOC = '.                      
               88  MIN-SEWER-OFF                    VALUE               
                         'MIN SWR  OFFICE LOC = '.                      
               88  MAX-SEWER-OFF                    VALUE               
                         'MAX SWR  OFFICE LOC = '.                      
               88  MIN-XFORMER-OFF                  VALUE               
                         'MIN XFMR OFFICE LOC = '.                      
               88  MAX-XFORMER-OFF                  VALUE               
                         'MAX XFMR OFFICE LOC = '.                      
               88  MIN-ATTACH-OFF                   VALUE               
                         'MIN ATT  OFFICE LOC = '.                      
               88  MAX-ATTACH-OFF                   VALUE               
                         'MAX ATT  OFFICE LOC = '.                      
               88  MIN-ELEC-METER                   VALUE               
                         'MIN ELEC METER NO   = '.                      
               88  MAX-ELEC-METER                   VALUE               
                         'MAX ELEC METER NO   = '.                      
               88  MIN-GAS-METER                    VALUE               
                         'MIN GAS  METER NO   = '.                      
               88  MAX-GAS-METER                    VALUE               
                         'MAX GAS  METER NO   = '.                      
               88  MIN-WATER-METER                  VALUE               
                         'MIN WTR  METER NO   = '.                      
               88  MAX-WATER-METER                  VALUE               
                         'MAX WTR  METER NO   = '.                      
               88  MIN-SEWER-METER                  VALUE               
                         'MIN SWR  METER NO   = '.                      
               88  MAX-SEWER-METER                  VALUE               
                         'MAX SWR  METER NO   = '.                      
               88  MIN-XFORMER                      VALUE               
                         'MIN    XFORMER NO   = '.                      
               88  MAX-XFORMER                      VALUE               
                         'MAX    XFORMER NO   = '.                      
               88  MIN-ATTACH-METER                 VALUE               
                         'MIN ATT  METER NO   = '.                      
               88  MAX-ATTACH-METER                 VALUE               
                         'MAX ATT  METER NO   = '.                      
           05  WS-PARAMETER-VALUE      PIC X(09).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-EXT     PIC X(01).                       
               10  FILLER              PIC X(08).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-OFF     PIC 9(03).                       
               10  FILLER              PIC X(06).                       
           05  FILLER REDEFINES WS-PARAMETER-VALUE.                     
               10  WS-PARM-VAL-MET     PIC X(09).                       
           05  FILLER                  PIC X(22).                       
      *                                                                         
       COPY CWS00039.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
ACT072     EXEC SQL                                                             
ACT072         INCLUDE TBEQLOC                                                  
ACT072     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A05744**  CSS_ELEC_CL_SPEC - U0                                     **          
      ****************************************************************          
      *                                                                         
A05744     EXEC SQL                                                             
A05744         INCLUDE TBELCLSP                                                 
A05744     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINXFOR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
ST             DECLARE EQUIP_CURSOR CURSOR FOR                          
               SELECT  DEVICE_NO                                        
                      ,DATE_LAST_MOVE                                   
                      ,LOCAL_OFFICE                                     
                      ,CODE_CRNT_LOC                                    
                      ,DATE_PURCHASED                                   
                      ,DATE_DISPOSED_OF                                 
                      ,SERIAL_NO                                        
                      ,CODE_MAKE                                        
T22243                ,COMPANY_NO                                       
                FROM   CSS_EQUIPMENT  EQ                                
               WHERE   CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE            
                 AND   EQUIP_TYPE_CD    = :EQ-EQUIP-TYPE-CD             
                 AND   CODE_CRNT_LOC    = :EQ-CODE-CRNT-LOC             
T22243           AND   DATE_LAST_MOVE  >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )            
T22243           AND   DATE_LAST_MOVE   < IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )            
              ORDER BY DATE_PURCHASED                                   
END                   ,DEVICE_NO                                        
T18652     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EQUIP_CURSOR CURSOR FOR                                  
MFA-TR*        SELECT  DEVICE_NO                                                
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,CODE_CRNT_LOC                                            
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               ,DATE_DISPOSED_OF                                         
MFA-TR*               ,SERIAL_NO                                                
MFA-TR*               ,CODE_MAKE                                                
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*         FROM   CSS_EQUIPMENT  EQ                                        
MFA-TR*        WHERE   CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND   EQUIP_TYPE_CD    = :EQ-EQUIP-TYPE-CD                     
MFA-TR*          AND   CODE_CRNT_LOC    = :EQ-CODE-CRNT-LOC                     
MFA-TR*          AND   DATE_LAST_MOVE  >= :WS-MOVE-TO-DATE-1                    
MFA-TR*          AND   DATE_LAST_MOVE   < :WS-MOVE-TO-DATE-2                    
MFA-TR*       ORDER BY DATE_PURCHASED                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE ATTACH_CURSOR CURSOR FOR                         
               SELECT  DEVICE_NO                                        
                      ,CODE_ATT_TYPE                                    
                      ,COMPANY_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,EQUIP_LOC_ID                                     
                      ,MTR_STORAGE_FAC_CD                               
                      ,CODE_MAKE                                        
                      ,DATE_LAST_MOVE                                   
                      ,DATE_PURCHASED                                   
                      ,DATE_OBSOLETE                                    
                FROM   CSS_EQUIP_ATTCHMTS LX                            
               WHERE   CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE            
                 AND   CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE             
                 AND   EQUIP_LOC_ID     = :LX-EQUIP-LOC-ID              
                 AND   DATE_LAST_MOVE  >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )            
                 AND   DATE_LAST_MOVE   < IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )            
              ORDER BY DATE_PURCHASED                                   
                      ,DEVICE_NO                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTACH_CURSOR CURSOR FOR                                 
MFA-TR*        SELECT  DEVICE_NO                                                
MFA-TR*               ,CODE_ATT_TYPE                                            
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,EQUIP_LOC_ID                                             
MFA-TR*               ,MTR_STORAGE_FAC_CD                                       
MFA-TR*               ,CODE_MAKE                                                
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               ,DATE_OBSOLETE                                            
MFA-TR*         FROM   CSS_EQUIP_ATTCHMTS LX                                    
MFA-TR*        WHERE   CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                    
MFA-TR*          AND   CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND   EQUIP_LOC_ID     = :LX-EQUIP-LOC-ID                      
MFA-TR*          AND   DATE_LAST_MOVE  >= :WS-MOVE-TO-DATE-1                    
MFA-TR*          AND   DATE_LAST_MOVE   < :WS-MOVE-TO-DATE-2                    
MFA-TR*       ORDER BY DATE_PURCHASED                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVHCUR CURSOR FOR                                
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       MOVE_NO,                                         
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_UTIL_TYPE   =:MV-CODE-UTIL-TYPE             
                 AND   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE           
                 AND   DATE_MOVE BETWEEN IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-1
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-1
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-1) )             
                                     AND IIF(TRY_CONVERT(DATE, 
                                                     :WS-MOVE-TO-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-MOVE-TO-DATE-2
              ) <> 0) OR (LEN(:WS-MOVE-TO-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-MOVE-TO-DATE-2
              ), CONVERT(DATE, :WS-MOVE-TO-DATE-2) )             
               ORDER BY LOCAL_OFFICE,                                   
                        DEVICE_NO,                                      
                        MOVE_NO                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVHCUR CURSOR FOR                                        
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_UTIL_TYPE   =:MV-CODE-UTIL-TYPE                     
MFA-TR*          AND   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE                   
MFA-TR*          AND   DATE_MOVE BETWEEN :WS-MOVE-TO-DATE-1                     
MFA-TR*                              AND :WS-MOVE-TO-DATE-2                     
MFA-TR*        ORDER BY LOCAL_OFFICE,                                           
MFA-TR*                 DEVICE_NO,                                              
MFA-TR*                 MOVE_NO                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVHCUR-2 CURSOR FOR                              
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO,                                       
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE           
                 AND   DEVICE_NO        =:MV-DEVICE-NO                  
                 AND   MOVE_NO <         CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)        
               ORDER BY MOVE_NO DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVHCUR-2 CURSOR FOR                                      
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_DEVICE_TYPE =:MV-CODE-DEVICE-TYPE                   
MFA-TR*          AND   DEVICE_NO        =:MV-DEVICE-NO                          
MFA-TR*          AND   MOVE_NO <         :MV-MOVE-NO                            
MFA-TR*        ORDER BY MOVE_NO DESC                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MVH-JUNK CURSOR FOR                              
               SELECT  CODE_DEVICE_TYPE,                                
                       DEVICE_NO,                                       
                       DATE_MOVE,                                       
                       REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO, 121), 
           ' ', '-'), ':', '.') MOVE_NO,                                       
                       LOCAL_OFFICE,                                    
                       LOC_NO,                                          
                       CODE_CRNT_LOC,                                   
                       CODE_UTIL_TYPE                                   
               FROM    CSS_MOVEMENT_HIST                                
               WHERE   CODE_CRNT_LOC    =:WS-2                          
                 AND   MOVE_NO   BETWEEN CIS.CHAR2TIMESTAMP(
                                                        :WS-MOVE-TS-1-R
              )                
                                     AND CIS.CHAR2TIMESTAMP(
                                                        :WS-MOVE-TS-2-R
              )                
               ORDER BY MOVE_NO DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MVH-JUNK CURSOR FOR                                      
MFA-TR*        SELECT  CODE_DEVICE_TYPE,                                        
MFA-TR*                DEVICE_NO,                                               
MFA-TR*                DATE_MOVE,                                               
MFA-TR*                MOVE_NO,                                                 
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LOC_NO,                                                  
MFA-TR*                CODE_CRNT_LOC,                                           
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*        FROM    CSS_MOVEMENT_HIST                                        
MFA-TR*        WHERE   CODE_CRNT_LOC    =:WS-2                                  
MFA-TR*          AND   MOVE_NO   BETWEEN :WS-MOVE-TS-1-R                        
MFA-TR*                              AND :WS-MOVE-TS-2-R                        
MFA-TR*        ORDER BY MOVE_NO DESC                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WORK-STORAGE-END            PIC X(38)    VALUE               
              'WORKING STORAGE FOR PCSMT301 ENDS HERE'.                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0000-MAIN                                                 **          
      **      CONTROLS MAIN PROCESSING                              **          
      **                                                            **          
      ****************************************************************          
       0000-MAIN.                                                       
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 0200-PROCESS-BEGIN-CONTROL-REC                       
                                                 THRU 0200-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE                THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-OF-SYSIPT                                             
               MOVE 'COMMON  '         TO WS-PROGRAM                    
               MOVE 'DATE'             TO WS-COMMAND                    
               MOVE SPACES             TO WS-SYSIPT                     
               MOVE ZERO               TO WS-SEQUENCE                   
               MOVE WS-KEY-AREA        TO E-FJC01-KEY                   
               PERFORM 7600-START-FCSJC01        THRU 7600-EXIT         
               PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT         
                   UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
                      OR  END-OF-SYSIPT                                 
      *                                                                         
               IF END-OF-SYSIPT                                         
                   DISPLAY '*** PROCESSING ERROR IN PCSMT301  ***'      
                   DISPLAY '*** NO ACTIVE DATE CARD IN COMMON ***'      
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   PERFORM 7611-CLOSE            THRU 7611-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-RUN-DATE      TO WS-INPUT-DATE.                
           MOVE WS-INPUT-DATE          TO WS-DIS-DATE.                  
           PERFORM 0130-PROCESS-MOVE-DATE        THRU 0130-EXIT.        
           MOVE WS-DIS-MM              TO WS-CURR-DATE-MM.              
           MOVE WS-DIS-YY              TO WS-CURR-DATE-YY.              
           PERFORM 6243-GET-FCA00-UTIL-TYPES     THRU 6243-EXIT.        
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
           PERFORM 0110-PROCESS-PARAMETER-FILE   THRU 0110-EXIT         
               UNTIL (WS-PGRMNAME NOT EQUAL WS-PROGRAM)                 
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE                THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN                                                         
               OUTPUT FCSMT01-FILE,                                     
                      FCSMT02-FILE,                                     
T18652                FCSMT22-FILE,                                     
T18652                FCSMT23-FILE,                                     
T18652                FCSMT26-FILE.                                     
      *                                                                         
ACT072     OPEN OUTPUT FCSMT01B-FILE.                                   
ACT072     IF NOT FMT01B-SUCCESSFUL                                     
ACT072         MOVE 12                   TO RETURN-CODE                 
ACT072         DISPLAY '**************************************'         
ACT072         DISPLAY '****PROGRAM PCSRP301******************'         
ACT072         DISPLAY '**  ERROR OPENING FCSMT01B          **'         
ACT072         DISPLAY '**  FILE STATUS = '  WS-FMT01B-STATUS           
ACT072         DISPLAY '**************************************'         
ACT072         PERFORM 9900-ABEND               THRU 9900-EXIT          
ACT072     END-IF.                                                      
                                                                        
ACT072     OPEN OUTPUT FCSMT26B-FILE.                                   
ACT072     IF NOT FMT26B-SUCCESSFUL                                     
ACT072         MOVE 12                   TO RETURN-CODE                 
ACT072         DISPLAY '**************************************'         
ACT072         DISPLAY '****PROGRAM PCSRP301******************'         
ACT072         DISPLAY '**  ERROR OPENING FCSMT26B          **'         
ACT072         DISPLAY '**  FILE STATUS = '  WS-FMT26B-STATUS           
ACT072         DISPLAY '**************************************'         
ACT072         PERFORM 9900-ABEND               THRU 9900-EXIT          
ACT072     END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0110-PROCESS-PARAMETER-FILE                               **          
      **                                                            **          
      ****************************************************************          
       0110-PROCESS-PARAMETER-FILE.                                     
      *                                                                         
           IF E-FJC01-CMND-CODE EQUAL WS-PARM                           
               IF E-FJC01-STATUS EQUAL WS-A                             
                   PERFORM 0120-HANDLE-PARM      THRU 0120-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0120-HANDLE-PARM                                          **          
      **                                                            **          
      ****************************************************************          
       0120-HANDLE-PARM.                                                
      *                                                                         
           MOVE E-FJC01-PARAMETER-DATA TO WS-PARAMETER-DATA.            
      *                                                                         
           IF EXTR-ELEC                                                 
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-ELEC-FLAG          
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF EXTR-GAS                                                  
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-GAS-FLAG           
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF EXTR-XFORMER                                              
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-XFORMER-FLAG       
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF EXTR-ATTACHMENTS                                          
               IF WS-PARM-VAL-EXT EQUAL WS-YES OR WS-NO                 
                   MOVE WS-PARM-VAL-EXT                                 
                                       TO WS-PROCESS-ATTACH-FLAG        
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ELEC-OFF                                              
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-E-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-ELEC-OFF                                              
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-E-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-GAS-OFF                                               
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-G-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-GAS-OFF                                               
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-G-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-XFORMER-OFF                                           
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-X-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-XFORMER-OFF                                           
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-X-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ATTACH-OFF                                            
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MIN-A-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MAX-ATTACH-OFF                                            
               IF WS-PARM-VAL-OFF NUMERIC                               
                   MOVE WS-PARM-VAL-OFF                                 
                                       TO WS-MAX-A-OFF-LOC              
               ELSE                                                     
                   PERFORM 9110-INVALID-PARAMETER                       
                                                 THRU 9110-EXIT         
               END-IF                                                   
           ELSE                                                         
           IF MIN-ELEC-METER                                            
               MOVE WS-PARM-VAL-MET    TO WS-MIN-E-METER-NO             
           ELSE                                                         
           IF MAX-ELEC-METER                                            
               MOVE WS-PARM-VAL-MET    TO WS-MAX-E-METER-NO             
           ELSE                                                         
           IF MIN-GAS-METER                                             
               MOVE WS-PARM-VAL-MET    TO WS-MIN-G-METER-NO             
           ELSE                                                         
           IF MAX-GAS-METER                                             
               MOVE WS-PARM-VAL-MET    TO WS-MAX-G-METER-NO             
           ELSE                                                         
           IF MIN-XFORMER                                               
               MOVE WS-PARM-VAL-MET    TO WS-MIN-XFORMER-NO             
           ELSE                                                         
           IF MAX-XFORMER                                               
               MOVE WS-PARM-VAL-MET    TO WS-MAX-XFORMER-NO             
           ELSE                                                         
           IF MIN-ATTACH-METER                                          
               MOVE WS-PARM-VAL-MET    TO WS-MIN-ATTACH-NO              
           ELSE                                                         
           IF MAX-ATTACH-METER                                          
               MOVE WS-PARM-VAL-MET    TO WS-MAX-ATTACH-NO              
           ELSE                                                         
               PERFORM 9110-INVALID-PARAMETER    THRU 9110-EXIT         
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0130-PROCESS-MOVE-DATE                                    **          
      **                                                            **          
      ****************************************************************          
       0130-PROCESS-MOVE-DATE.                                          
      *                                                                         
T19027     MOVE WS-DIS-CCYY            TO WS-MOVE-CCYY-1,               
                                          WS-MOVE-CCYY-2.               
           MOVE 01                     TO WS-MOVE-DD-1,                 
                                          WS-MOVE-DD-2.                 
           MOVE WS-DIS-MM              TO WS-MOVE-MM-1,                 
                                          WS-MOVE-MM-2.                 
           ADD 1                       TO WS-MOVE-MM-2.                 
      *                                                                         
           IF WS-MOVE-MM-2 EQUAL 13                                     
T19027         ADD 1                   TO WS-MOVE-CCYY-2                
               MOVE 01                 TO WS-MOVE-MM-2                  
           END-IF.                                                      
      *                                                                         
           MOVE WS-MOVE-DATE-1         TO WS-MOVE-TO-DATE-1,            
                                          WS-MOVE-TS-DATE-1.            
           MOVE WS-MOVE-DATE-2         TO WS-MOVE-TO-DATE-2,            
                                          WS-MOVE-TS-DATE-2.            
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0200-PROCESS-BEGIN-CONTROL-REC                            **          
      **                                                            **          
      ****************************************************************          
       0200-PROCESS-BEGIN-CONTROL-REC.                                  
      *                                                                         
ACT072     MOVE 'UTL TYPE'             TO E-FMT01-UTL-TYPE-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER1-HDR.          
ACT072     MOVE 'METER NO'             TO E-FMT01-METER-NO-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER2-HDR.          
ACT072     MOVE 'SERIAL NO'            TO E-FMT01-SERIAL-NO-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER3-HDR.          
ACT072     MOVE 'MTR STORAGE FAC CD'                                    
ACT072                                TO E-FMT01-MTR-STORAGE-FAC-CD-HDR.
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER4-HDR.          
ACT072     MOVE 'CODE CRNT LOC'        TO E-FMT01-CODE-CRNT-LOC-HDR.    
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER5-HDR.          
ACT072     MOVE 'CODE MAKE'            TO E-FMT01-CODE-MAKE-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER6-HDR.          
ACT072     MOVE 'MTR SIZE ID'          TO E-FMT01-MTR-SIZE-ID-HDR.      
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER7-HDR.          
ACT072     MOVE 'YEAR PURCHASED'       TO E-FMT01-YEAR-PURCHASED-HDR.   
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER8-HDR.          
ACT072     MOVE 'DATE RETIRED'         TO E-FMT01-DATE-RETIRED-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER9-HDR.          
ACT072     MOVE 'COMPANY NO'           TO E-FMT01-COMPANY-NO-HDR.       
           MOVE FIOMT01                TO FIOMT01B.                     
           PERFORM 8000-WRITE-FCSMT01            THRU 8000-EXIT.        
           MOVE SPACES                 TO FIOMT01.                      
ACT072     PERFORM 8500-WRITE-FCSMT01B           THRU 8500-EXIT.        
ACT072     MOVE SPACES                 TO FIOMT01B.                     
                                                                        
ACT072     MOVE 'UTL TYPE'             TO E-FMT22-UTL-TYPE-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER1-HDR.          
ACT072     MOVE 'METER NO'             TO E-FMT22-METER-NO-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER2-HDR.          
ACT072     MOVE 'SERIAL NO'            TO E-FMT22-SERIAL-NO-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER3-HDR.          
ACT072     MOVE 'MTR STORAGE FAC CD'                                    
ACT072                                TO E-FMT22-MTR-STORAGE-FAC-CD-HDR.
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER4-HDR.          
ACT072     MOVE 'CODE CRNT LOC'        TO E-FMT22-CODE-CRNT-LOC-HDR.    
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER5-HDR.          
ACT072     MOVE 'CODE MAKE'            TO E-FMT22-CODE-MAKE-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER6-HDR.          
ACT072     MOVE 'MTR CLSS CD'          TO E-FMT22-MTR-CLASS-CD-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER7-HDR.          
ACT072     MOVE 'MTR SPEC ID'          TO E-FMT22-MTR-SPEC-ID-HDR.      
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER8-HDR.          
ACT072     MOVE 'YEAR PURCHASED'       TO E-FMT22-YEAR-PURCHASED-HDR.   
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER9-HDR.          
ACT072     MOVE 'DATE RETIRED'         TO E-FMT22-DATE-RETIRED-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER10-HDR.         
ACT072     MOVE 'COMPANY NO'           TO E-FMT22-COMPANY-NO-HDR.       
A05744     MOVE WS-COMMA               TO E-FMT22-FILLER11-HDR.         
A05744     MOVE 'RETIRED CD'           TO E-FMT22-RETIRED-CD-HDR.       
           PERFORM 8200-WRITE-FCSMT22            THRU 8200-EXIT.        
           MOVE SPACES                 TO FIOMT22.                      
                                                                        
ACT072     MOVE 'UTL TYPE'             TO E-FMT26-UTL-TYPE-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER1-HDR.          
ACT072     MOVE 'DEVICE NO'            TO E-FMT26-DEVICE-NO-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER2-HDR.          
ACT072     MOVE 'CODE ATT TYPE'        TO E-FMT26-CODE-ATT-TYPE-HDR.    
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER3-HDR.          
ACT072     MOVE 'CODE MAKE'            TO E-FMT26-CODE-MAKE-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER4-HDR.          
ACT072     MOVE 'MTR STORAGE FAC CD'   TO E-FMT26-MTR-STOR-FAC-CD-HDR.  
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER5-HDR.          
ACT072     MOVE 'EQUIP LOC ID'         TO E-FMT26-EQUIP-LOC-ID-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER6-HDR.          
ACT072     MOVE 'YEAR PURCHASED'       TO E-FMT26-YEAR-PURCHASED-HDR.   
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER7-HDR.          
ACT072     MOVE 'DATE RETIRED'         TO E-FMT26-DATE-RETIRED-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER8-HDR.          
ACT072     MOVE 'COMPANY NO'           TO E-FMT26-COMPANY-NO-HDR.       
ACT072     MOVE FIOMT26                TO FIOMT26B.                     
ACT072     PERFORM 8400-WRITE-FCSMT26            THRU 8400-EXIT.        
ACT072     MOVE SPACES                 TO FIOMT26.                      
ACT072     PERFORM 8600-WRITE-FCSMT26B           THRU 8600-EXIT.        
ACT072     MOVE SPACES                 TO FIOMT26B.                     
                                                                        
ACT072     MOVE 'UTL TYPE'             TO E-FMT23-UTL-TYPE-HDR.         
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER1-HDR.          
ACT072     MOVE 'XFORMER NO'           TO E-FMT23-XFORMER-NO-HDR.       
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER2-HDR.          
ACT072     MOVE 'SERIAL NO'            TO E-FMT23-SERIAL-NO-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER3-HDR.          
ACT072     MOVE 'MTR STORAGE FAC CD'                                    
                                      TO E-FMT23-MTR-STORAGE-FAC-CD-HDR.
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER4-HDR.          
ACT072     MOVE 'CODE CRNT LOC'        TO E-FMT23-CODE-CRNT-LOC-HDR.    
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER5-HDR.          
ACT072     MOVE 'CODE MAKE'            TO E-FMT23-CODE-MAKE-HDR.        
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER6-HDR.          
ACT072     MOVE 'XFROMER TYPE CD'      TO E-FMT23-XFORMER-TYPE-CD-HDR.  
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER7-HDR.          
ACT072     MOVE 'XFROMER CLASS CD'     TO E-FMT23-XFORMER-CLASS-CD-HDR. 
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER8-HDR.          
ACT072     MOVE 'XFORMER SPEC CD'      TO E-FMT23-XFORMER-SPEC-CD-HDR.  
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER9-HDR.          
ACT072     MOVE 'YEAR PURCHASED'       TO E-FMT23-YEAR-PURCHASED-HDR.   
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER10-HDR.         
ACT072     MOVE 'DATE RETIRED'         TO E-FMT23-DATE-RETIRED-HDR.     
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER11-HDR.         
ACT072     MOVE 'COMPANY NO'           TO E-FMT23-COMPANY-NO-HDR.       
ACT072     PERFORM 8300-WRITE-FCSMT23 THRU 8300-EXIT.                   
           MOVE SPACES                 TO FIOMT23.                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1000-PROCESS-INPUT                                        **          
      **                                                            **          
      ****************************************************************          
       1000-PROCESS-INPUT.                                              
      *                                                                         
           DISPLAY 'PROCESS ELEC = ' WS-PROCESS-ELEC-FLAG.              
           DISPLAY 'PROCESS GAS  = ' WS-PROCESS-GAS-FLAG.               
           DISPLAY 'PROCESS WTR  = ' WS-PROCESS-WATER-FLAG.             
           DISPLAY 'PROCESS SWR  = ' WS-PROCESS-SEWER-FLAG.             
           DISPLAY 'PROCESS XFRM = ' WS-PROCESS-XFORMER-FLAG.           
           DISPLAY 'PROCESS ATT  = ' WS-PROCESS-ATTACH-FLAG.            
      *                                                                         
           IF PROCESS-ELECTRIC                                          
               PERFORM 1100-PROCESS-ELECTRIC      THRU 1100-EXIT        
           END-IF.                                                      
      *                                                                         
           IF PROCESS-GAS                                               
               PERFORM 1200-PROCESS-GAS           THRU 1200-EXIT        
           END-IF.                                                      
                                                                        
           IF PROCESS-XFORMER                                           
               PERFORM 1500-PROCESS-XFORMER      THRU 1500-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PROCESS-ATTACH                                            
               PERFORM 1600-PROCESS-ATTACHMENT   THRU 1600-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 2000-PROCESS-JUNK-EQUIP       THRU 2000-EXIT.        
ACT072     PERFORM 2200-CHECK-NO-DATA            THRU 2200-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1100-PROCESS-ELECTRIC                                     **          
      **                                                            **          
      ****************************************************************          
       1100-PROCESS-ELECTRIC.                                           
      *                                                                         
T18652     MOVE WS-E                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
T18652     MOVE WS-I                   TO EQ-CODE-CRNT-LOC.             
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T22243             MOVE EQ-COMPANY-NO  TO EM-COMPANY-NO                 
                   PERFORM 1110-PROCESS-ELEC-MTD THRU 1110-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-E-METER-NO 
T18652                 PERFORM 7002-CLOSE-EQUIP-CURSOR                  
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR THRU 7002-EXIT           
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1110-PROCESS-ELEC-MTD                                     **          
      **                                                            **          
      ****************************************************************          
       1110-PROCESS-ELEC-MTD.                                           
      *                                                                         
T18652     PERFORM 1115-GATHER-ELEC-MTD-INFO THRU 1115-EXIT.            
      *                                                                         
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1115-GATHER-ELEC-MTD-INFO                                 **          
      **                                                            **          
      ****************************************************************          
       1115-GATHER-ELEC-MTD-INFO.                                       
      *                                                                         
T18652     MOVE WS-E                   TO E-FMT22-UTL-TYPE              
ACT072                                    WS-UTIL-TYPE.                 
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER1.              
                                                                        
T18652     MOVE EQ-DEVICE-NO           TO E-FMT22-METER-NO.             
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER2.              
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7020-SELECT-ELEC-METER    THRU 7020-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1120-PROCESS-ELEC-MTB THRU 1120-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1120-PROCESS-ELEC-MTB                                     **          
      **                                                            **          
      ****************************************************************          
       1120-PROCESS-ELEC-MTB.                                           
      *                                                                         
T18652     MOVE EQ-CODE-MAKE           TO E-FMT22-CODE-MAKE.            
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER3.              
T18652     MOVE EQ-SERIAL-NO           TO E-FMT22-SERIAL-NO.            
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER4.              
T18652     MOVE EM-ELEC-MTR-CLASS-CD   TO E-FMT22-MTR-CLASS-CD.         
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER5.              
T18652     MOVE EM-ELEC-MTR-SPEC-CD    TO E-FMT22-MTR-SPEC-CD.          
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER6.              
ACT072     MOVE EQ-COMPANY-NO          TO WS-COMPANY-NO.                
ACT072     MOVE EQ-LOCAL-OFFICE        TO W9-MTR-STORAGE-FAC-CD.        
ACT072     PERFORM 7400-GET-MSF-TEXT        THRU 7400-EXIT.             
ACT072     MOVE '"'                    TO E-FMT22-QUOTES1.              
ACT072     MOVE W9-MTR-STORAGE-FAC-TX  TO E-FMT22-MTR-STORAGE-FAC-CD.   
ACT072     MOVE '"'                    TO E-FMT22-QUOTES2.              
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER7.              
ACT072     PERFORM 7500-GET-CURR-LOC-TEXT   THRU 7500-EXIT              
ACT072     MOVE M6-EQUIP-LOC-DESC      TO E-FMT22-CODE-CRNT-LOC.        
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER8.              
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT22-YEAR-PURCHASED.       
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER9.              
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT22-DATE-RETIRED.         
ACT072     MOVE WS-COMMA               TO E-FMT22-FILLER10.             
T22243     MOVE EQ-COMPANY-NO          TO E-FMT22-COMPANY-NO.           
A05744     MOVE WS-COMMA               TO E-FMT22-FILLER11.             
A05744     MOVE U0-RETIREMENT-UNIT-CD  TO E-FMT22-RETIRED-CD.           
T18652     PERFORM 8200-WRITE-FCSMT22 THRU 8200-EXIT.                   
T18652     MOVE SPACES                 TO FIOMT22.                      
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1200-PROCESS-GAS                                          **          
      **                                                            **          
      ****************************************************************          
       1200-PROCESS-GAS.                                                
      *                                                                         
T18652     MOVE WS-G                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-M                   TO EQ-EQUIP-TYPE-CD.             
T12999     MOVE WS-I                   TO EQ-CODE-CRNT-LOC.             
           MOVE WS-MIN-G-OFF-LOC       TO WS-MIN-LOC.                   
           MOVE WS-MAX-G-OFF-LOC       TO WS-MAX-LOC.                   
           MOVE WS-MIN-G-METER-NO      TO WS-MIN-METER-NO.              
           MOVE WS-MAX-G-METER-NO      TO WS-MAX-METER-NO.              
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1210-PROCESS-GAS-MTD  THRU 1210-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-G-METER-NO 
T18652                 PERFORM 7002-CLOSE-EQUIP-CURSOR                  
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR  THRU 7002-EXIT          
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1210-PROCESS-GAS-MTD                                      **          
      **                                                            **          
      ****************************************************************          
       1210-PROCESS-GAS-MTD.                                            
      *                                                                         
T18652     PERFORM 1215-GATHER-GAS-MTD-INFO  THRU 1215-EXIT.            
      *                                                                         
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1215-GATHER-GAS-MTD-INFO                                  **          
      **                                                            **          
      ****************************************************************          
       1215-GATHER-GAS-MTD-INFO.                                        
      *                                                                         
ACT072     MOVE WS-G                   TO E-FMT01-UTL-TYPE              
ACT072                                    WS-UTIL-TYPE                  
ACT072                                    E-FMT01B-UTL-TYPE.            
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER1               
ACT072                                    E-FMT01B-FILLER1.             
T18652     MOVE EQ-DEVICE-NO           TO E-FMT01-METER-NO              
T18652                                    E-FMT01B-METER-NO.            
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER2               
ACT072                                    E-FMT01B-FILLER2.             
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T22243         MOVE EQ-COMPANY-NO  TO GM-COMPANY-NO                     
               PERFORM 7030-SELECT-GAS-METER     THRU 7030-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1220-PROCESS-GAS-MTB  THRU 1220-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1220-PROCESS-GAS-MTB                                      **          
      **                                                            **          
      ****************************************************************          
       1220-PROCESS-GAS-MTB.                                            
      *                                                                         
           MOVE EQ-CODE-MAKE           TO E-FMT01-CODE-MAKE             
ACT072                                    E-FMT01B-CODE-MAKE.           
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER3               
ACT072                                    E-FMT01B-FILLER3.             
           MOVE EQ-SERIAL-NO           TO E-FMT01-SERIAL-NO             
ACT072                                    E-FMT01B-SERIAL-NO.           
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER4               
ACT072                                    E-FMT01B-FILLER4.             
T18652     MOVE GM-METER-SIZE-ID       TO E-FMT01-MTR-SIZE-ID           
ACT072                                    E-FMT01B-MTR-SIZE-ID.         
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER5               
ACT072                                    E-FMT01B-FILLER5.             
T18652     MOVE EQ-LOCAL-OFFICE        TO W9-MTR-STORAGE-FAC-CD.        
ACT072     MOVE EQ-COMPANY-NO          TO WS-COMPANY-NO.                
ACT072     PERFORM 7400-GET-MSF-TEXT        THRU 7400-EXIT.             
ACT072     MOVE '"'                    TO E-FMT01-QUOTES1               
ACT072                                    E-FMT01B-QUOTES1.             
ACT072     MOVE W9-MTR-STORAGE-FAC-TX  TO E-FMT01-MTR-STORAGE-FAC-CD    
ACT072                                    E-FMT01B-MTR-STORAGE-FAC-CD.  
ACT072     MOVE '"'                    TO E-FMT01-QUOTES2               
ACT072                                    E-FMT01B-QUOTES2.             
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER6               
ACT072                                    E-FMT01B-FILLER6.             
ACT072     PERFORM 7500-GET-CURR-LOC-TEXT   THRU 7500-EXIT              
ACT072     MOVE M6-EQUIP-LOC-DESC      TO E-FMT01-CODE-CRNT-LOC         
ACT072                                    E-FMT01B-CODE-CRNT-LOC.       
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER7               
ACT072                                    E-FMT01B-FILLER7.             
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT01-YEAR-PURCHASED        
ACT072                                    E-FMT01B-YEAR-PURCHASED.      
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER8               
ACT072                                    E-FMT01B-FILLER8.             
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT01-DATE-RETIRED          
ACT072                                    E-FMT01B-DATE-RETIRED.        
ACT072     MOVE WS-COMMA               TO E-FMT01-FILLER9               
ACT072                                    E-FMT01B-FILLER9.             
T22243     MOVE EQ-COMPANY-NO          TO E-FMT01-COMPANY-NO            
ACT072                                    E-FMT01B-COMPANY-NO.          
                                                                        
ACT072     IF EQ-COMPANY-NO EQUAL '01'                                  
ACT072        PERFORM 8000-WRITE-FCSMT01       THRU 8000-EXIT           
T18652        MOVE SPACES              TO FIOMT01                       
ACT072     ELSE                                                         
ACT072        PERFORM 8500-WRITE-FCSMT01B      THRU 8500-EXIT           
ACT072        MOVE SPACES              TO FIOMT01B                      
ACT072     END-IF.                                                      
                                                                        
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1500-PROCESS-XFORMER                                      **          
      **                                                            **          
      ****************************************************************          
       1500-PROCESS-XFORMER.                                            
      *                                                                         
T18652     MOVE WS-X                   TO EQ-CODE-UTIL-TYPE.            
T18652     MOVE WS-T                   TO EQ-EQUIP-TYPE-CD.             
           MOVE WS-MIN-X-OFF-LOC       TO WS-MIN-LOC.                   
           MOVE WS-MAX-X-OFF-LOC       TO WS-MAX-LOC.                   
           MOVE WS-MIN-XFORMER-NO      TO WS-MIN-METER-NO.              
           MOVE WS-MAX-XFORMER-NO      TO WS-MAX-METER-NO.              
T18652     PERFORM 7000-OPEN-EQUIP-CURSOR THRU 7000-EXIT.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18652         PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T22243             MOVE EQ-COMPANY-NO  TO IX-COMPANY-NO                 
                   PERFORM 1510-PROCESS-XFORMER-MTD                     
                                                 THRU 1510-EXIT         
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
T18652                   OR EQ-DEVICE-NO GREATER THAN WS-MAX-XFORMER-NO 
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               ELSE                                                     
T18652             PERFORM 7002-CLOSE-EQUIP-CURSOR                      
                                                 THRU 7002-EXIT         
               END-IF                                                   
           ELSE                                                         
T18652         PERFORM 7002-CLOSE-EQUIP-CURSOR THRU 7002-EXIT           
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1510-PROCESS-XFORMER-MTD                                  **          
      **                                                            **          
      ****************************************************************          
       1510-PROCESS-XFORMER-MTD.                                        
      *                                                                         
T18652     PERFORM 1515-GATHER-XFORMER-MTD-INFO                         
                                                 THRU 1515-EXIT         
      *                                                                         
T18652     PERFORM 7001-FETCH-EQUIP-CURSOR THRU 7001-EXIT.              
      *                                                                         
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1515-GATHER-XFORMER-MTD-INFO                              **          
      **                                                            **          
      ****************************************************************          
       1515-GATHER-XFORMER-MTD-INFO.                                    
      *                                                                         
ACT072     MOVE WS-X                   TO E-FMT23-UTL-TYPE              
ACT072                                    WS-UTIL-TYPE.                 
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER1.              
T18652     MOVE EQ-DEVICE-NO           TO E-FMT23-XFORMER-NO.           
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER2.              
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7050-SELECT-INSTR-XFORMER THRU 7050-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1520-PROCESS-XFORMER-MTB                     
                                                 THRU 1520-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1520-PROCESS-XFORMER-MTB                                  **          
      **                                                            **          
      ****************************************************************          
       1520-PROCESS-XFORMER-MTB.                                        
      *                                                                         
T18652     MOVE EQ-CODE-MAKE           TO E-FMT23-CODE-MAKE.            
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER3.              
T18652     MOVE EQ-SERIAL-NO           TO E-FMT23-SERIAL-NO.            
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER4.              
T18652     MOVE IX-XFORMER-SPEC-CD     TO E-FMT23-XFORMER-SPEC-CD.      
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER5.              
T18652     MOVE IX-XFORMER-CLASS-CD    TO E-FMT23-XFORMER-CLASS-CD.     
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER6.              
T18652     MOVE IX-XFORMER-TYPE-CD     TO E-FMT23-XFORMER-TYPE-CD.      
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER7.              
ACT072     MOVE EQ-LOCAL-OFFICE        TO W9-MTR-STORAGE-FAC-CD.        
ACT072     MOVE EQ-COMPANY-NO          TO WS-COMPANY-NO.                
ACT072     PERFORM 7400-GET-MSF-TEXT        THRU 7400-EXIT.             
ACT072     MOVE '"'                    TO E-FMT23-QUOTES1.              
ACT072     MOVE W9-MTR-STORAGE-FAC-TX  TO E-FMT23-MTR-STORAGE-FAC-CD.   
ACT072     MOVE '"'                    TO E-FMT23-QUOTES2.              
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER8.              
ACT072     PERFORM 7500-GET-CURR-LOC-TEXT   THRU 7500-EXIT.             
ACT072     MOVE M6-EQUIP-LOC-DESC      TO E-FMT23-CODE-CRNT-LOC.        
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER9.              
T18652     MOVE EQ-DATE-PURCHASED(1:4) TO E-FMT23-YEAR-PURCHASED.       
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER10.             
T18652     MOVE EQ-DATE-LAST-MOVE      TO E-FMT23-DATE-RETIRED.         
ACT072     MOVE WS-COMMA               TO E-FMT23-FILLER11.             
T22243     MOVE EQ-COMPANY-NO          TO E-FMT23-COMPANY-NO.           
T18652     PERFORM 8300-WRITE-FCSMT23 THRU 8300-EXIT.                   
T18652     MOVE SPACES                 TO FIOMT23.                      
      *                                                                         
       1520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1600-PROCESS-ATTACHMENT                                   **          
      **                                                            **          
      ****************************************************************          
       1600-PROCESS-ATTACHMENT.                                         
      *                                                                         
           MOVE WS-G                   TO LX-CODE-UTIL-TYPE.            
           MOVE 'IT'                   TO LX-CODE-ATT-TYPE.             
           MOVE 'I'                    TO LX-EQUIP-LOC-ID.              
           PERFORM 7300-OPEN-ATTACH-CURSOR THRU 7300-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7310-FETCH-ATTACH-CURSOR THRU 7310-EXIT          
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 1610-PROCESS-ATTACH-MTB THRU 1610-EXIT       
                      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                   PERFORM 7320-CLOSE-ATTACH-CURSOR                     
                                                 THRU 7320-EXIT         
               ELSE                                                     
                   PERFORM 7320-CLOSE-ATTACH-CURSOR                     
                                                 THRU 7320-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM 7320-CLOSE-ATTACH-CURSOR THRU 7320-EXIT          
           END-IF.                                                      
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1610-PROCESS-ATTACH-MTB                                   **          
      **                                                            **          
      ****************************************************************          
       1610-PROCESS-ATTACH-MTB.                                         
      *                                                                         
ACT072     MOVE LX-CODE-UTIL-TYPE      TO E-FMT26-CODE-UTIL-TYPE        
ACT072                                    WS-UTIL-TYPE                  
ACT072                                    E-FMT26B-CODE-UTIL-TYPE.      
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER1               
ACT072                                    E-FMT26B-FILLER1.             
           MOVE LX-DEVICE-NO           TO E-FMT26-DEVICE-NO             
ACT072                                    E-FMT26B-DEVICE-NO.           
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER2               
ACT072                                    E-FMT26B-FILLER2.             
           MOVE LX-CODE-ATT-TYPE       TO E-FMT26-CODE-ATT-TYPE         
ACT072                                    E-FMT26B-CODE-ATT-TYPE.       
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER3               
ACT072                                    E-FMT26B-FILLER3.             
           MOVE LX-CODE-MAKE           TO E-FMT26-CODE-MAKE             
ACT072                                    E-FMT26B-CODE-MAKE.           
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER4               
ACT072                                    E-FMT26B-FILLER4.             
ACT072     MOVE LX-MTR-STORAGE-FAC-CD  TO W9-MTR-STORAGE-FAC-CD         
ACT072     MOVE LX-COMPANY-NO          TO WS-COMPANY-NO.                
ACT072     PERFORM 7400-GET-MSF-TEXT        THRU 7400-EXIT.             
ACT072     MOVE '"'                    TO E-FMT26-QUOTES1               
ACT072                                    E-FMT26B-QUOTES1.             
ACT072     MOVE W9-MTR-STORAGE-FAC-TX  TO E-FMT26-MTR-STORAGE-FAC-CD    
ACT072                                    E-FMT26B-MTR-STORAGE-FAC-CD.  
ACT072     MOVE '"'                    TO E-FMT26-QUOTES2               
ACT072                                    E-FMT26-QUOTES2.              
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER5               
ACT072                                    E-FMT26B-FILLER5.             
ACT072     PERFORM 7500-GET-CURR-LOC-TEXT   THRU 7500-EXIT.             
ACT072     MOVE M6-EQUIP-LOC-DESC      TO E-FMT26-EQUIP-LOC-ID          
ACT072                                    E-FMT26B-EQUIP-LOC-ID.        
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER6               
ACT072                                    E-FMT26B-FILLER6.             
           MOVE LX-DATE-PURCHASED(1:4) TO E-FMT26-YEAR-PURCHASED        
ACT072                                    E-FMT26B-YEAR-PURCHASED.      
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER7               
ACT072                                    E-FMT26B-FILLER7.             
           MOVE LX-DATE-LAST-MOVE      TO E-FMT26-DATE-RETIRED          
ACT072                                    E-FMT26B-DATE-RETIRED.        
ACT072     MOVE WS-COMMA               TO E-FMT26-FILLER8               
ACT072                                    E-FMT26B-FILLER8.             
           MOVE LX-COMPANY-NO          TO E-FMT26-COMPANY-NO            
ACT072                                    E-FMT26B-COMPANY-NO.          
ACT072     IF EQ-COMPANY-NO EQUAL '01'                                  
ACT072        PERFORM 8400-WRITE-FCSMT26       THRU 8400-EXIT           
              MOVE SPACES              TO FIOMT26                       
ACT072     ELSE                                                         
ACT072        PERFORM 8600-WRITE-FCSMT26B      THRU 8600-EXIT           
ACT072        MOVE SPACES              TO FIOMT26B                      
ACT072     END-IF                                                       
           PERFORM 7310-FETCH-ATTACH-CURSOR THRU 7310-EXIT.             
      *                                                                         
       1610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-PROCESS-JUNK-EQUIP                                   **          
      **                                                            **          
      ****************************************************************          
       2000-PROCESS-JUNK-EQUIP.                                         
      *                                                                         
           PERFORM 7100-OPEN-MOVEMENT-JUNK       THRU 7100-EXIT.        
      *                                                                         
           PERFORM 7101-FETCH-MOVEMENT-JUNK      THRU 7101-EXIT.        
           PERFORM 2100-PROCESS-ALL-JUNK-EQUIP   THRU 2100-EXIT         
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                         
           PERFORM 7102-CLOSE-MOVEMENT-JUNK      THRU 7102-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2100-PROCESS-ALL-JUNK-EQUIP                               **          
      **                                                            **          
      ****************************************************************          
       2100-PROCESS-ALL-JUNK-EQUIP.                                     
      *                                                                         
           PERFORM 7010-SELECT-EQUIPMENT         THRU 7010-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7101-FETCH-MOVEMENT-JUNK  THRU 7101-EXIT         
               GO                      TO 2100-EXIT                     
           END-IF.                                                      
      *                                                                         
           IF MV-CODE-UTIL-TYPE   = WS-E AND                            
              MV-CODE-DEVICE-TYPE = WS-M                                
               PERFORM 7020-SELECT-ELEC-METER    THRU 7020-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-E           TO E-FMT02-UTL-TYPE              
                   MOVE WS-MT          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE EM-METER-SIZE-ID                                
                                       TO E-FMT02-METER-SIZE-ID         
PCR040             MOVE ZERO           TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF MV-CODE-UTIL-TYPE   = WS-G AND                            
              MV-CODE-DEVICE-TYPE = WS-M                                
               PERFORM 7030-SELECT-GAS-METER     THRU 7030-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-G           TO E-FMT02-UTL-TYPE              
                   MOVE WS-MT          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE GM-METER-SIZE-ID                                
                                       TO E-FMT02-METER-SIZE-ID         
                   MOVE GM-CODE-CO-SIZE                                 
                                       TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
      *                                                                         
T18652     IF MV-CODE-UTIL-TYPE   = WS-X AND                            
              MV-CODE-DEVICE-TYPE = WS-T                                
               PERFORM 7050-SELECT-INSTR-XFORMER THRU 7050-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE WS-I           TO E-FMT02-UTL-TYPE              
                   MOVE WS-TF          TO E-FMT02-CODE-DEVICE-TYPE      
                   MOVE IX-XFORMER-SIZE-ID                              
                                       TO E-FMT02-METER-SIZE-ID         
                   MOVE ZERO           TO E-FMT02-CODE-CO-SIZE          
                   MOVE EQ-DATE-PURCHASED (1:4)                         
                                       TO E-FMT02-PURCHASE-YEAR         
                   MOVE +1             TO E-FMT02-QTY-RETIRED           
T22243             MOVE EQ-COMPANY-NO  TO E-FMT02-COMPANY-NO            
                   PERFORM 8100-WRITE-FCSMT02    THRU 8100-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7101-FETCH-MOVEMENT-JUNK      THRU 7101-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT072****************************************************************          
ACT072**  2200-CHECK-NO-DATA                                        **          
ACT072****************************************************************          
ACT072*                                                                         
ACT072 2200-CHECK-NO-DATA.                                              
ACT072*                                                                         
ACT072     IF WS-COUNT-GAS-SCEG  < 2                                    
ACT072        MOVE WS-NO-DATA            TO FIOMT01                     
ACT072        PERFORM 8000-WRITE-FCSMT01       THRU 8000-EXIT           
ACT072     END-IF.                                                      
                                                                        
ACT072     IF WS-COUNT-ELECTRIC  <  2                                   
ACT072        MOVE WS-NO-DATA            TO FIOMT22                     
ACT072        PERFORM 8200-WRITE-FCSMT22       THRU 8200-EXIT           
ACT072     END-IF.                                                      
                                                                        
                                                                        
ACT072     IF WS-COUNT-XFORMER   < 2                                    
ACT072        MOVE WS-NO-DATA            TO FIOMT23                     
ACT072        PERFORM 8300-WRITE-FCSMT23       THRU 8300-EXIT           
ACT072     END-IF.                                                      
                                                                        
ACT072     IF WS-COUNT-GAS-ATT-SCEG < 2                                 
ACT072        MOVE WS-NO-DATA            TO FIOMT26                     
ACT072        PERFORM 8400-WRITE-FCSMT26       THRU 8400-EXIT           
ACT072     END-IF.                                                      
                                                                        
ACT072     IF WS-COUNT-GAS-PSNC  < 2                                    
ACT072        MOVE WS-NO-DATA            TO FIOMT01B                    
ACT072        PERFORM 8500-WRITE-FCSMT01B      THRU 8500-EXIT           
ACT072     END-IF.                                                      
                                                                        
ACT072     IF WS-COUNT-GAS-ATT-PSNC  < 2                                
ACT072        MOVE WS-NO-DATA            TO FIOMT26B                    
ACT072        PERFORM 8600-WRITE-FCSMT26B      THRU 8600-EXIT           
ACT072     END-IF.                                                      
                                                                        
ACT072 2200-EXIT.                                                       
ACT072     EXIT.                                                        
      *                                                                         
       COPY CPD00040.                                                           
       COPY CPD00043.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7000-OPEN-EQUIP-CURSOR                                    **          
      **                                                            **          
      ****************************************************************          
T18652 7000-OPEN-EQUIP-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
T18652         OPEN EQUIP_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-OPEN-EQUIP-CURSOR'                         
T18652         DISPLAY 'UTIL   TYPE = ' EQ-CODE-UTIL-TYPE               
T18652         DISPLAY 'DEVICE TYPE = ' EQ-EQUIP-TYPE-CD                
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TO-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TO-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7001-FETCH-EQUIP-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
T18652 7001-FETCH-EQUIP-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
T18652         FETCH EQUIP_CURSOR                                       
ST              INTO :EQ-DEVICE-NO                                      
                    ,:EQ-DATE-LAST-MOVE                                 
                    ,:EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED    
                    ,:EQ-DATE-DISPOSED-OF :WS-NULLIND-DATE-DISPOSED     
END                 ,:EQ-SERIAL-NO                                      
T18652              ,:EQ-CODE-MAKE                                      
T22243              ,:EQ-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
T18652         DISPLAY '7001-FETCH-EQUIP-CURSOR'                        
T18652         DISPLAY 'UTILITY     = ' EQ-CODE-UTIL-TYPE               
T18652         DISPLAY 'TYPE        = ' EQ-EQUIP-TYPE-CD                
T18652         DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18652**  7002-CLOSE-EQUIP-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
T18652 7002-CLOSE-EQUIP-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
T18652         CLOSE EQUIP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T18652         DISPLAY '7002-CLOSE-EQUIP-CURSOR'                        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7010-SELECT-EQUIPMENT                                     **          
      **                                                            **          
      ****************************************************************          
       7010-SELECT-EQUIPMENT.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_UTIL_TYPE,                                   
                      DEVICE_NO,                                        
                      EQUIP_TYPE_CD,                                    
                      SERIAL_NO,                                        
                      CODE_CRNT_LOC,                                    
                      LOCAL_OFFICE,                                     
                      CODE_MAKE,                                        
                      DATE_PURCHASED,                                   
                      DATE_DISPOSED_OF                                  
               INTO   :EQ-CODE-UTIL-TYPE,                               
                      :EQ-DEVICE-NO,                                    
                      :EQ-EQUIP-TYPE-CD,                                
                      :EQ-SERIAL-NO,                                    
                      :EQ-CODE-CRNT-LOC,                                
                      :EQ-LOCAL-OFFICE,                                 
                      :EQ-CODE-MAKE                                     
                     ,:EQ-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED   
                     ,:EQ-DATE-DISPOSED-OF :WS-NULLIND-DATE-DISPOSED    
               FROM   CSS_EQUIPMENT                                     
T18652         WHERE  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
T18652           AND  EQUIP_TYPE_CD  = :EQ-EQUIP-TYPE-CD                
T18652           AND  DEVICE_NO      = :EQ-DEVICE-NO                    
T22243           AND  COMPANY_NO     = :EQ-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
T18652     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '7010-SELECT-EQUIPMENT'                           
T18652        DISPLAY 'UTILITY TYPE = ' EQ-CODE-UTIL-TYPE               
T18652        DISPLAY 'EQUIP TYPE CD= ' EQ-EQUIP-TYPE-CD                
T18652        DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                    
T18652        DISPLAY 'SQLCODE      = ' SQLCODE                         
T22243        DISPLAY 'COMPANY NO   = ' EQ-COMPANY-NO                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7020-SELECT-ELEC-METER                                    **          
      **                                                            **          
      ****************************************************************          
       7020-SELECT-ELEC-METER.                                          
      *                                                                         
A05744     EXEC SQL                                                     
A05744         SELECT EM.CODE_METER_TYPE                                
A05744               ,EM.ELEC_MTR_CLASS_CD                              
A05744               ,EM.ELEC_MTR_SPEC_CD                               
A05744               ,U0.RETIREMENT_UNIT_CD                             
A05744         INTO   :EM-CODE-METER-TYPE                               
A05744               ,:EM-ELEC-MTR-CLASS-CD                             
A05744               ,:EM-ELEC-MTR-SPEC-CD                              
A05744               ,:U0-RETIREMENT-UNIT-CD                            
A05744         FROM   CSS_ELEC_METER    EM                              
A05744               ,CSS_ELEC_CL_SPEC  U0                              
A05744        WHERE  EM.METER_NO       = :EQ-DEVICE-NO                  
A05744          AND  EM.CODE_UTIL_TYPE = :WS-E                          
A05744          AND  EM.COMPANY_NO     = :EM-COMPANY-NO                 
A05744          AND  EM.ELEC_MTR_CLASS_CD = U0.ELEC_MTR_CLASS_CD        
A05744          AND  EM.ELEC_MTR_SPEC_CD  = U0.ELEC_MTR_SPEC_CD         
A05744     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7020-SELECT-ELEC-METER'                         
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' EM-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7030-SELECT-GAS-METER                                     **          
      **                                                            **          
      ****************************************************************          
       7030-SELECT-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT CODE_METER_TYPE                                   
                     ,METER_SIZE_ID                                     
                     ,CODE_CO_SIZE                                      
               INTO   :GM-CODE-METER-TYPE                               
                     ,:GM-METER-SIZE-ID                                 
                     ,:GM-CODE-CO-SIZE                                  
               FROM   CSS_GAS_METER                                     
T18652         WHERE  METER_NO       = :EQ-DEVICE-NO                    
TP3285           AND  CODE_UTIL_TYPE = :WS-G                            
T22243           AND  COMPANY_NO     = :GM-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7030-SELECT-GAS-METER'                          
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' GM-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7050-SELECT-INSTR-XFORMER                                 **          
      **                                                            **          
      ****************************************************************          
       7050-SELECT-INSTR-XFORMER.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT DEVICE_TYPE_CD                                    
T18652               ,XFORMER_TYPE_CD                                   
T18652               ,XFORMER_SIZE_ID                                   
T18652               ,XFORMER_SPEC_CD                                   
               INTO   :IX-DEVICE-TYPE-CD                                
T18652               ,:IX-XFORMER-TYPE-CD                               
T18652               ,:IX-XFORMER-SIZE-ID                               
T18652               ,:IX-XFORMER-SPEC-CD                               
               FROM   CSS_INSTR_XFORMER                                 
T18652         WHERE  XFORMER_NO = :EQ-DEVICE-NO                        
T22243           AND  COMPANY_NO = :IX-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7050-SELECT-INSTR-XFORMER'                      
T18652         DISPLAY 'DEVICE NO    = ' EQ-DEVICE-NO                   
T22243         DISPLAY 'COMPANY NO   = ' IX-COMPANY-NO                  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7100-OPEN-MOVEMENT-JUNK                                   **          
      **                                                            **          
      ****************************************************************          
       7100-OPEN-MOVEMENT-JUNK.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN MVH-JUNK                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7100-OPEN-MOVEMENT-JUNK'                        
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7101-FETCH-MOVEMENT-JUNK                                  **          
      **                                                            **          
      ****************************************************************          
       7101-FETCH-MOVEMENT-JUNK.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH MVH-JUNK                                           
               INTO :MV-CODE-DEVICE-TYPE                                
                   ,:MV-DEVICE-NO                                       
                   ,:MV-DATE-MOVE                                       
                   ,:MV-MOVE-NO                                         
                   ,:MV-LOCAL-OFFICE                                    
                   ,:MV-LOC-NO :WS-NULLIND-LOC-NO                      
                   ,:MV-CODE-CRNT-LOC                                   
                   ,:MV-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               DISPLAY 'DEVICE TYPE = ' MV-CODE-DEVICE-TYPE             
               DISPLAY 'UTIL   TYPE = ' MV-CODE-UTIL-TYPE               
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7101-FETCH-MOVEMENT-JUNK'                       
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TS-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TS-DATE-2               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7102-CLOSE-MOVEMENT-JUNK                                  **          
      **                                                            **          
      ****************************************************************          
       7102-CLOSE-MOVEMENT-JUNK.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE MVH-JUNK                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7102-CLOSE-MOVEMENT-JUNK'                       
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7200-OPEN-MOVEMENT-HIST2                                  **          
      **                                                            **          
      ****************************************************************          
       7200-OPEN-MOVEMENT-HIST-2.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN MVHCUR-2                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7200-OPEN-MOVE-HIST-2'                          
               DISPLAY 'DEVICE TYPE =' MV-CODE-DEVICE-TYPE              
               DISPLAY 'DEVICE NO   =' MV-DEVICE-NO                     
               DISPLAY 'MOVE NO     =' MV-MOVE-NO                       
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7210-FETCH-MOVEMENT-HIST2                                 **          
      **                                                            **          
      ****************************************************************          
       7210-FETCH-MOVEMENT-HIST-2.                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH MVHCUR-2                                           
               INTO :MV-CODE-DEVICE-TYPE,                               
                    :MV-DEVICE-NO,                                      
                    :MV-DATE-MOVE,                                      
                    :MV-MOVE-NO,                                        
                    :MV-LOCAL-OFFICE,                                   
                    :MV-LOC-NO,                                         
                    :MV-CODE-CRNT-LOC,                                  
                    :MV-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           DISPLAY '~~~~~~~~~~~~~~~~~~~~~'                              
           DISPLAY '7210-FETCH-MOVE-HIST-2'                             
           DISPLAY 'SQLCODE     = ' WS-ACTIVE-RETURN-CODE.              
           DISPLAY 'DEVICE TYPE = ' MV-CODE-DEVICE-TYPE.                
           DISPLAY 'DEVICE NO   = ' MV-DEVICE-NO.                       
           DISPLAY 'MOVE NO     = ' MV-MOVE-NO.                         
           DISPLAY 'CRNT LOC    = ' MV-CODE-CRNT-LOC.                   
      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7210-FETCH-MOVE-HIST-2'                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7220-CLOSE-MOVEMENT-HIST2                                 **          
      **                                                            **          
      ****************************************************************          
       7220-CLOSE-MOVEMENT-HIST-2.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE MVHCUR-2                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7220-CLOSE-MOVE-HIST-2'                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7300-OPEN-ATTACH-CURSOR                                   **          
      **                                                            **          
      ****************************************************************          
       7300-OPEN-ATTACH-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ATTACH_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7300-OPEN-ATTACH-CURSOR'                        
               DISPLAY 'UTIL   TYPE = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'DEVICE TYPE = ' LX-CODE-ATT-TYPE                
               DISPLAY 'MOVE DATE1  = ' WS-MOVE-TO-DATE-1               
               DISPLAY 'MOVE DATE2  = ' WS-MOVE-TO-DATE-2               
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7310-FETCH-ATTACH-CURSOR                                  **          
      **                                                            **          
      ****************************************************************          
       7310-FETCH-ATTACH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH ATTACH_CURSOR                                      
               INTO :LX-DEVICE-NO                                       
                   ,:LX-CODE-ATT-TYPE                                   
                   ,:LX-COMPANY-NO                                      
                   ,:LX-CODE-UTIL-TYPE                                  
                   ,:LX-EQUIP-LOC-ID                                    
                   ,:LX-MTR-STORAGE-FAC-CD                              
                   ,:LX-CODE-MAKE                                       
                   ,:LX-DATE-LAST-MOVE :WS-NULLIND-DATE-LAST-MOVE        
                   ,:LX-DATE-PURCHASED :WS-NULLIND-DATE-PURCHASED        
                   ,:LX-DATE-OBSOLETE :WS-NULLIND-DATE-OBSOLETE          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7310-FETCH-ATTACH-CURSOR'                       
               DISPLAY 'UTILITY     = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'TYPE        = ' LX-CODE-ATT-TYPE                
               DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7320-CLOSE-ATTACH-CURSOR                                  **          
      **                                                            **          
      ****************************************************************          
       7320-CLOSE-ATTACH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE ATTACH_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7320-CLOSE-ATTACH-CURSOR'                       
               DISPLAY 'UTILITY     = ' LX-CODE-UTIL-TYPE               
               DISPLAY 'TYPE        = ' LX-CODE-ATT-TYPE                
               DISPLAY 'SQLCODE     = ' SQLCODE                         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT072*****************************************************************         
ACT072* 7400-GET-MSF-TEXT                                                       
ACT072*****************************************************************         
ACT072*                                                                         
ACT072 7400-GET-MSF-TEXT.                                               
ACT072*                                                                         
ACT072     MOVE 7400                     TO WS-ACTIVE-PARAGRAPH         
ACT072                                                                  
ACT072     EXEC SQL                                                     
ACT072         SELECT  MTR_STORAGE_FAC_TX                               
ACT072           INTO :W9-MTR-STORAGE-FAC-TX                            
ACT072           FROM  CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                 
ACT072          WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE               
ACT072            AND  MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD      
ACT072            AND  COMPANY_NO         = :WS-COMPANY-NO              
ACT072       ORDER BY  COMPANY_NO                                       
ACT072                                                          
ACT072                                                     
ACT072     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MTR_STORAGE_FAC_TX                                       
MFA-TR*          INTO :W9-MTR-STORAGE-FAC-TX                                    
MFA-TR*          FROM  CSS_MTR_STORGE_FAC                                       
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE                       
MFA-TR*           AND  MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD              
MFA-TR*           AND  COMPANY_NO         = :WS-COMPANY-NO                      
MFA-TR*      ORDER BY  COMPANY_NO                                               
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT072*                                                                         
ACT072     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT072                                                                  
ACT072     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
ACT072        IF WS-ACTIVE-RETURN-CODE =   NOT-FOUND                    
ACT072           MOVE SPACES                TO W9-MTR-STORAGE-FAC-TX    
ACT072        END-IF                                                    
ACT072        CONTINUE                                                  
ACT072     ELSE                                                         
ACT072         DISPLAY '******** PCSMT301 ABORT ******'                 
ACT072         DISPLAY '**  7400-GET-MSF-TEXT **'                       
ACT072         DISPLAY '**  PARAGRAPH -         ' WS-ACTIVE-PARAGRAPH   
ACT072         DISPLAY '**  COMPANY-NO        **' WS-COMPANY-NO         
ACT072         DISPLAY '**  UTILITY TYPE      **' WS-UTIL-TYPE          
ACT072         DISPLAY '**  METER STORAGE FAC CD **'                    
ACT072                                       W9-MTR-STORAGE-FAC-CD      
ACT072         DISPLAY '** SQLCODE            **' WS-ACTIVE-RETURN-CODE 
ACT072         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT072         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT072     END-IF.                                                      
ACT072*                                                                         
ACT072 7400-EXIT.                                                       
ACT072     EXIT.                                                        
ACT072*                                                                         
ACT072******************************************************************        
ACT072** 7500-GET-CURR-LOC-TEXT                                                 
ACT072******************************************************************        
ACT072*                                                                         
ACT072 7500-GET-CURR-LOC-TEXT.                                          
ACT072*                                                                         
ACT072     MOVE 7500                     TO WS-ACTIVE-PARAGRAPH         
ACT072                                                                  
ACT072     EXEC SQL                                                     
ACT072         SELECT  EQUIP_LOC_DESC                                   
ACT072           INTO :M6-EQUIP-LOC-DESC                                
ACT072           FROM  CSS_EQUIP_LOCATION WITH(READUNCOMMITTED)                 
ACT072          WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE               
ACT072            AND  EQUIP_LOC_ID       = :EQ-CODE-CRNT-LOC           
ACT072            AND  COMPANY_NO         = :WS-COMPANY-NO              
ACT072       ORDER BY  COMPANY_NO                                       
ACT072                                                          
ACT072                                                     
ACT072     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQUIP_LOC_DESC                                           
MFA-TR*          INTO :M6-EQUIP-LOC-DESC                                        
MFA-TR*          FROM  CSS_EQUIP_LOCATION                                       
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE                       
MFA-TR*           AND  EQUIP_LOC_ID       = :EQ-CODE-CRNT-LOC                   
MFA-TR*           AND  COMPANY_NO         = :WS-COMPANY-NO                      
MFA-TR*      ORDER BY  COMPANY_NO                                               
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT072*                                                                         
ACT072     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT072                                                                  
ACT072     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
ACT072        IF WS-ACTIVE-RETURN-CODE =   NOT-FOUND                    
ACT072           MOVE SPACES                TO M6-EQUIP-LOC-DESC        
ACT072        END-IF                                                    
ACT072        CONTINUE                                                  
ACT072     ELSE                                                         
ACT072         DISPLAY '******** PCSMT301 ABORT ******'                 
ACT072         DISPLAY '**  7500-GET-CURR-LOC-TEXT **'                  
ACT072         DISPLAY '**  PARAGRAPH -         ' WS-ACTIVE-PARAGRAPH   
ACT072         DISPLAY '**  COMPANY-NO        **' WS-COMPANY-NO         
ACT072         DISPLAY '**  UTILITY TYPE      **' WS-UTIL-TYPE          
ACT072         DISPLAY '**  METER STORAGE FAC CD **'                    
ACT072                                       EQ-CODE-CRNT-LOC           
ACT072         DISPLAY '** SQLCODE            **' WS-ACTIVE-RETURN-CODE 
ACT072         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT072         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT072     END-IF.                                                      
ACT072*                                                                         
ACT072 7500-EXIT.                                                       
ACT072     EXIT.                                                        
ACT072*                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *COPY CPD00039.                                                           
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8000-WRITE-FCSMT01                                        **          
      **                                                            **          
      ****************************************************************          
       8000-WRITE-FCSMT01.                                              
      *                                                                         
           WRITE FIOMT01.                                               
ACT072     COMPUTE WS-COUNT-GAS-SCEG = WS-COUNT-GAS-SCEG + 1.           
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8100-WRITE-FCSMT02                                        **          
      **                                                            **          
      ****************************************************************          
       8100-WRITE-FCSMT02.                                              
      *                                                                         
ACT072     WRITE FIOMT02.                                               
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
ST    **  8200-WRITE-FCSMT22                                        **          
      ****************************************************************          
       8200-WRITE-FCSMT22.                                              
      *                                                                         
           WRITE FIOMT22.                                               
ACT072     COMPUTE WS-COUNT-ELECTRIC = WS-COUNT-ELECTRIC + 1.           
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8300-WRITE-FCSMT23                                        **          
      ****************************************************************          
       8300-WRITE-FCSMT23.                                              
      *                                                                         
           WRITE FIOMT23.                                               
ACT072     COMPUTE WS-COUNT-XFORMER = WS-COUNT-XFORMER + 1.             
      *                                                                         
       8300-EXIT.                                                       
END        EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8400-WRITE-FCSMT26                                        **          
      ****************************************************************          
       8400-WRITE-FCSMT26.                                              
      *                                                                         
           WRITE FIOMT26.                                               
ACT072     COMPUTE WS-COUNT-GAS-ATT-SCEG  = WS-COUNT-GAS-ATT-SCEG + 1.  
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8500-WRITE-FCSMT01B                                       **          
      ****************************************************************          
       8500-WRITE-FCSMT01B.                                             
      *                                                                         
           WRITE FIOMT01B.                                              
ACT072     COMPUTE WS-COUNT-GAS-PSNC  = WS-COUNT-GAS-PSNC + 1.          
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  8600-WRITE-FCSMT26B                                       **          
      ****************************************************************          
       8600-WRITE-FCSMT26B.                                             
      *                                                                         
           WRITE FIOMT26B.                                              
ACT072     COMPUTE WS-COUNT-GAS-ATT-PSNC  = WS-COUNT-GAS-ATT-PSNC + 1.  
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9000-TERMINATE                                            **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE                                                        
               FCSMT01-FILE                                             
ACT072         FCSMT01B-FILE                                            
               FCSMT02-FILE                                             
T18652         FCSMT22-FILE                                             
T18652         FCSMT23-FILE                                             
               FCSMT26-FILE                                             
ACT072         FCSMT26B-FILE.                                           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9110-INVALID-PARAMETER                                    **          
      **                                                            **          
      ****************************************************************          
       9110-INVALID-PARAMETER.                                          
      *                                                                         
           DISPLAY '*******************************'                    
           DISPLAY '*         PCSMT301'                                 
           DISPLAY '* INVALID PARAMETER ENCOUNTERED'                    
           DISPLAY '* ' E-FJC01-PARAMETER-DATA                          
           DISPLAY '*     PROGRAM TERMINATING'                          
           DISPLAY '*******************************'                    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
       9110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-  THIS INCLUDES THE DB2 SQL ABEND MODULE             **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
