       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP275.                                        
       DATE-WRITTEN.   04/04/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                  PROGRAM DESCRIPTION                        **         
      **                                                             **         
      **  THIS PROGRAM CREATES A REPORT OF RECOVERY DETAILS FOR THE  **         
      **  DIFFERENT COLLECTION AGENCIES BASED ON THE FCSRP275.QSAM   **         
      **  FILE CREATED BY PCSCA275.                                  **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  04/04/95     SJ        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  ---------    ----------------------------------  **         
      **  06/08/95     DW        REMOVED FIOPT33; ADDED CWS00303;    **         
      **                         CHANGED DATE FORMAT TO GET CORRECT  **         
      **                         RUN-DATE; CORRECTED SPACING AND     **         
      **                         SPELLING ERRORS.                    **         
T10311**  04/10/97     EMM       FIXED THE SPACING ON LINE 2 OF THE  **         
      **                         DETAIL TITLE.                       **         
T13739**  11/13/97     EMS       REFORMATTED PRINT LINES             **         
T13740**                                                             **         
T15769**  04/08/98     AMG       ADDED LEGEND BOX AFTER EACH         **         
T15769**                         COLLECTION AGENCY                   **         
C23972**  12/03/01     LAT       CHANGES MADE TO PRINT CORRECT TOTALS**         
C23972**                         AND NEW TOTALS INCLUDED.            **         
T26954**  10/09/02     RICK      ADDED BREAK FOR REGULATED (SEBR) AND**         
T26954**                         NON-REGULATED (SEB) SCANA ACCOUNTS. **         
C27888**  02/12/03     LAT       TO PRINT REMAINING BALANCE ONLY FOR **         
C27888**                         THE LAST TRANSACTION OF AN ACCOUNT. **         
C34351**  07/26/06     PG36856   CONCEALED FIRST 5-DIGITS OF CUSTOMER**         
C34351**                         SSN.                                **         
C30169**  08/05/08     CNVS      REMOVE SOCIAL SECURITY NUMBER       **         
C30169**               CHENNAI                                       **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP275 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP275.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP275.                                                           
       COPY FIORP275.                                                           
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP275'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP275 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCLAGNY                                                 
           END-EXEC.                                                            
      *                                                                         
C23972     EXEC SQL                                                             
C23972         INCLUDE TBCSTSTS                                                 
C23972     END-EXEC.                                                            
C23972*                                                                         
C23972     EXEC SQL                                                             
C23972         INCLUDE TBACCT                                                   
C23972     END-EXEC.                                                            
C23972*                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
               'SOUTH CAROLINA ELEC.& GAS'.                             
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(65)    VALUE               
               '               RECOVERY DETAILS-COLLECTION AGENCY'.     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE2.                                  
               10  FILLER              PIC X(21)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                       'CURRENT AS OF  '.               
               10  WS-DEFAULT-RPT1-TITLE2-A PIC X(08).                  
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED     PIC X(01)   VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-LAST-DET-LINE-PRINTED PIC X(01)   VALUE 'N'.          
           05  WS-MORE-THAN-1-TRANS     PIC X(01)   VALUE 'N'.          
T26954     05  WS-DATABASE                 PIC 9(01) VALUE 0.           
T26954         88  CSR-DATABASE                      VALUE 1.           
T26954         88  SEB-DATABASE                      VALUE 2.           
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE '  '.         
           05  WS-HEADER-COMP-NO       PIC X(02)    VALUE '  '.         
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FRP275-REC-CNTR      PIC 9(09)    VALUE ZERO COMP-3.  
      *                                                                         
C23972     05  WS-TOTAL-PAYMENT-AMT      PIC S9(11)V99  VALUE 0 COMP-3. 
           05  WS-TOTAL-COMN             PIC S9(11)V99  VALUE 0 COMP-3. 
           05  WS-TOTAL-NON-COMN         PIC 9(11)V99   VALUE 0 COMP-3. 
           05  WS-TOTAL-REM-BAL          PIC S9(11)V99  VALUE 0 COMP-3. 
C23972     05  WS-TOTAL-PMTS-RECVD       PIC S9(11)V99  VALUE 0 COMP-3. 
C23972     05  WS-TOT-PMT-CORRECTION     PIC S9(11)V99  VALUE 0 COMP-3. 
C23972     05  WS-TOT-PMTS-ELIG-COMM     PIC S9(11)V99  VALUE 0 COMP-3. 
C23972     05  WS-GRD-TOTAL-PAYMENT-AMT  PIC S9(12)V99  VALUE 0 COMP-3. 
           05  WS-GRD-TOTAL-COMN         PIC S9(12)V99  VALUE 0 COMP-3. 
           05  WS-GRD-TOTAL-NON-COMN     PIC 9(12)V99   VALUE 0 COMP-3. 
           05  WS-GRD-TOTAL-REM-BAL      PIC S9(12)V99  VALUE 0 COMP-3. 
C23972     05  WS-GRD-TOTAL-PMTS-RECVD   PIC S9(12)V99  VALUE 0 COMP-3. 
C23972     05  WS-GRD-TOT-PMTS-ELIG-COMM PIC S9(12)V99  VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOTAL-PAYMENT-AMT  PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOTAL-COMN         PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOTAL-NON-COMN     PIC 9(11)V99   VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOTAL-REM-BAL      PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOTAL-PMTS-RECVD   PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-RGC-TOT-PMTS-ELIG-COMM PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-REG-TOTAL-PAYMENT-AMT  PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-REG-TOTAL-COMN         PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-REG-TOTAL-NON-COMN     PIC 9(11)V99   VALUE 0 COMP-3. 
T26954     05  WS-REG-TOTAL-REM-BAL      PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-REG-TOTAL-PMTS-RECVD   PIC S9(11)V99  VALUE 0 COMP-3. 
T26954     05  WS-REG-TOT-PMTS-ELIG-COMM PIC S9(11)V99  VALUE 0 COMP-3. 
      *                                                                         
           05  WS-FRP275-STATUS          PIC X(02).                     
               88  FRP275-SUCCESSFUL                VALUE '00'.         
      *                                                                         
C30169*    05  WS-SSN                    PIC X(09)    VALUE SPACES.             
           05  WS-CURRENT-COMP-NO        PIC X(02)    VALUE SPACES.     
T26954     05  WS-TEMP-REG-GROUP-CD      PIC X(03)    VALUE SPACES.     
T26954     05  WS-PREV-REG-GROUP-CD      PIC X(03)    VALUE SPACES.     
T26954     05  WS-TEMP-AGENCY-CODE       PIC X(03)    VALUE SPACES.     
           05  WS-PREV-AGENCY-CODE       PIC X(03)    VALUE SPACES.     
           05  WS-PREV-ACCOUNT-NO        PIC X(13)    VALUE SPACES.     
           05  WS-PREV-REM-BALANCE       PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-TOT-LINE-AGENCY-NAME   PIC X(25)    VALUE SPACES.     
T15769     05  WS-LGND-SUB               PIC 99       VALUE 01.         
C23972     05  WS-ACCOUNT-NO             PIC X(13)    VALUE SPACES.     
C23972     05  WS-ACCOUNT-NO-RED         REDEFINES WS-ACCOUNT-NO        
C23972                                   PIC 9(13).                     
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
T26954******* TABLE DECLARATION FOR CSS_DELINQUENCY  ****************   00672700
T26954     EXEC SQL                                                             
T26954         INCLUDE TBDELQ                                                   
T26954     END-EXEC.                                                            
T26954*                                                                 00683200
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 60   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP275'.   
           05  WS-1                    PIC X(01)    VALUE '1'.          
           05  WS-2                    PIC X(01)    VALUE '2'.          
           05  WS-3                    PIC X(01)    VALUE '3'.          
           05  WS-4                    PIC X(01)    VALUE '4'.          
T15769     05  WS-40                   PIC 9(02)    VALUE 40.           
           05  WS-51                   PIC 9(02)    VALUE 51.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
      *                                                                         
C30169*01  WS-SOC-SEC-REDEFINE         PIC 9(09).                               
T34351*                                                                         
C30169*01  WS-SOC-SEC-CAPTURE.                                                  
C30169*    05  WS-SOC-CAP-1ST          PIC X(03).                               
C30169*    05  WS-SOC-CAP-2ND          PIC X(02).                               
C30169*    05  WS-SOC-CAP-3RD          PIC X(04).                               
T34351*                                                                         
C30169*01  WS-SOC-SEC-BREAKDOWN.                                                
C30169*    05  WS-SOC-SEC-1ST          PIC X(03).                               
C30169*    05  WS-SOC-SEC-2ND          PIC X(02).                               
C30169*    05  WS-SOC-SEC-3RD          PIC X(04).                               
T34351*                                                                         
T15769 01 WS-LEGEND-BOX-DEFINITION.                                     
T15769     05  WS-LGND-VALUES.                                          
T15769         10 WS-LGND-CODE-1          PIC X(01)    VALUE 'A'.       
T15769         10 WS-LGND-DESC-1          PIC X(45)                     
T15769            VALUE 'PAYMENT IN FULL, SOLELY FOR PURPOSE OF HAVING'.
T15769         10 WS-LGND-CODE-2          PIC X(01)    VALUE ' '.       
T15769         10 WS-LGND-DESC-2          PIC X(45)                     
T15769            VALUE 'SERVICE RESTORED, MADE DIRECTLY TO COMPANY   '.
T15769         10 WS-LGND-CODE-3          PIC X(01)    VALUE 'B'.       
T15769         10 WS-LGND-DESC-3          PIC X(45)                     
T15769            VALUE 'TRANSFERRED TO AN ACCOUNT                    '.
T15769         10 WS-LGND-CODE-4          PIC X(01)    VALUE 'C'.       
T15769         10 WS-LGND-DESC-4          PIC X(45)                     
T15769            VALUE 'RETURNED CHECK                               '.
T15769         10 WS-LGND-CODE-5          PIC X(01)    VALUE 'D'.       
T15769         10 WS-LGND-DESC-5          PIC X(45)                     
T15769            VALUE 'MISCELLANEOUS DEBIT                          '.
T15769         10 WS-LGND-CODE-6          PIC X(01)    VALUE 'E'.       
T15769         10 WS-LGND-DESC-6          PIC X(45)                     
T15769            VALUE 'MISCELLANEOUS CREDIT                         '.
T15769         10 WS-LGND-CODE-7          PIC X(01)    VALUE 'F'.       
T15769         10 WS-LGND-DESC-7          PIC X(45)                     
T15769            VALUE 'CORRECTION OF PAYMENT                        '.
T15769         10 WS-LGND-CODE-8          PIC X(01)    VALUE 'X'.       
T15769         10 WS-LGND-DESC-8          PIC X(45)                     
T15769            VALUE 'OTHER                                        '.
C23972         10 WS-LGND-CODE-9          PIC X(01)    VALUE 'Y'.       
C23972         10 WS-LGND-DESC-9          PIC X(45)                     
C23972            VALUE 'NO FINANCIAL ACTIVITY IN THE LAST            '.
C23972         10 WS-LGND-CODE-10         PIC X(01)    VALUE ' '.       
C23972         10 WS-LGND-DESC-10         PIC X(45)                     
C23972            VALUE 'TWELVE MONTHS OR MORE                        '.
C23972         10 WS-LGND-CODE-11         PIC X(01)    VALUE 'Z'.       
C23972         10 WS-LGND-DESC-11         PIC X(45)                     
C23972            VALUE 'GOVT/CHURCH VOUCHER                          '.
T15769*                                                                         
C23972     05  WS-LGND-BOX REDEFINES WS-LGND-VALUES OCCURS 11 TIMES.    
T15769         10 WS-LGND-CODE            PIC X(01).                    
T15769         10 WS-LGND-DESC            PIC X(45).                    
      *                                                                         
      ***************** PCSRP275 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(31).                       
               10  FILLER              PIC X(30)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(65).                       
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(34)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(65).                       
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(08)    VALUE               
                                       'AGENCY: '.                      
               10  P-AGENCY-CODE       PIC X(03).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-AGENCY-DESC       PIC X(25).                       
               10  FILLER              PIC X(94)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE 'PLACEMENT'.  
               10  FILLER              PIC X(02)    VALUE SPACE.        
               10  FILLER              PIC X(09)    VALUE 'COLLECTED'.  
               10  FILLER              PIC X(03)    VALUE SPACE.        
               10  FILLER              PIC X(07)    VALUE 'PAYMENT'.    
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'TRANS'.      
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'PAYMENT'.    
               10  FILLER              PIC X(24)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'NON'.        
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE 'REMAINING'.  
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'RSN'.        
               10  FILLER              PIC X(01)    VALUE SPACE.        
      *                                                                         
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X        VALUE SPACE.        
C30169*        10  FILLER              PIC X(03)    VALUE 'SSN'.                
C30169*        10  FILLER              PIC X(07)    VALUE SPACES.               
T10311         10  FILLER              PIC X(04)    VALUE               
                                                   'NAME'.              
C30169         10  FILLER              PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(02)    VALUE 'BY'.         
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'TYPE'.       
               10  FILLER              PIC X(10)    VALUE SPACES.       
T10311         10  FILLER              PIC X(06)    VALUE 'AMOUNT'.     
               10  FILLER              PIC X(08)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'COMMISSION'. 
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'COMMISSION'. 
               10  FILLER              PIC X(08)    VALUE SPACES.       
T10311         10  FILLER              PIC X(07)    VALUE 'BALANCE'.    
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(02)    VALUE 'CD'.         
               10  FILLER              PIC X(02)    VALUE SPACES.       
      *                                                                         
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-WRITE-ACCOUNT-NO      PIC X(13).                   
               10  FILLER                  PIC X(06)    VALUE SPACES.   
               10  P-WRITE-PLACEMENT-DATE  PIC X(08).                   
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-COLLECTED-BY    PIC X(05).                   
               10  FILLER                  PIC X(07)    VALUE SPACES.   
               10  P-WRITE-PAYMENT-DATE    PIC X(08).                   
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-TRANS-TYPE      PIC X(04).                   
               10  FILLER                  PIC X(03)    VALUE SPACES.   
C23972         10  P-WRITE-PAYMENT-AMOUNT  PIC ZZZ,ZZZ,ZZ9.99-.         
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-COMMISSION      PIC ZZZ,ZZZ,ZZ9.99-.         
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-NON-COMMISSION  PIC ZZZ,ZZZ,ZZ9.99.          
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-REM-BALANCE     PIC ZZZ,ZZZ,ZZ9.99-.         
C27888         10  P-WRITE-REMBAL-STR      REDEFINES                    
C27888               P-WRITE-REM-BALANCE   PIC X(15).                   
               10  FILLER                  PIC X(03) VALUE SPACES.      
               10  P-WRITE-REASON-CODE     PIC X(01).                   
               10  FILLER                  PIC X(01) VALUE SPACE.       
           05  WS-DETAIL-LINE-2.                                        
               10  FILLER              PIC X        VALUE SPACE.        
C30169*        10  P-WRITE-SSN             PIC X(09).                           
C30169*        10  FILLER                  PIC X(01)    VALUE SPACES.           
               10  P-WRITE-CUSTOMER-NAME   PIC X(43).                   
C30169         10  FILLER                  PIC X(89)    VALUE SPACES.   
      *                                                                         
       01  WS-TOTAL-LINE.                                               
           05  WS-AGENCY-TOTAL-LINE.                                    
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER                  PIC X(26)    VALUE SPACES.   
               10  P-WRITE-AGENCY-NAME     PIC X(25).                   
               10  FILLER                  PIC X(01) VALUE SPACE.       
               10  FILLER                  PIC X(07)    VALUE 'TOTALS:'.
               10  FILLER                  PIC X(01)    VALUE SPACES.   
               10  P-WRITE-TOT-PAYMENT-AMT PIC ZZZ,ZZZ,ZZ9.99.          
C23972         10  FILLER                  PIC X(04)    VALUE SPACES.   
               10  P-WRITE-TOT-COMN        PIC ZZZ,ZZZ,ZZ9.99-.         
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-TOT-NON-COMN    PIC ZZZ,ZZZ,ZZ9.99.          
               10  FILLER                  PIC X(03)    VALUE SPACES.   
               10  P-WRITE-TOT-REM-BAL     PIC ZZZ,ZZZ,ZZ9.99-.         
               10  FILLER                  PIC X(04)    VALUE SPACES.   
      *                                                                         
C23972     05  WS-TOTAL-LINE-2.                                         
               10  FILLER              PIC X        VALUE SPACE.        
C23972         10  FILLER                  PIC X(35)    VALUE SPACES.   
C23972         10  FILLER                  PIC X(24)    VALUE           
C23972                                     'TOTAL PAYMENTS RECEIVED:'.  
C23972         10  FILLER                  PIC X(01)    VALUE SPACES.   
C23972         10  P-WRITE-TOTAL-PMTS-ONLY PIC ZZZ,ZZZ,ZZ9.99-.         
C23972*                                                                         
C23972     05  WS-TOTAL-LINE-3.                                         
               10  FILLER              PIC X        VALUE SPACE.        
C23972         10  FILLER                  PIC X(20)    VALUE SPACES.   
C23972         10  FILLER                  PIC X(39)    VALUE           
C23972                     'TOTAL PAYMENTS ELIGIBLE FOR COMMISSION:'.   
C23972         10  FILLER                  PIC X(01)    VALUE SPACES.   
C23972         10  P-WRITE-TOT-PMTS-ELIG-COMM                           
C23972                                     PIC ZZZ,ZZZ,ZZ9.99-.         
C23972*                                                                         
           05  WS-GRAND-TOTAL-LINE.                                     
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER                    PIC X(21)    VALUE SPACES. 
               10  P-WRITE-GRD-TOT-LABEL     PIC X(25)    VALUE SPACES. 
               10  FILLER                    PIC X(13)    VALUE         
                                                        'GRAND TOTALS:'.
               10  FILLER                    PIC X(01)    VALUE SPACES. 
               10  P-WRITE-GRD-TOT-PAYMT-AMT PIC ZZZ,ZZZ,ZZ9.99.        
               10  FILLER                    PIC X(04)    VALUE SPACES. 
               10  P-WRITE-GRD-TOT-COMN      PIC ZZZ,ZZZ,ZZ9.99-.       
               10  FILLER                    PIC X(03)    VALUE SPACES. 
               10  P-WRITE-GRD-TOT-NON-COMN  PIC ZZZ,ZZZ,ZZ9.99.        
               10  FILLER                    PIC X(03)    VALUE SPACES. 
               10  P-WRITE-GRD-TOT-REM-BAL   PIC ZZZ,ZZZ,ZZ9.99-.       
               10  FILLER                    PIC X(04)    VALUE SPACES. 
C23972     05  WS-GRAND-TOTAL-LINE-2.                                   
               10  FILLER              PIC X        VALUE SPACE.        
C23972         10  FILLER                    PIC X(29)    VALUE SPACES. 
C23972         10  FILLER                    PIC X(30)    VALUE         
C23972                                'GRAND TOTAL PAYMENTS RECEIVED:'. 
C23972         10  FILLER                    PIC X(01)    VALUE SPACES. 
C23972         10  P-WRITE-GRD-TOTAL-PMTS-RECVD                         
C23972                                       PIC ZZZ,ZZZ,ZZ9.99.        
C23972     05  WS-GRAND-TOTAL-LINE-3.                                   
               10  FILLER              PIC X        VALUE SPACE.        
C23972         10  FILLER                    PIC X(14)    VALUE SPACES. 
C23972         10  FILLER                    PIC X(45)    VALUE         
C23972                 'GRAND TOTAL PAYMENTS ELIGIBLE FOR COMMISSION:'. 
C23972         10  FILLER                    PIC X(01)    VALUE SPACES. 
C23972         10  P-WRITE-GRD-TOT-PMTS-ELIG-COMM                       
C23972                                       PIC ZZZ,ZZZ,ZZ9.99.        
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
T15769 01  WS-LEGEND-BOX-LAYOUT.                                        
T15769     05  WS-LGND-BOX-BORDER.                                      
               10  FILLER              PIC X        VALUE SPACE.        
T15769         10  FILLER                    PIC X(10)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(63)   VALUE ALL '*'. 
T15769         10  FILLER                    PIC X(59)   VALUE SPACES.  
T15769*                                                                         
T15769     05  WS-LGND-HDR-1.                                           
               10  FILLER              PIC X        VALUE SPACE.        
T15769         10  FILLER                    PIC X(10)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(05)   VALUE '**   '. 
T15769         10  FILLER                    PIC X(26)                  
T15769             VALUE 'CODE    REASON DESCRIPTION'.                  
T15769         10  FILLER                    PIC X(30)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(02)   VALUE '**'.    
T15769         10  FILLER                    PIC X(59)   VALUE SPACES.  
T15769*                                                                         
T15769     05  WS-LGND-HDR-2.                                           
               10  FILLER              PIC X        VALUE SPACE.        
T15769         10  FILLER                    PIC X(10)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(05)   VALUE '**   '. 
T15769         10  FILLER                    PIC X(26)                  
T15769             VALUE '----    ------------------'.                  
T15769         10  FILLER                    PIC X(30)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(02)   VALUE '**'.    
T15769         10  FILLER                    PIC X(59)   VALUE SPACES.  
T15769*                                                                         
T15769     05  WS-LGND-BOX-LINE.                                        
               10  FILLER              PIC X        VALUE SPACE.        
T15769         10  FILLER                    PIC X(10)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(05)   VALUE '**   '. 
T15769         10  WS-LGND-LINE-CODE         PIC X(01)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(07)   VALUE SPACES.  
T15769         10  WS-LGND-LINE-DESC         PIC X(45)   VALUE SPACES.  
T15769         10  FILLER                    PIC X(05)   VALUE '   **'. 
T15769         10  FILLER                    PIC X(59)   VALUE SPACES.  
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP275 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC            THRU 1000-EXIT.    
           PERFORM 7100-READ-FCSRP275                THRU 7100-EXIT.    
           MOVE E-FRP275-COLLEC-AGENCY-CODE                             
                                       TO WS-PREV-AGENCY-CODE.          
           MOVE E-FRP275-ACCOUNT-NO    TO WS-PREV-ACCOUNT-NO.           
T26954     MOVE E-FRP275-REG-GROUP-CD  TO WS-PREV-REG-GROUP-CD.         
           PERFORM 1100-PRODUCE-REPORTS              THRU 1100-EXIT     
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FRP275-REC-CNTR EQUAL ZERO                         
                   PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
                   PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT     
                   PERFORM 8400-PRINT-RPT1-HEADERS   THRU 8400-EXIT     
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF  WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                    
                   PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
                   PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT     
                   PERFORM 8400-PRINT-RPT1-HEADERS   THRU 8400-EXIT     
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP275 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP275 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSRP275-FILE.                                    
           IF FRP275-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP275 PROCESSING ERROR       **'    
               DISPLAY '**  OPEN ERROR OF FCSRP275 - INPUT FILE  **'    
               DISPLAY '**      FILE STATUS = ' WS-FRP275-STATUS        
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
T26954     MOVE C7-COMPANY-NO            TO C8-COMPANY-NO.              
T26954     MOVE 'DATABASE'               TO C8-DELINQ-CD.               
T26954     PERFORM 7500-GET-DATABASE     THRU 7500-EXIT.                
T26954     MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSRP701-FILE         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-READ-FCSRP275            THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP275-KEY-BREC EQUAL LOW-VALUES                        
               SUBTRACT 1 FROM WS-FRP275-REC-CNTR                       
               MOVE E-FRP275-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
               MOVE WS-DATE-8          TO WS-DEFAULT-RPT1-TITLE2-A      
           ELSE                                                         
               DISPLAY '**       PCSRP275 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP275 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           ELSE                                                         
               IF  E-FRP275-CO-KEY-EREC EQUAL HIGH-VALUES OR            
                   E-FRP275-KEY-EREC    EQUAL HIGH-VALUES               
                   PERFORM 1700-CHECK-END-REC     THRU 1700-EXIT        
               ELSE                                                     
                   IF REPORT-STARTED                                    
T26954                 PERFORM 1850-PROCESS-CO-END-REC-SEB              
T26954                                            THRU 1850-EXIT        
                       PERFORM 2100-CHECK-COMP-NO THRU 2100-EXIT        
                   ELSE                                                 
                       MOVE WS-Y TO WS-START-REPORT                     
                       MOVE E-FRP275-COMPANY-NO                         
                                       TO WS-CURRENT-COMP-NO            
T26954                 PERFORM 1850-PROCESS-CO-END-REC-SEB              
T26954                                            THRU 1850-EXIT        
                       PERFORM 2100-CHECK-COMP-NO THRU 2100-EXIT        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE E-FRP275-COLLEC-AGENCY-CODE                             
                                       TO WS-PREV-AGENCY-CODE.          
           MOVE E-FRP275-ACCOUNT-NO    TO WS-PREV-ACCOUNT-NO.           
      *                                                                         
           PERFORM 7100-READ-FCSRP275                 THRU 7100-EXIT.   
      *                                                                         
           IF WS-LAST-DET-LINE-PRINTED = 'N'                            
               IF E-FRP275-ACCOUNT-NO = WS-PREV-ACCOUNT-NO              
                   IF WS-MORE-THAN-1-TRANS = 'Y'                        
                       MOVE SPACES          TO P-WRITE-ACCOUNT-NO       
                                               P-WRITE-CUSTOMER-NAME    
                                               P-WRITE-PLACEMENT-DATE   
C30169*                                        P-WRITE-SSN                      
                   END-IF                                               
                   MOVE 'Y'                 TO WS-MORE-THAN-1-TRANS     
C27888             MOVE SPACES              TO P-WRITE-REMBAL-STR       
                   PERFORM 8900-PRINT-RPT1-DETAIL         THRU 8900-EXIT
               ELSE                                                     
                   ADD  WS-PREV-REM-BALANCE TO WS-TOTAL-REM-BAL         
                   ADD  WS-PREV-REM-BALANCE TO WS-GRD-TOTAL-REM-BAL     
      *                                                                         
                   IF WS-MORE-THAN-1-TRANS = 'Y'                        
                       MOVE SPACES          TO P-WRITE-ACCOUNT-NO       
                                               P-WRITE-CUSTOMER-NAME    
                                               P-WRITE-PLACEMENT-DATE   
C30169*                                        P-WRITE-SSN                      
                   END-IF                                               
      *                                                                         
                   PERFORM 8900-PRINT-RPT1-DETAIL         THRU 8900-EXIT
      *                                                                         
                   MOVE 'N'            TO WS-MORE-THAN-1-TRANS          
      *                                                                         
                   IF  E-FRP275-CO-KEY-EREC EQUAL HIGH-VALUES OR        
                       E-FRP275-KEY-EREC    EQUAL HIGH-VALUES           
                       MOVE 'Y'             TO WS-LAST-DET-LINE-PRINTED 
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       IT CHECKS WHETHER PROCESS END REC OR COMPANY END REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           MOVE '1700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP275-CO-NO-KEY-EREC EQUAL HIGH-VALUES                 
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           MOVE '1800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP275-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FRP275-CO-REC-COUNT-EREC         
               IF SYSIN-EXISTS  AND                                     
                    E-FRP275-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO      
                   MOVE WS-Y TO WS-END-OF-SYSIN-REC                     
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**      PCSRP275 PROCESSING ERROR      **'      
               DISPLAY '**  COMPANY NO = ' E-FRP275-CO-NO-KEY-EREC      
               DISPLAY '** ACTUAL RECORD COUNT OF THE COMPANY  **'      
               DISPLAY '**    DOES NOT MATCH CONTROL RECORD    **'      
               DISPLAY '** CONTROL REC COUNT = '                        
                               E-FRP275-CO-REC-COUNT-EREC               
               DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR       
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               IF E-FRP275-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO        
                   PERFORM 8500-PRINT-RPT1-AGENCY-TOTAL                 
                                                 THRU 8500-EXIT         
T26954             IF SEB-DATABASE                                      
T26954                 PERFORM 8700-PRINT-RPT1-REGGC-TOTAL              
T26954                                               THRU 8700-EXIT     
T26954                 PERFORM 8800-PRINT-RPT1-REG-TOTAL                
T26954                                               THRU 8800-EXIT     
T26954             END-IF                                               
                   PERFORM 8600-PRINT-RPT1-GRAND-TOTAL                  
                                                 THRU 8600-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM 8500-PRINT-RPT1-AGENCY-TOTAL                     
                                                 THRU 8500-EXIT         
T26954         IF SEB-DATABASE                                          
T26954             PERFORM 8700-PRINT-RPT1-REGGC-TOTAL                  
T26954                                           THRU 8700-EXIT         
T26954             PERFORM 8800-PRINT-RPT1-REG-TOTAL                    
T26954                                           THRU 8800-EXIT         
T26954         END-IF                                                   
               PERFORM 8600-PRINT-RPT1-GRAND-TOTAL                      
                                                 THRU 8600-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
T26954*                                                                         
T26954****************************************************************          
T26954**                                                            **          
T26954**   1850-PROCESS-CO-END-REC-SEB                              **          
T26954**       IT STOPS THE PROCESSING OF RECORDS FOR A SEB COMPANY **          
T26954**                                                            **          
T26954****************************************************************          
T26954*                                                                         
T26954 1850-PROCESS-CO-END-REC-SEB.                                     
T26954*                                                                         
T26954     MOVE '1850' TO WS-ACTIVE-PARAGRAPH.                          
T26954*                                                                         
T26954     IF E-FRP275-REG-GROUP-CD NOT = WS-PREV-REG-GROUP-CD          
T26954         PERFORM 8500-PRINT-RPT1-AGENCY-TOTAL THRU 8500-EXIT      
T26954         PERFORM 8700-PRINT-RPT1-REGGC-TOTAL THRU 8700-EXIT       
T26954         MOVE E-FRP275-REG-GROUP-CD TO WS-PREV-REG-GROUP-CD       
T26954         MOVE E-FRP275-COLLEC-AGENCY-CODE TO WS-PREV-AGENCY-CODE  
T26954     END-IF.                                                      
T26954*                                                                         
T26954 1850-EXIT.                                                       
T26954     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           MOVE '1900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP275-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**        PCSRP275 PROCESSING ERROR        **'  
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD  **'  
               DISPLAY '**          PROCESSING TERMINATED          **'  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FRP275-REC-CNTR EQUAL E-FRP275-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP275 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP275-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP275-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE E-FRP275-COMPANY-NO TO WS-CURRENT-COMP-NO           
               MOVE E-FRP275-COLLEC-AGENCY-CODE                         
                                        TO WS-PREV-AGENCY-CODE          
               MOVE WS-N                TO WS-CHANGE-COMP-NO            
           END-IF.                                                      
      *                                                                         
           IF E-FRP275-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO          
               DISPLAY '**      PCSRP275 PROCESSING ERROR      **'      
               DISPLAY '** COMPANY DATA RECORDS NOT SEPARATED  **'      
               DISPLAY '**     WITH PROPER COMPANY END-REC     **'      
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FRP275-COMPANY-NO 
               DISPLAY '** DATA IS :' E-FRP275-DATA-REC                 
               DISPLAY '**       PROCESSING TERMINATED         **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF  SYSIN-EXISTS                                         
                   IF E-FRP275-COMPANY-NO EQUAL WS-SYSIN-COMP-NO        
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT1                    
                                                 THRU 2200-EXIT         
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '*  PCSRP275 PROCESSING ERROR     *' 
                           DISPLAY '* INPUT FILE NOT SORTED PROPERLY *' 
                           DISPLAY '*   IN ORDER OF COMPANY NUMBERS  *' 
                           DISPLAY '* DATA IS :' E-FRP275-DATA-REC      
                           DISPLAY '*    PROCESSING TERMINATED       *' 
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT1     THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT1                                        **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT1.                                               
      *                                                                         
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP275-COLLEC-AGENCY-CODE NOT EQUAL WS-PREV-AGENCY-CODE 
               PERFORM 8500-PRINT-RPT1-AGENCY-TOTAL                     
                                                 THRU 8500-EXIT         
               MOVE E-FRP275-COLLEC-AGENCY-CODE                         
                                       TO WS-PREV-AGENCY-CODE           
               MOVE WS-60              TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-51                        
               PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT         
               PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT         
               PERFORM 8300-PRINT-RPT1-AGENCY-HEADER                    
                                                 THRU 8300-EXIT         
               PERFORM 8400-PRINT-RPT1-HEADERS   THRU 8400-EXIT         
           END-IF.                                                      
      *                                                                         
               PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP275-ACCOUNT-NO    TO  P-WRITE-ACCOUNT-NO.          
           MOVE E-FRP275-NAME          TO  P-WRITE-CUSTOMER-NAME.       
C30169*    PERFORM 7900-GET-SSN        THRU 7900-EXIT.                          
C23972*    MOVE CE-SSN                 TO P-WRITE-SSN.                          
T34351*                                                                         
C30169*    IF CE-SSN NOT EQUAL SPACES                                           
C30169*      MOVE CE-SSN                 TO WS-SOC-SEC-REDEFINE                 
C30169*      MOVE WS-SOC-SEC-REDEFINE    TO WS-SOC-SEC-CAPTURE                  
C30169*      MOVE '***'                  TO WS-SOC-SEC-1ST                      
C30169*      MOVE '**'                   TO WS-SOC-SEC-2ND                      
C30169*    IF WS-SOC-CAP-3RD NOT EQUAL SPACES                                   
C30169*      MOVE WS-SOC-CAP-3RD         TO WS-SOC-SEC-3RD                      
C30169*    ELSE                                                                 
C30169*      MOVE '****'                 TO WS-SOC-SEC-3RD                      
C30169*    END-IF                                                               
C30169*      MOVE WS-SOC-SEC-BREAKDOWN   TO P-WRITE-SSN                         
C30169*    END-IF.                                                              
T34351*                                                                         
           MOVE E-FRP275-PLACEMENT-DATE                                 
                                       TO WS-DATE-10.                   
           MOVE WS-D10-MM              TO WS-D8-MM                      
           MOVE WS-D10-DD              TO WS-D8-DD                      
           MOVE WS-D10-YY              TO WS-D8-YY                      
           MOVE WS-DATE-8              TO P-WRITE-PLACEMENT-DATE.       
           MOVE E-FRP275-COLLECTED-BY                                   
                                       TO P-WRITE-COLLECTED-BY.         
           MOVE E-FRP275-PAYMENT-DATE  TO WS-DATE-10.                   
           MOVE WS-D10-MM              TO WS-D8-MM                      
           MOVE WS-D10-DD              TO WS-D8-DD                      
           MOVE WS-D10-YY              TO WS-D8-YY                      
           MOVE WS-DATE-8              TO P-WRITE-PAYMENT-DATE.         
      *                                                                         
           EVALUATE E-FRP275-TRANS-TYPE                                 
             WHEN 'A'                                                   
               MOVE 'ADJ'              TO P-WRITE-TRANS-TYPE            
             WHEN 'B'                                                   
               MOVE 'BIL'              TO P-WRITE-TRANS-TYPE            
             WHEN 'C'                                                   
               MOVE 'COR'              TO P-WRITE-TRANS-TYPE            
             WHEN 'D'                                                   
               MOVE 'ARG'              TO P-WRITE-TRANS-TYPE            
             WHEN 'E'                                                   
               MOVE 'CNT'              TO P-WRITE-TRANS-TYPE            
             WHEN 'F'                                                   
               MOVE 'MNT'              TO P-WRITE-TRANS-TYPE            
             WHEN 'H'                                                   
               MOVE 'NOT'              TO P-WRITE-TRANS-TYPE            
             WHEN 'I'                                                   
               MOVE 'CRT'              TO P-WRITE-TRANS-TYPE            
             WHEN 'P'                                                   
               MOVE 'PMT'              TO P-WRITE-TRANS-TYPE            
             WHEN 'R'                                                   
               MOVE 'REF'              TO P-WRITE-TRANS-TYPE            
             WHEN 'S'                                                   
               MOVE 'CHG'              TO P-WRITE-TRANS-TYPE            
             WHEN 'T'                                                   
               MOVE 'XFR'              TO P-WRITE-TRANS-TYPE            
             WHEN 'W'                                                   
               MOVE 'W/O'              TO P-WRITE-TRANS-TYPE            
           END-EVALUATE.                                                
                                                                        
           MOVE E-FRP275-PAYMENT-AMOUNT                                 
                                       TO P-WRITE-PAYMENT-AMOUNT.       
           MOVE E-FRP275-COMMISSION    TO P-WRITE-COMMISSION.           
           MOVE E-FRP275-NON-COMMISSION                                 
                                       TO P-WRITE-NON-COMMISSION.       
           MOVE E-FRP275-REM-BALANCE   TO WS-PREV-REM-BALANCE           
                                          P-WRITE-REM-BALANCE.          
           MOVE E-FRP275-REASON-CODE   TO P-WRITE-REASON-CODE.          
      *                                                                         
           ADD  E-FRP275-COMMISSION    TO WS-TOTAL-COMN.                
           ADD  E-FRP275-NON-COMMISSION                                 
                                       TO WS-TOTAL-NON-COMN.            
C23972*    IF TRANS TYPE IS COR OR CHG, THEN SUBTRACT, ELSE ADD                 
C23972     IF E-FRP275-TRANS-TYPE = 'C' OR 'S'                          
C23972        SUBTRACT E-FRP275-PAYMENT-AMOUNT                          
C23972                                 FROM WS-TOTAL-PAYMENT-AMT        
C23972     ELSE                                                         
              ADD  E-FRP275-PAYMENT-AMOUNT                              
                                       TO WS-TOTAL-PAYMENT-AMT
           END-IF.         
C23972     IF E-FRP275-TRANS-TYPE = 'P'                                 
C23972        ADD  E-FRP275-PAYMENT-AMOUNT                              
C23972                                 TO WS-TOTAL-PMTS-RECVD
           END-IF.          
C23972     IF E-FRP275-TRANS-TYPE = 'C'                                 
C23972        ADD  E-FRP275-PAYMENT-AMOUNT                              
C23972                                 TO WS-TOT-PMT-CORRECTION
           END-IF.        
C23972     IF E-FRP275-TRANS-TYPE = 'P' AND E-FRP275-REASON-CODE        
C23972                                      EQUAL SPACES                
C23972        ADD  E-FRP275-PAYMENT-AMOUNT                              
C23972                                 TO WS-TOT-PMTS-ELIG-COMM
           END-IF.        
C23972     IF E-FRP275-TRANS-TYPE = 'P' AND E-FRP275-REASON-CODE = 'F'  
C23972        MOVE SPACES              TO P-WRITE-REASON-CODE
           END-IF.          
      *                                                                         
           ADD  E-FRP275-COMMISSION    TO WS-GRD-TOTAL-COMN.            
           ADD  E-FRP275-NON-COMMISSION                                 
                                       TO WS-GRD-TOTAL-NON-COMN.        
C23972*    ADD  E-FRP275-PAYMENT-AMOUNT                                         
C23972*                                TO WS-GRD-TOTAL-PAYMENT-AMT.             
C23972*    ADD WS-TOTAL-PAYMENT-AMT    TO WS-GRD-TOTAL-PAYMENT-AMT.             
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP275                                       **          
      **       READS THE INPUT FILE FCSRP275-FILE                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP275.                                              
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           READ FCSRP275-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP275-SUCCESSFUL                                         
               ADD 1                   TO WS-FRP275-REC-CNTR            
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP275 READ.  STATUS IS '       
                        WS-FRP275-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26954******************************************************************04850000
T26954*  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *04880000
T26954******************************************************************04900000
T26954 7500-GET-DATABASE.                                               
T26954                                                                  
T26954     EXEC SQL                                                     
T26954        SELECT  DELINQ_VALUE                                      
T26954        INTO    :C8-DELINQ-VALUE                                  
T26954        FROM    CSS_DELINQUENCY                                   
T26954        WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
T26954        AND     COMPANY_NO = :C8-COMPANY-NO                       
T26954     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26954                                                                  
T26954     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
T26954                                                                  
T26954     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26954           NEXT SENTENCE                                          
T26954     ELSE                                                         
T26954         DISPLAY '*************************************'          
T26954         DISPLAY '* 7500-GET-DATABASE'                            
T26954         DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
T26954         DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
T26954         DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
T26954         DISPLAY '*************************************'          
T26954         PERFORM 9900-ABEND   THRU 9900-EXIT                      
T26954     END-IF.                                                      
T26954                                                                  
T26954 7500-EXIT.                                                       
T26954     EXIT.                                                        
T26954*                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-GET-AGENCY-DESC                                     **          
      **      READS THE AGENCY NAME WITH THE GIVEN CODE             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GET-AGENCY-DESC.                                            
      *                                                                         
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT      COLLEC_AGNCY_NAME                            
                INTO   :Q7-COLLEC-AGNCY-NAME                            
               FROM    CSS_COLLECT_AGENCY                               
                WHERE CODE_COLLEC_AGNCY = :Q7-CODE-COLLEC-AGNCY         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE Q7-COLLEC-AGNCY-NAME                                
                                       TO P-AGENCY-DESC,                
                                          WS-TOT-LINE-AGENCY-NAME       
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-AGENCY-DESC                 
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7700-GET-AGENCY-DESC *'   
                   DISPLAY '* RETURN CODE = ' SQLCODE                   
                   DISPLAY '*        PROCESSING TERMINATED         *'   
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
               FROM  CSS_COMPANY                                        
                WHERE    COMPANY_NO = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7800-GET-COMPANY-DESC *'  
                   DISPLAY '* RETURN CODE = ' SQLCODE                   
                   DISPLAY '*         PROCESSING TERMINATED         *'  
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
C23972*                                                                         
C30169****************************************************************          
C30169** 7900-GET-SSN                                               **          
C30169** GET THE CUSTOMER'S SSN                                     **          
C30169****************************************************************          
C30169*                                                                         
C30169*7900-GET-SSN.                                                            
C30169*                                                                         
C30169*    MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                                  
C30169*    MOVE E-FRP275-ACCOUNT-NO TO WS-ACCOUNT-NO.                           
C30169*    MOVE WS-ACCOUNT-NO-RED   TO AT-ACCOUNT-NO.                           
C30169*                                                                         
C30169*    EXEC SQL                                                             
C30169*       SELECT SSN                                                        
C30169*         INTO :CE-SSN                                                    
C30169*         FROM CSS_CUST_STATS                                             
C30169*        WHERE CUSTOMER_NO = (SELECT CUSTOMER_NO                          
C30169*                               FROM CSS_ACCOUNT                          
C30169*                              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO)         
C30169*          AND CUSTOMER_TYPE = 'C'                                        
C30169*    END-EXEC.                                                            
C30169*                                                                         
C30169*    IF SQLCODE EQUAL SUCCESSFUL-CALL                                     
C30169*       NEXT SENTENCE                                                     
C30169*    ELSE                                                                 
C30169*       IF SQLCODE EQUAL NOT-FOUND                                        
C30169*          MOVE SPACES TO CE-SSN                                          
C30169*       ELSE                                                              
C30169*          DISPLAY '* SELECT ERROR IN 7900-GET-SSN *'                     
C30169*          DISPLAY '* RETURN CODE = ' SQLCODE                             
C30169*          DISPLAY '*         PROCESSING TERMINATED         *'            
C30169*          PERFORM 9900-ABEND            THRU 9900-EXIT                   
C30169*       END-IF                                                            
C30169*    END-IF.                                                              
C30169*                                                                         
C30169*7900-EXIT.                                                               
C30169*    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-RPT1-COMP-NAME                            **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-RPT1-COMP-NAME.                                       
      *                                                                         
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
              AND WS-CURRENT-COMP-NO NOT EQUAL WS-HEADER-COMP-NO        
               MOVE WS-CURRENT-COMP-NO TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
               MOVE WS-CURRENT-COMP-NO TO WS-HEADER-COMP-NO             
           END-IF.                                                      
      *                                                                         
T26954     IF E-FRP275-REG-GROUP-CD = '100' OR '200'                    
T26954         MOVE 'SCANA ENERGY REGULATED DIVISION'                   
T26954                                           TO P-RPT1-COMP-NAME    
T26954     END-IF.                                                      
T26954*                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-RPT1-TITLE                                    **          
      **       PRINTS THE TITLES  FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-RPT1-TITLE.                                           
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-RPT1-AGENCY-HEADER                            **          
      **      PRINTS THE AGENCY CODE & DESC IN THE REPORT HEADER    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-RPT1-AGENCY-HEADER.                                   
      *                                                                         
           MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP275-COLLEC-AGENCY-CODE                             
                                       TO P-AGENCY-CODE                 
                                          Q7-CODE-COLLEC-AGNCY.         
           PERFORM 7700-GET-AGENCY-DESC          THRU 7700-EXIT.        
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                  AFTER ADVANCING 3 LINE.                               
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-RPT1-HEADERS                                  **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-RPT1-HEADERS.                                         
      *                                                                         
           MOVE '8400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-32                    
                 AFTER ADVANCING 3 LINES.                               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-33                    
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 5                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8500-PRINT-RPT1-AGENCY-TOTAL                             **          
      **       PRINTS THE TOTAL LINE OF THE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-RPT1-AGENCY-TOTAL.                                    
      *                                                                         
           MOVE '8500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
C23972     ADD  WS-TOTAL-PAYMENT-AMT   TO WS-GRD-TOTAL-PAYMENT-AMT.     
           MOVE WS-TOTAL-PAYMENT-AMT   TO P-WRITE-TOT-PAYMENT-AMT.      
           MOVE WS-TOTAL-COMN          TO P-WRITE-TOT-COMN.             
           MOVE WS-TOTAL-NON-COMN      TO P-WRITE-TOT-NON-COMN.         
           MOVE WS-TOTAL-REM-BAL       TO P-WRITE-TOT-REM-BAL.          
           MOVE WS-TOT-LINE-AGENCY-NAME                                 
                                       TO P-WRITE-AGENCY-NAME.          
C23972     COMPUTE WS-TOTAL-PMTS-RECVD = WS-TOTAL-PMTS-RECVD -          
C23972                                   WS-TOT-PMT-CORRECTION          
C23972     MOVE WS-TOTAL-PMTS-RECVD    TO P-WRITE-TOTAL-PMTS-ONLY       
C23972     ADD  WS-TOTAL-PMTS-RECVD    TO WS-GRD-TOTAL-PMTS-RECVD       
C23972     MOVE WS-TOT-PMTS-ELIG-COMM  TO P-WRITE-TOT-PMTS-ELIG-COMM    
C23972     ADD  WS-TOT-PMTS-ELIG-COMM  TO WS-GRD-TOT-PMTS-ELIG-COMM     
      *                                                                         
           WRITE PRT33-RECORD FROM WS-AGENCY-TOTAL-LINE                 
                 AFTER ADVANCING 2 LINES.                               
C23972     WRITE PRT33-RECORD FROM WS-TOTAL-LINE-2                      
C23972           AFTER ADVANCING 1 LINES.                               
C23972     WRITE PRT33-RECORD FROM WS-TOTAL-LINE-3                      
C23972           AFTER ADVANCING 1 LINES.                               
                                                                        
T15769     PERFORM 8950-PRINT-LEGEND-BOX     THRU 8950-EXIT.            
T26954*                                                                         
T26954     ADD WS-TOTAL-PAYMENT-AMT   TO WS-RGC-TOTAL-PAYMENT-AMT.      
T26954     ADD WS-TOTAL-COMN          TO WS-RGC-TOTAL-COMN.             
T26954     ADD WS-TOTAL-NON-COMN      TO WS-RGC-TOTAL-NON-COMN.         
T26954     ADD WS-TOTAL-REM-BAL       TO WS-RGC-TOTAL-REM-BAL.          
T26954     ADD WS-TOTAL-PMTS-RECVD    TO WS-RGC-TOTAL-PMTS-RECVD.       
T26954     ADD WS-TOT-PMTS-ELIG-COMM  TO WS-RGC-TOT-PMTS-ELIG-COMM.     
      *                                                                         
           MOVE ZEROS                  TO WS-TOTAL-PAYMENT-AMT,         
                                          WS-TOTAL-COMN,                
                                          WS-TOTAL-NON-COMN,            
                                          WS-TOTAL-REM-BAL.             
C23972     MOVE ZEROS                  TO WS-TOTAL-PMTS-RECVD,          
C23972                                    WS-TOT-PMTS-ELIG-COMM,        
C23972                                    WS-TOT-PMT-CORRECTION.        
      *                                                                         
           MOVE SPACES                 TO WS-TOT-LINE-AGENCY-NAME.      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8600-PRINT-RPT1-GRAND-TOTAL                              **          
      **       PRINTS THE GRAND TOTAL LINE OF THE REPORT            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8600-PRINT-RPT1-GRAND-TOTAL.                                     
      *                                                                         
           MOVE '8600' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T26954     IF SEB-DATABASE                                              
T26954         MOVE 'DE-REGULATED & REGULATED '                         
T26954                                 TO P-WRITE-GRD-TOT-LABEL         
T26954     END-IF.                                                      
           MOVE WS-GRD-TOTAL-PAYMENT-AMT                                
                                       TO P-WRITE-GRD-TOT-PAYMT-AMT.    
           MOVE WS-GRD-TOTAL-COMN      TO P-WRITE-GRD-TOT-COMN.         
           MOVE WS-GRD-TOTAL-NON-COMN  TO P-WRITE-GRD-TOT-NON-COMN.     
           MOVE WS-GRD-TOTAL-REM-BAL   TO P-WRITE-GRD-TOT-REM-BAL.      
C23972     MOVE WS-GRD-TOTAL-PMTS-RECVD                                 
C23972                                 TO P-WRITE-GRD-TOTAL-PMTS-RECVD. 
C23972     MOVE WS-GRD-TOT-PMTS-ELIG-COMM                               
C23972                              TO P-WRITE-GRD-TOT-PMTS-ELIG-COMM.  
      *                                                                         
           WRITE PRT33-RECORD FROM WS-GRAND-TOTAL-LINE                  
                 AFTER ADVANCING 2 LINES.                               
C23972     WRITE PRT33-RECORD FROM WS-GRAND-TOTAL-LINE-2                
C23972           AFTER ADVANCING 1 LINES.                               
C23972     WRITE PRT33-RECORD FROM WS-GRAND-TOTAL-LINE-3                
C23972           AFTER ADVANCING 1 LINES.                               
      *                                                                         
           MOVE ZEROS                  TO WS-GRD-TOTAL-PAYMENT-AMT,     
                                          WS-GRD-TOTAL-COMN,            
                                          WS-GRD-TOTAL-NON-COMN,        
                                          WS-GRD-TOTAL-REM-BAL.         
      *                                                                         
           MOVE WS-60                  TO WS-RPT1-LINE-NO.              
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
T26954*                                                                         
T26954****************************************************************          
T26954**                                                            **          
T26954**   8700-PRINT-RPT1-REGGC-TOTAL                              **          
T26954**       PRINTS THE REG-GROUP-CD TOTAL LINE OF THE REPORT     **          
T26954**                                                            **          
T26954****************************************************************          
T26954*                                                                         
T26954 8700-PRINT-RPT1-REGGC-TOTAL.                                     
T26954*                                                                         
T26954     MOVE '8700' TO WS-ACTIVE-PARAGRAPH.                          
T26954*                                                                         
T26954     MOVE WS-RGC-TOTAL-PAYMENT-AMT TO P-WRITE-TOT-PAYMENT-AMT.    
T26954     MOVE WS-RGC-TOTAL-COMN      TO P-WRITE-TOT-COMN.             
T26954     MOVE WS-RGC-TOTAL-NON-COMN  TO P-WRITE-TOT-NON-COMN.         
T26954     MOVE WS-RGC-TOTAL-REM-BAL   TO P-WRITE-TOT-REM-BAL.          
T26954     MOVE WS-RGC-TOTAL-PMTS-RECVD TO P-WRITE-TOTAL-PMTS-ONLY.     
T26954     MOVE WS-RGC-TOT-PMTS-ELIG-COMM TO P-WRITE-TOT-PMTS-ELIG-COMM.
T26954*                                                                         
T26954     IF WS-PREV-REG-GROUP-CD NOT = SPACES                         
T26954         ADD WS-RGC-TOTAL-PAYMENT-AMT TO WS-REG-TOTAL-PAYMENT-AMT 
T26954         ADD WS-RGC-TOTAL-COMN      TO WS-REG-TOTAL-COMN          
T26954         ADD WS-RGC-TOTAL-NON-COMN  TO WS-REG-TOTAL-NON-COMN      
T26954         ADD WS-RGC-TOTAL-REM-BAL   TO WS-REG-TOTAL-REM-BAL       
T26954         ADD WS-RGC-TOTAL-PMTS-RECVD TO WS-REG-TOTAL-PMTS-RECVD   
T26954         ADD WS-RGC-TOT-PMTS-ELIG-COMM TO                         
T26954                                      WS-REG-TOT-PMTS-ELIG-COMM   
T26954     END-IF.                                                      
T26954*                                                                         
T26954     MOVE SPACES TO P-WRITE-AGENCY-NAME.                          
T26954     IF WS-PREV-REG-GROUP-CD = SPACES                             
T26954         MOVE 'DE-REGULATED' TO P-WRITE-AGENCY-NAME               
T26954     ELSE                                                         
T26954         IF WS-PREV-REG-GROUP-CD = '100'                          
T26954             MOVE 'REGULATED - 100' TO P-WRITE-AGENCY-NAME        
T26954         ELSE                                                     
T26954             IF WS-PREV-REG-GROUP-CD = '200'                      
T26954                 MOVE 'REGULATED - 200' TO P-WRITE-AGENCY-NAME    
T26954             END-IF                                               
T26954         END-IF                                                   
T26954     END-IF.                                                      
T26954*                                                                         
T26954     WRITE PRT33-RECORD FROM WS-AGENCY-TOTAL-LINE                 
T26954           AFTER ADVANCING 2 LINES.                               
T26954     WRITE PRT33-RECORD FROM WS-TOTAL-LINE-2                      
T26954           AFTER ADVANCING 1 LINES.                               
T26954     WRITE PRT33-RECORD FROM WS-TOTAL-LINE-3                      
T26954           AFTER ADVANCING 1 LINES.                               
T26954*                                                                         
T26954     MOVE ZEROS                  TO WS-RGC-TOTAL-PAYMENT-AMT,     
T26954                                    WS-RGC-TOTAL-COMN,            
T26954                                    WS-RGC-TOTAL-NON-COMN,        
T26954                                    WS-RGC-TOTAL-REM-BAL,         
T26954                                    WS-RGC-TOTAL-PMTS-RECVD,      
T26954                                    WS-RGC-TOT-PMTS-ELIG-COMM.    
T26954*                                                                         
T26954     MOVE WS-60                  TO WS-RPT1-LINE-NO.              
T26954*                                                                         
T26954 8700-EXIT.                                                       
T26954     EXIT.                                                        
T26954*                                                                         
T26954****************************************************************          
T26954**                                                            **          
T26954**   8800-PRINT-RPT1-REG-TOTAL                                **          
T26954**       PRINTS THE REGULATED TOTAL LINE OF THE REPORT        **          
T26954**                                                            **          
T26954****************************************************************          
T26954*                                                                         
T26954 8800-PRINT-RPT1-REG-TOTAL.                                       
T26954*                                                                         
T26954     MOVE '8800' TO WS-ACTIVE-PARAGRAPH.                          
T26954*                                                                         
T26954     IF WS-PREV-REG-GROUP-CD NOT = SPACES                         
T26954         MOVE WS-REG-TOTAL-PAYMENT-AMT TO P-WRITE-TOT-PAYMENT-AMT 
T26954         MOVE WS-REG-TOTAL-COMN      TO P-WRITE-TOT-COMN          
T26954         MOVE WS-REG-TOTAL-NON-COMN  TO P-WRITE-TOT-NON-COMN      
T26954         MOVE WS-REG-TOTAL-REM-BAL   TO P-WRITE-TOT-REM-BAL       
T26954         MOVE WS-REG-TOTAL-PMTS-RECVD TO P-WRITE-TOTAL-PMTS-ONLY  
T26954         MOVE WS-REG-TOT-PMTS-ELIG-COMM TO                        
T26954                                     P-WRITE-TOT-PMTS-ELIG-COMM   
T26954*                                                                         
T26954         MOVE 'REGULATED TOTALS' TO P-WRITE-AGENCY-NAME           
T26954*                                                                         
T26954         WRITE PRT33-RECORD FROM WS-AGENCY-TOTAL-LINE             
T26954           AFTER ADVANCING 2 LINES                                
T26954         WRITE PRT33-RECORD FROM WS-TOTAL-LINE-2                  
T26954           AFTER ADVANCING 1 LINES                                
T26954         WRITE PRT33-RECORD FROM WS-TOTAL-LINE-3                  
T26954           AFTER ADVANCING 1 LINES                                
T26954         ADD 4 TO WS-RPT1-LINE-NO                                 
T26954*                                                                         
T26954     END-IF.                                                      
T26954*                                                                         
T26954 8800-EXIT.                                                       
T26954     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-RPT1-DETAIL                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP275        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-RPT1-DETAIL.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T15769**   8950-PRINT-LEGEND-BOX                                    **          
T15769**       PRINTS THE LEGEND BOX AT THE END OF THE REPORT       **          
T15769**                                                            **          
T15769****************************************************************          
T15769*                                                                         
T15769 8950-PRINT-LEGEND-BOX.                                           
T15769                                                                  
T15769     IF WS-RPT1-LINE-NO GREATER THAN WS-40                        
T26954         IF WS-PREV-REG-GROUP-CD NOT = SPACES                     
T26954             MOVE E-FRP275-REG-GROUP-CD TO WS-TEMP-REG-GROUP-CD   
T26954             MOVE WS-PREV-REG-GROUP-CD TO E-FRP275-REG-GROUP-CD   
T15769             PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
T26954             MOVE WS-TEMP-REG-GROUP-CD TO E-FRP275-REG-GROUP-CD   
T26954         ELSE                                                     
T15769             PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
T26954         END-IF                                                   
T15769         PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT         
T26954         IF WS-PREV-AGENCY-CODE NOT = SPACES                      
T26954             MOVE E-FRP275-COLLEC-AGENCY-CODE TO                  
T26954                                   WS-TEMP-AGENCY-CODE            
T26954             MOVE WS-PREV-AGENCY-CODE TO                          
T26954                                   E-FRP275-COLLEC-AGENCY-CODE    
T15769             PERFORM 8300-PRINT-RPT1-AGENCY-HEADER                
T15769                                           THRU 8300-EXIT         
T26954             MOVE WS-TEMP-AGENCY-CODE TO                          
T26954                                   E-FRP275-COLLEC-AGENCY-CODE    
T26954         ELSE                                                     
T15769             PERFORM 8300-PRINT-RPT1-AGENCY-HEADER                
T15769                                           THRU 8300-EXIT         
T26954         END-IF                                                   
T15769         PERFORM 8400-PRINT-RPT1-HEADERS   THRU 8400-EXIT         
T15769     END-IF.                                                      
T15769                                                                  
T15769     WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     WRITE PRT33-RECORD FROM WS-LGND-BOX-BORDER                   
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     MOVE SPACES                            TO WS-LGND-LINE-CODE  
T15769                                               WS-LGND-LINE-DESC. 
T15769     WRITE PRT33-RECORD FROM WS-LGND-BOX-LINE                     
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     WRITE PRT33-RECORD FROM WS-LGND-HDR-1                        
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     WRITE PRT33-RECORD FROM WS-LGND-HDR-2                        
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     ADD 5                                  TO WS-RPT1-LINE-NO.   
T15769                                                                  
T15769     PERFORM VARYING WS-LGND-SUB                                  
T23972             FROM 1 BY 1 UNTIL WS-LGND-SUB > 11                   
T15769           MOVE WS-LGND-CODE (WS-LGND-SUB) TO WS-LGND-LINE-CODE   
T15769           MOVE WS-LGND-DESC (WS-LGND-SUB) TO WS-LGND-LINE-DESC   
T15769           WRITE PRT33-RECORD FROM WS-LGND-BOX-LINE               
T15769              AFTER ADVANCING 1 LINE                              
T15769           ADD 1                            TO WS-RPT1-LINE-NO    
T15769     END-PERFORM.                                                 
T15769                                                                  
T15769     MOVE SPACES                            TO WS-LGND-LINE-CODE  
T15769                                               WS-LGND-LINE-DESC. 
T15769     WRITE PRT33-RECORD FROM WS-LGND-BOX-LINE                     
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     WRITE PRT33-RECORD FROM WS-LGND-BOX-BORDER                   
T15769           AFTER ADVANCING 1 LINE.                                
T15769                                                                  
T15769     ADD 2                                  TO WS-RPT1-LINE-NO.   
T15769                                                                  
T15769 8950-EXIT.                                                       
T15769     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           CLOSE FCSRP275-FILE.                                         
           IF FRP275-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSRP275 PROCESSING ERROR  **'              
               DISPLAY '**  CLOSE ERROR FOR FCSRP275 - INPUT FILE'      
               DISPLAY '**  FILE STATUS = ' WS-FRP275-STATUS            
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
