       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP260.                                        
       DATE-WRITTEN.   05/08/06.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                      SCANA                                  **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
C32832**  05/08/06   COVANSYS    CML32832 - INITIAL PROGRAM          **         
C32832**             CHENNAI                                         **         
T35024**  01/05/07   COVANSYS    FIXED TO DISPLAY THE COMPANY TOTALS **         
T35024**             CHENNAI     CORRECTLY.                          **         
      **                                                             **         
A05136**  8 DEC 15   RF10596     CHANGE PRINTER FROM 33 TO 32        **         
      **                                                             **         
      *****************************************************************         
                                                                        
           REMARKS.                                                     
               ----     REPORT GENERATOR FOR PCSRP260 REPORTS    ----   
      *****************************************************************         
      *    THIS PROGRAM TAKES IN FILE FCSCA260 WHICH IS CREATED BY    *         
      *    JOB CSRA260 AND SORTED IN TWO DIFFERENT WAYS.              *         
      *    THE TWO DIFFERENT SORTS PRODUCE THE REPORTS.               *         
      *    PCSR2601/3 IS SORTED BY COMPANY, RESPONSIBLE AREA, LOCAL   *         
      *    OFFICE, ACCOUNT STATUS, ACCOUNT NUMBER. PCSR2602/4 HAS THE *         
      *    SAME SORT MINUS RESPONSIBLE AREA.                          *         
      *    THIS PROGRAM PRODUCES THE THID PARTY REPORT                *         
      *    WHICH CONTAINS:                                            *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *    PCSR2601/3 BREAKS ON COMPANY NUMBER, RESPONSIBLE AREA AND  *         
      *    LOCAL OFFICE.                                              *         
      *    PCSR2602/4 BREAKS ON COMPANY NUMBER AND LOCAL OFFICE.      *         
      *****************************************************************         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA260.                                                           
A05136 COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA260.                                                           
       COPY FIOCA260.                                                           
      *                                                                         
A05136 COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP260'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP260 STARTS HERE'.                  
      *                                                                         
      ************** CSS_LOCAL_OFFICE B1 *******************************        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ************** CSS_COMPANY C7 ************************************        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ************** CSS_RESP_AREA C1 **********************************        
           EXEC SQL                                                             
               INCLUDE TBRSAREA                                                 
           END-EXEC.                                                            
      *                                                                         
      ************** CSS_DELINQUENCY C8 ********************************        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
               'SOUTH CAROLINA ELEC. & GAS'.                            
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(50)    VALUE               
               '                 THIRD PARTY NOTIFICATION         '.    
      *                                                                         
       01 WS-SWITCHES.                                                  
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-DATABASE             PIC 9(01)    VALUE 0.            
               88 CSR-DATABASE                      VALUE 1.            
               88 SEB-DATABASE                      VALUE 2.            
           05  WS-SEBR                 PIC X(01)    VALUE 'N'.          
               88  FIRST-SEBR                       VALUE 'Y'.          
           05  WS-ONLY-REG             PIC X(01)    VALUE 'N'.          
               88  ONLY-SEBR                        VALUE 'Y'.          
           05  WS-FRP260-REC-CNTR      PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FCSCA260-STATUS      PIC X(02).                       
               88  FCA260-SUCCESSFUL                VALUE '00'.         
A05136     05  WS-FCA32-STATUS         PIC X(02).                       
A05136         88  FCA32-SUCCESSFUL                 VALUE '00'.         
           05  WS-PREV-THD-PRTY-ID     PIC 9(10)    VALUE ZEROS.        
           05  WS-PREV-RESP-AREA-ID    PIC X(03)    VALUE SPACES.       
           05  WS-PREV-COMPANY-NO      PIC X(02)    VALUE SPACES.       
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
      *                                                                         
       01  WS-RESP-AREA-TOTAL.                                          
           05  WS-RA-OPT-COUNT        PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-RA-CHG-COUNT        PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-RA-INACT-COUNT      PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-RA-ANNIV-COUNT      PIC  9(06)    VALUE ZEROS COMP-3. 
      *                                                                         
       01  WS-COMPANY-TOTAL.                                            
           05  WS-CO-OPT-COUNT        PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-CO-CHG-COUNT        PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-CO-INACT-COUNT      PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-CO-ANNIV-COUNT      PIC  9(06)    VALUE ZEROS COMP-3. 
      *                                                                         
       01  WS-ACCOUNT-TOTAL.                                            
           05  WS-TP-ACCT-COUNT       PIC  9(06)    VALUE ZEROS COMP-3. 
           05  WS-TP-ACT-COUNT        PIC  9(06)    VALUE ZEROS COMP-3. 
      *                                                                         
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
       COPY CWS00011.                                                           
      *                                                                         
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
      *                                                                         
      * DB2 AND CICS ERROR PROCESSING.                                          
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
       01  WS-LINE-COUNT               PIC 9(02)    VALUE 0   COMP-3.   
       01  WS-RPT1-PAGE-NO             PIC 9(06)    VALUE 0   COMP-3.   
      ****************************************************************          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CCYY                 PIC 9(04).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
           05  WS-CHH                  PIC 9(02).                       
           05  WS-CMM                  PIC 9(02).                       
           05  WS-CSS                  PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(04).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-RPT-MTH-CCYY.                                             
           05  WS-RPT-MONTH            PIC X(10).                       
           05  WS-RPT-CCYY             PIC X(04).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-CC                PIC X(02).                       
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP260'.   
           05  WS-0                    PIC 9(01)    VALUE ZERO.         
           05  WS-1                    PIC 9(01)    VALUE 1.            
           05  WS-2                    PIC 9(01)    VALUE 2.            
           05  WS-3                    PIC 9(01)    VALUE 3.            
           05  WS-4                    PIC 9(01)    VALUE 4.            
           05  WS-52                   PIC 9(02)    VALUE 52.           
           05  WS-42                   PIC 9(02)    VALUE 42.           
           05  WS-59                   PIC 9(02)    VALUE 59.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
                                                                        
      *                                                                 00940000
      ***************** PCSRP260 REPORT HEADERS **********************          
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE1        PIC X(10).                       
               10  FILLER              PIC X(40)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(30)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER1          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  P-RPT1-TITLE-PGNM   PIC X(08)    VALUE 'PCSRP260'.   
               10  FILLER              PIC X(01)    VALUE '-'.          
               10  P-RPT1-TITLE-FORM   PIC X(08)    VALUE 'PCSR2601'.   
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER2          **          
      ****************************************************************          
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(59)    VALUE SPACES.       
               10  P-RPT1-MONTH-CCYY   PIC X(14).                       
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **      COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS      **          
      ****************************************************************          
           05  WS-RPT1-HEADER-31A.                                      
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(19)    VALUE               
                                               'RESPONSIBLE AREA:  '.   
               10  P-RPT1-RESP-AREA-NM PIC X(30).                       
               10  FILLER              PIC X(83)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(16)    VALUE               
                                                    'ACCOUNT NO.    '.  
               10  FILLER              PIC X(14)    VALUE               
                                                    'CUSTOMER NAME '.   
               10  FILLER              PIC X(39)    VALUE SPACES.       
               10  FILLER              PIC X(17)    VALUE               
                                                    'THIRD PARTY NAME '.
               10  FILLER              PIC X(21)    VALUE SPACES.       
               10  FILLER              PIC X(13)    VALUE               
                                                    'LETTER TYPE '.     
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'TP ACTIVITY'.
                                                                        
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                    'ADDRESS       '.   
               10  FILLER              PIC X(39)    VALUE SPACES.       
               10  FILLER              PIC X(17)    VALUE               
                                                    'ADDRESS          '.
               10  FILLER              PIC X(21)    VALUE SPACES.       
               10  FILLER              PIC X(13)    VALUE               
                                                    'LETTER STATUS'.    
               10  FILLER              PIC X(12)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **        COMMON WORKING STORAGE FOR REPORT DETAIL LINES      **          
      ****************************************************************          
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  P-ACCOUNT-NO        PIC 9(13).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-CUST-NAME         PIC X(50).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-TP-NAME           PIC X(35).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-LETTER-TYPE       PIC X(12).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-TP-ACT-DATE       PIC X(11).                       
      *                                                                         
           05  WS-DETAIL-LINE-2.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  P-CUST-ADDR1        PIC X(35).                       
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  P-TP-ADDR1          PIC X(35).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-LTR-STATUS        PIC X(12).                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-3.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  P-CUST-ADDR2        PIC X(35).                       
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  P-TP-ADDR2          PIC X(35).                       
               10  FILLER              PIC X(28)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **        COMMON WORKING STORAGE FOR REPORT TOTAL LINES       **          
      ****************************************************************          
       01  WS-TOTAL-LINES.                                              
      * FOR RESPONSIBLE AREA TOTALS                                             
           05  WS-TOTAL-LINE-1R1.                                       
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER                PIC X(12)    VALUE             
                                                      'RESPONSIBLE '.   
               10  FILLER                PIC X(120)   VALUE SPACES.     
      *                                                                         
           05  WS-TOTAL-LINE-1R.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER                PIC X(12)    VALUE             
                                                      'AREA TOTAL  '.   
               10  FILLER                PIC X(38)    VALUE SPACES.     
               10  FILLER                PIC X(12)    VALUE             
                                                      'ADD/OPT OUT '.   
               10  P-ADD-OPT-TOT         PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(07)    VALUE             
                                                      'CHANGE '.        
               10  P-CHANGE-TOT          PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(09)    VALUE             
                                                      'INACTIVE '.      
               10  P-INACTIVE-TOT        PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(12)    VALUE             
                                                      'ANNIVERSARY '.   
               10  P-ANNIV-TOT           PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(06)    VALUE SPACES.     
      * FOR COMPANY TOTALS                                                      
           05  WS-TOTAL-LINE-1C.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER                PIC X(14)    VALUE             
                                                      'COMPANY TOTAL '. 
               10  FILLER                PIC X(36)    VALUE SPACES.     
               10  FILLER                PIC X(12)    VALUE             
                                                      'ADD/OPT OUT '.   
               10  P-ADD-OPT-TOT-C       PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(07)    VALUE             
                                                      'CHANGE '.        
               10  P-CHANGE-TOT-C        PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(09)    VALUE             
                                                      'INACTIVE '.      
               10  P-INACTIVE-TOT-C      PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(04)    VALUE SPACES.     
               10  FILLER                PIC X(12)    VALUE             
                                                      'ANNIVERSARY '.   
               10  P-ANNIV-TOT-C         PIC ZZZ,ZZ9.                   
               10  FILLER                PIC X(06)    VALUE SPACES.     
      * TOTAL THIRD PARTY ACCOUNTS                                              
           05  WS-TOTAL-LINE-1F1.                                       
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER                PIC X(12)    VALUE             
                                                      'TOTAL THIRD '.   
               10  FILLER                PIC X(43)    VALUE SPACES.     
               10  FILLER                PIC X(12)    VALUE             
                                                      'TOTAL ACTIVE'.   
               10  FILLER                PIC X(65)    VALUE SPACES.     
      *                                                                         
           05  WS-TOTAL-LINE-1F.                                        
               10  FILLER              PIC X        VALUE ' '.          
               10  FILLER                PIC X(14)    VALUE             
                                                      'PARTY ACCOUNTS'. 
               10  FILLER                PIC X(04)    VALUE SPACES.     
T35024         10  P-TOT-TP-ACCT         PIC ZZZ,ZZZ,ZZ9.               
T35024         10  FILLER                PIC X(27)    VALUE SPACES.     
               10  FILLER                PIC X(13)    VALUE             
                                                      'THIRD PARTIES'.  
               10  FILLER                PIC X(04)    VALUE SPACES.     
T35024         10  P-TOT-TP-ACT-ACCT     PIC ZZZ,ZZZ,ZZ9.               
T35024         10  FILLER                PIC X(52)    VALUE SPACES.     
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-PRT33-RECORD             PIC X(133)   VALUE SPACES.       
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP260 ENDS HERE'.                    
      *                                                                         
       LINKAGE SECTION.                                                 
        01  WS-PARM-VALUE.                                              
            05  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.      
            05  WS-PARMVAL-DATA.                                        
                10  WS-PARMVAL-COMPANY            PIC X(02).            
                10  WS-PARMVAL-REGION             PIC X(03).            
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
      *                                                                         
           IF E-FCA260-SORT-AREA2 = HIGH-VALUES AND                     
              E-FCA260-RECORD-COUNT = 1                                 
               PERFORM 0200-MAINLINE-STOP THRU 0200-EXIT                
           ELSE                                                         
               PERFORM 0300-MAINLINE-CONT THRU 0300-EXIT                
           END-IF.                                                      
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-END-DATA-LINE           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE                            WS-RESP-AREA-TOTAL,    
                                                 WS-COMPANY-TOTAL,      
                                                 WS-ACCOUNT-TOTAL.      
      *                                                                         
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                              TO WS-CURRENT-DATE.       
           MOVE WS-CHH                        TO WS-RT-HH.              
           MOVE WS-CMM                        TO WS-RT-MM.              
           MOVE WS-CSS                        TO WS-RT-SS.              
           MOVE WS-RUN-TIME                   TO P-RPT1-RUN-TIME.       
      *                                                                         
           MOVE WS-CCYY                       TO WS-RD-YY               
                                                 WS-RPT-CCYY.           
           MOVE WS-CM                         TO WS-RD-MM.              
           MOVE WS-CD                         TO WS-RD-DD.              
           MOVE WS-RUN-DATE                   TO P-RPT1-RUN-DATE.       
      *                                                                         
A05136     OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
      *                                                                         
           OPEN INPUT FCSCA260-FILE.                                    
           IF FCA260-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    FCSCA260 PROCESSING ERROR    **'          
               DISPLAY '**    OPEN ERROR OF FCSCA260 - INPUT FILE'      
               DISPLAY '**      FILE STATUS = ' WS-FCSCA260-STATUS      
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSCA260         THRU 7100-EXIT.           
      *                                                                         
           IF E-FCA260-SORT-AREA = LOW-VALUES                           
               MOVE E-FCA260-RUN-DATE         TO WS-DATE-10             
               MOVE WS-D10-CC                 TO WS-D8-CC               
               MOVE WS-D10-YY                 TO WS-D8-YY               
               MOVE WS-D10-MM                 TO WS-D8-MM               
               MOVE WS-D10-DD                 TO WS-D8-DD               
               MOVE WS-DATE-8                 TO P-RPT1-DATE1           
               PERFORM 0400-MONTH-DESC        THRU 0400-EXIT            
           ELSE                                                         
               DISPLAY '**    FCSCA260 PROCESSING ERROR    **'          
               DISPLAY '**    ERROR OF FCSCA260 - INPUT FILE'           
               DISPLAY '**    BEGIN RECORD DOES NOT EXIST '             
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE WS-RPT-MTH-CCYY           TO WS-EMB-INPUT.              
           MOVE 14                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE WS-CMP-TABLE              TO P-RPT1-MONTH-CCYY.         
      *                                                                         
           MOVE '01'                          TO C8-COMPANY-NO.         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           PERFORM 7900-GET-REGION            THRU 7900-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-DATABASE.           
      *                                                                         
           PERFORM 7100-READ-FCSCA260         THRU 7100-EXIT.           
           IF WS-PARMVAL-LENGTH > 0                                     
               CONTINUE                                                 
           ELSE                                                         
               MOVE E-FCA260-COMPANY-NO       TO WS-PARMVAL-COMPANY     
           END-IF.                                                      
      *                                                                         
           IF E-FCA260-SORT-AREA2 = HIGH-VALUES                         
               MOVE WS-N                      TO WS-MORE-DATA-SW        
               MOVE 1                         TO E-FCA260-RECORD-COUNT  
               MOVE '01'                      TO WS-PARMVAL-COMPANY     
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0200-MAINLINE-STOP.                                      **          
      **           STOP THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0200-MAINLINE-STOP.                                              
      *                                                                         
           MOVE WS-PARMVAL-COMPANY            TO C7-COMPANY-NO.         
           PERFORM 8100-PRINT-RPT1-COMP-NAME  THRU 8100-EXIT.           
           PERFORM 8200-PRINT-RPT1-TITLE      THRU 8200-EXIT.           
           PERFORM 8300-PRINT-RPT1-HEADERS    THRU 8300-EXIT.           
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-NO-DATA-LINE            TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0300-MAINLINE-CONT                                       **          
      **       CONTINUE THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0300-MAINLINE-CONT.                                              
      *                                                                         
           MOVE E-FCA260-RESP-AREA-ID         TO WS-PREV-RESP-AREA-ID,  
                                                 C1-RESP-AREA-ID.       
           MOVE E-FCA260-COMPANY-NO           TO WS-PREV-COMPANY-NO,    
                                                 B1-COMPANY-NO,         
                                                 C7-COMPANY-NO.         
      *                                                                         
           PERFORM 8100-PRINT-RPT1-COMP-NAME  THRU 8100-EXIT.           
           PERFORM 8200-PRINT-RPT1-TITLE      THRU 8200-EXIT.           
           PERFORM 8300-PRINT-RPT1-HEADERS    THRU 8300-EXIT.           
      *                                                                         
           PERFORM 1000-PRODUCE-REPORTS       THRU 1000-EXIT            
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           PERFORM 2500-FORMAT-RESP-AREA-TOTAL                          
                                              THRU 2500-EXIT.           
           PERFORM 8410-PRINT-TOTAL-LINE      THRU 8410-EXIT.           
      *                                                                         
           PERFORM 8100-PRINT-RPT1-COMP-NAME  THRU 8100-EXIT.           
           PERFORM 8200-PRINT-RPT1-TITLE      THRU 8200-EXIT.           
           PERFORM 8300-PRINT-RPT1-HEADERS    THRU 8300-EXIT.           
           PERFORM 2600-FORMAT-COMPANY-TOTAL  THRU 2600-EXIT.           
           PERFORM 8420-PRINT-TOTAL-LINE      THRU 8420-EXIT.           
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      ** 0400-MONTH-DESC.                                        **             
      **TO DISPLAY THE MONTH FOR WHICH REPORT IS GENERATED       **             
      **                                                         **             
      *************************************************************             
                                                                        
       0400-MONTH-DESC.                                                 
                                                                        
           EVALUATE WS-D10-MM                                           
             WHEN '01'                                                  
               MOVE 'JANUARY  '                TO WS-RPT-MONTH          
             WHEN '02'                                                  
               MOVE 'FEBRUARY '                TO WS-RPT-MONTH          
             WHEN '03'                                                  
               MOVE 'MARCH    '                TO WS-RPT-MONTH          
             WHEN '04'                                                  
               MOVE 'APRIL    '                TO WS-RPT-MONTH          
             WHEN '05'                                                  
               MOVE 'MAY      '                TO WS-RPT-MONTH          
             WHEN '06'                                                  
               MOVE 'JUNE     '                TO WS-RPT-MONTH          
             WHEN '07'                                                  
               MOVE 'JULY     '                TO WS-RPT-MONTH          
             WHEN '08'                                                  
               MOVE 'AUGUST   '                TO WS-RPT-MONTH          
             WHEN '09'                                                  
               MOVE 'SEPTEMBER'                TO WS-RPT-MONTH          
             WHEN '10'                                                  
               MOVE 'OCTOBER  '                TO WS-RPT-MONTH          
             WHEN '11'                                                  
               MOVE 'NOVEMBER '                TO WS-RPT-MONTH          
             WHEN '12'                                                  
               MOVE 'DECEMBER '                TO WS-RPT-MONTH          
           END-EVALUATE.                                                
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   1000-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
       1000-PRODUCE-REPORTS.                                            
      *                                                                         
           IF E-FCA260-SORT-AREA2 = HIGH-VALUES                         
               MOVE WS-N TO WS-MORE-DATA-SW                             
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF E-FCA260-COMPANY-NO NOT EQUAL WS-PARMVAL-COMPANY          
               PERFORM 7100-READ-FCSCA260 THRU 7100-EXIT                
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF E-FCA260-RESP-AREA-ID NOT EQUAL WS-PREV-RESP-AREA-ID      
               IF WS-LINE-COUNT GREATER THAN WS-52                      
                   PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
                   PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT     
                   PERFORM 8300-PRINT-RPT1-HEADERS   THRU 8300-EXIT     
               END-IF                                                   
               PERFORM 2500-FORMAT-RESP-AREA-TOTAL THRU 2500-EXIT       
               PERFORM 8410-PRINT-TOTAL-LINE       THRU 8410-EXIT       
               MOVE E-FCA260-RESP-AREA-ID TO WS-PREV-RESP-AREA-ID,      
                                             C1-RESP-AREA-ID            
               MOVE WS-62 TO WS-LINE-COUNT                              
           END-IF.                                                      
      *                                                                         
           MOVE E-FCA260-COMPANY-NO        TO WS-PREV-COMPANY-NO.       
           MOVE E-FCA260-RESP-AREA-ID      TO WS-PREV-RESP-AREA-ID.     
      *                                                                         
           PERFORM 2000-PRODUCE-RPT1  THRU 2000-EXIT.                   
      *                                                                         
           PERFORM 7100-READ-FCSCA260 THRU 7100-EXIT.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2000-PRODUCE-RPT1                                        **          
      **       CONTROLS THE DETAILS LINES, CHECKING FOR PAGE BREAKS.**          
      **                                                            **          
      ****************************************************************          
       2000-PRODUCE-RPT1.                                               
      *                                                                         
           IF WS-LINE-COUNT >= WS-59                                    
               PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT         
               PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT         
               PERFORM 8300-PRINT-RPT1-HEADERS   THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                         
           IF P-ACCOUNT-NO NOT EQUAL E-FCA260-ACCOUNT-NO                
              ADD WS-1                           TO WS-TP-ACCT-COUNT    
           END-IF.                                                      
      *                                                                         
           IF E-FCA260-THD-PRTY-STATUS = 'A' AND                        
              E-FCA260-THD-PRTY-ID NOT EQUAL WS-PREV-THD-PRTY-ID        
              ADD WS-1                           TO WS-TP-ACT-COUNT     
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-FORMAT-DETAIL-LINE       THRU 2200-EXIT.        
           PERFORM 8900-PRINT-DETAIL-LINE        THRU 8900-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS AND LOADS THE DETAIL LINE OF THE REPORT.     **          
      **                                                            **          
      ****************************************************************          
       2200-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           INITIALIZE                        P-ACCOUNT-NO               
                                             P-CUST-NAME                
                                             P-TP-NAME                  
                                             P-LETTER-TYPE              
                                             P-TP-ACT-DATE              
                                             P-CUST-ADDR1               
                                             P-TP-ADDR1                 
                                             P-LTR-STATUS               
                                             P-CUST-ADDR2               
                                             P-TP-ADDR2.                
      *                                                                 11370740
           MOVE E-FCA260-ACCOUNT-NO       TO P-ACCOUNT-NO.              
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE E-FCA260-CUST-NAME        TO WS-EMB-INPUT.              
           MOVE 50                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE WS-CMP-TABLE              TO P-CUST-NAME.               
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE E-FCA260-CC-ADDR-STREET   TO WS-EMB-INPUT.              
           MOVE 35                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE WS-CMP-TABLE              TO P-CUST-ADDR1.              
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE E-FCA260-TP-NAME          TO WS-EMB-INPUT.              
           MOVE 35                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE WS-CMP-TABLE              TO P-TP-NAME.                 
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE E-FCA260-TP-ADDR-STREET   TO WS-EMB-INPUT.              
           MOVE 35                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE WS-CMP-TABLE              TO P-TP-ADDR1.                
      *                                                                 11370740
           STRING                            E-FCA260-CC-CITY-STATE     
                                             ' '                        
                                             E-FCA260-CC-ZIP(1:5)       
                                             '-'                        
                                             E-FCA260-CC-ZIP(6:4)       
                                             DELIMITED BY SIZE INTO     
                                             P-CUST-ADDR2.              
           IF E-FCA260-CC-ZIP(6:4) = SPACES                             
              INITIALIZE                     P-CUST-ADDR2               
              STRING                         E-FCA260-CC-CITY-STATE     
                                             ' '                        
                                             E-FCA260-CC-ZIP(1:5)       
                                             DELIMITED BY SIZE INTO     
                                             P-CUST-ADDR2               
           END-IF.                                                      
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE P-CUST-ADDR2              TO WS-EMB-INPUT.              
           MOVE 29                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE SPACES                    TO P-CUST-ADDR2.              
           MOVE WS-CMP-TABLE              TO P-CUST-ADDR2.              
      *                                                                 11370740
           STRING                            E-FCA260-TP-CITY-STATE     
                                             ' '                        
                                             E-FCA260-TP-ZIP(1:5)       
                                             '-'                        
                                             E-FCA260-TP-ZIP(6:4)       
                                             DELIMITED BY SIZE INTO     
                                             P-TP-ADDR2.                
           IF E-FCA260-CC-ZIP(6:4) = SPACES                             
              INITIALIZE                     P-TP-ADDR2                 
              STRING                         E-FCA260-TP-CITY-STATE     
                                             ' '                        
                                             E-FCA260-TP-ZIP(1:5)       
                                             DELIMITED BY SIZE INTO     
                                             P-TP-ADDR2                 
           END-IF.                                                      
      *                                                                 11370740
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           MOVE P-TP-ADDR2                TO WS-EMB-INPUT.              
           MOVE 29                        TO WS-EMB-LENG.               
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                          THRU 6011-EXIT.               
           MOVE SPACES                    TO P-TP-ADDR2.                
           MOVE WS-CMP-TABLE              TO P-TP-ADDR2.                
      *                                                                 11370740
           MOVE E-FCA260-TP-ACT-DT        TO WS-DATE-10.                
           MOVE WS-D10-CC                 TO WS-D8-CC.                  
           MOVE WS-D10-YY                 TO WS-D8-YY.                  
           MOVE WS-D10-MM                 TO WS-D8-MM.                  
           MOVE WS-D10-DD                 TO WS-D8-DD.                  
           MOVE WS-DATE-8                 TO P-TP-ACT-DATE.             
           IF E-FCA260-TP-ACT-DT = SPACES                               
              MOVE SPACES                 TO P-TP-ACT-DATE              
           END-IF.                                                      
      *                                                                         
           EVALUATE E-FCA260-TP-LETTER-TYPE                             
             WHEN 'A'                                                   
               MOVE 'ADD/OPT OUT '             TO P-LETTER-TYPE         
               ADD WS-1                        TO WS-RA-OPT-COUNT       
                                                  WS-CO-OPT-COUNT       
             WHEN 'C'                                                   
               MOVE 'CHANGE '                  TO P-LETTER-TYPE         
               ADD WS-1                        TO WS-RA-CHG-COUNT       
                                                  WS-CO-CHG-COUNT       
             WHEN 'I'                                                   
               MOVE 'INACTIVE '                TO P-LETTER-TYPE         
               ADD WS-1                        TO WS-RA-INACT-COUNT     
                                                  WS-CO-INACT-COUNT     
             WHEN 'V'                                                   
               MOVE 'ANNIVERSARY '             TO P-LETTER-TYPE         
               ADD WS-1                        TO WS-RA-ANNIV-COUNT     
                                                  WS-CO-ANNIV-COUNT     
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE E-FCA260-TP-LETTER-ST                               
             WHEN 'M'                                                   
               MOVE 'MAILED '                  TO P-LTR-STATUS          
                                                                        
             WHEN 'P'                                                   
               MOVE 'PENDING'                  TO P-LTR-STATUS          
                                                                        
             WHEN 'N'                                                   
               MOVE 'NO LETTER'                TO P-LTR-STATUS          
           END-EVALUATE.                                                
      *                                                                 11370740
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    2500-FORMAT-RESP-AREA-TOTAL                             **          
      **         TOTAL LINE VALUE WILL BE MOVED FOR RESPONSIBLE AREA**          
      ****************************************************************          
       2500-FORMAT-RESP-AREA-TOTAL.                                     
      *                                                                         
           MOVE WS-RA-OPT-COUNT        TO P-ADD-OPT-TOT.                
           MOVE WS-RA-CHG-COUNT        TO P-CHANGE-TOT.                 
           MOVE WS-RA-INACT-COUNT      TO P-INACTIVE-TOT.               
           MOVE WS-RA-ANNIV-COUNT      TO P-ANNIV-TOT.                  
      *                                                                         
           INITIALIZE                     WS-RESP-AREA-TOTAL.           
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    2600-FORMAT-COMPANY-TOTAL                               **          
      **         TOTAL LINE VALUE WILL BE MOVED FOR COMPANY         **          
      **                                                            **          
      ****************************************************************          
       2600-FORMAT-COMPANY-TOTAL.                                       
      *                                                                         
           MOVE WS-CO-OPT-COUNT        TO P-ADD-OPT-TOT-C.              
           MOVE WS-CO-CHG-COUNT        TO P-CHANGE-TOT-C.               
           MOVE WS-CO-INACT-COUNT      TO P-INACTIVE-TOT-C.             
           MOVE WS-CO-ANNIV-COUNT      TO P-ANNIV-TOT-C.                
      *                                                                         
T35024     EVALUATE WS-PARMVAL-REGION                                   
T35024        WHEN 'CSR'                                                
T35024        MOVE E-FCA260-THD-PRTY-CNT-01 TO P-TOT-TP-ACT-ACCT        
T35024        MOVE E-FCA260-ACT-ACCT-CNT-01 TO P-TOT-TP-ACCT            
T35024        WHEN 'PNC'                                                
T35024        MOVE E-FCA260-THD-PRTY-CNT-02 TO P-TOT-TP-ACT-ACCT        
T35024        MOVE E-FCA260-ACT-ACCT-CNT-02 TO P-TOT-TP-ACCT            
T35024        WHEN 'SBR'                                                
T35024        MOVE E-FCA260-THD-PRTY-CNT-01 TO P-TOT-TP-ACT-ACCT        
T35024        MOVE E-FCA260-ACT-ACCT-CNT-01 TO P-TOT-TP-ACCT            
T35024        WHEN 'SEB'                                                
T35024        MOVE E-FCA260-THD-PRTY-CNT-02 TO P-TOT-TP-ACT-ACCT        
T35024        MOVE E-FCA260-ACT-ACCT-CNT-02 TO P-TOT-TP-ACCT            
T35024     END-EVALUATE.                                                
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    6010-REDUCE-EMBEDDED-SPACES                                **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSCA260                                       **          
      **       READS THE INPUT FILE FCSCA260-FILE                   **          
      **                                                            **          
      ****************************************************************          
       7100-READ-FCSCA260.                                              
      *                                                                         
           READ FCSCA260-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO TO 7100-EXIT.                                     
      *                                                                         
           IF FCA260-SUCCESSFUL                                         
               ADD 1                   TO WS-FRP260-REC-CNTR            
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSCA260 READ.  STATUS IS '       
                        WS-FCSCA260-STATUS                              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7600-GET-RESP-AREA                                       **          
      **      READS THE RESP AREA NAME WITH THE GIVEN CODE          **          
      **                                                            **          
      ****************************************************************          
       7600-GET-RESP-AREA.                                              
      *                                                                         
           MOVE '7600' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    RESP_AREA_DESC                                 
                INTO :C1-RESP-AREA-DESC                                 
               FROM  CSS_RESP_AREA                                      
                WHERE    RESP_AREA_ID   = :C1-RESP-AREA-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C1-RESP-AREA-DESC                                   
                                       TO P-RPT1-RESP-AREA-NM           
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE 'NO RESP AREA DESCRIPTION FOUND'                
                                          TO P-RPT1-RESP-AREA-NM        
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7600-GET-RESP-AREA ****'  
                   DISPLAY '* RETURN CODE = ' SQLCODE                   
                   DISPLAY '*        PROCESSING TERMINATED          *'  
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
               FROM  CSS_COMPANY                                        
                WHERE    COMPANY_NO = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE WS-DEFAULT-RPT1-COMPANY TO P-RPT1-COMP-NAME     
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7800-GET-COMPANY-DESC *'  
                   DISPLAY '* RETURN CODE = ' SQLCODE                   
                   DISPLAY '*        PROCESSING TERMINATED          *'  
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-PARMVAL-REGION = 'SBR'                                 
              INITIALIZE                           P-RPT1-COMP-NAME     
              MOVE   'SCANA ENERGY - REGULATED' TO P-RPT1-COMP-NAME     
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7900-GET-REGION                                          **          
      **      FINDS IF CSR OR SEB REGION                            **          
      **                                                            **          
      ****************************************************************          
       7900-GET-REGION.                                                 
      *                                                                         
           MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO  :C8-DELINQ-VALUE                                  
                FROM  CSS_DELINQUENCY                                   
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
                 AND  COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7900-GET-REGION       *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*        PROCESSING TERMINATED          *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    8100-PRINT-RPT1-COMP-NAME                               **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
       8100-PRINT-RPT1-COMP-NAME.                                       
      *                                                                         
           ADD 1            TO WS-RPT1-PAGE-NO.                         
      *                                                                         
           PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT.                
           MOVE WS-RPT1-TITLE              TO WS-PRT33-RECORD.          
           PERFORM 8920-PRINT-REPORT-TITLE THRU 8920-EXIT.              
           MOVE WS-1                       TO WS-LINE-COUNT.            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-RPT1-TITLE                                    **          
      **       PRINTS THE TITLES  FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
       8200-PRINT-RPT1-TITLE.                                           
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1     TO P-RPT1-HEAD1.             
           MOVE WS-RPT1-HEADER-1           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-RPT1-PAGE-NO            TO P-RPT1-PAGE-NO.           
           MOVE WS-RPT1-HEADER-2           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-RPT1-HEADERS                                  **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
       8300-PRINT-RPT1-HEADERS.                                         
      *                                                                         
           PERFORM 7600-GET-RESP-AREA      THRU 7600-EXIT.              
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-RPT1-HEADER-31A         TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-RPT1-HEADER-32          TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-RPT1-HEADER-33          TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8410-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE TOTAL LINES FOR THE RESPONSIBLE AREA      **          
      **                                                            **          
      ****************************************************************          
       8410-PRINT-TOTAL-LINE.                                           
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-TOTAL-LINE-1R1          TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-TOTAL-LINE-1R           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8420-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE TOTAL LINES FOR THE COMPANY               **          
      **                                                            **          
      ****************************************************************          
       8420-PRINT-TOTAL-LINE.                                           
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-TOTAL-LINE-1C           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-TOTAL-LINE-1F1          TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-TOTAL-LINE-1F           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           MOVE WS-DETAIL-LINE-1           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-DETAIL-LINE-2           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-DETAIL-LINE-3           TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
      *                                                                         
           MOVE WS-BLANK-LINE              TO WS-PRT33-RECORD.          
           PERFORM 8910-WRITE-REPORT-DATA  THRU 8910-EXIT.              
           ADD WS-1                        TO WS-LINE-COUNT.            
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8910-WRITE-REPORT-DATA                                   **          
      **      PRINTS THE DATA TO THE REPORT                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8910-WRITE-REPORT-DATA.                                          
      *                                                                         
A05136     MOVE WS-PRT33-RECORD         TO PRT33-RECORD.                
A05136     WRITE PRT33-RECORD.                                          
           MOVE SPACES                  TO WS-PRT33-RECORD.             
      *                                                                         
       8910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8920-PRINT-REPORT-TITLE                                  **          
      **      PRINTS THE TITLE OF THE REPORT                        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8920-PRINT-REPORT-TITLE.                                         
      *                                                                         
A05136     WRITE PRT33-RECORD           FROM WS-PRT33-RECORD            
                                        AFTER ADVANCING PAGE.           
           MOVE SPACES                  TO WS-PRT33-RECORD.             
      *                                                                         
       8920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA260-FILE.                                         
           IF FCA260-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSRP260 PROCESSING ERROR  **'              
               DISPLAY '**  CLOSE ERROR FOR FCSCA260 - INPUT FILE'      
               DISPLAY '**  FILE STATUS = ' WS-FCSCA260-STATUS          
           END-IF.                                                      
      *                                                                         
A05136     CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
