       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSRP233.                                         
       DATE-WRITTEN.  JUL 2002.                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00060000
      **                   BASS & ASSOCIATES, INC.                   ** 00070000
      **                     2027 DODGE STREET                       ** 00080000
      **                   OMAHA, NEBRASKA 68102                     ** 00090000
      **                      (800) 588-1505                         ** 00100000
      **                                                             **         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 07/10/02   R. SPIRES      DEVELOPMENT OF NEW REPORT PROGRAM **         
      ** 08/09/02   R. SPIRES      CORRECT NO DATA LOGIC             **         
      ** 02/04/03   R. SPIRES      ADD TOTALS FOR OV/SH GL'S         **         
      ** 02/05/03   R. SPIRES      CORRECT ABEND LOGIC IN TERMINATE  **         
      **                           ROUTINE FROM ABENDING AGAIN.      **         
T30257** 02/26/04   SK88120        CHANGES WERE MADE TO INCLUDE BMX  **         
      **                           GL ACCOUNT 143.6000 IN TOTALS.    **         
      *                            (ACTIVITY #7)                      *         
T31289** 04/28/05   SK88120        CHANGES WERE MADE TO INCLUDE APS  ** *       
      **                           GL ACCOUNT 143.8000               **         
      **                                      253.0900 IN TOTALS.    **         
      *                            (ACTIVITY #7)                      *         
      *****************************************************************         
      *                   PCSRP233   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM READS CSS_OVERSHORT_HDR TABLE TO DETERMINE WHICH *         
      * PROBLEM OVERAGE OR SHORTAGE ARE NOT RESOLVED. IF THIS IS A    *         
      * PROBLEM OV/SH, THE CSS_OVERSHORT_DET TABLE IS READ TO LINK    *         
      * DISPLAY WHICH PORTIONS OF THE PROBLEM ARE CORRECTED,          *         
      *                                                               *         
      *****************************************************************         
             REMARKS.                                                   
      *****************************************************************         
      *        THIS IS A NEW PROGRAM WRITTEN FOR LISTING ALL          *         
      *        PROBLEM OVERAGES AND SHORTAGES WITH THE SOLUTIONS.     *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0099     MAIN CONTROL PATH                   
                    0100 - 0999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP233'.
MSQ017     COPY MFASQLM.
       01  WS-START                          PIC X(40)  VALUE           
           'WORKING STORAGE FOR PCSRP233 STARTS HERE'.                  
                                                                        
       01  WS-PYMT-FIELDS.                                              
           05  WS-CASH-GL-NUM                PIC X(01)  VALUE 'N'.      
               88 CASH-GL-ACCT                          VALUE 'Y'.      
               88 NOT-CASH-GL                           VALUE 'N'.      
           05  WS-GL-ACCT-FLAG               PIC X(01)  VALUE 'N'.      
           05  WS-GL-ACCOUNT                 PIC 9(3)V9(4).             
           05  FILLER REDEFINES WS-GL-ACCOUNT.                          
               10 WS-GL-ACCT-MAJOR           PIC X(03).                 
               10 WS-GL-ACCT-MINOR           PIC X(04).                 
                                                                        
       01  WS-TOT-OVSH-AMT                   PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-AMT                   PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530100               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530100               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530200               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530200               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530300               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530300               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530400               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530400               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530500               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530500               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530600               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530600               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530700               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530700               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-2530800               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-2530800               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
T31289 01  WS-TOT-OVSH-2530900               PIC S9(11)V99 COMP-3       
T31289                                                  VALUE ZEROS.    
T31289 01  WS-TOT-OFST-2530900               PIC S9(11)V99 COMP-3       
T31289                                                  VALUE ZEROS.    
       01  WS-TOT-OVSH-1432000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-1432000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-1433000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-1433000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-1434000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-1434000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OVSH-1846000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
       01  WS-TOT-OFST-1846000               PIC S9(11)V99 COMP-3       
                                                        VALUE ZEROS.    
T30257 01  WS-TOT-OVSH-1436000               PIC S9(11)V99 COMP-3       
T30257                                                  VALUE ZEROS.    
T30257 01  WS-TOT-OFST-1436000               PIC S9(11)V99 COMP-3       
T30257                                                  VALUE ZEROS.    
T31289 01  WS-TOT-OVSH-1438000               PIC S9(11)V99 COMP-3       
T31289                                                  VALUE ZEROS.    
T31289 01  WS-TOT-OFST-1438000               PIC S9(11)V99 COMP-3       
T31289                                                  VALUE ZEROS.    
       01  WS-CUST-COUNT.                                               
           05  WS-IBS-CUSTOMER-COUNT         PIC S9(07)    COMP.        
           05  WS-RES-CUSTOMER-COUNT         PIC S9(07)    COMP.        
           05  WS-TOTAL-CUSTOMER-COUNT       PIC S9(07)    COMP.        
                                                                        
       01  WS-MISC.                                                     
           05  WS-SYSIN-COMP-NO              PIC X(02)  VALUE SPACES.   
           05  WS-DISP-RC                    PIC -ZZZZZZZZ9.9.          
           05  WS-MAX-LINES                  PIC 9(02)  VALUE 56.       
           05  WS-LINE-COUNT                 PIC 9(02)  VALUE 57.       
           05  WS-TEMP-COUNT                 PIC 9(02).                 
           05  WS-PAGE-COUNT                 PIC 9(05)  VALUE 0.        
           05  WS-ERR-MSG                    PIC X(60)  VALUE SPACES.   
           05  WS-PGRMNAME                   PIC X(10)  VALUE           
                                                          'PCSRP233'.   
           05  WS-REPTNAME                   PIC X(10)  VALUE           
                                                          'PCSR2331'.   
           05  WS-ACCT-DIFF                  PIC S9(09)V99 COMP-3       
                                                        VALUE ZEROS.    
           05  WS-PROCESS-SW                 PIC 9(01)  VALUE 1.        
               88  PROCESS-CSR                          VALUE 1.        
               88  PROCESS-SEB                          VALUE 2.        
           05  WS-SAVE-CASH-OFFICE           PIC X(03)  VALUE SPACES.   
           05  WS-CNT-OOB                    PIC 9(02)  VALUE ZEROS.    
           05  WS-MAX-OOB                    PIC 9(02)  VALUE 5.        
           05  WS-BALANCE-CODE               PIC 9(02)  VALUE ZEROS.    
           05  WS-FCSPT33-STATUS             PIC X(02)  VALUE '00'.     
               88  FCSPT33-SUCCESSFUL                   VALUE '00'.     
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FIRST-TIME                 PIC X(01)  VALUE 'Y'.      
               88  FIRST-TIME                           VALUE 'Y'.      
               88  NOT-FIRST-TIME                       VALUE 'N'.      
           05  WS-RECORD-FOUND               PIC X(01)  VALUE 'N'.      
               88  RECORD-FOUND                         VALUE 'Y'.      
               88  NOT-RECORD-FOUND                     VALUE 'N'.      
           05  WS-NO-DATA                    PIC X(01)  VALUE 'N'.      
               88  NO-DATA                              VALUE 'Y'.      
               88  NOT-NO-DATA                          VALUE 'N'.      
           05  WS-LAST-RECORD                PIC X(01)  VALUE 'N'.      
               88  LAST-RECORD                          VALUE 'Y'.      
               88  NOT-LAST-RECORD                      VALUE 'N'.      
           05  WS-MORE-ROWS-FLAG             PIC X(01)  VALUE 'Y'.      
               88  END-OF-ROWS                          VALUE 'N'.      
                                                                        
           05  WS-MORE-DETL-FLAG             PIC X(01)  VALUE ' '.      
               88  START-OF-DETAIL                      VALUE 'S'.      
               88  END-OF-DETAIL                        VALUE 'E'.      
           05  WS-REPORT-LINE-IND            PIC X(01)  VALUE ' '.      
               88  REPORT-LINE1                         VALUE '1'.      
               88  REPORT-LINE2                         VALUE '2'.      
                                                                        
       01  WS-CIS-ACCOUNT                    PIC 9(13).                 
       01  WS-CIS-ACCOUNT-X REDEFINES WS-CIS-ACCOUNT                    
                                             PIC X(13).                 
                                                                        
       01  WS-CIS-ACCT.                                                 
           05  WS-ACCT-1                     PIC X(1).                  
           05  WS-ACCT-D1                    PIC X(1).                  
           05  WS-ACCT-2                     PIC X(4).                  
           05  WS-ACCT-D2                    PIC X(1).                  
           05  WS-ACCT-3                     PIC X(4).                  
           05  WS-ACCT-D3                    PIC X(1).                  
           05  WS-ACCT-4                     PIC X(4).                  
                                                                        
       01  WS-CASH-REPORT-DATE.                                         
           05  WS-CASH-REPORT-YY             PIC 9(2).                  
           05  WS-CASH-REPORT-MM             PIC 9(2).                  
           05  WS-CASH-REPORT-DD             PIC 9(2).                  
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY                 PIC 9(02).                 
           05  WS-CURRENT-MM                 PIC 9(02).                 
           05  WS-CURRENT-DD                 PIC 9(02).                 
                                                                        
       01  WS-CURRENT-TIME                   PIC 9(08).                 
                                                                        
       01  WS-BEGIN-DATE.                                               
           05  WS-BEGIN-YY                   PIC 9(04).                 
           05  WS-BEGIN-D1                   PIC X(01).                 
           05  WS-BEGIN-MM                   PIC 9(02).                 
           05  WS-BEGIN-D2                   PIC X(01).                 
           05  WS-BEGIN-DD                   PIC 9(02).                 
                                                                        
       01  WS-END-DATE.                                                 
           05  WS-END-YY                     PIC 9(04).                 
           05  WS-END-D1                     PIC X(01).                 
           05  WS-END-MM                     PIC 9(02).                 
           05  WS-END-D2                     PIC X(01).                 
           05  WS-END-DD                     PIC 9(02).                 
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-YES                        PIC X(01)  VALUE 'Y'.      
           05  WS-NO                         PIC X(01)  VALUE 'N'.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-N                          PIC X(01)  VALUE 'N'.      
           05  WS-Y                          PIC X(01)  VALUE 'Y'.      
           05  WS-0                          PIC 9(01)  VALUE 0.        
           05  WS-1                          PIC 9(01)  VALUE 1.        
           05  WS-2                          PIC 9(01)  VALUE 2.        
           05  WS-3                          PIC 9(01)  VALUE 3.        
           05  WS-4                          PIC 9(01)  VALUE 4.        
           05  WS-5                          PIC 9(01)  VALUE 5.        
           05  WS-6                          PIC 9(01)  VALUE 6.        
           05  WS-7                          PIC 9(01)  VALUE 7.        
           05  WS-8                          PIC 9(01)  VALUE 8.        
           05  WS-9                          PIC 9(01)  VALUE 9.        
           05  WS-10                         PIC 9(02)  VALUE 10.       
           05  WS-11                         PIC 9(02)  VALUE 11.       
           05  WS-12                         PIC 9(02)  VALUE 12.       
           05  WS-21                         PIC 9(02)  VALUE 21.       
           05  WS-22                         PIC 9(02)  VALUE 22.       
           05  WS-23                         PIC 9(02)  VALUE 23.       
           05  WS-24                         PIC 9(02)  VALUE 24.       
           05  WS-25                         PIC 9(02)  VALUE 25.       
           05  WS-26                         PIC 9(02)  VALUE 26.       
           05  WS-27                         PIC 9(02)  VALUE 27.       
           05  WS-28                         PIC 9(02)  VALUE 28.       
           05  WS-29                         PIC 9(02)  VALUE 29.       
           05  WS-30                         PIC 9(02)  VALUE 30.       
           05  WS-31                         PIC 9(02)  VALUE 31.       
           05  WS-57                         PIC 9(02)  VALUE 57.       
           05  WS-100                        PIC 9(03)  VALUE 100.      
                                                                        
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT HEADER            *           
      ***************************************************************           
       01  WS-HEADER-LINES.                                             
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  P-RPT-TITLE-PGNM          PIC X(08).                 
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  P-RPT-COMP-NAME           PIC X(15)  VALUE           
                   ' SCE&G / PSNC  '.                                   
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                       'RUN-DATE:'.     
               10  P-RPT-RUN-MM              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-DD              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-YY              PIC X(02).                 
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                                 'MONTHLY OVER/SHORT MONITORING'.       
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  WS-REP-HH                 PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP-MIN                PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP-SS                 PIC X(02).                 
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(19)  VALUE           
                   'CASH LOCAL OFFICE: '.                               
               10  WS-RPT-LOC-OFFICE         PIC X(03)  VALUE SPACES.   
               10  FILLER                    PIC X(42)  VALUE SPACES.   
               10  FILLER                    PIC X(06)  VALUE           
                                                'REPORT'.               
               10  FILLER                    PIC X(46)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                        'PAGE    :'.    
               10  P-RPT-PAGE-NO             PIC ZZZZZ.                 
                                                                        
           05  WS-RPT-HEADER-4.                                         
               10 FILLER                    PIC X(02) VALUE SPACES.     
               10 WS-CASH-LOC-OFF-DESC      PIC X(25) VALUE SPACES.     
               10 FILLER                    PIC X(106) VALUE SPACES.    
      *                                                                         
           05  WS-RPT-HEADER-5.                                         
               10  FILLER                    PIC X(133) VALUE SPACES.   
                                                                        
           05  WS-RPT-HEADER-6.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(04)  VALUE           
                                                 'DESC'.                
               10  FILLER                    PIC X(03)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                 'CASH DATE'.           
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(04)  VALUE           
                                                  'OFCE'.               
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(04)  VALUE           
                                                  'DRWR'.               
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(08)  VALUE           
                                                  'EMPLOYEE'.           
               10  FILLER                    PIC X(03)  VALUE SPACES.   
               10  FILLER                    PIC X(08)  VALUE           
                                                  'OV/SH ID'.           
               10  FILLER                    PIC X(03)  VALUE SPACES.   
               10  FILLER                    PIC X(12)  VALUE           
                                                  'OV/SH AMOUNT'.       
               10  FILLER                    PIC X(03)  VALUE SPACES.   
               10  FILLER                    PIC X(13)  VALUE           
                                                  'OFFSET AMOUNT'.      
               10  FILLER                    PIC X(05)  VALUE SPACES.   
               10  FILLER                    PIC X(08)  VALUE           
                                                 'ACCOUNT '.            
               10  FILLER                    PIC X(10)  VALUE SPACES.   
               10  FILLER                    PIC X(10)  VALUE           
                                                  'OV/SH TYPE'.         
               10  FILLER                    PIC X(11)  VALUE SPACES.   
               10  FILLER                    PIC X(07)  VALUE           
                                                  'GL ACCT'.            
      *                                                                         
           05  WS-RPT-HEADER-7.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(08)  VALUE           
                                                  'COMMENTS'.           
               10  FILLER                    PIC X(122) VALUE SPACES.   
                                                                        
           05  WS-RPT-HEADER-8.                                         
               10  FILLER                    PIC X(133) VALUE ALL '='.  
                                                                        
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT DETAILS           *           
      ***************************************************************           
                                                                        
       01  WS-RPT-DETAIL-LINE-1.                                        
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-DESC                      PIC X(05).               
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-CASH-DATE                 PIC X(10).               
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-CASH-OFFICE               PIC X(03).               
           05 FILLER                           PIC X(01) VALUE SPACES.  
           05 WS-RPT-CASH-DRWR                 PIC ZZZZ9.               
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-EMPL                      PIC X(07).               
           05 FILLER                           PIC X(05) VALUE SPACES.  
           05 WS-RPT-OVSH-ID                   PIC ZZZZ9.               
           05 FILLER                           PIC X(01) VALUE SPACES.  
           05 WS-RPT-OVSH-AMT                  PIC ZZZ,ZZZ,ZZ9.99-.     
           05 FILLER                           PIC X(01) VALUE SPACES.  
           05 WS-RPT-OFFSET-AMT                PIC ZZZ,ZZZ,ZZ9.99-.     
           05 FILLER                           PIC X(03) VALUE SPACES.  
           05 WS-RPT-CIS-ACCT                  PIC X(16).               
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-OVSH-TYPE                 PIC X(22).               
           05 FILLER                           PIC X(01) VALUE SPACES.  
           05 WS-RPT-GL-MAJOR                  PIC X(03).               
           05 WS-RPT-GL-PERIOD                 PIC X(01) VALUE '.'.     
           05 WS-RPT-GL-MINOR                  PIC X(04).               
                                                                        
       01  WS-MSG-LINE.                                                 
           05 FILLER                         PIC X(02)  VALUE SPACES.   
           05 WS-RPT-MSG-OVSH                PIC X(130) VALUE SPACES.   
                                                                        
       01  WS-TOT-LINE.                                                 
           05 FILLER                         PIC X(02)  VALUE SPACES.   
           05 FILLER                         PIC X(08)  VALUE           
               'TOTALS :'.                                              
           05 FILLER                         PIC X(27) VALUE SPACES.    
           05 WS-RPT-GL                      PIC X(10) VALUE SPACES.    
           05 WS-RPT-TOT-OVSH                PIC ZZ,ZZZ,ZZZ,ZZ9.99-.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-RPT-TOT-OFST                PIC ZZZ,ZZZ,ZZ9.99-.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(31)  VALUE           
               '****** NO DATA THIS RUN *******'.                       
           05 FILLER                         PIC X(44)  VALUE SPACES.   
                                                                        
       01  WS-FOOTER.                                                   
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(25)  VALUE           
               '* * * END OF REPORT * * *'.                             
           05 FILLER                         PIC X(60)  VALUE SPACES.   
                                                                        
       01  WS-SAVE-PRT33                     PIC X(133).                
                                                                        
       COPY FIOJC01.                                                            
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_OVERSHORT_HDR                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBOVSHHD                                                 
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_OVERSHORT_DET                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBOVSHDT                                                 
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_OVERSHORT_TYPE                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBOVSHTY                                                 
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_DELINQUENCY                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CASHIER_OFFICE                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCSHOFF                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR TO GET SOLUTION OV/SH HEADER RECORDS                   *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE OVSH_HDR CURSOR FOR                             
                 SELECT A.CASH_LOCAL_OFFICE                             
                       ,A.DATE_CASH_REPORT                              
                       ,A.CASH_DRAWER_ID                                
                       ,A.OVERSHORT_ID                                  
                       ,A.USER_ID                                       
                       ,A.ACCOUNT_NO                                    
                       ,A.OVERSHORT_AMT                                 
                       ,A.OVERSHORT_DR_CR                               
                       ,A.OFST_OVERSHORT_AMT                            
                       ,A.OFST_DR_CR                                    
                       ,A.GL_ACCT_NO                                    
                       ,A.OVERSHORT_TYPE_CD                             
                       ,A.OVERSHORT_SOLTN_FL                            
                       ,A.TRAN_COMMENT                                  
                   FROM CSS_OVERSHORT_HDR A                             
                  WHERE A.CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO      
               ORDER BY A.CASH_LOCAL_OFFICE                             
                       ,A.DATE_CASH_REPORT                              
                       ,A.CASH_DRAWER_ID                                
                       ,A.OVERSHORT_ID                                  
           END-EXEC.                                                    
      *                                                                         
                                                                        
      ******************************************************************        
      *  CURSOR TO GET OV/SH DETAIL RECORDS                            *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE OVSH_DET CURSOR FOR                             
                 SELECT A.OFST_COMPANY_NO                               
                       ,A.OFST_LOC_OFCE                                 
                       ,A.OFST_CASH_REPT_DT                             
                       ,A.OFST_CASH_DRWR_ID                             
                       ,A.OFST_OVERSHORT_ID                             
                       ,A.OVERSHORT_SEQ_NO                              
                       ,A.OFST_OVERSHORT_AMT                            
                       ,A.OFST_DR_CR                                    
                   FROM CSS_OVERSHORT_DET A                             
                  WHERE A.CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO      
                    AND A.CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE    
                    AND A.DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )     
                    AND A.CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID       
                    AND A.OVERSHORT_ID       = :OH-OVERSHORT-ID         
               ORDER BY A.OFST_COMPANY_NO                               
                       ,A.OFST_LOC_OFCE                                 
                       ,A.OFST_CASH_REPT_DT                             
                       ,A.OFST_CASH_DRWR_ID                             
                       ,A.OFST_OVERSHORT_ID                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     56130000
MFA-TR*         DECLARE OVSH_DET CURSOR FOR                                     
MFA-TR*          SELECT A.OFST_COMPANY_NO                               56210000
MFA-TR*                ,A.OFST_LOC_OFCE                                         
MFA-TR*                ,A.OFST_CASH_REPT_DT                                     
MFA-TR*                ,A.OFST_CASH_DRWR_ID                                     
MFA-TR*                ,A.OFST_OVERSHORT_ID                                     
MFA-TR*                ,A.OVERSHORT_SEQ_NO                                      
MFA-TR*                ,A.OFST_OVERSHORT_AMT                                    
MFA-TR*                ,A.OFST_DR_CR                                            
MFA-TR*            FROM CSS_OVERSHORT_DET A                             56200000
MFA-TR*           WHERE A.CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO      56140000
MFA-TR*             AND A.CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE    56140000
MFA-TR*             AND A.DATE_CASH_REPORT   = :OH-DATE-CASH-REPORT             
MFA-TR*             AND A.CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID               
MFA-TR*             AND A.OVERSHORT_ID       = :OH-OVERSHORT-ID                 
MFA-TR*        ORDER BY A.OFST_COMPANY_NO                               56210000
MFA-TR*                ,A.OFST_LOC_OFCE                                         
MFA-TR*                ,A.OFST_CASH_REPT_DT                                     
MFA-TR*                ,A.OFST_CASH_DRWR_ID                                     
MFA-TR*                ,A.OFST_OVERSHORT_ID                                     
MFA-TR*    END-EXEC.                                                    56242000
      *                                                                         
      ******************************************************************        
      *  CURSOR TO RESOLVE OFFSET TO PROBLEM HEADER RECORDS.           *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE OVSH_DET2 CURSOR FOR                            
                 SELECT A.CASH_COMPANY_NO                               
                       ,A.CASH_LOCAL_OFFICE                             
                       ,A.DATE_CASH_REPORT                              
                       ,A.CASH_DRAWER_ID                                
                       ,A.OVERSHORT_ID                                  
                       ,A.OVERSHORT_SEQ_NO                              
                       ,A.OFST_OVERSHORT_AMT                            
                       ,A.OFST_DR_CR                                    
                   FROM CSS_OVERSHORT_DET A                             
                  WHERE A.OFST_COMPANY_NO    = :OH-CASH-COMPANY-NO      
                    AND A.OFST_LOC_OFCE      = :OH-CASH-LOCAL-OFFICE    
                    AND A.OFST_CASH_REPT_DT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )     
                    AND A.OFST_CASH_DRWR_ID  = :OH-CASH-DRAWER-ID       
                    AND A.OFST_OVERSHORT_ID  = :OH-OVERSHORT-ID         
               ORDER BY A.CASH_COMPANY_NO                               
                       ,A.CASH_LOCAL_OFFICE                             
                       ,A.DATE_CASH_REPORT                              
                       ,A.CASH_DRAWER_ID                                
                       ,A.OVERSHORT_ID                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     56130000
MFA-TR*         DECLARE OVSH_DET2 CURSOR FOR                                    
MFA-TR*          SELECT A.CASH_COMPANY_NO                               56210000
MFA-TR*                ,A.CASH_LOCAL_OFFICE                                     
MFA-TR*                ,A.DATE_CASH_REPORT                                      
MFA-TR*                ,A.CASH_DRAWER_ID                                        
MFA-TR*                ,A.OVERSHORT_ID                                          
MFA-TR*                ,A.OVERSHORT_SEQ_NO                                      
MFA-TR*                ,A.OFST_OVERSHORT_AMT                                    
MFA-TR*                ,A.OFST_DR_CR                                            
MFA-TR*            FROM CSS_OVERSHORT_DET A                             56200000
MFA-TR*           WHERE A.OFST_COMPANY_NO    = :OH-CASH-COMPANY-NO      56140000
MFA-TR*             AND A.OFST_LOC_OFCE      = :OH-CASH-LOCAL-OFFICE    56140000
MFA-TR*             AND A.OFST_CASH_REPT_DT  = :OH-DATE-CASH-REPORT             
MFA-TR*             AND A.OFST_CASH_DRWR_ID  = :OH-CASH-DRAWER-ID               
MFA-TR*             AND A.OFST_OVERSHORT_ID  = :OH-OVERSHORT-ID                 
MFA-TR*        ORDER BY A.CASH_COMPANY_NO                               56210000
MFA-TR*                ,A.CASH_LOCAL_OFFICE                                     
MFA-TR*                ,A.DATE_CASH_REPORT                                      
MFA-TR*                ,A.CASH_DRAWER_ID                                        
MFA-TR*                ,A.OVERSHORT_ID                                          
MFA-TR*    END-EXEC.                                                    56242000
      *                                                                         
                                                                        
       01  WS-END                              PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSRP233 ENDS HERE  '.                  
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                                                              **        
      **  0000-MAINLINE.                                              **        
      **       CONTROLS MAIN PATH OF PROGRAM                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
           PERFORM 1000-MAIN-PROCESS-PARA                               
              THRU 1000-EXIT                                            
                   UNTIL END-OF-ROWS.                                   
           PERFORM 8450-PRINT-RPT-FOOTER                                
              THRU 8450-EXIT.                                           
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **   0100-INITIALIZATION.                                       **        
      **        INITIALIZATION ROUTINE                                **        
      **                                                              **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
      *  OPEN FCSPT33-FILE                                                      
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF FCSPT33-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS         TO WS-DISP-RC              
              MOVE ' ERROR IN OPENING FCSPT33 FILE.'                    
                                             TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               DISPLAY '************** PCSRP233************'            
               DISPLAY '  INVALID COMPANY NUMBER'                       
               DISPLAY '  PROCESSING TERMINATED'                        
               DISPLAY '************** PCSRP233************'            
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           ELSE                                                         
              MOVE WS-SYSIN-COMP-NO            TO C7-COMPANY-NO         
           END-IF.                                                      
      *                                                                         
           PERFORM 7450-GET-COMP-DESC          THRU 7450-EXIT.          
      *                                                                         
                                                                        
      * GET CURRENT DATE                                                        
                                                                        
           ACCEPT WS-CURRENT-DATE            FROM DATE.                 
           MOVE   WS-CURRENT-YY              TO P-RPT-RUN-YY.           
           MOVE   WS-CURRENT-MM              TO P-RPT-RUN-MM.           
           MOVE   WS-CURRENT-DD              TO P-RPT-RUN-DD.           
                                                                        
      * GET CURRENT TIME                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME            FROM TIME.                 
           MOVE   WS-CURRENT-TIME(1:2)       TO WS-REP-HH.              
           MOVE   WS-CURRENT-TIME(3:2)       TO WS-REP-MIN.             
           MOVE   WS-CURRENT-TIME(5:2)       TO WS-REP-SS.              
                                                                        
           MOVE   '01'                       TO OH-CASH-COMPANY-NO.     
                                                                        
      *****************************************************************         
      * CHECK CSS_DELINQUENCY TABLE TO DETERMINE IF SCEG/PSNC OR SEB  *         
      * ACCOUNT --                                                    *         
      *****************************************************************         
      *                                                                         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           MOVE WS-SYSIN-COMP-NO              TO C8-COMPANY-NO.         
           PERFORM 7500-CALL-DELIQUENCY       THRU 7500-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-1                       TO WS-PROCESS-SW          
           ELSE                                                         
              MOVE C8-DELINQ-VALUE            TO WS-PROCESS-SW          
           END-IF.                                                      
                                                                        
           PERFORM 0200-PROCESS-DATE                                    
              THRU 0200-EXIT.                                           
                                                                        
           PERFORM 7100-OPEN-OVSH-HDR                                   
              THRU 7100-EXIT.                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0200-PROCESS-CURRENT-DATE                                     *         
      * OBTAINS BOTH THE SYSTEM DATE AND THE ACCOUNTING PERIOD. IF    *         
      * THE ACCOUNTING PERIOD IS  NOT FOUND, THE ACCOUNTING PERIOD    *         
      * DEFAULTS TO THE PREVIOUS MONTH OF THE SYSTEM DATE.            *         
      *                                                               *         
      * CALLED BY:  0100-INITIALIZATION                               *         
      *****************************************************************         
       0200-PROCESS-DATE.                                               
                                                                        
           MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
           MOVE SPACES                   TO WS-SYSIPT.                  
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE             THRU 6200-EXIT.  
                                                                        
           DISPLAY 'BEGIN DATE = ', WS-STNDTE-RPT-BEG-DT.               
           DISPLAY '  END DATE = ', WS-STNDTE-RPT-END-DT.               
                                                                        
RLS   *    MOVE '2003-01-01' TO WS-STNDTE-RPT-BEG-DT.                           
RLS   *    MOVE '2003-01-31' TO WS-STNDTE-RPT-END-DT.                           
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **   1000-MAIN-PROCESS-PARA.                                    **        
      **        MAIN PROCESS                                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           PERFORM 7150-FETCH-OVSH-HDR                                  
              THRU 7150-EXIT.                                           
                                                                        
           IF END-OF-ROWS                                               
              GO TO 1000-EXIT
           END-IF.                                          
                                                                        
           PERFORM 2000-PROCESS-OVSH                                    
              THRU 2000-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **  2000-PROCESS-OVSH.                                       **           
      **       PROCESS OVSH HEADER RECORDS FOR PROBLEM TAGGING     **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2000-PROCESS-OVSH.                                               
                                                                        
           MOVE '2000'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF OH-OVERSHORT-AMT = ZERO                                   
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF OH-DATE-CASH-REPORT < WS-STNDTE-RPT-BEG-DT                
           OR OH-DATE-CASH-REPORT > WS-STNDTE-RPT-END-DT                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           SET REPORT-LINE1 TO TRUE.                                    
           MOVE SPACES                       TO WS-RPT-DETAIL-LINE-1.   
                                                                        
           IF OH-OVERSHORT-SOLTN-FL = 'S'                               
              MOVE 'SOLTN'                   TO WS-RPT-DESC             
           ELSE                                                         
              MOVE 'PBLM'                    TO WS-RPT-DESC             
           END-IF.                                                      
                                                                        
           MOVE OH-DATE-CASH-REPORT          TO WS-RPT-CASH-DATE.       
           MOVE OH-CASH-DRAWER-ID            TO WS-RPT-CASH-DRWR.       
           MOVE OH-USER-ID                   TO WS-RPT-EMPL.            
           MOVE OH-OVERSHORT-ID              TO WS-RPT-OVSH-ID.         
           IF OH-OVERSHORT-DR-CR = 'C'                                  
              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT * -1          
           END-IF.                                                      
           MOVE OH-OVERSHORT-AMT             TO WS-RPT-OVSH-AMT.        
           IF OH-OFST-DR-CR = 'C'                                       
              COMPUTE OH-OFST-OVERSHORT-AMT =                           
                      OH-OFST-OVERSHORT-AMT * -1                        
           END-IF.                                                      
                                                                        
           COMPUTE WS-TOT-OVSH-AMT = WS-TOT-OVSH-AMT +                  
                                     OH-OVERSHORT-AMT.                  
           COMPUTE WS-TOT-OFST-AMT = WS-TOT-OFST-AMT +                  
                                     OH-OFST-OVERSHORT-AMT.             
                                                                        
RLS        EVALUATE OH-GL-ACCT-NO                                       
              WHEN 253.0100                                             
                 COMPUTE WS-TOT-OVSH-2530100 = WS-TOT-OVSH-2530100 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530100 = WS-TOT-OFST-2530100 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0200                                             
                 COMPUTE WS-TOT-OVSH-2530200 = WS-TOT-OVSH-2530200 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530200 = WS-TOT-OFST-2530200 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0300                                             
                 COMPUTE WS-TOT-OVSH-2530300 = WS-TOT-OVSH-2530300 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530300 = WS-TOT-OFST-2530300 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0400                                             
                 COMPUTE WS-TOT-OVSH-2530400 = WS-TOT-OVSH-2530400 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530400 = WS-TOT-OFST-2530400 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0500                                             
                 COMPUTE WS-TOT-OVSH-2530500 = WS-TOT-OVSH-2530500 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530500 = WS-TOT-OFST-2530500 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0600                                             
                 COMPUTE WS-TOT-OVSH-2530600 = WS-TOT-OVSH-2530600 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530600 = WS-TOT-OFST-2530600 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0700                                             
                 COMPUTE WS-TOT-OVSH-2530700 = WS-TOT-OVSH-2530700 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530700 = WS-TOT-OFST-2530700 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 253.0800                                             
                 COMPUTE WS-TOT-OVSH-2530800 = WS-TOT-OVSH-2530800 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-2530800 = WS-TOT-OFST-2530800 +    
                                               OH-OFST-OVERSHORT-AMT    
T31289        WHEN 253.0900                                             
T31289           COMPUTE WS-TOT-OVSH-2530900 = WS-TOT-OVSH-2530900 +    
T31289                                         OH-OVERSHORT-AMT         
T31289           COMPUTE WS-TOT-OFST-2530900 = WS-TOT-OFST-2530900 +    
T31289                                         OH-OFST-OVERSHORT-AMT    
              WHEN 143.2000                                             
                 COMPUTE WS-TOT-OVSH-1432000 = WS-TOT-OVSH-1432000 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-1432000 = WS-TOT-OFST-1432000 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 143.3000                                             
                 COMPUTE WS-TOT-OVSH-1433000 = WS-TOT-OVSH-1433000 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-1433000 = WS-TOT-OFST-1433000 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN 143.4000                                             
                 COMPUTE WS-TOT-OVSH-1434000 = WS-TOT-OVSH-1434000 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-1434000 = WS-TOT-OFST-1434000 +    
                                               OH-OFST-OVERSHORT-AMT    
T30257        WHEN 143.6000                                             
T30257           COMPUTE WS-TOT-OVSH-1436000 = WS-TOT-OVSH-1436000 +    
T30257                                         OH-OVERSHORT-AMT         
T30257           COMPUTE WS-TOT-OFST-1436000 = WS-TOT-OFST-1436000 +    
T30257                                         OH-OFST-OVERSHORT-AMT    
T31289        WHEN 143.8000                                             
T31289           COMPUTE WS-TOT-OVSH-1438000 = WS-TOT-OVSH-1438000 +    
T31289                                         OH-OVERSHORT-AMT         
T31289           COMPUTE WS-TOT-OFST-1438000 = WS-TOT-OFST-1438000 +    
T31289                                         OH-OFST-OVERSHORT-AMT    
              WHEN 184.6000                                             
                 COMPUTE WS-TOT-OVSH-1846000 = WS-TOT-OVSH-1846000 +    
                                               OH-OVERSHORT-AMT         
                 COMPUTE WS-TOT-OFST-1846000 = WS-TOT-OFST-1846000 +    
                                               OH-OFST-OVERSHORT-AMT    
              WHEN OTHER                                                
                 CONTINUE                                               
RLS        END-EVALUATE.                                                
                                                                        
           MOVE OH-OFST-OVERSHORT-AMT        TO WS-RPT-OFFSET-AMT.      
           MOVE OH-ACCOUNT-NO                TO WS-CIS-ACCOUNT.         
           MOVE WS-CIS-ACCOUNT-X (1:1)       TO WS-ACCT-1.              
           MOVE WS-CIS-ACCOUNT-X (2:4)       TO WS-ACCT-2.              
           MOVE WS-CIS-ACCOUNT-X (6:4)       TO WS-ACCT-3.              
           MOVE WS-CIS-ACCOUNT-X (10:4)      TO WS-ACCT-4.              
           MOVE '-'                          TO WS-ACCT-D1.             
           MOVE '-'                          TO WS-ACCT-D2.             
           MOVE '-'                          TO WS-ACCT-D3.             
           MOVE WS-CIS-ACCT                  TO WS-RPT-CIS-ACCT.        
                                                                        
           PERFORM 7400-SELECT-OVSH-DESC                                
              THRU 7400-EXIT.                                           
                                                                        
           MOVE OT-OVERSHORT-TYPE-DSC        TO WS-RPT-OVSH-TYPE.       
           MOVE OH-GL-ACCT-NO                TO WS-GL-ACCOUNT.          
           MOVE WS-GL-ACCT-MAJOR             TO WS-RPT-GL-MAJOR.        
           MOVE '.'                          TO WS-RPT-GL-PERIOD.       
           MOVE WS-GL-ACCT-MINOR             TO WS-RPT-GL-MINOR.        
                                                                        
           MOVE OH-TRAN-COMMENT              TO WS-RPT-MSG-OVSH.        
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT                                
              THRU 8000-EXIT.                                           
                                                                        
           IF OH-OVERSHORT-SOLTN-FL = 'S'                               
              PERFORM 7200-OPEN-OVSH-DET                                
                 THRU 7200-EXIT                                         
              SET START-OF-DETAIL TO TRUE                               
              PERFORM 2500-PROCESS-OVSH-DET                             
                 THRU 2500-EXIT                                         
                 UNTIL END-OF-DETAIL                                    
           ELSE                                                         
           IF OH-OVERSHORT-SOLTN-FL = 'P'                               
              PERFORM 7300-OPEN-OVSH-DET2                               
                 THRU 7300-EXIT                                         
              SET START-OF-DETAIL TO TRUE                               
              PERFORM 2600-PROCESS-OVSH-DET2                            
                 THRU 2600-EXIT                                         
                 UNTIL END-OF-DETAIL                                    
           END-IF END-IF.                                               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **  2500-PROCESS-OVSH-DET.                                   **           
      **       PROCESS OVSH DETAIL RECORDS FOR PROBLEM TAGGING     **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2500-PROCESS-OVSH-DET.                                           
                                                                        
           MOVE '2500'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7250-FETCH-OVSH-DET                                  
              THRU 7250-EXIT.                                           
                                                                        
           IF END-OF-DETAIL                                             
              PERFORM 7280-CLOSE-OVSH-DET                               
                 THRU 7280-EXIT                                         
              GO TO 2500-EXIT                                           
           END-IF.                                                      
                                                                        
           SET REPORT-LINE2 TO TRUE.                                    
           MOVE SPACES                       TO WS-RPT-DETAIL-LINE-1.   
           MOVE '*OFST'                      TO WS-RPT-DESC.            
           MOVE OD-OFST-CASH-REPT-DT         TO WS-RPT-CASH-DATE.       
           MOVE OD-OFST-LOC-OFCE             TO WS-RPT-CASH-OFFICE.     
           MOVE OD-OFST-CASH-DRWR-ID         TO WS-RPT-CASH-DRWR.       
           MOVE OD-OFST-OVERSHORT-ID         TO WS-RPT-OVSH-ID.         
           IF OD-OFST-DR-CR = 'C'                                       
              COMPUTE OD-OFST-OVERSHORT-AMT =                           
                      OD-OFST-OVERSHORT-AMT * -1                        
           END-IF.                                                      
           MOVE OD-OFST-OVERSHORT-AMT        TO WS-RPT-OFFSET-AMT.      
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT                                
              THRU 8000-EXIT.                                           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **  2600-PROCESS-OVSH-DET2.                                  **           
      **       PROCESS OVSH DETAIL RECORDS FOR PROBLEM TAGGING     **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2600-PROCESS-OVSH-DET2.                                          
                                                                        
           MOVE '2600'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7350-FETCH-OVSH-DET2                                 
              THRU 7350-EXIT.                                           
                                                                        
           IF END-OF-DETAIL                                             
              PERFORM 7380-CLOSE-OVSH-DET2                              
                 THRU 7380-EXIT                                         
              GO TO 2600-EXIT                                           
           END-IF.                                                      
                                                                        
           SET REPORT-LINE2 TO TRUE.                                    
           MOVE SPACES                       TO WS-RPT-DETAIL-LINE-1.   
           MOVE '*OFST'                      TO WS-RPT-DESC.            
           MOVE OD-DATE-CASH-REPORT          TO WS-RPT-CASH-DATE.       
           MOVE OD-CASH-LOCAL-OFFICE         TO WS-RPT-CASH-OFFICE.     
           MOVE OD-CASH-DRAWER-ID            TO WS-RPT-CASH-DRWR.       
           MOVE OD-OVERSHORT-ID              TO WS-RPT-OVSH-ID.         
           IF OD-OFST-DR-CR = 'C'                                       
              COMPUTE OD-OFST-OVERSHORT-AMT =                           
                      OD-OFST-OVERSHORT-AMT * -1                        
           END-IF.                                                      
           MOVE OD-OFST-OVERSHORT-AMT        TO WS-RPT-OFFSET-AMT.      
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT                                
              THRU 8000-EXIT.                                           
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **  6200-GET-PARAMETER-DATE                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  7100-OPEN-OVSH-HDR.                                         **        
      **       OPENS THE OVSH_HDR CURSOR                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7100-OPEN-OVSH-HDR.                                              
                                                                        
           MOVE '7100'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                OPEN OVSH_HDR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'OPEN OVSH HDR ERROR'     TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7150-FETCH-OVSH-HDR.                                        **        
      **                                                              **        
      **      FETCHES THE REQUIRED COLUMNS FROM CSS_OVERSHORT_HDR     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7150-FETCH-OVSH-HDR.                                             
                                                                        
           MOVE '7150'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE SPACES TO OH-TRAN-COMMENT.                              
                                                                        
           EXEC SQL                                                     
               FETCH OVSH_HDR                                           
               INTO :OH-CASH-LOCAL-OFFICE,                              
                    :OH-DATE-CASH-REPORT,                               
                    :OH-CASH-DRAWER-ID,                                 
                    :OH-OVERSHORT-ID,                                   
                    :OH-USER-ID,                                        
                    :OH-ACCOUNT-NO,                                     
                    :OH-OVERSHORT-AMT,                                  
                    :OH-OVERSHORT-DR-CR,                                
                    :OH-OFST-OVERSHORT-AMT,                             
                    :OH-OFST-DR-CR,                                     
                    :OH-GL-ACCT-NO,                                     
                    :OH-OVERSHORT-TYPE-CD,                              
                    :OH-OVERSHORT-SOLTN-FL,                             
                    :OH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF FIRST-TIME                                             
                 SET NOT-FIRST-TIME TO TRUE                             
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET END-OF-ROWS TO TRUE                                   
           ELSE                                                         
              SET END-OF-ROWS TO TRUE                                   
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'FETCH CURSOR ERROR'      TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF END-IF.                                               
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7200-CLOSE-OVSH-HDR.                                        **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7180-CLOSE-OVSH-HDR.                                             
                                                                        
           MOVE '7180'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                CLOSE OVSH_HDR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'CLOSE CURSOR ERROR'      TO WS-ERR-MSG              
RLS           DISPLAY WS-DISP-RC, '  WS-ACTIVE-RETURN-CODE  '           
              DISPLAY '********************************'                
              DISPLAY '** PROCESSING ERROR           **'                
              DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH            
              DISPLAY '** ', WS-ERR-MSG                                 
              DISPLAY '** SQLCODE = ', WS-DISP-RC                       
              DISPLAY '** PROCESSING TERMINATED      **'                
              DISPLAY '********************************'                
RLS   *       PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT                     
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7200-OPEN-OVSH-DET.                                         **        
      **       OPENS THE OVSH_DET CURSOR                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7200-OPEN-OVSH-DET.                                              
                                                                        
           MOVE '7200'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                OPEN OVSH_DET                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'OPEN OVSH DET ERROR'     TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7250-FETCH-OVSH-DET.                                        **        
      **                                                              **        
      **      FETCHES THE REQUIRED COLUMNS FROM CSS_OVERSHORT_DET     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7250-FETCH-OVSH-DET.                                             
                                                                        
           MOVE '7250'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               FETCH OVSH_DET                                           
               INTO :OD-OFST-COMPANY-NO,                                
                    :OD-OFST-LOC-OFCE,                                  
                    :OD-OFST-CASH-REPT-DT,                              
                    :OD-OFST-CASH-DRWR-ID,                              
                    :OD-OFST-OVERSHORT-ID,                              
                    :OD-OVERSHORT-SEQ-NO,                               
                    :OD-OFST-OVERSHORT-AMT,                             
                    :OD-OFST-DR-CR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET END-OF-DETAIL TO TRUE                                 
           ELSE                                                         
              SET END-OF-DETAIL TO TRUE                                 
              SET END-OF-ROWS   TO TRUE                                 
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'FETCH OVSH DET ERROR'    TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF END-IF.                                               
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7280-CLOSE-OVSH-DET.                                        **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7280-CLOSE-OVSH-DET.                                             
                                                                        
           MOVE '7280'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                CLOSE OVSH_DET                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'CLOSE OVSH DET ERROR'    TO WS-ERR-MSG              
RLS           DISPLAY WS-DISP-RC, '  WS-ACTIVE-RETURN-CODE  '           
              DISPLAY '********************************'                
              DISPLAY '** PROCESSING ERROR           **'                
              DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH            
              DISPLAY '** ', WS-ERR-MSG                                 
              DISPLAY '** SQLCODE = ', WS-DISP-RC                       
              DISPLAY '** PROCESSING TERMINATED      **'                
              DISPLAY '********************************'                
RLS   *       PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT                     
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7300-OPEN-OVSH-DET2.                                        **        
      **       OPENS THE OVSH_DET2 CURSOR                             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7300-OPEN-OVSH-DET2.                                             
                                                                        
           MOVE '7300'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                OPEN OVSH_DET2                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'OPEN OVSH DET2 ERROR'    TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7350-FETCH-OVSH-DET.                                        **        
      **                                                              **        
      **      FETCHES THE REQUIRED COLUMNS FROM CSS_OVERSHORT_DET     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7350-FETCH-OVSH-DET2.                                            
                                                                        
           MOVE '7350'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               FETCH OVSH_DET2                                          
               INTO :OD-CASH-COMPANY-NO,                                
                    :OD-CASH-LOCAL-OFFICE,                              
                    :OD-DATE-CASH-REPORT,                               
                    :OD-CASH-DRAWER-ID,                                 
                    :OD-OVERSHORT-ID,                                   
                    :OD-OVERSHORT-SEQ-NO,                               
                    :OD-OFST-OVERSHORT-AMT,                             
                    :OD-OFST-DR-CR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET END-OF-DETAIL TO TRUE                                 
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'FETCH OVSH DET2 ERROR'   TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF END-IF.                                               
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7380-CLOSE-OVSH-DET2.                                       **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7380-CLOSE-OVSH-DET2.                                            
                                                                        
           MOVE '7380'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                CLOSE OVSH_DET2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'CLOSE OVSH DET2 ERROR'   TO WS-ERR-MSG              
RLS           DISPLAY WS-DISP-RC, '  WS-ACTIVE-RETURN-CODE  '           
              DISPLAY '********************************'                
              DISPLAY '** PROCESSING ERROR           **'                
              DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH            
              DISPLAY '** ', WS-ERR-MSG                                 
              DISPLAY '** SQLCODE = ', WS-DISP-RC                       
              DISPLAY '** PROCESSING TERMINATED      **'                
              DISPLAY '********************************'                
RLS   *       PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT                     
           END-IF.                                                      
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  7400-SELECT-OVSH-DESC.                                      **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7400-SELECT-OVSH-DESC.                                           
                                                                        
           MOVE '7400'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE '01'                         TO WS-SYSIN-COMP-NO.       
                                                                        
           EXEC SQL                                                     
               SELECT OVERSHORT_TYPE_DSC                                
                 INTO  :OT-OVERSHORT-TYPE-DSC                           
                 FROM  CSS_OVERSHORT_TYPE                               
                WHERE  OVERSHORT_TYPE_CD = :OH-OVERSHORT-TYPE-CD        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO WS-DISP-RC              
              MOVE 'SELECT ERROR CSS_OVERSHORT_TYPE '                   
                                             TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7450-GET-COMP-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7                                     
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSRP233 ************'           
               DISPLAY 'ERROR IN 7450-GET-COMP-DESC'                    
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'CASH COMPANY NO  ', C7-COMPANY-NO               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP233 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINES IF WE ARE PROCESS SCEG/PSNC OR SEB                           
      ******************************************************************        
       7500-CALL-DELIQUENCY.                                            
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY                                  
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSRP233 ************'           
               DISPLAY 'ERROR IN 7500-CALL-DELINQUENCY'                 
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP233 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * CPD00038  76XX-                                               *         
      *****************************************************************         
      *                                                                 00626000
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * GETS THE LOCAL OFFICE DESCRIPTION FOR THE CASH LOCAL OFFICE AND         
      * CASH COMPANY NO.                                                        
      ******************************************************************        
      *                                                                         
       7700-GET-LOCOFF-DESC.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT CASH_LOC_OFF_DESC                                  
                INTO :Y2-CASH-LOC-OFF-DESC                              
                FROM CSS_CASHIER_OFFICE Y2                              
               WHERE Y2.CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE       
                 AND Y2.CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSRP233 ************'           
               DISPLAY 'ERROR IN 7700-GET-LOCOFF-DESC'                  
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'CASH LOCAL OFFICE', Y2-CASH-LOCAL-OFFICE        
               DISPLAY 'CASH COMPANY NO  ', Y2-CASH-COMPANY-NO          
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP233 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF OH-CASH-LOCAL-OFFICE NOT = WS-SAVE-CASH-OFFICE            
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                             THRU 8500-EXIT             
              MOVE OH-CASH-LOCAL-OFFICE      TO WS-SAVE-CASH-OFFICE     
           END-IF.                                                      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                             THRU 8500-EXIT             
           END-IF.                                                      
                                                                        
           IF REPORT-LINE1                                              
              PERFORM 8200-WRITE-DETAIL      THRU 8200-EXIT             
           ELSE                                                         
              PERFORM 8300-WRITE-DETAIL      THRU 8300-EXIT             
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-NO-DATA-LINE              TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8200-WRITE-DETAIL.                                          **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8200-WRITE-DETAIL.                                               
                                                                        
           MOVE '8200'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE WS-RPT-HEADER-5              TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
           MOVE WS-RPT-DETAIL-LINE-1         TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
           MOVE WS-MSG-LINE                  TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
           IF OH-TRAN-COMMENT-LEN > 130                                 
              MOVE OH-TRAN-COMMENT-TEXT(131:80)                         
                                             TO WS-RPT-MSG-OVSH         
              MOVE WS-MSG-LINE               TO PRT33-RECORD            
              ADD  WS-1                      TO WS-LINE-COUNT           
              PERFORM 8900-PRINT-RPT-DETAIL  THRU 8900-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-WRITE-DETAIL.                                          **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-WRITE-DETAIL.                                               
                                                                        
           MOVE '8300'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE WS-RPT-DETAIL-LINE-1         TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8450-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8450-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8450'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF FIRST-TIME                                                
              PERFORM 8100-PRINT-RPT-NO-DATA THRU 8100-EXIT             
              GO TO 8450-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE    WS-RPT-HEADER-8           TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE WS-TOT-OVSH-AMT              TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-AMT              TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-HEADER-8           TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0100 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530100          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530100          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0200 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530200          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530200          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0300 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530300          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530300          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0400 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530400          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530400          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0500 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530500          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530500          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0600 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530600          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530600          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0700 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530700          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530700          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '253.0800 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-2530800          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-2530800          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
T31289     MOVE '253.0900 ='                 TO WS-RPT-GL.              
T31289     MOVE WS-TOT-OVSH-2530900          TO WS-RPT-TOT-OVSH.        
T31289     MOVE WS-TOT-OFST-2530900          TO WS-RPT-TOT-OFST.        
T31289     MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
T31289     PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
T31289     ADD WS-1                          TO WS-LINE-COUNT.          
T31289                                                                  
           MOVE '143.2000 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-1432000          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-1432000          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '143.3000 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-1433000          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-1433000          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE '143.4000 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-1434000          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-1434000          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
T30257     MOVE '143.6000 ='                 TO WS-RPT-GL.              
T30257     MOVE WS-TOT-OVSH-1436000          TO WS-RPT-TOT-OVSH.        
T30257     MOVE WS-TOT-OFST-1436000          TO WS-RPT-TOT-OFST.        
T30257     MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
T30257     PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
T30257     ADD WS-1                          TO WS-LINE-COUNT.          
T30257                                                                  
T31289     MOVE '143.8000 ='                 TO WS-RPT-GL.              
T31289     MOVE WS-TOT-OVSH-1438000          TO WS-RPT-TOT-OVSH.        
T31289     MOVE WS-TOT-OFST-1438000          TO WS-RPT-TOT-OFST.        
T31289     MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
T31289     PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
T31289     ADD WS-1                          TO WS-LINE-COUNT.          
T31289                                                                  
           MOVE '184.6000 ='                 TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-1846000          TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-1846000          TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           COMPUTE WS-TOT-OVSH-AMT = WS-TOT-OVSH-2530100 +              
                                     WS-TOT-OVSH-2530200 +              
                                     WS-TOT-OVSH-2530300 +              
                                     WS-TOT-OVSH-2530400 +              
                                     WS-TOT-OVSH-2530500 +              
                                     WS-TOT-OVSH-2530600 +              
                                     WS-TOT-OVSH-2530700 +              
                                     WS-TOT-OVSH-1432000 +              
                                     WS-TOT-OVSH-1433000 +              
                                     WS-TOT-OVSH-1434000 +              
T30257                               WS-TOT-OVSH-1436000 +              
T31289                               WS-TOT-OVSH-1438000 +              
T31289                               WS-TOT-OVSH-2530900 +              
                                     WS-TOT-OVSH-1846000.               
           COMPUTE WS-TOT-OFST-AMT = WS-TOT-OFST-2530100 +              
                                     WS-TOT-OFST-2530200 +              
                                     WS-TOT-OFST-2530300 +              
                                     WS-TOT-OFST-2530400 +              
                                     WS-TOT-OFST-2530500 +              
                                     WS-TOT-OFST-2530600 +              
                                     WS-TOT-OFST-2530700 +              
                                     WS-TOT-OFST-1432000 +              
                                     WS-TOT-OFST-1433000 +              
                                     WS-TOT-OFST-1434000 +              
T30257                               WS-TOT-OFST-1436000 +              
T31289                               WS-TOT-OFST-1438000 +              
T31289                               WS-TOT-OFST-2530900 +              
                                     WS-TOT-OFST-1846000.               
                                                                        
           MOVE    WS-RPT-HEADER-8           TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE SPACES                       TO WS-RPT-GL.              
           MOVE WS-TOT-OVSH-AMT              TO WS-RPT-TOT-OVSH.        
           MOVE WS-TOT-OFST-AMT              TO WS-RPT-TOT-OFST.        
           MOVE WS-TOT-LINE                  TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE WS-FOOTER                    TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
      *    PRINTS COMPANY NAME                                                  
                                                                        
           ADD WS-1                          TO WS-PAGE-COUNT.          
           MOVE WS-PAGE-COUNT                TO P-RPT-PAGE-NO.          
           MOVE WS-REPTNAME                  TO P-RPT-TITLE-PGNM.       
           MOVE OH-CASH-LOCAL-OFFICE         TO WS-RPT-LOC-OFFICE,      
                                                Y2-CASH-LOCAL-OFFICE.   
           MOVE C7-COMPANY-NO                TO Y2-CASH-COMPANY-NO.     
           IF NOT-FIRST-TIME                                            
              PERFORM 7700-GET-LOCOFF-DESC   THRU 7700-EXIT             
           END-IF.                                                      
           MOVE Y2-CASH-LOC-OFF-DESC         TO WS-CASH-LOC-OFF-DESC.   
           IF PROCESS-SEB                                               
              MOVE ' SCANA-ENERGY '          TO P-RPT-COMP-NAME         
           END-IF.                                                      
                                                                        
      *    PRINTS FOOTER IF NEEDED                                              
                                                                        
           IF WS-SAVE-CASH-OFFICE > '000'                               
              MOVE    WS-RPT-HEADER-8        TO PRT33-RECORD            
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
                                                                        
      *    PRINTS REPORT TITLE                                                  
                                                                        
           MOVE    WS-RPT-HEADER-1           TO PRT33-RECORD.           
           WRITE PRT33-RECORD AFTER ADVANCING TOP-OF-PAGE.              
                                                                        
           MOVE    WS-RPT-HEADER-2           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-3           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-4           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-5           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-6           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-7           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-8           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
           MOVE WS-8                         TO WS-LINE-COUNT.          
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8900-PRINT-RPT-DETAIL.                                      **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8900-PRINT-RPT-DETAIL.                                           
                                                                        
           MOVE '8900'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              MOVE PRT33-RECORD              TO WS-SAVE-PRT33           
              PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
              MOVE WS-SAVE-PRT33             TO PRT33-RECORD            
              WRITE PRT33-RECORD                                        
              MOVE WS-1                      TO WS-LINE-COUNT           
           ELSE                                                         
              WRITE PRT33-RECORD                                        
              MOVE WS-LINE-COUNT             TO WS-TEMP-COUNT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           PERFORM 7180-CLOSE-OVSH-HDR                                  
              THRU 7180-EXIT.                                           
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY WS-DISP-RC, '  WS-ACTIVE-RETURN-CODE  '.             
           DISPLAY '********************************'.                  
           DISPLAY '** PROCESSING ERROR           **'.                  
           DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH.              
           DISPLAY '** ', WS-ERR-MSG.                                   
           DISPLAY '** SQLCODE = ', WS-DISP-RC.                         
           DISPLAY '** PROCESSING TERMINATED      **'.                  
           DISPLAY '********************************'.                  
           PERFORM 9900-ABEND                THRU 9900-EXIT.            
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9300-SYSIN-DATA-ERROR                                       **        
      **       SYSIN DATA NOT FOUND                                   **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9300-SYSIN-DATA-ERROR.                                           
                                                                        
           DISPLAY '**   PROCESSING SYSIN ERR **'.                      
           DISPLAY '****************************'.                      
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   PROCESSING TERMINATED **'.                     
           DISPLAY '*****************************'.                     
           PERFORM 9900-ABEND                THRU 9900-EXIT.            
                                                                        
       9300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **COPYBOOK FOR ABEND ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
