       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP226.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. SEP-2001.                                          
      *****************************************************************         
      *               SOUTH CAROLINA ELECTRIC & GAS                   *         
      **                                                             **         
      *****************************************************************         
      ********        CUSTOMER INFORMATION  SYSTEM            *********         
      *****************************************************************         
      **                   P R O G R A M S U M M A R Y               **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **  GENERATE A REPORT FOR ALL PSNC INDUSTRIAL ACCOUNTS WHO ARE **         
      **  NEGOTIATING FOR THIS REVENUE MONTH. PRIOR TO BILLING.      **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS         REASON                      **         
      **    ======      =========        =======                     **         
      **   09/24/2001   COVANSYS         NEW REPORT PROGRAM          **         
      **                CHENNAI                                      **         
T25836**   01/08/2002   COVANSYS         CHANGED PROGRAM TO ADD      **         
T25836**                                 COMMENT AT THE END OF THE   **         
T25836**                                 REPORT                      **         
C25864**   01/11/02     SR82046          INCREASED THE FILED LENGTH  **         
      **                                 OF THERMS AND D.THERMS      **         
C25953**   01/29/02     SR82046          CHANGED TO SCHEDULE THE JOB **         
      **                                 DAILY BUT PRINT THE REPORT  **         
      **                                 ONLY AFTER END OF MONTH     **         
      **                                 READINGS POSTED.            **         
C25981**   02/01/02     SR82046          ADDED LOGIC TO SUBTRACT THE **         
      **                                 CCF FOR THE METERS THAT HAVE**         
      **                                 CODE-DEBIT 'C'              **         
C25991**   02/05/02     SR82046          ADDED LOGIC TO INCLUDE CUST **         
      **                                 NAME AND ALT FUEL CODE IN THE*         
      **                                 REPORT.                     **         
      **                                                             **         
31443 ** 26 AUG 2004  RDF         TAKE OUT DATE CHECK COMPARE FOR    **         
      **                          BN-DATE-EXTRACT.  JOB HAS BEEN     **         
      **                          RESCHEDULED TO RUN ONCE A MONTH ON **         
      **                          OPENING OF CYCLE 20, INSTEAD OF    **         
      **                          EVERYDAY.                          **         
      **                                                             **         
T35434** 10 MAY 2007  MK92804     REPLACED MODEL_SQL WITH SET COMMAND**         
T35434**                          AND ADDED FETCH ONLY WITH UR FOR   **         
T35434**                          -911.                              **         
T35465** 30 MAY 2007  PC97415     FLAG WS-NAME-ONLY-SW IS SET FOR    **         
T35465**                          CPD00074                           **         
A05460** 06/03/16  MR7E794    REPLACE THE DUPLICATE FIELD WS-C AND              
A05460**           ACT188     REMOVED THE UNUSED COPYBOOKS AND CODE.            
A05460** 08/30/16  DB41297    REPLACE THE DUPLICATE FIELD WS-A.                 
A05460**           ACT188                                                       
      *****************************************************************         
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP226'.
MSQ017     COPY MFASQLM.
       01  WS-START                          PIC X(40) VALUE            
           'WORKING STORAGE FOR PCSRP226 STARTS HERE'.                  
                                                                        
       01  WS-BTU-FACTOR-DATA.                                          
           03  WS-BTU-FACTOR-ITEM                                       
                  OCCURS 800 TIMES                                      
                  DESCENDING KEY WS-BTU-DT                              
                  INDEXED BY BTU-INDX BTU-INDX2.                        
             05  WS-BTU-DT                   PIC X(10).                 
COB305       05 WS-MMBTU-TOTAL        PIC S9(7) COMP-3 VALUE 0.          
COB305       05 WS-MCF-TOTAL        PIC S9(7) COMP-3 VALUE 0.          
             05  WS-COMPANY-NO-TF            PIC X(2).                  
                                                                        
       01  WS-BTU-HIGH-HIT-FACTORS.                                     
           03  WS-BTU-HIGH-HIT-ITEM                                     
                  OCCURS 15 TIMES                                       
                  INDEXED BY HH-INDX.                                   
             05  WS-HH-READ-DATE             PIC X(10).                 
             05  WS-HH-READ-DAYS             PIC 9(2).                  
COB305       05 WS-HH-BTU-FACTOR        PIC S9(2)V9(5) COMP-3 VALUE 0.     
                                                                        
       01 WS-MISC.                                                      
             05  WS-CCF                      PIC S9(9)V USAGE COMP-3    
                                                       VALUE ZERO.      
             05  WS-WORK-FROM-DATE           PIC X(10) VALUE SPACES.    
             05  WS-WORK-DATE                PIC X(10) VALUE SPACES.    
             05  WS-BC-CURRENT-DATE          PIC X(10) VALUE SPACES.    
             05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.    
             05  WS-MONTH                    PIC 9(02) VALUE ZERO.      
             05  WS-COMP-NAME                PIC X(26) VALUE SPACES.    
             05  WS-CALC-ERROR               PIC X(8)  VALUE SPACES.    
             05  WS-MAX-LINES                PIC 9(02) VALUE 56.        
             05  WS-LINE-COUNT               PIC 9(02) VALUE 57.        
             05  WS-PAGE-COUNT               PIC 9(03) VALUE ZERO.      
             05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSRP226'.
             05  WS-PGMNAME                  PIC X(08) VALUE 'PCSRP226'.
C25953       05  WS-COMMON                   PIC X(06) VALUE 'COMMON'.  
             05  WS-ERR-MSG                  PIC X(40) VALUE SPACES.    
             05  WS-DISP-RC                  PIC -ZZZZZZZZ9.9.          
             05  WS-NULL-IND                 PIC S9(04) COMP.           
                                                                        
             05 WS-NO-UNITS              PIC S9(9)   VALUE 0.           
                                                                        
             05 WS-ACCOUNT-NO.                                          
                10 WS-ACCOUNT-NO-P1          PIC X(01)  VALUE ZERO.     
                10 FILLER                    PIC X(01)  VALUE '-'.      
                10 WS-ACCOUNT-NO-P2          PIC X(04)  VALUE ZEROES.   
                10 FILLER                    PIC X(01)  VALUE '-'.      
                10 WS-ACCOUNT-NO-P3          PIC X(04)  VALUE ZEROES.   
                10 FILLER                    PIC X(01)  VALUE '-'.      
                10 WS-ACCOUNT-NO-P4          PIC X(04)  VALUE ZEROES.   
             05 WS-ACCOUNT-NO-X              PIC X(13)  VALUE SPACES.   
C25991       05 PROGRAM-NAME                 PIC X(8)   VALUE           
C25991                                                 'PCSRP226'.      
C25991       05 RS-RETURN-CODE               PIC S9(9)  VALUE           
C25991          +000 COMP.                                              
C25991       05 RS-RETURN-CODE-DISP          PIC S9(9)  VALUE           
C25991          +000 COMP.                                              
                                                                        
       01 WS-BTU-FACTOR-VAR.                                            
             05  WS-BC-BTU-FACTOR-BG         PIC S9(2)V9(5) USAGE       
                                                 COMP-3 VALUE ZERO.     
             05  WS-NO-BTU-FACTOR            PIC X(8)  VALUE 'BC0032'.  
             05  WS-NO-OF-CNSMPTN-DAYS-ACCUM PIC S9(4) COMP             
                                                       VALUE ZERO.      
C25981       05  WS-THERMS                   PIC S9(9)V COMP-3          
                                                       VALUE ZERO.      
C25864       05  WS-DEKATHERMS               PIC S9(9) VALUE ZERO.      
             05  WS-BTU-FACTOR               PIC S9V9(3) COMP-3         
                                                       VALUE ZERO.      
COB305       05 WS-SUM-MMBTU-TOTAL        PIC S9(15)V USAGE  COMP-3 
COB305       VALUE 0. 
COB305       05 WS-SUM-MCF-TOTAL        PIC S9(15)V USAGE  COMP-3 
COB305       VALUE 0. 
             05  WS-HOLD-MMBTU-TOTAL         PIC S9(9) COMP-3           
                                                       VALUE ZERO.      
             05  WS-HOLD-MCF-TOTAL           PIC S9(9) COMP-3           
                                                       VALUE ZERO.      
       01 WS-REVENU-MONTH.                                              
             05  WS-CUR-REV-MON.                                        
                 10  WS-REV-CCYY             PIC 9(04).                 
                 10  WS-REV-MM               PIC 9(02).                 
             05  WS-CUR-REV-MON-CR      REDEFINES WS-CUR-REV-MON        
                                             PIC 9(06).                 
             05  WS-CUR-REV-MON-MIN.                                    
                 10  WS-REV-CCYY-MIN         PIC 9(04).                 
                 10  WS-REV-MM-MIN           PIC 9(02).                 
             05  WS-CUR-REV-MON-CR-MIN  REDEFINES WS-CUR-REV-MON-MIN    
                                             PIC 9(06).                 
COB305       05 WS-CUR-REV-MON-NUM        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.   
COB305       05 WS-CUR-REV-MON-MIN-NUM        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.   
COB305       05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.   
                                                                        
       01 WS-START-END-MONTH.                                           
      *                                                                         
          05  WS-COMM-DATE.                                             
              10  WS-COMM-CCYY.                                         
                  15  WS-COMM-CC            PIC X(02)  VALUE SPACES.    
                  15  WS-COMM-YY            PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE SPACES.    
              10  WS-COMM-MM                PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE SPACES.    
              10  WS-COMM-DD                PIC X(02)  VALUE SPACES.    
      *                                                                         
          05 WS-PARM-COMMON-DATE            PIC X(10)  VALUE SPACES.    
             05 WS-FROM-DATE.                                           
                 10 WS-FROM-CCYY             PIC 9(04).                 
                 10 FILLER                   PIC X(01) VALUE '-'.       
                 10 WS-FROM-MM               PIC 9(02).                 
                 10 FILLER                   PIC X(01) VALUE '-'.       
                 10 WS-FROM-DD               PIC 9(02).                 
             05 WS-TO-DATE.                                             
                 10 WS-TO-CCYY               PIC 9(04).                 
                 10 FILLER                   PIC X(01) VALUE '-'.       
                 10 WS-TO-MM                 PIC 9(02).                 
                 10 FILLER                   PIC X(01) VALUE '-'.       
                 10 WS-TO-DD                 PIC 9(02).                 
             05 WS-START-DATE                PIC X(10) VALUE SPACES.    
             05 WS-END-DATE                  PIC X(10) VALUE SPACES.    
             05 WS-RUN-DATE                  PIC X(10) VALUE SPACES.    
C25864       05 WS-RUN-DATE-TEMP.                                       
C25864          10 WS-DATE-CCYY              PIC X(04) VALUE SPACES.    
C25864          10 FILLER                    PIC X(01) VALUE '-'.       
C25864          10 WS-DATE-MM                PIC X(02) VALUE SPACES.    
C25864          10 FILLER                    PIC X(01) VALUE '-'.       
C25864          10 WS-DATE-DD                PIC X(02) VALUE SPACES.    
      *                                                                         
             05 WS-PREV-READ-DT1             PIC X(10).                 
             05 WS-CURR-READ-DT1             PIC X(10).                 
           05 WS-PREV-READ-DT.                                          
              10 WS-PREV-READ-YYYY.                                     
                15 WS-PREV-READ-CC     PIC 99.                          
                15 WS-PREV-READ-YY     PIC 99.                          
              10 WS-F1                 PIC X       VALUE  '-'.          
              10 WS-PREV-READ-MN       PIC 99.                          
              10 WS-F2                 PIC X       VALUE   '-'.         
              10 WS-PREV-READ-DD       PIC 99.                          
           05 WS-CURR-READ-DT.                                          
              10 WS-CURR-READ-YYYY.                                     
                15 WS-CURR-READ-CC     PIC 99.                          
                15 WS-CURR-READ-YY     PIC 99.                          
              10 WS-F3                 PIC X       VALUE '-'.           
              10 WS-CURR-READ-MN       PIC 99.                          
              10 WS-F4                 PIC X       VALUE '-'.           
              10 WS-CURR-READ-DD       PIC 99.                          
           05 WS-RTD-RD-DT             PIC X(10).                       
           05 WS-PRV-RD-DT             PIC X(10).                       
COB305     05 WS-SUM-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.         
           05 WS-SUM-NO-DAYS           PIC S9(04) COMP VALUE 0.         
           05 WS-PREV-READ-DT-TEMP     PIC X(10).                       
           05 WS-CURR-READ-DT-TEMP     PIC X(10).                       
                                                                        
       01 WS-LITERALS.                                                  
             05 WS-D                         PIC X(01) VALUE 'D'.       
             05 WS-N                         PIC X(01) VALUE 'N'.       
             05 WS-Y                         PIC X(01) VALUE 'Y'.       
             05 WS-G                         PIC X(01) VALUE 'G'.       
             05 WS-DEFAULT-COMP              PIC X(02) VALUE '26'.      
             05 WS-01                        PIC 9(02) VALUE 01.        
             05 WS-20                        PIC X(02) VALUE '20'.      
             05 WS-29                        PIC 9(02) VALUE 29.        
             05 WS-30                        PIC 9(02) VALUE 30.        
             05 WS-31                        PIC 9(02) VALUE 31.        
             05 WS-ZERO                      PIC 9(02) VALUE 00.        
             05 WS-ONE                       PIC 9(02) VALUE 01.        
             05 WS-ONE1                      PIC 9(03) VALUE 000.       
                                                                        
        01 WS-SWITCHES.                                                 
             05 WS-FILE-STATUS               PIC X(02).                 
                88 SUCCESSFUL                          VALUE '00'.      
                                                                        
             05 WS-FIRST-TIME                PIC X(01) VALUE 'Y'.       
                88 FIRST-TIME                          VALUE 'Y'.       
                88 NOT-FIRST-TIME                      VALUE 'N'.       
                                                                        
             05 WS-RECORD-FOUND              PIC X(01) VALUE 'N'.       
                88 RECORD-FOUND                        VALUE 'Y'.       
                88 NOT-RECORD-FOUND                    VALUE 'N'.       
                                                                        
           05  WS-PARM-EXIST                 PIC X(01) VALUE 'Y'.       
               88  PARM-EXISTS                         VALUE 'Y'.       
               88  PARM-DOES-NOT-EXIST                 VALUE 'N'.       
                                                                        
           05  WS-MTR-READ-FLAG              PIC X(01) VALUE 'N'.       
               88  MTR-READ-PRESENT                    VALUE 'N'.       
               88  MTR-RD-MISSING                      VALUE 'Y'.       
                                                                        
        01  WS-HEADING-LINES.                                           
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
             05 WS-RPT-TITLE-1.                                         
                 10  FILLER                  PIC X(02) VALUE SPACES.    
                 10  FILLER                  PIC X(08) VALUE 'PCSR2261'.
      *          10  P-RPT-TITLE-PGNM        PIC X(08).                         
HEX01            10  FILLER                  PIC X(01) VALUE X'09'.     
C25991*          10  FILLER                  PIC X(35) VALUE SPACES.            
                 10  P-RPT-COMP-NAME         PIC X(26).                 
HEX01            10  FILLER                  PIC X(01) VALUE X'09'.     
C25991*          10  FILLER                  PIC X(43) VALUE SPACES.            
                 10  FILLER                  PIC X(09) VALUE            
                                                       'RUN-DATE:'.     
                 10  P-RPT-RUN-MM            PIC X(02).                 
                 10  FILLER                  PIC X(01) VALUE '/'.       
                 10  P-RPT-RUN-DD            PIC X(02).                 
                 10  FILLER                  PIC X(01) VALUE '/'.       
                 10  P-RPT-RUN-YY            PIC X(02).                 
                 10  FILLER                  PIC X(03) VALUE SPACES.    
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
             05 WS-RPT-TITLE-2.                                         
C25991*          10 FILLER                   PIC X(50)  VALUE SPACES.           
C25991           10 FILLER                   PIC X(02)  VALUE SPACES.   
C29551           10 FILLER                   PIC X(35)  VALUE           
                      'RATE 160 - CONSUMPTION REPORT'.                  
HEX01            10 FILLER                   PIC X(01)  VALUE X'09'.    
C25991*          10 FILLER                   PIC X(30)  VALUE SPACES.           
                 10 FILLER                   PIC X(09)  VALUE           
                                                       'RUN TIME:'.     
                 10 WS-REP-HH                PIC X(02).                 
                 10 FILLER                   PIC X(01)  VALUE ':'.      
                 10 WS-REP-MIN               PIC X(02).                 
                 10 FILLER                   PIC X(01)  VALUE ':'.      
                 10 WS-REP-SS                 PIC X(02).                
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
             05 WS-RPT-TITLE-3.                                         
C25991*          10 FILLER                    PIC X(57)  VALUE SPACES.          
C25991           10 FILLER                    PIC X(02)  VALUE SPACES.  
                 10 WS-RPT-MONTH              PIC X(10).                
                 10 FILLER                    PIC X(01)  VALUE SPACES.  
                 10 WS-REP-YEAR               PIC X(04).                
                 10 FILLER                    PIC X(44)  VALUE SPACES.  
                 10 FILLER                    PIC X(09)  VALUE          
                                                       'PAGE    :'.     
                 10 FILLER                    PIC X(05)  VALUE SPACES.  
                 10 WS-REP-PAGE               PIC ZZ9.                  
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER0.       **           
      ***************************************************************           
             05 WS-RPT-HEADER-0.                                        
                 10 FILLER                    PIC X(133) VALUE ALL '-'. 
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER1.       **           
      ***************************************************************           
             05 WS-RPT-HEADER-1.                                        
                 10 FILLER                    PIC X(02)  VALUE SPACES.  
C25991           10 FILLER                    PIC X(16)  VALUE          
C25991                    'CUSTOMER NAME   '.                           
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(11)  VALUE SPACES.          
                 10 FILLER                    PIC X(11)  VALUE          
                          'ACCOUNT NO '.                                
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
      *          10 FILLER                    PIC X(05)  VALUE SPACES.          
C25991           10 FILLER                    PIC X(16)  VALUE          
C25991                    '  ALTERNATE FUEL'.                           
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(21)  VALUE SPACES.          
                 10 FILLER                    PIC X(06)  VALUE          
                          '   CCF'.                                     
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
      *          10 FILLER                    PIC X(08)  VALUE SPACES.          
                 10 FILLER                    PIC X(07)  VALUE          
                          '   BTU '.                                    
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
      *          10 FILLER                    PIC X(08)  VALUE SPACES.          
                 10 FILLER                    PIC X(07)  VALUE          
                          'THERMS '.                                    
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
                 10 FILLER                    PIC X(13)  VALUE          
                          '   DEKATHERMS'.                              
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
             05  WS-BLANK-LINE.                                         
                 10 FILLER                    PIC X(133) VALUE SPACES.  
                                                                        
      ***************************************************************           
                                                                        
        01 WS-DETAIL-LINE1.                                             
             05 WS-DETAIL-LINE-1.                                       
                 10 FILLER                    PIC X(02)  VALUE SPACES.  
C25991           10 WS-CUST-NAME              PIC X(25).                
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(02)  VALUE SPACES.          
                 10 P-RPT-ACCT-NO             PIC X(16).                
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(02)  VALUE SPACES.          
C25991           10 P-RPT-FUEL-CD             PIC X(25).                
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(04)  VALUE SPACES.          
C25981           10 P-RPT-CCF                 PIC ZZ,ZZZ,ZZ9.           
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(02)  VALUE SPACES.          
                 10 P-RPT-BTU                 PIC ZZZZZ9.999.           
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
      *          10 FILLER                    PIC X(04)  VALUE SPACES.          
C25981           10 P-RPT-THERM               PIC ZZZ,ZZZ,ZZ9.          
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
C25991*          10 FILLER                    PIC X(02)  VALUE SPACES.          
C25864           10 P-RPT-DEKATHERMS          PIC ZZZ,ZZZ,ZZ9.          
HEX01            10 FILLER                    PIC X(01)  VALUE X'09'.   
                                                                        
        01  WS-NO-DATA-LINE.                                            
             05 FILLER                        PIC X(48)  VALUE SPACES.  
             05 FILLER                        PIC X(31)  VALUE          
                 '**** NO DATA FOR THIS RUN  ****'.                     
             05 FILLER                        PIC X(50)  VALUE SPACES.  
                                                                        
       01  WS-FOOTER1.                                                  
             05 FILLER                        PIC X(35)  VALUE SPACES.  
             05 FILLER                        PIC X(25)  VALUE          
                 '* * * END OF REPORT * * *'.                           
             05 FILLER                        PIC X(72)  VALUE SPACES.  
                                                                        
T25836 01  WS-COMMENT-FTR.                                              
T25836       05 FILLER                        PIC X(5)  VALUE SPACES.   
T25836       05 FILLER                        PIC X(98)  VALUE          
T25836          'THIS REPORT IS PRODUCED BEFORE BILLING AND, THEREFORE,         
T25836-         'WILL NOT MATCH THE END OF THE MONTH REVENUE'.                  
T25836       05 FILLER                        PIC X(30)  VALUE SPACES.  
C25991 01  WS-COMMENT-FTR1.                                             
C25991       05 FILLER                        PIC X(5)  VALUE SPACES.   
C25991       05 FILLER                        PIC X(85)  VALUE          
C25991          'ZERO COMSUMPTION MOST LIKELY INDICATES THAT METER READI        
C25991-         'NGS ARE MISSING FOR AN ACCOUNT'.                               
C25991       05 FILLER                        PIC X(43)  VALUE SPACES.  
                                                                        
       01  WS-CURRENT-DATE-ONE.                                         
             05  WS-CURRENT-YY                PIC 9(02).                
             05  WS-CURRENT-MM                PIC 9(02).                
             05  WS-CURRENT-DD                PIC 9(02).                
                                                                        
       01  WS-CURRENT-TIME                    PIC 9(08).                
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
         COPY CWS00038.                                                         
         COPY CWS00114.                                                         
         COPY CWS00039.                                                         
         COPY CWS09900.                                                         
         COPY CWS00303.                                                         
         COPY CWS00150.                                                         
         COPY FIOJC01.                                                          
         COPY FIOCA00.                                                          
C25991* -- USED BY CPD00074. CREATE MAIL NAME AND ADDRESS                       
C25991 COPY CWS00074.                                                           
C25991* -- USED BY CPD00004                                                     
C25991* WORKING STORAGE AREA USED TO REDUCE EMBEDDED BLANKS                     
C25991 COPY CWS00011.                                                           
C25991* -- USED BY CPD0303B                                                     
C25991* WS ABEND WORK AREA                                                      
C25991 COPY CWS00010.                                                           
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CONTRACT                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCNTR                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CNSMPTN_HIST                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_JOB_PARM                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BTU_FACTOR                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBTUFCT                                                
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *       DECLARATION FOR CSS_BILL_WINDOW                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *       DECLARATION FOR CSS_BILLING_HDR                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *       DECLARATION FOR CSS_BILLING_DET                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *       DECLARATION FOR CSS_READ_WINDOW                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_ALTN_FUEL_TYPE                      *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBALTFUL                                                  
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_NAME                                *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBNAME                                                    
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR  CSS_NAME_ACCT_XREF                     *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBNMACTX                                                  
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_CUST_ADDR_XREF                      *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBCSADRX                                                  
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_ADDR_FREEFORM                       *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBADRFRE                                                  
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_ADDR_FORMATTED                      *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBADRFMT                                                  
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_ZIP_CODE                            *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBZIPCD                                                   
C25991     END-EXEC.                                                            
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991*       DECLARATION FOR CSS_ACCT_MISC_INFO                      *         
C25991*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C25991     EXEC SQL                                                             
C25991        INCLUDE TBATMISC                                                  
C25991     END-EXEC.                                                            
      *----------------------------------------------------------------*        
      *CURSOR FOR FETCHING INDUSTRIAL ACCOUNT NEGOTIATING REVENUE MONTH*        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
            DECLARE CON_CUR CURSOR FOR                                  
              SELECT AT.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
                     AT.CODE_MAJOR_ACCT,                                
C25991               AT.ADDRESS_ID,                                     
                     BK.CODE_UTIL_TYPE,                                 
                     BK.IC_NO,                                          
                     BK.CNTRCT_START_DT,                                
                     BK.CNTRCT_END_DT,                                  
                     BK.DFLT_USAGE_CLS_CD                               
              FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
              WHERE  AT.ACCOUNT_NO         = BK.ACCOUNT_NO              
                AND  BK.CNTRCT_START_DT    =                            
                      (SELECT MAX(BK.CNTRCT_START_DT)                   
                        FROM  CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)        
                        WHERE BK.CNTRCT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )        
                          AND BK.CNTRCT_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )        
                          AND BK.ACCOUNT_NO    = AT.ACCOUNT_NO)         
                AND  BK.CNTRCT_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )               
                AND  AT.COMPANY_NO         = :C7-COMPANY-NO             
                AND  AT.CODE_MAJOR_ACCT    = :WS-Y                      
                AND  BK.DFLT_USAGE_CLS_CD  = :WS-N                      
T35434          FOR READ ONLY                                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CON_CUR CURSOR FOR                                          
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.CODE_MAJOR_ACCT,                                        
MFA-TR*              AT.ADDRESS_ID,                                             
MFA-TR*              BK.CODE_UTIL_TYPE,                                         
MFA-TR*              BK.IC_NO,                                                  
MFA-TR*              BK.CNTRCT_START_DT,                                        
MFA-TR*              BK.CNTRCT_END_DT,                                          
MFA-TR*              BK.DFLT_USAGE_CLS_CD                                       
MFA-TR*       FROM   CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_BILL_CONTRACT BK                                       
MFA-TR*       WHERE  AT.ACCOUNT_NO         = BK.ACCOUNT_NO                      
MFA-TR*         AND  BK.CNTRCT_START_DT    =                                    
MFA-TR*               (SELECT MAX(BK.CNTRCT_START_DT)                           
MFA-TR*                 FROM  CSS_BILL_CONTRACT BK                              
MFA-TR*                 WHERE BK.CNTRCT_START_DT <= :WS-RUN-DATE                
MFA-TR*                   AND BK.CNTRCT_END_DT   >= :WS-RUN-DATE                
MFA-TR*                   AND BK.ACCOUNT_NO    = AT.ACCOUNT_NO)                 
MFA-TR*         AND  BK.CNTRCT_END_DT     >= :WS-RUN-DATE                       
MFA-TR*         AND  AT.COMPANY_NO         = :C7-COMPANY-NO                     
MFA-TR*         AND  AT.CODE_MAJOR_ACCT    = :WS-Y                              
MFA-TR*         AND  BK.DFLT_USAGE_CLS_CD  = :WS-N                              
MFA-TR*         FOR  FETCH ONLY WITH UR                                         
MFA-TR*     END-EXEC.                                                           
      *                                                                         
           EXEC SQL                                                     
              DECLARE CNS_CRSR CURSOR FOR                               
               SELECT DATE_READ,                                        
                      DATEADD( DAY, -NO_DAYS, DATE_READ ),                      
                      DATEADD( DAY, -30, DATE_READ ),                           
                      NO_DAYS,                                          
                      NO_UNITS,                                         
                      BILL_NO                                           
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO      = :CX-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :WS-G                           
                  AND IC_NO           = :CX-IC-NO                       
                ORDER BY DATE_READ DESC                                 
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CNS_CRSR CURSOR FOR                                       
MFA-TR*        SELECT DATE_READ,                                                
MFA-TR*               DATE_READ - NO_DAYS DAYS,                         04092200
MFA-TR*               DATE_READ - 30 DAYS,                              04092300
MFA-TR*               NO_DAYS,                                          04092400
MFA-TR*               NO_UNITS,                                                 
MFA-TR*               BILL_NO                                                   
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO      = :CX-ACCOUNT-NO                          
MFA-TR*           AND CODE_UTIL_TYPE  = :WS-G                                   
MFA-TR*           AND IC_NO           = :CX-IC-NO                               
MFA-TR*         ORDER BY DATE_READ DESC                                         
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE BTU_SUM CURSOR FOR                                
               SELECT SUM (MMBTU_TOTAL),                                
                      SUM (MCF_TOTAL)                                   
                 FROM CSS_BTU_FACTOR WITH(READUNCOMMITTED)                      
                WHERE BTU_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                      :WS-PREV-READ-DT1
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-READ-DT1
              ) <> 0) OR (LEN(:WS-PREV-READ-DT1) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-READ-DT1
              ), CONVERT(DATE, :WS-PREV-READ-DT1) )                  
                                     AND IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURR-READ-DT1
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-READ-DT1
              ) <> 0) OR (LEN(:WS-CURR-READ-DT1) <> 10), CIS.CHAR2DATE(
                                                      :WS-CURR-READ-DT1
              ), CONVERT(DATE, :WS-CURR-READ-DT1) )              
                                     AND COMPANY_NO = :AT-COMPANY-NO    
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BTU_SUM CURSOR FOR                                        
MFA-TR*        SELECT SUM (MMBTU_TOTAL),                                        
MFA-TR*               SUM (MCF_TOTAL)                                           
MFA-TR*          FROM CSS_BTU_FACTOR                                            
MFA-TR*         WHERE BTU_DT BETWEEN :WS-PREV-READ-DT1                          
MFA-TR*                              AND :WS-CURR-READ-DT1                      
MFA-TR*                              AND COMPANY_NO = :AT-COMPANY-NO            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      *CURSOR FOR FETCHING BTU-FACTOR                                  *        
      *----------------------------------------------------------------*        
                                                                        
            EXEC SQL                                                    
              DECLARE BTU_FACTORS CURSOR FOR                            
                 SELECT BTU_DT,                                         
                        MMBTU_TOTAL,                                    
                        MCF_TOTAL                                       
                   FROM CSS_BTU_FACTOR WITH(READUNCOMMITTED)                    
                  WHERE COMPANY_NO = :TF-COMPANY-NO                     
                  ORDER BY BTU_DT DESC                                  
T35434              FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    02245000
MFA-TR*       DECLARE BTU_FACTORS CURSOR FOR                            02246000
MFA-TR*          SELECT BTU_DT,                                         02247000
MFA-TR*                 MMBTU_TOTAL,                                    02248000
MFA-TR*                 MCF_TOTAL                                       02249000
MFA-TR*            FROM CSS_BTU_FACTOR                                  02249100
MFA-TR*           WHERE COMPANY_NO = :TF-COMPANY-NO                             
MFA-TR*           ORDER BY BTU_DT DESC                                  02249200
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                   02249300
                                                                        
       01  WS-END                              PIC X(40) VALUE          
             'WORKING STORAGE FOR PCSRP226 ENDS HERE  '.                
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  WS-PARM-CARD.                                                
             05  WS-CHKBYTE                   PIC S9(04) COMP.          
             05  WS-PARM-COMPANY              PIC X(02).                
                                                                        
       PROCEDURE DIVISION USING WS-PARM-CARD.                           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000' TO  WS-ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
31443      PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
           STOP RUN.                                                    
                                                                        
      ***********************************************************               
      **                                                       **               
      **   0100-INITIALIZATION.                                **               
      **       INITIALIZATION ROUTINE                          **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                         TO  WS-ACTIVE-PARAGRAPH. 
                                                                        
      * OPEN REPORT FILE                                                        
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
      * GET CURRENT DATE                                                        
                                                                        
      *    ACCEPT WS-CURRENT-DATE-ONE          FROM DATE.                       
      *    MOVE   WS-CURRENT-YY                TO P-RPT-RUN-YY.                 
      *    MOVE   WS-CURRENT-MM                TO P-RPT-RUN-MM.                 
      *    MOVE   WS-CURRENT-DD                TO P-RPT-RUN-DD.                 
                                                                        
      * GET CURRENT TIME                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME              FROM TIME.               
           MOVE   WS-CURRENT-TIME(1:2)         TO WS-REP-HH.            
           MOVE   WS-CURRENT-TIME(3:2)         TO WS-REP-MIN.           
           MOVE   WS-CURRENT-TIME(5:2)         TO WS-REP-SS.            
                                                                        
           IF WS-PARM-COMPANY  EQUAL SPACES OR LOW-VALUES               
              MOVE WS-N                       TO WS-PARM-EXIST          
           ELSE                                                         
              MOVE WS-PARM-COMPANY            TO C7-COMPANY-NO          
           END-IF.                                                      
                                                                        
           PERFORM 0150-REVENUE-MONTH-PARA     THRU 0150-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    0150-REVENUE-MONTH-PARA.                               **           
      **                                                           **           
      ***************************************************************           
                                                                        
       0150-REVENUE-MONTH-PARA.                                         
                                                                        
             MOVE '0150'                       TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
C25953     IF COMMON-DATE-NEEDED                                        
C25953         MOVE SPACES             TO WS-SYSIPT                     
C25953         MOVE SPACES             TO WS-INPUT-DATA-BREAKDOWN       
C25953         MOVE WS-COMMON          TO WS-PROGRAM                    
C25953         MOVE WS-DATE            TO WS-COMMAND                    
C25953         MOVE ZEROS              TO WS-SEQUENCE                   
C25953         MOVE  WS-KEY-AREA       TO E-FJC01-KEY                   
C25953         PERFORM 7600-START-FCSJC01        THRU 7600-EXIT         
C25953         PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT         
C25953             UNTIL (RUN-DATE AND INPUT-ACTIVE)                    
C25953                OR  END-OF-SYSIPT                                 
C25953*                                                                         
C25953     IF END-OF-SYSIPT                                             
C25953         DISPLAY '**  PCSRP226 PROCESSING ERROR   **'             
C25953         DISPLAY '**  COMMON DATE PARM NOT ACTIVE **'             
C25953         DISPLAY '**    KEY = ' E-FJC01-KEY                       
C25953         DISPLAY '**    PROCESSING TERMINATED     **'             
C25953         PERFORM 9900-ABEND                THRU 9900-EXIT         
C25953     ELSE                                                         
C25953         IF WS-INPUT-RUN-DATE-MM NUMERIC AND                      
C25953            WS-INPUT-RUN-DATE-DD NUMERIC AND                      
C25953            WS-INPUT-RUN-DATE-CC NUMERIC AND                      
C25953            WS-INPUT-RUN-DATE-YY NUMERIC                          
C25953             MOVE WS-INPUT-RUN-DATE                               
C25953                                 TO WS-INPUT-DATE                 
C25953             PERFORM 7611-CLOSE            THRU 7611-EXIT         
C25953         ELSE                                                     
C25953             DISPLAY '**  PCSRP226 PROCESSING ERROR    **'        
C25953             DISPLAY '**  COMMON DATE PARM NOT NUMERIC **'        
C25953             DISPLAY '**    KEY = ' E-FJC01-KEY                   
C25953             DISPLAY '**     PROCESSING TERMINATED     **'        
C25953             PERFORM 9900-ABEND            THRU 9900-EXIT         
C25953         END-IF                                                   
C25953      END-IF                                                      
C25953     END-IF.                                                      
C25953*                                                                         
           MOVE WS-INPUT-DATE               TO WS-COMM-DATE             
                                               WS-PARM-COMMON-DATE      
           MOVE WS-COMM-MM                  TO P-RPT-RUN-MM             
           MOVE WS-COMM-DD                  TO P-RPT-RUN-DD             
           MOVE WS-COMM-YY                  TO P-RPT-RUN-YY.            
                                                                        
             PERFORM 6200-GET-PARAMETER-DATE   THRU 6200-EXIT.          
                                                                        
             MOVE WS-PARM-MONTH                TO WS-REV-MM.            
             MOVE WS-PARM-YR(1:4)              TO WS-REV-CCYY,          
                                                  WS-REP-YEAR           
             MOVE WS-REV-CCYY                  TO WS-FROM-CCYY          
                                                  WS-TO-CCYY.           
             MOVE WS-REV-MM                    TO WS-FROM-MM,           
                                                  WS-TO-MM,             
                                                  WS-MONTH.             
             MOVE WS-01                        TO WS-FROM-DD.           
             MOVE WS-31                        TO WS-TO-DD.             
                                                                        
             MOVE WS-FROM-DATE                 TO WS-START-DATE.        
             MOVE WS-TO-DATE                   TO WS-END-DATE.          
             PERFORM 0200-MONTH-DESC           THRU 0200-EXIT.          
             PERFORM 7775-GET-CURRENT-DATE     THRU 7775-EXIT.          
             MOVE WS-CURRENT-DATE              TO WS-BC-CURRENT-DATE.   
      *                                                                         
C25864*    PERFORM 7040-GET-REVENUE-MONTH   THRU 7040-EXIT.                     
C25864*    PERFORM 7050-GET-OPTIMUM-DATE    THRU 7050-EXIT.                     
C25864*                                                                         
C25864     MOVE WS-REV-CCYY                    TO WS-DATE-CCYY.         
C25864     MOVE WS-REV-MM                      TO WS-DATE-MM.           
C25864     MOVE '10'                           TO WS-DATE-DD.           
C25864     MOVE WS-RUN-DATE-TEMP               TO WS-RUN-DATE.          
C25953     MOVE WS-CUR-REV-MON-CR              TO WS-REVENUE-MONTH.     
C25953     MOVE WS-REVENUE-MONTH               TO BN-REVENUE-MONTH.     
C25953     PERFORM 7900-CHECK-RUNDATE          THRU 7900-EXIT.          
      *                                                                         
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      ** 0200-MONTH-DESC.                                        **             
      **TO DISPLAY THE MONTH FOR WHICH REPORT IS GENERATED       **             
      **                                                         **             
      *************************************************************             
                                                                        
       0200-MONTH-DESC.                                                 
                                                                        
           MOVE '0200'                         TO  WS-ACTIVE-PARAGRAPH. 
                                                                        
           EVALUATE WS-MONTH                                            
             WHEN '01'                                                  
               MOVE 'JANUARY  '                TO WS-RPT-MONTH          
             WHEN '02'                                                  
               MOVE 'FEBRUARY '                TO WS-RPT-MONTH          
             WHEN '03'                                                  
               MOVE 'MARCH    '                TO WS-RPT-MONTH          
             WHEN '04'                                                  
               MOVE 'APRIL    '                TO WS-RPT-MONTH          
             WHEN '05'                                                  
               MOVE 'MAY      '                TO WS-RPT-MONTH          
             WHEN '06'                                                  
               MOVE 'JUNE     '                TO WS-RPT-MONTH          
             WHEN '07'                                                  
               MOVE 'JULY     '                TO WS-RPT-MONTH          
             WHEN '08'                                                  
               MOVE 'AUGUST   '                TO WS-RPT-MONTH          
             WHEN '09'                                                  
               MOVE 'SEPTEMBER'                TO WS-RPT-MONTH          
             WHEN '10'                                                  
               MOVE 'OCTOBER  '                TO WS-RPT-MONTH          
             WHEN '11'                                                  
               MOVE 'NOVEMBER '                TO WS-RPT-MONTH          
             WHEN '12'                                                  
               MOVE 'DECEMBER '                TO WS-RPT-MONTH          
           END-EVALUATE.                                                
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **  0500-LOAD-BTU-FACTORS                                    **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
      *0500-LOAD-BTU-FACTORS.                                           04247000
      *                                                                         
      *    INITIALIZE WS-BTU-FACTOR-DATA                                04248000
      *    PERFORM VARYING BTU-INDX FROM 1 BY 1                         04249000
      *            UNTIL BTU-INDX > 800                                 04250000
      *       MOVE LOW-VALUES                  TO WS-BTU-DT (BTU-INDX)  04251000
      *    END-PERFORM                                                  04252000
      *    PERFORM 7400-OPEN-BTU-FACTORS       THRU 7400-EXIT           04253000
      *    SET BTU-INDX TO 1                                            04254000
      *      PERFORM UNTIL SQLCODE = NOT-FOUND                          04255000
      *               OR BTU-INDX > 800                                 04256000
      *       PERFORM 7500-FETCH-BTU-FACTORS   THRU 7500-EXIT           04257000
      *        IF SQLCODE = SUCCESSFUL-CALL                             04258000
      *           MOVE TF-BTU-DT               TO WS-BTU-DT (BTU-INDX)  04259000
      *           MOVE TF-MMBTU-TOTAL          TO                               
      *                                      WS-MMBTU-TOTAL (BTU-INDX)          
      *           MOVE TF-MCF-TOTAL            TO                               
      *                                      WS-MCF-TOTAL (BTU-INDX)            
      *           MOVE TF-COMPANY-NO           TO                               
      *                                      WS-COMPANY-NO-TF (BTU-INDX)        
      *           SET BTU-INDX UP BY 1                                  04262000
      *       END-IF                                                    04263000
      *      END-PERFORM                                                04264000
      *      PERFORM 7550-CLOSE-BTU-FACTORS    THRU 7550-EXIT.          04265000
      *      PERFORM 0525-LOAD-HIGH-HIT-BTUS   THRU 0525-EXIT.          04266000
      *      PERFORM 0550-CALC-BTU-FACTOR      THRU 0550-EXIT.          04266000
      *                                                                 04268000
      *   0500-EXIT.                                                    04269000
      *     EXIT.                                                       04270000
      *                                                                 04268000
      ***************************************************************           
      **                                                           **           
      **  0525-LOAD-HIGH-HIT-BTUS                                  **           
      **                                                           **           
      **SINCE MOST READS WILL HAVE A READ DATE WITHIN THE PAST 5   **           
      **DAYS AND SINCE MOST BILLS ARE 29, 30, OR 31 DAYS,          **           
      **PRECALCULATE FACTORS FOR THOSE 15 COMBINATIONS.            **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
      *  0525-LOAD-HIGH-HIT-BTUS.                                       04280000
      *                                                                 04268000
      *    MOVE WS-BC-CURRENT-DATE             TO WS-WORK-FROM-DATE.    04280100
      *    PERFORM 7850-GET-PREV-DAY           THRU 7850-EXIT.          04280200
      *    SET HH-INDX TO 1.                                            04280300
      *    SET BTU-INDX TO 1.                                           04280300
      *    SEARCH ALL WS-BTU-FACTOR-ITEM                                04281000
      *       AT END                                                    04282000
      *          CONTINUE                                               04283000
      *    WHEN WS-BTU-DT (BTU-INDX) = WS-WORK-DATE                     04284000
      *      SET BTU-INDX2 TO BTU-INDX                                  04285000
      *    PERFORM 5 TIMES                                              04286000
      *      SET BTU-INDX TO BTU-INDX2                                  04287000
      *      IF BTU-INDX < 801                                          04288000
      *         MOVE WS-BTU-DT (BTU-INDX)      TO                       04290000
      *                                        WS-HH-READ-DATE (HH-INDX)04290000
      *         MOVE WS-29                     TO                       04292000
      *                                        WS-HH-READ-DAYS (HH-INDX)04292000
      *         PERFORM 29 TIMES                                        04293000
      *           IF BTU-INDX < 801                                     04294000
      *              ADD WS-MMBTU-TOTAL (BTU-INDX)                      04295000
      *                                        TO WS-HOLD-MMBTU-TOTAL   04296000
      *              ADD WS-MCF-TOTAL (BTU-INDX)                        04297000
      *                                        TO WS-HOLD-MCF-TOTAL     04298000
      *           END-IF                                                04299000
      *           SET BTU-INDX UP BY 1                                  04300000
      *         END-PERFORM                                             04301000
      *            COMPUTE WS-HH-BTU-FACTOR (HH-INDX) ROUNDED           04302000
      *                      = WS-HOLD-MMBTU-TOTAL / WS-HOLD-MCF-TOTAL  04303000
      *                  ON SIZE ERROR                                  04304000
      *            MOVE ZERO                   TO                               
      *                                       WS-HH-BTU-FACTOR (HH-INDX)        
      *            END-COMPUTE                                          04306000
      *                IF BTU-INDX < 800                                04307000
      *                      AND WS-HH-BTU-FACTOR (HH-INDX) > ZERO      04308000
      *                   SET HH-INDX UP BY 1                           04310000
      *                   MOVE WS-HH-READ-DATE (HH-INDX - 1)            04311000
      *                                        TO                               
      *                                        WS-HH-READ-DATE (HH-INDX)04312000
      *                   MOVE WS-30           TO                       04313000
      *                                        WS-HH-READ-DAYS (HH-INDX)04313000
      *                   ADD WS-MMBTU-TOTAL (BTU-INDX)                 04314000
      *                                        TO WS-HOLD-MMBTU-TOTAL   04315000
      *                   ADD WS-MCF-TOTAL (BTU-INDX)                   04316000
      *                                        TO WS-HOLD-MCF-TOTAL     04317000
      *                   COMPUTE WS-HH-BTU-FACTOR (HH-INDX) ROUNDED    04318000
      *                      = WS-HOLD-MMBTU-TOTAL / WS-HOLD-MCF-TOTAL  04319000
      *                     ON SIZE ERROR                               04320000
      *                        MOVE ZERO       TO                       04321000
      *                                       WS-HH-BTU-FACTOR (HH-INDX)04321000
      *                   END-COMPUTE                                   04322000
      *                END-IF                                           04323000
      *                IF BTU-INDX < 800                                04324000
      *                      AND WS-HH-BTU-FACTOR (HH-INDX) > ZERO      04325000
      *                   SET BTU-INDX UP BY 1                          04326000
      *                   SET HH-INDX UP BY 1                           04327000
      *                   MOVE WS-HH-READ-DATE (HH-INDX - 1)            04328000
      *                     TO WS-HH-READ-DATE (HH-INDX)                04329000
      *                   MOVE WS-31           TO                       04330000
      *                                        WS-HH-READ-DAYS (HH-INDX)04330000
      *                   ADD WS-MMBTU-TOTAL (BTU-INDX)                 04331000
      *                                        TO WS-HOLD-MMBTU-TOTAL   04332000
      *                   ADD WS-MCF-TOTAL (BTU-INDX)                   04333000
      *                                        TO WS-HOLD-MCF-TOTAL     04334000
      *                   COMPUTE WS-HH-BTU-FACTOR (HH-INDX) ROUNDED    04335000
      *                      = WS-HOLD-MMBTU-TOTAL / WS-HOLD-MCF-TOTAL  04336000
      *                     ON SIZE ERROR                               04337000
      *                        MOVE ZERO       TO                       04338000
      *                                       WS-HH-BTU-FACTOR (HH-INDX)04338000
      *                   END-COMPUTE                                   04339000
      *                END-IF                                           04340000
      *             END-IF                                              04341000
      *             MOVE ZERO                  TO WS-HOLD-MMBTU-TOTAL   04342000
      *                                           WS-HOLD-MCF-TOTAL     04343000
      *             SET BTU-INDX2 UP BY 1                               04344000
      *             SET HH-INDX UP BY 1                                 04344100
      *          END-PERFORM                                            04345000
      *    END-SEARCH.                                                  04346000
      *                                                                         
      *  0525-EXIT.                                                     04347000
      *      EXIT.                                                      04348000
      *                                                                         
      ******************************************************************        
      **                                                              **06437000
      **    0550-CALC-BTU-FACTOR                                      **06438000
      **                                                              **06439000
      ** TRY TO MATCH ON THE HIGH-HIT ARRAY FIRST (SEE PARA 0500).    **06440000
      ** IF NO LUCK, CALCULATE USING THE BTU-FACTOR TABLE             **06441000
      **                                                              **06442000
      ******************************************************************        
      *0550-CALC-BTU-FACTOR.                                            06444000
      *                                                                         
      *    MOVE WS-BC-CURRENT-DATE             TO WS-WORK-FROM-DATE.    04280100
      *    PERFORM 7850-GET-PREV-DAY           THRU 7850-EXIT.          04280200
      *    SET HH-INDX TO 1                                             06455000
      *    SET BTU-INDX TO 1                                            06455000
      *    SEARCH WS-BTU-HIGH-HIT-ITEM                                  06456000
      *       AT END                                                    06457000
      *         SEARCH ALL WS-BTU-FACTOR-ITEM                           06458000
      *            AT END                                               06459000
      *               MOVE WS-NO-BTU-FACTOR    TO WS-CALC-ERROR         06460000
      *            WHEN WS-BTU-DT (BTU-INDX) = WS-WORK-DATE             06462000
      *               PERFORM VARYING BTU-INDX FROM BTU-INDX  BY 1      06463000
      *                       UNTIL BTU-INDX > 800                      06464000
      *                          OR WS-BTU-DT (BTU-INDX)                06465000
      *                             < WS-WORK-DATE                              
      *                   ADD WS-MMBTU-TOTAL (BTU-INDX)                 06467000
      *                                        TO WS-HOLD-MMBTU-TOTAL   06468000
      *                   ADD WS-MCF-TOTAL (BTU-INDX)                   06469000
      *                                        TO WS-HOLD-MCF-TOTAL     06470000
      *               END-PERFORM                                       06471000
      *               COMPUTE WS-BTU-FACTOR ROUNDED                     06472000
      *                  = WS-HOLD-MMBTU-TOTAL / WS-HOLD-MCF-TOTAL      06473000
      *                  ON SIZE ERROR                                  06474000
      *                     MOVE ZERO TO WS-BTU-FACTOR                  06475000
      *                     MOVE WS-NO-BTU-FACTOR                       06476000
      *                                        TO WS-CALC-ERROR         06476000
      *               END-COMPUTE                                       06478000
      *               MOVE WS-BTU-FACTOR       TO WS-BC-BTU-FACTOR-BG   06479000
      *         END-SEARCH                                              06480000
      *      WHEN WS-HH-READ-DATE (HH-INDX) = WS-WORK-DATE              06481000
      *            AND WS-HH-READ-DAYS (HH-INDX)                        06482000
      *                = WS-NO-OF-CNSMPTN-DAYS-ACCUM                    06483000
      *         IF WS-HH-BTU-FACTOR (HH-INDX) > ZERO                    06484000
      *            MOVE WS-HH-BTU-FACTOR (HH-INDX)                      06485000
      *                                        TO WS-BC-BTU-FACTOR-BG   06486000
      *         ELSE                                                    06487000
      *            MOVE WS-NO-BTU-FACTOR       TO WS-CALC-ERROR         06488000
      *         END-IF                                                  06490000
      *    END-SEARCH.                                                  06491000
      *                                                                 06493000
      *0550-EXIT.                                                       06444000
      *    EXIT.                                                                
      *                                                                 06493000
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS BEGINS HERE                      **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
            MOVE '1000'                        TO WS-ACTIVE-PARAGRAPH.  
                                                                        
            PERFORM 7100-OPEN-INDUST-ACCT-CUR  THRU 7100-EXIT.          
                                                                        
            PERFORM 7200-FETCH-INDUST-ACCT-CUR THRU 7200-EXIT           
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
                                                                        
            IF NOT-RECORD-FOUND                                         
               MOVE WS-DEFAULT-COMP            TO  C7-COMPANY-NO        
               PERFORM 7800-GET-COMPANY-DESC   THRU 7800-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE +31                     TO WS-MAX-FIELD-LEN-3900 
                  PERFORM 3900-CENTERING-ROUTINE                        
                                               THRU 3900-EXIT           
                  MOVE WS-OUTPUT-CTR-FIELD     TO P-RPT-COMP-NAME       
               END-IF                                                   
               PERFORM 8100-PRINT-RPT-NO-DATA  THRU 8100-EXIT           
            ELSE                                                        
               PERFORM 8400-PRINT-RPT-FOOTER   THRU 8400-EXIT           
            END-IF.                                                     
            PERFORM 7300-CLOSE-INDUST-ACCT-CUR THRU 7300-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **  2200-PROCESS-DETAIL-PARA                                 **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2200-PROCESS-DETAIL-PARA.                                        
                                                                        
           MOVE '2200'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           INITIALIZE CX-NO-UNITS.                                      
C25991*                                                                         
C25991     MOVE AT-ACCOUNT-NO                  TO HT-ACCOUNT-NO.        
T35465     MOVE 'Y'                            TO WS-NAME-ONLY-SW.      
C25991     PERFORM 4000-MAIL-NAME-ADDRESS      THRU 4000-EXIT.          
C25991     MOVE WS-CUSTOMER-NAME               TO WS-CUST-NAME.         
C25991     PERFORM 7950-GET-FUEL-CD            THRU 7950-EXIT.          
C25991     MOVE W0-ALTERNATE-FUEL-TX           TO P-RPT-FUEL-CD.        
C25991*                                                                         
           MOVE  AT-ACCOUNT-NO                 TO CX-ACCOUNT-NO.        
C25991     PERFORM 7960-MTRD-ENVRMT            THRU 7960-EXIT.          
C25991     IF MTR-RD-MISSING                                            
C25991        MOVE ZEROS                       TO WS-CCF                
C25991     ELSE                                                         
C25981        MOVE WS-D                        TO CX-CODE-DEBIT-CREDIT  
              PERFORM 7700-CCF-CALU-PARA       THRU 7700-EXIT           
              MOVE CX-NO-UNITS                 TO WS-CCF                
C25981        MOVE 'C'                         TO CX-CODE-DEBIT-CREDIT  
C25981        PERFORM 7700-CCF-CALU-PARA       THRU 7700-EXIT           
C25981        SUBTRACT CX-NO-UNITS             FROM WS-CCF              
C25991     END-IF.                                                      
           MOVE AT-COMPANY-NO                  TO TF-COMPANY-NO.        
      *    IF FIRST-TIME                                                        
      *       PERFORM 0500-LOAD-BTU-FACTORS    THRU 0500-EXIT                   
              PERFORM 2250-GET-DETAILS         THRU 2250-EXIT           
      *       SET NOT-FIRST-TIME               TO TRUE                          
      *    END-IF.                                                              
C25864     COMPUTE WS-THERMS ROUNDED = WS-CCF * WS-BTU-FACTOR.          
           COMPUTE WS-DEKATHERMS ROUNDED  = (WS-THERMS/10).             
           PERFORM 8000-PRINT-RPT-REPORT       THRU 8000-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01900000
      **  2250-GET-DETAILS                                            **01910000
      **  THIS PARA USED TO RETRIEVE THE PREV READ DATE & CURRENT     **        
      **  READ USING THE CURSOR FETCH                                 **        
      ******************************************************************01940000
                                                                        
       2250-GET-DETAILS.                                                
      *                                                                         
      *    MOVE UT-RATE-PLAN-NO        TO  WS-RATE-PLAN-NO                      
           MOVE BK-IC-NO               TO  CX-IC-NO                     
           MOVE AT-ACCOUNT-NO          TO  CX-ACCOUNT-NO                
           PERFORM 7400-OPEN-CNS-HIST  THRU 7400-EXIT                   
           PERFORM 7410-FETCH-CNS-HIST THRU 7410-EXIT                   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE ZEROES               TO WS-BTU-FACTOR                 
             PERFORM 7420-CLOSE-CNS-HIST THRU 7420-EXIT                 
             GO TO 2250-EXIT                                            
           END-IF.                                                      
           MOVE CX-DATE-READ           TO  WS-CURR-READ-DT              
           MOVE CX-NO-UNITS            TO  WS-NO-UNITS                  
           IF  CX-NO-DAYS < 27                                          
               MOVE WS-RTD-RD-DT       TO  WS-PRV-RD-DT                 
           END-IF.                                                      
           MOVE WS-PRV-RD-DT           TO WS-PREV-READ-DT               
           MOVE WS-PREV-READ-DT        TO WS-PREV-READ-DT-TEMP          
                                          WS-PREV-READ-DT1.             
           MOVE WS-CURR-READ-DT        TO WS-CURR-READ-DT-TEMP          
                                          WS-CURR-READ-DT1.             
           PERFORM 7420-CLOSE-CNS-HIST THRU 7420-EXIT.                  
           PERFORM 7430-GET-SUM-UNITS  THRU 7430-EXIT.                  
           MOVE WS-SUM-NO-UNITS        TO  WS-NO-UNITS.                 
           PERFORM 2500-COMPUTE-BTU-FACTOR  THRU 2500-EXIT.             
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01900000
      **  2500-COMPUTE-BTU-FACTOR                                     **01910000
      **  THIS PARA USED TO CALCULATE THE BTU FACTOR USING THE CURSOR **        
      **  FETCH                                                       **        
      ******************************************************************01940000
                                                                        
       2500-COMPUTE-BTU-FACTOR.                                         
      *                                                                         
           PERFORM 7440-OPEN-BTU-SUM   THRU 7440-EXIT                   
           PERFORM 7450-FETCH-BTU-SUM  THRU 7450-EXIT                   
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              COMPUTE WS-BTU-FACTOR ROUNDED =                           
                      WS-SUM-MMBTU-TOTAL / WS-SUM-MCF-TOTAL             
      *       COMPUTE WS-AVG-MCF-TOTAL-D ROUNDED =                              
      *               WS-SUM-MMBTU-TOTAL / WS-SUM-MCF-TOTAL                     
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                 MOVE ZEROES           TO WS-BTU-FACTOR                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7460-CLOSE-BTU-SUM  THRU 7460-EXIT.                  
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   3900-CENTERING-ROUTINE                                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       COPY CPD00150.                                                           
      *                                                                         
C25991******************************************************************        
C25991* 4000-MAIL-NAME-ADDRESS                                         *        
C25991******************************************************************        
C25991     EXEC SQL                                                             
C25991        INCLUDE CPD00074                                                  
C25991     END-EXEC.                                                            
C25991*                                                                         
C25991******************************************************************        
C25991* 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
C25991******************************************************************        
C25991     EXEC SQL                                                             
C25991        INCLUDE CPD00004                                                  
C25991     END-EXEC.                                                            
C25991*                                                                         
      ******************************************************************        
      *    6200-GET-PARAMETER-DATE                                              
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                  INCLUDE CPD00114                                              
              END-EXEC.                                                         
      *                                                                         
      ******************************************************************        
      *    6251-GET-FJC01-DATE.                                                 
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                  INCLUDE CPD00037                                              
              END-EXEC.                                                         
      *                                                                 14999700
      ***************************************************************           
      **                                                           **           
      **    7100-OPEN-INDUST-ACCT-CUR                              **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7100-OPEN-INDUST-ACCT-CUR.                                       
                                                                        
           MOVE '7100'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                OPEN CON_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7100-OPEN-INDUST-ACCT-CUR'                          
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      **                                                           **           
      **    7200-FETCH-INDUST-ACCT-CUR.                            **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7200-FETCH-INDUST-ACCT-CUR.                                      
                                                                        
           MOVE '7200'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                FETCH CON_CUR INTO                                      
                   :AT-ACCOUNT-NO,                                      
                   :AT-COMPANY-NO,                                      
                   :AT-CODE-MAJOR-ACCT,                                 
C25991             :AT-ADDRESS-ID,                                      
                   :BK-CODE-UTIL-TYPE,                                  
                   :BK-IC-NO,                                           
                   :BK-CNTRCT-START-DT,                                 
                   :BK-CNTRCT-END-DT,                                   
                   :BK-DFLT-USAGE-CLS-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    SET RECORD-FOUND           TO TRUE                  
                    PERFORM 2200-PROCESS-DETAIL-PARA                    
                                               THRU 2200-EXIT           
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE 'ERROR IN FETCHING INDUSTRIAL ACCOUNT'         
                                               TO WS-ERR-MSG            
                    MOVE SQLCODE               TO WS-DISP-RC            
                   PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT           
           END-EVALUATE.                                                
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7300-CLOSE-INDUST-ACCT-CUR                             **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7300-CLOSE-INDUST-ACCT-CUR.                                      
                                                                        
           MOVE '7300'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                CLOSE CON_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7300-CLOSE-INDUST-ACCT-CUR'                         
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40490000
      * 7400-OPEN-CNS-HIST                                             *40500000
      * OPENS CURSOR CNS_CRSR                                          *        
      ******************************************************************40530000
                                                                        
       7400-OPEN-CNS-HIST.                                              
      *                                                                         
           MOVE '7400'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              OPEN CNS_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7400-OPEN-CNS-HIST'                                 
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40490000
      * 7410-FETCH-CNS-HIST                                            *40500000
      * FETCHES THE CURSOR CNS_CRSR                                    *        
      ******************************************************************40530000
                                                                        
       7410-FETCH-CNS-HIST.                                             
      *                                                                         
           MOVE '7410'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              FETCH CNS_CRSR                                            
               INTO :CX-DATE-READ,                                      
                    :WS-PRV-RD-DT,                                      
                    :WS-RTD-RD-DT,                                      
                    :CX-NO-DAYS,                                        
                    :CX-NO-UNITS,                                       
                    :CX-BILL-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL) OR          
              (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7410-FETCH-CNS-HIST'                                
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40490000
      * 7420-CLOSE-CNS-HIST                                            *40500000
      * CLOSES THE CURSOR CNS_CRSR                                     *        
      ******************************************************************40530000
                                                                        
       7420-CLOSE-CNS-HIST.                                             
      *                                                                         
           MOVE '7420'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              CLOSE CNS_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7420-CLOSE-CNS-HIST'                                
                                               TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16840004
      ***************************************************************** 01900000
      **  7430-GET-SUM-UNITS. THIS PARA IS USED TO RETRIEVE THE      **         
      **   SUM OF NO-DAYS AND NO-UNITS BETWEEN PREV & CURR DATES.    **         
      ***************************************************************** 01900000
      *                                                                 01900000
       7430-GET-SUM-UNITS.                                              
      *                                                                         
           MOVE '7430'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(NO_UNITS),                                    
                      SUM(NO_DAYS)                                      
                INTO :WS-SUM-NO-UNITS,                                  
                     :WS-SUM-NO-DAYS                                    
                 FROM CSS_CNSMPTN_HIST                                  
                WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :WS-G                         
                  AND IC_NO             = :CX-IC-NO                     
                  AND BILL_NO           = :CX-BILL-NO                   
                  AND DATE_READ         > IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-READ-DT-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-READ-DT-TEMP
              ) <> 0) OR (LEN(:WS-PREV-READ-DT-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-READ-DT-TEMP
              ), CONVERT(DATE, :WS-PREV-READ-DT-TEMP) )         
                  AND DATE_READ        <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-CURR-READ-DT-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-READ-DT-TEMP
              ) <> 0) OR (LEN(:WS-CURR-READ-DT-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-READ-DT-TEMP
              ), CONVERT(DATE, :WS-CURR-READ-DT-TEMP) )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(NO_UNITS),                                            
MFA-TR*               SUM(NO_DAYS)                                              
MFA-TR*         INTO :WS-SUM-NO-UNITS,                                          
MFA-TR*              :WS-SUM-NO-DAYS                                            
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :WS-G                                 
MFA-TR*           AND IC_NO             = :CX-IC-NO                             
MFA-TR*           AND BILL_NO           = :CX-BILL-NO                           
MFA-TR*           AND DATE_READ         > :WS-PREV-READ-DT-TEMP                 
MFA-TR*           AND DATE_READ        <= :WS-CURR-READ-DT-TEMP                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7430-GET-SUM-UNITS'        TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16840004
      ******************************************************************40490000
      * 7440-OPEN-BTU-SUM                                              *40500000
      * OPENS THE CURSOR BTU_SUM                                       *        
      ******************************************************************40530000
                                                                        
       7440-OPEN-BTU-SUM.                                               
      *                                                                         
           MOVE '7440'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              OPEN BTU_SUM                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7440-OPEN-BTU-SUM '        TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40490000
      * 7450-FETCH-BTU-SUM                                             *40500000
      * FETCHES THE CURSOR BTU_SUM                                     *        
      ******************************************************************40530000
                                                                        
       7450-FETCH-BTU-SUM.                                              
      *                                                                         
           MOVE '7450'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              FETCH BTU_SUM                                             
               INTO :WS-SUM-MMBTU-TOTAL,                                
                    :WS-SUM-MCF-TOTAL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL)             
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY '**   PROCESSING ERROR IN PCSRP226  **'        
                 DISPLAY '** NO VALUES TO FETCH BTU-FACTOR   **'        
                 DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH          
                 DISPLAY '**   SQLCODE = ', WS-DISP-RC                  
              ELSE                                                      
                 MOVE SQLCODE                  TO WS-DISP-RC            
                 MOVE '7410-FETCH-CNS-HIST'    TO WS-ERR-MSG            
                                                                        
                 PERFORM 9100-DISPLAY-ERROR    THRU 9100-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40490000
      * 7460-CLOSE-BTU-SUM                                             *40500000
      * CLOSES THE CURSOR BTU_SUM                                      *        
      ******************************************************************40530000
                                                                        
       7460-CLOSE-BTU-SUM.                                              
      *                                                                         
           MOVE '7460'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
              CLOSE BTU_SUM                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7460-CLOSE-BTU-SUM'        TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16840004
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      *  7620-START-FCSCA00                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      **                                                           **           
      **     7700-CCF-CALU-PARA.                                   **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7700-CCF-CALU-PARA.                                              
                                                                        
           MOVE '7700'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
             SELECT SUM(CX.NO_UNITS)                                    
               INTO :CX-NO-UNITS :WS-NULL-IND                            
             FROM CSS_BILLING_DET BG                                    
                 ,CSS_CNSMPTN_HIST CX                                   
             WHERE BG.BILL_NO = (SELECT MAX(BILL_NO)                    
                                  FROM CSS_BILLING_HDR                  
                                 WHERE ACCOUNT_NO = :CX-ACCOUNT-NO      
                                   AND DATE_BILLED IS NULL)             
             AND BG.ACCOUNT_NO         = CX.ACCOUNT_NO                  
             AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE              
             AND BG.BILL_NO            = CX.BILL_NO                     
             AND BG.BILL_ITEM_TIMESTMP = CX.BILL_ITEM_TIMESTMP          
             AND BG.ACCOUNT_NO         = :CX-ACCOUNT-NO                 
             AND BG.CODE_UTIL_TYPE     = :BK-CODE-UTIL-TYPE             
ACT188       AND CX.CODE_USAGE_TYPE    = 'C'                            
ACT188       AND CX.CODE_USAGE_ID      = 'A'                            
             AND CX.CODE_USAGE_SOURCE  = 'B'                            
C25981       AND CX.CODE_DEBIT_CREDIT  = :CX-CODE-DEBIT-CREDIT          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND < 0                                        
                 MOVE ZEROES                   TO CX-NO-UNITS           
              END-IF                                                    
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7700-CCF-CALU-PARA'        TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************           
      **                                                           **           
      **     7775-GET-CURRENT-DATE.                                **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7775-GET-CURRENT-DATE.                                           
                                                                        
              EXEC SQL                                                  
T35434           SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                  11137400
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*       END-EXEC.                                                 11137800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                     TO WS-DISP-RC            
              MOVE '7775-GET-CURRENT-DATE'     TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       7775-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
                                                                        
       7800-GET-COMPANY-DESC.                                           
                                                                        
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME             TO WS-INPT-CTR-FIELD     
           ELSE                                                         
              MOVE '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'        
                                               TO WS-ERR-MSG            
              MOVE SQLCODE                     TO WS-DISP-RC            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
        7800-EXIT.                                                      
            EXIT.                                                       
C25953******************************************************************        
C25953**                                                              **        
C25953**  7900-CHECK-RUNDATE                                          **        
C25953**       CHECKS THE RUN DATE TO GENERATE THE REPORT             **        
C25953******************************************************************        
C25953 7900-CHECK-RUNDATE.                                              
C25953                                                                  
C25953      MOVE '7900'                      TO WS-ACTIVE-PARAGRAPH.    
C25953                                                                  
C25953     EXEC SQL                                                     
C25953          SELECT MIN(DATE_EXTRACT)                                
C25953            INTO :BN-DATE-EXTRACT                                 
C25953            FROM CSS_BILL_WINDOW BN                               
C25953           WHERE BN.BILL_CYCLE = '20'                             
C25953             AND BN.REVENUE_MONTH = :BN-REVENUE-MONTH             
C25953     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25953                                                                  
C25953     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C25953     EVALUATE  WS-ACTIVE-RETURN-CODE                              
C25953         WHEN  SUCCESSFUL-CALL                                    
C25953          CONTINUE                                                
C25953         WHEN  NOT-FOUND                                          
C25953          MOVE SPACES                  TO BN-DATE-EXTRACT         
C25953         WHEN OTHER                                               
C25953          MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISP-RC              
C25953          MOVE '7900-CHECK-RUN-DATE'   TO WS-ERR-MSG              
C25953          PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT         
C25953     END-EVALUATE.                                                
C25953*                                                                         
C25953 7900-EXIT.                                                       
C25953     EXIT.                                                        
C25953*                                                                         
C25991******************************************************************        
C25991**                                                              **        
C25991**  7950-GET-FUEL-CD                                            **        
C25991**       SELECTS THE FUEL CODE                                  **        
C25991******************************************************************        
C25991 7950-GET-FUEL-CD.                                                
C25991                                                                  
C25991      MOVE '7950'                      TO WS-ACTIVE-PARAGRAPH.    
C25991                                                                  
C25991     EXEC SQL                                                     
C25991          SELECT ALTERNATE_FUEL_TX                                
C25991            INTO :W0-ALTERNATE-FUEL-TX                            
C25991            FROM CSS_ALTN_FUEL_TYPE W0 WITH(READUNCOMMITTED)              
C25991                ,CSS_ALTN_FUEL_SPLY AK WITH(READUNCOMMITTED)              
C25991           WHERE AK.ACCOUNT_NO        = :AT-ACCOUNT-NO            
C25991             AND AK.CODE_UTIL_TYPE    = :BK-CODE-UTIL-TYPE        
C25991             AND AK.IC_NO             = :BK-IC-NO                 
C25991             AND AK.CNTRCT_START_DT   = IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) )       
C25991             AND AK.ALTN_FUEL_SPLY_CD = :BK-DFLT-USAGE-CLS-CD     
C25991             AND AK.ALTERNATE_FUEL_CD = W0.ALTERNATE_FUEL_CD      
T35434                                                           
C25991     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ALTERNATE_FUEL_TX                                        
MFA-TR*           INTO :W0-ALTERNATE-FUEL-TX                                    
MFA-TR*           FROM CSS_ALTN_FUEL_TYPE W0                                    
MFA-TR*               ,CSS_ALTN_FUEL_SPLY AK                                    
MFA-TR*          WHERE AK.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND AK.CODE_UTIL_TYPE    = :BK-CODE-UTIL-TYPE                
MFA-TR*            AND AK.IC_NO             = :BK-IC-NO                         
MFA-TR*            AND AK.CNTRCT_START_DT   = :BK-CNTRCT-START-DT               
MFA-TR*            AND AK.ALTN_FUEL_SPLY_CD = :BK-DFLT-USAGE-CLS-CD             
MFA-TR*            AND AK.ALTERNATE_FUEL_CD = W0.ALTERNATE_FUEL_CD              
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25991                                                                  
C25991     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C25991     EVALUATE  WS-ACTIVE-RETURN-CODE                              
C25991         WHEN  SUCCESSFUL-CALL                                    
C25991          CONTINUE                                                
C25991         WHEN  NOT-FOUND                                          
C25991          MOVE SPACES                  TO W0-ALTERNATE-FUEL-TX    
C25991         WHEN OTHER                                               
C25991          MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISP-RC              
C25991          MOVE '7950-GET-FUEL-CD'      TO WS-ERR-MSG              
C25991          PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT         
C25991     END-EVALUATE.                                                
C25991*                                                                         
C25991 7950-EXIT.                                                       
C25991     EXIT.                                                        
C25991*                                                                         
C25991******************************************************************        
C25991**                                                              **        
C25991**  7960-MTRD_ENVRMT                                            **        
C25991**       CHECKS FOR THE MISSING METERS FOR ALL THE ACCOUNTS.    **        
C25991******************************************************************        
C25991 7960-MTRD-ENVRMT.                                                
C25991                                                                  
C25991      MOVE '7960'                      TO WS-ACTIVE-PARAGRAPH.    
C25991      SET MTR-READ-PRESENT             TO TRUE.                   
C25991                                                                  
C25991     EXEC SQL                                                     
C25991           SELECT :WS-Y                                           
C25991             INTO :WS-MTR-READ-FLAG                               
C25991             FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
C25991            WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO             
C25991              AND CODE_CRNT_REG_READ = :WS-D                      
T35434                                                           
C25991     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT :WS-Y                                           02247000
MFA-TR*            INTO :WS-MTR-READ-FLAG                                       
MFA-TR*            FROM CSS_MTRD_ENVRNMT MN                             02249100
MFA-TR*           WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*             AND CODE_CRNT_REG_READ = :WS-D                              
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25991                                                                  
C25991     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C25991     EVALUATE  WS-ACTIVE-RETURN-CODE                              
C25991         WHEN  SUCCESSFUL-CALL                                    
C25991         WHEN  NOT-FOUND                                          
C25991         WHEN  -811                                               
C25991          CONTINUE                                                
C25991         WHEN OTHER                                               
C25991          MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISP-RC              
C25991          MOVE '7960-MTRD-ENVRMT'      TO WS-ERR-MSG              
C25991          PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT             
C25991     END-EVALUATE.                                                
C25991*                                                                         
C25991 7960-EXIT.                                                       
C25991     EXIT.                                                        
C25991*                                                                         
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           MOVE AT-COMPANY-NO                  TO C7-COMPANY-NO         
           PERFORM 7800-GET-COMPANY-DESC       THRU 7800-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE +31                         TO WS-MAX-FIELD-LEN-3900 
              PERFORM 3900-CENTERING-ROUTINE   THRU 3900-EXIT           
              MOVE WS-OUTPUT-CTR-FIELD         TO P-RPT-COMP-NAME       
           END-IF.                                                      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS   THRU 8500-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS      THRU 8300-EXIT.          
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                         TO   WS-ACTIVE-PARAGRAPH.
           PERFORM 8500-PRINT-RPT-HEADERS      THRU 8500-EXIT.          
           MOVE    WS-BLANK-LINE               TO   PRT33-RECORD.       
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           MOVE WS-NO-DATA-LINE                TO   PRT33-RECORD.       
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
       8100-EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-HEADERS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                         TO   WS-ACTIVE-PARAGRAPH.
                                                                        
           MOVE AT-ACCOUNT-NO                  TO   WS-ACCOUNT-NO-X     
           MOVE WS-ACCOUNT-NO-X(1:1)           TO   WS-ACCOUNT-NO-P1    
           MOVE WS-ACCOUNT-NO-X(2:4)           TO   WS-ACCOUNT-NO-P2    
           MOVE WS-ACCOUNT-NO-X(6:4)           TO   WS-ACCOUNT-NO-P3    
           MOVE WS-ACCOUNT-NO-X(10:4)          TO   WS-ACCOUNT-NO-P4    
           MOVE WS-ACCOUNT-NO                  TO   P-RPT-ACCT-NO       
           MOVE WS-CCF                         TO   P-RPT-CCF           
           MOVE WS-BTU-FACTOR                  TO   P-RPT-BTU           
           MOVE WS-THERMS                      TO   P-RPT-THERM         
           MOVE WS-DEKATHERMS                  TO   P-RPT-DEKATHERMS    
           MOVE WS-DETAIL-LINE1                TO   PRT33-RECORD        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT           
           ADD  WS-ONE                         TO   WS-LINE-COUNT.      
                                                                        
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
T25836     MOVE WS-COMMENT-FTR                 TO PRT33-RECORD.         
T25836     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
T25836     MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
T25836     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
C25991     MOVE WS-COMMENT-FTR1                TO PRT33-RECORD.         
C25991     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
C25991     MOVE WS-BLANK-LINE                  TO PRT33-RECORD.         
C25991     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           MOVE WS-FOOTER1                     TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-TITLES.                                      **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                         TO   WS-ACTIVE-PARAGRAPH.
                                                                        
      *    PRINTS COMPANY NAME                                                  
           IF WS-PAGE-COUNT GREATER THAN WS-ONE1                        
              MOVE WS-BLANK-LINE               TO PRT33-RECORD          
              PERFORM 8900-WRITE-REPORT        THRU 8900-EXIT           
              ADD WS-ONE                       TO WS-LINE-COUNT         
           END-IF.                                                      
           ADD 1                               TO WS-PAGE-COUNT.        
           MOVE WS-PAGE-COUNT                  TO WS-REP-PAGE.          
      *    MOVE WS-PGRMNAME                    TO P-RPT-TITLE-PGNM.             
      *    MOVE WS-COMP-NAME                   TO P-RPT-COMP-NAME.              
           MOVE WS-RPT-TITLE-1                 TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD WS-ONE                          TO WS-LINE-COUNT.        
                                                                        
      *    PRINTS REPORT TITLE                                                  
                                                                        
           MOVE    WS-RPT-TITLE-2              TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
           MOVE    WS-RPT-TITLE-3              TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
           MOVE    WS-BLANK-LINE               TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
           MOVE    WS-RPT-HEADER-0             TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
           MOVE    WS-RPT-HEADER-1             TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
           MOVE    WS-RPT-HEADER-0             TO PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           ADD     WS-ONE                      TO WS-LINE-COUNT.        
                                                                        
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8900-WRITE-REPORT.                                               
                                                                        
           MOVE '8900'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              WRITE PRT33-RECORD AFTER ADVANCING PAGE                   
              MOVE  WS-ZERO                    TO WS-LINE-COUNT         
           ELSE                                                         
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP226  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   ACCOUNT NO ', AT-ACCOUNT-NO.                   
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND                  THRU 9900-EXIT.          
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
C25991******************************************************************        
C25991* 9700-PROCESS-ABEND  (REQUIED BY CPD00074)                      *        
C25991******************************************************************        
C25991 COPY CPD0023B.                                                           
C25991*                                                                         
