       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP212.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. APR-2001.                                          
       *****************************************************************
       **               SOUTH CAROLINA ELECTRIC & GAS                 **
       **                      COVANSYS-CHENNAI                       **
       **                                                             **
       *****************************************************************
       ********            FIELD CASH SYSTEM                   *********
       *****************************************************************
       **                                                             **
       **              PROGRAM  MODIFICATION  LOG                     **
       **                                                             **
       **     DATE       INITIALS              REASON                 **
       **   04-13-2001   COVANSYS              NEW REPORT PROGRAM     **
       **                                      FOR REPORT GENERATION  **
       *****************************************************************
             REMARKS.                                                   
       *****************************************************************
       *****************************************************************
       *        REPORT GENERATOR FOR PCSRP212 REPORTS                  *
       *        THIS IS A NEW PROGRAM WRITTEN FOR GENERATING           *
       *        BATCH DID NOT CLOSE EACH DAY                           *
       *****************************************************************
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP212'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSRP212 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-ONE                    PIC 9(02)  VALUE 01.           
           05  WS-ZERO                   PIC 9(02)  VALUE 00.           
           05  WS-SYSIN-COMP-NO          PIC X(02)  VALUE SPACES.       
           05  WS-PREV-CASH-LOCAL-OFFICE PIC X(03)  VALUE SPACES.       
           05  WS-BATCH-TOTAL-CNTR       PIC 9(03)  VALUE ZERO.         
           05  WS-MAX-LINES              PIC 9(02)  VALUE 56.           
           05  WS-LINE-COUNT             PIC 9(02)  VALUE 57.           
           05  WS-PAGE-COUNT             PIC 9(03)  VALUE ZERO.         
           05  WS-PREV-BATCH             PIC 9(04)  VALUE ZERO.         
           05  WS-ERR-MSG                PIC X(50)  VALUE SPACES.       
           05  WS-CLEAR-CASH             PIC X(08)  VALUE 'CLR-CASH'.   
           05  WS-ACTIVE                 PIC X(06)  VALUE 'ACTIVE'.     
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
COB305     05 WS-BATCH-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305     05 WS-LEDGER-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSRP212'.   
           05  WS-PGRNAME                PIC X(08)  VALUE 'PCSRP212'.   
           05  WS-COMP-NAME              PIC X(31)  VALUE  SPACES.      
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-GL-ACCT-FLAG           PIC X(01)  VALUE 'N'.          
           05  WS-DATE-CASH-REPORT.                                     
               10  WS-REP-MM             PIC X(02).                     
               10  FILLER                PIC X(01)  VALUE '-'.          
               10  WS-REP-DD             PIC X(02).                     
               10  FILLER                PIC X(01)  VALUE '-'.          
               10  WS-REP-CCYY           PIC X(04).                     
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-FILE-STATUS             PIC X(02).                     
              88 SUCCESSFUL                         VALUE '00'.         
           05 WS-MORE-ROWS-FLAG          PIC X(01)  VALUE 'Y'.          
              88 END-OF-ROWS                        VALUE 'N'.          
              88 MORE-ROWS                          VALUE 'Y'.          
           05 WS-SYSIN-EXIST             PIC X(01)  VALUE 'Y'.          
              88  SYSIN-EXISTS                      VALUE 'Y'.          
              88  SYSIN-DOES-NOT-EXIST              VALUE 'N'.          
           05 WS-NO-BATCH-FLAG           PIC X(01)  VALUE 'N'.          
           05 WS-CASH-GL-NUM             PIC X(01)  VALUE 'N'.          
              88 CASH-GL-ACCT                       VALUE 'Y'.          
              88 NOT-CASH-GL                        VALUE 'N'.          
           05 WS-LIHEAP-PMT              PIC X(01)  VALUE 'N'.          
              88 LIHEAP-PAYMENT                     VALUE 'Y'.          
              88 NOT-LIHEAP-PAYMENT                 VALUE 'N'.          
           05 WS-LIHEAP-RVSL             PIC X(01)  VALUE 'N'.          
              88 LIHEAP-REVERSAL                    VALUE 'Y'.          
              88 NOT-LIHEAP-REVERSAL                VALUE 'N'.          
                                                                        
      ***************** PCSRP212 REPORT HEADERS **********************          
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
           05 WS-RPT-TITLE-1.                                           
              10  FILLER                 PIC X(02)  VALUE SPACES.       
              10  P-RPT-TITLE-PGNM       PIC X(08).                     
              10  FILLER                 PIC X(42)  VALUE SPACES.       
              10  P-RPT-COMP-NAME        PIC X(31).                     
              10  FILLER                 PIC X(30)  VALUE SPACES.       
              10  FILLER                 PIC X(09)  VALUE 'RUN-DATE:'.  
              10  P-RPT-RUN-MM           PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
              10  P-RPT-RUN-DD           PIC X(02).                     
              10  FILLER                 PIC X(01)  VALUE '/'.          
              10  P-RPT-RUN-YY           PIC X(02).                     
              10  FILLER                 PIC X(03)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
           05 WS-RPT-TITLE-2.                                           
              10 FILLER                  PIC X(02)  VALUE SPACES.       
              10 FILLER                  PIC X(05)  VALUE 'DATE:'.      
              10 WS-CUR-MM               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE '/'.          
              10 WS-CUR-DD               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE '/'.          
              10 WS-CUR-YY               PIC X(02).                     
              10 FILLER                  PIC X(27)  VALUE SPACES.       
              10 FILLER                  PIC X(33)  VALUE               
                      'REPORT OF CASH DRAWER STATUS FOR:'.              
              10 WS-REPORT-MM            PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE '-'.          
              10 WS-REPORT-DD            PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE '-'.          
              10 WS-REPORT-YY            PIC X(02).                     
              10 FILLER                  PIC X(30)  VALUE SPACES.       
              10 FILLER                  PIC X(09)  VALUE 'RUN TIME:'.  
              10 WS-REP-HH               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-MIN              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-SS               PIC X(02).                     
              10 FILLER                  PIC X(03)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
           05 WS-RPT-TITLE-3.                                           
              10 FILLER                  PIC X(113) VALUE SPACES.       
              10 FILLER                  PIC X(10)  VALUE 'PAGE    : '. 
              10 FILLER                  PIC X(03)  VALUE SPACES.       
              10 WS-REP-PAGE             PIC ZZZ9.                      
              10 FILLER                  PIC X(03)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER.       **            
      ***************************************************************           
           05 WS-RPT-HEADER.                                            
              10 FILLER                  PIC X(03)  VALUE SPACES.       
              10 FILLER                  PIC X(15)  VALUE               
                      'CASH COMPANY NO'.                                
              10 FILLER                  PIC X(03)  VALUE SPACES.       
              10 FILLER                  PIC X(17)  VALUE               
                      'CASH LOCAL OFFICE'.                              
              10 FILLER                  PIC X(03)  VALUE SPACES.       
              10 FILLER                  PIC X(14)  VALUE               
                      'CASH DRAWER ID'.                                 
              10 FILLER                  PIC X(02)  VALUE SPACES.       
              10 FILLER                  PIC X(07)  VALUE               
                      'USER ID'.                                        
              10 FILLER                  PIC X(08)  VALUE SPACES.       
              10 FILLER                  PIC X(12)  VALUE               
                      'CASHIER CODE'.                                   
              10 FILLER                  PIC X(10)  VALUE SPACES.       
              10 FILLER                  PIC X(18)  VALUE               
                       'CASH DRAWER STATUS'.                            
              10 FILLER                  PIC X(05)  VALUE SPACES.       
              10 FILLER                  PIC X(12)  VALUE               
                      'BATCH AMOUNT'.                                   
              10 FILLER                  PIC X(10)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
                                                                        
      ***************************************************************           
                                                                        
       01  WS-DETAIL-LINE.                                              
           10 FILLER                     PIC X(10)  VALUE SPACES.       
           10 WS-COMPANY-NO              PIC X(02).                     
           10 FILLER                     PIC X(17)  VALUE SPACES.       
           10 WS-LOCAL-OFFICE            PIC X(03).                     
           10 FILLER                     PIC X(15)  VALUE SPACES.       
           10 WS-CSH-DRWR-ID             PIC X(04).                     
           10 FILLER                     PIC X(06)  VALUE SPACES.       
           10 WS-USER-ID                 PIC X(07).                     
           10 FILLER                     PIC X(13)  VALUE SPACES.       
           10 WS-CASHIER-CODE            PIC X(02).                     
           10 FILLER                     PIC X(20)  VALUE SPACES.       
           10 WS-CSH-DRWR-STATUS         PIC X(06).                     
           10 FILLER                     PIC X(10)  VALUE SPACES.       
           10 WS-REPORT-AMT              PIC --------9.99.              
           10 FILLER                     PIC X(14)  VALUE SPACES.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                     PIC X(48)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '**** NO DATA THIS RUN****'.                             
           05 FILLER                     PIC X(55)  VALUE SPACES.       
                                                                        
       01  WS-FOOTER1.                                                  
           05 FILLER                     PIC X(35)  VALUE SPACES.       
           05 FILLER                     PIC X(25)  VALUE               
               '* * * END OF REPORT * * *'.                             
           05 FILLER                     PIC X(72)  VALUE SPACES.       
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME               PIC 9(08).                     
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)  VALUE 'Y'.          
           05 WS-N                       PIC X(01)  VALUE 'N'.          
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CSH_DRWR_CNTL                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCDCNTL                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_CSH_DRWR_JRNL                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCDJRNL                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_GL_ACCT_NO                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBGLATNO                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_LIEAP_AGENCY                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBLIAGCY                                                 
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * BATCH_ACTIVE CURSOR FOR FETCHING FROM CSS_CSH_DRWR_CNTL       *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
                DECLARE BATCH_ACTIVE CURSOR FOR                         
                   SELECT CASH_COMPANY_NO                               
                         ,CASH_LOCAL_OFFICE                             
                         ,CASH_REPORT_NO                                
                         ,CASH_DRAWER_ID                                
                         ,USER_ID                                       
                         ,CASHIER_CODE                                  
                         ,CODE_CSH_DRWR_STAT                            
                    FROM  CSS_CSH_DRWR_CNTL                             
                   WHERE  DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )     
                     AND  CASH_COMPANY_NO    = :WS-SYSIN-COMP-NO        
                     AND  CODE_CSH_DRWR_STAT = 'A'                      
                     AND  CASH_LOCAL_OFFICE  <> '998'                   
                     AND  CASH_LOCAL_OFFICE  <> '001'                   
                ORDER BY  CASH_COMPANY_NO,                              
                          CASH_LOCAL_OFFICE,                            
                          CASH_DRAWER_ID                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BATCH_ACTIVE CURSOR FOR                                 
MFA-TR*            SELECT CASH_COMPANY_NO                                       
MFA-TR*                  ,CASH_LOCAL_OFFICE                                     
MFA-TR*                  ,CASH_REPORT_NO                                        
MFA-TR*                  ,CASH_DRAWER_ID                                        
MFA-TR*                  ,USER_ID                                               
MFA-TR*                  ,CASHIER_CODE                                          
MFA-TR*                  ,CODE_CSH_DRWR_STAT                                    
MFA-TR*             FROM  CSS_CSH_DRWR_CNTL                                     
MFA-TR*            WHERE  DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT             
MFA-TR*              AND  CASH_COMPANY_NO    = :WS-SYSIN-COMP-NO                
MFA-TR*              AND  CODE_CSH_DRWR_STAT = 'A'                              
MFA-TR*              AND  CASH_LOCAL_OFFICE  <> '998'                           
MFA-TR*              AND  CASH_LOCAL_OFFICE  <> '001'                           
MFA-TR*         ORDER BY  CASH_COMPANY_NO,                                      
MFA-TR*                   CASH_LOCAL_OFFICE,                                    
MFA-TR*                   CASH_DRAWER_ID                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * GET_AMT CURSOR FOR FETCHING FROM CSS_CSH_DRWR_JRNL            *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
                DECLARE GET_AMT CURSOR FOR                              
                   SELECT TRAN_DATA                                     
                     FROM CSS_CSH_DRWR_JRNL                             
                    WHERE COMPANY_NO        = :CJ-CASH-COMPANY-NO       
                      AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE     
                      AND CASH_REPORT_NO    = :CJ-CASH-REPORT-NO        
                      AND CASH_DRAWER_ID    = :CJ-CASH-DRAWER-ID        
                      AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
                      AND USER_ID           = :CJ-USER-ID               
                 ORDER BY ENTRY_NO                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE GET_AMT CURSOR FOR                                      
MFA-TR*            SELECT TRAN_DATA                                             
MFA-TR*              FROM CSS_CSH_DRWR_JRNL                                     
MFA-TR*             WHERE COMPANY_NO        = :CJ-CASH-COMPANY-NO               
MFA-TR*               AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE             
MFA-TR*               AND CASH_REPORT_NO    = :CJ-CASH-REPORT-NO                
MFA-TR*               AND CASH_DRAWER_ID    = :CJ-CASH-DRAWER-ID                
MFA-TR*               AND DATE_CASH_REPORT  = :CJ-DATE-CASH-REPORT              
MFA-TR*               AND USER_ID           = :CJ-USER-ID                       
MFA-TR*          ORDER BY ENTRY_NO                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *        CURSOR FOR CSS_LIEAP_AGENCY                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE LIEAP_CURSOR CURSOR FOR                         
                 SELECT :WS-YES                                         
                   FROM CSS_LIEAP_AGENCY                                
                  WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                    
                    AND COMPANY_NO  = :I5-COMPANY-NO                    
               OPTION(FAST 1)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE LIEAP_CURSOR CURSOR FOR                                 
MFA-TR*          SELECT :WS-YES                                                 
MFA-TR*            FROM CSS_LIEAP_AGENCY                                        
MFA-TR*           WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                            
MFA-TR*             AND COMPANY_NO  = :I5-COMPANY-NO                            
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSRP212 ENDS HERE  '.                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO  WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
      * GET CURRENT DATE                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO   P-RPT-RUN-YY.           
           MOVE   WS-CURRENT-MM            TO   P-RPT-RUN-MM.           
           MOVE   WS-CURRENT-DD            TO   P-RPT-RUN-DD.           
                                                                        
      * GET CURRENT TIME                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
           MOVE   WS-CURRENT-TIME(1:2)     TO   WS-REP-HH.              
           MOVE   WS-CURRENT-TIME(3:2)     TO   WS-REP-MIN.             
           MOVE   WS-CURRENT-TIME(5:2)     TO   WS-REP-SS.              
                                                                        
                                                                        
      * SET UP DATE                                                             
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '              TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE WS-PGRNAME              TO WS-PGRMNAME               
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE(3:2)         TO WS-CUR-YY,WS-REPORT-YY.   
           MOVE WS-INPUT-DATE(6:2)         TO WS-CUR-MM,WS-REPORT-MM.   
           MOVE WS-INPUT-DATE(9:2)         TO WS-CUR-DD,WS-REPORT-DD.   
                                                                        
           MOVE WS-INPUT-DATE              TO WS-DATE-CASH-REPORT,      
                                              CS-DATE-CASH-REPORT.      
                                                                        
           ACCEPT WS-SYSIN-COMP-NO         FROM SYSIN.                  
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N                   TO WS-SYSIN-EXIST            
           END-IF.                                                      
                                                                        
                                                                        
      * SELECT COMPANY NAME                                                     
                                                                        
           IF SYSIN-EXISTS                                              
              MOVE WS-SYSIN-COMP-NO        TO C7-COMPANY-NO             
              PERFORM 7800-GET-COMPANY-DESC                             
                                           THRU 7800-EXIT               
           END-IF.                                                      
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7100-OPEN-BATCH-ACTIVE-CURSOR                        
                                           THRU 7100-EXIT.              
                                                                        
           PERFORM 7200-FETCH-BATCH-ACTIVE-CURSOR                       
                                           THRU 7200-EXIT               
                                           UNTIL END-OF-ROWS            
                                                                        
           PERFORM 7300-CLOSE-BATCH-ACTIVE-CURSOR                       
                                           THRU 7300-EXIT.              
                                                                        
           PERFORM 8400-PRINT-RPT-FOOTER                                
                                           THRU 8400-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     2100-PROCESS-DETAILS-PARA                             **           
      **          FECTHES THE TRAN DATA FROM  CSS_CSH_DRWR_JRNL    **           
      **          TABLE.                                           **           
      **                                                           **           
      ***************************************************************           
                                                                        
       2100-PROCESS-DETAILS-PARA.                                       
                                                                        
           MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              INITIALIZE WS-BATCH-AMT, WS-LEDGER-AMT                    
              ADD 1                        TO WS-BATCH-TOTAL-CNTR       
              MOVE CS-USER-ID              TO CJ-USER-ID                
              MOVE CS-CASH-REPORT-NO       TO CJ-CASH-REPORT-NO         
              MOVE CS-CASH-DRAWER-ID       TO CJ-CASH-DRAWER-ID         
              MOVE CS-CASH-COMPANY-NO      TO CJ-CASH-COMPANY-NO,       
                                              GO-COMPANY-NO             
              MOVE CS-CASH-COMPANY-NO      TO I5-COMPANY-NO             
              MOVE CS-CASH-LOCAL-OFFICE    TO CJ-CASH-LOCAL-OFFICE      
              MOVE CS-DATE-CASH-REPORT     TO CJ-DATE-CASH-REPORT       
              PERFORM 7400-SELECT-GL-ACCT-NO                            
                                           THRU 7400-EXIT               
              PERFORM 7500-OPEN-GET-AMT-CURSOR                          
                                           THRU 7500-EXIT               
              PERFORM 7550-FETCH-GET-AMT-CURSOR                         
                                           THRU 7550-EXIT               
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
              PERFORM 7700-CLOSE-GET-AMT-CURSOR                         
                                           THRU 7700-EXIT               
              PERFORM 8000-PRINT-RPT-REPORT                             
                                           THRU 8000-EXIT               
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **   2300-CALCULATE-AMT                                  **               
      **       CALCULATES THE AMOUNT                           **               
      **                                                       **               
      ***********************************************************               
                                                                        
       2300-CALCULATE-AMT.                                              
                                                                        
           MOVE '2300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE CJF00101.                                         
                                                                        
           SET NOT-CASH-GL                 TO TRUE                      
           SET NOT-LIHEAP-PAYMENT          TO TRUE                      
           SET NOT-LIHEAP-REVERSAL         TO TRUE                      
                                                                        
           MOVE CJ-TRAN-DATA               TO CJF00101.                 
                                                                        
           IF  WS-101-ACCT-GEN-LED-DR = WS-101-ACCT-GEN-LED-CR          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-101-ACCT-GEN-LED-DR = GO-GL-ACCT-NO OR            
                   WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO               
                   SET CASH-GL-ACCT        TO TRUE                      
               ELSE                                                     
                   MOVE WS-101-ACCT-GEN-LED-DR                          
                                           TO I5-GL-ACCT-NO             
                   PERFORM 2400-CHECK-GL-NUM                            
                                           THRU 2400-EXIT               
                                                                        
                   IF  WS-GL-ACCT-FLAG = WS-YES                         
                       SET LIHEAP-PAYMENT  TO TRUE                      
                   ELSE                                                 
                       MOVE WS-101-ACCT-GEN-LED-CR                      
                                           TO I5-GL-ACCT-NO             
                       PERFORM 2400-CHECK-GL-NUM                        
                                           THRU 2400-EXIT               
                       IF  WS-GL-ACCT-FLAG = WS-YES                     
                           SET LIHEAP-REVERSAL                          
                                           TO TRUE                      
                       END-IF                                           
                   END-IF                                               
                   MOVE WS-NO              TO WS-GL-ACCT-FLAG           
               END-IF                                                   
                                                                        
               IF  CASH-GL-ACCT OR LIHEAP-PAYMENT OR                    
                   LIHEAP-REVERSAL                                      
                   MOVE WS-101-AMT-POSTED  TO WS-LEDGER-AMT             
                                                                        
                   IF  WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO OR        
                        LIHEAP-REVERSAL                                 
                       MULTIPLY -1 BY WS-LEDGER-AMT                     
                   END-IF                                               
                                                                        
                   ADD WS-LEDGER-AMT       TO WS-BATCH-AMT              
               END-IF                                                   
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2400-CHECK-GL-NUM                                             *        
      *                                                                *        
      *    TO CHECK WHETHER GL_ACCT_NO IS IN THE CSS_LIEAP_AGENCY      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2400-CHECK-GL-NUM.                                               
                                                                        
           MOVE '2400'                     TO   WS-ACTIVE-PARAGRAPH.    
           PERFORM 7900-OPEN-LIEAP-CURSOR  THRU 7900-EXIT.              
           PERFORM 7920-FETCH-LIEAP-CURSOR THRU 7920-EXIT.              
           PERFORM 7940-CLOSE-LIEAP-CURSOR THRU 7940-EXIT.              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7100-OPEN-BATCH-ACTIVE-CURSOR                          **           
      **         OPENS THE CURSOR TO FETCH ROWS                    **           
      **          FROM CSS_CSH_DRWR_CNTL TABLE                     **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7100-OPEN-BATCH-ACTIVE-CURSOR.                                   
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN BATCH_ACTIVE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN BATCH ACTIVE CURSOR ERROR'                     
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7200-FETCH-BATCH-ACTIVE-CURSOR                         **           
      **         FETCH ROWS FROM CSS_CSH_DRWR_CNTL TABLE           **           
      **         WHERE CASH DRAWER STATUS IS ACTIVE                **           
      **         FOR THE GIVEN DATE                                **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7200-FETCH-BATCH-ACTIVE-CURSOR.                                  
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH BATCH_ACTIVE INTO                                 
                   :CS-CASH-COMPANY-NO,                                 
                   :CS-CASH-LOCAL-OFFICE,                               
                   :CS-CASH-REPORT-NO,                                  
                   :CS-CASH-DRAWER-ID,                                  
                   :CS-USER-ID,                                         
                   :CS-CASHIER-CODE,                                    
                   :CS-CODE-CSH-DRWR-STAT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   PERFORM 2100-PROCESS-DETAILS-PARA                    
                                           THRU 2100-EXIT               
                                                                        
              WHEN NOT-FOUND                                            
                   IF (WS-BATCH-TOTAL-CNTR = 0)                         
                      MOVE WS-Y TO WS-NO-BATCH-FLAG                     
                      PERFORM 8100-PRINT-RPT-NO-DATA                    
                                           THRU 8100-EXIT               
                   END-IF                                               
                   SET END-OF-ROWS         TO TRUE                      
                                                                        
              WHEN OTHER                                                
                   MOVE 'ERROR IN FETCHING BATCH ACTIVE CURSOR'         
                                           TO WS-ERR-MSG                
                   MOVE SQLCODE            TO WS-DISP-RC                
                   PERFORM 9900-ABEND      THRU 9900-EXIT               
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7300-CLOSE-BATCH-ACTIVE-CURSOR                         **           
      **         CLOSES CURSOR ON CSS_CSH_DRWR_CNTL TABLE          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7300-CLOSE-BATCH-ACTIVE-CURSOR.                                  
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE BATCH_ACTIVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'CLOSE BATCH ACTIVE CURSOR ERROR'                    
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7400-SELECT-GL-ACCT-NO                                 **           
      **         SELECTS GL_ACCT_NO FROM CSS_GL_ACCT_NO TABLE      **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7400-SELECT-GL-ACCT-NO.                                          
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT  GL_ACCT_NO                                      
                  INTO  :GO-GL-ACCT-NO                                  
                  FROM  CSS_GL_ACCT_NO                                  
                 WHERE  COMPANY_NO   = :GO-COMPANY-NO                   
                   AND  GL_ACCT_NAME = :WS-CLEAR-CASH                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'SELECT ERROR IN GL-ACCT-NO'                         
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7500-OPEN-GET-AMT-CURSOR                               **           
      **         OPENS THE CURSOR TO FETCH ROWS                    **           
      **         FROM CSS_CSH_DRWR_JRNL TABLE                      **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7500-OPEN-GET-AMT-CURSOR.                                        
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN GET_AMT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN GET AMT CURSOR ERROR'                          
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7550-FETCH-GET-AMT-CURSOR                              **           
      **         FETCH TRAN_DATA FROM CSS_CSH_DRWR_JRNL TABLE      **           
      **         FOR THE USER FETCHED FROM BATCH_ACTIVE CURSOR     **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7550-FETCH-GET-AMT-CURSOR.                                       
                                                                        
           MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               FETCH GET_AMT                                            
                INTO :CJ-TRAN-DATA                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
              WHEN SUCCESSFUL-CALL                                      
                   PERFORM 2300-CALCULATE-AMT                           
                      THRU 2300-EXIT                                    
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE 'ERROR IN FETCHING BATCH ACTIVE CURSOR'         
                                           TO WS-ERR-MSG                
                   MOVE SQLCODE            TO WS-DISP-RC                
                   PERFORM 9900-ABEND      THRU 9900-EXIT               
                                                                        
           END-EVALUATE                                                 
           .                                                            
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7700-CLOSE-GET-AMT-CURSOR                              **           
      **         CLOSES CURSOR ON CSS_CSH_DRWR_JRNL TABLE          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7700-CLOSE-GET-AMT-CURSOR.                                       
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE GET_AMT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'CLOSE GET AMT CURSOR ERROR'                         
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
                                                                        
       7800-GET-COMPANY-DESC.                                           
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY                                         
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME         TO WS-COMP-NAME              
            ELSE                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE '** COMPANY NO DOES NOT EXIST IN CSS_COMPANY **'  
                                           TO WS-ERR-MSG                
                  MOVE SQLCODE             TO WS-DISP-RC                
                  PERFORM 9100-DISPLAY-ERROR                            
                                           THRU 9100-EXIT               
               ELSE                                                     
                  MOVE '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'    
                                           TO WS-ERR-MSG                
                  MOVE SQLCODE             TO WS-DISP-RC                
                  PERFORM 9100-DISPLAY-ERROR                            
                                           THRU 9100-EXIT               
               END-IF                                                   
            END-IF.                                                     
                                                                        
        7800-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7900-OPEN-LIEAP-CURSOR                                      *        
      *         TO OPEN THE LIEAP_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7900-OPEN-LIEAP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN LIEAP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                 TO WS-DISP-RC                
              MOVE 'OPEN  LIEAP_CURSOR  ERROR'                          
                                           TO WS-ERR-MSG                
              PERFORM 9100-DISPLAY-ERROR   THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7920-FETCH-LIEAP-CURSOR                                     *        
      *         TO FETCH THE LIEAP_CURSOR                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7920-FETCH-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH LIEAP_CURSOR                                      
                 INTO :WS-GL-ACCT-FLAG                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'ERROR IN FETCHING LIEAP_CURSOR '                   
                                           TO WS-ERR-MSG                
               MOVE SQLCODE                TO WS-DISP-RC                
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7940-CLOSE-LIEAP-CURSOR                                     *        
      *          TO CLOSE THE LIEAP_CURSOR                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7940-CLOSE-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE LIEAP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                TO WS-DISP-RC                
               MOVE 'CLOSE  LIEAP_CURSOR  ERROR'                        
                                           TO WS-ERR-MSG                
               PERFORM 9100-DISPLAY-ERROR  THRU 9100-EXIT               
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF  WS-PREV-CASH-LOCAL-OFFICE NOT EQUAL CS-CASH-LOCAL-OFFICE 
               MOVE 57                     TO WS-LINE-COUNT             
               MOVE CS-CASH-LOCAL-OFFICE   TO WS-PREV-CASH-LOCAL-OFFICE 
           END-IF.                                                      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
                 PERFORM 8500-PRINT-RPT-HEADERS                         
                                           THRU 8500-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS  THRU 8300-EXIT.              
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8100-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                     TO   WS-ACTIVE-PARAGRAPH.    
           PERFORM 8500-PRINT-RPT-HEADERS  THRU 8500-EXIT.              
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           MOVE WS-NO-DATA-LINE            TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8100-EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-DETAILS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE CS-CASH-COMPANY-NO         TO WS-COMPANY-NO.            
           MOVE CS-CASH-LOCAL-OFFICE       TO WS-LOCAL-OFFICE.          
           MOVE CS-CASHIER-CODE            TO WS-CASHIER-CODE.          
           MOVE CS-USER-ID                 TO WS-USER-ID.               
           MOVE CS-CASH-DRAWER-ID          TO WS-CSH-DRWR-ID.           
           MOVE WS-ACTIVE                  TO WS-CSH-DRWR-STATUS.       
           MOVE WS-BATCH-AMT               TO WS-REPORT-AMT             
           MOVE WS-DETAIL-LINE             TO PRT33-RECORD.             
           ADD  WS-ONE                     TO WS-LINE-COUNT.            
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE WS-BLANK-LINE              TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           MOVE WS-FOOTER1                 TO PRT33-RECORD.             
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
      *    PRINTS COMPANY NAME                                                  
                                                                        
           ADD 1                           TO   WS-PAGE-COUNT.          
           MOVE WS-PAGE-COUNT              TO   WS-REP-PAGE.            
           MOVE WS-PGRMNAME                TO   P-RPT-TITLE-PGNM.       
           MOVE WS-COMP-NAME               TO   P-RPT-COMP-NAME.        
           MOVE WS-RPT-TITLE-1             TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD WS-ONE                      TO WS-LINE-COUNT.            
                                                                        
      *    PRINTS REPORT TITLE                                                  
                                                                        
           MOVE    WS-RPT-TITLE-2          TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-TITLE-3          TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
      *    PRINTS REPORT HEADER                                                 
                                                                        
           MOVE    WS-BLANK-LINE           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-HEADER           TO   PRT33-RECORD.           
           PERFORM 8900-WRITE-REPORT       THRU 8900-EXIT.              
           ADD     WS-ONE                  TO   WS-LINE-COUNT.          
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8900-WRITE-REPORT.                                               
                                                                        
           MOVE '8900'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              WRITE PRT33-RECORD AFTER ADVANCING PAGE                   
              MOVE  WS-ZERO                TO WS-LINE-COUNT             
           ELSE                                                         
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
     ******************************************************************         
     **                                                              **         
     **  9100-DISPLAY-ERROR.                                         **         
     **       DISPLAY ERROR PARA                                     **         
     **                                                              **         
     ******************************************************************         
                                                                        
       9100-DISPLAY-ERROR.                                              
           DISPLAY '**   PROCESSING ERROR IN PCSRP212  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND              THRU 9900-EXIT.              
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  6240-GET-FCA00-COMMON-DATE                              *              
      ************************************************************              
                                                                        
      *COPY CPD00040.                                                           
                                                                        
      ************************************************************              
      *                                                          *              
      *  6251-GET-FJC01-DATE                                     *              
      *                                                          *              
      ************************************************************              
                                                                        
       COPY CPD00037.                                                           
                                                                        
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      *  7620-START-FCSCA00                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
