       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP191.                                        
       DATE-WRITTEN.   01/24/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  01/24/95     SC        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  --------     ----------------------------------  **         
      **  06/13/95     DW        REMOVED 'COPY CFDS'; CHANGED DATE   **         
      **                         FORMAT FOR CORRECT RUN-DATE; COR-   **         
      **                         RECTED SPACING & SPELLING ERRORS;   **         
      **                         CHANGED PROGRAM NAME FROM PCSCA191  **         
      **                         TO PCSRP191 & ALL REFERENCES IN PGM.**         
      **  --------  --------     ----------------------------------  **         
      **  11/27/95    JTH        ADDED COMPANY BREAK LOGIC FOR       **         
      **                         REPORTS                             **         
T13502**  10/29/97    MKN        CHANGED REPORT NAME FROM PCSRP191 TO**         
      **                         PCSR1911                            **         
T20405**  07/22/99    VB         SELECTED COMPANY DESC FROM HEADER   **         
T20405**                         FILE COMPANY NO                     **         
P00047**  01/29/09    CVNS       BBP CHANGES                         **         
P00047**              CHENNAI                                        **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP191 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA191.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA191.                                                           
       COPY FIOCA191.                                                           
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP191'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP191 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
                          'SOUTH CAROLINA ELEC. & GAS'.                 
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(35)    VALUE               
                          'DRAFTS NOT EQUAL TO ACCOUNT BALANCE'.        
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE2  PIC X(14)    VALUE               
                          'DAILY REGISTER'.                             
      *                                                                         
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
T20405     05  WS-REPORT-FTIME         PIC X(01)    VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE '  '.         
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
           05  WS-HEADER-COMP-NO       PIC X(02)    VALUE SPACES.       
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FCA191-REC-CNTR      PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FCA191-STATUS        PIC X(02).                       
               88  FCA191-SUCCESSFUL                VALUE '00'.         
      *                                                                         
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
T10414 01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP191'.   
T13502     05  WS-RPT-NAME             PIC X(08)    VALUE 'PCSR1911'.   
           05  WS-52                   PIC 9(02)    VALUE 52.           
      *                                                                         
      ****************** PCSRP191 REPORT HEADERS *********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACES.       
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(34)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(35).                       
               10  FILLER              PIC X(31)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER              PIC X(59)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(14).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X        VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                       'ACCOUNT NUMBER'.                
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                       '  DRAFT AMOUNT'.                
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
P00047                                 '   BBP BALANCE'.                
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                       'ACCOUNT BALANCE'.               
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X        VALUE SPACES.       
               10  P-ACCOUNT-NO        PIC 9(13).                       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  P-DRAFT-AMOUNT      PIC ZZZ,ZZZ,Z99.99-.             
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  P-EPP-BALANCE       PIC ZZZ,ZZZ,Z99.99-.             
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  P-ACCOUNT-BALANCE   PIC ZZZ,ZZZ,Z99.99-.             
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP191 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSCA191            THRU 7100-EXIT.        
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           IF SYSIN-EXISTS                                              
               IF WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                     
                   PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
                   PERFORM 8200-PRINT-RPT1-TITLE THRU 8200-EXIT         
                   PERFORM 8300-PRINT-RPT1-HEADERS THRU 8300-EXIT       
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF WS-FCA191-REC-CNTR EQUAL ZERO                         
                   PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT     
                   PERFORM 8200-PRINT-RPT1-TITLE THRU 8200-EXIT         
                   PERFORM 8300-PRINT-RPT1-HEADERS THRU 8300-EXIT       
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP191 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP191 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE               
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSCA191-FILE.                                    
           IF FCA191-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    PCSRP191 PROCESSING ERROR    **'          
               DISPLAY '**    OPEN ERROR OF FCSCA191 - INPUT FILE'      
               DISPLAY '**    FILE STATUS = ' WS-FCA191-STATUS          
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
                                                                        
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
T20405*    PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT                     
T20405*    PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT                     
T20405*    PERFORM 8300-PRINT-RPT1-HEADERS   THRU 8300-EXIT.                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSCA191-FILE         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSCA191            THRU 7100-EXIT.        
      *                                                                         
T20405     MOVE E-FCA191-BEGIN-CO-NO   TO C7-COMPANY-NO                 
T20405                                    WS-CURRENT-COMP-NO            
T20405                                    WS-HEADER-COMP-NO             
T20405     PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT                 
           IF E-FCA191-KEY-BREC EQUAL LOW-VALUES                        
               SUBTRACT 1 FROM WS-FCA191-REC-CNTR                       
               MOVE E-FCA191-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
           ELSE                                                         
               DISPLAY '**       PCSRP191 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      FCSCA191 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           ELSE                                                         
               IF  E-FCA191-CO-KEY-EREC EQUAL HIGH-VALUES OR            
                   E-FCA191-KEY-EREC    EQUAL HIGH-VALUES               
                   PERFORM 1700-CHECK-END-REC     THRU 1700-EXIT        
               ELSE                                                     
                   IF REPORT-STARTED                                    
                       PERFORM 2100-CHECK-COMP-NO THRU 2100-EXIT        
                   ELSE                                                 
                       MOVE WS-Y TO WS-START-REPORT                     
                       MOVE E-FCA191-COMPANY-NO TO WS-CURRENT-COMP-NO   
                       PERFORM 2100-CHECK-COMP-NO THRU 2100-EXIT        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSCA191             THRU 7100-EXIT.       
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       IT CHECKS WHETHER PROCESS END REC OR COMPANY END REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           IF E-FCA191-CO-NO-EREC EQUAL HIGH-VALUES                     
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           SUBTRACT 1 FROM WS-FCA191-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FCA191-CO-REC-COUNT-EREC         
               IF E-FCA191-CO-NO-EREC EQUAL WS-SYSIN-COMP-NO            
                   MOVE WS-Y TO WS-END-OF-SYSIN-REC                     
               END-IF                                                   
           ELSE                                                         
               IF E-FCA191-CO-NO-EREC EQUAL WS-SYSIN-COMP-NO            
                  DISPLAY '**      PCSRP191 PROCESSING ERROR       **'  
                  DISPLAY '**  COMPANY NO = ' E-FCA191-COMPANY-NO       
                  DISPLAY '** ACTUAL REC COUNT OF THE CO. DOES NOT **'  
                  DISPLAY '**         MATCH CONTROL RECORD         **'  
                  DISPLAY '** CONTROL REC COUNT = '                     
                                     E-FCA191-CO-REC-COUNT-EREC         
                  DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR    
                  DISPLAY '**         PROCESSING TERMINATED        **'  
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
               ELSE                                                     
                  DISPLAY '**      PCSRP191 PROCESSING ERROR       **'  
                  DISPLAY '**  COMPANY NO = ' E-FCA191-CO-NO-EREC       
                  DISPLAY '** ACTUAL REC COUNT OF THE CO. DOES NOT **'  
                  DISPLAY '**         MATCH CONTROL RECORD         **'  
                  DISPLAY '** CONTROL REC COUNT = '                     
                                     E-FCA191-CO-REC-COUNT-EREC         
                  DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR    
                  DISPLAY '**         PROCESSING CONTINUES         **'  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FCA191-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**        PCSRP191 PROCESSING ERROR         **' 
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD   **' 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FCA191-REC-CNTR EQUAL E-FCA191-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP191 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FCA191-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FCA191-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           IF COMPANY-CHANGED                                           
               IF SYSIN-EXISTS                                          
                   CONTINUE                                             
               ELSE                                                     
                   MOVE 60             TO WS-RPT1-LINE-NO               
               END-IF                                                   
               MOVE E-FCA191-COMPANY-NO                                 
                                       TO WS-CURRENT-COMP-NO            
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
           END-IF.                                                      
      *                                                                         
           IF E-FCA191-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO          
               DISPLAY '**       PCSRP191 PROCESSING ERROR        **'   
               DISPLAY '**   COMPANY DATA RECORDS NOT SEPARATED   **'   
               DISPLAY '**     WITH PROPER COMPANY END-RECORD     **'   
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FCA191-COMPANY-NO 
               DISPLAY '** DATA IS :' E-FCA191-DATA-REC                 
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                  IF E-FCA191-COMPANY-NO EQUAL WS-SYSIN-COMP-NO         
                      IF NOT-END-OF-SYSIN                               
                         IF E-FCA191-DRAFT-AMOUNT NOT EQUAL             
                                                    E-FCA191-EPP-BALANCE
                            PERFORM 2200-PRODUCE-RPT1 THRU 2200-EXIT    
                            ADD 1           TO WS-SYSIN-COMP-REC-CNTR   
                         ELSE                                           
                            SUBTRACT 1 FROM WS-FCA191-REC-CNTR          
                            GO TO 2100-EXIT                             
                         END-IF                                         
                      ELSE                                              
                         DISPLAY '**   PCSRP191 PROCESSING ERROR     **'
                         DISPLAY '** INPUT FILE NOT SORTED PROPERLY  **'
                         DISPLAY '**   IN ORDER OF COMPANY NUMBERS   **'
                         DISPLAY '** DATA IS :' E-FCA191-DATA-REC       
                         DISPLAY '**     PROCESSING TERMINATED       **'
                         PERFORM 9900-ABEND        THRU 9900-EXIT       
                      END-IF                                            
                  END-IF                                                
               ELSE                                                     
                  IF E-FCA191-DRAFT-AMOUNT NOT EQUAL                    
                                                E-FCA191-EPP-BALANCE    
                     PERFORM 2200-PRODUCE-RPT1     THRU 2200-EXIT       
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT1                                        **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT1.                                               
      *                                                                         
           IF E-FCA191-DRAFT-AMOUNT NOT EQUAL E-FCA191-EPP-BALANCE      
              IF WS-RPT1-LINE-NO GREATER THAN WS-52                     
                  PERFORM 8100-PRINT-RPT1-COMP-NAME THRU 8100-EXIT      
                  PERFORM 8200-PRINT-RPT1-TITLE     THRU 8200-EXIT      
                  PERFORM 8300-PRINT-RPT1-HEADERS   THRU 8300-EXIT      
T20405        ELSE                                                      
T20405           IF WS-REPORT-FTIME EQUAL WS-Y                          
T20405              MOVE WS-N               TO WS-REPORT-FTIME          
T20405              PERFORM 8100-PRINT-RPT1-COMP-NAME                   
T20405                                           THRU 8100-EXIT         
T20405              PERFORM 8200-PRINT-RPT1-TITLE THRU 8200-EXIT        
T20405              PERFORM 8300-PRINT-RPT1-HEADERS                     
T20405                                           THRU 8300-EXIT         
T20405           END-IF                                                 
              END-IF                                                    
              PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT          
              PERFORM 8900-PRINT-RPT1-DETAIL    THRU 8900-EXIT          
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FCA191-ACCOUNT-NO    TO P-ACCOUNT-NO.                 
           MOVE E-FCA191-DRAFT-AMOUNT  TO P-DRAFT-AMOUNT.               
           MOVE E-FCA191-EPP-BALANCE   TO P-EPP-BALANCE.                
           MOVE E-FCA191-ACCOUNT-BALANCE                                
                                       TO P-ACCOUNT-BALANCE.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSCA191                                       **          
      **       READS THE INPUT FILE FCSCA191-FILE                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSCA191.                                              
      *                                                                         
           READ FCSCA191-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FCA191-SUCCESSFUL                                         
               ADD 1                   TO WS-FCA191-REC-CNTR            
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSCA191 READ.  STATUS IS '       
                        WS-FCA191-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
               FROM  CSS_COMPANY                                        
                WHERE    COMPANY_NO = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7800-GET-COMPANY-DESC *'  
                   DISPLAY '* RETURN CODE = ' SQLCODE                   
                   DISPLAY '*        PROCESSING TERMINATED          *'  
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-RPT1-COMP-NAME                            **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-RPT1-COMP-NAME.                                       
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
T13502     MOVE WS-RPT-NAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           IF SYSIN-EXISTS                                              
               CONTINUE                                                 
           ELSE                                                         
               IF WS-CURRENT-COMP-NO NOT EQUAL WS-HEADER-COMP-NO        
                   MOVE WS-CURRENT-COMP-NO                              
                                       TO C7-COMPANY-NO,                
                                          WS-HEADER-COMP-NO             
                   PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-RPT1-TITLE                                    **          
      **       PRINTS THE TITLES  FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-RPT1-TITLE.                                           
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-RPT1-HEADERS                                  **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-RPT1-HEADERS.                                         
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                 AFTER ADVANCING 3 LINES.                               
      *                                                                         
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 4                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-RPT1-DETAIL                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP191        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-RPT1-DETAIL.                                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA191-FILE.                                         
           IF FCA191-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSRP191 PROCESSING ERROR  **'              
               DISPLAY '**  CLOSE ERROR FOR FCSCA191 - INPUT FILE'      
               DISPLAY '**  FILE STATUS = ' WS-FCA191-STATUS            
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
