       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP174.                                        
       DATE-WRITTEN.   NOV 2009.                                        
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **   DATE         INITIALS    REASON                           **         
      **   __________   ________    ______________                   **         
PRJ166**   11/11/2009   CSCINDIA    INITIAL PROGRAM VERSION.         **         
A04494**   01/02/2013   SV          CHANGE THE REPORT TO PULL ALL    **         
A04494**                            RECONCILED ACCT TILL DATE.       **         
      **                                                             **         
A04724**   06/24/2013   SV95326     CREDIT NOTICES / LETTERS         **         
A04724**                            UNRECONCILED REPORT.             **         
A04494**   10/15/2013   AS7C117     ADD CUSTOMER BILL STATEMENTS TO  **         
A04494**                ACT053      THE UNRECONCILED ACCOUNTS        **         
      *****************************************************************         
      *        -------------- PCSRP174 NARRATIVE --------------      **         
      *****************************************************************         
      * THIS PROGRAM SHOULD REPORT ALL THE ACCOUNTS WHICH ARE CREATED**         
      * 3 BUSINESS DAYS PRIOR (VARIABLE) AND ARE NOT IN COMPLETE     **         
      * STATUS.                                                      **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **            ---- BASIC SEQUENCE STRUCTURE ----               **         
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **         
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH        **         
      **        2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **         
      **        3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **         
      **        5000 - 5999     COMMON PROGRAM MODULES               **         
      **        6000 - 6999     COMMON SYSTEM MODULES                **         
      **        7000 - 7999     INPUT MODULES                        **         
      **        8000 - 8999     OUTPUT MODULES                       **         
      **        9000 - 9799     TERMINATION MODULES                  **         
      **        9900 - 9999     ABEND/ABORT MODULES                  **         
      **                                                             **         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                    00700000
A04724 COPY CSSPT37.                                                    00700000
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                    00770000
A04724 COPY CFDPT37.                                                    00770000
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-CRED-NOT-LET-CUR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-CORR-MAIL-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRCK-STAT-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP174'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR PCSRP174 STARTS HERE'.                  
      *                                                                         
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSRP174'.      
           05  WS-DEFAULT-RPT1-TITLE-1 PIC X(31) VALUE                  
               'UN-RECONCILED ACCOUNTS LIST FOR'.                       
A04574     05  WS-DEFAULT-RPT2-TITLE-1 PIC X(56) VALUE                  
A04574       'UN-RECONCILED ACCOUNTS LIST FOR CREDIT LETTERS & NOTICES'.
           05  WS-REP-DATA             PIC X(01) VALUE 'Y'.             
               88  NO-REP-DATA                        VALUE 'N'.        
               88  REP-DATA                           VALUE 'Y'.        
           05  WS-COMPANY-NAME         PIC X(26) VALUE SPACES.          
           05  WS-REC-COUNTER          PIC 9(09) VALUE ZERO.            
           05  WS-REC-COUNTER-DISP     PIC ZZZZZZZZ9.                   
A04574     05  WS-REC2-COUNTER         PIC 9(09) VALUE ZERO.            
A04574     05  WS-REC2-COUNTER-DISP    PIC ZZZZZZZZ9.                   
           05  WS-PREV-BUS-CNTR        PIC S9(4)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  WS-CSR-FL               PIC X(01) VALUE 'N'.             
           05  WS-PNC-FL               PIC X(01) VALUE 'N'.             
           05  WS-SEB-FL               PIC X(01) VALUE 'N'.             
           05  WS-SBR-FL               PIC X(01) VALUE 'N'.             
           05  WS-SVC-FL               PIC X(01) VALUE 'N'.             
           05  WS-TRKST-ROW-COUNT      PIC S9(7)  COMP-3 VALUE +0.      
           05  WS-CORR-ROW-COUNT       PIC S9(7)  COMP-3 VALUE +0.      
           05  WS-NUM-COND             PIC S9(7)  COMP-3 VALUE +0.      
           05  WS-TRKST-INDEX          PIC S9(04) COMP-3 VALUE +0.      
           05  WS-CORR-INDEX           PIC S9(04) COMP-3 VALUE +0.      
           05  WS-ACCOUNT              PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NO REDEFINES  WS-ACCOUNT                      
                                       PIC 9(13).                       
           05  WS-NBR-BIZDAYS          PIC S9(4)V9(5) USAGE COMP-3      
                                                      VALUE 3.          
A04724     05  WS-NBR-CRED-BIZDAYS     PIC S9(4)V9(5) USAGE COMP-3      
A04724                                                VALUE 2.          
A04724     05  WS-NORMAL-BUSINESS-DAY  PIC X(10) VALUE SPACES.          
A04724     05  WS-CRED-BUSINESS-DAY    PIC X(10) VALUE SPACES.          
      *                                                                         
       01  WS-CSR1-HOST-VARIABLES.                                      
           05 WS-CSR-TRAC-STAT-CD      PIC X(2)  OCCURS 75 TIMES        
                                                      VALUE SPACES.     
           05 WS-CSR-TRAC-STAT-DESC    PIC X(75) OCCURS 75  TIMES       
                                                      VALUE SPACES.     
      *                                                                         
       01  WS-CSR2-HOST-VARIABLES.                                      
           05 WS-CSR-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3         
                                           OCCURS 100 TIMES VALUE ZEROS.
           05 WS-CSR-BARCD-UNIQ-ID     PIC X(9)  OCCURS 100 TIMES       
                                                      VALUE SPACES.     
A04494     05 WS-CREATE-DT             PIC X(10) OCCURS 100 TIMES       
A04494                                                VALUE SPACES.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSRP174'.      
      *                                                                         
      *                                                                         
COB305 01 WS-RPT1-LINE-NO        PIC 9(02) COMP-3 VALUE 0.                
       01  WS-RPT1-PAGE-NO             PIC 9(05) VALUE 0 COMP-3.        
COB305 01 WS-RPT2-LINE-NO        PIC 9(02) COMP-3 VALUE 0.                
A04574 01  WS-RPT2-PAGE-NO             PIC 9(05) VALUE 0 COMP-3.        
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE ':'.             
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE ':'.             
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE '/'.             
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE '/'.             
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
      *****************************************************************         
      * PCSRP174 REPORT HEADERS                                       *         
      *****************************************************************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(10).                       
               10  FILLER              PIC X(43) VALUE SPACES.          
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(34) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE                  
                                              'RUN DATE: '.             
               10  P-RPT1-RUN-DATE     PIC X(08).                       
               10  FILLER              PIC X(01) VALUE SPACES.          
      *                                                                         
      *****************************************************************         
      * COMMON WORKING STORAGE FOR REPORT HEADER1                     *         
      *****************************************************************         
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(51)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(31).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-RPT1-DATE1        PIC X(10).                       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
A04724     05  WS-RPT2-HEADER-1.                                        
A04724         10  FILLER              PIC X(27)    VALUE SPACES.       
A04724         10  P-RPT2-HEAD1        PIC X(55).                       
A04724         10  FILLER              PIC X(01)    VALUE SPACES.       
A04724         10  P-RPT2-DATE1        PIC X(10).                       
A04724         10  FILLER              PIC X(20)    VALUE SPACES.       
A04724         10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
A04724         10  P-RPT2-RUN-TIME     PIC X(08).                       
A04724         10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * COMMON WORKING STORAGE FOR REPORT HEADER2                     *         
      *****************************************************************         
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(48)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(50).                       
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
A04724     05  WS-RPT2-HEADER-2.                                        
A04724         10  FILLER              PIC X(48)    VALUE SPACES.       
A04724         10  P-RPT2-HEAD2        PIC X(50).                       
A04724         10  FILLER              PIC X(19)    VALUE SPACES.       
A04724         10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
A04724         10  P-RPT2-PAGE-NO      PIC ZZ,ZZ9.                      
A04724         10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS              *         
      *****************************************************************         
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER              PIC X(10)    VALUE               
                                                'ACCOUNT NO'.           
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(17)    VALUE               
                                                'UNIQUE IDENTIFIER'.    
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                                'STATUS DESCRIPTION'.   
A04494         10  FILLER              PIC X(61)    VALUE SPACES.       
A04494         10  FILLER              PIC X(10)    VALUE               
A04494                                          '   DATE   '.           
A04494         10  FILLER              PIC X(06)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * COMMON WORKING STORAGE FOR REPORT DETAIL LINES                *         
      *****************************************************************         
      *                                                                         
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10  P-ACCOUNT-NO        PIC 9(13).                       
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  P-UNIQUE-IDENTIFIER PIC X(09).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-STATUS-DESC       PIC X(75).                       
A04494         10  FILLER              PIC X(04)    VALUE SPACES.       
A04494         10  P-CREATE-DATE       PIC X(10).                       
A04494         10  FILLER              PIC X(06)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * COMMON WORKING STORAGE FOR REPORT TOTAL LINES                 *         
      *****************************************************************         
      *                                                                         
       01  WS-TOTAL-LINE.                                               
      *                                                                         
           05  WS-ACCOUNT-TOTAL-LINE-1.                                 
               10  FILLER              PIC X(26)    VALUE               
                           'TOTAL NUMBER OF ACCOUNTS  '.                
               10  P-TOTAL-ACCTS       PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(97)    VALUE SPACES.       
      *                                                                         
A04724 01  WS-TOTAL-LINE2.                                              
A04724*                                                                         
A04724     05  WS-ACCOUNT-TOTAL-LINE-2.                                 
A04724         10  FILLER              PIC X(34)    VALUE               
A04724               'TOTAL NUMBER OF LETTERS & NOTICES '.              
A04724         10  P-TOTAL-ACCTS2      PIC X(10)    VALUE SPACES.       
A04724         10  FILLER              PIC X(89)    VALUE SPACES.       
      *                                                                         
                                                                        
       01  WS-LINE.                                                     
           05  WS-LINE-1-131           PIC X(131)   VALUE ALL '-'.      
           05  WS-LINE-132-132         PIC X(01)    VALUE ALL ' '.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(26)    VALUE               
                     '** NO DATA FOR THIS RUN **'.                      
           05  FILLER                  PIC X(51)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * INCLUDE DLCGEN TABLE AND HOST VARIABLE DEFINTIONS             *         
      *****************************************************************         
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CORR_MAIL_STAT, MW                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMAILST                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_HOLIDAY, J8                                               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_JOB_PARM, G6                                              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_TRACK_STATUS, TD                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTRKSTA                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WS USED FOR CPD00039                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WS USED FOR DB2 ERROR PROCESSING                              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WS USED FOR PRIOR BUSINESS DAY CALCULATION                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * WS USED FOR DB2 ERROR PROCESSING                              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS09900                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WS USED FOR PARAMETER FILE                                    *         
      *****************************************************************         
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      *****************************************************************         
      * TRCK_STAT_CSR   - TO GET STATUS CODE                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE TRCK_STAT_CSR CURSOR WITH ROWSET POSITIONING FOR   
              SELECT TRACK_STATUS_CD                                    
                    ,TRACK_STATUS_DESC                                  
                FROM CSS_TRACK_STATUS WITH(READUNCOMMITTED)                     
               WHERE TRACK_STATUS_FL = 'A'                              
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRCK_STAT_CSR CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*       SELECT TRACK_STATUS_CD                                            
MFA-TR*             ,TRACK_STATUS_DESC                                          
MFA-TR*         FROM CSS_TRACK_STATUS                                           
MFA-TR*        WHERE TRACK_STATUS_FL = 'A'                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CORR-MAIL-CSR TO GET ACCOUNT DETAILS                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE CORR-MAIL-CSR  CURSOR WITH ROWSET POSITIONING FOR  
              SELECT ACCOUNT_NO                                         
                    ,BARCODE_UNIQUE_ID                                  
A04494              ,CREATE_DT                                          
                FROM CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)                   
A04494         WHERE CREATE_DT             <= IIF(TRY_CONVERT(DATE, 
                                                          :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )             
                 AND TRACKING_STATUS_CD     = :MW-TRACKING-STATUS-CD    
                 AND                                                    
                 (    ( :WS-CSR-FL          = 'Y'                       
A04724            AND COMM_TYPE_CODE      IN    ( '11','13','14' ))     
                  OR  ( :WS-PNC-FL          = 'Y'                       
A04724            AND COMM_TYPE_CODE      IN    ( '21','23','24' ))     
                  OR  ( :WS-SEB-FL          = 'Y'                       
A04724            AND COMM_TYPE_CODE      IN    ( '31','33','34' ))     
                  OR  ( :WS-SBR-FL          = 'Y'                       
A04724            AND COMM_TYPE_CODE      IN    ( '41','43','44' ))     
                  OR  ( :WS-SVC-FL          = 'Y'                       
A04724            AND COMM_TYPE_CODE      IN    ( '51','53','54' ))     
                  )                                                     
A04494           ORDER BY CREATE_DT ASC                                 
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CORR-MAIL-CSR  CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*             ,BARCODE_UNIQUE_ID                                          
MFA-TR*             ,CREATE_DT                                                  
MFA-TR*         FROM CSS_CORR_MAIL_STAT                                         
MFA-TR*        WHERE CREATE_DT             <= :MW-CREATE-DT                     
MFA-TR*          AND TRACKING_STATUS_CD     = :MW-TRACKING-STATUS-CD            
MFA-TR*          AND                                                            
MFA-TR*          (    ( :WS-CSR-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE      IN    ( '11','13','14' ))             
MFA-TR*           OR  ( :WS-PNC-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE      IN    ( '21','23','24' ))             
MFA-TR*           OR  ( :WS-SEB-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE      IN    ( '31','33','34' ))             
MFA-TR*           OR  ( :WS-SBR-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE      IN    ( '41','43','44' ))             
MFA-TR*           OR  ( :WS-SVC-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE      IN    ( '51','53','54' ))             
MFA-TR*           )                                                             
MFA-TR*          ORDER BY CREATE_DT ASC                                         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
A04724*****************************************************************         
A04724* CREDIT NOTICES/LETTERS UNRECONCILED REPORT.                   *         
A04724*****************************************************************         
A04724*                                                                         
A04724     EXEC SQL                                                     
A04724       DECLARE CRED-NOT-LET-CUR CURSOR WITH ROWSET POSITIONING FOR
A04724        SELECT ACCOUNT_NO                                         
A04724              ,BARCODE_UNIQUE_ID                                  
A04724              ,CREATE_DT                                          
A04724          FROM CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)                   
A04724         WHERE CREATE_DT             <= IIF(TRY_CONVERT(DATE, 
                                                          :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )             
A04724           AND TRACKING_STATUS_CD     = :MW-TRACKING-STATUS-CD    
A04724           AND                                                    
A04724            (   ( :WS-CSR-FL          = 'Y'                       
A04494            AND COMM_TYPE_CODE        IN ('12','15'))             
A04724            OR  ( :WS-PNC-FL          = 'Y'                       
A04494            AND COMM_TYPE_CODE        IN ('22','25'))             
A04724            OR  ( :WS-SEB-FL          = 'Y'                       
A04494            AND COMM_TYPE_CODE        IN ('32','35'))             
A04724            OR  ( :WS-SBR-FL          = 'Y'                       
A04494            AND COMM_TYPE_CODE        IN ('42','45'))             
A04724            OR  ( :WS-SVC-FL          = 'Y'                       
A04494            AND COMM_TYPE_CODE        IN ('52','55'))             
A04724            )                                                     
A04724           ORDER BY CREATE_DT ASC                                 
A04724           FOR READ ONLY                                  
A04724     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CRED-NOT-LET-CUR CURSOR WITH ROWSET POSITIONING FOR        
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*             ,BARCODE_UNIQUE_ID                                          
MFA-TR*             ,CREATE_DT                                                  
MFA-TR*         FROM CSS_CORR_MAIL_STAT                                         
MFA-TR*        WHERE CREATE_DT             <= :MW-CREATE-DT                     
MFA-TR*          AND TRACKING_STATUS_CD     = :MW-TRACKING-STATUS-CD            
MFA-TR*          AND                                                            
MFA-TR*           (   ( :WS-CSR-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE        IN ('12','15'))                     
MFA-TR*           OR  ( :WS-PNC-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE        IN ('22','25'))                     
MFA-TR*           OR  ( :WS-SEB-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE        IN ('32','35'))                     
MFA-TR*           OR  ( :WS-SBR-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE        IN ('42','45'))                     
MFA-TR*           OR  ( :WS-SVC-FL          = 'Y'                               
MFA-TR*           AND COMM_TYPE_CODE        IN ('52','55'))                     
MFA-TR*           )                                                             
MFA-TR*          ORDER BY CREATE_DT ASC                                         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40) VALUE                  
           'WORKING STORAGE FOR PCSRP174 ENDS HERE  '.                  
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LK-PARM.                                                     
         05  LK-PARM-LENGTH            PIC S9(04) COMP.                 
         05  LK-PARM-VALUE             PIC X(03).                       
      *                                                                         
       PROCEDURE DIVISION USING LK-PARM.                                
      *                                                                         
      *****************************************************************         
      *   0000-MAINLINE                                               *         
      *       CONTROLS MAIN PATH OF PROGRAM                           *         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 1000-PROCESS-INPUT                THRU 1000-EXIT     
                                                                        
      *                                                                         
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
A04724     OPEN OUTPUT FCSPT37-FILE.                                    
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
      *                                                                         
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO P-RPT1-RUN-TIME            
                                             P-RPT2-RUN-TIME.           
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
      *                                                                         
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO P-RPT1-RUN-DATE.           
      *                                                                         
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
           MOVE WS-FCA00-COMMON-DATE     TO WS-NEW-BUSINESS-DAY.        
           DISPLAY '* COMMON DATE ' WS-NEW-BUSINESS-DAY.                
      *                                                                         
           IF LK-PARM-LENGTH = 0                                        
              DISPLAY '************* PCSRP174 *******************'      
              DISPLAY '* NO PARM VALUE FOUND                    *'      
              DISPLAY '* VALID PARM VALUES ARE ''CSR'',''PNC'', *'      
              DISPLAY '* ''SEB'',''SBR'' AND ''SVC''            *'      
              DISPLAY '************* PCSRP174 *******************'      
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
           EVALUATE LK-PARM-VALUE                                       
              WHEN 'CSR'                                                
                  MOVE 'S C ELECTRIC && GAS CO'  TO WS-COMPANY-NAME     
                  MOVE 'Y'                       TO WS-CSR-FL           
              WHEN 'PNC'                                                
                  MOVE '     PSNC ENERGY'        TO WS-COMPANY-NAME     
                  MOVE 'Y'                       TO WS-PNC-FL           
              WHEN 'SEB'                                                
                  MOVE '  SCANA ENERGY'          TO WS-COMPANY-NAME     
                  MOVE 'Y'                       TO WS-SEB-FL           
              WHEN 'SBR'                                                
                  MOVE 'SCANA ENERGY REGULATED'  TO WS-COMPANY-NAME     
                  MOVE 'Y'                       TO WS-SBR-FL           
              WHEN 'SVC'                                                
                  MOVE '  SERVICE CARE'          TO WS-COMPANY-NAME     
                  MOVE 'Y'                       TO WS-SVC-FL           
              WHEN OTHER                                                
                  DISPLAY '************* PCSRP174 *******************'  
                  DISPLAY '* NOT A VALID PARM                       *'  
                  DISPLAY '* VALID PARM VALUES ARE ''CSR'',''PNC'', *'  
                  DISPLAY '* ''SEB'',''SBR'' AND ''SVC''            *'  
                  DISPLAY '************* PCSRP174 *******************'  
                  PERFORM 9900-ABEND                    THRU 9900-EXIT  
           END-EVALUATE.                                                
           IF WS-PNC-FL = 'Y'                                           
              MOVE '26'                  TO C8-COMPANY-NO               
           ELSE                                                         
              MOVE '01'                  TO C8-COMPANY-NO               
           END-IF.                                                      
           MOVE 'NO-RCNRPT-DAYS'         TO C8-DELINQ-CD.               
           PERFORM 7200-GET-DELINQUENCY       THRU 7200-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE       TO WS-NBR-BIZDAYS              
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL  WS-PREV-BUS-CNTR = WS-NBR-BIZDAYS             
              MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY        
                                                                        
              PERFORM 6525-PREV-BUSINESS-DAY       THRU                 
                         6525-PREV-BUSINESS-DAY-EXIT  UNTIL             
                         NEXT-BUSINESS-DAY-FOUND                        
              ADD 1 TO WS-PREV-BUS-CNTR                                 
                                                                        
           END-PERFORM.                                                 
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NORMAL-BUSINESS-DAY      
                                            P-RPT1-DATE1.               
      *                                                                         
            DISPLAY '* PRIOR DATE         ' WS-NORMAL-BUSINESS-DAY .    
            MOVE  WS-COMPANY-NAME                TO P-RPT1-COMP-NAME.   
      *                                                                         
           PERFORM 8100-PRINT-COMP-NAME                 THRU 8100-EXIT. 
           PERFORM 8200-PRINT-TITLE                     THRU 8200-EXIT. 
           PERFORM 8300-PRINT-HEADERS                   THRU 8300-EXIT. 
      *                                                                         
A04724     MOVE WS-FCA00-COMMON-DATE     TO WS-NEW-BUSINESS-DAY.        
A04724     MOVE 'NO-CREDRPT-DAYS'        TO C8-DELINQ-CD.               
A04724     PERFORM 7200-GET-DELINQUENCY       THRU 7200-EXIT.           
A04724     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04724        MOVE C8-DELINQ-VALUE       TO WS-NBR-CRED-BIZDAYS         
A04724     END-IF.                                                      
A04724     MOVE 0                        TO WS-PREV-BUS-CNTR.           
A04724     PERFORM UNTIL  WS-PREV-BUS-CNTR = WS-NBR-CRED-BIZDAYS        
A04724        MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY        
A04724                                                                  
A04724        PERFORM 6525-PREV-BUSINESS-DAY       THRU                 
A04724                   6525-PREV-BUSINESS-DAY-EXIT  UNTIL             
A04724                   NEXT-BUSINESS-DAY-FOUND                        
A04724        ADD 1 TO WS-PREV-BUS-CNTR                                 
A04724                                                                  
A04724     END-PERFORM.                                                 
A04724     MOVE WS-NEW-BUSINESS-DAY      TO WS-CRED-BUSINESS-DAY        
A04724                                      P-RPT2-DATE1.               
A04724*                                                                         
A04724      DISPLAY '* PRIOR DATE FOR NOTICES ' WS-CRED-BUSINESS-DAY .  
A04724      MOVE  WS-COMPANY-NAME                TO P-RPT1-COMP-NAME.   
A04724*                                                                         
A04724     PERFORM 8500-PRINT-COMP-NAME                 THRU 8500-EXIT. 
A04724     PERFORM 8550-PRINT-TITLE                     THRU 8550-EXIT. 
A04724     PERFORM 8600-PRINT-HEADERS                   THRU 8600-EXIT. 
A04724*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05700000
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *****************************************************************         
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-TRACK-STAT-CSR   THRU 7000-EXIT.           
           PERFORM 7030-FETCH-TRACK-STAT-CSR  THRU 7030-EXIT.           
                                                                        
           PERFORM 7050-CLOSE-TRACK-STAT-CSR  THRU 7050-EXIT .          
           IF WS-REC-COUNTER > 0                                        
              MOVE WS-REC-COUNTER             TO WS-REC-COUNTER-DISP    
              MOVE WS-REC-COUNTER-DISP        TO P-TOTAL-ACCTS          
              PERFORM 8410-PRINT-TOT-ACCOUNTS THRU 8410-EXIT            
               MOVE WS-END-DATA-LINE    TO PRT33-DATA                   
               WRITE PRT33-RECORD                                       
                     AFTER ADVANCING 1 LINES                            
           ELSE                                                         
              MOVE 'N'                        TO WS-REP-DATA            
              PERFORM 2200-NO-REPORT-DATA     THRU 2200-EXIT            
              DISPLAY '* TRACKING STATUS RECORD(S) NOT FOUND *'         
           END-IF.                                                      
           DISPLAY '*TOTAL NUMBER OF ACCOUNTS PROCESSED :'              
                                                   WS-REC-COUNTER.      
      *                                                                         
A04724     IF WS-REC2-COUNTER > 0                                       
A04724        MOVE WS-REC2-COUNTER            TO WS-REC2-COUNTER-DISP   
A04724        MOVE WS-REC2-COUNTER-DISP       TO P-TOTAL-ACCTS2         
A04724        PERFORM 8700-PRINT-TOT-ACCOUNTS THRU 8700-EXIT            
A04724         MOVE WS-END-DATA-LINE    TO PRT37-DATA                   
A04724         WRITE PRT37-RECORD                                       
A04724               AFTER ADVANCING 1 LINES                            
A04724     ELSE                                                         
A04724        MOVE 'N'                        TO WS-REP-DATA            
A04724        PERFORM 2200-NO-REPORT-DATA     THRU 2200-EXIT            
A04724        DISPLAY '* TRACKING STATUS RECORD(S) NOT FOUND *'         
A04724     END-IF.                                                      
A04724     DISPLAY '*TOTAL NO OF NOTICE AND LETTER ACCOUNT PROCESSED :' 
A04724                                             WS-REC2-COUNTER.     
A04724     DISPLAY '* PCSRP174 SUCCESSFULLY COMPLETED *'.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
A04724     MOVE WS-NORMAL-BUSINESS-DAY              TO MW-CREATE-DT .   
           MOVE WS-CSR-TRAC-STAT-CD(WS-TRKST-INDEX) TO                  
                                           MW-TRACKING-STATUS-CD.       
           PERFORM 7100-OPEN-CORR-MAIL-CSR          THRU 7100-EXIT.     
           PERFORM 7130-FETCH-CORR-MAIL-CSR         THRU 7130-EXIT      
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7150-CLOSE-CORR-MAIL-CSR         THRU 7150-EXIT .    
A04724*                                                                         
A04724     MOVE WS-CRED-BUSINESS-DAY                TO MW-CREATE-DT .   
A04724     PERFORM 7300-OPEN-CRED-NOT-LET-CUR       THRU 7300-EXIT.     
A04724     PERFORM 7330-FETCH-CRED-NOT-LET-CUR      THRU 7330-EXIT      
A04724              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
A04724     PERFORM 7350-CLOSE-CRED-NOT-LET-CUR      THRU 7350-EXIT .    
A04724     ADD 1 TO WS-TRKST-INDEX.                                     
A04724*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-CURSOR                                            *        
      * PERFORMS FETCH AND WRITES DATA TO OUTPUT FILE                  *        
      ******************************************************************        
       2100-PROCESS-CURSOR.                                             
                                                                        
           INITIALIZE  WS-ACCOUNT.                                      
                                                                        
           MOVE WS-CSR-ACCOUNT-NO(WS-CORR-INDEX)       TO WS-ACCOUNT-NO.
           MOVE WS-ACCOUNT                             TO P-ACCOUNT-NO. 
                                                                        
           MOVE WS-CSR-BARCD-UNIQ-ID(WS-CORR-INDEX)    TO               
                                                    P-UNIQUE-IDENTIFIER.
           MOVE WS-CSR-TRAC-STAT-DESC(WS-TRKST-INDEX)  TO P-STATUS-DESC.
A04494     MOVE WS-CREATE-DT(WS-CORR-INDEX)            TO P-CREATE-DATE.
                                                                        
           PERFORM 8400-PRINT-DETAIL-LINES             THRU 8400-EXIT.  
           ADD 1           TO WS-CORR-INDEX.                            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2200-NO-REPORT-DATA                                           *         
      *****************************************************************         
       2200-NO-REPORT-DATA.                                             
      *                                                                         
           IF NO-REP-DATA                                               
               MOVE WS-NO-DATA-LINE     TO PRT33-DATA                   
               WRITE PRT33-RECORD                                       
                     AFTER ADVANCING 3 LINES                            
               MOVE WS-END-DATA-LINE    TO PRT33-DATA                   
               WRITE PRT33-RECORD                                       
                     AFTER ADVANCING 3 LINES                            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04724******************************************************************        
A04724* 2300-PROCESS-CURSOR                                            *        
A04724* PERFORMS FETCH AND WRITES DATA TO OUTPUT FILE                  *        
A04724******************************************************************        
A04724 2300-PROCESS-CURSOR.                                             
A04724                                                                  
A04724     INITIALIZE  WS-ACCOUNT.                                      
A04724                                                                  
A04724     MOVE WS-CSR-ACCOUNT-NO(WS-CORR-INDEX)       TO WS-ACCOUNT-NO.
A04724     MOVE WS-ACCOUNT                             TO P-ACCOUNT-NO. 
A04724                                                                  
A04724     MOVE WS-CSR-BARCD-UNIQ-ID(WS-CORR-INDEX)    TO               
A04724                                              P-UNIQUE-IDENTIFIER.
A04724     MOVE WS-CSR-TRAC-STAT-DESC(WS-TRKST-INDEX)  TO P-STATUS-DESC.
A04724     MOVE WS-CREATE-DT(WS-CORR-INDEX)            TO P-CREATE-DATE.
A04724                                                                  
A04724     PERFORM 8650-PRINT-DETAIL-LINES             THRU 8650-EXIT.  
A04724     ADD 1           TO WS-CORR-INDEX.                            
A04724                                                                  
A04724 2300-EXIT.                                                       
A04724     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6240-GET-FCA00-COMMON-DATE                                    *         
      * GET FCA00 COMMON DATE                                         *         
      *****************************************************************         
      *                                                                         
       COPY CPD00040.                                                   PCS06610
      *                                                                         
      *****************************************************************         
      * 6525-PREV-BUSINESS-DAY                                      *           
      * LOGIC TO GET PRIOR BUSINESS DAY                               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-TRACK-STAT-CSR                                       *        
      * OPENS TRACK-STAT-CSR CURSOR                                    *        
      ******************************************************************        
       7000-OPEN-TRACK-STAT-CSR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN TRCK_STAT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP174 ABORT  ************'         
              DISPLAY '* 7000-OPEN-TRACK-STAT-CSR            *'         
              DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSRP174  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-FETCH-TRACK-STAT-CSR                                      *        
      * FETCH TRACK-STAT-CSR CURSOR                                    *        
      ******************************************************************        
       7030-FETCH-TRACK-STAT-CSR.                                       
           INITIALIZE WS-CSR1-HOST-VARIABLES.                           

MSQ008     MOVE 75 TO MSQ008-TRCK-STAT-CSR
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-TRCK-STAT-CSR
              FETCH 
              FROM TRCK_STAT_CSR          
                INTO                                                    
                    :WS-CSR-TRAC-STAT-CD                                
                   ,:WS-CSR-TRAC-STAT-DESC                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM TRCK_STAT_CSR FOR 75 ROWS                 
MFA-TR*         INTO                                                            
MFA-TR*             :WS-CSR-TRAC-STAT-CD                                        
MFA-TR*            ,:WS-CSR-TRAC-STAT-DESC                                      
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRCK-STAT-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO                      
                                                WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                                        
              IF  SQLERRD(3) >= 1                                       
                  MOVE SQLERRD (3)              TO WS-TRKST-ROW-COUNT   
                  MOVE  1                       TO WS-TRKST-INDEX       
                  PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT          
                            UNTIL WS-TRKST-INDEX > WS-TRKST-ROW-COUNT   
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-CORR-ROW-COUNT =                      
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-CORR-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '********** PCSRP174 ABORT  ************'     
                  DISPLAY '* 7030-FETCH-TRACK-STAT-CSR           *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
                  DISPLAY '* NUM_COND '  WS-NUM-COND                    
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSRP174  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              ELSE                                                      
                  DISPLAY '********** PCSRP174 ABORT  ************'     
                  DISPLAY '* 7030-FETCH-TRACK-STAT-CSR           *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSRP174  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-CLOSE-TRACK-STAT-CSR                                      *        
      * CLOSE TRACK-STAT-CSR CURSOR                                    *        
      ******************************************************************        
       7050-CLOSE-TRACK-STAT-CSR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE TRCK_STAT_CSR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSRP174 ABORT  ************'         
              DISPLAY '* 7050-CLOSE-TRACK-STAT-CSR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSRP174  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-CORR-MAIL-CSR                                        *        
      * OPENS CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7100-OPEN-CORR-MAIL-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN CORR-MAIL-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP174 ABORT  ************'         
              DISPLAY '* 7100-OPEN-CORR-MAIL-CSR             *'         
              DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
              DISPLAY '* TRACKING_STATUS_CD  = '  MW-TRACKING-STATUS-CD 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSRP174  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-FETCH-CORR-MAIL-CSR                                       *        
      * FETCH CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7130-FETCH-CORR-MAIL-CSR.                                        
           INITIALIZE WS-CSR2-HOST-VARIABLES.                           

MSQ008     MOVE 100 TO MSQ008-CORR-MAIL-CSR
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-CORR-MAIL-CSR
              FETCH 
              FROM CORR-MAIL-CSR        
                 INTO                                                   
                      :WS-CSR-ACCOUNT-NO                                
                     ,:WS-CSR-BARCD-UNIQ-ID                             
A04494               ,:WS-CREATE-DT                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM CORR-MAIL-CSR FOR 100 ROWS               
MFA-TR*          INTO                                                           
MFA-TR*               :WS-CSR-ACCOUNT-NO                                        
MFA-TR*              ,:WS-CSR-BARCD-UNIQ-ID                                     
MFA-TR*              ,:WS-CREATE-DT                                             
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CORR-MAIL-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO                      
                                                WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                                        
              IF  SQLERRD(3) >= 1                                       
                  MOVE SQLERRD (3)              TO WS-CORR-ROW-COUNT    
                  MOVE  1                       TO  WS-CORR-INDEX       
                  PERFORM 2100-PROCESS-CURSOR   THRU 2100-EXIT          
                            UNTIL WS-CORR-INDEX > WS-CORR-ROW-COUNT     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-CORR-ROW-COUNT =                      
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-CORR-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '********** PCSRP174 ABORT  ************'     
                  DISPLAY '* 7130-FETCH-CORR-MAIL-CSR            *'     
                  DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
                  DISPLAY '* TRACKING_STATUS_CD  = '                    
                                              MW-TRACKING-STATUS-CD     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
                  DISPLAY '* NUM_COND '  WS-NUM-COND                    
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSRP174  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              ELSE                                                      
                  DISPLAY '********** PCSRP174 ABORT  ************'     
                  DISPLAY '* 7130-FETCH-CORR-MAIL-CSR            *'     
                  DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
                  DISPLAY '* TRACKING_STATUS_CD  = '                    
                                              MW-TRACKING-STATUS-CD     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSRP174  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-CLOSE-CORR-MAIL-CSR                                       *        
      * CLOSE CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7150-CLOSE-CORR-MAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CORR-MAIL-CSR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSRP174 ABORT  ************'         
              DISPLAY '* 7150-CLOSE-CORR-MAIL-CSR            *'         
              DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
              DISPLAY '* TRACKING_STATUS_CD  = ' MW-TRACKING-STATUS-CD  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSRP174  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-DELINQUENCY                                           *        
      * GET NUMBER OF PRIOR BUSINESS DAYS                              *        
      ******************************************************************        
       7200-GET-DELINQUENCY.                                            
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                      DELINQ_VALUE                                      
                 INTO                                                   
                      :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD       = :C8-DELINQ-CD                   
                  AND COMPANY_NO      = :C8-COMPANY-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               DELINQ_VALUE                                              
MFA-TR*          INTO                                                           
MFA-TR*               :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD       = :C8-DELINQ-CD                           
MFA-TR*           AND COMPANY_NO      = :C8-COMPANY-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP174 ABORT  ************'         
              DISPLAY '* 7200-GET-DELINQUENCY                *'         
              DISPLAY '* DELINQ_CD    = ' C8-DELINQ-CD                  
              DISPLAY '* COMPANY_NO   = ' C8-COMPANY-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSRP174  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
A04724******************************************************************        
A04724* OPENS CRED-NOT-LET-CUR CURSOR                                  *        
A04724******************************************************************        
A04724 7300-OPEN-CRED-NOT-LET-CUR.                                      
A04724                                                                  
A04724     EXEC SQL                                                     
A04724          OPEN CRED-NOT-LET-CUR                                   
A04724     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04724                                                                  
A04724     MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
A04724                                                                  
A04724     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04724        CONTINUE                                                  
A04724     ELSE                                                         
A04724        DISPLAY '********** PCSRP174 ABORT  ************'         
A04724        DISPLAY '* 7300-OPEN-CRED-NOT-LET-CUR          *'         
A04724        DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
A04724        DISPLAY '* TRACKING_STATUS_CD  = '  MW-TRACKING-STATUS-CD 
A04724        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A04724        DISPLAY '* PROGRAM ABORTING...                 *'         
A04724        DISPLAY '********** PCSRP174  ABORT ************'         
A04724        PERFORM 9900-ABEND            THRU 9900-EXIT              
A04724     END-IF.                                                      
A04724                                                                  
A04724 7300-EXIT.                                                       
A04724     EXIT.                                                        
A04724*                                                                         
A04724******************************************************************        
A04724* FETCH CRED-NOT-LET-CUR CURSOR                                  *        
A04724******************************************************************        
A04724 7330-FETCH-CRED-NOT-LET-CUR.                                     
A04724     INITIALIZE WS-CSR2-HOST-VARIABLES.                           

MSQ008     MOVE 100 TO MSQ008-CRED-NOT-LET-CUR
A04724                                                                  
A04724     EXEC SQL                                                     
A04724          FOR :MSQ008-CRED-NOT-LET-CUR
              FETCH 
              FROM CRED-NOT-LET-CUR     
A04724           INTO                                                   
A04724                :WS-CSR-ACCOUNT-NO                                
A04724               ,:WS-CSR-BARCD-UNIQ-ID                             
A04724               ,:WS-CREATE-DT                                     
A04724     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM CRED-NOT-LET-CUR FOR 100 ROWS            
MFA-TR*          INTO                                                           
MFA-TR*               :WS-CSR-ACCOUNT-NO                                        
MFA-TR*              ,:WS-CSR-BARCD-UNIQ-ID                                     
MFA-TR*              ,:WS-CREATE-DT                                             
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CRED-NOT-LET-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04724                                                                  
A04724     MOVE SQLCODE                         TO                      
A04724                                          WS-ACTIVE-RETURN-CODE.  
A04724     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04724                                                                  
A04724        IF  SQLERRD(3) >= 1                                       
A04724            MOVE SQLERRD (3)              TO WS-CORR-ROW-COUNT    
A04724            MOVE  1                       TO  WS-CORR-INDEX       
A04724            PERFORM 2300-PROCESS-CURSOR   THRU 2300-EXIT          
A04724                      UNTIL WS-CORR-INDEX > WS-CORR-ROW-COUNT     
A04724        END-IF                                                    
A04724     ELSE                                                         
A04724        IF WS-ACTIVE-RETURN-CODE = +354                           
A04724            EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
A04724                       ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
A04724            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-CORR-ROW-COUNT =                      
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-CORR-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
A04724            DISPLAY '********** PCSRP174 ABORT  ************'     
A04724            DISPLAY '* 7330-FETCH-CRED-NOT-LET-CUR         *'     
A04724            DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
A04724            DISPLAY '* TRACKING_STATUS_CD  = '                    
A04724                                        MW-TRACKING-STATUS-CD     
A04724            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
A04724            DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
A04724            DISPLAY '* NUM_COND '  WS-NUM-COND                    
A04724            DISPLAY '* PROGRAM ABORTING...                 *'     
A04724            DISPLAY '********** PCSRP174  ABORT ************'     
A04724            PERFORM 9900-ABEND            THRU 9900-EXIT          
A04724        ELSE                                                      
A04724            DISPLAY '********** PCSRP174 ABORT  ************'     
A04724            DISPLAY '* 7330-FETCH-CRED-NOT-LET-CUR         *'     
A04724            DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
A04724            DISPLAY '* TRACKING_STATUS_CD  = '                    
A04724                                        MW-TRACKING-STATUS-CD     
A04724            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
A04724            DISPLAY '* PROGRAM ABORTING...                 *'     
A04724            DISPLAY '********** PCSRP174  ABORT ************'     
A04724            PERFORM 9900-ABEND            THRU 9900-EXIT          
A04724        END-IF                                                    
A04724     END-IF.                                                      
A04724                                                                  
A04724 7330-EXIT.                                                       
A04724     EXIT.                                                        
A04724*                                                                         
A04724******************************************************************        
A04724* CLOSE CRED-NOT-LET-CUR CURSOR                                  *        
A04724******************************************************************        
A04724 7350-CLOSE-CRED-NOT-LET-CUR.                                     
A04724                                                                  
A04724     EXEC SQL                                                     
A04724         CLOSE CRED-NOT-LET-CUR                                   
A04724     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04724                                                                  
A04724     MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
A04724                                                                  
A04724     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A04724        DISPLAY '********** PCSRP174 ABORT  ************'         
A04724        DISPLAY '* 7350-CLOSE-CRED-NOT-LET-CUR         *'         
A04724        DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
A04724        DISPLAY '* TRACKING_STATUS_CD  = ' MW-TRACKING-STATUS-CD  
A04724        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A04724        DISPLAY '* PROGRAM ABORTING...                 *'         
A04724        DISPLAY '********** PCSRP174  ABORT ************'         
A04724        PERFORM 9900-ABEND            THRU 9900-EXIT              
A04724     END-IF.                                                      
A04724                                                                  
A04724 7350-EXIT.                                                       
A04724     EXIT.                                                        
      *                                                                         
      ***************************************************************** 03490000
      * 7620-START-FCSCA00                                            *         
      * 7621-READ-FCSCA00                                             *         
      * 7622-CLOSE-CA00-CSR                                           *         
      ***************************************************************** 03490000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************** 03490000
      * 8100-PRINT-COMP-NAME                                          *         
      ***************************************************************** 03490000
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
      *                                                                         
A04724     MOVE 'PCSR1741'             TO P-RPT1-TITLE-PGNM.            
      *                                                                         
      *                                                                         
           MOVE WS-RPT1-TITLE          TO PRT33-DATA.                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 03490000
      * 8200-PRINT-TITLE                                              *         
      ***************************************************************** 03490000
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE-1   TO P-RPT1-HEAD1.              
           MOVE WS-RPT1-HEADER-1          TO PRT33-DATA                 
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE SPACES                    TO P-RPT1-HEAD2.              
           MOVE WS-RPT1-PAGE-NO           TO P-RPT1-PAGE-NO.            
           MOVE WS-RPT1-HEADER-2          TO  PRT33-DATA                
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 03490000
      * 8300-PRINT-HEADERS                                            *         
      ***************************************************************** 03490000
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
      *                                                                         
           MOVE WS-RPT1-HEADER-3       TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
      *                                                                         
           MOVE WS-LINE                TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-BLANK-LINE          TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03490000
      * 8400-PRINT-DETAIL-LINES                                       *         
      ***************************************************************** 03490000
      *                                                                         
       8400-PRINT-DETAIL-LINES.                                         
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 53                           
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-DETAIL-LINE-1       TO PRT33-DATA                    
           WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINE.                                  
                                                                        
      *                                                                         
           ADD 1                       TO WS-RPT1-LINE-NO.              
           ADD +1                      TO WS-REC-COUNTER.               
      *                                                                         
           MOVE SPACES                 TO WS-DETAIL-LINE-1 .            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03490000
      * 8410-PRINT-TOT-ACCOUNTS                                       *         
      ***************************************************************** 03490000
      *                                                                         
       8410-PRINT-TOT-ACCOUNTS.                                         
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 53                           
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-LINE                TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-TOTAL-LINE          TO PRT33-DATA                    
           WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINE.                                  
           ADD 2                           TO WS-RPT1-LINE-NO.          
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04724***************************************************************** 03490000
A04724* 8500-PRINT-COMP-NAME                                          *         
A04724***************************************************************** 03490000
A04724*                                                                         
A04724 8500-PRINT-COMP-NAME.                                            
A04724*                                                                         
A04724     ADD 1                       TO WS-RPT2-PAGE-NO.              
A04724*                                                                         
A04724     MOVE 'PCSR1742'             TO P-RPT1-TITLE-PGNM.            
A04724*                                                                         
A04724*                                                                         
A04724     MOVE WS-RPT1-TITLE          TO PRT37-DATA.                   
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING PAGE.                                   
A04724*                                                                         
A04724 8500-EXIT.                                                       
A04724     EXIT.                                                        
A04724***************************************************************** 03490000
A04724* 8550-PRINT-TITLE                                              *         
A04724***************************************************************** 03490000
A04724*                                                                         
A04724 8550-PRINT-TITLE.                                                
A04724*                                                                         
A04724     MOVE WS-DEFAULT-RPT2-TITLE-1   TO P-RPT2-HEAD1.              
A04724     MOVE WS-RPT2-HEADER-1          TO PRT37-DATA                 
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 1 LINE.                                 
A04724*                                                                         
A04724     MOVE SPACES                    TO P-RPT2-HEAD2.              
A04724     MOVE WS-RPT2-PAGE-NO           TO P-RPT2-PAGE-NO.            
A04724     MOVE WS-RPT2-HEADER-2          TO  PRT37-DATA                
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 1 LINE.                                 
A04724*                                                                         
A04724     MOVE 3                      TO WS-RPT2-LINE-NO.              
A04724*                                                                         
A04724 8550-EXIT.                                                       
A04724     EXIT.                                                        
A04724***************************************************************** 03490000
A04724* 8600-PRINT-HEADERS                                            *         
A04724***************************************************************** 03490000
A04724*                                                                         
A04724 8600-PRINT-HEADERS.                                              
A04724*                                                                         
A04724*                                                                         
A04724     MOVE WS-RPT1-HEADER-3       TO  PRT37-DATA                   
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 3 LINES.                                
A04724*                                                                         
A04724     MOVE WS-LINE                TO  PRT37-DATA                   
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 1 LINE.                                 
A04724*                                                                         
A04724     MOVE WS-BLANK-LINE          TO  PRT37-DATA                   
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 1 LINE.                                 
A04724*                                                                         
A04724     ADD 3                       TO WS-RPT2-LINE-NO.              
A04724*                                                                         
A04724 8600-EXIT.                                                       
A04724     EXIT.                                                        
A04724*                                                                         
A04724***************************************************************** 03490000
A04724* 8650-PRINT-DETAIL-LINES                                       *         
A04724***************************************************************** 03490000
A04724*                                                                         
A04724 8650-PRINT-DETAIL-LINES.                                         
A04724*                                                                         
A04724     IF WS-RPT2-LINE-NO GREATER THAN 53                           
A04724         PERFORM 8500-PRINT-COMP-NAME      THRU 8500-EXIT         
A04724         PERFORM 8550-PRINT-TITLE          THRU 8550-EXIT         
A04724         PERFORM 8600-PRINT-HEADERS        THRU 8600-EXIT         
A04724     END-IF.                                                      
A04724*                                                                         
A04724     MOVE WS-DETAIL-LINE-1       TO PRT37-DATA                    
A04724     WRITE PRT37-RECORD                                           
A04724         AFTER ADVANCING 1 LINE.                                  
A04724                                                                  
A04724*                                                                         
A04724     ADD 1                       TO WS-RPT2-LINE-NO.              
A04724     ADD +1                      TO WS-REC2-COUNTER.              
A04724*                                                                         
A04724     MOVE SPACES                 TO WS-DETAIL-LINE-1 .            
A04724*                                                                         
A04724 8650-EXIT.                                                       
A04724     EXIT.                                                        
A04724*                                                                         
A04724***************************************************************** 03490000
A04724* 8700-PRINT-TOT-ACCOUNTS                                       *         
A04724***************************************************************** 03490000
A04724*                                                                         
A04724 8700-PRINT-TOT-ACCOUNTS.                                         
A04724*                                                                         
A04724     IF WS-RPT2-LINE-NO GREATER THAN 53                           
A04724         PERFORM 8500-PRINT-COMP-NAME      THRU 8500-EXIT         
A04724         PERFORM 8550-PRINT-TITLE          THRU 8550-EXIT         
A04724         PERFORM 8600-PRINT-HEADERS        THRU 8600-EXIT         
A04724     END-IF.                                                      
A04724*                                                                         
A04724     MOVE WS-LINE                TO  PRT37-DATA                   
A04724     WRITE PRT37-RECORD                                           
A04724          AFTER ADVANCING 1 LINE.                                 
A04724     MOVE WS-TOTAL-LINE2         TO PRT37-DATA                    
A04724     WRITE PRT37-RECORD                                           
A04724         AFTER ADVANCING 1 LINE.                                  
A04724     ADD 2                           TO WS-RPT2-LINE-NO.          
A04724*                                                                         
A04724 8700-EXIT.                                                       
A04724     EXIT.                                                        
      ***************************************************************** 03490000
      * 9000-TERMINATE                                                *         
      ***************************************************************** 03490000
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
A04724     CLOSE FCSPT37-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9900-ABEND                                                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
      *                                                                         
