       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP170.                                        
       DATE-WRITTEN.   03/31/04.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ****                CUSTOMER SERVICE SYSTEM             *********         
      ****                          DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  03/31/04     SJB       NEW PROGRAM FOR REPORT GENERATION.  **         
      **                         OF WQS FOR CT METER DISCONNECT.     **         
      **  07/15/04     SJB       ADD 1 TO WS-CURR-DATE SINCE IT COULD**         
      **                         NOT BE DETERMINED WHERE THIS JOB    **         
      **                         SHOULD BE PLACED IN THE SCHEDULE    **         
      **  09/22/04     SJB       CALL ROUTINE TO CORRECTLY DETERMINE **         
      **                         WS-CURR-DATE +1 (END OF MONTH PROBLEM)         
      **  03/15/05     SJB       CHANGE PROCEDURE TO RETRIEVE PAST DUE*         
      **                         AMOUNT                              **         
C33201*   03/06/06   SS82048     INCLUDE DCLGEN FOR CSS_REG_PROFILE  **         
      *                          FOR MAX DEPOSIT CALCULATION CHANGES.**         
T34097*   02/20/07   JJ95645     REPLACED MODEL_SQL STATEMENTS WITH  **         
T34097*                          SET COMMAND                         **         
      *                                                              **         
 35116**  03/19/07   RC41079     INCLUDE THE IRREVOCABLE LETTER OF   **         
 35116*                          CREDIT AMOUNT(S) AND SURETY BOND    **         
 35116*                          AMOUNT(S) IN THE DEP AMT FIELD.     **         
T36306*   09/13/07   PG36856     INCLUDE ALL WQS STATUS. ADDED UPDATE *         
T36306*                          OF LAST RUN DATE AND BE USED IN THE  *         
T36306*                          CURSOR SO THAT ONLY DATA RETRIEVED   *         
T36306*                          FROM LAST RUN DATE TO CURRENT RUN    *         
T36306*                          DATE IS PULLED. ADDED TIMESTAMP DATE.*         
T36306*                          MOVED CODE FROM 7001-FETCH TO 1000-  *         
T36306*                          PROCESS. CHANGED 7500-UPDATE TO      *         
T36306*                          8200-UPDATE.                         *         
ACT009*   02/21/13   DB41297     FIX ISSUES FOR CONNIE WILLINGHAM.    *         
ACT009*              APL4527     CHECK FOR VALID STA, DEPOSITS PEND,  *         
ACT009*                          TOTAL_AR_BALANCE.                    *         
ACT009*   04/01/13   DB41297     ADD IFNULL TO PREVENT -305 ABEND.    *         
      *                                                               *         
P00726**  07/28/2014 WR19680     ADD CHANGES TO LOOK FOR STAS IN THE  *         
P00726**                         NEW TABLE STRUCTURE                 **         
      *                                                               *         
A05154** 29 JAN 2015 RF10596     CLEAN UP PROGRAM                     *         
      *                                                               *         
A05460** 11 AUG 2016 RF10596     HEADER CHANGE                        *         
      *                                                               *         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP170 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPRT11.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPRT11.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP170'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP170 STARTS HERE'.                  
      *                                                                         
T36306 01  WS-TO-DATE-CREATED     PIC X(26).                            
T36306*                                                                         
T36306 01  WS-CUR-DATE-CREATED.                                         
T36306     05 WS-CUR-DATE-DATE    PIC X(10).                            
T36306     05 WS-CUR-DATE-TMSTAMP PIC X(16)  VALUE '-23.59.59.999999'.  
T36306*                                                                         
T36306 01  WS-DATE-CREATED.                                             
T36306     05 WS-DATE-DATE       PIC X(10).                             
T36306     05 WS-DATE-TIMESTAMP  PIC X(16)  VALUE '-23.59.59.999999'.   
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE-194-1.                             
ACT009         10  FILLER                    PIC X(31)   VALUE          
A05460         '   CT METER DISCONNECT TASKS   '.                       
               10  WS-RPT1-TITLE-194-1-LIMIT PIC Z,ZZ9.99.              
ACT009         10  FILLER                    PIC X(05)   VALUE SPACES.  
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD2.                                   
               10  FILLER              PIC X(25)     VALUE              
                   '                   AS OF '.                         
               10  WS-DEFAULT-RPT1-DT  PIC X(08).                       
               10  FILLER              PIC X(14)     VALUE SPACES.      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-COMP-BREAK-SW        PIC X(01)     VALUE 'N'.         
               88  THIS-IS-COMP-BREAK                VALUE 'Y'.         
           05  WS-MORE-DATA-SW         PIC X(01)     VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-START-REPORT         PIC X(01)     VALUE 'N'.         
               88  REPORT-STARTED                    VALUE 'Y'.         
           05  WS-RPT1-EXIST           PIC X(01)     VALUE 'N'.         
               88  REPORT-1-DOES-NOT-EXIST           VALUE 'N'.         
           05  WS-RETRIEVE-DISTRICT    PIC X(01)     VALUE 'Y'.         
               88  MUST-GET-DISTRICT                 VALUE 'Y'.         
           05  WS-RETRIEVE-LOC-OFFICE  PIC X(01)     VALUE 'Y'.         
               88  MUST-GET-LOCAL-OFFICE             VALUE 'Y'.         
           05  WS-LEADING-ZERO-SW      PIC X(01)     VALUE 'N'.         
               88  NON-LEADING-ZERO-IS-FOUND         VALUE 'Y'.         
      *                                                                         
      ** SWITCH TO INIDICATE IF AN OVERRIDE DATE IS FOUND.                      
           05 WS-UPDATE-LAST-RUN-DATE        PIC X(01).                 
              88 WS-OVERRIDE-NOT-FOUND                 VALUE 'Y'.       
           05  WS-DATABASE             PIC  9(01)   VALUE ZERO.         
               88  CSR-DATABASE                     VALUE 1.            
               88  SEB-DATABASE                     VALUE 2.            
T36306*                                                                         
T36306 01  WS-SAME-SW                  PIC X   VALUE 'N'.               
T36306 01  WS-SAVE-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.      
T36306*                                                                         
       01  WS-GENERAL-VARIABLES.                                        
           05  WS-RPT1-CNTR            PIC 9(07) COMP-3 VALUE ZERO.     
           05  WS-RPT1-PREV-LOC-OFFICE PIC X(03)     VALUE SPACES.      
           05  WS-RPT1-PREV-RESP-AREA  PIC X(03)     VALUE SPACES.      
           05  WS-ROUTINE-CTR          PIC 9(07) COMP-3 VALUE ZERO.     
           05  WS-FIRST-DGT-POSITION   PIC 9(07) COMP-3 VALUE ZERO.     
           05  WS-DISPLAY-RC           PIC S9(04) COMP.                 
           05  WS-BC-CURR-DATE         PIC X(10)     VALUE SPACES.      
           05  WS-CURR-DATE            PIC X(10)     VALUE SPACES.      
           05  WS-CURR-DATE-N  REDEFINES WS-CURR-DATE.                  
               10 WS-YEAR-N            PIC 9999.                        
               10 WS-DASH-1            PIC X.                           
               10 WS-MONTH-1           PIC 99.                          
               10 WS-DASH-2            PIC X.                           
               10 WS-DAY-N             PIC 99.                          
COB305     05 WS-DNP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.            
           05  WS-DNP-AMT-NULL         PIC S9(04)    COMP VALUE +0.     
COB305     05 WS-AMT-DEPOSIT        PIC S9(09)V99 COMP-3 VALUE 0.            
 35116     05  WS-BOND-TOTAL-AMT       PIC S9(09)V99 COMP-3 VALUE +0.   
COB305     05 WS-AMT-NOTICE-G        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-AMT-NOTICE-D        PIC S9(09)V99 COMP-3 VALUE 0.            
           05  WS-TIMESTAMP-G          PIC X(10)     VALUE SPACES.      
           05  WS-TIMESTAMP-D          PIC X(10)     VALUE SPACES.      
           05  WS-DEPOSIT-AMT-NULL     PIC S9(04)    COMP VALUE +0.     
 35116     05  WS-BOND-TOTAL-AMT-NULL  PIC S9(04)    COMP VALUE +0.     
COB305     05 WS-PAST-DUE-AMT        PIC S9(09)V99 COMP-3 VALUE 0.            
      *                                                                         
       01  WS-ACCUMULATORS.                                             
           05  WS-RPT1-COMPANY-TOTALS.                                  
               10  WS-COMP-DNP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-AR-AMT      PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-DEP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-MAX-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-NUM-ACCTS   PIC S9(09)    COMP-3 VALUE +0.   
           05  WS-RPT1-DISTRICT-TOTALS.                                 
               10  WS-DIST-DNP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-AR-AMT      PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-DEP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-MAX-AMT     PIC S9(09)    COMP-3 VALUE +0.   
               10  WS-DIST-NUM-ACCTS   PIC S9(09)    COMP-3 VALUE +0.   
      *                                                                         
       01 WS-COMMON-INFO.                                               
      *                                                                         
           05  WS-DBA-NAME             PIC X(50)     VALUE SPACES.      
           05  WS-NAME-CUST            PIC X(50)     VALUE SPACES.      
           05  WS-SERVICE-ADDR1        PIC X(50)     VALUE SPACES.      
           05  WS-SERVICE-ADDR3        PIC X(50)     VALUE SPACES.      
           05  WS-ARREARS-HIST         PIC X(24)     VALUE SPACES.      
           05  WS-DISCONNECT-HIST      PIC X(24)     VALUE SPACES.      
           05  WS-DATE-UTIL-SVC-STRT   PIC X(10)     VALUE SPACES.      
           05  WS-NO-MONTH             PIC S9(04)    COMP   VALUE +0.   
           05  WS-NO-MONTH-STRT        PIC S9(04)    COMP   VALUE +0.   
           05  WS-NO-MONTH-END         PIC S9(04)    COMP   VALUE +0.   
           05  WS-NULL-DATE-UTL-END    PIC S9(04)    COMP VALUE +0.     
           05  WS-NULL-MAX-AMT         PIC S9(04)    COMP VALUE +0.     
           05  WS-LAST-PYMT-DATE-NULL  PIC S9(04)    COMP VALUE +0.     
           05  WS-HOLD-LOC-OFF-NM      PIC X(22)     VALUE SPACES.      
           05  WS-HOLD-LOC-OFF-CD      PIC X(03)     VALUE SPACES.      
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00011.                                                           
       COPY CWS00150.                                                           
       COPY CWS00039.                                                           
      *                                                                         
       COPY FIOJC01.                                                    00021500
       COPY FIOCA00.                                                    00021500
      *                                                                         
           EXEC SQL                                                     00042200
              INCLUDE CWS00074                                          00042300
           END-EXEC.                                                    00042400
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                          00017800
           END-EXEC.                                                            
      *                                                                         
       01  WS-BRKDOWN-PARM-DATA-1 REDEFINES                             
           WS-INPUT-DATA-BREAKDOWN.                                     
           05  WS-LAST-RUN            PIC X(14).                        
               88  WS-LAST-RUN-TEXT   VALUE 'LAST RUN DATE='.           
           05  WS-LAST-RUN-DATE       PIC X(10).                        
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
T36306     05  WS-CT                   PIC 9(02).                       
           05  WS-CY                   PIC 9(02).                       
T36306     05  FILLER                  PIC X(01).                       
           05  WS-CM                   PIC 9(02).                       
T36306     05  FILLER                  PIC X(01).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-REV-MTH.                                                  
           05  WS-REV-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-REV-CCYY             PIC X(04).                       
      *                                                                         
       01  WS-HOLD-ITEM-ID             PIC 9(09).                       
       01  WS-REDEF-ITEM-ID REDEFINES WS-HOLD-ITEM-ID.                  
           05  WS-REDEFINED-ITEM-ID    PIC X(09).                       
      *                                                                         
COB305 01 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
COB305 01 RS-MIN-DEPOSIT-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSRP170'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSRP170'.  
           05  WS-PGRMNAME-1           PIC X(10)     VALUE 'PCSRP170-1'.
           05  WS-SPC                  PIC X(01)     VALUE ' '.         
           05  WS-1                    PIC 9(01)     VALUE 1.           
           05  WS-2                    PIC 9(01)     VALUE 2.           
           05  WS-3                    PIC 9(01)     VALUE 3.           
           05  WS-42                   PIC 9(02)     VALUE 42.          
           05  WS-46                   PIC 9(02)     VALUE 46.          
           05  WS-50                   PIC 9(02)     VALUE 50.          
           05  WS-60                   PIC 9(02)     VALUE 60.          
           05  WS-62                   PIC 9(02)     VALUE 62.          
           05  WS-I                    PIC 9(02)     VALUE 0.           
           05  WS-NO-LASTRUNDATE       PIC X(03)     VALUE 'END'.       
           05  WS-DEP-REFUND           PIC X(01)     VALUE 'B'.         
      *                                                                         
           05  WS-LIT-ARREARS          PIC X(08)     VALUE 'ARREARS '.  
           05  WS-LIT-BALANCE          PIC X(08)     VALUE 'BALANCE '.  
           05  WS-LIT-EXEMPT           PIC X(08)     VALUE 'EXEMPT  '.  
           05  WS-LIT-NEW              PIC X(08)     VALUE 'NEW     '.  
           05  WS-LIT-NON-UTIL         PIC X(11)     VALUE              
                                                 'NON-UTILITY'.         
           05  WS-LIT-MASTER           PIC X(08)     VALUE 'MASTER  '.  
           05  WS-LIT-SUB              PIC X(08)     VALUE 'SUB ACCT'.  
      *                                                                         
      ****************************************************************          
      ******************* PCSRP170 REPORT HEADERS ********************          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLES         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-TITLE.                                            
               10  FILLER              PIC X         VALUE SPACES.      
               10  P-RPT-TITLE-PGNM    PIC X(10).                       
               10  FILLER              PIC X(43)     VALUE SPACES.      
               10  FILLER              PIC X(26)     VALUE              
                                       '     S C ELECTRIC & GAS   '.    
               10  FILLER              PIC X(35)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-DATE: '.
               10  P-RPT-RUN-DATE      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(06)     VALUE 'DATE: '.    
               10  P-RPT-DATE          PIC X(08).                       
               10  FILLER              PIC X(37)     VALUE SPACES.      
               10  P-RPT-HEAD1         PIC X(30).                       
               10  FILLER              PIC X(33)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-TIME: '.
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(41)     VALUE SPACES.      
               10  P-RPT-HEAD2         PIC X(50).                       
               10  FILLER              PIC X(27)     VALUE SPACES.      
               10  FILLER              PIC X(05)     VALUE 'PAGE:'.     
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR DISTRICT HEADER           **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-DIST.                                      
               10  FILLER              PIC X         VALUE SPACE.       
               10  FILLER              PIC X(09)     VALUE              
                                                 'DISTRICT:'.           
               10  FILLER              PIC X(02)     VALUE SPACES.      
               10  P-RPT-DIST-NM       PIC X(30).                       
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 1       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-01.                                          
               10  FILLER              PIC X(65)     VALUE SPACES.      
               10  FILLER              PIC X(11)     VALUE              
                                                 'ARREARS    '.         
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 2       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-02.                                          
               10  FILLER              PIC X(28)     VALUE SPACES.      
               10  FILLER              PIC X(04)     VALUE 'NAME'.      
               10  FILLER              PIC X(33)     VALUE SPACES.      
               10  FILLER              PIC X(11)     VALUE              
                                                 'NORMAL     '.         
               10  FILLER              PIC X(19)     VALUE SPACES.      
               10  FILLER              PIC X(12)     VALUE              
                                                 'CREDIT GROUP'.        
      *                                                                         
      ****************************************************************          
      **    COMMON WORKING STORAGE FOR REPORT 1     HEADER 3        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-03.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE              
                                                 'ACCOUNT NO'.          
               10  FILLER              PIC X(18)     VALUE SPACES.      
               10  FILLER              PIC X(07)     VALUE 'ADDRESS'.   
 35116         10  FILLER              PIC X(30)     VALUE SPACES.      
 35116         10  FILLER              PIC X(11)     VALUE              
                                                 'DEP AMT/MAX'.         
               10  FILLER              PIC X(19)     VALUE SPACES.      
               10  FILLER              PIC X(13)     VALUE              
                                                 'LAST PYMT AMT'.       
               10  FILLER              PIC X(05)     VALUE SPACES.      
               10  FILLER              PIC X(16)     VALUE              
                                                 'TOTAL AR BALANCE'.    
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 4       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-04.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(12)     VALUE              
                                                 'LOCAL OFFICE'.        
               10  FILLER              PIC X(16)     VALUE SPACES.      
               10  FILLER              PIC X(03)     VALUE              
                                                 'DBA'.                 
               10  FILLER              PIC X(34)     VALUE SPACES.      
               10  FILLER              PIC X(12)     VALUE              
                                                 'TURN-ON DATE'.        
               10  FILLER              PIC X(18)     VALUE SPACES.      
               10  FILLER              PIC X(12)     VALUE              
                                                 'LAST PYMT DT'.        
               10  FILLER              PIC X(06)     VALUE SPACES.      
               10  FILLER              PIC X(18)     VALUE              
                                                 'TOTAL PAST DUE AMT'.  
      *                                                                         
      ****************************************************************          
      **********************PCSRP170 REPORT DETAILS*******************          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 1  **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-101.                                      
               10  FILLER              PIC X         VALUE SPACES.      
               10  P1-ACCOUNT-NO       PIC 9(13).                       
               10  FILLER              PIC X(15)     VALUE SPACES.      
               10  P1-FULL-NAME        PIC X(33).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P1-ARREARS-HISTORY  PIC X(12).                       
               10  FILLER              PIC X(18)     VALUE SPACES.      
               10  P1-CREDIT-GRP       PIC X(11).                       
               10  FILLER              PIC X(11)     VALUE SPACES.      
               10  P1-AR-BAL           PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 2    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-102.                                      
               10  FILLER              PIC X         VALUE SPACES.      
               10  P1-LOC-OFF-CD       PIC X(03).                       
               10  FILLER              PIC X(01)     VALUE '-'.         
               10  P1-LOC-OFF-NM       PIC X(22).                       
               10  FILLER              PIC X(02)     VALUE SPACES.      
               10  P1-SERVICE-ADDR01   PIC X(33).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P1-NORMAL-HISTORY   PIC X(12).                       
               10  FILLER              PIC X(16)     VALUE SPACES.      
               10  P1-LAST-PYMNT-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(10)     VALUE SPACES.      
               10  P1-PAST-DUE         PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 3    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-103.                                      
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(28)     VALUE SPACES.      
               10  P1-SERVICE-ADDR03   PIC X(33).                       
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P1-DEP-AMT          PIC $,$$$,$$9.99.                
               10  FILLER              PIC X(01)     VALUE '/'.         
               10  P1-DEP-AMT-MAX      PIC $,$$$,$$9.99.                
               10  FILLER              PIC X(09)     VALUE SPACES.      
               10  P1-LAST-PYMT-DATE   PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 4    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-104.                                      
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(28)     VALUE SPACES.      
               10  P1-DBA-NAME         PIC X(33)     VALUE SPACES.      
               10  FILLER              PIC X(04)     VALUE SPACES.      
               10  P1-ON-DATE          PIC X(08).                       
      *                                                                         
      ****************************************************************          
      ******************PCSRP170 REPORT TOTAL LINES*******************          
      ****************************************************************          
      *                                                                         
       01  WS-TOTAL-LINES.                                              
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT101.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL AR  AMT CT DISCONNECT FOR '.     
               10  P101-DIST-NM          PIC X(30)     VALUE SPACES.    
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE              
                                                 'DISTRICT: '.          
               10  P101-DIST-AR-AMOUNT    PIC $$$,$$$,$$9.99.           
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT101A.                                         
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL DNP AMT CT DISCONNECT FOR '.     
               10  P101A-DIST-NM          PIC X(30)     VALUE SPACES.   
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE              
                                                 'DISTRICT: '.          
               10  P101A-DIST-DNP-AMOUNT    PIC $$$,$$$,$$9.99.         
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 2, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT102.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL NUMBER  CT DISCONNECT FOR '.     
               10  P102-DIST-NM        PIC X(30)     VALUE SPACES.      
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(13)     VALUE              
                                                 'DISTRICT: '.          
               10  P102-DIST-NUM-ACCTS   PIC ZZZZZZZZZZ9  VALUE SPACES. 
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 3, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT103.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL DEPOSIT AMOUNT        FOR '.     
               10  P103-DIST-NM          PIC X(30)     VALUE SPACES.    
               10  FILLER              PIC X(01)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE              
                                                 'DISTRICT: '.          
               10  P103-DIST-DEP-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  FILLER              PIC X(28)     VALUE              
                                'OF TOTAL MAX DEPOSIT AMOUNT:'.         
               10  P103-DIST-MAX-AMT   PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT101.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL AR  AMT CT DISCONNECT FOR '.     
               10  FILLER              PIC X(20)  VALUE                 
                                'S C ELECTRIC & GAS: '.                 
               10  P101-COMP-AR-AMOUNT    PIC $$$,$$$,$$9.99.           
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 1A, RPT 1    **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT101A.                                         
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL DNP AMT CT DISCONNECT FOR '.     
               10  FILLER              PIC X(20)  VALUE                 
                                'S C ELECTRIC & GAS: '.                 
               10  P101A-COMP-DNP-AMOUNT    PIC $$$,$$$,$$9.99.         
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 2, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT102.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL NUMBER  CT DISCONNECT FOR '.     
               10  FILLER                PIC X(23)     VALUE            
                                           'S C ELECTRIC & GAS:    '.   
               10  P102-COMP-NUM-ACCTS   PIC ZZZZZZZZZZ9 VALUE SPACES.  
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 3, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT103.                                          
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(32)     VALUE              
                                'TOTAL DEPOSIT AMOUNT        FOR '.     
               10  FILLER                PIC X(20)     VALUE            
                                              'S C ELECTRIC & GAS: '.   
               10  P103-COMP-DEP-AMT     PIC $$$,$$$,$$9.99.            
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  FILLER              PIC X(29)     VALUE              
                                'OF TOTAL MAX DEPOSIT AMOUNT: '.        
               10  P103-COMP-MAX-AMT   PIC $$$,$$$,$$9.99.              
      *                                                                         
       01  WS-PRINT-FUNCTION.                                           
           05  P-OUTPUT-LINE           PIC X(132)    VALUE SPACES.      
           05  WS-LINE                 PIC X(132)    VALUE ALL '-'.     
           05  WS-BLANK-LINE           PIC X(132)    VALUE SPACES.      
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                              '** NO DATA THIS RUN **'. 
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                               '*** END OF REPORT ***'. 
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-PRINT-CONTROL.                                            
           05  WS-RPT1-LINE-NO         PIC 9(02) COMP-3  VALUE 62.      
           05  WS-RPT1-PAGE-NO         PIC 9(02) COMP-3  VALUE ZERO.    
           05  WS-SKIP-LINES-NUM       PIC 9(02)         VALUE ZERO.    
      *                                                                         
       01  WS-ERROR-VARIABLES.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP.                 
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-DISP-RETURN-CODE     PIC +Z(04).                      
      *                                                                         
      ****** SQLCA *****************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_LOCAL_OFFICE ********************        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_ACCOUNT *************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_NAME_ACCT_XREF ******************        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_WQ_ITEMS ************************        
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_RESP_AREA      ******************        
           EXEC SQL                                                             
               INCLUDE TBRSAREA                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_CUST_PREM_HIST ******************        
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_MISC_INFO *****************        
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_JOB_PARM ************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_NAME ****************************        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_ADDR_FORMATTED ******************        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_ADDR_FREEFORM  ******************        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_ZIP_CODE ************************        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_CREDIT_PROFILE ******************        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_CUST_ADDR_XREF ******************        
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_DELINQUENCY    ******************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_UTIL_ENVRNMT   ******************        
           EXEC SQL                                                     00930000
              INCLUDE TBUTLENV                                          00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
      ****** TABLE DECLARATION FOR CSS_RATE_CREATOR   ******************        
           EXEC SQL                                                     00930000
              INCLUDE TBRTCRTR                                          00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
      ****** CURSOR DECLARATION FOR WQ FOR CT METER DISCONNECT *********        
           EXEC SQL                                                     
               DECLARE WQ_CSR CURSOR FOR                                
               SELECT   AT.ACCOUNT_NO,                                  
                        AT.PREMISE_NO,                                  
                        AT.LOCAL_OFFICE,                                
                        AT.ADDRESS_FORMAT,                              
                        AT.ADDRESS_ID,                                  
                        AT.LAST_PYMT_AMOUNT,                            
                        AT.LAST_PYMT_DATE,                              
                        AT.BILL_CYCLE,                                  
                        AT.CREDIT_GROUP,                                
                        AT.TOTAL_AR_BALANCE,                            
                        WQ.RESP_AREA_ID                                 
               FROM     CSS_ACCOUNT        AT WITH(READUNCOMMITTED),            
                        CSS_WQ_ITEMS       WQ WITH(READUNCOMMITTED)             
               WHERE    AT.COMPANY_NO = '01'                            
                 AND    AT.ACCOUNT_NO = WQ.ACCOUNT_NO                   
                 AND    WQ.CATEGORY_ID  = 108                           
T36306           AND    WQ.STATUS  IN ('A', 'C', 'I')                   
T36306           AND    WQ.DATE_CREATED >  CIS.CHAR2TIMESTAMP(
                                                       :WQ-DATE-CREATED
              )             
T36306           AND    WQ.DATE_CREATED <= CIS.CHAR2TIMESTAMP(
                                                    :WS-TO-DATE-CREATED
              )          
ACT009           AND   (AT.TOTAL_AR_BALANCE > 0                         
ACT009            OR CIS.SUBSTR3(AT.CODES_DATA_PRESENT,7,1)  = 'A'           
ACT009            OR CIS.SUBSTR3(AT.CODES_DATA_PRESENT,17,1) = 'A')          
P00726           AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,22,1) <> 'A'          
               ORDER BY                                                 
                   WQ.RESP_AREA_ID,                                     
                   AT.TOTAL_AR_BALANCE DESC                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WQ_CSR CURSOR FOR                                        
MFA-TR*        SELECT   AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 AT.ADDRESS_FORMAT,                                      
MFA-TR*                 AT.ADDRESS_ID,                                          
MFA-TR*                 AT.LAST_PYMT_AMOUNT,                                    
MFA-TR*                 AT.LAST_PYMT_DATE,                                      
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.CREDIT_GROUP,                                        
MFA-TR*                 AT.TOTAL_AR_BALANCE,                                    
MFA-TR*                 WQ.RESP_AREA_ID                                         
MFA-TR*        FROM     CSS_ACCOUNT        AT,                                  
MFA-TR*                 CSS_WQ_ITEMS       WQ                                   
MFA-TR*        WHERE    AT.COMPANY_NO = '01'                                    
MFA-TR*          AND    AT.ACCOUNT_NO = WQ.ACCOUNT_NO                           
MFA-TR*          AND    WQ.CATEGORY_ID  = 108                                   
MFA-TR*          AND    WQ.STATUS  IN ('A', 'C', 'I')                           
MFA-TR*          AND    WQ.DATE_CREATED >  :WQ-DATE-CREATED                     
MFA-TR*          AND    WQ.DATE_CREATED <= :WS-TO-DATE-CREATED                  
MFA-TR*          AND   (AT.TOTAL_AR_BALANCE > 0                                 
MFA-TR*           OR SUBSTR(AT.CODES_DATA_PRESENT,7,1)  = 'A'                   
MFA-TR*           OR SUBSTR(AT.CODES_DATA_PRESENT,17,1) = 'A')                  
MFA-TR*          AND SUBSTR(AT.CODES_DATA_PRESENT,22,1) <> 'A'                  
MFA-TR*        ORDER BY                                                         
MFA-TR*            WQ.RESP_AREA_ID,                                             
MFA-TR*            AT.TOTAL_AR_BALANCE DESC                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****** CURSOR DECLARATION FOR SERVICE START AND SERVICE END DATE *00075600
           EXEC SQL                                                     
               DECLARE CUST_PREM CURSOR FOR                             
               SELECT                                                   
                    DATE_UTIL_SVC_STRT,                                 
                    DATE_UTIL_SVC_END                                   
              FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND PREMISE_NO = :AT-PREMISE-NO                         
              ORDER BY DATE_UTIL_SVC_STRT DESC                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00075700
MFA-TR*        DECLARE CUST_PREM CURSOR FOR                             00075800
MFA-TR*        SELECT                                                   00075900
MFA-TR*             DATE_UTIL_SVC_STRT,                                 00076000
MFA-TR*             DATE_UTIL_SVC_END                                   00076100
MFA-TR*       FROM CSS_CUST_PREM_HIST                                   00076200
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         00076300
MFA-TR*         AND PREMISE_NO = :AT-PREMISE-NO                         00076400
MFA-TR*       ORDER BY DATE_UTIL_SVC_STRT DESC                          00076500
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    00076600
      *                                                                         
      ****** CURSOR DECLARATION FOR CSS_CRED_COLL                      *00075600
           EXEC SQL                                                     
               DECLARE CRED_COLL_G CURSOR FOR                           
               SELECT                                                   
                    AMT_NOTICE                                          
                   ,CAST(LAST_UPDATE_TS AS DATE)                                
              FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND CODE_NOTICE_TYPE = 'G'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00075700
MFA-TR*        DECLARE CRED_COLL_G CURSOR FOR                                   
MFA-TR*        SELECT                                                   00075900
MFA-TR*             AMT_NOTICE                                          00076000
MFA-TR*            ,DATE(LAST_UPDATE_TS)                                        
MFA-TR*       FROM CSS_CRED_COLL                                        00076200
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         00076300
MFA-TR*         AND CODE_NOTICE_TYPE = 'G'                              00076400
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    00076600
      *                                                                 00076700
           EXEC SQL                                                     
               DECLARE CRED_COLL_D CURSOR FOR                           
               SELECT                                                   
                    AMT_NOTICE                                          
                   ,CAST(LAST_UPDATE_TS AS DATE)                                
              FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND CODE_NOTICE_TYPE = 'D'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00075700
MFA-TR*        DECLARE CRED_COLL_D CURSOR FOR                                   
MFA-TR*        SELECT                                                   00075900
MFA-TR*             AMT_NOTICE                                          00076000
MFA-TR*            ,DATE(LAST_UPDATE_TS)                                00076000
MFA-TR*       FROM CSS_CRED_COLL                                        00076200
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         00076300
MFA-TR*         AND CODE_NOTICE_TYPE = 'D'                              00076400
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    00076600
      *                                                                 00076700
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSRP170 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 1100-PRODUCE-REPORT-1             THRU 1100-EXIT     
             UNTIL NO-MORE-DATA.                                        
      *                                                                         
           IF REPORT-STARTED                                            
               PERFORM 7002-CLOSE-WQ-CSR       THRU 7002-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 9500-CLEANUP                      THRU 9500-EXIT.    
      *                                                                         
T36306     STRING WS-LAST-RUN   DELIMITED BY SIZE                       
T36306            WS-CURR-DATE  DELIMITED BY SIZE                       
T36306     INTO   G6-PARM-DATA.                                         
      *                                                                         
T36306     MOVE WS-PGRMNAME    TO G6-PROGRAM-NAME.                      
T36306     MOVE WS-PARM        TO G6-CMND-CODE.                         
      *                                                                         
T36306     PERFORM 8200-UPDATE-LAST-RUN-DATE THRU 8200-EXIT.            
                                                                        
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME                             
           MOVE WS-HH                     TO WS-RT-HH                   
           MOVE WS-MM                     TO WS-RT-MM                   
           MOVE WS-SS                     TO WS-RT-SS                   
           MOVE WS-RUN-TIME               TO P-RPT-RUN-TIME             
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE                             
           MOVE WS-CY                     TO WS-RD-YY                   
           MOVE WS-CM                     TO WS-RD-MM                   
           MOVE WS-CD                     TO WS-RD-DD                   
           MOVE WS-RUN-DATE               TO P-RPT-RUN-DATE             
      *                                                                         
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-DATE     TO WS-COMMAND.                             
           MOVE  SPACES      TO WS-SYSIPT.                              
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE                   THRU 6251-EXIT.
T36306     MOVE WS-INPUT-DATE TO WS-CURRENT-DATE.                       
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                      THRU 6240-EXIT    
               DISPLAY 'FCA00-COMMON-DATE EQUALS ' WS-FCA00-COMMON-DATE 
               MOVE WS-FCA00-COMMON-DATE                                
                                       TO WS-INPUT-DATE                 
                                                                        
T36306         MOVE WS-INPUT-DATE TO WS-CURRENT-DATE                    
               MOVE WS-Y               TO WS-UPDATE-LAST-RUN-DATE       
                                                                        
           END-IF.                                                      
T36306*                                                                         
T36306     MOVE WS-CURRENT-DATE TO WS-CUR-DATE-DATE.                    
T36306     MOVE WS-CUR-DATE-CREATED TO WS-TO-DATE-CREATED.              
T36306*                                                                         
T36306     MOVE WS-CY             TO WS-RD-YY.                          
T36306     MOVE WS-CM             TO WS-RD-MM.                          
T36306     MOVE WS-CD             TO WS-RD-DD.                          
T36306     MOVE WS-RUN-DATE       TO P-RPT-RUN-DATE.                    
T36306*                                                                         
           MOVE WS-INPUT-DATE          TO WS-CURR-DATE                  
                                          WS-DATE-10.                   
               DISPLAY 'WS-CURR-DATE             ' WS-CURR-DATE         
                                                                        
           MOVE WS-D10-MM              TO WS-D8-MM                      
           MOVE WS-D10-DD              TO WS-D8-DD                      
           MOVE WS-D10-YY              TO WS-D8-YY                      
           MOVE WS-DATE-8              TO P-RPT-DATE                    
                                          WS-DEFAULT-RPT1-DT.           
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE                              
                                       THRU 6200-EXIT.                  
           PERFORM 7611-CLOSE          THRU  7611-EXIT.                 
           MOVE WS-PARM-MONTH          TO WS-REV-MM.                    
           MOVE WS-PARM-YR             TO WS-REV-CCYY.                  
                                                                        
                                                                        
           OPEN OUTPUT FCSPRT11-FILE.                                   
      *                                                                         
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-PARM     TO WS-COMMAND.                             
           MOVE  SPACES      TO WS-SYSIPT.                              
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT.                 
                                                                        
           IF WS-SYSIPT EQUAL WS-NO-LASTRUNDATE                         
                DISPLAY '*********************************'             
                DISPLAY '**  PCSRP170 PROCESSING ERROR  **'             
                DISPLAY '**  LAST RUN DATE NOT FOUND    **'             
                DISPLAY '**    PROCESSING TERMINATED    **'             
                DISPLAY '*********************************'             
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
T36306*                                                                         
T36306          DISPLAY '*******************************'               
T36306          DISPLAY 'LAST RUN DATE' WS-LAST-RUN-DATE                
T36306          DISPLAY '*******************************'               
T36306*                                                                         
T36306          MOVE WS-LAST-RUN-DATE TO WS-DATE-DATE.                  
T36306          MOVE WS-DATE-CREATED  TO WQ-DATE-CREATED.               
T36306*                                                                         
           IF WS-CURRENT-DATE < WS-LAST-RUN-DATE                        
                DISPLAY '********************************************'  
                DISPLAY '**        PCSRP170 PROCESSING ERROR        *'  
                DISPLAY '**  CURRENT RUN DATE BEFORE LAST RUN DATE  *'  
                DISPLAY '**          PROCESSING TERMINATED          *'  
                DISPLAY '********************************************'  
                PERFORM 9900-ABEND                    THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC            THRU 1000-EXIT.    
      *                                                                         
           PERFORM 1200-FORMAT-HOLD-FIELDS           THRU 1200-EXIT.    
      *                                                                         
           PERFORM 0200-INIT-RPT1-ACCUMS             THRU 0200-EXIT.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0200-INIT-RPT1-ACCUMS                                    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0200-INIT-RPT1-ACCUMS.                                           
      *                                                                         
           MOVE ZEROES                 TO WS-DIST-AR-AMT,               
                                          WS-DIST-DNP-AMT,              
                                          WS-DIST-DEP-AMT,              
                                          WS-DIST-MAX-AMT,              
                                          WS-DIST-NUM-ACCTS.            
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **                                                             **         
      **    0400-INIT-RPT1-ACCUMS                                    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0400-INIT-RPT1-ACCUMS.                                           
      *                                                                         
           MOVE ZEROES                 TO WS-COMP-AR-AMT,               
                                          WS-COMP-DNP-AMT,              
                                          WS-COMP-DEP-AMT,              
                                          WS-COMP-MAX-AMT,              
                                          WS-COMP-NUM-ACCTS.            
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  TO CHECK THE BEGIN OF THE FILE FCSRP17-FILE               **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-OPEN-WQ-CSR THRU 7000-EXIT.                     
      *                                                                         
T36306     MOVE 'N' TO WS-SAME-SW.                                      
           PERFORM 7001-FETCH-WQ-CSR THRU 7001-EXIT.                    
      *                                                                         
T36306     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T36306        MOVE AT-ACCOUNT-NO TO WS-SAVE-ACCOUNT-NO                  
T36306        IF WS-LAST-PYMT-DATE-NULL < 0                             
T36306           MOVE SPACES TO AT-LAST-PYMT-DATE                       
T36306        END-IF                                                    
T36306     ELSE                                                         
              MOVE 'N' TO WS-MORE-DATA-SW                               
T36306        MOVE 'N' TO WS-SAME-SW                                    
T36306     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORT-1                                   **           
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORT-1.                                           
      *                                                                         
           IF REPORT-STARTED                                            
              PERFORM 2800-PRODUCE-RPT THRU 2800-EXIT                   
           ELSE                                                         
              MOVE WS-Y TO WS-START-REPORT                              
              PERFORM 2800-PRODUCE-RPT THRU 2800-EXIT                   
           END-IF.                                                      
      *                                                                         
T36306     MOVE 'Y' TO WS-SAME-SW.                                      
      *                                                                         
           PERFORM 7001-FETCH-WQ-CSR THRU 7001-EXIT                     
T36306        UNTIL WS-SAME-SW = 'N'.                                   
      *                                                                         
T36306     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T36306        MOVE AT-ACCOUNT-NO TO WS-SAVE-ACCOUNT-NO                  
T36306        IF WS-LAST-PYMT-DATE-NULL < 0                             
T36306           MOVE SPACES TO AT-LAST-PYMT-DATE                       
T36306        END-IF                                                    
T36306     ELSE                                                         
              MOVE 'N' TO WS-MORE-DATA-SW                               
T36306        MOVE 'N' TO WS-SAME-SW                                    
T36306     END-IF.                                                      
      *                                                                         
           INITIALIZE WS-COMMON-INFO.                                   
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1200-FORMAT-HOLD-FIELDS                                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1200-FORMAT-HOLD-FIELDS.                                         
      *                                                                         
           MOVE AT-LOCAL-OFFICE                                         
                                       TO WS-RPT1-PREV-LOC-OFFICE.      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2050-BUILD-DETAIL-RPT1                                   **          
      **       BUILDS THE DETAIL PRINT LINE FOR BOTH WRITE OFF AMTS **          
      **       AND ACCUMULATES AMOUNTS FOR CONTROL BREAKS.          **          
      ****************************************************************          
      *                                                                         
       2050-BUILD-DETAIL-RPT1.                                          
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  1                   **          
      ****************************************************************          
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO P1-ACCOUNT-NO.                
           MOVE WS-NAME-CUST           TO P1-FULL-NAME.                 
      *                                                                         
           MOVE WS-ARREARS-HIST        TO P1-ARREARS-HISTORY.           
           MOVE AT-LAST-PYMT-AMOUNT    TO P1-LAST-PYMNT-AMT.            
           MOVE AT-TOTAL-AR-BALANCE    TO P1-AR-BAL.                    
      *                                                                         
           PERFORM 2110-PROCESS-CREDIT-GROUP         THRU 2110-EXIT.    
      *                                                                         
           MOVE 2                       TO WS-SKIP-LINES-NUM.           
           MOVE WS-DETAIL-LINE-101      TO P-OUTPUT-LINE.               
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  2                   **          
      ****************************************************************          
      *                                                                         
           IF MUST-GET-LOCAL-OFFICE                                     
             PERFORM 7700-GET-LOCAL-OFFICE           THRU 7700-EXIT     
             MOVE WS-N                 TO WS-RETRIEVE-LOC-OFFICE        
           END-IF.                                                      
      *                                                                         
           MOVE WS-SERVICE-ADDR1       TO P1-SERVICE-ADDR01.            
      *                                                                         
           MOVE WS-DISCONNECT-HIST     TO P1-NORMAL-HISTORY.            
      *                                                                         
           IF AT-LAST-PYMT-DATE    EQUAL SPACES                         
            OR AT-LAST-PYMT-DATE    EQUAL LOW-VALUES                    
             MOVE SPACES               TO P1-LAST-PYMT-DATE             
           ELSE                                                         
             MOVE AT-LAST-PYMT-DATE    TO WS-DATE-10                    
             MOVE WS-D10-YY            TO WS-D8-YY                      
             MOVE WS-D10-MM            TO WS-D8-MM                      
             MOVE WS-D10-DD            TO WS-D8-DD                      
             MOVE WS-DATE-8            TO P1-LAST-PYMT-DATE             
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS TO  WS-AMT-NOTICE-G                               
                          WS-AMT-NOTICE-D.                              
ACT009     PERFORM 2115-PAST-DUE-AMT  THRU 2115-EXIT.                   
ACT009     MOVE WS-AMT-NOTICE-D  TO P1-PAST-DUE                         
ACT009                              WS-PAST-DUE-AMT.                    
                                                                        
      *                                                                         
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-102     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  3                   **          
      ****************************************************************          
      *                                                                         
           MOVE WS-SERVICE-ADDR3       TO P1-SERVICE-ADDR03.            
      *                                                                         
           PERFORM 7310-SELECT-SUM-DEP-AMT            THRU 7310-EXIT.   
      *                                                                         
 35116     MOVE ZEROS                  TO WS-BOND-TOTAL-AMT.            
      *                                                                         
 35116     PERFORM 7400-SELECT-SUM-BOND-AMT           THRU 7400-EXIT.   
      *                                                                         
           MOVE WS-AMT-DEPOSIT         TO P1-DEP-AMT.                   
      *                                                                         
           PERFORM 2600-GET-MAX-DEPOSIT    THRU 2600-EXIT.              
           MOVE WS-MAX-DEPOSIT-AMT     TO P1-DEP-AMT-MAX.               
      *                                                                         
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-103     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  4                   **          
      ****************************************************************          
      *                                                                         
           IF WS-DATE-UTIL-SVC-STRT EQUAL SPACES                        
            OR WS-DATE-UTIL-SVC-STRT EQUAL LOW-VALUES                   
             MOVE SPACES                TO P1-ON-DATE                   
           ELSE                                                         
             MOVE WS-DATE-UTIL-SVC-STRT TO WS-DATE-10                   
             MOVE WS-D10-YY             TO WS-D8-YY                     
             MOVE WS-D10-MM             TO WS-D8-MM                     
             MOVE WS-D10-DD             TO WS-D8-DD                     
             MOVE WS-DATE-8             TO P1-ON-DATE                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7160-SELECT-DBA-NAME              THRU 7160-EXIT.    
           MOVE WS-DBA-NAME            TO P1-DBA-NAME.                  
      *                                                                         
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-104     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
      *****************************************************************         
      **                    R E P O R T   T O T A L S                **         
      *****************************************************************         
      *                                                                         
           ADD AT-TOTAL-AR-BALANCE TO WS-COMP-AR-AMT,                   
                                      WS-DIST-AR-AMT.                   
           ADD WS-PAST-DUE-AMT     TO WS-COMP-DNP-AMT,                  
                                      WS-DIST-DNP-AMT.                  
           ADD WS-AMT-DEPOSIT      TO WS-COMP-DEP-AMT,                  
                                      WS-DIST-DEP-AMT.                  
           ADD WS-MAX-DEPOSIT-AMT  TO WS-COMP-MAX-AMT,                  
                                      WS-DIST-MAX-AMT.                  
           ADD +1                  TO WS-COMP-NUM-ACCTS,                
                                      WS-DIST-NUM-ACCTS.                
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    2110-PROCESS-CREDIT-GROUP                                **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       2110-PROCESS-CREDIT-GROUP.                                       
      *                                                                         
           EVALUATE TRUE                                                
             WHEN AT-CREDIT-GROUP    EQUAL 'A'                          
               MOVE WS-LIT-ARREARS     TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'B'                          
               MOVE WS-LIT-BALANCE     TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'C'                          
               MOVE WS-LIT-EXEMPT      TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'N'                          
               MOVE WS-LIT-NEW         TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'D'                          
               MOVE WS-LIT-NON-UTIL    TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'M'                          
               MOVE WS-LIT-MASTER      TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    EQUAL 'S'                          
               MOVE WS-LIT-SUB         TO P1-CREDIT-GRP                 
           END-EVALUATE.                                                
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2115-PAST-DUE-AMT                                        **          
      ****************************************************************          
      *                                                                         
       2115-PAST-DUE-AMT.                                               
      *                                                                         
           MOVE '2115'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
ACT009     EXEC SQL                                                     
ACT009        SELECT                                                    
ACT009         COALESCE(SUM(AMT_NOTICE),0.0)                              
ACT009         INTO     :WS-AMT-NOTICE-D                                
ACT009       FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                           
ACT009       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
ACT009         AND CODE_NOTICE_TYPE IN('G','D')                         
ACT009                                                           
ACT009     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*        IFNULL(SUM(AMT_NOTICE),0.0)                                      
MFA-TR*        INTO     :WS-AMT-NOTICE-D                                        
MFA-TR*      FROM CSS_CRED_COLL                                                 
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                  
MFA-TR*        AND CODE_NOTICE_TYPE IN('G','D')                                 
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT009                                                                  
ACT009     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ACT009       CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*******************************************'      
             DISPLAY '*       PCSRP170 PROCESSING ERROR         *'      
ACT009       DISPLAY '*      ERROR OPENING CSS_CRED_COLL        *'      
             DISPLAY '* RETURN CODE = ' SQLCODE                         
             DISPLAY '*         PROCESSING TERMINATED           *'      
             DISPLAY '*******************************************'      
ACT009       MOVE 'SELECT'             TO ABEND-FUNCTION                
ACT009       MOVE 'CSS_CRED_COLL'      TO TABLE-1                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2210-TOTAL-DISTRICT                                      **          
      **       CONTROLS THE REPORT BREAK FOR DISTRICT CHANGE REPORT **          
      **       PCSRP170-1.                                          **          
      ****************************************************************          
      *                                                                         
       2210-TOTAL-DISTRICT.                                             
      *                                                                         
             IF WS-DIST-NUM-ACCTS EQUAL 0                               
               CONTINUE                                                 
             ELSE                                                       
      *                                                                         
               MOVE WS-DIST-AR-AMT     TO P101-DIST-AR-AMOUNT           
               MOVE WS-DIST-TOT101  TO P-OUTPUT-LINE                    
               MOVE 4                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-DIST-DNP-AMT    TO P101A-DIST-DNP-AMOUNT         
               MOVE WS-DIST-TOT101A TO P-OUTPUT-LINE                    
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-DIST-NUM-ACCTS  TO P102-DIST-NUM-ACCTS           
               MOVE WS-DIST-TOT102  TO P-OUTPUT-LINE                    
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-DIST-DEP-AMT TO P103-DIST-DEP-AMT                
               MOVE WS-DIST-MAX-AMT TO P103-DIST-MAX-AMT                
               MOVE WS-DIST-TOT103  TO P-OUTPUT-LINE                    
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               PERFORM 0200-INIT-RPT1-ACCUMS     THRU 0200-EXIT         
           END-IF.                                                      
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-TOTAL-COMPANY                                       **          
      **       CONTROLS THE REPORT BREAK FOR THE COMPANY            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-TOTAL-COMPANY.                                              
      *                                                                         
             IF WS-COMP-NUM-ACCTS EQUAL 0                               
               CONTINUE                                                 
             ELSE                                                       
               MOVE WS-COMP-AR-AMT     TO P101-COMP-AR-AMOUNT           
               MOVE WS-COMP-TOT101                                      
                                       TO P-OUTPUT-LINE                 
               MOVE 4                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-COMP-DNP-AMT    TO P101A-COMP-DNP-AMOUNT         
               MOVE WS-COMP-TOT101A                                     
                                       TO P-OUTPUT-LINE                 
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-COMP-NUM-ACCTS  TO P102-COMP-NUM-ACCTS           
               MOVE WS-COMP-TOT102                                      
                                       TO P-OUTPUT-LINE                 
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               MOVE WS-COMP-DEP-AMT TO P103-COMP-DEP-AMT                
               MOVE WS-COMP-MAX-AMT TO P103-COMP-MAX-AMT                
               MOVE WS-COMP-TOT103  TO P-OUTPUT-LINE                    
               MOVE 2                  TO WS-SKIP-LINES-NUM             
               PERFORM 8500-PRINT-PCSRP170           THRU 8500-EXIT     
      *                                                                         
               PERFORM 0400-INIT-RPT1-ACCUMS     THRU 0400-EXIT         
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  2600-GET-MAX-DEPOSIT                                       **         
      **                                                             **         
      **  THIS PARAGRAPH RETRIEVES THE MAXIMUM ALLOWABLE DEPOSIT FOR **         
      **  AN ACCOUNT.  THE CALCULATION IS DONE IN CPD00308.          **         
      **                                                             **         
      *****************************************************************         
       2600-GET-MAX-DEPOSIT.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO   TO    WS-ACCOUNT-NO.                    
           MOVE AT-PREMISE-NO   TO    WS-PREMISE-NO.                    
           MOVE 'Y'             TO    WS-CALLING-BATCH-SW.              
           MOVE  1              TO    WS-DATABASE.                      
           MOVE WS-INPUT-DATE   TO    WS-TEMP-BATCH-DATE.               
           PERFORM 5650-GET-MAX-DEPOSIT                                 
              THRU 5650-GET-MAX-DEPOSIT-EXIT.                           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2800-PRODUCE-RPT                                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2800-PRODUCE-RPT.                                                
      *                                                                         
           PERFORM 2805-GET-COMMON-INFO               THRU 2805-EXIT.   
      *                                                                         
           MOVE WS-Y               TO WS-RPT1-EXIST.                    
           ADD WS-1                TO WS-RPT1-CNTR.                     
           PERFORM 2810-PRODUCE-RPT1             THRU 2810-EXIT.        
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2805-GET-COMMON-INFO.                                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2805-GET-COMMON-INFO.                                            
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS              THRU 4000-EXIT.  
      *                                                                 14929700
           MOVE WS-CUSTOMER-NAME      TO WS-NAME-CUST.                  
      *                                                                         
           MOVE WS-PR-STREET          TO WS-SERVICE-ADDR1.              
           MOVE WS-PR-ADDR-CITY-STATE-ZIP                               
                                      TO WS-SERVICE-ADDR3.              
      *                                                                         
           MOVE AT-ACCOUNT-NO         TO CZ-ACCOUNT-NO.                 
           PERFORM 7170-SELECT-CREDIT-PROFILE          THRU 7170-EXIT.  
      *                                                                         
           MOVE CZ-ARREARS-HIST       TO WS-ARREARS-HIST.               
           MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST.            
      *                                                                         
           PERFORM 2807-GET-SVC-STRT-END-DATE         THRU 2807-EXIT.   
      *                                                                         
       2805-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14925300
      *                                                                *14925310
      *  2807-GET-SVC-STRT-END-DATE                                    *14925320
      *                                                                *14925330
      *  MODULE OPENS A CURSOR TO GET THE MOST RECENT SERVICE START    *14925400
      *  DATE AND END DATE. ONCE SELECTED THE VARIABLES ARE MOVED      *14925500
      *  INTO GENERAL ACCT INFORMATION.                                *14925600
      *                                                                *14925610
      ******************************************************************14925700
      *                                                                         
       2807-GET-SVC-STRT-END-DATE.                                      
      *                                                                 14925900
           PERFORM 7200-OPEN-CUST-PREM                THRU 7200-EXIT.   
           PERFORM 7210-FETCH-CUST-PREM               THRU 7210-EXIT.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CH-DATE-UTIL-SVC-STRT   TO WS-DATE-UTIL-SVC-STRT     
           END-IF.                                                      
      *                                                                         
           PERFORM 7220-CLOSE-CUST-PREM               THRU 7220-EXIT.   
      *                                                                 14926700
           PERFORM 2500-PROCESS-MONTHS                THRU 2500-EXIT.   
      *                                                                         
       2807-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  00271000
      **                                                            **  00271500
      **    2500-PROCESS-MONTHS                                     **  00272000
      **                                                            **  00273000
      **                                                            **  00273000
      ****************************************************************  00273500
      *                                                                         
       2500-PROCESS-MONTHS.                                             
      *                                                                 00665500
           EXEC SQL                                                     
T34097         SELECT
              CIS.DECIMAL2MONTH(CIS.DIFFDATE( CAST(SYSDATETIMEOFFSET() 
           AS DATE), IIF(TRY_CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:WS-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT) ) )) +       
T34097                                 ((CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
           CAST(SYSDATETIMEOFFSET() AS DATE), IIF(TRY_CONVERT(DATE, 
                                                 :WS-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:WS-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT) ) )))* 12)
            INTO
              :WS-NO-MONTH-STRT    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NO-MONTH-STRT = INTEGER (MONTH(CURRENT DATE -            
MFA-TR*                                :WS-DATE-UTIL-SVC-STRT)) +               
MFA-TR*                                ((YEAR(CURRENT DATE -                    
MFA-TR*                                :WS-DATE-UTIL-SVC-STRT))* 12)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00665500
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '*       PCSRP170 PROCESSING ERROR       *'        
             DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
             DISPLAY '*         PROCESSING TERMINATED         *'        
             DISPLAY '*****************************************'        
T34097       MOVE 'SET'                TO ABEND-FUNCTION                
             MOVE '2500'               TO ACTIVE-PARAGRAPH              
             MOVE WS-DATE-UTIL-SVC-STRT TO HOSTVAR-ELEMENT-2            
             MOVE 'WS-DATE-UTIL-SVC-STRT' TO TABLE-ELEMENT-2            
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14927000
      ****************************************************************          
      **                                                            **          
      **    2810-PRODUCE-RPT1                                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2810-PRODUCE-RPT1.                                               
      *                                                                         
           IF WS-RPT1-PREV-RESP-AREA  NOT EQUAL WQ-RESP-AREA-ID         
             PERFORM 2210-TOTAL-DISTRICT             THRU 2210-EXIT     
             MOVE WS-62                TO WS-RPT1-LINE-NO               
             MOVE WQ-RESP-AREA-ID      TO WS-RPT1-PREV-RESP-AREA        
             MOVE WS-Y                 TO WS-RETRIEVE-DISTRICT          
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-PREV-LOC-OFFICE NOT EQUAL AT-LOCAL-OFFICE         
             MOVE AT-LOCAL-OFFICE      TO WS-RPT1-PREV-LOC-OFFICE       
             MOVE WS-Y                 TO WS-RETRIEVE-LOC-OFFICE        
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-46                        
             MOVE WQ-RESP-AREA-ID      TO C1-RESP-AREA-ID               
             PERFORM 8110-PRINT-HEADERS              THRU 8110-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 2050-BUILD-DETAIL-RPT1            THRU 2050-EXIT.    
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   3900-CENTERING-ROUTINE                                   **          
      ****************************************************************          
      *                                                                         
       COPY CPD00150.                                                           
      *                                                                         
      ****************************************************************          
      **   4000-MAIL-NAME-ADDRESS                                   **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     14994500
                INCLUDE CPD00074                                        14994600
           END-EXEC.                                                    14994700
      *                                                                         
      ****************************************************************          
      **   6010-REDUCE-EMBEDDED-SPACES                              **          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                   14999200
      *                                                                 14999300
      ****************************************************************          
      **   6200-GET-PARAMETER-DATE                                  **          
      **   COPY BOOK TO GET REPORT DATE                             **          
      ****************************************************************          
      *                                                                 14999300
           EXEC SQL                                                     14999200
                INCLUDE CPD00114                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** 6240-GET-FCA00-COMMON-DATE                                 **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     14999800
                INCLUDE CPD00040                                        14999900
           END-EXEC.                                                    15000000
      *                                                                         
      ****************************************************************          
      **   6251-GET-FJC01-DATE                                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     14999400
                INCLUDE CPD00037                                        14999500
           END-EXEC.                                                    14999600
      *                                                                 14999700
      ****************************************************************          
      **  OPEN WQ CSR                                               **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-WQ-CSR.                                                
      *                                                                         
           MOVE '7990'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             OPEN WQ_CSR                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*******************************************'      
             DISPLAY '*       PCSRP170 PROCESSING ERROR         *'      
             DISPLAY '*      ERROR OPENING WRITTEM_OFF_ACCT_CSR *'      
             DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
             DISPLAY '*         PROCESSING TERMINATED           *'      
             DISPLAY '*******************************************'      
             MOVE 'OPEN'               TO ABEND-FUNCTION                
             MOVE 'CSS_FINAL_WO'       TO TABLE-1                       
             MOVE 'CSS_ACCOUNT '       TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  FETCH WQ CSR                                              **          
      ****************************************************************          
      *                                                                         
       7001-FETCH-WQ-CSR.                                               
      *                                                                         
           MOVE '7001'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             FETCH  WQ_CSR                                              
              INTO                                                      
                    :AT-ACCOUNT-NO,                                     
T27677              :AT-PREMISE-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-ADDRESS-FORMAT,                                 
                    :AT-ADDRESS-ID,                                     
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,         
                    :AT-BILL-CYCLE,                                     
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :WQ-RESP-AREA-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T36306        IF AT-ACCOUNT-NO = WS-SAVE-ACCOUNT-NO                     
T36306           MOVE 'Y' TO WS-SAME-SW                                 
T36306        ELSE                                                      
T36306           MOVE 'N' TO WS-SAME-SW                                 
T36306        END-IF                                                    
T36306     ELSE                                                         
T36306        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T36306           MOVE 'N' TO WS-MORE-DATA-SW                            
T36306           MOVE 'N' TO WS-SAME-SW                                 
              ELSE                                                      
                DISPLAY '*****************************************'     
                DISPLAY '*       PCSRP170 PROCESSING ERROR       *'     
                DISPLAY '*      ERROR FETCHING ACCT_TYPE_CSR     *'     
                DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE          
                DISPLAY '*         PROCESSING TERMINATED         *'     
                DISPLAY '*****************************************'     
                MOVE 'FETCH'              TO ABEND-FUNCTION             
                MOVE 'CSS_FINAL_WO    '   TO TABLE-1                    
                MOVE 'CSS_ACCOUNT     '   TO TABLE-2                    
                MOVE WS-LAST-RUN-DATE     TO HOSTVAR-ELEMENT-1          
                MOVE 'WS-LAST-RUN-DATE'   TO TABLE-ELEMENT-1            
                MOVE WS-CURR-DATE         TO HOSTVAR-ELEMENT-2          
                MOVE 'WS-CURR-DATE'       TO TABLE-ELEMENT-2            
                PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  CLOSE WQ CSR                                              **          
      ****************************************************************          
      *                                                                         
       7002-CLOSE-WQ-CSR.                                               
      *                                                                         
           MOVE '7002'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             CLOSE  WQ_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '*       PCSRP170 PROCESSING ERROR       *'        
             DISPLAY '*      ERROR CLOSING ACCT_TYPE_CSR      *'        
             DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
             DISPLAY '*         PROCESSING TERMINATED         *'        
             DISPLAY '*****************************************'        
             MOVE 'CLOSE'              TO ABEND-FUNCTION                
             MOVE 'CSS_FINAL_WO    '   TO TABLE-1                       
             MOVE 'CSS_ACCOUNT     '   TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  15073800
      *  SELECT DBA NAME                                             *  15074000
      ****************************************************************          
      *                                                                         
       7160-SELECT-DBA-NAME.                                            
      *                                                                 15074300
           EXEC SQL                                                     
               SELECT   NM.FULL_NAME                                    
               INTO     :WS-DBA-NAME                                    
               FROM CSS_NAME           NM WITH(READUNCOMMITTED),                
                    CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)                 
               WHERE AB.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND NM.NAME_ID    = AB.NAME_ID                         
                 AND NM.NAME_TYPE = 'DB'                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   NM.FULL_NAME                                            
MFA-TR*        INTO     :WS-DBA-NAME                                            
MFA-TR*        FROM CSS_NAME           NM,                                      
MFA-TR*             CSS_ACCT_BILL_NMES AB                                       
MFA-TR*        WHERE AB.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND NM.NAME_ID    = AB.NAME_ID                                 
MFA-TR*          AND NM.NAME_TYPE = 'DB'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '* SELECT ERROR IN 7160-SELECT-DBA-NAME       *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_NAME          ' TO TABLE-1                     
               MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE 'AT-ACCOUNT-NO'      TO TABLE-ELEMENT-1             
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15073800
      *                                                                 15073900
      *  7170-SELECT-CREDIT-PROFILE                                     15074000
      *                                                                 15074100
      ******************************************************************        
      *                                                                         
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                 15074300
           EXEC SQL                                                     
              SELECT                                                    
                  DISC_EXCEPTN_HIST,                                    
                  DISCONNECT_HIST,                                      
                  ARREARS_HIST,                                         
                  NON_UTL_ARRER_HIST,                                   
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
              INTO                                                      
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-ARREARS-HIST,                                     
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-LAST-UPDATE-TS                                    
              FROM                                                      
                 CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                       
              WHERE                                                     
                 ACCOUNT_NO = :CZ-ACCOUNT-NO                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15074400
MFA-TR*       SELECT                                                    15074500
MFA-TR*           DISC_EXCEPTN_HIST,                                    15074700
MFA-TR*           DISCONNECT_HIST,                                      15074800
MFA-TR*           ARREARS_HIST,                                         15074900
MFA-TR*           NON_UTL_ARRER_HIST,                                           
MFA-TR*           LAST_UPDATE_TS                                        15075000
MFA-TR*       INTO                                                      15075200
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                15075400
MFA-TR*           :CZ-DISCONNECT-HIST,                                  15075500
MFA-TR*           :CZ-ARREARS-HIST,                                     15075600
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                                       
MFA-TR*           :CZ-LAST-UPDATE-TS                                    15075700
MFA-TR*       FROM                                                      15075900
MFA-TR*          CSS_CREDIT_PROFILE                                             
MFA-TR*       WHERE                                                     15076000
MFA-TR*          ACCOUNT_NO = :CZ-ACCOUNT-NO                                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15076100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '* SELECT ERROR IN 7170-SELECT-CREDIT-PROFILE *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                     
               MOVE CZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE 'CZ-ACCOUNT-NO'      TO TABLE-ELEMENT-1             
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 15141300
      *                                                                 15141400
      * 7200-OPEN-CUST-PREM                                                     
      *                                                                         
      ***************************************************************** 15141500
      *                                                                         
       7200-OPEN-CUST-PREM.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CUST_PREM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '* OPEN ERROR IN 7200-OPEN-CUST-PREM          *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
T17394         MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15143700
      *****************************************************************         
      *                                                                         
      *  7210-FETCH-CUST-PREM                                                   
      *                                                                         
      *****************************************************************         
      *                                                                         
       7210-FETCH-CUST-PREM.                                            
                                                                        
           EXEC SQL                                                     
               FETCH CUST_PREM INTO                                     
                 :CH-DATE-UTIL-SVC-STRT,                                
                 :CH-DATE-UTIL-SVC-END :WS-NULL-DATE-UTL-END          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-DATE-UTL-END < ZERO                            
                 MOVE LOW-VALUES TO CH-DATE-UTIL-SVC-END                
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
               DISPLAY '**********************************************' 
               DISPLAY '* OPEN ERROR IN 7210-FETCH-CUST-PREM         *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
T17394         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
T17394         MOVE 'AT-ACCOUNT-NO'      TO TABLE-ELEMENT-1             
T17394         MOVE AT-PREMISE-NO        TO HOSTVAR-ELEMENT-2           
T17394         MOVE 'AT-PREMISE-NO'      TO TABLE-ELEMENT-2             
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      * 7220-CLOSE-CUST-PREM                                                    
      *                                                                         
      *****************************************************************         
      *                                                                         
       7220-CLOSE-CUST-PREM.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CUST_PREM                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '* OPEN ERROR IN 7220-CLOSE-CUST-PREM         *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
T17394         MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15148602
      ***************************************************************** 15070800
      *                                                                         
      *  7310-SELECT-SUM-DEP-AMT                                        15070900
      *                                                                 15071000
      *****************************************************************         
      *                                                                         
       7310-SELECT-SUM-DEP-AMT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :WS-AMT-DEPOSIT :WS-DEPOSIT-AMT-NULL                
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND DEPOSIT_STATUS_CD IN ('P','A')                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15071200
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                   15071300
MFA-TR*         INTO :WS-AMT-DEPOSIT:WS-DEPOSIT-AMT-NULL                15071600
MFA-TR*         FROM CSS_DEP_ON_HAND                                    15071900
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 15072000
MFA-TR*          AND DEPOSIT_STATUS_CD IN ('P','A')                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15072100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF WS-DEPOSIT-AMT-NULL < 0                               
                   MOVE ZEROS      TO WS-AMT-DEPOSIT                    
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '* SELECT ERROR  7310-SELECT-SUM-DEP-AMT      *' 
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED              *' 
               DISPLAY '**********************************************' 
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                     
               MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE 'AT-ACCOUNT-NO'      TO TABLE-ELEMENT-1             
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15073800
      ***************************************************************** 15070800
      *                                                                         
      *  7400-SELECT-SUM-BOND-AMT                                       15070900
      *                                                                 15071000
      *****************************************************************         
      *                                                                         
 35116 7400-SELECT-SUM-BOND-AMT.                                        
      *                                                                         
 35116     EXEC SQL                                                     
 35116        SELECT SUM(BOND_TOTAL_AMT)                                
 35116          INTO :WS-BOND-TOTAL-AMT :WS-BOND-TOTAL-AMT-NULL          
 35116          FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
 35116         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
 35116           AND CODE_STATUS = 'A'                                  
 35116           AND CODE_BOND_TYPE IN ('A','B')                        
 35116                                                           
 35116     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15071200
MFA-TR*       SELECT SUM(BOND_TOTAL_AMT)                                15071300
MFA-TR*         INTO :WS-BOND-TOTAL-AMT:WS-BOND-TOTAL-AMT-NULL          15071600
MFA-TR*         FROM CSS_SURETY_BOND                                    15071900
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 15072000
MFA-TR*          AND CODE_STATUS = 'A'                                          
MFA-TR*          AND CODE_BOND_TYPE IN ('A','B')                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15072100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

 35116     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
 35116                                    RS-RETURN-CODE,               
 35116                                    WS-DISP-RETURN-CODE.          
 35116                                                                  
 35116     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
 35116         IF WS-BOND-TOTAL-AMT-NULL < 0                            
 35116             MOVE ZEROS      TO WS-BOND-TOTAL-AMT                 
 35116         ELSE                                                     
 35116             ADD WS-BOND-TOTAL-AMT TO WS-AMT-DEPOSIT              
 35116         END-IF                                                   
 35116     ELSE                                                         
 35116         DISPLAY '**********************************************' 
 35116         DISPLAY '* SELECT ERROR  7400-SELECT-SUM-BOND-AMT     *' 
 35116         DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
 35116         DISPLAY '*         PROCESSING TERMINATED              *' 
 35116         DISPLAY '**********************************************' 
 35116         MOVE 'SELECT'             TO ABEND-FUNCTION              
 35116         MOVE 'CSS_SURETY_BOND'    TO TABLE-1                     
 35116         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
 35116         MOVE 'AT-ACCOUNT-NO'      TO TABLE-ELEMENT-1             
 35116         PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
 35116     END-IF.                                                      
      *                                                                 14999700
 35116 7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14999700
      ****************************************************************          
      ** 7600-START-FCSJC01                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                 14999700
      ****************************************************************          
      ** 7620-START-FCSCA00                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE '7700'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           MOVE AT-LOCAL-OFFICE        TO B1-LOCAL-OFFICE.              
      *                                                                         
           EXEC SQL                                                     
             SELECT    LOCAL_OFFICE_DESC                                
               INTO    :B1-LOCAL-OFFICE-DESC                            
               FROM    CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                   
              WHERE    COMPANY_NO   = '01'                              
                AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT    LOCAL_OFFICE_DESC                                        
MFA-TR*        INTO    :B1-LOCAL-OFFICE-DESC                                    
MFA-TR*        FROM    CSS_LOCAL_OFFICE                                         
MFA-TR*       WHERE    COMPANY_NO   = '01'                                      
MFA-TR*         AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE B1-LOCAL-OFFICE-DESC TO P1-LOC-OFF-NM                 
             MOVE B1-LOCAL-OFFICE      TO P1-LOC-OFF-CD                 
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE SPACES             TO P1-LOC-OFF-NM                 
               MOVE B1-LOCAL-OFFICE    TO P1-LOC-OFF-CD                 
             ELSE                                                       
               DISPLAY '*****************************************'      
               DISPLAY '* SELECT ERROR IN 7700-GET-LOCAL-OFFICE *'      
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED         *'      
               DISPLAY '*****************************************'      
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_LOCAL_OFFICE' TO TABLE-1                       
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE 'AT-ACCOUNT-NO'    TO TABLE-ELEMENT-1               
               MOVE B1-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-3             
               MOVE 'B1-LOCAL-OFFICE'  TO TABLE-ELEMENT-3               
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-DISTRICT                                        **          
      **      READS THE RESP AREA TABLE WITH THE GIVEN CODE         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-DISTRICT.                                               
      *                                                                         
           MOVE '7800'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             SELECT    RESP_AREA_DESC                                   
               INTO    :C1-RESP-AREA-DESC                               
               FROM    CSS_RESP_AREA WITH(READUNCOMMITTED)                      
              WHERE    COMPANY_NO   = '01'                              
                AND    RESP_AREA_ID = :C1-RESP-AREA-ID                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT    RESP_AREA_DESC                                           
MFA-TR*        INTO    :C1-RESP-AREA-DESC                                       
MFA-TR*        FROM    CSS_RESP_AREA                                            
MFA-TR*       WHERE    COMPANY_NO   = '01'                                      
MFA-TR*         AND    RESP_AREA_ID = :C1-RESP-AREA-ID                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE C1-RESP-AREA-DESC    TO P-RPT-DIST-NM,                
                                          P101-DIST-NM,                 
                                          P101A-DIST-NM,                
                                          P102-DIST-NM,                 
                                          P103-DIST-NM                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE '*** NOT FOUND ***' TO P-RPT-DIST-NM,               
                                           P101A-DIST-NM,               
                                           P102-DIST-NM,                
                                           P103-DIST-NM                 
             ELSE                                                       
               DISPLAY '*****************************************'      
               DISPLAY '* SELECT ERROR IN 7800-GET-DISTRICT     *'      
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED         *'      
               DISPLAY '*****************************************'      
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_RESP_AREA'    TO TABLE-1                       
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE 'AT-ACCOUNT-NO'    TO TABLE-ELEMENT-1               
               MOVE C1-RESP-AREA-ID    TO HOSTVAR-ELEMENT-3             
               MOVE 'C1-RESP-AREA-ID'  TO TABLE-ELEMENT-3               
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8110-PRINT-HEADERS                                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8110-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1                     TO WS-RPT1-PAGE-NO.                
           MOVE WS-RPT1-PAGE-NO      TO P-RPT-PAGE-NO.                  
           MOVE WS-PGRMNAME-1        TO P-RPT-TITLE-PGNM.               
           MOVE WS-DEFAULT-RPT1-TITLE-194-1                             
                                     TO P-RPT-HEAD1.                    
      *                                                                         
           MOVE WS-RPT-TITLE           TO P-OUTPUT-LINE.                
           PERFORM 8505-PRINT-PCSRP170-TOP           THRU 8505-EXIT.    
      *                                                                         
           MOVE WS-RPT-HEADER-1        TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEAD2  TO P-RPT-HEAD2.                  
      *                                                                         
           MOVE WS-RPT-HEADER-2        TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
           IF MUST-GET-DISTRICT                                         
             PERFORM 7800-GET-DISTRICT               THRU 7800-EXIT     
             MOVE WS-N                 TO WS-RETRIEVE-DISTRICT          
           END-IF.                                                      
      *                                                                         
           IF THIS-IS-COMP-BREAK                                        
              MOVE SPACES              TO WS-RPT-HEADER-DIST            
           END-IF.                                                      
      *                                                                         
           MOVE WS-RPT-HEADER-DIST     TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
           MOVE WS-RPT1-HDR-01       TO P-OUTPUT-LINE.                  
           MOVE WS-2                 TO WS-SKIP-LINES-NUM.              
           PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT.      
      *                                                                         
           MOVE WS-RPT1-HDR-02       TO P-OUTPUT-LINE.                  
           MOVE WS-1                 TO WS-SKIP-LINES-NUM.              
           PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT.      
      *                                                                         
           MOVE WS-RPT1-HDR-03       TO P-OUTPUT-LINE.                  
           MOVE WS-1                 TO WS-SKIP-LINES-NUM.              
           PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT.      
      *                                                                         
           MOVE WS-RPT1-HDR-04       TO P-OUTPUT-LINE.                  
           MOVE WS-1                 TO WS-SKIP-LINES-NUM.              
           PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT.      
      *                                                                         
           MOVE WS-LINE                TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8500-PRINT-PCSRP170               THRU 8500-EXIT.    
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14999700
      ****************************************************************          
      ** UPDATE LAST RUN DATE                                       **          
      ****************************************************************          
      *                                                                         
       8200-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
               SET    PARM_DATA        = :G6-PARM-DATA                  
               WHERE  PROGRAM_NAME     = :G6-PROGRAM-NAME               
               AND    CMND_CODE        = :G6-CMND-CODE                  
               AND    COMPANY_NO       = '01'                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T36306     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T36306                     RS-RETURN-CODE                               
T36306                     WS-DISP-RETURN-CODE.                         
      *                                                                         
T36306     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T36306         NEXT SENTENCE                                            
T36306     ELSE                                                         
T36306        DISPLAY '*****************************************'       
T36306        DISPLAY '*        PROCESSING ERROR               *'       
T36306        DISPLAY '* PARAGRAPH 8200-UPDATE-LAST-RUN-DATE   *'       
T36306        DISPLAY '*   SQLCODE = ' WS-DISP-RETURN-CODE              
T36306        DISPLAY '*   G6-PARM-DATA = ' G6-PARM-DATA                
T36306        DISPLAY '*   G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
T36306        DISPLAY '*   G6-CMND-CODE = ' G6-CMND-CODE                
T36306        DISPLAY '*         PROCESSING TERMINATED         *'       
T36306        DISPLAY '*****************************************'       
T36306        PERFORM 9900-ABEND THRU 9900-EXIT                         
T36306     END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE LINES FOR DETAIL OR TOTALS                **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-PCSRP170.                                             
      *                                                                         
           WRITE PRT-1-RECORD FROM P-OUTPUT-LINE                        
             AFTER ADVANCING WS-SKIP-LINES-NUM.                         
           ADD WS-SKIP-LINES-NUM     TO WS-RPT1-LINE-NO.                
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8505-PRINT-PCSRP170-TOP                                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8505-PRINT-PCSRP170-TOP.                                         
      *                                                                         
           WRITE PRT-1-RECORD FROM P-OUTPUT-LINE                        
             AFTER ADVANCING TOP-OF-PAGE.                               
           MOVE WS-1                 TO WS-RPT1-LINE-NO.                
                                                                        
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8600-PRINT-RPT1-COMP-END                                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8600-PRINT-RPT1-COMP-END.                                        
      *                                                                         
           IF WS-RPT1-CNTR GREATER THAN ZERO                            
             IF WS-RPT1-LINE-NO GREATER THAN WS-50                      
               PERFORM 8110-PRINT-HEADERS            THRU 8110-EXIT     
             END-IF                                                     
             PERFORM 2210-TOTAL-DISTRICT             THRU 2210-EXIT     
             MOVE WS-Y                 TO WS-COMP-BREAK-SW              
             PERFORM 8110-PRINT-HEADERS              THRU 8110-EXIT     
             MOVE WS-N                 TO WS-COMP-BREAK-SW              
             PERFORM 2300-TOTAL-COMPANY              THRU 2300-EXIT     
             MOVE ZERO                 TO WS-RPT1-CNTR                  
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPRT11-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **   9500-CLEANUP                                              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9500-CLEANUP.                                                    
      *                                                                         
           IF REPORT-1-DOES-NOT-EXIST                                   
             PERFORM 8110-PRINT-HEADERS              THRU 8110-EXIT     
      *                                                                         
             MOVE WS-NO-DATA-LINE      TO P-OUTPUT-LINE                 
             MOVE WS-3                 TO WS-SKIP-LINES-NUM             
             PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT     
           ELSE                                                         
             PERFORM 8600-PRINT-RPT1-COMP-END        THRU 8600-EXIT     
      *                                                                         
             MOVE WS-END-DATA-LINE     TO P-OUTPUT-LINE                 
             MOVE WS-3                 TO WS-SKIP-LINES-NUM             
             PERFORM 8500-PRINT-PCSRP170             THRU 8500-EXIT     
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9700-PROCESS-ABEND                                        **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
      ****************************************************************          
