       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP169.                                        
       DATE-WRITTEN.   05/17/2006.                                      
       DATE-COMPILED.                                                   
       AUTHOR.         VAISHNAVI.                                       
      ***************************************************************** 00006000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00007000
      **                                                             ** 00008000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00009000
      **                                                             ** 00009100
      ***************************************************************** 00009200
      **               P R O G R A M  S U M M A R Y                  ** 00009300
      **                                                             ** 00009400
      ** PCSRP169 GENERATES A REPORT FOR AUDITS.                     ** 00009500
      ** DATA IS AVAILABLE IN CSS_AUDIT_HISTORY. THE POSSIBLE AUDIT  ** 00009600
      ** DESCRIPTIONS ARE AVAILABLE IN CSS_AUDIT_COND_DSC AND        ** 00009700
      ** CSS_AUDIT_COND TABLES.                                      ** 00009800
      ** THE REPORT WILL CONSIST OF ALL THE AUDIT DESCRIPTIONS THAT  ** 00009900
      ** DID NOT HAVE ANY HISTORY ASSOCIATED TO IT.                  ** 00010000
      **                                                             ** 00010100
      ***************************************************************** 00010200
      **                                                             ** 00010300
      **             PROGRAM  MODIFICATION  LOG                      ** 00010400
      **                                                             ** 00010500
      **   DATE     INITIALS  REASON                                 ** 00010600
      **   ----     --------  ------                                 ** 00010700
T33675**   05/06    SV82012   NEW PROGRAM.                           ** 00010800
T35051**   12/06    sv82012   Report To Modify The Audit Of Audit    ** 00010900
T35051**                      Process.                               ** 00011000
T35434**   10/04    MK92804   REPLACED CSS_MODEL_SQL WITH SET COMMAND** 00011100
T35434**                      AND ADDED WITH UR FOR -911 ABENDS.     ** 00011200
A04494**   01/14    DMS       CHANGE TO PRINT UP TO 300 CHARACTERS   ** 00011316
      *END************************************************************* 00011400
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00011500
      **                                                             ** 00012000
      **  0000         MODULE CONTROL                                ** 00013000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00014000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00015000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00018000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00019000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00019100
      **  9000 - 9799  TERMINATION MODULES                           ** 00019200
      **  9900 - 9999  ABEND / ABORT MODULES                         ** 00019300
      **                                                             ** 00019400
      ***************************************************************** 00019500
      *                                                                 00019600
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00040000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT PCSRP169-FILE   ASSIGN TO UT-S-PCSRP169               
               FILE STATUS IS WS-R169-STATUS.                           
      *                                                                 00090000
T35051     SELECT PCSR169A-FILE   ASSIGN TO UT-S-PCSR169A               
T35051         FILE STATUS IS WS-RA169-STATUS.                          
      *                                                                 00093000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00120000
       FD  PCSRP169-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  PCSRP169-REC                PIC X(80).                       
      *                                                                 00200000
T35051 FD  PCSR169A-FILE                                                
T35051     BLOCK CONTAINS  0 RECORDS                                    
           RECORD CONTAINS 80 CHARACTERS                                
T35051     RECORDING MODE  IS F                                         
T35051     LABEL RECORDS   ARE STANDARD.                                
T35051                                                                  
       01  PCSR169A-REC                PIC X(80).                       
T35051*                                                                 00208000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP169'.
MSQ017     COPY MFASQLM.
      *                                                                 00220000
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP169 STARTS HERE'.                  
      *                                                                 00250000
       01  WS-MISC.                                                     
      *                                                                 00270000
           05  WS-LEN                  PIC 9(4)     COMP.               
           05  WS-AUDIT-EXISTS         PIC X        VALUE 'N'.          
               88  AUDIT-EXISTS                     VALUE 'Y'.          
               88  AUDIT-NOT-EXISTS                 VALUE 'N'.          
           05  WS-EOF1-SW              PIC X(01)    VALUE SPACES.       
               88  END-OF-FILE1                     VALUE 'Y'.          
           05  WS-EOF2-SW              PIC X(01)    VALUE SPACES.       
               88  END-OF-FILE2                     VALUE 'Y'.          
           05  WS-EXC-RPT-SW           PIC X(01)    VALUE SPACES.       
               88  HAVE-EXC-RPT                     VALUE 'Y'.          
           05  WS-HOLD-ST-DATE.                                         
               10  FILLER              PIC X(02).                       
               10  WS-HOLD-ST-YR       PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-HOLD-ST-MO       PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-HOLD-ST-DY       PIC X(02).                       
           05  WS-REV-MONTH            PIC 9(6).                        
           05  FILLER REDEFINES WS-REV-MONTH.                           
               10 WS-REV-CCYY          PIC 9(4).                        
               10 WS-REV-MM            PIC 9(2).                        
           05  WS-COMPANY-TYPE-CD      PIC X(01) VALUE SPACE.           
           05  WS-R169-STATUS          PIC  X(02).                      
               88 RP169-SUCCESSFUL               VALUE '00'.            
           05  WS-RA169-STATUS         PIC  X(02).                      
               88 RA169-SUCCESSFUL               VALUE '00'.            
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  FILLER REDEFINES WS-CURRENT-DATE.                        
               10  WS-CURR-CC          PIC X(02).                       
               10  WS-CURR-YY          PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CURR-MM          PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CURR-DD          PIC X(02).                       
           05  WS-TWO-YEARS-BACK-DATE  PIC X(10).                       
           05  FILLER REDEFINES WS-TWO-YEARS-BACK-DATE.                 
               10  WS-2-YRS-BACK-CC    PIC X(02).                       
               10  WS-2-YRS-BACK-YY    PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-2-YRS-BACK-MM    PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-2-YRS-BACK-DD    PIC X(02).                       
A04494     05  WS-AUDIT-COND-DESC      PIC X(300).                      
      *                                                                 00680000
       COPY CWS09900.                                                   00690000
       COPY CWS00303.                                                   00700000
      *                                                                 00710000
      ****************************************************************  00720000
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE ZERO.         
       01  WS-RPT2-LINE-NO             PIC 9(02)    VALUE ZERO.         
      ****************************************************************  00740000
      *                                                                 00750000
       01  WS-SUBJECT.                                                  
           05  FILLER                  PIC X(13)    VALUE               
                                       'PCSRP169 FOR '.                 
           05  WS-SUB-DATE             PIC X(10).                       
      *                                                                 00800000
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                 00870000
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-52                   PIC 9(02)    VALUE 52.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
      *                                                                 00930000
      ***************** PCSRP169 REPORT HEADERS **********************  00940000
      *                                                                 00950000
       01  WS-HEADING-LINES.                                            
      *                                                                 00970000
      ****************************************************************  00980000
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **  00990000
      ****************************************************************  01000000
      *                                                                 01010000
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(11)    VALUE SPACES.       
               10  FILLER              PIC X(30)    VALUE               
                                     'AUDIT FILE VERIFICATION REPORT'.  
               10  FILLER              PIC X(25)    VALUE SPACES.       
      *                                                                 01090000
      ****************************************************************  01100000
      **           COMMON WORKING STORAGE FOR REPORT HEADER1A       **  01110000
      ****************************************************************  01120000
      *                                                                 01130000
           05  WS-RPT1-HEADER-1A.                                       
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  P-RPT1A-COMP        PIC X(30).                       
               10  FILLER              PIC X(25)    VALUE SPACES.       
      *                                                                 01180000
      ****************************************************************  01190000
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **  01200000
      ****************************************************************  01210000
      *                                                                 01220000
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(08) VALUE 'PCSRP169'.      
A04494         10  FILLER              PIC X(03) VALUE SPACES.          
               10  FILLER              PIC X(47) VALUE                  
                 'AUDIT CONDITIONS NOT MET FOR THE REVENUE MONTH '.     
               10  WS-RPT-REV-MTH      PIC X(06).                       
A04494         10  FILLER              PIC X(16) VALUE SPACES.          
      *                                                                 01300000
T35051     05  WS-RPT1-HEADER-2A.                                       
T35051         10  FILLER              PIC X(08) VALUE 'PCSRP169'.      
A04494         10  FILLER              PIC X(03) VALUE SPACES.          
T35051         10  FILLER              PIC X(48) VALUE                  
T35051           'POSSIBLE AUDIT CONDITIONS FOR THE REVENUE MONTH '.    
T35051         10  WS-RPT2-REV-MTH     PIC X(06).                       
A04494         10  FILLER              PIC X(15) VALUE SPACES.          
T35051*                                                                 01308000
      ****************************************************************  01310000
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **  01320000
      ****************************************************************  01330000
      *                                                                 01340000
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X(15)    VALUE               
                                               'AUDIT CONDITION'.       
A04494         10  FILLER              PIC X(65)    VALUE SPACES.       
      *                                                                 01400000
      ****************************************************************  01410000
      **       COMMON WORKING STORAGE FOR LINE TOTALS               **  01420000
      ****************************************************************  01430000
      *                                                                 01440000
           05  WS-LINE-TOTAL.                                           
               10  FILLER              PIC X(46)    VALUE SPACES.       
               10  FILLER              PIC X(24)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE SPACES.       
      *                                                                 01490000
           05  WS-LINE-MESSAGE.                                         
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  LM-TITLE            PIC X(50)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE SPACES.       
      *                                                                 01540000
      ****************************************************************  01550000
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **  01560000
      ****************************************************************  01570000
      *                                                                 01580000
       01  WS-DETAIL-LINES.                                             
      *                                                                 01600000
           05  WS-DETAIL-LINE-1.                                        
A04494         10  D-AUDIT-CONDITION-1 PIC X(80).                       
A04494     05  WS-DETAIL-LINE-2.                                        
A04494         10  FILLER              PIC X(02)    VALUE SPACES.       
A04494         10  D-AUDIT-CONDITION-2 PIC X(78).                       
A04494     05  WS-DETAIL-LINE-3.                                        
A04494         10  FILLER              PIC X(02)    VALUE SPACES.       
A04494         10  D-AUDIT-CONDITION-3 PIC X(78).                       
A04494     05  WS-DETAIL-LINE-4.                                        
A04494         10  FILLER              PIC X(02)    VALUE SPACES.       
A04494         10  D-AUDIT-CONDITION-4 PIC X(78).                       
      *                                                                 01650000
      *                                                                 01660000
       01  WS-LINE-132                 PIC X(132)   VALUE ALL '-'.      
       01  WS-LINE-80                  PIC X(080)   VALUE ALL '-'.      
       01  WS-BLANK-LINE-132           PIC X(132)   VALUE SPACES.       
       01  WS-BLANK-LINE-80            PIC X(080)   VALUE SPACES.       
      *                                                                 01710000
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                 01770000
      *                                                                 01780000
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                 01830000
      * copy book for error handling                                    01840000
       COPY CWS00010.                                                   01850000
      *                                                                 01860000
      *    DCLGEN FOR CSS_AUDIT_COND                                    01870000
           EXEC SQL                                                     01880000
                INCLUDE TBAUDCON                                        01890000
           END-EXEC.                                                    01900000
      *    DCLGEN FOR CSS_AUDIT_DOND_DSC                                01910000
           EXEC SQL                                                     01920000
                INCLUDE TBAUDDES                                        01930000
           END-EXEC.                                                    01940000
      *    DCLGEN FOR CSS_AUDIT_HIST                                    01950000
           EXEC SQL                                                     01960000
                INCLUDE TBAUDHST                                        01970000
           END-EXEC.                                                    01980000
      *    SQL COMMUNICATION AREA.                                      01990000
           EXEC SQL                                                     02000000
               INCLUDE SQLCA                                            02010000
           END-EXEC.                                                    02020000
      *                                                                 02030000
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP169 ENDS HERE'.                    
      *                                                                 02060000
           EXEC SQL                                                     
               DECLARE AUDIT_SELECT CURSOR FOR                          
                   SELECT AH.AUDIT_COND_CD                              
                         ,AH.AUDIT_COND_DESC                            
                     FROM CSS_AUDIT_COND_DSC AH WITH(READUNCOMMITTED)           
                         ,CSS_AUDIT_COND AP WITH(READUNCOMMITTED)               
                    WHERE AH.AUDIT_COND_CD = AP.AUDIT_COND_CD           
                      AND AP.COMPANY_TYPE_CD = :AP-COMPANY-TYPE-CD      
                 ORDER BY AUDIT_COND_CD                                 
T35434                FOR READ ONLY                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02070000
MFA-TR*        DECLARE AUDIT_SELECT CURSOR FOR                          02080000
MFA-TR*            SELECT AH.AUDIT_COND_CD                              02090000
MFA-TR*                  ,AH.AUDIT_COND_DESC                            02100000
MFA-TR*              FROM CSS_AUDIT_COND_DSC AH                         02110000
MFA-TR*                  ,CSS_AUDIT_COND AP                             02120000
MFA-TR*             WHERE AH.AUDIT_COND_CD = AP.AUDIT_COND_CD           02130000
MFA-TR*               AND AP.COMPANY_TYPE_CD = :AP-COMPANY-TYPE-CD      02140000
MFA-TR*          ORDER BY AUDIT_COND_CD                                 02150000
MFA-TR*               FOR FETCH ONLY WITH UR                            02151000
MFA-TR*    END-EXEC.                                                    02160000
      *                                                                 02170000
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-PARM-COMPANY                   PIC X(03).             
      *                                                                 02220000
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                 02240000
      ****************************************************************  02250000
      **                                                            **  02260000
      **   0000-MAINLINE                                            **  02270000
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **  02280000
      **                                                            **  02290000
      ****************************************************************  02300000
       0000-MAINLINE.                                                   
      *                                                                 02320000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *  POPULATE THE VALUE FOR COMPANY_TYPE_CD                         02340000
           EVALUATE WS-PARM-COMPANY                                     
               WHEN 'CSR'                                               
                    MOVE 'S'              TO WS-COMPANY-TYPE-CD         
               WHEN 'PNC'                                               
                    MOVE 'P'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SEB'                                               
                    MOVE 'D'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SBR'                                               
                    MOVE 'R'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SVC'                                               
                    MOVE 'V'              TO WS-COMPANY-TYPE-CD         
           END-EVALUATE.                                                
      *                                                                 02470000
           PERFORM 1000-PROCESS-AUDITS           THRU 1000-EXIT.        
      *                                                                 02490000
           WRITE PCSRP169-REC FROM WS-BLANK-LINE-80.                    
      *                                                                 02510000
           PERFORM 2000-DELETE-PREV-RECS         THRU 2000-EXIT.        
      *                                                                 02530000
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                 02560000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02590000
      ****************************************************************  02600000
      **                                                            **  02610000
      **   0100-INITIALIZATION                                      **  02620000
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **  02630000
      **                                                            **  02640000
      ****************************************************************  02650000
       0100-INITIALIZATION.                                             
           MOVE WS-52                  TO WS-RPT1-LINE-NO.              
           MOVE WS-52                  TO WS-RPT2-LINE-NO.              
           PERFORM 7400-GET-CURRENT-DATE THRU 7400-EXIT.                
           MOVE WS-CURR-YY             TO WS-RD-YY.                     
           MOVE WS-CURR-MM             TO WS-RD-MM.                     
           MOVE WS-CURR-DD             TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-DATE.                  
           MOVE SPACES                 TO P-RPT1A-COMP.                 
           MOVE WS-CURR-CC             TO WS-REV-CCYY(1:2).             
           MOVE WS-CURR-YY             TO WS-REV-CCYY(3:2).             
           MOVE WS-CURR-MM             TO WS-REV-MM.                    
           IF WS-REV-MM = 1                                             
A04494        MOVE 12                  TO WS-REV-MM                     
              COMPUTE WS-REV-CCYY = WS-REV-CCYY - 1                     
           ELSE                                                         
              COMPUTE WS-REV-MM = WS-REV-MM - 1                         
           END-IF.                                                      
      *                                                                 02830000
           EVALUATE WS-PARM-COMPANY                                     
               WHEN 'CSR'                                               
                    MOVE 'SOUTH CAROLINA ELECTRIC & GAS '               
                                                      TO P-RPT1A-COMP   
               WHEN 'PNC'                                               
                    MOVE 'PSNC  ENERGY'               TO P-RPT1A-COMP   
               WHEN 'SEB'                                               
                    MOVE 'SCANA ENERGY - DEREGULATED' TO P-RPT1A-COMP   
               WHEN 'SBR'                                               
                    MOVE 'SCANA ENERGY - REGULATED'   TO P-RPT1A-COMP   
               WHEN 'SVC'                                               
                    MOVE 'SERVICE CARE'               TO P-RPT1A-COMP   
           END-EVALUATE.                                                
      *                                                                 02970000
           OPEN OUTPUT PCSRP169-FILE                                    
T35051                 PCSR169A-FILE.                                   
      *                                                                 02990000
           IF WS-RPT1-LINE-NO NOT < WS-52                               
              PERFORM 8200-PRINT-TITLE           THRU 8200-EXIT         
              PERFORM 8300-PRINT-HEADERS         THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                 03040000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03070000
       1000-PROCESS-AUDITS.                                             
      *                                                                 03090000
           MOVE WS-COMPANY-TYPE-CD           TO AP-COMPANY-TYPE-CD      
                                                AX-COMPANY-TYPE-CD.     
           PERFORM 7000-OPEN-AUDIT-SELECT      THRU 7000-EXIT.          
           PERFORM 7100-FETCH-AUDIT-SELECT     THRU 7100-EXIT.          
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 1100-PROCESS-AUDIT-HIST  THRU 1100-EXIT           
T35051        PERFORM 1200-ALL-POSSIBLE-AUDITS  THRU 1200-EXIT          
              PERFORM 7100-FETCH-AUDIT-SELECT  THRU 7100-EXIT           
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-AUDIT-SELECT     THRU 7200-EXIT.          
      *                                                                 03190000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03220000
       1100-PROCESS-AUDIT-HIST.                                         
      *                                                                 03240000
A04494     INITIALIZE WS-DETAIL-LINES.                                  
           MOVE AH-AUDIT-COND-CD             TO AX-AUDIT-COND-CD.       
           MOVE WS-REV-MONTH                 TO AX-REVENUE-MONTH.       
           MOVE WS-N                         TO WS-AUDIT-EXISTS.        
           PERFORM 7300-SELECT-AUDIT-HIST    THRU 7300-EXIT.            
           IF AUDIT-NOT-EXISTS                                          
A04494        MOVE WS-AUDIT-COND-DESC(1:80)   TO D-AUDIT-CONDITION-1    
A04494        MOVE WS-AUDIT-COND-DESC(81:78)  TO D-AUDIT-CONDITION-2    
A04494        MOVE WS-AUDIT-COND-DESC(159:78) TO D-AUDIT-CONDITION-3    
A04494        MOVE WS-AUDIT-COND-DESC(237:64) TO D-AUDIT-CONDITION-4    
              PERFORM 8000-WRITE-AUDIT-REPORT THRU 8000-EXIT            
           END-IF.                                                      
      *                                                                 03330000
       1100-EXIT.                                                       
           EXIT.                                                        
T35051************************************************************      03360000
T35051*  PROVIDE A LIST OF ALL POSSIBLE AUDIT CONDITIONS FOR THE *      03360100
T35051*  COMPANY WE ARE WORKING WITH. THIS WILL ENABLE THE USER  *      03360200
T35051*  TO VERIFY THE AUDIT REPORT THE SAME PROGRAM PROVIDES    *      03360315
T35051*  EVERY MONTH.                                            *      03360400
T35051************************************************************      03360500
T35051 1200-ALL-POSSIBLE-AUDITS.                                        
A04494      INITIALIZE WS-DETAIL-LINES.                                 
A04494      MOVE WS-AUDIT-COND-DESC(1:80)   TO D-AUDIT-CONDITION-1      
A04494      MOVE WS-AUDIT-COND-DESC(81:78)  TO D-AUDIT-CONDITION-2      
A04494      MOVE WS-AUDIT-COND-DESC(159:78) TO D-AUDIT-CONDITION-3      
A04494      MOVE WS-AUDIT-COND-DESC(237:64) TO D-AUDIT-CONDITION-4      
T35051      PERFORM 8400-WRITE-ALL-AUDITS    THRU 8400-EXIT.            
T35051*                                                                 03362000
T35051 1200-EXIT.                                                       
T35051     EXIT.                                                        
T35051*                                                                 03365000
       2000-DELETE-PREV-RECS.                                           
      *                                                                 03380000
           PERFORM 7500-GET-TWO-YEARS-BACK   THRU 7500-EXIT.            
           MOVE WS-2-YRS-BACK-CC             TO WS-REV-CCYY(1:2).       
           MOVE WS-2-YRS-BACK-YY             TO WS-REV-CCYY(3:2).       
           MOVE WS-2-YRS-BACK-MM             TO WS-REV-MM.              
           MOVE WS-REV-MONTH                 TO AX-REVENUE-MONTH.       
           PERFORM 8600-DELETE-PREV-RECS     THRU 8600-EXIT.            
      *                                                                 03450000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03480000
       7000-OPEN-AUDIT-SELECT.                                          
      *                                                                 03500000
           EXEC SQL                                                     
               OPEN AUDIT_SELECT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03540000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN PROGRAM PCSRP169 ***'               
              DISPLAY '*** 7000-OPEN-AUDIT-SELECT      ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND_DSC  ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND      ***'             
              DISPLAY '*** DB2 FUNCTION OPEN           ***'             
              DISPLAY '*** COMPANY_TYPE_CD ' AP-COMPANY-TYPE-CD         
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 03670000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03700000
       7100-FETCH-AUDIT-SELECT.                                         
      *                                                                 03720000
           EXEC SQL                                                     
               FETCH AUDIT_SELECT                                       
                INTO :AH-AUDIT-COND-CD                                  
                    ,:AH-AUDIT-COND-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03780000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN PROGRAM PCSRP169 ***'               
              DISPLAY '*** 7100-FETCH-AUDIT-SELECT     ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND_DSC  ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND      ***'             
              DISPLAY '*** DB2 FUNCTION - FETCH        ***'             
              DISPLAY '*** COMPANY_TYPE_CD    ' AP-COMPANY-TYPE-CD      
              DISPLAY '*** AH.AUDIT_COND_CD   ' AH-AUDIT-COND-CD        
              DISPLAY '*** AH.AUDIT_COND_DESC ' AH-AUDIT-COND-DESC      
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
A04494     MOVE SPACES TO WS-AUDIT-COND-DESC.                           
A04494     MOVE AH-AUDIT-COND-DESC-TEXT(1:AH-AUDIT-COND-DESC-LEN) TO    
A04494          WS-AUDIT-COND-DESC.                                     
      *                                                                 03930000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03960000
       7200-CLOSE-AUDIT-SELECT.                                         
      *                                                                 03980000
           EXEC SQL                                                     
               CLOSE AUDIT_SELECT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04020000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN PROGRAM PCSRP169 ***'               
              DISPLAY '*** 7200-CLOSE-AUDIT-SELECT     ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND_DSC  ***'             
              DISPLAY '*** TABLE - CSS_AUDIT_COND      ***'             
              DISPLAY '*** DB2 FUNCTION - CLOSE        ***'             
              DISPLAY '*** COMPANY_TYPE_CD    ' AP-COMPANY-TYPE-CD      
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 04150000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04180000
       7300-SELECT-AUDIT-HIST.                                          
      *                                                                 04200000
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-AUDIT-EXISTS                                  
                 FROM CSS_AUDIT_HISTORY WITH(READUNCOMMITTED)                   
                WHERE AUDIT_COND_CD      = :AX-AUDIT-COND-CD            
                  AND REVENUE_MONTH      = :AX-REVENUE-MONTH            
                  AND COMPANY_TYPE_CD    = :AX-COMPANY-TYPE-CD          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04210000
MFA-TR*        SELECT 'Y'                                               04220000
MFA-TR*          INTO :WS-AUDIT-EXISTS                                  04230000
MFA-TR*          FROM CSS_AUDIT_HISTORY                                 04240000
MFA-TR*         WHERE AUDIT_COND_CD      = :AX-AUDIT-COND-CD            04250000
MFA-TR*           AND REVENUE_MONTH      = :AX-REVENUE-MONTH            04260000
MFA-TR*           AND COMPANY_TYPE_CD    = :AX-COMPANY-TYPE-CD          04270000
MFA-TR*          WITH UR                                                04271000
MFA-TR*    END-EXEC.                                                    04280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04290000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-N                 TO WS-AUDIT-EXISTS        
               WHEN OTHER                                               
                    DISPLAY '*** ERROR IN PROGRAM PCSRP169  ***'        
                    DISPLAY '*** 7300-SELECT-AUDIT-HIST     ***'        
                    DISPLAY '*** TABLE - CSS_AUDIT_HISTORY  ***'        
                    DISPLAY '*** DB2 FUNCTION - SELECT      ***'        
                    DISPLAY '*** AUDIT_DESC_CD    'AX-AUDIT-COND-CD     
                    DISPLAY '*** REVENUE_MONTH    'WS-REV-MONTH         
                    DISPLAY '*** COMPANY_TYPE_CD  'AX-COMPANY-TYPE-CD   
                    PERFORM 9900-ABEND             THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                 04470000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04500000
       7400-GET-CURRENT-DATE.                                           
      *                                                                 04520000
           EXEC SQL                                                     
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     04530000
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                      04531000
MFA-TR*    END-EXEC.                                                    04570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSRP169 ABORT ************'         
               DISPLAY '* 7400-GET-CURRENT-DATE              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP169 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 04700000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04730000
       7500-GET-TWO-YEARS-BACK.                                         
      *                                                                 04750000
           EXEC SQL                                                     
T35434         SELECT
              DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-TWO-YEARS-BACK-DATE     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     04760000
MFA-TR*        SET :WS-TWO-YEARS-BACK-DATE =                            04761000
MFA-TR*                               DATE (CURRENT DATE - 2 YEARS)     04762000
MFA-TR*    END-EXEC.                                                    04800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSRP169 ABORT ************'         
               DISPLAY '* 7500-GET-TWO-YEARS-BACK            *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP169 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 04930000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04960000
       8000-WRITE-AUDIT-REPORT.                                         
      *                                                                 04980000
           IF WS-RPT1-LINE-NO = WS-52                                   
              PERFORM 8200-PRINT-TITLE           THRU 8200-EXIT         
              PERFORM 8300-PRINT-HEADERS         THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                 05030000
           WRITE PCSRP169-REC FROM WS-DETAIL-LINE-1.                    
A04494     ADD 1                 TO WS-RPT1-LINE-NO.                    
A04494     IF WS-DETAIL-LINE-2 > SPACES                                 
A04494        WRITE PCSRP169-REC FROM WS-DETAIL-LINE-2                  
A04494        ADD 1              TO WS-RPT1-LINE-NO                     
A04494     END-IF.                                                      
A04494     IF WS-DETAIL-LINE-3 > SPACES                                 
A04494        WRITE PCSRP169-REC FROM WS-DETAIL-LINE-3                  
A04494        ADD 1              TO WS-RPT1-LINE-NO                     
A04494     END-IF.                                                      
A04494     IF WS-DETAIL-LINE-4 > SPACES                                 
A04494        WRITE PCSRP169-REC FROM WS-DETAIL-LINE-4                  
A04494        ADD 1              TO WS-RPT1-LINE-NO                     
A04494     END-IF.                                                      
      *                                                                 05050000
      *                                                                 05061000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05064000
      ****************************************************************  05065000
      **                                                            **  05066000
      **   8200-PRINT-TITLE                                         **  05067000
      **       PRINTS THE TITLE OF THE REPORT                       **  05068000
      **                                                            **  05069000
      ****************************************************************  05070000
       8200-PRINT-TITLE.                                                
           MOVE ZEROES                 TO WS-RPT1-LINE-NO.              
           WRITE PCSRP169-REC FROM WS-RPT1-HEADER-1.                    
      *                                                                 05110000
           WRITE PCSRP169-REC FROM WS-RPT1-HEADER-1A.                   
           WRITE PCSRP169-REC FROM WS-LINE-80.                          
      *                                                                 05140000
           MOVE WS-REV-MONTH           TO WS-RPT-REV-MTH.               
           WRITE PCSRP169-REC FROM WS-RPT1-HEADER-2.                    
      *                                                                 05170000
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                 05190000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05220000
      ****************************************************************  05230000
      **                                                            **  05240000
      **   8300-PRINT-HEADERS                                       **  05250000
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **  05260000
      **                                                            **  05270000
      ****************************************************************  05280000
       8300-PRINT-HEADERS.                                              
      *                                                                 05300000
           WRITE PCSRP169-REC FROM WS-RPT1-HEADER-31.                   
           WRITE PCSRP169-REC FROM WS-LINE-80.                          
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                 05340000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05370000
T35051****************************************************************  05380000
T35051**                                                            **  05390000
T35051**   8400-WRITE-ALL-AUDITS                                    **  05400000
T35051**       PRINTS THE DETAIL LINE OF THE REPORT                 **  05410000
T35051**                                                            **  05420000
T35051****************************************************************  05430000
T35051 8400-WRITE-ALL-AUDITS.                                           
T35051*                                                                 05450000
T35051     IF WS-RPT2-LINE-NO = WS-52                                   
T35051        MOVE ZEROES                 TO WS-RPT2-LINE-NO            
T35051        WRITE PCSR169A-REC FROM WS-RPT1-HEADER-1                  
T35051*                                                                 05452300
T35051        WRITE PCSR169A-REC FROM WS-RPT1-HEADER-1A                 
T35051        WRITE PCSR169A-REC FROM WS-LINE-80                        
T35051*                                                                 05452600
T35051        MOVE WS-REV-MONTH        TO WS-RPT2-REV-MTH               
T35051        WRITE PCSR169A-REC FROM WS-RPT1-HEADER-2A                 
T35051*                                                                 05452900
T35051        ADD 4                    TO WS-RPT2-LINE-NO               
T35051*                                                                 05453100
T35051        WRITE PCSR169A-REC FROM WS-RPT1-HEADER-31                 
T35051        WRITE PCSR169A-REC FROM WS-LINE-80                        
T35051*                                                                 05453400
T35051        ADD 2                    TO WS-RPT1-LINE-NO               
T35051     END-IF.                                                      
T35051*                                                                 05455000
T35051     WRITE PCSR169A-REC FROM WS-DETAIL-LINE-1.                    
T35051     ADD 1              TO WS-RPT2-LINE-NO.                       
A04494     IF WS-DETAIL-LINE-2 > SPACES                                 
A04494        WRITE PCSR169A-REC FROM WS-DETAIL-LINE-2                  
A04494        ADD 1              TO WS-RPT2-LINE-NO                     
A04494     END-IF.                                                      
A04494     IF WS-DETAIL-LINE-3 > SPACES                                 
A04494        WRITE PCSR169A-REC FROM WS-DETAIL-LINE-3                  
A04494        ADD 1              TO WS-RPT2-LINE-NO                     
A04494     END-IF.                                                      
A04494     IF WS-DETAIL-LINE-4 > SPACES                                 
A04494        WRITE PCSR169A-REC FROM WS-DETAIL-LINE-4                  
A04494        ADD 1              TO WS-RPT2-LINE-NO                     
A04494     END-IF.                                                      
T35051*                                                                 05458000
T35051*                                                                 05490000
T35051 8400-EXIT.                                                       
T35051     EXIT.                                                        
T35051*                                                                 05520000
      *                                                                 05670000
       8600-DELETE-PREV-RECS.                                           
      *                                                                 05690000
           EXEC SQL                                                     
               DELETE FROM AX                          
               FROM CSS_AUDIT_HISTORY AX
                WHERE AX.REVENUE_MONTH <= :AX-REVENUE-MONTH             
                  AND AX.COMPANY_TYPE_CD = :AX-COMPANY-TYPE-CD          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     05700000
MFA-TR*        DELETE FROM CSS_AUDIT_HISTORY AX                         05710000
MFA-TR*         WHERE AX.REVENUE_MONTH <= :AX-REVENUE-MONTH             05720000
MFA-TR*           AND AX.COMPANY_TYPE_CD = :AX-COMPANY-TYPE-CD          05730000
MFA-TR*    END-EXEC.                                                    05730100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   DISPLAY '*NO RECORD FOUND TO DELETE FOR REV MONTH'   
                   DISPLAY AX-REVENUE-MONTH                             
              WHEN OTHER                                                
                   DISPLAY '*** ERROR IN PROGRAM PCSRP169  ***'         
                   DISPLAY '***  8600-DELETE-PREV-RECS     ***'         
                   DISPLAY '*** TABLE - CSS_AUDIT_HISTORY  ***'         
                   DISPLAY '*** DB2 FUNCTION - DELETE      ***'         
                   DISPLAY '*** REVENUE_MONTH    'AX-REVENUE-MONTH      
                   DISPLAY '*** COMPANY_TYPE_CD  'AX-COMPANY-TYPE-CD    
                   PERFORM 9900-ABEND             THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05737700
      ****************************************************************  05737800
      **                                                            **  05737900
      **   9000-TERMINATE                                           **  05738000
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **  05739000
      **                                                            **  05740000
      ****************************************************************  05750000
       9000-TERMINATE.                                                  
           CLOSE PCSRP169-FILE                                          
T35051           PCSR169A-FILE.                                         
           IF RP169-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP169 PROCESSING ERROR       **'   
               DISPLAY '** CLOSE ERROR FOR PCSRP169 - OUTPUT FILE **'   
               DISPLAY '**      FILE STATUS = ' WS-R169-STATUS          
           END-IF.                                                      
      *                                                                 05850000
           IF RA169-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP169 PROCESSING ERROR       **'   
               DISPLAY '** CLOSE ERROR FOR PCSRP169 - OUTPUT FILE **'   
               DISPLAY '**      FILE STATUS = ' WS-RA169-STATUS         
           END-IF.                                                      
      *                                                                 05858000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05880000
      ************************************************************      05890000
      *  9700-PROCESS-ABEND                                      *      05900000
      ************************************************************      05910000
      *                                                                 05920000
           EXEC SQL                                                     05930000
             INCLUDE CPD09900                                           05940000
           END-EXEC.                                                    05950000
      *                                                                 05960000
