       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP157.                                        
       DATE-WRITTEN.   08/28/03.                                        
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      ******************************************************************00330000
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  08/28/03     KR        NEW PROGRAM FOR REPORT GENERATION   **         
      **                         SIMILAR TO PROGRAM PCSRP187         **         
      **  12/15/03     KR        CML 28567 ACTIVITY #2               **         
      **  02/24/04  JS83520      CML 28567 ACTIVITY #2               **         
T35434**  04/09/07  COVANSYS     REPLACED MODEL_SQL WITH SET COMMAND **         
T35434**                         AND ADDED FETCH WITH UR FOR -911    **         
T35434**                         ABENDS.                                        
      **  --------  --------     ----------------------------------  **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP157 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP87.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP87.                                                            
       COPY FIORP87.                                                            
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP157'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP157 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1  PIC X(50)    VALUE               
              '        PROJECTED READ DAYS - 20 PLUS             '.     
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-IS-NOT-STARTED            VALUE 'N'.          
           05  WS-BEGIN-REPORT         PIC X(01)    VALUE 'Y'.          
               88  BEGINNING-OF-REPORT              VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-PRINT-FOOTER         PIC X(01)    VALUE 'N'.          
               88  FOOTER-TO-BE-PRINTED             VALUE 'Y'.          
           05  WS-LOCAL-OFFICE         PIC X(01)    VALUE 'N'.          
               88  LOC-OFFICE-CHANGED               VALUE 'Y'.          
           05  WS-ROUTE                PIC X(01)    VALUE 'N'.          
               88  ROUTE-CHANGED                    VALUE 'Y'.          
           05  WS-HEADER               PIC X(01)    VALUE 'N'.          
               88  HEADER-WRITTEN                   VALUE 'Y'.          
               88  HEADER-NOT-WRITTEN               VALUE 'N'.          
C28567     05  WS-PAGE                 PIC X(01)    VALUE 'N'.          
C28567         88  PAGE-CHANGED                     VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FRP87-REC-CNTR       PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FRP87-STATUS         PIC X(02).                       
               88  FRP87-SUCCESSFUL                 VALUE '00'.         
      *                                                                         
           05  WS-ADV-LINE             PIC 9(02)    VALUE 1.            
           05  WS-PREV-LOC-OFFICE      PIC X(03)    VALUE SPACES.       
           05  WS-PREV-ROUTE           PIC S9(05) COMP-3 VALUE ZEROS.   
           05  WS-PREV-LAST-READ-DATE  PIC X(10)    VALUE SPACES.       
           05  WS-DAY                  PIC S9(03) COMP  VALUE ZEROS.    
           05  WS-HOLIDAY-WEEKEND-CNTR PIC 9(01)    VALUE ZEROS.        
           05  WS-DAYS-COLLECTION      PIC S9(03) COMP  VALUE ZEROS.    
           05  WS-DAYS-CAL-CNTR        PIC X(01)    VALUE 'Y'.          
           05  WS-METERS-COUNT         PIC S9(06) COMP  VALUE ZEROS.    
           05  WS-METERS-COUNT2        PIC S9(06) COMP  VALUE ZEROS.    
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
           05  WS-ROW-COUNT            PIC S9(03) COMP  VALUE ZEROS.    
           05  WS-EXTRACT-DATE-CAL     PIC 9(02)    VALUE ZEROS.        
           05  WS-EXTRACT-MM-CAL       PIC 9(02)    VALUE ZEROS.        
           05  WS-EXTRACT-YY-CAL       PIC 9(02)    VALUE ZEROS.        
           05  WS-EXTRACT-CC-CAL       PIC 9(02)    VALUE ZEROS.        
           05  WS-LEAP-YY              PIC 9(02)V99 VALUE ZEROS.        
           05  WS-LEAP-YY-DEC REDEFINES WS-LEAP-YY.                     
               10 FILLER               PIC X(02).                       
               10 WS-LEAP-YY-D         PIC 9(02).                       
      *                                                                         
       01  WS-OPTIMAL-VALUE.                                            
           05  WS-OPTIMAL-DATE-1       PIC X(10)    VALUE SPACES.       
           05  WS-OPTIMAL-DATE-2       PIC X(10)    VALUE SPACES.       
           05  WS-OPTIMAL-DATE-3       PIC X(10)    VALUE SPACES.       
           05  WS-OPTIMAL-DATE-4       PIC X(10)    VALUE SPACES.       
           05  WS-OPTIMAL-DATE-5       PIC X(10)    VALUE SPACES.       
           05  WS-OPTIMAL-DATE-TEMP    PIC X(10)    VALUE SPACES.       
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 62   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      ****************************************************************          
      *                                                                         
       01  WS-EXTRACT-DATE-10.                                          
           05  WS-ED-CC                PIC X(02).                       
           05  WS-ED-YY                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-ED-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-ED-DD                PIC X(02).                       
      *                                                                         
       01  WS-EXTRACT-DATE-8.                                           
           05  WS-DATE-MM              PIC 9(02)    VALUE ZEROS.        
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-DD              PIC 9(02)    VALUE ZEROS.        
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-YY              PIC 9(02)    VALUE ZEROS.        
      *                                                                         
       01  WS-TEMP-DATE                PIC X(10).                       
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP157'.   
           05  WS-58                   PIC 9(02)    VALUE 58.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
      *                                                                         
      ***************** PCSRP157 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(23)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(118)   VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'READ CYCLE: '.      
               10  P-RPT1-READ-CYCLE   PIC X(02).                       
               10  FILLER              PIC X(105)   VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X(25)    VALUE               
                                           'METER READ EXTRACT DATE: '. 
               10  P-RPT1-EXTRACT-DATE PIC X(08).                       
               10  FILLER              PIC X(99)   VALUE SPACES.        
      *                                                                         
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                                   'CYCLE CLOSE DATE: '.
               10  P-RPT1-CYCLE-DATE   PIC X(08).                       
               10  FILLER              PIC X(99)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-34.                                       
               10  FILLER              PIC X(11)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'LOCAL OFFICE: '.    
               10  P-RPT1-LOCAL-OFF-CD PIC X(03).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-LOCAL-OFFICE-DESC PIC X(22).                       
               10  FILLER              PIC X(81)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-35.                                       
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'ROUTE: '.    
               10  P-RPT1-ROUTE        PIC 9(05).                       
               10  FILLER              PIC X(102)   VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-36.                                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'LAST READ DATE'.    
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'NO OF METERS'.      
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  P-RPT1-DATE-1ST     PIC X(08).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-RPT1-DATE-2ND     PIC X(08).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-RPT1-DATE-3RD     PIC X(08).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-RPT1-DATE-4TH     PIC X(08).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-RPT1-DATE-5TH     PIC X(08).                       
               10  FILLER              PIC X(05)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-LAST-READ-DATE    PIC X(08).                       
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  P-METERS-COUNT      PIC ZZZ,ZZ9.                     
               10  FILLER              PIC X(08)    VALUE SPACES.       
               10  P-DAYS-COUNT-1ST    PIC ZZZ,ZZ9.                     
               10  P-DAYS-ASTERISK-1ST PIC X(01).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-DAYS-COUNT-2ND    PIC ZZZ,ZZ9.                     
               10  P-DAYS-ASTERISK-2ND PIC X(01).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-DAYS-COUNT-3RD    PIC ZZZ,ZZ9.                     
               10  P-DAYS-ASTERISK-3RD PIC X(01).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-DAYS-COUNT-4TH    PIC ZZZ,ZZ9.                     
               10  P-DAYS-ASTERISK-4TH PIC X(01).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-DAYS-COUNT-5TH    PIC ZZZ,ZZ9.                     
               10  P-DAYS-ASTERISK-5TH PIC X(01).                       
               10  FILLER              PIC X(04)    VALUE SPACES.       
      *                                                                         
           05  WS-FOOTER-LINE.                                          
               10  P-FOOTER-DETAIL-1   PIC X(51)    VALUE               
                '* - PROJECTED READ DAYS OUTSIDE OF 28-34 DAY WINDOW'.  
      *         '* - PROJECTED READ DAYS OUTSIDE OF 27-34 DAY WINDOW'.          
               10  P-FOOTER-DETAIL-2   PIC X(37)    VALUE               
                ' AND WOULD CAUSE BILLS TO BE PRORATED'.                
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP157 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSRP87             THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP87-CO-KEY-EREC EQUAL HIGH-VALUES                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FRP87-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE         
              MOVE E-FRP87-ROUTE          TO WS-PREV-ROUTE              
              MOVE E-FRP87-LAST-READ-DATE TO WS-PREV-LAST-READ-DATE     
           END-IF.                                                      
      *                                                                         
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
               UNTIL NO-MORE-DATA.                                      
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FRP87-REC-CNTR EQUAL ZERO                          
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8310-PRINT-HEADERS    THRU 8310-EXIT         
                   MOVE SPACES         TO P-RPT1-DATE-1ST               
                   MOVE SPACES         TO P-RPT1-DATE-2ND               
                   MOVE SPACES         TO P-RPT1-DATE-3RD               
                   MOVE SPACES         TO P-RPT1-DATE-4TH               
                   MOVE SPACES         TO P-RPT1-DATE-5TH               
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
                   IF FOOTER-TO-BE-PRINTED                              
                       COMPUTE WS-ADV-LINE = WS-62 - WS-RPT1-LINE-NO    
                       PERFORM 8000-PRINT-FOOTER THRU 8000-EXIT         
                       MOVE WS-N       TO WS-PRINT-FOOTER               
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               IF WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                     
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8310-PRINT-HEADERS    THRU 8310-EXIT         
                   MOVE SPACES         TO P-RPT1-DATE-1ST               
                   MOVE SPACES         TO P-RPT1-DATE-2ND               
                   MOVE SPACES         TO P-RPT1-DATE-3RD               
                   MOVE SPACES         TO P-RPT1-DATE-4TH               
                   MOVE SPACES         TO P-RPT1-DATE-5TH               
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
                   ADD 3               TO WS-RPT1-LINE-NO               
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
                   ADD 3               TO WS-RPT1-LINE-NO               
                   IF FOOTER-TO-BE-PRINTED                              
                       COMPUTE WS-ADV-LINE = WS-62 - WS-RPT1-LINE-NO    
                       PERFORM 8000-PRINT-FOOTER THRU 8000-EXIT         
                       MOVE WS-N       TO WS-PRINT-FOOTER               
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP157 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP157 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSRP87-FILE.                                     
           IF FRP87-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       FCSRP87 PROCESSING ERROR       **'     
               DISPLAY '**  OPEN ERROR OF FCSRP87 - INPUT FILE  **'     
               DISPLAY '**        FILE STATUS = ' WS-FRP87-STATUS       
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO,                
                                          B1-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       CHECKS FOR THE BEGINNING OF THE FILE FCSRP87         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSRP87             THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP87-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FRP87-REC-CNTR                        
               MOVE E-FRP87-CREATE-DATE-BREC                            
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
                                                                        
           ELSE                                                         
               DISPLAY '**        FCSRP87 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1010-BUSINESS-DAY                                        **          
      **       THIS PARAGRAPH IS USED TO SELECT THE VALID DATE      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1010-BUSINESS-DAY.                                               
      *                                                                         
           MOVE 1                      TO WS-HOLIDAY-WEEKEND-CNTR.      
           MOVE SPACES                 TO WS-OPTIMAL-DATE-1.            
           MOVE SPACES                 TO WS-OPTIMAL-DATE-2.            
           MOVE SPACES                 TO WS-OPTIMAL-DATE-3.            
           MOVE SPACES                 TO WS-OPTIMAL-DATE-4.            
           MOVE SPACES                 TO WS-OPTIMAL-DATE-5.            
           MOVE E-FRP87-COMPANY-NO     TO C7-COMPANY-NO,                
                                          B1-COMPANY-NO.                
      *                                                                         
           PERFORM 3500-VALIDATE-DATE            THRU 3500-EXIT         
                  UNTIL WS-EXTRACT-DATE-10 EQUAL                        
                       E-FRP87-CYCLE-CLOSE-DATE.                        
      *                                                                         
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSRP157        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**       FCSRP87 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF E-FRP87-CO-KEY-EREC EQUAL HIGH-VALUES OR              
                  E-FRP87-KEY-EREC    EQUAL HIGH-VALUES                 
                   PERFORM 1700-CHECK-END-REC    THRU 1700-EXIT         
               ELSE                                                     
                  MOVE E-FRP87-METER-EXTRACT-DATE                       
                                       TO WS-EXTRACT-DATE-10            
                  PERFORM 1010-BUSINESS-DAY          THRU 1010-EXIT     
      *                                                                         
                   IF REPORT-IS-NOT-STARTED                             
                       MOVE WS-Y       TO WS-START-REPORT               
                       MOVE WS-Y       TO WS-ROUTE                      
                       MOVE E-FRP87-COMPANY-NO                          
                                       TO WS-CURRENT-COMP-NO,           
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSRP87             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       CHECKS WHETHER TO PROCESS END-REC OR COMPANY END-REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           IF E-FRP87-CO-NO-KEY-EREC EQUAL HIGH-VALUES                  
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           MOVE WS-62                  TO WS-RPT1-LINE-NO.              
      *                                                                         
           SUBTRACT 1 FROM WS-FRP87-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FRP87-CO-REC-COUNT-EREC          
               IF E-FRP87-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   MOVE WS-Y           TO WS-END-OF-SYSIN-REC           
               END-IF                                                   
           ELSE                                                         
               IF E-FRP87-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   DISPLAY '**      FCSRP87 PROCESSING ERROR      **'   
                   DISPLAY '**  COMPANY NO = ' E-FRP87-COMPANY-NO       
                   DISPLAY '** ACTUAL RECORD COUNT OF THE COMPANY **'   
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD   **'   
                   DISPLAY '** CONTROL REC COUNT = '                    
                                     E-FRP87-CO-REC-COUNT-EREC          
                   DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR   
                   DISPLAY '**         PROCESSING TERMINATED      **'   
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   DISPLAY '**      FCSRP87 PROCESSING ERROR      **'   
                   DISPLAY '**  COMPANY NO = ' E-FRP87-CO-NO-KEY-EREC   
                   DISPLAY '** ACTUAL RECORD COUNT OF THE COMPANY **'   
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD   **'   
                   DISPLAY '** CONTROL REC COUNT = '                    
                                     E-FRP87-CO-REC-COUNT-EREC          
                   DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR   
                   DISPLAY '**        PROCESSING CONTINUES        **'   
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF ALL RECORDS               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FRP87-REC-CNTR.                           
      *                                                                         
           IF FOOTER-TO-BE-PRINTED                                      
               PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT         
               PERFORM 8900-PRINT-DETAIL-LINE    THRU 8900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**         FCSRP87 PROCESSING ERROR        **'  
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD  **'  
               DISPLAY '**          PROCESSING TERMINATED          **'  
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FRP87-REC-CNTR EQUAL E-FRP87-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         FCSRP87 PROCESSING ERROR        **'  
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP87-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP87-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NUMBER TO PRODUCE REPORT              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE 'Y'                TO WS-ROUTE                      
               MOVE 'Y'                TO WS-BEGIN-REPORT               
               MOVE E-FRP87-COMPANY-NO TO WS-CURRENT-COMP-NO            
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
               MOVE E-FRP87-LOCAL-OFFICE                                
                                       TO WS-PREV-LOC-OFFICE            
               MOVE E-FRP87-ROUTE      TO WS-PREV-ROUTE                 
               MOVE E-FRP87-LAST-READ-DATE                              
                                       TO WS-PREV-LAST-READ-DATE        
           END-IF.                                                      
      *                                                                         
           IF E-FRP87-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO           
               DISPLAY '**       FCSRP87 PROCESSING ERROR       **'     
               DISPLAY '**  COMPANY DATA RECORDS NOT SEPARATED  **'     
               DISPLAY '**    WITH PROPER COMPANY END-RECORD    **'     
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FRP87-COMPANY-NO  
               DISPLAY '** DATA IS :  E-FRP87-DATA-REC'                 
               DISPLAY '**       PROCESSING TERMINATED          **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                   IF E-FRP87-COMPANY-NO EQUAL WS-SYSIN-COMP-NO         
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT                     
                                                 THRU 2200-EXIT         
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '**   FCSRP87 PROCESSING ERROR    **'
                           DISPLAY '**   FILE NOT SORTED PROPERLY    **'
                           DISPLAY '**  IN ORDER OF COMPANY NUMBERS  **'
                           DISPLAY '**  DATA IS:  E-FRP87-DATA-REC   **'
                           DISPLAY '**     PROCESSING TERMINATED     **'
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-58                        
               IF FOOTER-TO-BE-PRINTED                                  
                   COMPUTE WS-ADV-LINE = WS-62 - WS-RPT1-LINE-NO        
                   PERFORM 8000-PRINT-FOOTER     THRU 8000-EXIT         
               END-IF                                                   
               MOVE WS-Y               TO WS-PRINT-FOOTER               
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               MOVE E-FRP87-ROUTE      TO P-RPT1-ROUTE                  
C28567         PERFORM 8310-PRINT-HEADERS        THRU 8310-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-PREV-ROUTE EQUAL E-FRP87-ROUTE                         
             IF E-FRP87-LAST-READ-DATE < '2003-01-01'                   
               CONTINUE                                                 
             ELSE                                                       
               IF WS-PREV-LAST-READ-DATE EQUAL E-FRP87-LAST-READ-DATE   
                   ADD 1               TO WS-METERS-COUNT               
               ELSE                                                     
                   PERFORM 2300-FORMAT-DETAIL-LINE                      
                                                 THRU 2300-EXIT         
                   PERFORM 8900-PRINT-DETAIL-LINE                       
                                                 THRU 8900-EXIT         
                   MOVE 1              TO WS-METERS-COUNT               
                   MOVE E-FRP87-LAST-READ-DATE                          
                                       TO WS-PREV-LAST-READ-DATE        
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
               MOVE 'Y'                    TO WS-ROUTE                  
               PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT         
               MOVE WS-PREV-ROUTE          TO P-RPT1-ROUTE              
               PERFORM 8900-PRINT-DETAIL-LINE    THRU 8900-EXIT         
               MOVE 1                      TO WS-METERS-COUNT           
               MOVE E-FRP87-LAST-READ-DATE                              
                                           TO WS-PREV-LAST-READ-DATE    
               MOVE E-FRP87-ROUTE          TO WS-PREV-ROUTE             
T28567         MOVE E-FRP87-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE        
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP157       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE WS-PREV-LAST-READ-DATE TO WS-DATE-10.                   
           MOVE WS-D10-YY              TO WS-D8-YY.                     
           MOVE WS-D10-MM              TO WS-D8-MM.                     
           MOVE WS-D10-DD              TO WS-D8-DD.                     
           MOVE WS-DATE-8              TO P-LAST-READ-DATE.             
      *                                                                         
           MOVE WS-METERS-COUNT        TO P-METERS-COUNT,               
                                          WS-METERS-COUNT2.             
      *                                                                         
           MOVE WS-OPTIMAL-DATE-1      TO WS-OPTIMAL-DATE-TEMP.         
           IF WS-OPTIMAL-DATE-TEMP EQUAL SPACES                         
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7400-GET-DIFFERENCE-DATE  THRU 7400-EXIT         
               MOVE WS-DAYS-COLLECTION TO P-DAYS-COUNT-1ST              
               IF WS-DAYS-COLLECTION <= 27 OR                           
                  WS-DAYS-COLLECTION >= 35                              
                   MOVE '*'            TO P-DAYS-ASTERISK-1ST           
               ELSE                                                     
                   MOVE SPACES         TO P-DAYS-ASTERISK-1ST           
               END-IF                                                   
               MOVE ZEROS              TO WS-DAYS-COLLECTION            
           END-IF.                                                      
      *                                                                         
           MOVE WS-OPTIMAL-DATE-2      TO WS-OPTIMAL-DATE-TEMP.         
           IF WS-OPTIMAL-DATE-TEMP EQUAL SPACES                         
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7400-GET-DIFFERENCE-DATE  THRU 7400-EXIT         
               MOVE WS-DAYS-COLLECTION TO P-DAYS-COUNT-2ND              
               IF WS-DAYS-COLLECTION <= 27 OR                           
                  WS-DAYS-COLLECTION >= 35                              
                   MOVE '*'            TO P-DAYS-ASTERISK-2ND           
               ELSE                                                     
                   MOVE SPACES         TO P-DAYS-ASTERISK-2ND           
               END-IF                                                   
               MOVE ZEROS              TO WS-DAYS-COLLECTION            
           END-IF.                                                      
      *                                                                         
           MOVE WS-OPTIMAL-DATE-3      TO WS-OPTIMAL-DATE-TEMP.         
           IF WS-OPTIMAL-DATE-TEMP EQUAL SPACES                         
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7400-GET-DIFFERENCE-DATE  THRU 7400-EXIT         
               MOVE WS-DAYS-COLLECTION TO P-DAYS-COUNT-3RD              
               IF WS-DAYS-COLLECTION <= 27 OR                           
                  WS-DAYS-COLLECTION >= 35                              
                   MOVE '*'            TO P-DAYS-ASTERISK-3RD           
               ELSE                                                     
                   MOVE SPACES         TO P-DAYS-ASTERISK-3RD           
               END-IF                                                   
               MOVE ZEROS              TO WS-DAYS-COLLECTION            
           END-IF.                                                      
      *                                                                         
           MOVE WS-OPTIMAL-DATE-4      TO WS-OPTIMAL-DATE-TEMP.         
           IF WS-OPTIMAL-DATE-TEMP EQUAL SPACES                         
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7400-GET-DIFFERENCE-DATE  THRU 7400-EXIT         
               MOVE WS-DAYS-COLLECTION TO P-DAYS-COUNT-4TH              
               IF WS-DAYS-COLLECTION <= 27 OR                           
                  WS-DAYS-COLLECTION >= 35                              
                   MOVE '*'            TO P-DAYS-ASTERISK-4TH           
               ELSE                                                     
                   MOVE SPACES         TO P-DAYS-ASTERISK-4TH           
               END-IF                                                   
               MOVE ZEROS              TO WS-DAYS-COLLECTION            
           END-IF.                                                      
      *                                                                         
           MOVE WS-OPTIMAL-DATE-5      TO WS-OPTIMAL-DATE-TEMP.         
           IF WS-OPTIMAL-DATE-TEMP EQUAL SPACES                         
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7400-GET-DIFFERENCE-DATE  THRU 7400-EXIT         
               MOVE WS-DAYS-COLLECTION TO P-DAYS-COUNT-5TH              
               IF WS-DAYS-COLLECTION <= 27 OR                           
                  WS-DAYS-COLLECTION >= 35                              
                   MOVE '*'            TO P-DAYS-ASTERISK-5TH           
               ELSE                                                     
                   MOVE SPACES         TO P-DAYS-ASTERISK-5TH           
               END-IF                                                   
               MOVE ZEROS              TO WS-DAYS-COLLECTION            
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3500-VALIDATE-DATE                                       **          
      **     VALIDATES THAT DATE SPECIFIED IS A VALID BUSINESS DAY  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3500-VALIDATE-DATE.                                              
      *                                                                         
           IF WS-EXTRACT-DATE-10 >= E-FRP87-METER-EXTRACT-DATE AND      
              WS-EXTRACT-DATE-10 <= E-FRP87-CYCLE-CLOSE-DATE            
               MOVE WS-ED-DD           TO WS-EXTRACT-DATE-CAL           
               MOVE WS-ED-MM           TO WS-EXTRACT-MM-CAL             
               MOVE WS-ED-YY           TO WS-EXTRACT-YY-CAL             
               MOVE WS-ED-CC           TO WS-EXTRACT-CC-CAL             
               ADD 1                   TO WS-EXTRACT-DATE-CAL           
               MOVE WS-EXTRACT-DATE-CAL                                 
                                       TO WS-ED-DD                      
               PERFORM 3510-GET-VALID-MM-DD-YY   THRU 3510-EXIT         
               MOVE WS-ED-YY           TO WS-DATE-YY                    
               MOVE WS-ED-MM           TO WS-DATE-MM                    
               MOVE WS-ED-DD           TO WS-DATE-DD                    
               MOVE WS-EXTRACT-DATE-10 TO WS-TEMP-DATE                  
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-CURRENT-DAY-CODE     THRU 7500-EXIT.        
           IF WS-DAY EQUAL 6 OR                                         
              WS-DAY EQUAL ZEROS                                        
               CONTINUE                                                 
           ELSE                                                         
               MOVE ZEROS          TO WS-ROW-COUNT                      
               MOVE WS-EXTRACT-DATE-10                                  
                                       TO J8-HOLIDAY-DT                 
               PERFORM 7600-SELECT-HOLIDAY       THRU 7600-EXIT         
               IF WS-ROW-COUNT GREATER THAN ZEROS                       
                   NEXT SENTENCE                                        
               ELSE                                                     
                   EVALUATE WS-HOLIDAY-WEEKEND-CNTR                     
                       WHEN 1                                           
                           MOVE WS-EXTRACT-DATE-8                       
                                       TO P-RPT1-DATE-1ST               
                           MOVE WS-EXTRACT-DATE-10                      
                                       TO WS-OPTIMAL-DATE-1             
                           ADD 1       TO WS-HOLIDAY-WEEKEND-CNTR       
                       WHEN 2                                           
                           MOVE WS-EXTRACT-DATE-8                       
                                       TO P-RPT1-DATE-2ND               
                           MOVE WS-EXTRACT-DATE-10                      
                                       TO WS-OPTIMAL-DATE-2             
                           ADD 1       TO WS-HOLIDAY-WEEKEND-CNTR       
                       WHEN 3                                           
                           MOVE WS-EXTRACT-DATE-8                       
                                       TO P-RPT1-DATE-3RD               
                           MOVE WS-EXTRACT-DATE-10                      
                                       TO WS-OPTIMAL-DATE-3             
                           ADD 1       TO WS-HOLIDAY-WEEKEND-CNTR       
                       WHEN 4                                           
                           MOVE WS-EXTRACT-DATE-8                       
                                       TO P-RPT1-DATE-4TH               
                           MOVE WS-EXTRACT-DATE-10                      
                                       TO WS-OPTIMAL-DATE-4             
                           ADD 1       TO WS-HOLIDAY-WEEKEND-CNTR       
                       WHEN 5                                           
                           IF WS-EXTRACT-DATE-10 EQUAL                  
                                         E-FRP87-CYCLE-CLOSE-DATE       
                               MOVE WS-EXTRACT-DATE-8                   
                                       TO P-RPT1-DATE-5TH               
                               MOVE WS-EXTRACT-DATE-10                  
                                       TO WS-OPTIMAL-DATE-5             
                               ADD 1   TO WS-HOLIDAY-WEEKEND-CNTR       
                           END-IF                                       
                   END-EVALUATE                                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   3510-GET-VALID-MM-DD-YY                                  **          
      **     ENSURES THAT MONTH, DAY, AND YEAR ARE VALID            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       3510-GET-VALID-MM-DD-YY.                                         
      *                                                                         
           COMPUTE WS-LEAP-YY = WS-EXTRACT-YY-CAL / 4.                  
      *                                                                         
           IF (WS-ED-MM = '01' AND WS-ED-DD = '32') OR                  
              (WS-ED-MM = '02'                                          
             AND ((WS-ED-DD = '30' AND WS-LEAP-YY-D = 0)                
               OR (WS-ED-DD = '29' AND WS-LEAP-YY-D > 0)))              
               OR (WS-ED-MM = '03' AND WS-ED-DD = '32')                 
               OR (WS-ED-MM = '04' AND WS-ED-DD = '31')                 
               OR (WS-ED-MM = '05' AND WS-ED-DD = '32')                 
               OR (WS-ED-MM = '06' AND WS-ED-DD = '31')                 
               OR (WS-ED-MM = '07' AND WS-ED-DD = '32')                 
               OR (WS-ED-MM = '08' AND WS-ED-DD = '32')                 
               OR (WS-ED-MM = '09' AND WS-ED-DD = '31')                 
               OR (WS-ED-MM = '10' AND WS-ED-DD = '32')                 
               OR (WS-ED-MM = '11' AND WS-ED-DD = '31')                 
               ADD  1                  TO WS-EXTRACT-MM-CAL             
               MOVE 1                  TO WS-EXTRACT-DATE-CAL           
           ELSE                                                         
               IF WS-ED-MM = '12' AND WS-ED-DD = '32'                   
                   MOVE 1              TO WS-EXTRACT-MM-CAL             
                   ADD  1              TO WS-EXTRACT-YY-CAL             
                   MOVE 1              TO WS-EXTRACT-DATE-CAL           
                   IF WS-EXTRACT-YY-CAL = ZEROES                        
                       ADD 1           TO WS-EXTRACT-CC-CAL             
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-EXTRACT-DATE-CAL    TO WS-ED-DD.                     
           MOVE WS-EXTRACT-MM-CAL      TO WS-ED-MM.                     
           MOVE WS-EXTRACT-YY-CAL      TO WS-ED-YY.                     
           MOVE WS-EXTRACT-CC-CAL      TO WS-ED-CC.                     
      *                                                                         
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP87                                        **          
      **      READS THE INPUT FILE FCSRP87                          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP87.                                               
      *                                                                         
           READ FCSRP87-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP87-SUCCESSFUL                                          
               ADD 1                   TO WS-FRP87-REC-CNTR             
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP87 READ.  STATUS IS '        
                        WS-FRP87-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-GET-DIFFERENCE-DATE                                 **          
      **      PARAGRAPH IS USED TO GET THE DIFFERENCE OF TWO DATES  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7400-GET-DIFFERENCE-DATE.                                        
      *                                                                         
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
T35434         SELECT
              CIS.DAYS (IIF(TRY_CONVERT(DATE, :WS-OPTIMAL-DATE-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-OPTIMAL-DATE-TEMP
              ) <> 0) OR (LEN(:WS-OPTIMAL-DATE-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-OPTIMAL-DATE-TEMP
              ), CONVERT(DATE, :WS-OPTIMAL-DATE-TEMP) ))    
T35434                            - CIS.DAYS (IIF(TRY_CONVERT(DATE, 
                                                :WS-PREV-LAST-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-LAST-READ-DATE
              ) <> 0) OR (LEN(:WS-PREV-LAST-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-LAST-READ-DATE
              ), CONVERT(DATE, :WS-PREV-LAST-READ-DATE) ))
            INTO
              :WS-DAYS-COLLECTION
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DAYS-COLLECTION =                                        
MFA-TR*                           DAYS (DATE(:WS-OPTIMAL-DATE-TEMP))            
MFA-TR*                           - DAYS (DATE(:WS-PREV-LAST-READ-DATE))        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
T35434         DISPLAY '** SET ERROR IN 7400-GET-DIFFERENCE-DATE    **' 
               DISPLAY '**          RETURN CODE = ' SQLCODE             
               DISPLAY '**          PROCESSING TERMINATED           **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-GET-CURRENT-DAY-CODE                                **          
T35434**      PARAGRAPH USED TO SELECT DAY CODE                     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7500-GET-CURRENT-DAY-CODE.                                       
      *                                                                         
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
T35434         SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ))                  
T35434                      - (CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                          :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ))/7 * 7)
            INTO
              :WS-DAY
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DAY = DAYS(DATE(:WS-TEMP-DATE))                          
MFA-TR*                     - (INTEGER(DAYS(DATE(:WS-TEMP-DATE))/7) * 7)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
T35434         DISPLAY '** SET ERROR IN 7500-GET-CURRENT-DAY-CODE    **'
               DISPLAY '**          RETURN CODE = ' SQLCODE             
               DISPLAY '**          PROCESSING TERMINATED            **'
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7600-SELECT-HOLIDAY                                      **          
      **      PARAGRAPH IS USED TO SELECT HOLIDAY FROM CSS_HOLIDAY  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7600-SELECT-HOLIDAY.                                             
      *                                                                         
           MOVE '7600' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT       COUNT (*)                                   
               INTO :WS-ROW-COUNT                                       
               FROM CSS_HOLIDAY                                         
               WHERE    HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT       COUNT (*)                                           
MFA-TR*        INTO :WS-ROW-COUNT                                               
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*        WHERE    HOLIDAY_DT = :J8-HOLIDAY-DT                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7600-SELECT HOLIDAY **'      
               DISPLAY '**        RETURN CODE = ' SQLCODE               
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-GET-LOCAL-OFFICE                                    **          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE '7700'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT   LOCAL_OFFICE_DESC                               
               INTO :B1-LOCAL-OFFICE-DESC                               
               FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                      
               WHERE    COMPANY_NO   = :B1-COMPANY-NO                   
                 AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   LOCAL_OFFICE_DESC                                       
MFA-TR*        INTO :B1-LOCAL-OFFICE-DESC                                       
MFA-TR*        FROM CSS_LOCAL_OFFICE                                            
MFA-TR*        WHERE    COMPANY_NO   = :B1-COMPANY-NO                           
MFA-TR*          AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE B1-LOCAL-OFFICE-DESC                                
                                       TO P-LOCAL-OFFICE-DESC           
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-LOCAL-OFFICE-DESC           
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7700-GET-LOCAL-OFFICE **'
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   COMPANY_NAME                                    
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
               WHERE    COMPANY_NO = :C7-COMPANY-NO                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   COMPANY_NAME                                            
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*        WHERE    COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '**         RETURN CODE = ' SQLCODE          
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    8000-PRINT-FOOTER                                       **          
      **       PRINTS THE FOOTER LINE FOR THE REPORT                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8000-PRINT-FOOTER.                                               
      *                                                                         
           WRITE PRT33-RECORD FROM WS-FOOTER-LINE                       
                AFTER ADVANCING WS-ADV-LINE LINES.                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           MOVE 'N'                    TO WS-HEADER                     
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           IF SYSIN-DOES-NOT-EXIST                                      
               MOVE E-FRP87-COMPANY-NO TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                AFTER ADVANCING TOP-OF-PAGE                             
           MOVE ZERO            TO WS-RPT1-LINE-NO.                     
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
C28567     MOVE 'Y'                    TO WS-PAGE.                      
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8310-PRINT-HEADERS                                       **          
      **       PRINTS THE CYCLE AND LOCAL-OFFICE HEADERS            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8310-PRINT-HEADERS.                                              
      *                                                                         
           MOVE E-FRP87-LOCAL-OFFICE   TO P-RPT1-LOCAL-OFF-CD,          
                                          B1-LOCAL-OFFICE.              
           PERFORM 7700-GET-LOCAL-OFFICE         THRU 7700-EXIT.        
      *                                                                         
           MOVE E-FRP87-READ-CYCLE     TO P-RPT1-READ-CYCLE.            
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                AFTER ADVANCING 3 LINES.                                
      *                                                                         
           MOVE E-FRP87-METER-EXTRACT-DATE                              
                                       TO WS-DATE-10.                   
           MOVE WS-D10-MM              TO WS-D8-MM.                     
           MOVE WS-D10-DD              TO WS-D8-DD.                     
           MOVE WS-D10-YY              TO WS-D8-YY.                     
           MOVE WS-DATE-8              TO P-RPT1-EXTRACT-DATE.          
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-32                    
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE E-FRP87-CYCLE-CLOSE-DATE                                
                                       TO WS-DATE-10.                   
           MOVE WS-D10-MM              TO WS-D8-MM.                     
           MOVE WS-D10-DD              TO WS-D8-DD.                     
           MOVE WS-D10-YY              TO WS-D8-YY.                     
           MOVE WS-DATE-8              TO P-RPT1-CYCLE-DATE.            
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-33                    
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                AFTER ADVANCING 1 LINE.                                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-36                    
                AFTER ADVANCING 1 LINE.                                 
           WRITE PRT33-RECORD FROM WS-LINE                              
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 8                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8320-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8320-PRINT-HEADERS.                                              
      *                                                                         
T28567*    IF WS-PREV-LOC-OFFICE NOT EQUAL E-FRP87-LOCAL-OFFICE OR              
T28567     IF WS-PREV-LOC-OFFICE NOT EQUAL P-RPT1-LOCAL-OFF-CD  OR      
              PAGE-CHANGED                                              
T28567*       MOVE E-FRP87-LOCAL-OFFICE   TO B1-LOCAL-OFFICE                    
T28567        MOVE WS-PREV-LOC-OFFICE     TO B1-LOCAL-OFFICE            
              PERFORM 7700-GET-LOCAL-OFFICE         THRU 7700-EXIT      
              MOVE 'Y'                    TO WS-LOCAL-OFFICE            
T28567*       MOVE E-FRP87-LOCAL-OFFICE   TO P-RPT1-LOCAL-OFF-CD                
T28567        MOVE WS-PREV-LOC-OFFICE     TO P-RPT1-LOCAL-OFF-CD        
              WRITE PRT33-RECORD FROM WS-RPT1-HEADER-34                 
                   AFTER ADVANCING 2 LINES                              
              ADD 2                       TO WS-RPT1-LINE-NO            
              MOVE E-FRP87-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE         
           END-IF.                                                      
      *                                                                         
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP157        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           IF WS-METERS-COUNT >= 20                                     
              IF WS-PREV-ROUTE NOT EQUAL P-RPT1-ROUTE                   
                 MOVE 'Y'                    TO WS-ROUTE                
              END-IF                                                    
C28567        PERFORM 8320-PRINT-HEADERS        THRU 8320-EXIT          
C28567        IF ROUTE-CHANGED OR PAGE-CHANGED                          
                 MOVE WS-PREV-ROUTE          TO P-RPT1-ROUTE            
                 WRITE PRT33-RECORD FROM WS-RPT1-HEADER-35              
                      AFTER ADVANCING 2 LINE                            
                 WRITE PRT33-RECORD FROM WS-BLANK-LINE                  
                      AFTER ADVANCING 1 LINE                            
                 MOVE 'N'         TO WS-ROUTE                           
C28567           MOVE 'N'         TO WS-PAGE                            
                 IF E-FRP87-CO-KEY-EREC EQUAL HIGH-VALUES               
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE E-FRP87-ROUTE          TO WS-PREV-ROUTE        
                 END-IF                                                 
                 ADD 3                       TO WS-RPT1-LINE-NO         
              END-IF                                                    
              WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                  
                   AFTER ADVANCING 1 LINES                              
              WRITE PRT33-RECORD FROM WS-BLANK-LINE                     
                   AFTER ADVANCING 1 LINE                               
      *                                                                         
              ADD 2                       TO WS-RPT1-LINE-NO            
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP87-FILE.                                          
           IF FRP87-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP157 PROCESSING ERROR        **'   
               DISPLAY '**  CLOSE ERROR FOR FCSRP87 - INPUT FILE  **'   
               DISPLAY '**       FILE STATUS = ' WS-FRP87-STATUS        
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    9900-ABEND                                              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
