       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP156.                                        
       DATE-WRITTEN.   07/07/07.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **    DATE    INITIALS     REASON                             **          
      **  ________  _________    __________________________________ **          
      **  07 JULY 2007 RDF       NEW PROGRAM FOR REPORT GENERATION  **          
      **                         OF WQS FOR LIGHT ONLY ACCOUNTS.    **          
      **                                                            **          
      **   1 AUG  2007 RDF       ADDED CBL ADV LINE AT BEGINNING    **          
      **                         ADDED FOR FETCH ONLY               **          
      **                         SET WS-SEQUENCE = 0 FOR JOB-PARM   **          
      **                                                            **          
      **   6 AUG  2007 RDF       ADDING COMMENTS, MOVING THINGS     **          
      **                         MAKING ERROR MESSAGES FOR          **          
      **                         MEANINGFUL, CHANGING FROM CURRENT  **          
      **                         DATE TO DATECOMMON, CHANGING       **          
      **                         DATE TO DATECOMMON, CHANGING       **          
      **                         CFDPRT11 TO CFDPT331.  GETTING     **          
      **                         COMPANY NAME FROM DATABASE, INSTEAD**          
      **                         OF BEING HARD CODED.  ALL CHANGES  **          
      **                         DUE TO CODE REVUE.                 **          
      **                         ADDED COPY BOOKS AND A CALL TO     **          
      **                         SCSCB068 TO GET THE CORRECT DNP    **          
      **                         AMOUNT.                            **          
      **   8 AUG  2007 RDF       INCLUDED ACCOUNT NUMBER IN         **          
      **                         CSS_CUST_PREM_HIST FETCH           **          
T36294**   7 SEP  2007 CVNS      PASS WS-CURRENT-DATE TO            **          
      **               CHENNAI   WS-TEMP-BATCH-DATE.                **          
      **                                                            **          
      **  07 SEP 2007  RDF       ADD JOB PARM DATE LOGIC FOR RERUNS **          
      **                                                            **          
      **  10 SEP 2007  RDF       ADD AN EXTRA DATE FOR THE CURSOR   **          
      **                         TO COMPARE ON IN THE EVENT OF A    **          
      **                         MULTIPLE DAY RERUN SITUATION.      **          
      **                         CORRECT NO DATA ROUTINE.           **          
      **                                                            **          
C37361**  18 JUN 2008  RDF       THE RESP-ID CHANGED ON THE TABLE   **          
      **                         CAUSING A DIFFERENT DESCRIPTION    **          
      **                         FOR SOUTHERN AND NORTHERN.         **          
      **                                                            **          
A03082**  18 JUL 2011  RDF       USER CHANGED DESCRIPTION OR        **          
      **  ACT157                 FOR SOUTHERN AND NORTHERN.         **          
      **                                                            **          
A03967**  18 OCT 2012  RDF       INCLUDE RATE 029 ON REPORT         **          
ACT126**  01 NOV 2012  BD09555   USER CHANGED DESCRIPTION OR        **          
      **  A039967                FOR SOUTHERN AND NORTHERN.         **          
ACT126**  02 NOV 2012  DB41297   COMBINE DESCRIPTIONS TO FIX ABEND. **          
      **                                                            **          
A05154**   1 FEB 2015  RF10596   REMOVE UNUSED CODE                 **          
      **                                                            **          
A05460**  11 AUG 2016  RF10596   CHANGE HEADERS                     **          
      **                                                            **          
      ****************************************************************          
      ****************************************************************          
      **          PROGRAM NARATIVE                                  **          
      **                                                            **          
      **           REPORT GENERATION OF WQS                         **          
      **    FOR LIGHT ONLY ACCOUNTS FOR SCEG AND PSNC               **          
      **                   WITH                                     **          
      **             CATEGORY-ID = 135                              **          
      **                   AND                                      **          
      **    WQ.DATE_CREATED >  THE LAST RUN DATE FROM JOB PARM      **          
      **    WQ.DATE_CREATED <= CURRENT DATE                         **          
      **                                                            **          
      **    PULLS THE LAST RUN DATE FROM JOB-PARM AND               **          
      **    COMPARES THE DATE TO CURRENT DATE.  PROGRAM             **          
      **    ABENDS IF CURRENT IS LESS THAN OR EQUAL TO              **          
      **    LAST RUN.  ALSO, RETRIEVES THE STORED AMOUNTS,          **          
      **    DISPLAYS THEM, ADDS TO THEM AND UPDATES THEM            **          
      **    AT END OF RUN.  PROGRAM ABENDS IF A PROBLEM             **          
      **    WITH RETRIEVING THE RUNNING TOTALS.  IF THE             **          
      **    MONTH CHANGES, A MONTHLY SUMMARY REPORT IS              **          
      **    CREATED THE FIELDS ARE CLEARED AND THE DAILY            **          
      **    REPORT ROUTINE BEGINS.                                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP156 REPORTS ----      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT331.                                                           
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPT331.                                                           
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP156'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SCSCB068                PIC X(8) VALUE 'SCSCB068'.       
           05  WS-COMP-BREAK-SW        PIC X         VALUE 'N'.         
               88  THIS-IS-COMP-BREAK                VALUE 'Y'.         
           05  WS-MORE-DATA-SW         PIC X         VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-START-REPORT         PIC X         VALUE 'N'.         
               88  REPORT-STARTED                    VALUE 'Y'.         
           05  WS-RPT1-EXIST           PIC X         VALUE 'N'.         
               88  REPORT-1-DOES-NOT-EXIST           VALUE 'N'.         
           05  WS-RETRIEVE-DISTRICT    PIC X         VALUE 'Y'.         
               88  MUST-GET-DISTRICT                 VALUE 'Y'.         
           05  WS-RETRIEVE-LOC-OFFICE  PIC X         VALUE 'Y'.         
               88  MUST-GET-LOCAL-OFFICE             VALUE 'Y'.         
           05  WS-LEADING-ZERO-SW      PIC X         VALUE 'N'.         
               88  NON-LEADING-ZERO-IS-FOUND         VALUE 'Y'.         
           05  WS-DATABASE             PIC  9       VALUE ZERO.         
               88  CSR-DATABASE                     VALUE 1.            
               88  SEB-DATABASE                     VALUE 2.            
      *                                                                         
       01  WS-NO-DATA-SW               PIC X   VALUE 'N'.               
       01  WS-SAME-SW                  PIC X   VALUE 'N'.               
       01  WS-SAVE-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.      
      *                                                                         
       01  WS-GENERAL-VARIABLES.                                        
           05  WS-RPT1-CNTR            PIC 9(7) COMP-3 VALUE ZERO.      
           05  WS-RPT1-PREV-LOC-OFFICE PIC X(3)     VALUE SPACES.       
           05  WS-RPT1-PREV-RESP-AREA  PIC X(3)     VALUE SPACES.       
           05  WS-ROUTINE-CTR          PIC 9(7)     COMP-3 VALUE 0.     
           05  WS-FIRST-DGT-POSITION   PIC 9(7)     COMP-3 VALUE 0.     
           05  WS-DISPLAY-RC           PIC S9(4)    COMP   VALUE 0.     
           05  WS-UPDATE-LAST-RUN-DATE PIC X(10)    VALUE SPACES.       
COB305     05 WS-AMT-DEPOSIT        PIC S9(9)V99 COMP-3 VALUE 0.             
           05  WS-BOND-TOTAL-AMT       PIC S9(9)V99 COMP-3 VALUE +0.    
COB305     05 WS-AMT-NOTICE-G        PIC S9(9)V99 COMP-3 VALUE 0.             
COB305     05 WS-AMT-NOTICE-D        PIC S9(9)V99 COMP-3 VALUE 0.             
           05  WS-TIMESTAMP-G          PIC X(10)    VALUE SPACES.       
           05  WS-TIMESTAMP-D          PIC X(10)    VALUE SPACES.       
           05  WS-DEPOSIT-AMT-NULL     PIC S9(4)    COMP VALUE +0.      
           05  WS-BOND-TOTAL-AMT-NULL  PIC S9(4)    COMP VALUE +0.      
COB305     05 WS-PAST-DUE-AMT        PIC S9(9)V99 COMP-3 VALUE 0.             
           05  WS-FCA331-STATUS        PIC X(02).                       
               88  FCA331-SUCCESSFUL   VALUE '00'.                      
           05  WS-DATE-BILL-DAY-00-NULL  PIC S9(4) COMP VALUE +0.       
           05  WS-DATE-BILL-DAY-30-NULL  PIC S9(4) COMP VALUE +0.       
           05  WS-DATE-BILL-DAY-60-NULL  PIC S9(4) COMP VALUE +0.       
           05  WS-DATE-BILL-DAY-90-NULL  PIC S9(4) COMP VALUE +0.       
      *                                                                         
       01  WS-COMPARE-DATE-X      PIC X(10).                            
       01  WS-COMPARE-DATE-9 REDEFINES WS-COMPARE-DATE-X.               
           05  WS-COMPARE-YEAR    PIC 9(4).                             
           05  FILLER             PIC 9.                                
           05  WS-COMPARE-MONTH   PIC 99.                               
           05  FILLER             PIC 9.                                
           05  WS-COMPARE-DAY     PIC 99.                               
      *                                                                         
       01  WS-COMPARE-PARM-MONTH  PIC 99.                               
       01  WS-COMPARE-CURR-MONTH  PIC 99.                               
      *                                                                         
       01  WS-DATE-CREATED.                                             
           05  WS-DATE-DATE       PIC X(10).                            
RDF910     05  WS-DATE-TIMESTAMP  PIC X(16)  VALUE '-23.59.59.999999'.  
      *                                                                         
RDF910 01  WS-TO-DATE-CREATED     PIC X(26).                            
      *                                                                         
RDF910 01  WS-CUR-DATE-CREATED.                                         
RDF910     05 WS-CUR-DATE-DATE    PIC X(10).                            
RDF910     05 WS-CUR-DATE-TMSTAMP PIC X(16)  VALUE '-23.59.59.999999'.  
      *                                                                         
       01  WS-SOUTHERN-ACCUM.                                           
           05  WS-S-SUM-AR        PIC 9(9)V99  VALUE 0.                 
           05  WS-S-SUM-DNP       PIC 9(9)V99  VALUE 0.                 
           05  WS-S-SUM-CNT       PIC 9(11)    VALUE 0.                 
           05  WS-S-SUM-DEP       PIC 9(9)V99  VALUE 0.                 
      *                                                                         
       01  WS-NORTHERN-ACCUM.                                           
           05  WS-N-SUM-AR        PIC 9(9)V99  VALUE 0.                 
           05  WS-N-SUM-DNP       PIC 9(9)V99  VALUE 0.                 
           05  WS-N-SUM-CNT       PIC 9(11)    VALUE 0.                 
           05  WS-N-SUM-DEP       PIC 9(9)V99  VALUE 0.                 
      *                                                                         
      *  STORE THE INPUT PARM AMOUNTS TO BE ADDED WITH THE                      
      *  ACCUMULATED DAILY AMOUNT AND UPDATED BACK TO THE JOB-PARM              
      *                                                                         
       01  WS-SAVE-PARM-AMOUNTS.                                        
           05  WS-SAVE-S-PARM-AR       PIC 9(9)V99  VALUE 0.            
           05  WS-SAVE-S-PARM-DNP      PIC 9(9)V99  VALUE 0.            
           05  WS-SAVE-S-PARM-CNT      PIC 9(11)    VALUE 0.            
           05  WS-SAVE-S-PARM-DEP      PIC 9(9)V99  VALUE 0.            
           05  WS-SAVE-N-PARM-AR       PIC 9(9)V99  VALUE 0.            
           05  WS-SAVE-N-PARM-DNP      PIC 9(9)V99  VALUE 0.            
           05  WS-SAVE-N-PARM-CNT      PIC 9(11)    VALUE 0.            
           05  WS-SAVE-N-PARM-DEP      PIC 9(9)V99  VALUE 0.            
      *                                                                         
       01  WS-ACCUMULATORS.                                             
           05  WS-RPT1-COMPANY-TOTALS.                                  
               10  WS-COMP-DNP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-AR-AMT      PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-DEP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-MAX-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-COMP-NUM-ACCTS   PIC S9(9)     COMP-3 VALUE +0.   
           05  WS-RPT1-DISTRICT-TOTALS.                                 
               10  WS-DIST-DNP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-AR-AMT      PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-DEP-AMT     PIC S9(11)V99 COMP-3 VALUE +0.   
               10  WS-DIST-MAX-AMT     PIC S9(9)     COMP-3 VALUE +0.   
               10  WS-DIST-NUM-ACCTS   PIC S9(9)     COMP-3 VALUE +0.   
      *                                                                         
       01 WS-COMMON-INFO.                                               
      *                                                                         
           05  WS-DBA-NAME             PIC X(50)  VALUE SPACES.         
           05  WS-NAME-CUST            PIC X(50)  VALUE SPACES.         
           05  WS-SERVICE-ADDR1        PIC X(50)  VALUE SPACES.         
           05  WS-SERVICE-ADDR3        PIC X(50)  VALUE SPACES.         
           05  WS-ARREARS-HIST         PIC X(24)  VALUE SPACES.         
           05  WS-DISCONNECT-HIST      PIC X(24)  VALUE SPACES.         
           05  WS-DATE-UTIL-SVC-STRT   PIC X(10)  VALUE SPACES.         
           05  WS-NO-MONTH             PIC S9(4)  COMP VALUE +0.        
           05  WS-NO-MONTH-STRT        PIC S9(4)  COMP VALUE +0.        
           05  WS-NO-MONTH-END         PIC S9(4)  COMP VALUE +0.        
           05  WS-NULL-DATE-UTL-END    PIC S9(4)  COMP VALUE +0.        
           05  WS-NULL-MAX-AMT         PIC S9(4)  COMP VALUE +0.        
           05  WS-LAST-PYMT-DATE-NULL  PIC S9(4)  COMP VALUE +0.        
           05  WS-HOLD-LOC-OFF-NM      PIC X(22)  VALUE SPACES.         
           05  WS-HOLD-LOC-OFF-CD      PIC X(3)   VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER      *          
      *  WHICH INVOKES THE ABEND ROUTINE                             *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.    *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  WS ABEND WORK AREA                                          *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      *  THIS COPY STATEMENT IS THE WS AREA USED TO REDUCE           *          
      *  EMBEDDED BLANKS.                                            *          
      ****************************************************************          
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      *  THE FOLLOWING COPYBOOK CONTAINS THE VARIABLES AND           *          
      *  SWITCHES NECESSARY TO SUPPORT THE FIELD CENTERING           *          
      *  ROUTINE FOUND IN COMMON PROCEDURE DIVISION CPD00150.        *          
      ****************************************************************          
      *                                                                         
       COPY CWS00150.                                                           
      *                                                                         
      ****************************************************************          
      *  WORKING STORAGE FOR CPD00039                                *          
      ****************************************************************          
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ****************************************************************          
      *  IO AREA FOR PARAMETER INPUT FILE 'A'                        *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  NO COMMENTS FOR THIS COPY                                   *          
      ****************************************************************          
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ****************************************************************          
      *  WORKING STORAGE FOR CPD00074 - CREATE MAIL NAME AND ADDRESS *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00074                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH VARIABLES USED BY CPD00068                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00068                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH CODES DATA PRESENT VALUES                     *          
      ****************************************************************          
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ****************************************************************          
      *  WORKING STORAGE FOR CPD00038                                *          
      *       DO NOT PUT ANYTHING BETWEEN CWS0038                    *          
      *                 AND                                          *          
      *            WS-PARM-LAST-RUN-DATE                             *          
      *                 AND                                          *          
      *            WS-PARM-SUM-TOTAL                                 *          
      *                 AND                                          *          
      *               CWS00114                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  BELOW IS FOR RETRIEVING THE JOB PARMS NEEDED AND IS         *          
      *  A REDEFINES FOR CWS00038 ABOVE.                             *          
      ****************************************************************          
      *                                                                         
       01  WS-PARM-LAST-RUN-DATE REDEFINES WS-INPUT-DATA-BREAKDOWN.     
           05  WS-LAST-RUN-LIT   PIC X(16).                             
           05  WS-LAST-RUN-DATE  PIC X(10).                             
           05  FILLER            PIC X(54).                             
      *                                                                         
       01  WS-PARM-SUM-TOTAL REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-PARM-DIV-LIT   PIC X(8).                              
           05  WS-PARM-AR-LIT    PIC X(7).                              
           05  WS-PARM-SUM-AR    PIC 9(9)V99.                           
           05  WS-PARM-DNP-LIT   PIC X(7).                              
           05  WS-PARM-SUM-DNP   PIC 9(9)V99.                           
           05  WS-PARM-CNT-LIT   PIC X(7).                              
           05  WS-PARM-SUM-CNT   PIC 9(11).                             
           05  WS-PARM-DEP-LIT   PIC X(7).                              
           05  WS-PARM-SUM-DEP   PIC 9(9)V99.                           
      *                                                                         
      ****************************************************************          
      *  CWS00114 WORKING STORAGE TO READ THE JOB PARM TABLE FOR THE *          
      *  REPORT DATE                                                 *          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 99.                          
           05  WS-MM                   PIC 99.                          
           05  WS-SS                   PIC 99.                          
           05  WS-TT                   PIC 99.                          
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC XX.                          
           05  FILLER                  PIC X    VALUE ':'.              
           05  WS-RT-MM                PIC XX.                          
           05  FILLER                  PIC X    VALUE ':'.              
           05  WS-RT-SS                PIC XX.                          
      *                                                                         
       01  WS-SAVE-LAST-RUN-DATE       PIC X(10)  VALUE SPACES.         
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CUR-CENT             PIC 99.                          
           05  WS-CUR-YEAR             PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-CUR-MONTH            PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-CUR-DAY              PIC 99.                          
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CENT             PIC 99.                          
           05  WS-D10-YEAR             PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-D10-MONTH            PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-D10-DAY              PIC 99.                          
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC XX.                          
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-RD-DD                PIC XX.                          
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-RD-YY                PIC XX.                          
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC XX.                          
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-D8-DD                PIC XX.                          
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-D8-YY                PIC XX.                          
      *                                                                         
       01  WS-REV-MTH.                                                  
           05  WS-REV-MM               PIC XX.                          
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-REV-CCYY             PIC X(4).                        
      *                                                                         
       01  WS-HOLD-ITEM-ID             PIC 9(9).                        
       01  WS-REDEF-ITEM-ID REDEFINES WS-HOLD-ITEM-ID.                  
           05  WS-REDEFINED-ITEM-ID    PIC X(9).                        
      *                                                                         
       01  WS-ACCOUNT-NO               PIC S9(13)V  COMP-3 VALUE 0.     
       01  RS-MIN-DEPOSIT-AMT          PIC S9(9)V99 COMP-3 VALUE 0.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X     VALUE 'N'.             
           05  WS-Y                    PIC X     VALUE 'Y'.             
           05  WS-PGRMNAME             PIC X(8)  VALUE 'PCSRP156'.      
           05  PROGRAM-NAME            PIC X(8)  VALUE 'PCSRP156'.      
           05  WS-PGRMNAME-1           PIC X(10) VALUE 'PCSRP156-1'.    
           05  WS-SPC                  PIC X     VALUE ' '.             
           05  WS-1                    PIC 9     VALUE 1.               
           05  WS-2                    PIC 9     VALUE 2.               
           05  WS-3                    PIC 9     VALUE 3.               
           05  WS-42                   PIC 99    VALUE 42.              
           05  WS-46                   PIC 99    VALUE 46.              
           05  WS-50                   PIC 99    VALUE 50.              
           05  WS-60                   PIC 99    VALUE 60.              
           05  WS-62                   PIC 99    VALUE 62.              
           05  WS-I                    PIC 99    VALUE 0.               
           05  WS-NO-LASTRUNDATE       PIC X(3)  VALUE 'END'.           
           05  WS-DEP-REFUND           PIC X     VALUE 'B'.             
      *                                                                         
           05  WS-LIT-ARREARS          PIC X(8)  VALUE 'ARREARS '.      
           05  WS-LIT-BALANCE          PIC X(8)  VALUE 'BALANCE '.      
           05  WS-LIT-EXEMPT           PIC X(8)  VALUE 'EXEMPT  '.      
           05  WS-LIT-NEW              PIC X(8)  VALUE 'NEW     '.      
           05  WS-LIT-NON-UTIL         PIC X(11) VALUE 'NON-UTILITY'.   
           05  WS-LIT-MASTER           PIC X(8)  VALUE 'MASTER  '.      
           05  WS-LIT-SUB              PIC X(8)  VALUE 'SUB ACCT'.      
      *                                                                         
      ****************************************************************          
      ******************* PCSRP156 REPORT HEADERS ********************          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLES         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-TITLE.                                            
               10  FILLER              PIC X     VALUE SPACES.          
               10  P-RPT-TITLE-PGNM    PIC X(8)  VALUE 'PCSR1561'.      
               10  FILLER              PIC X(47) VALUE SPACES.          
               10  PRT-COMPANY-RPT     PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X(28) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN-DATE: '.    
               10  P-RPT-RUN-DATE      PIC X(10).                       
               10  FILLER              PIC X(3)  VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(55) VALUE SPACES.          
               10  P-RPT-HEAD1         PIC X(22) VALUE                  
A05460             '   LIGHT ONLY TASKS   '.                            
               10  FILLER              PIC X(32) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN-TIME: '.    
               10  P-RPT-RUN-TIME      PIC X(10).                       
               10  FILLER              PIC X(3)  VALUE SPACES.          
      *                                                                         
           05  WS-RPT-HEADER-PAGE.                                      
      *                                                                         
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(58)  VALUE SPACES.         
               10  FILLER              PIC X(6)   VALUE 'AS OF '.       
               10  WS-DEFAULT-RPT1-DT  PIC X(8).                        
               10  FILLER              PIC X(37)  VALUE SPACES.         
               10  FILLER              PIC X(6)   VALUE 'PAGE: '.       
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(11)  VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR DISTRICT HEADER           **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-DIST.                                      
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(9)  VALUE 'DISTRICT:'.     
               10  FILLER              PIC XX    VALUE SPACES.          
               10  P-RPT-DIST-NM       PIC X(30).                       
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 1       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-01.                                          
               10  FILLER              PIC X(65) VALUE SPACES.          
               10  FILLER              PIC X(11) VALUE 'ARREARS    '.   
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 2       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-02.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER         PIC X(10) VALUE 'ACCOUNT NO'.         
               10  FILLER         PIC X(18) VALUE SPACES.               
               10  FILLER         PIC X(4)  VALUE 'NAME'.               
               10  FILLER         PIC X(33) VALUE SPACES.               
               10  FILLER         PIC X(11) VALUE 'NORMAL     '.        
               10  FILLER         PIC X(19) VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'CREDIT GROUP'.       
      *                                                                         
      ****************************************************************          
      **    COMMON WORKING STORAGE FOR REPORT 1     HEADER 3        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-03.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER         PIC X(12) VALUE 'LOCAL OFFICE'.       
               10  FILLER         PIC X(16) VALUE SPACES.               
               10  FILLER         PIC X(7)  VALUE 'ADDRESS'.            
               10  FILLER         PIC X(30) VALUE SPACES.               
               10  FILLER         PIC X(11) VALUE 'DEP AMT/MAX'.        
               10  FILLER         PIC X(19) VALUE SPACES.               
               10  FILLER         PIC X(13) VALUE 'LAST PYMT AMT'.      
               10  FILLER         PIC X(5)  VALUE SPACES.               
               10  FILLER         PIC X(16) VALUE 'TOTAL AR BALANCE'.   
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     HEADER 4       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HDR-04.                                          
               10  FILLER         PIC X     VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'ACCOUNT TYPE'.       
               10  FILLER         PIC X(16) VALUE SPACES.               
               10  FILLER         PIC X(3)  VALUE 'DBA'.                
               10  FILLER         PIC X(34) VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'TURN-ON DATE'.       
               10  FILLER         PIC X(18) VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'LAST PYMT DT'.       
               10  FILLER         PIC X(6)  VALUE SPACES.               
               10  FILLER         PIC X(18) VALUE 'DNP AMOUNT        '. 
      *                                                                         
      ****************************************************************          
      **********************PCSRP156 REPORT DETAILS*******************          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
      ****************************************************************          
      **     COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 1  **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-101.                                      
               10  FILLER              PIC X     VALUE SPACES.          
               10  P1-ACCOUNT-NO       PIC 9(13).                       
               10  FILLER              PIC X(15)  VALUE SPACES.         
               10  P1-FULL-NAME        PIC X(33).                       
               10  FILLER              PIC X(4)   VALUE SPACES.         
               10  P1-ARREARS-HISTORY  PIC X(12).                       
               10  FILLER              PIC X(18)  VALUE SPACES.         
               10  P1-CREDIT-GRP       PIC X(11).                       
               10  FILLER              PIC X(11)  VALUE SPACES.         
               10  P1-AR-BAL           PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 2    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-102.                                      
               10  FILLER              PIC X     VALUE SPACES.          
               10  P1-LOC-OFF-CD       PIC X(3).                        
               10  FILLER              PIC X      VALUE '-'.            
               10  P1-LOC-OFF-NM       PIC X(22).                       
               10  FILLER              PIC XX     VALUE SPACES.         
               10  P1-SERVICE-ADDR01   PIC X(33).                       
               10  FILLER              PIC X(4)   VALUE SPACES.         
               10  P1-NORMAL-HISTORY   PIC X(12).                       
               10  FILLER              PIC X(16)  VALUE SPACES.         
               10  P1-LAST-PYMNT-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(10)  VALUE SPACES.         
               10  P1-PAST-DUE         PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 3    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-103.                                      
               10  FILLER         PIC X     VALUE SPACES.               
               10  P1-ACCT-TYPE        PIC X(19)  VALUE SPACES.         
               10  FILLER              PIC X(9)   VALUE SPACES.         
               10  P1-SERVICE-ADDR03   PIC X(33).                       
               10  FILLER              PIC X(4)   VALUE SPACES.         
               10  P1-DEP-AMT          PIC $,$$$,$$9.99.                
               10  FILLER              PIC X      VALUE '/'.            
               10  P1-DEP-AMT-MAX      PIC $,$$$,$$9.99.                
               10  FILLER              PIC X(9)   VALUE SPACES.         
               10  P1-LAST-PYMT-DATE   PIC X(8).                        
      *                                                                         
      ****************************************************************          
      **   COMMON WORKING STORAGE FOR REPORT 1     DETAIL LINE 4    **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-104.                                      
               10  FILLER              PIC X(28)  VALUE SPACES.         
               10  P1-DBA-NAME         PIC X(33)  VALUE SPACES.         
               10  FILLER              PIC X(4)   VALUE SPACES.         
               10  P1-ON-DATE          PIC X(8).                        
      *                                                                         
      ****************************************************************          
      **                PCSRP156 REPORT TOTAL LINES                 **          
      ****************************************************************          
      *                                                                         
       01  WS-TOTAL-LINES.                                              
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT101.                                          
               10  FILLER         PIC X     VALUE SPACES.               
               10  FILLER               PIC X(23)                       
                           VALUE 'TOTAL AR AMT         - '.             
               10  P101-DIST-NM         PIC X(30)  VALUE SPACES.        
               10  FILLER               PIC X      VALUE SPACES.        
               10  FILLER               PIC X(10)  VALUE 'DISTRICT: '.  
               10  P101-DIST-AR-AMOUNT  PIC $$$,$$$,$$9.99.             
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT101A.                                         
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)     VALUE              
                                'TOTAL DNP AMT        - '.              
               10  P101A-DIST-NM          PIC X(30)  VALUE SPACES.      
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE              
                                                 'DISTRICT: '.          
               10  P101A-DIST-DNP-AMOUNT    PIC $$$,$$$,$$9.99.         
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 2, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT102.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)     VALUE              
                                'TOTAL NUMBER         - '.              
               10  P102-DIST-NM        PIC X(30)     VALUE SPACES.      
               10  FILLER              PIC X         VALUE SPACES.      
               10  FILLER              PIC X(13)     VALUE              
                                                 'DISTRICT: '.          
               10  P102-DIST-NUM-ACCTS   PIC ZZZZZZZZZZ9 VALUE SPACES.  
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR DIST. TOTAL, LINE 3, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-DIST-TOT103.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)   VALUE                
                                'TOTAL DEPOSIT AMOUNT - '.              
               10  P103-DIST-NM        PIC X(30)   VALUE SPACES.        
               10  FILLER              PIC X       VALUE SPACES.        
               10  FILLER              PIC X(10)   VALUE                
                                                 'DISTRICT: '.          
               10  P103-DIST-DEP-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(3)    VALUE SPACES.        
               10  FILLER              PIC X(28)   VALUE                
                                'OF TOTAL MAX DEPOSIT AMOUNT:'.         
               10  P103-DIST-MAX-AMT   PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 1, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT101.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)  VALUE                 
                                'TOTAL AR AMT         - '.              
               10  FILLER              PIC X(20)  VALUE                 
                                'S C ELECTRIC & GAS: '.                 
               10  P101-COMP-AR-AMOUNT    PIC $$$,$$$,$$9.99.           
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 1A, RPT 1    **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT101A.                                         
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)  VALUE                 
                                'TOTAL DNP AMT        - '.              
               10  FILLER              PIC X(20)  VALUE                 
                                'S C ELECTRIC & GAS: '.                 
               10  P101A-COMP-DNP-AMOUNT    PIC $$$,$$$,$$9.99.         
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 2, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT102.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)   VALUE                
                                'TOTAL NUMBER         - '.              
               10  FILLER                PIC X(23) VALUE                
                                           'S C ELECTRIC & GAS:    '.   
               10  P102-COMP-NUM-ACCTS   PIC ZZZZZZZZZZ9 VALUE SPACES.  
      *                                                                         
      ****************************************************************          
      **  COMMON WORKING STORAGE FOR COMP. TOTAL, LINE 3, RPT 1     **          
      ****************************************************************          
      *                                                                         
           05  WS-COMP-TOT103.                                          
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(23)  VALUE                 
                                'TOTAL DEPOSIT AMOUNT - '.              
               10  FILLER              PIC X(20)  VALUE                 
                                 'S C ELECTRIC & GAS: '.                
               10  P103-COMP-DEP-AMT   PIC $$$,$$$,$$9.99.              
               10  FILLER              PIC X(3)   VALUE SPACES.         
               10  FILLER              PIC X(29)  VALUE                 
                                'OF TOTAL MAX DEPOSIT AMOUNT: '.        
               10  P103-COMP-MAX-AMT   PIC $$$,$$$,$$9.99.              
      *                                                                         
      ****************************************************************          
      **  MONTHLY SUMMARY TOTAL PRINT LINE.                         **          
      ****************************************************************          
      *                                                                         
           05  PRT-SUMMARY-PRINT-LINE.                                  
               10  FILLER         PIC X(3)  VALUE SPACES.               
               10  PRT-LITERAL    PIC X(9)  VALUE SPACES.               
               10  FILLER         PIC X(3)  VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'TOTAL AR =  '.       
               10  PRT-SUM-AR     PIC $$$,$$$,$$9.99.                   
               10  FILLER         PIC X(3)  VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'TOTAL DNP = '.       
               10  PRT-SUM-DNP    PIC $$$,$$$,$$9.99.                   
               10  FILLER         PIC X(3)  VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'TOTAL CNT = '.       
               10  PRT-SUM-CNT    PIC ZZZ,ZZZ,ZZZ.                      
               10  FILLER         PIC X(3)  VALUE SPACES.               
               10  FILLER         PIC X(12) VALUE 'TOTAL DEP = '.       
               10  PRT-SUM-DEP    PIC $$$,$$$,$$9.99.                   
               10  FILLER         PIC X(7)  VALUE SPACES.               
      *                                                                         
      ****************************************************************          
      **      MONTHLY SUMMARY REPORT HEADER                          *          
      ****************************************************************          
      *                                                                         
       01 PRT-MONTHLY-SUMMARY-HDR1.                                     
               10  FILLER              PIC X     VALUE SPACES.          
               10  PRT-PROGRAM-HDR1    PIC X(8)  VALUE 'PCSR1562'.      
               10  FILLER              PIC X(43) VALUE SPACES.          
               10  PRT-COMPANY-HDR1    PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X(32) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN-DATE: '.    
               10  PRT-DATE-HDR1       PIC X(10).                       
               10  FILLER              PIC X(3)  VALUE SPACES.          
      *                                                                         
       01 PRT-MONTHLY-SUMMARY-HDR2.                                     
               10  FILLER              PIC X(46) VALUE SPACES.          
               10  FILLER              PIC X(40) VALUE                  
A05460             '   MONTHLY SUMMARY - LIGHT ONLY TASKS   '.          
               10  FILLER              PIC X(23) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN-TIME: '.    
               10  PRT-TIME-HDR2       PIC X(10).                       
               10  FILLER              PIC X(3)  VALUE SPACES.          
      *                                                                         
       01  WS-PRINT-FUNCTION.                                           
           05  P-OUTPUT-LINE           PIC X(132)    VALUE SPACES.      
           05  WS-LINE                 PIC X(132)    VALUE ALL '-'.     
           05  WS-BLANK-LINE           PIC X(132)    VALUE SPACES.      
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                          '** NO DATA THIS RUN **'.     
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                            '*** END OF REPORT ***'.    
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-PRINT-CONTROL.                                            
           05  WS-RPT1-LINE-NO         PIC 99    COMP-3  VALUE 62.      
           05  WS-RPT1-PAGE-NO         PIC 99    COMP-3  VALUE ZERO.    
           05  WS-SKIP-LINES-NUM       PIC 99            VALUE ZERO.    
      *                                                                         
       01  WS-ERROR-VARIABLES.                                          
           05  RS-RETURN-CODE          PIC S9(4) COMP.                  
           05  RS-RETURN-CODE-DISP     PIC +Z(4).                       
           05  WS-DISP-RETURN-CODE     PIC +Z(4).                       
      *                                                                         
      ****************************************************************          
      *  SQLCA                                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_LOCAL_OFFICE                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_ACCOUNT                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_NAME_ACCT_XREF                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_WQ_ITEMS                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_RESP_AREA                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRSAREA                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_CUST_PREM_HIST                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_ACCT_MISC_INFO                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_JOB_PARM                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_NAME                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_ADDR_FORMATTED                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_ADDR_FREEFORM                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_ZIP_CODE                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_CREDIT_PROFILE                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_CUST_ADDR_XREF                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_DELINQUENCY                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_UTIL_ENVRNMT                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  TABLE DECLARATION FOR CSS_RATE_CREATOR                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_REG_PROFILE                                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_COMPANY                                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  WORKING STORAGE FOR CPD00308                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CURSOR DECLARATION FOR WQ FOR LIGHT ONLY WQS                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
              DECLARE WQ_CSR CURSOR FOR                                 
              SELECT  AT.ACCOUNT_NO                                     
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.ADDRESS_ID                                     
                     ,AT.LAST_PYMT_AMOUNT                               
                     ,AT.LAST_PYMT_DATE                                 
                     ,AT.BILL_CYCLE                                     
                     ,AT.CREDIT_GROUP                                   
                     ,AT.TOTAL_AR_BALANCE                               
                     ,WQ.RESP_AREA_ID                                   
                     ,UT.CODE_UTIL_TYPE                                 
                     ,AT.ACCOUNT_TYPE_CODE                              
                     ,AT.COMPANY_NO                                     
                     ,AT.CODES_DATA_PRESENT                             
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.DATE_BILL_DAY_30                               
                     ,AT.DATE_BILL_DAY_60                               
                     ,AT.DATE_BILL_DAY_90                               
                     ,AT.CODE_DISC_OK                                   
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.NOTICE_EXEMPT_CD                               
              FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                     
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
              WHERE   AT.COMPANY_NO = '01'                              
                AND   AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                AND   AT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                AND   WQ.CATEGORY_ID  = 135                             
                AND   WQ.STATUS  IN ('A', 'C', 'I')                     
A03967          AND   ((UT.CODE_UTIL_TYPE = 'U')                        
A03967             OR   (UT.CODE_UTIL_TYPE = 'E'                        
A03967                AND UT.RATE_PLAN_NO = '029'))                     
                AND   WQ.DATE_CREATED  > CIS.CHAR2TIMESTAMP(
                                                       :WQ-DATE-CREATED
              )               
RDF910          AND   WQ.DATE_CREATED  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-TO-DATE-CREATED
              )           
              ORDER BY                                                  
                  WQ.RESP_AREA_ID,                                      
                  AT.TOTAL_AR_BALANCE DESC                              
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CSR CURSOR FOR                                         
MFA-TR*       SELECT  AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.LAST_PYMT_AMOUNT                                       
MFA-TR*              ,AT.LAST_PYMT_DATE                                         
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,WQ.RESP_AREA_ID                                           
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.DATE_BILL_DAY_00                               15025580
MFA-TR*              ,AT.DATE_BILL_DAY_30                               15025590
MFA-TR*              ,AT.DATE_BILL_DAY_60                               15025600
MFA-TR*              ,AT.DATE_BILL_DAY_90                               15025700
MFA-TR*              ,AT.CODE_DISC_OK                                   15025900
MFA-TR*              ,AT.CODE_ACCT_STAT                                 15026800
MFA-TR*              ,AT.NOTICE_EXEMPT_CD                               15027700
MFA-TR*       FROM    CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_WQ_ITEMS WQ                                           
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*       WHERE   AT.COMPANY_NO = '01'                                      
MFA-TR*         AND   AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         AND   AT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*         AND   WQ.CATEGORY_ID  = 135                                     
MFA-TR*         AND   WQ.STATUS  IN ('A', 'C', 'I')                             
MFA-TR*         AND   ((UT.CODE_UTIL_TYPE = 'U')                                
MFA-TR*            OR   (UT.CODE_UTIL_TYPE = 'E'                                
MFA-TR*               AND UT.RATE_PLAN_NO = '029'))                             
MFA-TR*         AND   WQ.DATE_CREATED  > :WQ-DATE-CREATED                       
MFA-TR*         AND   WQ.DATE_CREATED  <= :WS-TO-DATE-CREATED                   
MFA-TR*       ORDER BY                                                          
MFA-TR*           WQ.RESP_AREA_ID,                                              
MFA-TR*           AT.TOTAL_AR_BALANCE DESC                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1100-PRODUCE-REPORT-1 THRU 1100-EXIT                 
             UNTIL NO-MORE-DATA.                                        
      *                                                                         
           IF REPORT-STARTED                                            
               PERFORM 7002-CLOSE-WQ-CSR THRU 7002-EXIT                 
           END-IF.                                                      
      *                                                                         
           PERFORM 9500-CLEANUP THRU 9500-EXIT.                         
      *                                                                         
      ** THE LAST RUN DATE IS COMPARED TO CURRENT RUN DATE TO BE ABLE           
      ** TO DETERMINE WHEN TO DO THE MONTHLY SUMMARY AND CLEAR THE              
      ** ROLLING ACCUMULATOR.                                                   
      *                                                                         
           MOVE SPACES                  TO WS-PARM-LAST-RUN-DATE.       
           MOVE 'LAST RUN DATE = '      TO WS-LAST-RUN-LIT.             
           MOVE WS-UPDATE-LAST-RUN-DATE TO WS-LAST-RUN-DATE.            
           MOVE WS-PARM-LAST-RUN-DATE   TO G6-PARM-DATA.                
           MOVE WS-PGRMNAME TO G6-PROGRAM-NAME.                         
           MOVE 'DATE'      TO G6-CMND-CODE.                            
      *                                                                         
           PERFORM 8200-UPDATE-LAST-RUN-DATE THRU 8200-EXIT.            
      *                                                                         
           PERFORM 2900-LOAD-JOB-PARM THRU 2900-EXIT.                   
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH TO WS-RT-HH.                                      
           MOVE WS-MM TO WS-RT-MM.                                      
           MOVE WS-SS TO WS-RT-SS.                                      
           MOVE WS-RUN-TIME TO P-RPT-RUN-TIME                           
                               PRT-TIME-HDR2.                           
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           MOVE WS-INPUT-DATE TO WS-CURRENT-DATE.                       
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-CURRENT-DATE              
           END-IF.                                                      
      *                                                                         
RDF910     MOVE WS-CURRENT-DATE TO WS-CUR-DATE-DATE.                    
RDF910     MOVE WS-CUR-DATE-CREATED TO WS-TO-DATE-CREATED.              
      *                                                                         
           MOVE WS-CUR-YEAR  TO WS-RD-YY.                               
           MOVE WS-CUR-MONTH TO WS-RD-MM.                               
           MOVE WS-CUR-DAY   TO WS-RD-DD.                               
      *                                                                         
           MOVE WS-CURRENT-DATE TO P-RPT-RUN-DATE                       
                                   PRT-DATE-HDR1.                       
      *                                                                         
           MOVE WS-CUR-MONTH TO WS-D8-MM.                               
           MOVE WS-CUR-DAY   TO WS-D8-DD.                               
           MOVE WS-CUR-YEAR  TO WS-D8-YY.                               
           MOVE WS-DATE-8    TO WS-DEFAULT-RPT1-DT.                     
                                                                        
           OPEN OUTPUT FCSPT331-FILE                                    
                       FCSPT33-FILE.                                    
      *                                                                         
           MOVE ZEROS TO WS-PARM-SUM-AR                                 
                         WS-PARM-SUM-DNP                                
                         WS-PARM-SUM-CNT                                
                         WS-PARM-SUM-DEP.                               
      *                                                                         
      *  GET LAST RUN DATE FROM JOB_PARM                                        
      *  THIS IS USED TO DETERMINE WHEN TO DO MONTHLY TOTALS AND                
      *  WHEN TO RESET THE MONTHLY ACCUMULATION TO ZEROS.                       
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE 'DATE'      TO WS-COMMAND.                              
           MOVE 0           TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-LAST-RUN-LIT = 'LAST RUN DATE = '              
                  AND INPUT-ACTIVE) OR END-OF-SYSIPT.                   
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ABENDING PROGRAM                   **'        
              DISPLAY '** PCSRP156                           **'        
              DISPLAY '** LAST RUN DATE NOT ACTIVE           **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE WS-LAST-RUN-DATE TO WS-SAVE-LAST-RUN-DATE            
           END-IF.                                                      
      *                                                                         
           IF WS-CURRENT-DATE > WS-LAST-RUN-DATE                        
              MOVE WS-CURRENT-DATE TO WS-UPDATE-LAST-RUN-DATE           
              DISPLAY '******************************************'      
              DISPLAY '* JOB PARM LAST RUN DATE   = ' WS-LAST-RUN-DATE  
              DISPLAY '* CURRENT DATE - NEXT PARM = ' WS-CURRENT-DATE   
              DISPLAY '******************************************'      
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '*       PCSRP156 PROCESSING ERROR        *'      
              DISPLAY '*  CURRENT RUN DATE EQUAL TO OR BEFORE   *'      
              DISPLAY '*  LAST RUN DATE - PROCESSING TERMINATED *'      
              DISPLAY '*  LAST RUN DATE = ' WS-LAST-RUN-DATE            
              DISPLAY '*  CURRENT DATE  = ' WS-CURRENT-DATE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
      *  GET PARM RUNNING DAILY TOTALS FOR SOUTHERN DIVISION                    
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE 0           TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-PARM-DIV-LIT = 'SOUTHERN' AND INPUT-ACTIVE)    
                  OR  END-OF-SYSIPT.                                    
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ABENDING PROGRAM                   **'        
              DISPLAY '** PCSRP156                           **'        
              DISPLAY '** SOUTHERN PARM NOT ACTIVE           **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '** BEGINNING SOUTHERN PARM TOTALS     **'        
              DISPLAY '** WS-PARM-SUM-AR  = ' WS-PARM-SUM-AR            
              DISPLAY '** WS-PARM-SUM-DNP = ' WS-PARM-SUM-DNP           
              DISPLAY '** WS-PARM-SUM-CNT = ' WS-PARM-SUM-CNT           
              DISPLAY '** WS-PARM-SUM-DEP = ' WS-PARM-SUM-DEP           
              DISPLAY '****************************************'        
              MOVE WS-PARM-SUM-AR  TO WS-SAVE-S-PARM-AR                 
              MOVE WS-PARM-SUM-DNP TO WS-SAVE-S-PARM-DNP                
              MOVE WS-PARM-SUM-CNT TO WS-SAVE-S-PARM-CNT                
              MOVE WS-PARM-SUM-DEP TO WS-SAVE-S-PARM-DEP                
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
      *  GET PARM RUNNING DAILY TOTALS FOR NORTHERN DIVISION                    
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE 0           TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-PARM-DIV-LIT = 'NORTHERN' AND INPUT-ACTIVE)    
                  OR  END-OF-SYSIPT.                                    
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ABENDING PROGRAM                   **'        
              DISPLAY '** PCSRP156                           **'        
              DISPLAY '** NORTHERN PARM NOT ACTIVE           **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              DISPLAY '    '                                            
              DISPLAY '****************************************'        
              DISPLAY '** BEGINNING NORTHERN PARM TOTALS     **'        
              DISPLAY '** WS-PARM-SUM-AR  = ' WS-PARM-SUM-AR            
              DISPLAY '** WS-PARM-SUM-DNP = ' WS-PARM-SUM-DNP           
              DISPLAY '** WS-PARM-SUM-CNT = ' WS-PARM-SUM-CNT           
              DISPLAY '** WS-PARM-SUM-DEP = ' WS-PARM-SUM-DEP           
              DISPLAY '****************************************'        
              MOVE WS-PARM-SUM-AR  TO WS-SAVE-N-PARM-AR                 
              MOVE WS-PARM-SUM-DNP TO WS-SAVE-N-PARM-DNP                
              MOVE WS-PARM-SUM-CNT TO WS-SAVE-N-PARM-CNT                
              MOVE WS-PARM-SUM-DEP TO WS-SAVE-N-PARM-DEP                
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC THRU 1000-EXIT.               
      *                                                                         
RDF910     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-COMPANY-NO TO C7-COMPANY-NO                       
              PERFORM 7500-GET-COMPANY-NAME THRU 7500-EXIT              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE C7-COMPANY-NAME  TO PRT-COMPANY-RPT               
                                          PRT-COMPANY-HDR1              
              END-IF                                                    
              PERFORM 0900-CHECK-NEW-MONTH THRU 0900-EXIT               
              PERFORM 1200-FORMAT-HOLD-FIELDS THRU 1200-EXIT            
              PERFORM 0200-INIT-RPT1-ACCUMS THRU 0200-EXIT              
RDF910     ELSE                                                         
RDF910        MOVE '01' TO C7-COMPANY-NO                                
RDF910        PERFORM 7500-GET-COMPANY-NAME THRU 7500-EXIT              
RDF910        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
RDF910           MOVE C7-COMPANY-NAME  TO PRT-COMPANY-RPT               
RDF910                                    PRT-COMPANY-HDR1              
RDF910        END-IF                                                    
RDF910        PERFORM 0900-CHECK-NEW-MONTH THRU 0900-EXIT               
RDF910     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    INITIALIZE THE DIST REPORT ACCUMULATORS                 **          
      ****************************************************************          
      *                                                                         
       0200-INIT-RPT1-ACCUMS.                                           
      *                                                                         
           MOVE ZEROES TO WS-DIST-AR-AMT                                
                          WS-DIST-DNP-AMT                               
                          WS-DIST-DEP-AMT                               
                          WS-DIST-MAX-AMT                               
                          WS-DIST-NUM-ACCTS.                            
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    INITIALIZE THE COMP REPORT ACCUMULATORS                 **          
      ****************************************************************          
      *                                                                         
       0400-INIT-RPT1-ACCUMS.                                           
      *                                                                         
           MOVE ZEROES TO WS-COMP-AR-AMT                                
                          WS-COMP-DNP-AMT                               
                          WS-COMP-DEP-AMT                               
                          WS-COMP-MAX-AMT                               
                          WS-COMP-NUM-ACCTS.                            
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CHECK FOR NEW MONTH.  IF SO, DO SUMMARY AND RESET           *          
      *  ACCUMULATORS.                                               *          
      ****************************************************************          
      *                                                                         
       0900-CHECK-NEW-MONTH.                                            
      *                                                                         
           MOVE WS-SAVE-LAST-RUN-DATE TO WS-COMPARE-DATE-X.             
           MOVE WS-COMPARE-MONTH      TO WS-COMPARE-PARM-MONTH.         
           MOVE WS-CURRENT-DATE       TO WS-COMPARE-DATE-X.             
           MOVE WS-COMPARE-MONTH      TO WS-COMPARE-CURR-MONTH.         
      *                                                                         
           IF WS-COMPARE-CURR-MONTH = WS-COMPARE-PARM-MONTH             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PARM TOTALS BEFORE MONTHLY SUMMARY REPORT *'   
              DISPLAY '* SOUTHERN PARM AR  = ' WS-SAVE-S-PARM-AR        
              DISPLAY '* SOUTHERN PARM DNP = ' WS-SAVE-S-PARM-DNP       
              DISPLAY '* SOUTHERN PARM CNT = ' WS-SAVE-S-PARM-CNT       
              DISPLAY '* SOUTHERN PARM DEP = ' WS-SAVE-S-PARM-DEP       
              DISPLAY '* NORTHERN PARM AR  = ' WS-SAVE-N-PARM-AR        
              DISPLAY '* NORTHERN PARM DNP = ' WS-SAVE-N-PARM-DNP       
              DISPLAY '* NORTHERN PARM CNT = ' WS-SAVE-N-PARM-CNT       
              DISPLAY '* NORTHERN PARM DEP = ' WS-SAVE-N-PARM-DEP       
              DISPLAY '**********************************************'  
      *                                                                         
              PERFORM 1300-MONTHLY-SUMMARY THRU 1300-EXIT               
           END-IF.                                                      
      *                                                                         
       0900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  BEGIN -  OPEN CURSOR AND DO FIRST FETCH                   **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE WS-SAVE-LAST-RUN-DATE TO WS-DATE-DATE.                  
           MOVE WS-DATE-CREATED TO WQ-DATE-CREATED.                     
      *                                                                         
           PERFORM 7000-OPEN-WQ-CSR THRU 7000-EXIT.                     
      *                                                                         
           MOVE 'N' TO WS-SAME-SW.                                      
           PERFORM 7001-FETCH-WQ-CSR THRU 7001-EXIT.                    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORT-1.                                           
      *                                                                         
           IF REPORT-STARTED                                            
               PERFORM 2800-PRODUCE-RPT THRU 2800-EXIT                  
           ELSE                                                         
               MOVE WS-Y             TO WS-START-REPORT                 
               PERFORM 2800-PRODUCE-RPT THRU 2800-EXIT                  
           END-IF.                                                      
      *                                                                         
           MOVE 'Y' TO WS-SAME-SW.                                      
      *                                                                         
           PERFORM 7001-FETCH-WQ-CSR THRU 7001-EXIT                     
              UNTIL WS-SAME-SW = 'N'.                                   
      *                                                                         
           INITIALIZE WS-COMMON-INFO.                                   
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   SET PREVIOUS LOCAL OFFICE                                **          
      ****************************************************************          
      *                                                                         
       1200-FORMAT-HOLD-FIELDS.                                         
      *                                                                         
           MOVE AT-LOCAL-OFFICE TO WS-RPT1-PREV-LOC-OFFICE.             
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   SUMMARY TOTAL REPORT PREPARATION                         **          
      ****************************************************************          
      *                                                                         
       1300-MONTHLY-SUMMARY.                                            
      *                                                                         
           PERFORM 8800-PRINT-MONTHLY-HEADER THRU 8800-EXIT.            
      *                                                                         
           MOVE 'SOUTHERN'         TO PRT-LITERAL.                      
           MOVE WS-SAVE-S-PARM-AR  TO PRT-SUM-AR.                       
           MOVE WS-SAVE-S-PARM-DNP TO PRT-SUM-DNP.                      
           MOVE WS-SAVE-S-PARM-CNT TO PRT-SUM-CNT.                      
           MOVE WS-SAVE-S-PARM-DEP TO PRT-SUM-DEP.                      
      *                                                                         
           PERFORM 8700-PRINT-MONTHLY-REPORT THRU 8700-EXIT.            
      *                                                                         
           MOVE 'NORTHERN'         TO PRT-LITERAL.                      
           MOVE WS-SAVE-N-PARM-AR  TO PRT-SUM-AR.                       
           MOVE WS-SAVE-N-PARM-DNP TO PRT-SUM-DNP.                      
           MOVE WS-SAVE-N-PARM-CNT TO PRT-SUM-CNT.                      
           MOVE WS-SAVE-N-PARM-DEP TO PRT-SUM-DEP.                      
      *                                                                         
           PERFORM 8700-PRINT-MONTHLY-REPORT THRU 8700-EXIT.            
      *                                                                         
           MOVE 'COMPANY '         TO PRT-LITERAL.                      
           ADD WS-SAVE-S-PARM-AR   TO WS-SAVE-N-PARM-AR .               
           ADD WS-SAVE-S-PARM-DNP  TO WS-SAVE-N-PARM-DNP.               
           ADD WS-SAVE-S-PARM-CNT  TO WS-SAVE-N-PARM-CNT.               
           ADD WS-SAVE-S-PARM-DEP  TO WS-SAVE-N-PARM-DEP.               
           MOVE WS-SAVE-N-PARM-AR  TO PRT-SUM-AR.                       
           MOVE WS-SAVE-N-PARM-DNP TO PRT-SUM-DNP.                      
           MOVE WS-SAVE-N-PARM-CNT TO PRT-SUM-CNT.                      
           MOVE WS-SAVE-N-PARM-DEP TO PRT-SUM-DEP.                      
      *                                                                         
           PERFORM 8700-PRINT-MONTHLY-REPORT THRU 8700-EXIT.            
      *                                                                         
           MOVE ZERO TO WS-SAVE-S-PARM-AR.                              
           MOVE ZERO TO WS-SAVE-S-PARM-DNP.                             
           MOVE ZERO TO WS-SAVE-S-PARM-CNT.                             
           MOVE ZERO TO WS-SAVE-S-PARM-DEP.                             
           MOVE ZERO TO WS-SAVE-N-PARM-AR.                              
           MOVE ZERO TO WS-SAVE-N-PARM-DNP.                             
           MOVE ZERO TO WS-SAVE-N-PARM-CNT.                             
           MOVE ZERO TO WS-SAVE-N-PARM-DEP.                             
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01181000
      ****************************************************************  06721000
      *   UTILIZATION OF CPD00068 FUNCTIONALITY TO CALCULATE ARREARS,*  06723100
      *   BALANCE DUE, PAST DUE AMOUNT AND DNP BALANCE               *  06723200
      ****************************************************************  06724000
      *                                                                 01181000
       1700-CALL-CPD00068.                                              
      *                                                                 06780000
           MOVE 'Y' TO CALC-PAST-DUE-SW                                 
                       CALC-ARREARS-SW                                  
                       CALC-BALANCE-SW.                                 
      *                                                                 06780000
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE WS-CURRENT-DATE       TO WS-HOLD-DATE.                  
           MOVE PROGRAM-NAME          TO WS-CPD00068-CALLING-PGM.       
      *                                                                 06860000
           MOVE SPACES TO  ABEND-FUNCTION.                              
           CALL SCSCB068  USING   CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
      *                                                                 06860000
           MOVE RS-RETURN-CODE TO  WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07598400
      ****************************************************************          
      **       BUILDS THE DETAIL PRINT LINE FOR BOTH WRITE OFF AMTS **          
      **       AND ACCUMULATES AMOUNTS FOR CONTROL BREAKS.          **          
      ****************************************************************          
      *                                                                         
       2050-BUILD-DETAIL-RPT1.                                          
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  1                   **          
      ****************************************************************          
      *                                                                         
           MOVE AT-ACCOUNT-NO TO P1-ACCOUNT-NO.                         
           MOVE WS-NAME-CUST  TO P1-FULL-NAME.                          
      *                                                                         
           IF AT-ACCOUNT-TYPE-CODE = 'R'                                
             MOVE 'RESIDENTIAL' TO P1-ACCT-TYPE                         
           ELSE                                                         
             IF AT-ACCOUNT-TYPE-CODE = 'C'                              
               MOVE 'COMMERCIAL' TO P1-ACCT-TYPE                        
             ELSE                                                       
               IF AT-ACCOUNT-TYPE-CODE = 'I'                            
                 MOVE 'INDUSTRIAL' TO P1-ACCT-TYPE                      
               ELSE                                                     
                 IF AT-ACCOUNT-TYPE-CODE = 'B'                          
                   MOVE 'MASTER ACCOUNT' TO P1-ACCT-TYPE                
                 ELSE                                                   
                   IF AT-ACCOUNT-TYPE-CODE = 'D'                        
                     MOVE 'COMPANY USAGE' TO P1-ACCT-TYPE               
                   ELSE                                                 
                     IF AT-ACCOUNT-TYPE-CODE = 'M'                      
                       MOVE 'PUBLIC/STREET LIGHT' TO P1-ACCT-TYPE       
                     ELSE                                               
                       IF AT-ACCOUNT-TYPE-CODE = 'N'                    
                         MOVE 'NON-UTILITY' TO P1-ACCT-TYPE             
                       ELSE                                             
                         IF AT-ACCOUNT-TYPE-CODE = 'S'                  
                           MOVE 'STATION/SUBSTATION' TO P1-ACCT-TYPE    
                         ELSE                                           
                           IF AT-ACCOUNT-TYPE-CODE = 'W'                
                             MOVE 'WHOLESALE' TO P1-ACCT-TYPE           
                           ELSE                                         
                             MOVE 'ACCT TYPE NOT FOUND' TO P1-ACCT-TYPE 
                           END-IF                                       
                         END-IF                                         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-ARREARS-HIST        TO P1-ARREARS-HISTORY.           
           MOVE AT-LAST-PYMT-AMOUNT    TO P1-LAST-PYMNT-AMT.            
           MOVE AT-TOTAL-AR-BALANCE    TO P1-AR-BAL.                    
      *                                                                         
           PERFORM 2110-PROCESS-CREDIT-GROUP THRU 2110-EXIT.            
      *                                                                         
           MOVE 2                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-101     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  2                   **          
      ****************************************************************          
      *                                                                         
           IF MUST-GET-LOCAL-OFFICE                                     
             PERFORM 7700-GET-LOCAL-OFFICE   THRU 7700-EXIT             
             MOVE WS-N TO WS-RETRIEVE-LOC-OFFICE                        
           END-IF.                                                      
      *                                                                         
           MOVE WS-SERVICE-ADDR1    TO P1-SERVICE-ADDR01.               
      *                                                                         
           MOVE WS-DISCONNECT-HIST  TO P1-NORMAL-HISTORY.               
      *                                                                         
           IF AT-LAST-PYMT-DATE = SPACES                                
            OR AT-LAST-PYMT-DATE = LOW-VALUES                           
             MOVE SPACES TO P1-LAST-PYMT-DATE                           
           ELSE                                                         
             MOVE AT-LAST-PYMT-DATE TO WS-DATE-10                       
             MOVE WS-D10-YEAR       TO WS-D8-YY                         
             MOVE WS-D10-MONTH      TO WS-D8-MM                         
             MOVE WS-D10-DAY        TO WS-D8-DD                         
             MOVE WS-DATE-8         TO P1-LAST-PYMT-DATE                
           END-IF.                                                      
      *                                                                         
           PERFORM 1700-CALL-CPD00068 THRU 1700-EXIT.                   
           MOVE WS-AMT-PAST-DUE TO P1-PAST-DUE                          
                                   WS-PAST-DUE-AMT.                     
      *                                                                 01181000
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-102     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  3                   **          
      ****************************************************************          
      *                                                                         
           MOVE WS-SERVICE-ADDR3       TO P1-SERVICE-ADDR03.            
      *                                                                         
           PERFORM 7310-SELECT-SUM-DEP-AMT  THRU 7310-EXIT.             
      *                                                                         
           MOVE ZEROS                  TO WS-BOND-TOTAL-AMT.            
      *                                                                         
           PERFORM 7400-SELECT-SUM-BOND-AMT   THRU 7400-EXIT.           
      *                                                                         
           MOVE WS-AMT-DEPOSIT         TO P1-DEP-AMT.                   
      *                                                                         
           PERFORM 2600-GET-MAX-DEPOSIT  THRU 2600-EXIT.                
           MOVE WS-MAX-DEPOSIT-AMT     TO P1-DEP-AMT-MAX.               
      *                                                                         
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-103     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP156   THRU 8500-EXIT.                
      *                                                                         
      ****************************************************************          
      **                 D E T A I L   L I N E  4                   **          
      ****************************************************************          
      *                                                                         
           IF WS-DATE-UTIL-SVC-STRT = SPACES                            
            OR WS-DATE-UTIL-SVC-STRT = LOW-VALUES                       
             MOVE SPACES TO P1-ON-DATE                                  
           ELSE                                                         
             MOVE WS-DATE-UTIL-SVC-STRT TO WS-DATE-10                   
             MOVE WS-D10-YEAR           TO WS-D8-YY                     
             MOVE WS-D10-MONTH          TO WS-D8-MM                     
             MOVE WS-D10-DAY            TO WS-D8-DD                     
             MOVE WS-DATE-8             TO P1-ON-DATE                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7160-SELECT-DBA-NAME  THRU 7160-EXIT.                
           MOVE WS-DBA-NAME            TO P1-DBA-NAME.                  
      *                                                                         
           MOVE 1                      TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-104     TO P-OUTPUT-LINE.                
           PERFORM 8500-PRINT-PCSRP156   THRU 8500-EXIT.                
      *                                                                         
      *****************************************************************         
      **                    R E P O R T   T O T A L S                **         
      *****************************************************************         
      *                                                                         
           ADD AT-TOTAL-AR-BALANCE TO WS-COMP-AR-AMT                    
                                      WS-DIST-AR-AMT.                   
           ADD WS-PAST-DUE-AMT     TO WS-COMP-DNP-AMT                   
                                      WS-DIST-DNP-AMT.                  
           ADD WS-AMT-DEPOSIT      TO WS-COMP-DEP-AMT                   
                                      WS-DIST-DEP-AMT.                  
           ADD WS-MAX-DEPOSIT-AMT  TO WS-COMP-MAX-AMT                   
                                      WS-DIST-MAX-AMT.                  
           ADD +1                  TO WS-COMP-NUM-ACCTS                 
                                      WS-DIST-NUM-ACCTS.                
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    PROCESS-CREDIT-GROUP                                    **          
      ****************************************************************          
      *                                                                         
       2110-PROCESS-CREDIT-GROUP.                                       
      *                                                                         
           EVALUATE TRUE                                                
             WHEN AT-CREDIT-GROUP    = 'A'                              
               MOVE WS-LIT-ARREARS     TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'B'                              
               MOVE WS-LIT-BALANCE     TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'C'                              
               MOVE WS-LIT-EXEMPT      TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'N'                              
               MOVE WS-LIT-NEW         TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'D'                              
               MOVE WS-LIT-NON-UTIL    TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'M'                              
               MOVE WS-LIT-MASTER      TO P1-CREDIT-GRP                 
             WHEN AT-CREDIT-GROUP    = 'S'                              
               MOVE WS-LIT-SUB         TO P1-CREDIT-GRP                 
           END-EVALUATE.                                                
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE REPORT BREAK FOR DISTRICT CHANGE REPORT **          
      ****************************************************************          
      *                                                                         
       2210-TOTAL-DISTRICT.                                             
      *                                                                         
           IF WS-DIST-NUM-ACCTS = 0                                     
              CONTINUE                                                  
           ELSE                                                         
ACT126        IF P101-DIST-NM = 'SCE&G CREDIT-SOUTHERN' OR              
ACT126                          'SCE&G CREDIT-COMM-SOUTHERN'            
                 MOVE WS-DIST-AR-AMT    TO WS-S-SUM-AR                  
                 MOVE WS-DIST-DNP-AMT   TO WS-S-SUM-DNP                 
                 MOVE WS-DIST-NUM-ACCTS TO WS-S-SUM-CNT                 
                 MOVE WS-DIST-DEP-AMT   TO WS-S-SUM-DEP                 
              ELSE                                                      
ACT126           IF P101-DIST-NM = 'SCE&G CREDIT-NORTHERN' OR           
ACT126                             'SCE&G CREDIT-COMM-NORTHERN'         
                    MOVE WS-DIST-AR-AMT    TO WS-N-SUM-AR               
                    MOVE WS-DIST-DNP-AMT   TO WS-N-SUM-DNP              
                    MOVE WS-DIST-NUM-ACCTS TO WS-N-SUM-CNT              
                    MOVE WS-DIST-DEP-AMT   TO WS-N-SUM-DEP              
                 ELSE                                                   
                    DISPLAY '***************************************'   
                    DISPLAY '*     PCSRP156 PROCESSING ERROR       *'   
                    DISPLAY '*   PARAGRAPH 2210-TOTAL-DISTRICT     *'   
                    DISPLAY '*       PROCESSING TERMINATED         *'   
                    DISPLAY '*          WE HAVE A MATCH            *'   
                    DISPLAY '*             BETWEEN                 *'   
                    DISPLAY '*   CSS_RESP_AREA AND CSS_WQ_ITEMS    *'   
                    DISPLAY '*               FOR                   *'   
                    DISPLAY '*  RESP_AREA_ID = :C1-RESP-AREA-ID    *'   
                    DISPLAY '*      WHICH HAS A DIFFERENT          *'   
                    DISPLAY '*        RESP_AREA_DESC               *'   
                    DISPLAY '* THAN WHAT WAS ORIGINALLY CODED FOR. *'   
                    DISPLAY '*  EITHER A TABLE CHANGE HAS OCCURRED *'   
                    DISPLAY '*    OR WQS 135 ARE BEING CREATED     *'   
                    DISPLAY '*      FOR ANOTHER RESP_AREA_ID.      *'   
                    DISPLAY '*   ABENDING PROGRAM BECAUSE THIS     *'   
                    DISPLAY '* AFFECTS THE TOTALING FOR THE PARM.  *'   
                    DISPLAY '* OFFENDING AREA ID = ' P101-DIST-NM       
                    DISPLAY '***************************************'   
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE WS-DIST-AR-AMT     TO P101-DIST-AR-AMOUNT            
              MOVE WS-DIST-TOT101  TO P-OUTPUT-LINE                     
              MOVE 4                  TO WS-SKIP-LINES-NUM              
              PERFORM 8500-PRINT-PCSRP156   THRU 8500-EXIT              
      *                                                                         
              MOVE WS-DIST-DNP-AMT    TO P101A-DIST-DNP-AMOUNT          
              MOVE WS-DIST-TOT101A TO P-OUTPUT-LINE                     
              MOVE 2                  TO WS-SKIP-LINES-NUM              
              PERFORM 8500-PRINT-PCSRP156   THRU 8500-EXIT              
      *                                                                         
              MOVE WS-DIST-NUM-ACCTS  TO P102-DIST-NUM-ACCTS            
              MOVE WS-DIST-TOT102  TO P-OUTPUT-LINE                     
              MOVE 2                  TO WS-SKIP-LINES-NUM              
              PERFORM 8500-PRINT-PCSRP156   THRU 8500-EXIT              
      *                                                                         
              MOVE WS-DIST-DEP-AMT TO P103-DIST-DEP-AMT                 
              MOVE WS-DIST-MAX-AMT TO P103-DIST-MAX-AMT                 
              MOVE WS-DIST-TOT103  TO P-OUTPUT-LINE                     
              MOVE 2  TO WS-SKIP-LINES-NUM                              
              PERFORM 8500-PRINT-PCSRP156  THRU 8500-EXIT               
      *                                                                         
              PERFORM 0200-INIT-RPT1-ACCUMS THRU 0200-EXIT              
           END-IF.                                                      
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE REPORT BREAK FOR THE COMPANY            **          
      ****************************************************************          
      *                                                                         
       2300-TOTAL-COMPANY.                                              
      *                                                                         
           IF WS-COMP-NUM-ACCTS = 0                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-COMP-AR-AMT TO P101-COMP-AR-AMOUNT                
              MOVE WS-COMP-TOT101 TO P-OUTPUT-LINE                      
              MOVE 4              TO WS-SKIP-LINES-NUM                  
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
              MOVE WS-COMP-DNP-AMT TO P101A-COMP-DNP-AMOUNT             
              MOVE WS-COMP-TOT101A TO P-OUTPUT-LINE                     
              MOVE 2               TO WS-SKIP-LINES-NUM                 
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
              MOVE WS-COMP-NUM-ACCTS TO P102-COMP-NUM-ACCTS             
              MOVE WS-COMP-TOT102    TO P-OUTPUT-LINE                   
              MOVE 2                 TO WS-SKIP-LINES-NUM               
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
              MOVE WS-COMP-DEP-AMT TO P103-COMP-DEP-AMT                 
              MOVE WS-COMP-MAX-AMT TO P103-COMP-MAX-AMT                 
              MOVE WS-COMP-TOT103  TO P-OUTPUT-LINE                     
              MOVE 2               TO WS-SKIP-LINES-NUM                 
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
              PERFORM 0400-INIT-RPT1-ACCUMS THRU 0400-EXIT              
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    PROCESS MONTHS                                          **          
      ****************************************************************          
      *                                                                         
       2500-PROCESS-MONTHS.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CIS.DECIMAL2MONTH(CIS.DIFFDATE( CAST(SYSDATETIMEOFFSET() 
           AS DATE), IIF(TRY_CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:WS-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT) ) )) +       
                                       ((CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
           CAST(SYSDATETIMEOFFSET() AS DATE), IIF(TRY_CONVERT(DATE, 
                                                 :WS-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:WS-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :WS-DATE-UTIL-SVC-STRT) ) )))* 12)
            INTO
              :WS-NO-MONTH-STRT    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NO-MONTH-STRT = INTEGER (MONTH(CURRENT DATE -            
MFA-TR*                                :WS-DATE-UTIL-SVC-STRT)) +               
MFA-TR*                                ((YEAR(CURRENT DATE -                    
MFA-TR*                                :WS-DATE-UTIL-SVC-STRT))* 12)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '*       PCSRP156 PROCESSING ERROR       *'       
              DISPLAY '*     PARAGRAPH 2500-PROCESS-MONTHS     *'       
              DISPLAY '*         PROCESSING TERMINATED         *'       
              DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE            
              DISPLAY '* WS-NO-MONTH-STRT = '   WS-NO-MONTH-STRT        
              DISPLAY '* DATE-UTIL-SVC-STRT = ' WS-DATE-UTIL-SVC-STRT   
              DISPLAY '*****************************************'       
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  RETRIEVES THE MAXIMUM ALLOWABLE DEPOSIT FOR AN ACCOUNT    **          
      **  THE CALCULATION IS DONE IN CPD00308.                      **          
      ****************************************************************          
      *                                                                         
       2600-GET-MAX-DEPOSIT.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO   TO    WS-ACCOUNT-NO.                    
           MOVE AT-PREMISE-NO   TO    WS-PREMISE-NO.                    
           MOVE 'Y'             TO    WS-CALLING-BATCH-SW.              
           MOVE  1              TO    WS-DATABASE.                      
T36294     MOVE WS-CURRENT-DATE TO    WS-TEMP-BATCH-DATE.               
           PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRODUCE THE REPORT                                       **          
      ****************************************************************          
      *                                                                         
       2800-PRODUCE-RPT.                                                
      *                                                                         
           PERFORM 2805-GET-COMMON-INFO THRU 2805-EXIT.                 
      *                                                                         
           MOVE WS-Y  TO WS-RPT1-EXIST.                                 
           ADD WS-1   TO WS-RPT1-CNTR.                                  
           PERFORM 2810-PRODUCE-RPT1 THRU 2810-EXIT.                    
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   GET COMMON INFORMATION                                   **          
      ****************************************************************          
      *                                                                         
       2805-GET-COMMON-INFO.                                            
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
      *                                                                         
           MOVE WS-CUSTOMER-NAME      TO WS-NAME-CUST.                  
      *                                                                         
           MOVE WS-PR-STREET          TO WS-SERVICE-ADDR1.              
           MOVE WS-PR-ADDR-CITY-STATE-ZIP TO WS-SERVICE-ADDR3.          
      *                                                                         
           MOVE AT-ACCOUNT-NO         TO CZ-ACCOUNT-NO.                 
           PERFORM 7170-SELECT-CREDIT-PROFILE  THRU 7170-EXIT.          
      *                                                                         
           MOVE CZ-ARREARS-HIST       TO WS-ARREARS-HIST.               
           MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST.            
      *                                                                         
           PERFORM 2807-GET-SVC-STRT-END-DATE  THRU 2807-EXIT.          
      *                                                                         
       2805-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  MODULE OPENS A CURSOR TO GET THE MOST RECENT SERVICE START  *          
      *  DATE AND END DATE. ONCE SELECTED THE VARIABLES ARE MOVED    *          
      *  INTO GENERAL ACCT INFORMATION.                              *          
      ****************************************************************          
      *                                                                         
       2807-GET-SVC-STRT-END-DATE.                                      
      *                                                                         
           PERFORM 7210-FETCH-CUST-PREM   THRU 7210-EXIT.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CH-DATE-UTIL-SVC-STRT   TO WS-DATE-UTIL-SVC-STRT     
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-PROCESS-MONTHS  THRU 2500-EXIT.                 
      *                                                                         
       2807-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    PRODUCE REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       2810-PRODUCE-RPT1.                                               
      *                                                                         
           IF WS-RPT1-PREV-RESP-AREA = WQ-RESP-AREA-ID                  
              CONTINUE                                                  
           ELSE                                                         
             PERFORM 2210-TOTAL-DISTRICT  THRU 2210-EXIT                
             MOVE WS-62            TO WS-RPT1-LINE-NO                   
             MOVE WQ-RESP-AREA-ID  TO WS-RPT1-PREV-RESP-AREA            
             MOVE WS-Y             TO WS-RETRIEVE-DISTRICT              
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-PREV-LOC-OFFICE = AT-LOCAL-OFFICE                 
              CONTINUE                                                  
           ELSE                                                         
             MOVE AT-LOCAL-OFFICE  TO WS-RPT1-PREV-LOC-OFFICE           
             MOVE WS-Y             TO WS-RETRIEVE-LOC-OFFICE            
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO > WS-46                                   
             MOVE WQ-RESP-AREA-ID  TO C1-RESP-AREA-ID                   
             PERFORM 8110-PRINT-HEADERS THRU 8110-EXIT                  
           END-IF.                                                      
      *                                                                         
           PERFORM 2050-BUILD-DETAIL-RPT1  THRU 2050-EXIT.              
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  LOAD JOB_PARM WITH SUMMARY DATA                           **          
      ****************************************************************          
      *                                                                         
       2900-LOAD-JOB-PARM.                                              
      *                                                                         
           MOVE WS-PGRMNAME TO G6-PROGRAM-NAME.                         
           MOVE WS-PARM     TO G6-CMND-CODE.                            
           MOVE 10          TO G6-SEQ-NO.                               
      *                                                                         
           INITIALIZE WS-PARM-SUM-TOTAL.                                
      *                                                                         
           ADD WS-S-SUM-AR  TO WS-SAVE-S-PARM-AR.                       
           ADD WS-S-SUM-DNP TO WS-SAVE-S-PARM-DNP.                      
           ADD WS-S-SUM-CNT TO WS-SAVE-S-PARM-CNT.                      
           ADD WS-S-SUM-DEP TO WS-SAVE-S-PARM-DEP.                      
      *                                                                         
           MOVE WS-SAVE-S-PARM-AR  TO WS-PARM-SUM-AR.                   
           MOVE WS-SAVE-S-PARM-DNP TO WS-PARM-SUM-DNP.                  
           MOVE WS-SAVE-S-PARM-CNT TO WS-PARM-SUM-CNT.                  
           MOVE WS-SAVE-S-PARM-DEP TO WS-PARM-SUM-DEP.                  
      *                                                                         
           MOVE 'SOUTHERN'        TO WS-PARM-DIV-LIT.                   
           MOVE ' AR =  '         TO WS-PARM-AR-LIT.                    
           MOVE ' DNP = '         TO WS-PARM-DNP-LIT.                   
           MOVE ' CNT = '         TO WS-PARM-CNT-LIT.                   
           MOVE ' DEP = '         TO WS-PARM-DEP-LIT.                   
           MOVE WS-PARM-SUM-TOTAL TO G6-PARM-DATA.                      
      *                                                                         
           PERFORM 8250-UPDATE-SUMMARY-TOTALS THRU 8250-EXIT.           
      *                                                                         
           INITIALIZE WS-PARM-SUM-TOTAL.                                
      *                                                                         
           MOVE WS-PGRMNAME TO G6-PROGRAM-NAME.                         
           MOVE WS-PARM     TO G6-CMND-CODE.                            
           MOVE 20          TO G6-SEQ-NO.                               
      *                                                                         
           ADD WS-N-SUM-AR  TO WS-SAVE-N-PARM-AR.                       
           ADD WS-N-SUM-DNP TO WS-SAVE-N-PARM-DNP.                      
           ADD WS-N-SUM-CNT TO WS-SAVE-N-PARM-CNT.                      
           ADD WS-N-SUM-DEP TO WS-SAVE-N-PARM-DEP.                      
      *                                                                         
           MOVE WS-SAVE-N-PARM-AR  TO WS-PARM-SUM-AR.                   
           MOVE WS-SAVE-N-PARM-DNP TO WS-PARM-SUM-DNP.                  
           MOVE WS-SAVE-N-PARM-CNT TO WS-PARM-SUM-CNT.                  
           MOVE WS-SAVE-N-PARM-DEP TO WS-PARM-SUM-DEP.                  
      *                                                                         
           MOVE 'NORTHERN'        TO WS-PARM-DIV-LIT.                   
           MOVE ' AR =  '         TO WS-PARM-AR-LIT.                    
           MOVE ' DNP = '         TO WS-PARM-DNP-LIT.                   
           MOVE ' CNT = '         TO WS-PARM-CNT-LIT.                   
           MOVE ' DEP = '         TO WS-PARM-DEP-LIT.                   
           MOVE WS-PARM-SUM-TOTAL TO G6-PARM-DATA.                      
      *                                                                         
           PERFORM 8250-UPDATE-SUMMARY-TOTALS THRU 8250-EXIT.           
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  3900-CENTERING-ROUTINE                                      *          
      *  THIS COPY STATEMENT CONTAINS THE NON-SQL PROCEDURE DIVISION *          
      *  STATEMENTS NECESSARY TO CENTER VARIABLE LENGTH TABLE        *          
      *  RETRIEVED INFORMATION IN A FIXED LENGTH FIELD.              *          
      ****************************************************************          
      *                                                                         
       COPY CPD00150.                                                           
      *                                                                         
      ****************************************************************          
      *  4000-MAIL-NAME-ADDRESS                                      *          
      *  CREATE MAIL NAME AND ADDRESS                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6010-REDUCE-EMBEDDED-SPACES.                                *          
      *  THIS PARAGRAPH CONTROLS THE EXAMINATION OF WS-EMB-INPUT     *          
      *  IN CWS00011 ONE CHARACTER AT A TIME UNTIL THE LIMIT IS      *          
      *  REACHED. SEE COMMENTS WITH CWS00011,WHICH MUST ALSO BE      *          
      *  COPIED INTO THE PROGRAM, FOR THE REQUIREMENTS OF ROUTINE    *          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      *  6200-GET-PARAMETER-DATE                                     *          
      *  COPYBOOK TO READ JOB PARM TABLE FOR REPORT DATE             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00114                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6240-GET-FCA00-COMMON-DATE.                                 *          
      *  THIS CPD WILL GET THE COMMON DATE RECORD OFF THE VSAM       *          
      *  CONTROL FILE (FCSCA00-FILE).                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6251-GET-FJC01-DATE                                         *          
      *  COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **    OPEN WS CURSOR                                          **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-WQ-CSR.                                                
      *                                                                         
           EXEC SQL                                                     
             OPEN WQ_CSR                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '*       PCSRP156 PROCESSING ERROR         *'     
              DISPLAY '*      PARAGRAPH 7000-OPEN-WQ-CSR         *'     
              DISPLAY '*         ERROR OPENING WQ_CSR            *'     
              DISPLAY '*         PROCESSING TERMINATED           *'     
              DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE            
              DISPLAY '*******************************************'     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     FETCH WS CURSOR                                        **          
      ****************************************************************          
      *                                                                         
       7001-FETCH-WQ-CSR.                                               
      *                                                                         
           EXEC SQL                                                     
             FETCH  WQ_CSR                                              
              INTO  :AT-ACCOUNT-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-ADDRESS-FORMAT,                                 
                    :AT-ADDRESS-ID,                                     
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,         
                    :AT-BILL-CYCLE,                                     
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :WQ-RESP-AREA-ID,                                   
                    :UT-CODE-UTIL-TYPE,                                 
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-COMPANY-NO,                                     
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,     
                    :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,     
                    :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,     
                    :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,     
                    :AT-CODE-DISC-OK,                                   
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-NOTICE-EXEMPT-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
      *                                                                         
              IF AT-ACCOUNT-NO = WS-SAVE-ACCOUNT-NO                     
                 MOVE 'Y' TO WS-SAME-SW                                 
              ELSE                                                      
                 MOVE 'N' TO WS-SAME-SW                                 
              END-IF                                                    
              MOVE AT-ACCOUNT-NO TO WS-SAVE-ACCOUNT-NO                  
      *                                                                         
              IF WS-LAST-PYMT-DATE-NULL < 0                             
                MOVE SPACES TO AT-LAST-PYMT-DATE                        
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-MORE-DATA-SW                            
                 MOVE 'N' TO WS-SAME-SW                                 
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '*       PCSRP156 PROCESSING ERROR       *'    
                 DISPLAY '*      PARAGRAPH 7001-FETCH-WQ-CSR      *'    
                 DISPLAY '*         ERROR FETCHING WQ_CSR         *'    
                 DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE         
                 DISPLAY '* WQ.DATE_CREATED = ' WQ-DATE-CREATED         
                 DISPLAY '*         PROCESSING TERMINATED         *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     CLOSE WQ CURSOR                                        **          
      ****************************************************************          
      *                                                                         
       7002-CLOSE-WQ-CSR.                                               
      *                                                                         
           EXEC SQL                                                     
             CLOSE  WQ_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '*       PCSRP156 PROCESSING ERROR       *'        
             DISPLAY '*      PARAGRAPH 7002-CLOSE-WQ-CSR      *'        
             DISPLAY '*         ERROR CLOSING WQ_CSR          *'        
             DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
             DISPLAY '*         PROCESSING TERMINATED         *'        
             DISPLAY '*****************************************'        
             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  SELECT THE FULL NAME                                        *          
      ****************************************************************          
      *                                                                         
       7160-SELECT-DBA-NAME.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT  NM.FULL_NAME                                     
               INTO   :WS-DBA-NAME                                      
               FROM CSS_NAME  NM WITH(READUNCOMMITTED)                          
                   ,CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)                 
               WHERE AB.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND NM.NAME_ID    = AB.NAME_ID                         
                 AND NM.NAME_TYPE  = 'DB'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  NM.FULL_NAME                                             
MFA-TR*        INTO   :WS-DBA-NAME                                              
MFA-TR*        FROM CSS_NAME  NM                                                
MFA-TR*            ,CSS_ACCT_BILL_NMES AB                                       
MFA-TR*        WHERE AB.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND NM.NAME_ID    = AB.NAME_ID                                 
MFA-TR*          AND NM.NAME_TYPE  = 'DB'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE                              
                            WS-DISP-RETURN-CODE.                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '*         PROCESSING ERROR                 *'   
               DISPLAY '*     PARAGRAPH 7160-SELECT-DBA-NAME       *'   
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* ACCOUNT NUMBER = ' AT-ACCOUNT-NO              
               DISPLAY '*       PROCESSING TERMINATED              *'   
               DISPLAY '********************************************'   
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  SELECT CREDIT PROFILE                                       *          
      ****************************************************************          
      *                                                                         
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  DISC_EXCEPTN_HIST,                                    
                  DISCONNECT_HIST,                                      
                  ARREARS_HIST,                                         
                  NON_UTL_ARRER_HIST,                                   
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
              INTO                                                      
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-ARREARS-HIST,                                     
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-LAST-UPDATE-TS                                    
              FROM                                                      
                 CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                       
              WHERE                                                     
                 ACCOUNT_NO = :CZ-ACCOUNT-NO                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           DISC_EXCEPTN_HIST,                                            
MFA-TR*           DISCONNECT_HIST,                                              
MFA-TR*           ARREARS_HIST,                                                 
MFA-TR*           NON_UTL_ARRER_HIST,                                           
MFA-TR*           LAST_UPDATE_TS                                                
MFA-TR*       INTO                                                              
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                        
MFA-TR*           :CZ-DISCONNECT-HIST,                                          
MFA-TR*           :CZ-ARREARS-HIST,                                             
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                                       
MFA-TR*           :CZ-LAST-UPDATE-TS                                            
MFA-TR*       FROM                                                              
MFA-TR*          CSS_CREDIT_PROFILE                                             
MFA-TR*       WHERE                                                             
MFA-TR*          ACCOUNT_NO = :CZ-ACCOUNT-NO                                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE                              
                            WS-DISP-RETURN-CODE.                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********************************************'  
               DISPLAY '*          PROCESSING ERROR                 *'  
               DISPLAY '*    PARAGRAPH 7170-SELECT-CREDIT-PROFILE   *'  
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* ACCOUNT NUMBER = ' CZ-ACCOUNT-NO              
               DISPLAY '*         PROCESSING TERMINATED             *'  
               DISPLAY '*********************************************'  
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH CUST-PREM                                             *          
      ****************************************************************          
      *                                                                         
       7210-FETCH-CUST-PREM.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DATE_UTIL_SVC_STRT,
              DATE_UTIL_SVC_END                                 
              INTO   :CH-DATE-UTIL-SVC-STRT,                            
                     :CH-DATE-UTIL-SVC-END :WS-NULL-DATE-UTL-END         
              FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND PREMISE_NO = :AT-PREMISE-NO                         
              ORDER BY DATE_UTIL_SVC_STRT DESC                          
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_UTIL_SVC_STRT                                         
MFA-TR*              ,DATE_UTIL_SVC_END                                         
MFA-TR*       INTO   :CH-DATE-UTIL-SVC-STRT,                                    
MFA-TR*              :CH-DATE-UTIL-SVC-END:WS-NULL-DATE-UTL-END                 
MFA-TR*       FROM CSS_CUST_PREM_HIST                                           
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND PREMISE_NO = :AT-PREMISE-NO                                 
MFA-TR*       ORDER BY DATE_UTIL_SVC_STRT DESC                                  
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-DATE-UTL-END < ZERO                            
                 MOVE LOW-VALUES TO CH-DATE-UTIL-SVC-END                
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
               DISPLAY '*********************************************'  
               DISPLAY '*         PROCESSING ERROR                  *'  
               DISPLAY '*    PARAGRAPH 7210-FETCH-CUST-PREM         *'  
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* PREMISE NUMBER = ' AT-PREMISE-NO              
               DISPLAY '*         PROCESSING TERMINATED             *'  
               DISPLAY '*********************************************'  
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  SELECT SUM DEPOSIT AMOUNT                                   *          
      ****************************************************************          
      *                                                                         
       7310-SELECT-SUM-DEP-AMT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :WS-AMT-DEPOSIT :WS-DEPOSIT-AMT-NULL                
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND DEPOSIT_STATUS_CD IN ('P','A')                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*         INTO :WS-AMT-DEPOSIT:WS-DEPOSIT-AMT-NULL                        
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DEPOSIT_STATUS_CD IN ('P','A')                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE                              
                            WS-DISP-RETURN-CODE.                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-DEPOSIT-AMT-NULL < 0                               
                   MOVE ZEROS TO WS-AMT-DEPOSIT                         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '*********************************************'  
               DISPLAY '*           PROCESSING ERROR                *'  
               DISPLAY '*      PARAGRAPH 7310-SELECT-SUM-DEP-AMT    *'  
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* ACCOUNT NUMBER = ' AT-ACCOUNT-NO              
               DISPLAY '*         PROCESSING TERMINATED             *'  
               DISPLAY '*********************************************'  
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  SELECT SUM BOND AMOUNT                                      *          
      ****************************************************************          
      *                                                                         
       7400-SELECT-SUM-BOND-AMT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(BOND_TOTAL_AMT)                                
                INTO :WS-BOND-TOTAL-AMT :WS-BOND-TOTAL-AMT-NULL          
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                 AND CODE_STATUS = 'A'                                  
                 AND CODE_BOND_TYPE IN ('A','B')                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(BOND_TOTAL_AMT)                                        
MFA-TR*         INTO :WS-BOND-TOTAL-AMT:WS-BOND-TOTAL-AMT-NULL                  
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND CODE_STATUS = 'A'                                          
MFA-TR*          AND CODE_BOND_TYPE IN ('A','B')                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-BOND-TOTAL-AMT-NULL < 0                            
                   MOVE ZEROS TO WS-BOND-TOTAL-AMT                      
               ELSE                                                     
                   ADD WS-BOND-TOTAL-AMT TO WS-AMT-DEPOSIT              
               END-IF                                                   
           ELSE                                                         
               DISPLAY '*********************************************'  
               DISPLAY '*          PROCESSING ERROR                 *'  
               DISPLAY '*    PARAGRAPH 7400-SELECT-SUM-BOND-AMT     *'  
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* ACCOUNT NUMBER = ' AT-ACCOUNT-NO              
               DISPLAY '*         PROCESSING TERMINATED             *'  
               DISPLAY '*********************************************'  
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  RETIEVE COMPANY NAME                                        *          
      ****************************************************************          
      *                                                                         
       7500-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*********************************************'  
               DISPLAY '*          PROCESSING ERROR                 *'  
               DISPLAY '*    PARAGRAPH 7500-GET-COMPANY-NAME        *'  
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '* COMPANY NO = ' C7-COMPANY-NO                  
               DISPLAY '*         PROCESSING TERMINATED             *'  
               DISPLAY '*********************************************'  
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE THE JOB PARM LAST RUN DATE WITH CURRENT RUN DATE    **          
      ****************************************************************          
      *                                                                         
       8200-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
               SET    PARM_DATA    = :G6-PARM-DATA                      
               WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                   
               AND    CMND_CODE    = :G6-CMND-CODE                      
               AND    SEQ_NO       = 10                                 
               AND    COMPANY_NO   = '01'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '*        PROCESSING ERROR               *'       
              DISPLAY '* PARAGRAPH 8200-UPDATE-LAST-RUN-DATE   *'       
              DISPLAY '*   SQLCODE = ' WS-DISP-RETURN-CODE              
              DISPLAY '*   G6-PARM-DATA = ' G6-PARM-DATA                
              DISPLAY '*   G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
              DISPLAY '*   G6-CMND-CODE = ' G6-CMND-CODE                
              DISPLAY '*         PROCESSING TERMINATED         *'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE THE RUNNING TOTALS TO BE USED IN THE MONTH END      **          
      ** REPORT.                                                    **          
      ****************************************************************          
      *                                                                         
       8250-UPDATE-SUMMARY-TOTALS.                                      
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
               SET    PARM_DATA     = :G6-PARM-DATA                     
               WHERE  PROGRAM_NAME  = :G6-PROGRAM-NAME                  
               AND    CMND_CODE     = :G6-CMND-CODE                     
               AND    SEQ_NO        = :G6-SEQ-NO                        
               AND    COMPANY_NO    = '01'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '*        PROCESSING ERROR               *'       
              DISPLAY '*  PARAGRAPH 8250-UPDATE-SUMMARY-TOTALS *'       
              DISPLAY '*   SQLCODE = ' WS-DISP-RETURN-CODE              
              DISPLAY '*   G6-PARM-DATA = ' G6-PARM-DATA                
              DISPLAY '*   G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
              DISPLAY '*   G6-CMND-CODE = ' G6-CMND-CODE                
              DISPLAY '*   G6-SEQ-NO = ' G6-SEQ-NO                      
              DISPLAY '*         PROCESSING TERMINATED         *'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  START FCSJC01 FILE USING E-FJC01-KEY                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  7620-START-FCSCA00                                          *          
      *  THIS CPD CONTAINS THE PARAGRAPH TO START AND READ THE       *          
      *  VSAM CONTROL FILE (FCSCA00-FILE).                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE AT-LOCAL-OFFICE TO B1-LOCAL-OFFICE.                     
      *                                                                         
           EXEC SQL                                                     
             SELECT LOCAL_OFFICE_DESC                                   
               INTO :B1-LOCAL-OFFICE-DESC                               
             FROM   CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                      
             WHERE  COMPANY_NO   = '01'                                 
               AND  LOCAL_OFFICE = :B1-LOCAL-OFFICE                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT LOCAL_OFFICE_DESC                                           
MFA-TR*        INTO :B1-LOCAL-OFFICE-DESC                                       
MFA-TR*      FROM   CSS_LOCAL_OFFICE                                            
MFA-TR*      WHERE  COMPANY_NO   = '01'                                         
MFA-TR*        AND  LOCAL_OFFICE = :B1-LOCAL-OFFICE                             
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE B1-LOCAL-OFFICE-DESC TO P1-LOC-OFF-NM                
              MOVE B1-LOCAL-OFFICE      TO P1-LOC-OFF-CD                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES             TO P1-LOC-OFF-NM               
                 MOVE B1-LOCAL-OFFICE    TO P1-LOC-OFF-CD               
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '*         PROCESSING ERROR             *'     
                 DISPLAY '* PARAGRAPH 7700-GET-LOCAL-OFFICE      *'     
                 DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE         
                 DISPLAY '* LOCAL-OFFICE = ' B1-LOCAL-OFFICE            
                 DISPLAY '*         PROCESSING TERMINATED         *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      SELECT THE RESP AREA DESCRIPTION                      **          
      ****************************************************************          
      *                                                                         
       7800-GET-DISTRICT.                                               
      *                                                                         
           EXEC SQL                                                     
             SELECT  RESP_AREA_DESC                                     
               INTO  :C1-RESP-AREA-DESC                                 
               FROM  CSS_RESP_AREA WITH(READUNCOMMITTED)                        
              WHERE  COMPANY_NO   = '01'                                
                AND  RESP_AREA_ID = :C1-RESP-AREA-ID                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  RESP_AREA_DESC                                             
MFA-TR*        INTO  :C1-RESP-AREA-DESC                                         
MFA-TR*        FROM  CSS_RESP_AREA                                              
MFA-TR*       WHERE  COMPANY_NO   = '01'                                        
MFA-TR*         AND  RESP_AREA_ID = :C1-RESP-AREA-ID                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C1-RESP-AREA-DESC TO P-RPT-DIST-NM                   
                                        P101-DIST-NM                    
                                        P101A-DIST-NM                   
                                        P102-DIST-NM                    
                                        P103-DIST-NM                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE '*** NOT FOUND ***' TO P-RPT-DIST-NM,             
                                             P101A-DIST-NM,             
                                             P102-DIST-NM,              
                                             P103-DIST-NM               
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '*        PROCESSING ERROR               *'    
                 DISPLAY '*    PARAGRAPH 7800-GET-DISTRICT        *'    
                 DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE         
                 DISPLAY '* C1-RESP-AREA-ID = ' C1-RESP-AREA-ID         
                 DISPLAY '* ACCOUNT NUMBER = ' AT-ACCOUNT-NO            
                 DISPLAY '*         PROCESSING TERMINATED         *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINT REGULAR HEADERS                                    **          
      ****************************************************************          
      *                                                                         
       8110-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1 TO WS-RPT1-PAGE-NO.                                    
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
      *                                                                         
           MOVE WS-RPT-TITLE TO P-OUTPUT-LINE.                          
           PERFORM 8505-PRINT-PCSRP156-TOP THRU 8505-EXIT.              
      *                                                                         
           MOVE WS-RPT-HEADER-1 TO P-OUTPUT-LINE.                       
           MOVE WS-1 TO WS-SKIP-LINES-NUM.                              
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-RPT-HEADER-PAGE TO P-OUTPUT-LINE.                    
           MOVE WS-1 TO WS-SKIP-LINES-NUM.                              
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           IF MUST-GET-DISTRICT                                         
              IF WS-NO-DATA-SW = 'Y'                                    
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 7800-GET-DISTRICT THRU 7800-EXIT               
                 MOVE WS-N TO WS-RETRIEVE-DISTRICT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF THIS-IS-COMP-BREAK                                        
              MOVE SPACES TO WS-RPT-HEADER-DIST                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-RPT-HEADER-DIST TO P-OUTPUT-LINE.                    
           MOVE WS-1               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-RPT1-HDR-01     TO P-OUTPUT-LINE.                    
           MOVE WS-2               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-RPT1-HDR-02     TO P-OUTPUT-LINE.                    
           MOVE WS-1               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-RPT1-HDR-03     TO P-OUTPUT-LINE.                    
           MOVE WS-1               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-RPT1-HDR-04     TO P-OUTPUT-LINE.                    
           MOVE WS-1               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
           MOVE WS-LINE            TO P-OUTPUT-LINE.                    
           MOVE WS-1               TO WS-SKIP-LINES-NUM.                
           PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT.                  
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE LINES FOR DETAIL OR TOTALS                **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-PCSRP156.                                             
      *                                                                         
           WRITE PRT331-RECORD FROM P-OUTPUT-LINE                       
             AFTER ADVANCING WS-SKIP-LINES-NUM.                         
           ADD WS-SKIP-LINES-NUM TO WS-RPT1-LINE-NO.                    
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS TOP OF PAGE HEADER                            **          
      ****************************************************************          
      *                                                                         
       8505-PRINT-PCSRP156-TOP.                                         
      *                                                                         
           WRITE PRT331-RECORD FROM P-OUTPUT-LINE                       
             AFTER ADVANCING TOP-OF-PAGE.                               
           MOVE WS-1 TO WS-RPT1-LINE-NO.                                
                                                                        
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS TOP OF PAGE HEADER                            **          
      ****************************************************************          
      *                                                                         
       8510-SUMMARY-PRINT-TOP.                                          
      *                                                                         
           WRITE PRT33-RECORD FROM P-OUTPUT-LINE                        
             AFTER ADVANCING TOP-OF-PAGE.                               
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE LINES FOR DETAIL OR TOTALS                **          
      ****************************************************************          
      *                                                                         
       8520-SUMMARY-PRINTER.                                            
      *                                                                         
           WRITE PRT33-RECORD FROM P-OUTPUT-LINE                        
             AFTER ADVANCING WS-SKIP-LINES-NUM.                         
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINT-RPT1-COMP-END                                      **          
      ****************************************************************          
      *                                                                         
       8600-PRINT-RPT1-COMP-END.                                        
      *                                                                         
           IF WS-RPT1-CNTR > ZERO                                       
             IF WS-RPT1-LINE-NO > WS-50                                 
               PERFORM 8110-PRINT-HEADERS THRU 8110-EXIT                
             END-IF                                                     
             PERFORM 2210-TOTAL-DISTRICT THRU 2210-EXIT                 
             MOVE WS-Y TO WS-COMP-BREAK-SW                              
             PERFORM 8110-PRINT-HEADERS THRU 8110-EXIT                  
             MOVE WS-N TO WS-COMP-BREAK-SW                              
             PERFORM 2300-TOTAL-COMPANY THRU 2300-EXIT                  
             MOVE ZERO TO WS-RPT1-CNTR                                  
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINT MONTHLY SUMMARY HEADERS                            **          
      ****************************************************************          
      *                                                                         
       8700-PRINT-MONTHLY-REPORT.                                       
      *                                                                         
           MOVE WS-1 TO WS-SKIP-LINES-NUM.                              
           MOVE PRT-SUMMARY-PRINT-LINE TO P-OUTPUT-LINE.                
           PERFORM 8520-SUMMARY-PRINTER THRU 8520-EXIT.                 
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINT MONTHLY SUMMARY HEADERS                            **          
      ****************************************************************          
      *                                                                         
       8800-PRINT-MONTHLY-HEADER.                                       
      *                                                                         
           MOVE PRT-MONTHLY-SUMMARY-HDR1 TO P-OUTPUT-LINE.              
           PERFORM 8510-SUMMARY-PRINT-TOP THRU 8510-EXIT.               
      *                                                                         
           MOVE WS-1 TO WS-SKIP-LINES-NUM.                              
           MOVE PRT-MONTHLY-SUMMARY-HDR2 TO P-OUTPUT-LINE.              
           PERFORM 8520-SUMMARY-PRINTER THRU 8520-EXIT.                 
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE                                          
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINTS NO DATA REPORT                                    **          
      ****************************************************************          
      *                                                                         
       9500-CLEANUP.                                                    
      *                                                                         
           IF REPORT-1-DOES-NOT-EXIST                                   
              MOVE 'Y' TO WS-NO-DATA-SW                                 
              PERFORM 8110-PRINT-HEADERS THRU 8110-EXIT                 
      *                                                                         
              MOVE WS-NO-DATA-LINE TO P-OUTPUT-LINE                     
              MOVE WS-3 TO WS-SKIP-LINES-NUM                            
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
              MOVE WS-END-DATA-LINE TO P-OUTPUT-LINE                    
              MOVE WS-3 TO WS-SKIP-LINES-NUM                            
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
      *                                                                         
           ELSE                                                         
      *                                                                         
              PERFORM 8600-PRINT-RPT1-COMP-END THRU 8600-EXIT           
      *                                                                         
              MOVE WS-END-DATA-LINE TO P-OUTPUT-LINE                    
              MOVE WS-3 TO WS-SKIP-LINES-NUM                            
              PERFORM 8500-PRINT-PCSRP156 THRU 8500-EXIT                
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  9700-PROCESS-ABEND                                          *          
      *  THIS PARAGRAPH DOES BATCH ABEND PROCESSING USING THE CICS   *          
      *  WORKING STORAGE ABEND FIELDS.                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  9900-ABEND.                                                 *          
      *  PERFORMED IF VSAM OR DB2 PROBLEM OCCURS                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  5650-GET-MAX-DEPOSIT.                                       *          
      *  THIS COPYBOOK IS ALSO USED IN BATCH TO COMPUTE              *          
      *  MAXIMUM DEPOSIT.                                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
