       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP144.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     FEB 21, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***GENERATE TAMPER REPORT FROM THE METER READ FILE.            ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT050***  03/23/2016    VV7M728     CAR144 CONVERT EZT TO COBOL     ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMT14.                                                            
       COPY CSSPT331.                                                           
       COPY CSSPT332.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      *                                                                         
       FD  FCSMT14-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIOBW81-RECORD                      PIC X(500).              
                                                                        
       COPY FIOBW81.                                                            
                                                                        
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT331-RECORD                       PIC X(294).              
                                                                        
       FD  FCSPT332-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT332-RECORD                       PIC X(294).              
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP144'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRTST                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEMTRSZ                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
                                                                        
       COPY CWS00074.                                                           
                                                                        
      *COPY CPD00004.                                                           
                                                                        
       COPY CWS00011.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP144'.     
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-ACTION                 PIC X(10) VALUE SPACES.         
           05 WS-CURSOR                 PIC X(15) VALUE SPACES.         
           05 WS-METER-NO               PIC X(09) VALUE SPACES.         
           05 WS-WORK-TYPE-CD           PIC X(03) VALUE SPACES.         
           05 WS-WORK-TYPE-CD-H         PIC X(03) VALUE SPACES.         
           05 WS-WO-COMP-DATE           PIC X(10) VALUE SPACES.         
           05 WS-WO-COMP-DATE-H         PIC X(10) VALUE SPACES.         
           05 WS-UTIL-TYPE              PIC X(01) VALUE SPACES.         
           05 WS-GOOD-REC               PIC X(01) VALUE 'N'.            
           05 WS-OUT                    PIC X(01) VALUE 'N'.            
           05 WS-ACCT-NO                PIC S9(13)V USAGE COMP-3        
                                                  VALUE ZERO.           
           05 WS-COUNT-1                PIC 9(08) VALUE ZEROES.         
           05 WS-COUNT-2                PIC 9(08) VALUE ZEROES.         
           05 WS-COUNT-12               PIC 9(08) VALUE ZEROES.         
           05 WS-INPUT-REC-COUNT        PIC 9(08) VALUE ZEROES.         
           05 WS-ACCT-NO-CHAR           PIC X(13).                      
           05 WS-ACCT-NO-NUM               REDEFINES                    
              WS-ACCT-NO-CHAR           PIC 9(13).                      
           05 WS-ACCOUNT-NO             PIC S9(13)V USAGE COMP-3        
                                                  VALUE ZERO.           
           05 WS-PREMISE-NO             PIC S9(10)V USAGE COMP-3        
                                                  VALUE ZERO.           
           05 WS-READ-DT.                                               
              10 WS-READ-DT-CC          PIC 9(04) VALUE ZEROES.         
              10 WS-READ-DT-YY          PIC 9(02) VALUE ZEROES.         
              10 WS-READ-DT-F1          PIC X(01) VALUE '-'.            
              10 WS-READ-DT-MM          PIC 9(02) VALUE ZEROES.         
              10 WS-READ-DT-F2          PIC X(01) VALUE ZEROES.         
              10 WS-READ-DT-DD          PIC 9(02) VALUE ZEROES.         
              10 WS-READ-DT-FILLER      PIC X(09) VALUE SPACES.         
           05 WS-READ-ROUTE-7.                                          
              10 WS-READ-ROUTE-4        PIC X(04) VALUE SPACES.         
              10 WS-READ-ROUTE-3        PIC X(03) VALUE SPACES.         
           05 WS-DT-RANGE-STARTX.                                       
              10 WS-DATE-RANGE-1        PIC X(10) VALUE 'XXXX-XX-XX'.   
              10 WS-DATE-RANGE-1-TM     PIC X(16) VALUE SPACES.         
           05 WS-DT-RANGE-ENDX.                                         
              10 WS-DATE-RANGE-2        PIC X(10) VALUE 'XXXX-XX-XX'.   
              10 WS-DATE-RANGE-2-TM     PIC X(16) VALUE SPACES.         
           05 WS-TIMESTAMP              PIC X(16)                       
                                          VALUE '-00.00.00.000000'.     
           05 WS-TIMESTAMP-END          PIC X(16)                       
                                          VALUE '-23.59.59.999999'.     
           05 WS-DT-RANGE-START         PIC X(26) VALUE SPACES.         
           05 WS-DT-RANGE-END           PIC X(26) VALUE SPACES.         
           05 WS-SKIP-RECORD            PIC X(01) VALUE SPACES.         
           05 WS-ORDER-TYPE-SW          PIC X(01) VALUE SPACES.         
           05 WS-HOLD-ORDER-TYPE        PIC X(04) VALUE SPACES.         
           05 WS-PARM-DATA.                                             
              10 WS-ORD-TYP-STR         PIC X(11) VALUE SPACES.         
              10 WS-ORDER-TYPE          PIC X(05) VALUE SPACES.         
              10 WS-FILLER              PIC X(64) VALUE SPACES.         
           05 WS-INDEX                  PIC 9(02) VALUE ZEROES.         
           05 WS-ZIP.                                                   
              10 WS-ZIP-CODE5           PIC X(05) VALUE SPACES.         
              10 WS-FILLERZ             PIC X(01) VALUE '-'.            
              10 WS-ZIP-CODE4           PIC X(04) VALUE SPACES.         
           05 WS-COMPANY-NO             PIC X(02) VALUE '01'.           
           05 WS-METER-SIZE.                                            
              10 WS-METER-SIZE-ID       PIC X(08) VALUE SPACES.         
              10 WS-FILLERM             PIC X(01) VALUE '-'.            
              10 WS-METER-SIZE-DESC     PIC X(25) VALUE SPACES.         
           05 WS-WORK-QUEUE-FL          PIC X(01) VALUE 'N'.            
           05 WS-PARM-NBR-DAYS.                                         
              10 WS-NBR-DAYS-STR        PIC X(09) VALUE SPACES.         
              10 WS-NBR-DAYS            PIC X(02) VALUE SPACES.         
              10 WS-FILLERN             PIC X(69) VALUE SPACES.         
           05 WS-PREV-DATE              PIC X(10) VALUE SPACES.         
           05 WS-PREV-MNTH-DATE         PIC X(10) VALUE SPACES.         
           05 WS-CRNT-TIMESTAMP         PIC X(26) VALUE SPACES.         
           05 WS-ORDER-TYPE-CD          PIC X(05) VALUE SPACES.         
           05 WS-ORDER-TYPE-CD-H        PIC X(05) VALUE SPACES.         
           05 WS-SERIAL-NO              PIC X(11) VALUE SPACES.         
           05 WS-CUST-NAME              PIC X(37).                      
           05 WS-ADDRESS-1              PIC X(30).                      
           05 WS-ADDRESS-2              PIC X(35).                      
           05 RS-RETURN-CODE            PIC S9(04) COMP VALUE 0.        
           05 RS-RETURN-CODE-DISP       PIC +Z(04).                     
           05 PROGRAM-NAME              PIC X(08) VALUE 'PCSRP144'.     
      *                                                                         
       01 WS-ORD-TYPE-CD.                                               
           05 WS-ORD-TYPE-CD-VAL OCCURS 50 TIMES PIC X(07) VALUE SPACES.
      *                                                                         
       05  WS-FMT-ACCT-NO.                                              
           10  WS-FMT-ACCT-NO-1         PIC X(1).                       
           10  FILLER                   PIC X(1)  VALUE '-'.            
           10  WS-FMT-ACCT-NO-4A        PIC X(4).                       
           10  FILLER                   PIC X(1)  VALUE '-'.            
           10  WS-FMT-ACCT-NO-4B        PIC X(4).                       
           10  FILLER                   PIC X(1)  VALUE '-'.            
           10  WS-FMT-ACCT-NO-4C        PIC X(4).                       
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-SWITCH.                                                   
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
           05  WS-FCA332-STATUS         PIC X(02).                      
               88 FCA332-SUCCESSFUL               VALUE '00'.           
           05  WS-FMT14-STATUS          PIC X(02) VALUE '00'.           
               88 FBW014-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
       01 OUTREC1.                                                      
           05 CIS-LOC-OFF               PIC X(03) VALUE SPACES.         
           05 CIS-READ-ROUTE            PIC X(04) VALUE SPACES.         
           05 CIS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05 CIS-TYPE-SVC              PIC X(01) VALUE SPACES.         
           05 CIS-METER-NO              PIC X(09) VALUE SPACES.         
           05 CIS-SERIAL-NO             PIC X(11) VALUE SPACES.         
           05 CIS-ERT-ID                PIC X(10) VALUE SPACES.         
           05 CIS-CUST-NAME             PIC X(40) VALUE SPACES.         
           05 CIS-SVC-ADDR              PIC X(50) VALUE SPACES.         
           05 CIS-SVC-ADDR-ZIP          PIC X(05) VALUE SPACES.         
           05 CIS-DATE-START            PIC X(10) VALUE SPACES.         
           05 CIS-DATE-END              PIC X(10) VALUE SPACES.         
           05 CIS-LAST-READ-DATE        PIC X(10) VALUE SPACES.         
           05 CIS-READ-DATE             PIC X(10) VALUE SPACES.         
           05 CIS-READ-B                PIC 9(08) VALUE ZEROES.         
           05 CIS-READ-B-CD             PIC X(04) VALUE SPACES.         
           05 CIS-READ-O                PIC 9(10) VALUE ZEROES.         
           05 CIS-READ-O-CD             PIC 9(02) VALUE ZEROES.         
           05 CIS-PROCESS-CD            PIC 9(01) VALUE ZEROES.         
           05 CIS-SEQ-NO                PIC 9(07) VALUE ZEROES.         
           05 CIS-TAMPER-1              PIC X(01) VALUE SPACES.         
           05 CIS-TAMPER-2              PIC X(01) VALUE SPACES.         
           05 CIS-TAMPER-O1             PIC X(02) VALUE SPACES.         
           05 CIS-TAMPER-N1             PIC X(02) VALUE SPACES.         
           05 CIS-TAMPER-C1             PIC X(01) VALUE SPACES.         
           05 CIS-TAMPER-O2             PIC X(02) VALUE SPACES.         
           05 CIS-TAMPER-N2             PIC X(02) VALUE SPACES.         
           05 CIS-TAMPER-C2             PIC X(01) VALUE SPACES.         
           05 CIS-METER-TYPE            PIC X(34) VALUE SPACES.         
           05 CIS-WORK-QUEUE-FL         PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(28) VALUE SPACES.         
      *                                                                         
       01 OUTREC2                       PIC X(294) VALUE SPACES.        
      *                                                                         
      ***************************************************************           
      *CURSOR FOR RETRIEVING ELECTRIC GROUPS                        *           
      ***************************************************************           
      *                                                                         
      *     EXEC SQL                                                            
      *      DECLARE ELEC_GRP CURSOR WITH HOLD FOR                              
      *         SELECT TG.ELEC_MTR_CLASS_CD                                     
      *               ,TG.ELEC_MTR_SPEC_CD                                      
      *               ,TG.BEGIN_PURCHASE_DT                                     
      *               ,TG.END_PURCHASE_DT                                       
      *           FROM CSS_ELEC_TST_GROUP TG                                    
      *           WHERE TG.MTR_TEST_GRP_CD = :WK-GRP-CD-HOLD                    
      *             AND TG.CODE_UTIL_TYPE  = 'E'                                
      *             AND TG.COMPANY_NO      = :WS-COMPANY-NO                     
      *           FOR FETCH ONLY WITH UR                                        
      *     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-PARA           THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
      *    MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.                  
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
      *    MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE                   
      *                                      HDR-LAST-TEST-SEL-DT.              
                                                                        
      *                                                                         
           OPEN INPUT  FCSMT14-FILE.                                    
                                                                        
           IF NOT FBW014-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSMT14-FILE.    **'          
               DISPLAY '**  FILE STATUS = ' WS-FMT14-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN OUTPUT FCSPT332-FILE.                                   
                                                                        
           IF NOT FCA332-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP657 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT332-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA332-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
           INITIALIZE FIOBW81-RECORD                                    
                      PRT331-RECORD                                     
                      PRT332-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-PARA.                                          
      *                                                                         
           PERFORM 7000-READ-FCSMT14-FILE        THRU 7000-EXIT         
           PERFORM 2100-GET-DAYS-MONTHS          THRU 2100-EXIT         
           PERFORM 2200-PROCESS-DTLS             THRU 2200-EXIT         
              UNTIL END-OF-REC.                                         
      *    PERFORM 8200-WRITE-OUTFILE-LAST-FTR   THRU 8200-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2100-GET-DAYS-MONTHS                                         *          
      ****************************************************************          
      *                                                                         
       2100-GET-DAYS-MONTHS.                                            
      *                                                                         
           IF WS-INPUT-REC-COUNT = 0                                    
             DISPLAY 'LOAD NUMBER OF DAYS'                              
             PERFORM 7100-GET-NBR-DAYS           THRU 7100-EXIT         
                                                                        
             MOVE G6-PARM-DATA            TO WS-PARM-NBR-DAYS           
             DISPLAY 'NUMBER OF DAYS = ' WS-NBR-DAYS                    
                                                                        
             DISPLAY 'GET PREVIOUS MONTHS DATE'                         
             PERFORM 7200-GET-PREV-MNTH-DATE     THRU 7200-EXIT         
             DISPLAY 'PREVIOUS MONTHS DATE = ' WS-PREV-MNTH-DATE        
                                                                        
             DISPLAY 'CURRENT DATE = ' WS-RUN-DATE                      
             DISPLAY 'CURRENT TIME = ' WS-RUN-TIME                      
                                                                        
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2200-PROCESS-DTLS.                                           *          
      ****************************************************************          
      *                                                                         
       2200-PROCESS-DTLS.                                               
      *                                                                         
           COMPUTE WS-INPUT-REC-COUNT = WS-INPUT-REC-COUNT + 1          
                                                                        
           MOVE 'N'                       TO WS-OUT                     
           MOVE SPACES                    TO OUTREC1                    
                                             OUTREC2                    
                                                                        
           MOVE E-FBW81-ERT-ID            TO CIS-ERT-ID                 
           MOVE E-FBW81-LOCAL-OFFICE      TO CIS-LOC-OFF                
           MOVE E-FBW81-READ-ROUTE        TO CIS-READ-ROUTE             
           MOVE E-FBW81-ACCOUNT-NO        TO CIS-ACCOUNT-NO             
      *NO LONGER ON FILE HAVE TO GET FROM 0074 BELOW                            
           MOVE E-FBW81-ACCOUNT-NO        TO WS-ACCT-NO-CHAR            
           MOVE WS-TIMESTAMP              TO WS-DATE-RANGE-1-TM         
           MOVE WS-TIMESTAMP-END          TO WS-DATE-RANGE-2-TM         
                                                                        
           IF WS-ACCT-NO-CHAR NOT EQUAL SPACES                          
             MOVE 'N'                     TO WS-SKIP-RECORD             
             MOVE WS-ACCT-NO-NUM          TO WS-ACCOUNT-NO              
           ELSE                                                         
             MOVE 'Y'                     TO WS-SKIP-RECORD             
           END-IF                                                       
                                                                        
           MOVE E-FBW81-COMPANY-NO        TO WS-COMPANY-NO              
                                                                        
           IF E-FBW81-METER-CATEGORY EQUAL ZEROES                       
             MOVE 'E'                     TO CIS-TYPE-SVC               
           ELSE                                                         
             MOVE 'G'                     TO CIS-TYPE-SVC               
           END-IF                                                       
                                                                        
           MOVE E-FBW81-METER-NO          TO CIS-METER-NO               
           MOVE E-FBW81-READ-METHOD       TO CIS-PROCESS-CD             
           MOVE E-FBW81-MTR-READ-SEQ      TO CIS-SEQ-NO                 
           MOVE E-FBW81-READ-DATETIME     TO WS-READ-DT                 
           MOVE WS-READ-DT                TO CIS-DATE-END               
           MOVE WS-READ-DT                TO CIS-READ-DATE              
           MOVE WS-READ-DT                TO WS-DATE-RANGE-2            
           MOVE E-FBW81-READ-CODE         TO CIS-READ-B                 
           MOVE E-FBW81-SKIP-CODE         TO CIS-READ-B-CD              
           MOVE 0                         TO CIS-READ-O                 
                                                                        
           MOVE E-FBW81-READ              TO CIS-READ-O                 
           MOVE E-FBW81-ERT-READ-STATUS   TO CIS-READ-O-CD              
           MOVE CIS-METER-NO              TO WS-METER-NO                
           MOVE CIS-TYPE-SVC              TO WS-UTIL-TYPE               
           MOVE E-FBW81-ERT-ID            TO CIS-ERT-ID                 
           MOVE E-FBW81-TAMPER-CD1        TO CIS-TAMPER-O1              
           MOVE E-FBW81-TAMPER-CD2        TO CIS-TAMPER-O2              
           MOVE E-FBW81-TAMPER-CD1-NEW    TO CIS-TAMPER-N1              
           MOVE E-FBW81-TAMPER-CD2-NEW    TO CIS-TAMPER-N2              
           MOVE E-FBW81-TAMPER-CD1-CHNG   TO CIS-TAMPER-C1              
           MOVE E-FBW81-TAMPER-CD2-CHNG   TO CIS-TAMPER-C2              
           MOVE 'N'                       TO CIS-TAMPER-1               
           MOVE 'N'                       TO CIS-TAMPER-2               
                                                                        
           IF WS-SKIP-RECORD  = 'N'                                     
             IF E-FBW81-TAMPER-CD1-CHNG = 'Y' AND                       
                E-FBW81-TAMPER-CD1 NOT EQUAL 16                         
               MOVE 'Y'                   TO CIS-TAMPER-1               
                                             WS-OUT                     
             END-IF                                                     
                                                                        
             IF E-FBW81-TAMPER-CD2-CHNG = 'Y' AND                       
                E-FBW81-TAMPER-CD2 NOT EQUAL 16                         
               MOVE 'Y'                   TO CIS-TAMPER-2               
                                             WS-OUT                     
             END-IF                                                     
                                                                        
             IF WS-OUT = 'Y'                                            
               DISPLAY '======================================'         
               DISPLAY 'ACCOUNT           = ' WS-ACCT-NO-CHAR           
               DISPLAY 'METER             = ' WS-METER-NO               
               DISPLAY 'CURRENT READ DATE = ' WS-DATE-RANGE-2           
                                                                        
               MOVE SPACES                TO WS-PREV-DATE               
                                                                        
               PERFORM 7300-GET-PREV-DATE          THRU 7300-EXIT       
               PERFORM 7350-CX-LST-READ            THRU 7350-EXIT       
                                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                 MOVE 'NOT-FOUND'          TO CIS-LAST-READ-DATE        
                 MOVE WS-PREV-DATE         TO WS-DATE-RANGE-1           
                                              CIS-DATE-START            
                 DISPLAY 'CX LAST READ DATE NOT FOUND, USING'           
                 DISPLAY ' LAST READ DATE = ' WS-DATE-RANGE-1           
               ELSE                                                     
                 IF WS-DATE-RANGE-1 = WS-DATE-RANGE-2                   
                   MOVE WS-DATE-RANGE-1    TO CIS-LAST-READ-DATE        
                   MOVE WS-PREV-DATE       TO WS-DATE-RANGE-1           
                                              CIS-DATE-START            
                                                                        
                   DISPLAY 'CX LAST READ DATE SAME AS CURRENT'          
                   DISPLAY ' READ DATE USING = ' WS-DATE-RANGE-1        
                 ELSE                                                   
                   IF WS-DATE-RANGE-1 > WS-DATE-RANGE-2                 
                     MOVE WS-DATE-RANGE-1  TO CIS-LAST-READ-DATE        
                     MOVE WS-PREV-DATE     TO WS-DATE-RANGE-1           
                                              CIS-DATE-START            
                                                                        
                     DISPLAY 'CX LAST READ DATE IS GREATER THAN CURRENT'
                     DISPLAY ' READ DATE USING = ' WS-DATE-RANGE-1      
                   ELSE                                                 
                     MOVE WS-DATE-RANGE-1  TO CIS-LAST-READ-DATE        
                     IF WS-DATE-RANGE-1 < WS-PREV-DATE                  
                       DISPLAY 'LAST READ DATE    = ' WS-DATE-RANGE-1   
                       MOVE WS-PREV-DATE   TO WS-DATE-RANGE-1           
                                                                        
                     DISPLAY 'LAST READ DATE IS MORE THAN ' WS-NBR-DAYS 
                     DISPLAY ' AGO.  USING = ' WS-DATE-RANGE-1          
                     ELSE                                               
                       DISPLAY 'LAST READ DATE    = ' WS-DATE-RANGE-1   
                     END-IF                                             
                     MOVE WS-DATE-RANGE-1  TO CIS-DATE-START            
                 END-IF                                                 
                                                                        
             MOVE 'N'                      TO WS-ORDER-TYPE-SW          
             DISPLAY 'BEGIN SEARCH FOR COMPLETED ORDERS BETWEEN '       
             DISPLAY '    ' WS-DATE-RANGE-1 ' AND ' WS-DATE-RANGE-2     
                                                                        
             MOVE SPACES                   TO WS-WORK-TYPE-CD           
                                              WS-WO-COMP-DATE           
                                              WS-ORDER-TYPE-CD          
                                                                        
             MOVE WS-UTIL-TYPE             TO VI-CODE-UTIL-TYPE         
             MOVE WS-DT-RANGE-STARTX       TO WS-DT-RANGE-START         
             MOVE WS-DT-RANGE-ENDX         TO WS-DT-RANGE-END           
                                                                        
             PERFORM 7400-GET-SO-DATA              THRU 7400-EXIT       
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               MOVE VO-ORDER-TYPE-CD       TO WS-ORDER-TYPE-CD          
               MOVE VI-WORK-TYPE-CD        TO WS-WORK-TYPE-CD           
               MOVE 'Y'                    TO WS-ORDER-TYPE-SW          
               DISPLAY '**EXCLUDED ACCT # ' WS-ACCT-NO-CHAR             
               DISPLAY ' DUE TO ORDER TYPE = ' WS-ORDER-TYPE-CD         
               DISPLAY ' COMPLETED ON DATE = ' WS-WO-COMP-DATE          
             ELSE                                                       
               DISPLAY 'ORDER TYPES  '                                  
               DISPLAY ' NOT PRESENT FOR ACCOUNT # ' WS-ACCT-NO-CHAR    
               DISPLAY ' METER # = ' WS-METER-NO                        
             END-IF                                                     
                                                                        
             IF WS-ORDER-TYPE-SW = 'N' AND                              
                WS-DATE-RANGE-1 <= WS-PREV-MNTH-DATE                    
               DISPLAY 'BEGIN SEARCH FOR COMPLETED ORDERS IN HISTORY '  
                       'BETWEEN'                                        
               DISPLAY '    ' WS-DATE-RANGE-1 ' AND ' WS-DATE-RANGE-2   
                                                                        
               MOVE SPACES                TO WS-WORK-TYPE-CD-H          
                                             WS-WO-COMP-DATE-H          
                                             WS-ORDER-TYPE-CD-H         
                                                                        
               MOVE WS-UTIL-TYPE          TO ZG-CODE-UTIL-TYPE          
                                                                        
               PERFORM 7450-GET-HST-SO-DATA        THRU 7450-EXIT       
                                                                        
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                   MOVE YV-ORDER-TYPE-CD  TO WS-ORDER-TYPE-CD-H         
                   MOVE ZG-WORK-TYPE-CD   TO WS-WORK-TYPE-CD-H          
                   MOVE 'Y'               TO WS-ORDER-TYPE-SW           
                   DISPLAY '**EXCLUDED ACCT # ' WS-ACCT-NO-CHAR         
                   DISPLAY ' DUE TO ORDER TYPE = ' WS-ORDER-TYPE-CD-H   
                   DISPLAY ' COMPLETED ON DATE = ' WS-WO-COMP-DATE      
                 ELSE                                                   
                   DISPLAY 'ORDER TYPES  '                              
                   DISPLAY ' NOT PRESENT IN HISTORY FOR ACCOUNT # '     
                   DISPLAY ' ## ' WS-ACCT-NO-CHAR                       
                   DISPLAY ' METER # = ' WS-METER-NO                    
                 END-IF                                                 
             END-IF                                                     
                                                                        
             PERFORM 7500-GET-PREMISE              THRU 7500-EXIT       
      *      MOVE SPACES                    TO WS-FMT-ADDR-LINE-1               
      *                                        WS-FMT-ADDR-LINE-2               
      *                                        WS-SVC-ADDR-LINE-1               
      *                                        WS-SVC-ADDR-LINE-2               
      *                                        WS-FMT-NAME                      
                                                                        
      *      PERFORM 7900-GET-NAME-ADDR            THRU 7900-EXIT               
             MOVE ZEROES                    TO AT-ADDRESS-ID            
                                               AT-ACCOUNT-NO            
                                               HT-NAME-ID               
                                               HT-ADDRESS-ID            
                                                                        
             MOVE E-FBW81-ACCOUNT-NO        TO AT-ACCOUNT-NO            
             PERFORM 4000-MAIL-NAME-ADDRESS        THRU 4000-EXIT       
      *                                                                         
      *      MOVE WS-SVC-ZIP-PLUS-4         TO WS-ZIP                           
             MOVE WS-ZIP-CODE               TO CIS-SVC-ADDR-ZIP         
      *      DISPLAY 'WS-ZIP-CODE ' WS-ZIP-CODE                                 
      *      MOVE WS-ZIP-CODE5              TO CIS-SVC-ADDR-ZIP                 
      *      MOVE WS-FMT-NAME               TO CIS-CUST-NAME                    
             MOVE WS-CUSTOMER-NAME          TO CIS-CUST-NAME            
      *      DISPLAY 'WS-CUSTOMER-NAME ' WS-CUSTOMER-NAME                       
             MOVE WS-PR-STREET              TO CIS-SVC-ADDR             
      *      MOVE WS-FORMATTED-ADDRESS      TO CIS-SVC-ADDR                     
      *      DISPLAY 'WS-SERVICE-ADDR1     ' WS-PR-STREET                       
      *      DISPLAY 'WS-SERVICE-ADDR2     ' WS-PR-ADDR-CITY-STATE-ZIP          
      *                                                                         
             MOVE WS-UTIL-TYPE              TO EQ-CODE-UTIL-TYPE        
             MOVE WS-COMPANY-NO             TO EQ-COMPANY-NO            
                                                                        
             PERFORM 7600-GET-EQUIPMENT            THRU 7600-EXIT       
             MOVE SPACES                    TO EQ-CODE-UTIL-TYPE        
             MOVE SPACES                    TO EQ-COMPANY-NO            
             MOVE WS-SERIAL-NO              TO CIS-SERIAL-NO            
                                                                        
             MOVE SPACES                    TO WS-METER-SIZE-ID         
                                               WS-METER-SIZE-DESC       
                                                                        
             IF WS-UTIL-TYPE = 'E'                                      
                MOVE WS-UTIL-TYPE           TO EM-CODE-UTIL-TYPE        
                MOVE WS-COMPANY-NO          TO EM-COMPANY-NO            
                PERFORM 7700-GET-ELEC-MTR-TYPE     THRU 7700-EXIT       
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                  MOVE EM-METER-SIZE-ID     TO WS-METER-SIZE-ID         
                  MOVE M1-METER-SIZE-DESC   TO WS-METER-SIZE-DESC       
                END-IF                                                  
                MOVE SPACES                 TO EM-CODE-UTIL-TYPE        
                MOVE SPACES                 TO GM-CODE-UTIL-TYPE        
             ELSE                                                       
                MOVE WS-UTIL-TYPE           TO GM-CODE-UTIL-TYPE        
                MOVE WS-COMPANY-NO          TO GM-COMPANY-NO            
                PERFORM 7750-GET-GAS-MTR-TYPE      THRU 7750-EXIT       
                MOVE SPACES                 TO EM-CODE-UTIL-TYPE        
                MOVE SPACES                 TO EM-COMPANY-NO            
             END-IF                                                     
             MOVE WS-METER-SIZE             TO CIS-METER-TYPE           
             MOVE WS-DT-RANGE-STARTX        TO WS-DT-RANGE-START        
             MOVE WS-DT-RANGE-ENDX          TO WS-DT-RANGE-END          
                                                                        
             PERFORM 7800-GET-WORK-QUEUE-FL        THRU 7800-EXIT       
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
              DISPLAY 'WORK QUEUE FOUND FOR ACCT = ' WS-ACCT-NO-CHAR    
             ELSE                                                       
              DISPLAY 'NO WORK QUEUES FOUND FOR ACCT = ' WS-ACCT-NO-CHAR
             END-IF                                                     
                                                                        
             MOVE WS-WORK-QUEUE-FL          TO CIS-WORK-QUEUE-FL        
             IF CIS-TAMPER-1 = 'Y' AND CIS-TAMPER-2 = 'N'               
              IF WS-ORDER-TYPE-SW = 'N'                                 
                 PERFORM 8100-WRITE-OUTFILE1       THRU 8100-EXIT       
                 COMPUTE WS-COUNT-1 = WS-COUNT-1 + 1                    
              END-IF                                                    
              MOVE OUTREC1                  TO OUTREC2                  
              PERFORM 8200-WRITE-OUTFILE2          THRU 8200-EXIT       
             END-IF                                                     
                                                                        
             IF CIS-TAMPER-1 = 'N' AND CIS-TAMPER-2 = 'Y'               
               IF WS-ORDER-TYPE-SW = 'N'                                
                  PERFORM 8100-WRITE-OUTFILE1      THRU 8100-EXIT       
                  COMPUTE WS-COUNT-2 = WS-COUNT-2 + 1                   
               END-IF                                                   
               MOVE OUTREC1                 TO OUTREC2                  
               PERFORM 8200-WRITE-OUTFILE2         THRU 8200-EXIT       
             END-IF                                                     
                                                                        
             IF CIS-TAMPER-1 = 'Y' AND CIS-TAMPER-2 = 'Y'               
               IF WS-ORDER-TYPE-SW = 'N'                                
                  PERFORM 8100-WRITE-OUTFILE1      THRU 8100-EXIT       
                  COMPUTE WS-COUNT-12 = WS-COUNT-12 + 1                 
               END-IF                                                   
               MOVE OUTREC1                 TO OUTREC2                  
               PERFORM 8200-WRITE-OUTFILE2         THRU 8200-EXIT       
               END-IF                                                   
              END-IF                                                    
             END-IF
             END-IF
           END-IF.                                                    
                                                                        
           PERFORM 7000-READ-FCSMT14-FILE          THRU 7000-EXIT.      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSMT06-FILE-INPUT FILE                                  *        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSMT14-FILE.                                          
      *                                                                         
           READ FCSMT14-FILE                                            
                                                                        
           IF FBW014-SUCCESSFUL  OR  END-OF-REC                         
              MOVE FIOBW81-RECORD         TO FIOBW81                    
              CONTINUE                                                  
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP144 ABORT   *********'        
               DISPLAY '** ERROR IN READING INPUT FILE     ****'        
               DISPLAY '** FILE STATUS IS ' WS-FMT14-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     *********'        
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7100-GET-NBR-DAYS.                                           *          
      ****************************************************************          
      *                                                                         
       7100-GET-NBR-DAYS.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME = 'EZTAMPER'                       
                 AND G6.COMPANY_NO   = '01'                             
                 AND G6.CMND_CODE    = 'PARM'                           
                 AND G6.STATUS       = 'A'                              
                 AND CIS.SUBSTR3(G6.PARM_DATA, 1,8) = 'NBR DAYS'             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME = 'EZTAMPER'                               
MFA-TR*          AND G6.COMPANY_NO   = '01'                                     
MFA-TR*          AND G6.CMND_CODE    = 'PARM'                                   
MFA-TR*          AND G6.STATUS       = 'A'                                      
MFA-TR*          AND SUBSTR(G6.PARM_DATA, 1,8) = 'NBR DAYS'                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7100-GET-NBR-DAYS      **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7200-GET-PREV-MNTH-DATE.                                     *          
      ****************************************************************          
      *                                                                         
       7200-GET-PREV-MNTH-DATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )                            
                INTO :WS-PREV-MNTH-DATE                                 
                FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE - 1 MONTHS                                    
MFA-TR*         INTO :WS-PREV-MNTH-DATE                                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7200-GET-PREV-MNTH-DATE**'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-GET-PREV-DATE.                                                    
      ******************************************************************        
      *                                                                         
       7300-GET-PREV-DATE.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT DATEADD( DAY, -IIF(TRY_CAST(:WS-NBR-DAYS
               AS INT) IS NULL, CIS.INTEGER(:WS-NBR-DAYS), CAST(
                                                           :WS-NBR-DAYS
               AS INT)), IIF(TRY_CONVERT(DATE, :WS-DATE-RANGE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-2
              ) <> 0) OR (LEN(:WS-DATE-RANGE-2) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-2
              ), CONVERT(DATE, :WS-DATE-RANGE-2) ) )    
                INTO :WS-PREV-DATE                                      
                FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-DATE-RANGE-2) - INT(:WS-NBR-DAYS) DAYS            
MFA-TR*         INTO :WS-PREV-DATE                                              
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7300-GET-PREV-DATE     **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7350-CX-LST-READ.                                                      
      ******************************************************************        
      *                                                                         
       7350-CX-LST-READ.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CX.DATE_READ                                       
                INTO :WS-DATE-RANGE-1                                   
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
              WHERE AT.ACCOUNT_NO       = :WS-ACCOUNT-NO                
                AND MN.ACCOUNT_NO       = AT.ACCOUNT_NO                 
                AND MN.METER_NO         = :WS-METER-NO                  
                AND CX.ACCOUNT_NO       = AT.ACCOUNT_NO                 
                AND CX.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE             
                AND CX.MTR_REF_NO       = MN.MTR_REF_NO                 
                AND CX.REG_ID_NO        = MN.REG_ID_NO                  
                AND CX.CODE_TIME_PERIOD = MN.CODE_TIME_PERIOD           
                AND CX.CODE_METER_READ  = 'J'                           
                AND CX.DATE_READ       <> IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-RANGE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-RANGE-2
              ) <> 0) OR (LEN(:WS-DATE-RANGE-2) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-RANGE-2
              ), CONVERT(DATE, :WS-DATE-RANGE-2) )              
              ORDER BY CX.DATE_READ DESC                                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CX.DATE_READ                                               
MFA-TR*         INTO :WS-DATE-RANGE-1                                           
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_CNSMPTN_HIST CX                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*       WHERE AT.ACCOUNT_NO       = :WS-ACCOUNT-NO                        
MFA-TR*         AND MN.ACCOUNT_NO       = AT.ACCOUNT_NO                         
MFA-TR*         AND MN.METER_NO         = :WS-METER-NO                          
MFA-TR*         AND CX.ACCOUNT_NO       = AT.ACCOUNT_NO                         
MFA-TR*         AND CX.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE                     
MFA-TR*         AND CX.MTR_REF_NO       = MN.MTR_REF_NO                         
MFA-TR*         AND CX.REG_ID_NO        = MN.REG_ID_NO                          
MFA-TR*         AND CX.CODE_TIME_PERIOD = MN.CODE_TIME_PERIOD                   
MFA-TR*         AND CX.CODE_METER_READ  = 'J'                                   
MFA-TR*         AND CX.DATE_READ       <> :WS-DATE-RANGE-2                      
MFA-TR*       ORDER BY CX.DATE_READ DESC                                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7350-CX-LST-READ.      **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-GET-SO-DATA.                                                      
      ******************************************************************        
      *                                                                         
       7400-GET-SO-DATA.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) VI.WORK_TYPE_CD,
              CAST(VO.COMPLETED_DATETIME AS DATE),
              VO.ORDER_TYPE_CD                                   
                INTO :VI-WORK-TYPE-CD                                   
                    ,:WS-WO-COMP-DATE                                   
                    ,:VO-ORDER-TYPE-CD                                  
                FROM CSS_SO_DATA       VO WITH(READUNCOMMITTED)                 
                    ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
              WHERE VO.ACCOUNT_NO       = :WS-ACCOUNT-NO                
                    AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',   
                                             'DNP01','EM001','EM002',   
                                             'FM001','FM002','FM003',   
                                             'FM006','FM008','FW001',   
                                             'FW004','FW007','FW008',   
                                             'FW010','FW011','FW019',   
                                             'FW020','MC001','NC001',   
                                             'OFF01','OFF02','OFF03',   
                                             'ON001')                   
                AND VI.SERV_ORDER_NO             = VO.SERV_ORDER_NO     
                AND VI.METER_NO                  = :WS-METER-NO         
                AND VI.CODE_UTIL_TYPE            = :VI-CODE-UTIL-TYPE   
                AND VO.COMPLETED_DATETIME       >= CIS.CHAR2TIMESTAMP(
                                                     :WS-DT-RANGE-START
              )   
                AND VO.COMPLETED_DATETIME       <= CIS.CHAR2TIMESTAMP(
                                                       :WS-DT-RANGE-END
              )     
                AND VO.ORDER_STATE_CD            = 'Z'                  
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VI.WORK_TYPE_CD                                            
MFA-TR*             ,DATE(VO.COMPLETED_DATETIME)                                
MFA-TR*             ,VO.ORDER_TYPE_CD                                           
MFA-TR*         INTO :VI-WORK-TYPE-CD                                           
MFA-TR*             ,:WS-WO-COMP-DATE                                           
MFA-TR*             ,:VO-ORDER-TYPE-CD                                          
MFA-TR*         FROM CSS_SO_DATA       VO                                       
MFA-TR*             ,CSS_SO_ORDER_INST VI                                       
MFA-TR*       WHERE VO.ACCOUNT_NO       = :WS-ACCOUNT-NO                        
MFA-TR*             AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',           
MFA-TR*                                      'DNP01','EM001','EM002',           
MFA-TR*                                      'FM001','FM002','FM003',           
MFA-TR*                                      'FM006','FM008','FW001',           
MFA-TR*                                      'FW004','FW007','FW008',           
MFA-TR*                                      'FW010','FW011','FW019',           
MFA-TR*                                      'FW020','MC001','NC001',           
MFA-TR*                                      'OFF01','OFF02','OFF03',           
MFA-TR*                                      'ON001')                           
MFA-TR*         AND VI.SERV_ORDER_NO             = VO.SERV_ORDER_NO             
MFA-TR*         AND VI.METER_NO                  = :WS-METER-NO                 
MFA-TR*         AND VI.CODE_UTIL_TYPE            = :VI-CODE-UTIL-TYPE           
MFA-TR*         AND VO.COMPLETED_DATETIME       >= :WS-DT-RANGE-START           
MFA-TR*         AND VO.COMPLETED_DATETIME       <= :WS-DT-RANGE-END             
MFA-TR*         AND VO.ORDER_STATE_CD            = 'Z'                          
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7400-GET-SO-DATA       **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7450-GET-HST-SO-DATA                                                   
      ******************************************************************        
      *                                                                         
       7450-GET-HST-SO-DATA.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) VI.WORK_TYPE_CD,
              CAST(VO.COMPLETED_DATETIME AS DATE),
              VO.ORDER_TYPE_CD                                   
                INTO :ZG-WORK-TYPE-CD                                   
                    ,:WS-WO-COMP-DATE-H                                 
                    ,:YV-ORDER-TYPE-CD                                  
                FROM HST_SO_DATA       VO WITH(READUNCOMMITTED)                 
                    ,HST_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
              WHERE VO.ACCOUNT_NO       = :WS-ACCOUNT-NO                
                    AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',   
                                             'DNP01','EM001','EM002',   
                                             'FM001','FM002','FM003',   
                                             'FM006','FM008','FW001',   
                                             'FW004','FW007','FW008',   
                                             'FW010','FW011','FW019',   
                                             'FW020','MC001','NC001',   
                                             'OFF01','OFF02','OFF03',   
                                             'ON001')                   
                AND VI.SERV_ORDER_NO             = VO.SERV_ORDER_NO     
                AND VI.METER_NO                  = :WS-METER-NO         
                AND VI.CODE_UTIL_TYPE            = :ZG-CODE-UTIL-TYPE   
                AND VO.COMPLETED_DATETIME       >= CIS.CHAR2TIMESTAMP(
                                                     :WS-DT-RANGE-START
              )   
                AND VO.COMPLETED_DATETIME       <= CIS.CHAR2TIMESTAMP(
                                                       :WS-DT-RANGE-END
              )     
                AND VO.ORDER_STATE_CD            = 'Z'                  
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VI.WORK_TYPE_CD                                            
MFA-TR*             ,DATE(VO.COMPLETED_DATETIME)                                
MFA-TR*             ,VO.ORDER_TYPE_CD                                           
MFA-TR*         INTO :ZG-WORK-TYPE-CD                                           
MFA-TR*             ,:WS-WO-COMP-DATE-H                                         
MFA-TR*             ,:YV-ORDER-TYPE-CD                                          
MFA-TR*         FROM HST_SO_DATA       VO                                       
MFA-TR*             ,HST_SO_ORDER_INST VI                                       
MFA-TR*       WHERE VO.ACCOUNT_NO       = :WS-ACCOUNT-NO                        
MFA-TR*             AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',           
MFA-TR*                                      'DNP01','EM001','EM002',           
MFA-TR*                                      'FM001','FM002','FM003',           
MFA-TR*                                      'FM006','FM008','FW001',           
MFA-TR*                                      'FW004','FW007','FW008',           
MFA-TR*                                      'FW010','FW011','FW019',           
MFA-TR*                                      'FW020','MC001','NC001',           
MFA-TR*                                      'OFF01','OFF02','OFF03',           
MFA-TR*                                      'ON001')                           
MFA-TR*         AND VI.SERV_ORDER_NO             = VO.SERV_ORDER_NO             
MFA-TR*         AND VI.METER_NO                  = :WS-METER-NO                 
MFA-TR*         AND VI.CODE_UTIL_TYPE            = :ZG-CODE-UTIL-TYPE           
MFA-TR*         AND VO.COMPLETED_DATETIME       >= :WS-DT-RANGE-START           
MFA-TR*         AND VO.COMPLETED_DATETIME       <= :WS-DT-RANGE-END             
MFA-TR*         AND VO.ORDER_STATE_CD            = 'Z'                          
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7450-GET-HST-SO-DATA   **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7500-GET-PREMISE                                                       
      ******************************************************************        
      *                                                                         
       7500-GET-PREMISE.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT PREMISE_NO                                         
                INTO :WS-PREMISE-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :WS-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*       WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7500-GET-PREMISE       **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7600-GET-EQUIPMENT.                                                    
      ******************************************************************        
      *                                                                         
       7600-GET-EQUIPMENT.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) EQ.SERIAL_NO                                       
                INTO :WS-SERIAL-NO                                      
                FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
              WHERE EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
                AND EQ.DEVICE_NO      = :WS-METER-NO                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQ.SERIAL_NO                                               
MFA-TR*         INTO :WS-SERIAL-NO                                              
MFA-TR*         FROM CSS_EQUIPMENT EQ                                           
MFA-TR*       WHERE EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*         AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*         AND EQ.DEVICE_NO      = :WS-METER-NO                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7600-GET-EQUIPMENT     **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-GET-ELEC-MTR-TYPE                                                 
      ******************************************************************        
      *                                                                         
       7700-GET-ELEC-MTR-TYPE.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) EM.METER_SIZE_ID,
              M1.METER_SIZE_DESC                                 
                INTO :EM-METER-SIZE-ID                                  
                    ,:M1-METER-SIZE-DESC                                
                FROM CSS_ELEC_METER    EM WITH(READUNCOMMITTED)                 
                    ,CSS_ELEC_MTR_SIZE M1 WITH(READUNCOMMITTED)                 
              WHERE EM.METER_NO       = :WS-METER-NO                    
                AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE              
                AND EM.COMPANY_NO     = :EM-COMPANY-NO                  
                AND EM.METER_SIZE_ID  = M1.METER_SIZE_ID                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.METER_SIZE_ID                                           
MFA-TR*             ,M1.METER_SIZE_DESC                                         
MFA-TR*         INTO :EM-METER-SIZE-ID                                          
MFA-TR*             ,:M1-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_ELEC_METER    EM                                       
MFA-TR*             ,CSS_ELEC_MTR_SIZE M1                                       
MFA-TR*       WHERE EM.METER_NO       = :WS-METER-NO                            
MFA-TR*         AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                      
MFA-TR*         AND EM.COMPANY_NO     = :EM-COMPANY-NO                          
MFA-TR*         AND EM.METER_SIZE_ID  = M1.METER_SIZE_ID                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7700-GET-ELEC-MTR-TYPE **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7750-GET-GAS-MTR-TYPE                                                  
      ******************************************************************        
      *                                                                         
       7750-GET-GAS-MTR-TYPE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) GM.METER_SIZE_ID,
              M5.METER_SIZE_DESC                                 
                INTO :WS-METER-SIZE-ID                                  
                    ,:WS-METER-SIZE-DESC                                
                FROM CSS_GAS_METER      GM WITH(READUNCOMMITTED)                
                    ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
              WHERE GM.METER_NO       = :WS-METER-NO                    
                AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE              
                AND GM.COMPANY_NO     = :GM-COMPANY-NO                  
                AND GM.COMPANY_NO     = M5.COMPANY_NO                   
                AND GM.METER_SIZE_ID  = M5.METER_SIZE_ID                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GM.METER_SIZE_ID                                           
MFA-TR*             ,M5.METER_SIZE_DESC                                         
MFA-TR*         INTO :WS-METER-SIZE-ID                                          
MFA-TR*             ,:WS-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_GAS_METER      GM                                      
MFA-TR*             ,CSS_GAS_METER_SIZE M5                                      
MFA-TR*       WHERE GM.METER_NO       = :WS-METER-NO                            
MFA-TR*         AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                      
MFA-TR*         AND GM.COMPANY_NO     = :GM-COMPANY-NO                          
MFA-TR*         AND GM.COMPANY_NO     = M5.COMPANY_NO                           
MFA-TR*         AND GM.METER_SIZE_ID  = M5.METER_SIZE_ID                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7750-GET-GAS-MTR-TYPE  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7800-GET-WORK-QUEUE-FL                                                 
      ******************************************************************        
      *                                                                         
       7800-GET-WORK-QUEUE-FL.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-WORK-QUEUE-FL                                  
                FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
              WHERE WQ.ACCOUNT_NO     = :WS-ACCOUNT-NO                  
                AND WQ.CATEGORY_ID       IN (33,173,134,239,            
                                            141,142,276,277,            
                                            278)                        
                AND WQ.DATE_CREATED  >= CIS.CHAR2TIMESTAMP(
                                                     :WS-DT-RANGE-START
              )              
                AND WQ.DATE_CREATED  <= CIS.CHAR2TIMESTAMP(
                                                       :WS-DT-RANGE-END
              )                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-WORK-QUEUE-FL                                          
MFA-TR*         FROM CSS_WQ_ITEMS WQ                                            
MFA-TR*       WHERE WQ.ACCOUNT_NO     = :WS-ACCOUNT-NO                          
MFA-TR*         AND WQ.CATEGORY_ID       IN (33,173,134,239,                    
MFA-TR*                                     141,142,276,277,                    
MFA-TR*                                     278)                                
MFA-TR*         AND WQ.DATE_CREATED  >= :WS-DT-RANGE-START                      
MFA-TR*         AND WQ.DATE_CREATED  <= :WS-DT-RANGE-END                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP657 ABORT *****'                   
              DISPLAY '**  7800-GET-WORK-QUEUE-FL **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  WS-DT-RANGE-START ' WS-DT-RANGE-START        
              DISPLAY '**  WS-DT-RANGE-END   ' WS-DT-RANGE-END          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **   8100-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM OUTREC1.                            
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8200-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT332-RECORD FROM OUTREC2.                            
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSPT332-FILE.                                         
                                                                        
           IF NOT FCA332-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA332-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ******************************************************************        
      * REDUCE EMBEDDED SPACES.                                        *        
      ******************************************************************        
       COPY CPD00004.                                                           
                                                                        
      ******************************************************************        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COPY BOOK FOR MAILING ADDRESS                                  *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
                                                                        
