       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP140.                                        
       DATE-WRITTEN.   12/20/94.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  12/20/94     SR        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  ---------    ----------------------------------  **         
      **  06/15/95     DW        DELETED FIOPT33, FIOJC01, TBJBPARM, **         
      **                         CPD00038 & CPD00024. ADDED CWS00303.**         
      **                         CHANGED DATE FORMAT TO GET CORRECT  **         
      **                         RUN-DATE. MOVED SQL TO PROPER POS-  **         
      **                         ITION. CHANGED CPD09900 FROM COPY   **         
      **                         TO INCLUDE AND CORRECTED SPACING &  **         
      **                         SPELLING ERRORS.                    **         
      ** 11/05/96   RAO JADA     CORRECTED TPR6064 CHANGES           **         
T27240** 12/03/02   COVANSYS     ADD ARREARS HISTORY COLUMN IN THE   **         
T27240**            CHENNAI      REPORT                              **         
C28301** 08/15/03   R.SPIRES     ADD ELECTRONIC BILLING INDICATOR    **         
C28301**                         TO REPORT.                          **         
C34656** 08/02/06   R.SPIRES     ADD STATUS_CD TO SELECTION CRITERIA.**         
A04388** 08/30/12   DB41297      ADD NEW FIELDS TO SELECTION CRITERIA**         
AM4388** 10/16/12   DB41297      ADD TURN ON DT TO SELECTION CRITERIA**         
A04388** 10/31/12   DB41297      FIX ISSUE WITH CONS ACCOUNTS NOT HAVING        
A04388**                         A UTILITY ROW.                                 
ACT106** 05/20/14   BD09555      REPORT ONLY ARREARS OVER $6.00                 
ACT106** A04880-ACT106                                                          
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSCA140 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP20.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP20.                                                            
       COPY FIORP20.                                                            
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP140'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP140 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE   PIC X(26)    VALUE               
               'SOUTH CAROLINA ELEC. & GAS'.                            
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(65)    VALUE               
               '              MAJOR ACCOUNTS ARREARS REGISTER     '.    
                                                                        
TP6064     05  WS-DEFAULT-RPT1-TITLE2.                                  
TP6064         10  FILLER              PIC X(21)    VALUE SPACES.       
TP6064         10  FILLER              PIC X(14)    VALUE               
TP6064                                'CURRENT AS OF '.                 
TP6064         10  WS-DEFAULT-RPT1-TITLE2-DT PIC X(08).                 
TP6064         10  FILLER              PIC X(22) VALUE SPACES.          
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE '  '.         
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE '  '.         
           05  WS-SYSIN-COMP-REC-CNTR  PIC S9(07)   VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC S9(07)   VALUE ZERO COMP-3.  
           05  WS-FRP20-REC-CNTR       PIC S9(07)   VALUE ZERO COMP-3.  
A04388     05  WS-DEPOSIT-AMT-NULL     PIC S9(4)   COMP   VALUE 0.      
A04388     05  WS-AMT-DEPOSIT          PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-FRP20-STATUS         PIC X(02).                       
               88  FRP20-SUCCESSFUL                 VALUE '00'.         
      *                                                                         
           05  WS-NAME-CONTACT-HOLD    PIC X(26)    VALUE SPACES.       
           05  WS-NUMBER-ACCOUNTS      PIC 9(04)    VALUE ZERO.         
ACT106     05  WS-ARREARS-MINIMUM      PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-00-DAY-TOTAL         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-30-DAY-TOTAL         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-60-DAY-TOTAL         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-90-DAY-TOTAL         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-TOT-DAY-TOTAL        PIC S9(09)V99 COMP-3 VALUE 0.    
T27240     05  WS-ACCOUNT-NO           PIC S9(13)V   USAGE COMP-3       
T27240                                               VALUE 0.           
C28301     05  WS-EDI-SW               PIC X         VALUE 'N'.         
C28301         88  EDI-ACCT                          VALUE 'Y'.         
C28301         88  NON-EDI-ACCT                      VALUE 'N'.         
A04388     05 PROGRAM-NAME                PIC X(8)  VALUE 'PCSRP140'.   
A04388     05 SCSCA666                    PIC X(8)  VALUE 'SCSCA666'.   
A04388*                                                                         
A04388 01 WS-SCSCA666-AREA.                                             
A04388    05 WS-SCSCA666-ACCOUNT-NO    PIC S9(13)V  COMP-3 VALUE 0.     
A04388    05 WS-SCSCA666-PREMISE-NO    PIC S9(10)V  COMP-3 VALUE 0.     
A04388    05 WS-SCSCA666-BILL-CYCLE    PIC 99              VALUE 0.     
A04388    05 WS-SCSCA666-INPUT-DATE    PIC X(10).                       
A04388    05 WS-SCSCA666-MAX-DEPOSIT   PIC S9(9)V99 COMP-3 VALUE 0.     
A04388    05 WS-SCSCA666-RETURN-CODE   PIC S9(9)    COMP   VALUE +000.  
A04388    05 WS-SCSCA666-DATABASE      PIC 9               VALUE 0.     
A04388       88 CSR-DATABASE         VALUE 1.                           
A04388       88 SEB-DATABASE         VALUE 2.                           
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
T27240*    CSS_CREDIT_PROFILE - CZ                                              
T27240     EXEC SQL                                                             
T27240         INCLUDE TBCRPROF                                                 
T27240     END-EXEC.                                                            
A04388*                                                                         
A04388     EXEC SQL                                                             
A04388         INCLUDE TBDELQ                                                   
A04388     END-EXEC.                                                            
                                                                        
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301* CSS_EDI_ACCT_DEST                                             *         
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301                                                                  
C28301     EXEC SQL                                                             
C28301         INCLUDE TBACDEST                                                 
C28301     END-EXEC.                                                            
C28301                                                                  
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301* CSS_ACCOUNT                                                   *         
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301                                                                  
C28301     EXEC SQL                                                             
C28301         INCLUDE TBACCT                                                   
C28301     END-EXEC.                                                            
C28301                                                                  
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301* CSS-UTIL-ENVRNMT                                              *         
C28301*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C28301                                                                  
C28301     EXEC SQL                                                             
C28301         INCLUDE TBUTLENV                                                 
C28301     END-EXEC.                                                            
C28301                                                                  
      ****************************************************************          
       01  WS-RPT1-LINE-NO             PIC S9(02)   VALUE 60   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC S9(02)   VALUE ZERO COMP-3.  
      ****************************************************************          
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP140'.   
           05  WS-13                   PIC 9(02)    VALUE 13.           
           05  WS-54                   PIC 9(02)    VALUE 54.           
                                                                        
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
               VALUE '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      ***************** PCSCA140 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
A04388     05  WS-RPT1-TITLE.                                           
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-RPT1-TITLE-PGNM   PIC X(08).                       
A04388         10  FILLER              PIC X(45)    VALUE SPACES.       
A04388         10  P-RPT1-TITLE        PIC X(26).                       
A04388         10  FILLER              PIC X(35)    VALUE SPACES.       
A04388         10  FILLER              PIC X(10)    VALUE 'RUN DATE: '. 
A04388         10  P-RPT1-RUN-DATE     PIC X(08).                       
A04388*                                                                         
A04388****************************************************************          
A04388**           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
A04388****************************************************************          
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-1.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(06)    VALUE 'DATE: '.     
A04388         10  P-RPT1-DATE         PIC X(08).                       
A04388         10  FILLER              PIC X(23)    VALUE SPACES.       
A04388         10  P-RPT1-HEAD1        PIC X(65).                       
A04388         10  FILLER              PIC X(12)    VALUE SPACES.       
A04388         10  FILLER              PIC X(10)    VALUE 'RUN TIME: '. 
A04388         10  P-RPT1-RUN-TIME     PIC X(08).                       
A04388*                                                                         
A04388****************************************************************          
A04388**           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
A04388****************************************************************          
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-2.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(34)    VALUE SPACES.       
A04388         10  P-RPT1-HEAD2        PIC X(65).                       
A04388         10  FILLER              PIC X(19)    VALUE SPACES.       
A04388         10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
A04388         10  FILLER              PIC X(02)    VALUE SPACES.       
A04388         10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
A04388*                                                                         
A04388****************************************************************          
A04388**       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
A04388****************************************************************          
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-31.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                              'CONTACT NAME: '.                   
A04388         10  P-CONTACT-NAME      PIC X(50)    VALUE SPACES.       
A04388         10  FILLER              PIC X(68)    VALUE SPACES.       
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-32.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                             'LOCAL OFFICE  '.    
A04388         10  FILLER              PIC X(02)    VALUE SPACES.       
A04388         10  FILLER              PIC X(04)    VALUE 'NAME'.       
A04388         10  FILLER              PIC X(31)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                            'ACCOUNT STATUS'.     
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                         'DEPOSIT AMT  '.         
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                           'DATE LAST PMT '.      
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(06)    VALUE '00 DAY'.     
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-33.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                             'ACCOUNT NUMBER'.    
A04388         10  FILLER              PIC X(02)    VALUE SPACES.       
A04388         10  FILLER              PIC X(07)    VALUE 'ADDRESS'.    
A04388         10  FILLER              PIC X(28)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                            'ACCOUNT TYPE  '.     
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                         'MAX DEP AMT'.           
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE 'AMT PMT '.   
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(06)    VALUE '30 DAY'.     
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-34.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                             'EDI BILL      '.    
A04388         10  FILLER              PIC X(02)    VALUE SPACES.       
A04388         10  FILLER              PIC X(05)    VALUE 'CITY,'.      
A04388         10  FILLER              PIC X(06)    VALUE ' STATE'.     
A04388         10  FILLER              PIC X(24)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE 'CREDIT GRP'. 
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(15)    VALUE               
A04388                                            'ARREARS HISTORY'.    
A04388         10  FILLER              PIC X(09)    VALUE SPACES.       
A04388         10  FILLER              PIC X(16)    VALUE               
A04388                                         'LAST BILL DUE DT'.      
A04388         10  FILLER              PIC X(08)    VALUE SPACES.       
A04388         10  FILLER              PIC X(06)    VALUE '60 DAY'.     
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-35.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                             'MAJOR ACCT IND'.    
A04388         10  FILLER              PIC X(37)    VALUE SPACES.       
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                           'RATE PLAN'.           
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  FILLER              PIC X(18)    VALUE               
A04388                                            'CREDIT HISTORY '.    
A04388         10  FILLER              PIC X(30)    VALUE SPACES.       
A04388         10  FILLER              PIC X(06)    VALUE '90 DAY'.     
A04388*                                                                         
A04388     05  WS-RPT1-HEADER-36.                                       
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                             'CT METER      '.    
AM4388         10  FILLER              PIC X(37)    VALUE SPACES.       
AM4388         10  FILLER              PIC X(14)    VALUE               
AM4388                                           'TURN ON DT'.          
AM4388         10  FILLER              PIC X(54)   VALUE SPACES.        
A04388         10  FILLER              PIC X(14)    VALUE               
A04388                                            'TOTAL ARREARS'.      
A04388*                                                                         
A04388****************************************************************          
A04388**          WORKING STORAGE FOR  DETAIL LINES                 **          
A04388****************************************************************          
A04388*                                                                         
A04388 01  WS-DETAIL-LINES.                                             
A04388*                                                                         
A04388     05  WS-DETAIL-LINE-1.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-LOCAL-OFFICE      PIC X(03).                       
A04388         10  FILLER              PIC X(13)    VALUE SPACES.       
A04388         10  P-NAME              PIC X(31).                       
A04388         10  FILLER              PIC X(04)    VALUE SPACES.       
A04388         10  P-ACCT-STATUS       PIC X(13).                       
A04388         10  FILLER              PIC X(17)    VALUE SPACES.       
A04388         10  P-MIN-DEPOSIT       PIC ZZZ,ZZ9.99.                  
A04388         10  FILLER              PIC X(13)    VALUE SPACES.       
A04388         10  P-DATE-LAST-PMT     PIC X(08).                       
A04388         10  FILLER              PIC X(07)    VALUE SPACES.       
A04388         10  P-00-DAY-DETAIL     PIC ZZ,ZZZ,ZZZ.99-.              
A04388*                                                                         
A04388     05  WS-DETAIL-LINE-2.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-ACCOUNT-NO        PIC 9(13).                       
A04388         10  FILLER              PIC X(03)    VALUE SPACES.       
A04388         10  P-ADDR-STREET       PIC X(34).                       
A04388         10  FILLER              PIC X(01)    VALUE SPACES.       
A04388         10  P-ACCT-TYPE         PIC X(11).                       
A04388         10  FILLER              PIC X(19)    VALUE SPACES.       
A04388         10  P-MAX-DEPOSIT       PIC ZZZ,ZZ9.99.                  
A04388         10  FILLER              PIC X(08)    VALUE SPACES.       
A04388         10  P-AMT-LAST-PMT      PIC ZZ,ZZZ,ZZZ.99-.              
A04388         10  FILLER              PIC X(06)    VALUE SPACES.       
A04388         10  P-30-DAY-DETAIL     PIC ZZ,ZZZ,ZZZ.99-.              
A04388*                                                                         
A04388     05  WS-DETAIL-LINE-3.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-EBL-ACCT          PIC X(13).                       
A04388         10  FILLER              PIC X(03)    VALUE SPACES.       
A04388         10  P-ADDR-CITY-STATE   PIC X(25).                       
A04388         10  FILLER              PIC X(10)    VALUE SPACES.       
A04388         10  P-CREDIT-GROUP      PIC X(11).                       
A04388         10  FILLER              PIC X(11)    VALUE SPACES.       
A04388         10  P-ACCT-ARRS-HIST    PIC X(24)    VALUE SPACES.       
A04388         10  FILLER              PIC X(07)    VALUE SPACES.       
A04388         10  P-DATE-LAST-BILL    PIC X(08).                       
A04388         10  FILLER              PIC X(07)    VALUE SPACES.       
A04388         10  P-60-DAY-DETAIL     PIC ZZ,ZZZ,ZZZ.99-.              
A04388*                                                                         
A04388     05  WS-DETAIL-LINE-4.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-MAJ-ACCT          PIC X(13).                       
A04388         10  FILLER              PIC X(03)    VALUE SPACES.       
A04388         10  FILLER              PIC X(35)    VALUE SPACES.       
A04388         10  P-RATE-PLAN         PIC X(03).                       
A04388         10  FILLER              PIC X(19)    VALUE SPACES.       
A04388         10  P-CRED-HIST         PIC X(24)    VALUE SPACES.       
A04388         10  FILLER              PIC X(22)    VALUE SPACES.       
A04388         10  P-90-DAY-DETAIL     PIC ZZ,ZZZ,ZZZ.99-.              
A04388*                                                                         
A04388     05  WS-DETAIL-LINE-5.                                        
A04388         10  FILLER              PIC X        VALUE ' '.          
A04388         10  P-CT-METER          PIC X(08).                       
AM4388         10  FILLER              PIC X(43)    VALUE SPACES.       
AM4388         10  P-TURN-ON-DT        PIC X(10).                       
AM4388         10  FILLER              PIC X(71)   VALUE SPACES.        
A04388         10  P-TOTAL-DETAIL      PIC ZZ,ZZZ,ZZZ.99-.              
      *                                                                         
      ****************************************************************          
      **            WORKING STORAGE FOR TOTAL LINES                 **          
      ****************************************************************          
      *                                                                         
       01  WS-TOTAL-LINE.                                               
A04388     05  FILLER                   PIC X        VALUE ' '.         
           05  FILLER                   PIC X(21)   VALUE               
                                        ' NUMBER OF ACCOUNTS  '.        
           05  P-NUMBER-ACCOUNTS        PIC ZZZ9.                       
A04388     05  FILLER                   PIC X(38)   VALUE SPACES.       
           05  P-00-DAY-TOTAL           PIC ZZ,ZZZ,ZZZ.99-.             
           05  P-30-DAY-TOTAL           PIC ZZ,ZZZ,ZZZ.99-.             
           05  P-60-DAY-TOTAL           PIC ZZ,ZZZ,ZZZ.99-.             
           05  P-90-DAY-TOTAL           PIC ZZ,ZZZ,ZZZ.99-.             
           05  P-TOT-DAY-TOTAL          PIC ZZ,ZZZ,ZZZ.99-.             
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
A04388************************************************************              
A04388**  WORKING STORAGE AREA USED IN CONJUNCTION WITH CPD00308                
A04388************************************************************              
A04388     EXEC SQL                                                             
A04388        INCLUDE CWS00308                                                  
A04388     END-EXEC.                                                            
A04388*                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP140 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSRP20             THRU 7100-EXIT.        
           MOVE E-FRP20-NAME-CONTACT   TO WS-NAME-CONTACT-HOLD.         
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                   UNTIL NO-MORE-DATA.                                  
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FRP20-REC-CNTR EQUAL ZERO                          
                   PERFORM 8100-PRINT-TITLE      THRU 8100-EXIT         
                   PERFORM 8200-PRINT-HEADERS    THRU 8200-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                       AFTER ADVANCING 2 LINES                          
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                       AFTER ADVANCING 2 LINES
               END-IF                          
           ELSE                                                         
               IF WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                     
                   PERFORM 8100-PRINT-TITLE      THRU 8100-EXIT         
                   PERFORM 8200-PRINT-HEADERS    THRU 8200-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                       AFTER ADVANCING 2 LINES                          
               ELSE                                                     
                   PERFORM 8950-PRINT-TOTAL-LINE THRU 8950-EXIT         
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                       AFTER ADVANCING 3 LINES                          
           END-IF
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP140 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP140 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
A04388     PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSRP20-FILE.                                     
           IF FRP20-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP140 PROCESSING ERROR      **'     
               DISPLAY '**  OPEN ERROR OF FCSRP20 - INPUT FILE  **'     
               DISPLAY '**    FILE STATUS = ' WS-FRP20-STATUS           
               DISPLAY '**         PROCESSING TERMINATED        **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
A04388     MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
A04388     MOVE WS-SYSIN-COMP-NO              TO C8-COMPANY-NO.         
A04388     PERFORM 3549-CALL-DELIQUENCY       THRU 3549-EXIT.           
A04388     MOVE C8-DELINQ-VALUE               TO WS-SCSCA666-DATABASE.  
ACT106     MOVE 'AMT-ARREARS-PCSRP140'        TO C8-DELINQ-CD.          
ACT106     PERFORM 3549-CALL-DELIQUENCY       THRU 3549-EXIT.           
ACT106     MOVE C8-DELINQ-VALUE               TO WS-ARREARS-MINIMUM.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSRP20-FILE          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-READ-FCSRP20             THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP20-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FRP20-REC-CNTR                        
               MOVE E-FRP20-CREATE-DATE-BREC                            
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
TP6064         MOVE WS-DATE-8          TO WS-DEFAULT-RPT1-TITLE2-DT     
           ELSE                                                         
               DISPLAY '**       PCSRP114 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP140 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF  E-FRP20-CO-KEY-EREC EQUAL HIGH-VALUES OR             
                   E-FRP20-KEY-EREC    EQUAL HIGH-VALUES                
                   PERFORM 1700-CHECK-END-REC    THRU 1700-EXIT         
               ELSE                                                     
                   IF REPORT-STARTED                                    
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       MOVE WS-Y       TO WS-START-REPORT               
                       MOVE E-FRP20-COMPANY-NO                          
                                       TO WS-CURRENT-COMP-NO            
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE E-FRP20-NAME-CONTACT   TO WS-NAME-CONTACT-HOLD.         
           PERFORM 7100-READ-FCSRP20             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       IT CHECKS WHETHER PROCESS END REC OR COMPANY END REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           MOVE '1700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP20-CO-NO-KEY-EREC EQUAL HIGH-VALUES                  
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           MOVE '1800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP20-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FRP20-CO-REC-COUNT-EREC          
               IF E-FRP20-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   MOVE WS-Y           TO WS-END-OF-SYSIN-REC           
               END-IF                                                   
           ELSE                                                         
               IF E-FRP20-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   DISPLAY '**      PCSRP140 PROCESSING ERROR       **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP20-CO-NO-KEY-EREC   
                   DISPLAY '** ACTUAL REC COUNT OF THE CO. DOES NOT **' 
                   DISPLAY '**          MATCH CONTROL RECORD        **' 
                   DISPLAY '** CONTROL REC COUNT = '                    
                                      E-FRP20-CO-REC-COUNT-EREC         
                   DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR   
                   DISPLAY '**        PROCESSING TERMINATED         **' 
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   DISPLAY '**      PCSRP140 PROCESSING ERROR       **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP20-CO-NO-KEY-EREC   
                   DISPLAY '** ACTUAL REC COUNT OF THE CO. DOES NOT **' 
                   DISPLAY '**          MATCH CONTROL RECORD        **' 
                   DISPLAY '** CONTROL REC COUNT = '                    
                                      E-FRP20-CO-REC-COUNT-EREC         
                   DISPLAY '** ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR   
                   DISPLAY '**        PROCESSING CONTINUES          **' 
               END-IF                                                   
           END-IF.                                                      
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           MOVE '1900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP20-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**        PCSRP140 PROCESSING ERROR         **' 
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD   **' 
               DISPLAY '**          PROCESSING TERMINATED           **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FRP20-REC-CNTR EQUAL E-FRP20-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP140 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP20-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP20-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE E-FRP20-COMPANY-NO TO WS-CURRENT-COMP-NO            
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
           END-IF.                                                      
      *                                                                         
           IF E-FRP20-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO           
               DISPLAY '**      PCSRP140 PROCESSING ERROR      **'      
               DISPLAY '** COMPANY DATA RECORDS NOT SEPARATED  **'      
               DISPLAY '**     WITH PROPER COMPANY END-REC     **'      
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FRP20-COMPANY-NO  
               DISPLAY '** DATA IS :  FIOCA54-DATA-REC'                 
               DISPLAY '**       PROCESSING TERMINATED         **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF E-FRP20-COMPANY-NO EQUAL WS-SYSIN-COMP-NO             
                   IF NOT-END-OF-SYSIN                                  
ACT106                 IF E-FRP20-30-DAY-DETAIL +                       
ACT106                    E-FRP20-60-DAY-DETAIL +                       
ACT106                    E-FRP20-90-DAY-DETAIL > WS-ARREARS-MINIMUM    
                              PERFORM 2200-PRODUCE-RPT THRU 2200-EXIT   
ACT106                 END-IF                                           
                       ADD 1           TO WS-SYSIN-COMP-REC-CNTR        
                   ELSE                                                 
                       DISPLAY '**    PCSRP140 PROCESSING ERROR      **'
                       DISPLAY '**  INPUT FILE NOT SORTED PROPERLY   **'
                       DISPLAY '**    IN ORDER OF COMPANY NUMBERS    **'
                       DISPLAY '**    DATA IS :  FIOCA54-DATA-REC    **'
                       DISPLAY '**       PROCESSING TERMINATED       **'
                       PERFORM 9900-ABEND        THRU 9900-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-54                        
               PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT         
               PERFORM 8200-PRINT-HEADERS        THRU 8200-EXIT         
           END-IF.                                                      
      *                                                                         
           IF E-FRP20-NAME-CONTACT NOT EQUAL WS-NAME-CONTACT-HOLD       
               AND WS-RPT1-LINE-NO GREATER THAN WS-13                   
               PERFORM 8100-PRINT-TITLE          THRU 8100-EXIT         
               PERFORM 8200-PRINT-HEADERS        THRU 8200-EXIT         
               PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT         
               PERFORM 8900-PRINT-RPT1-DETAIL    THRU 8900-EXIT         
           ELSE                                                         
               PERFORM 2300-FORMAT-DETAIL-LINE   THRU 2300-EXIT         
               PERFORM 8900-PRINT-RPT1-DETAIL    THRU 8900-EXIT         
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP140       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP20-ACCOUNT-NO     TO P-ACCOUNT-NO.                 
TP6064     EVALUATE E-FRP20-ACCT-STATUS                                 
TP6064       WHEN 'A'                                                   
TP6064          MOVE 'ACTIVE'          TO P-ACCT-STATUS                 
TP6064       WHEN 'B'                                                   
TP6064          MOVE 'FINAL BILLED'    TO P-ACCT-STATUS                 
TP6064       WHEN 'J'                                                   
TP6064          MOVE 'INACTIVE'        TO P-ACCT-STATUS                 
TP6064       WHEN 'P'                                                   
TP6064          MOVE 'PENDING'         TO P-ACCT-STATUS                 
TP6064       WHEN 'S'                                                   
TP6064          MOVE 'WRITTEN OFF'     TO P-ACCT-STATUS                 
TP6064     END-EVALUATE.                                                
                                                                        
T27240     MOVE E-FRP20-ACCOUNT-NO     TO WS-ACCOUNT-NO                 
T27240     PERFORM 7200-GET-ARREARS-HIST                                
T27240                                 THRU 7200-EXIT.                  
A04388     PERFORM 7300-GET-ACCOUNT-DATA                                
A04388                                 THRU 7300-EXIT.                  
A04388     MOVE ZEROS                  TO WS-MAX-DEPOSIT-AMT.           
A04388     MOVE ZEROS                  TO WS-MIN-DEPOSIT-AMT.           
A04388*                                                                         
A04388     MOVE WS-ACCOUNT-NO       TO WS-SCSCA666-ACCOUNT-NO           
A04388     MOVE AT-PREMISE-NO       TO WS-SCSCA666-PREMISE-NO           
A04388     MOVE AT-BILL-CYCLE       TO WS-SCSCA666-BILL-CYCLE           
A04388     MOVE WS-DATE-10          TO WS-SCSCA666-INPUT-DATE           
A04388     MOVE ZEROS               TO WS-SCSCA666-MAX-DEPOSIT          
A04388                                 WS-SCSCA666-RETURN-CODE.         
A04388                                                                  
A04388     CALL SCSCA666 USING WS-SCSCA666-AREA                         
A04388                                                                  
A04388     IF WS-SCSCA666-RETURN-CODE = ZEROS                           
A04388        CONTINUE                                                  
A04388     ELSE                                                         
A04388        MOVE WS-SCSCA666-RETURN-CODE TO WS-ACTIVE-RETURN-CODE     
A04388        DISPLAY '***************************************'         
A04388        DISPLAY '*  2300-FORMAT-DETAIL-LINE            *'         
A04388        DISPLAY '*  RETURN FROM CALLING SCSCA666       *'         
A04388        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A04388        DISPLAY '* ACCOUNT = ' WS-ACCOUNT-NO                      
A04388        DISPLAY '* PREMISE = ' AT-PREMISE-NO                      
A04388        DISPLAY '***************************************'         
A04388     END-IF                                                       
A04388                                                                  
A04388     MOVE WS-SCSCA666-MAX-DEPOSIT TO P-MAX-DEPOSIT.               
A04388                                                                  
A04388     MOVE ZEROS TO WS-DEPOSIT-AMT-NULL                            
A04388                   WS-AMT-DEPOSIT                                 
A04388     PERFORM 7660-GET-DEPOSIT THRU 7660-EXIT                      
A04388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04388        IF WS-DEPOSIT-AMT-NULL < 0                                
A04388           MOVE ZEROS          TO P-MIN-DEPOSIT                   
A04388        ELSE                                                      
A04388           MOVE WS-AMT-DEPOSIT TO P-MIN-DEPOSIT                   
A04388        END-IF                                                    
A04388     END-IF.                                                      
A04388     PERFORM 7750-GET-ARREARS    THRU 7750-EXIT.                  
A04388     MOVE CZ-DISCONNECT-HIST     TO P-CRED-HIST.                  
C28301     PERFORM 7700-CHK-EDI-ACCT   THRU 7700-EXIT.                  
A04388     IF SQLCODE = 0                                               
C28301        MOVE 'EDI BILL     '     TO P-EBL-ACCT                    
A04388     ELSE                                                         
A04388        MOVE 'NOT EDI      '     TO P-EBL-ACCT                    
A04388     END-IF.                                                      
A04388     IF AT-CT-METER-RATED-IND > ' '                               
A04388        MOVE 'CT METER'          TO P-CT-METER                    
A04388     ELSE                                                         
A04388        MOVE '        '          TO P-CT-METER                    
A04388     END-IF.                                                      
A04388     MOVE AT-LOCAL-OFFICE        TO P-LOCAL-OFFICE.               
A04388     IF AT-CODE-MAJOR-ACCT = 'Y'                                  
A04388        MOVE 'MAJOR ACCT'        TO P-MAJ-ACCT                    
A04388     ELSE                                                         
A04388        MOVE '          '        TO P-MAJ-ACCT                    
A04388     END-IF.                                                      
AM4388     MOVE AT-ACCT-CREATE-DT(1:4) TO P-TURN-ON-DT(7:4).            
AM4388     MOVE AT-ACCT-CREATE-DT(6:2) TO P-TURN-ON-DT(1:2).            
AM4388     MOVE AT-ACCT-CREATE-DT(9:2) TO P-TURN-ON-DT(4:2).            
AM4388     MOVE '/'                    TO P-TURN-ON-DT(3:1)             
AM4388                                    P-TURN-ON-DT(6:1).            
           MOVE E-FRP20-00-DAY-DETAIL  TO P-00-DAY-DETAIL.              
           MOVE E-FRP20-30-DAY-DETAIL  TO P-30-DAY-DETAIL.              
           MOVE E-FRP20-60-DAY-DETAIL  TO P-60-DAY-DETAIL.              
           MOVE E-FRP20-90-DAY-DETAIL  TO P-90-DAY-DETAIL.              
           MOVE E-FRP20-TOTAL-DETAIL   TO P-TOTAL-DETAIL.               
           MOVE E-FRP20-CUST-NAME      TO P-NAME.                       
           MOVE E-FRP20-CUST-ADDR-STRT TO P-ADDR-STREET.                
           MOVE E-FRP20-CUST-CTY-STATE TO P-ADDR-CITY-STATE.            
      *                                                                         
           MOVE E-FRP20-DATE-LAST-PAY  TO WS-DATE-10.                   
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
           MOVE WS-DATE-8              TO P-DATE-LAST-PMT.              
      *                                                                         
           MOVE E-FRP20-DATE-LAST-BILL TO WS-DATE-10.                   
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
           MOVE WS-DATE-8              TO P-DATE-LAST-BILL.             
           MOVE E-FRP20-AMT-LAST-PAY   TO P-AMT-LAST-PMT.               
      *                                                                         
           ADD E-FRP20-00-DAY-DETAIL   TO WS-00-DAY-TOTAL.              
           ADD E-FRP20-30-DAY-DETAIL   TO WS-30-DAY-TOTAL.              
           ADD E-FRP20-60-DAY-DETAIL   TO WS-60-DAY-TOTAL.              
           ADD E-FRP20-90-DAY-DETAIL   TO WS-90-DAY-TOTAL.              
           ADD E-FRP20-TOTAL-DETAIL    TO WS-TOT-DAY-TOTAL.             
      *                                                                         
A04388     MOVE AT-ACCOUNT-TYPE-CODE TO P-ACCT-TYPE                     
A04388     EVALUATE AT-ACCOUNT-TYPE-CODE                                
A04388       WHEN 'B'                                                   
A04388         MOVE 'MASTER'        TO P-ACCT-TYPE                      
A04388       WHEN 'C'                                                   
A04388         MOVE 'COMMERCIAL'        TO P-ACCT-TYPE                  
A04388       WHEN 'D'                                                   
A04388         MOVE 'COMPANY USE'        TO P-ACCT-TYPE                 
A04388       WHEN 'I'                                                   
A04388         MOVE 'INDUSTRIAL'        TO P-ACCT-TYPE                  
A04388       WHEN 'M'                                                   
A04388         MOVE 'PUB STR LIT'        TO P-ACCT-TYPE                 
A04388       WHEN 'N'                                                   
A04388         MOVE 'NON UTILITY'        TO P-ACCT-TYPE                 
A04388       WHEN 'R'                                                   
A04388         MOVE 'RESIDENTIAL'        TO P-ACCT-TYPE                 
A04388       WHEN 'S'                                                   
A04388         MOVE 'STATION'        TO P-ACCT-TYPE                     
A04388       WHEN 'W'                                                   
A04388         MOVE 'WHOLESALE  '        TO P-ACCT-TYPE                 
A04388     END-EVALUATE.                                                
A04388     MOVE AT-CREDIT-GROUP      TO P-CREDIT-GROUP                  
A04388     EVALUATE AT-CREDIT-GROUP                                     
A04388       WHEN 'A'                                                   
A04388         MOVE 'ARREARS'        TO P-CREDIT-GROUP                  
A04388       WHEN 'B'                                                   
A04388         MOVE 'BALANCE'        TO P-CREDIT-GROUP                  
A04388       WHEN 'C'                                                   
A04388         MOVE 'EXEMPT'        TO P-CREDIT-GROUP                   
A04388       WHEN 'D'                                                   
A04388         MOVE 'NON-UTILITY'   TO P-CREDIT-GROUP                   
A04388       WHEN 'M'                                                   
A04388         MOVE 'MASTER ACCT'   TO P-CREDIT-GROUP                   
A04388       WHEN 'N'                                                   
A04388         MOVE 'NEW CUST'      TO P-CREDIT-GROUP                   
A04388       WHEN 'S'                                                   
A04388         MOVE 'SUB ACCTS'     TO P-CREDIT-GROUP                   
A04388     END-EVALUATE.                                                
A04388     MOVE UT-RATE-PLAN-NO     TO P-RATE-PLAN.                     
A04388 2300-EXIT.                                                       
A04388     EXIT.                                                        
                                                                        
A04388*                                                                         
A04388 3549-CALL-DELIQUENCY.                                            
A04388     EXEC SQL                                                     
A04388          SELECT DELINQ_VALUE                                     
A04388            INTO :C8-DELINQ-VALUE                                 
A04388            FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
A04388           WHERE DELINQ_CD = :C8-DELINQ-CD                        
A04388             AND COMPANY_NO = :C8-COMPANY-NO                      
ACT106                                                           
A04388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13830000
MFA-TR*         SELECT DELINQ_VALUE                                     13840000
MFA-TR*           INTO :C8-DELINQ-VALUE                                 13850000
MFA-TR*           FROM CSS_DELINQUENCY                                  13860000
MFA-TR*          WHERE DELINQ_CD = :C8-DELINQ-CD                        13870000
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                      13880000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    13890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04388     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04388     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A04388        DISPLAY '** SELECT ERROR IN 3549-CALL-DELINQUENCY **'     
A04388        DISPLAY '** RETURN CODE = ' SQLCODE                       
A04388        DISPLAY '**         PROCESSING TERMINATED         **'     
A04388        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
A04388                                                                  
A04388 3549-EXIT.                                                       
A04388     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP20                                        **          
      **       READS THE INPUT FILE FCSRP20-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP20.                                               
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           READ FCSRP20-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP20-SUCCESSFUL                                          
               ADD 1                   TO WS-FRP20-REC-CNTR             
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP20 READ.  STATUS IS '        
                        WS-FRP20-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T27240****************************************************************          
T27240**                                                            **          
T27240**   7200-GET-ARREARS-HIST                                    **          
T27240**      READS THE ARREARS HISTORY FOR THE ACCOUNT NUMBER      **          
T27240**            FROM CSS_CREDIT_PROFILE TABLE                   **          
T27240****************************************************************          
T27240*                                                                         
T27240 7200-GET-ARREARS-HIST.                                           
T27240*                                                                         
T27240     MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
T27240*                                                                         
T27240     EXEC SQL                                                     
T27240         SELECT  ARREARS_HIST                                     
T27240           INTO :CZ-ARREARS-HIST                                  
T27240           FROM  CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                 
T27240          WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                      
ACT106                                                           
T27240     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  ARREARS_HIST                                             
MFA-TR*          INTO :CZ-ARREARS-HIST                                          
MFA-TR*          FROM  CSS_CREDIT_PROFILE                                       
MFA-TR*         WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27240*                                                                         
T27240     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T27240         MOVE CZ-ARREARS-HIST    TO P-ACCT-ARRS-HIST              
T27240     ELSE                                                         
T27240         IF SQLCODE EQUAL NOT-FOUND                               
T27240             MOVE SPACES         TO P-ACCT-ARRS-HIST              
T27240         ELSE                                                     
T27240             DISPLAY '** SELECT ERROR IN 7200-GET-ARREARS-HIST **'
T27240             DISPLAY '** RETURN CODE = ' SQLCODE                  
T27240             DISPLAY '**         PROCESSING TERMINATED         **'
T27240             PERFORM 9900-ABEND            THRU 9900-EXIT         
T27240         END-IF                                                   
T27240     END-IF.                                                      
T27240*                                                                         
T27240 7200-EXIT.                                                       
T27240     EXIT.                                                        
      *                                                                         
A04388****************************************************************          
A04388**                                                            **          
A04388**   7300-GET-ACCOUNT-DATA                                    **          
A04388**      READS THE ARREARS HISTORY FOR THE ACCOUNT NUMBER      **          
A04388**            FROM CSS_CREDIT_PROFILE TABLE                   **          
A04388****************************************************************          
A04388*                                                                         
A04388 7300-GET-ACCOUNT-DATA.                                           
A04388*                                                                         
A04388     MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                          
A04388*                                                                         
A04388     EXEC SQL                                                     
A04388         SELECT TOP(1) AT.ACCOUNT_TYPE_CODE,
              AT.CREDIT_GROUP,
              AT.PREMISE_NO,
              AT.BILL_CYCLE,
              AT.CODE_MAJOR_ACCT,
              AT.CT_METER_RATED_IND,
              AT.LOCAL_OFFICE,
              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,
              UT.RATE_PLAN_NO                                  
A04388           INTO :AT-ACCOUNT-TYPE-CODE                             
A04388               ,:AT-CREDIT-GROUP                                  
A04388               ,:AT-PREMISE-NO                                    
A04388               ,:AT-BILL-CYCLE                                    
A04388               ,:AT-CODE-MAJOR-ACCT                               
A04388               ,:AT-CT-METER-RATED-IND                            
A04388               ,:AT-LOCAL-OFFICE                                  
AM4388               ,:AT-ACCT-CREATE-DT                                
A04388               ,:UT-RATE-PLAN-NO                                  
A04388           FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
A04388                ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
A04388          WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                   
A04388           AND   UT.ACCOUNT_NO = AT.ACCOUNT_NO                    
A04388           ORDER BY UT.IC_NO                                      
A04388                                              
ACT106                                                           
A04388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.CODE_MAJOR_ACCT                                       
MFA-TR*               ,AT.CT_METER_RATED_IND                                    
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.ACCT_CREATE_DT                                        
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*          INTO :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-MAJOR-ACCT                                       
MFA-TR*              ,:AT-CT-METER-RATED-IND                                    
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-ACCT-CREATE-DT                                        
MFA-TR*              ,:UT-RATE-PLAN-NO                                          
MFA-TR*          FROM  CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                           
MFA-TR*          AND   UT.ACCOUNT_NO = AT.ACCOUNT_NO                            
MFA-TR*          ORDER BY UT.IC_NO                                              
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04388*                                                                         
A04388     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A04388         GO TO 7300-EXIT                                          
A04388     ELSE                                                         
A04388         IF SQLCODE EQUAL NOT-FOUND                               
A04388            MOVE SPACES             TO UT-RATE-PLAN-NO            
A04388         ELSE                                                     
A04388             DISPLAY '** SELECT ERROR IN 7300-GET-ACCOUNT-DATA **'
A04388             DISPLAY '** RETURN CODE = ' SQLCODE                  
A04388             DISPLAY '**         PROCESSING TERMINATED         **'
A04388             PERFORM 9900-ABEND            THRU 9900-EXIT         
A04388        END-IF                                                    
A04388     END-IF.                                                      
A04388                                                                  
A04388     EXEC SQL                                                     
A04388         SELECT TOP(1) AT.ACCOUNT_TYPE_CODE,
              AT.CREDIT_GROUP,
              AT.PREMISE_NO,
              AT.BILL_CYCLE,
              AT.CODE_MAJOR_ACCT,
              AT.CT_METER_RATED_IND,
              AT.LOCAL_OFFICE,
              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
A04388           INTO :AT-ACCOUNT-TYPE-CODE                             
A04388               ,:AT-CREDIT-GROUP                                  
A04388               ,:AT-PREMISE-NO                                    
A04388               ,:AT-BILL-CYCLE                                    
A04388               ,:AT-CODE-MAJOR-ACCT                               
A04388               ,:AT-CT-METER-RATED-IND                            
A04388               ,:AT-LOCAL-OFFICE                                  
A04388               ,:AT-ACCT-CREATE-DT                                
A04388           FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
A04388          WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                   
A04388                                              
ACT106                                                           
A04388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.CODE_MAJOR_ACCT                                       
MFA-TR*               ,AT.CT_METER_RATED_IND                                    
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.ACCT_CREATE_DT                                        
MFA-TR*          INTO :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-MAJOR-ACCT                                       
MFA-TR*              ,:AT-CT-METER-RATED-IND                                    
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-ACCT-CREATE-DT                                        
MFA-TR*          FROM  CSS_ACCOUNT AT                                           
MFA-TR*         WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                           
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04388*                                                                         
A04388     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A04388         CONTINUE                                                 
A04388       ELSE                                                       
A04388         IF SQLCODE EQUAL NOT-FOUND                               
A04388             MOVE SPACES         TO AT-ACCOUNT-TYPE-CODE          
A04388                                    AT-CREDIT-GROUP               
A04388                                    UT-RATE-PLAN-NO               
A04388         ELSE                                                     
A04388             DISPLAY '** SELECT ERROR IN 7300-GET-ACCOUNT-DATA **'
A04388             DISPLAY '** RETURN CODE = ' SQLCODE                  
A04388             DISPLAY '**         PROCESSING TERMINATED         **'
A04388             PERFORM 9900-ABEND            THRU 9900-EXIT         
A04388         END-IF                                                   
A04388     END-IF.                                                      
A04388                                                                  
A04388 7300-EXIT.                                                       
A04388     EXIT.                                                        
A04388****************************************************************  04170008
A04388* 5650-GET-MAX-DEPOSIT                                    *       04180008
A04388* TO GET MAXIMUM DEPOSIT                                       *  04190008
A04388****************************************************************  04200008
      *                                                                         
A04388 7660-GET-DEPOSIT.                                                
A04388*                                                                         
A04388     EXEC SQL                                                     
A04388        SELECT SUM(AMT_DEPOSIT)                                   
A04388          INTO :WS-AMT-DEPOSIT :WS-DEPOSIT-AMT-NULL                
A04388          FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
A04388         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                 
A04388           AND DEPOSIT_STATUS_CD IN ('P','A')                     
ACT106                                                           
A04388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*         INTO :WS-AMT-DEPOSIT:WS-DEPOSIT-AMT-NULL                        
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                         
MFA-TR*          AND DEPOSIT_STATUS_CD IN ('P','A')                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04388*                                                                         
A04388     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04388*                                                                         
A04388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04388        CONTINUE                                                  
A04388     ELSE                                                         
A04388        MOVE WS-ACTIVE-RETURN-CODE TO WS-ACTIVE-RETURN-CODE       
A04388        DISPLAY '********** PCSCA176 ABORT ****************'      
A04388        DISPLAY '*       7660-GET-DEPOSIT                 *'      
A04388        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A04388        DISPLAY '* ACCOUNT = ' WS-ACCOUNT-NO                      
A04388        DISPLAY '*****************************************'       
A04388        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04388     END-IF.                                                      
A04388*                                                                         
A04388 7660-EXIT.                                                       
A04388     EXIT.                                                        
T27240*                                                                         
C28301************************************************************              
C28301*                                                          *              
C28301*  7700-CHK-EDI-ACCT                                       *              
C28301*                                                          *              
C28301************************************************************              
C28301                                                                  
C28301 7700-CHK-EDI-ACCT.                                               
C28301                                                                  
C28301     MOVE WS-ACCOUNT-NO           TO NF-ACCOUNT-NO.               
A04388     MOVE SPACES                  TO NF-STAT-BEGIN-DT             
A04388                                     NF-STAT-END-DT.              
C28301                                                                  
C28301     EXEC SQL                                                     
C28301         SELECT STAT_BEGIN_DT                                     
C28301               ,STAT_END_DT                                       
C28301           INTO :NF-STAT-BEGIN-DT                                 
C28301               ,:NF-STAT-END-DT                                   
C28301         FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                     
C28301         WHERE ACCOUNT_NO     = :NF-ACCOUNT-NO                    
C34656           AND STATUS_CD      = 'A'                               
ACT106                                                           
C28301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STAT_BEGIN_DT                                             
MFA-TR*              ,STAT_END_DT                                               
MFA-TR*          INTO :NF-STAT-BEGIN-DT                                         
MFA-TR*              ,:NF-STAT-END-DT                                           
MFA-TR*        FROM CSS_EDI_ACCT_DEST                                           
MFA-TR*        WHERE ACCOUNT_NO     = :NF-ACCOUNT-NO                            
MFA-TR*          AND STATUS_CD      = 'A'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28301                                                                  
C28301     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
C28301     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C28301       IF WS-DATE-10  >= NF-STAT-BEGIN-DT                         
C28301                   OR <= NF-STAT-END-DT                           
C28301          SET EDI-ACCT             TO TRUE                        
C28301       ELSE                                                       
C28301          SET NON-EDI-ACCT         TO TRUE                        
C28301       END-IF                                                     
C28301     ELSE                                                         
C28301     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C28301        SET NON-EDI-ACCT         TO TRUE                          
C28301     ELSE                                                         
A04388         DISPLAY '************** PCSRP140 ************'           
A04388         DISPLAY 'ERROR IN 7700-CHK-EDI-ACCT     '                
A04388         DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
A04388         DISPLAY 'ACCOUNT NO = ', WS-ACCOUNT-NO                   
A04388         DISPLAY 'PROCESSING TERMINATED  '                        
A04388         DISPLAY '************** PCSRP140 ************'           
C28301         PERFORM 9900-ABEND              THRU 9900-EXIT           
C28301     END-IF
           END-IF.                                                      
C28301*                                                                         
C28301 7700-EXIT.                                                       
C28301     EXIT.                                                        
A04388*                                                                         
A04388************************************************************              
A04388*                                                          *              
A04388*  7750-GET-ARREARS.                                       *              
A04388*                                                          *              
A04388************************************************************              
A04388                                                                  
A04388 7750-GET-ARREARS.                                                
A04388                                                                  
A04388     EXEC SQL                                                     
A04388         SELECT CZ.ARREARS_HIST                                   
A04388               ,CZ.DISCONNECT_HIST                                
A04388           INTO :CZ-ARREARS-HIST                                  
A04388               ,:CZ-DISCONNECT-HIST                               
A04388         FROM CSS_CREDIT_PROFILE  CZ WITH(READUNCOMMITTED)                
A04388         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                    
ACT106                                                           
A04388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CZ.ARREARS_HIST                                           
MFA-TR*              ,CZ.DISCONNECT_HIST                                        
MFA-TR*          INTO :CZ-ARREARS-HIST                                          
MFA-TR*              ,:CZ-DISCONNECT-HIST                                       
MFA-TR*        FROM CSS_CREDIT_PROFILE  CZ                                      
MFA-TR*        WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04388                                                                  
A04388     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
A04388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04388        CONTINUE                                                  
A04388     ELSE                                                         
A04388     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A04388        MOVE SPACES              TO CZ-ARREARS-HIST               
A04388                                    CZ-DISCONNECT-HIST            
A04388     ELSE                                                         
A04388         DISPLAY '************** PCSRP140 ************'           
A04388         DISPLAY 'ERROR IN 7750-GET-ARREARS      '                
A04388         DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
A04388         DISPLAY 'ACCOUNT NO = ', WS-ACCOUNT-NO                   
A04388         DISPLAY 'PROCESSING TERMINATED  '                        
A04388         DISPLAY '************** PCSRP140 ************'           
A04388         PERFORM 9900-ABEND              THRU 9900-EXIT           
A04388     END-IF
           END-IF.                                                      
A04388*                                                                         
A04388 7750-EXIT.                                                       
A04388     EXIT.                                                        
A04388*                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
               FROM  CSS_COMPANY WITH(READUNCOMMITTED)                          
                WHERE    COMPANY_NO = :C7-COMPANY-NO                    
ACT106                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*        FROM  CSS_COMPANY                                                
MFA-TR*         WHERE    COMPANY_NO = :C7-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-TITLE                  
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-TITLE                  
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '** RETURN CODE = ' SQLCODE                  
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8100-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE FOR THE REPORT                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-TITLE.                                                
      *                                                                         
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
           ADD 1                       TO WS-RPT1-PAGE-NO.              
      *                                                                         
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           IF P-RPT1-TITLE EQUAL SPACES                                 
               MOVE WS-DEFAULT-RPT1-TITLE                               
                                       TO P-RPT1-TITLE                  
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-HEADERS                                       **          
      **       PRINTS THE HEADERS FOR THE REPORT                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-HEADERS.                                              
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEAD1  TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
TP6064     MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE E-FRP20-NAME-CONTACT   TO P-CONTACT-NAME.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                 AFTER ADVANCING 3 LINES.                               
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-32                    
                 AFTER ADVANCING 2 LINES.                               
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-33                    
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-34                    
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-35                    
                 AFTER ADVANCING 1 LINE.                                
A04388*                                                                         
A04388     WRITE PRT33-RECORD FROM WS-RPT1-HEADER-36                    
A04388           AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
A04388     MOVE 13                     TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-RPT1-DETAIL                                   **          
      **       PRINTS THE DETAIL LINES OF THE REPORT PCSRP140       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-RPT1-DETAIL.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                   AFTER ADVANCING 1 LINE.                              
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                     
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-2                     
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-3                     
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-4                     
                 AFTER ADVANCING 1 LINE.                                
A04388     WRITE PRT33-RECORD FROM WS-DETAIL-LINE-5                     
A04388           AFTER ADVANCING 1 LINE.                                
      *                                                                         
A04388     ADD 6                       TO WS-RPT1-LINE-NO.              
           ADD 1                       TO WS-NUMBER-ACCOUNTS.           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8950-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE TOTAL LINE OF THE REPORT PCSRP140         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8950-PRINT-TOTAL-LINE.                                           
      *                                                                         
           MOVE '8950' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-00-DAY-TOTAL        TO P-00-DAY-TOTAL.               
           MOVE WS-30-DAY-TOTAL        TO P-30-DAY-TOTAL.               
           MOVE WS-60-DAY-TOTAL        TO P-60-DAY-TOTAL.               
           MOVE WS-90-DAY-TOTAL        TO P-90-DAY-TOTAL.               
           MOVE WS-TOT-DAY-TOTAL       TO P-TOT-DAY-TOTAL.              
           MOVE WS-NUMBER-ACCOUNTS     TO P-NUMBER-ACCOUNTS.            
      *                                                                         
           WRITE PRT33-RECORD FROM WS-TOTAL-LINE                        
                   AFTER ADVANCING 3 LINES.                             
      *                                                                         
           ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-SEND-ERROR-RESULT                                   **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           CLOSE FCSRP20-FILE.                                          
           IF FRP20-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSRP140 PROCESSING ERROR  **'              
               DISPLAY '**  CLOSE ERROR FOR FCSRP20 - INPUT FILE'       
               DISPLAY '**  FILE STATUS = ' WS-FRP20-STATUS             
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9900-ABEND                                                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
A04388     EXEC SQL                                                             
A04388        INCLUDE CPD0023C                                                  
A04388     END-EXEC.                                                            
A04388*                                                                         
A04388 9900-SQL-ERROR-ROUTINE.                                          
A04388     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
A04388     EXIT PROGRAM.                                                
A04388 9000-TERMINATE.                                                  
A04388     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
A04388     EXIT PROGRAM.                                                
      ****************************************************************          
