       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP131.                                        
       DATE-WRITTEN.   12/21/94.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  12/21/94     SC        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  --------     ----------------------------------  **         
      **  09/25/95     DW        ADDED CWS00303; CHANGED DATE FORMAT **         
      **                         FOR CORRECT RUN-DATE; CORRECTED     **         
      **                         SPACING AND SPELLING ERRORS.        **         
TP6149**  01/06/97     KB        INITIALIZE WS-RPT2-HEADER-31 BEFORE **         
TP6149**                         MOVING WS-COMPANY-TOTAL             **         
T20409**  07/21/99     CBSI      SELECTING THE REPORT HEADER TITLE   **         
T20409**               MADRAS    FROM CSS_COMPANY INSTEAD OF THE HARD**         
T20409**                         CODED MESSAGE                       **         
      **  08/27/01     CHANELLE  MCR310. 23748. FIX COMPANY.         **         
T35755**  05/16/2007  SK88120    CHANGED COMPANY LOCAL OFFICE TO XXX  **        
T35755**                        (PREV 999), WE HAVE 999 AS LOCAL OFFICE*        
T35755**                        IN SEB REGION.                         *        
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSCA131 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP09.                                                            
       COPY CSSPT33.                                                            
                                                                        
      * SELECT STATEMENT FOR OUTPUT FILE W/ PAGE INFO                           
           SELECT PCS131F-FILE                                          
               ASSIGN TO UT-S-PCS131F                                   
               FILE STATUS IS WS-PCS131F-STATUS.                        
                                                                        
      * SELECT STATEMENT FOR OUTPUT FILE W/ PAGE INFO                           
           SELECT PCSR131M-FILE                                         
               ASSIGN TO UT-S-PCSR131M                                  
               FILE STATUS IS WS-PCSR131M-STATUS.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP09.                                                            
       COPY FIORP09.                                                            
       COPY CFDPT33.                                                            
                                                                        
       FD  PCS131F-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PCS131F-REC.                                                 
           05  PCS131F-LOCAL-OFF               PIC X(03).               
           05  PCS131F-AR-TOTAL                PIC 9(09)V99.            
           05  PCS131F-TYPE-ACCT               PIC X(03).               
           05  PCS131F-GL-REC                  PIC X(08).               
           05  PCS131F-GL-BAL                  PIC 9(09)V99.            
           05  PCS131F-DIFF                    PIC 9(09)V99.            
           05  FILLER                          PIC X(33).               
                                                                        
       FD  PCSR131M-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PCSR131M-REC                PIC X(80).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP131'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP131 STARTS HERE'.                  
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
T20409     EXEC SQL                                                             
T20409         INCLUDE TBCOMPNY                                                 
T20409     END-EXEC.                                                            
T20409*                                                                         
       01  WS-MISC.                                                     
      *                                                                         
T20409     05  WS-DEFAULT-RPT1-TITLE   PIC X(26)    VALUE SPACES.       
T20409     05  WS-DEFAULT-RPT2-TITLE   PIC X(26)    VALUE SPACES.       
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(50)    VALUE               
               '             CUSTOMER ACCOUNT BALANCE             '.    
      *                                                                         
           05  WS-DEFAULT-RPT2-HEAD1   PIC X(50)    VALUE               
               '          TRIAL BALANCE CONTROL LISTING           '.    
      *                                                                         
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-END-OF-RPT1          PIC X(01)    VALUE 'N'.          
               88  END-OF-REPORT-1                  VALUE 'Y'.          
               88  NOT-END-OF-REPORT-1              VALUE 'N'.          
           05  WS-FIRST-READ-FLAG      PIC X(01)    VALUE 'Y'.          
               88  WS-FIRST-READ                    VALUE 'Y'.          
           05  WS-OOB-RECS-FLAG        PIC X(01)    VALUE 'N'.          
               88  WS-OOB-RECS                      VALUE 'Y'.          
      *                                                                         
           05  WS-FRP09-REC-CNTR       PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-RPT1-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-RPT2-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FRP09-STATUS         PIC X(02).                       
               88  FRP09-SUCCESSFUL                 VALUE '00'.         
           05  WS-PCS131F-STATUS       PIC X(02).                       
               88  PCS131F-SUCCESSFUL               VALUE '00'.         
           05  WS-PCSR131M-STATUS      PIC X(02).                       
               88  PCSR131M-SUCCESSFUL              VALUE '00'.         
      *                                                                         
           05  WS-DEFAULT-COMP-NO      PIC X(02)    VALUE '01'.         
           05  WS-PREV-LOC-OFFICE      PIC X(03)    VALUE SPACES.       
           05  WS-LOCAL-OFFICE-DESC    PIC X(22)    VALUE SPACES.       
      *                                                                         
       01  WS-SUCCESS-MSG.                                              
           05  WS-MSG-JOB              PIC X(07).                       
           05  FILLER                  PIC X(21) VALUE                  
                  ' HAS RUN SUCCESSFULLY'.                              
                                                                        
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-RPT131-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.            
           05  RPT131-RPTS-PRINTED-PARM                                 
                                       PIC X(12).                       
               88  RPTS-PRINTED-PARM                VALUE               
                                                   'RPTS-PRINTED'.      
           05  FILLER                  PIC X(01).                       
           05  RPT131-RPTS-PRINTED-IND PIC X(11).                       
               88  PRINT-BOTH-REPORTS               VALUE 'REPORT-BOTH'.
               88  PRINT-REPORT-2                   VALUE 'REPORT-2   '.
           05  FILLER                  PIC X(56).                       
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 60   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(02)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP131'.   
T35755     05  WS-COMPANY-END          PIC X(03)    VALUE 'XXX'.        
           05  WS-COMPANY-TOTAL        PIC X(22)    VALUE               
                                           '        COMPANY TOTALS'.    
           05  WS-1                    PIC X(01)    VALUE '1'.          
           05  WS-2                    PIC X(01)    VALUE '2'.          
           05  WS-3                    PIC X(01)    VALUE '3'.          
           05  WS-4                    PIC X(01)    VALUE '4'.          
           05  WS-T                    PIC X(01)    VALUE 'T'.          
           05  WS-H                    PIC X(01)    VALUE 'H'.          
           05  WS-I                    PIC X(01)    VALUE 'I'.          
           05  WS-12                   PIC 9(02)    VALUE 12.           
      *                                                                         
      ***************** PCSRP131 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-1 TITLE         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT1-TITLE        PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-1 HEADER1       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(23)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-1 HEADER2       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(118)   VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **    COMMON WORKING STORAGE FOR RPT-1 LOCAL OFFICE HEADER    **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT1-LOCAL-OFFICE-NBR      PIC X(03).              
               10  FILLER                       PIC X(01).              
               10  DASH-FILLER1                 PIC X(02).              
               10  P-RPT1-LOCAL-OFFICE-DESC                             
                                       PIC X(22).                       
               10  FILLER              PIC X(110)   VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **      COMMON WORKING STORAGE FOR REPORT-1 COLUMN HEADERS    **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
      *                                                                         
               10  FILLER              PIC X(17)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'A/R'.        
               10  FILLER              PIC X(17)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'A/R'.        
               10  FILLER              PIC X(17)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'A/R'.        
               10  FILLER              PIC X(17)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'DATE'.       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(03)    VALUE 'A/R'.        
      *                                                                         
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'ACCOUNT NO.'.
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'LAST'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'BALANCE'.    
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'ACCOUNT NO.'.
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'LAST'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'BALANCE'.    
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'ACCOUNT NO.'.
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'LAST'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'BALANCE'.    
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'ACCOUNT NO.'.
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'LAST'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'BALANCE'.    
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-2 TITLE         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT2-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  P-RPT2-TITLE        PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT2-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-2 HEADER1       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT2-DATE         PIC X(08).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  P-RPT2-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(23)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT2-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT-2 HEADER2       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-HEADER-2.                                        
               10  FILLER              PIC X(118)   VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT2-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **    COMMON WORKING STORAGE FOR RPT-2 LOCAL OFFICE HEADER    **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-HEADER-31.                                       
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT2-LOCAL-OFFICE-NBR      PIC X(03).              
               10  FILLER                       PIC X(01).              
               10  DASH-FILLER2                 PIC X(02).              
               10  P-RPT2-LOCAL-OFFICE-DESC                             
                                       PIC X(22).                       
               10  FILLER              PIC X(110)   VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **      COMMON WORKING STORAGE FOR REPORT-2 COLUMN HEADERS    **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-HEADER-32.                                       
               10  FILLER              PIC X(48)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'TYPE'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'GL ACCT'.    
               10  FILLER              PIC X(68)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT2-HEADER-33.                                       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                                   'BILLED & UNPAID'.   
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE 'TOTAL A/R'.  
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'ACCOUNTS'.   
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RECEIVABLE'. 
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'GL BALANCE'. 
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'DIFFERENCE'. 
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'MESSAGE'.    
               10  FILLER              PIC X(25)    VALUE SPACES.       
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP131 ENDS HERE'.                    
                                                                        
        01  MAILHEAD-1.                                                 
            05  FILLER                    PIC X(22) VALUE               
                'HELO DOMAIN:     SCANA'.                               
                                                                        
        01  MAILHEAD-2.                                                 
            05  FILLER                    PIC X(14) VALUE               
                'MAIL FROM:   <'.                                       
            05  MAIL2-JOB-NAME            PIC X(07).                    
            05  FILLER                    PIC X(20) VALUE               
                '@SCEGJES2.SCANA.COM>'.                                 
                                                                        
        01  MAILHEAD-3-SCEG.                                            
            05  FILLER                    PIC X(42) VALUE               
                'RCPT TO:     <ISDCSR-AR-OOB@SCANA.COM>'.               
                                                                        
        01  MAILHEAD-3-SEB.                                             
            05  FILLER                    PIC X(42) VALUE               
                'RCPT TO:     <ISDCSRAROOBSEB@SCANA.COM>'.              
                                                                        
       01  MAILHEAD-4.                                                  
           05  FILLER                    PIC X(04) VALUE                
               'DATA'.                                                  
                                                                        
       01  MAILHEAD-5.                                                  
           05  FILLER                    PIC X(18) VALUE                
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME            PIC X(07).                     
           05  FILLER                    PIC X(20) VALUE                
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
       01  MAILHEAD-6-SCEG.                                             
           05  FILLER                    PIC X(35) VALUE                
               'TO:   <ISDCSR-AR-OOB@SCANA.COM>'.                       
                                                                        
       01  MAILHEAD-6-SEB.                                              
           05  FILLER                    PIC X(35) VALUE                
               'TO:   <ISDCSRAROOBSEB@SCANA.COM>'.                      
                                                                        
       01  MAILHEAD-7.                                                  
           05  FILLER                    PIC X(10) VALUE                
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT             PIC X(30).                     
                                                                        
       01  MAILHEAD-8.                                                  
           05  FILLER                    PIC X(80) VALUE SPACES.        
                                                                        
       01  MAILHEAD-9.                                                  
           05  MAIL9-MESSAGE             PIC X(80).                     
                                                                        
       01  MAILHEAD-10.                                                 
           05  FILLER                    PIC X(05) VALUE 'LOCAL'.       
           05  FILLER                    PIC X(07) VALUE SPACES.        
           05  FILLER                    PIC X(03) VALUE 'A/R'.         
           05  FILLER                    PIC X(07) VALUE SPACES.        
           05  FILLER                    PIC X(04) VALUE 'TYPE'.        
           05  FILLER                    PIC X(07) VALUE SPACES.        
           05  FILLER                    PIC X(03) VALUE 'G/L'.         
           05  FILLER                    PIC X(11) VALUE SPACES.        
           05  FILLER                    PIC X(03) VALUE 'G/L'.         
                                                                        
       01  MAILHEAD-11.                                                 
           05  FILLER                    PIC X(06) VALUE 'OFFICE'.      
           05  FILLER                    PIC X(05) VALUE SPACES.        
           05  FILLER                    PIC X(05) VALUE 'TOTAL'.       
           05  FILLER                    PIC X(06) VALUE SPACES.        
           05  FILLER                    PIC X(04) VALUE 'ACCT'.        
           05  FILLER                    PIC X(06) VALUE SPACES.        
           05  FILLER                    PIC X(05) VALUE 'RCVBL'.       
           05  FILLER                    PIC X(10) VALUE SPACES.        
           05  FILLER                    PIC X(03) VALUE 'BAL'.         
           05  FILLER                    PIC X(13) VALUE SPACES.        
           05  FILLER                    PIC X(04) VALUE 'DIFF'.        
                                                                        
       01  MAIL-DETAIL.                                                 
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  MAIL-LOCAL-OFFICE         PIC X(03).                     
           05  FILLER                    PIC X(02) VALUE SPACES.        
           05  MAIL-AR-TOTAL             PIC ZZ,ZZZ,ZZ9.99.             
           05  FILLER                    PIC X(03) VALUE SPACES.        
           05  MAIL-TYPE-ACCT            PIC X(03).                     
           05  FILLER                    PIC X(05) VALUE SPACES.        
           05  MAIL-GL-REC               PIC X(08).                     
           05  FILLER                    PIC X(04) VALUE SPACES.        
           05  MAIL-GL-BAL               PIC ZZ,ZZZ,ZZ9.99.             
           05  FILLER                    PIC X(04) VALUE SPACES.        
           05  MAIL-DIFF                 PIC ZZ,ZZZ,ZZ9.99.             
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM.                                                        
           05  LNGTH                     PIC S9(04) COMP.               
           05  WS-PASS-JOB               PIC X(07).                     
      *                                                                         
       PROCEDURE DIVISION USING PARM.                                   
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSRP09             THRU 7100-EXIT.        
           MOVE E-FRP09-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE.           
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
           IF PRINT-BOTH-REPORTS AND NOT-END-OF-REPORT-1                
               MOVE WS-Y               TO WS-END-OF-RPT1                
               IF WS-RPT1-REC-CNTR EQUAL ZERO                           
                   MOVE ZERO           TO WS-RPT1-PAGE-NO               
                   PERFORM 8100-PRINT-RPT1-TITLE THRU 8100-EXIT         
                   PERFORM 8200-PRINT-RPT1-HEADER                       
                                                 THRU 8200-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 2 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-RPT2-REC-CNTR EQUAL ZERO                               
               MOVE ZERO               TO WS-RPT1-PAGE-NO               
               PERFORM 8300-PRINT-RPT2-TITLE     THRU 8300-EXIT         
               PERFORM 8400-PRINT-RPT2-HEADER    THRU 8400-EXIT         
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                  
                    AFTER ADVANCING 3 LINES                             
           ELSE                                                         
               WRITE PRT33-RECORD FROM WS-END-DATA-LINE                 
                    AFTER ADVANCING 2 LINES                             
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP131 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 8500-READ-PAGE-INFO THRU 8500-EXIT.                  
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
           MOVE WS-RUN-TIME            TO P-RPT2-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
           MOVE WS-RUN-DATE            TO P-RPT2-RUN-DATE.              
      *                                                                         
T20409     MOVE WS-DEFAULT-COMP-NO     TO C7-COMPANY-NO.                
T20409     PERFORM 7200-SELECT-COMP-DESC         THRU 7200-EXIT.        
T20409     MOVE C7-COMPANY-NAME        TO WS-DEFAULT-RPT1-TITLE         
T20409                                    WS-DEFAULT-RPT2-TITLE.        
           PERFORM 6200-GET-FJC01-REPORT-CHOICE  THRU 6200-EXIT.        
      *                                                                         
           OPEN INPUT FCSRP09-FILE.                                     
           IF FRP09-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSRP131 PROCESSING ERROR       **'     
               DISPLAY '**  OPEN ERROR OF FCSRP09 - INPUT FILE  **'     
               DISPLAY '**        FILE STATUS = ' WS-FRP09-STATUS       
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT PCS131F-FILE.                                     
           IF PCS131F-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSRP131 PROCESSING ERROR       **'     
               DISPLAY '**  OPEN ERROR OF PCS131F - INPUT FILE  **'     
               DISPLAY '**        FILE STATUS = ' WS-PCS131F-STATUS     
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       CHECKS FOR THE BEGINNING OF THE FILE FCSRP09         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSRP09             THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP09-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FRP09-REC-CNTR                        
               MOVE E-FRP09-CREATE-DATE-BREC                            
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
               MOVE WS-DATE-8          TO P-RPT2-DATE                   
           ELSE                                                         
               DISPLAY '**       PCSRP131 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSRP131        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP131 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF E-FRP09-KEY-EREC EQUAL HIGH-VALUES                    
                   PERFORM 1900-PROCESS-END-REC  THRU 1900-EXIT         
               ELSE                                                     
                   IF E-FRP09-RPT-NO EQUAL 1                            
                       PERFORM 2100-PRODUCE-RPT  THRU 2100-EXIT         
                   ELSE                                                 
                       DISPLAY '**    PCSRP131 PROCESSING WARNING    **'
                       DISPLAY '** INVALID RECORD ON THE REPORT FILE **'
                       DISPLAY '**       RPT RECORD - ' FIORP09         
                       DISPLAY '**       PROCESSING CONTINUING       **'
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE E-FRP09-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE.           
           PERFORM 7100-READ-FCSRP09             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF ALL RECORDS               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FRP09-REC-CNTR.                           
           IF WS-FRP09-REC-CNTR EQUAL E-FRP09-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP131 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP09-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP09-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-PRODUCE-RPT                                         **          
      **       CONTROLS THE SUB-REPORTS TO BE PRINTED               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-PRODUCE-RPT.                                                
      *                                                                         
           IF E-FRP09-SUB-RPT EQUAL WS-1                                
               PERFORM 2200-PRODUCE-SUB-RPT1     THRU 2200-EXIT         
           ELSE                                                         
               IF E-FRP09-SUB-RPT EQUAL WS-2                            
                   PERFORM 2300-PRODUCE-SUB-RPT2 THRU 2300-EXIT         
               ELSE                                                     
                   DISPLAY '**      PCSRP131 PROCESSING WARNING     **' 
                   DISPLAY '**  INVALID SUB-REPORT OPTN INPUT FILE  **' 
                   DISPLAY '**  SUB-RPT OPTION - ' E-FRP09-SUB-RPT      
                   DISPLAY '**         PROCESSING CONTINUING        **' 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-SUB-RPT1                                    **          
      **       CONTROLS THE REPORT-1 FORMAT WITH CONTROL BREAKS     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-SUB-RPT1.                                           
      *                                                                         
           IF END-OF-REPORT-1                                           
               DISPLAY '**       PCSRP131 PROCESSING WARNING      **'   
               DISPLAY '**  RPT1 RECORD IS MIXED WITH RPT2 RECORD **'   
               DISPLAY '**  RPT1 RECORD  -' E-FRP09-DATA                
               DISPLAY '**         PROCESSING CONTINUING          **'   
               GO                      TO 2200-EXIT                     
           END-IF                                                       
      *                                                                         
           IF PRINT-REPORT-2                                            
               GO                      TO 2200-EXIT                     
           END-IF.                                                      
      *                                                                         
           IF E-FRP09-LOCAL-OFFICE EQUAL WS-COMPANY-END                 
               GO                      TO 2200-EXIT                     
           END-IF.                                                      
      *                                                                         
           IF E-FRP09-LOCAL-OFFICE NOT EQUAL WS-PREV-LOC-OFFICE         
               MOVE 60                 TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 51                           
               PERFORM 8100-PRINT-RPT1-TITLE     THRU 8100-EXIT         
               PERFORM 8200-PRINT-RPT1-HEADER    THRU 8200-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 8900-PRINT-RPT-DETAIL         THRU 8900-EXIT.        
           ADD 1                       TO WS-RPT1-REC-CNTR.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-PRODUCE-SUB-RPT2                                    **          
      **       CONTROLS THE REPORT-2 FORMAT WITH CONTROL BREAKS     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-PRODUCE-SUB-RPT2.                                           
      *                                                                         
           IF NOT-END-OF-REPORT-1                                       
               MOVE 'Y'                TO WS-END-OF-RPT1                
               MOVE ZERO               TO WS-RPT1-PAGE-NO               
               MOVE ZERO               TO WS-RPT1-LINE-NO               
               MOVE SPACES             TO WS-PREV-LOC-OFFICE            
               IF PRINT-BOTH-REPORTS                                    
                   IF WS-RPT1-REC-CNTR EQUAL ZERO                       
                       PERFORM 8100-PRINT-RPT1-TITLE                    
                                                 THRU 8100-EXIT         
                       PERFORM 8200-PRINT-RPT1-HEADER                   
                                                 THRU 8200-EXIT         
                       WRITE PRT33-RECORD FROM WS-NO-DATA-LINE          
                            AFTER ADVANCING 3 LINES                     
                   ELSE                                                 
                       WRITE PRT33-RECORD FROM WS-END-DATA-LINE         
                            AFTER ADVANCING 2 LINES                     
                   END-IF                                               
                   MOVE ZERO           TO WS-RPT1-PAGE-NO               
                   MOVE ZERO           TO WS-RPT1-LINE-NO               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF E-FRP09-LOCAL-OFFICE NOT EQUAL WS-PREV-LOC-OFFICE         
               MOVE 60                 TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 51                           
               PERFORM 8300-PRINT-RPT2-TITLE     THRU 8300-EXIT         
               PERFORM 8400-PRINT-RPT2-HEADER    THRU 8400-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 8900-PRINT-RPT-DETAIL         THRU 8900-EXIT.        
           ADD 1                       TO WS-RPT2-REC-CNTR.             
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   6200-GET-FJC01-REPORT-CHOICE                             **          
      **       FETCHES THE 'RPTS-PRINTED' FROM (FCSJC01)            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       6200-GET-FJC01-REPORT-CHOICE.                                    
      *                                                                         
           MOVE  WS-PGRMNAME           TO WS-PROGRAM.                   
           MOVE  WS-PARM               TO WS-COMMAND.                   
           MOVE  ZEROS                 TO WS-SEQUENCE.                  
           MOVE  SPACES                TO WS-SYSIPT.                    
           MOVE  WS-KEY-AREA           TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (RPTS-PRINTED-PARM AND INPUT-ACTIVE)               
                   OR END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG   **'      
               DISPLAY '**     RPTS-PRINTED PARM NOT ACTIVE    **'      
               DISPLAY '**      REPORT-2 WILL BE PRINTED       **'      
               DISPLAY '**       PROCESSING CONTINUING         **'      
               MOVE 'REPORT-2'         TO RPT131-RPTS-PRINTED-IND       
           ELSE                                                         
               IF WS-RPT1-TITLE-PARM EQUAL SPACES                       
                   PERFORM 7611-CLOSE THRU 7611-EXIT                    
                   DISPLAY ' '                                          
                   DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG   **'  
                   DISPLAY '**    RPTS-PRINTED PARM IS SPACES      **'  
                   DISPLAY '**      REPORT-2 WILL BE PRINTED       **'  
                   DISPLAY '**       PROCESSING CONTINUING         **'  
                   MOVE 'REPORT-2'     TO RPT131-RPTS-PRINTED-IND       
               ELSE                                                     
                   PERFORM 7611-CLOSE            THRU 7611-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP09                                        **          
      **      READS THE INPUT FILE FCSRP09                          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP09.                                               
      *                                                                         
           READ FCSRP09-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP09-SUCCESSFUL                                          
               ADD 1                   TO WS-FRP09-REC-CNTR             
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP09 READ.  STATUS IS '        
                        WS-FRP09-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T20409****************************************************************          
T20409**                                                            **          
T20409**      7200-SELECT-COMP-DESC                                 **          
T20409**      SELECTS THE COMPANY DESCRIPTION FROM CSS_COMPANY      **          
T20409**                                                            **          
T20409****************************************************************          
T20409*                                                                         
T20409 7200-SELECT-COMP-DESC.                                           
T20409*                                                                         
T20409     MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
T20409*                                                                         
T20409     EXEC SQL                                                     
T20409         SELECT   COMPANY_NAME                                    
T20409           INTO  :C7-COMPANY-NAME                                 
T20409           FROM   CSS_COMPANY                                     
T20409          WHERE   COMPANY_NO   = :C7-COMPANY-NO                   
T20409     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20409*                                                                         
T20409     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T20409         NEXT SENTENCE                                            
T20409     ELSE                                                         
T20409         IF  SQLCODE EQUAL NOT-FOUND                              
T20409             DISPLAY '*********** PCSRP131 **********************'
T20409             DISPLAY '*  COMPANY DESCRIPTION NOT FOUND          *'
T20409             DISPLAY '* FOR COMPANY NO *' C7-COMPANY-NO           
T20409             DISPLAY '* SPACES MOVED FOR COMPANY DESC           *'
T20409             DISPLAY '*********** PCSRP131 **********************'
T20409             MOVE SPACES                   TO C7-COMPANY-NAME     
T20409         ELSE                                                     
T20409             DISPLAY '*********** PCSRP131 **********************'
T20409             DISPLAY '** SELECT ERROR IN 7200-SELECT-COMP-DESC **'
T20409             DISPLAY '** RETURN CODE = ' SQLCODE                  
T20409             DISPLAY '** PROCESSING TERMINATED                 **'
T20409             DISPLAY '*********** PCSRP131 **********************'
T20409             PERFORM 9900-ABEND            THRU 9900-EXIT         
T20409         END-IF                                                   
T20409     END-IF.                                                      
T20409*                                                                         
T20409 7200-EXIT.                                                       
T20409     EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-GET-LOCAL-OFFICE                                    **          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   LOCAL_OFFICE_DESC                               
               INTO :B1-LOCAL-OFFICE-DESC                               
               FROM CSS_LOCAL_OFFICE                                    
T23748*        WHERE    COMPANY_NO   = :B1-COMPANY-NO                           
               WHERE    LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE B1-LOCAL-OFFICE-DESC                                
                                       TO WS-LOCAL-OFFICE-DESC          
               MOVE B1-LOCAL-OFFICE                                     
                                   TO P-RPT1-LOCAL-OFFICE-NBR,          
                                      P-RPT2-LOCAL-OFFICE-NBR           
               MOVE '-' TO DASH-FILLER1 DASH-FILLER2                    
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO WS-LOCAL-OFFICE-DESC,         
                                         P-RPT1-LOCAL-OFFICE-NBR,       
                                         P-RPT2-LOCAL-OFFICE-NBR,       
                                         DASH-FILLER1,DASH-FILLER2      
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7700-GET-LOCAL-OFFICE **'
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8100-PRINT-RPT1-TITLE                                    **          
      **       PRINTS THE TITLE FOR THE REPORT PCSRP131-1           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-RPT1-TITLE.                                           
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           MOVE WS-DEFAULT-RPT1-TITLE  TO P-RPT1-TITLE.                 
           MOVE WS-DEFAULT-COMP-NO     TO B1-COMPANY-NO.                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                AFTER ADVANCING TOP-OF-PAGE.                            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-RPT1-HEADER                                   **          
      **       PRINTS THE TITLE HEADERS FOR REPORT-1                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-RPT1-HEADER.                                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEAD1  TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           IF END-OF-REPORT-1                                           
               MOVE SPACES             TO P-RPT1-LOCAL-OFFICE-DESC      
           ELSE                                                         
               IF E-FRP09-LOCAL-OFFICE EQUAL SPACES                     
                   MOVE SPACES         TO P-RPT1-LOCAL-OFFICE-DESC      
               ELSE                                                     
                   MOVE E-FRP09-LOCAL-OFFICE                            
                                       TO B1-LOCAL-OFFICE               
                   PERFORM 7700-GET-LOCAL-OFFICE THRU 7700-EXIT         
                   MOVE WS-LOCAL-OFFICE-DESC TO                         
                                           P-RPT1-LOCAL-OFFICE-DESC,    
                                           P-RPT2-LOCAL-OFFICE-DESC     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                AFTER ADVANCING 3 LINES.                                
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-32                    
                AFTER ADVANCING 2 LINES.                                
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-33                    
                AFTER ADVANCING 1 LINE.                                 
           WRITE PRT33-RECORD FROM WS-LINE                              
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 10                     TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8100-PRINT-RPT2-TITLE                                    **          
      **       PRINTS THE TITLE FOR THE REPORT PCSRP131-2           **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-RPT2-TITLE.                                           
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT2-TITLE-PGNM.            
           MOVE WS-DEFAULT-RPT2-TITLE  TO P-RPT2-TITLE.                 
           MOVE WS-DEFAULT-COMP-NO     TO B1-COMPANY-NO.                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT2-TITLE                        
                AFTER ADVANCING TOP-OF-PAGE.                            
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-RPT2-HEADER                                   **          
      **       PRINTS THE TITLE HEADERS FOR REPORT-2                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-RPT2-HEADER.                                          
      *                                                                         
           MOVE WS-DEFAULT-RPT2-HEAD1  TO P-RPT2-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT2-HEADER-1                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT2-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT2-HEADER-2                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           IF E-FRP09-LOCAL-OFFICE EQUAL WS-COMPANY-END                 
TP6149         MOVE SPACES             TO WS-RPT2-HEADER-31             
               MOVE WS-COMPANY-TOTAL   TO P-RPT2-LOCAL-OFFICE-DESC      
           ELSE                                                         
               IF E-FRP09-LOCAL-OFFICE EQUAL SPACES                     
                   MOVE SPACES         TO P-RPT2-LOCAL-OFFICE-DESC      
               ELSE                                                     
                   MOVE E-FRP09-LOCAL-OFFICE                            
                                       TO B1-LOCAL-OFFICE               
                   PERFORM 7700-GET-LOCAL-OFFICE THRU 7700-EXIT         
                   MOVE WS-LOCAL-OFFICE-DESC TO                         
                                          P-RPT1-LOCAL-OFFICE-DESC,     
                                          P-RPT2-LOCAL-OFFICE-DESC      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT2-HEADER-31                    
                AFTER ADVANCING 3 LINES.                                
           WRITE PRT33-RECORD FROM WS-RPT2-HEADER-32                    
                AFTER ADVANCING 2 LINES.                                
           WRITE PRT33-RECORD FROM WS-RPT2-HEADER-33                    
                AFTER ADVANCING 1 LINE.                                 
           WRITE PRT33-RECORD FROM WS-LINE                              
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 10                     TO WS-RPT1-LINE-NO.              
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8500-READ-PAGE-INFO.                                             
                                                                        
           READ PCS131F-FILE, AT END                                    
      *        IF NOT WS-OOB-RECS                                               
      *            PERFORM 8520-UPD-SUCCESS-MSG THRU 8520-EXIT                  
      *        END-IF                                                           
               GO TO 8500-EXIT                                          
           END-READ.                                                    
                                                                        
           IF WS-FIRST-READ                                             
               OPEN OUTPUT PCSR131M-FILE                                
               IF PCSR131M-SUCCESSFUL                                   
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '**      PCSRP131 PROCESSING ERROR       **' 
                   DISPLAY '**  OPEN ERROR OF PCSR131M - INPUT FILE  **'
                   DISPLAY '**        FILE STATUS = ' WS-PCSR131M-STATUS
                   DISPLAY '**        PROCESSING TERMINATED         **' 
                   PERFORM 9900-ABEND                THRU 9900-EXIT     
               END-IF                                                   
               PERFORM 8510-WRITE-HEADING THRU 8510-EXIT                
               MOVE 'N' TO WS-FIRST-READ-FLAG                           
               MOVE 'Y' TO WS-OOB-RECS-FLAG                             
           END-IF.                                                      
                                                                        
           MOVE PCS131F-LOCAL-OFF TO MAIL-LOCAL-OFFICE.                 
           MOVE PCS131F-AR-TOTAL TO MAIL-AR-TOTAL.                      
           MOVE PCS131F-TYPE-ACCT TO MAIL-TYPE-ACCT.                    
           MOVE PCS131F-GL-REC TO MAIL-GL-REC.                          
           MOVE PCS131F-GL-BAL TO MAIL-GL-BAL.                          
           MOVE PCS131F-DIFF TO MAIL-DIFF.                              
           WRITE PCSR131M-REC FROM MAIL-DETAIL.                         
                                                                        
           GO TO 8500-READ-PAGE-INFO.                                   
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8510-WRITE-HEADING.                                              
                                                                        
           MOVE SPACES TO MAIL7-SUBJECT.                                
                                                                        
           IF WS-PASS-JOB = 'CSRC131'                                   
              STRING 'CSRP OOB FOR ' DELIMITED BY SIZE,                 
                     WS-DATE-8 DELIMITED BY SIZE,                       
                     INTO MAIL7-SUBJECT                                 
           ELSE                                                         
              STRING 'SEBP OOB FOR ' DELIMITED BY SIZE,                 
                     WS-DATE-8 DELIMITED BY SIZE,                       
                     INTO MAIL7-SUBJECT                                 
           END-IF.                                                      
                                                                        
           MOVE WS-PASS-JOB TO MAIL2-JOB-NAME,                          
                               MAIL5-JOB-NAME.                          
           WRITE PCSR131M-REC FROM MAILHEAD-1.                          
           WRITE PCSR131M-REC FROM MAILHEAD-2.                          
           IF WS-PASS-JOB = 'CSRC131'                                   
               WRITE PCSR131M-REC FROM MAILHEAD-3-SCEG                  
           ELSE                                                         
               WRITE PCSR131M-REC FROM MAILHEAD-3-SEB                   
           END-IF.                                                      
           WRITE PCSR131M-REC FROM MAILHEAD-4.                          
           WRITE PCSR131M-REC FROM MAILHEAD-5.                          
           IF WS-PASS-JOB = 'CSRC131'                                   
               WRITE PCSR131M-REC FROM MAILHEAD-6-SCEG                  
           ELSE                                                         
               WRITE PCSR131M-REC FROM MAILHEAD-6-SEB                   
           END-IF.                                                      
           WRITE PCSR131M-REC FROM MAILHEAD-7.                          
           WRITE PCSR131M-REC FROM MAILHEAD-8.                          
           WRITE PCSR131M-REC FROM MAILHEAD-10.                         
           WRITE PCSR131M-REC FROM MAILHEAD-11.                         
           WRITE PCSR131M-REC FROM MAILHEAD-8.                          
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8520-UPD-SUCCESS-MSG.                                            
                                                                        
           MOVE SPACES TO MAIL7-SUBJECT.                                
                                                                        
           MOVE WS-PASS-JOB TO MAIL2-JOB-NAME,                          
                               MAIL5-JOB-NAME,                          
                               MAIL7-SUBJECT,                           
                               WS-MSG-JOB.                              
           WRITE PCSR131M-REC FROM MAILHEAD-1.                          
           WRITE PCSR131M-REC FROM MAILHEAD-2.                          
           IF WS-PASS-JOB = 'CSRC131'                                   
               WRITE PCSR131M-REC FROM MAILHEAD-3-SCEG                  
           ELSE                                                         
               WRITE PCSR131M-REC FROM MAILHEAD-3-SEB                   
           END-IF.                                                      
      *    WRITE PCSR131M-REC FROM MAILHEAD-3A.                                 
           WRITE PCSR131M-REC FROM MAILHEAD-4.                          
           WRITE PCSR131M-REC FROM MAILHEAD-5.                          
           IF WS-PASS-JOB = 'CSRC131'                                   
               WRITE PCSR131M-REC FROM MAILHEAD-6-SCEG                  
           ELSE                                                         
               WRITE PCSR131M-REC FROM MAILHEAD-6-SEB                   
           END-IF.                                                      
           WRITE PCSR131M-REC FROM MAILHEAD-7.                          
           WRITE PCSR131M-REC FROM MAILHEAD-8.                          
           MOVE 'THIS IS A TEST' TO MAIL9-MESSAGE.                      
           WRITE PCSR131M-REC FROM MAILHEAD-9.                          
           MOVE WS-SUCCESS-MSG TO MAIL9-MESSAGE.                        
           WRITE PCSR131M-REC FROM MAILHEAD-9.                          
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-RPT-DETAIL                                    **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP131        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-RPT-DETAIL.                                           
      *                                                                         
           EVALUATE E-FRP09-CC                                          
               WHEN WS-1                                                
                   WRITE PRT33-RECORD FROM E-FRP09-DATA                 
                        AFTER ADVANCING 1 LINE                          
                   ADD 1               TO WS-RPT1-LINE-NO               
                   GO                  TO 8900-EXIT                     
               WHEN WS-2                                                
                   WRITE PRT33-RECORD FROM E-FRP09-DATA                 
                        AFTER ADVANCING 2 LINES                         
                   ADD 2               TO WS-RPT1-LINE-NO               
                   GO                  TO 8900-EXIT                     
               WHEN WS-3                                                
                   WRITE PRT33-RECORD FROM E-FRP09-DATA                 
                        AFTER ADVANCING 3 LINES                         
                   ADD 3               TO WS-RPT1-LINE-NO               
                   GO                  TO 8900-EXIT                     
               WHEN WS-4                                                
                   WRITE PRT33-RECORD FROM E-FRP09-DATA                 
                        AFTER ADVANCING 4 LINES                         
                   ADD 4               TO WS-RPT1-LINE-NO               
                   GO                  TO 8900-EXIT                     
               WHEN WS-T                                                
                   WRITE PRT33-RECORD FROM E-FRP09-DATA                 
                        AFTER ADVANCING 2 LINES                         
                   ADD 2               TO WS-RPT1-LINE-NO               
                   GO                  TO 8900-EXIT                     
               WHEN WS-H                                                
                   GO                  TO 8900-EXIT                     
               WHEN WS-I                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '**    PCSRP131 PROCESSING WARNING     **'   
                   DISPLAY '**  ERROR IN CONTROL CHARACTER FIELD  **'   
                   DISPLAY '**       RPT-RECORD - ' FIORP09             
                   DISPLAY '**       PROCESSING CONTINUING        **'   
           END-EVALUATE.                                                
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP09-FILE.                                          
           IF FRP09-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP131 PROCESSING ERROR        **'   
               DISPLAY '**  CLOSE ERROR FOR FCSRP09 - INPUT FILE  **'   
               DISPLAY '**       FILE STATUS = ' WS-FRP09-STATUS        
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   9900-ABEND                                               **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
