       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP123.                                        
       DATE-WRITTEN.   06/16/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** PCSCA123 REPORTS THE METERS ESTIMATED LAST MONTH.           **         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  06/16/95     SC        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  --------     ----------------------------------  **         
      **  06/30/95     DW        ADDED CWS00303; CHANGED DATE FORMAT **         
      **                         IN WORKING-STORAGE FOR CORRECT RUN- **         
      **                         DATE; CORRECTED SPACING & SPELLING  **         
      **                         ERRORS; ADDED COBOL ADVANCE.        **         
      **  --------  --------     ----------------------------------  **         
T13490**  11/19/97     AMG       PROCESSING TO HANDLE THE FOLLOWING: **         
T13490**                           - EMPTY EXTRACT FILE              **         
T13490**                           - EXTRACT HAS MULTIPLE HEAD RECS  **         
T13490**                           - COMPANY END REC IN INCORRECT    **         
T13490**                             PLACE                           **         
      **  --------  --------     ----------------------------------  **         
      **  11/19/97     AMG       FIXED LOCAL OFFICE DESCRIPTION      **         
      **                         IN THE REPORT HEADER                **         
      **  --------  --------     ----------------------------------  **         
T14050**  12/15/97     TQT       MOVE DATA INTO COMPANY NO AND READ  **         
      **                         CYCLE WHEN INPUT FILE CONTAINS      **         
      **                         ZERO DETAIL RECORD                  **         
      **  --------  --------     ----------------------------------  **         
T14410**  01/20/98     AMG       FIXED READ CYCLE PROBLEM AND CHANGED**         
T14410**                         LOGIC TO INCLUDE NO READ RSN DESC   **         
      **  --------  --------     ----------------------------------  **         
T15975**  04/20/98     TDK       CENTERED DATA UNDERNEATH COLUMN     **         
T15975**                         HEADERS.                            **         
      **  --------  --------     ----------------------------------  **         
T18861**  02/03/99    CBSI       INCLUDED READ-CODE-DESC AND READ-   **         
T18861**              MADRAS     COND-CODE-DESC IN THE REPORT        **         
      **  --------  --------     ----------------------------------  **         
T22002**  06/19/00    MRL        ADD SUB-TOTALS BY LOCAL OFFICE AND  **         
T22002**                         GRAND TOTAL TO THE REPORT           **         
      **  --------  --------     ----------------------------------  **         
T26407**  05/20/02    JDW        IF NO-READ REASON CODE FROM FILE IS **         
T26407**                         SPACES, USE THE REASON CODE FROM    **         
T26407**                         ROUTE REPORT TABLE.                 **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP123 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP123.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP123.                                                           
       COPY FIORP123.                                                           
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP123'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP123 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
T14410     EXEC SQL                                                             
T14410         INCLUDE TBNORDRN                                                 
T14410     END-EXEC.                                                            
      *                                                                         
T18861     EXEC SQL                                                             
T18861         INCLUDE TBRTERPT                                                 
T18861     END-EXEC.                                                            
      *                                                                         
T18861     EXEC SQL                                                             
T18861         INCLUDE TBRDWNDW                                                 
T18861     END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-HEADER1 PIC X(27)    VALUE               
                                   'METERS ESTIMATED LAST MONTH'.       
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
                                   '  S C ELECTRIC & GAS CO   '.        
      *                                                                         
           05  WS-DEFAULT-RPT1-HEADER2.                                 
               10  FILLER              PIC X(14)    VALUE               
                                       'CURRENT AS OF '.                
               10  WS-DEFAULT-RPT1-HEADER2-DT PIC X(08).                
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-STARTED                   VALUE 'Y'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-PRINT-NEXT-ROUTE-NO  PIC X(01)    VALUE 'N'.          
               88  ROUTE-NO-HAS-CHANGED             VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE '  '.         
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
T22002     05  WS-LOC-OFF-CNTR         PIC 9(07)    VALUE ZERO COMP-3.  
T22002     05  WS-TOT-COM-CNTR         PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FRP123-REC-CNTR      PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-FRP123-STATUS        PIC X(02).                       
               88  FRP123-SUCCESSFUL                VALUE '00'.         
      *                                                                         
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
           05  WS-PREV-LOCAL-OFFICE    PIC X(03)    VALUE SPACES.       
           05  WS-PREV-READ-CYCLE      PIC X(02)    VALUE SPACES.       
T18861     05  WS-READ-CYCLE           PIC X(02)    VALUE SPACES.       
T18861     05  WS-REVENUE-MONTH        PIC S9(06)   VALUE ZEROES.       
T18861     05  WS-REVENUE-MONTH-RED REDEFINES WS-REVENUE-MONTH.         
               10 WS-REV-YY            PIC 9(04).                       
               10 WS-REV-MM            PIC 9(02).                       
T18861     05  WS-ACCOUNT-NO           PIC S9(13)   COMP-3              
                                                    VALUE ZEROES.       
T18861     05  WS-CODE-UTIL-TYPE       PIC X(01)    VALUE SPACES.       
T18861     05  WS-IC-NO                PIC S9(04)   USAGE COMP.         
T18861     05  WS-METER-NO             PIC X(09)    VALUE SPACES.       
T18861     05  WS-REG-MEASURE-CD       PIC X(03)    VALUE SPACES.       
T18861     05  WS-READING-COND-CD      PIC X(01)    VALUE SPACES.       
T18861     05  WS-READING-CD           PIC X(01)    VALUE SPACES.       
T18861     05  WS-RUN-DATE-1           PIC X(10)    VALUE SPACES.       
           05  WS-PREV-ROUTE-NO        PIC S9(04)   VALUE ZEROS.        
           05  WS-CHECK-LINE-NO        PIC 99       VALUE ZEROS.        
T13490     05  WS-READ-CYCLE-NUMERIC   PIC S9(04)   COMP.               
T18861     05  WS-TABLE-FLAG           PIC X(01)    VALUE 'N'.          
T18861     05  WS-READING-COND-CD-DESC PIC X(35)    VALUE SPACES.       
T18861     05  WS-READING-CD-DESCN     PIC X(23)    VALUE SPACES.       
T18861     05  WS-1                    PIC 9(01)    VALUE 1 .           
T18861     05  WS-ONE                  PIC X(01)    VALUE '1' .         
T18861     05  WS-NINE                 PIC X(01)    VALUE '9' .         
T26407     05  WS-HOLD-READ-COND-CD    PIC X(01)    VALUE SPACES.       
      *                                                                         
T18861 01  WS-READING-CODE-DESC.                                        
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          '0MISSED/SKIPPED'.      
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          '1FRSM TRANSFERRED'.    
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'AOMR READ'.            
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'BMANUAL READ FOR ERT'. 
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'CCUSTOMER READ'.       
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'FFIELD ESTIMATE'.      
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'HSCANNED REMOTE READ'. 
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'IPC READ'.             
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                       'KDIGITAL/TOU MANUAL READ'.
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'MMANUAL REMOTE READ'.  
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'NCANT READ'.           
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'RREGULAR READ'.        
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'TTOU OPTICAL READ'.    
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'XFORCED COMPLETE'.     
T18861     05 FILLER               PIC X(24) VALUE                      
T18861                                          'ZDCH MEMORY ERROR'.    
T18861 01  WS-READING-CODE-DESC-RED  REDEFINES WS-READING-CODE-DESC.    
T18861     05  WS-READING-CODE-DESC-TBL OCCURS 15 TIMES                 
T18861                                 INDEXED BY WS-TBL-INDX .         
T18861         10 WS-READING-CODE      PIC X(01).                       
T18861         10 WS-READING-CODE-DESC-1 PIC X(23).                     
T18861*                                                                         
T18861 01  WS-READING-COND-CODE-DESC.                                   
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '1FAILED LOW-2'.                     
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '2FAILED LOW-1'.                     
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '3FAILED HIGH-1'.                    
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '4FAILED HIGH-2'.                    
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '5FAILED LOW-2,X IN MTR NO'.         
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '6FALLED HIGH-2,X IN MTR NO'.        
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '7ZERO CONSUMPTION ON ACTIVE METER'. 
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '8CONSUMPTION ON INACTIVE METER'.    
T18861     05 FILLER               PIC X(35) VALUE                      
T18861                             '9FAILED FULL SCALE'.                
      *                                                                         
T18861 01  WS-READING-COND-CODE-DESC-RED REDEFINES                      
                                         WS-READING-COND-CODE-DESC.     
T18861     05  WS-READING-COND-CODE-DESC-TBL OCCURS 09 TIMES            
T18861                                 INDEXED BY WS-TBL-INDX-1.        
T18861         10 WS-READING-COND-CODE         PIC X(01).               
T18861         10 WS-READING-COND-CODE-DESC-1  PIC X(34).               
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 62   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(05)    VALUE ZERO COMP-3.  
      ****************************************************************          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP123'.   
           05  WS-60                   PIC 9(02)    VALUE 60.           
      *                                                                         
      ***************** PCSRP123 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT TITLE            **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER1          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(39)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(27).                       
               10  FILLER              PIC X(34)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER2          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(55)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(22)    VALUE SPACES.       
               10  FILLER              PIC X(41)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-LOCAL-OFF-HEADER.                                
               10  FILLER              PIC X(14)    VALUE               
                                                   'LOCAL OFFICE: '.    
               10  P-LOCAL-OFFICE-CODE PIC X(03).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-LOCAL-OFFICE-DESC PIC X(22).                       
               10  FILLER              PIC X(92)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-READ-CYCLE-HEADER.                               
               10  FILLER              PIC X(14)    VALUE               
                                                   'READ CYCLE  : '.    
T13490         10  P-READ-CYCLE        PIC X(02).                       
               10  FILLER              PIC X(116)    VALUE SPACES.      
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-1.                                 
T18861         10  FILLER              PIC X(122)   VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE               
                                                   'NUMBER OF  '.       
      *                                                                         
T18861     05  WS-RPT1-COLUMN-HEADER-1-A.                               
T18861         10  FILLER              PIC X(122)   VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE               
                                                   'CONSECUTIVE'.       
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-2.                                 
T18861         10  FILLER              PIC X(108)   VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'CURRENT NO'. 
T18861         10  FILLER              PIC X(04)    VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE 'MONTHS-WITH'.
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-3.                                 
T18861         10  FILLER              PIC X(01)    VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE               
T18861                                             'ACCT-NUMBER'.       
T13490         10  FILLER              PIC X(03)    VALUE SPACES.       
T18861         10  FILLER              PIC X(22)    VALUE               
T18861                                         'READING-COND-CODE-DESC'.
T18861         10  FILLER              PIC X(28)    VALUE SPACES.       
T18861         10  FILLER              PIC X(17)    VALUE               
T18861                                             'READING-CODE-DESC'. 
T18861         10  FILLER              PIC X(07)    VALUE SPACES.       
T18861         10  FILLER              PIC X(06)    VALUE 'MTR-NO'.     
T18861         10  FILLER              PIC X(04)    VALUE SPACES.       
T18861         10  FILLER              PIC X(08)    VALUE 'MTR-TYPE'.   
T18861         10  FILLER              PIC X(01)    VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE 'READ-REASON'.
T18861         10  FILLER              PIC X(03)    VALUE SPACES.       
T18861         10  FILLER              PIC X(11)    VALUE               
T18861                                             'NO-MTR-READ'.       
T18861*                                                                         
T18861     05  WS-RPT1-COLUMN-HEADER-4.                                 
T18861         10  FILLER              PIC X(15)    VALUE SPACES.       
T18861         10  FILLER              PIC X(24)    VALUE               
T18861                                             'SERVICE-ADDRESS'.   
T18861         10  FILLER              PIC X(94)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **          WORKING STORAGE FOR REPORT DETAIL LINES           **          
      ****************************************************************          
      *                                                                         
       01  WS-RPT1-DETAIL-LINES.                                        
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-1.                                   
T18861         10  FILLER                 PIC X(01)    VALUE SPACES.    
               10  P-ACCOUNT-NO           PIC 9(13).                    
T18861         10  FILLER                 PIC X(01)    VALUE SPACES.    
T18861         10  P-READING-COND-CD      PIC X(35).                    
T18861         10  FILLER                 PIC X(15)    VALUE SPACES.    
T18861         10  P-READING-CODE         PIC X(23).                    
T18861         10  FILLER                 PIC X(01)    VALUE SPACES.    
T13490         10  P-METER-NO             PIC X(09).                    
T18861         10  FILLER                 PIC X(04)    VALUE SPACES.    
               10  P-METER-TYPE           PIC X(01).                    
T18861         10  FILLER                 PIC X(08)    VALUE SPACES.    
               10  P-NO-READ-RSN          PIC X(07).                    
T18861         10  FILLER                 PIC X(06)    VALUE SPACES.    
               10  P-NO-CONSEC-ESTIMATES  PIC ZZZ9.                     
T18861         10  FILLER                 PIC X(05)    VALUE SPACES.    
      *                                                                         
T18861     05  WS-RPT1-DETAIL-LINE-2.                                   
T18861         10  FILLER                 PIC X(15)    VALUE SPACES.    
T18861         10  P-SERVICE-ADDR         PIC X(50).                    
T18861         10  FILLER                 PIC X(68)    VALUE SPACES.    
      *                                                                         
T22002     05  WS-LOC-OFF-SUBTOT-LINE.                                  
T22002         10  FILLER                 PIC X(02)    VALUE SPACES.    
T22002         10  FILLER                 PIC X(40)    VALUE            
T22002             'LOCAL OFFICE SUB-TOTAL FOR CANT READ : '.           
T22002         10  FILLER                 PIC X(25)     VALUE SPACES.   
T22002         10  P-LOC-OFF-SUB-TOTAL    PIC ZZ,ZZ9.                   
T22002         10  FILLER                 PIC X(59)     VALUE SPACES.   
      *                                                                         
T22002     05  WS-LOC-OFF-GRAND-TOT-LINE.                               
T22002         10  FILLER                 PIC X(02)     VALUE SPACES.   
T22002         10  FILLER                 PIC X(41)     VALUE           
T22002             'LOCAL OFFICE GRAND TOTAL FOR CANT READ : '.         
T22002         10  FILLER                 PIC X(24)     VALUE SPACES.   
T22002         10  P-LOC-OFF-GRAND-TOTAL  PIC ZZ,ZZ9.                   
T22002         10  FILLER                 PIC X(56)     VALUE SPACES.   
      *                                                                         
       01  WS-RPT1-CONTROL-BREAK-LINE.                                  
      *                                                                         
           05  WS-CONTROL-BREAK-LINE-1.                                 
               10  FILLER                 PIC X(8)     VALUE 'ROUTE - '.
               10  P-ROUTE-NO             PIC 9999.                     
               10  FILLER                 PIC X(120)   VALUE SPACES.    
      *                                                                         
      ****************************************************************          
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
      *                                                                         
T18861*                                                                         
T18861***  DECLARE CURSOR FOR CSS_ROUTE_READ                                    
T18861*                                                                         
T18861     EXEC SQL                                                     
T18861         DECLARE READ-CURSOR CURSOR FOR                           
T18861         SELECT  READING_COND_CD,                                 
T18861                 READING_CODE,                                    
T18861                 LAST_REG_READ_DT,                                
T18861                 REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM                                 
T18861         FROM    CSS_ROUTE_REPORT                                 
T18861         WHERE  REVENUE_MONTH     =  :PW-REVENUE-MONTH    AND     
T18861                ACCOUNT_NO        =  :PW-ACCOUNT-NO       AND     
T18861                CODE_UTIL_TYPE    =  :PW-CODE-UTIL-TYPE   AND     
T18861                IC_NO             =  :PW-IC-NO            AND     
T18861                METER_NO          =  :PW-METER-NO         AND     
T18861                REG_MEASURE_CD    =  :PW-REG-MEASURE-CD           
T18861         ORDER BY LAST_REG_READ_DT  DESC,                         
T18861                  LAST_REG_READ_TM  DESC                          
T18861     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE READ-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT  READING_COND_CD,                                         
MFA-TR*                READING_CODE,                                            
MFA-TR*                LAST_REG_READ_DT,                                        
MFA-TR*                LAST_REG_READ_TM                                         
MFA-TR*        FROM    CSS_ROUTE_REPORT                                         
MFA-TR*        WHERE  REVENUE_MONTH     =  :PW-REVENUE-MONTH    AND             
MFA-TR*               ACCOUNT_NO        =  :PW-ACCOUNT-NO       AND             
MFA-TR*               CODE_UTIL_TYPE    =  :PW-CODE-UTIL-TYPE   AND             
MFA-TR*               IC_NO             =  :PW-IC-NO            AND             
MFA-TR*               METER_NO          =  :PW-METER-NO         AND             
MFA-TR*               REG_MEASURE_CD    =  :PW-REG-MEASURE-CD                   
MFA-TR*        ORDER BY LAST_REG_READ_DT  DESC,                                 
MFA-TR*                 LAST_REG_READ_TM  DESC                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP123 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
      *                                                                         
           PERFORM 7100-READ-FCSRP123            THRU 7100-EXIT.        
T13490     IF E-FRP123-KEY-EREC EQUAL HIGH-VALUES                       
T13490         PERFORM 1900-PROCESS-END-REC  THRU 1900-EXIT             
T13490     ELSE                                                         
T13490         IF E-FRP123-CO-KEY-EREC EQUAL HIGH-VALUES                
T13490             DISPLAY                                              
T13490              '**       PCSRP123 PROCESSING ERROR       **'       
T13490             DISPLAY                                              
T13490              '**   COMPANY END RECORD IN WRONG PLACE   **'       
T13490             DISPLAY                                              
T13490              '**         PROCESSING TERMINATED         **'       
T13490             PERFORM 9900-ABEND            THRU 9900-EXIT         
T13490         ELSE                                                     
T13490             IF E-FRP123-KEY-EREC EQUAL LOW-VALUES                
T13490                 DISPLAY                                          
T13490                  '**       PCSRP123 PROCESSING ERROR       **'   
T13490                 DISPLAY                                          
T13490                  '** EXTRACT HAD MORE THAN ONE HEAD RECORD **'   
T13490                 DISPLAY                                          
T13490                  '**         PROCESSING TERMINATED         **'   
T13490                 PERFORM 9900-ABEND        THRU 9900-EXIT         
T13490             ELSE                                                 
T13490                 MOVE E-FRP123-LOCAL-OFFICE                       
T13490                           TO WS-PREV-LOCAL-OFFICE                
T13490                 MOVE E-FRP123-READ-CYCLE                         
T13490                           TO WS-PREV-READ-CYCLE                  
T13490                 MOVE E-FRP123-ROUTE-NO                           
T13490                           TO WS-PREV-ROUTE-NO                    
T18861                 PERFORM 1150-GET-REV-MONTH                       
T18861                     THRU 1150-EXIT                               
T13490                 PERFORM 1100-PRODUCE-REPORTS                     
T13490                     THRU 1100-EXIT                               
T13490                         UNTIL NO-MORE-DATA                       
T13490             END-IF                                               
T13490         END-IF                                                   
T13490     END-IF.                                                      
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FRP123-REC-CNTR EQUAL ZERO                         
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8300-PRINT-CONTROL-HEADER                    
                                                 THRU 8300-EXIT         
                   PERFORM 8400-PRINT-COLUMN-HEADERS                    
                                                 THRU 8400-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
T22002             ADD WS-LOC-OFF-CNTR     TO WS-TOT-COM-CNTR           
T22002             MOVE WS-LOC-OFF-CNTR    TO P-LOC-OFF-SUB-TOTAL       
T22002             WRITE PRT33-RECORD FROM                              
T22002                                  WS-LOC-OFF-SUBTOT-LINE AFTER 3  
T22002             MOVE 0                  TO WS-LOC-OFF-CNTR           
T22002             MOVE WS-TOT-COM-CNTR    TO P-LOC-OFF-GRAND-TOTAL     
T22002             WRITE PRT33-RECORD FROM                              
T22002                                WS-LOC-OFF-GRAND-TOT-LINE AFTER 4 
T22002             MOVE 0                  TO WS-TOT-COM-CNTR           
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                     
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8300-PRINT-CONTROL-HEADER                    
                                                 THRU 8300-EXIT         
                   PERFORM 8400-PRINT-COLUMN-HEADERS                    
                                                 THRU 8400-EXIT         
                   WRITE PRT33-RECORD FROM WS-NO-DATA-LINE              
                       AFTER ADVANCING 3 LINES                          
               ELSE                                                     
                   WRITE PRT33-RECORD FROM WS-END-DATA-LINE             
                       AFTER ADVANCING 3 LINES                          
           END-IF
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP123 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP123 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE  FROM DATE.                           
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSRP123-FILE.                                    
           IF FRP123-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP123 PROCESSING ERROR      **'     
               DISPLAY '** OPEN ERROR OF FCSRP123 - INPUT FILE  **'     
               DISPLAY '**      FILE STATUS = ' WS-FRP123-STATUS        
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO,                
                                          B1-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       TO CHECK THE BEGIN OF THE FILE FCSRP123-FILE         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 7100-READ-FCSRP123            THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP123-KEY-BREC EQUAL LOW-VALUES                        
               SUBTRACT 1 FROM WS-FRP123-REC-CNTR                       
               MOVE E-FRP123-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
                                          RW-DATE-MTR-RD-XTRCT          
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
               MOVE WS-DATE-8          TO WS-DEFAULT-RPT1-HEADER2-DT    
           ELSE                                                         
               DISPLAY '**       PCSRP123 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSRP123        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP123 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF  E-FRP123-CO-KEY-EREC EQUAL HIGH-VALUES OR            
                   E-FRP123-KEY-EREC    EQUAL HIGH-VALUES               
                   PERFORM 1700-CHECK-END-REC    THRU 1700-EXIT         
               ELSE                                                     
                   IF REPORT-STARTED                                    
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       MOVE WS-Y       TO WS-START-REPORT               
                       MOVE E-FRP123-COMPANY-NO                         
                                       TO WS-CURRENT-COMP-NO            
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSRP123            THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18861**   1150-GET-REV-MONTH.                                      **          
T18861**   GET THE REVENUE MONTH FROM CSS-READ_WINDOW               **          
T18861**                                                            **          
T18861****************************************************************          
T18861*                                                                         
T18861 1150-GET-REV-MONTH.                                              
T18861*                                                                         
T18861     MOVE E-FRP123-READ-CYCLE          TO RW-READ-CYCLE.          
T18861     PERFORM 7400-GET-REV-MONTH        THRU 7400-EXIT.            
T18861     MOVE RW-REVENUE-MONTH             TO WS-REVENUE-MONTH.       
T18861     IF WS-REV-MM = WS-1                                          
T18861         MOVE 12 TO WS-REV-MM                                     
T18861         COMPUTE WS-REV-YY = WS-REV-YY - WS-1                     
T18861     ELSE                                                         
T18861         COMPUTE WS-REV-MM = WS-REV-MM - WS-1                     
T18861     END-IF.                                                      
T18861                                                                  
T18861     MOVE WS-REVENUE-MONTH             TO PW-REVENUE-MONTH.       
T18861*                                                                         
T18861 1150-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       IT CHECKS WHETHER PROCESS END REC OR COMPANY END REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           MOVE '1700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP123-CO-NO-KEY-EREC EQUAL HIGH-VALUES                 
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           MOVE '1800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               MOVE WS-60              TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           SUBTRACT 1 FROM WS-FRP123-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FRP123-CO-REC-COUNT-EREC         
               IF E-FRP123-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO        
                   MOVE WS-Y           TO WS-END-OF-SYSIN-REC           
               END-IF                                                   
           ELSE                                                         
               IF E-FRP123-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO        
                   DISPLAY '**        PCSRP123 PROCESSING ERROR     **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP123-COMPANY-NO      
                   DISPLAY '**  ACTUAL RECORD COUNT OF THE COMPANY  **' 
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD     **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                      E-FRP123-CO-REC-COUNT-EREC        
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING TERMINATED         **' 
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   DISPLAY '**        PCSRP123 PROCESSING ERROR     **' 
                   DISPLAY '**  COMPANY NO = ' E-FRP123-CO-NO-KEY-EREC  
                   DISPLAY '**  ACTUAL RECORD COUNT OF THE COMPANY  **' 
                   DISPLAY '**    DOES NOT MATCH CONTROL RECORD     **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                      E-FRP123-CO-REC-COUNT-EREC        
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING CONTINUES          **' 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF RECORDS                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           MOVE '1900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           SUBTRACT 1 FROM WS-FRP123-REC-CNTR.                          
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**         PCSRP123 PROCESSING ERROR        **' 
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD   **' 
               DISPLAY '**          PROCESSING TERMINATED           **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FRP123-REC-CNTR EQUAL E-FRP123-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP123 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP123-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP123-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE E-FRP123-COMPANY-NO                                 
                                       TO WS-CURRENT-COMP-NO            
               MOVE E-FRP123-LOCAL-OFFICE                               
                                       TO WS-PREV-LOCAL-OFFICE          
               MOVE E-FRP123-READ-CYCLE                                 
                                       TO WS-PREV-READ-CYCLE            
               MOVE E-FRP123-ROUTE-NO  TO WS-PREV-ROUTE-NO              
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
           END-IF.                                                      
      *                                                                         
           IF E-FRP123-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO          
               DISPLAY '**      PCSRP123 PROCESSING ERROR       **'     
               DISPLAY '**  COMPANY DATA RECORDS NOT SEPARATED  **'     
               DISPLAY '**    WITH PROPER COMPANY END-RECORD    **'     
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FRP123-COMPANY-NO 
               DISPLAY '** DATA IS :'  E-FRP123-DATA-REC                
               DISPLAY '**       PROCESSING TERMINATED          **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                   IF E-FRP123-COMPANY-NO EQUAL WS-SYSIN-COMP-NO        
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT                     
                                                 THRU 2200-EXIT         
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '**   PCSRP123 PROCESSING ERROR   **'
                           DISPLAY '**   FILE NOT SORTED PROPERLY    **'
                           DISPLAY '**  IN ORDER OF COMPANY NUMBERS  **'
                           DISPLAY '**  DATA IS :'  E-FRP123-DATA-REC   
                           DISPLAY '**     PROCESSING TERMINATED     **'
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T22002     IF WS-PREV-LOCAL-OFFICE NOT EQUAL E-FRP123-LOCAL-OFFICE      
T22002        ADD WS-LOC-OFF-CNTR      TO WS-TOT-COM-CNTR               
T22002        MOVE WS-LOC-OFF-CNTR     TO P-LOC-OFF-SUB-TOTAL           
T22002        WRITE PRT33-RECORD FROM                                   
T22002                           WS-LOC-OFF-SUBTOT-LINE AFTER 3         
T22002        MOVE 0                   TO WS-LOC-OFF-CNTR               
T22002     END-IF.                                                      
      *                                                                         
           IF E-FRP123-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCAL-OFFICE      
               MOVE WS-60              TO WS-RPT1-LINE-NO               
           ELSE                                                         
               IF E-FRP123-READ-CYCLE NOT EQUAL WS-PREV-READ-CYCLE      
T18861             PERFORM 1150-GET-REV-MONTH                           
T18861                                 THRU 1150-EXIT                   
                   MOVE WS-60          TO WS-RPT1-LINE-NO               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF E-FRP123-ROUTE-NO NOT EQUAL WS-PREV-ROUTE-NO              
               COMPUTE WS-CHECK-LINE-NO = WS-RPT1-LINE-NO + 5           
               IF WS-CHECK-LINE-NO GREATER THAN 50                      
                   MOVE WS-60          TO WS-RPT1-LINE-NO               
               END-IF                                                   
               MOVE WS-Y               TO WS-PRINT-NEXT-ROUTE-NO        
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 50                           
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8300-PRINT-CONTROL-HEADER THRU 8300-EXIT         
               PERFORM 8400-PRINT-COLUMN-HEADERS THRU 8400-EXIT         
               PERFORM 8500-PRINT-ROUTE-HEADER   THRU 8500-EXIT         
               MOVE WS-N               TO WS-PRINT-NEXT-ROUTE-NO        
           END-IF.                                                      
      *                                                                         
           IF ROUTE-NO-HAS-CHANGED                                      
               PERFORM 8500-PRINT-ROUTE-HEADER   THRU 8500-EXIT         
               MOVE WS-N               TO WS-PRINT-NEXT-ROUTE-NO        
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-FORMAT-DETAIL-LINE       THRU 2300-EXIT.        
           PERFORM 8900-PRINT-DETAIL-LINE        THRU 8900-EXIT.        
           MOVE E-FRP123-LOCAL-OFFICE  TO WS-PREV-LOCAL-OFFICE.         
           MOVE E-FRP123-READ-CYCLE    TO WS-PREV-READ-CYCLE.           
           MOVE E-FRP123-ROUTE-NO      TO WS-PREV-ROUTE-NO.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP123       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T18861     MOVE SPACES                  TO WS-READING-CD-DESCN          
T18861                                     WS-READING-COND-CD-DESC.     
      *                                                                         
T18861     PERFORM 2400-GET-READ-CODE  THRU 2400-EXIT.                  
T22002     IF PW-READING-CODE = 'N'                                     
T22002        ADD +1                      TO WS-LOC-OFF-CNTR            
           END-IF                                                       
                                                                        
      *                                                                         
T18861     MOVE WS-READING-CD-DESCN    TO P-READING-CODE.               
T18861     MOVE WS-READING-COND-CD-DESC TO P-READING-COND-CD.           
           MOVE E-FRP123-ACCOUNT-NO    TO P-ACCOUNT-NO.                 
           MOVE E-FRP123-SERVICE-ADDR  TO P-SERVICE-ADDR.               
           MOVE E-FRP123-METER-NO      TO P-METER-NO.                   
           MOVE E-FRP123-METER-TYPE    TO P-METER-TYPE.                 
      *    MOVE E-FRP123-NO-READ-RSN   TO P-NO-READ-RSN.                        
T26407     IF E-FRP123-NO-READ-RSN NOT EQUAL TO SPACES                  
T14410         MOVE E-FRP123-NO-READ-RSN   TO S4-CODE-NO-RD-REASON      
T26407     ELSE                                                         
T26407         MOVE WS-HOLD-READ-COND-CD   TO S4-CODE-NO-RD-REASON      
T26407     END-IF.                                                      
T14410                                                                  
T14410     EXEC SQL                                                     
T14410        SELECT  NO_RD_REASON_ITRON                                
T14410          INTO  :S4-NO-RD-REASON-ITRON                            
T14410          FROM  CSS_NO_READ_REASON                                
T14410         WHERE  CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON         
T14410     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T14410                                                                  
T14410     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T14410                                                                  
T14410     IF WS-ACTIVE-RETURN-CODE          = SUCCESSFUL-CALL          
T14410        MOVE S4-NO-RD-REASON-ITRON    TO P-NO-READ-RSN            
T14410     ELSE                                                         
T14410        IF WS-ACTIVE-RETURN-CODE       = NOT-FOUND                
T14410           MOVE S4-CODE-NO-RD-REASON  TO P-NO-READ-RSN            
T14410        ELSE                                                      
T14410           DISPLAY '**       PCSRP123 PROCESSING ERROR       **'  
T14410           DISPLAY '** ERROR TRYING TO FIND THE DESCRIPTION  **'  
T14410           DISPLAY '**     OF THE CURRENT NO READ REASON     **'  
T14410           PERFORM 9900-ABEND                THRU 9900-EXIT       
T14410        END-IF                                                    
T14410     END-IF.                                                      
                                                                        
           MOVE E-FRP123-NO-CONSEC-ESTIMATES                            
                                       TO P-NO-CONSEC-ESTIMATES.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
T18861**   2400-GET-READ-CODE.                                      **          
T18861**      GET THE READ-CODE  AND  READ-COND-CODE .              **          
T18861**                                                            **          
T18861****************************************************************          
T18861*                                                                         
T18861 2400-GET-READ-CODE.                                              
T18861*                                                                         
           DISPLAY '2400-GET-READ-CODE'                                 
T18861     MOVE '2400'                       TO WS-ACTIVE-PARAGRAPH.    
T18861     MOVE E-FRP123-ACCOUNT-NO          TO PW-ACCOUNT-NO.          
T18861     MOVE E-FRP123-METER-TYPE          TO PW-CODE-UTIL-TYPE.      
T18861     MOVE E-FRP123-IC-NO               TO PW-IC-NO.               
T18861     MOVE E-FRP123-METER-NO            TO PW-METER-NO.            
T18861     MOVE E-FRP123-REG-MEASURE-CD      TO PW-REG-MEASURE-CD.      
T18861     PERFORM 7200-OPEN-READ-CURSOR     THRU 7200-EXIT.            
T18861     PERFORM 7210-FETCH-READ-CURSOR    THRU 7210-EXIT.            
T18861*                                                                         
T18861     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18861        PERFORM 2500-GET-READ-DESC        THRU 2500-EXIT          
T18861        PERFORM 2600-GET-READ-COND-DESC   THRU 2600-EXIT          
T26407        MOVE PW-READING-COND-CD           TO WS-HOLD-READ-COND-CD 
T18861     ELSE                                                         
T18861        MOVE SPACES                  TO WS-READING-CD-DESCN       
T18861                                     WS-READING-COND-CD-DESC      
T26407                                     WS-HOLD-READ-COND-CD         
T18861     END-IF.                                                      
T18861     PERFORM 7220-CLOSE-READ-CURSOR    THRU 7220-EXIT.            
T18861 2400-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 2500-GET-READ-DESC                                             *47290000
T18861*     SELECT THE DESCRIPTION OF READING-CODE                     *47300000
T18861*                                                                *47310000
T18861******************************************************************47320000
T18861 2500-GET-READ-DESC.                                              
T18861                                                                  
T18861     MOVE PW-READING-CODE               TO WS-READING-CD.         
T18861     SET WS-TBL-INDX                    TO +1.                    
T18861     SEARCH WS-READING-CODE-DESC-TBL                              
T18861         VARYING WS-TBL-INDX                                      
T18861         AT END CONTINUE                                          
T18861         WHEN  WS-READING-CD = WS-READING-CODE(WS-TBL-INDX)       
T18861             MOVE WS-READING-CODE-DESC-1(WS-TBL-INDX)             
T18861                                        TO WS-READING-CD-DESCN    
T18861     END-SEARCH.                                                  
T18861 2500-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 2600-GET-READ-COND-DESC.                                       *47290000
T18861*    FOR READING-CODE 'N' IT WILL GET THE READ-COND-CODE-DESC    *47300000
T18861*    FROM CSS_NO_READ_REASON, FOR ALL OTHER VALUES IT WILL GET    47310000
T18861*    FROM WORKING-STORAGE .                                               
T18861******************************************************************47320000
T18861 2600-GET-READ-COND-DESC.                                         
T18861                                                                  
T18861      IF WS-READING-CD = WS-N                                     
T18861         PERFORM 7300-GET-READ-COND-DESC   THRU 7300-EXIT         
T18861                                                                  
T18861         IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL      
T18861           MOVE  S4-NO-RD-REASON-DESC  TO WS-READING-COND-CD-DESC 
T18861         ELSE                                                     
T18861           MOVE SPACES                 TO WS-READING-COND-CD-DESC 
T18861         END-IF                                                   
T18861      ELSE                                                        
T18861         PERFORM 2700-GET-READ-COND-DESC   THRU 2700-EXIT         
T18861      END-IF.                                                     
T18861 2600-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 2700-GET-READ-COND-DESC.                                       *47290000
T18861*     SELECT THE DESCRIPTION OF READING-COND-CODE                *47300000
T18861*                                                                *47310000
T18861******************************************************************47320000
T18861 2700-GET-READ-COND-DESC.                                         
T18861                                                                  
T18861     MOVE PW-READING-COND-CD            TO WS-READING-COND-CD.    
T18861     IF WS-READING-COND-CD GREATER THAN OR EQUAL TO WS-ONE AND    
T18861        WS-READING-COND-CD LESS    THAN OR EQUAL TO WS-NINE       
T18861        SET WS-TBL-INDX-1                  TO +1                  
T18861        SEARCH WS-READING-COND-CODE-DESC-TBL                      
T18861            VARYING WS-TBL-INDX-1                                 
T18861            AT END                                                
T18861            CONTINUE                                              
T18861            WHEN  WS-READING-COND-CD =                            
T18861                              WS-READING-COND-CODE(WS-TBL-INDX-1) 
T18861            MOVE WS-READING-COND-CODE-DESC-1(WS-TBL-INDX-1)       
T18861                         TO WS-READING-COND-CD-DESC               
T18861        END-SEARCH                                                
T18861     ELSE                                                         
T18861        MOVE SPACES      TO WS-READING-COND-CD-DESC               
T18861     END-IF.                                                      
T18861 2700-EXIT.                                                       
T18861     EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSRP123                                       **          
      **      READS THE INPUT FILE FCSRP123-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSRP123.                                              
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           READ FCSRP123-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP123-SUCCESSFUL                                         
               ADD 1                   TO WS-FRP123-REC-CNTR            
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP123 READ.  STATUS IS '       
                        WS-FRP123-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T18861******************************************************************47280000
T18861* 7200-OPEN-READ-CURSOR                                          *47290000
T18861*     OPENS THE  READ CURSOR                                     *47300000
T18861*                                                                *47310000
T18861******************************************************************47320000
T18861 7200-OPEN-READ-CURSOR.                                           
T18861                                                                  
T18861     MOVE '7200'                       TO WS-ACTIVE-PARAGRAPH.    
T18861                                                                  
T18861     EXEC SQL                                                     
T18861        OPEN READ-CURSOR                                          
T18861     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18861                                                                  
T18861     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T18861                                                                  
T18861     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18861        NEXT SENTENCE                                             
T18861     ELSE                                                         
T18861           DISPLAY '**       PCSRP123 PROCESSING ERROR       **'  
T18861           DISPLAY '** OPEN ERROR IN 7200-OPEN-READ-CURSOR   **'  
T18861           DISPLAY '** RETURN CODE = ' SQLCODE                    
T18861           DISPLAY '**          PROCESSING TERMINATED        **'  
T18861           PERFORM 9900-ABEND                THRU 9900-EXIT       
T18861     END-IF.                                                      
T18861                                                                  
T18861 7200-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 7210-FETCH-READ-CURSOR                                         *47290000
T18861*     FETCHES FOR READ-CODE AND READ-COND-CODE FROM              *47300000
T18861*     CSS_ROUTE_REPORT FOR ACCOUNT-NO, REVENUE-MONTH , METER-NO  *        
T18861******************************************************************47320000
T18861 7210-FETCH-READ-CURSOR.                                          
T18861                                                                  
T18861     MOVE '7210'                        TO WS-ACTIVE-PARAGRAPH.   
T18861                                                                  
T18861     EXEC SQL                                                     
T18861        FETCH READ-CURSOR                                         
T18861        INTO :PW-READING-COND-CD,                                 
T18861             :PW-READING-CODE,                                    
T18861             :PW-LAST-REG-READ-DT,                                
T18861             :PW-LAST-REG-READ-TM                                 
T18861     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18861                                                                  
T18861     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T18861                                                                  
T18861     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T18861        CONTINUE                                                  
T18861     ELSE                                                         
T18861           DISPLAY '**       PCSRP123 PROCESSING ERROR       **'  
T18861           DISPLAY '** ERROR TRYING TO FETCH THE DESCRIPTION **'  
T18861           DISPLAY '**   IN 7210-FETCH-READ-CURSOR           **'  
T18861           DISPLAY '**   PROCESSING  TERMINATED              **'  
T18861           PERFORM 9900-ABEND            THRU 9900-EXIT           
T18861     END-IF.                                                      
T18861                                                                  
T18861 7210-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 7220-CLOSE-READ-CURSOR                                         *47290000
T18861*     CLOSE  READ CURSOR                                         *47300000
T18861*                                                                *47310000
T18861******************************************************************47320000
T18861 7220-CLOSE-READ-CURSOR.                                          
T18861                                                                  
T18861     MOVE '7220'                        TO WS-ACTIVE-PARAGRAPH.   
T18861                                                                  
T18861     EXEC SQL                                                     
T18861        CLOSE READ-CURSOR                                         
T18861     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18861                                                                  
T18861     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T18861                                                                  
T18861     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18861        NEXT SENTENCE                                             
T18861     ELSE                                                         
T18861           DISPLAY '**       PCSRP123 PROCESSING ERROR       **'  
T18861           DISPLAY '** CLOSE ERROR IN 7220-CLOSE-READ-CURSOR  **' 
T18861           DISPLAY '** RETURN CODE = ' SQLCODE                    
T18861           DISPLAY '**          PROCESSING TERMINATED        **'  
T18861     END-IF.                                                      
T18861                                                                  
T18861 7220-EXIT.                                                       
T18861     EXIT.                                                        
T18861*                                                                         
T18861******************************************************************47280000
T18861* 7300-GET-READ-COND-DESC                                        *47290000
T18861*     SELECT THE DESCRIPTION OF READING-COND-CODE                *47300000
T18861*                                                                *47310000
T18861******************************************************************47320000
T18861 7300-GET-READ-COND-DESC.                                         
T18861                                                                  
T18861     MOVE '7300'                        TO WS-ACTIVE-PARAGRAPH.   
T18861                                                                  
T18861     MOVE PW-READING-COND-CD            TO S4-CODE-NO-RD-REASON   
T18861     EXEC SQL                                                     
T18861        SELECT  NO_RD_REASON_DESC                                 
T18861          INTO  :S4-NO-RD-REASON-DESC                             
T18861          FROM  CSS_NO_READ_REASON                                
T18861          WHERE CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON         
T18861     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18861                                                                  
T18861     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T18861                                                                  
T18861     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T18861        CONTINUE                                                  
T18861     ELSE                                                         
T18861        DISPLAY '**       PCSRP123 PROCESSING ERROR        **'    
T18861        DISPLAY '** ERROR TRYING TO SELECT THE DESCRIPTION **'    
T18861        DISPLAY '**   IN 7300-GET-READ-COND-DESC           **'    
T18861        DISPLAY '**   PROCESSING  TERMINATED               **'    
T18861        PERFORM 9900-ABEND            THRU 9900-EXIT              
T18861     END-IF.                                                      
T18861                                                                  
T18861 7300-EXIT.                                                       
T18861     EXIT.                                                        
T18861****************************************************************          
T18861**                                                            **          
T18861**   7400-GET-REV-MONTH.                                      **          
T18861**      GET THE REVENUE_MONTH FROM CSS_READ_WINDOW            **          
T18861**      FOR DATE-XTRACT AND READ-CYCLE                        **          
T18861****************************************************************          
T18861*                                                                         
T18861 7400-GET-REV-MONTH.                                              
T18861*                                                                         
T18861     MOVE '7400'                TO WS-ACTIVE-PARAGRAPH.           
T18861*                                                                         
T18861                                                                  
T18861     EXEC SQL                                                     
T18861        SELECT  REVENUE_MONTH                                     
T18861          INTO  :RW-REVENUE-MONTH                                 
T18861          FROM  CSS_READ_WINDOW                                   
T18861         WHERE  DATE_MTR_RD_XTRCT = IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )         
T18861          AND   READ_CYCLE        = :RW-READ-CYCLE                
T18861     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  REVENUE_MONTH                                             
MFA-TR*         INTO  :RW-REVENUE-MONTH                                         
MFA-TR*         FROM  CSS_READ_WINDOW                                           
MFA-TR*        WHERE  DATE_MTR_RD_XTRCT = :RW-DATE-MTR-RD-XTRCT                 
MFA-TR*         AND   READ_CYCLE        = :RW-READ-CYCLE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18861                                                                  
T18861     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T18861                                                                  
T18861     IF WS-ACTIVE-RETURN-CODE          = SUCCESSFUL-CALL          
T18861        NEXT SENTENCE                                             
T18861     ELSE                                                         
T18861             DISPLAY '** SELECT ERROR IN 7400-GET-REV-MONTH    **'
T18861             DISPLAY '** RETURN CODE = ' SQLCODE                  
T18861             DISPLAY '**          PROCESSING TERMINATED        **'
T18861             PERFORM 9900-ABEND            THRU 9900-EXIT         
T18861     END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7700-GET-LOCAL-OFFICE                                    **          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    LOCAL_OFFICE_DESC                              
                INTO :B1-LOCAL-OFFICE-DESC                              
               FROM  CSS_LOCAL_OFFICE                                   
                WHERE    COMPANY_NO   = :B1-COMPANY-NO                  
                  AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE B1-LOCAL-OFFICE-DESC                                
                                       TO P-LOCAL-OFFICE-DESC           
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-LOCAL-OFFICE-DESC           
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7700-GET-LOCAL-OFFICE **'
                   DISPLAY '** RETURN CODE = ' SQLCODE                  
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT    COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
               FROM  CSS_COMPANY                                        
                WHERE    COMPANY_NO = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
T14050             MOVE WS-DEFAULT-RPT1-COMPANY TO P-RPT1-COMP-NAME     
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '** RETURN CODE = ' SQLCODE                  
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           IF SYSIN-DOES-NOT-EXIST                                      
                  MOVE E-FRP123-COMPANY-NO                              
                                       TO C7-COMPANY-NO,                
T13490                                    B1-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEADER1                                 
                                       TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEADER2                                 
                                       TO P-RPT1-HEAD2.                 
           MOVE WS-RPT1-PAGE-NO TO P-RPT1-PAGE-NO.                      
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-CONTROL-HEADER                                **          
      **     PRINTS THE CONTROL HEADER (LOCAL OFFICE & READ CYCLE)  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-CONTROL-HEADER.                                       
      *                                                                         
           MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP123-LOCAL-OFFICE  TO P-LOCAL-OFFICE-CODE           
                                          B1-LOCAL-OFFICE.              
           PERFORM 7700-GET-LOCAL-OFFICE         THRU 7700-EXIT.        
           WRITE PRT33-RECORD FROM WS-RPT1-LOCAL-OFF-HEADER             
                    AFTER ADVANCING 3 LINES.                            
      *                                                                         
T14050     IF WS-FRP123-REC-CNTR > ZERO                                 
T13490*       MOVE E-FRP123-READ-CYCLE    TO WS-READ-CYCLE-NUMERIC              
T13490*       MOVE WS-READ-CYCLE-NUMERIC  TO P-READ-CYCLE                       
T14410        MOVE E-FRP123-READ-CYCLE    TO P-READ-CYCLE               
T14050     ELSE                                                         
T14050        MOVE SPACES                 TO P-READ-CYCLE               
T14050     END-IF.                                                      
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-READ-CYCLE-HEADER            
                  AFTER ADVANCING 1 LINE.                               
      *                                                                         
           ADD 4                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8400-PRINT-COLUMN-HEADERS                                **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-COLUMN-HEADERS.                                       
      *                                                                         
           MOVE '8400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-1              
                 AFTER ADVANCING 3 LINES.                               
T18861     WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-1-A            
T18861           AFTER ADVANCING 1 LINES.                               
           WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-2              
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-3              
                 AFTER ADVANCING 1 LINE.                                
T18861     WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-4              
T18861           AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
T18861     ADD 8                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8500-PRINT-ROUTE-HEADER                                  **          
      **       PRINTS ROUTE HEADER LINE OF THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-ROUTE-HEADER.                                         
      *                                                                         
           MOVE '8500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP123-ROUTE-NO      TO P-ROUTE-NO.                   
           WRITE PRT33-RECORD FROM WS-RPT1-CONTROL-BREAK-LINE           
                   AFTER ADVANCING 2 LINES.                             
      *                                                                         
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                   AFTER ADVANCING 1 LINE.                              
           WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-1                
                   AFTER ADVANCING 1 LINE.                              
T18861     WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-2                
T18861             AFTER ADVANCING 1 LINE.                              
      *                                                                         
T18861     ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           CLOSE FCSRP123-FILE.                                         
           IF FRP123-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP123 PROCESSING ERROR        **' 
               DISPLAY '**  CLOSE ERROR FOR FCSRP123 - INPUT FILE   **' 
               DISPLAY '**       FILE STATUS = ' WS-FRP123-STATUS       
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    9900-ABEND                                              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
