       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP119.                                        
       DATE-WRITTEN.   04/20/95.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  04/20/95     SR        NEW PROGRAM FOR REPORT GENERATION   **         
      **  --------  --------     ----------------------------------  **         
      **  09/18/95     DW        ADDED CWS00303; CHANGED DATE FORMAT **         
      **                         FOR CORRECT RUN-DATE; CORRECTED     **         
      **                         SPACING AND SPELLING ERRORS.        **         
TP5601**  10/15/96     JHR       KCSRP119 SOC7 PROBLEMS                         
TP8412**  01/13/97     KB        FIXED ERROR IN HANDLING END-REC                
TP8412**  01/13/97               RECORDS WHEN THERE ARE NO DETAIL RECS.         
TP8412**  01/13/97               ALSO CORRECTED THE PRINTING PROBLEM            
TP8412**  01/13/97               OF FIRST CHARACTER GETTING TRUNCATED.          
      **                                                                        
T14114**  01/09/98     TQT       ADDED "S C ELECTRIC & GAS CO" TO               
      **                         TO COMPANY NAME FOR HEADER.                    
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP119 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA55.                                                            
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA55.                                                            
       COPY FIOCA55.                                                            
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP119'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP119 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(50)    VALUE               
               '         ACCOUNTS WITH ZERO READ SEQUENCE         '.    
      *                                                                         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
                                   '  S C ELECTRIC & GAS CO   '.        
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-EXISTS                     VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-IS-NOT-STARTED            VALUE 'N'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
TP5601     05  WS-MORE-BEGIN-REC       PIC X(01)    VALUE 'N'.          
TP5601     05  WS-BEGIN-REC-PROCESSED  PIC X(01)    VALUE 'N'.          
TP5601     05  WS-BEGIN-REC-SW         PIC X(01)    VALUE 'N'.          
TP5601         88  WS-BEGIN-REC-NOT-PROCESSED       VALUE 'N'.          
TP5601         88  WS-BEGIN-RECS-PROCESSED          VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
           05  WS-CURRENT-COMP-NO      PIC X(02)    VALUE SPACES.       
           05  WS-PREV-LOC-OFFICE      PIC X(03)    VALUE SPACES.       
           05  WS-PREV-READ-CYCLE      PIC X(02)    VALUE SPACES.       
           05  WS-PREV-ROUTE-NUMBER    PIC S9(05)   VALUE ZERO COMP-3.  
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FCA55-REC-CNTR       PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FCA55-STATUS         PIC X(02).                       
               88  FCA55-SUCCESSFUL                 VALUE '00'.         
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 62   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(04)    VALUE ZERO COMP-3.  
      ****************************************************************          
      *                                                                         
       01  WS-TURN-ON-DATE.                                             
           05  WS-TD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-TD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-TD-YY                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP119'.   
           05  WS-52                   PIC 9(02)    VALUE 52.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
      *                                                                         
      ***************** PCSRP119 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(48)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(32)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(50).                       
               10  FILLER              PIC X(23)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(41)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(50).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
                                                                        
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR LOCAL OFFICE HEADER       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X(14)    VALUE               
                                                   'LOCAL OFFICE: '.    
               10  P-RPT1-LOCAL-OFFICE PIC X(03).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-LOCAL-OFFICE-DESC PIC X(22).                       
               10  FILLER              PIC X(92)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT CYCLE HEADER       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'CYCLE:    '. 
               10  P-RPT1-READ-CYCLE   PIC X(02).                       
               10  FILLER              PIC X(113)   VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'METER NUMBER'.      
               10  FILLER              PIC X(08)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                                   'SERVICE ADDRESS'.   
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(16)    VALUE               
                                                   'ADDRESS OVERFLOW'.  
               10  FILLER              PIC X(22)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'ROUTE: '.    
               10  P-ROUTE-NUMBER      PIC X(05).                       
               10  FILLER              PIC X(113)   VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-2.                                        
               10  P-ACCOUNT-NUMBER    PIC 9(13).                       
               10  FILLER              PIC X(11)    VALUE SPACES.       
               10  P-METER-NUMBER      PIC X(09).                       
               10  FILLER              PIC X(11)    VALUE SPACES.       
               10  P-SERVICE-ADDRESS   PIC X(35).                       
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  P-ADDRESS-OVERFLOW  PIC X(20).                       
               10  FILLER              PIC X(18)    VALUE SPACES.       
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP119 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           MOVE WS-Y   TO WS-MORE-BEGIN-REC.                            
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT         
TP5601        UNTIL WS-MORE-BEGIN-REC = WS-N.                           
                                                                        
TP8412*    PERFORM 7100-READ-FCSCA55             THRU 7100-EXIT.                
TP8412**** THE CODE BELOW COMMENTED AS PART OF TP8412 FIX                       
TP5601*    IF E-FCA55-ROUTE-NUMBER NOT NUMERIC                                  
TP5601*       MOVE ZEROES TO E-FCA55-ROUTE-NUMBER                               
TP5601*    END-IF                                                               
TP8412*    MOVE E-FCA55-LOCAL-OFFICE TO WS-PREV-LOC-OFFICE                      
TP8412*    MOVE E-FCA55-READ-CYCLE     TO WS-PREV-READ-CYCLE                    
TP8412**** THE CODE ABOVE COMMENTED AS PART OF TP8412 FIX                       
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
           IF SYSIN-DOES-NOT-EXIST                                      
               IF WS-FCA55-REC-CNTR EQUAL ZERO                          
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT         
TP8412             MOVE WS-NO-DATA-LINE  TO  PRT33-DATA                 
TP8412             WRITE PRT33-RECORD                                   
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
TP8412             MOVE WS-END-DATA-LINE  TO  PRT33-DATA                
TP8412             WRITE PRT33-RECORD                                   
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           ELSE                                                         
               IF WS-SYSIN-COMP-REC-CNTR EQUAL ZERO                     
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT         
TP8412             MOVE WS-NO-DATA-LINE  TO  PRT33-DATA                 
TP8412             WRITE PRT33-RECORD                                   
                        AFTER ADVANCING 3 LINES                         
               ELSE                                                     
TP8412             MOVE WS-END-DATA-LINE  TO PRT33-DATA                 
TP8412             WRITE PRT33-RECORD                                   
                        AFTER ADVANCING 3 LINES                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**       PCSRP119 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING COMPANY RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP119 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSCA55-FILE.                                     
           IF FCA55-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**    PCSRP119 PROCESSING ERROR           **'   
               DISPLAY '**    OPEN ERROR OF FCSCA55 - INPUT FILE  **'   
               DISPLAY '**    FILE STATUS = ' WS-FCA55-STATUS           
               DISPLAY '**        PROCESSING TERMINATED           **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO,                
                                          B1-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-BEGIN-REC                                   **          
      **       CHECKS FOR THE BEGINNING OF THE FILE FCSCA55         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSCA55             THRU 7100-EXIT.        
      *                                                                         
                                                                        
           IF E-FCA55-KEY-BREC EQUAL LOW-VALUES                         
               SUBTRACT 1 FROM WS-FCA55-REC-CNTR                        
               MOVE E-FCA55-CREATE-DATE-BREC                            
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT1-DATE                   
TP5601         MOVE WS-Y TO WS-BEGIN-REC-PROCESSED                      
TP5601     ELSE                                                         
TP5601       IF WS-BEGIN-REC-PROCESSED = WS-Y                           
TP5601          MOVE WS-N TO WS-MORE-BEGIN-REC                          
TP5601          GO TO 1000-EXIT                                         
TP5601       ELSE                                                       
               DISPLAY '**       PCSRP119 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSRP119        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      PCSRP119 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           ELSE                                                         
               IF E-FCA55-CO-KEY-EREC EQUAL HIGH-VALUES OR              
                  E-FCA55-KEY-EREC    EQUAL HIGH-VALUES                 
                   PERFORM 1700-CHECK-END-REC    THRU 1700-EXIT         
               ELSE                                                     
                   IF REPORT-IS-NOT-STARTED                             
TP8412                IF E-FCA55-ROUTE-NUMBER NOT NUMERIC               
TP8412                   MOVE ZEROES TO E-FCA55-ROUTE-NUMBER            
TP8412                END-IF                                            
TP8412                MOVE E-FCA55-LOCAL-OFFICE TO WS-PREV-LOC-OFFICE   
TP8412                MOVE E-FCA55-READ-CYCLE     TO WS-PREV-READ-CYCLE 
                      MOVE WS-Y       TO WS-START-REPORT                
                      MOVE E-FCA55-COMPANY-NO                           
                                      TO WS-CURRENT-COMP-NO,            
                                         B1-COMPANY-NO                  
                      PERFORM 2100-CHECK-COMP-NO                        
                                                 THRU 2100-EXIT         
                   ELSE                                                 
                       PERFORM 2100-CHECK-COMP-NO                       
                                                 THRU 2100-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSCA55             THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1700-CHECK-END-REC                                       **          
      **       CHECKS WHETHER TO PROCESS END-REC OR COMPANY END-REC **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1700-CHECK-END-REC.                                              
      *                                                                         
           IF E-FCA55-CO-NO-KEY-EREC EQUAL HIGH-VALUES                  
               PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT         
           ELSE                                                         
               PERFORM 1800-PROCESS-COMP-END-REC THRU 1800-EXIT         
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1800-PROCESS-COMP-END-REC                                **          
      **       IT STOPS THE PROCESSING OF RECORDS FOR A COMPANY     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1800-PROCESS-COMP-END-REC.                                       
      *                                                                         
           SUBTRACT 1 FROM WS-FCA55-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR EQUAL E-FCA55-CO-REC-COUNT-EREC          
               IF E-FCA55-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   MOVE WS-Y           TO WS-END-OF-SYSIN-REC           
               END-IF                                                   
           ELSE                                                         
               IF E-FCA55-CO-NO-KEY-EREC EQUAL WS-SYSIN-COMP-NO         
                   DISPLAY '**       PCSRP119 PROCESSING ERROR      **' 
                   DISPLAY '**  COMPANY NO = ' E-FCA55-COMPANY-NO       
                   DISPLAY '**  ACTUAL RECORD COUNT OF THE COMPANY  **' 
                   DISPLAY '**     DOES NOT MATCH CONTROL RECORD    **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                     E-FCA55-CO-REC-COUNT-EREC          
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING TERMINATED         **' 
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               ELSE                                                     
                   DISPLAY '**       PCSRP119 PROCESSING ERROR      **' 
                   DISPLAY '**  COMPANY NO = ' E-FCA55-CO-NO-KEY-EREC   
                   DISPLAY '**   ACTUAL RECORD COUNT OF THE COMPANY **' 
                   DISPLAY '**     DOES NOT MATCH CONTROL RECORD    **' 
                   DISPLAY '**  CONTROL REC COUNT = '                   
                                     E-FCA55-CO-REC-COUNT-EREC          
                   DISPLAY '**  ACTUAL  REC COUNT = ' WS-COMP-REC-CNTR  
                   DISPLAY '**        PROCESSING CONTINUES          **' 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-CHANGE-COMP-NO.            
           MOVE ZERO                   TO WS-COMP-REC-CNTR.             
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1900-PROCESS-END-REC                                     **          
      **       IT STOPS THE PROCESSING OF ALL RECORDS               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FCA55-REC-CNTR.                           
      *                                                                         
           IF WS-COMP-REC-CNTR GREATER THAN ZERO                        
               DISPLAY '**         PCSRP119 PROCESSING ERROR        **' 
               DISPLAY '**  DID NOT HAVE AN ENDING COMPANY RECORD   **' 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-FCA55-REC-CNTR EQUAL E-FCA55-RECORD-COUNT-EREC         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSRP119 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FCA55-RECORD-COUNT-EREC          
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FCA55-REC-CNTR  
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2100-CHECK-COMP-NO                                       **          
      **       CHECKS COMPANY NO TO PRODUCE REPORT                  **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2100-CHECK-COMP-NO.                                              
      *                                                                         
           IF COMPANY-CHANGED                                           
               MOVE E-FCA55-COMPANY-NO TO WS-CURRENT-COMP-NO            
               MOVE WS-N               TO WS-CHANGE-COMP-NO             
               MOVE E-FCA55-LOCAL-OFFICE                                
                                       TO WS-PREV-LOC-OFFICE            
               MOVE E-FCA55-READ-CYCLE TO WS-PREV-READ-CYCLE            
TP5601         IF E-FCA55-ROUTE-NUMBER NOT NUMERIC                      
TP5601            MOVE ZEROES TO E-FCA55-ROUTE-NUMBER                   
TP5601         END-IF                                                   
               MOVE E-FCA55-ROUTE-NUMBER                                
                                       TO WS-PREV-ROUTE-NUMBER          
               MOVE WS-62              TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           IF E-FCA55-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO           
               DISPLAY '**       PCSRP119 PROCESSING ERROR      **'     
               DISPLAY '**  COMPANY DATA RECORDS NOT SEPARATED  **'     
               DISPLAY '**    WITH PROPER COMPANY END-RECORD    **'     
               DISPLAY '** CURRENT COMPANY NO IS :' WS-CURRENT-COMP-NO  
               DISPLAY '** INPUT FILE COMP NO IS :' E-FCA55-COMPANY-NO  
               DISPLAY '**        DATA IS: ' E-FCA55-DATA-REC           
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
               IF SYSIN-EXISTS                                          
                   IF E-FCA55-COMPANY-NO EQUAL WS-SYSIN-COMP-NO         
                       IF NOT-END-OF-SYSIN                              
                           PERFORM 2200-PRODUCE-RPT THRU 2200-EXIT      
                           ADD 1       TO WS-SYSIN-COMP-REC-CNTR        
                       ELSE                                             
                           DISPLAY '**   PCSRP119 PROCESSING ERROR   **'
                           DISPLAY '**    FILE NOT SORTED PROPERLY   **'
                           DISPLAY '**  IN ORDER OF COMPANY NUMBERS  **'
                           DISPLAY '**     DATA IS: ' E-FCA55-DATA-REC  
                           DISPLAY '**     PROCESSING TERMINATED     **'
                           PERFORM 9900-ABEND    THRU 9900-EXIT         
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO WS-COMP-REC-CNTR.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           IF WS-PREV-LOC-OFFICE NOT EQUAL E-FCA55-LOCAL-OFFICE OR      
              WS-PREV-READ-CYCLE NOT EQUAL E-FCA55-READ-CYCLE           
               MOVE WS-62              TO WS-RPT1-LINE-NO               
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-52                        
               PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT         
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT         
               IF E-FCA55-ROUTE-NUMBER IS EQUAL WS-PREV-ROUTE-NUMBER    
                   MOVE E-FCA55-ROUTE-NUMBER                            
                                       TO P-ROUTE-NUMBER                
                   PERFORM 8900-PRINT-DETAIL-LINE                       
                                                 THRU 8900-EXIT         
                 END-IF                                                 
           END-IF.                                                      
      *                                                                         
           IF (WS-PREV-ROUTE-NUMBER NOT EQUAL E-FCA55-ROUTE-NUMBER)     
               MOVE E-FCA55-ROUTE-NUMBER                                
                                       TO P-ROUTE-NUMBER                
               PERFORM 8900-PRINT-DETAIL-LINE   THRU 8900-EXIT          
TP5601         IF E-FCA55-ROUTE-NUMBER NOT NUMERIC                      
TP5601            MOVE ZEROES TO E-FCA55-ROUTE-NUMBER                   
TP5601         END-IF                                                   
               MOVE E-FCA55-ROUTE-NUMBER                                
                                       TO WS-PREV-ROUTE-NUMBER          
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-FORMAT-DETAIL-LINE       THRU 2300-EXIT.        
           PERFORM 8910-PRINT-DETAIL-LINE-2      THRU 8910-EXIT.        
                                                                        
           MOVE E-FCA55-LOCAL-OFFICE   TO WS-PREV-LOC-OFFICE.           
           MOVE E-FCA55-READ-CYCLE     TO WS-PREV-READ-CYCLE.           
           MOVE E-FCA55-ROUTE-NUMBER   TO WS-PREV-ROUTE-NUMBER.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP119       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FCA55-ACCOUNT-NUMBER TO P-ACCOUNT-NUMBER.             
           MOVE E-FCA55-METER-NUMBER   TO P-METER-NUMBER.               
           MOVE E-FCA55-SERVICE-ADDRESS                                 
                                       TO P-SERVICE-ADDRESS.            
           MOVE E-FCA55-ADDRESS-OVERFLOW                                
                                       TO P-ADDRESS-OVERFLOW.           
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSCA55                                        **          
      **      READS THE INPUT FILE FCSCA55                          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSCA55.                                               
      *                                                                         
           READ FCSCA55-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FCA55-SUCCESSFUL                                          
               ADD 1                   TO WS-FCA55-REC-CNTR             
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSCA55 READ.  STATUS IS '        
                        WS-FCA55-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-GET-LOCAL-OFFICE                                    **          
      **      READS THE LOCAL OFFICE NAME WITH THE GIVEN CODE       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
      *                                                                         
           MOVE '7700'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT   LOCAL_OFFICE_DESC                               
               INTO :B1-LOCAL-OFFICE-DESC                               
               FROM CSS_LOCAL_OFFICE                                    
               WHERE    COMPANY_NO   = :B1-COMPANY-NO                   
                 AND    LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE B1-LOCAL-OFFICE-DESC                                
                                       TO P-LOCAL-OFFICE-DESC           
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-LOCAL-OFFICE-DESC           
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7700-GET-LOCAL-OFFICE **'
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7800-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   COMPANY_NAME                                    
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY                                         
               WHERE    COMPANY_NO = :C7-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME               TO P-RPT1-COMP-NAME   
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
T14114             MOVE WS-DEFAULT-RPT1-COMPANY   TO P-RPT1-COMP-NAME   
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7800-GET-COMPANY-DESC **'
                   DISPLAY '**         RETURN CODE = ' SQLCODE          
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           IF SYSIN-DOES-NOT-EXIST                                      
               MOVE E-FCA55-COMPANY-NO TO C7-COMPANY-NO                 
               PERFORM 7800-GET-COMPANY-DESC     THRU 7800-EXIT         
           END-IF.                                                      
      *                                                                         
TP8412     MOVE WS-RPT1-TITLE  TO  PRT33-DATA                           
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING TOP-OF-PAGE.                            
                                                                        
           MOVE 1                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEAD1  TO P-RPT1-HEAD1.                 
TP8412     MOVE WS-RPT1-HEADER-1  TO  PRT33-DATA                        
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
TP8412     MOVE WS-RPT1-HEADER-2   TO  PRT33-DATA                       
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
           MOVE E-FCA55-LOCAL-OFFICE   TO P-RPT1-LOCAL-OFFICE,          
                                          B1-LOCAL-OFFICE.              
           MOVE E-FCA55-READ-CYCLE     TO P-RPT1-READ-CYCLE.            
      *                                                                         
           PERFORM 7700-GET-LOCAL-OFFICE         THRU 7700-EXIT.        
      *                                                                         
TP8412     MOVE WS-RPT1-HEADER-31  TO  PRT33-DATA                       
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
TP8412     MOVE WS-RPT1-HEADER-32   TO  PRT33-DATA                      
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
TP8412     MOVE WS-RPT1-HEADER-33   TO  PRT33-DATA                      
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
TP8412     MOVE WS-LINE   TO   PRT33-DATA                               
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 8                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE CYCLE HEADER OF THE REPORT                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
TP8412     MOVE WS-BLANK-LINE   TO  PRT33-DATA                          
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
TP8412     MOVE WS-DETAIL-LINE-1  TO PRT33-DATA                         
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
TP8412     MOVE WS-BLANK-LINE   TO  PRT33-DATA                          
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
TP8412     MOVE WS-BLANK-LINE   TO  PRT33-DATA                          
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 4                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8910-PRINT-DETAIL-LINE-2                                 **          
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP119        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8910-PRINT-DETAIL-LINE-2.                                        
      *                                                                         
TP8412     MOVE WS-DETAIL-LINE-2   TO  PRT33-DATA                       
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
TP8412     MOVE WS-BLANK-LINE   TO   PRT33-DATA                         
TP8412     WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
                                                                        
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA55-FILE.                                          
           IF FCA55-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP119 PROCESSING ERROR       **'   
               DISPLAY '**  CLOSE ERROR FOR FCSCA55 - INPUT FILE  **'   
               DISPLAY '**        FILE STATUS = ' WS-FCA55-STATUS       
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    9900-ABEND                                              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
