       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSRP117.                                         
       AUTHOR.        SP94986 .                                         
       DATE-WRITTEN.  SEP 2009.                                         
                                                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                         DB2                                 **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS     REASON                              **         
      ** =======    =========    =================================== **         
      ** 29/09      SP94986      NEW PROGRAM                         **         
A05081** 04/11      MS93554      SOME OF THE ACCOUNTS ARE MISSING IN **         
      **                         THE SPECIAL INSTRUCTIONS REPORTS.   **         
A05081**            MS93554      MODIFIED THE PGM PCSRP117 TO        **         
      **                         GENERATE ACS016 OUTPUT REPORT       **         
      *****************************************************************         
      ******************************************************************        
      *                      PROGRAM NARRATIVE                         *        
      *    THIS PROGRAM PROCESSES FCSBW71 FILE AND PRINTS A REPORT OF  *        
      *    SPECIAL INSTRUCTIONS FOR SCE & G AND PSNC                   *        
      ******************************************************************        
             REMARKS.                                                   
      ******************************************************************        
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                         
A05081 ENVIRONMENT DIVISION.                                            
A05081 CONFIGURATION SECTION.                                           
A05081 SOURCE-COMPUTER.    IBM-4341.                                    
A05081 OBJECT-COMPUTER.    IBM-4341.                                    
A05081 SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBW71.                                                            
       COPY CSSPT33.                                                            
       COPY CSSPT33 REPLACING  FCSPT33-FILE BY FCSPT33A-FILE,                   
                               UT-S-FCSPT33 BY UT-S-FCSPT33A.                   
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW71.                                                            
       COPY FIOBW71.                                                            
       COPY CFDPT33.                                                            
A05081 COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33A-FILE,                    
A05081                        PRT33-RECORD BY PRT33A-RECORD.                    
                                                                        
      *             WORKING-STORAGE SECTION FOR PCSRP117-1                      
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP117'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)  VALUE            
                   'WORKING STORAGE FOR PCSRP117 STARTS HERE'.          
      *                                                                         
       01  WS-WORK-VARIABLES.                                           
           05 WS-AMR                        PIC X(3)   VALUE 'AMR'.     
           05 WS-HOLD-COMP-NO               PIC X(02)  VALUE SPACES.    
           05 WS-HOLD-LOC-OFF               PIC X(03)  VALUE SPACES.    
           05 WS-LINE-NO                    PIC 9(03)  VALUE 57.        
           05 WS-PAGE-NO                    PIC 9(05)  VALUE 0.         
           05 WS-DISP-RC                    PIC -Z(07)99.               
           05 WS-PARM-COMMON-DATE           PIC X(10)  VALUE SPACES.    
           05 WS-PREV-ACCOUNT-NO            PIC 9(13)  VALUE ZERO.      
           05 WS-PREV-METER-NO              PIC X(09)  VALUE SPACES.    
           05 WS-PREV-UTL-TYPE              PIC X(01)  VALUE SPACES.    
           05 WS-PREV-WORK-SET-ID           PIC X(08)  VALUE SPACES.    
           05 WS-RPT-RUN-TIME               PIC X(08)  VALUE SPACES.    
A05081     05 WS-RPT-RUN-DATE               PIC X(10)  VALUE SPACES.    
      *                                                                         
           05 WS-COMM-DATE.                                             
              10  WS-COMM-CCYY.                                         
                  15  WS-COMM-CC            PIC X(02)  VALUE SPACES.    
                  15  WS-COMM-YY            PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE SPACES.    
              10  WS-COMM-MM                PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE SPACES.    
              10  WS-COMM-DD                PIC X(02)  VALUE SPACES.    
      *                                                                         
           05 WS-RPT-DATE.                                              
              10 WS-RPT-DT-MM               PIC X(2).                   
              10 FILLER                     PIC X      VALUE '/'.       
              10 WS-RPT-DT-DD               PIC X(2).                   
              10 FILLER                     PIC X      VALUE '/'.       
              10 WS-RPT-DT-YY               PIC X(4).                   
      *                                                                         
           05 WS-DEFAULT-COMPANY-NAME       PIC X(19)  VALUE            
                'S C ELECTRIC & GAS '.                                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FCSPT33-STATUS             PIC X(02)  VALUE '00'.      
              88 GOOD-OPEN                             VALUE '00'.      
              88 GOOD-WRITE                            VALUE '00'.      
A05081     05 WS-FCSPT33A-STATUS            PIC X(02)  VALUE '00'.      
A05081        88 OPEN-OK                               VALUE '00'.      
A05081        88 WRITE-OK                              VALUE '00'.      
           05 WS-FBW71-STATUS               PIC X(02)  VALUE '00'.      
              88 SUCCESSFULL                           VALUE '00'.      
              88 END-OF-REC                            VALUE '10'.      
           05 WS-RECS-PRESENT               PIC X(01)  VALUE 'Y'.       
              88 RECS-PRESENT                          VALUE 'Y'.       
              88 NO-MORE-RECORDS                       VALUE 'N'.       
           05 WS-FIRST-TIME                 PIC X(01)  VALUE 'Y'.       
              88 FIRST-TIME                            VALUE 'Y'.       
              88 NOT-FIRST-TIME                        VALUE 'N'.       
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-PGRMNAME                   PIC X(08)  VALUE 'PCSRP117'.
           05 PROGRAM-NAME                  PIC X(08)  VALUE 'PCSRP117'.
           05 WS-Y                          PIC X(01)  VALUE 'Y'.       
           05 WS-N                          PIC X(01)  VALUE 'N'.       
           05 WS-COMMON                     PIC X(10)  VALUE            
                                                       'COMMONDATE'.    
           05 WS-CA00                       PIC X(04)  VALUE 'CA00'.    
           05 WS-ACTIVE                     PIC X(01)  VALUE 'A'.       
           05 WS-ONE                        PIC 9(01)  VALUE 1.         
           05 WS-MAX-LINES                  PIC 9(03)  VALUE 56.        
                                                                        
      *          WORKING-STORAGE SECTION FOR PCSRP117-2                         
                                                                        
A05081 01  WS-STORE-FIELDS.                                             
A05081     03  WS-STORE-ROUTE.                                          
A05081         05  WS-SCEG-COMPANY     PIC XX  VALUE '01'.              
A05081         05  WS-SCEG-CYCLE       PIC XX.                          
A05081         05  WS-SCEG-DISTRICT    PIC XXX VALUE '002'.             
A05081         05  WS-SCEG-ROUTE       PIC XXXX.                        
A05081         05  WS-WORK-SET-ID      PIC X(8).                        
A05081     03  WS-ACCOUNT-NBR          PIC X(13).                       
A05081     03  WS-METER-NBR            PIC X(9).                        
A05081 01  WS-ROUTE-DATA.                                               
A05081     03  WS-ROUTE.                                                
A05081         05  WS-R-COMPANY        PIC XX.                          
A05081         05  WS-R-CYCLE          PIC XX.                          
A05081         05  WS-R-LOC-OFF        PIC XXX.                         
A05081         05  WS-R-ROUTE          PIC X(4).                        
A05081         05  WS-R-WS-ID          PIC X(8).                        
A05081     03  WS-R-ACCT-NO            PIC X(13).                       
A05081     03  WS-R-MTR-NO             PIC X(9).                        
A05081 01  WS-CURR-ROUTE.                                               
A05081     05  WS-C-COMPANY            PIC XX.                          
A05081     05  WS-C-CYCLE              PIC XX.                          
A05081     05  WS-C-LOC-OFF            PIC XXX.                         
A05081     05  WS-C-ROUTE              PIC X(4).                        
A05081     05  WS-C-WS-ID              PIC X(8).                        
A05081 01  WS-STORE-COUNTS.                                             
A05081     03  WS-STORE-CUST-COUNT     PIC S9(7) VALUE +0 COMP-3.       
A05081     03  WS-STORE-METER-COUNT    PIC S9(7) VALUE +0 COMP-3.       
A05081     03  WS-STORE-TOU-COUNT      PIC S9(7) VALUE +0 COMP-3.       
A05081     03  WS-STORE-LP-COUNT       PIC S9(7) VALUE +0 COMP-3.       
A05081     03  WS-STORE-OMR-COUNT      PIC S9(7) VALUE +0 COMP-3.       
A05081 01  WS-COUNTERS.                                                 
A05081     03  WS-CUST-COUNT           PIC S9(5) VALUE +0 COMP-3.       
A05081     03  WS-METER-COUNT          PIC S9(5) VALUE +0 COMP-3.       
A05081     03  WS-TOU-COUNT            PIC S9(5) VALUE +0 COMP-3.       
A05081     03  WS-LP-COUNT             PIC S9(5) VALUE +0 COMP-3.       
A05081     03  WS-OMR-COUNT            PIC S9(5) VALUE +0 COMP-3.       
A05081     03  WS-E-REC-CNT            PIC S9(5) VALUE +0 COMP-3.       
A05081 01  WS-PAGE-FIELDS.                                              
A05081     03  WS-LINE-COUNT           PIC S999   VALUE +0 COMP-3.      
A05081     03  WS-LEMIT                PIC S999   VALUE +53.            
A05081     03  WS-PAGE-COUNT           PIC S999   VALUE +0  COMP-3.     
A05081     03  WS-MAX-COUNT            PIC S999   VALUE +40 COMP-3.     
A05081 01  WS-REMOTE-READ-IND-FL       PIC X.                           
A05081     88 MANUAL-MTR                VALUE '0'.                      
A05081     88 AMR-MTR                   VALUE 'A'.                      
A05081     88 NON-TOU-MTR               VALUE '0' 'A'.                  
A05081     88 TOU-MANUAL                VALUE 'M'.                      
A05081     88 TOU-ONLY                  VALUE 'T'.                      
A05081     88 TOU-IDR                   VALUE 'B'.                      
A05081     88 IDR-ONLY                  VALUE 'I'.                      
A05081     88 OPTICAL-PROB-MTR          VALUE 'T' 'B' 'I'.              
      *                                                                         
      ****************************************************************          
      *     COMMON WORKING STORAGE FOR REPORT TITLE-PCSRP117-1       *          
      ****************** HEADERS FOR REPORT **************************          
      *                                                                         
       01  WS-HEADERS.                                                  
           05 WS-HDR-COMPANY-ONE.                                       
              10  FILLER                    PIC X(02)  VALUE SPACES.    
A05081        10  P-RPT-TITLE-PGM         PIC X(10)  VALUE              
                                                  'PCSRP117-1'.         
              10  FILLER                    PIC X(41)  VALUE SPACES.    
A05081        10  P-RPT-COMP-NAME1          PIC X(26)  VALUE SPACES.    
              10  FILLER                    PIC X(34)  VALUE SPACES.    
              10  FILLER                    PIC X(10)  VALUE            
                                                    'RUN-DATE: '.       
A05081        10  P-RPT-RUN-DATE1           PIC X(10)  VALUE SPACES.    
      *                                                                         
           05 WS-HDR-RPT-NAME-ONE.                                      
              10  FILLER                    PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(06)  VALUE 'DATE: '.  
              10  P-RPT-DATE1               PIC X(08)  VALUE SPACES.    
              10  FILLER                    PIC X(32)  VALUE SPACES.    
              10  FILLER                    PIC X(39)  VALUE            
                   '     SPECIAL READ INSTRUCTIONS         '.           
              10  FILLER                    PIC X(26)  VALUE SPACES.    
              10  FILLER                    PIC X(12)  VALUE            
                                                    'RUN-TIME:   '.     
              10  P-RPT-RUN-TIME1           PIC X(08)  VALUE SPACES.    
      *                                                                         
           05 WS-HDR-PAGENO-ONE.                                        
              10  FILLER                    PIC X(113) VALUE SPACES.    
              10  FILLER                    PIC X(10)  VALUE            
                                                    'PAGE    : '.       
              10  FILLER                    PIC X(04)  VALUE SPACES.    
              10  P-RPT1-PAGE-NO             PIC ZZ,ZZ9.                
      *                                                                         
           05 WS-HDR-LINE1.                                             
              10  FILLER                    PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(130) VALUE ALL '-'.   
              10  FILLER                    PIC X(01)  VALUE SPACES.    
      *                                                                         
           05 WS-HDR-LOCOFF.                                            
              10  FILLER                    PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(13)  VALUE            
                         'LOCAL OFFICE'.                                
              10  FILLER                    PIC X(02)  VALUE ': '.      
              10  P-LOCAL-OFFICE            PIC X(03)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE SPACES.    
              10  P-LOCAL-OFFICE-DESC       PIC X(22)  VALUE SPACES.    
              10  FILLER                    PIC X(90)  VALUE SPACES.    
      *                                                                         
           05 WS-HDR-CYCLE.                                             
              10  FILLER                    PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(13)  VALUE            
                         'READ CYCLE  '.                                
              10  FILLER                    PIC X(02)  VALUE ': '.      
              10  P-READ-CYCLE              PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(114) VALUE SPACES.    
      *                                                                         
           05 WS-HDR-ROUTE.                                             
              10  FILLER                    PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(13)  VALUE            
                         'READ ROUTE  '.                                
              10  FILLER                    PIC X(02)  VALUE ': '.      
              10  P-READ-ROUTE              PIC X(04)  VALUE SPACES.    
              10  FILLER                    PIC X(117) VALUE SPACES.    
      *                                                                         
           05 WS-HDR-COLUMN.                                            
              10 FILLER                     PIC X(03)  VALUE SPACES.    
              10 FILLER                     PIC X(14)  VALUE            
                        'ACCOUNT NUMBER'.                               
              10 FILLER                     PIC X(02)  VALUE SPACES.    
              10 FILLER                     PIC X(25)  VALUE            
                        'NAME '.                                        
              10 FILLER                     PIC X(03)  VALUE SPACES.    
              10 FILLER                     PIC X(08)  VALUE            
                        'READ SEQ'.                                     
              10 FILLER                     PIC X(03)  VALUE SPACES.    
              10 FILLER                     PIC X(25)  VALUE            
                        'ADDRESS '.                                     
              10 FILLER                     PIC XX     VALUE SPACES.    
              10 FILLER                     PIC X(03)  VALUE            
                        'AMR'.                                          
              10 FILLER                     PIC XX     VALUE SPACES.    
              10 FILLER                     PIC X(40)  VALUE            
                        'SPECIAL READ INSTRUCTIONS '.                   
              10 FILLER                     PIC X(3)  VALUE SPACES.     
      *                                                                         
A05081****************************************************************          
A05081*          COMMON WORKING STORAGE FOR REPORT TITLE-PCARP117-2             
A05081****************************************************************          
A05081****************** HEADERS FOR REPORT TWO***********************          
A05081*                                                                         
A05081     05 WS-HDR-COMPANY-TWO.                                       
A05081        10  FILLER                    PIC X(02)  VALUE SPACES.    
A05081        10  P-RPT-TITLE-PGM           PIC X(10) VALUE             
A05081                                              'PCSRP117-2'.       
A05081        10  FILLER                    PIC X(41)  VALUE SPACES.    
A05081        10  P-RPT-COMP-NAME2          PIC X(26)  VALUE            
A05081             '   S C ELECTRIC & GAS CO '.                         
A05081        10  FILLER                    PIC X(34)  VALUE SPACES.    
A05081        10  FILLER                    PIC X(10)  VALUE            
A05081                                              'RUN-DATE: '.       
A05081        10  P-RPT-RUN-DATE2           PIC X(10)  VALUE SPACES.    
A05081*                                                                         
A05081     05 WS-HDR-RPT-NAME-TWO.                                      
A05081        10  FILLER                    PIC X(02)  VALUE SPACES.    
A05081        10  FILLER                    PIC X(06)  VALUE 'DATE: '.  
A05081        10  P-RPT-DATE2               PIC X(08)  VALUE SPACES.    
A05081        10  FILLER                    PIC X(32)  VALUE SPACES.    
A05081        10  FILLER                    PIC X(39)  VALUE            
A05081             '     FCS FROMHOST ROUTE DETAIL         '.           
A05081        10  FILLER                    PIC X(26)  VALUE SPACES.    
A05081        10  FILLER                    PIC X(12)  VALUE            
A05081                                              'RUN-TIME:   '.     
A05081        10  P-RPT-RUN-TIME2           PIC X(08)  VALUE SPACES.    
A05081                                                                  
A05081     05 WS-HDR-PAGENO-TWO.                                        
A05081        10  FILLER                    PIC X(113) VALUE SPACES.    
A05081        10  FILLER                    PIC X(10)  VALUE            
A05081                                              'PAGE    : '.       
A05081        10  FILLER                    PIC X(04)  VALUE SPACES.    
A05081        10  P-RPT2-PAGE-NO            PIC ZZ,ZZ9.                 
                                                                        
A05081     05 WS-HEAD-COLUMN.                                           
A05081        10  FILLER          PIC X.                                
A05081        10  FILLER          PIC X(20)  VALUE                      
A05081                                    '  ROUTE            W'.       
A05081        10  FILLER          PIC X(20)  VALUE                      
A05081                                    'RK GRP     CUSTOMER '.       
A05081        10  FILLER          PIC X(20)  VALUE                      
A05081                                    '   METERS       TOU '.       
A05081        10  FILLER          PIC X(20)  VALUE                      
A05081                                    '      IDR/LP     OMR'.       
A05081        10  FILLER          PIC X(52)  VALUE SPACES.              
                                                                        
      ***************** DETAIL LINE FOR REPORT -PCSRP117-1**************        
                                                                        
       01  WS-DETAILS.                                                  
           05 WS-RPT-DETAIL-LINE.                                       
              10  FILLER                    PIC X(03)  VALUE SPACES.    
              10  P-ACCT-NO                 PIC X(13)  VALUE SPACES.    
              10  FILLER                    PIC X(03)  VALUE SPACES.    
              10  P-NAME                    PIC X(25).                  
              10  FILLER                    PIC X(03)  VALUE SPACES.    
              10  P-READ-SEQUENCE           PIC 9(08).                  
              10  FILLER                    PIC X(03)  VALUE SPACES.    
              10  P-ADDRESS                 PIC X(25).                  
              10  FILLER                    PIC XX     VALUE SPACES.    
              10  P-AMR-METER               PIC XXX    VALUE SPACES.    
              10  FILLER                    PIC XX     VALUE SPACES.    
              10  P-SPCL-READ-INST          PIC X(40).                  
              10  FILLER                    PIC X(3)   VALUE SPACES.    
      *                                                                         
           05 WS-BLANK-LINE.                                            
              10 FILLER                     PIC X(133) VALUE SPACES.    
      *                                                                         
           05 WS-NO-DATA.                                               
              10 FILLER                     PIC X(45)  VALUE SPACES.    
              10 FILLER                     PIC X(35)  VALUE            
                      ' **** NO DATA FOR THIS RUN ****'.                
              10 FILLER                     PIC X(53)  VALUE SPACES.    
      *                                                                         
           05 WS-FOOTER.                                                
              10 FILLER                     PIC X(55)  VALUE SPACES.    
              10 FILLER                     PIC X(25)  VALUE            
                      ' **** END OF REPORT **** '.                      
              10 FILLER                     PIC X(53)  VALUE SPACES.    
      *                                                                         
A05081***************** DETAIL LINE FOR REPORT PCSRP117-2 *************         
A05081*                                                                         
A05081 01  WS-DETAIL-LINE.                                              
A05081     05  FILLER          PIC X.                                   
A05081     05  WS-DET-ITRON-ROUTE.                                      
A05081         10  WS-DET-COMPANY      PIC XX.                          
A05081         10  FILLER              PIC X VALUE '-'.                 
A05081         10  WS-DET-CYCLE        PIC XX.                          
A05081         10  FILLER              PIC X VALUE '-'.                 
A05081         10  WS-DET-DIST         PIC XXX.                         
A05081         10  FILLER              PIC X VALUE '-'.                 
A05081         10  WS-DET-ROUTE        PIC X(7).                        
A05081     05  FILLER                  PIC X(2) VALUE SPACES.           
A05081     05  WS-DET-WORK-SET-ID      PIC X(8).                        
A05081     05  FILLER                  PIC X(2) VALUE SPACES.           
A05081     05  WS-DET-CUSTOMERS        PIC ZZZ,ZZ9.                     
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  WS-DET-METERS           PIC ZZZ,ZZ9.                     
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  WS-DET-TOU              PIC ZZZ,ZZ9.                     
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  WS-DET-LP               PIC ZZZ,ZZ9.                     
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  WS-DET-OMR              PIC ZZZ,ZZ9.                     
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  FILLER                  PIC X(7) VALUE SPACES.           
A05081     05  FILLER                  PIC X(4) VALUE SPACES.           
A05081     05  FILLER                  PIC X(05) VALUE SPACES.          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *    *** DECLARATION FOR CSS_COMPANY ********                             
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *    *** DECLARATION FOR CSS_JOB_PARM *******                             
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *    *** DECLARATION FOR CSS_LOCAL_OFFICE ***                             
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                           PIC X(38)  VALUE            
           'WORKING STORAGE FOR PCSRP117 ENDS HERE'.                    
      *                                                                         
           COPY CWS09900.                                                       
           COPY CWS00303.                                                       
           COPY CWS00150.                                                       
           COPY FIOJC01.                                                        
           COPY FIOCA00.                                                        
           COPY CWS00038.                                                       
           COPY CWS00114.                                                       
           COPY CWS00039.                                                       
HPCCDM*    EJECT                                                                
      *                                                                         
      ***********************************************************               
      **  PROCEDURE DIVISION                                   **               
      ***********************************************************               
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION      THRU 0100-EXIT.             
           PERFORM 0400-INPUT-ACCT-PROCESS  THRU 0400-EXIT.             
           IF NO-MORE-RECORDS                                           
              PERFORM 8600-WRITE-NO-DATA  THRU 8600-EXIT                
A05081        PERFORM 8700-NO-REPORT      THRU 8700-EXIT                
           ELSE                                                         
              PERFORM 1000-PROCESS-REPORT1 THRU 1000-EXIT               
                 UNTIL NO-MORE-RECORDS                                  
           END-IF.                                                      
                                                                        
           PERFORM 8400-PRINT-FOOTER        THRU 8400-EXIT.             
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
A05081*                                                                         
      ************************************************************              
      ** 0100-INITIALISATION                                    **              
      ** OPENS FIOBW71 INPUT FILE AND REPORT FILE, ALSO GETS    **              
      ** THE CURRENT DATE, TIME                                 **              
      ************************************************************              
       0100-INITIALISATION.                                             
           MOVE '0100'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
           MOVE WS-INPUT-DATE               TO WS-COMM-DATE             
                                               WS-PARM-COMMON-DATE      
           MOVE WS-COMM-MM                  TO WS-RPT-DT-MM             
           MOVE WS-COMM-DD                  TO WS-RPT-DT-DD             
           MOVE WS-COMM-YY                  TO WS-RPT-DT-YY             
           MOVE WS-RPT-DATE                 TO P-RPT-DATE1              
                                               P-RPT-DATE2.             
      *                                                                         
           OPEN INPUT FCSBW71-FILE.                                     
      *                                                                         
           IF GOOD-OPEN                                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSRP117 *************'             
              DISPLAY '** ERROR IN OPENING FCSBW71 FILE **'             
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FBW71-STATUS              
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSRP117 *************'             
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           IF SUCCESSFULL                                               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSRP117 ************'              
              DISPLAY '** ERROR IN OPENING REPORT FILE **'              
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FCSPT33-STATUS            
              DISPLAY '** ABENDING PROGRAM             **'              
              DISPLAY '************ PCSRP117 ************'              
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
A05081     OPEN OUTPUT FCSPT33A-FILE.                                   
      *                                                                         
A05081     IF SUCCESSFULL                                               
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081        DISPLAY '************ PCSRP117 ************'              
A05081        DISPLAY '** ERROR IN OPENING REPORT FILE **'              
A05081        DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
A05081        DISPLAY '** FILE STATUS IS ' WS-FCSPT33A-STATUS           
A05081        DISPLAY '** ABENDING PROGRAM             **'              
A05081        DISPLAY '************ PCSRP117 ************'              
A05081        PERFORM 9900-ABEND            THRU 9900-EXIT              
A05081     END-IF.                                                      
      *                                                                         
           PERFORM 0300-GET-CURR-DT-TIME    THRU 0300-EXIT              
A05081     MOVE  WS-RPT-RUN-TIME              TO P-RPT-RUN-TIME1        
A05081                                           P-RPT-RUN-TIME2.       
A05081     MOVE  WS-RPT-RUN-DATE              TO P-RPT-RUN-DATE1        
A05081                                           P-RPT-RUN-DATE2.       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 0300-GET-CURR-DT-TIME                                  **              
      **    GETS CURRENT DATE AND TIME                          **              
      ************************************************************              
       0300-GET-CURR-DT-TIME.                                           
      *                                                                         
           MOVE '0300'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
A05081     EXEC SQL                                                     
A05081          SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-RPT-RUN-TIME,
              :WS-RPT-RUN-DATE           
A05081     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RPT-RUN-TIME = CURRENT TIME                             
MFA-TR*            ,:WS-RPT-RUN-DATE = CHAR(CURRENT DATE,USA)                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************** PCSRP117 ****************'      
              DISPLAY '** ERROR IN GETTING CURRENT DATE & TIME **'      
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
A05081        DISPLAY '** RUN TIME  - ' WS-RPT-RUN-TIME                 
A05081        DISPLAY '** RUN DATE  - ' WS-RPT-RUN-DATE                 
              DISPLAY '** ABENDING PROGRAM ........            **'      
              DISPLAY '**************** PCSRP117 ****************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0400-INPUT-ACCT-PROCESS.                                         
A05081*                                                                         
A05081     PERFORM 7100-READ-FCSBW71        THRU 7100-EXIT.             
A05081     MOVE E-FBW71-COMPANY-NO        TO WS-SCEG-COMPANY.           
A05081     MOVE E-FBW71-LOCAL-OFFICE      TO WS-SCEG-DISTRICT.          
A05081     MOVE E-FBW71-WORK-SET-ID       TO WS-WORK-SET-ID.            
A05081     MOVE E-FBW71-READ-CYCLE        TO WS-SCEG-CYCLE.             
A05081     MOVE E-FBW71-READ-ROUTE        TO WS-SCEG-ROUTE.             
A05081     MOVE E-FBW71-ACCOUNT-NO        TO WS-ACCOUNT-NBR.            
A05081     MOVE E-FBW71-METER-NO          TO WS-METER-NBR.              
A05081     ADD +1                         TO WS-CUST-COUNT              
A05081                                       WS-METER-COUNT.            
A05081     PERFORM 7240-PRINT-HEADER2     THRU 7240-EXIT.               
A05081*                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      ** 1000-PROCESS-REPORT1                                   **              
      **     CONTROLS PROCESSING LOGIC OF THE PROGRAM           **              
      ************************************************************              
       1000-PROCESS-REPORT1.                                            
      *                                                                         
           MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE SPACES                      TO P-AMR-METER.             
      *                                                                         
A05081     IF E-FBW71-ACCOUNT-NO    = WS-PREV-ACCOUNT-NO AND            
A05081        E-FBW71-METER-NO      = WS-PREV-METER-NO AND              
A05081        E-FBW71-UTL-TYPE      = WS-PREV-UTL-TYPE                  
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081       IF E-FBW71-SPL-MSG-INDICATOR > ZERO                        
A05081          MOVE 'N' TO WS-FIRST-TIME                               
A05081          PERFORM 2100-PROCESS-ACCT  THRU 2100-EXIT               
A05081          IF E-FBW71-RRI = 'A'                                    
A05081             MOVE WS-AMR TO P-AMR-METER                           
A05081          END-IF                                                  
A05081          PERFORM 8000-PRINT-LOGIC THRU 8000-EXIT                 
A05081       END-IF                                                     
A05081     END-IF.                                                      
      *                                                                         
A05081     PERFORM 2000-PROCESS-REPORT2 THRU 2000-EXIT                  
      *                                                                         
A05081     PERFORM 7100-READ-FCSBW71     THRU 7100-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *-----------------------------------------------------*                   
      * MAIN PROCESSING LOGIC FOR PCSRP117-2                *                   
      * COMPARE ROUTE INFO WITH STORED DATA, AND IF CHANGED *                   
      * THEN PRINT THE LINE AND DO THE PROPER TOTALS.       *                   
      * THEN ADD TO ALL THE PROPER COUNTERS                 *                   
      *-----------------------------------------------------*                   
A05081 2000-PROCESS-REPORT2.                                            
      *                                                                         
A05081     MOVE E-FBW71-COMPANY-NO          TO WS-R-COMPANY             
A05081     MOVE E-FBW71-LOCAL-OFFICE        TO WS-R-LOC-OFF             
A05081     MOVE E-FBW71-WORK-SET-ID         TO WS-R-WS-ID               
A05081     MOVE E-FBW71-READ-CYCLE          TO WS-R-CYCLE               
A05081     MOVE E-FBW71-READ-ROUTE          TO WS-R-ROUTE               
A05081     IF WS-ROUTE NOT = WS-STORE-ROUTE                             
A05081        PERFORM 2200-END-OF-ROUTE THRU 2200-EXIT                  
A05081        MOVE WS-ROUTE TO WS-STORE-ROUTE                           
A05081     END-IF.                                                      
A05081     IF E-FBW71-ACCOUNT-NO NOT EQUAL  TO WS-ACCOUNT-NBR           
A05081        MOVE E-FBW71-ACCOUNT-NO       TO WS-ACCOUNT-NBR           
A05081        ADD +1 TO WS-CUST-COUNT                                   
A05081     END-IF.                                                      
A05081     IF E-FBW71-METER-NO NOT EQUAL TO WS-METER-NBR                
A05081        MOVE E-FBW71-METER-NO         TO WS-METER-NBR             
A05081        ADD +1                        TO WS-METER-COUNT           
A05081     END-IF.                                                      
A05081     IF E-FBW71-TIM-NAME NOT EQUAL    TO SPACES                   
A05081        ADD +1                        TO WS-TOU-COUNT             
A05081     END-IF.                                                      
A05081     IF E-FBW71-READ-LOAD-PROFILE-IND IS GREATER THAN ZERO        
A05081        ADD +1                        TO WS-LP-COUNT              
A05081     END-IF.                                                      
A05081     IF E-FBW71-RRI = 'A'                                         
A05081           ADD +1                     TO WS-OMR-COUNT             
A05081     END-IF.                                                      
A05081     MOVE E-FBW71-ACCOUNT-NO          TO WS-R-ACCT-NO             
A05081     MOVE E-FBW71-METER-NO            TO WS-R-MTR-NO.             
A05081*                                                                         
A05081 2000-EXIT.                                                       
A05081     EXIT.                                                        
      *************************************************************             
      ** 2100-PROCESS-ACCT                                       **             
      **     MOVES FILE VARIABLES TO REPORT VARIABLES            **             
      *************************************************************             
       2100-PROCESS-ACCT.                                               
      *                                                                         
           MOVE '2100'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE E-FBW71-ACCOUNT-NO   TO WS-PREV-ACCOUNT-NO              
           MOVE E-FBW71-METER-NO     TO WS-PREV-METER-NO                
           MOVE E-FBW71-UTL-TYPE     TO WS-PREV-UTL-TYPE                
      *                                                                         
           IF E-FBW71-COMPANY-NO NOT EQUAL  TO WS-HOLD-COMP-NO          
              MOVE E-FBW71-COMPANY-NO       TO C7-COMPANY-NO            
              PERFORM 7200-SELECT-COMP-NAME THRU 7200-EXIT              
              MOVE E-FBW71-COMPANY-NO       TO WS-HOLD-COMP-NO          
              IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL           
                 MOVE +26                   TO WS-MAX-FIELD-LEN-3900    
                 PERFORM 3900-CENTERING-ROUTINE                         
                                            THRU 3900-EXIT              
                 MOVE WS-OUTPUT-CTR-FIELD   TO P-RPT-COMP-NAME1         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF E-FBW71-LOCAL-OFFICE      NOT EQUAL TO WS-HOLD-LOC-OFF    
              MOVE E-FBW71-LOCAL-OFFICE     TO B1-LOCAL-OFFICE          
              PERFORM 7300-SELECT-LOC-OFF-DESC                          
                                            THRU 7300-EXIT              
              MOVE E-FBW71-LOCAL-OFFICE     TO WS-HOLD-LOC-OFF          
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW71-ACCOUNT-NO          TO P-ACCT-NO.               
           MOVE E-FBW71-FULLL-NAME          TO P-NAME.                  
           MOVE E-FBW71-STREET-ADDRESS      TO P-ADDRESS.               
           MOVE E-FBW71-SPCL-READ-INSTR     TO P-SPCL-READ-INST.        
           MOVE E-FBW71-READ-SEQ            TO P-READ-SEQUENCE.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
A05081 2200-END-OF-ROUTE.                                               
A05081****************************************************************          
A05081* SUBTOTAL THE ROUTE AT THIS POINT AND PRINT THE DETAILS                  
A05081*    IF WS-ROUTE NOT = WS-STORE-ROUTE                                     
A05081****************************************************************          
A05081     IF WS-LINE-COUNT GREATER THAN WS-MAX-COUNT                   
A05081        PERFORM 7240-PRINT-HEADER2 THRU 7240-EXIT                 
A05081     END-IF.                                                      
A05081     MOVE WS-SCEG-COMPANY             TO WS-DET-COMPANY           
A05081     MOVE WS-SCEG-CYCLE               TO WS-DET-CYCLE             
A05081     MOVE WS-SCEG-DISTRICT            TO WS-DET-DIST              
A05081     MOVE WS-WORK-SET-ID              TO WS-DET-WORK-SET-ID       
A05081     MOVE WS-SCEG-ROUTE               TO WS-DET-ROUTE             
A05081     MOVE WS-CUST-COUNT               TO WS-DET-CUSTOMERS         
A05081     MOVE WS-METER-COUNT              TO WS-DET-METERS            
A05081     MOVE WS-TOU-COUNT                TO WS-DET-TOU               
A05081     MOVE WS-LP-COUNT                 TO WS-DET-LP                
A05081     MOVE WS-OMR-COUNT                TO WS-DET-OMR               
A05081     MOVE WS-DETAIL-LINE              TO PRT33A-RECORD            
A05081     PERFORM 8500-WRITE-PRT33A  THRU 8500-EXIT.                   
A05081     ADD WS-CUST-COUNT                TO WS-STORE-CUST-COUNT      
A05081     ADD WS-METER-COUNT               TO WS-STORE-METER-COUNT     
A05081     ADD WS-TOU-COUNT                 TO WS-STORE-TOU-COUNT       
A05081     ADD WS-LP-COUNT                  TO WS-STORE-LP-COUNT        
A05081     ADD WS-OMR-COUNT                 TO WS-STORE-OMR-COUNT       
A05081     ADD +1                           TO WS-E-REC-CNT.            
A05081     IF WS-R-LOC-OFF NOT EQUAL WS-SCEG-DISTRICT                   
A05081        PERFORM 7250-TOTAL-COUNT-FCS-RPT THRU 7250-EXIT           
A05081     END-IF.                                                      
A05081     IF WS-R-COMPANY NOT EQUAL WS-SCEG-COMPANY                    
A05081        PERFORM 7240-PRINT-HEADER2 THRU 7240-EXIT                 
A05081     END-IF.                                                      
A05081     MOVE WS-ROUTE  TO WS-STORE-ROUTE                             
A05081     MOVE ZEROS     TO WS-CUST-COUNT                              
A05081                       WS-METER-COUNT                             
A05081                       WS-TOU-COUNT                               
A05081                       WS-LP-COUNT.                               
A05081     MOVE ZEROS     TO WS-OMR-COUNT.                              
A05081*                                                                         
A05081 2200-EXIT.                                                       
A05081     EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   3900-CENTERING-ROUTINE                                   **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       COPY CPD00150.                                                           
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 6240-GET-FCA00-COMMON-DATE                                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     14999800
                INCLUDE CPD00040                                        14999900
           END-EXEC.                                                    15000000
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   6251-GET-FJC01-DATE                                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     14999400
                INCLUDE CPD00037                                        14999500
           END-EXEC.                                                    14999600
      *                                                                 14999700
      *************************************************************             
      * 7100-READ-FCSBW71                                        **             
      *     READS FCSBW71 FILE                                   **             
      *************************************************************             
       7100-READ-FCSBW71.                                               
      *                                                                         
           MOVE '7100'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           READ FCSBW71-FILE                                            
           AT END MOVE 'N' TO  WS-RECS-PRESENT.                         
      *                                                                         
           IF SUCCESSFULL  OR END-OF-REC                                
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '************ PCSRP117 ***************'          
               DISPLAY '** ERROR IN READING FCSBW71 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FBW71-STATUS             
               DISPLAY '** ACCOUNT NO     ' E-FBW71-ACCOUNT-NO          
               DISPLAY '** LOCAL OFFICE   ' E-FBW71-LOCAL-OFFICE        
               DISPLAY '** READ ROUTE     ' E-FBW71-READ-ROUTE          
               DISPLAY '** ABENDING PROGRAM              **'            
               DISPLAY '************ PCSRP117 ***************'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
A05081*- THIS ROUTINE FORMATS THE DETAIL LINE OF THE REPORT ---------*          
A05081*--------------------------------------------------------------*          
A05081 7150-FORMAT-DETAIL-LINE.                                         
A05081*                                                                         
A05081     IF WS-LINE-COUNT IS GREATER THAN WS-LEMIT                    
A05081       PERFORM 7240-PRINT-HEADER2 THRU 7240-EXIT                  
A05081     END-IF.                                                      
A05081     MOVE WS-CUST-COUNT               TO WS-DET-CUSTOMERS         
A05081     MOVE WS-METER-COUNT              TO WS-DET-METERS            
A05081     MOVE WS-TOU-COUNT                TO WS-DET-TOU               
A05081     MOVE WS-LP-COUNT                 TO WS-DET-LP                
A05081     MOVE WS-OMR-COUNT                TO WS-DET-OMR               
A05081     MOVE WS-DETAIL-LINE              TO PRT33A-RECORD.           
A05081     PERFORM 8500-WRITE-PRT33A  THRU 8500-EXIT.                   
A05081*                                                                         
A05081 7150-EXIT.                                                       
A05081     EXIT.                                                        
      *************************************************************             
      ** 7200-SELECT-COMP-NAME                                   **             
      **     SELECTS THE COMPANY NAME FOR THE GIVEN COMPANY NO   **             
      *************************************************************             
       7200-SELECT-COMP-NAME.                                           
      *                                                                         
           MOVE '7200'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO :C7-COMPANY-NAME                                  
                 FROM  CSS_COMPANY                                      
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                              ,WS-DISP-RC.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME          TO WS-INPT-CTR-FIELD        
           ELSE                                                         
              DISPLAY '************ PCSRP117 ************'              
              DISPLAY '** ERROR IN SELECT-COMPANY-NAME **'              
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** SQLCODE = ' WS-DISP-RC                        
              DISPLAY '** COMPANY NO = ' C7-COMPANY-NO                  
              DISPLAY '** ABENDING PROGRAM             **'              
              DISPLAY '************ PCSRP117 ************'              
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05081*--------------------------------------------------------------*          
A05081*- THIS ROUTINE FORMATS THE HEADINGS OF THE REPORT ------------*          
A05081*--------------------------------------------------------------*          
A05081 7240-PRINT-HEADER2.                                              
A05081*                                                                         
A05081     ADD 1                       TO WS-PAGE-COUNT.                
A05081     MOVE WS-PAGE-COUNT          TO P-RPT2-PAGE-NO.               
A05081     MOVE WS-HDR-COMPANY-TWO     TO PRT33A-RECORD.                
A05081     WRITE PRT33A-RECORD AFTER ADVANCING TOP-OF-PAGE.             
A05081     MOVE WS-HDR-RPT-NAME-TWO    TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE WS-HDR-PAGENO-TWO      TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE WS-HEAD-COLUMN         TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE SPACES                 TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE 5                      TO WS-LINE-COUNT.                
A05081*                                                                         
A05081 7240-EXIT.                                                       
A05081     EXIT.                                                        
A05081*                                                                         
A05081 7250-TOTAL-COUNT-FCS-RPT.                                        
A05081*                                                                         
A05081     MOVE SPACES                 TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE 'TOTAL'                TO WS-DET-ROUTE.                 
A05081     MOVE SPACES                 TO WS-DET-WORK-SET-ID.           
A05081     MOVE WS-STORE-CUST-COUNT    TO WS-DET-CUSTOMERS.             
A05081     MOVE WS-STORE-METER-COUNT   TO WS-DET-METERS.                
A05081     MOVE WS-STORE-TOU-COUNT     TO WS-DET-TOU.                   
A05081     MOVE WS-STORE-LP-COUNT      TO WS-DET-LP.                    
A05081     MOVE WS-STORE-OMR-COUNT     TO WS-DET-OMR.                   
A05081     MOVE WS-DETAIL-LINE         TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE SPACES                 TO PRT33A-RECORD.                
A05081     PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT.                  
A05081     MOVE ZEROS                  TO WS-STORE-CUST-COUNT           
A05081                                    WS-STORE-METER-COUNT.         
A05081     MOVE ZEROS                  TO WS-STORE-TOU-COUNT            
A05081                                    WS-STORE-OMR-COUNT.           
A05081     MOVE ZEROS                  TO WS-STORE-LP-COUNT.            
A05081*                                                                         
A05081 7250-EXIT.                                                       
A05081     EXIT.                                                        
A05081*                                                                         
      *************************************************************             
      ** 7300-SELECT-LOC-OFF                                     **             
      **     SELECTS THE LOCAL OFFICE DESCRIPTION FOR THE LOCAL  **             
      ** OFFICE                                                  **             
      *************************************************************             
       7300-SELECT-LOC-OFF-DESC.                                        
      *                                                                         
           MOVE '7300'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           EXEC SQL                                                     
               SELECT  LOCAL_OFFICE_DESC                                
                 INTO :B1-LOCAL-OFFICE-DESC                             
                 FROM  CSS_LOCAL_OFFICE                                 
                WHERE  LOCAL_OFFICE = :B1-LOCAL-OFFICE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                              ,WS-DISP-RC.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE B1-LOCAL-OFFICE-DESC     TO P-LOCAL-OFFICE-DESC      
           ELSE                                                         
              DISPLAY '************ PCSRP117 ***********'               
              DISPLAY '** ERROR IN SELECT-LOC-OFF     **'               
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** SQLCODE = ' WS-DISP-RC                        
              DISPLAY '** LOCAL OFFICE = ' B1-LOCAL-OFFICE              
              DISPLAY '** ABENDING PROGRAM            **'               
              DISPLAY '************ PCSRP117 ***********'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 7600-START-FCSJC01                                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                 14999700
      ****************************************************************          
      **                                                            **          
      ** 7620-START-FCSCA00                                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      **********************************************************                
      ** 8000-PRINT-LOGIC                                     **                
      **     CONTROLS THE WHOLE PRINTING LOGIC FOR REPORT     **                
      **********************************************************                
       8000-PRINT-LOGIC.                                                
      *                                                                         
           MOVE '8000'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           IF (WS-LINE-NO > 56) OR                                      
              (E-FBW71-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID)           
              ADD WS-ONE                    TO WS-PAGE-NO               
              MOVE E-FBW71-READ-CYCLE       TO P-READ-CYCLE             
              MOVE E-FBW71-LOCAL-OFFICE     TO P-LOCAL-OFFICE           
              MOVE E-FBW71-READ-ROUTE       TO P-READ-ROUTE             
              MOVE WS-PAGE-NO               TO P-RPT1-PAGE-NO           
              MOVE E-FBW71-WORK-SET-ID      TO WS-PREV-WORK-SET-ID      
              PERFORM 8100-PRINT-HEADER1    THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 8200-PRINT-DETAIL        THRU 8200-EXIT.             
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************                
      ** 8100-PRINT-HEADER1                                   **                
      **     PRINTS HEADER RECORDS OF REPORT                  **                
      **********************************************************                
       8100-PRINT-HEADER1.                                              
      *                                                                         
           MOVE '8100'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE WS-HDR-COMPANY-ONE          TO PRT33-RECORD.            
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
           IF GOOD-WRITE                                                
             CONTINUE                                                   
           ELSE                                                         
              DISPLAY '************ PCSRP117 ******************'        
              DISPLAY '** ERROR IN WRITING REPORT FILE **'              
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FCSPT33-STATUS            
              DISPLAY '** ACCOUNT NO     ' E-FBW71-ACCOUNT-NO           
              DISPLAY '** LOCAL OFFICE   ' E-FBW71-LOCAL-OFFICE         
              DISPLAY '** READ ROUTE     ' E-FBW71-READ-ROUTE           
              DISPLAY '** ABENDING PROGRAM             **'              
              DISPLAY '************ PCSRP117 ******************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE 1                           TO WS-LINE-NO.              
           MOVE WS-HDR-RPT-NAME-ONE         TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-PAGENO-ONE           TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-BLANK-LINE               TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-LOCOFF               TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-CYCLE                TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-ROUTE                TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-LINE1                TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-COLUMN               TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
           MOVE WS-HDR-LINE1                TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      ** 8200-PRINT-DETAIL                                     **               
      **     PRINTS DETAIL RECORD                              **               
      ***********************************************************               
       8200-PRINT-DETAIL.                                               
      *                                                                         
           MOVE '8200'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE WS-RPT-DETAIL-LINE          TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      ** 8300-WRITE-PRT33                                      **               
      **     WRITES RECORD IN REPORT                           **               
      ***********************************************************               
A05081 8300-WRITE-PRT33.                                                
      *                                                                         
           MOVE '8300'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           WRITE PRT33-RECORD.                                          
           IF GOOD-WRITE                                                
             ADD WS-ONE                     TO WS-LINE-NO               
           ELSE                                                         
              DISPLAY '************ PCSRP117 ****************'          
              DISPLAY '** ERROR IN WRITING REPORT FILE ******'          
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FCSPT33-STATUS            
              DISPLAY '** ACCOUNT NO     ' E-FBW71-ACCOUNT-NO           
              DISPLAY '** LOCAL OFFICE   ' E-FBW71-LOCAL-OFFICE         
              DISPLAY '** READ ROUTE     ' E-FBW71-READ-ROUTE           
              DISPLAY '** ABENDING PROGRAM             ******'          
              DISPLAY '************ PCSRP117 ****************'          
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
A05081 8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      ** 8400-PRINT-FOOTER                                     **               
      **     PRINTS REPORT FOOTER                              **               
      ***********************************************************               
       8400-PRINT-FOOTER.                                               
      *                                                                         
           MOVE '8400'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
           IF NOT-FIRST-TIME                                            
              MOVE    WS-FOOTER           TO PRT33-RECORD               
A05081                                       PRT33A-RECORD              
A05081        PERFORM 8300-WRITE-PRT33    THRU 8300-EXIT                
A05081        PERFORM 8500-WRITE-PRT33A   THRU 8500-EXIT                
           ELSE                                                         
              DISPLAY WS-NO-DATA                                        
           END-IF.                                                      
A05081*                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
A05081*- THIS ROUTINE PRINTS THE REPORT -----------------------------*          
A05081*--------------------------------------------------------------*          
A05081 8500-WRITE-PRT33A.                                               
A05081     WRITE PRT33A-RECORD.                                         
A05081     ADD 1 TO WS-LINE-COUNT.                                      
A05081 8500-EXIT.                                                       
A05081     EXIT.                                                        
      *                                                                         
      ***********************************************************               
      ** 8600-WRITE-NO-DATA                                    **               
      **     WRITES A NO DATA REPORT IF INPUT FILE IS EMPTY    **               
      ***********************************************************               
       8600-WRITE-NO-DATA.                                              
      *                                                                         
           MOVE '8600'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE WS-DEFAULT-COMPANY-NAME     TO P-RPT-COMP-NAME1.        
           MOVE WS-ONE                      TO P-RPT1-PAGE-NO.          
           PERFORM 8100-PRINT-HEADER1       THRU 8100-EXIT.             
           MOVE WS-NO-DATA                  TO PRT33-RECORD.            
A05081     PERFORM 8300-WRITE-PRT33         THRU 8300-EXIT.             
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
A05081*- THIS ROUTINE PRINTS THE ERROR REPORT WITH THE MESSAGE -      *         
A05081*- 'NO DATA FOR REPORT' IF THERE IS NO ACTUAL DATA, WHICH       *         
A05081*- SHOULD NEVER HAPPEN BECAUSE THE JOB DOES NOT RUN ON DAYS     *         
A05081*- THAT THERE ARE NO ROUTES TO SEND TO THE METER READING SYSTEM *         
A05081*---------------------------------------------------------------*         
A05081 8700-NO-REPORT.                                                  
A05081     MOVE SPACES  TO PRT33A-RECORD WS-DETAIL-LINE                 
A05081     MOVE 'NO DATA FOR REPORT' TO WS-DET-ITRON-ROUTE              
A05081     MOVE  WS-DETAIL-LINE      TO PRT33A-RECORD                   
A05081     PERFORM 8500-WRITE-PRT33A THRU 8500-EXIT.                    
A05081 8700-EXIT.                                                       
A05081     EXIT.                                                        
      ***********************************************************               
      ** 9000-TERMINATE                                        **               
      **     CLOSES REPORT AND INPUT FILE                      **               
      ***********************************************************               
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           CLOSE FCSBW71-FILE                                           
                 FCSPT33-FILE                                           
A05081           FCSPT33A-FILE.                                         
      *                                                                         
           DISPLAY '** PCSRP117 COMPLETED   **'.                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************** 9900-ABEND ************                                   
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
