       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP115.                                        
       DATE-WRITTEN.   12/13/96.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  12/13/96     MAD       NEW REPORT GENERATOR FOR PCSRP115   **         
      **                          CUSTOMER ACTION REPORTS.           **         
T13342**  10/20/97     BAB       THREE REPORTS WILL BE GENERATED,    **         
      **                          RATHER THAN ONE REPORT WITH THREE  **         
      **                          SECTIONS.                          **         
T20295**  07/06/99     SHF       REPORTS WILL USE COMPANY NUMBER 01  **         
      **                         WHEN SYSIN DOES NOT EXIST AND NO    **         
      **                         DATA IS FOUND.                      **         
P26289**  08/18/08    RB19957     MAKE CHANGES TO THE REPORT - ADDED **         
P26289**            RICK BLACK    CREDIT HISTORY, ISSUE/EXPIR DATES  **         
P26289**                          SECURED AMOUNT.                    **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP115 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                         ---- BASIC SEQUENCE STRUCTURE ----             
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSRP115.                                                           
       COPY CSSPT33.                                                            
T13342 COPY CSSPT33 REPLACING FCSPT33-FILE BY FCSPT33A-FILE,                    
                              UT-S-FCSPT33 BY UT-S-FCSPT33A.                    
T13342 COPY CSSPT33 REPLACING FCSPT33-FILE BY FCSPT33B-FILE,                    
                              UT-S-FCSPT33 BY UT-S-FCSPT33B.                    
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDRP115.                                                           
       COPY FIORP115.                                                           
       COPY CFDPT33.                                                            
T13342 COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33A-FILE,                    
                              PRT33-RECORD BY PRT33A-RECORD.                    
T13342 COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33B-FILE,                    
                              PRT33-RECORD BY PRT33B-RECORD.                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP115'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)     VALUE              
           'WORKING STORAGE FOR PCSRP115 STARTS HERE'.                  
      *                                                                         
      ****************************************************************          
      ************* PCSRP115 MISCELLANEOUS REPORT HEADERS ************          
      ****************************************************************          
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT-TITLE-115-1.                              
               10  FILLER              PIC X(50)     VALUE              
               '     CUSTOMER ACTION REPORT - ACTION REQUIRED     '.    
      *                                                                         
           05  WS-DEFAULT-RPT-TITLE-115-2.                              
               10  FILLER              PIC X(50)     VALUE              
               '   CUSTOMER ACTION REPORT - NO ACTION REQUIRED    '.    
      *                                                                         
           05  WS-DEFAULT-RPT-TITLE-115-3.                              
               10  FILLER              PIC X(50)     VALUE              
               '        CUSTOMER ACTION REPORT - BANKRUPT         '.    
      *                                                                         
           05  WS-DEFAULT-RPT-HEAD2.                                    
               10  FILLER              PIC X(09)     VALUE SPACES.      
               10  FILLER              PIC X(23)     VALUE              
                   'FOR ACCOUNTS BILLED ON '.                           
               10  WS-DEFAULT-RPT-DT   PIC X(08).                       
               10  FILLER              PIC X(10)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      ************************* PCSRP115 SWITCHES ********************          
      ****************************************************************          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-MORE-DATA-SW         PIC X(01)     VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
               88  MORE-DATA-FOUND                   VALUE 'Y'.         
           05  WS-CHANGE-COMP-NO       PIC X(01)     VALUE 'N'.         
               88  COMPANY-CHANGED                   VALUE 'Y'.         
           05  WS-CHANGE-REPORT        PIC X(01)     VALUE 'N'.         
               88  REPORT-CHANGED                    VALUE 'Y'.         
           05  WS-START-REPORT         PIC X(01)     VALUE 'N'.         
               88  REPORT-STARTED                    VALUE 'Y'.         
           05  WS-SYSIN-EXIST          PIC X(01)     VALUE 'Y'.         
               88  SYSIN-EXISTS                      VALUE 'Y'.         
               88  SYSIN-DOES-NOT-EXIST              VALUE 'N'.         
           05  WS-END-OF-SYSIN-REC     PIC X(01)     VALUE 'N'.         
               88  NOT-END-OF-SYSIN-REC              VALUE 'N'.         
           05  WS-END-REC-PROCESSED    PIC X(01)     VALUE 'N'.         
               88  END-REC-WAS-PROCESSED             VALUE 'Y'.         
           05  WS-REPORT-EXIST         PIC X(01)     VALUE 'N'.         
               88  REPORT-DOES-NOT-EXIST             VALUE 'N'.         
T13342     05  WS-ACTION-REQ-EXISTS    PIC X(01)     VALUE 'N'.         
               88  ACTION-REQUIRED                   VALUE 'Y'.         
T13342     05  WS-NO-ACTION-REQ-EXISTS PIC X(01)     VALUE 'N'.         
               88  NO-ACTION-REQ                     VALUE 'Y'.         
T13342     05  WS-BANKRUPT-EXISTS      PIC X(01)     VALUE 'N'.         
               88  BANKRUPT                          VALUE 'Y'.         
      *                                                                         
      ****************************************************************          
      *************** PCSRP115 WORKING STORAGE COPYBOOKS *************          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00150.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ************* PCSRP115 TIME AND DATE WORKING STORAGE ***********          
      ****************************************************************          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE ':'.         
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
      ****************************************************************          
      *************** PCSRP115 GENERAL WORKING STORAGE ***************          
      ****************************************************************          
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-REPORT-COUNTER       PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FRP115-REC-CNTR      PIC S9(07) COMP-3 VALUE ZERO.    
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FRP115-STATUS        PIC X(02).                       
               88  FRP115-SUCCESSFUL                 VALUE '00'.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSRP115'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSRP115'.  
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-1                    PIC 9(02)     VALUE 1.           
           05  WS-2                    PIC 9(02)     VALUE 2.           
           05  WS-3                    PIC 9(02)     VALUE 3.           
           05  WS-ALPHA-1              PIC X(01)     VALUE '1'.         
           05  WS-ALPHA-2              PIC X(01)     VALUE '2'.         
           05  WS-ALPHA-3              PIC X(01)     VALUE '3'.         
           05  WS-60                   PIC 9(02)     VALUE 60.          
           05  WS-62                   PIC 9(02)     VALUE 62.          
           05  WS-DEFAULT-COMP-NO      PIC X(02)     VALUE '01'.        
P26289     05  WS-ARREARS              PIC X(11)    VALUE 'ARREARS    '.
P26289     05  WS-BALANCE              PIC X(11)    VALUE 'BALANCE    '.
P26289     05  WS-NEW                  PIC X(11)    VALUE 'NEW        '.
P26289     05  WS-EXEMPT               PIC X(11)    VALUE 'EXEMPT     '.
P26289     05  WS-MASTER               PIC X(11)    VALUE 'MASTER     '.
P26289     05  WS-SUB-ACCT             PIC X(11)    VALUE 'SUB ACCT   '.
P26289     05  WS-NON-UTILITY          PIC X(11)    VALUE 'NON-UTILITY'.
      *                                                                         
       01  WS-GENERAL.                                                  
           05  WS-CURRENT-COMP-NO      PIC X(02).                       
           05  WS-SYSIN-COMP-NO        PIC X(02).                       
           05  WS-PREV-COMP-NO         PIC X(02).                       
           05  WS-PREV-REPORT          PIC X(01).                       
      *                                                                         
      ****************************************************************          
      ******************* PCSRP115 REPORT HEADERS ********************          
      ****************************************************************          
      *                                                                         
       01  WS-REPORT-HEADERS.                                           
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-REPORT-TITLE.                                         
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  P-RPT-TITLE-PGNM    PIC X(08).                       
P26289         10  P-RPT-NUMBER        PIC X(01).                       
P26289         10  FILLER              PIC X(44)     VALUE SPACES.      
               10  P-RPT-COMP-NAME     PIC X(26).                       
               10  FILLER              PIC X(35)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-DATE: '.
               10  P-RPT-RUN-DATE      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-REPORT-HEADER-1.                                      
               10  FILLER              PIC X         VALUE SPACE.       
               10  FILLER              PIC X(06)     VALUE 'DATE: '.    
               10  P-RPT-DATE          PIC X(08).                       
               10  FILLER              PIC X(27)     VALUE SPACES.      
               10  P-RPT-HEAD1         PIC X(50).                       
               10  FILLER              PIC X(23)     VALUE SPACES.      
               10  FILLER              PIC X(10)     VALUE 'RUN-TIME: '.
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-REPORT-HEADER-2.                                      
               10  FILLER              PIC X         VALUE SPACE.       
               10  FILLER              PIC X(41)     VALUE SPACES.      
               10  P-RPT-HEAD2         PIC X(50).                       
               10  FILLER              PIC X(27)     VALUE SPACES.      
               10  FILLER              PIC X(05)     VALUE 'PAGE:'.     
               10  FILLER              PIC X(03)     VALUE SPACES.      
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      *************** PCSRP115 REPORT COLUMN HEADERS *****************          
      ****************************************************************          
      *                                                                         
       01  WS-COLUMN-HEADERS.                                           
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR COLUMN HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-COLUMN-HEADER-1.                                      
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  FILLER              PIC X(14)     VALUE              
P26289                                           'ACCOUNT NUMBER'.      
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
               10  FILLER              PIC X(04)     VALUE 'NAME'.      
P26289         10  FILLER              PIC X(43)     VALUE SPACES.      
P26289         10  FILLER              PIC X(12)     VALUE              
P26289                                           'ARRS HISTORY'.        
P26289         10  FILLER              PIC X(07)     VALUE SPACES.      
P26289         10  FILLER              PIC X(13)     VALUE              
P26289                                              'DATE OF ISSUE'.    
P26289         10  FILLER              PIC X(37)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR COLUMN HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-COLUMN-HEADER-2.                                      
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  FILLER              PIC X(14)     VALUE              
P26289                                           'BOND/LETTER # '.      
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
               10  FILLER              PIC X(07)     VALUE 'ADDRESS'.   
P26289         10  FILLER              PIC X(39)     VALUE SPACES.      
P26289         10  FILLER              PIC X(14)     VALUE              
P26289                                              'CREDIT HISTORY'.   
P26289         10  FILLER              PIC X(07)     VALUE SPACES.      
P26289         10  FILLER              PIC X(12)     VALUE              
P26289                                           'DATE EXPIRES'.        
P26289         10  FILLER              PIC X(37)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR COLUMN HEADER3        **          
      ****************************************************************          
      *                                                                         
           05  WS-COLUMN-HEADER-3.                                      
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  FILLER              PIC X(16)     VALUE SPACES.      
               10  FILLER              PIC X(16)     VALUE              
                                                 'CITY, STATE, ZIP'.    
P26289         10  FILLER              PIC X(31)     VALUE SPACES.      
P26289         10  FILLER              PIC X(12)     VALUE              
P26289                                           'CREDIT GROUP'.        
P26289         10  FILLER              PIC X(09)     VALUE SPACES.      
P26289         10  FILLER              PIC X(11)     VALUE              
P26289                                           'SECURED AMT'.         
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
P26289         10  FILLER              PIC X(06)     VALUE 'ACTION'.    
P26289         10  FILLER              PIC X(29)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      ***************** PCSRP115 REPORT DETAIL LINES *****************          
      ****************************************************************          
      *                                                                         
       01  WS-REPORT-DETAILS.                                           
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT DETAIL1        **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X         VALUE SPACE.       
               10  P-RPT-ACCOUNT-NO    PIC 9(13).                       
P26289         10  FILLER              PIC X(03)     VALUE SPACES.      
P26289         10  P-RPT-CUST-NAME     PIC X(40).                       
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
P26289         10  P-RPT-ARRS-HISTORY  PIC X(24).                       
P26289         10  FILLER              PIC X(03)     VALUE SPACES.      
P26289         10  P-RPT-ISSUE-DATE    PIC X(10).                       
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
P26289         10  P-RPT-ACTION        PIC X(35).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT DETAIL2        **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-2.                                        
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  P-RPT-BOND-LTR-NBR  PIC X(13)     VALUE SPACES.      
P26289         10  FILLER              PIC X(03)     VALUE SPACES.      
P26289         10  P-RPT-CUST-ADDRESS  PIC X(40).                       
P26289         10  FILLER              PIC X(02)     VALUE SPACES.      
P26289         10  P-RPT-CRED-HISTORY  PIC X(24).                       
P26289         10  FILLER              PIC X(03)     VALUE SPACES.      
P26289         10  P-RPT-EXPIR-DATE    PIC X(10).                       
P26289         10  FILLER              PIC X(37)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT DETAIL3        **          
      ****************************************************************          
      *                                                                         
           05  WS-DETAIL-LINE-3.                                        
               10  FILLER              PIC X         VALUE SPACE.       
P26289         10  FILLER              PIC X(16)     VALUE SPACES.      
P26289         10  P-RPT-CITY-ST-ZIP   PIC X(40).                       
P26289         10  FILLER              PIC X(09)     VALUE SPACES.      
P26289         10  P-RPT-CRED-GROUP    PIC X(11).                       
P26289         10  FILLER              PIC X(07)     VALUE SPACES.      
P26289         10  P-RPT-SECURED-AMT   PIC $$$$,$$$,$$9.                
P26289         10  FILLER              PIC X(37)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **************** PCSRP115 REPORT END MESSAGES ******************          
      ****************************************************************          
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                              '** NO DATA THIS RUN **'. 
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  FILLER                  PIC X(22)     VALUE              
                                               '*** END OF REPORT ***'. 
           05  FILLER                  PIC X(55)     VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      ******************** PCSRP115 PRINT CONTROLS *******************          
      ****************************************************************          
      *                                                                         
       01  WS-PRINT-CONTROL.                                            
           05  WS-REPORT-LINE-NO       PIC 9(02) COMP-3  VALUE 62.      
           05  WS-REPORT-PAGE-NO       PIC 9(02) COMP-3  VALUE ZERO.    
           05  WS-SKIP-LINES-NUM       PIC 9(02)         VALUE ZERO.    
           05  P-OUTPUT-LINE           PIC X(132)        VALUE SPACES.  
           05  WS-LINE                 PIC X(132)        VALUE ALL '-'. 
      *                                                                         
      ****************************************************************          
      ********************** PCSRP115 ERROR CONTROL ******************          
      ****************************************************************          
      *                                                                         
       01  WS-ERROR-VARIABLES.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP.                 
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-DISP-RETURN-CODE     PIC +Z(04).                      
      *                                                                         
      ****************************************************************          
      ******************** PCSRP115 DB2 DECLARATIONS *****************          
      ****************************************************************          
      *                                                                         
      **********************                                                    
      **    S Q L C A     **                                                    
      **********************                                                    
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *******************                                                       
      **  CSS_COMPANY  **                                                       
      *******************                                                       
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSRP115 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0000-MAINLINE                                            **         
      **      MAIN PROCESSING MODULE - CONTROLS PROGRAM FLOW         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 3000-PROCESS-RP115-FILE           THRU 3000-EXIT     
            UNTIL NO-MORE-DATA.                                         
      *                                                                         
           PERFORM 9500-CLEANUP                      THRU 9500-EXIT.    
      *                                                                         
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0100-INITIALIZATION                                      **         
      **      MODULE ACCEPTS DATE AND TIME PARAMETERS, RETRIEVES THE **         
      **      CSS_JOB_PARM DATE, ACCEPTS THE SYSIN COMPANY NUMBER,   **         
      **      PROCESSES THE INPUT FILE BEGIN RECORD AND PERFORMS A   **         
      **      PRIMING READ.                                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT-RUN-TIME.               
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT-RUN-DATE.               
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN OUTPUT FCSPT33A-FILE.                                   
           OPEN OUTPUT FCSPT33B-FILE.                                   
      *                                                                         
           OPEN INPUT FCSRP115-FILE.                                    
           IF FRP115-SUCCESSFUL                                         
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSRP115 PROCESSING ERROR      **'        
             DISPLAY '** OPEN ERROR OF FCSRP115 - INPUT FILE'           
             DISPLAY '**    FILE STATUS = ' WS-FRP115-STATUS            
             DISPLAY '**       PROCESSING TERMINATED         **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE               THRU 6251-EXIT.    
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
             PERFORM 6240-GET-FCA00-COMMON-DATE      THRU 6240-EXIT     
             MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                 
           END-IF.                                                      
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
      *                                                                         
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
             MOVE WS-N                 TO WS-SYSIN-EXIST                
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC            THRU 1000-EXIT.    
      *                                                                         
           PERFORM 7000-READ-FCSRP115                THRU 7000-EXIT.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    1000-PROCESS-BEGIN-REC                                   **         
      **      MODULE PROCESSES THE INPUT FILE BEGIN RECORD - PROGRAM **         
      **      WILL ABEND IF THE COMMON DATE (CSS_JOB_PARM) IS NOT    **         
      **      EQUAL TO THE FILE CREATE DATE.                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSRP115                THRU 7000-EXIT.    
      *                                                                         
           IF E-FRP115-KEY-BREC EQUAL LOW-VALUES                        
             IF WS-INPUT-DATE EQUAL E-FRP115-CREATE-DATE-BREC           
               SUBTRACT 1 FROM WS-FRP115-REC-CNTR                       
               MOVE E-FRP115-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-D8-MM                      
               MOVE WS-D10-DD          TO WS-D8-DD                      
               MOVE WS-D10-YY          TO WS-D8-YY                      
               MOVE WS-DATE-8          TO P-RPT-DATE,                   
                                          WS-DEFAULT-RPT-DT             
             ELSE                                                       
               DISPLAY '****************************************'       
               DISPLAY '**      FCSRP115 PROCESSING ERROR     **'       
               DISPLAY '**  FILE CREATE DATE IS NOT EQUAL TO  **'       
               DISPLAY '**       THE PROGRAM COMMON DATE      **'       
               DISPLAY '**  ********************************  **'       
               DISPLAY '**  FILE CREATE DATE IS: '                      
                                               E-FRP115-CREATE-DATE-BREC
               DISPLAY '**  PROGRAM COMMON DATE IS: ' WS-INPUT-DATE     
               DISPLAY '**        PROCESSING TERMINATED       **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
             END-IF                                                     
           ELSE                                                         
             DISPLAY '********************************************'     
             DISPLAY '**       FCSRP115 PROCESSING ERROR        **'     
             DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'     
             DISPLAY '**         PROCESSING TERMINATED          **'     
             DISPLAY '********************************************'     
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    1900-PROCESS-END-REC                                     **         
      **      MODULE PROCESSES THE ENDING RECORD FOR INPUT FILE      **         
      **      FCSRP115.                                              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FRP115-REC-CNTR.                          
      *                                                                         
           IF WS-FRP115-REC-CNTR EQUAL E-FRP115-RECORD-COUNT-EREC       
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '**********************************************'   
             DISPLAY '**         FCSRP115 PROCESSING ERROR        **'   
             DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **'   
             DISPLAY '**     CONTROL REC COUNT = '                      
                                      E-FRP115-RECORD-COUNT-EREC        
             DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP115-REC-CNTR   
             DISPLAY '**           PROCESSING TERMINATED          **'   
             DISPLAY '**********************************************'   
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3000-PROCESS-RP115-FILE                                  **         
      **      MAIN LOOPING MODULE WHICH PROCESSES THE INPUT FILE     **         
      **      AN END-OF-FILE CONDITION IS RETURNED FROM THE READ     **         
      **      STATEMENT.                                             **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3000-PROCESS-RP115-FILE.                                         
      *                                                                         
           IF E-FRP115-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO             
             MOVE WS-Y                 TO WS-CHANGE-COMP-NO             
             MOVE E-FRP115-COMPANY-NO  TO WS-PREV-COMP-NO               
           END-IF.                                                      
      *                                                                         
           IF E-FRP115-REPORT-SECTION NOT EQUAL WS-PREV-REPORT          
             MOVE WS-Y                 TO WS-CHANGE-REPORT              
             MOVE E-FRP115-REPORT-SECTION                               
                                       TO WS-PREV-REPORT                
      ** INITIALIZE THE ACCUMULATION VARIABLES WHEN SECTION CHANGES.            
T13342       INITIALIZE WS-REPORT-LINE-NO                               
                        WS-REPORT-PAGE-NO                               
           END-IF.                                                      
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSRP115 PROCESSING ERROR      **'        
             DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'        
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           ELSE                                                         
      *                                                                         
             IF E-FRP115-KEY-EREC EQUAL HIGH-VALUES                     
               PERFORM 1900-PROCESS-END-REC          THRU 1900-EXIT     
             ELSE                                                       
               IF REPORT-STARTED                                        
                 PERFORM 3500-CHECK-COMP-NO          THRU 3500-EXIT     
               ELSE                                                     
                 MOVE WS-Y             TO WS-START-REPORT               
                 PERFORM 3500-CHECK-COMP-NO          THRU 3500-EXIT     
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSRP115                THRU 7000-EXIT.    
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3500-CHECK-COMP-NO                                       **         
      **      MODULE WHICH CORRECTLY PRODUCES PAGES BREAKS ON        **         
      **      COMPANY AND REPORT CHANGES, RETRIEVES COMPANY NAME     **         
      **      FROM CSS_COMPANY AND PRODUCES THE DETAILED REPORT.     **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3500-CHECK-COMP-NO.                                              
      *                                                                         
           IF COMPANY-CHANGED                                           
             IF SYSIN-DOES-NOT-EXIST                                    
               MOVE WS-62              TO WS-REPORT-LINE-NO             
             END-IF                                                     
      *                                                                         
             MOVE E-FRP115-COMPANY-NO  TO C7-COMPANY-NO,                
                                          WS-CURRENT-COMP-NO            
             MOVE WS-N                 TO WS-CHANGE-COMP-NO             
      *                                                                         
             PERFORM 7800-GET-COMPANY-DESC           THRU 7800-EXIT     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               MOVE +26                TO WS-MAX-FIELD-LEN-3900         
               PERFORM 3900-CENTERING-ROUTINE          THRU 3900-EXIT   
               MOVE WS-OUTPUT-CTR-FIELD                                 
                                       TO P-RPT-COMP-NAME               
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           IF REPORT-CHANGED                                            
             MOVE WS-62                TO WS-REPORT-LINE-NO             
             MOVE WS-N                 TO WS-CHANGE-REPORT              
           END-IF.                                                      
      *                                                                         
           IF E-FRP115-COMPANY-NO NOT EQUAL WS-CURRENT-COMP-NO          
             DISPLAY '*******************************************'      
             DISPLAY '**       PCSRP115 PROCESSING ERROR       **'      
             DISPLAY '**   COMPANY DATA RECORDS NOT SEPARATED  **'      
             DISPLAY '**     WITH PROPER COMPANY END-RECORD    **'      
             DISPLAY '**   CURRENT COMPANY NO IS: ' WS-CURRENT-COMP-NO  
             DISPLAY '**   INPUT FILE COMP NO IS: ' E-FRP115-COMPANY-NO 
             DISPLAY '**          PROCESSING TERMINATED        **'      
             DISPLAY '*******************************************'      
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           ELSE                                                         
             IF SYSIN-EXISTS                                            
               IF E-FRP115-COMPANY-NO EQUAL WS-SYSIN-COMP-NO            
                 IF NOT-END-OF-SYSIN-REC                                
                   PERFORM 3600-PRODUCE-REPORT       THRU 3600-EXIT     
                 ELSE                                                   
                   DISPLAY '*********************************'          
                   DISPLAY '**  PCSRP115 PROCESSING ERROR  **'          
                   DISPLAY '**  FILE NOT SORTED PROPERLY   **'          
                   DISPLAY '** IN ORDER OF COMPANY NUMBERS **'          
                   DISPLAY '**    PROCESSING TERMINATED    **'          
                   DISPLAY '*********************************'          
                   PERFORM 9900-ABEND                THRU 9900-EXIT     
                 END-IF                                                 
               END-IF                                                   
             ELSE                                                       
               PERFORM 3600-PRODUCE-REPORT           THRU 3600-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3600-PRODUCE-REPORT                                      **         
      **      MODULE PROCESSES PAGE BREAKS, IF NECESSARY, THEN       **         
      **      PRODUCES REPORT DETAIL LINES.                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3600-PRODUCE-REPORT.                                             
      *                                                                         
           IF WS-REPORT-LINE-NO GREATER THAN WS-60                      
             PERFORM 8000-PRINT-RPT-HEADERS          THRU 8000-EXIT     
             PERFORM 8100-PRINT-RPT-COLUMN-HEADERS   THRU 8100-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 3800-FORMAT-DETAIL-LINE           THRU 3800-EXIT.    
           PERFORM 8200-PRINT-REPORT-DETAILS         THRU 8200-EXIT.    
      *                                                                         
           MOVE WS-Y                   TO WS-REPORT-EXIST.              
           ADD 1                       TO WS-REPORT-COUNTER.            
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3800-FORMAT-DETAIL-LINE                                  **         
      **      MODULE LOADS INPUT FILE VALUES INTO REPORT WORKING-    **         
      **      STORAGE AREAS FOR PRINTING.                            **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3800-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FRP115-ACCOUNT-NUMBER                                 
                                       TO P-RPT-ACCOUNT-NO.             
           MOVE E-FRP115-CUSTOMER-NAME TO P-RPT-CUST-NAME.              
           MOVE E-FRP115-CUSTOMER-ADDRESS                               
                                       TO P-RPT-CUST-ADDRESS.           
           MOVE E-FRP115-CUSTOMER-CITY-ST-ZIP                           
                                       TO P-RPT-CITY-ST-ZIP.            
           MOVE E-FRP115-REPORT-ACTION TO P-RPT-ACTION.                 
P26289     MOVE E-FRP115-BOND-LTR-NUMBER    TO P-RPT-BOND-LTR-NBR.      
P26289     MOVE E-FRP115-CREDIT-HIST        TO P-RPT-CRED-HISTORY.      
P26289     MOVE E-FRP115-UTIL-ARREARS-HIST  TO P-RPT-ARRS-HISTORY.      
P26289     MOVE E-FRP115-DATE-BOND-ISSUED   TO P-RPT-ISSUE-DATE.        
P26289     MOVE E-FRP115-BOND-EXPIRATION-DT TO P-RPT-EXPIR-DATE.        
P26289     MOVE E-FRP115-AMT-BOND           TO P-RPT-SECURED-AMT.       
P26289     EVALUATE TRUE                                                
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'A'                     
P26289             MOVE WS-ARREARS      TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'B'                     
P26289             MOVE WS-BALANCE      TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'C'                     
P26289             MOVE WS-EXEMPT       TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'N'                     
P26289             MOVE WS-NEW          TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'D'                     
P26289             MOVE WS-NON-UTILITY  TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'M'                     
P26289             MOVE WS-MASTER       TO P-RPT-CRED-GROUP             
P26289         WHEN E-FRP115-CREDIT-GROUP EQUAL 'S'                     
P26289             MOVE WS-SUB-ACCT     TO P-RPT-CRED-GROUP             
P26289     END-EVALUATE.                                                
      *                                                                         
       3800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3900-CENTERING-ROUTINE                                   **         
      **      COPYBOOK CPD00150 IS A FIELD CENTERING ROUTINE WHICH   **         
      **      IS USED IN THIS INSTANCE TO CENTER THE RETRIEVED COMP. **         
      **      NAME ON THE REPORT HEADER.                             **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       COPY CPD00150.                                                           
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6240-GET-FCA00-COMMON-DATE                               **         
      **      IF NECESSARY, COPYBOOK CPD00040 RETRIEVES THE COMMON   **         
      **      DATE FROM TABLE CSS_JOB_PARM.                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00040                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6251-GET-FJC01-DATE                                      **         
      **      THIS COPYBOOK, CPD00037, CONTAINS THE DB2 STATEMENTS   **         
      **      NECESSARY TO RETRIEVE PARAMETERS FROM TABLE CSS_JOB_   **         
      **      PARM.                                                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7000-READ-FCSRP115                                       **         
      **      MODULE READS THE INPUT FILE, SETS A FLAG AT END-OF-    **         
      **      FILE AND CHECKS THE READ STATUS FOR POSSIBLE ERRORS.   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7000-READ-FCSRP115.                                              
      *                                                                         
           READ FCSRP115-FILE                                           
            AT END                                                      
            MOVE WS-N                  TO WS-MORE-DATA-SW               
            GO                         TO 7000-EXIT.                    
      *                                                                         
           IF FRP115-SUCCESSFUL                                         
             ADD 1                     TO WS-FRP115-REC-CNTR            
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSRP115 PROCESSING ERROR      **'        
             DISPLAY '** READ ERROR OF FCSRP115 - INPUT FILE **'        
             DISPLAY '**    FILE STATUS = ' WS-FRP115-STATUS            
             DISPLAY '**       PROCESSING TERMINATED         **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7600-START-FCSJC01                                       **         
      **      COPYBOOK CPD00038 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7620-START-FCSCA00                                       **         
      **      COPYBOOK CPD00039 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7800-GET-COMPANY-DESC                                    **         
      **      MODULE RETRIEVES THE COMPANY NAME FROM CSS_COMPANY.    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             SELECT    COMPANY_NAME                                     
               INTO    :C7-COMPANY-NAME                                 
               FROM    CSS_COMPANY                                      
              WHERE    COMPANY_NO = :C7-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE C7-COMPANY-NAME      TO WS-INPT-CTR-FIELD             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE SPACES             TO P-RPT-COMP-NAME               
             ELSE                                                       
               DISPLAY '*****************************************'      
               DISPLAY '**      PCSRP115 PROCESSING ERROR      **'      
               DISPLAY '* SELECT ERROR IN 7800-GET-COMPANY-DESC *'      
               DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE           
               DISPLAY '*         PROCESSING TERMINATED         *'      
               DISPLAY '*****************************************'      
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_COMPANY'      TO TABLE-1                       
               PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8000-PRINT-RPT-HEADERS                                   **         
      **      MODULE PRINTS PCSRP115 REPORT HEADERS.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8000-PRINT-RPT-HEADERS.                                          
      *                                                                         
      ** EACH REPORT HAS ITS OWN HEADER.                                        
           EVALUATE E-FRP115-REPORT-SECTION                             
               WHEN WS-ALPHA-1                                          
P26289             MOVE '1' TO P-RPT-NUMBER                             
                   MOVE WS-DEFAULT-RPT-TITLE-115-1                      
                                       TO P-RPT-HEAD1                   
               WHEN WS-ALPHA-2                                          
P26289             MOVE '2' TO P-RPT-NUMBER                             
                   MOVE WS-DEFAULT-RPT-TITLE-115-2                      
                                       TO P-RPT-HEAD1                   
               WHEN WS-ALPHA-3                                          
P26289             MOVE '3' TO P-RPT-NUMBER                             
                   MOVE WS-DEFAULT-RPT-TITLE-115-3                      
                                       TO P-RPT-HEAD1                   
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-PGRMNAME            TO P-RPT-TITLE-PGNM.             
           MOVE WS-REPORT-TITLE        TO P-OUTPUT-LINE.                
           PERFORM 8900-PRINT-RPT-TOP-OF-PAGE        THRU 8900-EXIT.    
      *                                                                         
           MOVE WS-REPORT-HEADER-1     TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-DEFAULT-RPT-HEAD2   TO P-RPT-HEAD2.                  
           MOVE WS-REPORT-PAGE-NO      TO P-RPT-PAGE-NO.                
           MOVE WS-REPORT-HEADER-2     TO P-OUTPUT-LINE.                
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8100-PRINT-RPT-COLUMN-HEADERS                            **         
      **      MODULE PRINTS PCSRP115 COLUMN HEADERS.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8100-PRINT-RPT-COLUMN-HEADERS.                                   
      *                                                                         
           MOVE WS-2                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-COLUMN-HEADER-1     TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-COLUMN-HEADER-2     TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-COLUMN-HEADER-3     TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-LINE                TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8200-PRINT-REPORT-DETAILS                                **         
      **      MODULE PRINTS PCSRP115 DETAIL LINES.                   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8200-PRINT-REPORT-DETAILS.                                       
      *                                                                         
           MOVE WS-2                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-1       TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-2       TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
           MOVE WS-1                   TO WS-SKIP-LINES-NUM.            
           MOVE WS-DETAIL-LINE-3       TO P-OUTPUT-LINE.                
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8900-PRINT-RPT-TOP-OF-PAGE                               **         
      **      COMMON PRINTING MODULE FOR PCSRP115 TOP-OF-PAGE.       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8900-PRINT-RPT-TOP-OF-PAGE.                                      
      *                                                                         
           EVALUATE E-FRP115-REPORT-SECTION                             
               WHEN WS-ALPHA-1                                          
                   WRITE PRT33-RECORD FROM P-OUTPUT-LINE                
                    AFTER ADVANCING TOP-OF-PAGE                         
               WHEN WS-ALPHA-2                                          
                   WRITE PRT33A-RECORD FROM P-OUTPUT-LINE               
                    AFTER ADVANCING TOP-OF-PAGE                         
               WHEN WS-ALPHA-3                                          
                   WRITE PRT33B-RECORD FROM P-OUTPUT-LINE               
                    AFTER ADVANCING TOP-OF-PAGE                         
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-1                   TO WS-REPORT-LINE-NO.            
           ADD 1                       TO WS-REPORT-PAGE-NO.            
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8950-PRINT-RPT-LINE                                      **         
      **      COMMON PRINTING MODULE FOR PCSRP115 DETAIL LINES.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8950-PRINT-RPT-LINE.                                             
      *                                                                         
      ** THE PROGRAM NEEDS TO WRITE THE DIFFERENT SECTIONS TO DIFFERENT         
      ** REPORTS.                                                               
T13342     EVALUATE E-FRP115-REPORT-SECTION                             
               WHEN WS-ALPHA-1                                          
                   WRITE PRT33-RECORD FROM P-OUTPUT-LINE                
                    AFTER ADVANCING WS-SKIP-LINES-NUM                   
      *                                                                         
T13342             MOVE WS-Y               TO WS-ACTION-REQ-EXISTS      
      *                                                                         
               WHEN WS-ALPHA-2                                          
T13342             WRITE PRT33A-RECORD FROM P-OUTPUT-LINE               
T13342              AFTER ADVANCING WS-SKIP-LINES-NUM                   
      *                                                                         
T13342             MOVE WS-Y               TO WS-NO-ACTION-REQ-EXISTS   
      *                                                                         
               WHEN WS-ALPHA-3                                          
                   WRITE PRT33B-RECORD FROM P-OUTPUT-LINE               
                    AFTER ADVANCING WS-SKIP-LINES-NUM                   
      *                                                                         
T13342             MOVE WS-Y               TO WS-BANKRUPT-EXISTS        
      *                                                                         
           END-EVALUATE.                                                
      *                                                                         
           ADD WS-SKIP-LINES-NUM       TO WS-REPORT-LINE-NO.            
      *                                                                         
           INITIALIZE P-OUTPUT-LINE.                                    
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8990-WRITE-END-OF-DATA                                   **         
      **      MODULE WRITES PCSRP115 END-OF-DATA LINE.               **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8990-WRITE-END-OF-DATA.                                          
      ** DISPLAY NOT DATA FOUND ONLY WHEN DETAILS HAVE NOT BEEN WRITTEN         
      ** FOR THE INDIVIDUAL REPORT.                                             
T13342     IF ACTION-REQUIRED                                           
               MOVE WS-ALPHA-1         TO E-FRP115-REPORT-SECTION       
               MOVE WS-END-DATA-LINE   TO P-OUTPUT-LINE                 
               MOVE WS-3               TO WS-SKIP-LINES-NUM             
      *                                                                         
               PERFORM 8950-PRINT-RPT-LINE           THRU 8950-EXIT     
           END-IF.                                                      
                                                                        
T13342     IF NO-ACTION-REQ                                             
               MOVE WS-ALPHA-2         TO E-FRP115-REPORT-SECTION       
               MOVE WS-END-DATA-LINE   TO P-OUTPUT-LINE                 
               MOVE WS-3               TO WS-SKIP-LINES-NUM             
      *                                                                         
               PERFORM 8950-PRINT-RPT-LINE           THRU 8950-EXIT     
           END-IF.                                                      
                                                                        
T13342     IF BANKRUPT                                                  
               MOVE WS-ALPHA-3         TO E-FRP115-REPORT-SECTION       
               MOVE WS-END-DATA-LINE   TO P-OUTPUT-LINE                 
               MOVE WS-3               TO WS-SKIP-LINES-NUM             
      *                                                                         
               PERFORM 8950-PRINT-RPT-LINE           THRU 8950-EXIT     
           END-IF.                                                      
      *                                                                         
       8990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8995-WRITE-NO-DATA                                       **         
      **      MODULE WRITES PCSRP115 NO-DATA LINE.                   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8995-WRITE-NO-DATA.                                              
      *                                                                         
           MOVE WS-NO-DATA-LINE        TO P-OUTPUT-LINE.                
           MOVE WS-3                   TO WS-SKIP-LINES-NUM.            
      *                                                                         
           PERFORM 8950-PRINT-RPT-LINE               THRU 8950-EXIT.    
      *                                                                         
       8995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9000-TERMINATE                                           **         
      **      MODULE CLOSES ALL OPEN FILES UTILIZED BY THE PROGRAM.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP115-FILE.                                         
           IF FRP115-SUCCESSFUL                                         
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSRP115 PROCESSING ERROR      **'        
             DISPLAY '** CLOSE ERROR OF FCSRP115 - INPUT FILE**'        
             DISPLAY '**    FILE STATUS = ' WS-FRP115-STATUS            
             DISPLAY '*****************************************'        
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT33A-FILE.                                         
           CLOSE FCSPT33B-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9500-CLEANUP                                             **         
      **      MODULE PRODUCES REPORT HEADERS AND COLUMN HEADERS WITH **         
      **      'NO DATA THIS RUN' MESSAGE WHEN NO DATA IS PRINTED FOR **         
      **      THIS RUN; OTHERWISE, THE 'END OF REPORT' MESSAGE IS    **         
      **      PRINTED ON THE BOTTOM OF THE CURRENT PAGE.             **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9500-CLEANUP.                                                    
      ** DISPLAY END OF REPORT ONLY WHEN LINES HAVE NOT BEEN WRITTEN            
      ** FOR THE INDIVIDUAL REPORT.                                             
                                                                        
           PERFORM 8990-WRITE-END-OF-DATA            THRU 8990-EXIT.    
                                                                        
T13342     IF NOT ACTION-REQUIRED                                       
               MOVE WS-ALPHA-1         TO E-FRP115-REPORT-SECTION       
T13342         INITIALIZE WS-REPORT-PAGE-NO                             
T20295         MOVE WS-DEFAULT-COMP-NO   TO C7-COMPANY-NO               
T20295         PERFORM 7800-GET-COMPANY-DESC           THRU 7800-EXIT   
T20295         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T20295            MOVE +26                TO WS-MAX-FIELD-LEN-3900      
T20295            PERFORM 3900-CENTERING-ROUTINE          THRU 3900-EXIT
T20295            MOVE WS-OUTPUT-CTR-FIELD                              
T20295                                 TO P-RPT-COMP-NAME               
T20295         END-IF                                                   
               PERFORM 8000-PRINT-RPT-HEADERS        THRU 8000-EXIT     
               PERFORM 8100-PRINT-RPT-COLUMN-HEADERS THRU 8100-EXIT     
               PERFORM 8995-WRITE-NO-DATA            THRU 8995-EXIT     
           END-IF.                                                      
                                                                        
T13342     IF NOT NO-ACTION-REQ                                         
               MOVE WS-ALPHA-2         TO E-FRP115-REPORT-SECTION       
T13342         INITIALIZE WS-REPORT-PAGE-NO                             
T20295         MOVE WS-DEFAULT-COMP-NO   TO C7-COMPANY-NO               
T20295         PERFORM 7800-GET-COMPANY-DESC           THRU 7800-EXIT   
T20295         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T20295            MOVE +26                TO WS-MAX-FIELD-LEN-3900      
T20295            PERFORM 3900-CENTERING-ROUTINE          THRU 3900-EXIT
T20295            MOVE WS-OUTPUT-CTR-FIELD                              
T20295                                 TO P-RPT-COMP-NAME               
T20295         END-IF                                                   
               PERFORM 8000-PRINT-RPT-HEADERS        THRU 8000-EXIT     
               PERFORM 8100-PRINT-RPT-COLUMN-HEADERS THRU 8100-EXIT     
               PERFORM 8995-WRITE-NO-DATA            THRU 8995-EXIT     
           END-IF.                                                      
                                                                        
T13342     IF NOT BANKRUPT                                              
               MOVE WS-ALPHA-3         TO E-FRP115-REPORT-SECTION       
T13342         INITIALIZE WS-REPORT-PAGE-NO                             
T20295         MOVE WS-DEFAULT-COMP-NO   TO C7-COMPANY-NO               
T20295         PERFORM 7800-GET-COMPANY-DESC           THRU 7800-EXIT   
T20295         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T20295            MOVE +26                TO WS-MAX-FIELD-LEN-3900      
T20295            PERFORM 3900-CENTERING-ROUTINE          THRU 3900-EXIT
T20295            MOVE WS-OUTPUT-CTR-FIELD                              
T20295                                 TO P-RPT-COMP-NAME               
T20295         END-IF                                                   
               PERFORM 8000-PRINT-RPT-HEADERS        THRU 8000-EXIT     
               PERFORM 8100-PRINT-RPT-COLUMN-HEADERS THRU 8100-EXIT     
               PERFORM 8995-WRITE-NO-DATA            THRU 8995-EXIT     
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9700-PROCESS-ABEND                                       **         
      **      COPYBOOK CPD0023B PERFORM BATCH ABEND PROCESSING.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9900-ABEND                                               **         
      **      COPYBOOK CPD09900 PERFORMS THE ABEND PROCESSING        **         
      **      UTILIZED BY ALL MAINFRAME COMPONENTS.                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
