       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP106.                                            
       AUTHOR. SATISH SIVASUBRAMANIAN.                                  
       INSTALLATION. SCE&G.                                             
       DATE-WRITTEN. 06/25/2016.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                 COBOL/DB2                      *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 10/15/15   SS95855       APPL#5347 AUDIT REPORT GENERATED BY**         
      **                          COMPARING ITRON FILE AGAINST CIS.  **         
      ** 10/25/15   SS95855       A#5347 COMPARE READ SOURCE(ACT010) **         
A#5745** 02/02/17   SS95855       ACT018 CHANGE REPORT SORT ORDER    **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSRP106 NARRATIVE                        
      *                                                                         
           THIS PROGRAM COMPARES THE IEE AUDIT REPORT AGAINST CIS-MDM   
           TO GENERATES A EXCEPTION REPORT FOR OPERATIONAL GROUP.       
           IT LISTS OUT THE EXCEPTION FIELD, CURRENT VALUE IN CIS,      
           VALUE RECEIVED FROM ITRON FOR EACH METER-ID.                 
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSRP106.                                                           
       COPY CSSPT106.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP106.                                                           
       01  FIORP106-REC                       PIC X(600).               
      *                                                                         
       COPY CFDPT106.                                                           
       01  FIOPT106-REC.                                                
ACT018     05 WS-RPT-METER-ID                 PIC X(12).                
ACT018     05 WS-RPT-DLM-1                    PIC X(01).                
ACT018     05 WS-RPT-SPOINT-ID                PIC X(21).                
ACT018     05 WS-RPT-DLM-2                    PIC X(01).                
ACT018     05 WS-RPT-DISCREPANCY              PIC X(30).                
ACT018     05 WS-RPT-DLM-3                    PIC X(01).                
ACT018     05 WS-RPT-CIS-VALUE                PIC X(40).                
ACT018     05 WS-RPT-DLM-4                    PIC X(01).                
ACT018     05 WS-RPT-IEE-VALUE                PIC X(40).                
ACT018     05 FILLER                          PIC X(03).                
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP106'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR PCSRP106 STARTS HERE'.                  
      *                                                                         
      * ABEND SWITCH          *                                                 
       COPY CWS09900.                                                           
                                                                        
      * WARNING DATA          *                                                 
       COPY CWS00303.                                                           
                                                                        
      * WS ABEND WORK AREA    *                                                 
       COPY CWS00010.                                                           
                                                                        
       COPY CWS00011.                                                           
      *                                                                         
                                                                        
      ******************************************************************        
      *                           DCLGEN'S                             *        
      ******************************************************************        
                                                                        
      * COMMUNICATION AREA                                                      
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *CSS_MDM_SS_INTF     (1D)                                                 
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_CODE_VALUE      (UV)                                                 
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_CUST_PREM_HIST (CH)                                                 
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTRD_ENVRNMT   (MN)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-YES                          PIC X(01) VALUE 'Y'.       
          05 WS-Y                            PIC X(01) VALUE 'Y'.       
          05 WS-N                            PIC X(01) VALUE 'N'.       
          05 WS-NO                           PIC X(01) VALUE 'N'.       
          05 WS-PGRMNAME                     PIC X(08) VALUE            
                                                      'PCSRP106'.       
          05 PROGRAM-NAME                    PIC X(08) VALUE            
                                                      'PCSRP106'.       
          05 WS-NO-METER-MSG                 PIC X(24) VALUE            
                                             'Meter/Account not in CIS'.
          05 WS-H-METER-ID                   PIC X(08) VALUE            
                                                             'Meter ID'.
          05 WS-H-SERVICE-POINT-ID           PIC X(16) VALUE            
                                                     'Service Point ID'.
          05 WS-H-DISCREPANCY                PIC X(11) VALUE            
                                                          'Discrepancy'.
          05 WS-H-CIS-VALUE                  PIC X(12) VALUE            
                                                         'Value in CIS'.
          05 WS-H-IEE-VALUE                  PIC X(17) VALUE            
                                                    'Value in IEE/OWCE'.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FRP106-STATUS               PIC XX    VALUE '00'.      
              88 FRP106-SUCCESSFUL                     VALUE '00'.      
              88 FRP106-READ-EOF                       VALUE '10'.      
           05 WS-FPT106-STATUS               PIC XX    VALUE '00'.      
              88 FPT106-SUCCESSFUL                     VALUE '00'.      
           05 WS-END-OF-FILE                 PIC X(01) VALUE 'N'.       
              88 END-OF-FILE                           VALUE 'Y'.       
      *                                                                         
       01 WS-RECORD-STRING.                                             
          05 WS-I-ACCOUNT-NO                 PIC X(015).                
          05 WS-I-ACCT-CHNG-DTTM             PIC X(019).                
          05 WS-I-ACCT-STATUS                PIC X(010).                
          05 WS-I-CUSTOMER-NO                PIC X(012).                
          05 WS-I-DBA-NAME                   PIC X(102).                
          05 WS-I-CUST-EST-DTTM              PIC X(019).                
          05 WS-I-METER-ID                   PIC X(014).                
          05 WS-I-METER-STATUS               PIC X(013).                
          05 WS-I-ENDPOINT-ID                PIC X(036).                
          05 WS-I-METER-NO                   PIC X(011).                
          05 WS-I-AMI-VENDOR                 PIC X(017).                
          05 WS-I-MTR-INSTALL-DTTM           PIC X(019).                
          05 WS-I-METER-STATUS-2             PIC X(013).                
          05 WS-I-METER-TYPE-ID              PIC X(008).                
          05 WS-I-SERVICE-POINT-ID           PIC X(023).                
          05 WS-I-READ-CYCLE                 PIC X(004).                
          05 WS-I-CONSTANT-KWH               PIC 9(006).                
          05 WS-I-REVENUE-CLASS              PIC X(005).                
          05 WS-I-POINT-ID                   PIC X(012).                
          05 WS-I-RATE-PLAN-NO               PIC X(057).                
          05 WS-I-LOC-OFFICE                 PIC X(028).                
          05 WS-I-SVC-ADDR-1                 PIC X(057).                
          05 WS-I-SVC-ADDR-OVERFLOW          PIC X(028).                
          05 WS-I-SVC-CITY                   PIC X(032).                
          05 WS-I-SVC-STATE                  PIC X(004).                
          05 WS-I-SVC-ZIP                    PIC X(012).                
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 RS-RETURN-CODE                  PIC S9(9) VALUE +0 COMP.   
          05 RS-RETURN-CODE-DISP             PIC S9(9) VALUE +0 COMP.   
          05 WS-CURR-TMSTMP                  PIC X(26) VALUE SPACES.    
          05 WS-CURR-DATE                    PIC X(10) VALUE SPACES.    
          05 WS-DISPLAY-SQLCODE              PIC ---9.                  
          05 WS-FCSRP106-REC-CNTR            PIC 9(07) VALUE 0.         
          05 WS-FCSPT106-REC-CNTR            PIC 9(07) VALUE 0.         
          05 WS-ENDPOINT-ID                  PIC X(24) VALUE SPACES.    
          05 WS-NULL-IND-STC                 PIC S9(4) COMP VALUE 0.    
          05 WS-SPACE-CNT                    PIC 9(02) VALUE ZERO.      
          05 WS-STR-COUNT                    PIC 9(02) VALUE ZERO.      
          05 WS-SP-MTR-NO                    PIC X(09) VALUE SPACES.    
ACT010    05 WS-MTR-READ-SOURCE-CD           PIC X(01) VALUE SPACES.    
ACT010    05 WS-MTR-RD-SRC-CD                PIC X(15).                 
      *                                                                         
       01 WS-FORMAT-STRING.                                             
          05 WS-ACCOUNT-NO-FMT.                                         
             10 WS-ACCOUNT-NO                PIC 9(13) VALUE 0.         
             10 WS-ACCOUNT-NO-R REDEFINES                               
                WS-ACCOUNT-NO                PIC X(13).                 
          05 WS-CUSTOMER-NO-FMT.                                        
             10 WS-CUSTOMER-NO               PIC 9(10) VALUE 0.         
             10 WS-CUSTOMER-NO-R REDEFINES                              
                WS-CUSTOMER-NO               PIC X(10).                 
          05 WS-ACCT-CHNG-DTTM-FMT.                                     
             10 WS-ACCT-CHNG-DT              PIC X(10) VALUE SPACES.    
             10 FILLER                       PIC X(01) VALUE SPACES.    
             10 WS-ACCT-CHNG-TM              PIC X(08) VALUE SPACES.    
          05 WS-CUST-EST-DTTM-FMT.                                      
             10 WS-CUST-EST-DT               PIC X(10) VALUE SPACES.    
             10 FILLER                       PIC X(01) VALUE SPACES.    
             10 WS-CUST-EST-TM               PIC X(08) VALUE SPACES.    
          05 WS-METER-ID-FMT.                                           
             10 WS-METER-ID-PFX              PIC X(01) VALUE SPACES.    
             10 WS-METER-ID-1                PIC X(12) VALUE SPACES.    
             10 WS-METER-ID-SFX              PIC X(01) VALUE SPACES.    
          05 WS-MTR-INSTALL-DTTM-FMT.                                   
             10 WS-MTR-INSTALL-DT            PIC X(10) VALUE SPACES.    
             10 FILLER                       PIC X(01) VALUE SPACES.    
             10 WS-MTR-INSTALL-TM            PIC X(08) VALUE SPACES.    
          05 WS-METER-TYPE-ID-FMT.                                      
             10 WS-METER-TYPE-PFX            PIC X(01) VALUE SPACES.    
             10 WS-METER-TYPE-ID-1           PIC X(06) VALUE SPACES.    
             10 WS-METER-TYPE-SFX            PIC X(01) VALUE SPACES.    
          05 WS-SERVICE-POINT-ID-FMT.                                   
             10 WS-SERVICE-POINT-PFX         PIC X(01) VALUE SPACES.    
             10 WS-SERVICE-POINT-ID-1        PIC X(21) VALUE SPACES.    
             10 WS-SERVICE-POINT-SFX         PIC X(01) VALUE SPACES.    
          05 WS-SERVICE-POINT-ID.                                       
             10 WS-COMPANY-NO                PIC X(02) VALUE SPACES.    
             10 WS-PREMISE-NO                PIC 9(10) VALUE 0.         
             10 WS-CODE-UTIL-TYPE            PIC X(01) VALUE SPACES.    
             10 WS-IC-NO                     PIC 9(04) VALUE 0.         
             10 WS-MTR-REF-NO                PIC 9(04) VALUE 0.         
          05 WS-METER-ID.                                               
             10 WS-COMPANY-NO1               PIC X(02) VALUE SPACES.    
             10 WS-CODE-UTIL-TYPE1           PIC X(01) VALUE SPACES.    
             10 WS-METER-NO1                 PIC X(09) VALUE SPACES.    
          05 WS-METER-TYPE-ID.                                          
             10 WS-DMT                       PIC X(02) VALUE SPACES.    
             10 WS-PGM-ID                    PIC X(02) VALUE SPACES.    
             10 WS-CODE-UTIL-TYPE2           PIC X(01) VALUE SPACES.    
             10 WS-MTR-RD-SRC                PIC X(01) VALUE SPACES.    
          05 WS-CONSTANT-DISP                PIC 9(09).9(6).            
          05 WS-RATE-PLAN-NO                 PIC X(03) VALUE SPACES.    
          05 WS-LOC-OFFICE                   PIC X(03) VALUE SPACES.    
          05 WS-ACCT-STATUS                  PIC X(10) VALUE SPACES.    
          05 WS-ACCT-STATUS-CD               PIC X(01) VALUE SPACES.    
          05 WS-METER-STATUS                 PIC X(10) VALUE SPACES.    
          05 WS-METER-STATUS-CD              PIC X(01) VALUE SPACES.    
          05 WS-READ-CYCLE                   PIC X(02) VALUE SPACES.    
          05 WS-REVENUE-CLASS                PIC X(03) VALUE SPACES.    
          05 WS-POINT-ID                     PIC X(10) VALUE SPACES.    
          05 WS-ACCOUNT-NO-NUM               PIC 9(13) VALUE 0.         
          05 WS-ACCOUNT-NO-CHA REDEFINES                                
             WS-ACCOUNT-NO-NUM               PIC X(13).                 
          05 WS-CUSTOMER-NO-NUM              PIC 9(10) VALUE 0.         
          05 WS-CUSTOMER-NO-CHA REDEFINES                               
             WS-CUSTOMER-NO-NUM              PIC X(10).                 
      *                                                                         
       01 WS-AUDIT-REPT.                                                
          05 RS-METER-ID                     PIC X(12).                 
          05 RS-SERVICE-POINT-ID             PIC X(21).                 
          05 RS-DISCREPANCY                  PIC X(30).                 
          05 RS-CIS-VALUE                    PIC X(40).                 
          05 RS-IEE-VALUE                    PIC X(40).                 
      *                                                                         
       01 WS-NO-DATA.                                                   
          05 FILLER                  PIC X(55) VALUE SPACES.            
          05 FILLER                  PIC X(32) VALUE                    
                   '** NO DATA FOUND FOR THIS RUN **'.                  
          05 FILLER                  PIC X(45) VALUE SPACES.            
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-END                             PIC X(40) VALUE            
           'WORKING STORAGE FOR PCSRP106 ENDS HERE  '.                  
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 1000-GENERATE-AUDIT-REPORT                           
              THRU 1000-EXIT                                            
             UNTIL WS-END-OF-FILE = 'Y'.                                
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN INPUT  FCSRP106-FILE.                                   
                                                                        
           IF  FRP106-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSRP106 OPEN INPUT               **'  
              DISPLAY '** FILE STATUS = ' WS-FRP106-STATUS              
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT106-FILE.                                   
                                                                        
           IF  FPT106-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSPT106 OPEN OUTPUT              **'  
              DISPLAY '** FILE STATUS = ' WS-FPT106-STATUS              
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-GET-CURR-TMSTMP                                 
              THRU 7000-EXIT.                                           
      *                                                                         
           DISPLAY 'CURRENT TIMESTAMP  ==> ' WS-CURR-TMSTMP.            
           DISPLAY '  '.                                                
      *                                                                         
      *** GET ITRON ENDPOINT-ID                                                 
           PERFORM 7100-GET-ENDPOINT-ID                                 
              THRU 7100-EXIT.                                           
                                                                        
           MOVE UV-CODE-LONG-DESC-TEXT TO WS-ENDPOINT-ID.               
           DISPLAY 'ENDPOINT-ID: ' WS-ENDPOINT-ID.                      
           DISPLAY '  '.                                                
      *                                                                         
      *** CREATE REPORT HEADER                                                  
ACT018     INITIALIZE FIOPT106-REC.                                     
ACT018     MOVE WS-H-METER-ID          TO WS-RPT-METER-ID.              
ACT018     MOVE WS-H-SERVICE-POINT-ID  TO WS-RPT-SPOINT-ID.             
ACT018     MOVE WS-H-DISCREPANCY       TO WS-RPT-DISCREPANCY.           
ACT018     MOVE WS-H-CIS-VALUE         TO WS-RPT-CIS-VALUE.             
ACT018     MOVE WS-H-IEE-VALUE         TO WS-RPT-IEE-VALUE.             
ACT018     MOVE ','                    TO WS-RPT-DLM-1                  
ACT018                                    WS-RPT-DLM-2                  
ACT018                                    WS-RPT-DLM-3                  
ACT018                                    WS-RPT-DLM-4.                 
           WRITE FIOPT106-REC.                                          
      *                                                                         
      *** READ FILE FOR PROCESSING                                              
           PERFORM 7200-READ-FCSRP106                                   
              THRU 7200-EXIT.                                           
                                                                        
           IF FRP106-READ-EOF                                           
              DISPLAY '  '                                              
              DISPLAY '****************************************'        
              DISPLAY '**                                    **'        
              DISPLAY '**   NO METER-ID CHANGES FOUND...     **'        
              DISPLAY '**   PROGRAM COMPLETED SUCCESSFULLY.  **'        
              DISPLAY '**                                    **'        
              DISPLAY '****************************************'        
              MOVE WS-NO-DATA          TO FIOPT106-REC                  
              WRITE FIOPT106-REC                                        
           ELSE                                                         
              PERFORM 7200-READ-FCSRP106                                
                 THRU 7200-EXIT                                         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-GENERATE-AUDIT-REPORT.                                      
      *================================================================*        
      *                                                                         
ACT018     MOVE SPACES                 TO WS-AUDIT-REPT                 
ACT018                                    FIOPT106-REC.                 
      *                                                                         
           PERFORM 1100-GET-IEE-DATA                                    
              THRU 1100-EXIT.                                           
      *                                                                         
           PERFORM 7300-GET-INTF-DETAILS                                
              THRU 7300-EXIT.                                           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 1200-GET-OTHER-DETAILS                            
                 THRU 1200-EXIT                                         
           ELSE                                                         
              DISPLAY ' *************************************** '       
              DISPLAY ' # EXCPTN OPENWAY METER-ID : ' 1D-METER-NO       
              DISPLAY ' *************************************** '       
              PERFORM 2000-PROCESS-EXCPTN                               
                 THRU 2000-EXIT                                         
           END-IF.                                                      
      *                                                                         
           PERFORM 7200-READ-FCSRP106                                   
              THRU 7200-EXIT.                                           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-GET-IEE-DATA.                                               
      *================================================================*        
      *                                                                         
           INITIALIZE WS-RECORD-STRING                                  
                      WS-FORMAT-STRING.                                 
                                                                        
           UNSTRING  FIORP106-REC DELIMITED BY ','                      
               INTO  WS-I-ACCOUNT-NO                                    
                   , WS-I-ACCT-CHNG-DTTM                                
                   , WS-I-ACCT-STATUS                                   
                   , WS-I-CUSTOMER-NO                                   
                   , WS-I-DBA-NAME                                      
                   , WS-I-CUST-EST-DTTM                                 
                   , WS-I-METER-ID                                      
                   , WS-I-METER-STATUS                                  
                   , WS-I-ENDPOINT-ID                                   
                   , WS-I-METER-NO                                      
                   , WS-I-AMI-VENDOR                                    
                   , WS-I-MTR-INSTALL-DTTM                              
                   , WS-I-METER-STATUS-2                                
                   , WS-I-METER-TYPE-ID                                 
                   , WS-I-SERVICE-POINT-ID                              
                   , WS-I-READ-CYCLE                                    
                   , WS-I-CONSTANT-KWH                                  
                   , WS-I-REVENUE-CLASS                                 
                   , WS-I-POINT-ID                                      
                   , WS-I-RATE-PLAN-NO                                  
                   , WS-I-LOC-OFFICE                                    
                   , WS-I-SVC-ADDR-1                                    
                   , WS-I-SVC-ADDR-OVERFLOW                             
                   , WS-I-SVC-CITY                                      
                   , WS-I-SVC-STATE                                     
                   , WS-I-SVC-ZIP                                       
           END-UNSTRING.                                                
      *                                                                         
           MOVE WS-I-METER-ID          TO WS-METER-ID-FMT.              
           MOVE WS-METER-ID-1          TO WS-METER-ID.                  
           MOVE WS-METER-NO1           TO 1D-METER-NO.                  
                                                                        
           MOVE WS-I-SERVICE-POINT-ID  TO WS-SERVICE-POINT-ID-FMT.      
           MOVE WS-SERVICE-POINT-ID-1  TO WS-SERVICE-POINT-ID.          
      *                                                                         
           MOVE WS-I-METER-TYPE-ID     TO WS-METER-TYPE-ID-FMT.         
           MOVE WS-METER-TYPE-ID-1     TO WS-METER-TYPE-ID.             
      *                                                                         
           DISPLAY 'PROCESSING METER: ' WS-METER-ID.                    
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-GET-OTHER-DETAILS.                                          
      *================================================================*        
      *                                                                         
      *** Format Account No.                                                    
           IF WS-I-ACCOUNT-NO > SPACES                                  
              PERFORM 1210-FMT-ACCT-NO                                  
                 THRU 1210-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** Format Customer No.                                                   
           IF WS-I-CUSTOMER-NO > SPACES                                 
              PERFORM 1220-FMT-CUST-NO                                  
                 THRU 1220-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** Get CIS Customer No & Service Start Date                              
           PERFORM 7400-GET-SERVICE-DATES                               
              THRU 7400-EXIT.                                           
                                                                        
      *** Get CIS Meter Install Dates                                           
                                                                        
      *    MOVE 1D-ACCOUNT-NO          TO MN-ACCOUNT-NO                         
      *    MOVE WS-CODE-UTIL-TYPE      TO MN-CODE-UTIL-TYPE                     
      *    MOVE WS-IC-NO               TO MN-IC-NO                              
      *    MOVE WS-MTR-REF-NO          TO MN-MTR-REF-NO                         
      *                                                                         
      *    PERFORM 7500-GET-MTR-STATUS-DATES                                    
      *       THRU 7500-EXIT.                                                   
      *                                                                         
      *** Format Revenue Class                                                  
           IF WS-I-REVENUE-CLASS > SPACES                               
              PERFORM 1230-FMT-REV-CLS                                  
                 THRU 1230-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** Format Point ID                                                       
           IF WS-I-POINT-ID > SPACES                                    
              PERFORM 1240-FMT-POINT-ID                                 
                 THRU 1240-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** Format Account Status                                                 
      *    IF WS-I-ACCT-STATUS > SPACES                                         
      *       PERFORM 1250-FMT-ACCT-STATS                                       
      *          THRU 1250-EXIT                                                 
      *    END-IF.                                                              
      *                                                                         
      *** Format Meter Status                                                   
           IF WS-I-POINT-ID > SPACES                                    
              PERFORM 1260-FMT-METER-STATS                              
                 THRU 1260-EXIT                                         
           END-IF.                                                      
ACT010*                                                                         
ACT010*** Format Meter Read Source                                              
ACT010     IF WS-I-AMI-VENDOR > SPACES                                  
ACT010        PERFORM 1270-FMT-MTR-READ-SOURCE                          
ACT010           THRU 1270-EXIT                                         
ACT010     END-IF.                                                      
      *                                                                         
      *** Miscellaneous Attributes                                              
      *    MOVE WS-I-ACCT-CHNG-DTTM    TO WS-ACCT-CHNG-DTTM-FMT.                
      *    MOVE WS-I-CUST-EST-DTTM     TO WS-CUST-EST-DTTM-FMT.                 
      *    MOVE WS-I-MTR-INSTALL-DTTM  TO WS-MTR-INSTALL-DTTM-FMT.              
           MOVE WS-I-READ-CYCLE(2:2)   TO WS-READ-CYCLE.                
           MOVE WS-I-RATE-PLAN-NO(2:3) TO WS-RATE-PLAN-NO.              
           MOVE WS-I-LOC-OFFICE(2:3)   TO WS-LOC-OFFICE.                
      *                                                                         
           PERFORM 1300-COMPARE-DATA                                    
              THRU 1300-EXIT.                                           
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1210-FMT-ACCT-NO.                                                
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-ACCOUNT-NO REPLACING ALL '"' BY ' '.            
           INSPECT WS-I-ACCOUNT-NO TALLYING WS-SPACE-CNT                
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 15 - WS-SPACE-CNT.                    
                                                                        
           MOVE WS-I-ACCOUNT-NO(WS-SPACE-CNT + 1 : WS-STR-COUNT)        
             TO WS-ACCOUNT-NO-R.                                        
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1220-FMT-CUST-NO.                                                
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-CUSTOMER-NO REPLACING ALL '"' BY ' '.           
           INSPECT WS-I-CUSTOMER-NO TALLYING WS-SPACE-CNT               
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 12 - WS-SPACE-CNT.                    
                                                                        
           MOVE WS-I-CUSTOMER-NO(WS-SPACE-CNT + 1 : WS-STR-COUNT)       
             TO WS-CUSTOMER-NO-R.                                       
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1230-FMT-REV-CLS.                                                
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-REVENUE-CLASS REPLACING ALL '"' BY ' '.         
           INSPECT WS-I-REVENUE-CLASs TALLYING WS-SPACE-CNT             
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 5 - WS-SPACE-CNT.                     
                                                                        
           MOVE WS-I-REVENUE-CLASS(WS-SPACE-CNT + 1 : WS-STR-COUNT)     
             TO WS-REVENUE-CLASS.                                       
      *                                                                         
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1240-FMT-POINT-ID.                                               
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-POINT-ID REPLACING ALL '"' BY ' '.              
           INSPECT WS-I-POINT-ID TALLYING WS-SPACE-CNT                  
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 12 - WS-SPACE-CNT.                    
                                                                        
           MOVE WS-I-POINT-ID(WS-SPACE-CNT + 1 : WS-STR-COUNT)          
             TO WS-POINT-ID.                                            
      *                                                                         
       1240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1250-FMT-ACCT-STATS.                                             
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-ACCT-STATUS REPLACING ALL '"' BY ' '.           
           INSPECT WS-I-ACCT-STATUS TALLYING WS-SPACE-CNT               
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 10 - WS-SPACE-CNT.                    
                                                                        
           MOVE WS-I-POINT-ID(WS-SPACE-CNT + 1 : WS-STR-COUNT)          
             TO WS-ACCT-STATUS.                                         
                                                                        
           IF WS-ACCT-STATUS = 'Active'                                 
              MOVE 'A'                 TO WS-ACCT-STATUS-CD             
           ELSE                                                         
              MOVE 'B'                 TO WS-ACCT-STATUS-CD             
           END-IF.                                                      
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1260-FMT-METER-STATS.                                            
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO WS-SPACE-CNT                  
                                          WS-STR-COUNT.                 
                                                                        
           INSPECT WS-I-METER-STATUS REPLACING ALL '"' BY ' '.          
           INSPECT WS-I-METER-STATUS TALLYING WS-SPACE-CNT              
               FOR LEADING SPACES.                                      
                                                                        
           COMPUTE WS-STR-COUNT = 10 - WS-SPACE-CNT.                    
                                                                        
           MOVE WS-I-METER-STATUS(WS-SPACE-CNT + 1 : WS-STR-COUNT)      
             TO WS-METER-STATUS.                                        
                                                                        
           IF WS-METER-STATUS = 'Active'                                
              MOVE 'A'                 TO WS-METER-STATUS-CD            
           ELSE                                                         
              MOVE 'K'                 TO WS-METER-STATUS-CD            
           END-IF.                                                      
      *                                                                         
       1260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT010*================================================================*        
ACT010 1270-FMT-MTR-READ-SOURCE.                                        
ACT010*================================================================*        
ACT010*                                                                         
ACT010     MOVE SPACES                 TO WS-MTR-RD-SRC-CD.             
ACT010     MOVE ZERO                   TO WS-SPACE-CNT                  
ACT010                                    WS-STR-COUNT.                 
ACT010                                                                  
ACT010     INSPECT WS-I-AMI-VENDOR   REPLACING ALL '"' BY ' '.          
ACT010     INSPECT WS-I-AMI-VENDOR   TALLYING WS-SPACE-CNT              
ACT010         FOR LEADING SPACES.                                      
ACT010                                                                  
ACT010     COMPUTE WS-STR-COUNT = 17 - WS-SPACE-CNT.                    
ACT010                                                                  
ACT010     MOVE WS-I-AMI-VENDOR(WS-SPACE-CNT + 1 : WS-STR-COUNT)        
ACT010       TO WS-MTR-RD-SRC-CD.                                       
ACT010                                                                  
ACT010     MOVE 'P'                    TO WS-MTR-READ-SOURCE-CD.        
ACT010                                                                  
ACT010     IF WS-MTR-RD-SRC-CD = 'MV90'                                 
ACT010        MOVE 'M'                 TO WS-MTR-READ-SOURCE-CD         
ACT010     END-IF.                                                      
ACT010*                                                                         
ACT010*                                                                         
ACT010 1270-EXIT.                                                       
ACT010     EXIT.                                                        
ACT010*                                                                         
      *================================================================*        
       1300-COMPARE-DATA.                                               
      *================================================================*        
      *                                                                         
           MOVE WS-METER-ID            TO RS-METER-ID.                  
           MOVE 1D-SERVICE-POINT-ID    TO RS-SERVICE-POINT-ID.          
           MOVE 1D-ACCOUNT-NO          TO WS-ACCOUNT-NO-NUM.            
ACT010                                                                  
ACT010*** METER READ SOURCE                                                     
ACT010     IF WS-MTR-READ-SOURCE-CD NOT EQUAL 1D-MTR-READ-SOURCE-CD     
ACT010        MOVE 'MTR_READ_SOURCE_CD'      TO RS-DISCREPANCY          
ACT010        MOVE 1D-MTR-READ-SOURCE-CD     TO RS-CIS-VALUE            
ACT010        MOVE WS-MTR-READ-SOURCE-CD     TO RS-IEE-VALUE            
ACT010        PERFORM 3000-PREPARE-STRING                               
ACT010           THRU 3000-EXIT                                         
ACT010        GO TO 1300-EXIT                                           
ACT010     END-IF.                                                      
                                                                        
      *** ACCOUNT NO                                                            
           IF WS-ACCOUNT-NO NOT EQUAL 1D-ACCOUNT-NO                     
              MOVE 'ACCOUNT_NO'        TO RS-DISCREPANCY                
              MOVE WS-ACCOUNT-NO-CHA   TO RS-CIS-VALUE                  
              MOVE WS-ACCOUNT-NO-R     TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** SERVICE POINT ID                                                      
           IF WS-SERVICE-POINT-ID NOT EQUAL 1D-SERVICE-POINT-ID         
              MOVE 'SERVICE_POINT_ID'  TO RS-DISCREPANCY                
              MOVE 1D-SERVICE-POINT-ID TO RS-CIS-VALUE                  
              MOVE WS-SERVICE-POINT-ID TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** DIGITAL METER TYPE                                                    
           IF WS-DMT NOT EQUAL 1D-DIGTL-MTR-TYPE                        
              MOVE 'DIGTL_MTR_TYPE'    TO RS-DISCREPANCY                
              MOVE 1D-DIGTL-MTR-TYPE   TO RS-CIS-VALUE                  
              MOVE WS-DMT              TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** PROGRAM ID                                                            
           IF WS-PGM-ID NOT EQUAL 1D-PROGRAM-ID                         
              MOVE 'PROGRAM_ID'        TO RS-DISCREPANCY                
              MOVE 1D-PROGRAM-ID       TO RS-CIS-VALUE                  
              MOVE WS-PGM-ID           TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** Meter Status                                                          
           IF WS-METER-STATUS-CD NOT EQUAL 1D-CODE-METER-STATUS         
              IF 1D-CODE-METER-STATUS EQUAL 'K'                         
                 MOVE 'CODE_METER_STATUS' TO RS-DISCREPANCY             
                 MOVE 1D-CODE-METER-STATUS TO RS-CIS-VALUE              
                 MOVE WS-METER-STATUS-CD TO RS-IEE-VALUE                
                 PERFORM 3000-PREPARE-STRING                            
                    THRU 3000-EXIT                                      
                 GO TO 1300-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** CUSTOMER NO                                                           
           IF WS-CUSTOMER-NO NOT EQUAL CH-CUSTOMER-NO                   
              MOVE 'CUSTOMER_NO'       TO RS-DISCREPANCY                
              MOVE CH-CUSTOMER-NO      TO RS-CIS-VALUE                  
              MOVE WS-CUSTOMER-NO-R    TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** CONSTANT                                                              
           IF WS-I-CONSTANT-KWH NOT EQUAL 1D-CONSTANT                   
              MOVE 'CONSTANT'          TO RS-DISCREPANCY                
              MOVE 1D-CONSTANT         TO WS-CONSTANT-DISP              
              MOVE WS-CONSTANT-DISP    TO RS-CIS-VALUE                  
              MOVE WS-I-CONSTANT-KWH   TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** RATE PLAN NO                                                          
           IF WS-RATE-PLAN-NO NOT EQUAL 1D-RATE-PLAN-NO                 
              MOVE 'RATE_PLAN_NO'      TO RS-DISCREPANCY                
              MOVE 1D-RATE-PLAN-NO     TO RS-CIS-VALUE                  
              MOVE WS-RATE-PLAN-NO     TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** LOCAL OFFICE                                                          
           IF WS-LOC-OFFICE NOT EQUAL 1D-LOCAL-OFFICE                   
              MOVE 'LOCAL_OFFICE'      TO RS-DISCREPANCY                
              MOVE 1D-LOCAL-OFFICE     TO RS-CIS-VALUE                  
              MOVE WS-LOC-OFFICE       TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** REVENUE CLASS                                                         
           IF WS-REVENUE-CLASS NOT EQUAL 1D-CODE-REVENUE-CLASS          
              MOVE 'REVENUE_CLASS'       TO RS-DISCREPANCY              
              MOVE 1D-CODE-REVENUE-CLASS TO RS-CIS-VALUE                
              MOVE WS-REVENUE-CLASS      TO RS-IEE-VALUE                
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** POINT ID                                                              
           IF WS-POINT-ID NOT EQUAL 1D-POINT-ID                         
              MOVE 'POINT_ID'          TO RS-DISCREPANCY                
              MOVE 1D-POINT-ID         TO RS-CIS-VALUE                  
              MOVE WS-POINT-ID         TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** READ CYCLE                                                            
           IF WS-READ-CYCLE NOT EQUAL 1D-READ-CYCLE                     
              MOVE 'READ_CYCLE'        TO RS-DISCREPANCY                
              MOVE 1D-READ-CYCLE       TO RS-CIS-VALUE                  
              MOVE WS-READ-CYCLE       TO RS-IEE-VALUE                  
              PERFORM 3000-PREPARE-STRING                               
                 THRU 3000-EXIT                                         
           END-IF.                                                      
      *                                                                         
      *** ACCOUNT EFFECTIVE START DATE                                          
      *    IF WS-ACCT-CHNG-DT NOT EQUAL CH-DATE-UTIL-SVC-STRT                   
      *       MOVE 'DATE_UTIL_SVC_STRT'  TO RS-DISCREPANCY                      
      *       MOVE CH-DATE-UTIL-SVC-STRT TO RS-CIS-VALUE                        
      *       MOVE WS-ACCT-CHNG-DT       TO RS-IEE-VALUE                        
      *       PERFORM 3000-PREPARE-STRING                                       
      *          THRU 3000-EXIT                                                 
      *    END-IF.                                                              
      *                                                                         
      *** METER EFFECTIVE START DATE                                            
      *    IF WS-MTR-INSTALL-DT NOT EQUAL MN-DATE-MTR-INSTALL                   
      *       MOVE 'DATE_MTR_INSTALL'  TO RS-DISCREPANCY                        
      *       MOVE MN-DATE-MTR-INSTALL TO RS-CIS-VALUE                          
      *       MOVE WS-MTR-INSTALL-DT   TO RS-IEE-VALUE                          
      *       PERFORM 3000-PREPARE-STRING                                       
      *          THRU 3000-EXIT                                                 
      *    END-IF.                                                              
      *                                                                         
      *** Account Status                                                        
      *    IF WS-ACCT-STATUS-CD NOT EQUAL 1D-CODE-ACCT-STAT                     
      *       MOVE 'CODE_ACCT_STAT'    TO RS-DISCREPANCY                        
      *       MOVE 1D-CODE-ACCT-STAT   TO RS-CIS-VALUE                          
      *       MOVE WS-ACCT-STATUS-CD   TO RS-IEE-VALUE                          
      *       PERFORM 3000-PREPARE-STRING                                       
      *          THRU 3000-EXIT                                                 
      *    END-IF.                                                              
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-PROCESS-EXCPTN.                                             
      *================================================================*        
      *                                                                         
           IF WS-SERVICE-POINT-ID > SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE SPACES                 TO WS-SP-MTR-NO.                 
                                                                        
           PERFORM 7600-GET-METER-FROM-SP                               
              THRU 7600-EXIT.                                           
      *                                                                         
           IF WS-SP-MTR-NO > SPACES                                     
              MOVE WS-SP-MTR-NO        TO RS-CIS-VALUE                  
           ELSE                                                         
              MOVE '*********'         TO RS-CIS-VALUE                  
           END-IF.                                                      
                                                                        
           MOVE WS-METER-ID            TO RS-METER-ID.                  
           MOVE WS-SERVICE-POINT-ID    TO RS-SERVICE-POINT-ID.          
           MOVE 'METER_NO*'            TO RS-DISCREPANCY.               
           MOVE WS-METER-NO1           TO RS-IEE-VALUE.                 
      *                                                                         
           PERFORM 3000-PREPARE-STRING                                  
              THRU 3000-EXIT.                                           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-PREPARE-STRING.                                             
      *================================================================*        
      *                                                                         
ACT018     INITIALIZE FIOPT106-REC.                                     
ACT018     MOVE RS-METER-ID            TO WS-RPT-METER-ID.              
ACT018     MOVE RS-SERVICE-POINT-ID    TO WS-RPT-SPOINT-ID.             
ACT018     MOVE RS-DISCREPANCY         TO WS-RPT-DISCREPANCY.           
ACT018     MOVE RS-CIS-VALUE           TO WS-RPT-CIS-VALUE.             
ACT018     MOVE RS-IEE-VALUE           TO WS-RPT-IEE-VALUE.             
ACT018     MOVE ','                    TO WS-RPT-DLM-1                  
ACT018                                    WS-RPT-DLM-2                  
ACT018                                    WS-RPT-DLM-3                  
ACT018                                    WS-RPT-DLM-4.                 
      *                                                                         
           PERFORM 8000-WRITE-REPORT                                    
              THRU 8000-EXIT.                                           
      *                                                                         
           MOVE SPACES                 TO RS-DISCREPANCY                
                                          RS-CIS-VALUE                  
                                          RS-IEE-VALUE.                 
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7000-GET-CURR-TMSTMP.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TMSTMP,
              :WS-CURR-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURR-TMSTMP = CURRENT TIMESTAMP                         
MFA-TR*            ,:WS-CURR-DATE   = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSRP106 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN 7000-GET-CURR-TMSTMP    **'        
              DISPLAY '**   GET CURRENT TIMESTAMP            **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '**      PROCESSING TERMINATED          **'       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7100-GET-ENDPOINT-ID.                                            
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
                SELECT  CODE_LONG_DESC                                  
                  INTO :UV-CODE-LONG-DESC                               
                  FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                     
                 WHERE CODE_VALUE = 'A'                                 
                   AND COLUMN_NA  = 'ENDPOINT_ID'                       
                   AND COMPANY_NO = '01'                                
                   AND PROGRAM_ID = 'ALL'                               
                   AND TABLE_NA   = 'OPENWAY'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  CODE_LONG_DESC                                          
MFA-TR*           INTO :UV-CODE-LONG-DESC                                       
MFA-TR*           FROM CSS_CODE_VALUE                                           
MFA-TR*          WHERE CODE_VALUE = 'A'                                         
MFA-TR*            AND COLUMN_NA  = 'ENDPOINT_ID'                               
MFA-TR*            AND COMPANY_NO = '01'                                        
MFA-TR*            AND PROGRAM_ID = 'ALL'                                       
MFA-TR*            AND TABLE_NA   = 'OPENWAY'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '*****************************************'       
              DISPLAY '**  ERROR IN 7100-GET-ENDPOINT-ID      **'       
              DISPLAY '**  SELECT FROM CSS_CODE_VALUE         **'       
              DISPLAY '**  CODE_VALUE    =  A'                          
              DISPLAY '**  COLUMN_NA     =  ENDPOINT_ID'                
              DISPLAY '**  COMPANY_NO    =  01'                         
              DISPLAY '**  PROGRAM_ID    =  ALL'                        
              DISPLAY '**  TABLE_NA      =  OPENWAY'                    
              DISPLAY '**  RETURN CODE   = '  WS-DISPLAY-SQLCODE        
              DISPLAY '**      PROCESSING TERMINATED          **'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7200-READ-FCSRP106.                                              
      *==============================================================*          
      *                                                                         
           READ FCSRP106-FILE                                           
                 AT END MOVE 'Y'          TO WS-END-OF-FILE.            
      *                                                                         
           EVALUATE TRUE                                                
               WHEN FRP106-SUCCESSFUL                                   
                   ADD 1                  TO WS-FCSRP106-REC-CNTR       
               WHEN FRP106-READ-EOF                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                  DISPLAY '****************************************'    
                  DISPLAY '** PCSRP106 PROCESSING ERROR          **'    
                  DISPLAY '** ABEND IN PARAGRAPH 7200            **'    
                  DISPLAY '** ERROR ON READING AUDIT FILE        **'    
                  DISPLAY '** ITRON FILE STATUS = ' WS-FRP106-STATUS    
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND                                    
                     THRU 9900-EXIT                                     
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-GET-INTF-DETAILS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) [1D].ACCOUNT_NO,
              [1D].SERVICE_POINT_ID,
              [1D].CODE_ACCT_STAT,
              [1D].CODE_METER_STATUS,
              [1D].MTR_SERIAL_NO,
              [1D].DEVICE_NO,
              [1D].LOCAL_OFFICE,
              [1D].READ_ROUTE,
              [1D].READ_CYCLE,
              [1D].CODE_REVENUE_CLASS,
              [1D].RATE_PLAN_NO,
              [1D].DIGTL_MTR_TYPE,
              [1D].PROGRAM_ID,
              [1D].REMOTE_READ_IND,
              [1D].MTR_READ_SOURCE_CD,
              [1D].CONSTANT,
              [1D].POINT_ID,
              [1D].IDR_IDENT_NO,
              [1D].ELEC_MTR_CLASS_CD,
              [1D].ELEC_MTR_SPEC_CD,
              [1D].METER_SUPPLYING,
              [1D].SECURED_RATE_FL,
              [1D].LAST_SYNC_DATE,
              [1D].LAST_UPDATE_PGM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), [1D].LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              [1D].TEMP_DATA                                        
              INTO :1D-ACCOUNT-NO                                       
                  ,:1D-SERVICE-POINT-ID                                 
                  ,:1D-CODE-ACCT-STAT                                   
                  ,:1D-CODE-METER-STATUS                                
                  ,:1D-MTR-SERIAL-NO                                    
                  ,:1D-DEVICE-NO                                        
                  ,:1D-LOCAL-OFFICE                                     
                  ,:1D-READ-ROUTE                                       
                  ,:1D-READ-CYCLE                                       
                  ,:1D-CODE-REVENUE-CLASS                               
                  ,:1D-RATE-PLAN-NO                                     
                  ,:1D-DIGTL-MTR-TYPE                                   
                  ,:1D-PROGRAM-ID                                       
                  ,:1D-REMOTE-READ-IND                                  
                  ,:1D-MTR-READ-SOURCE-CD                               
                  ,:1D-CONSTANT                                         
                  ,:1D-POINT-ID                                         
                  ,:1D-IDR-IDENT-NO                                     
                  ,:1D-ELEC-MTR-CLASS-CD                                
                  ,:1D-ELEC-MTR-SPEC-CD                                 
                  ,:1D-METER-SUPPLYING                                  
                  ,:1D-SECURED-RATE-FL                                  
                  ,:1D-LAST-SYNC-DATE                                   
                  ,:1D-LAST-UPDATE-PGM-ID                               
                  ,:1D-LAST-UPDATE-TS                                   
                  ,:1D-TEMP-DATA                                        
              FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)                   
             WHERE [1D].METER_NO  = :1D-METER-NO                          
ACT010*        AND 1D.MTR_READ_SOURCE_CD IN ('P','M')                           
             ORDER BY [1D].LAST_SYNC_DATE DESC                            
                     ,[1D].CODE_METER_STATUS                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1D.ACCOUNT_NO                                               
MFA-TR*            ,1D.SERVICE_POINT_ID                                         
MFA-TR*            ,1D.CODE_ACCT_STAT                                           
MFA-TR*            ,1D.CODE_METER_STATUS                                        
MFA-TR*            ,1D.MTR_SERIAL_NO                                            
MFA-TR*            ,1D.DEVICE_NO                                                
MFA-TR*            ,1D.LOCAL_OFFICE                                             
MFA-TR*            ,1D.READ_ROUTE                                               
MFA-TR*            ,1D.READ_CYCLE                                               
MFA-TR*            ,1D.CODE_REVENUE_CLASS                                       
MFA-TR*            ,1D.RATE_PLAN_NO                                             
MFA-TR*            ,1D.DIGTL_MTR_TYPE                                           
MFA-TR*            ,1D.PROGRAM_ID                                               
MFA-TR*            ,1D.REMOTE_READ_IND                                          
MFA-TR*            ,1D.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,1D.CONSTANT                                                 
MFA-TR*            ,1D.POINT_ID                                                 
MFA-TR*            ,1D.IDR_IDENT_NO                                             
MFA-TR*            ,1D.ELEC_MTR_CLASS_CD                                        
MFA-TR*            ,1D.ELEC_MTR_SPEC_CD                                         
MFA-TR*            ,1D.METER_SUPPLYING                                          
MFA-TR*            ,1D.SECURED_RATE_FL                                          
MFA-TR*            ,1D.LAST_SYNC_DATE                                           
MFA-TR*            ,1D.LAST_UPDATE_PGM_ID                                       
MFA-TR*            ,1D.LAST_UPDATE_TS                                           
MFA-TR*            ,1D.TEMP_DATA                                                
MFA-TR*       INTO :1D-ACCOUNT-NO                                               
MFA-TR*           ,:1D-SERVICE-POINT-ID                                         
MFA-TR*           ,:1D-CODE-ACCT-STAT                                           
MFA-TR*           ,:1D-CODE-METER-STATUS                                        
MFA-TR*           ,:1D-MTR-SERIAL-NO                                            
MFA-TR*           ,:1D-DEVICE-NO                                                
MFA-TR*           ,:1D-LOCAL-OFFICE                                             
MFA-TR*           ,:1D-READ-ROUTE                                               
MFA-TR*           ,:1D-READ-CYCLE                                               
MFA-TR*           ,:1D-CODE-REVENUE-CLASS                                       
MFA-TR*           ,:1D-RATE-PLAN-NO                                             
MFA-TR*           ,:1D-DIGTL-MTR-TYPE                                           
MFA-TR*           ,:1D-PROGRAM-ID                                               
MFA-TR*           ,:1D-REMOTE-READ-IND                                          
MFA-TR*           ,:1D-MTR-READ-SOURCE-CD                                       
MFA-TR*           ,:1D-CONSTANT                                                 
MFA-TR*           ,:1D-POINT-ID                                                 
MFA-TR*           ,:1D-IDR-IDENT-NO                                             
MFA-TR*           ,:1D-ELEC-MTR-CLASS-CD                                        
MFA-TR*           ,:1D-ELEC-MTR-SPEC-CD                                         
MFA-TR*           ,:1D-METER-SUPPLYING                                          
MFA-TR*           ,:1D-SECURED-RATE-FL                                          
MFA-TR*           ,:1D-LAST-SYNC-DATE                                           
MFA-TR*           ,:1D-LAST-UPDATE-PGM-ID                                       
MFA-TR*           ,:1D-LAST-UPDATE-TS                                           
MFA-TR*           ,:1D-TEMP-DATA                                                
MFA-TR*       FROM CSS_MDM_SS_INTF 1D                                           
MFA-TR*      WHERE 1D.METER_NO  = :1D-METER-NO                                  
MFA-TR*        AND 1D.MTR_READ_SOURCE_CD IN ('P','M')                           
MFA-TR*      ORDER BY 1D.LAST_SYNC_DATE DESC                                    
MFA-TR*              ,1D.CODE_METER_STATUS                                      
MFA-TR*      FETCH FIRST ROW ONLY                                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  7300-GET-INTF-DETAILS          **'  
              DISPLAY '** SELECT ROW FROM CSS_MDM_SS_INTF          **'  
              DISPLAY '** METER-NO         = ' 1D-METER-NO              
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '**      PROCESSING TERMINATED               **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7400-GET-SERVICE-DATES.                                          
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_UTIL_SVC_STRT                                  
                   ,CUSTOMER_NO                                         
               INTO :CH-DATE-UTIL-SVC-STRT                              
                   ,:CH-CUSTOMER-NO                                     
               FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :1D-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_UTIL_SVC_STRT                                          
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*        INTO :CH-DATE-UTIL-SVC-STRT                                      
MFA-TR*            ,:CH-CUSTOMER-NO                                             
MFA-TR*        FROM CSS_CUST_PREM_HIST                                          
MFA-TR*       WHERE ACCOUNT_NO = :1D-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  7400-GET-SERVICE-DATES         **'  
              DISPLAY '** SELECT ROW FROM CSS_CUST_PREM_HIST       **'  
              DISPLAY '** ACCOUNT NO       = ' 1D-ACCOUNT-NO            
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '**      PROCESSING TERMINATED               **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7500-GET-MTR-STATUS-DATES.                                       
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_MTR_INSTALL                                    
                   ,MTR_STATUS_CHNG_DT                                  
              INTO :MN-DATE-MTR-INSTALL                                 
                  ,:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-STC               
               FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                    
                AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                
                AND IC_NO           = :MN-IC-NO                         
                AND MTR_REF_NO      = :MN-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_MTR_INSTALL                                            
MFA-TR*            ,MTR_STATUS_CHNG_DT                                          
MFA-TR*       INTO :MN-DATE-MTR-INSTALL                                         
MFA-TR*           ,:MN-MTR-STATUS-CHNG-DT:WS-NULL-IND-STC                       
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*       WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                            
MFA-TR*         AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                        
MFA-TR*         AND IC_NO           = :MN-IC-NO                                 
MFA-TR*         AND MTR_REF_NO      = :MN-MTR-REF-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-STC < 0                                    
                 MOVE SPACES           TO MN-MTR-STATUS-CHNG-DT         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  7500-GET-MTR-STATUS-DATES      **'  
              DISPLAY '** SELECT ROW FROM CSS_MTRD_ENVRNMT         **'  
              DISPLAY '** ACCOUNT_NO      = ' 1D-ACCOUNT-NO             
              DISPLAY '** CODE_UTIL_TYPE  = ' MN-CODE-UTIL-TYPE         
              DISPLAY '** IC_NO           = ' MN-IC-NO                  
              DISPLAY '** MTR_REF_NO      = ' MN-MTR-REF-NO             
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**      PROCESSING TERMINATED               **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7600-GET-METER-FROM-SP.                                          
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
               SELECT [1D].METER_NO                                       
                 INTO :WS-SP-MTR-NO                                     
                 FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)                
                WHERE [1D].SERVICE_POINT_ID = :WS-SERVICE-POINT-ID-1      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1D.METER_NO                                               
MFA-TR*          INTO :WS-SP-MTR-NO                                             
MFA-TR*          FROM CSS_MDM_SS_INTF 1D                                        
MFA-TR*         WHERE 1D.SERVICE_POINT_ID = :WS-SERVICE-POINT-ID-1              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSRP106 ERROR ******************'  
              DISPLAY '** ERROR IN  7600-GET-METER-FROM-SP         **'  
              DISPLAY '** SELECT ROW FROM CSS_MDM_SS_INTF          **'  
              DISPLAY '** SERVICEPOINT     = ' WS-SERVICE-POINT-ID-1    
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '**      PROCESSING TERMINATED               **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8000-WRITE-REPORT.                                               
      *================================================================*        
      *                                                                         
           WRITE FIOPT106-REC.                                          
      *                                                                         
           IF FPT106-SUCCESSFUL                                         
              ADD 1                TO WS-FCSPT106-REC-CNTR              
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '** PCSRP106 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8000            **'        
              DISPLAY '** ERROR ON WRITING AUDIT REPORT      **'        
              DISPLAY '** REPORT FILE STATUS = ' WS-FPT106-STATUS       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSRP106-FILE.                                         
      *                                                                         
           IF FRP106-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSRP106 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FRP106-STATUS            
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSRP106-FILE **'     
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT106-FILE.                                         
      *                                                                         
           IF FPT106-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSPT106 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FPT106-STATUS            
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSPT106-FILE **'     
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL RECS PROCESSED FROM RP106 = '              
                                 WS-FCSRP106-REC-CNTR.                  
           DISPLAY '** TOTAL RECS WRITTEN IN AUDIT REPT= '              
                                 WS-FCSPT106-REC-CNTR.                  
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
