       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSRP104.                                         
       DATE-WRITTEN.   SEP 2007.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **             F U N C T I O N A L   D E S C R I P T I O N    **          
      **                             O F   M O D U LE               **          
      **                                                            **          
      **  PURPOSE : GENERATE A REPORT TO IDENTIFY AMR METERS THAT   **          
      **            ARE NOT SENDING AMR READS.                      **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
T35434** 07/23/08   MR97640    NEW PROGRAM.                         **          
C35434** 07/29/08   NC94746    HANDLE NOT-FOUND CONDITION IN 7200   **          
A00633** 01/14/09   NC94746    ACT00001:FIX REV MONTH ISSUE BY      **          
A00633**                       CORRECTLY COMPUTING SIX MONTHS BACK  **          
A00633**                       REV MONTH TO REPORT COUNTS CORRECTLY **          
A00790** 04/09/09   NC94746    ACT00001:COUNT CONSEQUTIVE NON-AMR   **          
A00790**                       READS WHEN NO AMR READ EXISTS FOR    **          
A00790**                       THE MONTH.                           **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSBW06.                                                            
                                                                        
           SELECT FCSRP104-FILE    ASSIGN UT-S-FCSRP104                 
                                FILE STATUS IS WS-RP104-STATUS.         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW06.                                                            
       COPY FIOBW06.                                                            
                                                                        
       FD  FCSRP104-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  RP104-RECORD.                                                
           05 RP104-DATA              PIC X(178).                       
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ROUTE-REPOT  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP104'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                   PIC X(40)  VALUE                  
           'WORKING STORAGE FOR PCSRP104 STARTS HERE'.                  
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 PROGRAM-NAME            PIC X(08)  VALUE 'PCSRP104'.      
           05 WS-PGRMNAME             PIC X(08)  VALUE 'PCSRP104'.      
           05 WS-PW-REV-MONTH-DISP       PIC 9(06).                     
           05 WS-PW-REV-MONTH REDEFINES  WS-PW-REV-MONTH-DISP.          
              10 WS-PW-REV-MONTH-YYYY    PIC 9(04).                     
              10 WS-PW-REV-MONTH-MM      PIC 9(02).                     
A00633     05 WS-REV-MONTH-SIGNMM     PIC S9(02).                       
           05 WS-REV-MONTH-MAX        PIC S9(06)V COMP-3 VALUE ZEROES.  
           05 WS-REV-MONTH-MTC        PIC S9(06)V COMP-3 VALUE ZEROES.  
           05 WS-REV-MONTH-MIN        PIC S9(06)V COMP-3 VALUE ZEROES.  
           05 WS-COMMON-DATE          PIC X(10)  VALUE SPACES.          
           05 WS-CURR-REV-MNTH-X      PIC X(06)  VALUE SPACES.          
           05 WS-CURR-REV-MNTH-N      REDEFINES  WS-CURR-REV-MNTH-X     
                                      PIC 9(06).                        
           05 WS-CURR-REV-MNTH1       PIC S9(06)V COMP-3 VALUE ZEROES.  
           05 WS-CURR-REV-MNTH2       PIC S9(06)V COMP-3 VALUE ZEROES.  
           05 WS-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE ZEROES.  
           05 WS-FBW06-REC-CNTR       PIC 9(09)   COMP-3 VALUE ZEROES.  
           05 WS-AMR-READS            PIC S9(04)  COMP VALUE ZEROES.    
           05 WS-NON-AMR-READS        PIC S9(04)  COMP VALUE ZEROES.    
           05 WS-READING-CODE-NULL    PIC S9(04)  COMP VALUE ZEROES.    
           05 WS-READ-ROUTE           PIC 9(04)  VALUE ZEROES.          
           05 WS-DATA-RECORD          PIC X(178) VALUE SPACES.          
           05 WS-METER-PROCESSED      PIC X(01)  VALUE 'N'.             
           05 WS-READING-CODE         PIC X(01)  VALUE SPACES.          
           05 RTE-SUB                 PIC 9(02)  VALUE ZEROS.           
           05 RTE-SUB1                PIC 9(02)  VALUE ZEROS.           
           05 RTE-SUB2                PIC 9(02)  VALUE ZEROS.           
           05 WS-READ-ROW-COUNT       PIC S9(4)  COMP VALUE ZEROES.     
                                                                        
           05 RS-RETURN-CODE          PIC S9(9)  VALUE  +000 COMP.      
           05 RS-RETURN-CODE-DISP     PIC S9(9)  VALUE  +000 COMP.      
                                                                        
           05 WS-START-DATE.                                            
               10 WS-START-YR         PIC X(04)  VALUE SPACES.          
               10 WS-START-MT         PIC X(02)  VALUE SPACES.          
                                                                        
           05 WS-START-DATE-N.                                          
               10 WS-START-YR-N       PIC S9(4)  COMP VALUE ZEROES.     
               10 WS-START-MT-N       PIC S9(2)  COMP VALUE ZEROES.     
                                                                        
           05 WS-Y                    PIC X(01)  VALUE 'Y'.             
           05 WS-N                    PIC X(01)  VALUE 'N'.             
                                                                        
                                                                        
       01 WS-TEMP-TABLES.                                               
          05 WS-ROUTE-REPOT-TAB.                                        
COB305       10 WS-REV-MONTH-ARR        PIC S9(06)V COMP-3 
COB305          OCCURS 40 TIMES VALUE 0.    
             10  WS-READING-CODE-ARR     PIC X(01)  OCCURS 40 TIMES.    
          05 WS-SIX-MONTHS-TAB.                                         
             10 WS-AMR-MONTHLY-TAB OCCURS 6 TIMES.                      
                15  WS-TAB-AMR              PIC 9(02).                  
                15  WS-TAB-NONAMR           PIC 9(02).                  
                15  WS-TAB-RD-SRC           PIC X(01).                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FBW06-STATUS         PIC X(02).                        
              88  FBW06-SUCCESSFUL               VALUE '00'.            
           05 WS-RP104-STATUS         PIC X(02).                        
              88  RP104-SUCCESSFUL               VALUE '00'.            
           05 WS-FBW06-EOF            PIC X(01)  VALUE 'N'.             
              88 FBW06-EOF                       VALUE 'Y'.             
           05 WS-FIRST-READ-SW        PIC X(01)  VALUE 'N'.             
              88 FIRST-READ-FOUND                VALUE 'Y'.             
              88 FIRST-READ-NOT-FOUND            VALUE 'N'.             
                                                                        
      ****************************************************************          
      *           COMMON WORKING STORAGE FOR REPORT VARIABLES       *           
      ****************************************************************          
       01 WS-DATA-LINE.                                                 
           05 WS-RPT-COMPANY-NO            PIC X(02)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-LOCAL-OFFICE          PIC X(03)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-READ-ROUTE            PIC 9(04)  VALUE ZEROES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-READ-CYCLE            PIC X(02)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-METER-NUMBER          PIC X(09)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-AMR-ATTACH-ID         PIC X(12)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-DATE-READ             PIC X(10)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-REG-MEASURE-CD            PIC X(03)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-UTIL-TYPE             PIC X(01)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-AMR-READS             PIC 9(02)  VALUE ZEROES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-CONS-NON-AMR-READS    PIC 9(02)  VALUE ZEROES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-SVC-ADD               PIC X(50)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-SVC-ADDR-OVERFLOW     PIC X(24)  VALUE SPACES.     
           05 FILLER                       PIC X(01)  VALUE ','.        
           05 WS-RPT-SVC-ADDR-CTY-ST-ZIP   PIC X(41)  VALUE SPACES.     
                                                                        
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                       PIC X(73)  VALUE SPACES.     
           05 FILLER                       PIC X(31)  VALUE             
              '**** NO DATA FOR THIS RUN  ****'.                        
           05 FILLER                       PIC X(74)  VALUE SPACES.     
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *****************************************************************         
      *  CWS00074    WORKING STORAGE FOR CPD00074                     *         
      *              CREATE MAIL NAME AND ADDRESS                     *         
      *****************************************************************         
       COPY CWS00074.                                                           
                                                                        
      *****************************************************************         
      *  CWS00011   REDUCE EMBEDDED BLANKS                            *         
      *****************************************************************         
       COPY CWS00011.                                                           
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      * COPYBOOK WITH COMMON SQL VARIABLES                            *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      * COPYBOOK FOR CPD00039                                         *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      * COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                     *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      * DCLGEN FOR CSS_JOB_PARM                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * DECLARATION FOR SQL COMMAND AREA                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_ACCOUNT, AT                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_COMPANY, C7                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_MSTSUB_ACCT, MU                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMSTSUB                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_NAME, DQ                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_NAME_ACCT_XREF , HT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_CUST_ADDR_XREF, DM                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_ADDR_FREEFORM , DZ                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * TABLE : CSS_ADDR_FORMATTED , DY                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_ACCT_MISC_INFO, TA                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_ZIP_CODE , A4                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_UTIL_ENVRNMT , UT                                 *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_METER_ATTCHMTS , MA                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_MTR_ATT_TYPE , N5                                 *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMTRATP                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * TABLE : CSS_ROUTE_REPORT , PW                                 *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_CUST_PREM_HIST CH                        *            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_PREMISE PR                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION                                            *         
      *****************************************************************         
            EXEC SQL                                                    
               DECLARE ROUTE_REPOT CURSOR WITH ROWSET                   
                       POSITIONING FOR                                  
                SELECT PW.REVENUE_MONTH                                 
                      ,PW.READING_CODE                                  
                  FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)              
                      ,CSS_ROUTE_REPORT   PW WITH(READUNCOMMITTED)              
                 WHERE CH.ACCOUNT_NO      =  PW.ACCOUNT_NO              
                   AND CH.PREMISE_NO      = :CH-PREMISE-NO              
                   AND PW.REVENUE_MONTH BETWEEN :WS-REV-MONTH-MIN       
                                            AND :WS-REV-MONTH-MAX       
                   AND PW.CODE_UTIL_TYPE  = :PW-CODE-UTIL-TYPE          
                   AND PW.IC_NO           = :PW-IC-NO                   
                   AND PW.METER_NO        = :PW-METER-NO                
                   AND PW.REG_MEASURE_CD  = :PW-REG-MEASURE-CD          
                   AND PW.MTR_READ_SOURCE_CD = :PW-MTR-READ-SOURCE-CD   
A00790             AND PW.TYPE_OF_RD_IND   IN (' ', 'S', 'H')           
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE ROUTE_REPOT CURSOR WITH ROWSET                           
MFA-TR*                POSITIONING FOR                                          
MFA-TR*         SELECT PW.REVENUE_MONTH                                         
MFA-TR*               ,PW.READING_CODE                                          
MFA-TR*           FROM CSS_CUST_PREM_HIST CH                                    
MFA-TR*               ,CSS_ROUTE_REPORT   PW                                    
MFA-TR*          WHERE CH.ACCOUNT_NO      =  PW.ACCOUNT_NO                      
MFA-TR*            AND CH.PREMISE_NO      = :CH-PREMISE-NO                      
MFA-TR*            AND PW.REVENUE_MONTH BETWEEN :WS-REV-MONTH-MIN               
MFA-TR*                                     AND :WS-REV-MONTH-MAX               
MFA-TR*            AND PW.CODE_UTIL_TYPE  = :PW-CODE-UTIL-TYPE                  
MFA-TR*            AND PW.IC_NO           = :PW-IC-NO                           
MFA-TR*            AND PW.METER_NO        = :PW-METER-NO                        
MFA-TR*            AND PW.REG_MEASURE_CD  = :PW-REG-MEASURE-CD                  
MFA-TR*            AND PW.MTR_READ_SOURCE_CD = :PW-MTR-READ-SOURCE-CD           
MFA-TR*            AND PW.TYPE_OF_RD_IND   IN (' ', 'S', 'H')                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *===============================================================*         
       0000-MAINLINE.                                                   
      *===============================================================*         
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-PARA       THRU 1000-EXIT               
                                     UNTIL FBW06-EOF.                   
           PERFORM 5100-NO-DATA-LINE       THRU 5100-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       0100-INITIALIZATION.                                             
      *===============================================================*         
                                                                        
           OPEN INPUT FCSBW06-FILE.                                     
                                                                        
           IF FBW06-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSRP104 ABORT **************'       
               DISPLAY '*       0100-INITIALIZATION            *'       
               DISPLAY '*    ERROR OPENING FCSBW06 FILE        *'       
               DISPLAY '* FILE STATUS    : ' WS-FBW06-STATUS            
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRP104 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
           MOVE 'DATE'                       TO G6-CMND-CODE.           
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           MOVE WS-INPUT-RUN-DATE            TO WS-COMMON-DATE          
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE 'PCSRP104'               TO WS-PGRMNAME             
               MOVE WS-FCA00-COMMON-DATE     TO WS-COMMON-DATE          
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FBW06-FILE         THRU 7000-EXIT          
                                                                        
           OPEN OUTPUT FCSRP104-FILE.                                   
                                                                        
           IF RP104-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSRP104 ABORT **************'       
               DISPLAY '*       0100-INITIALIZATION            *'       
               DISPLAY '*    ERROR OPENING RP104 FILE          *'       
               DISPLAY '* FILE STATUS    : ' WS-RP104-STATUS            
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRP104 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1000-PROCESS-PARA.                                               
      *===============================================================*         
           INITIALIZE                       WS-DATA-LINE                
           MOVE E-FBW06-ACCOUNT-NO       TO PW-ACCOUNT-NO               
                                            HT-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
                                            WS-ACCOUNT-NO               
           MOVE E-FBW06-CODE-UTIL-TYPE   TO PW-CODE-UTIL-TYPE           
                                            MA-CODE-UTIL-TYPE           
           MOVE E-FBW06-METER-NO         TO PW-METER-NO                 
                                            MA-METER-NO                 
           MOVE E-FBW06-REG-MEASURE-CD   TO PW-REG-MEASURE-CD           
           MOVE E-FBW06-CODE-TIME-PERIOD TO PW-CODE-TIME-PERIOD         
           MOVE E-FBW06-CODE-TOU-SEASN   TO PW-CODE-TOU-SEASN           
           MOVE E-FBW06-DATE-READ        TO PW-LAST-REG-READ-DT         
           MOVE E-FBW06-TIME-READ        TO PW-LAST-REG-READ-TM         
      *                                                                         
           PERFORM 7020-SELECT-ROUTE-REPORT     THRU 7020-EXIT          
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              PERFORM 1200-PROCESS-CURSOR       THRU 1200-EXIT          
              PERFORM 1400-LOAD-METER-TRACKER   THRU 1400-EXIT          
           ELSE                                                         
              DISPLAY 'ACCOUNT NOT QUALIFY: '                           
                      E-FBW06-ACCOUNT-NO '|' E-FBW06-METER-NO           
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FBW06-FILE         THRU 7000-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1200-PROCESS-CURSOR.                                             
      *===============================================================*         
                                                                        
           DISPLAY 'PROCESSING ACCOUNT: '                               
                    E-FBW06-ACCOUNT-NO '|' E-FBW06-METER-NO             
      *                                                                         
           MOVE AT-PREMISE-NO            TO CH-PREMISE-NO               
                                            PR-PREMISE-NO               
           MOVE PW-REVENUE-MONTH         TO WS-REV-MONTH-MAX            
                                            WS-PW-REV-MONTH-DISP        
      *                                                                         
A00633     MOVE WS-PW-REV-MONTH-MM       TO WS-REV-MONTH-SIGNMM         
A00633     COMPUTE WS-REV-MONTH-SIGNMM = WS-REV-MONTH-SIGNMM - 5        
A00633*                                                                         
A00633     IF WS-REV-MONTH-SIGNMM <=  ZERO                              
A00633        COMPUTE WS-PW-REV-MONTH-YYYY =                            
A00633                               WS-PW-REV-MONTH-YYYY - 1           
A00633        COMPUTE WS-REV-MONTH-SIGNMM  =                            
A00633                               WS-REV-MONTH-SIGNMM + 12           
A00633     END-IF                                                       
A00633*                                                                         
A00633     MOVE WS-REV-MONTH-SIGNMM      TO WS-PW-REV-MONTH-MM          
           MOVE WS-PW-REV-MONTH-DISP     TO WS-REV-MONTH-MIN            
                                                                        
           PERFORM 7110-OPEN-ROUTE-REPORT       THRU 7110-EXIT.         
           PERFORM 7120-FETCH-ROUTE-REPORT      THRU 7120-EXIT.         
           PERFORM 7130-CLOSE-ROUTE-REPORT      THRU 7130-EXIT.         
           PERFORM 1220-PROCESS-ROUTE-REPORT    THRU 1220-EXIT.         
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1220-PROCESS-ROUTE-REPORT.                                       
      *===============================================================*         
                                                                        
           INITIALIZE WS-SIX-MONTHS-TAB.                                
           PERFORM VARYING RTE-SUB FROM 1 BY 1 UNTIL                    
                           RTE-SUB > WS-READ-ROW-COUNT                  
             MOVE WS-REV-MONTH-ARR (RTE-SUB) TO WS-REV-MONTH-MTC        
             MOVE WS-READING-CODE-ARR (RTE-SUB) TO WS-READING-CODE      
      ***    BELOW CODE WILL STORE COUNTS OF AMR READS FOR EACH REV             
      ***    MONTH FOR LAST 6 REV MONTHS                                        
             EVALUATE TRUE                                              
                WHEN WS-REV-MONTH-MTC = WS-REV-MONTH-MAX                
                     MOVE +1              TO RTE-SUB2                   
                WHEN (WS-REV-MONTH-MTC = WS-REV-MONTH-MAX - 1           
                      OR WS-REV-MONTH-MTC = WS-REV-MONTH-MIN + 4)       
                     MOVE +2              TO RTE-SUB2                   
                WHEN (WS-REV-MONTH-MTC = WS-REV-MONTH-MAX - 2           
                      OR WS-REV-MONTH-MTC = WS-REV-MONTH-MIN + 3)       
                     MOVE +3              TO RTE-SUB2                   
                WHEN (WS-REV-MONTH-MTC = WS-REV-MONTH-MAX - 3           
                      OR WS-REV-MONTH-MTC = WS-REV-MONTH-MIN + 2)       
                     MOVE +4              TO RTE-SUB2                   
                WHEN (WS-REV-MONTH-MTC = WS-REV-MONTH-MAX - 4           
                      OR WS-REV-MONTH-MTC = WS-REV-MONTH-MIN + 1)       
                      MOVE +5              TO RTE-SUB2                  
                WHEN WS-REV-MONTH-MTC = WS-REV-MONTH-MIN                
                     MOVE +6              TO RTE-SUB2                   
             END-EVALUATE                                               
      *                                                                         
             IF WS-READING-CODE = 'A'                                   
                ADD +1                   TO WS-TAB-AMR    (RTE-SUB2)    
                MOVE 'A'                 TO WS-TAB-RD-SRC (RTE-SUB2)    
             ELSE                                                       
                ADD +1                   TO WS-TAB-NONAMR (RTE-SUB2)    
                MOVE 'R'                 TO WS-TAB-RD-SRC (RTE-SUB2)    
             END-IF                                                     
      *                                                                         
A00790***    CONSIDER NON-AMR READS ONLY IF NO AMR READS EXISTS FOR             
A00790***     THE MONTH                                                         
A00790       IF WS-TAB-AMR    (RTE-SUB2) > ZEROS                        
A00790          MOVE ZEROS               TO WS-TAB-NONAMR (RTE-SUB2)    
A00790       END-IF                                                     
A00790*                                                                         
           END-PERFORM.                                                 
                                                                        
           SET FIRST-READ-NOT-FOUND     TO TRUE                         
           MOVE ZEROS                   TO WS-AMR-READS                 
                                           WS-NON-AMR-READS             
           PERFORM VARYING RTE-SUB1 FROM 6 BY -1 UNTIL                  
                           RTE-SUB1 < 1                                 
              IF WS-TAB-RD-SRC (RTE-SUB1) > SPACES                      
                 AND FIRST-READ-NOT-FOUND                               
                 SET FIRST-READ-FOUND     TO TRUE                       
              END-IF                                                    
              IF FIRST-READ-FOUND                                       
                 IF WS-TAB-AMR (RTE-SUB1)  > ZEROS                      
                    ADD +1                TO WS-AMR-READS               
                    MOVE ZEROS            TO WS-NON-AMR-READS           
                 ELSE                                                   
                    ADD +1                TO WS-NON-AMR-READS           
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1400-LOAD-METER-TRACKER.                                         
      *===============================================================*         
      *                                                                         
           PERFORM 7360-SELECT-PREMISE       THRU 7360-EXIT             
           MOVE ZERO                     TO AT-ADDRESS-ID               
           MOVE PR-ADDRESS-ID            TO HT-ADDRESS-ID               
           PERFORM 4025-DETERMINE-ADDRESS THRU 4025-EXIT                
      *                                                                         
           INSPECT WS-PR-STREET              REPLACING ALL ',' BY ' '.  
           INSPECT WS-PR-ADDR-OVERFLOW       REPLACING ALL ',' BY ' '.  
           INSPECT WS-PR-ADDR-CITY-STATE-ZIP REPLACING ALL ',' BY ' '.  
      *                                                                         
           MOVE WS-PR-STREET             TO WS-RPT-SVC-ADD              
           MOVE WS-PR-ADDR-OVERFLOW      TO WS-RPT-SVC-ADDR-OVERFLOW    
           MOVE WS-PR-ADDR-CITY-STATE-ZIP TO WS-RPT-SVC-ADDR-CTY-ST-ZIP 
      *                                                                         
           MOVE PW-COMPANY-NO            TO WS-RPT-COMPANY-NO           
                                            MA-COMPANY-NO               
           MOVE PW-LOCAL-OFFICE          TO WS-RPT-LOCAL-OFFICE         
           MOVE PW-READ-CYCLE            TO WS-RPT-READ-CYCLE           
           MOVE PW-READ-ROUTE            TO WS-READ-ROUTE               
           MOVE WS-READ-ROUTE            TO WS-RPT-READ-ROUTE           
           MOVE E-FBW06-DATE-READ        TO WS-RPT-DATE-READ            
      *                                                                         
           MOVE SPACES                   TO MA-DEVICE-NO                
           PERFORM 7200-GET-AMR-ATTACH-ID    THRU 7200-EXIT             
      *                                                                         
           MOVE MA-DEVICE-NO             TO WS-RPT-AMR-ATTACH-ID        
           MOVE WS-NON-AMR-READS         TO WS-RPT-CONS-NON-AMR-READS   
           MOVE WS-AMR-READS             TO WS-RPT-AMR-READS            
           MOVE E-FBW06-METER-NO         TO WS-RPT-METER-NUMBER         
           MOVE E-FBW06-REG-MEASURE-CD   TO WS-REG-MEASURE-CD           
           MOVE E-FBW06-CODE-UTIL-TYPE   TO WS-RPT-UTIL-TYPE            
           MOVE WS-DATA-LINE             TO WS-DATA-RECORD              
           MOVE 'Y'                      TO WS-METER-PROCESSED          
           PERFORM 8000-WRITE-REPORT     THRU 8000-EXIT.                
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       5100-NO-DATA-LINE.                                               
      *===============================================================*         
                                                                        
           IF WS-METER-PROCESSED = 'N'                                  
             MOVE WS-NO-DATA-LINE            TO WS-DATA-RECORD          
             PERFORM 8000-WRITE-REPORT          THRU 8000-EXIT          
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6251-GET-FJC01-DATE                                           *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-READ-FBW06-FILE.                                         *         
      *****************************************************************         
       7000-READ-FBW06-FILE.                                            
                                                                        
           READ FCSBW06-FILE                                            
             AT END                                                     
             MOVE 'Y'                        TO WS-FBW06-EOF.           
                                                                        
           IF FBW06-SUCCESSFUL OR FBW06-EOF                             
             NEXT SENTENCE                                              
           ELSE                                                         
             DISPLAY '********** PCSRP104 ABORT **************'         
             DISPLAY '*     READ ERROR : FBW06 FILE          *'         
             DISPLAY '* CURRENT PARA   : 7000                *'         
             DISPLAY '* FILE-STATUS    : ' WS-FBW06-STATUS              
             DISPLAY '* PROGRAM ABORTING...                  *'         
             DISPLAY '********** PCSRP104 ABORT **************'         
             PERFORM 9900-ABEND                 THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       7020-SELECT-ROUTE-REPORT.                                        
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) PW.REVENUE_MONTH,
              PW.IC_NO,
              PW.READING_CODE,
              PW.LOCAL_OFFICE,
              PW.COMPANY_NO,
              PW.READ_CYCLE,
              PW.READ_ROUTE,
              PW.MTR_READ_SOURCE_CD,
              AT.PREMISE_NO                                    
                 INTO :PW-REVENUE-MONTH                                 
                     ,:PW-IC-NO                                         
                     ,:PW-READING-CODE                                  
                     ,:PW-LOCAL-OFFICE                                  
                     ,:PW-COMPANY-NO                                    
                     ,:PW-READ-CYCLE                                    
                     ,:PW-READ-ROUTE                                    
                     ,:PW-MTR-READ-SOURCE-CD                            
                     ,:AT-PREMISE-NO                                    
                  FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
                      ,CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED)                
                 WHERE AT.ACCOUNT_NO       =  PW.ACCOUNT_NO             
                   AND PW.ACCOUNT_NO       = :PW-ACCOUNT-NO             
                   AND PW.CODE_UTIL_TYPE   = :PW-CODE-UTIL-TYPE         
                   AND PW.METER_NO         = :PW-METER-NO               
                   AND PW.REG_MEASURE_CD   = :PW-REG-MEASURE-CD         
                   AND PW.CODE_TIME_PERIOD = :PW-CODE-TIME-PERIOD       
                   AND PW.CODE_TOU_SEASN   = :PW-CODE-TOU-SEASN         
                   AND PW.LAST_REG_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                   :PW-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :PW-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:PW-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:PW-LAST-REG-READ-DT
              ), CONVERT(DATE, :PW-LAST-REG-READ-DT) )       
                   AND PW.LAST_REG_READ_TM = CIS.CHAR2TIME(
                                                   :PW-LAST-REG-READ-TM
              )       
A00790             AND PW.TYPE_OF_RD_IND   IN (' ', 'S', 'H')           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PW.REVENUE_MONTH                                         
MFA-TR*               ,PW.IC_NO                                                 
MFA-TR*               ,PW.READING_CODE                                          
MFA-TR*               ,PW.LOCAL_OFFICE                                          
MFA-TR*               ,PW.COMPANY_NO                                            
MFA-TR*               ,PW.READ_CYCLE                                            
MFA-TR*               ,PW.READ_ROUTE                                            
MFA-TR*               ,PW.MTR_READ_SOURCE_CD                                    
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*          INTO :PW-REVENUE-MONTH                                         
MFA-TR*              ,:PW-IC-NO                                                 
MFA-TR*              ,:PW-READING-CODE                                          
MFA-TR*              ,:PW-LOCAL-OFFICE                                          
MFA-TR*              ,:PW-COMPANY-NO                                            
MFA-TR*              ,:PW-READ-CYCLE                                            
MFA-TR*              ,:PW-READ-ROUTE                                            
MFA-TR*              ,:PW-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*           FROM CSS_ACCOUNT      AT                                      
MFA-TR*               ,CSS_ROUTE_REPORT PW                                      
MFA-TR*          WHERE AT.ACCOUNT_NO       =  PW.ACCOUNT_NO                     
MFA-TR*            AND PW.ACCOUNT_NO       = :PW-ACCOUNT-NO                     
MFA-TR*            AND PW.CODE_UTIL_TYPE   = :PW-CODE-UTIL-TYPE                 
MFA-TR*            AND PW.METER_NO         = :PW-METER-NO                       
MFA-TR*            AND PW.REG_MEASURE_CD   = :PW-REG-MEASURE-CD                 
MFA-TR*            AND PW.CODE_TIME_PERIOD = :PW-CODE-TIME-PERIOD               
MFA-TR*            AND PW.CODE_TOU_SEASN   = :PW-CODE-TOU-SEASN                 
MFA-TR*            AND PW.LAST_REG_READ_DT = :PW-LAST-REG-READ-DT               
MFA-TR*            AND PW.LAST_REG_READ_TM = :PW-LAST-REG-READ-TM               
MFA-TR*            AND PW.TYPE_OF_RD_IND   IN (' ', 'S', 'H')                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP104 ABORT **************'       
               DISPLAY '**      ABEND IN PARAGRAPH 7020       **'       
               DISPLAY '**  ACCOUNT_NO       = ' PW-ACCOUNT-NO          
               DISPLAY '**  CODE_UTIL_TYPE   = ' PW-CODE-UTIL-TYPE      
               DISPLAY '**  METER_NO         = ' PW-METER-NO            
               DISPLAY '**  REG_MEASURE_CD   = ' PW-REG-MEASURE-CD      
               DISPLAY '**  CODE_TIME_PERIOD = ' PW-CODE-TIME-PERIOD    
               DISPLAY '**  CODE_TOU_SEASN   = ' PW-CODE-TOU-SEASN      
               DISPLAY '**  LAST_REG_READ_DT = ' PW-LAST-REG-READ-DT    
               DISPLAY '**  LAST_REG_READ_TM = ' PW-LAST-REG-READ-TM    
               DISPLAY '**     SQLCODE       = ' WS-ACTIVE-RETURN-CODE  
               DISPLAY '********** PCSRP104 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-OPEN-ROUTE-REPORT.                                          
      *===============================================================*         
                                                                        
            EXEC SQL                                                    
               OPEN ROUTE_REPOT                                         
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP104 ABORT **************'        
              DISPLAY '* ERROR IN 7110-OPEN-ROUTE-REPORT      *'        
              DISPLAY '* PREMISE_NO         = ' CH-PREMISE-NO           
              DISPLAY '* REVENUE_MONTH BETWEEN ' WS-REV-MONTH-MIN       
              DISPLAY '*                   AND ' WS-REV-MONTH-MAX       
              DISPLAY '* CODE_UTIL_TYPE     = ' PW-CODE-UTIL-TYPE       
              DISPLAY '* IC_NO              = ' PW-IC-NO                
              DISPLAY '* METER_NO           = ' PW-METER-NO             
              DISPLAY '* REG_MEASURE_CD     = ' PW-REG-MEASURE-CD       
              DISPLAY '* MTR_READ_SOURCE_CD = ' PW-MTR-READ-SOURCE-CD   
              DISPLAY '* SQLCODE            = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '********** PCSRP104 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *===============================================================*         
       7120-FETCH-ROUTE-REPORT.                                         

MSQ008     MOVE 40 TO MSQ008-ROUTE-REPOT
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-ROUTE-REPOT
              FETCH 
              FROM ROUTE_REPOT           
                INTO :WS-REV-MONTH-ARR                                  
                    ,:WS-READING-CODE-ARR                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM ROUTE_REPOT FOR 40 ROWS                  
MFA-TR*         INTO :WS-REV-MONTH-ARR                                          
MFA-TR*             ,:WS-READING-CODE-ARR                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ROUTE-REPOT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)              TO WS-READ-ROW-COUNT         
           ELSE                                                         
              DISPLAY '********** PCSRP104 ABORT **************'        
              DISPLAY '* ERROR IN 7120-FETCH-ROUTE-REPORT     *'        
              DISPLAY '* PREMISE_NO         = ' CH-PREMISE-NO           
              DISPLAY '* REVENUE_MONTH BETWEEN ' WS-REV-MONTH-MIN       
              DISPLAY '*                   AND ' WS-REV-MONTH-MAX       
              DISPLAY '* CODE_UTIL_TYPE     = ' PW-CODE-UTIL-TYPE       
              DISPLAY '* IC_NO              = ' PW-IC-NO                
              DISPLAY '* METER_NO           = ' PW-METER-NO             
              DISPLAY '* REG_MEASURE_CD     = ' PW-REG-MEASURE-CD       
              DISPLAY '* MTR_READ_SOURCE_CD = ' PW-MTR-READ-SOURCE-CD   
              DISPLAY '*   SQLCODE          = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '********** PCSRP104 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *===============================================================*         
       7130-CLOSE-ROUTE-REPORT.                                         
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
              CLOSE ROUTE_REPOT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       EQUAL SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP104 ABORT **************'        
              DISPLAY '* ERROR IN 7130-CLOSE-ROUTE-REPORT     *'        
              DISPLAY '* SQLCODE     = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '********** PCSRP104 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *===============================================================*         
       7200-GET-AMR-ATTACH-ID.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) MA.DEVICE_NO                                      
                 INTO :MA-DEVICE-NO                                     
                 FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
                     ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)               
                WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE             
                  AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE              
                  AND MA.COMPANY_NO     = :MA-COMPANY-NO                
                  AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE            
                  AND MA.METER_NO       = :MA-METER-NO                  
                  AND N5.DEVICE_TYPE_CD = 'A'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MA.DEVICE_NO                                              
MFA-TR*          INTO :MA-DEVICE-NO                                             
MFA-TR*          FROM CSS_METER_ATTCHMTS MA                                     
MFA-TR*              ,CSS_MTR_ATT_TYPE   N5                                     
MFA-TR*         WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                     
MFA-TR*           AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                      
MFA-TR*           AND MA.COMPANY_NO     = :MA-COMPANY-NO                        
MFA-TR*           AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                    
MFA-TR*           AND MA.METER_NO       = :MA-METER-NO                          
MFA-TR*           AND N5.DEVICE_TYPE_CD = 'A'                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
C35434     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP104 ABORT **************'        
              DISPLAY '**      ABEND IN PARAGRAPH 7200       **'        
              DISPLAY '** COMPANY_NO     = ' PW-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MA-METER-NO                
              DISPLAY '** DEVICE_TYPE_CD =   A'                         
              DISPLAY '**    SQLCODE     = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '********** PCSRP104 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       7360-SELECT-PREMISE.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT PR.ADDRESS_ID                                      
                INTO :PR-ADDRESS-ID                                     
                FROM CSS_PREMISE  PR WITH(READUNCOMMITTED)                      
               WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.ADDRESS_ID                                              
MFA-TR*         INTO :PR-ADDRESS-ID                                             
MFA-TR*         FROM CSS_PREMISE  PR                                            
MFA-TR*        WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7360       **'       
               DISPLAY '**     PREMISE_NO  = ' PR-PREMISE-NO            
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CPD00038 INCLUDES:                                            *         
      *     7600-START-FCSJC01                                        *         
      *     7610-READ-FCSJC01                                         *         
      *     7611-CLOSE                                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7620-START-FCSCA00                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000-WRITE-REPORT.                                            *         
      *****************************************************************         
       8000-WRITE-REPORT.                                               
                                                                        
           WRITE RP104-RECORD          FROM WS-DATA-RECORD              
           IF RP104-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSRP104 ABORT **************'       
               DISPLAY '*       8000-WRITE-REPORT              *'       
               DISPLAY '*    ERROR WRITING RP104 FILE          *'       
               DISPLAY '* FILE STATUS    : ' WS-RP104-STATUS            
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRP104 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
           INITIALIZE                       WS-DATA-RECORD.             
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBW06-FILE                                           
                 FCSRP104-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * COPY BOOK TO GET COMMON DATE FROM JOB PARM                    *         
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * CPD00074                                                     *          
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * CPD00004                                                                
      *****************************************************************         
           COPY CPD00004.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9700-PROCESS-ABEND  (REQUIRED BY CPD00074)                    *         
      *****************************************************************         
       COPY CPD0023B.                                                           
                                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ******           END OF PCSRP104                           ******         
      *****************************************************************         
