       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP101.                                        
       DATE-WRITTEN.   07/18/97.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **              PROGRAM  NARRATIVE                             **         
      **  THIS IS A NEW REPORT  FOR CONSOLIDATED BILLING. THE REPORT **         
      **  SHOWS ALL THE ACCOUNTS WHERE THE TRANSFERS ARE PENDING.    **         
      **  THE REPORT WON'T HAVE ANY CONTROL BREAKS BECAUSE THERE     **         
      **  WON'T BE MANY ACCOUNTS WHERE TRANSFERS ARE PENDING.        **         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  07/14/97    RAO        NEW PROGRAM FOR REPORT GENERATION   **         
T16362**  05/13/98    TDK        MOVE SUB_ACCT_BLLD_OK VALUE TO      **         
T16362**                         'MASTER/SUB ACCT' FIELD ON REPORT   **         
T17146**  07/20/98    SV         SET MST/SUB FLAG AND TRANSFER FLAG  **         
      **                         CORRECTLY.  ADD FROM NAME AND TO NAME*         
T17393**  10/29/98    CBSI       REMOVE MST/SUB ACCT COLUMN FROM THE **         
T17393**              MDS        REPORT. PRINT AN ADDITIONAL REPORT  **         
T17393**                         FOR RECORDS THAT DO NOT BELONG TO   **         
T17393**                         EITHER MASTER OR SUB ACCOUNTS       **         
T19276**  04/22/99    CBSI       REPLACE THE TWO SUMMARY REPORTS WITH**         
T19276**              MDS        THE DETAILED REPORTS I.E PRINT      **         
T19276**                         MULTIPLE ROWS FOR AN ACCOUNT        **         
T20408**  07/22/99    CBSI       SELECTING THE REPORT HEADER TITLE   **         
T20408**              MDS        FROM CSS_COMPANY INSTEAD OF THE HARD**         
T20408**                         CODED MESSAGE                       **         
T23875** 07/30/01     COVANSYS   CHANGE COMPANY HEADER TO ACCOMMODATE** 00191016
T23875**              CHENNAI    MULTI- COMPANY. ADDED COMPANY BREAK ** 00191016
T23875**                         LOGIC                               ** 00192000
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP101 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
      *                                                                         
T17393 COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
T17393 COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP101'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP101 STARTS HERE'.                  
      *                                                                         
      **   TABLE CSS_PENDING_XFER DEFINITION **                                 
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPENXFR                                                 
           END-EXEC.                                                            
                                                                        
      **   TABLE CSS_ACCOUNT DEFINITION **                                      
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *    INCLUDE TABLE CSS_JOB_PARM                                           
                                                                        
           EXEC SQL                                                     03190000
               INCLUDE TBJBPARM                                         03200000
           END-EXEC.                                                            
                                                                        
T17146****COPYBOOKS & DCLGENS FOR CPD00074                                      
                                                                        
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
       COPY CWS00010.                                                           
                                                                        
T17146******* TABLE DECLARATION FOR CSS_NAME *************************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_NAME_ACC_XREF ******************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_CUST_ADD_XREF ******************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_FREE_FRM_ADDR*****************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_ADDR_FORMATTED ***************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_ZIP_CODE   *****************            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_JOB_PARM      ******************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
T17146******************************************************************        
      *                                                                         
720408******* TABLE DECLARATION FOR CSS_COMPANY       ******************        
T20408     EXEC SQL                                                             
T20408         INCLUDE TBCOMPNY                                                 
T20408     END-EXEC.                                                            
T20408*                                                                         
       01  WS-MISC.                                                     
T23875*    05  WS-DEFAULT-COMP-NO             PIC X(02)    VALUE '01'.          
      *                                                                         
T17393*    05  WS-DEFAULT-RPT1-TITLE1  PIC X(31)    VALUE                       
T17393*                          'PENDING TRANSFERS REPORT'.                    
T17393     05  WS-DEFAULT-RPT1-TITLE1         PIC X(41)    VALUE        
T17393             'CONSOLIDATED BILL PENDING TRANSFER REPORT'.         
T17393     05  WS-DEFAULT-RPT2-TITLE1         PIC X(41)    VALUE        
T17393             '      PENDING TRANSFERS REPORT           '.         
T17393     05  WS-LINE-SPACE                  PIC 9(01)    VALUE ZERO.  
T17393     05  WS-RPT1-NAME                   PIC X(08)    VALUE        
T17393         'PCSR1011'.                                              
T17393     05  WS-RPT2-NAME                   PIC X(08)    VALUE        
T17393         'PCSR1012'.                                              
      *                                                                         
T17393     05  WS-CONSOLIDATED-REPORT         PIC X(01)    VALUE 'Y'.   
T17393         88 CONSOLIDATED-REPORT                      VALUE 'Y'.   
T17393         88 NON-CONSOLIDATED-REPORT                  VALUE 'N'.   
      *                                                                         
           05  WS-MORE-DATA-SW                PIC X(01)    VALUE 'Y'.   
               88  NO-MORE-DATA                            VALUE 'N'.   
      *                                                                         
T23875     05  WS-COMPANY-NOTSCEG             PIC X(01)    VALUE 'Y'.   
T23875         88  NOT-SCEG                                VALUE 'N'.   
T23875     05  WS-COMPANY-SCEG                PIC X(01)    VALUE 'Y'.   
T23875         88  NOT-SCEG-ONE                            VALUE 'N'.   
T23875     05  WS-COMPANY-FLAG                PIC X(01)    VALUE 'Y'.   
T23875         88  FIRST-TIME                              VALUE 'Y'.   
T23875         88  SECOND-TIME                             VALUE 'N'.   
T23875     05  WS-COMPANY-NAME-ONE            PIC X(01)    VALUE 'Y'.   
T23875         88  SCEG-FIRST-ONE                          VALUE 'Y'.   
T23875         88  SCEG-SECOND-ONE                         VALUE 'N'.   
T23875     05  WS-COMPANY-NAME-TWO            PIC X(01)    VALUE 'Y'.   
T23875         88  SCEG-FIRST-TWO                          VALUE 'Y'.   
T23875         88  SCEG-SECOND-TWO                         VALUE 'N'.   
T23875     05  WS-COMPANY-FLAG-TWO            PIC X(01)    VALUE 'Y'.   
T23875         88  THIRD-TIME                              VALUE 'N'.   
T23875     05  WS-COMPANY-PSNC-ONE            PIC X(01)    VALUE 'Y'.   
T23875         88 NO-PSNC                                  VALUE 'N'.   
T23875     05  WS-COMPANY-PSNC-TWO            PIC X(01)    VALUE 'Y'.   
T23875         88 NOT-PSNC                                 VALUE 'N'.   
      *                                                                         
T17146     05  RS-RETURN-CODE                 PIC S9(04) COMP.          
T17146     05  RS-RETURN-CODE-DISP            PIC +Z(04).               
T17146     05  PROGRAM-NAME                   PIC X(08).                
T17393     05  WS-FCA331-STATUS               PIC X(02).                
      ****** TO GET THE COMMON DATE                                             
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ****** FIOJC01, FIOCA00 REQUIRED FOR COMMON DATE PROCESSING               
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
                                                                        
       01  WS-AR-CNTRL-AC.                                              
           10  WS-AR-CNTRL-KEY-AC.                                      
COB305         15 WS-ACCOUNT-NO-AC        PIC S9(13)V COMP-3 VALUE 0.     
               15  WS-PYMT-PRIORITY-LVL-AC   PIC S9(04)     COMP.       
               15  WS-ITEM-ID-AC             PIC S9(09)     COMP.       
COB305     10 WS-AMT-AR-DAY-00-AC        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     10 WS-AMT-AR-DAY-30-AC        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     10 WS-AMT-AR-DAY-60-AC        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     10 WS-AMT-AR-DAY-90-AC        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     10 WS-AMT-UNUSED-CR-AC        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     10 WS-AMT-TRAN-BALANCE-AC        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.     
COB305     10 WS-TOT-SUMM-UNBILLED-AC        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.     
           10  WS-LAST-UPDATE-TS-AC          PIC X(26).                 
COB305     10 WS-TOT-NEW-CHRGS-CALC-AC        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.     
           10  WS-CURRENT-LT-25-DAYS-CALC-AC PIC X(1).                  
           10  WS-UPDATE-ACTION-IND-AC       PIC X(1).                  
           10  FILLER                        PIC X(411).                
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP101'.   
           05  WS-52                   PIC 9(02)    VALUE 52.           
T23875     05  WS-53                   PIC 9(02)    VALUE 53.           
           05  WS-62                   PIC 9(02)    VALUE 62.           
T17393     05  WS-M                    PIC X(01)    VALUE 'M'.          
T17393     05  WS-S                    PIC X(01)    VALUE 'S'.          
T17393     05  WS-ONE                  PIC 9(01)    VALUE 1.            
T17393     05  WS-TWO                  PIC 9(01)    VALUE 2.            
T17393     05  WS-EIGHT                PIC 9(01)    VALUE 8.            
T23875     05  WS-ONE-1                PIC X(02)    VALUE '01'.         
T23875     05  WS-26                   PIC X(02)    VALUE '26'.         
T17393*                                                                         
T17393 01  WS-RPT33-RECORD.                                             
T17393     05  WS-RPT33-CC             PIC X(01).                       
T17393     05  WS-RPT33-DATA           PIC X(132).                      
T17393*                                                                         
                                                                        
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
T17393******************************************************************        
T17393* CURSOR DECLARATION TO SELECT RECORDS THAT BELONG TO EITHER              
T17393* MASTER OR SUB ACCOUNTS                                                  
T17393******************************************************************        
T17393*                                                                         
           EXEC SQL                                                     
T17393         DECLARE CONS_PENDING_XFER CURSOR FOR                     
T17393         SELECT XP.ACCT_XFER_TO,                                  
T17393                XP.TABLE_ID,                                      
T17393                XP.SUB_ACCT_BLLD_OK,                              
T17393                XP.ACCT_XFER_FROM,                                
T17393                XP.XFER_DATA,                                     
T23875                AT.COMPANY_NO                                     
T17393           FROM CSS_PENDING_XFER XP,                              
T17393                CSS_ACCOUNT      AT                               
T17393          WHERE XP.TABLE_ID          = 2400                       
T17393            AND XP.ACCT_XFER_FROM    = AT.ACCOUNT_NO              
T17393            AND AT.MST_SUB_ACCT_IND IN (:WS-M, :WS-S)             
T23875         ORDER BY AT.COMPANY_NO ASC,                              
T17393                  XP.ACCT_XFER_TO, XP.ACCT_XFER_FROM,             
T17393                  XP.SUB_ACCT_BLLD_OK                             
           END-EXEC.                                                    
      *                                                                         
T17393******************************************************************        
T17393* CURSOR DECLARATION TO SELECT RECORDS THAT DO NOT BELONG TO    **        
T17393* EITHER  MASTER OR SUB ACCOUNTS                                **        
T17393******************************************************************        
T17393*                                                                         
           EXEC SQL                                                     
               DECLARE PENDING_XFER CURSOR FOR                          
T17393         SELECT XP.ACCT_XFER_TO,                                  
T17393                XP.TABLE_ID,                                      
T17393                XP.SUB_ACCT_BLLD_OK,                              
T17393                XP.ACCT_XFER_FROM,                                
T17393                XP.XFER_DATA,                                     
T23875                AT.COMPANY_NO                                     
T17393           FROM CSS_PENDING_XFER XP,                              
T17393                CSS_ACCOUNT      AT                               
T17393          WHERE XP.TABLE_ID              = 2400                   
T17393            AND XP.ACCT_XFER_FROM        = AT.ACCOUNT_NO          
T17393            AND AT.MST_SUB_ACCT_IND NOT IN (:WS-M, :WS-S)         
T23875         ORDER BY AT.COMPANY_NO ASC,                              
T17393                  XP.ACCT_XFER_TO, XP.ACCT_XFER_FROM,             
T17393                  XP.SUB_ACCT_BLLD_OK                             
           END-EXEC.                                                    
      *                                                                         
      ****************************************************************          
       01  WS-RPT1-LINE-NO             PIC 9(02)     VALUE 62   COMP-3. 
       01  WS-RPT1-PAGE-NO             PIC 9(02)     VALUE ZERO COMP-3. 
       01  WS-GRAND-TOTAL              PIC S9(10)V99 VALUE ZERO COMP-3. 
T17393 01  WS-COUNT                    PIC 9(4)      VALUE ZERO COMP-3. 
       01  WS-NO-OF-RECS-CNTR          PIC 9(04)     VALUE ZERO COMP-3. 
       01  WS-CURR-DATE                PIC X(10)     VALUE SPACES.      
T19276 01  WS-CUST-FROM-NAME           PIC X(35)     VALUE SPACES.      
T19276 01  WS-CUST-TO-NAME             PIC X(35)     VALUE SPACES.      
T19276 01  WS-TRANS-DESC               PIC X(04)     VALUE SPACES.      
T23875 01  WS-HOLD-COMPANY             PIC X(02)     VALUE SPACES.      
T23875 01  WS-COMPANY-NO               PIC X(02)     VALUE SPACES.      
T23875 01  WS-PREV-COMPANY             PIC X(02)     VALUE SPACES.      
       01  WS-HOLD-VARIABLES.                                           
           10  WS-TO-ACCOUNT-HOLD          PIC 9(13) VALUE ZEROES.      
           10  WS-FROM-ACCOUNT-HOLD        PIC 9(13) VALUE ZEROES.      
           10  WS-XFER-FLAG-HOLD           PIC X(1)  VALUE SPACES.      
                                                                        
      ****************************************************************          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
      *                                                                         
      ***************** PCSRP101 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT TITLE           **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  FILLER              PIC X        VALUE SPACE.        
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(42)    VALUE SPACES.       
T20408*        10  P-RPT1-COMP-NAME    PIC X(29)    VALUE                       
T20408*        'SOUTH CAROLINA ELECTRIC & GAS'.                                 
T20408         10  P-RPT1-COMP-NAME    PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT HEADER1         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
T17393         10  P-RPT1-HEAD1        PIC X(41).                       
T17393         10  FILLER              PIC X(26)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X        VALUE SPACE.        
               10  FILLER              PIC X(55)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   '              '.    
               10  P-RPT1-DATE1        PIC X(08)    VALUE SPACES.       
               10  FILLER              PIC X(41)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZZ.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'FROM '.      
               10  FILLER              PIC X(13)    VALUE SPACES.       
T17146         10  FILLER              PIC X(09)    VALUE 'FROM NAME'.  
T17393         10  FILLER              PIC X(32)    VALUE SPACES.       
               10  FILLER              PIC X(02)    VALUE 'TO'.         
               10  FILLER              PIC X(11)    VALUE SPACES.       
T17146         10  FILLER              PIC X(07)    VALUE 'TO NAME'.    
T17393         10  FILLER              PIC X(28)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'TRANSFER'.   
T17393         10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE 'TRANSFER '.  
      *                                                                         
           05  WS-RPT1-HEADER-32.                                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'ACCOUNT '.   
T17393         10  FILLER              PIC X(50)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE 'ACCOUNT'.    
T17393         10  FILLER              PIC X(36)    VALUE SPACES.       
T17393         10  FILLER              PIC X(08)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'FLAG'.       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE 'AMT '.       
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **        WORKING STORAGE FOR REPORT DETAIL LINES             **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-DETAIL-LINE-1.                                        
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-FROM-ACCOUNT      PIC 9(13).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
T17393         10  P-FROM-NAME         PIC X(35).                       
T17146         10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-TO-ACCOUNT        PIC 9(13).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
T17393         10  P-TO-NAME           PIC X(35).                       
T17393         10  FILLER              PIC X(04)    VALUE SPACES.       
               10  P-TRANS-DESC        PIC X(04).                       
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  P-TRANS-AMT         PIC ZZ,ZZZ,ZZZ.99.               
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE-2.                                        
T17393         10  FILLER              PIC X(55)    VALUE SPACES.       
T17393         10  FILLER              PIC X(05)    VALUE               
T17393                                 'TOTAL'.                         
               10  FILLER              PIC X(04)    VALUE SPACES.       
T17393         10  P-COUNT             PIC ZZ9.                         
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  P-GRAND-TOTAL       PIC ZZZ,ZZZ,ZZZ.99.              
T17393         10  FILLER              PIC X(44)    VALUE SPACES.       
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP101 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-CONSOLIDATED-REPORT      THRU 1000-EXIT         
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
           IF WS-NO-OF-RECS-CNTR NOT EQUAL ZERO                         
T23875       IF NOT NO-PSNC                                             
T23875          PERFORM 8910-END-TOTAL-DETAILS   THRU 8910-EXIT         
T23875          WRITE PRT33-RECORD FROM WS-END-DATA-LINE                
T23875                    AFTER ADVANCING 2 LINES                       
T23875          MOVE WS-26                       TO  WS-COMPANY-NO      
T23875          PERFORM 7400-SELECT-COMP-DESC THRU 7400-EXIT            
T23875          PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT            
T23875          PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT            
T23875          WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                 
T23875                 AFTER ADVANCING 3 LINES                          
T23875       END-IF                                                     
T23875      END-IF                                                      
      *                                                                         
           IF WS-NO-OF-RECS-CNTR EQUAL ZERO                             
T23875        MOVE WS-ONE-1                 TO  WS-COMPANY-NO           
T23875        PERFORM 7400-SELECT-COMP-DESC THRU 7400-EXIT              
              PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT              
              PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT              
              WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                   
                     AFTER ADVANCING 3 LINES                            
T23875        MOVE WS-26                    TO  WS-COMPANY-NO           
T23875        PERFORM 7400-SELECT-COMP-DESC THRU 7400-EXIT              
T23875        PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT              
T23875        PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT              
T23875        WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                   
T23875               AFTER ADVANCING 3 LINES                            
T17393        PERFORM 7300-CLOSE-PENDING-XFER-CURSOR                    
T17393                                      THRU 7300-EXIT              
           ELSE                                                         
T17393        PERFORM 7300-CLOSE-PENDING-XFER-CURSOR                    
T17393                                      THRU 7300-EXIT              
             IF WS-RPT1-LINE-NO GREATER THAN WS-52                      
               PERFORM 8200-PRINT-TITLE     THRU 8200-EXIT              
               PERFORM 8300-PRINT-HEADERS   THRU 8300-EXIT              
             END-IF                                                     
T23875       IF NO-PSNC                                                 
              PERFORM 8910-END-TOTAL-DETAILS THRU 8910-EXIT             
              WRITE PRT33-RECORD FROM WS-END-DATA-LINE                  
                     AFTER ADVANCING 2 LINES                            
T23875       END-IF                                                     
           END-IF.                                                      
      *                                                                         
T17393     PERFORM 1100-PENDING-XFER-REPORT THRU 1100-EXIT.             
      *                                                                         
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
T23875*    MOVE WS-DEFAULT-COMP-NO     TO C7-COMPANY-NO.                        
T23875*    PERFORM 7400-SELECT-COMP-DESC                                        
T23875*                                THRU 7400-EXIT.                          
T23875*    MOVE C7-COMPANY-NAME        TO P-RPT1-COMP-NAME.                     
T20408*                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE             TO WS-CURR-DATE.              
           MOVE WS-CURR-DATE              TO WS-DATE-10.                
           MOVE WS-D10-MM                 TO WS-D8-MM.                  
           MOVE WS-D10-DD                 TO WS-D8-DD.                  
           MOVE WS-D10-YY                 TO WS-D8-YY.                  
           MOVE WS-DATE-8                 TO P-RPT1-DATE.               
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
T17393                 FCSPT331-FILE.                                   
                                                                        
           PERFORM 7100-OPEN-PENDING-XFER-CURSOR  THRU 7100-EXIT.       
           PERFORM 7200-FETCH-PENDING-XFER-CURSOR THRU 7200-EXIT.       
      *                                                                         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-CONSOLIDATED-REPORT                                 **          
      **       PROCESSES THE RECORDS FETCHED FROM THE CURSOR        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-CONSOLIDATED-REPORT.                                        
      *                                                                         
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
T23875     PERFORM 1500-GET-COMPANY-NAME       THRU 1500-EXIT           
                                                                        
           IF WS-RPT1-LINE-NO GREATER THAN WS-52                        
               PERFORM 8200-PRINT-TITLE        THRU 8200-EXIT           
               PERFORM 8300-PRINT-HEADERS      THRU 8300-EXIT           
           END-IF.                                                      
T19276     PERFORM 2000-PRODUCE-RPT            THRU 2000-EXIT           
                                                                        
                                                                        
      *                                                                         
           PERFORM 7200-FETCH-PENDING-XFER-CURSOR                       
                                               THRU 7200-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
T17393******************************************************************        
T17393* INITIALIZES THE REPORT VARIABLES AND FETCHES ALL THE RECORDS            
T17393* THAT DO NOT BELONG TO MASTER OR SUB ACCOUNTS, PRINTS THESE              
T17393* RECORDS UNTIL SQLCODE NOT FOUND AND AT THE END PRINTS THE GRAND         
T17393* TOTALS                                                                  
T17393******************************************************************        
T17393*                                                                         
T17393 1100-PENDING-XFER-REPORT.                                        
T17393*                                                                         
T17393     MOVE 62                             TO WS-RPT1-LINE-NO.      
T17393     MOVE ZEROS                          TO WS-RPT1-PAGE-NO       
T17393                                            WS-GRAND-TOTAL        
T17393                                            WS-COUNT.             
           MOVE SPACES                         TO WS-HOLD-COMPANY.      
T17393                                                                  
T17393     PERFORM 7000-OPEN-PX-CURSOR         THRU 7000-EXIT.          
T17393     PERFORM 7010-FETCH-PX-CURSOR        THRU 7010-EXIT.          
T17393*                                                                         
T17393     IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
T23875         MOVE WS-ONE-1                   TO WS-COMPANY-NO         
T23875         PERFORM 7400-SELECT-COMP-DESC   THRU 7400-EXIT           
T17393         PERFORM 8400-PRT-RPT2-HEADINGS  THRU 8400-EXIT           
T17393         MOVE WS-NO-DATA-LINE            TO WS-RPT33-DATA         
T17393         PERFORM 8800-WRITE-REPORT2      THRU 8800-EXIT           
T23875         MOVE WS-26                      TO WS-COMPANY-NO         
T23875         PERFORM 7400-SELECT-COMP-DESC   THRU 7400-EXIT           
T23875         PERFORM 8400-PRT-RPT2-HEADINGS  THRU 8400-EXIT           
T23875         MOVE WS-NO-DATA-LINE            TO WS-RPT33-DATA         
T23875         PERFORM 8800-WRITE-REPORT2      THRU 8800-EXIT           
T17393         PERFORM 7020-CLOSE-PX-CURSOR    THRU 7020-EXIT           
T17393         GO                              TO 1100-EXIT             
T17393     ELSE                                                         
T17393         SET NON-CONSOLIDATED-REPORT     TO TRUE                  
T17393     END-IF.                                                      
T17393*                                                                         
T17393     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T17393*                                                                         
T17393         IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
T23875           IF SCEG-FIRST-ONE                                      
T23875             IF AT-COMPANY-NO    NOT EQUAL  WS-ONE-1              
T23875               MOVE WS-ONE-1             TO WS-COMPANY-NO         
T23875               PERFORM 7400-SELECT-COMP-DESC                      
T23875                                         THRU 7400-EXIT           
T23875               PERFORM 8400-PRT-RPT2-HEADINGS                     
T23875                                         THRU 8400-EXIT           
T23875               MOVE WS-NO-DATA-LINE      TO WS-RPT33-DATA         
T23875               PERFORM 8800-WRITE-REPORT2                         
T23875                                         THRU 8800-EXIT           
T23875               SET NOT-SCEG-ONE          TO TRUE                  
T23875             ELSE                                                 
T23875               MOVE AT-COMPANY-NO        TO WS-COMPANY-NO         
T23875                                            WS-HOLD-COMPANY       
T23875               PERFORM 7400-SELECT-COMP-DESC                      
T23875                                         THRU 7400-EXIT           
T23875               PERFORM 8400-PRT-RPT2-HEADINGS                     
T23875                                         THRU 8400-EXIT           
T23875             END-IF                                               
T23875             SET SCEG-SECOND-ONE         TO TRUE                  
T23875           END-IF                                                 
T23875*                                                                         
T23875           IF AT-COMPANY-NO     NOT EQUAL WS-HOLD-COMPANY         
T17393                MOVE WS-53               TO WS-RPT1-LINE-NO       
T23875           END-IF                                                 
T17393           IF  WS-RPT1-LINE-NO GREATER THAN WS-52                 
T23875              IF NOT NOT-SCEG-ONE                                 
T23875                MOVE WS-COUNT            TO P-COUNT               
T23875                MOVE WS-GRAND-TOTAL      TO P-GRAND-TOTAL         
T23875                MOVE WS-DETAIL-LINE-2    TO WS-RPT33-DATA         
T17393                MOVE WS-RPT33-RECORD     TO PRT331-RECORD         
T23875                WRITE PRT331-RECORD  AFTER                        
T23875                                      ADVANCING WS-LINE-SPACE     
T23875                MOVE ZEROES              TO WS-COUNT              
T23875                                           WS-GRAND-TOTAL         
T23875              END-IF                                              
T23875               MOVE AT-COMPANY-NO        TO WS-COMPANY-NO         
T23875                                            WS-HOLD-COMPANY       
T23875               PERFORM 7400-SELECT-COMP-DESC                      
T23875                                         THRU 7400-EXIT           
T17393               PERFORM 8400-PRT-RPT2-HEADINGS                     
T17393                                         THRU 8400-EXIT           
T23875               SET NOT-PSNC              TO TRUE                  
T17393           ELSE                                                   
T17393               MOVE WS-ONE               TO WS-LINE-SPACE         
T17393               ADD  WS-ONE               TO WS-RPT1-LINE-NO       
T17393           END-IF                                                 
T17393           PERFORM 2000-PRODUCE-RPT      THRU 2000-EXIT           
T17393         END-IF                                                   
T17393*                                                                         
T17393         PERFORM 7010-FETCH-PX-CURSOR    THRU 7010-EXIT           
T17393     END-PERFORM.                                                 
T17393*                                                                         
T23875     IF NOT NOT-PSNC                                              
T23875         MOVE WS-COUNT                   TO P-COUNT               
T23875         MOVE WS-GRAND-TOTAL             TO P-GRAND-TOTAL         
T23875         MOVE WS-DETAIL-LINE-2           TO WS-RPT33-DATA         
T17393         MOVE WS-RPT33-RECORD            TO PRT331-RECORD         
T23875         WRITE PRT331-RECORD  AFTER                               
T23875                                  ADVANCING WS-LINE-SPACE         
T23875         MOVE ZEROES                     TO WS-COUNT              
T23875                                            WS-GRAND-TOTAL        
T23875         MOVE WS-26                      TO WS-COMPANY-NO         
T23875         PERFORM 7400-SELECT-COMP-DESC   THRU 7400-EXIT           
T23875         PERFORM 8400-PRT-RPT2-HEADINGS  THRU 8400-EXIT           
T23875         MOVE WS-NO-DATA-LINE            TO WS-RPT33-DATA         
T23875         PERFORM 8800-WRITE-REPORT2      THRU 8800-EXIT           
T23875     END-IF.                                                      
T17393*                                                                         
T17393     PERFORM 7020-CLOSE-PX-CURSOR        THRU 7020-EXIT.          
T17393*                                                                         
T23875     IF NOT-PSNC                                                  
T17393       MOVE WS-BLANK-LINE                TO WS-RPT33-DATA         
T17393       PERFORM 8800-WRITE-REPORT2        THRU 8800-EXIT           
T17393       MOVE WS-COUNT                     TO P-COUNT               
T17393       MOVE WS-GRAND-TOTAL               TO P-GRAND-TOTAL         
T17393       MOVE WS-DETAIL-LINE-2             TO WS-RPT33-DATA         
T17393       MOVE WS-TWO                       TO WS-LINE-SPACE         
T17393       PERFORM 8800-WRITE-REPORT2        THRU 8800-EXIT           
T17393       MOVE WS-END-DATA-LINE             TO WS-RPT33-DATA         
T17393       PERFORM 8800-WRITE-REPORT2        THRU 8800-EXIT           
T23875     END-IF.                                                      
T17393*                                                                         
T17393 1100-EXIT.                                                       
T17393     EXIT.                                                        
T17393*                                                                         
T23875************************************************************              
T23875**1500-GET-COMPANY-NAME*                                                  
T23875************************************************************              
T23875 1500-GET-COMPANY-NAME.                                           
T23875*                                                                         
T23875     IF FIRST-TIME                                                
T23875        IF AT-COMPANY-NO NOT EQUAL  WS-ONE-1                      
T23875            MOVE WS-ONE-1                 TO WS-COMPANY-NO        
T23875            PERFORM 7400-SELECT-COMP-DESC THRU 7400-EXIT          
T23875            PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT          
T23875            PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT          
T23875            WRITE PRT33-RECORD FROM WS-NO-DATA-LINE               
T23875                               AFTER ADVANCING 3 LINES            
T23875            SET  NOT-SCEG                 TO TRUE                 
T23875        ELSE                                                      
T23875            MOVE AT-COMPANY-NO            TO WS-COMPANY-NO        
T23875                                             WS-HOLD-COMPANY      
T23875            PERFORM 7400-SELECT-COMP-DESC THRU 7400-EXIT          
T23875            PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT          
T23875            PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT          
T23875        END-IF                                                    
T23875        SET SECOND-TIME                   TO TRUE                 
T23875     END-IF                                                       
T23875       IF NOT NOT-SCEG                                            
T23875         IF AT-COMPANY-NO   NOT EQUAL WS-HOLD-COMPANY             
T23875          PERFORM 8910-END-TOTAL-DETAILS  THRU 8910-EXIT          
T23875          WRITE PRT33-RECORD FROM WS-END-DATA-LINE                
T23875               AFTER ADVANCING 2 LINES                            
T23875          INITIALIZE   WS-RPT1-LINE-NO                            
T23875         END-IF                                                   
T23875       END-IF                                                     
T23875        IF AT-COMPANY-NO   NOT EQUAL WS-HOLD-COMPANY              
T23875          MOVE AT-COMPANY-NO              TO WS-COMPANY-NO        
T23875                                             WS-HOLD-COMPANY      
T23875          PERFORM 7400-SELECT-COMP-DESC   THRU 7400-EXIT          
T23875          PERFORM 8200-PRINT-TITLE        THRU 8200-EXIT          
T23875          PERFORM 8300-PRINT-HEADERS      THRU 8300-EXIT          
T23875          SET    NO-PSNC                  TO TRUE                 
T23875        END-IF.                                                   
T23875                                                                  
T23875 1500-EXIT.                                                       
T23875     EXIT.                                                        
T23875*                                                                         
      ****************************************************************          
      **                                                            **          
      **   2000-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2000-PRODUCE-RPT.                                                
      *                                                                         
           MOVE '2000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T19276     MOVE XP-ACCT-XFER-TO              TO P-TO-ACCOUNT.           
T19276     MOVE XP-ACCT-XFER-FROM            TO P-FROM-ACCOUNT.         
                                                                        
T16362*    MOVE XP-SUB-ACCT-BLLD-OK   TO P-ACCT-FLAG.                           
                                                                        
T19276     MOVE XP-XFER-DATA-TEXT            TO WS-AR-CNTRL-AC.         
T19276     MOVE WS-TOT-SUMM-UNBILLED-AC      TO P-TRANS-AMT.            
T19276     ADD  WS-TOT-SUMM-UNBILLED-AC      TO WS-GRAND-TOTAL.         
T17393     ADD WS-ONE                        TO WS-COUNT                
                                                                        
                                                                        
T19276     IF  XP-ACCT-XFER-TO      = WS-TO-ACCOUNT-HOLD AND            
T19276         XP-ACCT-XFER-FROM    = WS-FROM-ACCOUNT-HOLD AND          
T19276         XP-SUB-ACCT-BLLD-OK  = WS-XFER-FLAG-HOLD                 
T19276         MOVE WS-CUST-FROM-NAME TO P-FROM-NAME                    
T19276         MOVE WS-CUST-TO-NAME   TO P-TO-NAME                      
T19276         MOVE WS-TRANS-DESC     TO P-TRANS-DESC                   
           ELSE                                                         
T19276         MOVE XP-ACCT-XFER-FROM TO  AT-ACCOUNT-NO                 
T17146         SET WS-NAME-ONLY       TO  TRUE                          
T17146         PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT            
T17146         MOVE WS-CUSTOMER-NAME  TO  P-FROM-NAME                   
T19276                                    WS-CUST-FROM-NAME             
T19276         MOVE XP-ACCT-XFER-TO   TO  AT-ACCOUNT-NO                 
T17146         SET WS-NAME-ONLY       TO  TRUE                          
T17146         PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT            
T17146         MOVE WS-CUSTOMER-NAME  TO  P-TO-NAME                     
T19276                                    WS-CUST-TO-NAME               
T19276         EVALUATE  XP-SUB-ACCT-BLLD-OK                            
T19276             WHEN 'T'                                             
T17146                  MOVE 'XFR'    TO P-TRANS-DESC                   
T19276                                   WS-TRANS-DESC                  
T19276             WHEN 'Y'                                             
T17146                  MOVE 'YES'    TO P-TRANS-DESC                   
T19276                                   WS-TRANS-DESC                  
T19276             WHEN 'N'                                             
T17146                  MOVE ' NO '   TO P-TRANS-DESC                   
T19276                                   WS-TRANS-DESC                  
T19276             WHEN 'S'                                             
T17146                  MOVE 'SUSP'   TO P-TRANS-DESC                   
T19276                                   WS-TRANS-DESC                  
T19276         END-EVALUATE                                             
T19276*                                                                         
T19276         MOVE XP-ACCT-XFER-TO   TO  WS-TO-ACCOUNT-HOLD            
T19276         MOVE XP-ACCT-XFER-FROM TO  WS-FROM-ACCOUNT-HOLD          
T19276         MOVE XP-SUB-ACCT-BLLD-OK                                 
T19276                                TO  WS-XFER-FLAG-HOLD             
T19276     END-IF.                                                      
      *                                                                         
T17393     IF  CONSOLIDATED-REPORT                                      
               PERFORM 8900-PRINT-DETAIL-LINE                           
                                      THRU 8900-EXIT                    
T17393     ELSE                                                         
T17393         MOVE WS-DETAIL-LINE-1  TO WS-RPT33-DATA                  
T17393         PERFORM 8800-WRITE-REPORT2                               
T17393                                THRU 8800-EXIT                    
T17393     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
T17393**   7000-OPEN-PX-CURSOR                                      **          
T17393**       OPENS THE PENDING TRANSFER CURSOR AND TESTS FOR SQL  **          
T17393**       CODE SUCCESSFUL OR NOT.                              **          
T17393****************************************************************          
T17393*                                                                         
T17393 7000-OPEN-PX-CURSOR.                                             
T17393*                                                                         
T17393     MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
T17393*                                                                         
T17393     EXEC SQL                                                     
T17393          OPEN PENDING_XFER                                       
T17393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17393*                                                                         
T17393     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
T17393     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T17393         CONTINUE                                                 
T17393     ELSE                                                         
T17393         DISPLAY 'SELECT IN 7000-OPEN-PX-CURSOR'                  
T17393         DISPLAY '**  SQL RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
T17393         PERFORM 9900-ABEND     THRU 9900-EXIT                    
T17393     END-IF.                                                      
T17393*                                                                         
T17393 7000-EXIT.                                                       
T17393     EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
T17393**   7010-FETCH-PX-CURSOR                                     **          
T17393**      FETCHS THE DETAILS FROM THE PENDING TRANSFER CURSOR.  **          
T17393**                                                            **          
T17393****************************************************************          
T17393*                                                                         
T17393 7010-FETCH-PX-CURSOR.                                            
T17393*                                                                         
T17393     MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
T17393*                                                                         
T17393     EXEC SQL                                                     
T17393          FETCH PENDING_XFER                                      
T17393           INTO :XP-ACCT-XFER-TO,                                 
T17393                :XP-TABLE-ID,                                     
T17393                :XP-SUB-ACCT-BLLD-OK,                             
T17393                :XP-ACCT-XFER-FROM,                               
T17393                :XP-XFER-DATA,                                    
T23875                :AT-COMPANY-NO                                    
T17393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17393*                                                                         
T17393     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
T17393     IF  WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR          
                                             NOT-FOUND                  
T17393         CONTINUE                                                 
T17393     ELSE                                                         
T17393          DISPLAY '**FETCH ERROR IN 7010-FETCH-PX-CURSOR    **'   
T17393          DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
T17393          DISPLAY '**        PROCESSING TERMINATED          **'   
T17393          PERFORM 9900-ABEND            THRU 9900-EXIT            
T17393     END-IF.                                                      
T17393*                                                                         
T17393 7010-EXIT.                                                       
T17393     EXIT.                                                        
T17393*                                                                         
T17393****************************************************************          
T17393**                                                            **          
T17393**   7020-CLOSE-PX-CURSOR                                     **          
T17393**       CLOSES THE PENDING TRANSFER CURSOR AND TESTS FOR SQL **          
T17393**       CODE SUCCESSFUL OR NOT.                              **          
T17393****************************************************************          
T17393 7020-CLOSE-PX-CURSOR.                                            
T17393*                                                                         
T17393     MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
T17393*                                                                         
T17393     EXEC SQL                                                     
T17393          CLOSE PENDING_XFER                                      
T17393     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17393*                                                                         
T17393     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T17393     IF  WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL             
T17393         CONTINUE                                                 
T17393     ELSE                                                         
T17393         DISPLAY 'CLOSE CSR IN 7020-CLOSE-PX-CURSOR   '           
T17393         DISPLAY '**  SQL RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
T17393         PERFORM 9900-ABEND                THRU 9900-EXIT         
T17393     END-IF.                                                      
T17393*                                                                         
T17393 7020-EXIT.                                                       
T17393     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-OPEN-PENDING-XFER-CURSOR                            **          
      **       OPENS THE CONSOLIDATED PENDING TRANSFER CURSOR AND   **          
      **       TESTS FOR SQLCODE SUCCESSFUL OR NOT.                 **          
      ****************************************************************          
      *                                                                         
       7100-OPEN-PENDING-XFER-CURSOR.                                   
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
T17393          OPEN CONS_PENDING_XFER                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY 'SELECT IN 7100-OPEN-PENDING-XFER-CURSOR '       
               DISPLAY '**    SQL RETURN CODE = ' SQLCODE               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7200-FETCH-PENDING-XFER-CURSOR                           **          
      **      FETCHS THE DETAILS FROM THE CONSOLIDATED PENDING      **          
      **      TRANSFER CURSOR                                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7200-FETCH-PENDING-XFER-CURSOR.                                  
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE ZEROES TO XP-ACCT-XFER-TO,                              
                          XP-ACCT-XFER-FROM,                            
                          XP-TABLE-ID.                                  
           MOVE SPACES TO XP-SUB-ACCT-BLLD-OK,                          
                          XP-XFER-DATA.                                 
           EXEC SQL                                                     
T17393          FETCH CONS_PENDING_XFER                                 
                 INTO :XP-ACCT-XFER-TO,                                 
                      :XP-TABLE-ID,                                     
                      :XP-SUB-ACCT-BLLD-OK,                             
                      :XP-ACCT-XFER-FROM,                               
                      :XP-XFER-DATA,                                    
                      :AT-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 ADD 1 TO WS-NO-OF-RECS-CNTR                            
              WHEN NOT-FOUND                                            
                 SET NO-MORE-DATA TO TRUE                               
T23875           MOVE SPACES      TO WS-HOLD-COMPANY                    
              WHEN OTHER                                                
                 DISPLAY '**FETCH ERROR IN 7200-FETCH-PENDING-CURSOR**' 
                 DISPLAY '**        RETURN CODE = ' SQLCODE             
                 DISPLAY '**        PROCESSING TERMINATED          **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7300-CLOSE-PENDING-XFER-CURSOR                           **          
      **       CLOSES THE CONSOLIDATED PENDING TRANSFER CURSOR      **          
      **       AND TESTS FOR SQLCODE SUCCESSFUL OR NOT.             **          
      ****************************************************************          
       7300-CLOSE-PENDING-XFER-CURSOR.                                  
      *                                                                         
           MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
T17393          CLOSE CONS_PENDING_XFER                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY 'CLOSE CSR IN 7300-CLOSE-PENDING-XFER-CURSOR '   
               DISPLAY '**    SQL RETURN CODE = ' SQLCODE               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T20408****************************************************************          
T20408**                                                            **          
T20408**      7400-SELECT-COMP-DESC                                 **          
T20408**      SELECTS THE COMPANY DESCRIPTION FROM CSS_COMPANY      **          
T20408**                                                            **          
T20408****************************************************************          
T20408*                                                                         
T20408 7400-SELECT-COMP-DESC.                                           
T20408*                                                                         
T20408     MOVE '7400'                      TO WS-ACTIVE-PARAGRAPH.     
T20408*                                                                         
T23875     MOVE WS-COMPANY-NO               TO C7-COMPANY-NO.           
T20408     EXEC SQL                                                     
T20408         SELECT   COMPANY_NAME                                    
T20408           INTO  :C7-COMPANY-NAME                                 
T20408           FROM   CSS_COMPANY                                     
T20408          WHERE   COMPANY_NO   = :C7-COMPANY-NO                   
T23875*         WHERE   COMPANY_NO   = :WS-HOLD-COMPANY                         
T20408     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20408*                                                                         
T20408     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T23875           MOVE C7-COMPANY-NAME       TO P-RPT1-COMP-NAME         
T20408     ELSE                                                         
T20408         IF  SQLCODE EQUAL NOT-FOUND                              
T20408             DISPLAY '*********** PCSRP101 **********************'
T20408             DISPLAY '*  COMPANY DESCRIPTION NOT FOUND          *'
T20408             DISPLAY '* FOR COMPANY NO *' C7-COMPANY-NO           
T20408             DISPLAY '* SPACES MOVED FOR COMPANY DESC           *'
T20408             DISPLAY '*********** PCSRP101 **********************'
T20408             MOVE SPACES                   TO C7-COMPANY-NAME     
T20408         ELSE                                                     
T20408             DISPLAY '*********** PCSRP101 **********************'
T20408             DISPLAY '** SELECT ERROR IN 7400-SELECT-COMP-DESC **'
T20408             DISPLAY '** RETURN CODE = ' SQLCODE                  
T20408             DISPLAY '** PROCESSING TERMINATED                 **'
T20408             DISPLAY '*********** PCSRP101 **********************'
T20408             PERFORM 9900-ABEND            THRU 9900-EXIT         
T20408         END-IF                                                   
T20408     END-IF.                                                      
T20408*                                                                         
T20408 7400-EXIT.                                                       
T20408     EXIT.                                                        
      *                                                                         
      ****** CPD00037 CALLS DATE ROUTINES                                       
       COPY CPD00037.                                                           
      ****** CPD00040 CALLS DATE ROUTINES                                       
       COPY CPD00040.                                                           
                                                                        
      * TO GET TODAY'S DATE FROM JOB PARM TABLE                                 
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
                                                                        
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE FOR THE REPORT PCSRP101             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           ADD 1                       TO WS-RPT1-PAGE-NO.              
T17393     MOVE WS-RPT1-NAME           TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                AFTER ADVANCING PAGE.                                   
                                                                        
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-HEADERS                                       **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
           MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-31                    
                AFTER ADVANCING 3 LINES.                                
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-32                    
                AFTER ADVANCING 1 LINES.                                
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 6                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T17393******************************************************************        
T17393* PRINTS PAGE HEADINGS ON THE FCSPT331 REPORT FILE                        
T17393******************************************************************        
T17393*                                                                         
T17393 8400-PRT-RPT2-HEADINGS.                                          
T17393     MOVE 0                              TO WS-RPT1-LINE-NO.      
T17393     ADD WS-ONE                          TO WS-RPT1-PAGE-NO.      
T17393     MOVE WS-RPT2-NAME                   TO P-RPT1-TITLE-PGNM.    
T17393     MOVE WS-RPT1-TITLE                  TO WS-RPT33-DATA.        
T17393     MOVE WS-RPT33-RECORD                TO PRT331-RECORD.        
T17393     WRITE PRT331-RECORD  AFTER ADVANCING PAGE.                   
T17393     MOVE WS-DEFAULT-RPT2-TITLE1         TO P-RPT1-HEAD1.         
T17393     MOVE WS-RPT1-HEADER-1               TO WS-RPT33-DATA.        
T17393     MOVE WS-ONE                         TO WS-LINE-SPACE.        
T17393     PERFORM 8800-WRITE-REPORT2          THRU 8800-EXIT.          
T17393     MOVE WS-RPT1-PAGE-NO                TO P-RPT1-PAGE-NO.       
T17393     MOVE WS-RPT1-HEADER-2               TO WS-RPT33-DATA.        
T17393     PERFORM 8800-WRITE-REPORT2          THRU 8800-EXIT.          
T17393     MOVE WS-RPT1-HEADER-31              TO WS-RPT33-DATA.        
T17393     MOVE WS-TWO                         TO WS-LINE-SPACE.        
T17393     PERFORM 8800-WRITE-REPORT2          THRU 8800-EXIT.          
T17393     MOVE WS-RPT1-HEADER-32              TO WS-RPT33-DATA.        
T17393     MOVE WS-ONE                         TO WS-LINE-SPACE.        
T17393     PERFORM 8800-WRITE-REPORT2          THRU 8800-EXIT.          
T17393     MOVE WS-TWO                         TO WS-LINE-SPACE.        
T17393     ADD  WS-EIGHT                       TO WS-RPT1-LINE-NO.      
T17393*                                                                         
T17393 8400-EXIT.                                                       
T17393     EXIT.                                                        
T17393*                                                                         
T17393****************************************************************          
T17393* PRINTS THE DETAIL LINE OF THE FCSPT331   REPORT FILE        **          
T17393****************************************************************          
T17393*                                                                         
T17393 8800-WRITE-REPORT2.                                              
T17393     MOVE WS-RPT33-RECORD                TO PRT331-RECORD.        
T17393     WRITE PRT331-RECORD  AFTER ADVANCING WS-LINE-SPACE.          
T17393*                                                                         
T17393 8800-EXIT.                                                       
T17393     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE FCSPT33 REPORT FILE    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           MOVE '8900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-1                     
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           ADD 1                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8910-END-TOTAL-DETAILS.                                  **          
T17393**     PRINTS THE DETAILS OF TOATLS AT THE END OF REPORT      **          
      ****************************************************************          
      *                                                                         
       8910-END-TOTAL-DETAILS.                                          
      *                                                                         
           MOVE '8910' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                AFTER ADVANCING 1 LINE.                                 
T17393     MOVE WS-COUNT         TO P-COUNT.                            
           MOVE WS-GRAND-TOTAL   TO P-GRAND-TOTAL.                      
           WRITE PRT33-RECORD FROM WS-DETAIL-LINE-2                     
                AFTER ADVANCING 2 LINE.                                 
      *                                                                         
T23875         INITIALIZE WS-GRAND-TOTAL                                
T23875                    WS-COUNT                                      
           ADD 2                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           CLOSE FCSPT33-FILE                                           
T17393           FCSPT331-FILE.                                         
                                                                        
           STOP RUN.                                                    
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9900-ABEND                                               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  COPYBOOK CONTAINING STANDARD ADDRESS RETRIEVAL LOGIC          *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00074                                             
              END-EXEC.                                                         
      *                                                                         
      ******************************************************************        
      *  COPYBOOK CONTAINING COMMON ABEND FORMATTING ROUTINE           *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD0023B                                             
              END-EXEC.                                                         
      *                                                                         
      ******************************************************************        
      *  COPYBOOK CONTAINING ADDRESS FORMATTING ROUTINE                *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00004                                             
              END-EXEC.                                                         
