       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP100.                                        
       DATE-WRITTEN.   10/09/01.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         SRIDEVI                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                        COVANSYS INC.                        **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      **                                                             **         
M25067** 10/09/01   AS            DEVELOPMENT OF NEW REPORT PROGRAM  **         
C25067** 01/10/02   SFH           MODIFIED TO SORT MONEY DESCENDING  **         
      **                          AND TO DISPLAY ALL MONEY BUCKETS.  **         
C25067** 01/28/02   MDJ           MODIFIED TO ALSO SHOW 0-DAY MONEY. **         
T35434** 04/05/07   COVANSYS      REPLACED MODEL_SQL WITH SET        **         
T35434**                          STATEMENT AND ADDED WITH UR FOR    **         
T35434**                          -911                               **         
      *****************************************************************         
      *                   PCSRP100   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM GETS ALL THE ACCOUNTS THAT HAVE 30 DAY, 60 DAY,  *         
      * 90 DAY ARREARS ALONG WITH THE NAME AND PHONE NUMBER.          *         
      * THIS PROGRAM IS RUN EVERY DAY AFTER BILLING.                  *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     INPUT MODULES                           
                9900 - 9999     ABEND/ABORT MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP100'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-1                             PIC 9(01)  VALUE 1.      
           05 WS-2                             PIC 9(01)  VALUE 2.      
           05 WS-5                             PIC 9(01)  VALUE 5.      
           05 WS-56                            PIC 9(02)  VALUE 56.     
           05 WS-57                            PIC 9(02)  VALUE 57.     
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-PGRMNAME                      PIC X(08)  VALUE         
              'PCSRP100'.                                               
           05 WS-NSC                           PIC S9(04) VALUE +19.    
           05 WS-NSA                           PIC S9(04) VALUE +20.    
           05 WS-NSN                           PIC S9(04) VALUE +29.    
           05 WS-LPC                           PIC S9(04) VALUE +30.    
           05 WS-LPN                           PIC S9(04) VALUE +39.    
           05 WS-UTE                           PIC S9(04) VALUE +40.    
           05 WS-UTG                           PIC S9(04) VALUE +45.    
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
           05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
           05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
           05 WS-PREV-BILL-CYCLE               PIC X(02)  VALUE SPACES. 
           05 WS-ARR-INDX                      PIC 9(05)  VALUE ZERO.   
           05 WS-REP-INDX                      PIC 9(05)  VALUE ZERO.   
           05 WS-PHONE-NO                      PIC X(10)  VALUE SPACES. 
           05 WS-CURRENT-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-TOTAL-RECORDS                 PIC 9(05)  VALUE ZERO.   
           05 WS-AMT-AR-DAY-30                 PIC S9(07)V99 VALUE 0.   
           05 WS-AMT-AR-DAY-60                 PIC S9(07)V99 VALUE 0.   
           05 WS-AMT-AR-DAY-90                 PIC S9(07)V99 VALUE 0.   
           05 WS-TOTAL-ARREARS                 PIC S9(09)V99 VALUE  0.  
           05 WS-ARREARS                       PIC 9(02)  VALUE ZEROS.  
              88 30-DAY-ARREARS                VALUE 30.                
              88 60-DAY-ARREARS                VALUE 60.                
              88 90-DAY-ARREARS                VALUE 90.                
           05 WS-ARREARS-EXIST                 PIC X(01)  VALUE 'N'.    
              88 ARREARS-EXIST                 VALUE 'Y'.               
      *                                                                         
       01  WS-ARREARS-TABLE.                                            
           05 WS-ARR-TAB OCCURS 30000 TIMES.                            
              10 WS-ACCT-NO                    PIC 9(13).               
              10 WS-NAME                       PIC X(50).               
              10 WS-CUST-PH-NO                 PIC X(10).               
              10 WS-CR-GR                      PIC X(01).               
              10 WS-PYMT-DT                    PIC X(10).               
              10 WS-PYMT-AMT                   PIC 9(09)V99.            
              10 WS-TOT-BAL                    PIC 9(09)V99.            
C25067        10 WS-DAY-00                     PIC 9(06)V99.            
              10 WS-DAY-30                     PIC 9(06)V99.            
              10 WS-DAY-60                     PIC 9(06)V99.            
              10 WS-DAY-90                     PIC 9(06)V99.            
              10 WS-LPC-CD                     PIC X(01).               
              10 WS-LPC-IND                    PIC X(01).               
      *                                                                         
       01  WS-INDICATOR-VARIABLES.                                      
           05 IV-LAST-PYMT-DATE                PIC S9(04) COMP.         
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                           PIC X(08)  VALUE         
              'PCSRP100'.                                               
           05 FILLER                           PIC X(44)  VALUE SPACES. 
           05 WS-COMPANY-HDR                   PIC X(26)  VALUE SPACES. 
           05 FILLER                           PIC X(38)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              'PAGE :'.                                                 
           05 FILLER                           PIC X(06)  VALUE SPACES. 
           05 WS-DET-PAGE                      PIC ZZZZ   VALUE SPACES. 
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                           PIC X(07)  VALUE         
              'CYCLE  '.                                                
           05 WS-RPT-CYCLE                     PIC X(03)  VALUE SPACES. 
           05 FILLER                           PIC X(38)  VALUE SPACES. 
           05 FILLER                           PIC X(20)  VALUE         
              'ACCOUNTS BILLED ON '.                                    
           05 WS-BILL-DATE.                                             
              10 WS-BILL-MM                    PIC X(02).               
              10 FILLER                        PIC X(01)  VALUE '/'.    
              10 WS-BILL-DD                    PIC X(02).               
              10 FILLER                        PIC X(01)  VALUE '/'.    
              10 WS-BILL-YY                    PIC X(02).               
           05 FILLER                           PIC X(36)  VALUE SPACES. 
           05 FILLER                           PIC X(10)  VALUE         
              'RUN DATE :'.                                             
           05 WS-RPT-H2-DATE.                                           
              10 WS-RPT-MM                     PIC X(02).               
              10 FILLER                        PIC X(01)  VALUE '/'.    
              10 WS-RPT-DD                     PIC X(02).               
              10 FILLER                        PIC X(01)  VALUE '/'.    
              10 WS-RPT-CCYY                   PIC X(04).               
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                           PIC X(10)  VALUE         
              'ACCOUNT NO'.                                             
           05 FILLER                           PIC X(08)  VALUE SPACES. 
           05 FILLER                           PIC X(12)  VALUE         
              'TELEPHONE NO'.                                           
           05 FILLER                           PIC X(05)  VALUE SPACES. 
           05 FILLER                           PIC X(02)  VALUE         
C25067        'CG'.                                                     
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(09)  VALUE         
              'LAST PYMT'.                                              
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 FILLER                           PIC X(09)  VALUE         
              'LAST PYMT'.                                              
           05 FILLER                           PIC X(06)  VALUE SPACES. 
           05 FILLER                           PIC X(05)  VALUE         
              'TOTAL'.                                                  
C25067     05 FILLER                           PIC X(04)  VALUE SPACES. 
C25067     05 FILLER                           PIC X(06)  VALUE         
C25067        '00 DAY'.                                                 
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              '30 DAY'.                                                 
           05 FILLER                           PIC X(06)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              '60 DAY'.                                                 
           05 FILLER                           PIC X(06)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              '90 DAY'.                                                 
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(08)  VALUE         
              'LPC EXMT'.                                               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'EXMT'.                                                   
      *                                                                         
       01  WS-HDR-SUB-THREE.                                            
           05 FILLER                           PIC X(04)  VALUE         
              'NAME'.                                                   
           05 FILLER                           PIC X(35)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'DATE'.                                                   
           05 FILLER                           PIC X(12)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              'AMOUNT'.                                                 
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 FILLER                           PIC X(10)  VALUE         
              'BALANCE'.                                                
           05 FILLER                           PIC X(43)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'CODE'.                                                   
           05 FILLER                           PIC X(06)  VALUE SPACES. 
           05 FILLER                           PIC X(03)  VALUE         
              'IND'.                                                    
           05 FILLER                           PIC X(01)  VALUE SPACES. 
      *                                                                         
       01  WS-DETAIL-LINE-ONE.                                          
           05 WS-DET-ACCOUNT                   PIC XBXXXXBXXXXBXXXX.    
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-DET-TEL-NO.                                            
              10 FILLER                        PIC X(01)  VALUE '('.    
              10 WS-CITY-CODE                  PIC 9(03)  VALUE ZEROS.  
              10 FILLER                        PIC X(01)  VALUE ')'.    
              10 WS-AREA-CODE                  PIC 9(03)  VALUE ZEROS.  
              10 FILLER                        PIC X(01)  VALUE '-'.    
              10 WS-PH-NO                      PIC 9(04)  VALUE ZEROS.  
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 WS-DET-CRED-GROUP                PIC X(01).               
C25067***  05 FILLER                           PIC X(01)  VALUE '-'.            
C25067***  05 WS-DET-CRED-GROUP-DES            PIC X(08).                       
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-LAST-PYMT-DATE            PIC X(10).               
           05 FILLER                           PIC X(01)  VALUE SPACES. 
           05 WS-DET-LAST-PYMT-AMT             PIC ZZZZ,ZZ9.99.         
      *    05 FILLER                           PIC X(01)  VALUE SPACES.         
           05 WS-DET-TOTAL-BALANCE             PIC ZZZZ,ZZ9.99.         
C25067     05 FILLER                           PIC X(01)  VALUE SPACES. 
C25067     05 WS-DET-00-DAY                    PIC ZZ,ZZ9.99.           
           05 FILLER                           PIC X(01)  VALUE SPACES. 
           05 WS-DET-30-DAY                    PIC ZZ,ZZ9.99.           
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-60-DAY                    PIC ZZ,ZZ9.99.           
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-90-DAY                    PIC ZZ,ZZ9.99.           
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-DET-EXEMPT-CODE               PIC X(01).               
           05 FILLER                           PIC X(09)  VALUE SPACES. 
           05 WS-DET-EXEMPT-IND                PIC X(01).               
           05 FILLER                           PIC X(03)  VALUE SPACES. 
      *                                                                         
       01  WS-DETAIL-LINE-TWO.                                          
           05  WS-DET-NAME                     PIC X(50).               
           05  FILLER                          PIC X(82)  VALUE SPACES. 
      *                                                                         
       01  WS-TOTAL-LINE.                                               
           05 FILLER                           PIC X(14)  VALUE SPACES. 
           05 WS-ARREAR-DESC                   PIC X(26)  VALUE SPACES. 
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-ARREARS-RECORDS               PIC ZZZZZ  VALUE SPACES. 
           05 FILLER                           PIC X(07)  VALUE SPACES. 
           05 FILLER                           PIC X(10)  VALUE         
              'AMOUNT DUE'.                                             
           05 FILLER                           PIC X(01)  VALUE SPACES. 
           05 WS-TOT-AMT-DUE                   PIC ZZZ,ZZZ,ZZ9.99.      
           05 FILLER                           PIC X(53)  VALUE SPACES. 
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** END OF  REPORT ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** NO DATA  FOUND ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_JOB_PARM                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_AR_CNTL                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBARCNTL                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_COMPANY                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_PHONE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCSTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME                                                             
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_HDR                                                      
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUSTOMER                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      *-- COPY BOOK THAT CONTAINS VARIABLES REQD TO GET JOB PARM DATE           
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      *                                                                         
      *-- COPY BOOK HAVING WS-EMB-INPUT                                         
       COPY CWS00011.                                                           
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET ALL THE ACCOUNTS THAT BILLED FOR             
      ** FOR THE JOB PARM DATE.                                                 
C25067** THIS CURSOR SUMS UP 30-DAY, 60-DAY, AND 90-DAY FOR EACH ACCT           
C25067** AND SORTS THE BUCKETS DESCENDING.                                      
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE BILL-HDR CURSOR FOR                              
                 SELECT DISTINCT(BI.ACCOUNT_NO)                         
                       ,AT.BILL_CYCLE                                   
                       ,AT.COMPANY_NO                                   
C25067                 ,SUM(AC.AMT_AR_DAY_00) AS SUM00                  
C25067                 ,SUM(AC.AMT_AR_DAY_30) AS SUM30                  
C25067                 ,SUM(AC.AMT_AR_DAY_60) AS SUM60                  
C25067                 ,SUM(AC.AMT_AR_DAY_90) AS SUM90                  
                   FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)               
                       ,CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)               
C25067                 ,CSS_AR_CNTL      AC WITH(READUNCOMMITTED)               
                  WHERE BI.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND BI.ACCOUNT_NO = AC.ACCOUNT_NO                   
                    AND BI.DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                
C25067              AND ((AC.ITEM_ID > 0)                               
C25067                   OR (AC.ITEM_ID = 0                             
C25067                       AND PYMT_PRIORITY_LVL IN                   
C25067                       (19,20,29,30,39,40,45)))                   
C25067              AND BI.ACCOUNT_NO IN                                
C25067                     (SELECT DISTINCT(UT.ACCOUNT_NO)              
C25067                        FROM CSS_UTIL_ENVRNMT UT
                           WITH(READUNCOMMITTED)                  
                             WHERE CIS.SUBSTR3(
           CODE_REVENUE_CLASS,2,1) = '2')
C25067            GROUP BY                                              
C25067                  BI.ACCOUNT_NO                                   
C25067                 ,AT.BILL_CYCLE                                   
C25067                 ,AT.COMPANY_NO                                   
C25067            ORDER BY                                              
C25067                  AT.BILL_CYCLE                                   
C25067                 ,SUM90 DESC                                      
C25067                 ,SUM60 DESC                                      
C25067                 ,SUM30 DESC                                      
T35434              FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL-HDR CURSOR FOR                                      
MFA-TR*          SELECT DISTINCT(BI.ACCOUNT_NO)                                 
MFA-TR*                ,AT.BILL_CYCLE                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,SUM(AC.AMT_AR_DAY_00) AS SUM00                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_30) AS SUM30                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_60) AS SUM60                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_90) AS SUM90                          
MFA-TR*            FROM CSS_ACCOUNT      AT                                     
MFA-TR*                ,CSS_BILLING_HDR  BI                                     
MFA-TR*                ,CSS_AR_CNTL      AC                                     
MFA-TR*           WHERE BI.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND BI.ACCOUNT_NO = AC.ACCOUNT_NO                           
MFA-TR*             AND BI.DATE_BILLED = :BI-DATE-BILLED                        
MFA-TR*             AND ((AC.ITEM_ID > 0)                                       
MFA-TR*                  OR (AC.ITEM_ID = 0                                     
MFA-TR*                      AND PYMT_PRIORITY_LVL IN                           
MFA-TR*                      (19,20,29,30,39,40,45)))                           
MFA-TR*             AND BI.ACCOUNT_NO IN                                        
MFA-TR*                    (SELECT DISTINCT(UT.ACCOUNT_NO)                      
MFA-TR*                       FROM CSS_UTIL_ENVRNMT UT                          
MFA-TR*                      WHERE SUBSTR(CODE_REVENUE_CLASS,2,1) = '2')        
MFA-TR*           GROUP BY                                                      
MFA-TR*                 BI.ACCOUNT_NO                                           
MFA-TR*                ,AT.BILL_CYCLE                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*           ORDER BY                                                      
MFA-TR*                 AT.BILL_CYCLE                                           
MFA-TR*                ,SUM90 DESC                                              
MFA-TR*                ,SUM60 DESC                                              
MFA-TR*                ,SUM30 DESC                                              
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                    33080000
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET THE PHONE NO. OF THE CUSTOMER                
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE PHONE-NO CURSOR FOR                              
                 SELECT  CB.PHONE_NO                                    
                   FROM  CSS_CUST_PHONE CB                              
                  WHERE  CB.CUSTOMER_NO = :CB-CUSTOMER-NO               
               ORDER BY CB.PHONE_NO DESC                                
               OPTION(FAST 1)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        DECLARE PHONE-NO CURSOR FOR                                      
MFA-TR*          SELECT  CB.PHONE_NO                                    32970000
MFA-TR*            FROM  CSS_CUST_PHONE CB                                      
MFA-TR*           WHERE  CB.CUSTOMER_NO = :CB-CUSTOMER-NO                       
MFA-TR*        ORDER BY CB.PHONE_NO DESC                                        
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*    END-EXEC.                                                    33080000
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   OPENS OUTPUT FILE AND GETS JOB PARM DATE AND REPORT DATE     *        
      ******************************************************************        
       0100-INITIALISATION.                                             
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE                  TO BI-DATE-BILLED.       
           MOVE WS-INPUT-DATE(3:2)             TO WS-BILL-YY.           
           MOVE WS-INPUT-DATE(6:2)             TO WS-BILL-MM.           
           MOVE WS-INPUT-DATE(9:2)             TO WS-BILL-DD.           
      *                                                                         
           PERFORM 7500-GET-CURRENT-DATE       THRU 7500-EXIT.          
           MOVE WS-CURRENT-DATE(1:4)           TO WS-RPT-CCYY.          
           MOVE WS-CURRENT-DATE(6:2)           TO WS-RPT-MM.            
           MOVE WS-CURRENT-DATE(9:2)           TO WS-RPT-DD.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO PROCESS EACH ACCOUNT FROM BILL-HDR CURSOR   **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-BILL-HDR-CURSOR   THRU 7000-EXIT.          
           PERFORM 7010-FETCH-BILL-HDR-CURSOR  THRU 7010-EXIT.          
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               PERFORM 2700-PRT-HEADINGS       THRU 2700-EXIT           
               MOVE WS-NO-DATA-LINE            TO PRT33-DATA            
               PERFORM 2800-WRITE-PRINT-REC    THRU 2800-EXIT           
               GO TO 1000-EXIT                                          
           ELSE                                                         
              MOVE AT-BILL-CYCLE               TO WS-PREV-BILL-CYCLE    
              MOVE AT-COMPANY-NO               TO C7-COMPANY-NO         
              PERFORM 7550-GET-COMPANY-DESC    THRU 7550-EXIT           
              MOVE C7-COMPANY-NAME             TO WS-COMPANY-HDR        
              INITIALIZE WS-ARREARS-TABLE                               
              MOVE WS-1                        TO WS-ARR-INDX           
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              IF AT-BILL-CYCLE = WS-PREV-BILL-CYCLE                     
                 PERFORM 2100-POP-REP-DETAILS  THRU 2100-EXIT           
              ELSE                                                      
                 COMPUTE WS-ARR-INDX = WS-ARR-INDX - WS-1               
                 IF WS-ARR-INDX NOT EQUAL ZERO                          
                    PERFORM 2200-PRINT-REPORT  THRU 2200-EXIT           
                 END-IF                                                 
      *                                                                         
                 INITIALIZE WS-ARREARS-TABLE                            
                 MOVE WS-1                     TO WS-ARR-INDX           
                 MOVE AT-BILL-CYCLE            TO WS-PREV-BILL-CYCLE    
                 MOVE WS-57                    TO WS-LINE-CNTR          
                 PERFORM 2100-POP-REP-DETAILS  THRU 2100-EXIT           
              END-IF                                                    
      *                                                                         
              PERFORM 7010-FETCH-BILL-HDR-CURSOR THRU 7010-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-BILL-HDR-CURSOR  THRU 7020-EXIT.          
      *                                                                         
           COMPUTE WS-ARR-INDX = WS-ARR-INDX - WS-1                     
           IF WS-ARR-INDX NOT EQUAL ZERO                                
              PERFORM 2200-PRINT-REPORT        THRU 2200-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-FOOT-LINE                   TO PRT33-DATA.           
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * POPULATE THE ARRAY FOR EACH BILL CYCLE                                  
      ******************************************************************        
      *                                                                         
       2100-POP-REP-DETAILS.                                            
      *                                                                         
           MOVE BI-ACCOUNT-NO                  TO AC-ACCOUNT-NO         
                                                  AT-ACCOUNT-NO.        
C25067     IF AC-AMT-AR-DAY-30 > 0 OR                                   
C25067        AC-AMT-AR-DAY-60 > 0 OR                                   
C25067        AC-AMT-AR-DAY-90 > 0                                      
              PERFORM 2400-POPULATE-ARRAY      THRU 2400-EXIT           
              COMPUTE WS-ARR-INDX = WS-ARR-INDX + WS-1                  
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WHEN THE BILL CYCLE CHANGES PRINT THE REPORT.                           
      ******************************************************************        
      *                                                                         
       2200-PRINT-REPORT.                                               
      *                                                                         
           MOVE WS-N                           TO WS-ARREARS-EXIST.     
           MOVE WS-PREV-BILL-CYCLE             TO WS-RPT-CYCLE.         
           MOVE 90                             TO WS-ARREARS.           
           INITIALIZE WS-TOTAL-RECORDS                                  
                      WS-TOTAL-ARREARS.                                 
           PERFORM VARYING WS-REP-INDX FROM WS-1 BY WS-1                
              UNTIL WS-REP-INDX > WS-ARR-INDX                           
              IF WS-DAY-90(WS-REP-INDX) > 0                             
                    SET ARREARS-EXIST          TO TRUE                  
                    PERFORM 2500-POPULATE-REPORT THRU 2500-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF ARREARS-EXIST                                             
              MOVE 'TOTAL ACCOUNTS WITH 90 DAY'                         
                                               TO WS-ARREAR-DESC        
              MOVE WS-TOTAL-RECORDS            TO WS-ARREARS-RECORDS    
              MOVE WS-TOTAL-ARREARS            TO WS-TOT-AMT-DUE        
              MOVE WS-TOTAL-LINE               TO PRT33-DATA            
              MOVE WS-2                        TO WS-LINE-SPACE         
              ADD  WS-2                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
              MOVE SPACES                      TO PRT33-DATA            
              ADD  WS-1                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-N                           TO WS-ARREARS-EXIST.     
           MOVE 60                             TO WS-ARREARS.           
           INITIALIZE WS-TOTAL-RECORDS                                  
                      WS-TOTAL-ARREARS.                                 
           PERFORM VARYING WS-REP-INDX FROM WS-1 BY WS-1                
              UNTIL WS-REP-INDX > WS-ARR-INDX                           
              IF WS-DAY-60(WS-REP-INDX) > 0                             
C25067           IF WS-DAY-90(WS-REP-INDX) <= 0                         
                    SET ARREARS-EXIST          TO TRUE                  
                    PERFORM 2500-POPULATE-REPORT THRU 2500-EXIT         
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF ARREARS-EXIST                                             
              MOVE 'TOTAL ACCOUNTS WITH 60 DAY' TO WS-ARREAR-DESC       
              MOVE WS-TOTAL-RECORDS            TO WS-ARREARS-RECORDS    
              MOVE WS-TOTAL-ARREARS            TO WS-TOT-AMT-DUE        
              MOVE WS-TOTAL-LINE               TO PRT33-DATA            
              MOVE WS-2                        TO WS-LINE-SPACE         
              ADD  WS-2                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
              MOVE SPACES                      TO PRT33-DATA            
              ADD  WS-1                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-N                           TO WS-ARREARS-EXIST.     
           MOVE 30                             TO WS-ARREARS.           
           INITIALIZE WS-TOTAL-RECORDS                                  
                      WS-TOTAL-ARREARS.                                 
           PERFORM VARYING WS-REP-INDX FROM WS-1 BY WS-1                
              UNTIL WS-REP-INDX > WS-ARR-INDX                           
              IF WS-DAY-30(WS-REP-INDX) > 0                             
C25067           IF WS-DAY-60(WS-REP-INDX) <= 0                         
C25067           AND WS-DAY-90(WS-REP-INDX) <= 0                        
                    SET ARREARS-EXIST          TO TRUE                  
                    PERFORM 2500-POPULATE-REPORT THRU 2500-EXIT         
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF ARREARS-EXIST                                             
              MOVE 'TOTAL ACCOUNTS WITH 30 DAY' TO WS-ARREAR-DESC       
              MOVE WS-TOTAL-RECORDS            TO WS-ARREARS-RECORDS    
              MOVE WS-TOTAL-ARREARS            TO WS-TOT-AMT-DUE        
              MOVE WS-TOTAL-LINE               TO PRT33-DATA            
              MOVE WS-2                        TO WS-LINE-SPACE         
              ADD  WS-2                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
              MOVE SPACES                      TO PRT33-DATA            
              ADD  WS-1                        TO WS-LINE-CNTR          
              PERFORM 2800-WRITE-PRINT-REC     THRU 2800-EXIT           
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-AMT-AR-DAY-30                                  
                      WS-AMT-AR-DAY-60                                  
                      WS-AMT-AR-DAY-90.                                 
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************25460000
      * GETS ALL THE OTHER DETAILS LIKE NAME, PHONE NO, LAST PAYMENT    25470000
      * AMOUNT, LAST PAYMENT DATE ETC AND POPULATES THE ARRAY.                  
      ******************************************************************25460000
      *                                                                         
       2400-POPULATE-ARRAY.                                             
      *                                                                         
           PERFORM 7300-GET-ACCT-DET           THRU 7300-EXIT.          
           MOVE SPACES                         TO WS-EMB-INPUT          
                                                  WS-CMP-TABLE.         
           MOVE AT-CUSTOMER-NO                 TO CU-CUSTOMER-NO.       
           PERFORM 7400-GET-NAME               THRU 7400-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES                      TO WS-NAME(WS-ARR-INDX)  
           ELSE                                                         
              MOVE DQ-FULL-NAME                TO WS-EMB-INPUT          
              MOVE 50                          TO WS-EMB-LENG           
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
              MOVE WS-CMP-TABLE                TO WS-NAME(WS-ARR-INDX)  
           END-IF.                                                      
      *                                                                         
           MOVE AT-CUSTOMER-NO                 TO CB-CUSTOMER-NO.       
           MOVE SPACES                         TO CB-PHONE-NO.          
           PERFORM 7200-OPEN-PHONE-NO-CURSOR   THRU 7200-EXIT.          
           PERFORM 7210-FETCH-PHONE-NO-CURSOR  THRU 7210-EXIT.          
           PERFORM 7220-CLOSE-PHONE-NO-CURSOR  THRU 7220-EXIT.          
      *                                                                         
           MOVE AT-ACCOUNT-NO           TO WS-ACCT-NO(WS-ARR-INDX).     
           MOVE CB-PHONE-NO             TO WS-CUST-PH-NO(WS-ARR-INDX).  
           MOVE AT-CREDIT-GROUP         TO WS-CR-GR(WS-ARR-INDX).       
           MOVE AT-LAST-PYMT-DATE       TO WS-PYMT-DT(WS-ARR-INDX).     
           MOVE AT-LAST-PYMT-AMOUNT     TO WS-PYMT-AMT(WS-ARR-INDX).    
      *                                                                         
           MOVE AT-TOTAL-AR-BALANCE     TO WS-TOT-BAL(WS-ARR-INDX).     
C25067     MOVE AC-AMT-AR-DAY-00        TO WS-DAY-00(WS-ARR-INDX).      
C25067     MOVE AC-AMT-AR-DAY-30        TO WS-DAY-30(WS-ARR-INDX).      
C25067     MOVE AC-AMT-AR-DAY-60        TO WS-DAY-60(WS-ARR-INDX).      
C25067     MOVE AC-AMT-AR-DAY-90        TO WS-DAY-90(WS-ARR-INDX).      
           MOVE AT-CODE-LPC-XMT         TO WS-LPC-CD(WS-ARR-INDX).      
           MOVE AT-NOTICE-EXEMPT-CD     TO WS-LPC-IND(WS-ARR-INDX).     
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************25460000
      * MOVES ALL THE DETAILS FROM THE ARRAY TO THE REPORT VARIABLES    25470000
      ******************************************************************25460000
      *                                                                         
       2500-POPULATE-REPORT.                                            
      *                                                                         
           ADD WS-1                            TO WS-TOTAL-RECORDS.     
           MOVE WS-ACCT-NO(WS-REP-INDX)        TO WS-DET-ACCOUNT.       
           INSPECT WS-DET-ACCOUNT REPLACING ALL ' ' BY '-'.             
           MOVE WS-NAME(WS-REP-INDX)           TO WS-DET-NAME.          
           MOVE WS-CUST-PH-NO(WS-REP-INDX)     TO WS-PHONE-NO.          
           IF WS-PHONE-NO EQUAL SPACES                                  
              MOVE ZEROS                       TO WS-CITY-CODE          
                                                  WS-AREA-CODE          
                                                  WS-PH-NO              
           ELSE                                                         
              MOVE WS-PHONE-NO(1:3)            TO WS-CITY-CODE          
              MOVE WS-PHONE-NO(4:3)            TO WS-AREA-CODE          
              MOVE WS-PHONE-NO(7:4)            TO WS-PH-NO              
           END-IF.                                                      
      *                                                                         
           MOVE WS-CR-GR(WS-REP-INDX)          TO WS-DET-CRED-GROUP.    
      *                                                                         
C25067***  EVALUATE WS-DET-CRED-GROUP                                           
C25067***      WHEN 'A'                                                         
C25067***         MOVE 'A'                     TO WS-DET-CRED-GROUP-DES         
C25067***      WHEN 'B'                                                         
C25067***         MOVE 'B'                     TO WS-DET-CRED-GROUP-DES         
C25067***      WHEN 'C'                                                         
C25067***         MOVE 'C'                     TO WS-DET-CRED-GROUP-DES         
C25067***      WHEN 'N'                                                         
C25067***         MOVE 'N'                     TO WS-DET-CRED-GROUP-DES         
C25067**** END-EVALUATE.                                                        
      *                                                                         
           MOVE WS-PYMT-DT(WS-REP-INDX)        TO WS-DET-LAST-PYMT-DATE.
           MOVE WS-PYMT-AMT(WS-REP-INDX)       TO WS-DET-LAST-PYMT-AMT. 
           MOVE WS-TOT-BAL(WS-REP-INDX)        TO WS-DET-TOTAL-BALANCE. 
           ADD WS-TOT-BAL(WS-REP-INDX)         TO WS-TOTAL-ARREARS.     
      *                                                                         
C25067     MOVE 0                              TO WS-DET-00-DAY         
                                                  WS-DET-30-DAY         
                                                  WS-DET-60-DAY         
                                                  WS-DET-90-DAY.        
      *                                                                         
C25067     MOVE WS-DAY-90(WS-REP-INDX) TO WS-DET-90-DAY.                
C25067     MOVE WS-DAY-60(WS-REP-INDX) TO WS-DET-60-DAY.                
C25067     MOVE WS-DAY-30(WS-REP-INDX) TO WS-DET-30-DAY.                
C25067     MOVE WS-DAY-00(WS-REP-INDX) TO WS-DET-00-DAY.                
      *                                                                         
           MOVE WS-LPC-CD(WS-REP-INDX)         TO WS-DET-EXEMPT-CODE.   
           MOVE WS-LPC-IND(WS-REP-INDX)        TO WS-DET-EXEMPT-IND.    
      *                                                                         
           PERFORM 2600-PRINT-REPORT           THRU 2600-EXIT.          
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************25460000
      * IF LINE COUNTER IS GREATER THAN 56 PRINTS THE REPORT ON THE     25470000
      * NEXT PAGE WITH DETAILS AND HEADERS.                                     
      ******************************************************************25460000
      *                                                                         
       2600-PRINT-REPORT.                                               
      *                                                                         
           IF  WS-LINE-CNTR > WS-56                                     
               PERFORM 2700-PRT-HEADINGS       THRU 2700-EXIT           
               MOVE WS-2                       TO WS-LINE-SPACE         
               ADD  WS-2                       TO WS-LINE-CNTR          
           ELSE                                                         
               MOVE WS-1                       TO WS-LINE-SPACE         
               ADD  WS-1                       TO WS-LINE-CNTR          
           END-IF.                                                      
                                                                        
      *                                                                         
           MOVE WS-DETAIL-LINE-ONE             TO PRT33-DATA.           
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
           INITIALIZE WS-DETAIL-LINE-ONE.                               
      *                                                                         
           MOVE WS-DETAIL-LINE-TWO             TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           ADD  WS-1                           TO WS-LINE-CNTR.         
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
           INITIALIZE WS-DETAIL-LINE-TWO.                               
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************25460000
      * PRINTS THE PAGE HEADINGS AND SUB HEADINGS ON THE REPORT         25470000
      ******************************************************************25460000
      *                                                                         
       2700-PRT-HEADINGS.                                               
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-1                            TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
           MOVE WS-HDR-SUB-THREE               TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           ADD  WS-5                           TO WS-LINE-CNTR.         
           PERFORM 2800-WRITE-PRINT-REC        THRU 2800-EXIT.          
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************25460000
      * WRITES THE DETAILS ON TO THE REPORT FCSPT33.                    25470000
      ******************************************************************25460000
      *                                                                         
       2800-WRITE-PRINT-REC.                                            
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      *                                                                 11187100
       COPY CPD00040.                                                   11187200
       COPY CPD00037.                                                   11188800
      * PARAGRAPH 7550-START-FCSJC01 IS IN CPD00038.                            
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                             
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                 11188900
      ******************************************************************        
      **  OPENS BILL-HDR CURSOR TO GET ACCOUNTS BILLED FOR THE JOB    **        
      **  PARM DATE                                                   **        
      ******************************************************************        
      *                                                                         
       7000-OPEN-BILL-HDR-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN BILL-HDR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7000-OPEN-BILL-HDR-CURSOR          *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCHES ACCOUNT NO, BILL CYCLE                              **        
      ******************************************************************        
      *                                                                         
       7010-FETCH-BILL-HDR-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL-HDR                                            
               INTO :BI-ACCOUNT-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-COMPANY-NO                                      
C25067             ,:AC-AMT-AR-DAY-00                                   
C25067             ,:AC-AMT-AR-DAY-30                                   
C25067             ,:AC-AMT-AR-DAY-60                                   
C25067             ,:AC-AMT-AR-DAY-90                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7010-FETCH-BILL-HDR                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSES BILL-HDR CURSOR                                      **        
      ******************************************************************        
      *                                                                         
       7020-CLOSE-BILL-HDR-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL-HDR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7020-CLOSE-BILL-HDR-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPENS PHONE-NO CURSOR                                        *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-PHONE-NO-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN PHONE-NO                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7200-OPEN-PHONE-NO-CURSOR          *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO', AT-ACCOUNT-NO                    
               DISPLAY '* CUSTOMER NO', CB-CUSTOMER-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCHES PHONE NO FROM CSS_CUST_PHONE TABLE                   *        
      ******************************************************************        
      *                                                                         
       7210-FETCH-PHONE-NO-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH PHONE-NO                                            
               INTO :CB-PHONE-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7210-FETCH-PHONE-NO                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO', AT-ACCOUNT-NO                    
               DISPLAY '* CUSTOMER NO', CB-CUSTOMER-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSES PHONE-NO CURSOR                                       *        
      ******************************************************************        
      *                                                                         
       7220-CLOSE-PHONE-NO-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE PHONE-NO                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7220-CLOSE-BILL-HDR-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO', AT-ACCOUNT-NO                    
               DISPLAY '* CUSTOMER NO', CB-CUSTOMER-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS CUSTOMER NO, TOTAL AR BALANCE AND OTHER DETAILS FROM    *        
      **  CSS_ACCOUNT                                                  *        
      ******************************************************************        
      *                                                                         
       7300-GET-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.TOTAL_AR_BALANCE                               
                     ,AT.CODE_LPC_XMT                                   
                     ,AT.CUSTOMER_NO                                    
                     ,AT.NOTICE_EXEMPT_CD                               
                     ,AT.CREDIT_GROUP                                   
                     ,AT.LAST_PYMT_DATE                                 
                     ,AT.LAST_PYMT_AMOUNT                               
                INTO  :AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODE-LPC-XMT                                  
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-NOTICE-EXEMPT-CD                              
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-LAST-PYMT-DATE :IV-LAST-PYMT-DATE             
                     ,:AT-LAST-PYMT-AMOUNT                              
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
T35434                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT AT.TOTAL_AR_BALANCE                               32970000
MFA-TR*              ,AT.CODE_LPC_XMT                                   32970000
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.NOTICE_EXEMPT_CD                                       
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.LAST_PYMT_DATE                                         
MFA-TR*              ,AT.LAST_PYMT_AMOUNT                                       
MFA-TR*         INTO  :AT-TOTAL-AR-BALANCE                              32980000
MFA-TR*              ,:AT-CODE-LPC-XMT                                  32980000
MFA-TR*              ,:AT-CUSTOMER-NO                                   32980000
MFA-TR*              ,:AT-NOTICE-EXEMPT-CD                              33010000
MFA-TR*              ,:AT-CREDIT-GROUP                                  33020000
MFA-TR*              ,:AT-LAST-PYMT-DATE :IV-LAST-PYMT-DATE             33030000
MFA-TR*              ,:AT-LAST-PYMT-AMOUNT                              33040000
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF IV-LAST-PYMT-DATE EQUAL -1                             
                 MOVE SPACES                   TO AT-LAST-PYMT-DATE     
              END-IF                                                    
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7300-GET-ACCT-DET                  *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS CUSTOMER NAME FROM CSS_NAME                             *        
      ******************************************************************        
      *                                                                         
       7400-GET-NAME.                                                   
      *                                                                         
           EXEC SQL                                                     
               SELECT  DQ.FULL_NAME                                     
                 INTO  :DQ-FULL-NAME                                    
                 FROM  CSS_NAME           DQ WITH(READUNCOMMITTED)              
                      ,CSS_CUSTOMER       CU WITH(READUNCOMMITTED)              
                WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                 
                  AND  CU.NAME_ID     =  DQ.NAME_ID                     
T35434                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT  DQ.FULL_NAME                                     32970000
MFA-TR*          INTO  :DQ-FULL-NAME                                    32980000
MFA-TR*          FROM  CSS_NAME           DQ                                    
MFA-TR*               ,CSS_CUSTOMER       CU                                    
MFA-TR*         WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                         
MFA-TR*           AND  CU.NAME_ID     =  DQ.NAME_ID                             
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7400-GET-NAME                      *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* CUSTOMER NO', CU-CUSTOMER-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS CURRENT DATE                                            *        
      ******************************************************************        
      *                                                                         
       7500-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7500-GET-CURRENT-DATE              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS COMPANY NAME FROM CSS_COMPANY                           *        
      ******************************************************************        
      *                                                                         
       7550-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO  :C7-COMPANY-NAME                                 
                 FROM  CSS_COMPANY   C7 WITH(READUNCOMMITTED)                   
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
T35434                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT  COMPANY_NAME                                     32970000
MFA-TR*          INTO  :C7-COMPANY-NAME                                 32980000
MFA-TR*          FROM  CSS_COMPANY   C7                                         
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSRP100 ABORT ************'         
               DISPLAY '* 7550-GET-COMAPNY-DESC              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* COMPANY NO ', C7-COMPANY-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSRP100 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      * CLOSES THE FILE  FCSPT33-FILE.                                          
      ************************************************************              
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
