       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP099.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. APR 29, 2008.                                      
      ******************************************************************        
      **                                                              **        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                                                              **        
      ******************************************************************        
      *********        CUSTOMER INFORMATION  SYSTEM            *********        
      ******************************************************************        
      **                    P R O G R A M S U M M A R Y               **        
      **                                                              **        
      **   PURPOSE :                                                  **        
      **   THIS IS A CHECKER PROGRAM TO VALIDATE CRM USER TABLE DATA. **        
      **   IF WILL GENERATE A VALIDATION REPORT FOR DATA ERRORS.      **        
      **                                                              **        
      **   DATA VALIDATION IS DONE ON FOLLOWING CRM TABLES.           **        
      **                                                              **        
      **   1. CRM_MKT_TIER                                            **        
      **   2. CRM_OFF_MKT_TIER                                        **        
      **   3. CRM_RT_ATTR_INCTV                                       **        
      **   4. CRM_OPT_ATTR_INTCV                                      **        
      **   5. CRM_RT_PKG_OPTION                                       **        
      **   6. CRM_RT_PKG_OFFER                                        **        
      **   7. CRM_OFFER_OPTION                                        **        
      **   9. CRM_MKT_PROMOTION                                       **        
      **  10. CRM_RATE_GROUP                                          **        
      **  11. CRM_RATE_GRP_OFFER                                      **        
      **  12. CSS_SPCL_FCTR                                           **        
      **  13. CSS_SPCL_FCTR_APPL                                      **        
      **                                                              **        
      **   THIS PROGRAM SHOULD BE RUN ANY TIME WE WANT TO VALIDATE    **        
      **   CRM USER TABLES DATA.                                      **        
      ******************************************************************        
      **                                                              **        
      **               PROGRAM  MODIFICATION  LOG                     **        
      **                                                              **        
      **      DATE       INITIALS         REASON                      **        
      **     ======      =========        =======                     **        
      **    04-29-2008   GD97441          NEW BATCH PROGRAM.          **        
C37780**    11-10-2008   GD97441          1.MODIFIED QUERY FOR        **        
C37780**                                    FIX_PRICE_C1 CURSOR.      **        
C37780**                                  2.REPLACED WS-CODE-UTIL-TYPE**        
C37780**                                    WITH 'G' IN ALL QUERIES.  **        
A00633**    05/06/2009   GD97441          ADD 18, 24 & 36 TO FIXED    **        
A00633**                                  FACTOR DURATION_NO CHECK.   **        
P00141**    05/06/2009   SS97726          ADD START/END DATE CHECK FOR**        
P00141**                                  CRM_OPT_ATTR_INCTV TABLE.   **        
P00211**    11/10/2009   VY95550          INTRODUCED NEW              **        
P00211**                                  OPT_CALC_TYPE_CD FOR        **        
P00211**                                  INTRO/PROMOTIONAL OPTIONS   **        
P00211**                                  AND TREAT THEM AS VP        **        
P00269**    02/04/2010   MN90523          INCLUDED OFFER_OPT_START_DT **        
P00269**                                  AND OFFER_OPT_END_DT        **        
A00494**    06-03-2010   GD97441          ADDED ERROR REPORT CHECK FOR**        
A00494**                                  MKT_TIER & OFF_MKT_TIER     **        
P00396**    08-09-2010   VY95550          ADDED RENEWAL DESCRIPTION   **        
P00396**                                  LENGTH CHECK ON             **        
P00396**                                  CRM_RT_PKG_OPTION TABLE     **        
PRJ396**    09/09/2010   JC91900          Renewal option validation   **        
PRJ396**                                  based on DELINQ value.      **        
A02791**    09/22/2010   VY95550          Added Carriage return field **        
A02791**                                  check on CRM_RT_PKG_OPTION  **        
P00485**    03/03/2011   MS93554          VALIDATE THE CURRENT EXTERNAL*        
P00485**                                  DESC AND WEB MARKETING DESC **        
P00485**                                  COLUMNS NOT EXCEED THEIR    **        
P00485**                                  DELINQUENCY VALUE.          **        
P00473**   05/16/2011    SB93596          CHGS INCLUDED TO PULL APPROVED        
P00473**                                  OPTION/OFFER/PROMOTION      **        
P00473**                                  OPT ATTR INCTV RECORDS      **        
P00473**   04/24/2012    JC91900          Remove the option  and      **        
      **                                  tweak the price validation. **        
      **                                  They are now handled by the **        
      **                                  RPM application.            **        
A04256**   07/26/2012    MS93554          HARDCODED THE OPTION CODES  **        
A04256**                                  IN THE QUERY NOT TO THROW   **        
A04256**                                  THE VALIDATION ERRORS.      **        
A04319**   09/07/2012    HA7A338          MODIFIED MONTHLY_CR_C4 QUERY**        
A04319**                                  TO SKIP OPTIONS WITH INCT_VL**        
A04319**                                  < 0 / OPT_CHG_ACTION_CD 'N' **        
A04319**   09/18/2012    HA7A338          ADD SPCL_FCTR_C4 CURSOR TO  **        
A04319**                                  VALIDATE DUPLICATE ACTIVE   **        
A04319**                                  FACTOR IN SPCL_FCTR_APPL TBL**        
A04221**   11/19/2012    GD43988          ADDED SPCL_FCTR_C5 CURSOR TO**        
A04221**                                  VALIDATE DUPLICATE FACTORS  **        
A04221**                                  FOR START/END DISP TIMESTAMP**        
A04221**                                  IN CSS_SPCL_FCTR_APPL       **        
P00614**   08/26/2013    GD43988          WEB MOD-PROJECT CHANGES     **        
PRDFIX**   09/19/2013    GD43988          OPT_INCTV_C4 CURSOR CHANGES **        
P00838**   08/28/2014    SS97726          Web Rate Enhancements.      **        
A05136**   08/04/2015    db41297          Add additional durations    **        
P805CS**   05/06/2016    SS45239          CSC Increase. Temp changes. **        
P805CS**                                  Also removed code for A02791**        
P805CS**                                  as descriptions are entered **        
P805CS**                                  thru RPM and carriage return**        
P805CS**                                  check is no longer needed.  **        
P805CS**                                  This code is causing error  **        
P805CS**                                  during conversion for CIS   **        
P805CS**                                  optimization project.       **        
ACT388**   12/17/2016    AD7F921          CHANGES TO REMOVE THE       **        
ACT388**                                  RATE PACKAGE REMOVE CALLS   **        
ACT388**                                  AND ITS PROCESS.            **        
      ******************************************************************        
      **                                                              **        
      **            ---- BASIC SEQUENCE STRUCTURE ------              **        
      **       0000 - 0999     MAIN CONTROL PATH                      **        
      **       1000 - 1999     INITIALIZATION                         **        
      **       1000 - 1999     INPUT PROCESSING CONTROL PATH          **        
      **       2000 - 2999     OUTPUT PROCESSING CONTROL PATH         **        
      **       3000 - 4999     BATCH PROCESSING MODULES - NOT USED    **        
      **       5000 - 5999     COMMON PROGRAM MODULES                 **        
      **       6000 - 6999     COMMON SYSTEM MODULES                  **        
      **       7000 - 7999     INPUT MODULES                          **        
      **       8000 - 8999     OUTPUT MODULES                         **        
      **       9000 - 9799     TERMINATION MODULES                    **        
      **       9900 - 9999     ABEND/ABORT MODULES                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT PRNTFILE        ASSIGN TO UT-S-PRNTFILE               
               FILE STATUS IS WS-P099-STATUS.                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       FD  PRNTFILE                                                     
           BLOCK CONTAINS  0 RECORDS                                    
           RECORD CONTAINS 130 CHARACTERS                               
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  PRNTFILE-RECORD             PIC X(130).                      
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP099'.
MSQ017     COPY MFASQLM.
       01 WS-START                       PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP099 STARTS HERE'.                  
      *                                                                         
      ****************************************************************          
      **          COMMON COPYBOOK FOR WS-VARIABLES                  **          
      ****************************************************************          
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      * WS SUPPORT VARIABLES FOR JOB PARM ROUTINE                               
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME                PIC X(08) VALUE 'PCSRP099'.    
          05  WS-COMMON                  PIC X(08) VALUE 'COMMON  '.    
          05  WS-Y                       PIC X(01) VALUE 'Y'.           
          05  WS-N                       PIC X(01) VALUE 'N'.           
          05  WS-COMPANY-NO              PIC X(02) VALUE '01'.          
          05  WS-CODE-UTIL-TYPE          PIC X(01) VALUE 'G'.           
      *                                                                         
      *01 WS-SWITCHES.                                                          
      *                                                                         
       01 WS-MISC.                                                      
          05  WS-CALC-ERROR              PIC X(08) VALUE SPACES.        
          05  WS-ERR-MSG                 PIC X(50) VALUE SPACES.        
          05  WS-DISP-RC                 PIC -ZZZZZZZZ9.9.              
          05  WS-CHECK-DATE              PIC X(10) VALUE SPACES.        
P00473    05  WS-CHECK-TS.                                              
P00473        10 WS-CHECK-DT             PIC X(10).                     
P00473        10 FILLER                  PIC X(16)                      
P00473                                         VALUE '-00.00.00.000000'.
P00473    05  WS-CHECK-TIMESTAMP         PIC X(26) VALUE SPACES.        
          05  WS-P099-STATUS             PIC X(02) VALUE SPACES.        
              88  P099-SUCCESSFUL                  VALUE '00'.          
          05  WS-RPT-LINE-NO             PIC 9(04) VALUE 0.             
          05  WS-RPT-LINE-COUNT          PIC 9(04) VALUE 0.             
          05  WS-RPT-PAGE-NO             PIC 9(04) VALUE 0.             
P00396    05  WS-LEN-LIMIT               PIC S9(4) USAGE COMP VALUE +0. 
PRJ396    05  WS-OFFER-OPT-CNT           PIC S9(4) USAGE COMP VALUE +0. 
P00396    05  WS-RENEWAL-DELINQ-CD       PIC X(18) VALUE                
P00396                                    'RENEWAL-DESC-LIMIT'.         
PRJ396    05  WS-RENEWAL-OFFER-CNT       PIC X(19) VALUE                
PRJ396                                    'CRM-RENEW-OFFER-CNT'.        
P00485    05  WS-EXT-DESC-DELINQ-CD      PIC X(18) VALUE                
P00485                                    'CRM-EXT-DESC-LIMIT'.         
P00485    05  WS-EXT-DESC-LIMIT          PIC S9(4) USAGE COMP VALUE +0. 
P00485    05  WS-INSPECT-EXT-CNT         PIC S9(4) USAGE COMP VALUE +0. 
                                                                        
      *                                                                         
      *****************************************************************         
      ** WS-VARIABLES FOR CHECKER PROGRAM VALIDATION REPORT          **         
      *****************************************************************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-TITLE-LINE-1.                                         
               10  FILLER                PIC X(06) VALUE 'DATE: '.      
               10  P-RPT-DATE            PIC X(10).                     
               10  FILLER                PIC X(20) VALUE SPACES.        
               10  FILLER                PIC X(32) VALUE                
                   'CRM USER TABLE VALIDATION REPORT'.                  
               10  FILLER                PIC X(50) VALUE SPACES.        
               10  FILLER                PIC X(06) VALUE 'PAGE: '.      
               10  P-RPT-PAGE-NO         PIC ZZ,ZZ9.                    
      *                                                                         
           05  WS-HEADER-LINE-1.                                        
               10  FILLER                PIC X(18) VALUE                
                                           'PARENT/CHILD TABLE'.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  FILLER                PIC X(18) VALUE                
                                           'COLUMN NAME       '.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  FILLER                PIC X(18) VALUE                
                                           'COLUMN VALUE      '.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  FILLER                PIC X(13) VALUE                
                                                'ERROR MESSAGE'.        
               10  FILLER                PIC X(60) VALUE SPACES.        
      *                                                                         
       01  WS-MAIL-HEADERS.                                             
           05  MAILHEAD-1.                                              
               10  FILLER                PIC X(39) VALUE                
                     'SUBJECT: CRM USER TABLE VALIDATION FOR '.         
               10  MAIL1-SUB-DATE        PIC X(10).                     
           05  MAILHEAD-2.                                              
               10  FILLER                PIC X(80) VALUE SPACES.        
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-BLANK-LINE             PIC X(130) VALUE SPACES.       
      *                                                                         
           05  WS-DETAIL-LINE.                                          
               10  D-TABLE-DESC          PIC X(18).                     
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  D-COLUMN-NAME         PIC X(18).                     
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  D-COLUMN-VALUE        PIC X(18).                     
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  D-ERROR-MESSAGE       PIC X(73) VALUE SPACES.        
      *                                                                         
           05  WS-NO-DATA-LINE.                                         
               10  FILLER                PIC X(30) VALUE SPACES.        
               10  FILLER                PIC X(22) VALUE                
                        '** NO ERRORS FOUND ** '.                       
               10  FILLER                PIC X(78) VALUE SPACES.        
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
      *                                                                         
           05  WS-ERROR-MESSAGE-1.                                      
               10  FILLER                PIC X(43) VALUE                
                   'MKT_TIER_C1:TIER ACCOUNT TYPE DOES NOT HAVE'.       
               10  FILLER                PIC X(30) VALUE                
                   ' A DEFAULT TIER RANKING.      '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-2.                                      
               10  FILLER                PIC X(43) VALUE                
                   'MKT_TIER_C2:TIER ACCOUNT TYPE HAS MORE THAN'.       
               10  FILLER                PIC X(30) VALUE                
                   ' 1 DEFAULT TIER RANKING.      '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-3.                                      
               10  FILLER                PIC X(43) VALUE                
                   'MKT_TIER_C3:TIER RANKING HAS OVERLAPPING EF'.       
               10  FILLER                PIC X(30) VALUE                
                   'FECTIVE DATES.                '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-4.                                      
               10  FILLER                PIC X(43) VALUE                
                   'MKT_TIER_C4:TIER ACCT TYPE DOES NOT HAVE 99'.       
               10  FILLER                PIC X(30) VALUE                
                   '9 RANK FOR WILD CARD SEARCH.  '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-5.                                      
               10  FILLER                PIC X(43) VALUE                
                   'MKT_TIER_C5:DEFAULT OFFER MISSING FOR MARKE'.       
               10  FILLER                PIC X(30) VALUE                
                   'T TIER RANKING.               '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-6.                                      
               10  FILLER                PIC X(43) VALUE                
                   'OFF_MKT_TIER_C1:MULTIPLE DEFAULT OFFERS FOR'.       
               10  FILLER                PIC X(30) VALUE                
                   ' MARKET TIER RANKING.         '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-7.                                      
               10  FILLER                PIC X(43) VALUE                
                   'OFF_MKT_TIER_C2:OVERLAPPING DATES FOR THE S'.       
               10  FILLER                PIC X(30) VALUE                
                   'AME OFFER MARKET TIER.        '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-8.                                      
               10  FILLER                PIC X(43) VALUE                
                   'OFF_MKT_TIER_C3:MKT TIER APPLY CODE MUST BE'.       
               10  FILLER                PIC X(30) VALUE                
                   ' ONLY FOR REGULATED.          '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-9.                                      
               10  FILLER                PIC X(43) VALUE                
                   'SPCL_FCTR_C1:FIXED PRICE FACTOR DEFINITION '.       
               10  FILLER                PIC X(30) VALUE                
                   'IS NOT CORRECT.               '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-10.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SPCL_FCTR_C2:COMPONENT ID CODE IS BLANK IN '.       
               10  FILLER                PIC X(30) VALUE                
                   'CSS_SPCL_FCTR_APPL.           '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-11.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SPCL_FCTR_C3:FACTOR START DISPLAY DATE AFTE'.       
               10  FILLER                PIC X(30) VALUE                
                   'R END DISPLAY DATE.           '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-12.                                     
               10  FILLER                PIC X(43) VALUE                
                   'MKT_PROMOTION_C1:REPLACEMENT PROMOTION CODE'.       
               10  FILLER                PIC X(30) VALUE                
                   ' DOES NOT EXIST.              '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-13.                                     
               10  FILLER                PIC X(43) VALUE                
                   'MKT_PROMOTION_C2:SHORT OR LONG PROMOTION DE'.       
               10  FILLER                PIC X(30) VALUE                
                   'SCRIPTION IS BLANK.           '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-14.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RATE_GROUP_C1:RATE GROUP DESCRIPTION IS BLA'.       
               10  FILLER                PIC X(30) VALUE                
                   'NK.                           '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-15.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RATE_GROUP_C2:OFFER REPEATED FOR RATE_GROUP'.       
               10  FILLER                PIC X(30) VALUE                
                   '_TYPE_CD.                     '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-17.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OPT_C2:OPTION HAS DESCRIPTION WHICH I'.       
               10  FILLER                PIC X(30) VALUE                
                   'S BLANK.                      '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-18.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OPT_C3:OPTION CODE HAS TRAILING SPACE'.       
               10  FILLER                PIC X(30) VALUE                
                   'S.                            '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-19.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OPT_C4:RATE REFERENCED BY OPTION NOT '.       
               10  FILLER                PIC X(30) VALUE                
                   'ACTIVE.                       '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-20.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C1:OFFER DOES NOT HAVE ANY OPTION'.       
               10  FILLER                PIC X(30) VALUE                
                   'S.                            '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-21.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C2:DISPLAY DATES OUTSIDE RANGE OF'.       
               10  FILLER                PIC X(30) VALUE                
                   ' OFFER EFFECTIVE DATES.       '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-22.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C3:OFFER CODE HAS TRAILING SPACES'.       
               10  FILLER                PIC X(30) VALUE                
                   '.                             '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-23.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C4:OFFER NOT IN CRM_OFF_MKT_TIER '.       
               10  FILLER                PIC X(30) VALUE                
                   'FOR CURRENT DATE.             '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-24.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C5:RENEWAL OFFER NOT ACTIVE FOR C'.       
               10  FILLER                PIC X(30) VALUE                
                   'URRENT DATE.                  '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-25.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C6:RENEWAL OFFER CODE HAS MORE TH'.       
               10  FILLER                PIC X(30) VALUE                
                   'AN 3 OPTIONS.                 '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-26.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C7:LAST OPTION ON RENEWAL OFFER N'.       
               10  FILLER                PIC X(30) VALUE                
                   'OT VARIABLE PRICE.            '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-27.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RTPKG_OFF_C8:DEREG RES W/O RENEWAL OFFER OR'.       
               10  FILLER                PIC X(30) VALUE                
                   ' REG OFFER W/ RENEWAL OFFER.  '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-28.                                     
               10  FILLER                PIC X(43) VALUE                
                   'OPT_INCTV_C1:OPTION HAS MULTIPLE PRIMARY RA'.       
               10  FILLER                PIC X(30) VALUE                
                   'TE ATTRIBUTES.                '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-29.                                     
               10  FILLER                PIC X(43) VALUE                
                   'OPT_INCTV_C2:SPECIAL FACTOR NEEDS RT_ATTR_I'.       
               10  FILLER                PIC X(30) VALUE                
                   'NCTV_TYPE ON CSS_SPCL_FCTR.   '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-30.                                     
               10  FILLER                PIC X(43) VALUE                
                   'OPT_INCTV_C3:FACTOR NOT IN CSS_SPCL_FCTR OR'.       
               10  FILLER                PIC X(30) VALUE                
                   ' INVALID TYPE.                '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-31.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FIX_PRICE_C1:THERE IS NOT AN ACTIVE ROW IN '.       
               10  FILLER                PIC X(30) VALUE                
                   'CSS_SPCL_FCTR_APPL.           '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-32.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FIX_PRICE_C2:RT_ATTR_INCTV_TYPE NOT SET TO '.       
               10  FILLER                PIC X(30) VALUE                
                   'FIXED PRICE.                  '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-33.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FIX_PRICE_C3:FIXED PRICE DOES NOT HAVE AN E'.       
               10  FILLER                PIC X(30) VALUE                
                   'XIT FEE.                      '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-34.                                     
               10  FILLER                PIC X(43) VALUE                
A00633             'FIX_PRICE_C4:INCORRECT DURATION/NOT PRIMARY'.       
               10  FILLER                PIC X(30) VALUE                
A00633             '/VALUE>0/OPT_CHG_ACTION_CD<>E.'.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-35.                                     
               10  FILLER                PIC X(43) VALUE                
                   'MONTHLY_CR_C1:MONTHLY CREDIT NOT IN CSS_SPC'.       
               10  FILLER                PIC X(30) VALUE                
                   'L_FCTR.                       '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-36.                                     
               10  FILLER                PIC X(43) VALUE                
                   'MONTHLY_CR_C2:MONTHLY CREDIT NOT IN CSS_SPC'.       
               10  FILLER                PIC X(30) VALUE                
                   'L_FCTR WITH GL_ACCT_NO > 0.   '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-37.                                     
               10  FILLER                PIC X(43) VALUE                
                   'MONTHLY_CR_C3:MONTHLY CREDIT SOURCE CODE IN'.       
               10  FILLER                PIC X(30) VALUE                
                   ' CRM_RT_ATTR_INCTV <> FF.     '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-38.                                     
               10  FILLER                PIC X(43) VALUE                
A04319             'MONTHLY_CR_C4:DURATION <= 0 OR VALUE = 0 OR'.       
               10  FILLER                PIC X(30) VALUE                
A04319             ' OPT_CHG_ACTION_CD NOT = E & N'.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-39.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FREE_CSC_C1:FREE CSC NOT IN CSS_SPCL_FCTR. '.       
               10  FILLER                PIC X(30) VALUE                
                   '                              '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-40.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FREE_CSC_C2:FREE CSC WITHOUT ACTIVE FACTOR '.       
               10  FILLER                PIC X(30) VALUE                
                   'IN CSS_SPCL_FCTR_APPL.        '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-41.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FREE_CSC_C3:VALUE > 0 OR DURATION_NO = 0 IN'.       
               10  FILLER                PIC X(30) VALUE                
                   ' CRM_OPT_ATTR_INCTV.          '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-42.                                     
               10  FILLER                PIC X(43) VALUE                
                   'FREE_CSC_C4:FREE CSC DOES NOT HAVE OPT_CHG_'.       
               10  FILLER                PIC X(30) VALUE                
                   'ACTION_CD = K.                '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-43.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SIGNUP_CR_C1:APPLICATION PROGRAM ID NOT IN '.       
               10  FILLER                PIC X(30) VALUE                
                   'CSS_APPL_PGM_DESC.            '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-44.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SIGNUP_CR_C2:DURATION<>0/VALUE<=0/APPL_PROG'.       
               10  FILLER                PIC X(30) VALUE                
                   'RAM_ID BLANK/ACCT_CRED/DEBIT=0'.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-45.                                     
               10  FILLER                PIC X(43) VALUE                
                   'EXIT_FEE_C1:EXIT FEE NOT IN CSS_SPCL_FCTR. '.       
               10  FILLER                PIC X(30) VALUE                
                   '                              '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-46.                                     
               10  FILLER                PIC X(43) VALUE                
                   'EXIT_FEE_C2:EXIT FEE SHOULD HAVE GL_ACCT_NO'.       
               10  FILLER                PIC X(30) VALUE                
                   ' ON CSS_SPCL_FCTR.            '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-47.                                     
               10  FILLER                PIC X(43) VALUE                
                   'EXIT_FEE_C3:SOURCE CODE <> FIXED FACTOR FOR'.       
               10  FILLER                PIC X(30) VALUE                
                   ' EXIT FEE.                    '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-48.                                     
               10  FILLER                PIC X(43) VALUE                
                   'EXIT_FEE_C4:DURATION <> 0 OR VALUE <= 0 OR '.       
               10  FILLER                PIC X(30) VALUE                
                   'OPT_CHG_ACTION_CD <> A.       '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-49.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SKYMILES_C1:SOURCE_CD ON CRM_RT_ATTR_INCTV '.       
               10  FILLER                PIC X(30) VALUE                
                   '<> INCENTIVE.                 '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-50.                                     
               10  FILLER                PIC X(43) VALUE                
                   'SKYMILES_C2:DURATION=0/VALUE<=0/WQ_CATEGORY'.       
               10  FILLER                PIC X(30) VALUE                
                   '_ID<>458/WQ_ROUTE_CATEGORY<>4.'.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-51.                                     
               10  FILLER                PIC X(43) VALUE                
                   'OPT_INCTV_C4:OPTION DOES NOT HAVE PRIMARY A'.       
               10  FILLER                PIC X(30) VALUE                
                   'TTRIBUTES.                    '.                    
      *                                                                         
           05  WS-ERROR-MESSAGE-52.                                     
               10  FILLER                PIC X(43) VALUE                
                   'RATE_GROUP_C3:                             '.       
               10  FILLER                PIC X(30) VALUE                
                   '                              '.                    
      *                                                                         
P00141     05  WS-ERROR-MESSAGE-53.                                     
P00141         10  FILLER                PIC X(43) VALUE                
P00141             'OPT_INCTV_C5:OPT CD HAS MULTIPLE RT ATTR IN'.       
P00141         10  FILLER                PIC X(30) VALUE                
P00141             'CTV TYPE EFFECTIVE FOR RUN DT.'.                    
P00141*                                                                         
A00494     05  WS-ERROR-MESSAGE-54.                                     
A00494         10  FILLER                PIC X(43) VALUE                
A00494             'OFF_MKT_TIER_C4:MARKET TIER RANKING IS MISS'.       
A00494         10  FILLER                PIC X(30) VALUE                
A00494             'ING FOR DEFAULT OFFER.        '.                    
A00494*                                                                         
P00396     05  WS-ERROR-MESSAGE-55.                                     
P00396         10  FILLER                PIC X(43) VALUE                
P00396             'RTPKG_OPT_C5: RENEWAL DESCRIPTION EXCEEDS  '.       
P00396         10  FILLER                PIC X(30) VALUE                
P00396             'THE MAXIMUM LIMIT.            '.                    
P00396*                                                                         
P00614*    05  WS-ERROR-MESSAGE-57.                                             
P00614*        10  FILLER                PIC X(43) VALUE                        
P00614*            'RTPKG_OPT_C7: WEB MARKETING DESCRIPTION CAN'.               
P00614*        10  FILLER                PIC X(30) VALUE                        
P00614*            'NOT EXCEED 250 CHARACTERS.    '.                            
P00614*                                                                         
P00485     05  WS-ERROR-MESSAGE-58.                                     
P00485         10  FILLER                PIC X(43) VALUE                
P00485             'RTPKG_OPT_C7: CURR EXTERNAL LONG DESCRIPTIO'.       
P00485         10  FILLER                PIC X(30) VALUE                
P00485             'N CANNOT EXCEED 60 CHARACTERS.'.                    
P00485*                                                                         
A04319     05  WS-ERROR-MESSAGE-59.                                     
A04319         10  FILLER                PIC X(43) VALUE                
A04319             'SPCL_FCTR_C4:RATE PLAN # HAS MULTIPLE ACTIV'.       
A04319         10  FILLER                PIC X(30) VALUE                
A04319             'E FACTORS AVAILABLE.          '.                    
A04319*                                                                         
A04221     05  WS-ERROR-MESSAGE-60.                                     
A04221         10  FILLER                PIC X(43) VALUE                
A04221             'SPCL_FCTR_C5:RATE HAS MULTIPLE FACTORS FOR '.       
A04221         10  FILLER                PIC X(30) VALUE                
A04221             'START/END DISPLAY TIMESTAMP.  '.                    
A04221*                                                                         
C37780 01  WS-SPCL-MESSAGES.                                            
C37780*                                                                         
C37780     05  WS-SPCL-MESSAGE-1.                                       
C37780         10  FILLER                PIC X(05) VALUE 'NOTE:'.       
C37780         10  FILLER                PIC X(41) VALUE                
C37780             'THE ABOVE ERRORS HAVE BEEN FOUND AND SEB '.         
C37780         10  FILLER                PIC X(39) VALUE                
C37780             'SAMPLE BILLING WILL NOT CONTINUE UNTIL '.           
C37780         10  FILLER                PIC X(29) VALUE                
C37780             'THESE ERRORS HAVE BEEN FIXED.'.                     
C37780*                                                                         
C37780     05  WS-SPCL-MESSAGE-2.                                       
C37780         10  FILLER                PIC X(05) VALUE SPACES.        
C37780         10  FILLER                PIC X(38) VALUE                
C37780             'CORRECT AND CALL THE COMPUTER ROOM AT '.            
C37780         10  FILLER                PIC X(40) VALUE                
C37780             '217-2814 AND USE THE FOLLOWING VERBIAGE:'.          
C37780*                                                                         
C37780     05  WS-SPCL-MESSAGE-3.                                       
C37780         10  FILLER                PIC X(05) VALUE SPACES.        
C37780         10  FILLER                PIC X(41) VALUE                
C37780             'JOB SEBR099 NEEDS TO BE RERUN. RERUN JOB '.         
C37780         10  FILLER                PIC X(30) VALUE                
C37780             'SEBR099 AS IS WITH NO CHANGES.'.                    
      *                                                                         
      *****************************************************************         
      ** SQL COMMUNICATION AREA                                      **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
P00396*****************************************************************         
P00396** CSS_DELINQUENCY, C8                                         **         
P00396*****************************************************************         
P00396                                                                  
P00396     EXEC SQL                                                             
P00396          INCLUDE TBDELQ                                                  
P00396     END-EXEC.                                                            
P00396                                                                  
      *****************************************************************         
      ** CSS_JOB_PARM, G6                                            **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_MKT_TIER       (IG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCTV  (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GROUP     (F7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRATGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER (G5)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR (SF)                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL (SA)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_CREATOR   (RT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_APPL_PGM_DESC   (K9)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT DO *         
      * NOT HAVE A ROW WITH CUST_ACCT_DEFLT_FL = 'Y'                  *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_TIER_C1 CURSOR FOR                            
               SELECT  DISTINCT  IG.TIER_CUST_STAT_CD                   
                                ,IG.TIER_ACCT_TYPE_CD                   
                                                                        
                 FROM  CRM_MKT_TIER IG WITH(READUNCOMMITTED)  LEFT JOIN         
                       CRM_MKT_TIER ZZ WITH(READUNCOMMITTED)                    
                                                                        
                   ON (ZZ.COMPANY_NO         =  IG.COMPANY_NO           
                  AND  ZZ.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD    
                  AND  ZZ.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD    
                  AND  ZZ.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  ZZ.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  ZZ.CUST_ACCT_DEFLT_FL =  'Y' )                   
                WHERE  IG.COMPANY_NO         =  :WS-COMPANY-NO          
                  AND  IG.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  IG.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  ZZ.CUST_ACCT_DEFLT_FL IS NULL                    
                ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_C1 CURSOR FOR                                    
MFA-TR*        SELECT  DISTINCT  IG.TIER_CUST_STAT_CD                           
MFA-TR*                         ,IG.TIER_ACCT_TYPE_CD                           
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_TIER IG  LEFT JOIN                               
MFA-TR*                CRM_MKT_TIER ZZ                                          
MFA-TR*                                                                         
MFA-TR*            ON (ZZ.COMPANY_NO         =  IG.COMPANY_NO                   
MFA-TR*           AND  ZZ.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD            
MFA-TR*           AND  ZZ.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD            
MFA-TR*           AND  ZZ.MKT_TIER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND  ZZ.MKT_TIER_END_DT    >= :WS-CHECK-DATE                  
MFA-TR*           AND  ZZ.CUST_ACCT_DEFLT_FL =  'Y' )                           
MFA-TR*         WHERE  IG.COMPANY_NO         =  :WS-COMPANY-NO                  
MFA-TR*           AND  IG.MKT_TIER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND  IG.MKT_TIER_END_DT    >= :WS-CHECK-DATE                  
MFA-TR*           AND  ZZ.CUST_ACCT_DEFLT_FL IS NULL                            
MFA-TR*         ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT    *         
      * ARE HAVING MULTIPLE ROWS WITH CUST_ACCT_DEFLT_FL = 'Y'        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_TIER_C2 CURSOR FOR                            
               SELECT  IG.TIER_CUST_STAT_CD                             
                      ,IG.TIER_ACCT_TYPE_CD                             
                      ,IG.CUST_ACCT_DEFLT_FL                            
                                                                        
                 FROM  CRM_MKT_TIER  IG WITH(READUNCOMMITTED)                   
                                                                        
                WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO          
                  AND IG.MKT_TIER_START_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND IG.MKT_TIER_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND IG.CUST_ACCT_DEFLT_FL =  'Y'                      
                GROUP BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD,     
                         IG.CUST_ACCT_DEFLT_FL,IG.COMPANY_NO            
               HAVING COUNT(*)  >=  2                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_C2 CURSOR FOR                                    
MFA-TR*        SELECT  IG.TIER_CUST_STAT_CD                                     
MFA-TR*               ,IG.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,IG.CUST_ACCT_DEFLT_FL                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_TIER  IG                                         
MFA-TR*                                                                         
MFA-TR*         WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO                  
MFA-TR*           AND IG.MKT_TIER_START_DT  <=  :WS-CHECK-DATE                  
MFA-TR*           AND IG.MKT_TIER_END_DT    >=  :WS-CHECK-DATE                  
MFA-TR*           AND IG.CUST_ACCT_DEFLT_FL =  'Y'                              
MFA-TR*         GROUP BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD,             
MFA-TR*                  IG.CUST_ACCT_DEFLT_FL,IG.COMPANY_NO                    
MFA-TR*        HAVING COUNT(*)  >=  2                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT    *         
      * ARE HAVING MULTIPLE ROWS WITH (PRIMARY KEY EXCLUDING          *         
      * MKT_TIER_START_DT) & MKT_TIER_END_DT >= CHECKER DATE          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_TIER_C3 CURSOR FOR                            
               SELECT  IG.TIER_CUST_STAT_CD                             
                      ,IG.TIER_ACCT_TYPE_CD                             
                      ,IG.MKT_TIER_RANKING                              
                      ,IG.COMPANY_NO                                    
                                                                        
                 FROM  CRM_MKT_TIER  IG WITH(READUNCOMMITTED)                   
                                                                        
                WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO          
                  AND IG.MKT_TIER_START_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND IG.MKT_TIER_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                GROUP BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD,     
                         IG.MKT_TIER_RANKING,IG.COMPANY_NO              
               HAVING COUNT(*)  >=  2                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_C3 CURSOR FOR                                    
MFA-TR*        SELECT  IG.TIER_CUST_STAT_CD                                     
MFA-TR*               ,IG.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,IG.MKT_TIER_RANKING                                      
MFA-TR*               ,IG.COMPANY_NO                                            
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_TIER  IG                                         
MFA-TR*                                                                         
MFA-TR*         WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO                  
MFA-TR*           AND IG.MKT_TIER_START_DT  <=  :WS-CHECK-DATE                  
MFA-TR*           AND IG.MKT_TIER_END_DT    >=  :WS-CHECK-DATE                  
MFA-TR*         GROUP BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD,             
MFA-TR*                  IG.MKT_TIER_RANKING,IG.COMPANY_NO                      
MFA-TR*        HAVING COUNT(*)  >=  2                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT    *         
      * DO NOT HAVE A ROW WITH MKT_TIER_RANKING = 999                 *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_TIER_C4 CURSOR FOR                            
               SELECT  IG.TIER_CUST_STAT_CD                             
                      ,IG.TIER_ACCT_TYPE_CD                             
                                                                        
                 FROM  CRM_MKT_TIER  IG WITH(READUNCOMMITTED)  LEFT JOIN        
                       CRM_MKT_TIER  ZZ WITH(READUNCOMMITTED)                   
                                                                        
                   ON (ZZ.COMPANY_NO         =  IG.COMPANY_NO           
                  AND  ZZ.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD    
                  AND  ZZ.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD    
                  AND  ZZ.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  ZZ.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  ZZ.MKT_TIER_RANKING   =  999  )                  
                WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO          
                  AND IG.MKT_TIER_START_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND IG.MKT_TIER_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND ZZ.MKT_TIER_RANKING   IS  NULL                    
                ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_C4 CURSOR FOR                                    
MFA-TR*        SELECT  IG.TIER_CUST_STAT_CD                                     
MFA-TR*               ,IG.TIER_ACCT_TYPE_CD                                     
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_TIER  IG  LEFT JOIN                              
MFA-TR*                CRM_MKT_TIER  ZZ                                         
MFA-TR*                                                                         
MFA-TR*            ON (ZZ.COMPANY_NO         =  IG.COMPANY_NO                   
MFA-TR*           AND  ZZ.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD            
MFA-TR*           AND  ZZ.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD            
MFA-TR*           AND  ZZ.MKT_TIER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND  ZZ.MKT_TIER_END_DT    >= :WS-CHECK-DATE                  
MFA-TR*           AND  ZZ.MKT_TIER_RANKING   =  999  )                          
MFA-TR*         WHERE IG.COMPANY_NO         =   :WS-COMPANY-NO                  
MFA-TR*           AND IG.MKT_TIER_START_DT  <=  :WS-CHECK-DATE                  
MFA-TR*           AND IG.MKT_TIER_END_DT    >=  :WS-CHECK-DATE                  
MFA-TR*           AND ZZ.MKT_TIER_RANKING   IS  NULL                            
MFA-TR*         ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD,TIER_ACCT_TYPE_CD,          *         
      * MKT_TIER_RANKING & MKT_TIER_START_DT THAT DO NOT HAVE A ROW   *         
      * WITH TIER_DEFLT_OFFR_CD = 'Y' IN CRM_OFF_MKT_TIER TABLE AND   *         
      * MKT_TIER_RANKING <> 999                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_TIER_C5 CURSOR FOR                            
               SELECT  DISTINCT  IG.TIER_CUST_STAT_CD                   
                                ,IG.TIER_ACCT_TYPE_CD                   
                                ,IG.MKT_TIER_RANKING                    
                                ,IG.MKT_TIER_START_DT                   
                                                                        
                 FROM  CRM_MKT_TIER         IG
                           WITH(READUNCOMMITTED)  LEFT JOIN               
                       CRM_OFF_MKT_TIER     DU WITH(READUNCOMMITTED)            
                                                                        
                   ON (DU.COMPANY_NO         =  IG.COMPANY_NO           
                  AND  DU.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD    
                  AND  DU.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD    
                  AND  DU.MKT_TIER_RANKING   =  IG.MKT_TIER_RANKING     
                  AND  DU.MKT_TIER_START_DT  =  IG.MKT_TIER_START_DT    
P00473            AND  DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND  DU.OFF_TIER_VEND_TS  >=  CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND  DU.PROC_STATUS_CD     =  'AC'                    
                  AND  DU.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  DU.TIER_DEFLT_OFFR_CD =  'Y'   )                 
                WHERE  IG.COMPANY_NO         =  '01'                    
                  AND  IG.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  IG.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND  IG.MKT_TIER_RANKING   <> 999                     
                  AND  DU.TIER_DEFLT_OFFR_CD IS NULL                    
                ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_C5 CURSOR FOR                                    
MFA-TR*        SELECT  DISTINCT  IG.TIER_CUST_STAT_CD                           
MFA-TR*                         ,IG.TIER_ACCT_TYPE_CD                           
MFA-TR*                         ,IG.MKT_TIER_RANKING                            
MFA-TR*                         ,IG.MKT_TIER_START_DT                           
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_TIER         IG  LEFT JOIN                       
MFA-TR*                CRM_OFF_MKT_TIER     DU                                  
MFA-TR*                                                                         
MFA-TR*            ON (DU.COMPANY_NO         =  IG.COMPANY_NO                   
MFA-TR*           AND  DU.TIER_CUST_STAT_CD  =  IG.TIER_CUST_STAT_CD            
MFA-TR*           AND  DU.TIER_ACCT_TYPE_CD  =  IG.TIER_ACCT_TYPE_CD            
MFA-TR*           AND  DU.MKT_TIER_RANKING   =  IG.MKT_TIER_RANKING             
MFA-TR*           AND  DU.MKT_TIER_START_DT  =  IG.MKT_TIER_START_DT            
MFA-TR*           AND  DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND  DU.OFF_TIER_VEND_TS  >=  :WS-CHECK-TIMESTAMP             
MFA-TR*           AND  DU.PROC_STATUS_CD     =  'AC'                            
MFA-TR*           AND  DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND  DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE                  
MFA-TR*           AND  DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE                  
MFA-TR*           AND  DU.TIER_DEFLT_OFFR_CD =  'Y'   )                         
MFA-TR*         WHERE  IG.COMPANY_NO         =  '01'                            
MFA-TR*           AND  IG.MKT_TIER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND  IG.MKT_TIER_END_DT    >= :WS-CHECK-DATE                  
MFA-TR*           AND  IG.MKT_TIER_RANKING   <> 999                             
MFA-TR*           AND  DU.TIER_DEFLT_OFFR_CD IS NULL                            
MFA-TR*         ORDER BY IG.TIER_CUST_STAT_CD,IG.TIER_ACCT_TYPE_CD              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD,TIER_ACCT_TYPE_CD,          *         
      * MKT_TIER_RANKING & MKT_TIER_START_DT THAT ARE HAVING MULTIPLE *         
      * ROWS WITH TIER_DEFLT_OFFR_CD = 'Y'                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OFF_MKT_TIER_C1 CURSOR FOR                        
               SELECT  DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,DU.TIER_DEFLT_OFFR_CD                            
                                                                        
                 FROM  CRM_OFF_MKT_TIER  DU WITH(READUNCOMMITTED)               
                                                                        
                WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO          
                  AND DU.MKT_TIER_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.OFFER_TIER_STRT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.OFFER_TIER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.TIER_DEFLT_OFFR_CD   =  'Y'                    
P00473            AND DU.OFF_TIER_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.OFF_TIER_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.PROC_STATUS_CD       =  'AC'                   
                GROUP BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD,     
                         DU.MKT_TIER_RANKING,DU.MKT_TIER_START_DT,      
                         DU.TIER_DEFLT_OFFR_CD,DU.COMPANY_NO            
                    HAVING COUNT(*)  >=  2                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFF_MKT_TIER_C1 CURSOR FOR                                
MFA-TR*        SELECT  DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,DU.TIER_DEFLT_OFFR_CD                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OFF_MKT_TIER  DU                                     
MFA-TR*                                                                         
MFA-TR*         WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO                  
MFA-TR*           AND DU.MKT_TIER_START_DT   <= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFFER_TIER_STRT_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFFER_TIER_END_DT   >= :WS-CHECK-DATE                  
MFA-TR*           AND DU.TIER_DEFLT_OFFR_CD   =  'Y'                            
MFA-TR*           AND DU.OFF_TIER_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.OFF_TIER_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.PROC_STATUS_CD       =  'AC'                           
MFA-TR*         GROUP BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD,             
MFA-TR*                  DU.MKT_TIER_RANKING,DU.MKT_TIER_START_DT,              
MFA-TR*                  DU.TIER_DEFLT_OFFR_CD,DU.COMPANY_NO                    
MFA-TR*             HAVING COUNT(*)  >=  2                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT    *         
      * ARE HAVING MULTIPLE ROWS WITH (PRIMARY KEY EXCLUDING          *         
      * OFFER_TIER_STRT_DT) & OFFER_TIER_STRT_DT <= CHECKER DATE   &  *         
      * OFFER_TIER_END_DT >= CHECKER DATE                             *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OFF_MKT_TIER_C2 CURSOR FOR                        
               SELECT  DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,DU.OFFER_CD                                      
                                                                        
                 FROM  CRM_OFF_MKT_TIER  DU WITH(READUNCOMMITTED)               
                                                                        
                WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO          
                  AND DU.MKT_TIER_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.OFFER_TIER_STRT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.OFFER_TIER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00473            AND DU.OFF_TIER_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.OFF_TIER_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.PROC_STATUS_CD       = 'AC'                    
                GROUP BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD,     
                         DU.MKT_TIER_RANKING,DU.MKT_TIER_START_DT,      
                         DU.OFFER_CD,DU.COMPANY_NO                      
                    HAVING COUNT(*)  >=  2                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFF_MKT_TIER_C2 CURSOR FOR                                
MFA-TR*        SELECT  DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OFF_MKT_TIER  DU                                     
MFA-TR*                                                                         
MFA-TR*         WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO                  
MFA-TR*           AND DU.MKT_TIER_START_DT   <= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFFER_TIER_STRT_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFFER_TIER_END_DT   >= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFF_TIER_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.OFF_TIER_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         GROUP BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD,             
MFA-TR*                  DU.MKT_TIER_RANKING,DU.MKT_TIER_START_DT,              
MFA-TR*                  DU.OFFER_CD,DU.COMPANY_NO                              
MFA-TR*             HAVING COUNT(*)  >=  2                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND ROWS WITH TIER_ACCT_TYPE_CD IN ('1','2')  &    *         
      * MKT_TIER_APPLY_CD <> 'O'                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OFF_MKT_TIER_C3 CURSOR FOR                        
               SELECT  DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,DU.OFFER_CD                                      
                      ,DU.OFFER_TIER_STRT_DT                            
                      ,DU.MKT_TIER_APPLY_CD                             
                                                                        
                 FROM  CRM_OFF_MKT_TIER  DU WITH(READUNCOMMITTED)               
                                                                        
                WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO          
                  AND DU.TIER_ACCT_TYPE_CD   IN ('1','2')               
                  AND DU.MKT_TIER_APPLY_CD   <> 'O'                     
                  AND DU.OFFER_TIER_STRT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND DU.OFFER_TIER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00473            AND DU.OFF_TIER_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.OFF_TIER_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.PROC_STATUS_CD       = 'AC'                    
                ORDER BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFF_MKT_TIER_C3 CURSOR FOR                                
MFA-TR*        SELECT  DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*               ,DU.OFFER_TIER_STRT_DT                                    
MFA-TR*               ,DU.MKT_TIER_APPLY_CD                                     
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OFF_MKT_TIER  DU                                     
MFA-TR*                                                                         
MFA-TR*         WHERE DU.COMPANY_NO          =  :WS-COMPANY-NO                  
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD   IN ('1','2')                       
MFA-TR*           AND DU.MKT_TIER_APPLY_CD   <> 'O'                             
MFA-TR*           AND DU.OFFER_TIER_STRT_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFFER_TIER_END_DT   >= :WS-CHECK-DATE                  
MFA-TR*           AND DU.OFF_TIER_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.OFF_TIER_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         ORDER BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
A00494*                                                                         
A00494*****************************************************************         
A00494* CURSOR TO FIND  TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD THAT    *         
A00494* DOES NOT HAVE VALID ROW IN CRM_MKT_TIER                       *         
A00494*****************************************************************         
A00494*                                                                         
A00494     EXEC SQL                                                     
A00494        DECLARE OFF_MKT_TIER_C4 CURSOR FOR                        
A00494         SELECT DISTINCT  DU.TIER_CUST_STAT_CD                    
A00494                         ,DU.TIER_ACCT_TYPE_CD                    
A00494                         ,DU.MKT_TIER_RANKING                     
A00494                         ,DU.MKT_TIER_START_DT                    
A00494                                                                  
A00494           FROM  CRM_OFF_MKT_TIER  DU
                           WITH(READUNCOMMITTED)  LEFT JOIN                  
A00494                 CRM_MKT_TIER      IG WITH(READUNCOMMITTED)               
A00494                                                                  
A00494             ON (IG.COMPANY_NO        =  DU.COMPANY_NO            
A00494            AND IG.TIER_CUST_STAT_CD  =  DU.TIER_CUST_STAT_CD     
A00494            AND IG.TIER_ACCT_TYPE_CD  =  DU.TIER_ACCT_TYPE_CD     
A00494            AND IG.MKT_TIER_RANKING   =  DU.MKT_TIER_RANKING      
A00494            AND IG.MKT_TIER_START_DT  =  DU.MKT_TIER_START_DT     
A00494            AND IG.MKT_TIER_START_DT <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A00494            AND IG.MKT_TIER_END_DT   >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A00494            AND IG.MKT_TIER_RANKING  <>  999)                     
A00494          WHERE DU.COMPANY_NO           =  :WS-COMPANY-NO         
A00494            AND DU.MKT_TIER_START_DT   <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
A00494            AND DU.OFFER_TIER_STRT_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
A00494            AND DU.OFFER_TIER_END_DT   >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
A00494            AND DU.TIER_DEFLT_OFFR_CD   =  'Y'                    
P00473            AND DU.OFF_TIER_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.OFF_TIER_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND DU.PROC_STATUS_CD       = 'AC'                    
A00494            AND IG.TIER_CUST_STAT_CD   IS  NULL                   
P00838            AND DU.TIER_CUST_STAT_CD   NOT IN ('L','W')           
A00494          ORDER BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD      
A00494                                                           
A00494     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFF_MKT_TIER_C4 CURSOR FOR                                
MFA-TR*        SELECT DISTINCT  DU.TIER_CUST_STAT_CD                            
MFA-TR*                        ,DU.TIER_ACCT_TYPE_CD                            
MFA-TR*                        ,DU.MKT_TIER_RANKING                             
MFA-TR*                        ,DU.MKT_TIER_START_DT                            
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OFF_MKT_TIER  DU  LEFT JOIN                          
MFA-TR*                CRM_MKT_TIER      IG                                     
MFA-TR*                                                                         
MFA-TR*            ON (IG.COMPANY_NO        =  DU.COMPANY_NO                    
MFA-TR*           AND IG.TIER_CUST_STAT_CD  =  DU.TIER_CUST_STAT_CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  =  DU.TIER_ACCT_TYPE_CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   =  DU.MKT_TIER_RANKING              
MFA-TR*           AND IG.MKT_TIER_START_DT  =  DU.MKT_TIER_START_DT             
MFA-TR*           AND IG.MKT_TIER_START_DT <=  :WS-CHECK-DATE                   
MFA-TR*           AND IG.MKT_TIER_END_DT   >=  :WS-CHECK-DATE                   
MFA-TR*           AND IG.MKT_TIER_RANKING  <>  999)                             
MFA-TR*         WHERE DU.COMPANY_NO           =  :WS-COMPANY-NO                 
MFA-TR*           AND DU.MKT_TIER_START_DT   <=  :WS-CHECK-DATE                 
MFA-TR*           AND DU.OFFER_TIER_STRT_DT  <=  :WS-CHECK-DATE                 
MFA-TR*           AND DU.OFFER_TIER_END_DT   >=  :WS-CHECK-DATE                 
MFA-TR*           AND DU.TIER_DEFLT_OFFR_CD   =  'Y'                            
MFA-TR*           AND DU.OFF_TIER_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.OFF_TIER_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND DU.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND IG.TIER_CUST_STAT_CD   IS  NULL                           
MFA-TR*           AND DU.TIER_CUST_STAT_CD   NOT IN ('L','W')                   
MFA-TR*         ORDER BY DU.TIER_CUST_STAT_CD,DU.TIER_ACCT_TYPE_CD              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
A00494*                                                                         
      *****************************************************************         
      * CURSOR TO FIND 'FIXED PRICE' FACTOR_ID ROWS THAT ARE HAVING   *         
      * BILL_PRT_MSG_PL_CD = SPACES OR OVR_RT_CALC_TYP_CD <> '02'  OR *         
      * OVR_RT_VER_PRO_FL  <> 'Y'   OR DURATION_START_CD  = SPACES OR *         
      * DURATION_TYPE_CD = SPACES                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SPCL_FCTR_C1 CURSOR FOR                           
               SELECT  SF.FACTOR_ID                                     
                      ,SF.BILL_PRT_MSG_PL_CD                            
                      ,SF.OVR_RT_CALC_TYP_CD                            
                      ,SF.OVR_RT_VER_PRO_FL                             
                      ,SF.DURATION_START_CD                             
                      ,SF.DURATION_TYPE_CD                              
                                                                        
                 FROM  CSS_SPCL_FCTR     SF WITH(READUNCOMMITTED)               
                                                                        
                WHERE SF.RT_ATTR_INCTV_TYPE  =  'FIXED PRICE'           
                  AND SF.FACTOR_ID     NOT LIKE 'INTRO%'                
                  AND ( (CIS.SUBSTR3(SF.FACTOR_ID,1,2) = 'FP'   AND          
                         SF.BILL_PRT_MSG_PL_CD  =  ' '  )  OR           
                        (SF.OVR_RT_CALC_TYP_CD  <> '02' )  OR           
                        (SF.OVR_RT_VER_PRO_FL   <> 'Y'  )  OR           
                        (SF.DURATION_START_CD   =  ' '  )  OR           
                        (SF.DURATION_TYPE_CD    =  ' '  )  )            
                ORDER BY SF.FACTOR_ID                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCTR_C1 CURSOR FOR                                   
MFA-TR*        SELECT  SF.FACTOR_ID                                             
MFA-TR*               ,SF.BILL_PRT_MSG_PL_CD                                    
MFA-TR*               ,SF.OVR_RT_CALC_TYP_CD                                    
MFA-TR*               ,SF.OVR_RT_VER_PRO_FL                                     
MFA-TR*               ,SF.DURATION_START_CD                                     
MFA-TR*               ,SF.DURATION_TYPE_CD                                      
MFA-TR*                                                                         
MFA-TR*          FROM  CSS_SPCL_FCTR     SF                                     
MFA-TR*                                                                         
MFA-TR*         WHERE SF.RT_ATTR_INCTV_TYPE  =  'FIXED PRICE'                   
MFA-TR*           AND SF.FACTOR_ID     NOT LIKE 'INTRO%'                        
MFA-TR*           AND ( (SUBSTR(SF.FACTOR_ID,1,2) = 'FP'   AND                  
MFA-TR*                  SF.BILL_PRT_MSG_PL_CD  =  ' '  )  OR                   
MFA-TR*                 (SF.OVR_RT_CALC_TYP_CD  <> '02' )  OR                   
MFA-TR*                 (SF.OVR_RT_VER_PRO_FL   <> 'Y'  )  OR                   
MFA-TR*                 (SF.DURATION_START_CD   =  ' '  )  OR                   
MFA-TR*                 (SF.DURATION_TYPE_CD    =  ' '  )  )                    
MFA-TR*         ORDER BY SF.FACTOR_ID                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND FACTOR_ID WITH CMPNT_ID_CD = SPACES            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SPCL_FCTR_C2 CURSOR FOR                           
               SELECT  SF.FACTOR_ID                                     
                      ,SA.CODE_UTIL_TYPE                                
                      ,SA.RATE_PLAN_NO                                  
                      ,SA.DATE_FROM                                     
                      ,SA.ENTRY_NO                                      
                      ,SA.DATE_TO                                       
                      ,SA.CMPNT_ID_CD                                   
                                                                        
                 FROM  CSS_SPCL_FCTR         SF WITH(READUNCOMMITTED)           
                      ,CSS_SPCL_FCTR_APPL    SA WITH(READUNCOMMITTED)           
                                                                        
                WHERE SF.FACTOR_ID        =   SA.FACTOR_ID              
C37780            AND SA.CODE_UTIL_TYPE   =   'G'                       
                  AND SA.DATE_FROM        <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND SA.DATE_TO          >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND SA.CMPNT_ID_CD      =   ' '                       
                ORDER BY SF.FACTOR_ID                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCTR_C2 CURSOR FOR                                   
MFA-TR*        SELECT  SF.FACTOR_ID                                             
MFA-TR*               ,SA.CODE_UTIL_TYPE                                        
MFA-TR*               ,SA.RATE_PLAN_NO                                          
MFA-TR*               ,SA.DATE_FROM                                             
MFA-TR*               ,SA.ENTRY_NO                                              
MFA-TR*               ,SA.DATE_TO                                               
MFA-TR*               ,SA.CMPNT_ID_CD                                           
MFA-TR*                                                                         
MFA-TR*          FROM  CSS_SPCL_FCTR         SF                                 
MFA-TR*               ,CSS_SPCL_FCTR_APPL    SA                                 
MFA-TR*                                                                         
MFA-TR*         WHERE SF.FACTOR_ID        =   SA.FACTOR_ID                      
MFA-TR*           AND SA.CODE_UTIL_TYPE   =   'G'                               
MFA-TR*           AND SA.DATE_FROM        <=  :WS-CHECK-DATE                    
MFA-TR*           AND SA.DATE_TO          >=  :WS-CHECK-DATE                    
MFA-TR*           AND SA.CMPNT_ID_CD      =   ' '                               
MFA-TR*         ORDER BY SF.FACTOR_ID                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND FACTOR_ID WITH DISPLAY TIMESTAMP ISSUES        *         
      * ( INT_DISP_START_TS  >  INT_DISP_END_TS ) OR                  *         
      * ( EXT_DISP_START_TS  >  EXT_DISP_END_TS )                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SPCL_FCTR_C3 CURSOR FOR                           
               SELECT  SA.CODE_UTIL_TYPE                                
                      ,SA.RATE_PLAN_NO                                  
                      ,SA.FACTOR_ID                                     
                      ,SA.DATE_FROM                                     
                      ,SA.ENTRY_NO                                      
                                                                        
                 FROM  CSS_SPCL_FCTR_APPL    SA WITH(READUNCOMMITTED)           
                                                                        
C37780          WHERE SA.CODE_UTIL_TYPE    =   'G'                      
                  AND SA.DATE_FROM         <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND SA.DATE_TO           >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND SA.INT_DISP_START_TS >   SA.INT_DISP_END_TS       
                ORDER BY SA.FACTOR_ID                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCTR_C3 CURSOR FOR                                   
MFA-TR*        SELECT  SA.CODE_UTIL_TYPE                                        
MFA-TR*               ,SA.RATE_PLAN_NO                                          
MFA-TR*               ,SA.FACTOR_ID                                             
MFA-TR*               ,SA.DATE_FROM                                             
MFA-TR*               ,SA.ENTRY_NO                                              
MFA-TR*                                                                         
MFA-TR*          FROM  CSS_SPCL_FCTR_APPL    SA                                 
MFA-TR*                                                                         
MFA-TR*         WHERE SA.CODE_UTIL_TYPE    =   'G'                              
MFA-TR*           AND SA.DATE_FROM         <=  :WS-CHECK-DATE                   
MFA-TR*           AND SA.DATE_TO           >=  :WS-CHECK-DATE                   
MFA-TR*           AND SA.INT_DISP_START_TS >   SA.INT_DISP_END_TS               
MFA-TR*         ORDER BY SA.FACTOR_ID                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
A04319*****************************************************************         
A04319* CURSOR TO FIND RATE_PLAN_NO WITH MULTIPLE ACTIVE FACTORS      *         
A04319* ( CODE_STATUS     IN ('A','E')                                *         
A04319*****************************************************************         
A04319*                                                                         
A04319     EXEC SQL                                                     
A04319        DECLARE SPCL_FCTR_C4 CURSOR FOR                           
A04319         SELECT SA.CODE_UTIL_TYPE                                 
A04319               ,SA.RATE_PLAN_NO                                   
A04319               ,SA.FACTOR_ID                                      
A04319               ,SA.CMPNT_ID_CD                                    
A04319               ,SA.BLOCK_NO                                       
A04319               ,SA.CODE_SEASON                                    
A04319               ,SA.CODE_TIME_PERIOD                               
A04319               ,SA.INSTR_USE_TYPE_CD                              
A04319           FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
A04319          WHERE SA.CODE_UTIL_TYPE   = 'G'                         
A04319            AND SA.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
A04319            AND SA.DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
A04319            AND SA.CODE_STATUS     IN ('A','E')                   
A04319         GROUP BY SA.CODE_UTIL_TYPE                               
A04319                 ,SA.RATE_PLAN_NO                                 
A04319                 ,SA.FACTOR_ID                                    
A04319                 ,SA.CMPNT_ID_CD                                  
A04319                 ,SA.BLOCK_NO                                     
A04319                 ,SA.CODE_SEASON                                  
A04319                 ,SA.CODE_TIME_PERIOD                             
A04319                 ,SA.INSTR_USE_TYPE_CD                            
A04319         HAVING COUNT(*) > 1                                      
A04319                                                           
A04319     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCTR_C4 CURSOR FOR                                   
MFA-TR*        SELECT SA.CODE_UTIL_TYPE                                         
MFA-TR*              ,SA.RATE_PLAN_NO                                           
MFA-TR*              ,SA.FACTOR_ID                                              
MFA-TR*              ,SA.CMPNT_ID_CD                                            
MFA-TR*              ,SA.BLOCK_NO                                               
MFA-TR*              ,SA.CODE_SEASON                                            
MFA-TR*              ,SA.CODE_TIME_PERIOD                                       
MFA-TR*              ,SA.INSTR_USE_TYPE_CD                                      
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*         WHERE SA.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND SA.DATE_FROM       <= :WS-CHECK-DATE                      
MFA-TR*           AND SA.DATE_TO         >= :WS-CHECK-DATE                      
MFA-TR*           AND SA.CODE_STATUS     IN ('A','E')                           
MFA-TR*        GROUP BY SA.CODE_UTIL_TYPE                                       
MFA-TR*                ,SA.RATE_PLAN_NO                                         
MFA-TR*                ,SA.FACTOR_ID                                            
MFA-TR*                ,SA.CMPNT_ID_CD                                          
MFA-TR*                ,SA.BLOCK_NO                                             
MFA-TR*                ,SA.CODE_SEASON                                          
MFA-TR*                ,SA.CODE_TIME_PERIOD                                     
MFA-TR*                ,SA.INSTR_USE_TYPE_CD                                    
MFA-TR*        HAVING COUNT(*) > 1                                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
A04221*                                                                         
A04221*****************************************************************         
A04221* CURSOR TO FIND RATE/FACTOR WITH MULTIPLE FACTORS FOR ANY      *         
A04221* GIVEN START / END DISPLAY TIMESTAMP                           *         
A04221*****************************************************************         
A04221*                                                                         
A04221     EXEC SQL                                                     
A04221        DECLARE SPCL_FCTR_C5 CURSOR FOR                           
A04221         SELECT SA.RATE_PLAN_NO                                   
A04221               ,SA.FACTOR_ID                                      
A04221           FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
A04221               ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
A04221          WHERE SA.FACTOR_ID           = SF.FACTOR_ID             
A04221            AND SA.CODE_UTIL_TYPE      = 'G'                      
A04221            AND SA.CODE_STATUS        IN ('A', 'E')               
A04221            AND SF.RT_ATTR_INCTV_TYPE  > ' '                      
A04221            AND SA.INT_DISP_START_TS  <= CIS.CURRENT$TIMESTAMP()        
A04221            AND SA.INT_DISP_END_TS    >= CIS.CURRENT$TIMESTAMP()        
A04221         GROUP BY SA.RATE_PLAN_NO, SA.FACTOR_ID                   
A04221         HAVING COUNT(*) >= 2                                     
A04221         ORDER BY SA.RATE_PLAN_NO, SA.FACTOR_ID                   
A04221                                                      
A04221                                                           
A04221     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCTR_C5 CURSOR FOR                                   
MFA-TR*        SELECT SA.RATE_PLAN_NO                                           
MFA-TR*              ,SA.FACTOR_ID                                              
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR      SF                                     
MFA-TR*         WHERE SA.FACTOR_ID           = SF.FACTOR_ID                     
MFA-TR*           AND SA.CODE_UTIL_TYPE      = 'G'                              
MFA-TR*           AND SA.CODE_STATUS        IN ('A', 'E')                       
MFA-TR*           AND SF.RT_ATTR_INCTV_TYPE  > ' '                              
MFA-TR*           AND SA.INT_DISP_START_TS  <= CURRENT TIMESTAMP                
MFA-TR*           AND SA.INT_DISP_END_TS    >= CURRENT TIMESTAMP                
MFA-TR*        GROUP BY SA.RATE_PLAN_NO, SA.FACTOR_ID                           
MFA-TR*        HAVING COUNT(*) >= 2                                             
MFA-TR*        ORDER BY SA.RATE_PLAN_NO, SA.FACTOR_ID                           
MFA-TR*        QUERYNO 7141                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
A04221*                                                                         
      *****************************************************************         
      * CURSOR TO FIND REPLACMNT_PROMO_CD (<> SPACES) THAT DOES NOT   *         
      * EXISTS AS A VALID PROMOTION IN CRM_MKT_PROMOTION TABLE        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_PROMOTION_C1 CURSOR FOR                       
               SELECT  KM.REPLACMNT_PROMO_CD                            
                                                                        
                 FROM  CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)            
                                                                        
                WHERE KM.COMPANY_NO          =  :WS-COMPANY-NO          
                  AND KM.PROMO_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND KM.PROMO_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND KM.REPLACMNT_PROMO_CD  >  ' '                     
P00473            AND KM.PROMO_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND KM.PROMO_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND KM.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_MKT_PROMOTION    ZZ
                           WITH(READUNCOMMITTED)                   
                        WHERE ZZ.COMPANY_NO       =  KM.COMPANY_NO      
                          AND ZZ.PROMO_CD        = KM.REPLACMNT_PROMO_CD
P00473                    AND ZZ.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) 
P00473                    AND ZZ.PROMO_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) 
P00473                    AND ZZ.PROC_STATUS_CD   = 'AC'                
                          AND ZZ.PROMO_START_DT  <=  
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )     
                          AND ZZ.PROMO_END_DT    >=  
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) )   
                ORDER BY KM.REPLACMNT_PROMO_CD                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_PROMOTION_C1 CURSOR FOR                               
MFA-TR*        SELECT  KM.REPLACMNT_PROMO_CD                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_PROMOTION    KM                                  
MFA-TR*                                                                         
MFA-TR*         WHERE KM.COMPANY_NO          =  :WS-COMPANY-NO                  
MFA-TR*           AND KM.PROMO_START_DT      <= :WS-CHECK-DATE                  
MFA-TR*           AND KM.PROMO_END_DT        >= :WS-CHECK-DATE                  
MFA-TR*           AND KM.REPLACMNT_PROMO_CD  >  ' '                             
MFA-TR*           AND KM.PROMO_VSTART_TS     <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND KM.PROMO_VEND_TS       >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND KM.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_MKT_PROMOTION    ZZ                           
MFA-TR*                 WHERE ZZ.COMPANY_NO       =  KM.COMPANY_NO              
MFA-TR*                   AND ZZ.PROMO_CD        = KM.REPLACMNT_PROMO_CD        
MFA-TR*                   AND ZZ.PROMO_VSTART_TS <= :WS-CHECK-TIMESTAMP         
MFA-TR*                   AND ZZ.PROMO_VEND_TS   >= :WS-CHECK-TIMESTAMP         
MFA-TR*                   AND ZZ.PROC_STATUS_CD   = 'AC'                        
MFA-TR*                   AND ZZ.PROMO_START_DT  <=  :WS-CHECK-DATE             
MFA-TR*                   AND ZZ.PROMO_END_DT    >=  :WS-CHECK-DATE )           
MFA-TR*         ORDER BY KM.REPLACMNT_PROMO_CD                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND PROMO_CD WITH PROMO_DESC/PROMO_DESC_LONG=SPACES*         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MKT_PROMOTION_C2 CURSOR FOR                       
               SELECT  KM.PROMO_CD                                      
                                                                        
                 FROM  CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)            
                                                                        
                WHERE KM.COMPANY_NO       = :WS-COMPANY-NO              
                  AND KM.PROMO_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
                  AND KM.PROMO_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
                  AND ( KM.PROMO_DESC     =  ' '  OR                    
                      KM.PROMO_DESC_LONG  =  ' '  )                     
P00473            AND KM.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )         
P00473            AND KM.PROMO_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )         
P00473            AND KM.PROC_STATUS_CD   = 'AC'                        
                ORDER BY KM.PROMO_CD                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_PROMOTION_C2 CURSOR FOR                               
MFA-TR*        SELECT  KM.PROMO_CD                                              
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_MKT_PROMOTION    KM                                  
MFA-TR*                                                                         
MFA-TR*         WHERE KM.COMPANY_NO       = :WS-COMPANY-NO                      
MFA-TR*           AND KM.PROMO_START_DT  <= :WS-CHECK-DATE                      
MFA-TR*           AND KM.PROMO_END_DT    >= :WS-CHECK-DATE                      
MFA-TR*           AND ( KM.PROMO_DESC     =  ' '  OR                            
MFA-TR*               KM.PROMO_DESC_LONG  =  ' '  )                             
MFA-TR*           AND KM.PROMO_VSTART_TS <= :WS-CHECK-TIMESTAMP                 
MFA-TR*           AND KM.PROMO_VEND_TS   >= :WS-CHECK-TIMESTAMP                 
MFA-TR*           AND KM.PROC_STATUS_CD   = 'AC'                                
MFA-TR*         ORDER BY KM.PROMO_CD                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RATE_GROUP_TYPE_CD & RATE_GROUP_CD WITH        *         
      * RATE_GRP_DESC = SPACES                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE RATE_GROUP_C1    CURSOR FOR                       
               SELECT  F7.RATE_GROUP_TYPE_CD                            
                      ,F7.RATE_GROUP_CD                                 
                                                                        
                 FROM  CRM_RATE_GROUP      F7 WITH(READUNCOMMITTED)             
                                                                        
                WHERE F7.COMPANY_NO      =   :WS-COMPANY-NO             
                  AND F7.RATE_GRP_DESC   =   ' '                        
                ORDER BY F7.RATE_GROUP_TYPE_CD,F7.RATE_GROUP_CD         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATE_GROUP_C1    CURSOR FOR                               
MFA-TR*        SELECT  F7.RATE_GROUP_TYPE_CD                                    
MFA-TR*               ,F7.RATE_GROUP_CD                                         
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RATE_GROUP      F7                                   
MFA-TR*                                                                         
MFA-TR*         WHERE F7.COMPANY_NO      =   :WS-COMPANY-NO                     
MFA-TR*           AND F7.RATE_GRP_DESC   =   ' '                                
MFA-TR*         ORDER BY F7.RATE_GROUP_TYPE_CD,F7.RATE_GROUP_CD                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RATE_GROUP_TYPE_CD, RATE_GROUP_CD &            *         
      * EFF_START_DT THAT ARE HAVING MULTIPLE ROWS WITH SAME "OFFER"  *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE RATE_GROUP_C2 CURSOR FOR                          
               SELECT  G5.RATE_GROUP_TYPE_CD                            
                      ,G5.RATE_GROUP_CD                                 
                      ,G5.EFF_START_DT                                  
                      ,G5.OFFER_CD                                      
                                                                        
                 FROM  CRM_RATE_GRP_OFFER  G5 WITH(READUNCOMMITTED)             
                                                                        
                WHERE G5.COMPANY_NO           =  :WS-COMPANY-NO         
                  AND G5.EFF_START_DT        <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND G5.EFF_END_DT          >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00473            AND G5.GRP_OFF_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND G5.GRP_OFF_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND G5.PROC_STATUS_CD       = 'AC'                    
                GROUP BY G5.RATE_GROUP_TYPE_CD,G5.RATE_GROUP_CD,        
                         G5.EFF_START_DT,G5.OFFER_CD,G5.COMPANY_NO      
               HAVING COUNT(*)  >=  2                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATE_GROUP_C2 CURSOR FOR                                  
MFA-TR*        SELECT  G5.RATE_GROUP_TYPE_CD                                    
MFA-TR*               ,G5.RATE_GROUP_CD                                         
MFA-TR*               ,G5.EFF_START_DT                                          
MFA-TR*               ,G5.OFFER_CD                                              
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RATE_GRP_OFFER  G5                                   
MFA-TR*                                                                         
MFA-TR*         WHERE G5.COMPANY_NO           =  :WS-COMPANY-NO                 
MFA-TR*           AND G5.EFF_START_DT        <= :WS-CHECK-DATE                  
MFA-TR*           AND G5.EFF_END_DT          >= :WS-CHECK-DATE                  
MFA-TR*           AND G5.GRP_OFF_VSTART_TS   <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND G5.GRP_OFF_VEND_TS     >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND G5.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         GROUP BY G5.RATE_GROUP_TYPE_CD,G5.RATE_GROUP_CD,                
MFA-TR*                  G5.EFF_START_DT,G5.OFFER_CD,G5.COMPANY_NO              
MFA-TR*        HAVING COUNT(*)  >=  2                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RATE_GROUP_TYPE_CD & RATE_GROUP_CD THAT MEET   *         
      * CONDITION (EFF_START_DT > WS-CHECK-DATE)  OR                  *         
      *           (EFF_END_DT   < WS-CHECK-DATE)  OR                  *         
      *****************************************************************         
      *                                                                         
      *    EXEC SQL                                                             
      *       DECLARE RATE_GROUP_C3 CURSOR FOR                                  
      *        SELECT  G5.RATE_GROUP_TYPE_CD                                    
      *               ,G5.RATE_GROUP_CD                                         
      *               ,G5.EFF_START_DT                                          
      *               ,G5.EFF_END_DT                                            
      *               ,G5.OFFER_CD                                              
      *                                                                         
      *          FROM  CRM_RATE_GRP_OFFER  G5                                   
      *                                                                         
      *         WHERE G5.COMPANY_NO          =  :WS-COMPANY-NO                  
      *           AND ( (G5.EFF_START_DT  >  :WS-CHECK-DATE) OR                 
      *                 (G5.EFF_END_DT    <  :WS-CHECK-DATE) )                  
      *         ORDER BY G5.RATE_GROUP_TYPE_CD,G5.RATE_GROUP_CD                 
      *        WITH UR                                                          
      *    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OPTION_CD WITH ANY DESCRIPTION = SPACES        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OPT_C2 CURSOR FOR                           
               SELECT  DISTINCT  FI.OPTION_CD                           
                                                                        
                 FROM  CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                                                                        
                WHERE FI.COMPANY_NO           =   :WS-COMPANY-NO        
C37780            AND FI.CODE_UTIL_TYPE       =   'G'                   
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.STATUS_CD            =   'A'                   
P00473            AND FI.OPT_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.OPT_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.PROC_STATUS_CD       = 'AC'                    
                  AND ( FI.OPT_DESC_INT        =  ' '  OR               
                        FI.OPT_DESC_INT_LONG   =  ' '  OR               
                        FI.CURR_EXT_DESC_LONG  =  ' '  OR               
                        FI.RENEWAL_DESC_LONG   =  ' '  OR               
                        FI.WEB_DESC_LONG       =  ' '  )                
                ORDER BY FI.OPTION_CD                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OPT_C2 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FI.OPTION_CD                                   
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OPTION   FI                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FI.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND FI.CODE_UTIL_TYPE       =   'G'                           
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.STATUS_CD            =   'A'                           
MFA-TR*           AND FI.OPT_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND ( FI.OPT_DESC_INT        =  ' '  OR                       
MFA-TR*                 FI.OPT_DESC_INT_LONG   =  ' '  OR                       
MFA-TR*                 FI.CURR_EXT_DESC_LONG  =  ' '  OR                       
MFA-TR*                 FI.RENEWAL_DESC_LONG   =  ' '  OR                       
MFA-TR*                 FI.WEB_DESC_LONG       =  ' '  )                        
MFA-TR*         ORDER BY FI.OPTION_CD                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OPTION_CD WITH TRAILING SPACES                 *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OPT_C3 CURSOR FOR                           
               SELECT  DISTINCT  FI.OPTION_CD                           
                                                                        
                 FROM  CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                                                                        
                WHERE FI.COMPANY_NO          =   :WS-COMPANY-NO         
C37780            AND FI.CODE_UTIL_TYPE      =   'G'                    
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.STATUS_CD           =   'A'                    
                  AND DATALENGTH(FI.OPTION_CD) > DATALENGTH(RTRIM(
           FI.OPTION_CD))
P00473            AND FI.OPT_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.OPT_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.PROC_STATUS_CD       = 'AC'                    
                ORDER BY FI.OPTION_CD                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OPT_C3 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FI.OPTION_CD                                   
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OPTION   FI                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FI.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND FI.CODE_UTIL_TYPE      =   'G'                            
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.STATUS_CD           =   'A'                            
MFA-TR*           AND LENGTH(FI.OPTION_CD) > LENGTH(RTRIM(FI.OPTION_CD))        
MFA-TR*           AND FI.OPT_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         ORDER BY FI.OPTION_CD                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RATE_PLAN_NO OF A VALID OPTION_CD FROM         *         
      * CRM_RT_PKG_OPTION THAT DOES NOT HAS A CORRESPONDING ENTRY IN  *         
      * CSS_RATE_CREATOR TABLE                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OPT_C4 CURSOR FOR                           
               SELECT  DISTINCT  FI.OPTION_CD                           
                                ,FI.RATE_PLAN_NO                        
                                                                        
                 FROM  CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                                                                        
                WHERE FI.COMPANY_NO          =   :WS-COMPANY-NO         
C37780            AND FI.CODE_UTIL_TYPE      =   'G'                    
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.STATUS_CD           =   'A'                    
P00473            AND FI.OPT_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.OPT_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                  (SELECT 1                                             
                     FROM CSS_RATE_CREATOR   RT WITH(READUNCOMMITTED)           
                    WHERE RT.CODE_UTIL_TYPE  =   FI.CODE_UTIL_TYPE      
                      AND RT.RATE_PLAN_NO    =   FI.RATE_PLAN_NO        
                      AND RT.CODE_STATUS     =   'A'                    
                      AND CAST(RT.DISPLAY_START_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )   
                      AND CAST(RT.DISPLAY_END_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )   
                      AND RT.VERSION_NO_CNTRL  IN (                     
                          SELECT MAX(ZZ.VERSION_NO_CNTRL)               
                            FROM CSS_RATE_CREATOR   ZZ
                           WITH(READUNCOMMITTED)                  
                           WHERE ZZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE  
                             AND ZZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO    
                             AND ZZ.CODE_STATUS    = RT.CODE_STATUS     
                             AND CAST(RT.DISPLAY_START_TS AS DATE) <=           
                                                  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )        
                             AND CAST(RT.DISPLAY_END_TS AS DATE)   >=           
                                                  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) ) )    
                ORDER BY FI.OPTION_CD                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OPT_C4 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FI.OPTION_CD                                   
MFA-TR*                         ,FI.RATE_PLAN_NO                                
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OPTION   FI                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FI.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND FI.CODE_UTIL_TYPE      =   'G'                            
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.STATUS_CD           =   'A'                            
MFA-TR*           AND FI.OPT_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CSS_RATE_CREATOR   RT                                 
MFA-TR*             WHERE RT.CODE_UTIL_TYPE  =   FI.CODE_UTIL_TYPE              
MFA-TR*               AND RT.RATE_PLAN_NO    =   FI.RATE_PLAN_NO                
MFA-TR*               AND RT.CODE_STATUS     =   'A'                            
MFA-TR*               AND DATE(RT.DISPLAY_START_TS) <= :WS-CHECK-DATE           
MFA-TR*               AND DATE(RT.DISPLAY_END_TS)   >= :WS-CHECK-DATE           
MFA-TR*               AND RT.VERSION_NO_CNTRL  IN (                             
MFA-TR*                   SELECT MAX(ZZ.VERSION_NO_CNTRL)                       
MFA-TR*                     FROM CSS_RATE_CREATOR   ZZ                          
MFA-TR*                    WHERE ZZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE          
MFA-TR*                      AND ZZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO            
MFA-TR*                      AND ZZ.CODE_STATUS    = RT.CODE_STATUS             
MFA-TR*                      AND DATE(RT.DISPLAY_START_TS) <=                   
MFA-TR*                                           :WS-CHECK-DATE                
MFA-TR*                      AND DATE(RT.DISPLAY_END_TS)   >=                   
MFA-TR*                                           :WS-CHECK-DATE ) )            
MFA-TR*         ORDER BY FI.OPTION_CD                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
P00396*****************************************************************         
P00396* CURSOR TO FIND RENEWAL_DESC_LONG > DELINQUENCY LENGTH ON      *         
P00396* CRM_RT_PKG_OPTION TABLE                                       *         
P00396*****************************************************************         
P00396     EXEC SQL                                                     
P00396        DECLARE RTPKG_OPT_C5 CURSOR FOR                           
P00396         SELECT FI.OPTION_CD                                      
P00396           FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00396          WHERE FI.COMPANY_NO       = :WS-COMPANY-NO              
P00396            AND FI.CODE_UTIL_TYPE   = 'G'                         
P00396            AND FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
P00396            AND FI.OPTION_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )              
P00396            AND FI.STATUS_CD        = 'A'                         
P00396            AND FI.OPT_CALC_TYPE_CD = 'FP'                        
P00396            AND DATALENGTH(LTRIM(RTRIM(FI.RENEWAL_DESC_LONG))) >          
P00396                                            :WS-LEN-LIMIT         
P00473            AND FI.OPT_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.OPT_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FI.PROC_STATUS_CD       = 'AC'                    
P00396          ORDER BY FI.OPTION_CD                                   
P00396                                                      
P00396                                                           
P00396     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OPT_C5 CURSOR FOR                                   
MFA-TR*        SELECT FI.OPTION_CD                                              
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO       = :WS-COMPANY-NO                      
MFA-TR*           AND FI.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND FI.OPTION_START_DT <= :WS-CHECK-DATE                      
MFA-TR*           AND FI.OPTION_END_DT   >= :WS-CHECK-DATE                      
MFA-TR*           AND FI.STATUS_CD        = 'A'                                 
MFA-TR*           AND FI.OPT_CALC_TYPE_CD = 'FP'                                
MFA-TR*           AND LENGTH(STRIP(FI.RENEWAL_DESC_LONG)) >                     
MFA-TR*                                           :WS-LEN-LIMIT                 
MFA-TR*           AND FI.OPT_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         ORDER BY FI.OPTION_CD                                           
MFA-TR*        QUERYNO 7442                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OFFER_CD THAT IS VALID IN CRM_RT_PKG_OFFER     *         
      * TABLE BUT ENTRY DOES NOT EXISTS IN CRM_OFFER_OPTION           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C1 CURSOR FOR                           
               SELECT  DISTINCT  FG.OFFER_CD                            
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND FG.OFFER_START_DT      <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.OFFER_END_DT        >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00473            AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                  (SELECT 1                                             
                     FROM CRM_OFFER_OPTION   E9 WITH(READUNCOMMITTED)           
                    WHERE E9.COMPANY_NO         =   FG.COMPANY_NO       
P00473                AND E9.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )   
P00473                AND E9.OFF_OPT_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )   
P00473                AND E9.PROC_STATUS_CD     = 'AC'                  
                      AND E9.OFFER_CD           =   FG.OFFER_CD         
P00269                AND E9.OFFER_OPT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )       
P00269                AND E9.OFFER_OPT_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) )     
                ORDER BY FG.OFFER_CD                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C1 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FG.OFFER_CD                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND FG.OFFER_START_DT      <=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFFER_END_DT        >=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CRM_OFFER_OPTION   E9                                 
MFA-TR*             WHERE E9.COMPANY_NO         =   FG.COMPANY_NO               
MFA-TR*               AND E9.OFF_OPT_VSTART_TS <= :WS-CHECK-TIMESTAMP           
MFA-TR*               AND E9.OFF_OPT_VEND_TS   >= :WS-CHECK-TIMESTAMP           
MFA-TR*               AND E9.PROC_STATUS_CD     = 'AC'                          
MFA-TR*               AND E9.OFFER_CD           =   FG.OFFER_CD                 
MFA-TR*               AND E9.OFFER_OPT_START_DT <= :WS-CHECK-DATE               
MFA-TR*               AND E9.OFFER_OPT_END_DT   >= :WS-CHECK-DATE )             
MFA-TR*         ORDER BY FG.OFFER_CD                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND VALID OFFER_CD IN CRM_RT_PKG_OFFER WITH        *         
      * (DISP_START_INT_TS/DISP_START_EXT_TS  <  OFFER_START_DT)  OR  *         
      * (DISP_END_INT_TS/DISP_END_EXT_TS      >  OFFER_END_DT  )      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C2 CURSOR FOR                           
               SELECT  FG.OFFER_CD                                      
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO           =  :WS-COMPANY-NO         
                  AND FG.OFFER_START_DT      <   IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.OFFER_END_DT        >   IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND ((FG.OFFER_START_DT >  CAST(FG.DISP_START_INT_TS
            AS DATE))
                   OR  (FG.OFFER_START_DT >  CAST(FG.DISP_START_EXT_TS
            AS DATE))
                   OR  (FG.OFFER_END_DT <  CAST(FG.DISP_END_INT_TS
            AS DATE))    
                   OR  (FG.OFFER_END_DT <  CAST(FG.DISP_END_EXT_TS
            AS DATE))  ) 
P00473            AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.PROC_STATUS_CD       = 'AC'                    
                ORDER BY FG.OFFER_CD                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C2 CURSOR FOR                                   
MFA-TR*        SELECT  FG.OFFER_CD                                              
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO           =  :WS-COMPANY-NO                 
MFA-TR*           AND FG.OFFER_START_DT      <   :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFFER_END_DT        >   :WS-CHECK-DATE                 
MFA-TR*           AND ((FG.OFFER_START_DT >  DATE(FG.DISP_START_INT_TS))        
MFA-TR*            OR  (FG.OFFER_START_DT >  DATE(FG.DISP_START_EXT_TS))        
MFA-TR*            OR  (FG.OFFER_END_DT <  DATE(FG.DISP_END_INT_TS))            
MFA-TR*            OR  (FG.OFFER_END_DT <  DATE(FG.DISP_END_EXT_TS))  )         
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         ORDER BY FG.OFFER_CD                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OFFER_CD WITH TRAILING SPACES                  *         
      *****************************************************************         
      *                                                                         
      *    EXEC SQL                                                             
      *       DECLARE RTPKG_OFF_C3 CURSOR FOR                                   
      *        SELECT  FG.OFFER_CD                                              
      *                                                                         
      *          FROM  CRM_RT_PKG_OFFER    FG                                   
      *                                                                         
      *         WHERE FG.COMPANY_NO          =   :WS-COMPANY-NO                 
      *           AND FG.OFFER_START_DT      <=  :WS-CHECK-DATE                 
      *           AND FG.OFFER_END_DT        >=  :WS-CHECK-DATE                 
      *           AND LENGTH(FG.OFFER_CD)  >  LENGTH(RTRIM(FG.OFFER_CD))        
      *         ORDER BY FG.OFFER_CD                                            
      *        WITH UR                                                          
      *    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OFFER_CD THAT IS VALID IN CRM_RT_PKG_OFFER     *         
      * TABLE BUT ENTRY DOES NOT EXISTS IN CRM_OFF_MKT_TIER           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C4 CURSOR FOR                           
               SELECT  DISTINCT  FG.OFFER_CD                            
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND FG.OFFER_START_DT      <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.OFFER_END_DT        >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00473            AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                  (SELECT 1                                             
                     FROM CRM_OFF_MKT_TIER   DU WITH(READUNCOMMITTED)           
                    WHERE DU.COMPANY_NO          =  FG.COMPANY_NO       
                      AND DU.OFFER_CD            =  FG.OFFER_CD         
P00473                AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )  
P00473                AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )  
P00473                AND DU.PROC_STATUS_CD      =  'AC'                
                      AND DU.MKT_TIER_START_DT  <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )       
                      AND DU.OFFER_TIER_STRT_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )       
                      AND DU.OFFER_TIER_END_DT  >= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )  )    
P805CS            AND FG.OFFER_CD NOT LIKE 'P00805%'                    
                ORDER BY FG.OFFER_CD                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C4 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FG.OFFER_CD                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND FG.OFFER_START_DT      <=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFFER_END_DT        >=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CRM_OFF_MKT_TIER   DU                                 
MFA-TR*             WHERE DU.COMPANY_NO          =  FG.COMPANY_NO               
MFA-TR*               AND DU.OFFER_CD            =  FG.OFFER_CD                 
MFA-TR*               AND DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP          
MFA-TR*               AND DU.OFF_TIER_VEND_TS   >= :WS-CHECK-TIMESTAMP          
MFA-TR*               AND DU.PROC_STATUS_CD      =  'AC'                        
MFA-TR*               AND DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE               
MFA-TR*               AND DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE               
MFA-TR*               AND DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE  )            
MFA-TR*           AND FG.OFFER_CD NOT LIKE 'P00805%'                            
MFA-TR*         ORDER BY FG.OFFER_CD                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RENEWAL_OFFER_CD FROM CRM_RT_PKG_OFFER THAT    *         
      * DOES NOT EXISTS AS VALID ACTIVE OFFER_CD IN CRM_RT_PKG_OFFER  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C5 CURSOR FOR                           
               SELECT  DISTINCT  FG.RENEWAL_OFFER_CD                    
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND FG.OFFER_START_DT      <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.OFFER_END_DT        >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.RENEWAL_OFFER_CD    >   ' '                    
P00473            AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                  (SELECT 1                                             
                     FROM CRM_RT_PKG_OFFER    ZZ WITH(READUNCOMMITTED)          
                    WHERE ZZ.COMPANY_NO      =  FG.COMPANY_NO           
                      AND ZZ.OFFER_CD        =  FG.RENEWAL_OFFER_CD     
P00473                AND ZZ.OFF_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473                AND ZZ.OFF_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473                AND ZZ.PROC_STATUS_CD   = 'AC'                    
                      AND ZZ.OFFER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                      AND ZZ.OFFER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )   )      
                ORDER BY FG.RENEWAL_OFFER_CD                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C5 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FG.RENEWAL_OFFER_CD                            
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND FG.OFFER_START_DT      <=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFFER_END_DT        >=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.RENEWAL_OFFER_CD    >   ' '                            
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CRM_RT_PKG_OFFER    ZZ                                
MFA-TR*             WHERE ZZ.COMPANY_NO      =  FG.COMPANY_NO                   
MFA-TR*               AND ZZ.OFFER_CD        =  FG.RENEWAL_OFFER_CD             
MFA-TR*               AND ZZ.OFF_VSTART_TS   <= :WS-CHECK-TIMESTAMP             
MFA-TR*               AND ZZ.OFF_VEND_TS     >= :WS-CHECK-TIMESTAMP             
MFA-TR*               AND ZZ.PROC_STATUS_CD   = 'AC'                            
MFA-TR*               AND ZZ.OFFER_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*               AND ZZ.OFFER_END_DT    >= :WS-CHECK-DATE   )              
MFA-TR*         ORDER BY FG.RENEWAL_OFFER_CD                                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND RENEWAL_OFFER_CD WITH                          *         
      * CRM_RT_PKG_OPTION.OPT_CALC_TYPE_CD  <>  'VP' FOR              *         
      *    MAX(CRM_OFFER_OPTION.OPTION_SORT_SEQ_NO)                   *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C7 CURSOR FOR                           
               SELECT  FG.RENEWAL_OFFER_CD                              
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                      ,CRM_OFFER_OPTION    E9 WITH(READUNCOMMITTED)             
                      ,CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND FG.OFFER_START_DT      <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.OFFER_END_DT        >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00473            AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND FG.PROC_STATUS_CD       = 'AC'                    
P00269            AND E9.OFFER_OPT_START_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00269            AND E9.OFFER_OPT_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FG.RENEWAL_OFFER_CD    >   ' '                    
                  AND E9.COMPANY_NO          =   FG.COMPANY_NO          
                  AND E9.OFFER_CD            =   FG.RENEWAL_OFFER_CD    
P00473            AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND E9.PROC_STATUS_CD      = 'AC'                     
                  AND E9.OPTION_SORT_SEQ_NO  IN  (                      
                    SELECT  MAX(ZZ.OPTION_SORT_SEQ_NO)                  
                      FROM CRM_OFFER_OPTION  ZZ WITH(READUNCOMMITTED)           
                     WHERE ZZ.COMPANY_NO         = FG.COMPANY_NO        
                       AND ZZ.OFFER_CD           = FG.RENEWAL_OFFER_CD  
P00473                 AND ZZ.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )  
P00473                 AND ZZ.OFF_OPT_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )  
P00473                 AND ZZ.PROC_STATUS_CD     = 'AC'                 
P00269                   AND  ZZ.OFFER_OPT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )   
P00269                   AND  ZZ.OFFER_OPT_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) ) 
                  AND FI.COMPANY_NO          =  E9.COMPANY_NO           
                  AND FI.OPTION_CD           =  E9.OPTION_CD            
C37780            AND FI.CODE_UTIL_TYPE      =  'G'                     
                  AND FI.OPTION_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FI.OPTION_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00211            AND FI.OPT_CALC_TYPE_CD  NOT IN ('VP','IV','TV')      
P00473            AND FI.OPT_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473            AND FI.OPT_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473            AND FI.PROC_STATUS_CD     = 'AC'                      
                ORDER BY FG.RENEWAL_OFFER_CD                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C7 CURSOR FOR                                   
MFA-TR*        SELECT  FG.RENEWAL_OFFER_CD                                      
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*               ,CRM_OFFER_OPTION    E9                                   
MFA-TR*               ,CRM_RT_PKG_OPTION   FI                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND FG.OFFER_START_DT      <=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFFER_END_DT        >=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND E9.OFFER_OPT_START_DT  <=  :WS-CHECK-DATE                 
MFA-TR*           AND E9.OFFER_OPT_END_DT    >=  :WS-CHECK-DATE                 
MFA-TR*           AND FG.RENEWAL_OFFER_CD    >   ' '                            
MFA-TR*           AND E9.COMPANY_NO          =   FG.COMPANY_NO                  
MFA-TR*           AND E9.OFFER_CD            =   FG.RENEWAL_OFFER_CD            
MFA-TR*           AND E9.OFF_OPT_VSTART_TS  <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND E9.OFF_OPT_VEND_TS    >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND E9.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND E9.OPTION_SORT_SEQ_NO  IN  (                              
MFA-TR*             SELECT  MAX(ZZ.OPTION_SORT_SEQ_NO)                          
MFA-TR*               FROM CRM_OFFER_OPTION  ZZ                                 
MFA-TR*              WHERE ZZ.COMPANY_NO         = FG.COMPANY_NO                
MFA-TR*                AND ZZ.OFFER_CD           = FG.RENEWAL_OFFER_CD          
MFA-TR*                AND ZZ.OFF_OPT_VSTART_TS <= :WS-CHECK-TIMESTAMP          
MFA-TR*                AND ZZ.OFF_OPT_VEND_TS   >= :WS-CHECK-TIMESTAMP          
MFA-TR*                AND ZZ.PROC_STATUS_CD     = 'AC'                         
MFA-TR*                  AND  ZZ.OFFER_OPT_START_DT <= :WS-CHECK-DATE           
MFA-TR*                  AND  ZZ.OFFER_OPT_END_DT   >= :WS-CHECK-DATE )         
MFA-TR*           AND FI.COMPANY_NO          =  E9.COMPANY_NO                   
MFA-TR*           AND FI.OPTION_CD           =  E9.OPTION_CD                    
MFA-TR*           AND FI.CODE_UTIL_TYPE      =  'G'                             
MFA-TR*           AND FI.OPTION_START_DT     <= :WS-CHECK-DATE                  
MFA-TR*           AND FI.OPTION_END_DT       >= :WS-CHECK-DATE                  
MFA-TR*           AND FI.OPT_CALC_TYPE_CD  NOT IN ('VP','IV','TV')              
MFA-TR*           AND FI.OPT_VSTART_TS     <= :WS-CHECK-TIMESTAMP               
MFA-TR*           AND FI.OPT_VEND_TS       >= :WS-CHECK-TIMESTAMP               
MFA-TR*           AND FI.PROC_STATUS_CD     = 'AC'                              
MFA-TR*         ORDER BY FG.RENEWAL_OFFER_CD                                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OFFER_CD WHICH MEETS CONDITION 1 OR 2.         *         
      * 1.TIER_ACCT_TYPE_CD = 'D' AND RENEWAL_OFFER_CD = SPACES       *         
      * 2.TIER_ACCT_TYPE_CD IN('1','2') AND RENEWAL_OFFER_CD <> SPACES*         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKG_OFF_C8 CURSOR FOR                           
               SELECT  DISTINCT  FG.OFFER_CD                            
                                ,FG.RENEWAL_OFFER_CD                    
                                ,DU.TIER_ACCT_TYPE_CD                   
                                                                        
                 FROM  CRM_RT_PKG_OFFER    FG WITH(READUNCOMMITTED)             
                      ,CRM_OFF_MKT_TIER    DU WITH(READUNCOMMITTED)             
                                                                        
                WHERE FG.COMPANY_NO         =  :WS-COMPANY-NO           
                  AND FG.OFFER_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND FG.OFFER_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND FG.SPCL_OFFER_TYPE_CD <> 'IN'                     
P00473            AND FG.OFF_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FG.OFF_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FG.PROC_STATUS_CD      = 'AC'                     
                  AND DU.COMPANY_NO         =  FG.COMPANY_NO            
                  AND DU.OFFER_CD           =  FG.OFFER_CD              
                  AND DU.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND ( ( DU.TIER_ACCT_TYPE_CD = 'D'         AND        
                          FG.RENEWAL_OFFER_CD  = ' ')        OR         
                        ( DU.TIER_ACCT_TYPE_CD IN ('1','2')  AND        
                          FG.RENEWAL_OFFER_CD  > ' ')        )          
P00473            AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND DU.PROC_STATUS_CD      =  'AC'                    
P00614            AND DU.TIER_CUST_STAT_CD  <>  'L'                     
                ORDER BY FG.OFFER_CD                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OFF_C8 CURSOR FOR                                   
MFA-TR*        SELECT  DISTINCT  FG.OFFER_CD                                    
MFA-TR*                         ,FG.RENEWAL_OFFER_CD                            
MFA-TR*                         ,DU.TIER_ACCT_TYPE_CD                           
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_RT_PKG_OFFER    FG                                   
MFA-TR*               ,CRM_OFF_MKT_TIER    DU                                   
MFA-TR*                                                                         
MFA-TR*         WHERE FG.COMPANY_NO         =  :WS-COMPANY-NO                   
MFA-TR*           AND FG.OFFER_START_DT     <= :WS-CHECK-DATE                   
MFA-TR*           AND FG.OFFER_END_DT       >= :WS-CHECK-DATE                   
MFA-TR*           AND FG.SPCL_OFFER_TYPE_CD <> 'IN'                             
MFA-TR*           AND FG.OFF_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FG.OFF_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FG.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND DU.COMPANY_NO         =  FG.COMPANY_NO                    
MFA-TR*           AND DU.OFFER_CD           =  FG.OFFER_CD                      
MFA-TR*           AND DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE                   
MFA-TR*           AND ( ( DU.TIER_ACCT_TYPE_CD = 'D'         AND                
MFA-TR*                   FG.RENEWAL_OFFER_CD  = ' ')        OR                 
MFA-TR*                 ( DU.TIER_ACCT_TYPE_CD IN ('1','2')  AND                
MFA-TR*                   FG.RENEWAL_OFFER_CD  > ' ')        )                  
MFA-TR*           AND DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.OFF_TIER_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.PROC_STATUS_CD      =  'AC'                            
MFA-TR*           AND DU.TIER_CUST_STAT_CD  <>  'L'                             
MFA-TR*         ORDER BY FG.OFFER_CD                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OPTION_CD THAT HAS MULTIPLE ROWS WITH          *         
      * PRIMRY_OPT_ATTR_FL  =   'Y'                                   *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OPT_INCTV_C1 CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO           
                  AND HQ.PRIMRY_OPT_ATTR_FL  = 'Y'                      
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                GROUP BY HQ.OPTION_CD                                   
               HAVING COUNT(*)  >=  2                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_INCTV_C1 CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO                   
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL  = 'Y'                              
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*         GROUP BY HQ.OPTION_CD                                           
MFA-TR*        HAVING COUNT(*)  >=  2                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND FACTOR_ID WITH CSS_SPCL_FCTR.RT_ATTR_INCTV_TYPE*         
      *  <>  CRM_OPT_ATTR_INCTV.RT_ATTR_INCTV_TYPE                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OPT_INCTV_C2 CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                      ,HQ.RT_ATTR_INCTV_TYPE                            
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID          =  HQ.FACTOR_ID     
                          AND SF.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                )    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_INCTV_C2 CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*               ,HQ.RT_ATTR_INCTV_TYPE                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID          =  HQ.FACTOR_ID             
MFA-TR*                   AND SF.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                )            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND FACTOR_ID WITH CSS_SPCL_FCTR.FACTOR_TYPE       *         
      *  NOT IN ('B','F','V')                                         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OPT_INCTV_C3 CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID          
                          AND SF.FACTOR_TYPE  IN  ('B','F','V')  )      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_INCTV_C3 CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID                  
MFA-TR*                   AND SF.FACTOR_TYPE  IN  ('B','F','V')  )              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND OPTION_CD THAT DOES NOT HAVE A ROW WITH        *         
      * PRIMRY_OPT_ATTR_FL = 'Y'                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OPT_INCTV_C4 CURSOR FOR                           
               SELECT DISTINCT  HQ.OPTION_CD                            
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
PRDFIX                 ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
PRDFIX            AND FI.COMPANY_NO          =  HQ.COMPANY_NO           
PRDFIX            AND FI.OPTION_CD           =  HQ.OPTION_CD            
PRDFIX            AND FI.CODE_UTIL_TYPE      = 'G'                      
PRDFIX            AND FI.OPTION_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
PRDFIX            AND FI.OPTION_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
PRDFIX            AND FI.STATUS_CD           = 'A'                      
PRDFIX            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
PRDFIX            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
PRDFIX            AND FI.PROC_STATUS_CD      = 'AC'                     
PRDFIX            AND FI.OPT_CALC_TYPE_CD   <> 'VP'                     
                  AND NOT EXISTS                                        
                      (SELECT  1                                        
                         FROM  CRM_OPT_ATTR_INCTV  ZZ
                           WITH(READUNCOMMITTED)                   
                        WHERE  ZZ.OPTION_CD   =  HQ.OPTION_CD           
                          AND  ZZ.COMPANY_NO  =  HQ.COMPANY_NO          
P00473                AND ZZ.OPT_ATTR_VSTART_TS                         
p00473                                       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473                AND ZZ.OPT_ATTR_VEND_TS                           
P00473                                       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473                AND ZZ.PROC_STATUS_CD      = 'AC'                 
                          AND  ZZ.PRIMRY_OPT_ATTR_FL  =   'Y'  )        
                ORDER BY HQ.OPTION_CD                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_INCTV_C4 CURSOR FOR                                   
MFA-TR*        SELECT DISTINCT  HQ.OPTION_CD                                    
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.COMPANY_NO          =  HQ.COMPANY_NO                   
MFA-TR*           AND FI.OPTION_CD           =  HQ.OPTION_CD                    
MFA-TR*           AND FI.CODE_UTIL_TYPE      = 'G'                              
MFA-TR*           AND FI.OPTION_START_DT    <= :WS-CHECK-DATE                   
MFA-TR*           AND FI.OPTION_END_DT      >= :WS-CHECK-DATE                   
MFA-TR*           AND FI.STATUS_CD           = 'A'                              
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.OPT_CALC_TYPE_CD   <> 'VP'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT  1                                                
MFA-TR*                  FROM  CRM_OPT_ATTR_INCTV  ZZ                           
MFA-TR*                 WHERE  ZZ.OPTION_CD   =  HQ.OPTION_CD                   
MFA-TR*                   AND  ZZ.COMPANY_NO  =  HQ.COMPANY_NO                  
MFA-TR*               AND ZZ.OPT_ATTR_VSTART_TS                                 
MFA-TR*                                      <= :WS-CHECK-TIMESTAMP             
MFA-TR*               AND ZZ.OPT_ATTR_VEND_TS                                   
MFA-TR*                                      >= :WS-CHECK-TIMESTAMP             
MFA-TR*               AND ZZ.PROC_STATUS_CD      = 'AC'                         
MFA-TR*                   AND  ZZ.PRIMRY_OPT_ATTR_FL  =   'Y'  )                
MFA-TR*         ORDER BY HQ.OPTION_CD                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FIXED PRICE" FACTOR_ID WITH NO VALID ROW      *         
      * IN CSS_SPCL_FCTR_APPL TABLE WITH DATE_TO >= CHECKER DATE      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FIX_PRICE_C1  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
C37780           FROM  CRM_OPT_ATTR_INCTV  HQ
                           WITH(READUNCOMMITTED)               JOIN        
C37780                 CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
C37780             ON (FI.COMPANY_NO      =  HQ.COMPANY_NO              
C37780            AND  FI.OPTION_CD       =  HQ.OPTION_CD ) JOIN        
C37780                 CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
C37780             ON (SF.FACTOR_ID       =  HQ.FACTOR_ID ) LEFT JOIN   
C37780                 CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
C37780             ON (SA.FACTOR_ID       =  HQ.FACTOR_ID               
C37780            AND  SA.CODE_STATUS     =  'A'                        
C37780            AND  SA.CODE_UTIL_TYPE  =  'G'                        
C37780            AND  SA.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )             
P00473            AND  SA.DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )  ) JOIN     
P00473                 CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                
P00473             ON (E9.OPTION_CD           = FI.OPTION_CD            
P00473            AND  E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00473            AND  E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
P00473            AND  E9.PROC_STATUS_CD     = 'AC'                     
P00473            AND  E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND  E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) )   
C37780                                                                  
C37780          WHERE HQ.COMPANY_NO         =  :WS-COMPANY-NO           
C37780            AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'            
C37780            AND HQ.FACTOR_ID          >  ' '                      
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
C37780            AND FI.OPTION_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
C37780            AND FI.OPTION_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
C37780            AND FI.CODE_UTIL_TYPE     =  'G'                      
C37780            AND FI.OPT_CALC_TYPE_CD   =  'FP'                     
P00473            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.PROC_STATUS_CD      = 'AC'                     
C37780            AND SF.OVR_RT_CALC_TYP_CD =  '02'                     
C37780            AND SA.CODE_STATUS        IS NULL                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIX_PRICE_C1  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ               JOIN                
MFA-TR*                CRM_RT_PKG_OPTION   FI                                   
MFA-TR*            ON (FI.COMPANY_NO      =  HQ.COMPANY_NO                      
MFA-TR*           AND  FI.OPTION_CD       =  HQ.OPTION_CD ) JOIN                
MFA-TR*                CSS_SPCL_FCTR       SF                                   
MFA-TR*            ON (SF.FACTOR_ID       =  HQ.FACTOR_ID ) LEFT JOIN           
MFA-TR*                CSS_SPCL_FCTR_APPL SA                                    
MFA-TR*            ON (SA.FACTOR_ID       =  HQ.FACTOR_ID                       
MFA-TR*           AND  SA.CODE_STATUS     =  'A'                                
MFA-TR*           AND  SA.CODE_UTIL_TYPE  =  'G'                                
MFA-TR*           AND  SA.DATE_FROM       <= :WS-CHECK-DATE                     
MFA-TR*           AND  SA.DATE_TO         >= :WS-CHECK-DATE  ) JOIN             
MFA-TR*                CRM_OFFER_OPTION E9                                      
MFA-TR*            ON (E9.OPTION_CD           = FI.OPTION_CD                    
MFA-TR*           AND  E9.OFFER_OPT_START_DT <= :WS-CHECK-DATE                  
MFA-TR*           AND  E9.OFFER_OPT_END_DT   >= :WS-CHECK-DATE                  
MFA-TR*           AND  E9.PROC_STATUS_CD     = 'AC'                             
MFA-TR*           AND  E9.OFF_OPT_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND  E9.OFF_OPT_VEND_TS    >= :WS-CHECK-TIMESTAMP )           
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO         =  :WS-COMPANY-NO                   
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                    
MFA-TR*           AND HQ.FACTOR_ID          >  ' '                              
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.OPTION_START_DT    <= :WS-CHECK-DATE                   
MFA-TR*           AND FI.OPTION_END_DT      >= :WS-CHECK-DATE                   
MFA-TR*           AND FI.CODE_UTIL_TYPE     =  'G'                              
MFA-TR*           AND FI.OPT_CALC_TYPE_CD   =  'FP'                             
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD =  '02'                             
MFA-TR*           AND SA.CODE_STATUS        IS NULL                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FIXED PRICE" FACTOR_ID WITH                   *         
      * CRM_RT_ATTR_INCTV.SOURCE_CD <> 'CF'                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FIX_PRICE_C2  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                      ,CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                      ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'          
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND FI.COMPANY_NO          =   HQ.COMPANY_NO          
                  AND FI.OPTION_CD           =   HQ.OPTION_CD           
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
C37780            AND FI.CODE_UTIL_TYPE      =   'G'                    
                  AND FI.OPT_CALC_TYPE_CD    =   'FP'                   
P00473            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.PROC_STATUS_CD      = 'AC'                     
                  AND SF.FACTOR_ID           =   HQ.FACTOR_ID           
                  AND SF.OVR_RT_CALC_TYP_CD  =   '02'                   
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_RT_ATTR_INCTV   G7
                           WITH(READUNCOMMITTED)                    
                        WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO           
                          AND G7.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                     
                          AND G7.SOURCE_CD   =  'CF'         )          
C37780          GROUP BY HQ.OPTION_CD,HQ.FACTOR_ID                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIX_PRICE_C2  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*               ,CRM_RT_PKG_OPTION   FI                                   
MFA-TR*               ,CSS_SPCL_FCTR       SF                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'                  
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.COMPANY_NO          =   HQ.COMPANY_NO                  
MFA-TR*           AND FI.OPTION_CD           =   HQ.OPTION_CD                   
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.CODE_UTIL_TYPE      =   'G'                            
MFA-TR*           AND FI.OPT_CALC_TYPE_CD    =   'FP'                           
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND SF.FACTOR_ID           =   HQ.FACTOR_ID                   
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD  =   '02'                           
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_RT_ATTR_INCTV   G7                            
MFA-TR*                 WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO                   
MFA-TR*                   AND G7.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                             
MFA-TR*                   AND G7.SOURCE_CD   =  'CF'         )                  
MFA-TR*         GROUP BY HQ.OPTION_CD,HQ.FACTOR_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FIXED PRICE" FACTOR_ID WITH DURATION_NO > 1   *         
      * AND CORRESPONDING "EXIT FEE" FACTOR DOES NOT EXISTS           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FIX_PRICE_C3  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                      ,CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                      ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'          
                  AND HQ.FACTOR_ID           >   ' '                    
                  AND HQ.DURATION_NO         >   1                      
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND FI.COMPANY_NO          =   HQ.COMPANY_NO          
                  AND FI.OPTION_CD           =   HQ.OPTION_CD           
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
C37780            AND FI.CODE_UTIL_TYPE      =   'G'                    
                  AND FI.OPT_CALC_TYPE_CD    =   'FP'                   
P00473            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.PROC_STATUS_CD      = 'AC'                     
                  AND SF.FACTOR_ID           =   HQ.FACTOR_ID           
                  AND SF.OVR_RT_CALC_TYP_CD  =   '02'                   
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_OPT_ATTR_INCTV  ZZ
                           WITH(READUNCOMMITTED)                    
                        WHERE ZZ.COMPANY_NO         = HQ.COMPANY_NO     
                          AND ZZ.OPTION_CD          = HQ.OPTION_CD      
                          AND ZZ.RT_ATTR_INCTV_TYPE = 'EXIT FEE'        
MAN004*               AND zz.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP          
MAN004                AND ZZ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) 
P00473                AND ZZ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )  
P00473                AND ZZ.PROC_STATUS_CD      = 'AC'                 
                          AND ZZ.FACTOR_ID          > ' '         )     
C37780          GROUP BY HQ.OPTION_CD                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIX_PRICE_C3  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*               ,CRM_RT_PKG_OPTION   FI                                   
MFA-TR*               ,CSS_SPCL_FCTR       SF                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'                  
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.DURATION_NO         >   1                              
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.COMPANY_NO          =   HQ.COMPANY_NO                  
MFA-TR*           AND FI.OPTION_CD           =   HQ.OPTION_CD                   
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.CODE_UTIL_TYPE      =   'G'                            
MFA-TR*           AND FI.OPT_CALC_TYPE_CD    =   'FP'                           
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND SF.FACTOR_ID           =   HQ.FACTOR_ID                   
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD  =   '02'                           
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_OPT_ATTR_INCTV  ZZ                            
MFA-TR*                 WHERE ZZ.COMPANY_NO         = HQ.COMPANY_NO             
MFA-TR*                   AND ZZ.OPTION_CD          = HQ.OPTION_CD              
MFA-TR*                   AND ZZ.RT_ATTR_INCTV_TYPE = 'EXIT FEE'                
MFA-TR*               AND zz.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP          
MFA-TR*               AND ZZ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP 
MFA-TR*               AND ZZ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP          
MFA-TR*               AND ZZ.PROC_STATUS_CD      = 'AC'                         
MFA-TR*                   AND ZZ.FACTOR_ID          > ' '         )             
MFA-TR*         GROUP BY HQ.OPTION_CD                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FIXED PRICE" OPTION_CD & FACTOR_ID WITH       *         
A00633* (PRIMRY_OPT_ATTR_FL<>'Y') OR (DURATION_NO<>(1,6,12,18,24,36)) *         
      * OR (ATTR_INCTV_VALUE <> 0) OR (OPT_CHG_ACTION_CD <> 'E')      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FIX_PRICE_C4  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                      ,CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)             
                      ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'          
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND FI.COMPANY_NO          =   HQ.COMPANY_NO          
                  AND FI.OPTION_CD           =   HQ.OPTION_CD           
                  AND FI.OPTION_START_DT     <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
                  AND FI.OPTION_END_DT       >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
C37780            AND FI.CODE_UTIL_TYPE      =   'G'                    
                  AND FI.OPT_CALC_TYPE_CD    =   'FP'                   
P00473            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND FI.PROC_STATUS_CD      = 'AC'                     
                  AND SF.FACTOR_ID           =   HQ.FACTOR_ID           
                  AND SF.OVR_RT_CALC_TYP_CD  =   '02'                   
                  AND ( (HQ.PRIMRY_OPT_ATTR_FL  <>  'Y'  )  OR          
A05136                  (HQ.DURATION_NO NOT IN(1,6,7,8,12,18,24,36)) OR 
                        (HQ.ATTR_INCTV_VALUE    <>  0    )  OR          
                        (HQ.OPT_CHG_ACTION_CD   <>  'E'  )  )           
C37780          GROUP BY HQ.OPTION_CD,HQ.FACTOR_ID                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIX_PRICE_C4  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*               ,CRM_RT_PKG_OPTION   FI                                   
MFA-TR*               ,CSS_SPCL_FCTR       SF                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'FIXED PRICE'                  
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FI.COMPANY_NO          =   HQ.COMPANY_NO                  
MFA-TR*           AND FI.OPTION_CD           =   HQ.OPTION_CD                   
MFA-TR*           AND FI.OPTION_START_DT     <=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.OPTION_END_DT       >=  :WS-CHECK-DATE                 
MFA-TR*           AND FI.CODE_UTIL_TYPE      =   'G'                            
MFA-TR*           AND FI.OPT_CALC_TYPE_CD    =   'FP'                           
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND SF.FACTOR_ID           =   HQ.FACTOR_ID                   
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD  =   '02'                           
MFA-TR*           AND ( (HQ.PRIMRY_OPT_ATTR_FL  <>  'Y'  )  OR                  
MFA-TR*                 (HQ.DURATION_NO NOT IN(1,6,7,8,12,18,24,36)) OR         
MFA-TR*                 (HQ.ATTR_INCTV_VALUE    <>  0    )  OR                  
MFA-TR*                 (HQ.OPT_CHG_ACTION_CD   <>  'E'  )  )                   
MFA-TR*         GROUP BY HQ.OPTION_CD,HQ.FACTOR_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "MONTHLY CREDIT" CRM_OPT_ATTR_INCTV.FACTOR_ID  *         
      * THAT DOES NOT HAVE VALID ENTRY IN CSS_SPCL_FCTR               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MONTHLY_CR_C1 CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'       
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MONTHLY_CR_C1 CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'               
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "MONTHLY CREDIT" CRM_OPT_ATTR_INCTV.FACTOR_ID  *         
      * WITH GL_ACCT_NO  <=  0                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MONTHLY_CR_C2 CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'       
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID          
                          AND SF.GL_ACCT_NO   >   0           )         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MONTHLY_CR_C2 CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'               
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID                  
MFA-TR*                   AND SF.GL_ACCT_NO   >   0           )                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "MONTHLY CREDIT" CRM_OPT_ATTR_INCTV.FACTOR_ID  *         
      * WITH CRM_RT_ATTR_INCTV.SOURCE_CD  <>  'FF'                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MONTHLY_CR_C3 CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'       
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_RT_ATTR_INCTV   G7
                           WITH(READUNCOMMITTED)                    
                        WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO           
                          AND G7.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                     
                          AND G7.SOURCE_CD   =  'FF'         )          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MONTHLY_CR_C3 CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'MONTHLY CREDIT'               
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_RT_ATTR_INCTV   G7                            
MFA-TR*                 WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO                   
MFA-TR*                   AND G7.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                             
MFA-TR*                   AND G7.SOURCE_CD   =  'FF'         )                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "MONTHLY CREDIT" FACTOR_ID WITH DURATION_NO <=0*         
A04319* OR ( ATTR_INCTV_VALUE  = 0 ) OR OPT_CHG_ACTION_CD NOT IN E & N*         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE MONTHLY_CR_C4 CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND HQ.RT_ATTR_INCTV_TYPE   =   'MONTHLY CREDIT'      
                  AND HQ.FACTOR_ID            >   ' '                   
                  AND ( (HQ.DURATION_NO       <=  0    )  OR            
A04319                  (HQ.ATTR_INCTV_VALUE   =  0    )  OR            
A04319                  (HQ.OPT_CHG_ACTION_CD NOT IN ('E','N') )  )     
P00473            AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.OPT_ATTR_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.PROC_STATUS_CD        = 'AC'                   
A04256            AND HQ.OPTION_CD      NOT IN ( 'RDZ03C39DC03',        
A04256                                           'RDZ04C39DC03',        
A04256                                           'RD303C39DC03',        
A04256                                           'RD304C39DC03',        
A04256                                           'RD703C39DC03',        
A04256                                           'RD704C39DC03')        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MONTHLY_CR_C4 CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =   'MONTHLY CREDIT'              
MFA-TR*           AND HQ.FACTOR_ID            >   ' '                           
MFA-TR*           AND ( (HQ.DURATION_NO       <=  0    )  OR                    
MFA-TR*                 (HQ.ATTR_INCTV_VALUE   =  0    )  OR                    
MFA-TR*                 (HQ.OPT_CHG_ACTION_CD NOT IN ('E','N') )  )             
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS   <= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS     >= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.PROC_STATUS_CD        = 'AC'                           
MFA-TR*           AND HQ.OPTION_CD      NOT IN ( 'RDZ03C39DC03',                
MFA-TR*                                          'RDZ04C39DC03',                
MFA-TR*                                          'RD303C39DC03',                
MFA-TR*                                          'RD304C39DC03',                
MFA-TR*                                          'RD703C39DC03',                
MFA-TR*                                          'RD704C39DC03')                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FREE CSC" CRM_OPT_ATTR_INCTV.FACTOR_ID        *         
      * THAT DOES NOT HAVE VALID ENTRY IN CSS_SPCL_FCTR               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FREE_CSC_C1  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'FREE CSC'             
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FREE_CSC_C1  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'FREE CSC'                     
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FREE CSC" CRM_OPT_ATTR_INCTV.FACTOR_ID        *         
      * WITH CSS_SPCL_FCTR_APPL.DATE_TO >= CHECKER DATE               *         
      *****************************************************************         
      *                                                                         
      *    EXEC SQL                                                             
      *       DECLARE FREE_CSC_C2  CURSOR FOR                                   
      *        SELECT  HQ.OPTION_CD                                             
      *               ,HQ.FACTOR_ID                                             
      *                                                                         
      *          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
      *                                                                         
      *         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
      *           AND HQ.RT_ATTR_INCTV_TYPE  =   'FREE CSC'                     
      *           AND HQ.FACTOR_ID           >   ' '                            
      *           AND NOT EXISTS                                                
      *               (SELECT 1                                                 
      *                  FROM CSS_SPCL_FCTR_APPL  SA                            
      *                 WHERE SA.FACTOR_ID      =  HQ.FACTOR_ID                 
      *                   AND SA.CODE_STATUS    =  'A'                          
      *                   AND SA.CODE_UTIL_TYPE =  :WS-CODE-UTIL-TYPE           
      *                   AND SA.DATE_FROM      <= :WS-CHECK-DATE               
      *                   AND SA.DATE_TO        >= :WS-CHECK-DATE  )            
      *        WITH UR                                                          
      *    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FREE CSC" FACTOR_ID WITH                      *         
      * (ATTR_INCTV_VALUE > 0) OR (DURATION_NO <= 0)                  *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FREE_CSC_C3  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =  :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE   =  'FREE CSC'             
                  AND HQ.FACTOR_ID            >  ' '                    
                  AND ( (HQ.DURATION_NO       <= 0  )  OR               
                        (HQ.ATTR_INCTV_VALUE  >  0  )  )                
P00473            AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.OPT_ATTR_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.PROC_STATUS_CD        = 'AC'                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FREE_CSC_C3  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =  :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =  'FREE CSC'                     
MFA-TR*           AND HQ.FACTOR_ID            >  ' '                            
MFA-TR*           AND ( (HQ.DURATION_NO       <= 0  )  OR                       
MFA-TR*                 (HQ.ATTR_INCTV_VALUE  >  0  )  )                        
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS   <= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS     >= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.PROC_STATUS_CD        = 'AC'                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "FREE CSC" FACTOR_ID WITH                      *         
      * OPT_CHG_ACTION_CD <> 'K'                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE FREE_CSC_C4  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =  :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE   =  'FREE CSC'             
                  AND HQ.FACTOR_ID            >  ' '                    
                  AND HQ.OPT_CHG_ACTION_CD    <> 'K'                    
P00473            AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.OPT_ATTR_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.PROC_STATUS_CD        = 'AC'                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FREE_CSC_C4  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =  :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =  'FREE CSC'                     
MFA-TR*           AND HQ.FACTOR_ID            >  ' '                            
MFA-TR*           AND HQ.OPT_CHG_ACTION_CD    <> 'K'                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS   <= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS     >= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.PROC_STATUS_CD        = 'AC'                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "SIGNUP CREDIT" APPL_PROGRAM_ID THAT DOES NOT  *         
      * HAVE VALID ENTRY IN CSS_APPL_PGM_DESC TABLE                   *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SIGNUP_CR_C1  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.APPL_PROGRAM_ID                               
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'ACCOUNT CREDIT'       
                  AND HQ.APPL_PROGRAM_ID     >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.OPT_ATTR_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )    
P00473            AND HQ.PROC_STATUS_CD        = 'AC'                   
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_APPL_PGM_DESC  K9
                           WITH(READUNCOMMITTED)                     
                        WHERE K9.APPL_PROGRAM_ID = HQ.APPL_PROGRAM_ID)  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SIGNUP_CR_C1  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.APPL_PROGRAM_ID                                       
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'ACCOUNT CREDIT'               
MFA-TR*           AND HQ.APPL_PROGRAM_ID     >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS   <= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS     >= :WS-CHECK-TIMESTAMP            
MFA-TR*           AND HQ.PROC_STATUS_CD        = 'AC'                           
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_APPL_PGM_DESC  K9                             
MFA-TR*                 WHERE K9.APPL_PROGRAM_ID = HQ.APPL_PROGRAM_ID)          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "SIGNUP CREDIT" OPTION WITH (DURATION_NO <> 0) *         
      * OR  (APPL_PROGRAM_ID = SPACES) OR (ATTR_INCTV_VALUE <= 0) OR  *         
      * (GL_ACCT_CREDIT <= 0)  OR  (GL_ACCT_DEBIT <= 0)               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SIGNUP_CR_C2  CURSOR FOR                          
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'ACCOUNT CREDIT'       
                  AND ( (HQ.DURATION_NO      <>  0   )  OR              
                        (HQ.APPL_PROGRAM_ID  =   ' ' )  OR              
                        (HQ.ATTR_INCTV_VALUE <=  0   )  OR              
                        (HQ.GL_ACCT_CREDIT   <=  0 )  OR                
                        (HQ.GL_ACCT_DEBIT    <=  0   )  )               
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SIGNUP_CR_C2  CURSOR FOR                                  
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'ACCOUNT CREDIT'               
MFA-TR*           AND ( (HQ.DURATION_NO      <>  0   )  OR                      
MFA-TR*                 (HQ.APPL_PROGRAM_ID  =   ' ' )  OR                      
MFA-TR*                 (HQ.ATTR_INCTV_VALUE <=  0   )  OR                      
MFA-TR*                 (HQ.GL_ACCT_CREDIT   <=  0 )  OR                        
MFA-TR*                 (HQ.GL_ACCT_DEBIT    <=  0   )  )                       
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "EXIT FEE" CRM_OPT_ATTR_INCTV.FACTOR_ID        *         
      * THAT DOES NOT HAVE VALID ENTRY IN CSS_SPCL_FCTR               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EXIT_FEE_C1  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'EXIT FEE'             
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EXIT_FEE_C1  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'EXIT FEE'                     
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID  )               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "EXIT FEE" CRM_OPT_ATTR_INCTV.FACTOR_ID        *         
      * WITH GL_ACCT_NO  <=  0                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EXIT_FEE_C2 CURSOR FOR                            
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND HQ.RT_ATTR_INCTV_TYPE   =   'EXIT FEE'            
                  AND HQ.FACTOR_ID            >   ' '                   
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                  AND EXISTS                                            
                      (SELECT 1                                         
                         FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)           
                        WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID          
                          AND SF.GL_ACCT_NO   <=  0           )         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EXIT_FEE_C2 CURSOR FOR                                    
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =   'EXIT FEE'                    
MFA-TR*           AND HQ.FACTOR_ID            >   ' '                           
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SPCL_FCTR  SF                                 
MFA-TR*                 WHERE SF.FACTOR_ID    =   HQ.FACTOR_ID                  
MFA-TR*                   AND SF.GL_ACCT_NO   <=  0           )                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "EXIT FEE" CRM_OPT_ATTR_INCTV.FACTOR_ID        *         
      * WITH CRM_RT_ATTR_INCTV.SOURCE_CD  <>  'FF'                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EXIT_FEE_C3  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'EXIT FEE'             
                  AND HQ.FACTOR_ID           >   ' '                    
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_RT_ATTR_INCTV   G7
                           WITH(READUNCOMMITTED)                    
                        WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO           
                          AND G7.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                     
                          AND G7.SOURCE_CD   =  'FF'         )          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EXIT_FEE_C3  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'EXIT FEE'                     
MFA-TR*           AND HQ.FACTOR_ID           >   ' '                            
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_RT_ATTR_INCTV   G7                            
MFA-TR*                 WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO                   
MFA-TR*                   AND G7.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                             
MFA-TR*                   AND G7.SOURCE_CD   =  'FF'         )                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "EXIT FEE" FACTOR_ID WITH (DURATION_NO <> 1)   *         
      * OR (ATTR_INCTV_VALUE <= 0) OR (OPT_CHG_ACTION_CD <> 'A')      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EXIT_FEE_C4  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                      ,HQ.FACTOR_ID                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND HQ.RT_ATTR_INCTV_TYPE   =   'EXIT FEE'            
                  AND HQ.FACTOR_ID            >   ' '                   
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                  AND ( (HQ.DURATION_NO       <>  1    )  OR            
                        (HQ.ATTR_INCTV_VALUE  <=  0    )  OR            
                        (HQ.OPT_CHG_ACTION_CD <>  'A'  )  )             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EXIT_FEE_C4  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =   'EXIT FEE'                    
MFA-TR*           AND HQ.FACTOR_ID            >   ' '                           
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND ( (HQ.DURATION_NO       <>  1    )  OR                    
MFA-TR*                 (HQ.ATTR_INCTV_VALUE  <=  0    )  OR                    
MFA-TR*                 (HQ.OPT_CHG_ACTION_CD <>  'A'  )  )                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "BONUS SKYMILES" OPTION_CD WITH                *         
      * CRM_RT_ATTR_INCTV.SOURCE_CD  <>  'IN'                         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SKYMILES_C1  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
                  AND HQ.RT_ATTR_INCTV_TYPE  =   'BONUS SKYMILES'       
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                  AND NOT EXISTS                                        
                      (SELECT 1                                         
                         FROM CRM_RT_ATTR_INCTV   G7
                           WITH(READUNCOMMITTED)                    
                        WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO           
                          AND G7.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                     
                          AND G7.SOURCE_CD   =  'IN'         )          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SKYMILES_C1  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  =   'BONUS SKYMILES'               
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_RT_ATTR_INCTV   G7                            
MFA-TR*                 WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO                   
MFA-TR*                   AND G7.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                             
MFA-TR*                   AND G7.SOURCE_CD   =  'IN'         )                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      * CURSOR TO FIND "BONUS SKYMILES" OPTION_CD WITH                *         
      * (DURATION_NO>0)OR (ATTR_INCTV_VALUE<=0) OR (CATEGORY_ID<>458) *         
      * OR (WQ_ROUTE_CATEGORY <> '4')                                 *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE SKYMILES_C2  CURSOR FOR                           
               SELECT  HQ.OPTION_CD                                     
                                                                        
                 FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                                                                        
                WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO        
                  AND HQ.RT_ATTR_INCTV_TYPE   =   'BONUS SKYMILES'      
                  AND ( (HQ.DURATION_NO       >   0    )  OR            
                        (HQ.ATTR_INCTV_VALUE  <=  0    )  OR            
                        (HQ.CATEGORY_ID       <>  458  )  OR            
                        (HQ.WQ_ROUTE_CATEGORY <>  '4'  )  )             
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SKYMILES_C2  CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO           =   :WS-COMPANY-NO                
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE   =   'BONUS SKYMILES'              
MFA-TR*           AND ( (HQ.DURATION_NO       >   0    )  OR                    
MFA-TR*                 (HQ.ATTR_INCTV_VALUE  <=  0    )  OR                    
MFA-TR*                 (HQ.CATEGORY_ID       <>  458  )  OR                    
MFA-TR*                 (HQ.WQ_ROUTE_CATEGORY <>  '4'  )  )                     
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
P00141*****************************************************************         
P00141* CURSOR TO CHECK NO TWO RT_ATTR_INCTV_TYPE ARE EFFECTIVE AT THE*         
P00141* SAME TIME FOR A PARTICULAR OPTION CODE.                       *         
P00141*****************************************************************         
P00141*                                                                         
P00141     EXEC SQL                                                     
P00141        DECLARE OPT_INCTV_C5 CURSOR FOR                           
P00141         SELECT  HQ.OPTION_CD                                     
P00141                ,HQ.RT_ATTR_INCTV_TYPE                            
P00141                ,HQ.FACTOR_ID                                     
P00141                                                                  
P00141           FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
P00141                                                                  
P00141          WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO         
P00141            AND HQ.ATTR_INCTV_STRT_DT  <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00141            AND HQ.ATTR_INCTV_END_DT   >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )         
P00473            AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.OPT_ATTR_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
P00473            AND HQ.PROC_STATUS_CD       = 'AC'                    
P00141          GROUP BY HQ.OPTION_CD                                   
P00141                  ,HQ.RT_ATTR_INCTV_TYPE                          
P00141                  ,HQ.FACTOR_ID                                   
P00141         HAVING COUNT(*)  >=  2                                   
P00141                                                           
P00141     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_INCTV_C5 CURSOR FOR                                   
MFA-TR*        SELECT  HQ.OPTION_CD                                             
MFA-TR*               ,HQ.RT_ATTR_INCTV_TYPE                                    
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*                                                                         
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*                                                                         
MFA-TR*         WHERE HQ.COMPANY_NO          =   :WS-COMPANY-NO                 
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT  <=  :WS-CHECK-DATE                 
MFA-TR*           AND HQ.ATTR_INCTV_END_DT   >=  :WS-CHECK-DATE                 
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS  <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS    >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND HQ.PROC_STATUS_CD       = 'AC'                            
MFA-TR*         GROUP BY HQ.OPTION_CD                                           
MFA-TR*                 ,HQ.RT_ATTR_INCTV_TYPE                                  
MFA-TR*                 ,HQ.FACTOR_ID                                           
MFA-TR*        HAVING COUNT(*)  >=  2                                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
P00141*                                                                         
P00485*****************************************************************         
P00485* CURSOR TO VALIDATE CURRENT EXTERNAL DESCRIPTION & WEB         *         
P00485* MARKETTING DESCRIPTION LENGTH WITH DELINQUENCY LIMIT          *         
P00485*****************************************************************         
P00485     EXEC SQL                                                     
P00485        DECLARE RTPKG_OPT_C7 CURSOR FOR                           
P00485         SELECT DISTINCT FI.OPTION_CD                             
P00485               ,FI.CURR_EXT_DESC_LONG                             
P00485          FROM  CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00485               ,CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
P00485               ,CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
P00485               ,CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
P00485         WHERE FI.OPTION_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00485           AND FI.OPTION_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00473           AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND FI.PROC_STATUS_CD      = 'AC'                      
P00485           AND FG.OFFER_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00485           AND FG.OFFER_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00473           AND FG.OFF_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND FG.OFF_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND FG.PROC_STATUS_CD      ='AC'                       
P00485           AND E9.OPTION_CD           = FI.OPTION_CD              
P00485           AND E9.OFFER_CD            = FG.OFFER_CD               
P00485           AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00485           AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00473           AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND E9.PROC_STATUS_CD      = 'AC'                      
P00485           AND KM.OFFER_CD            = FG.OFFER_CD               
P00485           AND KM.PROMO_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00485           AND KM.PROMO_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
P00473           AND KM.PROMO_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND KM.PROMO_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
P00473           AND KM.PROC_STATUS_CD      = 'AC'                      
p00485           FOR READ ONLY                                  
P00485                                                      
P00485     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_OPT_C7 CURSOR FOR                                   
MFA-TR*        SELECT DISTINCT FI.OPTION_CD                                     
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*         FROM  CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CRM_RT_PKG_OFFER  FG                                      
MFA-TR*              ,CRM_OFFER_OPTION  E9                                      
MFA-TR*              ,CRM_MKT_PROMOTION KM                                      
MFA-TR*        WHERE FI.OPTION_START_DT    <= :WS-CHECK-DATE                    
MFA-TR*          AND FI.OPTION_END_DT      >= :WS-CHECK-DATE                    
MFA-TR*          AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND FI.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND FG.OFFER_START_DT     <= :WS-CHECK-DATE                    
MFA-TR*          AND FG.OFFER_END_DT       >= :WS-CHECK-DATE                    
MFA-TR*          AND FG.OFF_VSTART_TS      <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND FG.OFF_VEND_TS        >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND FG.PROC_STATUS_CD      ='AC'                               
MFA-TR*          AND E9.OPTION_CD           = FI.OPTION_CD                      
MFA-TR*          AND E9.OFFER_CD            = FG.OFFER_CD                       
MFA-TR*          AND E9.OFFER_OPT_START_DT <= :WS-CHECK-DATE                    
MFA-TR*          AND E9.OFFER_OPT_END_DT   >= :WS-CHECK-DATE                    
MFA-TR*          AND E9.OFF_OPT_VSTART_TS  <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND E9.OFF_OPT_VEND_TS    >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND E9.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND KM.OFFER_CD            = FG.OFFER_CD                       
MFA-TR*          AND KM.PROMO_START_DT     <= :WS-CHECK-DATE                    
MFA-TR*          AND KM.PROMO_END_DT       >= :WS-CHECK-DATE                    
MFA-TR*          AND KM.PROMO_VSTART_TS    <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND KM.PROMO_VEND_TS      >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND KM.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7462                                                   
MFA-TR*    END-EXEC.                                                            
P00485*                                                                         
       01  WS-END                     PIC X(40) VALUE                   
             'WORKING STORAGE FOR PCSRP099 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
                                                                        
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  INITIALIZATION ROUTINE                                     **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 6251-GET-FJC01-DATE    THRU 6251-EXIT.               
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE SPACES                 TO WS-SYSIPT                  
              MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN    
              MOVE WS-COMMON              TO WS-PROGRAM                 
              MOVE WS-DATE                TO WS-COMMAND                 
              MOVE ZEROS                  TO WS-SEQUENCE                
              MOVE WS-KEY-AREA            TO E-FJC01-KEY                
              PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                
              PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                
                  UNTIL (RUN-DATE AND INPUT-ACTIVE)                     
                     OR  END-OF-SYSIPT                                  
              IF END-OF-SYSIPT                                          
                 DISPLAY '**  PCSRP099 PROCESSING ERROR   **'           
                 DISPLAY '**  COMMON DATE PARM NOT ACTIVE **'           
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**    PROCESSING TERMINATED     **'           
                 PERFORM 9900-ABEND       THRU 9900-EXIT                
              ELSE                                                      
                 IF WS-INPUT-RUN-DATE-MM NUMERIC AND                    
                    WS-INPUT-RUN-DATE-DD NUMERIC AND                    
                    WS-INPUT-RUN-DATE-CC NUMERIC AND                    
                    WS-INPUT-RUN-DATE-YY NUMERIC                        
                    PERFORM 7611-CLOSE          THRU 7611-EXIT          
                    MOVE WS-INPUT-RUN-DATE                              
                                          TO WS-INPUT-DATE              
                 ELSE                                                   
                    DISPLAY '**  PCSRP099 PROCESSING ERROR    **'       
                    DISPLAY '**  COMMON DATE PARM NOT NUMERIC **'       
                    DISPLAY '**    KEY = ' E-FJC01-KEY                  
                    DISPLAY '**     PROCESSING TERMINATED     **'       
                    PERFORM 9900-ABEND    THRU 9900-EXIT                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE             TO WS-CHECK-DATE              
                                             MAIL1-SUB-DATE.            
           DISPLAY 'CHECKER PROGRAM INPUT DATE : ' WS-CHECK-DATE.       
                                                                        
P00473     MOVE WS-CHECK-DATE             TO WS-CHECK-DT.               
P00473     MOVE WS-CHECK-TS               TO WS-CHECK-TIMESTAMP.        
                                                                        
P00396                                                                  
P00396* GET RENEWAL DESCRIPTION LENGTH LIMIT                                    
P00396     MOVE '01'                        TO C8-COMPANY-NO.           
P00396     MOVE WS-RENEWAL-DELINQ-CD        TO C8-DELINQ-CD.            
P00396     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
P00396     MOVE C8-DELINQ-VALUE             TO WS-LEN-LIMIT.            
PRJ396     MOVE WS-RENEWAL-OFFER-CNT        TO C8-DELINQ-CD.            
PRJ396     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
PRJ396     MOVE C8-DELINQ-VALUE             TO WS-OFFER-OPT-CNT.        
                                                                        
P00485* GET WEB MKT DESC & CURR EXET DESC LENGTH LIMIT                          
P00485     MOVE '01'                        TO C8-COMPANY-NO.           
P00485     MOVE WS-EXT-DESC-DELINQ-CD       TO C8-DELINQ-CD.            
P00485     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
P00485     MOVE C8-DELINQ-VALUE             TO WS-EXT-DESC-LIMIT.       
      *                                                                         
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                         
           WRITE PRNTFILE-RECORD  FROM  MAILHEAD-1.                     
           WRITE PRNTFILE-RECORD  FROM  MAILHEAD-2.                     
      *                                                                         
           PERFORM 8100-PRINT-TITLE             THRU 8100-EXIT.         
           PERFORM 8200-PRINT-HEADERS           THRU 8200-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  MAIN PROCESS BEGINS HERE.                                  **         
      *****************************************************************         
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           MOVE '1000'                  TO WS-ACTIVE-PARAGRAPH.         
                                                                        
           PERFORM 2000-VALIDATE-CRM-TABLES     THRU 2000-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  VALIDATE VARIOUS CRM USER TABLE DATA                       **         
      *****************************************************************         
      *                                                                         
       2000-VALIDATE-CRM-TABLES.                                        
      *                                                                         
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 2010-VLDT-MKT-TIER-DATA      THRU 2010-EXIT.         
           PERFORM 2100-VLDT-SPCL-FCTR-DATA     THRU 2100-EXIT.         
           PERFORM 2200-VLDT-MKT-PROMO-DATA     THRU 2200-EXIT.         
           PERFORM 2300-VLDT-RATE-GROUP-DATA    THRU 2300-EXIT.         
           PERFORM 2400-VLDT-RTPKG-OPTION-DATA  THRU 2400-EXIT.         
           PERFORM 2500-VLDT-RTPKG-OFFER-DATA   THRU 2500-EXIT.         
           PERFORM 2600-VLDT-ATTR-INCTV-DATA    THRU 2600-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA - CRM_MKT_TIER & CRM_OFF_MKT_TIER  **         
      *****************************************************************         
      *                                                                         
       2010-VLDT-MKT-TIER-DATA.                                         
      *                                                                         
           MOVE '2010'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7011-OPEN-MKT-TIER-C1        THRU 7011-EXIT.         
                                                                        
           PERFORM 7012-FETCH-MKT-TIER-C1       THRU 7012-EXIT.         
                                                                        
           PERFORM 2015-PROCESS-MKT-TIER-C1     THRU 2015-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7013-CLOSE-MKT-TIER-C1       THRU 7013-EXIT.         
                                                                        
           PERFORM 7021-OPEN-MKT-TIER-C2        THRU 7021-EXIT.         
                                                                        
           PERFORM 7022-FETCH-MKT-TIER-C2       THRU 7022-EXIT.         
                                                                        
           PERFORM 2020-PROCESS-MKT-TIER-C2     THRU 2020-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7023-CLOSE-MKT-TIER-C2       THRU 7023-EXIT.         
                                                                        
           PERFORM 7031-OPEN-MKT-TIER-C3        THRU 7031-EXIT.         
                                                                        
           PERFORM 7032-FETCH-MKT-TIER-C3       THRU 7032-EXIT.         
                                                                        
           PERFORM 2025-PROCESS-MKT-TIER-C3     THRU 2025-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7033-CLOSE-MKT-TIER-C3       THRU 7033-EXIT.         
                                                                        
           PERFORM 7041-OPEN-MKT-TIER-C4        THRU 7041-EXIT.         
                                                                        
           PERFORM 7042-FETCH-MKT-TIER-C4       THRU 7042-EXIT.         
                                                                        
           PERFORM 2030-PROCESS-MKT-TIER-C4     THRU 2030-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7043-CLOSE-MKT-TIER-C4       THRU 7043-EXIT.         
                                                                        
           PERFORM 7051-OPEN-MKT-TIER-C5        THRU 7051-EXIT.         
                                                                        
           PERFORM 7052-FETCH-MKT-TIER-C5       THRU 7052-EXIT.         
                                                                        
           PERFORM 2035-PROCESS-MKT-TIER-C5     THRU 2035-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7053-CLOSE-MKT-TIER-C5       THRU 7053-EXIT.         
                                                                        
           PERFORM 7061-OPEN-OFF-MKT-TIER-C1    THRU 7061-EXIT.         
                                                                        
           PERFORM 7062-FETCH-OFF-MKT-TIER-C1   THRU 7062-EXIT.         
                                                                        
           PERFORM 2040-PROCESS-OFF-MKT-TIER-C1 THRU 2040-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7063-CLOSE-OFF-MKT-TIER-C1   THRU 7063-EXIT.         
                                                                        
           PERFORM 7071-OPEN-OFF-MKT-TIER-C2    THRU 7071-EXIT.         
                                                                        
           PERFORM 7072-FETCH-OFF-MKT-TIER-C2   THRU 7072-EXIT.         
                                                                        
           PERFORM 2045-PROCESS-OFF-MKT-TIER-C2 THRU 2045-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7073-CLOSE-OFF-MKT-TIER-C2   THRU 7073-EXIT.         
                                                                        
           PERFORM 7081-OPEN-OFF-MKT-TIER-C3    THRU 7081-EXIT.         
                                                                        
           PERFORM 7082-FETCH-OFF-MKT-TIER-C3   THRU 7082-EXIT.         
                                                                        
           PERFORM 2050-PROCESS-OFF-MKT-TIER-C3 THRU 2050-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7083-CLOSE-OFF-MKT-TIER-C3   THRU 7083-EXIT.         
A00494                                                                  
A00494     PERFORM 7091-OPEN-OFF-MKT-TIER-C4    THRU 7091-EXIT.         
A00494                                                                  
A00494     PERFORM 7092-FETCH-OFF-MKT-TIER-C4   THRU 7092-EXIT.         
A00494                                                                  
A00494     PERFORM 2075-PROCESS-OFF-MKT-TIER-C4 THRU 2075-EXIT          
A00494             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
A00494                                                                  
A00494     PERFORM 7093-CLOSE-OFF-MKT-TIER-C4   THRU 7093-EXIT.         
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_TIER_C1 CURSOR                   **         
      *****************************************************************         
      *                                                                         
       2015-PROCESS-MKT-TIER-C1.                                        
      *                                                                         
           MOVE '2015'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_TIER'           TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-1       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7012-FETCH-MKT-TIER-C1  THRU 7012-EXIT.              
      *                                                                         
       2015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_TIER_C2 CURSOR                   **         
      *****************************************************************         
      *                                                                         
       2020-PROCESS-MKT-TIER-C2.                                        
      *                                                                         
           MOVE '2020'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_TIER'           TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-2       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'CUST_ACCT_DEFLT_FL'     TO D-COLUMN-NAME.              
           MOVE IG-CUST-ACCT-DEFLT-FL    TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7022-FETCH-MKT-TIER-C2  THRU 7022-EXIT.              
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_TIER_C3 CURSOR                   **         
      *****************************************************************         
      *                                                                         
       2025-PROCESS-MKT-TIER-C3.                                        
      *                                                                         
           MOVE '2025'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_TIER'           TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-3       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE IG-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'COMPANY_NO'             TO D-COLUMN-NAME.              
           MOVE IG-COMPANY-NO            TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7032-FETCH-MKT-TIER-C3  THRU 7032-EXIT.              
      *                                                                         
       2025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_TIER_C4 CURSOR                   **         
      *****************************************************************         
      *                                                                         
       2030-PROCESS-MKT-TIER-C4.                                        
      *                                                                         
           MOVE '2030'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_TIER'           TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-4       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE IG-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7042-FETCH-MKT-TIER-C4  THRU 7042-EXIT.              
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_TIER_C5 CURSOR                   **         
      *****************************************************************         
      *                                                                         
       2035-PROCESS-MKT-TIER-C5.                                        
      *                                                                         
           MOVE '2035'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_TIER'           TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-5       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE IG-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE IG-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_START_DT'      TO D-COLUMN-NAME.              
           MOVE IG-MKT-TIER-START-DT     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7052-FETCH-MKT-TIER-C5  THRU 7052-EXIT.              
      *                                                                         
       2035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OFF_MKT_TIER_C1 CURSOR               **         
      *****************************************************************         
      *                                                                         
       2040-PROCESS-OFF-MKT-TIER-C1.                                    
      *                                                                         
           MOVE '2040'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-6       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_START_DT'      TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-START-DT     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_DEFLT_OFFR_CD'     TO D-COLUMN-NAME.              
           MOVE DU-TIER-DEFLT-OFFR-CD    TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7062-FETCH-OFF-MKT-TIER-C1 THRU 7062-EXIT.           
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OFF_MKT_TIER_C2 CURSOR               **         
      *****************************************************************         
      *                                                                         
       2045-PROCESS-OFF-MKT-TIER-C2.                                    
      *                                                                         
           MOVE '2045'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-7       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_START_DT'      TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-START-DT     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OFFER_CD'              TO D-COLUMN-NAME.               
           MOVE DU-OFFER-CD             TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7072-FETCH-OFF-MKT-TIER-C2 THRU 7072-EXIT.           
      *                                                                         
       2045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OFF_MKT_TIER_C3 CURSOR               **         
      *****************************************************************         
      *                                                                         
       2050-PROCESS-OFF-MKT-TIER-C3.                                    
      *                                                                         
           MOVE '2050'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
           MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-8       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_START_DT'      TO D-COLUMN-NAME.              
           MOVE DU-MKT-TIER-START-DT     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OFFER_CD'              TO D-COLUMN-NAME.               
           MOVE DU-OFFER-CD             TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OFFER_TIER_STRT_DT'    TO D-COLUMN-NAME.               
           MOVE DU-OFFER-TIER-STRT-DT   TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'MKT_TIER_APPLY_CD'     TO D-COLUMN-NAME.               
           MOVE DU-MKT-TIER-APPLY-CD    TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7082-FETCH-OFF-MKT-TIER-C3 THRU 7082-EXIT.           
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00494*****************************************************************         
A00494**  ERROR REPORT BASED ON OFF_MKT_TIER_C4 CURSOR               **         
A00494*****************************************************************         
A00494*                                                                         
A00494 2075-PROCESS-OFF-MKT-TIER-C4.                                    
A00494*                                                                         
A00494     MOVE '2075'                   TO WS-ACTIVE-PARAGRAPH.        
A00494*                                                                         
A00494     INITIALIZE                       WS-DETAIL-LINE.             
A00494*                                                                         
A00494     PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
A00494*                                                                         
A00494     MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
A00494     MOVE 'TIER_CUST_STAT_CD'      TO D-COLUMN-NAME.              
A00494     MOVE DU-TIER-CUST-STAT-CD     TO D-COLUMN-VALUE.             
A00494     MOVE WS-ERROR-MESSAGE-54      TO D-ERROR-MESSAGE.            
A00494     PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
A00494*                                                                         
A00494     MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
A00494     MOVE DU-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
A00494     PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
A00494*                                                                         
A00494     MOVE 'MKT_TIER_RANKING'       TO D-COLUMN-NAME.              
A00494     MOVE DU-MKT-TIER-RANKING      TO D-COLUMN-VALUE.             
A00494     PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
A00494*                                                                         
A00494     MOVE 'MKT_TIER_START_DT'      TO D-COLUMN-NAME.              
A00494     MOVE DU-MKT-TIER-START-DT     TO D-COLUMN-VALUE.             
A00494     PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
A00494*                                                                         
A00494     PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
A00494*                                                                         
A00494     PERFORM 7092-FETCH-OFF-MKT-TIER-C4 THRU 7092-EXIT.           
A00494*                                                                         
A00494 2075-EXIT.                                                       
A00494     EXIT.                                                        
A00494*                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA-CSS_SPCL_FCTR & CSS_SPCL_FCTR_APPL **         
      *****************************************************************         
      *                                                                         
       2100-VLDT-SPCL-FCTR-DATA.                                        
      *                                                                         
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7101-OPEN-SPCL-FCTR-C1       THRU 7101-EXIT.         
                                                                        
           PERFORM 7102-FETCH-SPCL-FCTR-C1      THRU 7102-EXIT.         
                                                                        
           PERFORM 2105-PROCESS-SPCL-FCTR-C1    THRU 2105-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7103-CLOSE-SPCL-FCTR-C1      THRU 7103-EXIT.         
                                                                        
           PERFORM 7111-OPEN-SPCL-FCTR-C2       THRU 7111-EXIT.         
                                                                        
           PERFORM 7112-FETCH-SPCL-FCTR-C2      THRU 7112-EXIT.         
                                                                        
           PERFORM 2110-PROCESS-SPCL-FCTR-C2    THRU 2110-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7113-CLOSE-SPCL-FCTR-C2      THRU 7113-EXIT.         
                                                                        
           PERFORM 7121-OPEN-SPCL-FCTR-C3       THRU 7121-EXIT.         
                                                                        
           PERFORM 7122-FETCH-SPCL-FCTR-C3      THRU 7122-EXIT.         
                                                                        
           PERFORM 2115-PROCESS-SPCL-FCTR-C3    THRU 2115-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7123-CLOSE-SPCL-FCTR-C3      THRU 7123-EXIT.         
A04319                                                                  
A04319     PERFORM 7131-OPEN-SPCL-FCTR-C4       THRU 7131-EXIT.         
A04319                                                                  
A04319     PERFORM 7132-FETCH-SPCL-FCTR-C4      THRU 7132-EXIT.         
A04319                                                                  
A04319     PERFORM 2120-PROCESS-SPCL-FCTR-C4    THRU 2120-EXIT          
A04319             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
A04319                                                                  
A04319     PERFORM 7133-CLOSE-SPCL-FCTR-C4      THRU 7133-EXIT.         
      *                                                                         
A04221     PERFORM 7141-OPEN-SPCL-FCTR-C5       THRU 7141-EXIT.         
A04221*                                                                         
A04221     PERFORM 7142-FETCH-SPCL-FCTR-C5      THRU 7142-EXIT.         
A04221*                                                                         
A04221     PERFORM 2125-PROCESS-SPCL-FCTR-C5    THRU 2125-EXIT          
A04221             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
A04221*                                                                         
A04221     PERFORM 7143-CLOSE-SPCL-FCTR-C5      THRU 7143-EXIT.         
A04221*                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SPCL_FCTR_C1 CURSOR                  **         
      *****************************************************************         
      *                                                                         
       2105-PROCESS-SPCL-FCTR-C1.                                       
      *                                                                         
           MOVE '2105'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CSS_SPCL_FCTR'          TO D-TABLE-DESC.               
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE SF-FACTOR-ID             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-9       TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'BILL_PRT_MSG_PL_CD'     TO D-COLUMN-NAME.              
           MOVE SF-BILL-PRT-MSG-PL-CD    TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OVR_RT_CALC_TYP_CD'     TO D-COLUMN-NAME.              
           MOVE SF-OVR-RT-CALC-TYP-CD    TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OVR_RT_VER_PRO_FL'      TO D-COLUMN-NAME.              
           MOVE SF-OVR-RT-VER-PRO-FL     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'DURATION_START_CD'     TO D-COLUMN-NAME.               
           MOVE SF-DURATION-START-CD    TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'DURATION_TYPE_CD'      TO D-COLUMN-NAME.               
           MOVE SF-DURATION-TYPE-CD     TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7102-FETCH-SPCL-FCTR-C1 THRU 7102-EXIT.              
      *                                                                         
       2105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SPCL_FCTR_C2 CURSOR                  **         
      *****************************************************************         
      *                                                                         
       2110-PROCESS-SPCL-FCTR-C2.                                       
      *                                                                         
           MOVE '2110'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CSS_SPCL_FCTR'          TO D-TABLE-DESC.               
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE SF-FACTOR-ID             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-10      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'CSS_SPCL_FCTR_APPL'     TO D-TABLE-DESC.               
           MOVE 'CODE_UTIL_TYPE'         TO D-COLUMN-NAME.              
           MOVE SA-CODE-UTIL-TYPE        TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'RATE_PLAN_NO'           TO D-COLUMN-NAME.              
           MOVE SA-RATE-PLAN-NO          TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'DATE_FROM'              TO D-COLUMN-NAME.              
           MOVE SA-DATE-FROM             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'ENTRY_NO'              TO D-COLUMN-NAME.               
           MOVE SA-ENTRY-NO             TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'DATE_TO'               TO D-COLUMN-NAME.               
           MOVE SA-DATE-TO              TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'CMPNT_ID_CD'           TO D-COLUMN-NAME.               
           MOVE SA-CMPNT-ID-CD          TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7112-FETCH-SPCL-FCTR-C2 THRU 7112-EXIT.              
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SPCL_FCTR_C3 CURSOR                  **         
      *****************************************************************         
      *                                                                         
       2115-PROCESS-SPCL-FCTR-C3.                                       
      *                                                                         
           MOVE '2115'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CSS_SPCL_FCTR_APPL'     TO D-TABLE-DESC.               
           MOVE 'CODE_UTIL_TYPE'         TO D-COLUMN-NAME.              
           MOVE SA-CODE-UTIL-TYPE        TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-11      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'RATE_PLAN_NO'           TO D-COLUMN-NAME.              
           MOVE SA-RATE-PLAN-NO          TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE SA-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'DATE_FROM'              TO D-COLUMN-NAME.              
           MOVE SA-DATE-FROM             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'ENTRY_NO'              TO D-COLUMN-NAME.               
           MOVE SA-ENTRY-NO             TO D-COLUMN-VALUE.              
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7122-FETCH-SPCL-FCTR-C3 THRU 7122-EXIT.              
      *                                                                         
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04319*****************************************************************         
A04319**  ERROR REPORT BASED ON SPCL_FCTR_C4 CURSOR                  **         
A04319*****************************************************************         
A04319*                                                                         
A04319 2120-PROCESS-SPCL-FCTR-C4.                                       
A04319*                                                                         
A04319     MOVE '2120'                       TO WS-ACTIVE-PARAGRAPH.    
A04319*                                                                         
A04319     INITIALIZE                           WS-DETAIL-LINE.         
A04319*                                                                         
A04319     PERFORM 8400-PRINT-NEXT-PAGE-CHK  THRU 8400-EXIT.            
A04319*                                                                         
A04319     MOVE 'CSS_SPCL_FCTR_APPL'         TO D-TABLE-DESC.           
A04319     MOVE 'RATE_PLAN_NO'               TO D-COLUMN-NAME.          
A04319     MOVE SA-RATE-PLAN-NO              TO D-COLUMN-VALUE.         
A04319     MOVE WS-ERROR-MESSAGE-59          TO D-ERROR-MESSAGE.        
A04319     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04319*                                                                         
A04319     MOVE 'FACTOR_ID'                  TO D-COLUMN-NAME.          
A04319     MOVE SA-FACTOR-ID                 TO D-COLUMN-VALUE.         
A04319     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04319*                                                                         
A04319     MOVE 'CODE_UTIL_TYPE'             TO D-COLUMN-NAME.          
A04319     MOVE SA-CODE-UTIL-TYPE            TO D-COLUMN-VALUE.         
A04319     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04319*                                                                         
A04319     MOVE 'CMPNT_ID_CD'                TO D-COLUMN-NAME.          
A04319     MOVE SA-CMPNT-ID-CD               TO D-COLUMN-VALUE.         
A04319     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04319*                                                                         
A04319     PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
A04319*                                                                         
A04319     PERFORM 7132-FETCH-SPCL-FCTR-C4   THRU 7132-EXIT.            
A04319*                                                                         
A04319 2120-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
A04221*****************************************************************         
A04221**  ERROR REPORT BASED ON SPCL_FCTR_C5 CURSOR                  **         
A04221*****************************************************************         
A04221*                                                                         
A04221 2125-PROCESS-SPCL-FCTR-C5.                                       
A04221*                                                                         
A04221     MOVE '2125'                       TO WS-ACTIVE-PARAGRAPH.    
A04221*                                                                         
A04221     INITIALIZE                           WS-DETAIL-LINE.         
A04221*                                                                         
A04221     PERFORM 8400-PRINT-NEXT-PAGE-CHK  THRU 8400-EXIT.            
A04221*                                                                         
A04221     MOVE 'CSS_SPCL_FCTR_APPL'         TO D-TABLE-DESC.           
A04221     MOVE 'RATE_PLAN_NO'               TO D-COLUMN-NAME.          
A04221     MOVE SA-RATE-PLAN-NO              TO D-COLUMN-VALUE.         
A04221     MOVE WS-ERROR-MESSAGE-60          TO D-ERROR-MESSAGE.        
A04221     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04221*                                                                         
A04221     MOVE 'FACTOR_ID'                  TO D-COLUMN-NAME.          
A04221     MOVE SA-FACTOR-ID                 TO D-COLUMN-VALUE.         
A04221     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
A04221*                                                                         
A04221     PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
A04221*                                                                         
A04221     PERFORM 7142-FETCH-SPCL-FCTR-C5   THRU 7142-EXIT.            
A04221*                                                                         
A04221 2125-EXIT.                                                       
A04221     EXIT.                                                        
A04221*                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA - CRM_MKT_PROMOTION                **         
      *****************************************************************         
      *                                                                         
       2200-VLDT-MKT-PROMO-DATA.                                        
      *                                                                         
           MOVE '2200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7201-OPEN-MKT-PROMO-C1   THRU 7201-EXIT.             
                                                                        
           PERFORM 7202-FETCH-MKT-PROMO-C1  THRU 7202-EXIT.             
                                                                        
           PERFORM 2205-PROCESS-MKT-PROMO-C1   THRU 2205-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7203-CLOSE-MKT-PROMO-C1  THRU 7203-EXIT.             
                                                                        
           PERFORM 7211-OPEN-MKT-PROMO-C2   THRU 7211-EXIT.             
                                                                        
           PERFORM 7212-FETCH-MKT-PROMO-C2  THRU 7212-EXIT.             
                                                                        
           PERFORM 2210-PROCESS-MKT-PROMO-C2   THRU 2210-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7213-CLOSE-MKT-PROMO-C2  THRU 7213-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_PROMOTION_C1 CURSOR              **         
      *****************************************************************         
      *                                                                         
       2205-PROCESS-MKT-PROMO-C1.                                       
      *                                                                         
           MOVE '2205'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_PROMOTION'      TO D-TABLE-DESC.               
           MOVE 'REPLACMNT_PROMO_CD'     TO D-COLUMN-NAME.              
           MOVE KM-REPLACMNT-PROMO-CD    TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-12      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7202-FETCH-MKT-PROMO-C1 THRU 7202-EXIT.              
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MKT_PROMOTION_C2 CURSOR              **         
      *****************************************************************         
      *                                                                         
       2210-PROCESS-MKT-PROMO-C2.                                       
      *                                                                         
           MOVE '2210'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_MKT_PROMOTION'      TO D-TABLE-DESC.               
           MOVE 'PROMO_CD'               TO D-COLUMN-NAME.              
           MOVE KM-PROMO-CD              TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-13      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7212-FETCH-MKT-PROMO-C2 THRU 7212-EXIT.              
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA - RATE_GROUP TABLES                **         
      *****************************************************************         
      *                                                                         
       2300-VLDT-RATE-GROUP-DATA.                                       
      *                                                                         
           MOVE '2300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7301-OPEN-RATE-GROUP-C1  THRU 7301-EXIT.             
                                                                        
           PERFORM 7302-FETCH-RATE-GROUP-C1 THRU 7302-EXIT.             
                                                                        
           PERFORM 2305-PROCESS-RATE-GROUP-C1  THRU 2305-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7303-CLOSE-RATE-GROUP-C1 THRU 7303-EXIT.             
                                                                        
           PERFORM 7311-OPEN-RATE-GROUP-C2  THRU 7311-EXIT.             
                                                                        
           PERFORM 7312-FETCH-RATE-GROUP-C2 THRU 7312-EXIT.             
                                                                        
           PERFORM 2310-PROCESS-RATE-GROUP-C2  THRU 2310-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7313-CLOSE-RATE-GROUP-C2 THRU 7313-EXIT.             
      *                                                                         
      *    PERFORM 7321-OPEN-RATE-GROUP-C3  THRU 7321-EXIT.                     
      *                                                                         
      *    PERFORM 7322-FETCH-RATE-GROUP-C3 THRU 7322-EXIT.                     
      *                                                                         
      *    PERFORM 2315-PROCESS-RATE-GROUP-C3  THRU 2315-EXIT                   
      *            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
      *                                                                         
      *    PERFORM 7323-CLOSE-RATE-GROUP-C3 THRU 7323-EXIT.                     
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RATE_GROUP_C1 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2305-PROCESS-RATE-GROUP-C1.                                      
      *                                                                         
           MOVE '2305'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RATE_GROUP'         TO D-TABLE-DESC.               
           MOVE 'RATE_GROUP_TYPE_CD'     TO D-COLUMN-NAME.              
           MOVE F7-RATE-GROUP-TYPE-CD    TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-14      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'RATE_GROUP_CD'          TO D-COLUMN-NAME.              
           MOVE F7-RATE-GROUP-CD         TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7302-FETCH-RATE-GROUP-C1 THRU 7302-EXIT.             
      *                                                                         
       2305-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RATE_GROUP_C2 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2310-PROCESS-RATE-GROUP-C2.                                      
      *                                                                         
           MOVE '2310'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RATE_GRP_OFFER'     TO D-TABLE-DESC.               
           MOVE 'RATE_GROUP_TYPE_CD'     TO D-COLUMN-NAME.              
           MOVE G5-RATE-GROUP-TYPE-CD    TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-15      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'RATE_GROUP_CD'          TO D-COLUMN-NAME.              
           MOVE G5-RATE-GROUP-CD         TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'EFF_START_DT'           TO D-COLUMN-NAME.              
           MOVE G5-EFF-START-DT          TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'OFFER_CD'               TO D-COLUMN-NAME.              
           MOVE G5-OFFER-CD              TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7312-FETCH-RATE-GROUP-C2 THRU 7312-EXIT.             
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RATE_GROUP_C3 CURSOR                 **         
      *****************************************************************         
      *                                                                         
      *2315-PROCESS-RATE-GROUP-C3.                                              
      *                                                                         
      *    MOVE '2315'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    INITIALIZE                       WS-DETAIL-LINE.                     
      *                                                                         
      *    PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.                     
      *                                                                         
      *    MOVE 'CRM_RATE_GRP_OFFER'     TO D-TABLE-DESC.                       
      *    MOVE 'RATE_GROUP_TYPE_CD'     TO D-COLUMN-NAME.                      
      *    MOVE G5-RATE-GROUP-TYPE-CD    TO D-COLUMN-VALUE.                     
      *    MOVE WS-ERROR-MESSAGE-52      TO D-ERROR-MESSAGE.                    
      *    PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.                      
      *                                                                         
      *    MOVE 'RATE_GROUP_CD'          TO D-COLUMN-NAME.                      
      *    MOVE G5-RATE-GROUP-CD         TO D-COLUMN-VALUE.                     
      *    PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.                      
      *                                                                         
      *    MOVE 'EFF_START_DT'           TO D-COLUMN-NAME.                      
      *    MOVE G5-EFF-START-DT          TO D-COLUMN-VALUE.                     
      *    PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.                      
      *                                                                         
      *    MOVE 'EFF_END_DT'             TO D-COLUMN-NAME.                      
      *    MOVE G5-EFF-END-DT            TO D-COLUMN-VALUE.                     
      *    PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.                      
      *                                                                         
      *    MOVE 'OFFER_CD'               TO D-COLUMN-NAME.                      
      *    MOVE G5-OFFER-CD              TO D-COLUMN-VALUE.                     
      *    PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.                      
      *                                                                         
      *    PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.                      
      *                                                                         
      *    PERFORM 7322-FETCH-RATE-GROUP-C3 THRU 7322-EXIT.                     
      *                                                                         
      *2315-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA-CRM_RT_PKG_OPTION & RELATED TABLES **         
      *****************************************************************         
      *                                                                         
       2400-VLDT-RTPKG-OPTION-DATA.                                     
      *                                                                         
           MOVE '2400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7411-OPEN-RTPKG-OPT-C2   THRU 7411-EXIT.             
                                                                        
           PERFORM 7412-FETCH-RTPKG-OPT-C2  THRU 7412-EXIT.             
                                                                        
           PERFORM 2410-PROCESS-RTPKG-OPT-C2   THRU 2410-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7413-CLOSE-RTPKG-OPT-C2  THRU 7413-EXIT.             
                                                                        
           PERFORM 7421-OPEN-RTPKG-OPT-C3   THRU 7421-EXIT.             
                                                                        
           PERFORM 7422-FETCH-RTPKG-OPT-C3  THRU 7422-EXIT.             
                                                                        
           PERFORM 2415-PROCESS-RTPKG-OPT-C3   THRU 2415-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7423-CLOSE-RTPKG-OPT-C3  THRU 7423-EXIT.             
                                                                        
           PERFORM 7431-OPEN-RTPKG-OPT-C4   THRU 7431-EXIT.             
                                                                        
           PERFORM 7432-FETCH-RTPKG-OPT-C4  THRU 7432-EXIT.             
                                                                        
           PERFORM 2420-PROCESS-RTPKG-OPT-C4   THRU 2420-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7433-CLOSE-RTPKG-OPT-C4  THRU 7433-EXIT.             
P00396*                                                                         
P00396     PERFORM 7441-OPEN-RTPKG-OPT-C5   THRU 7441-EXIT.             
P00396                                                                  
P00396     PERFORM 7442-FETCH-RTPKG-OPT-C5  THRU 7442-EXIT.             
P00396                                                                  
P00396     PERFORM 2425-PROCESS-RTPKG-OPT-C5   THRU 2425-EXIT           
P00396             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
P00396                                                                  
P00396     PERFORM 7443-CLOSE-RTPKG-OPT-C5  THRU 7443-EXIT.             
P00485*                                                                         
P00485     INITIALIZE                FI-CURR-EXT-DESC-LONG              
P00485                               FI-WEB-MKT-DESC-LONG.              
P00485     PERFORM 7461-OPEN-RTPKG-OPT-C7   THRU 7461-EXIT.             
P00485                                                                  
P00485     PERFORM 7462-FETCH-RTPKG-OPT-C7  THRU 7462-EXIT.             
P00485                                                                  
P00485     PERFORM 2440-PROCESS-RTPKG-OPT-C7   THRU 2440-EXIT           
P00485             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
P00485                                                                  
P00485     PERFORM 7463-CLOSE-RTPKG-OPT-C7  THRU 7463-EXIT.             
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OPT_C2  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2410-PROCESS-RTPKG-OPT-C2.                                       
      *                                                                         
           MOVE '2410'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OPTION'      TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE FI-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-17      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7412-FETCH-RTPKG-OPT-C2 THRU 7412-EXIT.              
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OPT_C3  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2415-PROCESS-RTPKG-OPT-C3.                                       
      *                                                                         
           MOVE '2415'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OPTION'      TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE FI-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-18      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7422-FETCH-RTPKG-OPT-C3 THRU 7422-EXIT.              
      *                                                                         
       2415-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OPT_C4  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2420-PROCESS-RTPKG-OPT-C4.                                       
      *                                                                         
           MOVE '2420'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OPTION'      TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE FI-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-19      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           MOVE 'RATE_PLAN_NO'           TO D-COLUMN-NAME.              
           MOVE FI-RATE-PLAN-NO          TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
      *                                                                         
           PERFORM 7432-FETCH-RTPKG-OPT-C4 THRU 7432-EXIT.              
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
P00396*                                                                         
P00396*****************************************************************         
P00396**  ERROR REPORT BASED ON RTPKG_OPT_C5  CURSOR                 **         
P00396*****************************************************************         
P00396*                                                                         
P00396 2425-PROCESS-RTPKG-OPT-C5.                                       
P00396*                                                                         
P00396     MOVE '2425'                   TO WS-ACTIVE-PARAGRAPH.        
P00396*                                                                         
P00396     INITIALIZE                       WS-DETAIL-LINE.             
P00396*                                                                         
P00396     PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
P00396*                                                                         
P00396     MOVE 'CRM_RT_PKG_OPTION'      TO D-TABLE-DESC.               
P00396     MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
P00396     MOVE FI-OPTION-CD             TO D-COLUMN-VALUE.             
P00396     MOVE WS-ERROR-MESSAGE-55      TO D-ERROR-MESSAGE.            
P00396     PERFORM 8300-PRINT-DETAIL-LINE  THRU 8300-EXIT.              
P00396*                                                                         
P00396     PERFORM 8500-PRINT-BLANK-LINE   THRU 8500-EXIT.              
P00396*                                                                         
P00396     PERFORM 7442-FETCH-RTPKG-OPT-C5 THRU 7442-EXIT.              
P00396*                                                                         
P00396 2425-EXIT.                                                       
P00396     EXIT.                                                        
      *                                                                         
P00485*****************************************************************         
P00485**  ERROR REPORT BASED ON RTPKG_OPT_C7  CURSOR                 **         
P00485*****************************************************************         
P00485*                                                                         
P00485 2440-PROCESS-RTPKG-OPT-C7.                                       
P00485*                                                                         
P00485     MOVE '2440'                   TO WS-ACTIVE-PARAGRAPH.        
P00485*                                                                         
P00485     INITIALIZE                       WS-DETAIL-LINE.             
P00485                                                                  
P00485*   ------------------------------------------------------                
P00485*    VALIDATION FOR CURRENT EXTERNAL DESCRIPTION LENGTH                   
P00485*   ------------------------------------------------------                
P00485     INSPECT FI-CURR-EXT-DESC-LONG-TEXT TALLYING                  
P00485                    WS-INSPECT-EXT-CNT FOR CHARACTERS BEFORE '  ' 
p00485     IF WS-INSPECT-EXT-CNT   > WS-EXT-DESC-LIMIT                  
P00485        PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT           
P00485*                                                                         
P00485        MOVE 'CRM_RT_PKG_OPTION'      TO D-TABLE-DESC             
P00485        MOVE 'CURR_EXT_DESC_LONG'     TO D-COLUMN-NAME            
P00485        MOVE FI-OPTION-CD             TO D-COLUMN-VALUE           
P00485        MOVE WS-ERROR-MESSAGE-58      TO D-ERROR-MESSAGE          
P00485        PERFORM 8300-PRINT-DETAIL-LINE   THRU 8300-EXIT           
P00485        PERFORM 8500-PRINT-BLANK-LINE    THRU 8500-EXIT           
P00485     END-IF.                                                      
P00485*                                                                         
P00485     INITIALIZE                 FI-CURR-EXT-DESC-LONG             
P00485                                WS-INSPECT-EXT-CNT                
P00485     PERFORM 7462-FETCH-RTPKG-OPT-C7  THRU 7462-EXIT.             
P00485*                                                                         
P00485 2440-EXIT.                                                       
P00485     EXIT.                                                        
      *****************************************************************         
      ** VALIDATE USER TABLE DATA-CRM_RT_PKG_OFFER & RELATED TABLES  **         
      *****************************************************************         
      *                                                                         
       2500-VLDT-RTPKG-OFFER-DATA.                                      
      *                                                                         
           MOVE '2500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7501-OPEN-RTPKG-OFFER-C1 THRU 7501-EXIT.             
                                                                        
           PERFORM 7502-FETCH-RTPKG-OFFER-C1 THRU 7502-EXIT.            
                                                                        
           PERFORM 2505-PROCESS-RTPKG-OFFER-C1  THRU 2505-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7503-CLOSE-RTPKG-OFFER-C1  THRU 7503-EXIT.           
                                                                        
           PERFORM 7511-OPEN-RTPKG-OFFER-C2 THRU 7511-EXIT.             
                                                                        
           PERFORM 7512-FETCH-RTPKG-OFFER-C2 THRU 7512-EXIT.            
                                                                        
           PERFORM 2510-PROCESS-RTPKG-OFFER-C2  THRU 2510-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7513-CLOSE-RTPKG-OFFER-C2  THRU 7513-EXIT.           
                                                                        
      *    PERFORM 7521-OPEN-RTPKG-OFFER-C3 THRU 7521-EXIT.                     
                                                                        
      *    PERFORM 7522-FETCH-RTPKG-OFFER-C3 THRU 7522-EXIT.                    
                                                                        
      *    PERFORM 2515-PROCESS-RTPKG-OFFER-C3  THRU 2515-EXIT                  
      *            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
      *    PERFORM 7523-CLOSE-RTPKG-OFFER-C3  THRU 7523-EXIT.                   
                                                                        
           PERFORM 7531-OPEN-RTPKG-OFFER-C4 THRU 7531-EXIT.             
                                                                        
           PERFORM 7532-FETCH-RTPKG-OFFER-C4 THRU 7532-EXIT.            
                                                                        
           PERFORM 2520-PROCESS-RTPKG-OFFER-C4  THRU 2520-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7533-CLOSE-RTPKG-OFFER-C4  THRU 7533-EXIT.           
                                                                        
           PERFORM 7541-OPEN-RTPKG-OFFER-C5 THRU 7541-EXIT.             
                                                                        
           PERFORM 7542-FETCH-RTPKG-OFFER-C5 THRU 7542-EXIT.            
                                                                        
           PERFORM 2525-PROCESS-RTPKG-OFFER-C5  THRU 2525-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7543-CLOSE-RTPKG-OFFER-C5  THRU 7543-EXIT.           
                                                                        
           PERFORM 7561-OPEN-RTPKG-OFFER-C7 THRU 7561-EXIT.             
                                                                        
           PERFORM 7562-FETCH-RTPKG-OFFER-C7 THRU 7562-EXIT.            
                                                                        
           PERFORM 2535-PROCESS-RTPKG-OFFER-C7  THRU 2535-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7563-CLOSE-RTPKG-OFFER-C7  THRU 7563-EXIT.           
                                                                        
           PERFORM 7571-OPEN-RTPKG-OFFER-C8 THRU 7571-EXIT.             
                                                                        
           PERFORM 7572-FETCH-RTPKG-OFFER-C8 THRU 7572-EXIT.            
                                                                        
           PERFORM 2540-PROCESS-RTPKG-OFFER-C8  THRU 2540-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7573-CLOSE-RTPKG-OFFER-C8  THRU 7573-EXIT.           
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C1  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2505-PROCESS-RTPKG-OFFER-C1.                                     
      *                                                                         
           MOVE '2505'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'OFFER_CD'               TO D-COLUMN-NAME.              
           MOVE FG-OFFER-CD              TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-20      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7502-FETCH-RTPKG-OFFER-C1 THRU 7502-EXIT.            
      *                                                                         
       2505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C2  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2510-PROCESS-RTPKG-OFFER-C2.                                     
      *                                                                         
           MOVE '2510'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'OFFER_CD'               TO D-COLUMN-NAME.              
           MOVE FG-OFFER-CD              TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-21      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7512-FETCH-RTPKG-OFFER-C2 THRU 7512-EXIT.            
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C3  CURSOR                 **         
      *****************************************************************         
      *                                                                         
      *2515-PROCESS-RTPKG-OFFER-C3.                                             
      *                                                                         
      *    MOVE '2515'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    INITIALIZE                       WS-DETAIL-LINE.                     
      *                                                                         
      *    PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.                     
      *                                                                         
      *    MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.                       
      *    MOVE 'OFFER_CD'               TO D-COLUMN-NAME.                      
      *    MOVE FG-OFFER-CD              TO D-COLUMN-VALUE.                     
      *    MOVE WS-ERROR-MESSAGE-22      TO D-ERROR-MESSAGE.                    
      *    PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.                    
      *                                                                         
      *    PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.                    
      *                                                                         
      *    PERFORM 7522-FETCH-RTPKG-OFFER-C3 THRU 7522-EXIT.                    
      *                                                                         
      *2515-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C4  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2520-PROCESS-RTPKG-OFFER-C4.                                     
      *                                                                         
           MOVE '2520'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'OFFER_CD'               TO D-COLUMN-NAME.              
           MOVE FG-OFFER-CD              TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-23      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7532-FETCH-RTPKG-OFFER-C4 THRU 7532-EXIT.            
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C5  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2525-PROCESS-RTPKG-OFFER-C5.                                     
      *                                                                         
           MOVE '2525'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'RENEWAL_OFFER_CD'       TO D-COLUMN-NAME.              
           MOVE FG-RENEWAL-OFFER-CD      TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-24      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7542-FETCH-RTPKG-OFFER-C5 THRU 7542-EXIT.            
      *                                                                         
       2525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C7  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2535-PROCESS-RTPKG-OFFER-C7.                                     
      *                                                                         
           MOVE '2535'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'RENEWAL_OFFER_CD'       TO D-COLUMN-NAME.              
           MOVE FG-RENEWAL-OFFER-CD      TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-26      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7562-FETCH-RTPKG-OFFER-C7 THRU 7562-EXIT.            
      *                                                                         
       2535-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON RTPKG_OFF_C8  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2540-PROCESS-RTPKG-OFFER-C8.                                     
      *                                                                         
           MOVE '2540'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_RT_PKG_OFFER'       TO D-TABLE-DESC.               
           MOVE 'OFFER_CD'               TO D-COLUMN-NAME.              
           MOVE FG-OFFER-CD              TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-27      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'CRM_OFF_MKT_TIER'       TO D-TABLE-DESC.               
           MOVE 'RENEWAL_OFFER_CD'       TO D-COLUMN-NAME.              
           MOVE FG-RENEWAL-OFFER-CD      TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'TIER_ACCT_TYPE_CD'      TO D-COLUMN-NAME.              
           MOVE DU-TIER-ACCT-TYPE-CD     TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7572-FETCH-RTPKG-OFFER-C8 THRU 7572-EXIT.            
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** VALIDATE USER TABLE DATA-CRM_OPT_ATTR_INCTV & RELATED TABLES**         
      *****************************************************************         
      *                                                                         
       2600-VLDT-ATTR-INCTV-DATA.                                       
      *                                                                         
           MOVE '2600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7601-OPEN-OPT-INCTV-C1      THRU 7601-EXIT.          
                                                                        
           PERFORM 7602-FETCH-OPT-INCTV-C1     THRU 7602-EXIT.          
                                                                        
           PERFORM 2605-PROCESS-OPT-INCTV-C1   THRU 2605-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7603-CLOSE-OPT-INCTV-C1     THRU 7603-EXIT.          
                                                                        
           PERFORM 7615-OPEN-OPT-INCTV-C2      THRU 7615-EXIT.          
                                                                        
           PERFORM 7616-FETCH-OPT-INCTV-C2     THRU 7616-EXIT.          
                                                                        
           PERFORM 2610-PROCESS-OPT-INCTV-C2   THRU 2610-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7617-CLOSE-OPT-INCTV-C2     THRU 7617-EXIT.          
                                                                        
           PERFORM 7621-OPEN-OPT-INCTV-C3      THRU 7621-EXIT.          
                                                                        
           PERFORM 7622-FETCH-OPT-INCTV-C3     THRU 7622-EXIT.          
                                                                        
           PERFORM 2615-PROCESS-OPT-INCTV-C3   THRU 2615-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7623-CLOSE-OPT-INCTV-C3     THRU 7623-EXIT.          
                                                                        
           PERFORM 7631-OPEN-OPT-INCTV-C4      THRU 7631-EXIT.          
                                                                        
           PERFORM 7632-FETCH-OPT-INCTV-C4     THRU 7632-EXIT.          
                                                                        
           PERFORM 2620-PROCESS-OPT-INCTV-C4   THRU 2620-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7633-CLOSE-OPT-INCTV-C4     THRU 7633-EXIT.          
                                                                        
P00141     PERFORM 7634-OPEN-OPT-INCTV-C5      THRU 7634-EXIT.          
P00141                                                                  
P00141     PERFORM 7635-FETCH-OPT-INCTV-C5     THRU 7635-EXIT.          
P00141                                                                  
P00141     PERFORM 2625-PROCESS-OPT-INCTV-C5   THRU 2625-EXIT           
P00141             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
P00141                                                                  
P00141     PERFORM 7636-CLOSE-OPT-INCTV-C5     THRU 7636-EXIT.          
P00141                                                                  
           PERFORM 7651-OPEN-FIX-PRICE-C1      THRU 7651-EXIT.          
                                                                        
           PERFORM 7652-FETCH-FIX-PRICE-C1     THRU 7652-EXIT.          
                                                                        
           PERFORM 2650-PROCESS-FIX-PRICE-C1   THRU 2650-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7653-CLOSE-FIX-PRICE-C1     THRU 7653-EXIT.          
                                                                        
           PERFORM 7661-OPEN-FIX-PRICE-C2      THRU 7661-EXIT.          
                                                                        
           PERFORM 7662-FETCH-FIX-PRICE-C2     THRU 7662-EXIT.          
                                                                        
           PERFORM 2655-PROCESS-FIX-PRICE-C2   THRU 2655-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7663-CLOSE-FIX-PRICE-C2     THRU 7663-EXIT.          
                                                                        
           PERFORM 7671-OPEN-FIX-PRICE-C3      THRU 7671-EXIT.          
                                                                        
           PERFORM 7672-FETCH-FIX-PRICE-C3     THRU 7672-EXIT.          
                                                                        
           PERFORM 2660-PROCESS-FIX-PRICE-C3   THRU 2660-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7673-CLOSE-FIX-PRICE-C3     THRU 7673-EXIT.          
                                                                        
           PERFORM 7681-OPEN-FIX-PRICE-C4      THRU 7681-EXIT.          
                                                                        
           PERFORM 7682-FETCH-FIX-PRICE-C4     THRU 7682-EXIT.          
                                                                        
           PERFORM 2665-PROCESS-FIX-PRICE-C4   THRU 2665-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7683-CLOSE-FIX-PRICE-C4     THRU 7683-EXIT.          
                                                                        
           PERFORM 7701-OPEN-MONTHLY-CR-C1     THRU 7701-EXIT.          
                                                                        
           PERFORM 7702-FETCH-MONTHLY-CR-C1    THRU 7702-EXIT.          
                                                                        
           PERFORM 2705-PROCESS-MONTHLY-CR-C1  THRU 2705-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7703-CLOSE-MONTHLY-CR-C1    THRU 7703-EXIT.          
                                                                        
           PERFORM 7711-OPEN-MONTHLY-CR-C2     THRU 7711-EXIT.          
                                                                        
           PERFORM 7712-FETCH-MONTHLY-CR-C2    THRU 7712-EXIT.          
                                                                        
           PERFORM 2710-PROCESS-MONTHLY-CR-C2  THRU 2710-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7713-CLOSE-MONTHLY-CR-C2    THRU 7713-EXIT.          
                                                                        
           PERFORM 7721-OPEN-MONTHLY-CR-C3     THRU 7721-EXIT.          
                                                                        
           PERFORM 7722-FETCH-MONTHLY-CR-C3    THRU 7722-EXIT.          
                                                                        
           PERFORM 2715-PROCESS-MONTHLY-CR-C3  THRU 2715-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7723-CLOSE-MONTHLY-CR-C3    THRU 7723-EXIT.          
                                                                        
           PERFORM 7731-OPEN-MONTHLY-CR-C4     THRU 7731-EXIT.          
                                                                        
           PERFORM 7732-FETCH-MONTHLY-CR-C4    THRU 7732-EXIT.          
                                                                        
           PERFORM 2720-PROCESS-MONTHLY-CR-C4  THRU 2720-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7733-CLOSE-MONTHLY-CR-C4    THRU 7733-EXIT.          
                                                                        
           PERFORM 7751-OPEN-FREE-CSC-C1       THRU 7751-EXIT.          
                                                                        
           PERFORM 7752-FETCH-FREE-CSC-C1      THRU 7752-EXIT.          
                                                                        
           PERFORM 2750-PROCESS-FREE-CSC-C1    THRU 2750-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7753-CLOSE-FREE-CSC-C1      THRU 7753-EXIT.          
                                                                        
      *    PERFORM 7761-OPEN-FREE-CSC-C2       THRU 7761-EXIT.                  
      *                                                                         
      *    PERFORM 7762-FETCH-FREE-CSC-C2      THRU 7762-EXIT.                  
      *                                                                         
      *    PERFORM 2755-PROCESS-FREE-CSC-C2    THRU 2755-EXIT                   
      *            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
      *                                                                         
      *    PERFORM 7763-CLOSE-FREE-CSC-C2      THRU 7763-EXIT.                  
      *                                                                         
           PERFORM 7771-OPEN-FREE-CSC-C3       THRU 7771-EXIT.          
                                                                        
           PERFORM 7772-FETCH-FREE-CSC-C3      THRU 7772-EXIT.          
                                                                        
           PERFORM 2760-PROCESS-FREE-CSC-C3    THRU 2760-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7773-CLOSE-FREE-CSC-C3      THRU 7773-EXIT.          
                                                                        
           PERFORM 7781-OPEN-FREE-CSC-C4       THRU 7781-EXIT.          
                                                                        
           PERFORM 7782-FETCH-FREE-CSC-C4      THRU 7782-EXIT.          
                                                                        
           PERFORM 2765-PROCESS-FREE-CSC-C4    THRU 2765-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7783-CLOSE-FREE-CSC-C4      THRU 7783-EXIT.          
                                                                        
           PERFORM 7801-OPEN-SIGNUP-CR-C1      THRU 7801-EXIT.          
                                                                        
           PERFORM 7802-FETCH-SIGNUP-CR-C1     THRU 7802-EXIT.          
                                                                        
           PERFORM 2805-PROCESS-SIGNUP-CR-C1   THRU 2805-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7803-CLOSE-SIGNUP-CR-C1     THRU 7803-EXIT.          
                                                                        
           PERFORM 7811-OPEN-SIGNUP-CR-C2      THRU 7811-EXIT.          
                                                                        
           PERFORM 7812-FETCH-SIGNUP-CR-C2     THRU 7812-EXIT.          
                                                                        
           PERFORM 2810-PROCESS-SIGNUP-CR-C2   THRU 2810-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7813-CLOSE-SIGNUP-CR-C2     THRU 7813-EXIT.          
                                                                        
           PERFORM 7851-OPEN-EXIT-FEE-C1       THRU 7851-EXIT.          
                                                                        
           PERFORM 7852-FETCH-EXIT-FEE-C1      THRU 7852-EXIT.          
                                                                        
           PERFORM 2850-PROCESS-EXIT-FEE-C1    THRU 2850-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7853-CLOSE-EXIT-FEE-C1      THRU 7853-EXIT.          
                                                                        
           PERFORM 7861-OPEN-EXIT-FEE-C2       THRU 7861-EXIT.          
                                                                        
           PERFORM 7862-FETCH-EXIT-FEE-C2      THRU 7862-EXIT.          
                                                                        
           PERFORM 2855-PROCESS-EXIT-FEE-C2    THRU 2855-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7863-CLOSE-EXIT-FEE-C2      THRU 7863-EXIT.          
                                                                        
           PERFORM 7871-OPEN-EXIT-FEE-C3       THRU 7871-EXIT.          
                                                                        
           PERFORM 7872-FETCH-EXIT-FEE-C3      THRU 7872-EXIT.          
                                                                        
           PERFORM 2860-PROCESS-EXIT-FEE-C3    THRU 2860-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7873-CLOSE-EXIT-FEE-C3      THRU 7873-EXIT.          
                                                                        
           PERFORM 7881-OPEN-EXIT-FEE-C4       THRU 7881-EXIT.          
                                                                        
           PERFORM 7882-FETCH-EXIT-FEE-C4      THRU 7882-EXIT.          
                                                                        
           PERFORM 2865-PROCESS-EXIT-FEE-C4    THRU 2865-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7883-CLOSE-EXIT-FEE-C4      THRU 7883-EXIT.          
                                                                        
           PERFORM 7901-OPEN-SKYMILES-C1       THRU 7901-EXIT.          
                                                                        
           PERFORM 7902-FETCH-SKYMILES-C1      THRU 7902-EXIT.          
                                                                        
           PERFORM 2905-PROCESS-SKYMILES-C1    THRU 2905-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7903-CLOSE-SKYMILES-C1      THRU 7903-EXIT.          
                                                                        
           PERFORM 7911-OPEN-SKYMILES-C2       THRU 7911-EXIT.          
                                                                        
           PERFORM 7912-FETCH-SKYMILES-C2      THRU 7912-EXIT.          
                                                                        
           PERFORM 2910-PROCESS-SKYMILES-C2    THRU 2910-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7913-CLOSE-SKYMILES-C2      THRU 7913-EXIT.          
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OPT_INCTV_C1  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2605-PROCESS-OPT-INCTV-C1.                                       
      *                                                                         
           MOVE '2605'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-28      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7602-FETCH-OPT-INCTV-C1   THRU 7602-EXIT.            
      *                                                                         
       2605-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OPT_INCTV_C2  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2610-PROCESS-OPT-INCTV-C2.                                       
      *                                                                         
           MOVE '2610'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-29      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'RT_ATTR_INCTV_TYPE'     TO D-COLUMN-NAME.              
           MOVE HQ-RT-ATTR-INCTV-TYPE    TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7616-FETCH-OPT-INCTV-C2   THRU 7616-EXIT.            
      *                                                                         
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OPT_INCTV_C3  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2615-PROCESS-OPT-INCTV-C3.                                       
      *                                                                         
           MOVE '2615'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-30      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7622-FETCH-OPT-INCTV-C3   THRU 7622-EXIT.            
      *                                                                         
       2615-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON OPT_INCTV_C4  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2620-PROCESS-OPT-INCTV-C4.                                       
      *                                                                         
           MOVE '2620'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-51      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7632-FETCH-OPT-INCTV-C4   THRU 7632-EXIT.            
      *                                                                         
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00141*****************************************************************         
P00141**  ERROR REPORT BASED ON OPT_INCTV_C5  CURSOR                 **         
P00141*****************************************************************         
P00141*                                                                         
P00141 2625-PROCESS-OPT-INCTV-C5.                                       
P00141*                                                                         
P00141     MOVE '2625'                   TO WS-ACTIVE-PARAGRAPH.        
P00141*                                                                         
P00141     INITIALIZE                       WS-DETAIL-LINE.             
P00141*                                                                         
P00141     PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
P00141*                                                                         
P00141     MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
P00141     MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
P00141     MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
P00141     MOVE WS-ERROR-MESSAGE-53      TO D-ERROR-MESSAGE.            
P00141     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
P00141*                                                                         
P00141     MOVE 'RT_ATTR_INCTV_TYPE'     TO D-COLUMN-NAME.              
P00141     MOVE HQ-RT-ATTR-INCTV-TYPE    TO D-COLUMN-VALUE.             
P00141     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
P00141*                                                                         
P00141     MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
P00141     MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
P00141     PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
P00141*                                                                         
P00141     PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
P00141*                                                                         
P00141     PERFORM 7635-FETCH-OPT-INCTV-C5   THRU 7635-EXIT.            
P00141*                                                                         
P00141 2625-EXIT.                                                       
P00141     EXIT.                                                        
P00141*                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FIX_PRICE_C1  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2650-PROCESS-FIX-PRICE-C1.                                       
      *                                                                         
           MOVE '2650'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-31      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7652-FETCH-FIX-PRICE-C1   THRU 7652-EXIT.            
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FIX_PRICE_C2  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2655-PROCESS-FIX-PRICE-C2.                                       
      *                                                                         
           MOVE '2655'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-32      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7662-FETCH-FIX-PRICE-C2   THRU 7662-EXIT.            
      *                                                                         
       2655-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FIX_PRICE_C3  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2660-PROCESS-FIX-PRICE-C3.                                       
      *                                                                         
           MOVE '2660'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-33      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7672-FETCH-FIX-PRICE-C3   THRU 7672-EXIT.            
      *                                                                         
       2660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FIX_PRICE_C4  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2665-PROCESS-FIX-PRICE-C4.                                       
      *                                                                         
           MOVE '2665'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-34      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7682-FETCH-FIX-PRICE-C4   THRU 7682-EXIT.            
      *                                                                         
       2665-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MONTHLY_CR_C1 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2705-PROCESS-MONTHLY-CR-C1.                                      
      *                                                                         
           MOVE '2705'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-35      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7702-FETCH-MONTHLY-CR-C1  THRU 7702-EXIT.            
      *                                                                         
       2705-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MONTHLY_CR_C2 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2710-PROCESS-MONTHLY-CR-C2.                                      
      *                                                                         
           MOVE '2710'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-36      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7712-FETCH-MONTHLY-CR-C2  THRU 7712-EXIT.            
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MONTHLY_CR_C3 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2715-PROCESS-MONTHLY-CR-C3.                                      
      *                                                                         
           MOVE '2715'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-37      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7722-FETCH-MONTHLY-CR-C3  THRU 7722-EXIT.            
      *                                                                         
       2715-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON MONTHLY_CR_C4 CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2720-PROCESS-MONTHLY-CR-C4.                                      
      *                                                                         
           MOVE '2720'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-38      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7732-FETCH-MONTHLY-CR-C4  THRU 7732-EXIT.            
      *                                                                         
       2720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FREE_CSC_C1   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2750-PROCESS-FREE-CSC-C1.                                        
      *                                                                         
           MOVE '2750'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-39      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7752-FETCH-FREE-CSC-C1    THRU 7752-EXIT.            
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FREE_CSC_C2   CURSOR                 **         
      *****************************************************************         
      *                                                                         
      *2755-PROCESS-FREE-CSC-C2.                                                
      *                                                                         
      *    MOVE '2755'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    INITIALIZE                       WS-DETAIL-LINE.                     
      *                                                                         
      *    PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.                     
      *                                                                         
      *    MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.                       
      *    MOVE 'OPTION_CD'              TO D-COLUMN-NAME.                      
      *    MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.                     
      *    MOVE WS-ERROR-MESSAGE-40      TO D-ERROR-MESSAGE.                    
      *    PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.                    
      *                                                                         
      *    MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.                      
      *    MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.                     
      *    PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.                    
      *                                                                         
      *    PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.                    
      *                                                                         
      *    PERFORM 7762-FETCH-FREE-CSC-C2    THRU 7762-EXIT.                    
      *                                                                         
      *2755-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FREE_CSC_C3   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2760-PROCESS-FREE-CSC-C3.                                        
      *                                                                         
           MOVE '2760'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-41      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7772-FETCH-FREE-CSC-C3    THRU 7772-EXIT.            
      *                                                                         
       2760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON FREE_CSC_C4   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2765-PROCESS-FREE-CSC-C4.                                        
      *                                                                         
           MOVE '2765'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-42      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7782-FETCH-FREE-CSC-C4    THRU 7782-EXIT.            
      *                                                                         
       2765-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SIGNUP_CR_C1  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2805-PROCESS-SIGNUP-CR-C1.                                       
      *                                                                         
           MOVE '2805'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-43      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'APPL_PROGRAM_ID'        TO D-COLUMN-NAME.              
           MOVE HQ-APPL-PROGRAM-ID       TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7802-FETCH-SIGNUP-CR-C1   THRU 7802-EXIT.            
      *                                                                         
       2805-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SIGNUP_CR_C2  CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2810-PROCESS-SIGNUP-CR-C2.                                       
      *                                                                         
           MOVE '2810'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-44      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7812-FETCH-SIGNUP-CR-C2   THRU 7812-EXIT.            
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON EXIT_FEE_C1   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2850-PROCESS-EXIT-FEE-C1.                                        
      *                                                                         
           MOVE '2850'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-45      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7852-FETCH-EXIT-FEE-C1    THRU 7852-EXIT.            
      *                                                                         
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON EXIT_FEE_C2   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2855-PROCESS-EXIT-FEE-C2.                                        
      *                                                                         
           MOVE '2855'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-46      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7862-FETCH-EXIT-FEE-C2    THRU 7862-EXIT.            
      *                                                                         
       2855-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON EXIT_FEE_C3   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2860-PROCESS-EXIT-FEE-C3.                                        
      *                                                                         
           MOVE '2860'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-47      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7872-FETCH-EXIT-FEE-C3    THRU 7872-EXIT.            
      *                                                                         
       2860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON EXIT_FEE_C4   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2865-PROCESS-EXIT-FEE-C4.                                        
      *                                                                         
           MOVE '2865'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-48      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           MOVE 'FACTOR_ID'              TO D-COLUMN-NAME.              
           MOVE HQ-FACTOR-ID             TO D-COLUMN-VALUE.             
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7882-FETCH-EXIT-FEE-C4    THRU 7882-EXIT.            
      *                                                                         
       2865-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SKYMILES_C1   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2905-PROCESS-SKYMILES-C1.                                        
      *                                                                         
           MOVE '2905'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-49      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7902-FETCH-SKYMILES-C1    THRU 7902-EXIT.            
      *                                                                         
       2905-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  ERROR REPORT BASED ON SKYMILES_C2   CURSOR                 **         
      *****************************************************************         
      *                                                                         
       2910-PROCESS-SKYMILES-C2.                                        
      *                                                                         
           MOVE '2910'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                       WS-DETAIL-LINE.             
      *                                                                         
           PERFORM 8400-PRINT-NEXT-PAGE-CHK THRU 8400-EXIT.             
      *                                                                         
           MOVE 'CRM_OPT_ATTR_INCTV'     TO D-TABLE-DESC.               
           MOVE 'OPTION_CD'              TO D-COLUMN-NAME.              
           MOVE HQ-OPTION-CD             TO D-COLUMN-VALUE.             
           MOVE WS-ERROR-MESSAGE-50      TO D-ERROR-MESSAGE.            
           PERFORM 8300-PRINT-DETAIL-LINE    THRU 8300-EXIT.            
      *                                                                         
           PERFORM 8500-PRINT-BLANK-LINE     THRU 8500-EXIT.            
      *                                                                         
           PERFORM 7912-FETCH-SKYMILES-C2    THRU 7912-EXIT.            
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00396***************************************************************** 03832700
P00396* 7010-SELECT-DELINQ-VALUE                                      * 03832900
P00396***************************************************************** 03833000
P00396*                                                                         
P00396 7010-SELECT-DELINQ-VALUE.                                        
P00396*                                                                         
P00396     MOVE '7010'                   TO WS-ACTIVE-PARAGRAPH.        
P00396                                                                  
P00396     EXEC SQL                                                     
P00396        SELECT C8.DELINQ_VALUE                                    
P00396          INTO :C8-DELINQ-VALUE                                   
P00396          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
P00396         WHERE C8.DELINQ_CD    = :C8-DELINQ-CD                    
P00396           AND C8.COMPANY_NO   = :C8-COMPANY-NO                   
P00396                                                      
P00396                                                           
P00396     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD    = :C8-DELINQ-CD                            
MFA-TR*          AND C8.COMPANY_NO   = :C8-COMPANY-NO                           
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00396                                                                  
P00396     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00396                                                                  
P00396     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00396        CONTINUE                                                  
P00396     ELSE                                                         
P00396        MOVE SQLCODE               TO WS-DISP-RC                  
P00396        MOVE '7010-SELECT-DELINQ-VALUE'                           
P00396                                   TO WS-ERR-MSG                  
P00396        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00396     END-IF.                                                      
P00396*                                                                         
P00396 7010-EXIT.                                                       
P00396     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_TIER_C1 CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7011-OPEN-MKT-TIER-C1.                                           
                                                                        
           MOVE '7011'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_TIER_C1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7011-OPEN-MKT-TIER-C1'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_TIER_C1 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7012-FETCH-MKT-TIER-C1.                                          
                                                                        
           MOVE '7012'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_TIER_C1                                        
               INTO  :IG-TIER-CUST-STAT-CD                              
                    ,:IG-TIER-ACCT-TYPE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7012-FETCH-MKT-TIER-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7012-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_TIER_C1 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7013-CLOSE-MKT-TIER-C1.                                          
                                                                        
           MOVE '7013'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_TIER_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7013-CLOSE-MKT-TIER-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7013-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_TIER_C2 CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7021-OPEN-MKT-TIER-C2.                                           
                                                                        
           MOVE '7021'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_TIER_C2                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7021-OPEN-MKT-TIER-C2'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7021-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_TIER_C2 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7022-FETCH-MKT-TIER-C2.                                          
                                                                        
           MOVE '7022'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_TIER_C2                                        
               INTO  :IG-TIER-CUST-STAT-CD                              
                    ,:IG-TIER-ACCT-TYPE-CD                              
                    ,:IG-CUST-ACCT-DEFLT-FL                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7022-FETCH-MKT-TIER-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7022-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_TIER_C2 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7023-CLOSE-MKT-TIER-C2.                                          
                                                                        
           MOVE '7023'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_TIER_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7023-CLOSE-MKT-TIER-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7023-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_TIER_C3 CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7031-OPEN-MKT-TIER-C3.                                           
                                                                        
           MOVE '7031'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_TIER_C3                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7031-OPEN-MKT-TIER-C3'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7031-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_TIER_C3 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7032-FETCH-MKT-TIER-C3.                                          
                                                                        
           MOVE '7032'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_TIER_C3                                        
               INTO  :IG-TIER-CUST-STAT-CD                              
                    ,:IG-TIER-ACCT-TYPE-CD                              
                    ,:IG-MKT-TIER-RANKING                               
                    ,:IG-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7032-FETCH-MKT-TIER-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7032-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_TIER_C3 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7033-CLOSE-MKT-TIER-C3.                                          
                                                                        
           MOVE '7033'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_TIER_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7033-CLOSE-MKT-TIER-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7033-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_TIER_C4 CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7041-OPEN-MKT-TIER-C4.                                           
                                                                        
           MOVE '7041'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_TIER_C4                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7041-OPEN-MKT-TIER-C4'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7041-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_TIER_C4 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7042-FETCH-MKT-TIER-C4.                                          
                                                                        
           MOVE '7042'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_TIER_C4                                        
               INTO  :IG-TIER-CUST-STAT-CD                              
                    ,:IG-TIER-ACCT-TYPE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7042-FETCH-MKT-TIER-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7042-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_TIER_C4 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7043-CLOSE-MKT-TIER-C4.                                          
                                                                        
           MOVE '7043'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_TIER_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7043-CLOSE-MKT-TIER-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7043-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_TIER_C5 CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7051-OPEN-MKT-TIER-C5.                                           
                                                                        
           MOVE '7051'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_TIER_C5                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7051-OPEN-MKT-TIER-C5'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7051-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_TIER_C5 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7052-FETCH-MKT-TIER-C5.                                          
                                                                        
           MOVE '7052'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_TIER_C5                                        
               INTO  :IG-TIER-CUST-STAT-CD                              
                    ,:IG-TIER-ACCT-TYPE-CD                              
                    ,:IG-MKT-TIER-RANKING                               
                    ,:IG-MKT-TIER-START-DT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7052-FETCH-MKT-TIER-C5'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7052-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_TIER_C5 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7053-CLOSE-MKT-TIER-C5.                                          
                                                                        
           MOVE '7053'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_TIER_C5                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7053-CLOSE-MKT-TIER-C5'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7053-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OFF_MKT_TIER_C1 CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7061-OPEN-OFF-MKT-TIER-C1.                                       
                                                                        
           MOVE '7061'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OFF_MKT_TIER_C1                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7061-OPEN-OFF-MKT-TIER-C1'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7061-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OFF_MKT_TIER_C1 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7062-FETCH-OFF-MKT-TIER-C1.                                      
                                                                        
           MOVE '7062'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OFF_MKT_TIER_C1                                    
               INTO  :DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-MKT-TIER-RANKING                               
                    ,:DU-MKT-TIER-START-DT                              
                    ,:DU-TIER-DEFLT-OFFR-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7062-FETCH-OFF-MKT-TIER-C1'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7062-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OFF_MKT_TIER_C1 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7063-CLOSE-OFF-MKT-TIER-C1.                                      
                                                                        
           MOVE '7063'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OFF_MKT_TIER_C1                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7063-CLOSE-OFF-MKT-TIER-C1'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7063-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OFF_MKT_TIER_C2 CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7071-OPEN-OFF-MKT-TIER-C2.                                       
                                                                        
           MOVE '7071'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OFF_MKT_TIER_C2                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7071-OPEN-OFF-MKT-TIER-C2'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7071-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OFF_MKT_TIER_C2 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7072-FETCH-OFF-MKT-TIER-C2.                                      
                                                                        
           MOVE '7072'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OFF_MKT_TIER_C2                                    
               INTO  :DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-MKT-TIER-RANKING                               
                    ,:DU-MKT-TIER-START-DT                              
                    ,:DU-OFFER-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7072-FETCH-OFF-MKT-TIER-C2'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7072-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OFF_MKT_TIER_C2 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7073-CLOSE-OFF-MKT-TIER-C2.                                      
                                                                        
           MOVE '7073'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OFF_MKT_TIER_C2                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7073-CLOSE-OFF-MKT-TIER-C2'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7073-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OFF_MKT_TIER_C3 CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7081-OPEN-OFF-MKT-TIER-C3.                                       
                                                                        
           MOVE '7081'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OFF_MKT_TIER_C3                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7081-OPEN-OFF-MKT-TIER-C3'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7081-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OFF_MKT_TIER_C3 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7082-FETCH-OFF-MKT-TIER-C3.                                      
                                                                        
           MOVE '7082'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OFF_MKT_TIER_C3                                    
               INTO  :DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-MKT-TIER-RANKING                               
                    ,:DU-MKT-TIER-START-DT                              
                    ,:DU-OFFER-CD                                       
                    ,:DU-OFFER-TIER-STRT-DT                             
                    ,:DU-MKT-TIER-APPLY-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7082-FETCH-OFF-MKT-TIER-C3'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7082-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OFF_MKT_TIER_C3 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7083-CLOSE-OFF-MKT-TIER-C3.                                      
                                                                        
           MOVE '7083'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OFF_MKT_TIER_C3                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7083-CLOSE-OFF-MKT-TIER-C3'                         
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7083-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00494******************************************************************        
A00494**  OPEN OFF_MKT_TIER_C4 CURSOR                                 **        
A00494******************************************************************        
A00494*                                                                         
A00494 7091-OPEN-OFF-MKT-TIER-C4.                                       
A00494                                                                  
A00494     MOVE '7091'                   TO WS-ACTIVE-PARAGRAPH.        
A00494                                                                  
A00494     EXEC SQL                                                     
A00494        OPEN OFF_MKT_TIER_C4                                      
A00494     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00494                                                                  
A00494     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A00494                                                                  
A00494     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00494        CONTINUE                                                  
A00494     ELSE                                                         
A00494        MOVE SQLCODE               TO WS-DISP-RC                  
A00494        MOVE '7091-OPEN-OFF-MKT-TIER-C4'                          
A00494                                   TO WS-ERR-MSG                  
A00494        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A00494     END-IF.                                                      
A00494*                                                                         
A00494 7091-EXIT.                                                       
A00494     EXIT.                                                        
A00494*                                                                         
A00494******************************************************************        
A00494**  FETCH OFF_MKT_TIER_C4 CURSOR                                **        
A00494******************************************************************        
A00494*                                                                         
A00494 7092-FETCH-OFF-MKT-TIER-C4.                                      
A00494                                                                  
A00494     MOVE '7092'                   TO WS-ACTIVE-PARAGRAPH.        
A00494                                                                  
A00494     EXEC SQL                                                     
A00494        FETCH  OFF_MKT_TIER_C4                                    
A00494         INTO  :DU-TIER-CUST-STAT-CD                              
A00494              ,:DU-TIER-ACCT-TYPE-CD                              
A00494              ,:DU-MKT-TIER-RANKING                               
A00494              ,:DU-MKT-TIER-START-DT                              
A00494     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00494                                                                  
A00494     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A00494                                                                  
A00494     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00494        CONTINUE                                                  
A00494     ELSE                                                         
A00494        MOVE SQLCODE               TO WS-DISP-RC                  
A00494        MOVE '7092-FETCH-OFF-MKT-TIER-C4'                         
A00494                                   TO WS-ERR-MSG                  
A00494        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A00494     END-IF.                                                      
A00494*                                                                         
A00494 7092-EXIT.                                                       
A00494     EXIT.                                                        
A00494*                                                                         
A00494******************************************************************        
A00494**  CLOSE OFF_MKT_TIER_C4 CURSOR                                **        
A00494******************************************************************        
A00494*                                                                         
A00494 7093-CLOSE-OFF-MKT-TIER-C4.                                      
A00494                                                                  
A00494     MOVE '7093'                   TO WS-ACTIVE-PARAGRAPH.        
A00494                                                                  
A00494     EXEC SQL                                                     
A00494        CLOSE OFF_MKT_TIER_C4                                     
A00494     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00494                                                                  
A00494     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A00494                                                                  
A00494     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00494        CONTINUE                                                  
A00494     ELSE                                                         
A00494        MOVE SQLCODE               TO WS-DISP-RC                  
A00494        MOVE '7093-CLOSE-OFF-MKT-TIER-C4'                         
A00494                                   TO WS-ERR-MSG                  
A00494        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A00494     END-IF.                                                      
A00494*                                                                         
A00494 7093-EXIT.                                                       
A00494     EXIT.                                                        
A00494*                                                                         
      ******************************************************************        
      **  OPEN SPCL_FCTR_C1 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7101-OPEN-SPCL-FCTR-C1.                                          
                                                                        
           MOVE '7101'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SPCL_FCTR_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7101-OPEN-SPCL-FCTR-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SPCL_FCTR_C1 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7102-FETCH-SPCL-FCTR-C1.                                         
                                                                        
           MOVE '7102'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SPCL_FCTR_C1                                       
               INTO  :SF-FACTOR-ID                                      
                    ,:SF-BILL-PRT-MSG-PL-CD                             
                    ,:SF-OVR-RT-CALC-TYP-CD                             
                    ,:SF-OVR-RT-VER-PRO-FL                              
                    ,:SF-DURATION-START-CD                              
                    ,:SF-DURATION-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7102-FETCH-SPCL-FCTR-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SPCL_FCTR_C1 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7103-CLOSE-SPCL-FCTR-C1.                                         
                                                                        
           MOVE '7103'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SPCL_FCTR_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7103-CLOSE-SPCL-FCTR-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7103-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SPCL_FCTR_C2 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7111-OPEN-SPCL-FCTR-C2.                                          
                                                                        
           MOVE '7111'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SPCL_FCTR_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7111-OPEN-SPCL-FCTR-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7111-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SPCL_FCTR_C2 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7112-FETCH-SPCL-FCTR-C2.                                         
                                                                        
           MOVE '7112'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SPCL_FCTR_C2                                       
               INTO  :SF-FACTOR-ID                                      
                    ,:SA-CODE-UTIL-TYPE                                 
                    ,:SA-RATE-PLAN-NO                                   
                    ,:SA-DATE-FROM                                      
                    ,:SA-ENTRY-NO                                       
                    ,:SA-DATE-TO                                        
                    ,:SA-CMPNT-ID-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7112-FETCH-SPCL-FCTR-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7112-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SPCL_FCTR_C2 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7113-CLOSE-SPCL-FCTR-C2.                                         
                                                                        
           MOVE '7113'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SPCL_FCTR_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7113-CLOSE-SPCL-FCTR-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7113-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SPCL_FCTR_C3 CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7121-OPEN-SPCL-FCTR-C3.                                          
                                                                        
           MOVE '7121'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SPCL_FCTR_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7121-OPEN-SPCL-FCTR-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7121-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SPCL_FCTR_C3 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7122-FETCH-SPCL-FCTR-C3.                                         
                                                                        
           MOVE '7122'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SPCL_FCTR_C3                                       
               INTO  :SA-CODE-UTIL-TYPE                                 
                    ,:SA-RATE-PLAN-NO                                   
                    ,:SA-FACTOR-ID                                      
                    ,:SA-DATE-FROM                                      
                    ,:SA-ENTRY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7122-FETCH-SPCL-FCTR-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7122-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SPCL_FCTR_C3 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7123-CLOSE-SPCL-FCTR-C3.                                         
                                                                        
           MOVE '7123'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SPCL_FCTR_C3                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7123-CLOSE-SPCL-FCTR-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7123-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04319******************************************************************        
A04319**  OPEN SPCL_FCTR_C4 CURSOR                                    **        
A04319******************************************************************        
A04319*                                                                         
A04319 7131-OPEN-SPCL-FCTR-C4.                                          
A04319                                                                  
A04319     MOVE '7131'                       TO WS-ACTIVE-PARAGRAPH.    
A04319                                                                  
A04319     EXEC SQL                                                     
A04319        OPEN SPCL_FCTR_C4                                         
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        MOVE SQLCODE                   TO WS-DISP-RC              
A04319        MOVE '7131-OPEN-SPCL-FCTR-C4'  TO WS-ERR-MSG              
A04319        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04319     END-IF.                                                      
A04319*                                                                         
A04319 7131-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
A04319******************************************************************        
A04319**  FETCH SPCL_FCTR_C4 CURSOR                                   **        
A04319******************************************************************        
A04319*                                                                         
A04319 7132-FETCH-SPCL-FCTR-C4.                                         
A04319                                                                  
A04319     MOVE '7132'                       TO WS-ACTIVE-PARAGRAPH.    
A04319                                                                  
A04319     EXEC SQL                                                     
A04319        FETCH  SPCL_FCTR_C4                                       
A04319         INTO  :SA-CODE-UTIL-TYPE                                 
A04319              ,:SA-RATE-PLAN-NO                                   
A04319              ,:SA-FACTOR-ID                                      
A04319              ,:SA-CMPNT-ID-CD                                    
A04319              ,:SA-BLOCK-NO                                       
A04319              ,:SA-CODE-SEASON                                    
A04319              ,:SA-CODE-TIME-PERIOD                               
A04319              ,:SA-INSTR-USE-TYPE-CD                              
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        MOVE SQLCODE                   TO WS-DISP-RC              
A04319        MOVE '7132-FETCH-SPCL-FCTR-C4' TO WS-ERR-MSG              
A04319        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04319     END-IF.                                                      
A04319*                                                                         
A04319 7132-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
A04319******************************************************************        
A04319**  CLOSE SPCL_FCTR_C4 CURSOR                                   **        
A04319******************************************************************        
A04319*                                                                         
A04319 7133-CLOSE-SPCL-FCTR-C4.                                         
A04319                                                                  
A04319     MOVE '7133'                       TO WS-ACTIVE-PARAGRAPH.    
A04319                                                                  
A04319     EXEC SQL                                                     
A04319        CLOSE SPCL_FCTR_C4                                        
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        MOVE SQLCODE                   TO WS-DISP-RC              
A04319        MOVE '7133-CLOSE-SPCL-FCTR-C4' TO WS-ERR-MSG              
A04319        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04319     END-IF.                                                      
A04319*                                                                         
A04319 7133-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
A04221******************************************************************        
A04221**  OPEN SPCL_FCTR_C5 CURSOR                                    **        
A04221******************************************************************        
A04221*                                                                         
A04221 7141-OPEN-SPCL-FCTR-C5.                                          
A04221                                                                  
A04221     MOVE '7141'                       TO WS-ACTIVE-PARAGRAPH.    
A04221                                                                  
A04221     EXEC SQL                                                     
A04221        OPEN SPCL_FCTR_C5                                         
A04221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04221                                                                  
A04221     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04221                                                                  
A04221     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04221        CONTINUE                                                  
A04221     ELSE                                                         
A04221        MOVE SQLCODE                   TO WS-DISP-RC              
A04221        MOVE '7141-OPEN-SPCL-FCTR-C5'  TO WS-ERR-MSG              
A04221        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04221     END-IF.                                                      
A04221*                                                                         
A04221 7141-EXIT.                                                       
A04221     EXIT.                                                        
A04221*                                                                         
A04221******************************************************************        
A04221**  FETCH SPCL_FCTR_C5 CURSOR                                   **        
A04221******************************************************************        
A04221*                                                                         
A04221 7142-FETCH-SPCL-FCTR-C5.                                         
A04221                                                                  
A04221     MOVE '7142'                       TO WS-ACTIVE-PARAGRAPH.    
A04221                                                                  
A04221     EXEC SQL                                                     
A04221        FETCH  SPCL_FCTR_C5                                       
A04221         INTO  :SA-RATE-PLAN-NO                                   
A04221              ,:SA-FACTOR-ID                                      
A04221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04221                                                                  
A04221     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04221                                                                  
A04221     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04221        CONTINUE                                                  
A04221     ELSE                                                         
A04221        MOVE SQLCODE                   TO WS-DISP-RC              
A04221        MOVE '7142-FETCH-SPCL-FCTR-C5' TO WS-ERR-MSG              
A04221        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04221     END-IF.                                                      
A04221*                                                                         
A04221 7142-EXIT.                                                       
A04221     EXIT.                                                        
A04221*                                                                         
A04221******************************************************************        
A04221**  CLOSE SPCL_FCTR_C5 CURSOR                                   **        
A04221******************************************************************        
A04221*                                                                         
A04221 7143-CLOSE-SPCL-FCTR-C5.                                         
A04221                                                                  
A04221     MOVE '7143'                       TO WS-ACTIVE-PARAGRAPH.    
A04221                                                                  
A04221     EXEC SQL                                                     
A04221        CLOSE SPCL_FCTR_C5                                        
A04221     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04221                                                                  
A04221     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04221                                                                  
A04221     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04221        CONTINUE                                                  
A04221     ELSE                                                         
A04221        MOVE SQLCODE                   TO WS-DISP-RC              
A04221        MOVE '7143-CLOSE-SPCL-FCTR-C5' TO WS-ERR-MSG              
A04221        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
A04221     END-IF.                                                      
A04221*                                                                         
A04221 7143-EXIT.                                                       
A04221     EXIT.                                                        
A04221*                                                                         
      ******************************************************************        
      **  OPEN MKT_PROMOTION_C1 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7201-OPEN-MKT-PROMO-C1.                                          
                                                                        
           MOVE '7201'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_PROMOTION_C1                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7201-OPEN-MKT-PROMO-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_PROMOTION_C1 CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7202-FETCH-MKT-PROMO-C1.                                         
                                                                        
           MOVE '7202'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_PROMOTION_C1                                   
               INTO  :KM-REPLACMNT-PROMO-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7202-FETCH-MKT-PROMO-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_PROMOTION_C1 CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7203-CLOSE-MKT-PROMO-C1.                                         
                                                                        
           MOVE '7203'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_PROMOTION_C1                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7203-CLOSE-MKT-PROMO-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7203-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MKT_PROMOTION_C2 CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7211-OPEN-MKT-PROMO-C2.                                          
                                                                        
           MOVE '7211'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MKT_PROMOTION_C2                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7211-OPEN-MKT-PROMO-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7211-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MKT_PROMOTION_C2 CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7212-FETCH-MKT-PROMO-C2.                                         
                                                                        
           MOVE '7212'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MKT_PROMOTION_C2                                   
               INTO  :KM-PROMO-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7212-FETCH-MKT-PROMO-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7212-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MKT_PROMOTION_C2 CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7213-CLOSE-MKT-PROMO-C2.                                         
                                                                        
           MOVE '7213'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MKT_PROMOTION_C2                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7213-CLOSE-MKT-PROMO-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7213-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RATE_GROUP_C1 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7301-OPEN-RATE-GROUP-C1.                                         
                                                                        
           MOVE '7301'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RATE_GROUP_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7301-OPEN-RATE-GROUP-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7301-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RATE_GROUP_C1 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7302-FETCH-RATE-GROUP-C1.                                        
                                                                        
           MOVE '7302'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RATE_GROUP_C1                                      
               INTO  :F7-RATE-GROUP-TYPE-CD                             
                    ,:F7-RATE-GROUP-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7302-FETCH-RATE-GROUP-C1'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7302-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RATE_GROUP_C1 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7303-CLOSE-RATE-GROUP-C1.                                        
                                                                        
           MOVE '7303'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_GROUP_C1                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7303-CLOSE-RATE-GROUP-C1'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7303-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RATE_GROUP_C2 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7311-OPEN-RATE-GROUP-C2.                                         
                                                                        
           MOVE '7311'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RATE_GROUP_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7311-OPEN-RATE-GROUP-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7311-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RATE_GROUP_C2 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7312-FETCH-RATE-GROUP-C2.                                        
                                                                        
           MOVE '7312'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RATE_GROUP_C2                                      
               INTO  :G5-RATE-GROUP-TYPE-CD                             
                    ,:G5-RATE-GROUP-CD                                  
                    ,:G5-EFF-START-DT                                   
                    ,:G5-OFFER-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7312-FETCH-RATE-GROUP-C2'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7312-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RATE_GROUP_C2 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7313-CLOSE-RATE-GROUP-C2.                                        
                                                                        
           MOVE '7313'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_GROUP_C2                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7313-CLOSE-RATE-GROUP-C2'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7313-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RATE_GROUP_C3 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
      *7321-OPEN-RATE-GROUP-C3.                                                 
      *                                                                         
      *    MOVE '7321'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       OPEN RATE_GROUP_C3                                        01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7321-OPEN-RATE-GROUP-C3'                                    
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7321-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  FETCH RATE_GROUP_C3 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7322-FETCH-RATE-GROUP-C3.                                                
      *                                                                         
      *    MOVE '7322'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       FETCH  RATE_GROUP_C3                                      01740001
      *        INTO  :G5-RATE-GROUP-TYPE-CD                             01750001
      *             ,:G5-RATE-GROUP-CD                                          
      *             ,:G5-EFF-START-DT                                           
      *             ,:G5-EFF-END-DT                                             
      *             ,:G5-OFFER-CD                                               
      *    END-EXEC.                                                    01760001
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND          
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7322-FETCH-RATE-GROUP-C3'                                   
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7322-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  CLOSE RATE_GROUP_C3 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7323-CLOSE-RATE-GROUP-C3.                                                
      *                                                                         
      *    MOVE '7323'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       CLOSE RATE_GROUP_C3                                       01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7323-CLOSE-RATE-GROUP-C3'                                   
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7323-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OPT_C2  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7411-OPEN-RTPKG-OPT-C2.                                          
                                                                        
           MOVE '7411'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OPT_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7411-OPEN-RTPKG-OPT-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7411-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OPT_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7412-FETCH-RTPKG-OPT-C2.                                         
                                                                        
           MOVE '7412'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OPT_C2                                       
               INTO  :FI-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7412-FETCH-RTPKG-OPT-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7412-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OPT_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7413-CLOSE-RTPKG-OPT-C2.                                         
                                                                        
           MOVE '7413'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OPT_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7413-CLOSE-RTPKG-OPT-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7413-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OPT_C3  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7421-OPEN-RTPKG-OPT-C3.                                          
                                                                        
           MOVE '7421'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OPT_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7421-OPEN-RTPKG-OPT-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7421-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OPT_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7422-FETCH-RTPKG-OPT-C3.                                         
                                                                        
           MOVE '7422'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OPT_C3                                       
               INTO  :FI-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7422-FETCH-RTPKG-OPT-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7422-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OPT_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7423-CLOSE-RTPKG-OPT-C3.                                         
                                                                        
           MOVE '7423'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OPT_C3                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7423-CLOSE-RTPKG-OPT-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7423-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OPT_C4  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7431-OPEN-RTPKG-OPT-C4.                                          
                                                                        
           MOVE '7431'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OPT_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7431-OPEN-RTPKG-OPT-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7431-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OPT_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7432-FETCH-RTPKG-OPT-C4.                                         
                                                                        
           MOVE '7432'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OPT_C4                                       
               INTO  :FI-OPTION-CD                                      
                    ,:FI-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7432-FETCH-RTPKG-OPT-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7432-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OPT_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7433-CLOSE-RTPKG-OPT-C4.                                         
                                                                        
           MOVE '7433'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OPT_C4                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7433-CLOSE-RTPKG-OPT-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7433-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00396******************************************************************        
P00396**  OPEN RTPKG_OPT_C5  CURSOR                                   **        
P00396******************************************************************        
P00396*                                                                         
P00396 7441-OPEN-RTPKG-OPT-C5.                                          
P00396                                                                  
P00396     MOVE '7441'                   TO WS-ACTIVE-PARAGRAPH.        
P00396                                                                  
P00396     EXEC SQL                                                     
P00396        OPEN RTPKG_OPT_C5                                         
P00396     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00396                                                                  
P00396     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00396                                                                  
P00396     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00396        CONTINUE                                                  
P00396     ELSE                                                         
P00396        MOVE SQLCODE               TO WS-DISP-RC                  
P00396        MOVE '7441-OPEN-RTPKG-OPT-C5'                             
P00396                                   TO WS-ERR-MSG                  
P00396        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00396     END-IF.                                                      
P00396*                                                                         
P00396 7441-EXIT.                                                       
P00396     EXIT.                                                        
P00396*                                                                         
P00396******************************************************************        
P00396**  FETCH RTPKG_OPT_C5  CURSOR                                  **        
P00396******************************************************************        
P00396*                                                                         
P00396 7442-FETCH-RTPKG-OPT-C5.                                         
P00396                                                                  
P00396     MOVE '7442'                   TO WS-ACTIVE-PARAGRAPH.        
P00396                                                                  
P00396     EXEC SQL                                                     
P00396        FETCH  RTPKG_OPT_C5                                       
P00396         INTO  :FI-OPTION-CD                                      
P00396     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00396                                                                  
P00396     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00396                                                                  
P00396     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00396        CONTINUE                                                  
P00396     ELSE                                                         
P00396        MOVE SQLCODE               TO WS-DISP-RC                  
P00396        MOVE '7442-FETCH-RTPKG-OPT-C5'                            
P00396                                   TO WS-ERR-MSG                  
P00396        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00396     END-IF.                                                      
P00396*                                                                         
P00396 7442-EXIT.                                                       
P00396     EXIT.                                                        
P00396*                                                                         
P00396******************************************************************        
P00396**  CLOSE RTPKG_OPT_C5  CURSOR                                  **        
P00396******************************************************************        
P00396*                                                                         
P00396 7443-CLOSE-RTPKG-OPT-C5.                                         
P00396                                                                  
P00396     MOVE '7443'                   TO WS-ACTIVE-PARAGRAPH.        
P00396                                                                  
P00396     EXEC SQL                                                     
P00396        CLOSE RTPKG_OPT_C5                                        
P00396     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00396                                                                  
P00396     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00396                                                                  
P00396     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00396        CONTINUE                                                  
P00396     ELSE                                                         
P00396        MOVE SQLCODE               TO WS-DISP-RC                  
P00396        MOVE '7443-CLOSE-RTPKG-OPT-C5'                            
P00396                                   TO WS-ERR-MSG                  
P00396        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00396     END-IF.                                                      
P00396*                                                                         
P00396 7443-EXIT.                                                       
P00396     EXIT.                                                        
      *                                                                         
P00485 7461-OPEN-RTPKG-OPT-C7.                                          
P00485                                                                  
P00485     MOVE '7461'                   TO WS-ACTIVE-PARAGRAPH.        
P00485                                                                  
P00485     EXEC SQL                                                     
P00485        OPEN RTPKG_OPT_C7                                         
P00485     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00485                                                                  
P00485     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00485                                                                  
P00485     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00485        CONTINUE                                                  
P00485     ELSE                                                         
P00485        MOVE SQLCODE               TO WS-DISP-RC                  
P00485        MOVE '7461-OPEN-RTPKG-OPT-C7'                             
P00485                                   TO WS-ERR-MSG                  
P00485        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00485     END-IF.                                                      
P00485*                                                                         
P00485 7461-EXIT.                                                       
P00485     EXIT.                                                        
P00485*                                                                         
P00485******************************************************************        
P00485**  FETCH RTPKG_OPT_C7  CURSOR                                  **        
P00485******************************************************************        
P00485*                                                                         
P00485 7462-FETCH-RTPKG-OPT-C7.                                         
P00485                                                                  
P00485     MOVE '7462'                   TO WS-ACTIVE-PARAGRAPH.        
P00485                                                                  
P00485     EXEC SQL                                                     
P00485        FETCH  RTPKG_OPT_C7                                       
P00485         INTO  :FI-OPTION-CD                                      
P00485              ,:FI-CURR-EXT-DESC-LONG                             
P00485     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00485                                                                  
P00485     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00485                                                                  
P00485     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00485        CONTINUE                                                  
P00485     ELSE                                                         
P00485        MOVE SQLCODE               TO WS-DISP-RC                  
P00485        MOVE '7462-FETCH-RTPKG-OPT-C7'                            
P00485                                   TO WS-ERR-MSG                  
P00485        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00485     END-IF.                                                      
P00485*                                                                         
P00485 7462-EXIT.                                                       
P00485     EXIT.                                                        
P00485*                                                                         
P00485******************************************************************        
P00485**  CLOSE RTPKG_OPT_C7  CURSOR                                  **        
P00485******************************************************************        
P00485*                                                                         
P00485 7463-CLOSE-RTPKG-OPT-C7.                                         
P00485                                                                  
P00485     MOVE '7463'                   TO WS-ACTIVE-PARAGRAPH.        
P00485                                                                  
P00485     EXEC SQL                                                     
P00485        CLOSE RTPKG_OPT_C7                                        
P00485     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00485                                                                  
P00485     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00485                                                                  
P00485     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00485        CONTINUE                                                  
P00485     ELSE                                                         
P00485        MOVE SQLCODE               TO WS-DISP-RC                  
P00485        MOVE '7463-CLOSE-RTPKG-OPT-C7'                            
P00485                                   TO WS-ERR-MSG                  
P00485        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00485     END-IF.                                                      
P00485*                                                                         
P00485 7463-EXIT.                                                       
P00485     EXIT.                                                        
      ******************************************************************        
      **  OPEN RTPKG_OFF_C1  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7501-OPEN-RTPKG-OFFER-C1.                                        
                                                                        
           MOVE '7501'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7501-OPEN-RTPKG-OFFER-C1'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7501-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7502-FETCH-RTPKG-OFFER-C1.                                       
                                                                        
           MOVE '7502'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C1                                       
               INTO  :FG-OFFER-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7502-FETCH-RTPKG-OFFER-C1'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7502-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7503-CLOSE-RTPKG-OFFER-C1.                                       
                                                                        
           MOVE '7503'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7503-CLOSE-RTPKG-OFFER-C1'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7503-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OFF_C2  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7511-OPEN-RTPKG-OFFER-C2.                                        
                                                                        
           MOVE '7511'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7511-OPEN-RTPKG-OFFER-C2'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7511-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7512-FETCH-RTPKG-OFFER-C2.                                       
                                                                        
           MOVE '7512'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C2                                       
               INTO  :FG-OFFER-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7512-FETCH-RTPKG-OFFER-C2'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7512-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7513-CLOSE-RTPKG-OFFER-C2.                                       
                                                                        
           MOVE '7513'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7513-CLOSE-RTPKG-OFFER-C2'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7513-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OFF_C3  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
      *7521-OPEN-RTPKG-OFFER-C3.                                                
      *                                                                         
      *    MOVE '7521'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       OPEN RTPKG_OFF_C3                                         01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7521-OPEN-RTPKG-OFFER-C3'                                   
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7521-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7522-FETCH-RTPKG-OFFER-C3.                                               
      *                                                                         
      *    MOVE '7522'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       FETCH  RTPKG_OFF_C3                                       01740001
      *        INTO  :FG-OFFER-CD                                       01750001
      *    END-EXEC.                                                    01760001
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND          
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7522-FETCH-RTPKG-OFFER-C3'                                  
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7522-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7523-CLOSE-RTPKG-OFFER-C3.                                               
      *                                                                         
      *    MOVE '7523'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       CLOSE RTPKG_OFF_C3                                        01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7523-CLOSE-RTPKG-OFFER-C3'                                  
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7523-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OFF_C4  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7531-OPEN-RTPKG-OFFER-C4.                                        
                                                                        
           MOVE '7531'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7531-OPEN-RTPKG-OFFER-C4'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7531-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7532-FETCH-RTPKG-OFFER-C4.                                       
                                                                        
           MOVE '7532'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C4                                       
               INTO  :FG-OFFER-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7532-FETCH-RTPKG-OFFER-C4'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7532-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7533-CLOSE-RTPKG-OFFER-C4.                                       
                                                                        
           MOVE '7533'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C4                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7533-CLOSE-RTPKG-OFFER-C4'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7533-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OFF_C5  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7541-OPEN-RTPKG-OFFER-C5.                                        
                                                                        
           MOVE '7541'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C5                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7541-OPEN-RTPKG-OFFER-C5'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7541-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C5  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7542-FETCH-RTPKG-OFFER-C5.                                       
                                                                        
           MOVE '7542'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C5                                       
               INTO  :FG-RENEWAL-OFFER-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7542-FETCH-RTPKG-OFFER-C5'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7542-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C5  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7543-CLOSE-RTPKG-OFFER-C5.                                       
                                                                        
           MOVE '7543'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C5                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7543-CLOSE-RTPKG-OFFER-C5'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7543-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **  OPEN RTPKG_OFF_C7  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7561-OPEN-RTPKG-OFFER-C7.                                        
                                                                        
           MOVE '7561'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C7                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7561-OPEN-RTPKG-OFFER-C7'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7561-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C7  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7562-FETCH-RTPKG-OFFER-C7.                                       
                                                                        
           MOVE '7562'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C7                                       
               INTO  :FG-RENEWAL-OFFER-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7562-FETCH-RTPKG-OFFER-C7'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7562-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C7  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7563-CLOSE-RTPKG-OFFER-C7.                                       
                                                                        
           MOVE '7563'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C7                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7563-CLOSE-RTPKG-OFFER-C7'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7563-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN RTPKG_OFF_C8  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7571-OPEN-RTPKG-OFFER-C8.                                        
                                                                        
           MOVE '7571'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_OFF_C8                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7571-OPEN-RTPKG-OFFER-C8'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7571-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH RTPKG_OFF_C8  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7572-FETCH-RTPKG-OFFER-C8.                                       
                                                                        
           MOVE '7572'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_OFF_C8                                       
               INTO  :FG-OFFER-CD                                       
                    ,:FG-RENEWAL-OFFER-CD                               
                    ,:DU-TIER-ACCT-TYPE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7572-FETCH-RTPKG-OFFER-C8'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7572-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE RTPKG_OFF_C8  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7573-CLOSE-RTPKG-OFFER-C8.                                       
                                                                        
           MOVE '7573'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_OFF_C8                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7573-CLOSE-RTPKG-OFFER-C8'                          
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7573-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OPT_INCTV_C1  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7601-OPEN-OPT-INCTV-C1.                                          
                                                                        
           MOVE '7601'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OPT_INCTV_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7601-OPEN-OPT-INCTV-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7601-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OPT_INCTV_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7602-FETCH-OPT-INCTV-C1.                                         
                                                                        
           MOVE '7602'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OPT_INCTV_C1                                       
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7602-FETCH-OPT-INCTV-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7602-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OPT_INCTV_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7603-CLOSE-OPT-INCTV-C1.                                         
                                                                        
           MOVE '7603'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OPT_INCTV_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7603-CLOSE-OPT-INCTV-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7603-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OPT_INCTV_C2  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7615-OPEN-OPT-INCTV-C2.                                          
                                                                        
           MOVE '7615'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OPT_INCTV_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7615-OPEN-OPT-INCTV-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7615-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OPT_INCTV_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7616-FETCH-OPT-INCTV-C2.                                         
                                                                        
           MOVE '7616'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OPT_INCTV_C2                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
                    ,:HQ-RT-ATTR-INCTV-TYPE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7616-FETCH-OPT-INCTV-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7616-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OPT_INCTV_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7617-CLOSE-OPT-INCTV-C2.                                         
                                                                        
           MOVE '7617'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OPT_INCTV_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7617-CLOSE-OPT-INCTV-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7617-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OPT_INCTV_C3  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7621-OPEN-OPT-INCTV-C3.                                          
                                                                        
           MOVE '7621'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OPT_INCTV_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7621-OPEN-OPT-INCTV-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7621-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OPT_INCTV_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7622-FETCH-OPT-INCTV-C3.                                         
                                                                        
           MOVE '7622'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OPT_INCTV_C3                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7622-FETCH-OPT-INCTV-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7622-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OPT_INCTV_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7623-CLOSE-OPT-INCTV-C3.                                         
                                                                        
           MOVE '7623'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OPT_INCTV_C3                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7623-CLOSE-OPT-INCTV-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7623-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN OPT_INCTV_C4  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7631-OPEN-OPT-INCTV-C4.                                          
                                                                        
           MOVE '7631'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OPT_INCTV_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7631-OPEN-OPT-INCTV-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7631-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH OPT_INCTV_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7632-FETCH-OPT-INCTV-C4.                                         
                                                                        
           MOVE '7632'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  OPT_INCTV_C4                                       
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7632-FETCH-OPT-INCTV-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7632-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE OPT_INCTV_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7633-CLOSE-OPT-INCTV-C4.                                         
                                                                        
           MOVE '7633'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OPT_INCTV_C4                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7633-CLOSE-OPT-INCTV-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7633-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00141******************************************************************        
P00141**  OPEN OPT_INCTV_C5  CURSOR                                   **        
P00141******************************************************************        
P00141*                                                                         
P00141 7634-OPEN-OPT-INCTV-C5.                                          
P00141                                                                  
P00141     MOVE '7634'                   TO WS-ACTIVE-PARAGRAPH.        
P00141                                                                  
P00141     EXEC SQL                                                     
P00141        OPEN OPT_INCTV_C5                                         
P00141     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00141                                                                  
P00141     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00141                                                                  
P00141     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00141        CONTINUE                                                  
P00141     ELSE                                                         
P00141        MOVE SQLCODE               TO WS-DISP-RC                  
P00141        MOVE '7634-OPEN-OPT-INCTV-C5'                             
P00141                                   TO WS-ERR-MSG                  
P00141        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00141     END-IF.                                                      
P00141*                                                                         
P00141 7634-EXIT.                                                       
P00141     EXIT.                                                        
P00141*                                                                         
P00141******************************************************************        
P00141**  FETCH OPT_INCTV_C5  CURSOR                                  **        
P00141******************************************************************        
P00141*                                                                         
P00141 7635-FETCH-OPT-INCTV-C5.                                         
P00141                                                                  
P00141     MOVE '7635'                   TO WS-ACTIVE-PARAGRAPH.        
P00141                                                                  
P00141     EXEC SQL                                                     
P00141        FETCH  OPT_INCTV_C5                                       
P00141         INTO  :HQ-OPTION-CD                                      
P00141              ,:HQ-RT-ATTR-INCTV-TYPE                             
P00141              ,:HQ-FACTOR-ID                                      
P00141     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00141                                                                  
P00141     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00141                                                                  
P00141     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00141        CONTINUE                                                  
P00141     ELSE                                                         
P00141        MOVE SQLCODE               TO WS-DISP-RC                  
P00141        MOVE '7635-FETCH-OPT-INCTV-C5'                            
P00141                                   TO WS-ERR-MSG                  
P00141        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00141     END-IF.                                                      
P00141*                                                                         
P00141 7635-EXIT.                                                       
P00141     EXIT.                                                        
P00141*                                                                         
P00141******************************************************************        
P00141**  CLOSE OPT_INCTV_C5  CURSOR                                  **        
P00141******************************************************************        
P00141*                                                                         
P00141 7636-CLOSE-OPT-INCTV-C5.                                         
P00141                                                                  
P00141     MOVE '7636'                   TO WS-ACTIVE-PARAGRAPH.        
P00141                                                                  
P00141     EXEC SQL                                                     
P00141        CLOSE OPT_INCTV_C5                                        
P00141     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00141                                                                  
P00141     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00141                                                                  
P00141     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00141        CONTINUE                                                  
P00141     ELSE                                                         
P00141        MOVE SQLCODE               TO WS-DISP-RC                  
P00141        MOVE '7636-CLOSE-OPT-INCTV-C5'                            
P00141                                   TO WS-ERR-MSG                  
P00141        PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
P00141     END-IF.                                                      
P00141*                                                                         
P00141 7636-EXIT.                                                       
P00141     EXIT.                                                        
P00141*                                                                         
      ******************************************************************        
      **  OPEN FIX_PRICE_C1  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7651-OPEN-FIX-PRICE-C1.                                          
                                                                        
           MOVE '7651'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIX_PRICE_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7651-OPEN-FIX-PRICE-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7651-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FIX_PRICE_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7652-FETCH-FIX-PRICE-C1.                                         
                                                                        
           MOVE '7652'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FIX_PRICE_C1                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7652-FETCH-FIX-PRICE-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7652-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FIX_PRICE_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7653-CLOSE-FIX-PRICE-C1.                                         
                                                                        
           MOVE '7653'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FIX_PRICE_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7653-CLOSE-FIX-PRICE-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7653-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FIX_PRICE_C2  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7661-OPEN-FIX-PRICE-C2.                                          
                                                                        
           MOVE '7661'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIX_PRICE_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7661-OPEN-FIX-PRICE-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7661-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FIX_PRICE_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7662-FETCH-FIX-PRICE-C2.                                         
                                                                        
           MOVE '7662'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FIX_PRICE_C2                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7662-FETCH-FIX-PRICE-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7662-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FIX_PRICE_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7663-CLOSE-FIX-PRICE-C2.                                         
                                                                        
           MOVE '7663'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FIX_PRICE_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7663-CLOSE-FIX-PRICE-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7663-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FIX_PRICE_C3  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7671-OPEN-FIX-PRICE-C3.                                          
                                                                        
           MOVE '7671'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIX_PRICE_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7671-OPEN-FIX-PRICE-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7671-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FIX_PRICE_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7672-FETCH-FIX-PRICE-C3.                                         
                                                                        
           MOVE '7672'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FIX_PRICE_C3                                       
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7672-FETCH-FIX-PRICE-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7672-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FIX_PRICE_C3  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7673-CLOSE-FIX-PRICE-C3.                                         
                                                                        
           MOVE '7673'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FIX_PRICE_C3                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7673-CLOSE-FIX-PRICE-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7673-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FIX_PRICE_C4  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7681-OPEN-FIX-PRICE-C4.                                          
                                                                        
           MOVE '7681'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIX_PRICE_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7681-OPEN-FIX-PRICE-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7681-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FIX_PRICE_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7682-FETCH-FIX-PRICE-C4.                                         
                                                                        
           MOVE '7682'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FIX_PRICE_C4                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7682-FETCH-FIX-PRICE-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7682-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FIX_PRICE_C4  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7683-CLOSE-FIX-PRICE-C4.                                         
                                                                        
           MOVE '7683'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FIX_PRICE_C4                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7683-CLOSE-FIX-PRICE-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7683-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MONTHLY_CR_C1 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7701-OPEN-MONTHLY-CR-C1.                                         
                                                                        
           MOVE '7701'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MONTHLY_CR_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7701-OPEN-MONTHLY-CR-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7701-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MONTHLY_CR_C1 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7702-FETCH-MONTHLY-CR-C1.                                        
                                                                        
           MOVE '7702'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MONTHLY_CR_C1                                      
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7702-FETCH-MONTHLY-CR-C1'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7702-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MONTHLY_CR_C1 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7703-CLOSE-MONTHLY-CR-C1.                                        
                                                                        
           MOVE '7703'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MONTHLY_CR_C1                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7703-CLOSE-MONTHLY-CR-C1'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7703-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MONTHLY_CR_C2 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7711-OPEN-MONTHLY-CR-C2.                                         
                                                                        
           MOVE '7711'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MONTHLY_CR_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7711-OPEN-MONTHLY-CR-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7711-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MONTHLY_CR_C2 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7712-FETCH-MONTHLY-CR-C2.                                        
                                                                        
           MOVE '7712'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MONTHLY_CR_C2                                      
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7712-FETCH-MONTHLY-CR-C2'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7712-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MONTHLY_CR_C2 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7713-CLOSE-MONTHLY-CR-C2.                                        
                                                                        
           MOVE '7713'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MONTHLY_CR_C2                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7713-CLOSE-MONTHLY-CR-C2'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7713-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MONTHLY_CR_C3 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7721-OPEN-MONTHLY-CR-C3.                                         
                                                                        
           MOVE '7721'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MONTHLY_CR_C3                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7721-OPEN-MONTHLY-CR-C3'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7721-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MONTHLY_CR_C3 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7722-FETCH-MONTHLY-CR-C3.                                        
                                                                        
           MOVE '7722'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MONTHLY_CR_C3                                      
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7722-FETCH-MONTHLY-CR-C3'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7722-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MONTHLY_CR_C3 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7723-CLOSE-MONTHLY-CR-C3.                                        
                                                                        
           MOVE '7723'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MONTHLY_CR_C3                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7723-CLOSE-MONTHLY-CR-C3'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7723-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MONTHLY_CR_C4 CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7731-OPEN-MONTHLY-CR-C4.                                         
                                                                        
           MOVE '7731'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN MONTHLY_CR_C4                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7731-OPEN-MONTHLY-CR-C4'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7731-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MONTHLY_CR_C4 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7732-FETCH-MONTHLY-CR-C4.                                        
                                                                        
           MOVE '7732'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  MONTHLY_CR_C4                                      
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7732-FETCH-MONTHLY-CR-C4'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7732-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MONTHLY_CR_C4 CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7733-CLOSE-MONTHLY-CR-C4.                                        
                                                                        
           MOVE '7733'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE MONTHLY_CR_C4                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7733-CLOSE-MONTHLY-CR-C4'                           
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7733-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FREE_CSC_C1   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7751-OPEN-FREE-CSC-C1.                                           
                                                                        
           MOVE '7751'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FREE_CSC_C1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7751-OPEN-FREE-CSC-C1'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7751-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FREE_CSC_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7752-FETCH-FREE-CSC-C1.                                          
                                                                        
           MOVE '7752'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FREE_CSC_C1                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7752-FETCH-FREE-CSC-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7752-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FREE_CSC_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7753-CLOSE-FREE-CSC-C1.                                          
                                                                        
           MOVE '7753'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FREE_CSC_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7753-CLOSE-FREE-CSC-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7753-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FREE_CSC_C2   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
      *7761-OPEN-FREE-CSC-C2.                                                   
      *                                                                         
      *    MOVE '7761'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       OPEN FREE_CSC_C2                                          01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7761-OPEN-FREE-CSC-C2'                                      
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7761-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  FETCH FREE_CSC_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7762-FETCH-FREE-CSC-C2.                                                  
      *                                                                         
      *    MOVE '7762'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       FETCH  FREE_CSC_C2                                        01740001
      *        INTO  :HQ-OPTION-CD                                      01750001
      *             ,:HQ-FACTOR-ID                                      01750001
      *    END-EXEC.                                                    01760001
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND          
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7762-FETCH-FREE-CSC-C2'                                     
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7762-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  CLOSE FREE_CSC_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
      *7763-CLOSE-FREE-CSC-C2.                                                  
      *                                                                         
      *    MOVE '7763'                   TO WS-ACTIVE-PARAGRAPH.                
      *                                                                         
      *    EXEC SQL                                                             
      *       CLOSE FREE_CSC_C2                                         01720001
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SQLCODE               TO WS-DISP-RC                          
      *       MOVE '7763-CLOSE-FREE-CSC-C2'                                     
      *                                  TO WS-ERR-MSG                          
      *       PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                         
      *    END-IF.                                                              
      *                                                                         
      *7763-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      **  OPEN FREE_CSC_C3   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7771-OPEN-FREE-CSC-C3.                                           
                                                                        
           MOVE '7771'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FREE_CSC_C3                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7771-OPEN-FREE-CSC-C3'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7771-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FREE_CSC_C3   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7772-FETCH-FREE-CSC-C3.                                          
                                                                        
           MOVE '7772'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FREE_CSC_C3                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7772-FETCH-FREE-CSC-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7772-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FREE_CSC_C3   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7773-CLOSE-FREE-CSC-C3.                                          
                                                                        
           MOVE '7773'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FREE_CSC_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7773-CLOSE-FREE-CSC-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7773-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN FREE_CSC_C4   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7781-OPEN-FREE-CSC-C4.                                           
                                                                        
           MOVE '7781'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FREE_CSC_C4                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7781-OPEN-FREE-CSC-C4'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7781-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH FREE_CSC_C4   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7782-FETCH-FREE-CSC-C4.                                          
                                                                        
           MOVE '7782'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  FREE_CSC_C4                                        
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7782-FETCH-FREE-CSC-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7782-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE FREE_CSC_C4   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7783-CLOSE-FREE-CSC-C4.                                          
                                                                        
           MOVE '7783'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE FREE_CSC_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7783-CLOSE-FREE-CSC-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7783-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SIGNUP_CR_C1  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7801-OPEN-SIGNUP-CR-C1.                                          
                                                                        
           MOVE '7801'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SIGNUP_CR_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7801-OPEN-SIGNUP-CR-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7801-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SIGNUP_CR_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7802-FETCH-SIGNUP-CR-C1.                                         
                                                                        
           MOVE '7802'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SIGNUP_CR_C1                                       
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-APPL-PROGRAM-ID                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7802-FETCH-SIGNUP-CR-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7802-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SIGNUP_CR_C1  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7803-CLOSE-SIGNUP-CR-C1.                                         
                                                                        
           MOVE '7803'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SIGNUP_CR_C1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7803-CLOSE-SIGNUP-CR-C1'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7803-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SIGNUP_CR_C2  CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7811-OPEN-SIGNUP-CR-C2.                                          
                                                                        
           MOVE '7811'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SIGNUP_CR_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7811-OPEN-SIGNUP-CR-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7811-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SIGNUP_CR_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7812-FETCH-SIGNUP-CR-C2.                                         
                                                                        
           MOVE '7812'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SIGNUP_CR_C2                                       
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7812-FETCH-SIGNUP-CR-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7812-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SIGNUP_CR_C2  CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7813-CLOSE-SIGNUP-CR-C2.                                         
                                                                        
           MOVE '7813'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SIGNUP_CR_C2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7813-CLOSE-SIGNUP-CR-C2'                            
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7813-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN EXIT_FEE_C1   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7851-OPEN-EXIT-FEE-C1.                                           
                                                                        
           MOVE '7851'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN EXIT_FEE_C1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7851-OPEN-EXIT-FEE-C1'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7851-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH EXIT_FEE_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7852-FETCH-EXIT-FEE-C1.                                          
                                                                        
           MOVE '7852'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  EXIT_FEE_C1                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7852-FETCH-EXIT-FEE-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7852-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE EXIT_FEE_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7853-CLOSE-EXIT-FEE-C1.                                          
                                                                        
           MOVE '7853'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE EXIT_FEE_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7853-CLOSE-EXIT-FEE-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7853-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN EXIT_FEE_C2   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7861-OPEN-EXIT-FEE-C2.                                           
                                                                        
           MOVE '7861'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN EXIT_FEE_C2                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7861-OPEN-EXIT-FEE-C2'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7861-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH EXIT_FEE_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7862-FETCH-EXIT-FEE-C2.                                          
                                                                        
           MOVE '7862'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  EXIT_FEE_C2                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7862-FETCH-EXIT-FEE-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7862-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE EXIT_FEE_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7863-CLOSE-EXIT-FEE-C2.                                          
                                                                        
           MOVE '7863'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE EXIT_FEE_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7863-CLOSE-EXIT-FEE-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7863-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN EXIT_FEE_C3   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7871-OPEN-EXIT-FEE-C3.                                           
                                                                        
           MOVE '7871'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN EXIT_FEE_C3                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7871-OPEN-EXIT-FEE-C3'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7871-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH EXIT_FEE_C3   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7872-FETCH-EXIT-FEE-C3.                                          
                                                                        
           MOVE '7872'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  EXIT_FEE_C3                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7872-FETCH-EXIT-FEE-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7872-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE EXIT_FEE_C3   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7873-CLOSE-EXIT-FEE-C3.                                          
                                                                        
           MOVE '7873'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE EXIT_FEE_C3                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7873-CLOSE-EXIT-FEE-C3'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7873-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN EXIT_FEE_C4   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7881-OPEN-EXIT-FEE-C4.                                           
                                                                        
           MOVE '7881'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN EXIT_FEE_C4                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7881-OPEN-EXIT-FEE-C4'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7881-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH EXIT_FEE_C4   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7882-FETCH-EXIT-FEE-C4.                                          
                                                                        
           MOVE '7882'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  EXIT_FEE_C4                                        
               INTO  :HQ-OPTION-CD                                      
                    ,:HQ-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7882-FETCH-EXIT-FEE-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7882-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE EXIT_FEE_C4   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7883-CLOSE-EXIT-FEE-C4.                                          
                                                                        
           MOVE '7883'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE EXIT_FEE_C4                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7883-CLOSE-EXIT-FEE-C4'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7883-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SKYMILES_C1   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7901-OPEN-SKYMILES-C1.                                           
                                                                        
           MOVE '7901'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SKYMILES_C1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7901-OPEN-SKYMILES-C1'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7901-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SKYMILES_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7902-FETCH-SKYMILES-C1.                                          
                                                                        
           MOVE '7902'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SKYMILES_C1                                        
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7902-FETCH-SKYMILES-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7902-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SKYMILES_C1   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7903-CLOSE-SKYMILES-C1.                                          
                                                                        
           MOVE '7903'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SKYMILES_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7903-CLOSE-SKYMILES-C1'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7903-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SKYMILES_C2   CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       7911-OPEN-SKYMILES-C2.                                           
                                                                        
           MOVE '7911'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN SKYMILES_C2                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7911-OPEN-SKYMILES-C2'                              
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7911-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SKYMILES_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7912-FETCH-SKYMILES-C2.                                          
                                                                        
           MOVE '7912'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH  SKYMILES_C2                                        
               INTO  :HQ-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7912-FETCH-SKYMILES-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7912-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SKYMILES_C2   CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       7913-CLOSE-SKYMILES-C2.                                          
                                                                        
           MOVE '7913'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE SKYMILES_C2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO WS-DISP-RC                  
              MOVE '7913-CLOSE-SKYMILES-C2'                             
                                         TO WS-ERR-MSG                  
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
      *                                                                         
       7913-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-INPUT-DATE             TO P-RPT-DATE.                
           ADD  1                         TO WS-RPT-PAGE-NO.            
           MOVE WS-RPT-PAGE-NO            TO P-RPT-PAGE-NO.             
           WRITE PRNTFILE-RECORD  FROM  WS-TITLE-LINE-1.                
           ADD  1                         TO WS-RPT-LINE-NO             
                                             WS-RPT-LINE-COUNT.         
      *                                                                         
           WRITE PRNTFILE-RECORD  FROM  WS-BLANK-LINE.                  
           ADD  1                         TO WS-RPT-LINE-NO             
                                             WS-RPT-LINE-COUNT.         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-HEADERS.                                              
      *                                                                         
           WRITE PRNTFILE-RECORD  FROM  WS-HEADER-LINE-1.               
           ADD  1                         TO WS-RPT-LINE-NO             
                                             WS-RPT-LINE-COUNT.         
      *                                                                         
           WRITE PRNTFILE-RECORD  FROM  WS-BLANK-LINE.                  
           ADD  1                         TO WS-RPT-LINE-NO             
                                             WS-RPT-LINE-COUNT.         
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-DETAIL-LINE.                                          
      *                                                                         
           IF WS-RPT-LINE-NO >= 52                                      
              MOVE ZEROS               TO   WS-RPT-LINE-NO              
              PERFORM 8100-PRINT-TITLE   THRU 8100-EXIT                 
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
                                                                        
           WRITE PRNTFILE-RECORD  FROM  WS-DETAIL-LINE.                 
           ADD  1                      TO   WS-RPT-LINE-NO              
                                            WS-RPT-LINE-COUNT.          
                                                                        
           MOVE SPACES                 TO   WS-DETAIL-LINE.             
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS DATA TO THE NEXT PAGE IF REQUIRED             **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-NEXT-PAGE-CHK.                                        
      *                                                                         
           IF WS-RPT-LINE-NO >= 45                                      
              PERFORM 8500-PRINT-BLANK-LINE THRU 8500-EXIT              
                                      UNTIL WS-RPT-LINE-NO = 52         
              MOVE ZEROS               TO   WS-RPT-LINE-NO              
              PERFORM 8100-PRINT-TITLE   THRU 8100-EXIT                 
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS THE BLANK LINE WHEN REQUIRED                  **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-BLANK-LINE.                                           
      *                                                                         
           IF WS-RPT-LINE-NO >= 52                                      
              MOVE ZEROS               TO   WS-RPT-LINE-NO              
              PERFORM 8100-PRINT-TITLE   THRU 8100-EXIT                 
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           ELSE                                                         
              WRITE PRNTFILE-RECORD  FROM  WS-BLANK-LINE                
              ADD 1                    TO   WS-RPT-LINE-NO              
                                            WS-RPT-LINE-COUNT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** IF THERE ARE NO EXCEPTIONS TO REPORT, "NO DATA THIS RUN"    *          
      ** MESSAGE WILL BE DISPLAYED IN THE REPORT.                    *          
      ****************************************************************          
      *                                                                         
       8600-PRINT-NO-DATA-EXISTS.                                       
      *                                                                         
           WRITE PRNTFILE-RECORD  FROM  WS-NO-DATA-LINE.                
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C37780****************************************************************          
C37780** SPECIAL INSTRUCTIONS ON HOW TO RERUN THE JOB ARE DISPLAYED  *          
C37780** IN THE REPORT.                                              *          
C37780****************************************************************          
C37780*                                                                         
C37780 8700-PRINT-SPCL-MESSAGES.                                        
C37780*                                                                         
C37780     WRITE PRNTFILE-RECORD  FROM  WS-SPCL-MESSAGE-1.              
C37780     WRITE PRNTFILE-RECORD  FROM  WS-SPCL-MESSAGE-2.              
C37780     WRITE PRNTFILE-RECORD  FROM  WS-SPCL-MESSAGE-3.              
C37780*                                                                         
C37780 8700-EXIT.                                                       
C37780     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-RPT-LINE-COUNT >= 5                                    
C37780        PERFORM 8700-PRINT-SPCL-MESSAGES  THRU 8700-EXIT          
              MOVE +5                  TO  RETURN-CODE                  
           ELSE                                                         
              PERFORM 8600-PRINT-NO-DATA-EXISTS THRU 8600-EXIT          
           END-IF.                                                      
                                                                        
           CLOSE PRNTFILE.                                              
           IF P099-SUCCESSFUL                                           
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP099 PROCESSING ERROR       **'   
               DISPLAY '** CLOSE ERROR FOR PCSRP099 - OUTPUT FILE **'   
               DISPLAY '**      FILE STATUS = ' WS-P099-STATUS          
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DISPLAY ERROR DETAILS                                       **        
      ******************************************************************        
      *                                                                         
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY '**   PROCESSING ERROR IN PCSRP099  **'.             
           DISPLAY '**   ', WS-ERR-MSG.                                 
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND             THRU 9900-EXIT.               
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  6251-GET-FJC01-DATE                                         **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  7600-START-FCSJC01                                        **          
      **  7610-READ-FCSJC01                                         **          
      **  7611-CLOSE                                                **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  COPYBOOK FOR ABEND ROUTINE                                  **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
