       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP095.                                      
COB303 DATE-WRITTEN.     JULY 28, 2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  07/28/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT008*--                            SEB095 TO COBOL.                --*        
A05268*--  08/13/2015    VK7L032     CHANGES DONE TO REPORT THE DRAFT--*        
      *--                            CUSTOMERS ONLY WITH BILL BALANCE--*        
      *--                            GREATER THAN $700.              --*        
A05268*--  08/18/2015    VK7L032     CHANGED THE OUTPUT TO CSV FORMAT--*        
      *--                            FROM REPORT FORMAT.             --*        
A05268*--  08/25/2015    VK7L032     REPORT SHOULD NOT BE SENT IN AN --*        
      *--                            EMAIL WHEN NO DATA FOUND.       --*        
A05268*--  09/01/2015    VK7L032     MODIFIED THE QUERY IN 7300 PARA --*        
      *--                            TO GET THE NAME IN DOUBLE QUOTES--*        
      *--                            FOR THE CSV FORMAT.             --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE59.                                                            
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDBE59.                                                            
       COPY FIOBE59.                                                            
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP095'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_AR_CNTL, AC                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK_EFT, BE                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK, D1                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUSTOMER_BANK, JF                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP095'.     
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-DRAFT-CYCLE            PIC X(02) VALUE SPACES.         
           05 WS-BANK-NAME              PIC X(35) VALUE SPACES.         
           05 WS-ACCOUNT-NAME           PIC X(35) VALUE SPACES.         
           05 WS-EPP-ACCT               PIC X(01) VALUE SPACES.         
           05 WS-RESIDENT-ACCT          PIC X(01) VALUE SPACES.         
           05 WS-HDR-EXIST              PIC X(01) VALUE 'Y'.            
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1 REDEFINES WS-SAVE-ACCT.                  
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
           05 WS-ACCT                   PIC X(13) VALUE SPACES.         
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FBE59-STATUS          PIC X(02) VALUE '00'.           
               88 FBE59-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
      ***************** PCSRP095 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER               PIC X(10) VALUE 'ACCOUNT NO'.   
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(03) VALUE 'CYC'.          
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(04) VALUE 'DATE'.         
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(03) VALUE 'AMT'.          
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(04) VALUE 'BANK'.         
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(12) VALUE 'ACCOUNT NAME'. 
               10  FILLER               PIC X(01) VALUE ','.            
               10  FILLER               PIC X(04) VALUE 'TYPE'.         
      *                                                                         
       01  WS-DTL-REC.                                                  
           05 RPT-ACCOUNT-NO            PIC X(16) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-DRAFT-CYCLE           PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-DRAFT-DATE            PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-DRAFT-AMT             PIC Z(09).9(2).                 
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-BANK-NAME             PIC X(35) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-ACCOUNT-NAME          PIC X(35) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 RPT-TRANSACTION-CD        PIC Z(04).                      
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT FCSBE59-FILE.                                     
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7400-READ-FCSBE59                THRU 7400-EXIT.     
           PERFORM 2000-PROCESS-DTLS                THRU 2000-EXIT      
             UNTIL END-OF-REC.                                          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS                                            **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           IF E-FBE59-INS-DEL-FLAG   EQUAL 'I'         AND              
A05268       (E-FBE59-DRAFT-AMT      GREATER THAN 700  OR               
            ((E-FBE59-TRANSACTION-CD EQUAL 27          OR               
              E-FBE59-TRANSACTION-CD EQUAL 37 )        AND              
              E-FBE59-DRAFT-AMT = 0)                   OR               
             (E-FBE59-TRANSACTION-CD EQUAL 28          AND              
              E-FBE59-DRAFT-AMT > 0))                                   
              MOVE E-FBE59-ACCOUNT-NO     TO AT-ACCOUNT-NO              
                                             AC-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
              MOVE E-FBE59-BANK-SEQ-NO    TO JF-CUST-BANK-SEQ-NO        
              MOVE WS-NO                  TO WS-RESIDENT-ACCT           
              MOVE WS-NO                  TO WS-EPP-ACCT                
              PERFORM 7100-CHECK-RESIDENT           THRU 7100-EXIT      
              PERFORM 7200-CHECK-EPP                THRU 7200-EXIT      
              IF WS-RESIDENT-ACCT EQUAL WS-YES AND                      
                 WS-EPP-ACCT      EQUAL WS-NO                           
                 PERFORM 7300-SELECT-PARA           THRU 7300-EXIT      
                 PERFORM 2100-WRITE-HDR             THRU 2100-EXIT      
                 PERFORM 2200-WRITE-DTL             THRU 2200-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-READ-FCSBE59                THRU 7400-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-WRITE-HDR.                                                *        
      ******************************************************************        
      *                                                                         
       2100-WRITE-HDR.                                                  
      *                                                                         
           IF WS-HDR-EXIST  EQUAL WS-YES                                
              MOVE WS-RPT-HEADER-1           TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33                 THRU 8000-EXIT   
              MOVE WS-NO                     TO WS-HDR-EXIST            
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-WRITE-DTL.                                                *        
      ******************************************************************        
      *                                                                         
       2200-WRITE-DTL.                                                  
      *                                                                         
      ***********FORMAT ACCOUNT NUMBER                                          
           MOVE AT-ACCOUNT-NO             TO WS-SAVE-ACCT.              
           MOVE WS-SAVE-ACCT1             TO WS-ACCT1.                  
           MOVE WS-SAVE-ACCT2             TO WS-ACCT2.                  
           MOVE WS-SAVE-ACCT3             TO WS-ACCT3.                  
           MOVE WS-SAVE-ACCT4             TO WS-ACCT4.                  
           MOVE WS-ACCOUNT1               TO RPT-ACCOUNT-NO.            
      *                                                                         
           MOVE WS-DRAFT-CYCLE            TO RPT-DRAFT-CYCLE.           
           MOVE E-FBE59-DRAFT-DATE        TO RPT-DRAFT-DATE.            
           MOVE E-FBE59-DRAFT-AMT         TO RPT-DRAFT-AMT.             
           MOVE WS-BANK-NAME              TO RPT-BANK-NAME.             
           MOVE WS-ACCOUNT-NAME           TO RPT-ACCOUNT-NAME.          
           MOVE E-FBE59-TRANSACTION-CD    TO RPT-TRANSACTION-CD.        
           MOVE WS-DTL-REC                TO PRT33-RECORD.              
           PERFORM 8000-WRITE-PRT33                 THRU 8000-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-CHECK-RESIDENT.                                        **        
      ******************************************************************        
      *                                                                         
       7100-CHECK-RESIDENT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-RESIDENT-ACCT                                  
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND ACCOUNT_TYPE_CODE = 'R'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RESIDENT-ACCT                                          
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND ACCOUNT_TYPE_CODE = 'R'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP095 ABORT *****'                   
              DISPLAY '**  7100-CHECK-RESIDENT    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-CHECK-EPP.                                             **        
      ******************************************************************        
      *                                                                         
       7200-CHECK-EPP.                                                  
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-EPP-ACCT                                      
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 50                            
                  AND ITEM_ID           = 0                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-EPP-ACCT                                              
MFA-TR*          FROM CSS_AR_CNTL AC                                            
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = 50                                    
MFA-TR*           AND ITEM_ID           = 0                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP095 ABORT *****'                   
              DISPLAY '**  7200-CHECK-EPP         **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AC-ACCOUNT-NO = ' AC-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-SELECT-PARA.                                              *        
      ******************************************************************        
      *                                                                         
       7300-SELECT-PARA.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT BE.DRAFT_CYCLE,                                    
                    ('"' + (CIS.SUBSTR3(D1.BANK_NAME,1,30)) + '"' ),       
                    ('"' + (CIS.SUBSTR3(BE.BANK_ACCOUNT_NAME,1,33)) + 
           '"') 
                INTO :WS-DRAFT-CYCLE                                    
                    ,:WS-BANK-NAME                                      
                    ,:WS-ACCOUNT-NAME                                   
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED),                     
                     CSS_BANK D1 WITH(READUNCOMMITTED),                         
                     CSS_CUSTOMER_BANK JF WITH(READUNCOMMITTED)                 
               WHERE BE.ACCOUNT_NO       = :BE-ACCOUNT-NO               
                 AND JF.CUSTOMER_NO      = BE.CUSTOMER_NO               
                 AND JF.BANK_ID          = D1.BANK_ID                   
                 AND JF.CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BE.DRAFT_CYCLE,                                            
MFA-TR*             ('"' || (SUBSTR(D1.BANK_NAME,1,30)) || '"' ),               
MFA-TR*             ('"' || (SUBSTR(BE.BANK_ACCOUNT_NAME,1,33)) || '"')         
MFA-TR*         INTO :WS-DRAFT-CYCLE                                            
MFA-TR*             ,:WS-BANK-NAME                                              
MFA-TR*             ,:WS-ACCOUNT-NAME                                           
MFA-TR*         FROM CSS_BANK_EFT BE,                                           
MFA-TR*              CSS_BANK D1,                                               
MFA-TR*              CSS_CUSTOMER_BANK JF                                       
MFA-TR*        WHERE BE.ACCOUNT_NO       = :BE-ACCOUNT-NO                       
MFA-TR*          AND JF.CUSTOMER_NO      = BE.CUSTOMER_NO                       
MFA-TR*          AND JF.BANK_ID          = D1.BANK_ID                           
MFA-TR*          AND JF.CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP095 ABORT *****'                   
              DISPLAY '**  7300-CHECK-EPP         **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  BE-ACCOUNT-NO = ' BE-ACCOUNT-NO              
              DISPLAY '**  JF-CUST-BANK-SEQ-NO = ' JF-CUST-BANK-SEQ-NO  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSBE59 FILE FOR INPUT                                   *        
      ******************************************************************        
       7400-READ-FCSBE59.                                               
      *                                                                         
           READ FCSBE59-FILE                                            
                                                                        
           IF FBE59-SUCCESSFUL  OR  END-OF-REC                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP095 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSBE59 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FBE59-STATUS             
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBE59-FILE.                                          
                                                                        
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
