       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP094.                                      
COB303 DATE-WRITTEN.     AUGUST 13, 2015.                               
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  08/13/2015    RS7M249     CONVERTED THE EAZYTRIVE PGM     --*        
ACT017*--                            CSR094 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSCA135-FILE                                         
              ASSIGN UT-S-FCSCA135                                      
              FILE STATUS IS WS-FCSCA135-STATUS.                        
                                                                        
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDCA135.                                                           
       COPY FIOCA135.                                                           
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP094'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_AR_CNTL, AC                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK_EFT, BE                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BANK, D1                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUSTOMER_BANK, JF                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_DELINQUENCY, C8                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-FCA331-STATUS          PIC X(02) VALUE SPACES.         
           05 WS-LINE-COUNT1            PIC 9(02)  VALUE ZEROES.        
           05 WS-LINE-COUNT2            PIC 9(02)  VALUE ZEROES.        
           05 WS-PAGE-NUM1              PIC 9(02)  VALUE ZEROES.        
           05 WS-PAGE-NUM2              PIC 9(02)  VALUE ZEROES.        
           05 WS-COMPANY-NO             PIC X(02)  VALUE SPACES.        
           05 WS-PREV-COMP-NO           PIC X(02)  VALUE SPACES.        
           05 WS-COMPANY-NAME           PIC X(26)  VALUE SPACES.        
           05 WS-SECURED-ACCOUNT        PIC X(24)  VALUE SPACES.        
           05 WS-ACCOUNT-NO             PIC 9(13).                      
           05 WS-ACCOUNT-TYPE-CODE      PIC X(01)  VALUE SPACES.        
           05 WS-CODE-UTIL-TYPE         PIC X(01)  VALUE SPACES.        
           05 WS-RATE-PLAN-NO           PIC X(03)  VALUE SPACES.        
           05 WS-BILL-NO                PIC Z(3)9.                      
           05 WS-BILL-CYCLE             PIC X(02)  VALUE SPACES.        
           05 WS-AMT-BILL-ITEM          PIC 9(9)V9(2) VALUE 0.          
           05 WS-PREV-BILL-AMT          PIC 9(9)V9(2) VALUE 0.          
           05 WS-VAR                    PIC S9(9)V9(2) VALUE 0.         
           05 WS-VAR-PER                PIC S9(3).                      
           05 WS-TOTAL-AR-BAL           PIC 9(9)V9(2) VALUE 0.          
           05 WS-EBILL-REG-IND          PIC X(01)  VALUE SPACES.        
           05 WS-DRAFT-IND              PIC X(01)  VALUE SPACES.        
           05 WS-HIGH-BILL-CODE         PIC X(01)  VALUE SPACES.        
           05 WS-SECURED-RATE           PIC X(01)  VALUE SPACES.        
           05 WS-REGULATED-FLAG         PIC X(01)  VALUE SPACES.        
           05 WS-REGULATED-ACCOUNT      PIC X(20)  VALUE ' '.           
           05 WS-COMMON-DATE.                                           
              10 WS-COMMON-CC           PIC 9(02)  VALUE 0.             
              10 WS-COMMON-YY           PIC 9(02)  VALUE 0.             
              10 FILLER                 PIC X(01)  VALUE '-'.           
              10 WS-COMMON-MM           PIC 9(02)  VALUE 0.             
              10 FILLER                 PIC X(01)  VALUE '-'.           
              10 WS-COMMON-DD           PIC 9(02)  VALUE 0.             
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP094'.     
           05 WS-RPT-CSRPG1             PIC X(09) VALUE 'CSR094-01'.    
           05 WS-RPT-CSRPG2             PIC X(09) VALUE 'CSR094-02'.    
           05 WS-RPT1-COMPANY           PIC X(02) VALUE SPACES.         
           05 WS-RPT2-COMPANY           PIC X(02) VALUE SPACES.         
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-COMP-NO-DIFF           PIC X(01) VALUE 'N'.            
           05 WS-REPORT-1               PIC X(01) VALUE 'N'.            
           05 WS-REPORT-2               PIC X(01) VALUE 'N'.            
           05 WS-SECURED                PIC X(01) VALUE 'N'.            
           05 WS-NON-SECURED            PIC X(01) VALUE 'N'.            
           05 WS-REG                    PIC X(01) VALUE 'N'.            
           05 WS-DE-REG                 PIC X(01) VALUE 'N'.            
      *                                                                         
           05 WS-ACCT                   PIC X(13) VALUE SPACES.         
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
           05 WS-RECORD-COUNT           PIC 9(9)  VALUE ZEROES.         
      *                                                                         
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1 REDEFINES WS-SAVE-ACCT.                  
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE1.                                            
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SR-TRLR-DATA-REQ-N       PIC X(01) VALUE 'N'.            
               88 SR-TRLR-DATA-REQ                VALUE 'Y'.            
           05  NS-TRLR-DATA-REQ-N       PIC X(01) VALUE 'N'.            
               88 NS-TRLR-DATA-REQ                VALUE 'Y'.            
           05  WS-FCSCA135-STATUS      PIC X(02)  VALUE '00'.           
               88 FCSCA135-SUCCESSFUL             VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
      ***************** PCSRP094 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINE1.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(14)                       
                                VALUE 'PROGRAM NAME: '.                 
               10  P-RPT-TITLE-PGM      PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(22) VALUE SPACES.         
               10  WS-RPT-TITLE-1       PIC X(22) VALUE SPACES.         
               10  FILLER               PIC X(53) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  P-RPT-TITLE-PGNM     PIC Z(03).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(12)                       
                                          VALUE 'COMMON DATE:'.         
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  P-RPT1-DATE          PIC X(10).                      
               10  FILLER               PIC X(21) VALUE SPACES.         
               10  WS-RPT-TITLE-2       PIC X(17)                       
                                          VALUE 'HIGH BILL REPORT'.     
               10  FILLER               PIC X(50) VALUE SPACES.         
               10  FILLER               PIC X(09)                       
                                          VALUE 'RUN DATE:'.            
               10  P-RPT-RUN-DATE       PIC X(10).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER               PIC X(46) VALUE SPACES.         
               10  WS-TITLE-3           PIC X(20) VALUE SPACES.         
               10  FILLER               PIC X(67) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER               PIC X(113) VALUE SPACES.        
               10  FILLER               PIC X(09)                       
                                          VALUE 'RUN TIME:'.            
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  P-RPT-RUN-TIME       PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-5.                                         
               10  FILLER               PIC X(133) VALUE SPACES.        
      *                                                                         
           05  WS-RPT-HEADER-6.                                         
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(07) VALUE 'ACCOUNT'.      
               10  FILLER               PIC X(07) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'ACT'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'UTL'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'RATE'.         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'BLL'.          
               10  FILLER               PIC X(02) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'BILL'.         
               10  FILLER               PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'CURR'.         
               10  FILLER               PIC X(13) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PREV'.         
               10  FILLER               PIC X(13) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE 'TOTAL'.        
               10  FILLER               PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE 'VARIANCE'.     
               10  FILLER               PIC X(07) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'VAR'.          
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'EBL'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'DRF'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(02) VALUE 'HB'.           
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT-HEADER-7.                                         
               10  FILLER               PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(02) VALUE 'NO'.           
               10  FILLER               PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'TYP'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'TYP'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'PLAN'.         
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'CYC'.          
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(02) VALUE 'NO'.           
               10  FILLER               PIC X(08) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE 'BILL AMT'.     
               10  FILLER               PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE 'BILL AMT'.     
               10  FILLER               PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(06) VALUE 'AR BAL'.       
               10  FILLER               PIC X(14) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'AMT'.          
               10  FILLER               PIC X(09) VALUE SPACES.         
               10  FILLER               PIC X(01) VALUE '%'.            
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'IND'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE 'IND'.          
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  FILLER               PIC X(02) VALUE 'CD'.           
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
       01  WS-DTL-REC.                                                  
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-ACCOUNT-NO            PIC X(16) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-ACCOUNT-TYPE-CODE     PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-BILL-CYCLE            PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-BILL-NO               PIC Z(3)9.                      
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-AMT-BILL-ITEM         PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-PREV-BILL-AMT         PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-TOTAL-AR-BAL          PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT-VARIANCE              PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 RPT-VARIANCE-PER          PIC Z99-.                       
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-EBILL-REG-IND         PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT-DRAFT-IND             PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 RPT-HIGH-BILL-CODE        PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
      *                                                                         
       01  WS-DTL1-REC.                                                 
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT1-ACCOUNT-NO           PIC X(16) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT1-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-RATE-PLAN-NO         PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-BILL-CYCLE           PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-BILL-NO              PIC Z(3)9.                      
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT1-AMT-BILL-ITEM        PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-PREV-BILL-AMT        PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-TOTAL-AR-BAL         PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 RPT1-VARIANCE             PIC ZZZ,ZZZ,ZZZ.99-.            
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 RPT1-VARIANCE-PER         PIC Z99-.                       
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT1-EBILL-REG-IND        PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 RPT1-DRAFT-IND            PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 RPT1-HIGH-BILL-CODE       PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
      *                                                                         
        01 WS-RPT-DISP.                                                 
           05  WS-RPT-TERMDISP1.                                        
               10  FILLER                   PIC X(60) VALUE SPACES.     
               10  FILLER                   PIC X(30) VALUE             
                      '* HIGH BILL CODE DESCRIPTION *'.                 
               10  FILLER                   PIC X(43) VALUE SPACES.     
      *                                                                         
           05  WS-RPT-TERMDISP2.                                        
               10  FILLER                   PIC X(55) VALUE SPACES.     
               10  FILLER                   PIC X(34) VALUE             
                      'A - TOTAL AR BALANCE EXCEEDS LIMIT'.             
               10  FILLER                   PIC X(44) VALUE SPACES.     
      *                                                                         
           05  WS-RPT-TERMDISP3.                                        
               10  FILLER                   PIC X(55) VALUE SPACES.     
               10  FILLER                   PIC X(33) VALUE             
                      'G - GAS BILL AMOUNT EXCEEDS LIMIT'.              
               10  FILLER                   PIC X(45) VALUE SPACES.     
      *                                                                         
           05  WS-RPT-TERMDISP4.                                        
               10  FILLER                   PIC X(55) VALUE SPACES.     
               10  FILLER                   PIC X(38) VALUE             
                      'E - ELECTRIC BILL AMOUNT EXCEEDS LIMIT'.         
               10  FILLER                   PIC X(40) VALUE SPACES.     
      *                                                                         
           05  WS-RPT-TERMDISP5.                                        
               10  FILLER                   PIC X(55) VALUE SPACES.     
               10  FILLER                   PIC X(49) VALUE             
                  'O - OTHER CHARGES DIFFERENCE W.R.TO PREVIOUS BILL'.  
               10  FILLER                   PIC X(29) VALUE SPACES.     
      *                                                                         
           05  WS-RPT-TERMDISP6.                                        
               10  FILLER                   PIC X(60) VALUE SPACES.     
               10  FILLER                   PIC X(21) VALUE             
                         '*** END OF REPORT ***'.                       
               10  FILLER                   PIC X(52) VALUE SPACES.     
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                   PIC X(60) VALUE SPACES.         
           05  FILLER                   PIC X(25) VALUE                 
                     '*** NO ACCOUNTS FOUND ***'.                       
           05  FILLER                   PIC X(48) VALUE SPACES.         
      *                                                                         
       01  WS-SPACES.                                                   
           05  FILLER                   PIC X(133) VALUE SPACES.        
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE            THRU  0100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU  1000-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE             THRU  9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                       TO WS-RT-HH.                
           MOVE WS-MM                       TO WS-RT-MM.                
           MOVE WS-SS                       TO WS-RT-SS.                
           MOVE WS-RUN-TIME                 TO P-RPT-RUN-TIME.          
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                       TO WS-RD-YY.                
           MOVE WS-CM                       TO WS-RD-MM.                
           MOVE WS-CD                       TO WS-RD-DD.                
           MOVE WS-RUN-DATE                 TO P-RPT-RUN-DATE           
                                               P-RPT1-DATE.             
      *                                                                         
           OPEN INPUT  FCSCA135-FILE.                                   
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7400-READ-FCSCA135         THRU 7400-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
             UNTIL END-OF-REC.                                          
      *                                                                         
           PERFORM 2400-NO-DATA-REPORT        THRU 2400-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT                                          **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           COMPUTE  WS-RECORD-COUNT  = WS-RECORD-COUNT + 1.             
           IF WS-RECORD-COUNT = 1                                       
              MOVE FIOCA135-CREATE-DATE     TO  WS-COMMON-DATE          
           ELSE                                                         
              MOVE FIOCA135-COMPANY-NO      TO  C7-COMPANY-NO           
              MOVE FIOCA135-ACCOUNT-NO      TO  WS-SAVE-ACCT            
              MOVE WS-SAVE-ACCT1            TO  WS-ACCT1                
              MOVE WS-SAVE-ACCT2            TO  WS-ACCT2                
              MOVE WS-SAVE-ACCT3            TO  WS-ACCT3                
              MOVE WS-SAVE-ACCT4            TO  WS-ACCT4                
              MOVE FIOCA135-ACCT-TYPE-CODE  TO  WS-ACCOUNT-TYPE-CODE    
              MOVE FIOCA135-CODE-UTIL-TYPE  TO  WS-CODE-UTIL-TYPE       
              MOVE FIOCA135-RATE-PLAN-NO    TO  WS-RATE-PLAN-NO         
              MOVE FIOCA135-BILL-NO         TO  WS-BILL-NO              
              MOVE FIOCA135-BILL-CYCLE      TO  WS-BILL-CYCLE           
              MOVE FIOCA135-AMT-BILL-ITEM   TO  WS-AMT-BILL-ITEM        
              MOVE FIOCA135-PREV-BILL-AMT   TO  WS-PREV-BILL-AMT        
              MOVE FIOCA135-TOTAL-AR-BAL    TO  WS-TOTAL-AR-BAL         
              MOVE FIOCA135-EBILL-REG-IND   TO  WS-EBILL-REG-IND        
              MOVE FIOCA135-DRAFT-IND       TO  WS-DRAFT-IND            
              MOVE FIOCA135-HIGH-BILL-CODE  TO  WS-HIGH-BILL-CODE       
              MOVE FIOCA135-SECURED-RATE    TO  WS-SECURED-RATE         
              MOVE FIOCA135-REGULATED-FLAG  TO  WS-REGULATED-FLAG       
              MOVE FIOCA135-VAR             TO  WS-VAR                  
              MOVE FIOCA135-VAR-PER         TO  WS-VAR-PER              
              PERFORM 2500-GENERATE-RPT01        THRU 2500-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7400-READ-FCSCA135         THRU 7400-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-MOVE-HDR-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2100-MOVE-HDR-DATA.                                              
      *                                                                         
              MOVE WS-RPT-CSRPG1            TO P-RPT-TITLE-PGM.         
              ADD +1                        TO WS-PAGE-NUM1             
              MOVE WS-PAGE-NUM1             TO P-RPT-TITLE-PGNM         
              MOVE WS-COMPANY-NAME          TO WS-RPT-TITLE-1           
              MOVE WS-RPT-HEADER-1          TO PRT33-RECORD             
              WRITE PRT33-RECORD            AFTER ADVANCING PAGE        
              ADD +1                        TO WS-LINE-COUNT1           
              MOVE WS-RPT-HEADER-2          TO PRT33-RECORD             
              PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT            
              MOVE WS-RPT-HEADER-3          TO PRT33-RECORD             
              PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT            
              MOVE WS-RPT-HEADER-4          TO PRT33-RECORD             
              PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT            
              MOVE WS-RPT-HEADER-5          TO PRT33-RECORD             
              PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT            
              MOVE WS-RPT-HEADER-6          TO PRT33-RECORD             
              WRITE PRT33-RECORD            AFTER ADVANCING 3 LINES     
              ADD   +4                      TO WS-LINE-COUNT1           
              MOVE WS-RPT-HEADER-7          TO PRT33-RECORD             
              PERFORM 8000-WRITE-PRT33        THRU 8000-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-MOVE-HDR-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2200-MOVE-HDR-DATA.                                              
      *                                                                         
                MOVE WS-RPT-CSRPG2          TO P-RPT-TITLE-PGM.         
                ADD +1                      TO WS-PAGE-NUM2             
                MOVE WS-PAGE-NUM2           TO P-RPT-TITLE-PGNM         
                MOVE WS-COMPANY-NAME        TO WS-RPT-TITLE-1           
                MOVE WS-RPT-HEADER-1        TO PRT331-RECORD            
                WRITE PRT331-RECORD         AFTER ADVANCING PAGE        
                ADD +1                       TO WS-LINE-COUNT1          
                MOVE WS-RPT-HEADER-2        TO PRT331-RECORD            
                PERFORM 8100-WRITE-PRT331     THRU 8100-EXIT            
                MOVE WS-RPT-HEADER-3        TO PRT331-RECORD            
                PERFORM 8100-WRITE-PRT331     THRU 8100-EXIT            
                MOVE WS-RPT-HEADER-4        TO PRT331-RECORD            
                PERFORM 8100-WRITE-PRT331     THRU 8100-EXIT            
                MOVE WS-RPT-HEADER-5        TO PRT331-RECORD            
                PERFORM 8100-WRITE-PRT331     THRU 8100-EXIT            
                MOVE WS-RPT-HEADER-6        TO PRT331-RECORD            
                WRITE PRT331-RECORD         AFTER ADVANCING 3 LINES     
                ADD   +4                    TO WS-LINE-COUNT2           
                MOVE WS-RPT-HEADER-7        TO PRT331-RECORD            
                PERFORM 8100-WRITE-PRT331     THRU 8100-EXIT.           
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-NO-DATA-REPORT.                                   **              
      ******************************************************************        
      *                                                                         
       2400-NO-DATA-REPORT.                                             
      *                                                                         
            IF WS-REPORT-1 = WS-NO                                      
               IF WS-COMPANY-NAME = SPACES                              
                  MOVE SPACES                TO WS-TITLE-3              
               ELSE                                                     
                  IF WS-COMPANY-NAME = 'SCANA ENERGY'                   
                     MOVE 'REGULATED ACCOUNTS'   TO WS-TITLE-3          
                  ELSE                                                  
                     MOVE 'SECURED ACCOUNTS'     TO WS-TITLE-3          
                  END-IF                                                
               END-IF                                                   
               PERFORM 2100-MOVE-HDR-DATA    THRU 2100-EXIT             
               MOVE WS-NO-DATA               TO PRT33-RECORD            
               PERFORM 8000-WRITE-PRT33      THRU 8000-EXIT             
            ELSE                                                        
              MOVE WS-RPT-TERMDISP1          TO PRT33-RECORD            
              WRITE PRT33-RECORD AFTER ADVANCING 3 LINES                
              ADD   +4                       TO WS-LINE-COUNT1          
              MOVE WS-RPT-TERMDISP2          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP3          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP4          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP5          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
              MOVE WS-RPT-TERMDISP6          TO PRT33-RECORD            
              PERFORM 8000-WRITE-PRT33       THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WS-REPORT-2 = WS-NO                                       
              IF WS-COMPANY-NAME = SPACES                               
                 MOVE SPACES                TO WS-TITLE-3               
              ELSE                                                      
                 IF WS-COMPANY-NAME = 'SCANA ENERGY'                    
                    MOVE 'DEREGULATED ACCOUNTS' TO WS-TITLE-3           
                 ELSE                                                   
                    MOVE SPACES             TO WS-TITLE-3               
                 END-IF                                                 
              END-IF                                                    
              PERFORM 2200-MOVE-HDR-DATA    THRU 2200-EXIT              
              MOVE WS-NO-DATA               TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
           ELSE                                                         
              MOVE WS-RPT-TERMDISP1         TO PRT331-RECORD            
              WRITE PRT331-RECORD AFTER ADVANCING 3 LINES               
              ADD   +4                       TO WS-LINE-COUNT2          
              MOVE WS-RPT-TERMDISP2         TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
              MOVE WS-RPT-TERMDISP3         TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
              MOVE WS-RPT-TERMDISP4         TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
              MOVE WS-RPT-TERMDISP5         TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
              MOVE WS-RPT-TERMDISP6         TO PRT331-RECORD            
              PERFORM 8100-WRITE-PRT331       THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2500-GENERATE-RPT01                                         **        
      ******************************************************************        
      *                                                                         
       2500-GENERATE-RPT01.                                             
                                                                        
           IF C7-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO                   
              PERFORM 7000-GET-COMPANY-NAME   THRU 7000-EXIT            
              MOVE C7-COMPANY-NAME            TO WS-COMPANY-NAME        
              MOVE C7-COMPANY-NO              TO WS-PREV-COMP-NO        
              MOVE WS-YES                     TO WS-COMP-NO-DIFF        
           END-IF.                                                      
                                                                        
           IF WS-COMPANY-NAME = 'SCANA ENERGY'                          
              IF WS-REGULATED-FLAG = 'Y'                                
                 MOVE 'REGULATED ACCOUNTS'    TO WS-TITLE-3             
                 PERFORM 2510-MOVE-DETAIL-REC THRU 2510-EXIT            
              ELSE                                                      
                 MOVE 'DEREGULATED ACCOUNTS'  TO WS-TITLE-3             
                 PERFORM 2520-MOVE-DETAIL-REC THRU 2520-EXIT            
              END-IF                                                    
           ELSE                                                         
              IF WS-SECURED-RATE = 'Y'                                  
                 MOVE 'SECURED  ACCOUNTS'    TO WS-TITLE-3              
                 PERFORM 2510-MOVE-DETAIL-REC THRU 2510-EXIT            
              ELSE                                                      
                 MOVE SPACES                 TO WS-TITLE-3              
                 PERFORM 2520-MOVE-DETAIL-REC THRU 2520-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-MOVE-DETAIL-REC.                                       *           
      ******************************************************************        
      *                                                                         
       2510-MOVE-DETAIL-REC.                                            
      *                                                                         
           IF WS-LINE-COUNT1    >= 52      OR                           
              WS-COMP-NO-DIFF   =  WS-YES  OR                           
              WS-REPORT-1       =  WS-NO   OR                           
              C7-COMPANY-NO NOT EQUAL WS-RPT1-COMPANY                   
              MOVE 0                        TO  WS-LINE-COUNT1          
              PERFORM 2100-MOVE-HDR-DATA    THRU 2100-EXIT              
              MOVE WS-NO                    TO WS-COMP-NO-DIFF          
              MOVE C7-COMPANY-NO            TO WS-RPT1-COMPANY          
           END-IF.                                                      
           MOVE WS-ACCOUNT1                 TO  RPT-ACCOUNT-NO          
           MOVE WS-ACCOUNT-TYPE-CODE        TO  RPT-ACCOUNT-TYPE-CODE   
           MOVE WS-CODE-UTIL-TYPE           TO  RPT-CODE-UTIL-TYPE      
           MOVE WS-RATE-PLAN-NO             TO  RPT-RATE-PLAN-NO        
           MOVE WS-BILL-CYCLE               TO  RPT-BILL-CYCLE          
           MOVE WS-BILL-NO                  TO  RPT-BILL-NO             
           MOVE WS-AMT-BILL-ITEM            TO  RPT-AMT-BILL-ITEM       
           MOVE WS-PREV-BILL-AMT            TO  RPT-PREV-BILL-AMT       
           MOVE WS-TOTAL-AR-BAL             TO  RPT-TOTAL-AR-BAL        
           MOVE WS-VAR                      TO  RPT-VARIANCE            
           MOVE WS-VAR-PER                  TO  RPT-VARIANCE-PER        
           MOVE WS-EBILL-REG-IND            TO  RPT-EBILL-REG-IND       
           MOVE WS-DRAFT-IND                TO  RPT-DRAFT-IND           
           MOVE WS-HIGH-BILL-CODE           TO  RPT-HIGH-BILL-CODE      
           MOVE WS-DTL-REC                  TO  PRT33-RECORD            
           PERFORM 8000-WRITE-PRT33         THRU 8000-EXIT              
           MOVE WS-YES                      TO WS-REPORT-1.             
      *                                                                         
       2510-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2520-MOVE-DETAIL-REC.                                          *        
      ******************************************************************        
      *                                                                         
       2520-MOVE-DETAIL-REC.                                            
      *                                                                         
           IF WS-LINE-COUNT2    >= 52       OR                          
              WS-COMP-NO-DIFF   =  WS-YES   OR                          
              WS-REPORT-2       =  WS-NO    OR                          
              C7-COMPANY-NO NOT EQUAL WS-RPT2-COMPANY                   
              MOVE 0                        TO WS-LINE-COUNT2           
              PERFORM 2200-MOVE-HDR-DATA    THRU 2200-EXIT              
              MOVE WS-NO                    TO WS-COMP-NO-DIFF          
              MOVE C7-COMPANY-NO            TO WS-RPT2-COMPANY          
           END-IF.                                                      
           MOVE WS-ACCOUNT1                 TO  RPT1-ACCOUNT-NO         
           MOVE WS-ACCOUNT-TYPE-CODE        TO  RPT1-ACCOUNT-TYPE-CODE  
           MOVE WS-CODE-UTIL-TYPE           TO  RPT1-CODE-UTIL-TYPE     
           MOVE WS-RATE-PLAN-NO             TO  RPT1-RATE-PLAN-NO       
           MOVE WS-BILL-CYCLE               TO  RPT1-BILL-CYCLE         
           MOVE WS-BILL-NO                  TO  RPT1-BILL-NO            
           MOVE WS-AMT-BILL-ITEM            TO  RPT1-AMT-BILL-ITEM      
           MOVE WS-PREV-BILL-AMT            TO  RPT1-PREV-BILL-AMT      
           MOVE WS-TOTAL-AR-BAL             TO  RPT1-TOTAL-AR-BAL       
           MOVE WS-VAR                      TO  RPT1-VARIANCE           
           MOVE WS-VAR-PER                  TO  RPT1-VARIANCE-PER       
           MOVE WS-EBILL-REG-IND            TO  RPT1-EBILL-REG-IND      
           MOVE WS-DRAFT-IND                TO  RPT1-DRAFT-IND          
           MOVE WS-HIGH-BILL-CODE           TO  RPT1-HIGH-BILL-CODE     
           MOVE WS-DTL1-REC                 TO PRT331-RECORD            
           PERFORM 8100-WRITE-PRT331        THRU 8100-EXIT              
           MOVE WS-YES                      TO WS-REPORT-2.             
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP094 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-READ-FCSCA135                                             *        
      ******************************************************************        
       7400-READ-FCSCA135.                                              
      *                                                                         
           READ FCSCA135-FILE                                           
                                                                        
           IF FCSCA135-SUCCESSFUL OR  END-OF-REC                        
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP094 ABORT *********'          
               DISPLAY '**ERROR IN READING FCSCA135 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCSCA135-STATUS          
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-PRT33                                             **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-PRT33.                                                
      *                                                                         
           WRITE PRT33-RECORD.                                          
           ADD +1                           TO WS-LINE-COUNT1.          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-PRT331                                            **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                           TO WS-LINE-COUNT2.          
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA135-FILE.                                         
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
