       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP091.                                            
       AUTHOR. ROGER D FAULK                                            
       DATE-WRITTEN. DEC 2011.                                          
      ****************************************************************          
      *                SOUTH CAROLINA ELECTRIC & GAS                 *          
      ****************************************************************          
      *                CUSTOMER INFORMATION SYSTEM                   *          
      ****************************************************************          
      *                     P R O G R A M S U M M A R Y              *          
      *                                                              *          
      *    PURPOSE :                                                 *          
      *    REPORT OF SPECIALTY METER CHANGES.                        *          
      *                                                              *          
      ****************************************************************          
      *                                                              *          
      *                PROGRAM  MODIFICATION  LOG                    *          
      *                                                              *          
      *       DATE       INITIALS    REASON                          *          
      *     ----------   --------    ---------------------------     *          
A03959*     12/31/2012   MS93554     CODE_METER_STATUS = 'B' CHANGED *          
      *                              TO NOW BE "BACKUP METER".       *          
      ****************************************************************          
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP091'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-GENERAL-WORKING-STORAGE.                                   
          05  WS-ACCOUNT-NO-HOLD       PIC S9(13) COMP-3 VALUE 0.       
          05  WS-ACCOUNT-NO            PIC 9(13).                       
          05  WS-FMT-ACCT-NO.                                           
               10  WS-FMT-ACCT-NO-1    PIC X.                           
               10  FILLER              PIC X    VALUE '-'.              
               10  WS-FMT-ACCT-NO-4A   PIC X(4).                        
               10  FILLER              PIC X    VALUE '-'.              
               10  WS-FMT-ACCT-NO-4B   PIC X(4).                        
               10  FILLER              PIC X    VALUE '-'.              
               10  WS-FMT-ACCT-NO-4C   PIC X(4).                        
          05  WS-COMMON-DATE           PIC X(10).                       
          05  WS-NODATA-SPECIALTY-01   PIC X     VALUE 'Y'.             
          05  WS-NODATA-SPECIALTY-26   PIC X     VALUE 'Y'.             
          05  WS-DATA-FLAG             PIC X     VALUE 'N'.             
          05  WS-RPT-PRINTED           PIC X     VALUE 'Y'.             
          05  WS-PREV-DATA             PIC X(40).                       
          05  WS-PREV-DATA-TEMP        PIC X(40).                       
          05  WS-CHANGED-TO            PIC X(40).                       
          05  WS-CHANGED-TO-TEMP       PIC X(40).                       
          05  WS-CUSTOMER-NO           PIC S9(10) COMP-3 VALUE 0.       
          05  WS-NAME-FIRST-TIME       PIC X      VALUE 'Y'.            
          05  WS-CUST-FIRST-TIME       PIC X      VALUE 'Y'.            
          05  WS-CUST-NAME             PIC X(37).                       
          05  WS-ADDRESS-1             PIC X(30).                       
          05  WS-ADDRESS-2             PIC X(35).                       
          05  WS-COMP-INFO-CRSR-IND    PIC X.                           
          05  WS-TMP-CMP-NO            PIC XX.                          
          05  WS-COMP-NO-HOLD          PIC XX.                          
          05  WS-PARM-COMP-NO          PIC XX.                          
          05  WS-METER-NO              PIC X(9).                        
          05  WS-CODE-UTIL-TYPE        PIC X.                           
          05  WS-CODE-UTIL-TYPE-DESC   PIC X(12).                       
          05  WS-TRAN-DESC             PIC X.                           
          05  WS-MTR-STATUS-CHNG-DT    PIC X(10).                       
          05  WS-DATE-MTR-INSTALL      PIC X(10).                       
          05  WS-CODE-METER-STATUS     PIC X.                           
          05  WS-CODE-METER-STATUS-DSC PIC X(22).                       
          05  WS-CODE-STATUS-REAS      PIC X.                           
          05  WS-CODE-STATUS-REASON    PIC X(22).                       
          05  WS-RATE-PLAN-NO          PIC X(3).                        
          05  WS-TRAN-TYPE             PIC X(15).                       
          05  WS-DISP-RC               PIC -ZZZZZZZZ9.9.                
          05  WS-LOCAL-OFFICE          PIC X(3)   VALUE ' '.            
          05  WS-LINE-COUNT            PIC 99     VALUE 0.              
          05  WS-PRT33-RECORD          PIC X(132) VALUE SPACES.         
          05  WS-PAGE-COUNT            PIC 99     VALUE 0.              
          05  WS-SKIP-LINES-NUM        PIC 99     VALUE 0.              
          05  WS-ERR-MSG               PIC X(40)  VALUE SPACES.         
          05  WS-SCEG-COMP-NAME        PIC X(26)  VALUE SPACES.         
          05  WS-PSNC-COMP-NAME        PIC X(26)  VALUE SPACES.         
          05  RS-RETURN-CODE           PIC S9(4)  COMP VALUE 0.         
          05  RS-RETURN-CODE-DISP      PIC +Z(4).                       
          05  WS-PREMISE-NO            PIC S9(10) COMP-3 VALUE 0.       
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
          05  WS-NULL-IND1             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND2             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND3             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND4             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND5             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND6             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND7             PIC S9(4) COMP VALUE 0.          
          05  WS-NULL-IND8             PIC S9(4) COMP VALUE 0.          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 99.                          
           05  WS-MM                   PIC 99.                          
           05  WS-SS                   PIC 99.                          
           05  WS-TT                   PIC 99.                          
      *                                                                         
       01  WS-FIX-DATE                 PIC X(10).                       
       01  WS-FIX-DATE2                PIC X(10).                       
      *                                                                         
       01  WS-WORK-DATE.                                                
           07  WS-WORK-YEAR            PIC X(4).                        
           07  FILLER                  PIC X   VALUE '-'.               
           07  WS-WORK-MONTH           PIC XX.                          
           07  FILLER                  PIC X   VALUE '-'.               
           07  WS-WORK-DAY             PIC XX.                          
      *                                                                         
       01  WS-TODAY-2UNIQUE-TS         PIC X(26).                       
       01  WS-TOM-2UNIQUE-TS           PIC X(26).                       
      *                                                                         
       01  WS-TODAY-UNIQUE-TS.                                          
           05 WS-FIX-DATE-TS.                                           
              07  WS-TODAY-YEAR        PIC X(4).                        
              07  FILLER               PIC X   VALUE '-'.               
              07  WS-TODAY-MONTH       PIC XX.                          
              07  FILLER               PIC X   VALUE '-'.               
              07  WS-TODAY-DAY         PIC XX.                          
           05  WS-TODAY-REST           PIC X(16)                        
                                  VALUE '-00.00.00.000000'.             
      *                                                                         
       01  WS-TOM-UNIQUE-TS.                                            
           05 WS-FIX-DATE2-TS.                                          
              07  WS-TOM-YEAR          PIC X(4).                        
              07  FILLER               PIC X   VALUE '-'.               
              07  WS-TOM-MONTH         PIC XX.                          
              07  FILLER               PIC X   VALUE '-'.               
              07  WS-TOM-DAY           PIC XX.                          
           05  WS-TOM-REST             PIC X(16)                        
                                  VALUE '-00.00.00.000000'.             
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC XX.                          
           05  FILLER                  PIC X     VALUE ':'.             
           05  WS-RT-MM                PIC XX.                          
           05  FILLER                  PIC X     VALUE ':'.             
           05  WS-RT-SS                PIC XX.                          
      *                                                                         
       01  WS-REVENUE-MONTH.                                            
           05  WS-REV-YR               PIC X(4).                        
           05  FILLER                  PIC X    VALUE '/'.              
           05  WS-REV-MTH              PIC XX.                          
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 99.                          
           05  WS-CM                   PIC 99.                          
           05  WS-CD                   PIC 99.                          
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC XX.                          
           05  FILLER                  PIC X     VALUE '/'.             
           05  WS-RD-DD                PIC XX.                          
           05  FILLER                  PIC X     VALUE '/'.             
           05  WS-RD-YY                PIC XX.                          
      *                                                                         
        01 WS-LITERALS.                                                 
           05 WS-01                    PIC XX    VALUE '01'.            
           05 WS-Y                     PIC X     VALUE 'Y'.             
           05 WS-N                     PIC X     VALUE 'N'.             
           05 WS-MAX-LINES             PIC 99    VALUE 55.              
           05 WS-PARM1                 PIC X(4)  VALUE 'DATE'.          
           05 PROGRAM-NAME             PIC X(8)  VALUE 'PCSRP091'.      
           05 WS-PGRMNAME              PIC X(8)  VALUE 'PCSRP091'.      
      *                                                                         
      ****************************************************************          
      *            COMMON WORKING STORAGE FOR REPORT HEADERS         *          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
           05  PRT-HEADER-1.                                            
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(8)  VALUE 'PCSRP091'.      
               10  FILLER              PIC X(38) VALUE SPACES.          
               10  PRT-COMPANY-NAME    PIC X(26) VALUE SPACES.          
               10  FILLER              PIC X(38) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'PAGE    : '.    
               10  PRT-PAGE-NBR        PIC ZZ,ZZ9.                      
      *                                                                         
           05  PRT-HEADER-2.                                            
               10  FILLER              PIC X(40) VALUE SPACES.          
               10  FILLER              PIC X(31)                        
                          VALUE 'TRANSACTIONS POSTED TO ACCOUNTS'.      
               10  FILLER              PIC X(19)                        
                          VALUE ' WITH SECURED RATES'.                  
               10  FILLER              PIC X(21) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN DATE: '.    
               10  PRT-RUN-DATE        PIC X(10) VALUE SPACES.          
      *                                                                         
           05  PRT-HEADER-3.                                            
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(14)                        
                          VALUE 'REVENUE-MONTH:'.                       
               10  PRT-REVENUE-MONTH   PIC X(7)  VALUE SPACES.          
               10  FILLER              PIC X(89) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'RUN TIME: '.    
               10  PRT-RUN-TIME        PIC X(8)  VALUE SPACES.          
               10  FILLER              PIC XX    VALUE SPACES.          
      *                                                                         
           05  PRT-HEADER-4.                                            
               10  FILLER              PIC X     VALUE SPACES.          
               10  FILLER              PIC X(14)                        
                          VALUE 'ACCOUNT NUMBER'.                       
               10  FILLER              PIC X(4)  VALUE SPACES.          
               10  FILLER              PIC X(13)                        
                          VALUE 'CUSTOMER NAME'.                        
               10  FILLER              PIC X(24) VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'TRANS TYPE'.    
               10  FILLER              PIC X(7)  VALUE SPACES.          
               10  FILLER              PIC X(10) VALUE 'TRANS DESC'.    
               10  FILLER              PIC X(51) VALUE SPACES.          
      *                                                                         
           05  PRT-DETAIL-1.                                            
               10  FILLER              PIC X     VALUE SPACES.          
               10  PRT-ACCOUNT         PIC X(16) VALUE SPACES.          
               10  FILLER              PIC XX    VALUE SPACES.          
               10  PRT-CUSTOMER        PIC X(37) VALUE SPACES.          
               10  PRT-TRAN-TYPE       PIC X(15) VALUE SPACES.          
               10  FILLER              PIC XX    VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'CODE  UTIL TYPE : '.                   
               10  PRT-UTIL-DESC       PIC X(12) VALUE SPACES.          
               10  FILLER              PIC X(24) VALUE SPACES.          
      *                                                                         
           05  PRT-DETAIL-2.                                            
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'METER NO / CONSTANT  : '.              
               10  PRT-METER           PIC X(9)  VALUE SPACES.          
               10  FILLER              PIC X(3)  VALUE ' \ '.           
               10  PRT-CONSTANT        PIC 999999.999.                  
               10  FILLER              PIC X(14) VALUE SPACES.          
      *                                                                         
           05  PRT-DETAIL-3.                                            
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'RATE PLAN NO         : '.              
               10  PRT-RATE            PIC X(3)  VALUE SPACES.          
               10  FILLER              PIC X(35) VALUE SPACES.          
      *                                                                         
           05  PRT-LINE-4.                                              
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'MTR STATUS CHANGE DT : '.              
               10  PRT-MTR-STATUS      PIC X(10) VALUE SPACES.          
               10  FILLER              PIC X(28) VALUE SPACES.          
      *                                                                         
           05  PRT-LINE-5.                                              
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'DATE MTR INSTALL     : '.              
               10  PRT-DATE-INSTALL    PIC X(10) VALUE SPACES.          
               10  FILLER              PIC X(28) VALUE SPACES.          
      *                                                                         
           05  PRT-LINE-6.                                              
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'METER STATUS         : '.              
               10  PRT-CODE-MTR-STATUS PIC X(22).                       
               10  FILLER              PIC X(17) VALUE SPACES.          
      *                                                                         
           05  PRT-LINE-7.                                              
               10  FILLER              PIC X(73) VALUE SPACES.          
               10  FILLER              PIC X(23)                        
                          VALUE 'METER STATUS REASON  : '.              
               10  PRT-STATUS-REASON   PIC X(22) VALUE SPACES.          
               10  FILLER              PIC X(17) VALUE SPACES.          
      *                                                                         
           05  PRT-BLANK-LINE.                                          
               10 FILLER               PIC X(133) VALUE SPACES.         
      *                                                                         
       01  PRT-NO-DATA-LINE.                                            
           05  FILLER                  PIC X(52)  VALUE SPACES.         
           05  FILLER                  PIC X(31)  VALUE                 
               '**** NO DATA FOR THIS RUN  ****'.                       
           05  FILLER                  PIC X(49)  VALUE SPACES.         
      *                                                                         
       01  PRT-FOOTER-LINE.                                             
           05  FILLER                  PIC X(35)  VALUE SPACES.         
           05  FILLER                  PIC X(25)  VALUE                 
               '* * * END OF REPORT * * *'.                             
           05  FILLER                  PIC X(72)  VALUE SPACES.         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY CWS00074.                                                           
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * SQL COMMUNICATION AREA                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ACCOUNT                                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ADDR_FORMATTED                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ADDR_FREEFORM                                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_COMPANY                                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_JOB_PARM                                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_MTRD_ENVRNMT                                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_NAME                                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_NAME_ACCT_XREF                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CUST_ADDR_XREF                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_PREMISE                                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_RATE_PLAN_DESC                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_UTIL_ENVRNMT                                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ZIP_CODE                                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ACCT_MISC_INFO                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_DELINQUENCY                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_MTR_CAP  -  MC                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD00099                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR FOR SPECIALTY METER CHANGE                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE SPECIALTY_CSR CURSOR FOR                           
              SELECT DISTINCT AT.ACCOUNT_NO                             
                    ,AT.ADDRESS_ID                                      
                    ,MN.METER_NO                                        
                    ,MN.CODE_UTIL_TYPE                                  
                    ,MN.MTR_STATUS_CHNG_DT                              
                    ,MN.DATE_MTR_INSTALL                                
                    ,MN.CODE_METER_STATUS                               
                    ,MN.CODE_STATUS_REAS                                
                    ,UT.RATE_PLAN_NO                                    
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.COMPANY_NO                                      
                    ,MC.CONSTANT                                        
               FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
                    ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
                    ,CSS_SO_UPDATE VW WITH(READUNCOMMITTED)                     
                    ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
                    ,CSS_MTR_CAP MC WITH(READUNCOMMITTED)                       
               WHERE RD.SECURED_RATE_FL = 'Y'                           
               AND AT.CODE_ACCT_STAT = 'A'                              
               AND ( UT.ACCOUNT_NO = VO.ACCOUNT_NO                      
                      OR UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR)           
               AND VO.ORDER_STATE_CD = 'Z'                              
               AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                  
               AND VW.UPDATE_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )           
               AND VW.UPDATE_DATETIME <  CIS.CHAR2TIMESTAMP(
                                                     :WS-TOM-2UNIQUE-TS
              )             
               AND VW.ORDER_STATE_CD = 'A'                              
               AND VW.SERV_ORDER_STATUS = '60'                          
               AND VW.PANEL_NO = '090'                                  
               AND VW.USER_ID_UPDT_BY IN ('DV14870', 'PD04049')         
               AND CAST(VO.COMPLETED_DATETIME AS DATE) = 
           MN.MTR_STATUS_CHNG_DT  
               AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                  
               AND VI.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                
               AND VI.IC_NO = UT.IC_NO                                  
               AND VI.WORK_TYPE_CD NOT IN ('   ', 'RDO')                
               AND AT.ACCOUNT_NO = MN.ACCOUNT_NO                        
               AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                        
               AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                
               AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                
               AND MN.IC_NO = UT.IC_NO                                  
               AND MN.METER_NO  = MC.METER_NO                           
               AND MN.REG_ID_NO = MC.REG_ID_NO                          
               AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                    
               AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE               
               AND AT.COMPANY_NO      = MC.COMPANY_NO                   
             ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO                      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SPECIALTY_CSR CURSOR FOR                                   
MFA-TR*       SELECT DISTINCT AT.ACCOUNT_NO                                     
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,MN.METER_NO                                                
MFA-TR*             ,MN.CODE_UTIL_TYPE                                          
MFA-TR*             ,MN.MTR_STATUS_CHNG_DT                                      
MFA-TR*             ,MN.DATE_MTR_INSTALL                                        
MFA-TR*             ,MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.CODE_STATUS_REAS                                        
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,MC.CONSTANT                                                
MFA-TR*        FROM  CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                                      
MFA-TR*             ,CSS_SO_DATA VO                                             
MFA-TR*             ,CSS_SO_UPDATE VW                                           
MFA-TR*             ,CSS_SO_ORDER_INST VI                                       
MFA-TR*             ,CSS_MTR_CAP MC                                             
MFA-TR*        WHERE RD.SECURED_RATE_FL = 'Y'                                   
MFA-TR*        AND AT.CODE_ACCT_STAT = 'A'                                      
MFA-TR*        AND ( UT.ACCOUNT_NO = VO.ACCOUNT_NO                              
MFA-TR*               OR UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR)                   
MFA-TR*        AND VO.ORDER_STATE_CD = 'Z'                                      
MFA-TR*        AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                          
MFA-TR*        AND VW.UPDATE_DATETIME >= :WS-TODAY-2UNIQUE-TS                   
MFA-TR*        AND VW.UPDATE_DATETIME <  :WS-TOM-2UNIQUE-TS                     
MFA-TR*        AND VW.ORDER_STATE_CD = 'A'                                      
MFA-TR*        AND VW.SERV_ORDER_STATUS = '60'                                  
MFA-TR*        AND VW.PANEL_NO = '090'                                          
MFA-TR*        AND VW.USER_ID_UPDT_BY IN ('DV14870', 'PD04049')                 
MFA-TR*        AND DATE(VO.COMPLETED_DATETIME) = MN.MTR_STATUS_CHNG_DT          
MFA-TR*        AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                          
MFA-TR*        AND VI.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                        
MFA-TR*        AND VI.IC_NO = UT.IC_NO                                          
MFA-TR*        AND VI.WORK_TYPE_CD NOT IN ('   ', 'RDO')                        
MFA-TR*        AND AT.ACCOUNT_NO = MN.ACCOUNT_NO                                
MFA-TR*        AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                                
MFA-TR*        AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                        
MFA-TR*        AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                        
MFA-TR*        AND MN.IC_NO = UT.IC_NO                                          
MFA-TR*        AND MN.METER_NO  = MC.METER_NO                                   
MFA-TR*        AND MN.REG_ID_NO = MC.REG_ID_NO                                  
MFA-TR*        AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                            
MFA-TR*        AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                       
MFA-TR*        AND AT.COMPANY_NO      = MC.COMPANY_NO                           
MFA-TR*      ORDER BY AT.COMPANY_NO, AT.ACCOUNT_NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   INITIALIZATION.                                            *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           MOVE '01' TO AT-COMPANY-NO                                   
                        C7-COMPANY-NO.                                  
           PERFORM 7800-GET-COMP-DESC THRU 7800-EXIT.                   
           MOVE C7-COMPANY-NAME TO WS-SCEG-COMP-NAME.                   
      *                                                                         
           MOVE '26' TO AT-COMPANY-NO                                   
                        C7-COMPANY-NO.                                  
           PERFORM 7800-GET-COMP-DESC THRU 7800-EXIT.                   
           MOVE C7-COMPANY-NAME TO WS-PSNC-COMP-NAME.                   
      *                                                                         
           MOVE WS-PGRMNAME TO G6-PROGRAM-NAME.                         
           MOVE WS-PARM1    TO G6-CMND-CODE.                            
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           MOVE WS-INPUT-RUN-DATE TO WS-COMMON-DATE.                    
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE PROGRAM-NAME TO WS-PGRMNAME                          
              MOVE WS-FCA00-COMMON-DATE TO WS-COMMON-DATE               
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMMON-DATE(1:4)   TO WS-REV-YR.                     
           MOVE WS-COMMON-DATE(6:2)   TO WS-REV-MTH.                    
           MOVE WS-REVENUE-MONTH      TO PRT-REVENUE-MONTH.             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                 TO WS-RT-HH.                      
           MOVE WS-MM                 TO WS-RT-MM.                      
           MOVE WS-SS                 TO WS-RT-SS.                      
           MOVE WS-RUN-TIME           TO PRT-RUN-TIME.                  
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                 TO WS-RD-YY.                      
           MOVE WS-CM                 TO WS-RD-MM.                      
           MOVE WS-CD                 TO WS-RD-DD.                      
           MOVE WS-RUN-DATE           TO PRT-RUN-DATE.                  
      *                                                                         
           MOVE WS-COMMON-DATE  TO WS-FIX-DATE                          
                                   WS-FIX-DATE2.                        
      *                                                                         
           PERFORM 7500-GET-NEXT-DAY THRU 7500-EXIT.                    
      *                                                                         
           MOVE WS-FIX-DATE   TO WS-WORK-DATE.                          
           MOVE WS-WORK-YEAR  TO WS-TODAY-YEAR.                         
           MOVE WS-WORK-MONTH TO WS-TODAY-MONTH.                        
           MOVE WS-WORK-DAY   TO WS-TODAY-DAY.                          
      *                                                                         
           MOVE WS-FIX-DATE2  TO WS-WORK-DATE.                          
           MOVE WS-WORK-YEAR  TO WS-TOM-YEAR.                           
           MOVE WS-WORK-MONTH TO WS-TOM-MONTH.                          
           MOVE WS-WORK-DAY   TO WS-TOM-DAY.                            
      *                                                                         
           MOVE WS-TODAY-UNIQUE-TS TO WS-TODAY-2UNIQUE-TS.              
           MOVE WS-TOM-UNIQUE-TS   TO WS-TOM-2UNIQUE-TS.                
      *                                                                         
           DISPLAY 'WS-COMMON-DATE      = ' WS-COMMON-DATE.             
           DISPLAY 'WS-TODAY-2UNIQUE-TS = ' WS-TODAY-2UNIQUE-TS.        
           DISPLAY 'WS-TOM-2UNIQUE-TS   = ' WS-TOM-2UNIQUE-TS.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   MAIN PROCESS FLOW.                                         *          
      ****************************************************************          
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           PERFORM 5275-PROCESS-SPECIALTY-CHANGE THRU 5275-EXIT.        
      *                                                                         
           IF WS-NODATA-SPECIALTY-01 = 'Y'                              
              MOVE '01'                   TO AT-COMPANY-NO              
              MOVE AT-COMPANY-NO          TO WS-COMP-NO-HOLD            
              PERFORM 5950-PROCESS-NODATA THRU 5950-EXIT                
           END-IF.                                                      
      *                                                                         
           IF WS-NODATA-SPECIALTY-26 = 'Y'                              
              MOVE '26'                     TO AT-COMPANY-NO            
              MOVE AT-COMPANY-NO            TO WS-COMP-NO-HOLD          
              PERFORM 5950-PROCESS-NODATA   THRU 5950-EXIT              
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET CUSTOMER NAME                                          *          
      ****************************************************************          
      *                                                                         
       3000-GET-ADDRESS.                                                
      *                                                                         
           MOVE AT-ACCOUNT-NO        TO WS-ACCOUNT-NO.                  
           MOVE WS-ACCOUNT-NO(1:1)   TO WS-FMT-ACCT-NO-1.               
           MOVE WS-ACCOUNT-NO(2:4)   TO WS-FMT-ACCT-NO-4A.              
           MOVE WS-ACCOUNT-NO(6:4)   TO WS-FMT-ACCT-NO-4B.              
           MOVE WS-ACCOUNT-NO(10:4)  TO WS-FMT-ACCT-NO-4C.              
           MOVE WS-PREMISE-NO        TO AT-PREMISE-NO.                  
           MOVE SPACES               TO WS-CUST-NAME                    
                                        WS-ADDRESS-1                    
                                        WS-ADDRESS-2.                   
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           MOVE WS-CUSTOMER-NAME TO WS-CUST-NAME.                       
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS SPECIALTY METER CHANGE                             *          
      ****************************************************************          
      *                                                                         
       5275-PROCESS-SPECIALTY-CHANGE.                                   
      *                                                                         
           MOVE 0              TO WS-ACCOUNT-NO-HOLD.                   
           MOVE 'METER CHANGE' TO WS-TRAN-TYPE.                         
           MOVE SPACES         TO WS-COMP-NO-HOLD.                      
      *                                                                         
           PERFORM 7300-OPEN-SPECIALTY-CSR THRU 7300-EXIT.              
      *                                                                         
           PERFORM 7310-FETCH-SPECIALTY-CSR THRU 7310-EXIT.             
           PERFORM 5675-GENERATE-SPECIALTY THRU 5675-EXIT               
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.          
      *                                                                         
           PERFORM 7320-CLOSE-SPECIALTY-CSR THRU 7320-EXIT.             
      *                                                                         
       5275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GENERATE REPORT.                                           *          
      ****************************************************************          
      *                                                                         
       5675-GENERATE-SPECIALTY.                                         
      *                                                                         
           IF WS-ACCOUNT-NO-HOLD = AT-ACCOUNT-NO                        
             MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-HOLD                   
             PERFORM 7310-FETCH-SPECIALTY-CSR THRU 7310-EXIT            
           ELSE                                                         
             MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-HOLD                   
             PERFORM 3000-GET-ADDRESS THRU 3000-EXIT                    
             PERFORM 5710-EVALUATE-PARA THRU 5710-EXIT                  
             PERFORM 5850-POPULATE-REPORT-DET-02 THRU 5850-EXIT         
             PERFORM 7310-FETCH-SPECIALTY-CSR THRU 7310-EXIT            
           END-IF.                                                      
      *                                                                         
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N' TO WS-NODATA-SPECIALTY-01                         
           ELSE                                                         
             MOVE 'N' TO WS-NODATA-SPECIALTY-01                         
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER THRU 8400-EXIT               
           END-IF.                                                      
      *                                                                         
       5675-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   EVALUATE DATA.  MOVE LITERALS                              *          
      ****************************************************************          
      *                                                                         
       5710-EVALUATE-PARA.                                              
      *                                                                         
           EVALUATE WS-CODE-UTIL-TYPE                                   
            WHEN 'G'                                                    
                 MOVE 'GAS'      TO WS-CODE-UTIL-TYPE-DESC              
            WHEN 'E'                                                    
                 MOVE 'ELECTRIC' TO WS-CODE-UTIL-TYPE-DESC              
            WHEN 'U'                                                    
                 MOVE 'UTIILITY' TO WS-CODE-UTIL-TYPE-DESC              
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE WS-CODE-METER-STATUS                                
             WHEN '0'                                                   
               MOVE 'INSTALLED/KVAR' TO WS-CODE-METER-STATUS-DSC        
             WHEN '1'                                                   
               MOVE 'INSTALLED/KVAR I MONTH'                            
                     TO WS-CODE-METER-STATUS-DSC                        
             WHEN 'A'                                                   
               MOVE 'ACTIVE/NORMAL BILLING'                             
                     TO WS-CODE-METER-STATUS-DSC                        
             WHEN 'B'                                                   
A03959         MOVE 'BACKUP METER'                                      
                     TO WS-CODE-METER-STATUS-DSC                        
             WHEN 'I'                                                   
               MOVE 'INSTALLED' TO WS-CODE-METER-STATUS-DSC             
             WHEN 'J'                                                   
               MOVE 'INACTIVE/TURNED OFF' TO WS-CODE-METER-STATUS-DSC   
             WHEN 'K'                                                   
               MOVE 'REMOVED' TO WS-CODE-METER-STATUS-DSC               
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE WS-CODE-STATUS-REAS                                 
             WHEN '0'                                                   
                 MOVE 'COMMISSION REQUEST' TO WS-CODE-STATUS-REASON     
             WHEN '1'                                                   
                 MOVE 'FIRE'               TO WS-CODE-STATUS-REASON     
             WHEN '2'                                                   
                 MOVE 'UNAUTHORIZED USE'   TO WS-CODE-STATUS-REASON     
             WHEN '3'                                                   
                 MOVE 'PERIODIC TEST'      TO WS-CODE-STATUS-REASON     
             WHEN '4'                                                   
                 MOVE 'SAMPLE TEST'        TO WS-CODE-STATUS-REASON     
             WHEN '5'                                                   
                 MOVE 'STOPPED METER'      TO WS-CODE-STATUS-REASON     
             WHEN '6'                                                   
                 MOVE 'SERVICE ABANDONED'  TO WS-CODE-STATUS-REASON     
             WHEN '7'                                                   
                 MOVE 'SERVICE LINE REMOVED' TO WS-CODE-STATUS-REASON   
             WHEN '8'                                                   
                 MOVE 'METER SONP'         TO WS-CODE-STATUS-REASON     
             WHEN 'A'                                                   
                 MOVE 'NORMAL'             TO WS-CODE-STATUS-REASON     
             WHEN 'B'                                                   
                 MOVE 'NON-PAYMENT'        TO WS-CODE-STATUS-REASON     
             WHEN 'C'                                                   
                 MOVE 'SEASONAL'           TO WS-CODE-STATUS-REASON     
             WHEN 'D'                                                   
                 MOVE 'FORCED OFF'         TO WS-CODE-STATUS-REASON     
             WHEN 'E'                                                   
                 MOVE 'BANKRUPT'           TO WS-CODE-STATUS-REASON     
             WHEN 'F'                                                   
                 MOVE 'CONDEMNATION'       TO WS-CODE-STATUS-REASON     
             WHEN 'G'                                                   
                 MOVE 'LOCATION'           TO WS-CODE-STATUS-REASON     
             WHEN 'H'                                                   
                 MOVE 'TAMPERING'          TO WS-CODE-STATUS-REASON     
             WHEN 'I'                                                   
                 MOVE 'FOUND OFF / LOCKED' TO WS-CODE-STATUS-REASON     
             WHEN 'J'                                                   
                 MOVE 'FOUND USING / LOCKED' TO WS-CODE-STATUS-REASON   
             WHEN 'K'                                                   
                 MOVE 'CUSTOMER REPAIRS'   TO WS-CODE-STATUS-REASON     
             WHEN 'L'                                                   
                 MOVE 'COMPANY REPAIRS'    TO WS-CODE-STATUS-REASON     
             WHEN 'M'                                                   
                 MOVE 'HOT OFF / CT METER' TO WS-CODE-STATUS-REASON     
             WHEN 'N'                                                   
                 MOVE 'NOT OFF / INACCESSIBLE'                          
                       TO WS-CODE-STATUS-REASON                         
             WHEN 'O'                                                   
                 MOVE 'CUT OFF AT POLE'    TO WS-CODE-STATUS-REASON     
             WHEN 'P'                                                   
                 MOVE 'RELEASE'            TO WS-CODE-STATUS-REASON     
             WHEN 'Q'                                                   
                 MOVE 'BROKEN INDEX'       TO WS-CODE-STATUS-REASON     
             WHEN 'R'                                                   
                 MOVE 'DNP / REAPAIRS'     TO WS-CODE-STATUS-REASON     
             WHEN 'S'                                                   
                 MOVE 'DNP / TAMPER'       TO WS-CODE-STATUS-REASON     
             WHEN 'T'                                                   
                 MOVE 'LOAD CHANGE'        TO WS-CODE-STATUS-REASON     
             WHEN 'U'                                                   
                 MOVE 'UNSPECIFIED'        TO WS-CODE-STATUS-REASON     
             WHEN 'V'                                                   
                 MOVE 'CUSTOMER CHANGE'    TO WS-CODE-STATUS-REASON     
             WHEN 'W'                                                   
                 MOVE 'OFF'                TO WS-CODE-STATUS-REASON     
             WHEN 'X'                                                   
                 MOVE 'SET INACTIVE'       TO WS-CODE-STATUS-REASON     
             WHEN 'Y'                                                   
                 MOVE 'CUSTOMER REQUEST'   TO WS-CODE-STATUS-REASON     
             WHEN 'Z'                                                   
                 MOVE 'TRAILER MOVED OFF LOT'                           
                       TO WS-CODE-STATUS-REASON                         
           END-EVALUATE.                                                
      *                                                                         
       5710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   POPULATE REPORT FIELDS                                     *          
      ****************************************************************          
      *                                                                         
       5850-POPULATE-REPORT-DET-02.                                     
      *                                                                         
           IF AT-COMPANY-NO = WS-COMP-NO-HOLD                           
              PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
           ELSE                                                         
              MOVE AT-COMPANY-NO TO WS-COMP-NO-HOLD                     
              MOVE 0 TO WS-PAGE-COUNT                                   
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE WS-FMT-ACCT-NO           TO PRT-ACCOUNT.                
           MOVE WS-CUST-NAME             TO PRT-CUSTOMER.               
           MOVE WS-TRAN-TYPE             TO PRT-TRAN-TYPE.              
           MOVE WS-METER-NO              TO PRT-METER.                  
           MOVE MC-CONSTANT              TO PRT-CONSTANT.               
           MOVE WS-CODE-UTIL-TYPE-DESC   TO PRT-UTIL-DESC.              
           MOVE WS-RATE-PLAN-NO          TO PRT-RATE.                   
           MOVE WS-MTR-STATUS-CHNG-DT    TO PRT-MTR-STATUS.             
           MOVE WS-DATE-MTR-INSTALL      TO PRT-DATE-INSTALL.           
           MOVE WS-CODE-METER-STATUS-DSC TO PRT-CODE-MTR-STATUS.        
           MOVE WS-CODE-STATUS-REASON    TO PRT-STATUS-REASON.          
      *                                                                         
           MOVE PRT-DETAIL-1 TO WS-PRT33-RECORD.                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-DETAIL-2 TO WS-PRT33-RECORD.                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-DETAIL-3 TO WS-PRT33-RECORD.                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-LINE-4 TO WS-PRT33-RECORD.                          
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-LINE-5 TO WS-PRT33-RECORD.                          
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-LINE-6 TO WS-PRT33-RECORD.                          
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-LINE-7 TO WS-PRT33-RECORD.                          
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           ADD 8 TO WS-LINE-COUNT.                                      
      *                                                                         
       5850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS NO DATA REPORT                                     *          
      ****************************************************************          
      *                                                                         
       5950-PROCESS-NODATA.                                             
      *                                                                         
           PERFORM 8200-PRINT-RPT-NO-DATA THRU 8200-EXIT.               
      *                                                                         
       5950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6990-FETCH-CUR-ACCOUNT                                      **          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * 6995-CPD99-ERROR-ROUTINE.                                   **          
      *  ERROR ROUTINE FOR CPD00099                                 **          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
            EVALUATE WS-ACTIVE-RETURN-CODE                              
            WHEN SUCCESSFUL-CALL                                        
                 CONTINUE                                               
            WHEN NOT-FOUND                                              
                 CONTINUE                                               
            WHEN WS-CPD99-DUP-ROWS                                      
                 CONTINUE                                               
            WHEN OTHER                                                  
              DISPLAY '***************PCSRP091**********************'   
              DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH              
              DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO            
              DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
              DISPLAY '***************PCSRP091**********************'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-EVALUATE.                                                
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   OPEN SPECIALTY METER CURSOR                                *          
      ****************************************************************          
      *                                                                         
       7300-OPEN-SPECIALTY-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
                OPEN SPECIALTY_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP091 ABORT **************'        
              DISPLAY '*       7300-OPEN-SPECIALTY-CSR        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP091 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   FETCH SPECIALTY METER CURSOR                               *          
      ****************************************************************          
      *                                                                         
       7310-FETCH-SPECIALTY-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH SPECIALTY_CSR                                       
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:WS-METER-NO :WS-NULL-IND1                           
                   ,:WS-CODE-UTIL-TYPE :WS-NULL-IND2                     
                   ,:WS-MTR-STATUS-CHNG-DT :WS-NULL-IND3                 
                   ,:WS-DATE-MTR-INSTALL :WS-NULL-IND4                   
                   ,:WS-CODE-METER-STATUS :WS-NULL-IND5                  
                   ,:WS-CODE-STATUS-REAS :WS-NULL-IND6                   
                   ,:WS-RATE-PLAN-NO :WS-NULL-IND7                       
                   ,:WS-LOCAL-OFFICE :WS-NULL-IND8                       
                   ,:AT-COMPANY-NO                                      
                   ,:MC-CONSTANT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP091 ABORT **************'        
              DISPLAY '*       7310-FETCH-SPECIALTY-CSR       *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP091 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CLOSE SPECIALTY METER CURSOR                               *          
      ****************************************************************          
      *                                                                         
       7320-CLOSE-SPECIALTY-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
                CLOSE SPECIALTY_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP091 ABORT **************'        
              DISPLAY '*       7320-CLOSE-SPECIALTY-CSR       *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP091 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET DATE WITH THE LAST DAY OF THE CURRENT MONTH           **          
      ****************************************************************          
      *                                                                         
       7500-GET-NEXT-DAY.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-FIX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FIX-DATE
              ) <> 0) OR (LEN(:WS-FIX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-FIX-DATE
              ), CONVERT(DATE, :WS-FIX-DATE) ) )
            INTO
              :WS-FIX-DATE2                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FIX-DATE2 =                                               
MFA-TR*            DATE(:WS-FIX-DATE) + 1 DAY                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING LAST DAY OF MONTH   **'       
              DISPLAY '**7500-GET-NEXT-DAY                    **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '**WS-FIX-DATE   = ' WS-FIX-DATE                  
              DISPLAY '**WS-FIX-DATE2  = ' WS-FIX-DATE2                 
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET COMPANY DISCRIPTION                                   *          
      ****************************************************************          
      *                                                                         
       7800-GET-COMP-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT C7.COMPANY_NAME                                    
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7                                     
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C7.COMPANY_NAME                                            
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP091 ABORT **************'        
              DISPLAY '*        7800-GET-COMP-DESC            *'        
              DISPLAY '* SQLCODE    : ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '* COMPANY NO : ' C7-COMPANY-NO                   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP091 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PRINT REPORT HEADERS.                                      *          
      ****************************************************************          
      *                                                                         
       8000-PRINT-RPT-HEADERS.                                          
      *                                                                         
           IF AT-COMPANY-NO = '01'                                      
              MOVE WS-SCEG-COMP-NAME TO PRT-COMPANY-NAME                
           ELSE                                                         
              MOVE WS-PSNC-COMP-NAME TO PRT-COMPANY-NAME                
           END-IF.                                                      
      *                                                                         
           ADD 1              TO WS-PAGE-COUNT.                         
           MOVE WS-PAGE-COUNT TO PRT-PAGE-NBR.                          
      *                                                                         
           MOVE PRT-HEADER-1  TO WS-PRT33-RECORD.                       
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1             TO WS-SKIP-LINES-NUM.                     
           MOVE PRT-HEADER-2  TO WS-PRT33-RECORD.                       
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1             TO WS-SKIP-LINES-NUM.                     
           MOVE PRT-HEADER-3  TO WS-PRT33-RECORD.                       
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE 2             TO WS-SKIP-LINES-NUM.                     
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1             TO WS-SKIP-LINES-NUM.                     
      *                                                                         
           MOVE PRT-HEADER-4  TO WS-PRT33-RECORD                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE 6             TO WS-LINE-COUNT.                         
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK PAGE OVERFLOW                                        *          
      ****************************************************************          
      *                                                                         
       8100-CHECK-PAGE-OVERFLOW.                                        
      *                                                                         
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PRINT NO DATA REPORT                                       *          
      ****************************************************************          
      *                                                                         
       8200-PRINT-RPT-NO-DATA.                                          
      *                                                                         
           IF AT-COMPANY-NO = '01'                                      
              MOVE WS-SCEG-COMP-NAME TO PRT-COMPANY-NAME                
           ELSE                                                         
              MOVE WS-PSNC-COMP-NAME TO PRT-COMPANY-NAME                
           END-IF.                                                      
      *                                                                         
           MOVE 1 TO PRT-PAGE-NBR.                                      
      *                                                                         
           MOVE PRT-HEADER-1 TO WS-PRT33-RECORD.                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1            TO WS-SKIP-LINES-NUM.                      
           MOVE PRT-HEADER-2 TO WS-PRT33-RECORD.                        
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1            TO WS-SKIP-LINES-NUM.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE 2            TO WS-SKIP-LINES-NUM.                      
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE 1            TO WS-SKIP-LINES-NUM.                      
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE PRT-NO-DATA-LINE TO WS-PRT33-RECORD.                    
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PRINT REPORT FOOTER.                                       *          
      ****************************************************************          
      *                                                                         
       8400-PRINT-RPT-FOOTER.                                           
      *                                                                         
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE PRT-FOOTER-LINE TO WS-PRT33-RECORD.                     
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           MOVE PRT-BLANK-LINE TO WS-PRT33-RECORD.                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   WRITE REPORT                                               *          
      ****************************************************************          
      *                                                                         
       8900-WRITE-REPORT.                                               
      *                                                                         
            WRITE PRT33-RECORD FROM WS-PRT33-RECORD                     
                       AFTER ADVANCING WS-SKIP-LINES-NUM.               
      *                                                                         
            INITIALIZE WS-PRT33-RECORD.                                 
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   NORMAL TERMINATION.                                        *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  6251-GET-FJC01-DATE                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  7620-START-FCSCA00                                          *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * REDUCE EMBEDDED SPACES.                                      *          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      * COPYBOOK FOR ABEND ROUTINE                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * COPY BOOK FOR MAILING ADDRESS                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * COPY BOOK TO GET COMMON DATE FROM JOB PARM                   *          
      * 6240-GET-FCA00-COMMON-DATE                                   *          
      ****************************************************************          
      *                                                                         
           COPY CPD00040.                                                       
      *                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
