       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP090.                                            
       AUTHOR. JIJU CHOVVA.                                             
       DATE-WRITTEN. DEC 2005.                                          
      ****************************************************************          
      *                SOUTH CAROLINA ELECTRIC & GAS                 *          
      *                                                              *          
      ****************************************************************          
      *                CUSTOMER INFORMATION SYSTEM                   *          
      ****************************************************************          
      *                     P R O G R A M S U M M A R Y              *          
      *                                                              *          
      *                                                              *          
      *    PURPOSE :                                                 *          
      *    TO ALERT (SECURED RATE BILLING TEAM) THAT SOME            *          
      *    ONE HAS MADE NAME CHANGE OR CUSTOMER CHANGE.              *          
      *                                                              *          
      ****************************************************************          
      *                                                              *          
      *                PROGRAM  MODIFICATION  LOG                    *          
      *                                                              *          
      *       DATE       INITIALS    REASON                          *          
      *     ----------   --------    ---------------------------     *          
      *     12/07/2005   JC91900     RE WRITING TO COBOL(CSR090)     *          
      *     10/12/2006   MC95456     ADDED FOR FETCH ONLY TO CURSOR  *          
A02823*     10/07/2010   SJ97149     ADDING REVENUE CLASS AND ALSO   *          
A02823*                  ACT001      REVENUE DISTRICT CHANGE         *          
A02823*                              REPORT                          *          
      *                                                              *          
A03082*     18 NOV 2011  RF10596     UPDATE METER CURSOR AND RATE    *          
A03082*                              CURSOR.                         *          
      *                                                              *          
A03082*      8 MAY 2012  RF10596     ADD LOCAL OFFICE TO REPORTS     *          
      *                                                              *          
A03967*     23 JUN 2012  RF10596     ADD LOCAL OFFICE TO REV REPORTS *          
      *                                                              *          
A03959*     31 DEC 2012  MS93554     CODE_METER_STATUS = 'B' CHANGED *          
      *                              TO NOW BE "BACKUP METER".       *          
      *                                                              *          
A04527*     24 JAN 2014  RF10596     ADD USER-ID TO REPORTS          *          
      *                                                              *          
A05460*     19 MAY 2016  RF10596     ADD SOLAR LOGIC                 *          
      *                                                              *          
A05460*     19 JUL 2016  RF10596     CHANGE DATE USE FOR DAILY RUNS  *          
      *                                                              *          
      ****************************************************************          
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP090'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-GENERAL-WORKING-STORAGE.                                   
A05460    05  WS-SOLAR-SW                PIC X     VALUE SPACES.        
A05460    05  WS-SOLAR-TXT               PIC X(5)  VALUE 'SOLAR'.       
A05460    05  WS-SOLAR                   PIC X(5)  VALUE SPACES.        
A05460    05  WS-SOLAR-ACCOUNT           PIC S9(13) COMP-3 VALUE ZEROS. 
A05460    05  WS-SOLAR-RATE              PIC X(3)  VALUE SPACES.        
A04527    05  WS-USER-ID                 PIC X(7)  VALUE SPACES.        
COB305    05 WS-ACCOUNT-NO-HOLD        PIC S9(13) USAGE COMP-3 VALUE 0.      
          05  WS-ACCOUNT-NO              PIC 9(13).                     
          05  WS-FMT-ACCT-NO.                                           
               10  WS-FMT-ACCT-NO-1    PIC X(1).                        
               10  FILLER              PIC X(1)    VALUE '-'.           
               10  WS-FMT-ACCT-NO-4A   PIC X(4).                        
               10  FILLER              PIC X(1)    VALUE '-'.           
               10  WS-FMT-ACCT-NO-4B   PIC X(4).                        
               10  FILLER              PIC X(1)    VALUE '-'.           
               10  WS-FMT-ACCT-NO-4C   PIC X(4).                        
          05  WS-COMMON-DATE             PIC X(10).                     
          05  WS-NODATA-NAME-01          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-NAME-26          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-METER-01         PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-METER-26         PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-CUST-01          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-CUST-26          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-FINL-01          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-FINL-26          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-RATE-01          PIC X(01) VALUE 'Y'.           
          05  WS-NODATA-RATE-26          PIC X(01) VALUE 'Y'.           
A02823    05  WS-NODATA-REV-DIST-01      PIC X(01) VALUE 'Y'.           
A02823    05  WS-NODATA-REV-DIST-26      PIC X(01) VALUE 'Y'.           
A02823    05  WS-NODATA-REV-CLASS-01     PIC X(01) VALUE 'Y'.           
A02823    05  WS-NODATA-REV-CLASS-26     PIC X(01) VALUE 'Y'.           
A02823    05  WS-DATA-FLAG               PIC X(01) VALUE 'N'.           
A02823    05  WS-SECURED-RATE-FL         PIC X(01) VALUE 'N'.           
          05  WS-RPT-PRINTED             PIC X(01) VALUE 'Y'.           
          05  WS-PREV-DATA               PIC X(40).                     
          05  WS-PREV-DATA-TEMP          PIC X(40).                     
          05  WS-CHANGED-TO              PIC X(40).                     
          05  WS-CHANGED-TO-TEMP         PIC X(40).                     
COB305    05 WS-CUSTOMER-NO        PIC S9(10) USAGE COMP-3 VALUE 0.       
          05  WS-NAME-FIRST-TIME         PIC X(01)  VALUE 'Y'.          
          05  WS-CUST-FIRST-TIME         PIC X(01)  VALUE 'Y'.          
          05  WS-CUST-NAME               PIC X(37).                     
          05  WS-ADDRESS-1               PIC X(30).                     
          05  WS-ADDRESS-2               PIC X(35).                     
          05  WS-COMP-INFO-CRSR-IND      PIC X(01).                     
          05  WS-TMP-CMP-NO              PIC X(02).                     
          05  WS-COMP-NO-HOLD            PIC X(02).                     
          05  WS-PARM-COMP-NO            PIC X(02).                     
          05  WS-METER-NO                PIC X(09).                     
          05  WS-CODE-UTIL-TYPE          PIC X(01).                     
          05  WS-CODE-UTIL-TYPE-DESC     PIC X(12).                     
          05  WS-TRAN-DESC               PIC X(01).                     
          05  WS-MTR-STATUS-CHNG-DT      PIC X(10).                     
          05  WS-DATE-MTR-INSTALL        PIC X(10).                     
          05  WS-CODE-METER-STATUS       PIC X(01).                     
          05  WS-CODE-METER-STATUS-DSC   PIC X(22).                     
          05  WS-CODE-STATUS-REAS        PIC X(01).                     
          05  WS-CODE-STATUS-REASON      PIC X(22).                     
          05  WS-RATE-PLAN-NO            PIC X(03).                     
          05  WS-TRAN-TYPE               PIC X(15).                     
          05  WS-DISP-RC                 PIC -ZZZZZZZZ9.9.              
          05  WS-LOCAL-OFFICE            PIC X(03)  VALUE ' '.          
          05  WS-RPT-NO                  PIC 9(02)  VALUE 1.            
          05  WS-LINE-COUNT              PIC 9(02)  VALUE 0.            
          05  WS-PRT33-RECORD            PIC X(132) VALUE SPACES.       
          05  WS-PAGE-COUNT              PIC 9(02)  VALUE 0.            
          05  WS-SKIP-LINES-NUM          PIC 9(02)  VALUE 0.            
          05  WS-ERR-MSG                 PIC X(40)  VALUE SPACES.       
          05  WS-SCEG-COMP-NAME          PIC X(26)  VALUE SPACES.       
          05  WS-PSNC-COMP-NAME          PIC X(26)  VALUE SPACES.       
          05  RS-RETURN-CODE             PIC S9(04) COMP VALUE 0.       
          05  RS-RETURN-CODE-DISP        PIC +Z(04).                    
          05  WS-PREMISE-NO              PIC S9(10)  USAGE COMP-3       
                                                     VALUE 0.           
       01  WS-NULL-INDICATORS.                                          
          05  WS-NULL-IND1               PIC S9(04) COMP VALUE 0.       
          05  WS-NULL-IND2               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND3               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND4               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND5               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND6               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND7               PIC S9(04) COMP VALUE +0.      
          05  WS-NULL-IND8               PIC S9(04) COMP VALUE +0.      
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                     PIC 9(02).                     
           05  WS-MM                     PIC 9(02).                     
           05  WS-SS                     PIC 9(02).                     
           05  WS-TT                     PIC 9(02).                     
      *                                                                         
A03802 01  WS-FIX-DATE                 PIC X(10).                       
A03802 01  WS-FIX-DATE2                PIC X(10).                       
      *                                                                         
A03802 01  WS-WORK-DATE.                                                
A03802     07  WS-WORK-YEAR            PIC X(4).                        
A03802     07  FILLER                  PIC X   VALUE '-'.               
A03802     07  WS-WORK-MONTH           PIC XX.                          
A03802     07  FILLER                  PIC X   VALUE '-'.               
A03802     07  WS-WORK-DAY             PIC XX.                          
      *                                                                         
A03802 01  WS-TODAY-2UNIQUE-TS         PIC X(26).                       
A05460 01  WS-YES-2UNIQUE-TS           PIC X(26).                       
      *                                                                         
A03802 01  WS-TODAY-UNIQUE-TS.                                          
A03802     05 WS-FIX-DATE-TS.                                           
A03802        07  WS-TODAY-YEAR        PIC X(4).                        
A03802        07  FILLER               PIC X   VALUE '-'.               
A03802        07  WS-TODAY-MONTH       PIC XX.                          
A03802        07  FILLER               PIC X   VALUE '-'.               
A03802        07  WS-TODAY-DAY         PIC XX.                          
A03802     05  WS-TODAY-REST           PIC X(16)                        
A03802                            VALUE '-00.00.00.000000'.             
      *                                                                         
A05460 01  WS-YES-UNIQUE-TS.                                            
A05460     05 WS-FIX-DATE2-TS.                                          
A05460        07  WS-YES-YEAR          PIC X(4).                        
A05460        07  FILLER               PIC X   VALUE '-'.               
A05460        07  WS-YES-MONTH         PIC XX.                          
A05460        07  FILLER               PIC X   VALUE '-'.               
A05460        07  WS-YES-DAY           PIC XX.                          
A05460     05  WS-YES-REST             PIC X(16)                        
A05460                            VALUE '-00.00.00.000000'.             
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-MM                  PIC X(02).                     
           05  FILLER                    PIC X(01) VALUE ':'.           
           05  WS-RT-SS                  PIC X(02).                     
      *                                                                         
       01  WS-REVENUE-MONTH.                                            
           05  WS-REV-YR                 PIC X(04).                     
           05  FILLER                    PIC X(01) VALUE '/'.           
           05  WS-REV-MTH                PIC X(02).                     
                                                                        
A05460 01  WS-CURRENT-DATE               PIC X(10) VALUE SPACES.        
                                                                        
A05460 01  WS-RUN-DATE                   PIC X(10) VALUE SPACES.        
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-01                       PIC X(02) VALUE '01'.          
          05 WS-Y                        PIC X(01) VALUE 'Y'.           
          05 WS-N                        PIC X(01) VALUE 'N'.           
          05 WS-MAX-LINES                PIC 9(02) VALUE 55.            
          05 WS-PARM1                    PIC X(04) VALUE 'DATE'.        
          05 PROGRAM-NAME                PIC X(08) VALUE 'PCSRP090'.    
          05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSRP090'.    
                                                                        
      ****************************************************************          
      *            COMMON WORKING STORAGE FOR REPORT HEADERS         *          
      ****************************************************************          
       01  WS-HEADING-LINES.                                            
           05  WS-RPT-HEADER-01.                                        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  FILLER                PIC X(09) VALUE 'PCSR090-1'.   
               10  FILLER                PIC X(37) VALUE SPACES.        
               10  P-RPT-COMPANY-NAME    PIC X(26) VALUE SPACES.        
               10  FILLER                PIC X(38) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'PAGE    : '.  
               10  P-RPT-PAGE-NO         PIC ZZ,ZZ9.                    
                                                                        
           05  WS-RPT-HEADER-02.                                        
               10  FILLER                PIC X(40) VALUE SPACES.        
               10  FILLER                PIC X(31)                      
                               VALUE 'TRANSACTIONS POSTED TO ACCOUNTS'. 
               10  FILLER                PIC X(19)                      
                               VALUE ' WITH SECURED RATES'.             
               10  FILLER                PIC X(21) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN DATE: '.  
               10  P-RPT-RUN-DATE        PIC X(10) VALUE SPACES.        
                                                                        
           05  WS-RPT-HEADER-03.                                        
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(14)                      
                                             VALUE 'REVENUE-MONTH:'.    
               10  P-RPT-COMMON-DATE     PIC X(07)  VALUE SPACES.       
               10  FILLER                PIC X(89) VALUE SPACES.        
               10  FILLER                PIC X(10)  VALUE 'RUN TIME: '. 
               10  P-RPT-RUN-TIME        PIC X(08)  VALUE SPACES.       
               10  FILLER                PIC X(02)  VALUE SPACES.       
                                                                        
           05  WS-RPT-HEADER-04.                                        
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  FILLER                PIC X(14)                      
                                             VALUE 'REVENUE-MONTH:'.    
               10  P-RPT-COMMON-DATE-04  PIC X(07)  VALUE SPACES.       
               10  FILLER                PIC X(20) VALUE SPACES.        
               10  FILLER                PIC X(26)                      
                                    VALUE ' CURRENT AS OF COMMON-DATE'. 
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-RPT-RUN-DATE-04     PIC X(10)  VALUE SPACES.       
               10  FILLER                PIC X(32) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'RUN TIME: '.  
               10  P-RPT-RUN-TIME-04     PIC X(08) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
                                                                        
           05  WS-RPT-HEADING-01.                                       
               10  FILLER                PIC X(01) VALUE SPACES.        
A03082         10  FILLER                PIC X(15)                      
A03082                                       VALUE 'ACCT NBR/LOCOFF'.   
A03082         10  FILLER                PIC X(3)  VALUE SPACES.        
               10  FILLER                PIC X(13)                      
                                             VALUE 'CUSTOMER NAME'.     
               10  FILLER                PIC X(24) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'TRANS TYPE'.  
               10  FILLER                PIC X(07) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'TRANS DESC'.  
               10  FILLER                PIC X(51) VALUE SPACES.        
                                                                        
           05  WS-RPT-HEADING-02.                                       
               10  FILLER                PIC X(01) VALUE SPACES.        
A03082         10  FILLER                PIC X(15)                      
A03082                                       VALUE 'ACCT NBR/LOCOFF'.   
A03082         10  FILLER                PIC X(3)  VALUE SPACES.        
               10  FILLER                PIC X(13)                      
                                             VALUE 'CUSTOMER NAME'.     
               10  FILLER                PIC X(26) VALUE SPACES.        
               10  FILLER                PIC X(15)                      
                                             VALUE 'SERVICE ADDRESS'.   
               10  FILLER                PIC X(19) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'TRANS TYPE'.  
               10  FILLER                PIC X(07) VALUE SPACES.        
               10  FILLER                PIC X(10) VALUE 'TRANS DESC'.  
               10  FILLER                PIC X(15) VALUE SPACES.        
                                                                        
           05  WS-RPT1-DETAIL-LINE-01.                                  
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-ACCOUNT-NO          PIC X(16) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  P-CUST-NAME           PIC X(37) VALUE SPACES.        
               10  P-TRAN-TYPE           PIC X(15) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(16)                      
                                              VALUE 'PRIOR DATA   : '.  
               10  P-PREV-DATA           PIC X(40) VALUE SPACES.        
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-02.                                  
A03082         10  FILLER                PIC X     VALUE SPACES.        
A03082         10  P-LOCOFF-1            PIC X(3)  VALUE SPACES.        
A05460         10  FILLER                PIC X(4)  VALUE SPACES.        
A05460         10  P-SOLAR-1             PIC X(5)  VALUE SPACES.        
A05460         10  FILLER                PIC X(43) VALUE SPACES.        
A04527         10  P-USER-ID-1           PIC X(7)  VALUE SPACES.        
A04527         10  FILLER                PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(16)                      
                                              VALUE 'CHANGED TO   : '.  
               10  P-WS-CHANGED-TO       PIC X(40) VALUE SPACES.        
      *                                                                         
           05  WS-RPT3-DETAIL-LINE-01.                                  
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-ACCOUNT-NO-3        PIC X(16) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  P-CUST-NAME-3         PIC X(37) VALUE SPACES.        
               10  P-TRAN-TYPE-3         PIC X(15) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                             VALUE 'CODE  UTIL TYPE : '.
               10  P-CODE-UTIL-TYPE-DESC PIC X(12) VALUE SPACES.        
               10  FILLER                PIC X(24) VALUE SPACES.        
      *                                                                         
           05  WS-RPT3-DETAIL-LINE-02.                                  
A03082         10  FILLER                PIC X     VALUE SPACES.        
A03082         10  P-LOCOFF-3            PIC X(3)  VALUE SPACES.        
A05460         10  FILLER                PIC X(4)  VALUE SPACES.        
A05460         10  P-SOLAR-3             PIC X(5)  VALUE SPACES.        
A05460         10  FILLER                PIC X(43) VALUE SPACES.        
A04527         10  P-USER-ID-3           PIC X(7)  VALUE SPACES.        
A04527         10  FILLER                PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
A03082                            VALUE 'METER NO / CONSTANT  : '.      
               10  P-METER-NO            PIC X(9)  VALUE SPACES.        
A03082         10  FILLER                PIC X(3) VALUE ' / '.          
A03082         10  P-CONSTANT            PIC 999999.999.                
A03082         10  FILLER                PIC X(14) VALUE SPACES.        
      *                                                                         
           05  WS-RPT3-DETAIL-LINE-03.                                  
               10  FILLER                PIC X(73) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                   VALUE 'RATE PLAN NO         : '.     
               10  P-RATE-PLAN-NO        PIC X(03) VALUE SPACES.        
               10  FILLER                PIC X(35) VALUE SPACES.        
                                                                        
           05  WS-RPT3-DETAIL-LINE-04.                                  
               10  FILLER                PIC X(73) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                   VALUE 'MTR STATUS CHANGE DT : '.     
               10  P-MTR-STATUS-CHNG-DT  PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(28) VALUE SPACES.        
                                                                        
           05  WS-RPT3-DETAIL-LINE-05.                                  
               10  FILLER                PIC X(73) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                   VALUE 'DATE MTR INSTALL     : '.     
               10  P-DATE-MTR-INSTALL    PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(28) VALUE SPACES.        
                                                                        
           05  WS-RPT3-DETAIL-LINE-06.                                  
               10  FILLER                PIC X(73) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                   VALUE 'METER STATUS         : '.     
               10  P-CODE-MTR-STATUS     PIC X(22).                     
               10  FILLER                PIC X(17) VALUE SPACES.        
                                                                        
           05  WS-RPT3-DETAIL-LINE-07.                                  
               10  FILLER                PIC X(73) VALUE SPACES.        
               10  FILLER                PIC X(23)                      
                                   VALUE 'METER STATUS REASON  : '.     
               10  P-CODE-STATUS-REASON  PIC X(22) VALUE SPACES.        
               10  FILLER                PIC X(17) VALUE SPACES.        
                                                                        
           05  WS-RPT4-DETAIL-LINE-01.                                  
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  P-ACCOUNT-NO-4        PIC X(16) VALUE SPACES.        
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  P-CUST-NAME-4         PIC X(37).                     
               10  FILLER                PIC X(02) VALUE SPACES.        
               10  P-ADDRESS-01          PIC X(30).                     
               10  FILLER                PIC X(04) VALUE SPACES.        
               10  P-TRAN-TYPE-4         PIC X(15).                     
               10  FILLER                PIC X(02) VALUE SPACES.        
                                                                        
           05  WS-RPT4-DETAIL-LINE-02.                                  
A03082         10  FILLER                PIC X     VALUE SPACES.        
A03082         10  P-LOCOFF-4            PIC X(3)  VALUE SPACES.        
A05460         10  FILLER                PIC X(4)  VALUE SPACES.        
A05460         10  P-SOLAR-4             PIC X(5)  VALUE SPACES.        
A05460         10  FILLER                PIC X(45) VALUE SPACES.        
               10  P-ADDRESS-02          PIC X(35).                     
               10  FILLER                PIC X(15) VALUE SPACES.        
                                                                        
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                    PIC X(52)  VALUE SPACES.       
           05  FILLER                    PIC X(31)  VALUE               
               '**** NO DATA FOR THIS RUN  ****'.                       
           05  FILLER                    PIC X(49)  VALUE SPACES.       
                                                                        
       01  WS-FOOTER-LINE.                                              
           05  FILLER                    PIC X(35)  VALUE SPACES.       
           05  FILLER                    PIC X(25)  VALUE               
               '* * * END OF REPORT * * *'.                             
           05  FILLER                    PIC X(72)  VALUE SPACES.       
                                                                        
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT                                                   *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ADDR_FORMATTED                                           *          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ADDR_FREEFORM                                             *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_COMPANY                                                   *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CSS_MT_TRN_HST_DET                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBMNHDT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CSS_MNT_TRANS_HIST                                          *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MTRD_ENVRNMT                                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_NAME                                                      *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_NAME_ACCT_XREF                                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CUST_ADDR_XREF                                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREMISE                                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_RATE_PLAN_DESC                                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT                                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ZIP_CODE                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCT_MISC_INFO                                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY                                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
A03082* CSS_MTR_CAP  MC                                             *           
      ***************************************************************           
A03082     EXEC SQL                                                             
A03082         INCLUDE TBMTRCAP                                                 
A03082     END-EXEC.                                                            
      *                                                                         
A02823*****************************************************************         
A02823* WORKING STORAGE FOR CPD00099                                  *         
A02823*****************************************************************         
A02823     EXEC SQL                                                             
A02823         INCLUDE CWS00099                                                 
A02823     END-EXEC.                                                            
A02823*                                                                         
      *****************************************************************         
      * CURSOR FOR ACCOUNTS FINALLING ON RUN DATE                     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE FINAL_CSR CURSOR FOR                              
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.PREMISE_NO                                     
                     ,AT.COMPANY_NO                                     
                     ,AT.ADDRESS_ID                                     
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
A05460          WHERE AT.ACCT_FINALED_DT  >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )         
A05460            AND AT.ACCT_FINALED_DT  <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )       
                  AND RD.SECURED_RATE_FL = 'Y'                          
                  AND AT.CODE_ACCT_STAT = 'B'                           
                  AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                 
                  AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE            
                 ORDER BY AT.COMPANY_NO                                 
                         , AT.ACCOUNT_NO                                
                     FOR READ ONLY                              
A02823                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FINAL_CSR CURSOR FOR                                      
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*         WHERE AT.ACCT_FINALED_DT  >= :WS-YES-2UNIQUE-TS                 
MFA-TR*           AND AT.ACCT_FINALED_DT  <  :WS-TODAY-2UNIQUE-TS               
MFA-TR*           AND RD.SECURED_RATE_FL = 'Y'                                  
MFA-TR*           AND AT.CODE_ACCT_STAT = 'B'                                   
MFA-TR*           AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                         
MFA-TR*           AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                    
MFA-TR*          ORDER BY AT.COMPANY_NO                                         
MFA-TR*                  , AT.ACCOUNT_NO                                        
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*          QUERYNO 7150                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR NAME CHANGE                                        *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE NAME_CSR CURSOR FOR                               
                    SELECT DISTINCT(AT.ACCOUNT_NO)                      
                          ,AT.COMPANY_NO                                
                          ,AT.LOCAL_OFFICE                              
                          ,PI.PRV_COLUMN_VALUE                          
                          ,PI.CHG_COLUMN_VALUE                          
                          ,AT.ADDRESS_ID                                
A04527                    ,PT.USER_ID                                   
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                          ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)          
                          ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)            
                          ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)            
                          ,CSS_MNT_TRANS_HIST PT WITH(READUNCOMMITTED)          
                          ,CSS_MT_TRN_HST_DET PI WITH(READUNCOMMITTED)          
A05460               WHERE PT.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )   
A05460                 AND PT.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              ) 
                       AND PT.APPL_PROGRAM_ID = 'PANEL087'              
                       AND PI.COLUMN_DESC LIKE '%NAME%'                 
                       AND RD.SECURED_RATE_FL = 'Y'                     
                       AND MN.CODE_METER_STATUS NOT IN ('J', 'K')       
                       AND PT.TRANS_HIST_SEQ_NO = PI.TRANS_HIST_SEQ_NO  
                       AND AT.CUSTOMER_NO = PT.CUSTOMER_NO              
                       AND UT.ACCOUNT_NO      = AT.ACCOUNT_NO           
                       AND MN.ACCOUNT_NO      = AT.ACCOUNT_NO           
                       AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE       
                       AND UT.IC_NO           = MN.IC_NO                
                       AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO         
                       AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE       
                     ORDER BY AT.COMPANY_NO                             
                     FOR READ ONLY                              
A02823                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NAME_CSR CURSOR FOR                                       
MFA-TR*             SELECT DISTINCT(AT.ACCOUNT_NO)                              
MFA-TR*                   ,AT.COMPANY_NO                                        
MFA-TR*                   ,AT.LOCAL_OFFICE                                      
MFA-TR*                   ,PI.PRV_COLUMN_VALUE                                  
MFA-TR*                   ,PI.CHG_COLUMN_VALUE                                  
MFA-TR*                   ,AT.ADDRESS_ID                                        
MFA-TR*                   ,PT.USER_ID                                           
MFA-TR*               FROM CSS_ACCOUNT AT                                       
MFA-TR*                   ,CSS_RATE_PLAN_DESC RD                                
MFA-TR*                   ,CSS_UTIL_ENVRNMT UT                                  
MFA-TR*                   ,CSS_MTRD_ENVRNMT MN                                  
MFA-TR*                   ,CSS_MNT_TRANS_HIST PT                                
MFA-TR*                   ,CSS_MT_TRN_HST_DET PI                                
MFA-TR*              WHERE PT.TRANS_HIST_SEQ_NO >= :WS-YES-2UNIQUE-TS           
MFA-TR*                AND PT.TRANS_HIST_SEQ_NO <  :WS-TODAY-2UNIQUE-TS         
MFA-TR*                AND PT.APPL_PROGRAM_ID = 'PANEL087'                      
MFA-TR*                AND PI.COLUMN_DESC LIKE '%NAME%'                         
MFA-TR*                AND RD.SECURED_RATE_FL = 'Y'                             
MFA-TR*                AND MN.CODE_METER_STATUS NOT IN ('J', 'K')               
MFA-TR*                AND PT.TRANS_HIST_SEQ_NO = PI.TRANS_HIST_SEQ_NO          
MFA-TR*                AND AT.CUSTOMER_NO = PT.CUSTOMER_NO                      
MFA-TR*                AND UT.ACCOUNT_NO      = AT.ACCOUNT_NO                   
MFA-TR*                AND MN.ACCOUNT_NO      = AT.ACCOUNT_NO                   
MFA-TR*                AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE               
MFA-TR*                AND UT.IC_NO           = MN.IC_NO                        
MFA-TR*                AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                 
MFA-TR*                AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE               
MFA-TR*              ORDER BY AT.COMPANY_NO                                     
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7000                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR FOR CUSTOMER NAME CHANGE                                *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE CUST_CSR CURSOR FOR                               
                SELECT AT.ACCOUNT_NO                                    
                      ,AT.COMPANY_NO                                    
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.ADDRESS_ID                                    
                      ,MI.PRV_COLUMN_VALUE                              
                      ,MI.CHG_COLUMN_VALUE                              
A04527                ,MT.USER_ID                                       
                  FROM CSS_MNT_TRANS_HIST MT WITH(READUNCOMMITTED)              
                      ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)              
                      ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
A05460           WHERE MT.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )       
A05460             AND MT.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )     
                   AND MT.APPL_PROGRAM_ID   = 'PANEL457'                
                   AND MI.COLUMN_DESC LIKE '%ACCOUNT%'                  
A05460             AND AT.ACCT_CREATE_DT >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )          
A05460             AND AT.ACCT_CREATE_DT <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )        
                   AND AT.CODE_ACCT_STAT    = 'A'                       
                   AND MN.CODE_METER_STATUS NOT IN ('J', 'K')           
                   AND RD.SECURED_RATE_FL   = 'Y'                       
                   AND MT.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO      
                   AND AT.ACCOUNT_NO        = MT.ACCOUNT_NO             
                   AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO             
                   AND MN.ACCOUNT_NO        = AT.ACCOUNT_NO             
                   AND UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE         
                   AND UT.IC_NO             = MN.IC_NO                  
                   AND UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO           
                   AND UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE         
                  ORDER BY AT.COMPANY_NO                                
                  FOR READ ONLY                                 
A02823                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST_CSR CURSOR FOR                                       
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.ADDRESS_ID                                            
MFA-TR*               ,MI.PRV_COLUMN_VALUE                                      
MFA-TR*               ,MI.CHG_COLUMN_VALUE                                      
MFA-TR*               ,MT.USER_ID                                               
MFA-TR*           FROM CSS_MNT_TRANS_HIST MT                                    
MFA-TR*               ,CSS_MT_TRN_HST_DET MI                                    
MFA-TR*               ,CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_RATE_PLAN_DESC RD                                    
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_MTRD_ENVRNMT MN                                      
MFA-TR*          WHERE MT.TRANS_HIST_SEQ_NO >= :WS-YES-2UNIQUE-TS               
MFA-TR*            AND MT.TRANS_HIST_SEQ_NO <  :WS-TODAY-2UNIQUE-TS             
MFA-TR*            AND MT.APPL_PROGRAM_ID   = 'PANEL457'                        
MFA-TR*            AND MI.COLUMN_DESC LIKE '%ACCOUNT%'                          
MFA-TR*            AND AT.ACCT_CREATE_DT >= :WS-YES-2UNIQUE-TS                  
MFA-TR*            AND AT.ACCT_CREATE_DT <  :WS-TODAY-2UNIQUE-TS                
MFA-TR*            AND AT.CODE_ACCT_STAT    = 'A'                               
MFA-TR*            AND MN.CODE_METER_STATUS NOT IN ('J', 'K')                   
MFA-TR*            AND RD.SECURED_RATE_FL   = 'Y'                               
MFA-TR*            AND MT.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO              
MFA-TR*            AND AT.ACCOUNT_NO        = MT.ACCOUNT_NO                     
MFA-TR*            AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO                     
MFA-TR*            AND MN.ACCOUNT_NO        = AT.ACCOUNT_NO                     
MFA-TR*            AND UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE                 
MFA-TR*            AND UT.IC_NO             = MN.IC_NO                          
MFA-TR*            AND UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO                   
MFA-TR*            AND UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE                 
MFA-TR*           ORDER BY AT.COMPANY_NO                                        
MFA-TR*           FOR FETCH ONLY  WITH UR                                       
MFA-TR*           QUERYNO 7050                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR FOR METER CHANGE USING SERVICE ORDER TABLES           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE METER_CSR CURSOR FOR                               
              SELECT DISTINCT AC.ACCOUNT_NO                             
                    ,AC.ADDRESS_ID                                      
                    ,MN.METER_NO                                        
                    ,MN.CODE_UTIL_TYPE                                  
                    ,MN.MTR_STATUS_CHNG_DT                              
                    ,MN.DATE_MTR_INSTALL                                
                    ,MN.CODE_METER_STATUS                               
                    ,MN.CODE_STATUS_REAS                                
                    ,UT.RATE_PLAN_NO                                    
                    ,AC.LOCAL_OFFICE                                    
                    ,AC.COMPANY_NO                                      
A03082              ,MC.CONSTANT                                        
A04527              ,VW.USER_ID_UPDT_BY                                 
               FROM  CSS_ACCOUNT AC WITH(READUNCOMMITTED)                       
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
                    ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
                    ,CSS_SO_UPDATE VW WITH(READUNCOMMITTED)                     
                    ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
A03082              ,CSS_MTR_CAP MC WITH(READUNCOMMITTED)                       
               WHERE RD.SECURED_RATE_FL = 'Y'                           
               AND AC.CODE_ACCT_STAT = 'A'                              
               AND ( UT.ACCOUNT_NO = VO.ACCOUNT_NO                      
                      OR UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR)           
               AND VO.ORDER_STATE_CD = 'Z'                              
               AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                  
A05460         AND VW.UPDATE_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )             
A05460         AND VW.UPDATE_DATETIME <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )           
               AND VW.ORDER_STATE_CD = 'A'                              
               AND VW.SERV_ORDER_STATUS = '60'                          
               AND VW.PANEL_NO = '090'                                  
               AND CAST(VO.COMPLETED_DATETIME AS DATE) = 
           MN.MTR_STATUS_CHNG_DT  
               AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                  
               AND VI.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                
               AND VI.IC_NO = UT.IC_NO                                  
               AND VI.WORK_TYPE_CD NOT IN ('   ', 'RDO')                
               AND AC.ACCOUNT_NO = MN.ACCOUNT_NO                        
               AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                        
               AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                
A03082         AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                
               AND MN.IC_NO = UT.IC_NO                                  
A03082         AND MN.METER_NO  = MC.METER_NO                           
A03082         AND MN.REG_ID_NO = MC.REG_ID_NO                          
               AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                    
               AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE               
A03082         AND AC.COMPANY_NO      = MC.COMPANY_NO                   
             ORDER BY AC.COMPANY_NO, AC.ACCOUNT_NO                      
               FOR READ ONLY                                    
A02823                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE METER_CSR CURSOR FOR                                       
MFA-TR*       SELECT DISTINCT AC.ACCOUNT_NO                                     
MFA-TR*             ,AC.ADDRESS_ID                                              
MFA-TR*             ,MN.METER_NO                                                
MFA-TR*             ,MN.CODE_UTIL_TYPE                                          
MFA-TR*             ,MN.MTR_STATUS_CHNG_DT                                      
MFA-TR*             ,MN.DATE_MTR_INSTALL                                        
MFA-TR*             ,MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.CODE_STATUS_REAS                                        
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,AC.LOCAL_OFFICE                                            
MFA-TR*             ,AC.COMPANY_NO                                              
MFA-TR*             ,MC.CONSTANT                                                
MFA-TR*             ,VW.USER_ID_UPDT_BY                                         
MFA-TR*        FROM  CSS_ACCOUNT AC                                             
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                                      
MFA-TR*             ,CSS_SO_DATA VO                                             
MFA-TR*             ,CSS_SO_UPDATE VW                                           
MFA-TR*             ,CSS_SO_ORDER_INST VI                                       
MFA-TR*             ,CSS_MTR_CAP MC                                             
MFA-TR*        WHERE RD.SECURED_RATE_FL = 'Y'                                   
MFA-TR*        AND AC.CODE_ACCT_STAT = 'A'                                      
MFA-TR*        AND ( UT.ACCOUNT_NO = VO.ACCOUNT_NO                              
MFA-TR*               OR UT.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR)                   
MFA-TR*        AND VO.ORDER_STATE_CD = 'Z'                                      
MFA-TR*        AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                          
MFA-TR*        AND VW.UPDATE_DATETIME >= :WS-YES-2UNIQUE-TS                     
MFA-TR*        AND VW.UPDATE_DATETIME <  :WS-TODAY-2UNIQUE-TS                   
MFA-TR*        AND VW.ORDER_STATE_CD = 'A'                                      
MFA-TR*        AND VW.SERV_ORDER_STATUS = '60'                                  
MFA-TR*        AND VW.PANEL_NO = '090'                                          
MFA-TR*        AND DATE(VO.COMPLETED_DATETIME) = MN.MTR_STATUS_CHNG_DT          
MFA-TR*        AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                          
MFA-TR*        AND VI.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                        
MFA-TR*        AND VI.IC_NO = UT.IC_NO                                          
MFA-TR*        AND VI.WORK_TYPE_CD NOT IN ('   ', 'RDO')                        
MFA-TR*        AND AC.ACCOUNT_NO = MN.ACCOUNT_NO                                
MFA-TR*        AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                                
MFA-TR*        AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                        
MFA-TR*        AND MN.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                        
MFA-TR*        AND MN.IC_NO = UT.IC_NO                                          
MFA-TR*        AND MN.METER_NO  = MC.METER_NO                                   
MFA-TR*        AND MN.REG_ID_NO = MC.REG_ID_NO                                  
MFA-TR*        AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                            
MFA-TR*        AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                       
MFA-TR*        AND AC.COMPANY_NO      = MC.COMPANY_NO                           
MFA-TR*      ORDER BY AC.COMPANY_NO, AC.ACCOUNT_NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A03082* CURSOR FOR RATE CHANGE                                       *          
      ****************************************************************          
      *                                                                         
A03082     EXEC SQL                                                     
A03082       DECLARE RATE_CSR CURSOR FOR                                
A03082         SELECT DISTINCT(AT.ACCOUNT_NO)                           
A03082               ,AT.COMPANY_NO                                     
A03082               ,AT.LOCAL_OFFICE                                   
A03082               ,AT.ADDRESS_ID                                     
A03082               ,MI.PRV_COLUMN_VALUE                               
A03082               ,MI.CHG_COLUMN_VALUE                               
A04527               ,MH.USER_ID                                        
A03082           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
A03082               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
A03082               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
A03082               ,CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
A03082               ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)               
A05460          WHERE MH.APPL_PROGRAM_ID IN ('PANEL051', 'CSR04642')    
A05460          AND MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )          
A05460          AND MH.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )        
A03082          AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO         
A03082          AND MI.COLUMN_DESC LIKE '%RATE PLAN NO%'                
A03082          AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO                  
A03082          AND UT.ACCOUNT_NO      = AT.ACCOUNT_NO                  
A03082          AND                                                     
A03082              ((UT.RATE_PLAN_NO  = RD.RATE_PLAN_NO                
A03082          AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE              
A03082          AND RD.SECURED_RATE_FL = 'Y')                           
A03082           OR                                                     
A03082             (CIS.SUBSTR3(MI.PRV_COLUMN_VALUE,1,3) = 
           RD.RATE_PLAN_NO   
A03082          AND RD.SECURED_RATE_FL = 'Y'                            
A03082          AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE))            
A03082          ORDER BY AT.COMPANY_NO                                  
A03082          FOR READ ONLY                                   
A03082                                                      
A03082     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE RATE_CSR CURSOR FOR                                        
MFA-TR*        SELECT DISTINCT(AT.ACCOUNT_NO)                                   
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,MI.PRV_COLUMN_VALUE                                       
MFA-TR*              ,MI.CHG_COLUMN_VALUE                                       
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MNT_TRANS_HIST MH                                     
MFA-TR*              ,CSS_MT_TRN_HST_DET MI                                     
MFA-TR*         WHERE MH.APPL_PROGRAM_ID IN ('PANEL051', 'CSR04642')            
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO >= :WS-YES-2UNIQUE-TS                  
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO <  :WS-TODAY-2UNIQUE-TS                
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                 
MFA-TR*         AND MI.COLUMN_DESC LIKE '%RATE PLAN NO%'                        
MFA-TR*         AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO                          
MFA-TR*         AND UT.ACCOUNT_NO      = AT.ACCOUNT_NO                          
MFA-TR*         AND                                                             
MFA-TR*             ((UT.RATE_PLAN_NO  = RD.RATE_PLAN_NO                        
MFA-TR*         AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                      
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y')                                   
MFA-TR*          OR                                                             
MFA-TR*            (SUBSTR(MI.PRV_COLUMN_VALUE,1,3) = RD.RATE_PLAN_NO           
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y'                                    
MFA-TR*         AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE))                    
MFA-TR*         ORDER BY AT.COMPANY_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
A02823****************************************************************          
A02823* CURSOR FOR REV DISTRICT CHG                                  *          
A02823****************************************************************          
      *                                                                         
A02823     EXEC SQL                                                     
A02823        DECLARE REV_DIST_CSR CURSOR FOR                           
A02823          SELECT MH.ACCOUNT_NO                                    
A02823                ,PR.PREMISE_NO                                    
A02823                ,PR.COMPANY_NO                                    
A02823                ,MH.DATE_TRANS                                    
A02823                ,MI.PRV_COLUMN_VALUE                              
A02823                ,MI.CHG_COLUMN_VALUE                              
A03967                ,AT.LOCAL_OFFICE                                  
A04527                ,MH.USER_ID                                       
A02823          FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
A02823               ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)               
A02823               ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
A03967               ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
A02823        WHERE MH.APPL_PROGRAM_ID   = 'PANEL077'                   
A05460          AND MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )          
A05460          AND MH.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )        
A02823          AND MI.COLUMN_DESC       = 'REV DISTRICT'               
A02823          AND MH.PREMISE_NO        = PR.PREMISE_NO                
A02823          AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO         
A03967          AND MH.ACCOUNT_NO        = AT.ACCOUNT_NO                
A02823          ORDER BY PR.COMPANY_NO                                  
A02823          FOR READ ONLY                                   
A02823                                                      
A02823     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REV_DIST_CSR CURSOR FOR                                   
MFA-TR*         SELECT MH.ACCOUNT_NO                                            
MFA-TR*               ,PR.PREMISE_NO                                            
MFA-TR*               ,PR.COMPANY_NO                                            
MFA-TR*               ,MH.DATE_TRANS                                            
MFA-TR*               ,MI.PRV_COLUMN_VALUE                                      
MFA-TR*               ,MI.CHG_COLUMN_VALUE                                      
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,MH.USER_ID                                               
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*              ,CSS_MT_TRN_HST_DET MI                                     
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*       WHERE MH.APPL_PROGRAM_ID   = 'PANEL077'                           
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO >= :WS-YES-2UNIQUE-TS                  
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO <  :WS-TODAY-2UNIQUE-TS                
MFA-TR*         AND MI.COLUMN_DESC       = 'REV DISTRICT'                       
MFA-TR*         AND MH.PREMISE_NO        = PR.PREMISE_NO                        
MFA-TR*         AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                 
MFA-TR*         AND MH.ACCOUNT_NO        = AT.ACCOUNT_NO                        
MFA-TR*         ORDER BY PR.COMPANY_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7810                                                    
MFA-TR*    END-EXEC.                                                            
A02823******************************************************************        
A02823* CURSOR FOR REVENUE CLASS CHG                                   *        
A02823******************************************************************        
A02823     EXEC SQL                                                     
A02823        DECLARE REV_CLASS_CSR CURSOR FOR                          
A02823          SELECT  AT.ACCOUNT_NO                                   
A02823                 ,AT.COMPANY_NO                                   
A02823                 ,AT.LOCAL_OFFICE                                 
A02823                 ,AT.ADDRESS_ID                                   
A02823                 ,MI.PRV_COLUMN_VALUE                             
A02823                 ,MI.CHG_COLUMN_VALUE                             
A04527                 ,MH.USER_ID                                      
A02823            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
A02823                 ,CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
A02823                 ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)             
A05460           WHERE MH.APPL_PROGRAM_ID IN ('PANEL051', 'CSR04642')   
A05460             AND MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-YES-2UNIQUE-TS
              )       
A05460             AND MH.TRANS_HIST_SEQ_NO <  CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAY-2UNIQUE-TS
              )     
A02823             AND MI.COLUMN_DESC = 'REVENUE CLASS'                 
A02823             AND AT.ACCOUNT_NO = MH.ACCOUNT_NO                    
A02823             AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO      
A02823             AND EXISTS(SELECT UT.ACCOUNT_NO                      
A02823                       FROM CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                 
A02823                            ,CSS_UTIL_ENVRNMT UT
                           WITH(READUNCOMMITTED)                  
A02823                  WHERE UT.ACCOUNT_NO       = AT.ACCOUNT_NO       
A02823                   AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO     
A02823                   AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE   
A02823                   AND RD.SECURED_RATE_FL   = 'Y')                
A02823                   ORDER BY AT.COMPANY_NO                         
A02823                   FOR READ ONLY                          
A02823                                                      
A02823     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REV_CLASS_CSR CURSOR FOR                                  
MFA-TR*         SELECT  AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.ADDRESS_ID                                           
MFA-TR*                ,MI.PRV_COLUMN_VALUE                                     
MFA-TR*                ,MI.CHG_COLUMN_VALUE                                     
MFA-TR*                ,MH.USER_ID                                              
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*                ,CSS_MNT_TRANS_HIST MH                                   
MFA-TR*                ,CSS_MT_TRN_HST_DET MI                                   
MFA-TR*          WHERE MH.APPL_PROGRAM_ID IN ('PANEL051', 'CSR04642')           
MFA-TR*            AND MH.TRANS_HIST_SEQ_NO >= :WS-YES-2UNIQUE-TS               
MFA-TR*            AND MH.TRANS_HIST_SEQ_NO <  :WS-TODAY-2UNIQUE-TS             
MFA-TR*            AND MI.COLUMN_DESC = 'REVENUE CLASS'                         
MFA-TR*            AND AT.ACCOUNT_NO = MH.ACCOUNT_NO                            
MFA-TR*            AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO              
MFA-TR*            AND EXISTS(SELECT UT.ACCOUNT_NO                              
MFA-TR*                      FROM CSS_RATE_PLAN_DESC RD                         
MFA-TR*                           ,CSS_UTIL_ENVRNMT UT                          
MFA-TR*                 WHERE UT.ACCOUNT_NO       = AT.ACCOUNT_NO               
MFA-TR*                  AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO             
MFA-TR*                  AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
MFA-TR*                  AND RD.SECURED_RATE_FL   = 'Y')                        
MFA-TR*                  ORDER BY AT.COMPANY_NO                                 
MFA-TR*                  FOR FETCH ONLY WITH UR                                 
MFA-TR*                  QUERYNO 7840                                           
MFA-TR*    END-EXEC.                                                            
       01  WS-END                        PIC X(40) VALUE                
           'WORKING STORAGE FOR CSRP090  ENDS HERE  '.                  
                                                                        
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
                                                                        
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
A05460* INITIALIZATION - OPEN FILES, GET CURRENT DATE AND TIME         *        
A05460*   GET COMPANY DESCRIPTION                                      *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           MOVE '01'                         TO AT-COMPANY-NO,          
                                                C7-COMPANY-NO.          
                                                                        
           PERFORM 7800-GET-COMP-DESC          THRU 7800-EXIT.          
           MOVE C7-COMPANY-NAME              TO WS-SCEG-COMP-NAME.      
                                                                        
           MOVE '26'                         TO AT-COMPANY-NO,          
                                                C7-COMPANY-NO.          
           PERFORM 7800-GET-COMP-DESC          THRU 7800-EXIT.          
           MOVE C7-COMPANY-NAME              TO WS-PSNC-COMP-NAME.      
      *                                                                         
A05460     PERFORM 7080-GET-CURRENT THRU 7080-EXIT.                     
           MOVE WS-CURRENT-DATE              TO WS-COMMON-DATE.         
           MOVE WS-COMMON-DATE               TO P-RPT-RUN-DATE-04       
A05460                                          P-RPT-RUN-DATE.         
      *                                                                         
           MOVE WS-COMMON-DATE(1:4)          TO WS-REV-YR.              
           MOVE WS-COMMON-DATE(6:2)          TO WS-REV-MTH.             
           MOVE WS-REVENUE-MONTH             TO P-RPT-COMMON-DATE       
                                                P-RPT-COMMON-DATE-04.   
                                                                        
           ACCEPT WS-CURRENT-TIME            FROM TIME.                 
           MOVE WS-HH                        TO WS-RT-HH.               
           MOVE WS-MM                        TO WS-RT-MM.               
           MOVE WS-SS                        TO WS-RT-SS.               
           MOVE WS-RUN-TIME                  TO P-RPT-RUN-TIME          
                                                P-RPT-RUN-TIME-04.      
      *                                                                         
A03802     MOVE WS-COMMON-DATE  TO WS-FIX-DATE                          
A03802                             WS-FIX-DATE2.                        
      *                                                                         
A03802     PERFORM 7500-GET-YESTERDAY THRU 7500-EXIT.                   
      *                                                                         
A03802     MOVE WS-FIX-DATE   TO WS-WORK-DATE.                          
A03802     MOVE WS-WORK-YEAR  TO WS-TODAY-YEAR.                         
A03802     MOVE WS-WORK-MONTH TO WS-TODAY-MONTH.                        
A03802     MOVE WS-WORK-DAY   TO WS-TODAY-DAY.                          
      *                                                                         
A03802     MOVE WS-FIX-DATE2  TO WS-WORK-DATE.                          
A05460     MOVE WS-WORK-YEAR  TO WS-YES-YEAR.                           
A05460     MOVE WS-WORK-MONTH TO WS-YES-MONTH.                          
A05460     MOVE WS-WORK-DAY   TO WS-YES-DAY.                            
      *                                                                         
A03802     MOVE WS-TODAY-UNIQUE-TS TO WS-TODAY-2UNIQUE-TS.              
A05460     MOVE WS-YES-UNIQUE-TS   TO WS-YES-2UNIQUE-TS.                
      *                                                                         
A03802     DISPLAY 'WS-COMMON-DATE      = ' WS-COMMON-DATE.             
A03802     DISPLAY 'WS-TODAY-2UNIQUE-TS = ' WS-TODAY-2UNIQUE-TS.        
A05460     DISPLAY 'WS-YES-2UNIQUE-TS   = ' WS-YES-2UNIQUE-TS.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-MAIN-PROCESS-PARA.                                        *        
      ******************************************************************        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
A03082     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
           PERFORM 5000-PROCESS-NAME-CHANGE      THRU 5000-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
           PERFORM 5100-PROCESS-CUST-NAME-CHANGE THRU 5100-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
           PERFORM 5200-PROCESS-METER-CHANGE     THRU 5200-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
           PERFORM 5300-PROCESS-FINALED-ACCTS    THRU 5300-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
           PERFORM 5400-PROCESS-RATE-CHANGE      THRU 5400-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
A02823     PERFORM 5410-PROCESS-REV-CLASS-CHG    THRU 5410-EXIT.        
                                                                        
A03967     MOVE SPACES TO WS-LOCAL-OFFICE.                              
A04527     MOVE SPACES TO WS-USER-ID.                                   
A02823     PERFORM 5510-PROCESS-REV-DIST-CHG     THRU 5510-EXIT.        
                                                                        
           IF WS-NODATA-NAME-01 = 'Y' AND                               
              WS-NODATA-CUST-01 = 'Y' AND                               
              WS-NODATA-FINL-01 = 'Y' AND                               
              WS-NODATA-RATE-01 = 'Y' AND                               
A02823        WS-NODATA-METER-01 = 'Y' AND                              
A02823        WS-NODATA-REV-DIST-01 = 'Y' AND                           
A02823        WS-NODATA-REV-CLASS-01 = 'Y' THEN                         
              MOVE '01'                     TO AT-COMPANY-NO            
              MOVE AT-COMPANY-NO            TO WS-COMP-NO-HOLD          
              PERFORM 5950-PROCESS-NODATA   THRU 5950-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-NODATA-NAME-26  = 'Y' AND                              
              WS-NODATA-CUST-26  = 'Y' AND                              
              WS-NODATA-FINL-26  = 'Y' AND                              
              WS-NODATA-RATE-26  = 'Y' AND                              
A02823        WS-NODATA-METER-26 = 'Y' AND                              
A02823        WS-NODATA-REV-DIST-26 = 'Y' AND                           
A02823        WS-NODATA-REV-CLASS-26 = 'Y' THEN                         
              MOVE '26'                     TO AT-COMPANY-NO            
              MOVE AT-COMPANY-NO            TO WS-COMP-NO-HOLD          
              PERFORM 5950-PROCESS-NODATA   THRU 5950-EXIT              
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-PROCESS-NAME-CHANGE                                       *        
      ******************************************************************        
       5000-PROCESS-NAME-CHANGE.                                        
                                                                        
           MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
           MOVE SPACES                       TO WS-COMP-NO-HOLD.        
           MOVE 'NAME CHANGE'                TO WS-TRAN-TYPE.           
           MOVE 1                            TO WS-RPT-NO.              
                                                                        
           PERFORM 7000-OPEN-NAME-CSR        THRU 7000-EXIT.            
                                                                        
           PERFORM 7010-FETCH-NAME-CSR       THRU 7010-EXIT.            
      *                                                                         
           PERFORM 5500-GENERATE-REPORT-1    THRU 5500-EXIT             
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.   
                                                                        
           PERFORM 7020-CLOSE-NAME-CSR       THRU 7020-EXIT.            
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-PROCESS-CUST-NAME-CHANGE.                                 *        
      ******************************************************************        
       5100-PROCESS-CUST-NAME-CHANGE.                                   
                                                                        
           MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
           MOVE SPACES                       TO WS-COMP-NO-HOLD.        
           MOVE 'CUSTOMER CHANGE'            TO WS-TRAN-TYPE.           
           MOVE 2                            TO WS-RPT-NO.              
                                                                        
           PERFORM 7050-OPEN-CUST-CSR        THRU 7050-EXIT.            
                                                                        
           PERFORM 7060-FETCH-CUST-CSR       THRU 7060-EXIT.            
      *                                                                         
           PERFORM 5550-GENERATE-REPORT-2    THRU 5550-EXIT             
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
           PERFORM 7070-CLOSE-CUST-CSR       THRU 7070-EXIT.            
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5200-PROCESS-METER-CHANGE.                                     *        
      ******************************************************************        
       5200-PROCESS-METER-CHANGE.                                       
                                                                        
           MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
           MOVE 'METER CHANGE'               TO WS-TRAN-TYPE.           
           MOVE SPACES                       TO WS-COMP-NO-HOLD.        
           MOVE 3                            TO WS-RPT-NO.              
                                                                        
           PERFORM 7100-OPEN-METER-CSR       THRU 7100-EXIT.            
                                                                        
           PERFORM 7110-FETCH-METER-CSR      THRU 7110-EXIT.            
      *                                                                         
           PERFORM 5600-GENERATE-REPORT-3    THRU 5600-EXIT             
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
                                                                        
           PERFORM 7120-CLOSE-METER-CSR      THRU 7120-EXIT.            
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5300-PROCESS-FINALED-ACCTS                                     *        
      ******************************************************************        
       5300-PROCESS-FINALED-ACCTS.                                      
                                                                        
           MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
           MOVE 'FINAL ACCOUNT'              TO WS-TRAN-TYPE.           
           MOVE SPACES                       TO WS-COMP-NO-HOLD.        
           MOVE 4                            TO WS-RPT-NO.              
                                                                        
           PERFORM 7150-OPEN-FINAL-CSR       THRU 7150-EXIT.            
           PERFORM 7160-FETCH-FINAL-CSR      THRU 7160-EXIT.            
      *                                                                         
           PERFORM 5650-GENERATE-REPORT-4    THRU 5650-EXIT             
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
           PERFORM 7170-CLOSE-FINAL-CSR      THRU 7170-EXIT.            
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5400-PROCESS-RATE-CHANGE                                       *        
      ******************************************************************        
       5400-PROCESS-RATE-CHANGE.                                        
                                                                        
           MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
           MOVE SPACES                       TO WS-COMP-NO-HOLD.        
           MOVE 'RATE PLAN NO'               TO WS-TRAN-TYPE.           
           MOVE 5                            TO WS-RPT-NO.              
                                                                        
           PERFORM 7200-OPEN-RATE-CSR        THRU 7200-EXIT.            
                                                                        
           PERFORM 7210-FETCH-RATE-CSR       THRU 7210-EXIT.            
      *                                                                         
           PERFORM 5700-GENERATE-REPORT-5    THRU 5700-EXIT             
                              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.  
                                                                        
           PERFORM 7220-CLOSE-RATE-CSR       THRU 7220-EXIT.            
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5410-PROCESS-REV-CLASS-CHG                                     *        
A02823******************************************************************        
A02823 5410-PROCESS-REV-CLASS-CHG.                                      
                                                                        
A02823     MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
A02823     MOVE SPACES                       TO WS-COMP-NO-HOLD.        
A02823     MOVE 'REV CLASS CHANGE'           TO WS-TRAN-TYPE.           
A02823     MOVE 6                            TO WS-RPT-NO.              
                                                                        
A02823     PERFORM 7840-OPEN-REV-CLASS-CSR   THRU 7840-EXIT.            
                                                                        
A02823     PERFORM 7850-FETCH-REV-CLASS-CSR  THRU 7850-EXIT.            
      *                                                                         
A02823     PERFORM 5953-GENERATE-REPORT-6    THRU 5953-EXIT             
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.   
                                                                        
A02823     PERFORM 7860-CLOSE-REV-CLASS-CSR  THRU 7860-EXIT.            
                                                                        
A02823 5410-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5510-PROCESS-REV-DIST-CHG                                      *        
A02823******************************************************************        
A02823 5510-PROCESS-REV-DIST-CHG.                                       
                                                                        
A02823     MOVE 0                            TO WS-ACCOUNT-NO-HOLD.     
A02823     MOVE SPACES                       TO WS-COMP-NO-HOLD.        
A02823     MOVE 'REV DIST CHANGE'            TO WS-TRAN-TYPE.           
A02823     MOVE 7                            TO WS-RPT-NO.              
A02823     MOVE 'N'                          TO WS-DATA-FLAG.           
                                                                        
A02823     PERFORM 7810-OPEN-REV-DIST-CSR    THRU 7810-EXIT.            
                                                                        
A02823     PERFORM 7820-FETCH-REV-DIST-CSR   THRU 7820-EXIT.            
      *                                                                         
A02823     PERFORM 5951-GENERATE-REPORT-7    THRU 5951-EXIT             
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.   
                                                                        
A02823     PERFORM 7830-CLOSE-REV-DIST-CSR   THRU 7830-EXIT.            
                                                                        
A02823 5510-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5500-GENERATE-REPORT-1                                         *        
      ******************************************************************        
       5500-GENERATE-REPORT-1.                                          
                                                                        
           IF WS-ACCOUNT-NO-HOLD NOT = AT-ACCOUNT-NO                    
              MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-HOLD      
              PERFORM 3000-GET-ADDRESS              THRU 3000-EXIT      
              PERFORM 5800-POPULATE-REPORT-DET-01   THRU 5800-EXIT      
              PERFORM 7010-FETCH-NAME-CSR           THRU 7010-EXIT      
           ELSE                                                         
              MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-HOLD      
              PERFORM 7010-FETCH-NAME-CSR           THRU 7010-EXIT      
           END-IF.                                                      
                                                                        
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N'                        TO WS-NODATA-NAME-01       
           ELSE                                                         
             MOVE 'N'                        TO WS-NODATA-NAME-26       
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER         THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5550-GENERATE-REPORT-2                                         *        
      ******************************************************************        
       5550-GENERATE-REPORT-2.                                          
                                                                        
           IF WS-ACCOUNT-NO-HOLD NOT = AT-ACCOUNT-NO                    
             MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-HOLD       
             PERFORM 3000-GET-ADDRESS             THRU 3000-EXIT        
             PERFORM 5800-POPULATE-REPORT-DET-01  THRU 5800-EXIT        
             PERFORM 7060-FETCH-CUST-CSR          THRU 7060-EXIT        
           ELSE                                                         
             MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO-HOLD    
             PERFORM 7060-FETCH-CUST-CSR       THRU 7060-EXIT           
           END-IF.                                                      
                                                                        
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N'                        TO WS-NODATA-CUST-01       
           ELSE                                                         
             MOVE 'N'                        TO WS-NODATA-CUST-26       
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER         THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5600-GENERATE-REPORT-3.                                        *        
      ******************************************************************        
       5600-GENERATE-REPORT-3.                                          
                                                                        
           IF WS-ACCOUNT-NO-HOLD NOT = AT-ACCOUNT-NO                    
             MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO-HOLD      
             PERFORM 3000-GET-ADDRESS               THRU 3000-EXIT      
             PERFORM 5710-EVALUATE-PARA             THRU 5710-EXIT      
             PERFORM 5850-POPULATE-REPORT-DET-02    THRU 5850-EXIT      
             PERFORM 7110-FETCH-METER-CSR           THRU 7110-EXIT      
           ELSE                                                         
             MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO-HOLD    
             PERFORM 7110-FETCH-METER-CSR      THRU 7110-EXIT           
           END-IF.                                                      
                                                                        
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N'                        TO WS-NODATA-METER-01      
           ELSE                                                         
             MOVE 'N'                        TO WS-NODATA-METER-26      
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER         THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5650-GENERATE-REPORT-4.                                        *        
      ******************************************************************        
       5650-GENERATE-REPORT-4.                                          
                                                                        
           IF WS-ACCOUNT-NO-HOLD NOT = AT-ACCOUNT-NO                    
             MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-HOLD       
             PERFORM 3000-GET-ADDRESS              THRU 3000-EXIT       
             PERFORM 5900-POPULATE-REPORT-DET-03   THRU 5900-EXIT       
             PERFORM 7160-FETCH-FINAL-CSR          THRU 7160-EXIT       
           ELSE                                                         
              MOVE AT-ACCOUNT-NO                 TO WS-ACCOUNT-NO-HOLD  
              PERFORM 7160-FETCH-FINAL-CSR         THRU 7160-EXIT       
           END-IF.                                                      
                                                                        
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N'                        TO WS-NODATA-FINL-01       
           ELSE                                                         
             MOVE 'N'                        TO WS-NODATA-FINL-26       
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER         THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
       5650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5700-GENERATE-REPORT-5.                                        *        
      ******************************************************************        
       5700-GENERATE-REPORT-5.                                          
                                                                        
           IF WS-ACCOUNT-NO-HOLD NOT = AT-ACCOUNT-NO                    
             MOVE AT-ACCOUNT-NO                 TO WS-ACCOUNT-NO-HOLD   
             PERFORM 3000-GET-ADDRESS              THRU 3000-EXIT       
             PERFORM 5800-POPULATE-REPORT-DET-01   THRU 5800-EXIT       
             PERFORM 7210-FETCH-RATE-CSR           THRU 7210-EXIT       
           ELSE                                                         
              MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO-HOLD   
              PERFORM 7210-FETCH-RATE-CSR       THRU 7210-EXIT          
           END-IF.                                                      
                                                                        
           IF AT-COMPANY-NO = '01'                                      
             MOVE 'N'                        TO WS-NODATA-RATE-01       
           ELSE                                                         
             MOVE 'N'                        TO WS-NODATA-RATE-26       
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             PERFORM 8400-PRINT-RPT-FOOTER         THRU 8400-EXIT       
           END-IF.                                                      
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5710-EVALUATE-PARA.                                            *        
      ******************************************************************        
       5710-EVALUATE-PARA.                                              
                                                                        
           EVALUATE WS-CODE-UTIL-TYPE                                   
            WHEN 'G'                                                    
                 MOVE 'GAS'                  TO WS-CODE-UTIL-TYPE-DESC  
            WHEN 'E'                                                    
                 MOVE 'ELECTRIC'             TO WS-CODE-UTIL-TYPE-DESC  
            WHEN 'U'                                                    
                 MOVE 'UTIILITY'             TO WS-CODE-UTIL-TYPE-DESC  
           END-EVALUATE.                                                
                                                                        
           EVALUATE WS-CODE-METER-STATUS                                
             WHEN '0'                                                   
               MOVE 'INSTALLED/KVAR'         TO WS-CODE-METER-STATUS-DSC
             WHEN '1'                                                   
               MOVE 'INSTALLED/KVAR I MONTH' TO WS-CODE-METER-STATUS-DSC
             WHEN 'A'                                                   
               MOVE 'ACTIVE/NORMAL BILLING'  TO WS-CODE-METER-STATUS-DSC
             WHEN 'B'                                                   
A03959         MOVE 'BACKUP METER'           TO WS-CODE-METER-STATUS-DSC
             WHEN 'I'                                                   
               MOVE 'INSTALLED'              TO WS-CODE-METER-STATUS-DSC
             WHEN 'J'                                                   
               MOVE 'INACTIVE/TURNED OFF'    TO WS-CODE-METER-STATUS-DSC
             WHEN 'K'                                                   
               MOVE 'REMOVED'                TO WS-CODE-METER-STATUS-DSC
           END-EVALUATE.                                                
                                                                        
           EVALUATE WS-CODE-STATUS-REAS                                 
             WHEN '0'                                                   
                 MOVE 'COMMISSION REQUEST'   TO WS-CODE-STATUS-REASON   
             WHEN '1'                                                   
                 MOVE 'FIRE'                 TO WS-CODE-STATUS-REASON   
             WHEN '2'                                                   
                 MOVE 'UNAUTHORIZED USE'     TO WS-CODE-STATUS-REASON   
             WHEN '3'                                                   
                 MOVE 'PERIODIC TEST'        TO WS-CODE-STATUS-REASON   
             WHEN '4'                                                   
                 MOVE 'SAMPLE TEST'          TO WS-CODE-STATUS-REASON   
             WHEN '5'                                                   
                 MOVE 'STOPPED METER'        TO WS-CODE-STATUS-REASON   
             WHEN '6'                                                   
                 MOVE 'SERVICE ABANDONED'    TO WS-CODE-STATUS-REASON   
             WHEN '7'                                                   
                 MOVE 'SERVICE LINE REMOVED' TO WS-CODE-STATUS-REASON   
             WHEN '8'                                                   
                 MOVE 'METER SONP'           TO WS-CODE-STATUS-REASON   
             WHEN 'A'                                                   
                 MOVE 'NORMAL'               TO WS-CODE-STATUS-REASON   
             WHEN 'B'                                                   
                 MOVE 'NON-PAYMENT'          TO WS-CODE-STATUS-REASON   
             WHEN 'C'                                                   
                 MOVE 'SEASONAL'             TO WS-CODE-STATUS-REASON   
             WHEN 'D'                                                   
                 MOVE 'FORCED OFF'           TO WS-CODE-STATUS-REASON   
             WHEN 'E'                                                   
                 MOVE 'BANKRUPT'             TO WS-CODE-STATUS-REASON   
             WHEN 'F'                                                   
                 MOVE 'CONDEMNATION'         TO WS-CODE-STATUS-REASON   
             WHEN 'G'                                                   
                 MOVE 'LOCATION'             TO WS-CODE-STATUS-REASON   
             WHEN 'H'                                                   
                 MOVE 'TAMPERING'            TO WS-CODE-STATUS-REASON   
             WHEN 'I'                                                   
                 MOVE 'FOUND OFF / LOCKED'   TO WS-CODE-STATUS-REASON   
             WHEN 'J'                                                   
                 MOVE 'FOUND USING / LOCKED' TO WS-CODE-STATUS-REASON   
             WHEN 'K'                                                   
                 MOVE 'CUSTOMER REPAIRS'     TO WS-CODE-STATUS-REASON   
             WHEN 'L'                                                   
                 MOVE 'COMPANY REPAIRS'      TO WS-CODE-STATUS-REASON   
             WHEN 'M'                                                   
                 MOVE 'HOT OFF / CT METER'   TO WS-CODE-STATUS-REASON   
             WHEN 'N'                                                   
                 MOVE 'NOT OFF / INACCESSIBLE'                          
                                             TO WS-CODE-STATUS-REASON   
             WHEN 'O'                                                   
                 MOVE 'CUT OFF AT POLE'      TO WS-CODE-STATUS-REASON   
             WHEN 'P'                                                   
                 MOVE 'RELEASE'              TO WS-CODE-STATUS-REASON   
             WHEN 'Q'                                                   
                 MOVE 'BROKEN INDEX'         TO WS-CODE-STATUS-REASON   
             WHEN 'R'                                                   
                 MOVE 'DNP / REAPAIRS'       TO WS-CODE-STATUS-REASON   
             WHEN 'S'                                                   
                 MOVE 'DNP / TAMPER'         TO WS-CODE-STATUS-REASON   
             WHEN 'T'                                                   
                 MOVE 'LOAD CHANGE'          TO WS-CODE-STATUS-REASON   
             WHEN 'U'                                                   
                 MOVE 'UNSPECIFIED'          TO WS-CODE-STATUS-REASON   
             WHEN 'V'                                                   
                 MOVE 'CUSTOMER CHANGE'      TO WS-CODE-STATUS-REASON   
             WHEN 'W'                                                   
                 MOVE 'OFF'                  TO WS-CODE-STATUS-REASON   
             WHEN 'X'                                                   
                 MOVE 'SET INACTIVE'         TO WS-CODE-STATUS-REASON   
             WHEN 'Y'                                                   
                 MOVE 'CUSTOMER REQUEST'     TO WS-CODE-STATUS-REASON   
             WHEN 'Z'                                                   
                 MOVE 'TRAILER MOVED OFF LOT'                           
                                             TO WS-CODE-STATUS-REASON   
           END-EVALUATE.                                                
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5800-POPULATE-REPORT-DET.                                      *        
      ******************************************************************        
       5800-POPULATE-REPORT-DET-01.                                     
                                                                        
           IF AT-COMPANY-NO NOT = WS-COMP-NO-HOLD                       
              MOVE AT-COMPANY-NO              TO WS-COMP-NO-HOLD        
              MOVE 0                          TO WS-PAGE-COUNT          
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           ELSE                                                         
              PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
           END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
           MOVE WS-FMT-ACCT-NO               TO P-ACCOUNT-NO.           
A03082     MOVE WS-LOCAL-OFFICE              TO P-LOCOFF-1.             
A05460     MOVE WS-SOLAR                     TO P-SOLAR-1.              
           MOVE WS-CUST-NAME                 TO P-CUST-NAME.            
           MOVE WS-TRAN-TYPE                 TO P-TRAN-TYPE.            
           MOVE WS-PREV-DATA                 TO P-PREV-DATA.            
           MOVE WS-CHANGED-TO                TO P-WS-CHANGED-TO.        
A04527     MOVE WS-USER-ID                   TO P-USER-ID-1.            
                                                                        
           MOVE WS-RPT1-DETAIL-LINE-01       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT1-DETAIL-LINE-02       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-BLANK-LINE                TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           ADD 3                             TO WS-LINE-COUNT.          
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5850-POPULATE-REPORT-DET-02.                                   *        
      ******************************************************************        
       5850-POPULATE-REPORT-DET-02.                                     
                                                                        
           IF AT-COMPANY-NO NOT = WS-COMP-NO-HOLD                       
              MOVE AT-COMPANY-NO              TO WS-COMP-NO-HOLD        
              MOVE 0                          TO WS-PAGE-COUNT          
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           ELSE                                                         
              PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
           END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
           MOVE WS-FMT-ACCT-NO               TO P-ACCOUNT-NO-3.         
A03082     MOVE WS-LOCAL-OFFICE              TO P-LOCOFF-3.             
A05460     MOVE WS-SOLAR                     TO P-SOLAR-3.              
A04527     MOVE WS-USER-ID                   TO P-USER-ID-3.            
           MOVE WS-CUST-NAME                 TO P-CUST-NAME-3.          
           MOVE WS-TRAN-TYPE                 TO P-TRAN-TYPE-3.          
           MOVE WS-METER-NO                  TO P-METER-NO.             
A03082     MOVE MC-CONSTANT                  TO P-CONSTANT.             
           MOVE WS-CODE-UTIL-TYPE-DESC       TO P-CODE-UTIL-TYPE-DESC.  
           MOVE WS-RATE-PLAN-NO              TO P-RATE-PLAN-NO.         
           MOVE WS-MTR-STATUS-CHNG-DT        TO P-MTR-STATUS-CHNG-DT.   
           MOVE WS-DATE-MTR-INSTALL          TO P-DATE-MTR-INSTALL.     
           MOVE WS-CODE-METER-STATUS-DSC     TO P-CODE-MTR-STATUS.      
           MOVE WS-CODE-STATUS-REASON        TO P-CODE-STATUS-REASON.   
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-01       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-02       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-03       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-04       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-05       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-06       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT3-DETAIL-LINE-07       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-BLANK-LINE                TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           ADD 8                             TO WS-LINE-COUNT.          
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5900-POPULATE-REPORT-DET-03.                                   *        
      ******************************************************************        
       5900-POPULATE-REPORT-DET-03.                                     
                                                                        
           IF AT-COMPANY-NO NOT = WS-COMP-NO-HOLD                       
              MOVE AT-COMPANY-NO              TO WS-COMP-NO-HOLD        
              MOVE 0                          TO WS-PAGE-COUNT          
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           ELSE                                                         
              PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
           END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
           MOVE WS-FMT-ACCT-NO               TO P-ACCOUNT-NO-4.         
A03082     MOVE WS-LOCAL-OFFICE              TO P-LOCOFF-4.             
A05460     MOVE WS-SOLAR                     TO P-SOLAR-4.              
           MOVE WS-CUST-NAME                 TO P-CUST-NAME-4.          
           MOVE WS-ADDRESS-1                 TO P-ADDRESS-01.           
           MOVE WS-ADDRESS-2                 TO P-ADDRESS-02.           
           MOVE WS-TRAN-TYPE                 TO P-TRAN-TYPE-4           
                                                                        
           MOVE WS-RPT4-DETAIL-LINE-01       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-RPT4-DETAIL-LINE-02       TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           MOVE WS-BLANK-LINE                TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
           ADD 8                             TO WS-LINE-COUNT.          
                                                                        
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5950-PROCESS-NODATA.                                           *        
      ******************************************************************        
       5950-PROCESS-NODATA.                                             
                                                                        
           MOVE 2                             TO WS-RPT-NO.             
                                                                        
           PERFORM 8200-PRINT-RPT-NO-DATA  THRU 8200-EXIT.              
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5951-GENERATE-REPORT-7                                         *        
A02823******************************************************************        
A02823 5951-GENERATE-REPORT-7.                                          
                                                                        
A02823     INITIALIZE AT-ACCOUNT-NO,                                    
A02823                WS-PREMISE-NO,                                    
A02823                WS-CPD99-ACCOUNT-NO                               
A02823     IF MH-ACCOUNT-NO = ZERO THEN                                 
A02823        MOVE PR-PREMISE-NO                  TO WS-CPD99-PREMISE-NO
A02823                                               WS-PREMISE-NO      
A02823        PERFORM 6990-FETCH-CUR-ACCOUNT      THRU 6990-EXIT        
A02823        MOVE WS-CPD99-ACCOUNT-NO            TO AT-ACCOUNT-NO      
A02823     ELSE                                                         
A02823        MOVE MH-ACCOUNT-NO                  TO AT-ACCOUNT-NO      
A02823     END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
A02823     IF AT-ACCOUNT-NO NOT = ZERO THEN                             
A02823        MOVE 'N'                            TO WS-SECURED-RATE-FL 
A02823        MOVE AT-ACCOUNT-NO                  TO UT-ACCOUNT-NO      
A02823        PERFORM 7870-CHK-SECURED-RATE-FLAG    THRU 7870-EXIT      
A02823        IF WS-SECURED-RATE-FL = 'Y' THEN                          
A02823           MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-HOLD   
A02823           MOVE PR-COMPANY-NO             TO AT-COMPANY-NO        
A02823           IF AT-COMPANY-NO = '01'                                
A02823              MOVE 'N'                    TO WS-NODATA-REV-DIST-01
A02823           ELSE                                                   
A02823              MOVE 'N'                    TO WS-NODATA-REV-DIST-26
A02823           END-IF                                                 
A02823           MOVE 'Y'                       TO WS-NAME-ONLY-SW      
A02823           PERFORM 3100-GET-ADDRESS       THRU 3100-EXIT          
A02823           MOVE 'N'                       TO WS-NAME-ONLY-SW      
A02823           PERFORM 5952-POPULATE-REPORT-DET-07 THRU 5952-EXIT     
A02823           PERFORM 7820-FETCH-REV-DIST-CSR     THRU 7820-EXIT     
A02823           MOVE 'Y'                            TO WS-DATA-FLAG    
A02823           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A02823              PERFORM 8400-PRINT-RPT-FOOTER  THRU 8400-EXIT       
A02823           END-IF                                                 
A02823        ELSE                                                      
A02823           MOVE PR-COMPANY-NO                  TO AT-COMPANY-NO   
A02823           IF AT-COMPANY-NO = '01'                                
A02823              MOVE 'N'                    TO WS-NODATA-REV-DIST-01
A02823           ELSE                                                   
A02823              MOVE 'N'                    TO WS-NODATA-REV-DIST-26
A02823           END-IF                                                 
A02823           PERFORM 7820-FETCH-REV-DIST-CSR   THRU 7820-EXIT       
A02823           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A02823              IF WS-DATA-FLAG = 'Y' THEN                          
A02823                 PERFORM 8400-PRINT-RPT-FOOTER  THRU 8400-EXIT    
A02823              END-IF                                              
A02823           END-IF                                                 
A02823        END-IF                                                    
A02823     ELSE                                                         
A02823        MOVE PR-COMPANY-NO                  TO AT-COMPANY-NO      
A02823        IF AT-COMPANY-NO = '01'                                   
A02823           MOVE 'N'                       TO WS-NODATA-REV-DIST-01
A02823        ELSE                                                      
A02823           MOVE 'N'                       TO WS-NODATA-REV-DIST-26
A02823        END-IF                                                    
A02823        PERFORM 7820-FETCH-REV-DIST-CSR   THRU 7820-EXIT          
A02823        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A02823           IF WS-DATA-FLAG = 'Y' THEN                             
A02823             PERFORM 8400-PRINT-RPT-FOOTER  THRU 8400-EXIT        
A02823           END-IF                                                 
A02823        END-IF                                                    
A02823     END-IF.                                                      
A02823                                                                  
A02823 5951-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5952-POPULATE-REPORT-DET-07                                    *        
A02823******************************************************************        
A02823 5952-POPULATE-REPORT-DET-07.                                     
                                                                        
A02823     IF AT-COMPANY-NO NOT = WS-COMP-NO-HOLD                       
A02823        MOVE AT-COMPANY-NO               TO WS-COMP-NO-HOLD       
A02823        MOVE 0                           TO WS-PAGE-COUNT         
A02823        PERFORM 8000-PRINT-RPT-HEADERS   THRU 8000-EXIT           
A02823     ELSE                                                         
A02823        PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
A02823     END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
A02823     MOVE WS-FMT-ACCT-NO                 TO P-ACCOUNT-NO.         
A02823     MOVE WS-CUST-NAME                   TO P-CUST-NAME.          
A02823     MOVE WS-TRAN-TYPE                   TO P-TRAN-TYPE.          
A02823     MOVE WS-PREV-DATA                   TO P-PREV-DATA.          
A02823     MOVE WS-CHANGED-TO                  TO P-WS-CHANGED-TO.      
A03967     MOVE WS-LOCAL-OFFICE                TO P-LOCOFF-1.           
A05460     MOVE WS-SOLAR                       TO P-SOLAR-1.            
A04527     MOVE WS-USER-ID                     TO P-USER-ID-1.          
                                                                        
A02823     MOVE WS-RPT1-DETAIL-LINE-01         TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE WS-RPT1-DETAIL-LINE-02         TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE WS-BLANK-LINE                  TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     ADD 3                               TO WS-LINE-COUNT.        
                                                                        
A02823 5952-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5953-GENERATE-REPORT-6                                         *        
A02823******************************************************************        
A02823 5953-GENERATE-REPORT-6.                                          
                                                                        
A02823     MOVE 'N'                            TO WS-SECURED-RATE-FL.   
A02823     MOVE AT-ACCOUNT-NO                  TO WS-ACCOUNT-NO-HOLD.   
A02823     MOVE 'Y'                            TO WS-NAME-ONLY-SW.      
A02823     PERFORM 3100-GET-ADDRESS            THRU 3100-EXIT.          
A02823     PERFORM 5954-POPULATE-REPORT-DET-06 THRU 5954-EXIT.          
A02823     PERFORM 7850-FETCH-REV-CLASS-CSR    THRU 7850-EXIT.          
A02823     MOVE 'N'                            TO WS-NAME-ONLY-SW.      
A02823                                                                  
A02823     IF AT-COMPANY-NO = '01'                                      
A02823        MOVE 'N'                      TO WS-NODATA-REV-CLASS-01   
A02823     ELSE                                                         
A02823        MOVE 'N'                      TO WS-NODATA-REV-CLASS-26   
A02823     END-IF.                                                      
A02823                                                                  
A02823     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A02823        PERFORM 8400-PRINT-RPT-FOOTER      THRU 8400-EXIT         
A02823     END-IF.                                                      
A02823                                                                  
A02823 5953-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823* 5954-POPULATE-REPORT-DET-06                                    *        
A02823******************************************************************        
A02823 5954-POPULATE-REPORT-DET-06.                                     
                                                                        
A02823     IF AT-COMPANY-NO NOT = WS-COMP-NO-HOLD                       
A02823        MOVE AT-COMPANY-NO               TO WS-COMP-NO-HOLD       
A02823        MOVE 0                           TO WS-PAGE-COUNT         
A02823        PERFORM 8000-PRINT-RPT-HEADERS   THRU 8000-EXIT           
A02823     ELSE                                                         
A02823        PERFORM 8100-CHECK-PAGE-OVERFLOW THRU 8100-EXIT           
A02823     END-IF                                                       
      *                                                                         
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
A05460     PERFORM 7890-CHECK-SOLAR THRU 7890-EXIT.                     
A05460     IF WS-SOLAR-SW = WS-Y                                        
A05460        MOVE WS-SOLAR-TXT TO WS-SOLAR                             
A05460     ELSE                                                         
A05460        MOVE SPACES TO WS-SOLAR                                   
A05460     END-IF.                                                      
A05460     MOVE SPACES TO WS-SOLAR-SW.                                  
      *                                                                         
A02823     MOVE WS-FMT-ACCT-NO                 TO P-ACCOUNT-NO.         
A02823     MOVE WS-CUST-NAME                   TO P-CUST-NAME.          
A02823     MOVE WS-TRAN-TYPE                   TO P-TRAN-TYPE.          
A02823     MOVE WS-PREV-DATA                   TO P-PREV-DATA.          
A02823     MOVE WS-CHANGED-TO                  TO P-WS-CHANGED-TO.      
A03967     MOVE WS-LOCAL-OFFICE                TO P-LOCOFF-1.           
A05460     MOVE WS-SOLAR                       TO P-SOLAR-1.            
A04527     MOVE WS-USER-ID                     TO P-USER-ID-1.          
                                                                        
A02823     MOVE WS-RPT1-DETAIL-LINE-01         TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE WS-RPT1-DETAIL-LINE-02         TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE WS-BLANK-LINE                  TO WS-PRT33-RECORD.      
A02823     PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     ADD 3                               TO WS-LINE-COUNT.        
                                                                        
A02823 5954-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
       3000-GET-ADDRESS.                                                
                                                                        
           MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NO(1:1)           TO WS-FMT-ACCT-NO-1.       
           MOVE WS-ACCOUNT-NO(2:4)           TO WS-FMT-ACCT-NO-4A.      
           MOVE WS-ACCOUNT-NO(6:4)           TO WS-FMT-ACCT-NO-4B.      
           MOVE WS-ACCOUNT-NO(10:4)          TO WS-FMT-ACCT-NO-4C.      
           MOVE WS-PREMISE-NO                TO AT-PREMISE-NO.          
           MOVE ' '                          TO WS-CUST-NAME.           
           MOVE ' '                          TO WS-ADDRESS-1.           
           MOVE ' '                          TO WS-ADDRESS-2.           
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS    THRU 4000-EXIT.            
           MOVE WS-CUSTOMER-NAME             TO WS-CUST-NAME.           
           MOVE 'F'                          TO WS-MAIL-ADDR-TYPE.      
           PERFORM 4025-DETERMINE-ADDRESS    THRU 4025-EXIT.            
           PERFORM 4030-LOAD-NAME-ADDR       THRU 4030-EXIT.            
           MOVE WS-PR-STREET                 TO WS-ADDRESS-1.           
           MOVE WS-PR-ADDR-CITY-STATE-ZIP    TO WS-ADDRESS-2.           
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02823 3100-GET-ADDRESS.                                                
A02823                                                                  
A02823     MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO.          
A02823     MOVE WS-ACCOUNT-NO(1:1)           TO WS-FMT-ACCT-NO-1.       
A02823     MOVE WS-ACCOUNT-NO(2:4)           TO WS-FMT-ACCT-NO-4A.      
A02823     MOVE WS-ACCOUNT-NO(6:4)           TO WS-FMT-ACCT-NO-4B.      
A02823     MOVE WS-ACCOUNT-NO(10:4)          TO WS-FMT-ACCT-NO-4C.      
A02823     MOVE WS-PREMISE-NO                TO AT-PREMISE-NO.          
A02823     MOVE ' '                          TO WS-CUST-NAME.           
A02823     MOVE ' '                          TO WS-ADDRESS-1.           
A02823     MOVE ' '                          TO WS-ADDRESS-2.           
A02823*                                                                         
A02823     PERFORM 4000-MAIL-NAME-ADDRESS    THRU 4000-EXIT.            
A02823     MOVE WS-CUSTOMER-NAME             TO WS-CUST-NAME.           
A02823                                                                  
A02823 3100-EXIT.                                                       
A02823     EXIT.                                                        
A02823                                                                  
A02823******************************************************************        
A02823* 6990-FETCH-CUR-ACCOUNT                                        **        
A02823*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.            **        
A02823******************************************************************        
A02823     EXEC SQL                                                             
A02823         INCLUDE CPDCA099                                                 
A02823     END-EXEC.                                                            
A02823*                                                                         
A02823******************************************************************        
A02823* 6995-CPD99-ERROR-ROUTINE.                                     **        
A02823*  ERROR ROUTINE FOR CPD00099                                   **        
A02823******************************************************************        
A02823*                                                                         
A02823 6995-CPD99-ERROR-ROUTINE.                                        
A02823*                                                                         
A02823      EVALUATE WS-ACTIVE-RETURN-CODE                              
A02823      WHEN SUCCESSFUL-CALL                                        
A02823           CONTINUE                                               
A02823      WHEN NOT-FOUND                                              
A02823           CONTINUE                                               
A02823      WHEN WS-CPD99-DUP-ROWS                                      
A02823           CONTINUE                                               
A02823      WHEN OTHER                                                  
A02823        DISPLAY '***************PCSRP090**********************'   
A02823        DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH              
A02823        DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO            
A02823        DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
A02823        DISPLAY '***************PCSRP090**********************'   
A02823        PERFORM 9900-ABEND          THRU 9900-EXIT                
A02823     END-EVALUATE.                                                
A02823*                                                                         
A02823 6995-EXIT.                                                       
A02823     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-NAME-CSR.                                            *        
      ******************************************************************        
       7000-OPEN-NAME-CSR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN NAME_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7000-OPEN-NAME-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-FETCH-NAME-CSR                                            *        
      ******************************************************************        
       7010-FETCH-NAME-CSR.                                             
                                                                        
           EXEC SQL                                                     
                FETCH NAME_CSR                                          
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:WS-LOCAL-OFFICE                                  
                     ,:WS-PREV-DATA                                     
                     ,:WS-CHANGED-TO                                    
                     ,:AT-ADDRESS-ID                                    
A04527               ,:WS-USER-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7010-FETCH-NAME-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-CLOSE-NAME-CSR                                            *        
      ******************************************************************        
       7020-CLOSE-NAME-CSR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE NAME_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7020-CLOSE-NAME-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-OPEN-CUST-CSR                                             *        
      ******************************************************************        
       7050-OPEN-CUST-CSR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN CUST_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7050-OPEN-CUST-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-FETCH-CUST-CSR                                            *        
      ******************************************************************        
       7060-FETCH-CUST-CSR.                                             
                                                                        
           EXEC SQL                                                     
                FETCH CUST_CSR                                          
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:WS-LOCAL-OFFICE                                  
                     ,:AT-ADDRESS-ID                                    
                     ,:WS-PREV-DATA                                     
                     ,:WS-CHANGED-TO                                    
A04527               ,:WS-USER-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7060-FETCH-CUST-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-CLOSE-CUST-CSR                                            *        
      ******************************************************************        
       7070-CLOSE-CUST-CSR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE CUST_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7070-CLOSE-CUST-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05460** GET CURRENT DATE FOR HEADER RECORD                         **          
A05460****************************************************************          
      *                                                                         
A05460 7080-GET-CURRENT.                                                
      *                                                                         
A05460     EXEC SQL                                                     
A05460        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05460        CONTINUE                                                  
A05460     ELSE                                                         
A05460        DISPLAY '******** PCSRP090 ABORT ******'                  
A05460        DISPLAY '** 7080-GET-CURRENT         **'                  
A05460        DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE          
A05460        DISPLAY '** PROCESSING TERMINATED    **'                  
A05460        DISPLAY '******************************'                  
A05460        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05460     END-IF.                                                      
      *                                                                         
A05460 7080-EXIT.                                                       
A05460     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-METER-CSR.                                           *        
      ******************************************************************        
       7100-OPEN-METER-CSR.                                             
                                                                        
           EXEC SQL                                                     
                OPEN METER_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7100-OPEN-METER-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-FETCH-METER-CSR.                                          *        
      ******************************************************************        
       7110-FETCH-METER-CSR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH METER_CSR                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:WS-METER-NO :WS-NULL-IND1                           
                   ,:WS-CODE-UTIL-TYPE :WS-NULL-IND2                     
                   ,:WS-MTR-STATUS-CHNG-DT :WS-NULL-IND3                 
                   ,:WS-DATE-MTR-INSTALL :WS-NULL-IND4                   
                   ,:WS-CODE-METER-STATUS :WS-NULL-IND5                  
                   ,:WS-CODE-STATUS-REAS :WS-NULL-IND6                   
                   ,:WS-RATE-PLAN-NO :WS-NULL-IND7                       
                   ,:WS-LOCAL-OFFICE :WS-NULL-IND8                       
                   ,:AT-COMPANY-NO                                      
A03082             ,:MC-CONSTANT                                        
A04527             ,:WS-USER-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7110-FETCH-METER-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-CLOSE-METER-CSR.                                          *        
      ******************************************************************        
       7120-CLOSE-METER-CSR.                                            
                                                                        
           EXEC SQL                                                     
                CLOSE METER_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7120-CLOSE-METER-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7150-OPEN-FINAL-CSR.                                           *        
      ******************************************************************        
       7150-OPEN-FINAL-CSR.                                             
                                                                        
           EXEC SQL                                                     
                OPEN FINAL_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7150-OPEN-FINAL-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7160-FETCH-FINAL-CSR.                                          *        
      ******************************************************************        
       7160-FETCH-FINAL-CSR.                                            
                                                                        
           EXEC SQL                                                     
                FETCH FINAL_CSR                                         
                 INTO :AT-ACCOUNT-NO                                    
                     ,:WS-LOCAL-OFFICE                                  
                     ,:WS-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:AT-ADDRESS-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7160-FETCH-FINAL-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7170-CLOSE-FINAL-CSR.                                          *        
      ******************************************************************        
       7170-CLOSE-FINAL-CSR.                                            
                                                                        
           EXEC SQL                                                     
                CLOSE FINAL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7170-CLOSE-FINAL-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPEN RATE CURSOR                                             *          
      ****************************************************************          
      *                                                                         
       7200-OPEN-RATE-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
                OPEN RATE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7200-OPEN-RATE-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH RATE CURSOR                                           *          
      ****************************************************************          
      *                                                                         
       7210-FETCH-RATE-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
                FETCH RATE_CSR                                          
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:WS-LOCAL-OFFICE                                  
                     ,:AT-ADDRESS-ID                                    
                     ,:WS-PREV-DATA                                     
                     ,:WS-CHANGED-TO                                    
A04527               ,:WS-USER-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*       7210-FETCH-RATE-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE RATE CURSOR                                           *          
      ****************************************************************          
      *                                                                         
       7220-CLOSE-RATE-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
                CLOSE RATE_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7220-CLOSE-RATE-CSR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05460**  USE CURRENT DATE TO GET THE DAY BEFORE CURRENT DATE       **          
      ****************************************************************          
      *                                                                         
A03802 7500-GET-YESTERDAY.                                              
      *                                                                         
A03802     EXEC SQL                                                     
A03802        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-FIX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FIX-DATE
              ) <> 0) OR (LEN(:WS-FIX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-FIX-DATE
              ), CONVERT(DATE, :WS-FIX-DATE) ) )
            INTO
              :WS-FIX-DATE2                           
A03802     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FIX-DATE2 =                                               
MFA-TR*            DATE(:WS-FIX-DATE) - 1 DAY                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A03802     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A03802     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03802        NEXT SENTENCE                                             
A03802     ELSE                                                         
A03802        DISPLAY '*****************************************'       
A03802        DISPLAY '**ERROR RETRIEVING LAST DAY OF MONTH   **'       
A03802        DISPLAY '**7500-GET-YESTERDAY                    **'      
A03802        DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A03802        DISPLAY '**WS-FIX-DATE   = ' WS-FIX-DATE                  
A03802        DISPLAY '**WS-FIX-DATE2  = ' WS-FIX-DATE2                 
A03802        DISPLAY '*****************************************'       
A03802        PERFORM 9900-ABEND THRU 9900-EXIT                         
A03802     END-IF.                                                      
      *                                                                         
A03802 7500-EXIT.                                                       
A03802     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *  7800-GET-COMP-DESC                                          *          
      ****************************************************************          
       7800-GET-COMP-DESC.                                              
                                                                        
           EXEC SQL                                                     
              SELECT C7.COMPANY_NAME                                    
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7                                     
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
A02823                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C7.COMPANY_NAME                                            
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSRP090 ABORT **************'        
              DISPLAY '*        7800-GET-COMP-DESC            *'        
              DISPLAY '* SQLCODE    : ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '* COMPANY NO : ' C7-COMPANY-NO                   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP090 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7810-OPEN-REV-DIST-CSR                                         *        
A02823******************************************************************        
A02823 7810-OPEN-REV-DIST-CSR.                                          
                                                                        
A02823     EXEC SQL                                                     
A02823          OPEN REV_DIST_CSR                                       
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*     7810-OPEN-REV-DIST-CSR           *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
                                                                        
A02823 7810-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7820-FETCH-REV-DIST-CSR                                        *        
A02823******************************************************************        
A02823 7820-FETCH-REV-DIST-CSR.                                         
                                                                        
A02823     EXEC SQL                                                     
A02823          FETCH REV_DIST_CSR                                      
A02823           INTO :MH-ACCOUNT-NO                                    
A02823               ,:PR-PREMISE-NO                                    
A02823               ,:PR-COMPANY-NO                                    
A02823               ,:MH-DATE-TRANS                                    
A02823               ,:WS-PREV-DATA                                     
A02823               ,:WS-CHANGED-TO                                    
A03967               ,:WS-LOCAL-OFFICE                                  
A04527               ,:WS-USER-ID                                       
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*   7820-FETCH-REV-DIST-CSR            *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
A02823                                                                  
A02823 7820-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7830-CLOSE-REV-DIST-CSR                                        *        
A02823******************************************************************        
A02823 7830-CLOSE-REV-DIST-CSR.                                         
                                                                        
A02823     EXEC SQL                                                     
A02823          CLOSE REV_DIST_CSR                                      
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*    7830-CLOSE-REV-DIST-CSR           *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
                                                                        
A02823 7830-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7840-OPEN-REV-CLASS-CSR                                        *        
A02823******************************************************************        
A02823 7840-OPEN-REV-CLASS-CSR.                                         
                                                                        
A02823     EXEC SQL                                                     
A02823          OPEN REV_CLASS_CSR                                      
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*     7840-OPEN-REV-CLASS-CSR          *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* COMMON DATE    : ' WS-COMMON-DATE              
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
                                                                        
A02823 7840-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7850-FETCH-REV-CLASS-CSR                                       *        
A02823******************************************************************        
A02823 7850-FETCH-REV-CLASS-CSR.                                        
                                                                        
A02823     EXEC SQL                                                     
A02823          FETCH REV_CLASS_CSR                                     
A02823           INTO  :AT-ACCOUNT-NO                                   
A02823                ,:AT-COMPANY-NO                                   
A02823                ,:WS-LOCAL-OFFICE                                 
A02823                ,:AT-ADDRESS-ID                                   
A02823                ,:WS-PREV-DATA                                    
A02823                ,:WS-CHANGED-TO                                   
A04527                ,:WS-USER-ID                                      
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.     
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*   7850-FETCH-REV-CLASS-CSR           *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
A02823                                                                  
A02823 7850-EXIT.                                                       
A02823     EXIT.                                                        
                                                                        
A02823******************************************************************        
A02823*                                                                *        
A02823* 7860-CLOSE-REV-CLASS-CSR                                       *        
A02823******************************************************************        
A02823 7860-CLOSE-REV-CLASS-CSR.                                        
                                                                        
A02823     EXEC SQL                                                     
A02823          CLOSE REV_CLASS_CSR                                     
A02823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02823     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02823        NEXT SENTENCE                                             
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*    7860-CLOSE-REV-CLASS-CSR          *'        
A02823        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
                                                                        
A02823 7860-EXIT.                                                       
A02823     EXIT.                                                        
A02823****************************************************************          
A02823*  7870-CHK-SECURED-RATE-FLAG                                  *          
A02823****************************************************************          
A02823 7870-CHK-SECURED-RATE-FLAG.                                      
A02823                                                                  
A02823     EXEC SQL                                                     
A02823          SELECT TOP(1) 'Y'                                              
A02823            INTO :WS-SECURED-RATE-FL                              
A02823            FROM  CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
A02823                 ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
A02823           WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
A02823             AND RD.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE            
A02823             AND RD.RATE_PLAN_NO   = UT.RATE_PLAN_NO              
A02823             AND RD.SECURED_RATE_FL = 'Y'                         
A02823                                       
A02823     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-SECURED-RATE-FL                                      
MFA-TR*           FROM  CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                                   
MFA-TR*          WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*            AND RD.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                    
MFA-TR*            AND RD.RATE_PLAN_NO   = UT.RATE_PLAN_NO                      
MFA-TR*            AND RD.SECURED_RATE_FL = 'Y'                                 
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02823                                                                  
A02823     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
A02823                                                                  
A02823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02823        CONTINUE                                                  
A02823     ELSE                                                         
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        DISPLAY '*    7870-CHK-SECURED-RATE-FLAG        *'        
A02823        DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
A02823        DISPLAY '* UT-ACCOUNT-NO : ' UT-ACCOUNT-NO                
A02823        DISPLAY '* PROGRAM ABORTING...                  *'        
A02823        DISPLAY '********** PCSRP090 ABORT **************'        
A02823        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02823     END-IF.                                                      
A02823                                                                  
A02823 7870-EXIT.                                                       
A02823     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05460*  CHECK FOR SOLAR RATE                                        *          
      ****************************************************************          
      *                                                                         
A05460 7890-CHECK-SOLAR.                                                
      *                                                                         
A05460     EXEC SQL                                                     
A05460       SELECT TOP(1) CH.ACCOUNT_NO,
              UT.RATE_PLAN_NO                                     
A05460         INTO :WS-SOLAR-ACCOUNT                                   
A05460             ,:WS-SOLAR-RATE                                      
A05460         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
A05460             ,CSS_PREMISE PR WITH(READUNCOMMITTED)                        
A05460             ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                 

                INNER JOIN (
                 SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END              
A05460                 ,IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') ))) MFAAUXI_0         
A05460                 ,MAX(CH1.DATE_UTIL_SVC_STRT) MFAAUXI_1
                       ,CH1.PREMISE_NO MFAAUXI_2
            FROM CSS_CUST_PREM_HIST CH1 WITH(READUNCOMMITTED)
            GROUP BY CH1.PREMISE_NO
               ) MFAAUXI
                 ON MFAAUXI_0 = COALESCE(CH.DATE_UTIL_SVC_END                   
A05460              , IIF(TRY_CONVERT(DATE, '9999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '9999-12-31'
              ) <> 0) OR (LEN('9999-12-31') <> 10), CIS.CHAR2DATE(
              '9999-12-31'), CONVERT(DATE, '9999-12-31') )) AND 
           MFAAUXI_1 = CH.DATE_UTIL_SVC_STRT
                 AND MFAAUXI.MFAAUXI_2 = CH.PREMISE_NO
A05460             ,CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                  
A05460        WHERE CH.ACCOUNT_NO     = :AT-ACCOUNT-NO
                    AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO
                    AND PR.PREMISE_NO     = UT.PREMISE_NO
                    AND PR.PREMISE_NO     = CH.PREMISE_NO
                    AND PR.COMPANY_NO     = '01'
                    AND PR.COMPANY_NO     = UT.COMPANY_NO
                    AND J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE
                    AND J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO
                    AND (J1.BAL_FWD_CD > ' '                                
A05460           OR  J1.CMPNT_ID_CD = '60')
                    AND J1.VERSION_NO_CNTRL =                               
A05460            (SELECT MAX(RC.VERSION_NO_CNTRL)                      
A05460                  FROM CSS_RATE_CREATOR RC WITH(READUNCOMMITTED)          
A05460                 WHERE RC.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE      
A05460                   AND RC.RATE_PLAN_NO = J1.RATE_PLAN_NO          
A05460                   AND RC.CODE_STATUS = 'A')                              
A05460            ORDER BY PR.PREMISE_NO                                
A05460                                       
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ059
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CH.ACCOUNT_NO                                               
MFA-TR*            ,UT.RATE_PLAN_NO                                             
MFA-TR*        INTO :WS-SOLAR-ACCOUNT                                           
MFA-TR*            ,:WS-SOLAR-RATE                                              
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_PREMISE PR                                              
MFA-TR*            ,CSS_CUST_PREM_HIST CH                                       
MFA-TR*            ,CSS_RATE_COMP_DEF J1                                        
MFA-TR*       WHERE CH.ACCOUNT_NO     = :AT-ACCOUNT-NO                          
MFA-TR*         AND CH.ACCOUNT_NO     = UT.ACCOUNT_NO                           
MFA-TR*         AND PR.PREMISE_NO     = UT.PREMISE_NO                           
MFA-TR*         AND PR.PREMISE_NO     = CH.PREMISE_NO                           
MFA-TR*         AND PR.COMPANY_NO     = '01'                                    
MFA-TR*         AND PR.COMPANY_NO     = UT.COMPANY_NO                           
MFA-TR*         AND J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                       
MFA-TR*         AND J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO                         
MFA-TR*         AND (J1.BAL_FWD_CD > ' '                                        
MFA-TR*          OR  J1.CMPNT_ID_CD = '60')                                     
MFA-TR*         AND J1.VERSION_NO_CNTRL =                                       
MFA-TR*           (SELECT MAX(RC.VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR RC                                
MFA-TR*                WHERE RC.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE              
MFA-TR*                  AND RC.RATE_PLAN_NO = J1.RATE_PLAN_NO                  
MFA-TR*                  AND RC.CODE_STATUS = 'A')                              
MFA-TR*         AND ( COALESCE(CH.DATE_UTIL_SVC_END                             
MFA-TR*             , DATE('9999-12-31'))                                       
MFA-TR*             , CH.DATE_UTIL_SVC_STRT) IN                                 
MFA-TR*         (SELECT MAX(COALESCE(CH1.DATE_UTIL_SVC_END                      
MFA-TR*                ,DATE('9999-12-31')))                                    
MFA-TR*                ,MAX(CH1.DATE_UTIL_SVC_STRT)                             
MFA-TR*            FROM CSS_CUST_PREM_HIST CH1                                  
MFA-TR*           WHERE CH1.PREMISE_NO = CH.PREMISE_NO                          
MFA-TR*           GROUP BY CH1.PREMISE_NO)                                      
MFA-TR*           ORDER BY PR.PREMISE_NO                                        
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05460        MOVE WS-Y TO WS-SOLAR-SW                                  
A05460     ELSE                                                         
A05460        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A05460           MOVE SPACES TO WS-SOLAR-SW                             
A05460        ELSE                                                      
A05460           DISPLAY '********** PCSRP090 ABORT **************'     
A05460           DISPLAY '*    7890-CHECK-SOLAR                  *'     
A05460           DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE     
A05460           DISPLAY '* AT-ACCOUNT-NO : ' AT-ACCOUNT-NO             
A05460           DISPLAY '* PROGRAM ABORTING...                  *'     
A05460           DISPLAY '****************************************'     
A05460           PERFORM 9900-ABEND THRU 9900-EXIT                      
A05460        END-IF                                                    
A05460     END-IF.                                                      
      *                                                                         
A05460 7890-EXIT.                                                       
A05460     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-PRINT-RPT-HEADERS.                                        *        
      ******************************************************************        
       8000-PRINT-RPT-HEADERS.                                          
                                                                        
           IF AT-COMPANY-NO = '01'                                      
              MOVE WS-SCEG-COMP-NAME     TO P-RPT-COMPANY-NAME          
           ELSE                                                         
              MOVE WS-PSNC-COMP-NAME     TO P-RPT-COMPANY-NAME          
           END-IF.                                                      
                                                                        
           ADD 1                             TO WS-PAGE-COUNT.          
           MOVE WS-PAGE-COUNT                TO P-RPT-PAGE-NO.          
                                                                        
           MOVE WS-RPT-HEADER-01             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
A02823     MOVE 1                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-RPT-HEADER-02             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
A02823     MOVE 1                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-RPT-HEADER-03             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE 2                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-BLANK-LINE                TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           MOVE 1                            TO WS-SKIP-LINES-NUM.      
                                                                        
           IF WS-RPT-NO NOT = 4 THEN                                    
              MOVE WS-RPT-HEADING-01       TO WS-PRT33-RECORD           
           ELSE                                                         
              MOVE WS-RPT-HEADING-02       TO WS-PRT33-RECORD           
           END-IF.                                                      
                                                                        
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
                                                                        
           MOVE 6                            TO WS-LINE-COUNT.          
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-CHECK-PAGE-OVERFLOW.                                      *        
      ******************************************************************        
       8100-CHECK-PAGE-OVERFLOW.                                        
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8000-PRINT-RPT-HEADERS THRU 8000-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-PRINT-RPT-NO-DATA.                                        *        
      ******************************************************************        
       8200-PRINT-RPT-NO-DATA.                                          
                                                                        
           IF AT-COMPANY-NO = '01'                                      
              MOVE WS-SCEG-COMP-NAME     TO P-RPT-COMPANY-NAME          
           ELSE                                                         
              MOVE WS-PSNC-COMP-NAME     TO P-RPT-COMPANY-NAME          
           END-IF.                                                      
                                                                        
           MOVE 1                            TO P-RPT-PAGE-NO.          
                                                                        
           MOVE WS-RPT-HEADER-01             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
A02823     MOVE 1                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-RPT-HEADER-02             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
A02823     MOVE 1                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-RPT-HEADER-04             TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
                                                                        
A02823     MOVE 2                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-BLANK-LINE                TO WS-PRT33-RECORD.        
           PERFORM 8900-WRITE-REPORT           THRU 8900-EXIT.          
           MOVE 1                            TO WS-SKIP-LINES-NUM.      
           MOVE WS-BLANK-LINE             TO   WS-PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT      THRU 8900-EXIT.               
           MOVE WS-NO-DATA-LINE           TO   WS-PRT33-RECORD.         
           PERFORM 8900-WRITE-REPORT      THRU 8900-EXIT.               
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8400-PRINT-RPT-FOOTER.                                         *        
      ******************************************************************        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE WS-BLANK-LINE            TO WS-PRT33-RECORD.            
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           MOVE WS-FOOTER-LINE           TO WS-PRT33-RECORD.            
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           MOVE WS-BLANK-LINE            TO WS-PRT33-RECORD.            
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-WRITE-REPORT.                                             *        
      ******************************************************************        
       8900-WRITE-REPORT.                                               
                                                                        
            WRITE PRT33-RECORD FROM WS-PRT33-RECORD                     
                               AFTER ADVANCING WS-SKIP-LINES-NUM.       
                                                                        
            INITIALIZE  WS-PRT33-RECORD.                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  6251-GET-FJC01-DATE                                           *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  7600-START-FCSJC01                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  7620-START-FCSCA00                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * REDUCE EMBEDDED SPACES.                                        *        
      ******************************************************************        
       COPY CPD00004.                                                           
                                                                        
      ******************************************************************        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COPY BOOK FOR MAILING ADDRESS                                  *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COPY BOOK TO GET COMMON DATE FROM JOB PARM                     *        
      ******************************************************************        
           COPY CPD00040.                                                       
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
