       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID   . PCSRP048.                                         
       DATE-WRITTEN . 03/17/16.                                         
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00070000
      **                                                             ** 00080000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00090000
      ********                   DB2                          ********* 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS       REASON                            ** 00150000
      ** 03/17/16   VIJAY V        NEW PROGRAM (CONVERTED FROM EZT)  ** 00161001
      ** A05460-ACT094                                               ** 00162001
ACT023** 02/09/17   VIJAY V        INITIALIZE VARIABLES OF ACCUMULA- ** 00161001
ACT023** A05744                    TION.                             ** 00162001
      ***************************************************************** 00170000
      *                   PCSRP048  NARRATIVE                         * 00180000
      *                                                               * 00190000
      *      GENERATE PENALTY COST OF GAS AND EMERGENCY GAS REPORT    * 00200000
      *            FILES.                                             * 00220003
      ***************************************************************** 00230000
      *                                                                 00240000
      **          ----BASIC SEQUENCE STRUCTURE ----                  ** 00250000
      **                                                             ** 00260000
      **  0000         MODULE CONTROL                                ** 00270000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00280000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00290000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00300000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00310000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00320000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00330000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00340000
      **                                                             ** 00350000
      ***************************************************************** 00360000
      *                                                                 00370000
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00430000
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSCA481-FILE                                         
               ASSIGN TO UT-S-FCSCA481                                  
               FILE STATUS IS WS-FRP0481-STATUS.                        
                                                                        
           SELECT FCSCA482-FILE                                         
               ASSIGN TO UT-S-FCSCA482                                  
               FILE STATUS IS WS-FRP0482-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
     *** EMER GAS REPORT FILE                                           00580001
       FD  FCSCA481-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FCSCA481-REC                PIC X(166).                      
                                                                        
     *** PENALTY GAS REPORT                                             00632001
       FD  FCSCA482-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FCSCA482-REC                PIC X(108).                      
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP048'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05 WS-CURRENT-DATE       PIC X(10).                          
           05 WS-CURRENT-TIME       PIC X(08).                          
           05 WS-START-DATE         PIC X(10).                          
           05 WS-END-DATE           PIC X(10).                          
           05 WS-REV-MONTH          PIC X(12).                          
COB305     05 WS-REVENUE-MONTH        PIC S9(7) COMP-3 VALUE 0.                 
ACT023     05 WS-WORK-REV-MONTH-NUM PIC 9(06) VALUE 0.                  
ACT023     05 WS-WORK-REV-MONTH REDEFINES WS-WORK-REV-MONTH-NUM.        
              10 WS-WORK-REV-YEAR   PIC 9(04).                          
              10 WS-WORK-REV-MM     PIC 9(02).                          
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.                  
           05 WS-ACCOUNT-DISP       PIC 9(13).                          
           05 WS-PREV-ACCOUNT-NO    PIC S9(13) COMP-3 VALUE +0.         
           05 WS-PREV-SVC-CAT-CD    PIC X(02).                          
           05 WS-PREV-IC-NO         PIC S9(04) COMP.                    
           05 WS-PNLTY-UNITS        PIC S9(11)V9(1) COMP-3 VALUE +0.    
           05 WS-NO-UNITS           PIC S9(11)      COMP-3 VALUE +0.    
           05 WS-CUSTOMER-MRKUP     PIC S9(11)V9(6) COMP-3 VALUE +0.    
           05 WS-FACTOR-TRANSCO     PIC S9(11)V9(6) COMP-3 VALUE +0.    
           05 WS-FACTOR-EMERGAS     PIC S9(11)V9(6) COMP-3 VALUE +0.    
           05 WS-MIN-BILL-PRICE     PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-FACTOR-COGBR       PIC S9(11)V9(6) COMP-3 VALUE +0.    
           05 WS-FACTOR-PCOGBR      PIC S9(11)V9(6) COMP-3 VALUE +0.    
           05 WS-TOTAL-EGAS-PRICE   PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-PRICE1             PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-BASE-RATE          PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-TRANSCO-BLD-RATE   PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-EGAS-BILLED-RATE   PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-TOTAL-PNLTY-PRICE  PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-MAX-PRICE          PIC S9(09)V9(4) COMP-3 VALUE +0.    
           05 WS-TRANSCO-REVENUE    PIC S9(09)V9(2) COMP-3 VALUE +0.    
           05 WS-EGAS-REVENUE       PIC S9(09)V9(2) COMP-3 VALUE +0.    
           05 WS-PNLTY-COG          PIC S9(11)V9(2) COMP-3 VALUE +0.    
           05 WS-RP-DATE            PIC X(05).                          
           05 WS-FIRST-TIME         PIC X(01)   VALUE 'Y'.              
           05 WS-N                  PIC X(01)   VALUE 'N'.              
           05 WS-Y                  PIC X(01)   VALUE 'Y'.              
                                                                        
      ** EMER GAS RECORD                                                01740003
       01  WS-FCSCA481-REC.                                             
           05  CA481-ACCOUNT-NO            PIC 9(13).                   
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-CUSTOMER-NAME         PIC X(30).                   
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-SVC-CAT-ID            PIC X(02).                   
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-DATE                  PIC X(05).                   
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-TRANSCO-RATE          PIC ZZZZZZ9.9(4) .           
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-CUST-MRKUP            PIC ZZZZ9.9(2) .             
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-TOTAL-EGAS-PRICE      PIC ZZZZZZ9.9(4) .           
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-EGAS-BILLED-RATE      PIC ZZZZZZ9.9(4) .           
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-TRANSCO-BLD-RATE      PIC ZZZZ9.9(2) .             
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-APP-DTS               PIC ZZZZZZZZZZ9     .        
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-TRANSCO-REVENUE       PIC ZZZZZZZZZZ9.99 .         
           05  FILLER                      PIC X(01) VALUE  X'05' .     
           05  CA481-EGAS-REVENUE          PIC ZZZZZZZZZZ9.99 .         
                                                                        
      ** PENALTY GAS RECORD                                             01751307
       01  WS-FCSCA482-REC.                                             
           05  CA482-ACCOUNT-NO        PIC 9(13).                       
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-CUSTOMER-NAME     PIC X(30).                       
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-SVC-CAT-CD        PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-PCOGBR-FACTOR     PIC ZZZZZZ9.9(4).                
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-CUSTOMER-MRKUP    PIC ZZZZ9.99 .                   
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-TOTAL-PNLTY-PRICE PIC ZZZZ9.9999.                  
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-PENALTY-UNITS     PIC ZZZZZZZZZZ9.                 
           05  FILLER                  PIC X(01) VALUE  X'05' .         
           05  CA482-PENALTY-REVENUE   PIC ZZZZZZZZZZZ9.99.             
                                                                        
      ** EMER GAS REPORT HEADER                                         01820007
       01  WS-EMER-GAS-RPT-HDR.                                         
           05  FILLER            PIC X(09) VALUE ' PCSRP048'   .        
           05  FILLER            PIC X(10) VALUE SPACES        .        
           05  FILLER            PIC X(32) VALUE                        
               'EMERGENCY GAS REPORT BY DAY FOR ' .                     
           05  WS-RPT-REV-MONTH1 PIC 9(06) .                            
           05  FILLER            PIC X(15) VALUE SPACES        .        
           05  FILLER            PIC X(11) VALUE 'RUN DATE : ' .        
           05  WS-RPT-RUN-DATE1  PIC X(10) .                            
           05  FILLER            PIC X(73) VALUE SPACES        .        
                                                                        
       01  WS-EMER-GAS-DET-HDR.                                         
           05  FILLER            PIC X(10) VALUE 'ACCOUNT NO'   .       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(13) VALUE 'CUSTOMER NAME'.       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(13) VALUE 'SER CATEGORY' .       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(04) VALUE 'DATE'         .       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(15) VALUE 'TRANSCO Z6 NYC$'.     
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(15) VALUE 'CUSTOMER MRKUP$'.     
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(16) VALUE 'TOTAL EGAS PRICE' .   
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(17) VALUE 'EGAS BILLED PRICE'.   
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(20) VALUE 'TRANSCO BILLED PRICE'.
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(05) VALUE 'UNITS' .              
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(15) VALUE 'TRANSCO REVENUE'.     
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(12) VALUE 'EGAS REVENUE' .       
                                                                        
      ** PENALTY GAS REPORT HEADER                                      01859407
       01  WS-PENALTY-RPT-HDR.                                          
           05  FILLER            PIC X(09) VALUE ' PCSRP048'   .        
           05  FILLER            PIC X(10) VALUE SPACES        .        
           05  FILLER            PIC X(23) VALUE                        
                                     'PENALTY GAS REPORT FOR ' .        
           05  WS-RPT-REV-MONTH2 PIC 9(06) .                            
           05  FILLER            PIC X(15) VALUE SPACES        .        
           05  FILLER            PIC X(11) VALUE 'RUN DATE : ' .        
           05  WS-RPT-RUN-DATE2  PIC X(10) .                            
           05  FILLER            PIC X(24) VALUE SPACES        .        
                                                                        
       01  WS-PENALTY-DET-HDR.                                          
           05  FILLER            PIC X(10) VALUE 'ACCOUNT NO'   .       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(13) VALUE 'CUSTOMER NAME'.       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(13) VALUE 'SER CATEGORY' .       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(13) VALUE 'PCOGBR FACTOR'.       
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(15) VALUE 'CUSTOMER MRKUP$'.     
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(17) VALUE 'TOT PENLATY PRICE'.   
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(05) VALUE 'UNITS' .              
           05  FILLER            PIC X(01) VALUE  X'05' .               
           05  FILLER            PIC X(15) VALUE 'PENALTY REVENUE'.     
                                                                        
      ** NO DATA RECORD                                                 01901030
       01  WS-NO-DATA-REC.                                              
           05  FILLER            PIC X(25)  VALUE SPACES.               
           05  FILLER            PIC X(20)  VALUE 'NO DATA TO PROCESS' .
           05  FILLER            PIC X(121) VALUE SPACES.               
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  BG-RETURN-CODE          PIC S9(04) COMP VALUE +0.        
           05  ND-RETURN-CODE          PIC S9(04) COMP VALUE +0.        
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE +0.        
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCSBE00-ACCT-FLAG        PIC X(01)   VALUE 'N'.       
               88  FCSBE00-ACCT-NO-CHANGED             VALUE 'Y'.       
           05  WS-FRP0481-STATUS           PIC X(02).                   
               88  FRP0481-SUCCESSFUL                  VALUE '00'.      
               88  WS-START-INPUT-DATA                 VALUE 'X'.       
           05  WS-FRP0482-STATUS           PIC X(02).                   
               88  FRP0482-SUCCESSFUL                  VALUE '00'.      
               88  WS-START-INPUT-DATA                 VALUE 'X'.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSRP048'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSRP048'.      
                                                                        
      ******* JOBS FILE/TABLE DEFINITIONS                               02560000
       COPY FIOCA00.                                                    02570003
       COPY FIOJC01.                                                    02580003
                                                                        
      ******* CWS00039 IS CA00 WORK DATA                                02600000
       COPY CWS00039.                                                   02610000
                                                                        
      ******* CWS00010 IS FOR ERROR HANDLING VARIABLES                  02630000
       COPY CWS00010.                                                   02640000
                                                                        
      ******* CWS09900 CONTAINS VARIABLES FOR ABEND                     02660000
       COPY CWS09900.                                                   02670000
                                                                        
      ******* CWS00038 IS JC01 WORK DATA                                02690000
       COPY CWS00038.                                                   02700000
                                                                        
      ******* CWS00114 CONTAINS VARIABLES FOR CPD00114                  02720000
       COPY CWS00114.                                                   02730000
                                                                        
      ******* CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                02750000
       COPY CWS00303.                                                   02760000
                                                                        
      ******************************************************************02780000
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                       02790000
      ******************************************************************02800000
           EXEC SQL                                                     02810000
              INCLUDE CWS00074                                          02820000
           END-EXEC.                                                    02830000
      ************************************************************      02840000
      *COPYBOOK FOR REDUCING EMBEDDED SPACES                            02850000
      ************************************************************      02860000
           EXEC SQL                                                     02870000
              INCLUDE CWS00011                                          02880000
           END-EXEC.                                                    02890000
                                                                        
      ***************************************************************** 02910000
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          ** 02920000
      ***************************************************************** 02930000
                                                                        
           EXEC SQL                                                     02950003
                INCLUDE SQLCA                                           02960003
           END-EXEC.                                                    02970003
                                                                        
      ******************************************************************02990000
      **  CSS_JOB_PARM                                                **03000000
      ******************************************************************03010000
                                                                        
           EXEC SQL                                                     03030000
                INCLUDE TBJBPARM                                        03040000
           END-EXEC.                                                    03050000
                                                                        
      ******************************************************************03070000
      **  CSS_ACCOUNT   AT                                            **03080020
      ******************************************************************03090000
                                                                        
           EXEC SQL                                                     03110000
               INCLUDE TBACCT                                           03120020
           END-EXEC.                                                    03130000
                                                                        
      ******************************************************************03141020
      **  CSS_NAME_ACCT_XREF                                          **03142020
      ******************************************************************03143020
                                                                        
           EXEC SQL                                                     03145020
               INCLUDE TBNMACTX                                         03146020
           END-EXEC.                                                    03147020
                                                                        
      ******************************************************************03150000
      **  CSS_PRTY_SVC_CAT Z4                                         **03160001
      ******************************************************************03170000
                                                                        
           EXEC SQL                                                     03190000
               INCLUDE TBSVCCAT                                         03200000
           END-EXEC.                                                    03210000
                                                                        
                                                                        
      ******************************************************************03390000
      **  CSS_VOL_DAILY                                               **03400000
      ******************************************************************03410000
                                                                        
           EXEC SQL                                                     03430000
               INCLUDE TBVOLDLY                                         03440000
           END-EXEC.                                                    03450000
                                                                        
      ******************************************************************03461008
      **  CSS_BILL_CALC_DET BZ                                        **03462008
      ******************************************************************03463008
                                                                        
           EXEC SQL                                                     03465008
               INCLUDE TBBLCLDT                                         03466008
           END-EXEC.                                                    03467008
                                                                        
      ******************************************************************03468119
      **  CSS_BILLING_DET BG                                        **  03468219
      ******************************************************************03468319
                                                                        
           EXEC SQL                                                     03468519
               INCLUDE TBBLLDET                                         03468619
           END-EXEC.                                                    03468719
                                                                        
      ******************************************************************03469008
      **  CSS_SPCL_FCTR_APPL SA                                       **03469108
      ******************************************************************03469208
                                                                        
           EXEC SQL                                                     03469408
               INCLUDE TBSPLAPL                                         03469508
           END-EXEC.                                                    03469608
                                                                        
      ******************************************************************03469809
      **  CSS_PRICE_SCHED    PS                                       **03469909
      ******************************************************************03470009
                                                                        
           EXEC SQL                                                     03470209
               INCLUDE TBPRCSCH                                         03470309
           END-EXEC.                                                    03470409
                                                                        
      ******************************************************************03471009
      **  CSS_ACCT_MISC_INFO                                          **03480000
      ******************************************************************03490000
                                                                        
           EXEC SQL                                                     03510000
               INCLUDE TBATMISC                                         03520000
           END-EXEC.                                                    03530000
                                                                        
      ******************************************************************03550000
      **  CSS_CUST_ADDR_XREF                                          **03560000
      ******************************************************************03570000
                                                                        
           EXEC SQL                                                     03590000
               INCLUDE TBCSADRX                                         03600000
           END-EXEC.                                                    03610000
                                                                        
      ******************************************************************03620000
      **  CSS_NAME                                                    **03630000
      ******************************************************************03640000
                                                                        
           EXEC SQL                                                     03660000
               INCLUDE TBNAME                                           03670000
           END-EXEC.                                                    03680000
                                                                        
      ******************************************************************03700000
      **  CSS_ADDR_FORMATTED                                          **03710000
      ******************************************************************03720000
                                                                        
           EXEC SQL                                                     03740000
               INCLUDE TBADRFMT                                         03750000
           END-EXEC.                                                    03760000
                                                                        
      ******************************************************************03780000
      **  CSS_ADDR_FREEFORM                                           **03790000
      ******************************************************************03800000
                                                                        
           EXEC SQL                                                     03820000
               INCLUDE TBADRFRE                                         03830000
           END-EXEC.                                                    03840000
                                                                        
      ******************************************************************03860000
      **  CSS_ZIPCD                                                   **03870000
      ******************************************************************03880000
                                                                        
           EXEC SQL                                                     03900000
               INCLUDE TBZIPCD                                          03910000
           END-EXEC.                                                    03920000
                                                                        
      ******************************************************************04180000
      * CURSOR TO FETCH BILL DETAILS                                   *04190001
      ******************************************************************04200000
                                                                        
           EXEC SQL                                                     
                   DECLARE BILLDET_CUR CURSOR FOR                       
               SELECT                                                   
                    BZ.ACCOUNT_NO                                       
                   ,BG.RATE_PLAN_NO                                     
                   ,Z4.PRTY_SVC_CAT_CD                                  
                   ,BZ.CODE_UTIL_TYPE                                   
                   ,BZ.IC_NO                                            
                   ,BZ.BILL_NO                                          
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BZ.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
                   ,BZ.CMPNT_ID_CD                                      
                   ,IIF(TRY_CAST(BZ.BILL_UNITS AS INT) IS NULL, 
              CIS.INTEGER(BZ.BILL_UNITS), CAST(BZ.BILL_UNITS AS INT))          
                   ,BZ.UNIT_PRICE_AM                                    
                   ,BG.REV_MTH_ORIG_BILL                                
                   ,BG.REVENUE_MONTH                                    
               FROM                                                     
                    CSS_BILL_CALC_DET BZ                                
                   ,CSS_BILLING_DET   BG                                
                   ,CSS_PRTY_SVC_CAT  Z4                                
                                                                        
             WHERE BG.REVENUE_MONTH      = :WS-REVENUE-MONTH            
               AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO                
               AND BZ.BILL_NO            = BG.BILL_NO                   
               AND BZ.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE            
               AND BZ.IC_NO              = BG.IC_NO                     
               AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP        
               AND BZ.CMPNT_ID_CD       IN ('51','55')                  
               AND BZ.CONSUMPT_TYPE_CD   = 'D'                          
               AND Z4.CODE_CURTAIL_PRTY  = BG.CODE_CURTAIL_PRTY         
               AND Z4.COMPANY_NO         = BG.COMPANY_NO                
               AND BG.CODE_BILL_CALC     = 'A'                          
               AND BG.CODE_BILL_ITM_TYPE = 'C'                          
               AND BG.CODE_BILL_ITM_IND  = 'A'                          
               ORDER BY                                                 
                    BZ.ACCOUNT_NO                                       
                   ,BILL_ITEM_TIMESTMP                               
                   ,BZ.CMPNT_ID_CD                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04220001
MFA-TR*            DECLARE BILLDET_CUR CURSOR FOR                       04230001
MFA-TR*        SELECT                                                   04240001
MFA-TR*             BZ.ACCOUNT_NO                                       04250001
MFA-TR*            ,BG.RATE_PLAN_NO                                     04260017
MFA-TR*            ,Z4.PRTY_SVC_CAT_CD                                  04270001
MFA-TR*            ,BZ.CODE_UTIL_TYPE                                   04280017
MFA-TR*            ,BZ.IC_NO                                            04290017
MFA-TR*            ,BZ.BILL_NO                                          04300017
MFA-TR*            ,BZ.BILL_ITEM_TIMESTMP                               04310017
MFA-TR*            ,BZ.CMPNT_ID_CD                                      04320001
MFA-TR*            ,INTEGER(BZ.BILL_UNITS)                              04330001
MFA-TR*            ,BZ.UNIT_PRICE_AM                                    04340001
MFA-TR*            ,BG.REV_MTH_ORIG_BILL                                04340001
MFA-TR*            ,BG.REVENUE_MONTH                                    04340001
MFA-TR*        FROM                                                     04380001
MFA-TR*             CSS_BILL_CALC_DET BZ                                04400017
MFA-TR*            ,CSS_BILLING_DET   BG                                04410001
MFA-TR*            ,CSS_PRTY_SVC_CAT  Z4                                04420001
MFA-TR*                                                                 04440003
MFA-TR*      WHERE BG.REVENUE_MONTH      = :WS-REVENUE-MONTH            04490015
MFA-TR*        AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO                04610015
MFA-TR*        AND BZ.BILL_NO            = BG.BILL_NO                   04620001
MFA-TR*        AND BZ.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE            04630001
MFA-TR*        AND BZ.IC_NO              = BG.IC_NO                     04640001
MFA-TR*        AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP        04650001
MFA-TR*        AND BZ.CMPNT_ID_CD       IN ('51','55')                  04660001
MFA-TR*        AND BZ.CONSUMPT_TYPE_CD   = 'D'                          04670001
MFA-TR*        AND Z4.CODE_CURTAIL_PRTY  = BG.CODE_CURTAIL_PRTY         04684017
MFA-TR*        AND Z4.COMPANY_NO         = BG.COMPANY_NO                04685017
MFA-TR*        AND BG.CODE_BILL_CALC     = 'A'                          04685018
MFA-TR*        AND BG.CODE_BILL_ITM_TYPE = 'C'                          04685019
MFA-TR*        AND BG.CODE_BILL_ITM_IND  = 'A'                          04685020
MFA-TR*        ORDER BY                                                 04686003
MFA-TR*             BZ.ACCOUNT_NO                                       04687012
MFA-TR*            ,BZ.BILL_ITEM_TIMESTMP                               04688012
MFA-TR*            ,BZ.CMPNT_ID_CD                                      04689012
MFA-TR*        QUERYNO 7000                                             04780015
MFA-TR*    END-EXEC.                                                    04790001
                                                                        
      ******************************************************************04800000
      * GET VOLUME DETAILS UNITS AND DATE                              *04810001
      ******************************************************************04820000
           EXEC SQL                                                     
                   DECLARE VOLDET_CUR CURSOR FOR                        
               SELECT                                                   
                    ND.DATE_READ                                        
                   ,ND.VOL_TYPE_CD                                      
                   ,ND.NO_UNITS                                         
                   ,SUBSTRING(CAST(ND.DATE_READ AS CHAR(10)), 6, 2) + 
           '/' + SUBSTRING(CAST(ND.DATE_READ AS CHAR(10)), 9, 2)               
               FROM                                                     
                   CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                       
               WHERE                                                    
                   ND.ACCOUNT_NO         = :ND-ACCOUNT-NO               
               AND ND.BILL_NO            = :ND-BILL-NO                  
               AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE           
               AND ND.IC_NO              = :ND-IC-NO                    
               AND ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )       
               AND ND.VOL_TYPE_CD        IN('EG','PG')                  
               AND ND.ENERGY_UNIT_CD     = 'D'                          
               AND ND.DATE_READ BETWEEN IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) AND 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) 
               ORDER BY ND.DATE_READ                                    
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04830000
MFA-TR*            DECLARE VOLDET_CUR CURSOR FOR                        04840001
MFA-TR*        SELECT                                                   04850000
MFA-TR*             ND.DATE_READ                                        04860000
MFA-TR*            ,ND.VOL_TYPE_CD                                      04870000
MFA-TR*            ,ND.NO_UNITS                                         04880000
MFA-TR*            ,SUBSTR(CHAR(ND.DATE_READ),6,2)|| '/' ||             04890000
MFA-TR*             SUBSTR(CHAR(ND.DATE_READ),9,2)                      04900000
MFA-TR*        FROM                                                     04910000
MFA-TR*            CSS_VOL_DAILY ND                                     04920000
MFA-TR*        WHERE                                                    04930000
MFA-TR*            ND.ACCOUNT_NO         = :ND-ACCOUNT-NO               04940000
MFA-TR*        AND ND.BILL_NO            = :ND-BILL-NO                  04950000
MFA-TR*        AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE           04960000
MFA-TR*        AND ND.IC_NO              = :ND-IC-NO                    04970000
MFA-TR*        AND ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP       04980000
MFA-TR*        AND ND.VOL_TYPE_CD        IN('EG','PG')                  04990000
MFA-TR*        AND ND.ENERGY_UNIT_CD     = 'D'                          05000000
MFA-TR*        AND ND.DATE_READ BETWEEN :WS-START-DATE AND :WS-END-DATE 05010000
MFA-TR*        ORDER BY ND.DATE_READ                                    05020000
MFA-TR*        FOR FETCH ONLY WITH UR                                   05030000
MFA-TR*        QUERYNO 7100                                             05031015
MFA-TR*    END-EXEC.                                                    05040000
                                                                        
       PROCEDURE DIVISION .                                             
      ***************************************************************** 06410000
      *                                                              ** 06420000
      *    0000-MAINLINE                                             ** 06430000
      *                                                              ** 06440000
      ***************************************************************** 06450000
      *                                                                 06460000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS  THRU 1000-EXIT                
                                                                        
      *** AT END OF PROCESSING                                          06570223
           PERFORM 2300-PROCESS-PENALTY-REPORT THRU 2300-EXIT           
                                                                        
           PERFORM 9000-TERMINATE         THRU 9000-EXIT                
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06640000
      ***************************************************************** 06650000
      *    0100-INITIALIZATION                                       ** 06660000
      *                                                              ** 06670000
      *    OPEN FILES                                                ** 06680000
      *    READ JOBS TABLE TO OBTAIN RUN DATE/COMMON DATE            ** 06690000
      *                                                              ** 06700000
      ***************************************************************** 06710000
      *                                                                 06720000
       0100-INITIALIZATION.                                             
                                                                        
                                                                        
      * OPEN THE OUTPUT FILE FOR PROCESSING                             06760000
                                                                        
           OPEN OUTPUT FCSCA481-FILE.                                   
           IF NOT FRP0481-SUCCESSFUL                                    
              DISPLAY '** PCSRP048  PROCESSING ERROR  **'               
              DISPLAY '** OPEN ERROR ON FILE FRP0481  **'               
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '** STATUS IS ' WS-FRP0481-STATUS                 
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSCA482-FILE.                                   
           IF NOT FRP0482-SUCCESSFUL                                    
              DISPLAY '** PCSRP048  PROCESSING ERROR  **'               
              DISPLAY '** OPEN ERROR ON FILE FRP0482  **'               
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '** STATUS IS ' WS-FRP0482-STATUS                 
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
      * GET THE COMMON DATE FROM THE JOB PARM DB2 TABLE.                06960000
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE          TO   WS-INPUT-DATE     
           END-IF                                                       
                                                                        
      * GET THE REVENUE MONTH FROM THE JOB PARM DB2 TABLE.              07160000
           INITIALIZE WS-SYSIPT                                         
           MOVE WS-PGRMNAME            TO WS-PROGRAM                    
           MOVE WS-DATE                TO WS-COMMAND                    
           MOVE ZEROS                  TO WS-SEQUENCE                   
           MOVE WS-KEY-AREA            TO E-FJC01-KEY                   
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIt                   
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
                           UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)       
                                                 OR END-OF-SYSIPT       
           IF END-OF-SYSIPT                                             
              INITIALIZE WS-SYSIPT                                      
              MOVE 'COMMON'               TO WS-PROGRAM                 
              MOVE WS-DATE                TO WS-COMMAND                 
              MOVE ZEROS                  TO WS-SEQUENCE                
              MOVE WS-KEY-AREA            TO E-FJC01-KEY                
              PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                
              PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                
                            UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)      
                                                 OR END-OF-SYSIPT       
              EVALUATE TRUE                                             
                 WHEN END-OF-SYSIPT                                     
                    DISPLAY '********** PCSCA048 ABORT ********'        
                    DISPLAY '*       0100-INITIALIZATION      *'        
                    DISPLAY '*NO ACTIVE REVENUE MONTH IN COMMON'        
                    DISPLAY '*     PROCESSING TERMINATED      *'        
                    DISPLAY '********** PCSCA048 ABORT ********'        
                    PERFORM 9900-ABEND         THRU  9900-EXIT          
                 WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC                 
                    DISPLAY '******** PCSCA048 ABORT **********'        
                    DISPLAY '*     0100-INITIALIZATION        *'        
                    DISPLAY '*  REVENUE MONTH PARM NOT NUMERIC*'        
                    DISPLAY '*          KEY = ' E-FJC01-KEY             
                    DISPLAY '*   PROCESSING TERMINATED        *'        
                    DISPLAY '******** PCSCA048 ABORT **********'        
                    PERFORM 9900-ABEND         THRU  9900-EXIT          
                 WHEN OTHER                                             
                    PERFORM 7611-CLOSE THRU 7611-EXIT                   
                    MOVE WS-REVENUE-MONTH-PARM                          
                      TO WS-REVENUE-MONTH                               
                         WS-WORK-REV-MONTH                              
              END-EVALUATE                                              
           ELSE                                                         
              MOVE WS-REVENUE-MONTH-PARM TO WS-REVENUE-MONTH            
                                            WS-WORK-REV-MONTH           
           END-IF                                                       
                                                                        
           DISPLAY 'REVENUE MONTH : ' WS-REVENUE-MONTH-PARM             
                                                                        
      * GET START AND END DATES FOR THE MONTH                           07299830
           PERFORM 0110-GET-START-END-DATE THRU 0110-EXIT.              
                                                                        
      * WRITE HEADERS OF REPORTS                                        07752007
           INITIALIZE WS-FCSCA481-REC WS-FCSCA482-REC                   
                      FCSCA481-REC    FCSCA482-REC                      
                                                                        
           MOVE WS-INPUT-DATE TO WS-RPT-RUN-DATE1                       
                                 WS-RPT-RUN-DATE2                       
                                                                        
           MOVE WS-WORK-REV-MONTH TO WS-RPT-REV-MONTH1                  
                                     WS-RPT-REV-MONTH2                  
                                                                        
           WRITE FCSCA481-REC FROM WS-EMER-GAS-RPT-HDR                  
           WRITE FCSCA481-REC FROM WS-EMER-GAS-DET-HDR                  
                                                                        
           WRITE FCSCA482-REC FROM WS-PENALTY-RPT-HDR                   
           WRITE FCSCA482-REC FROM WS-PENALTY-DET-HDR                   
                                                                        
           INITIALIZE WS-FCSCA481-REC WS-FCSCA482-REC                   
                      FCSCA481-REC    FCSCA482-REC                      
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07810000
      ***************************************************************** 07811001
      ** GET START AND END DATES FOR THE MONTH                        * 07812001
      ***************************************************************** 07813001
       0110-GET-START-END-DATE.                                         
                                                                        
           EVALUATE WS-WORK-REV-MM                                      
              WHEN  '01'                                                
              WHEN  '03'                                                
              WHEN  '05'                                                
              WHEN  '07'                                                
              WHEN  '08'                                                
              WHEN  '10'                                                
              WHEN  '12'                                                
                 MOVE '31' TO WS-STNDTE-END-DAY                         
              WHEN '04'                                                 
              WHEN '06'                                                 
              WHEN '09'                                                 
              WHEN '11'                                                 
                 MOVE '30' TO WS-STNDTE-END-DAY                         
              WHEN '02'                                                 
                 MOVE 99  TO WS-REMAINDER1                              
                             WS-REMAINDER2                              
                 DIVIDE WS-NUM-CENTURY BY 4 GIVING WS-QUOTIENT          
                 REMAINDER WS-REMAINDER1                                
                 DIVIDE WS-NUM-CENTURY BY 400 GIVING WS-QUOTIENT        
                 REMAINDER WS-REMAINDER2                                
                    IF (    WS-REMAINDER1 NOT = ZERO                    
                         OR WS-REMAINDER2 = ZERO )                      
                         MOVE '28' TO WS-STNDTE-END-DAY                 
                    ELSE                                                
                         IF WS-REMAINDER1 = ZERO                        
                             MOVE '29' TO WS-STNDTE-END-DAY             
                                                                        
                         END-IF                                         
                    END-IF                                              
              WHEN  OTHER                                               
                    DISPLAY '0110-GET-START-END-DATE'                   
                    'MONTH VALUE IS = ' WS-WORK-REV-MM                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
           MOVE '01'          TO WS-STNDTE-BEG-DAY.                     
                                                                        
           MOVE WS-WORK-REV-MM   TO WS-STNDTE-MONTH                     
                                    WS-STNDTE-BEG-MONTH                 
                                    WS-STNDTE-END-MONTH.                
                                                                        
           MOVE WS-WORK-REV-YEAR TO WS-STNDTE-CENTURY-YR                
                                    WS-STNDTE-BEG-YEAR                  
                                    WS-STNDTE-END-YEAR.                 
                                                                        
           MOVE WS-STNDTE-BEG-DATE TO WS-START-DATE.                    
           MOVE WS-STNDTE-END-DATE TO WS-END-DATE.                      
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08050000
      *                                                               * 08060000
      * 1000-PROCESS-ACCOUNTS                                         * 08070000
      *                                                               * 08110000
      ***************************************************************** 08120000
      *                                                                 08130000
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
ACT023     INITIALIZE WS-CUSTOMER-NAME                                  
ACT023                WS-PNLTY-UNITS                                    
ACT023                WS-TOTAL-EGAS-PRICE                               
ACT023                WS-BASE-RATE                                      
ACT023                WS-NO-UNITS                                       
ACT023                WS-TRANSCO-REVENUE                                
ACT023                WS-EGAS-REVENUE                                   
ACT023                WS-TOTAL-PNLTY-PRICE                              
ACT023                WS-PNLTY-COG                                      
                                                                        
           PERFORM 7000-OPEN-BILLDET-CUR  THRU 7000-EXIT                
                                                                        
           PERFORM 7010-FETCH-BILLDET-CUR THRU 7010-EXIT                
                                                                        
           IF BG-RETURN-CODE = NOT-FOUND                                
              WRITE FCSCA481-REC FROM WS-NO-DATA-REC                    
              WRITE FCSCA482-REC FROM WS-NO-DATA-REC                    
           END-IF                                                       
                                                                        
           PERFORM 2000-PROCESS-BILLDET   THRU 2000-EXIT                
             UNTIL BG-RETURN-CODE = NOT-FOUND                           
                                                                        
           PERFORM 7020-CLOSE-BILLDET-CUR THRU 7020-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09060000
      * THIS PARA WILL PROCESS TRANSPORTATION PURCHASE DETIALS          09070000
      ******************************************************************09080000
                                                                        
       2000-PROCESS-BILLDET.                                            
                                                                        
           MOVE BZ-ACCOUNT-NO TO WS-ACCOUNT-DISP                        
           DISPLAY 'ACCOUNT PROCESSING : ' WS-ACCOUNT-DISP              
                                                                        
ACT023* GET START AND END DATES FOR THE MONTH                           07299830
ACT023     IF BG-REV-MTH-ORIG-BILL > 0                                  
ACT023        MOVE BG-REV-MTH-ORIG-BILL TO WS-WORK-REV-MONTH-NUM        
ACT023     ELSE                                                         
ACT023        MOVE BG-REVENUE-MONTH     TO WS-WORK-REV-MONTH-NUM        
ACT023     END-IF                                                       
ACT023     PERFORM 0110-GET-START-END-DATE THRU 0110-EXIT               
                                                                        
           IF WS-FIRST-TIME = 'Y'                                       
              MOVE BZ-ACCOUNT-NO      TO WS-PREV-ACCOUNT-NO             
              MOVE BZ-IC-NO           TO WS-PREV-IC-NO                  
              MOVE Z4-PRTY-SVC-CAT-CD TO WS-PREV-SVC-CAT-CD             
              MOVE 'N'                TO WS-FIRST-TIME                  
              MOVE 'Y' TO WS-NAME-ONLY-SW                               
              MOVE BZ-ACCOUNT-NO      TO AT-ACCOUNT-NO                  
              PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT         
           END-IF                                                       
                                                                        
           IF BZ-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO                    
              PERFORM 2300-PROCESS-PENALTY-REPORT THRU 2300-EXIT        
              MOVE BZ-ACCOUNT-NO      TO WS-PREV-ACCOUNT-NO             
              MOVE BZ-IC-NO           TO WS-PREV-IC-NO                  
              MOVE Z4-PRTY-SVC-CAT-CD TO WS-PREV-SVC-CAT-CD             
              MOVE 'Y' TO WS-NAME-ONLY-SW                               
              MOVE BZ-ACCOUNT-NO      TO AT-ACCOUNT-NO                  
              PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT         
           END-IF                                                       
                                                                        
           IF BZ-ACCOUNT-NO     = WS-PREV-ACCOUNT-NO                    
             AND BZ-IC-NO   NOT = WS-PREV-IC-NO                         
              PERFORM 2300-PROCESS-PENALTY-REPORT THRU 2300-EXIT        
              MOVE BZ-ACCOUNT-NO      TO WS-PREV-ACCOUNT-NO             
              MOVE BZ-IC-NO           TO WS-PREV-IC-NO                  
              MOVE Z4-PRTY-SVC-CAT-CD TO WS-PREV-SVC-CAT-CD             
           END-IF                                                       
                                                                        
           MOVE BZ-ACCOUNT-NO        TO ND-ACCOUNT-NO                   
           MOVE BZ-BILL-NO           TO ND-BILL-NO                      
           MOVE BZ-IC-NO             TO ND-IC-NO                        
           MOVE BZ-CODE-UTIL-TYPE    TO ND-CODE-UTIL-TYPE               
           MOVE BZ-BILL-ITEM-TIMESTMP                                   
             TO ND-BILL-ITEM-TIMESTMP                                   
                                                                        
           PERFORM 7100-OPEN-VOLDET-CUR     THRU 7100-EXIT              
           PERFORM 7110-FETCH-VOLDET-CUR    THRU 7110-EXIT              
           PERFORM 2100-PROCESS-VOL-DETAILS THRU 2100-EXIT              
             UNTIL ND-RETURN-CODE = NOT-FOUND                           
           PERFORM 7120-CLOSE-VOLDET-CUR    THRU 7120-EXIT              
                                                                        
           PERFORM 7010-FETCH-BILLDET-CUR   THRU 7010-EXIT.             
                                                                        
        2000-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ***************************************************************** 10030103
      * ACCUMULATE VOLUME DETAILS                                     * 10030203
      ***************************************************************** 10030303
       2100-PROCESS-VOL-DETAILS.                                        
                                                                        
            IF ND-VOL-TYPE-CD = 'EG'                                    
              PERFORM 2200-PROCESS-EGAS-REPORT THRU 2200-EXIT           
            END-IF                                                      
                                                                        
            IF ND-VOL-TYPE-CD = 'PG'                                    
               IF WS-PREV-SVC-CAT-CD = '1 ' OR '2 ' OR '3A' OR '3B'     
                  CONTINUE                                              
               ELSE                                                     
                  COMPUTE                                               
                     WS-PNLTY-UNITS = WS-PNLTY-UNITS + ND-NO-UNITS      
                  END-COMPUTE                                           
               END-IF                                                   
            END-IF                                                      
                                                                        
            PERFORM 7110-FETCH-VOLDET-CUR THRU 7110-EXIT.               
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 10200000
      ***************************************************************** 10210000
      *    EGAS REPORT PRCESS                                         * 10230003
      ***************************************************************** 10240000
       2200-PROCESS-EGAS-REPORT.                                        
                                                                        
            MOVE '51'  TO BZ-CMPNT-ID-CD                                
            PERFORM 7200-GET-MARK-UP-PRICE THRU 7200-EXIT               
            MOVE PS-SCHED-PRICE-AM     TO WS-CUSTOMER-MRKUP             
                                                                        
            PERFORM 2210-GET-FACTORS THRU 2210-EXIT                     
                                                                        
            COMPUTE                                                     
                WS-TOTAL-EGAS-PRICE =                                   
                    WS-FACTOR-TRANSCO + WS-CUSTOMER-MRKUP               
            END-COMPUTE                                                 
                                                                        
            MOVE WS-TOTAL-EGAS-PRICE TO WS-PRICE1                       
                                                                        
            COMPUTE                                                     
                WS-BASE-RATE = WS-FACTOR-COGBR + WS-CUSTOMER-MRKUP      
            END-COMPUTE                                                 
                                                                        
            PERFORM 2220-SELECT-MAX-PRICE THRU 2220-EXIT                
                                                                        
      *  EMER GAS BILLED PRICE                                          10850003
            MOVE WS-MAX-PRICE  TO WS-EGAS-BILLED-RATE                   
                                                                        
            MOVE WS-FACTOR-TRANSCO TO WS-PRICE1                         
            MOVE WS-FACTOR-COGBR   TO WS-BASE-RATE                      
            PERFORM 2220-SELECT-MAX-PRICE THRU 2220-EXIT                
                                                                        
      *  TRANSCO BILLED PRICE                                           10971003
            MOVE WS-MAX-PRICE  TO WS-TRANSCO-BLD-RATE                   
                                                                        
            COMPUTE                                                     
                 WS-NO-UNITS ROUNDED = ND-NO-UNITS                      
            END-COMPUTE                                                 
                                                                        
            COMPUTE                                                     
                 WS-TRANSCO-REVENUE = WS-NO-UNITS * WS-TRANSCO-BLD-RATE 
            END-COMPUTE                                                 
                                                                        
            COMPUTE                                                     
                 WS-EGAS-REVENUE = WS-NO-UNITS * WS-EGAS-BILLED-RATE    
            END-COMPUTE                                                 
                                                                        
            MOVE BZ-ACCOUNT-NO       TO CA481-ACCOUNT-NO                
            MOVE WS-CUSTOMER-NAME    TO CA481-CUSTOMER-NAME             
            MOVE WS-PREV-SVC-CAT-CD  TO CA481-SVC-CAT-ID                
            MOVE WS-RP-DATE          TO CA481-DATE                      
            MOVE WS-FACTOR-TRANSCO   TO CA481-TRANSCO-RATE              
            MOVE WS-CUSTOMER-MRKUP   TO CA481-CUST-MRKUP                
            MOVE WS-TOTAL-EGAS-PRICE TO CA481-TOTAL-EGAS-PRICE          
            MOVE WS-EGAS-BILLED-RATE TO CA481-EGAS-BILLED-RATE          
            MOVE WS-TRANSCO-BLD-RATE TO CA481-TRANSCO-BLD-RATE          
            MOVE WS-NO-UNITS         TO CA481-APP-DTS                   
            MOVE WS-TRANSCO-REVENUE  TO CA481-TRANSCO-REVENUE           
            MOVE WS-EGAS-REVENUE     TO CA481-EGAS-REVENUE              
                                                                        
            WRITE FCSCA481-REC FROM WS-FCSCA481-REC                     
                                                                        
            IF NOT FRP0481-SUCCESSFUL                                   
               DISPLAY '** PCSRP048  PROCESSING ERROR   **'             
               DISPLAY '** WRITE ERROR ON FILE FIOCA481 **'             
               DISPLAY '** PROCESSING TERMINATED        **'             
               DISPLAY '** STATUS IS ' WS-FRP0481-STATUS                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
            END-IF.                                                     
                                                                        
ACT023      INITIALIZE WS-TOTAL-EGAS-PRICE                              
ACT023                 WS-BASE-RATE                                     
ACT023                 WS-NO-UNITS                                      
ACT023                 WS-TRANSCO-REVENUE                               
ACT023                 WS-EGAS-REVENUE.                                 
                                                                        
        2200-EXIT.                                                      
             EXIT.                                                      
      *                                                                 11290000
      ***************************************************************** 11300000
      * 2300-PROCESS-PENALTY-REPORT.                                    11310004
      ***************************************************************** 11330000
       2300-PROCESS-PENALTY-REPORT.                                     
                                                                        
           IF WS-PNLTY-UNITS > 0                                        
                                                                        
      *    GET MARK UP PRICE                                            11361007
               MOVE '55'  TO BZ-CMPNT-ID-CD                             
               PERFORM 7200-GET-MARK-UP-PRICE THRU 7200-EXIT            
                                                                        
      *    GET PCOGBR FACTOR                                            11380207
               MOVE 'PCOGBR' TO SA-FACTOR-ID                            
               PERFORM 7220-GET-PCOGBR-FACTOR THRU 7220-EXIT            
               MOVE SA-FACTOR TO WS-FACTOR-PCOGBR                       
                                                                        
               COMPUTE                                                  
                   WS-NO-UNITS ROUNDED = WS-PNLTY-UNITS                 
               END-COMPUTE                                              
                                                                        
               COMPUTE                                                  
                   WS-TOTAL-PNLTY-PRICE ROUNDED =                       
                               (PS-SCHED-PRICE-AM + WS-FACTOR-PCOGBR)   
               END-COMPUTE                                              
                                                                        
               COMPUTE                                                  
                 WS-PNLTY-COG ROUNDED =                                 
                   WS-NO-UNITS * WS-TOTAL-PNLTY-PRICE                   
               END-COMPUTE                                              
                                                                        
               MOVE WS-PREV-ACCOUNT-NO   TO CA482-ACCOUNT-NO            
               MOVE WS-CUSTOMER-NAME     TO CA482-CUSTOMER-NAME         
               MOVE WS-PREV-SVC-CAT-CD   TO CA482-SVC-CAT-CD            
               MOVE PS-SCHED-PRICE-AM    TO CA482-CUSTOMER-MRKUP        
               MOVE WS-FACTOR-PCOGBR     TO CA482-PCOGBR-FACTOR         
               MOVE WS-TOTAL-PNLTY-PRICE TO CA482-TOTAL-PNLTY-PRICE     
               MOVE WS-NO-UNITS          TO CA482-PENALTY-UNITS         
               MOVE WS-PNLTY-COG         TO CA482-PENALTY-REVENUE       
                                                                        
               WRITE FCSCA482-REC FROM ws-FCSCA482-REC                  
                                                                        
               IF NOT FRP0482-SUCCESSFUL                                
                  DISPLAY '** PCSRP048  PROCESSING ERROR   **'          
                  DISPLAY '** WRITE ERROR ON FILE FIOCA482 **'          
                  DISPLAY '** PROCESSING TERMINATED        **'          
                  DISPLAY '** STATUS IS ' WS-FRP0482-STATUS             
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
                                                                        
               INITIALIZE WS-PNLTY-UNITS                                
                          WS-NO-UNITS                                   
                          WS-TOTAL-PNLTY-PRICE                          
                          WS-PNLTY-COG                                  
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 11580000
      ***************************************************************** 11590000
      * 2210-GET-FACTORS.                                             * 11600003
      *     TO RETRIEVE FACTORS.                                      * 11610000
      ***************************************************************** 11620000
       2210-GET-FACTORS.                                                
                                                                        
      * GET TRANSCO FACTOR                                              11650000
                                                                        
            MOVE 'TRANSCO' TO SA-FACTOR-ID                              
                                                                        
            PERFORM 7210-GET-FACTOR-PRICE  THRU 7210-EXIT               
            MOVE SA-FACTOR TO WS-FACTOR-TRANSCO                         
                                                                        
      *  GET EMERGAS FACTOR                                             11770000
                                                                        
            MOVE 'EMERGAS' TO SA-FACTOR-ID                              
            PERFORM 7210-GET-FACTOR-PRICE  THRU 7210-EXIT               
            MOVE SA-FACTOR TO WS-FACTOR-EMERGAS                         
                                                                        
      *    GET COG BR FACTOR                                            11940000
                                                                        
            MOVE 'COG BR' TO SA-FACTOR-ID                               
            PERFORM 7210-GET-FACTOR-PRICE  THRU 7210-EXIT               
            MOVE SA-FACTOR TO WS-FACTOR-COGBR .                         
                                                                        
                                                                        
        2210-EXIT.                                                      
            EXIT.                                                       
      *                                                                 12080000
      ***************************************************************** 12090000
      * 2220-SELECT-MAX-PRICE.                                        * 12100010
      *     TO RETRIEVE MAX PRICES.                                   * 12110000
      ***************************************************************** 12120000
        2220-SELECT-MAX-PRICE.                                          
                                                                        
           IF WS-PRICE1 > WS-BASE-RATE AND                              
              WS-PRICE1 > WS-FACTOR-EMERGAS                             
              COMPUTE WS-MAX-PRICE = WS-PRICE1                          
           ELSE                                                         
              IF WS-BASE-RATE > WS-FACTOR-EMERGAS                       
                 COMPUTE WS-MAX-PRICE = WS-BASE-RATE                    
              ELSE                                                      
                 COMPUTE WS-MAX-PRICE = WS-FACTOR-EMERGAS               
              END-IF                                                    
           END-IF.                                                      
                                                                        
        2220-EXIT.                                                      
            EXIT.                                                       
      *                                                                 12280000
      ***************************************************************** 12290000
      * 4000-MAIL-NAME-ADDRESS                                        * 12300000
      *     TO GET CUSTOMER NAME, ADDRESS, BILLING ADDRESS            * 12310000
      ***************************************************************** 12320000
            EXEC SQL                                                    12330000
                INCLUDE CPD00074                                        12340000
            END-EXEC.                                                   12350000
                                                                        
            EXEC SQL                                                    12360000
                INCLUDE CPD00004                                        12370000
            END-EXEC.                                                   12380000
      *                                                                 12390000
      ******************************************************************12480000
      *   6240-GET-FCA00-COMMON-DATE.                                  *12490000
      ******************************************************************12500000
      *                                                                 12510000
       COPY CPD00040.                                                   12520000
      *                                                                 12530000
      ******************************************************************12540000
      * 6251-GET-FJC01-DATE.                                           *12550000
      ******************************************************************12560000
       COPY CPD00037.                                                   12570000
      *                                                                 12580000
      ******************************************************************12590000
      *    7000-OPEN-BILLDET-CUR                                        12600003
      ******************************************************************12610000
      *                                                                 12620000
       7000-OPEN-BILLDET-CUR.                                           
                                                                        
            MOVE '7200'                  TO ACTIVE-PARAGRAPH.           
                                                                        
            EXEC SQL                                                    
                 OPEN BILLDET_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '7000-OPEN-BILLDET-CUR'                         
                DISPLAY 'RETURN CODE =' WS-ACTIVE-RETURN-CODE           
                DISPLAY 'WS-EXTRACT-REV-MNTH   ' WS-WORK-REV-MONTH      
                PERFORM 9900-ABEND       THRU 9900-EXIT                 
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12850000
      *    FETCHES BILLDET-CUR CURSOR                                   12860001
      ******************************************************************12870000
      *                                                                 12880000
       7010-FETCH-BILLDET-CUR.                                          
                                                                        
           MOVE '7210'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
               FETCH BILLDET_CUR                                        
                INTO :BZ-ACCOUNT-NO                                     
                    ,:BG-RATE-PLAN-NO                                   
                    ,:Z4-PRTY-SVC-CAT-CD                                
                    ,:BZ-CODE-UTIL-TYPE                                 
                    ,:BZ-IC-NO                                          
                    ,:BZ-BILL-NO                                        
                    ,:BZ-BILL-ITEM-TIMESTMP                             
                    ,:BZ-CMPNT-ID-CD                                    
                    ,:BZ-BILL-UNITS                                     
                    ,:BZ-UNIT-PRICE-AM                                  
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REVENUE-MONTH                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            BG-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
               DISPLAY '7010-FETCH-BILLDET-CUR'                         
               DISPLAY 'RETURN CODE         = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY 'WS-REVENUE-MONTH    = ' WS-WORK-REV-MONTH       
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13330000
      ******************************************************************13340000
      *    CLOSES BILLDET-CUR                                           13350001
      ******************************************************************13360000
      *                                                                 13370000
       7020-CLOSE-BILLDET-CUR.                                          
                                                                        
           MOVE '7220'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
               CLOSE BILLDET_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7020-CLOSE-BILLDET-CUR'                         
               DISPLAY 'RETURN CODE =' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13581003
      *    7100-OPEN-VOLDET-CUR                                         13582003
      ******************************************************************13583003
      *                                                                 13584003
       7100-OPEN-VOLDET-CUR .                                           
                                                                        
            MOVE '7100'                  TO ACTIVE-PARAGRAPH.           
                                                                        
            EXEC SQL                                                    
                 OPEN VOLDET_CUR                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '7100-OPEN-VOLDET-CUR'                          
                DISPLAY 'RETURN CODE =' WS-ACTIVE-RETURN-CODE           
                DISPLAY 'ACCOUNT NO  = ' ND-ACCOUNT-NO                  
                DISPLAY 'BILL NO     = ' ND-BILL-NO                     
                DISPLAY 'CODE UTIL   = ' ND-CODE-UTIL-TYPE              
                DISPLAY 'IC NO       = ' ND-IC-NO                       
                DISPLAY 'TIME STAMP  = ' ND-BILL-ITEM-TIMESTMP          
                DISPLAY 'START DATE  = ' WS-START-DATE                  
                DISPLAY 'END   DATE  = ' WS-END-DATE                    
                PERFORM 9900-ABEND       THRU 9900-EXIT                 
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13591403
      *    7110-FETCH-VOLDET-CUR                                        13591503
      ******************************************************************13591603
      *                                                                 13591703
       7110-FETCH-VOLDET-CUR .                                          
                                                                        
            MOVE '7110'                  TO ACTIVE-PARAGRAPH.           
                                                                        
            EXEC SQL FETCH VOLDET_CUR                                   
                INTO :ND-DATE-READ                                      
                    ,:ND-VOL-TYPE-CD                                    
                    ,:ND-NO-UNITS                                       
                    ,:WS-RP-DATE                                        
            END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            ND-RETURN-CODE.             
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '7110-FETCH-VOLDET-CUR'                         
                DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
                DISPLAY 'ACCOUNT NO  = ' ND-ACCOUNT-NO                  
                DISPLAY 'BILL NO     = ' ND-BILL-NO                     
                DISPLAY 'CODE UTIL   = ' ND-CODE-UTIL-TYPE              
                DISPLAY 'IC NO       = ' ND-IC-NO                       
                DISPLAY 'TIME STAMP  = ' ND-BILL-ITEM-TIMESTMP          
                DISPLAY 'START DATE  = ' WS-START-DATE                  
                DISPLAY 'END   DATE  = ' WS-END-DATE                    
                PERFORM 9900-ABEND       THRU 9900-EXIT                 
            END-IF.                                                     
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13595016
      *    7120-CLOSE-VOLDET-CUR                                        13595116
      ******************************************************************13595216
      *                                                                 13595316
       7120-CLOSE-VOLDET-CUR .                                          
                                                                        
            MOVE '7120'                  TO ACTIVE-PARAGRAPH.           
                                                                        
            EXEC SQL                                                    
                 CLOSE VOLDET_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '7120-CLOSE-VOLDET-CUR'                         
                DISPLAY 'RETURN CODE =' WS-ACTIVE-RETURN-CODE           
                PERFORM 9900-ABEND       THRU 9900-EXIT                 
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13597616
      *    7200-GET-MARK-UP-PRICE                                       13597716
      ******************************************************************13597816
       7200-GET-MARK-UP-PRICE.                                          
                                                                        
           EXEC SQL                                                     
             SELECT PS.SCHED_PRICE_AM                                   
               INTO :PS-SCHED-PRICE-AM                                  
               FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                    
              WHERE PS.RATE_PLAN_NO       = :BG-RATE-PLAN-NO            
                AND PS.CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE          
                AND PS.CMPNT_ID_CD        = :BZ-CMPNT-ID-CD             
                AND PS.VERSION_NO_CNTRL   =                             
                    (SELECT MAX(VERSION_NO_CNTRL)                       
                       FROM  CSS_RATE_CREATOR       RT
                           WITH(READUNCOMMITTED)                  
                      WHERE RT.RATE_PLAN_NO       = PS.RATE_PLAN_NO     
                        AND RT.CODE_UTIL_TYPE     = PS.CODE_UTIL_TYPE   
                        AND RT.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )       
                    )                                                   
                AND PS.CODE_SEASON        = 'B'                         
                AND PS.CODE_USE_INST_TYPE = 'R'                         
                AND PS.BLOCK_NO           = 1                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13598116
MFA-TR*      SELECT PS.SCHED_PRICE_AM                                   13598216
MFA-TR*        INTO :PS-SCHED-PRICE-AM                                  13598316
MFA-TR*        FROM CSS_PRICE_SCHED PS                                  13598416
MFA-TR*       WHERE PS.RATE_PLAN_NO       = :BG-RATE-PLAN-NO            13598517
MFA-TR*         AND PS.CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE          13598617
MFA-TR*         AND PS.CMPNT_ID_CD        = :BZ-CMPNT-ID-CD             13598716
MFA-TR*         AND PS.VERSION_NO_CNTRL   =                             13598816
MFA-TR*             (SELECT MAX(VERSION_NO_CNTRL)                       13598916
MFA-TR*                FROM  CSS_RATE_CREATOR       RT                  13599016
MFA-TR*               WHERE RT.RATE_PLAN_NO       = PS.RATE_PLAN_NO     13599116
MFA-TR*                 AND RT.CODE_UTIL_TYPE     = PS.CODE_UTIL_TYPE   13599216
MFA-TR*                 AND RT.FROM_EFFECTIVE_DT <= :ND-DATE-READ       13599316
MFA-TR*             )                                                   13599416
MFA-TR*         AND PS.CODE_SEASON        = 'B'                         13599516
MFA-TR*         AND PS.CODE_USE_INST_TYPE = 'R'                         13599616
MFA-TR*         AND PS.BLOCK_NO           = 1                           13599716
MFA-TR*         WITH UR                                                 13599816
MFA-TR*         QUERYNO 7210                                            13599916
MFA-TR*    END-EXEC.                                                    13600016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7200-GET-MARK-UP-PRICE'                         
               DISPLAY 'RETURN CODE  = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'RATE PLAN NO = ' BG-RATE-PLAN-NO                
               DISPLAY 'CODE UTIL    = ' BZ-CODE-UTIL-TYPE              
               DISPLAY 'CMPNT ID CD  = ' BZ-CMPNT-ID-CD                 
               DISPLAY 'DATE READ    = ' ND-DATE-READ                   
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13602916
      *    7210-GET-FACTOR-PRICE                                        13603016
      ******************************************************************13603116
       7210-GET-FACTOR-PRICE.                                           
                                                                        
           EXEC SQL                                                     
            SELECT SA.FACTOR                                            
              INTO :SA-FACTOR                                           
              FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                  
                  ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                  
             WHERE SA.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE            
               AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO              
               AND SA.FACTOR_ID         = :SA-FACTOR-ID                 
               AND SA.CMPNT_ID_CD       = :BZ-CMPNT-ID-CD               
               AND SA.CODE_STATUS       = 'A'                           
               AND SF.FACTOR_TYPE       = 'A'                           
               AND SA.FACTOR_ID         = SF.FACTOR_ID                  
               AND SA.INSTR_USE_TYPE_CD = 'R'                           
               AND SA.DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                 
               AND SA.DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13604003
MFA-TR*     SELECT SA.FACTOR                                            13604203
MFA-TR*       INTO :SA-FACTOR                                           13604303
MFA-TR*       FROM CSS_SPCL_FCTR_APPL SA                                13604403
MFA-TR*           ,CSS_SPCL_FCTR      SF                                13604503
MFA-TR*      WHERE SA.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE            13604717
MFA-TR*        AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO              13604817
MFA-TR*        AND SA.FACTOR_ID         = :SA-FACTOR-ID                 13604903
MFA-TR*        AND SA.CMPNT_ID_CD       = :BZ-CMPNT-ID-CD               13605003
MFA-TR*        AND SA.CODE_STATUS       = 'A'                           13605103
MFA-TR*        AND SF.FACTOR_TYPE       = 'A'                           13605203
MFA-TR*        AND SA.FACTOR_ID         = SF.FACTOR_ID                  13605303
MFA-TR*        AND SA.INSTR_USE_TYPE_CD = 'R'                           13605403
MFA-TR*        AND SA.DATE_FROM        <= :ND-DATE-READ                 13605507
MFA-TR*        AND SA.DATE_TO          >= :ND-DATE-READ                 13605607
MFA-TR*        WITH UR                                                  13605703
MFA-TR*        QUERYNO 7210                                             13605803
MFA-TR*    END-EXEC.                                                    13605903

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO SA-FACTOR                                
              END-IF                                                    
           ELSE                                                         
               DISPLAY '7210-GET-FACTOR-PRICE'                          
               DISPLAY 'RETURN CODE  = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'CODE UTIL    = ' BG-CODE-UTIL-TYPE              
               DISPLAY 'RATE PLAN NO = ' BG-RATE-PLAN-NO                
               DISPLAY 'FACTOR ID    = ' SA-FACTOR-ID                   
               DISPLAY 'CMPNT ID CD  = ' BZ-CMPNT-ID-CD                 
               DISPLAY 'DATE READ    = ' ND-DATE-READ                   
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13608316
      *    7220-GET-PCOGBR-FACTOR                                       13608416
      ******************************************************************13608516
       7220-GET-PCOGBR-FACTOR.                                          
                                                                        
           EXEC SQL                                                     
            SELECT SA.FACTOR                                            
              INTO :SA-FACTOR                                           
              FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                  
                  ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                  
             WHERE SA.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE            
               AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO              
               AND SA.FACTOR_ID         = :SA-FACTOR-ID                 
               AND SA.CMPNT_ID_CD       = :BZ-CMPNT-ID-CD               
               AND SA.CODE_STATUS       = 'A'                           
               AND SF.FACTOR_TYPE       = 'A'                           
               AND SA.FACTOR_ID         = SF.FACTOR_ID                  
               AND SA.INSTR_USE_TYPE_CD = 'R'                           
               AND SA.DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                
               AND SA.DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13608816
MFA-TR*     SELECT SA.FACTOR                                            13608916
MFA-TR*       INTO :SA-FACTOR                                           13609016
MFA-TR*       FROM CSS_SPCL_FCTR_APPL SA                                13609116
MFA-TR*           ,CSS_SPCL_FCTR      SF                                13609216
MFA-TR*      WHERE SA.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE            13609317
MFA-TR*        AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO              13609417
MFA-TR*        AND SA.FACTOR_ID         = :SA-FACTOR-ID                 13609516
MFA-TR*        AND SA.CMPNT_ID_CD       = :BZ-CMPNT-ID-CD               13609616
MFA-TR*        AND SA.CODE_STATUS       = 'A'                           13609716
MFA-TR*        AND SF.FACTOR_TYPE       = 'A'                           13609816
MFA-TR*        AND SA.FACTOR_ID         = SF.FACTOR_ID                  13609916
MFA-TR*        AND SA.INSTR_USE_TYPE_CD = 'R'                           13610016
MFA-TR*        AND SA.DATE_FROM        <= :WS-START-DATE                13610116
MFA-TR*        AND SA.DATE_TO          >= :WS-END-DATE                  13610216
MFA-TR*        WITH UR                                                  13610316
MFA-TR*        QUERYNO 7210                                             13610416
MFA-TR*    END-EXEC.                                                    13610516

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO SA-FACTOR                                
              END-IF                                                    
           ELSE                                                         
               DISPLAY '7220-GET-PCOGBR-FACTOR'                         
               DISPLAY 'RETURN CODE  = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'CODE UTIL    = ' BZ-CODE-UTIL-TYPE              
               DISPLAY 'RATE PLAN NO = ' BG-RATE-PLAN-NO                
               DISPLAY 'FACTOR ID    = ' SA-FACTOR-ID                   
               DISPLAY 'CMPNT ID CD  = ' BZ-CMPNT-ID-CD                 
               DISPLAY 'START DATE   = ' WS-START-DATE                  
               DISPLAY 'END   DATE   = ' WS-END-DATE                    
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13612816
      *     7600-START-FCSJC01                                         *13612916
      ******************************************************************13613007
      *                                                                 13620000
            EXEC SQL                                                    13630000
              INCLUDE CPD00038                                          13640000
            END-EXEC.                                                   13650000
      ******************************************************************13660000
      *     7620-START-FCSCA00                                         *13670000
      ******************************************************************13680000
            EXEC SQL                                                    13690000
              INCLUDE CPD00039                                          13700000
            END-EXEC.                                                   13710000
                                                                        
      ******************************************************************14210000
      *     9000-TERMINATE                                             *14220000
      *     CLOSE FILES                                                *14230000
      ******************************************************************14240000
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA481-FILE.                                         
           CLOSE FCSCA482-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14340000
      *  9700-PROCESS-ABEND                                           * 14350000
      *                                                               * 14360000
      *    THIS PARAGRAPH:                                            * 14370000
      *      1) PROVIDES ABEND LOGIC FOR NAME/ADDRESS ROUTINE         * 14380000
      *                                                               * 14390000
      ***************************************************************** 14400000
       COPY CPD0023B.                                                   14410000
      ******************************************************************14420000
      *       THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *14430000
      ******************************************************************14440000
      *                                                                 14450000
           EXEC SQL                                                     14460000
               INCLUDE CPD09900                                         14470000
           END-EXEC.                                                    14480000
      *                                                                 14490000
      ******************************************************************14500000
