       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP041.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     APR 04, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***PRINTS A REPORT OF                                          ***        
      ***                                                            ***        
      ***   GAS METERS NOT TESTED                                    ***        
      ***   GAS METERS ALREADY PERIODIC TESTED                       ***        
      ***   GAS METERS NOT YET PERIODIC TESTED                       ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT055***  04/04/2016    VV7M728     GMC041 CONVERT EZT TO COBOL     ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
      ****************************************************************          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT INFILE1                                               
               ASSIGN TO UT-S-INFILE1                                   
           FILE STATUS IS WS-INFILE1-STATUS.                            
                                                                        
           SELECT INFILE2                                               
               ASSIGN TO UT-S-INFILE2                                   
           FILE STATUS IS WS-INFILE2-STATUS.                            
                                                                        
           SELECT INFILE3                                               
               ASSIGN TO UT-S-INFILE3                                   
           FILE STATUS IS WS-INFILE3-STATUS.                            
                                                                        
           SELECT FCSPT33-FILE                                          
               ASSIGN TO UT-S-FCSPT33                                   
           FILE STATUS IS WS-FCA33-STATUS.                              
      *                                                                         
           SELECT OUTFILE1                                              
               ASSIGN TO UT-S-OUTFILE1                                  
           FILE STATUS IS WS-FCA32-STATUS.                              
      *                                                                         
       COPY CSSPT331.                                                           
       COPY CSSPT332.                                                           
      *                                                                         
      ****************************************************************          
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  INFILE1                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE1-REC                     PIC X(230) VALUE SPACES.      
      *                                                                         
       FD  INFILE2                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE2-REC                     PIC X(230) VALUE SPACES.      
      *                                                                         
       FD  INFILE3                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE3-REC                     PIC X(230) VALUE SPACES.      
      *                                                                         
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
       COPY CFDPT332.                                                           
      *                                                                         
       FD  OUTFILE1                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 OUTFILE-REC.                                                  
          05 OUT-DEVICE-NO                PIC X(09) VALUE SPACES.       
          05 OUT-SERIAL-NO                PIC X(11) VALUE SPACES.       
          05 OUT-CODE-CRNT-LOC            PIC X(01) VALUE SPACES.       
          05 OUT-PREMISE-NO-EQ            PIC S9(11) USAGE COMP-3       
                                          VALUE ZERO.                   
          05 OUT-DATE-LAST-MOVE           PIC X(10) VALUE SPACES.       
          05 OUT-LOCAL-OFFICE             PIC X(03) VALUE SPACES.       
          05 OUT-COMPANY-NO               PIC X(02) VALUE SPACES.       
          05 OUT-DATE-LAST-TESTED         PIC X(10) VALUE SPACES.       
          05 OUT-METER-SIZE-ID            PIC X(08) VALUE SPACES.       
          05 OUT-TEST-SCHED-CD            PIC X(01) VALUE SPACES.       
          05 OUT-LAST-TEST-SEL-DT         PIC X(10) VALUE SPACES.       
          05 OUT-LAST-TEST-SEL-CD         PIC X(02) VALUE SPACES.       
          05 FILLER                       PIC X(127) VALUE SPACES.      
      *                                                                         
      ****************************************************************          
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP041'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOMT12.                                                            
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  05170000
      *    COPYBOOK FOR CSS_GAS_METER, GM                            *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBGASMTR                                         05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ****************************************************************  05170000
      *    COPYBOOK FOR CSS_EQUIPMENT, EQ                            *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBEQUIP                                          05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_COMPANY, C7                              *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBCOMPNY                                         05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER_SIZE,M5                        *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBGASMSZ                                         05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_LOCAL_OFFICET, B1                        *  05180000
      ****************************************************************  05190000
      *                                                                         
           EXEC SQL                                                     05200000
               INCLUDE TBLOCOFC                                         05210000
           END-EXEC.                                                    05220000
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
      *                                                                         
           05 WS-PREMISE-NO-EQ        PIC 9(10) VALUE ZEROES.           
           05 WS-PREMISE-NO-X          REDEFINES                        
              WS-PREMISE-NO-EQ        PIC X(10).                        
           05 WS-MSF-CD               PIC X(03) VALUE SPACES.           
           05 WS-METER-FOUND          PIC X(01) VALUE 'N'.              
           05 WS-DATA-FOUND           PIC X(01) VALUE 'N'.              
           05 WS-SKIP-REC             PIC X(01) VALUE 'N'.              
           05 WS-VAL1-DIFFERS         PIC X(01) VALUE 'N'.              
           05 WS-VAL2-DIFFERS         PIC X(01) VALUE 'N'.              
           05 WS-VAL3-DIFFERS         PIC X(01) VALUE 'Y'.              
           05 WS-LOC3-DIFFERS         PIC X(01) VALUE 'N'.              
           05 WS-VAL1-TRAILER         PIC X(01) VALUE 'N'.              
           05 WS-VAL2-TRAILER         PIC X(01) VALUE 'N'.              
           05 WS-TOTAL-IN             PIC 9(05) VALUE ZEROES.           
           05 WS-TOTAL-OUT            PIC 9(05) VALUE ZEROES.           
           05 WS-FILE1-PAGE-NO        PIC 9(06) VALUE 1.                
           05 WS-FILE2-PAGE-NO        PIC 9(06) VALUE 1.                
           05 WS-DT-MOVE-NULL         PIC S9(04) USAGE COMP             
                                      VALUE ZERO.                       
           05 WS-DT-TEST-NULL         PIC S9(04) USAGE COMP             
                                      VALUE ZERO.                       
           05 WS-DT-SEL-NULL          PIC S9(04) USAGE COMP             
                                      VALUE ZERO.                       
           05 WS-COMPANY-NO           PIC X(02) VALUE SPACES.           
           05 WS-CURR-DATE-X          PIC X(10) VALUE SPACES.           
           05 WS-LOCAL-OFC            PIC X(03) VALUE SPACES.           
           05 WS-LOCAL-OFC-PREV1      PIC X(03) VALUE SPACES.           
           05 WS-MTR-SIZE-PREV1       PIC X(08) VALUE SPACES.           
           05 WS-COMPANY-NAME         PIC X(26) VALUE SPACES.           
           05 WS-LOCATION             PIC X(10) VALUE SPACES.           
           05 WS-ACCOUNT-NO           PIC 9(13) VALUE ZEROES.           
           05 WS-ACCOUNT-NOX           REDEFINES                        
              WS-ACCOUNT-NO           PIC X(13).                        
           05 WS-RTE-CYCLE.                                             
             10 FILLER                PIC X(01) VALUE SPACES.           
             10 WS-READ-CYCLE         PIC X(02) VALUE SPACES.           
             10 FILLER                PIC X(03) VALUE SPACES.           
             10 WS-READ-ROUTE         PIC 9(04) VALUE ZEROES.           
           05 WS-METER-NO             PIC X(09) VALUE SPACES.           
           05 WS-METER-CHK            PIC X(01) VALUE SPACES.           
           05 WS-CCF-CAP-PER-HR       PIC S9(08) USAGE COMP             
                                      VALUE ZERO.                       
           05 WS-COUNT-1              PIC 9(05) VALUE ZEROES.           
           05 WS-COUNT-2              PIC 9(05) VALUE ZEROES.           
           05 WS-COUNT-3              PIC 9(05) VALUE ZEROES.           
           05 WS-COUNT-1-TOT          PIC 9(10) VALUE ZEROES.           
           05 WS-COUNT-2-TOT          PIC 9(10) VALUE ZEROES.           
           05 WS-COUNT-3-TOT          PIC 9(10) VALUE ZEROES.           
           05 WS-COUNT-4-TOT          PIC 9(10) VALUE ZEROES.           
           05 WS-FILE1-COUNT          PIC 9(10) VALUE ZEROES.           
           05 WS-FILE2-COUNT          PIC 9(10) VALUE ZEROES.           
           05 WS-FILE1-TOT-COUNT      PIC 9(10) VALUE ZEROES.           
           05 WS-FILE2-TOT-COUNT      PIC 9(10) VALUE ZEROES.           
           05 WS-FILE1-LOC-COUNT      PIC 9(10) VALUE ZEROES.           
           05 WS-FILE2-LOC-COUNT      PIC 9(10) VALUE ZEROES.           
           05 WS-TOTAL                PIC 9(07) VALUE ZEROES.           
      *                                                                         
       01 WS-RP041-HDR1-REC-LN1.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN1-NAME             PIC X(09) VALUE 'GMC041-01'.    
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR1-LN1-COMPANY-NAME     PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(26) VALUE SPACES.         
           05 HDR1-LN1-DATE             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 HDR1-LN1-PAGE             PIC X(05) VALUE 'PAGE '.        
           05 HDR1-LN1-PAGE-NO          PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN2.                                        
           05 FILLER                    PIC X(50) VALUE SPACES.         
           05 HDR1-LN2-NAME             PIC X(34) VALUE                 
                          'GAS METERS ALREADY PERIODIC TESTED'.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN3.                                        
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR1-LN3-NAME             PIC X(12) VALUE 'LOCAL OFFICE'. 
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR1-LN3-LOCAL-OFC        PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR1-LN3-LOCAL-DESC       PIC X(22) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN4.                                        
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR1-LN4-NAME             PIC X(12) VALUE 'METER SIZE: '. 
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR1-LN4-METER-ID         PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN5.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP041-HDR1-REC-LN6.                                        
           05 FILLER                    PIC X(30) VALUE SPACES.         
           05 HDR1-LN6-NAME             PIC X(08) VALUE 'LOCATION'.     
      *                                                                         
       01 WS-RP041-HDR1-REC-LN7.                                        
           05 FILLER                    PIC X(31) VALUE SPACES.         
           05 HDR1-LN7-NAME             PIC X(05) VALUE 'NAME/'.        
           05 FILLER                    PIC X(36) VALUE SPACES.         
           05 HDR1-LN7-NAME1            PIC X(04) VALUE 'DATE'.         
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 HDR1-LN7-NAME2            PIC X(04) VALUE 'DATE'.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN8.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN8-NAME1            PIC X(09) VALUE 'METER NBR'.    
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR1-LN8-NAME2            PIC X(11) VALUE 'SERIAL NBR '.  
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR1-LN8-NAME3            PIC X(09) VALUE ' ADDRESS '.    
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 HDR1-LN8-NAME4            PIC X(10) VALUE ' PREMISE  '.   
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR1-LN8-NAME5            PIC X(03) VALUE 'MSF'.          
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 HDR1-LN8-NAME6            PIC X(10) VALUE '  TESTED  '.   
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR1-LN8-NAME7            PIC X(10) VALUE ' SELECTED '.   
      *                                                                         
       01 WS-RP041-HDR1-REC-LN9.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR1-LN9-DEVICE-NO        PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR1-LN9-SERIAL-NO        PIC X(11) VALUE SPACES.         
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR1-LN9-LOCATION         PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR1-LN9-PREMISE          PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR1-LN9-MSF-CD           PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 HDR1-LN9-LAST-TESTED      PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR1-LN9-TEST-SEL-DT      PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR1-REC-LN10.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR1-LN10-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS SIZE    = '.         
           05 HDR1-LN10-TOTAL           PIC ZZZZZZZZZ9.                 
      *                                                                         
       01 WS-RP041-HDR1-REC-LN11.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR1-LN11-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS OFFICE  = '.         
           05 HDR1-LN11-TOTAL           PIC ZZZZZZZZZ9.                 
      *                                                                         
       01 WS-RP041-HDR1-REC-LN12.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR1-LN12-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS REPORT  = '.         
           05 HDR1-LN12-TOTAL           PIC ZZZZZZZZZ9.                 
      **************************************************************            
      *                                                                         
       01 WS-RP041-HDR2-REC-LN1.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR2-LN1-NAME             PIC X(09) VALUE 'GMC041-02'.    
           05 FILLER                    PIC X(37) VALUE SPACES.         
           05 HDR2-LN1-COMPANY-NAME     PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(26) VALUE SPACES.         
           05 HDR2-LN1-DATE             PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 HDR2-LN1-PAGE             PIC X(05) VALUE 'PAGE '.        
           05 HDR2-LN1-PAGE-NO          PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN2.                                        
           05 FILLER                    PIC X(50) VALUE SPACES.         
           05 HDR2-LN2-NAME             PIC X(28) VALUE                 
                          'PERIODIC TEST NOT YET TESTED'.               
      *                                                                         
       01 WS-RP041-HDR2-REC-LN3.                                        
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR2-LN3-NAME             PIC X(12) VALUE 'LOCAL OFFICE'. 
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR2-LN3-LOCAL-OFC        PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR2-LN3-LOCAL-DESC       PIC X(22) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN4.                                        
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR2-LN4-NAME             PIC X(12) VALUE 'METER SIZE: '. 
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR2-LN4-METER-ID         PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN5.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP041-HDR2-REC-LN6.                                        
           05 FILLER                    PIC X(30) VALUE SPACES.         
           05 HDR2-LN6-NAME             PIC X(08) VALUE 'LOCATION'.     
           05 FILLER                    PIC X(48) VALUE SPACES.         
           05 HDR2-LN6-NAME1            PIC X(04) VALUE 'DATE'.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN7.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR2-LN7-NAME1            PIC X(10) VALUE 'METER NBR/'.   
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR2-LN7-NAME2            PIC X(11) VALUE 'SERIAL NBR/'.  
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR2-LN7-NAME3            PIC X(11) VALUE 'NAME/'.        
           05 FILLER                    PIC X(30) VALUE SPACES.         
           05 HDR2-LN7-NAME4            PIC X(04) VALUE 'DATE'.         
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 HDR2-LN7-NAME5            PIC X(09) VALUE 'SELECTED/'.    
      *                                                                         
       01 WS-RP041-HDR2-REC-LN8.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR2-LN8-NAME1            PIC X(10) VALUE ' ACCT NBR '.   
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR2-LN8-NAME2            PIC X(11) VALUE 'CYC/ RD RTE'.  
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR2-LN8-NAME3            PIC X(07) VALUE 'ADDRESS'.      
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 HDR2-LN8-NAME4            PIC X(07) VALUE 'PREMISE'.      
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 HDR2-LN8-NAME5            PIC X(03) VALUE 'MSF'.          
           05 FILLER                    PIC X(09) VALUE SPACES.         
           05 HDR2-LN8-NAME6            PIC X(06) VALUE 'TESTED'.       
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 HDR2-LN8-NAME7            PIC X(04) VALUE 'CITY'.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN9.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR2-LN9-DEVICE-NO        PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 HDR2-LN9-SERIAL-NO        PIC X(11) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR2-LN9-LOCATION         PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR2-LN9-PREMISE          PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR2-LN9-MSF-CD           PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 HDR2-LN9-LAST-TESTED      PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR2-LN9-TEST-SEL-DT      PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN10.                                       
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR2-LN10-ACCOUNT-NOX     PIC X(13) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR2-LN10-RTE-CYCLE       PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR2-LN10-NAME            PIC X(50) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN11.                                       
           05 FILLER                    PIC X(29) VALUE SPACES.         
           05 HDR2-LN11-SERV-ADDR       PIC X(42) VALUE SPACES.         
           05 FILLER                    PIC X(13) VALUE SPACES.         
           05 HDR2-LN11-ADDR            PIC X(41) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR2-REC-LN12.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR2-LN12-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS SIZE    = '.         
           05 HDR2-LN12-TOTAL           PIC ZZZZZZZZZ9.                 
      *                                                                         
       01 WS-RP041-HDR2-REC-LN13.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR2-LN13-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS OFFICE  = '.         
           05 HDR2-LN13-TOTAL           PIC ZZZZZZZZZ9.                 
      *                                                                         
       01 WS-RP041-HDR2-REC-LN14.                                       
           05 FILLER                    PIC X(24) VALUE SPACES.         
           05 HDR2-LN14-NAME1           PIC X(23) VALUE                 
                                     'TOTAL METERS REPORT  = '.         
           05 HDR2-LN14-TOTAL           PIC ZZZZZZZZZ9.                 
      *                                                                         
      **************************************************************            
      *                                                                         
       01 WS-RP041-HDR3-REC-LN1.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN1-NAME             PIC X(09) VALUE 'GMC040-03'.    
           05 FILLER                    PIC X(46) VALUE SPACES.         
           05 HDR3-LN1-COMPANY-NAME     PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR3-LN1-PAGE             PIC X(04) VALUE 'PAGE'.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 HDR3-LN1-PAGE-NO          PIC 9(01) VALUE 1.              
      *                                                                         
       01 WS-RP041-HDR3-REC-LN2.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN2-NAME             PIC X(13) VALUE 'REPORT DATE :'.
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN2-RPT-DT           PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(17) VALUE SPACES.         
           05 HDR3-LN2-NAME1            PIC X(36) VALUE                 
                        'PERIODIC TEST NOT YET TESTED-SUMMARY'.         
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR3-LN2-NAME2            PIC X(09) VALUE 'RUN-DATE:'.    
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN2-DATE             PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR3-REC-LN3.                                        
           05 FILLER                    PIC X(113) VALUE SPACES.        
           05 HDR3-LN3-NAME             PIC X(09) VALUE 'RUN-TIME:'.    
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN3-TIME             PIC X(08) VALUE SPACES.         
      *                                                                         
       01 WS-RP041-HDR3-REC-LN4.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP041-HDR3-REC-LN5.                                        
           05 FILLER                    PIC X(45) VALUE SPACES.         
           05 HDR3-LN5-NAME             PIC X(07) VALUE 'GROUP 1'.      
           05 FILLER                    PIC X(16) VALUE SPACES.         
           05 HDR3-LN5-NAME             PIC X(07) VALUE 'GROUP 3'.      
           05 FILLER                    PIC X(18) VALUE SPACES.         
           05 HDR3-LN5-NAME             PIC X(06) VALUE 'GROUP4'.       
      *                                                                         
       01 WS-RP041-HDR3-REC-LN6.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
      *                                                                         
       01 WS-RP041-HDR3-REC-LN7.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR3-LN7-NAME             PIC X(13) VALUE 'OFFICE NUMBER'.
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 HDR3-LN7-NAME1            PIC X(11) VALUE 'OFFICE NAME'.  
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 HDR3-LN7-NAME2            PIC X(13) VALUE '(< 251 CF/HR)'.
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR3-LN7-NAME3            PIC X(26) VALUE                 
                                       '(>= 251 AND <= 1500 CF/HR)'.    
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 HDR3-LN7-NAME4            PIC X(14) VALUE                 
                                       '(> 1500 CF/HR)'.                
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 HDR3-LN7-NAME5            PIC X(12) VALUE 'OFFICE TOTAL'. 
      *                                                                         
       01 WS-RP041-HDR3-REC-LN8.                                        
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 HDR3-LN8-LOCAL-OFC        PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 HDR3-LN8-LOCAL-DESC       PIC X(22) VALUE SPACES.         
           05 FILLER                    PIC X(05) VALUE SPACES.         
           05 HDR3-LN8-COUNT1           PIC ZZZZ9.                      
           05 FILLER                    PIC X(20) VALUE SPACES.         
           05 HDR3-LN8-COUNT2           PIC ZZZZ9.                      
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR3-LN8-COUNT3           PIC ZZZZ9.                      
           05 FILLER                    PIC X(12) VALUE SPACES.         
           05 HDR3-LN8-TOTAL            PIC ZZZZZZ9.                    
      *                                                                         
       01 WS-RP041-HDR3-REC-LN9.                                        
           05 FILLER                    PIC X(41) VALUE SPACES.         
           05 HDR3-LN9-TOTAL1           PIC ZZZZZZZZZ9.                 
           05 FILLER                    PIC X(15) VALUE SPACES.         
           05 HDR3-LN9-TOTAL2           PIC ZZZZZZZZZ9.                 
           05 FILLER                    PIC X(14) VALUE SPACES.         
           05 HDR3-LN9-TOTAL3           PIC ZZZZZZZZZ9.                 
           05 FILLER                    PIC X(09) VALUE SPACES.         
           05 HDR3-LN9-TOTAL4           PIC ZZZZZZZZZ9.                 
      *                                                                         
       01 WS-RP041-HDR3-REC-LN10.                                       
           05 FILLER                    PIC X(51) VALUE SPACES.         
           05 HDR3-LN10-NAME            PIC X(21) VALUE                 
                                       '*** END OF REPORT ***'.         
      *                                                                         
      **************************************************************            
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
      *                                                                         
       05  WS-CURR-DATE.                                                
           10  WS-REPORT-CCYY         PIC 9(04) VALUE ZEROES.           
           10  WS-FILLER1             PIC X(01) VALUE '-'.              
           10  WS-REPORT-MM           PIC 9(02) VALUE ZEROES.           
           10  WS-FILLER2             PIC X(01) VALUE '-'.              
           10  WS-REPORT-XX           PIC X(02) VALUE SPACES.           
      *                                                                         
       05  WS-REPORT-DATE.                                              
           10  WS-RPT-MONTH           PIC X(02) VALUE SPACES.           
           10  WS-FILLER3             PIC X(01) VALUE '/'.              
           10  WS-RPT-YEAR            PIC X(04) VALUE SPACES.           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-N                   PIC X(01) VALUE 'N'.              
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-INFILE1-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE1-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC1                   VALUE '10'.             
           05  WS-INFILE2-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE2-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC2                   VALUE '10'.             
           05  WS-INFILE3-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE3-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC3                   VALUE '10'.             
           05  WS-FCA33-STATUS          PIC X(02).                      
               88 FCA33-SUCCESSFUL                VALUE '00'.           
           05  WS-FCA32-STATUS          PIC X(02).                      
               88 FCA32-SUCCESSFUL                VALUE '00'.           
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
           05  WS-FCA332-STATUS         PIC X(02).                      
               88 FCA332-SUCCESSFUL               VALUE '00'.           
      *                                                                         
      ******************************************************************        
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-TEST-METERS         THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
      *    MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME.                  
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
      *    MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DATE                   
      *                                      HDR-LAST-TEST-SEL-DT.              
                                                                        
      *                                                                         
           OPEN INPUT INFILE1.                                          
                                                                        
           IF NOT INFILE1-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE1.         **'          
               DISPLAY '**  FILE STATUS = ' WS-INFILE1-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN INPUT INFILE2.                                          
                                                                        
           IF NOT INFILE2-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE2.         **'          
               DISPLAY '**  FILE STATUS = ' WS-INFILE2-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN INPUT INFILE3.                                          
                                                                        
           IF NOT INFILE3-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE3.          **'         
               DISPLAY '**  FILE STATUS = ' WS-INFILE3-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
           IF NOT FCA33-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT33-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA33-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN OUTPUT FCSPT331-FILE                                    
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN OUTPUT FCSPT332-FILE.                                   
                                                                        
           IF NOT FCA332-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT332-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA332-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN OUTPUT OUTFILE1                                         
                                                                        
           IF NOT FCA32-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP041 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT32-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA32-STATUS             
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
      *                                                                 08335000
           INITIALIZE INFILE1-REC                                       
                      INFILE2-REC                                       
                      INFILE3-REC                                       
                      OUTFILE-REC                                       
                      PRT33-RECORD                                      
                      PRT331-RECORD                                     
                      PRT332-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2000-PROCESS-TEST-METERS                                               
      ******************************************************************        
      *                                                                         
       2000-PROCESS-TEST-METERS.                                        
      *                                                                         
           PERFORM 7500-READ-INFILE1                THRU 7500-EXIT.     
                                                                        
           IF E-FMT12-COMPANY-NO EQUAL X'00' OR X'FF' OR '00' OR '  '   
             MOVE '01'                    TO WS-COMPANY-NO              
           ELSE                                                         
             MOVE E-FMT12-COMPANY-NO      TO WS-COMPANY-NO              
           END-IF.                                                      
                                                                        
           DISPLAY 'WS-COMPANY-NO: ' WS-COMPANY-NO                      
                                                                        
           PERFORM 7000-GET-COMPANY-NAME            THRU 7000-EXIT      
                                                                        
           MOVE WS-REPORT-CCYY            TO WS-RPT-YEAR                
           MOVE WS-REPORT-MM              TO WS-RPT-MONTH               
      *                                                                         
           PERFORM 2100-PROCESS-REPORT1             THRU 2100-EXIT      
              UNTIL END-OF-REC1.                                        
           MOVE WS-FILE1-LOC-COUNT        TO HDR1-LN11-TOTAL            
           MOVE WS-FILE1-TOT-COUNT        TO HDR1-LN12-TOTAL            
                                                                        
           IF HDR1-LN12-TOTAL NOT = ZEROES                              
             PERFORM 8130-WRITE-OUTFILE1            THRU 8130-EXIT      
           END-IF                                                       
      *                                                                         
           MOVE SPACES                    TO WS-LOCAL-OFC-PREV1         
           MOVE SPACES                    TO WS-MTR-SIZE-PREV1          
      *                                                                         
           PERFORM 7600-READ-INFILE2                THRU 7600-EXIT.     
           PERFORM 2200-PROCESS-REPORT2             THRU 2200-EXIT      
              UNTIL END-OF-REC2.                                        
           MOVE WS-FILE2-LOC-COUNT        TO HDR2-LN13-TOTAL            
           MOVE WS-FILE2-TOT-COUNT        TO HDR2-LN14-TOTAL            
           PERFORM 8230-WRITE-OUTFILE2              THRU 8230-EXIT      
      *                                                                         
           MOVE SPACES                    TO WS-LOCAL-OFC-PREV1         
           MOVE SPACES                    TO WS-MTR-SIZE-PREV1          
                                                                        
           PERFORM 7700-READ-INFILE3                THRU 7700-EXIT.     
           PERFORM 2250-PROCESS-REPORT3             THRU 2250-EXIT      
              UNTIL END-OF-REC3.                                        
           PERFORM 8310-WRITE-OUTFILE3              THRU 8310-EXIT.     
                                                                        
           COMPUTE WS-COUNT-1-TOT = WS-COUNT-1-TOT + WS-COUNT-1         
           COMPUTE WS-COUNT-2-TOT = WS-COUNT-2-TOT + WS-COUNT-2         
           COMPUTE WS-COUNT-3-TOT = WS-COUNT-3-TOT + WS-COUNT-3         
           COMPUTE WS-COUNT-4-TOT = WS-COUNT-4-TOT + WS-TOTAL           
                                                                        
           MOVE WS-COUNT-1-TOT            TO HDR3-LN9-TOTAL1            
           MOVE WS-COUNT-2-TOT            TO HDR3-LN9-TOTAL2            
           MOVE WS-COUNT-3-TOT            TO HDR3-LN9-TOTAL3            
           MOVE WS-COUNT-4-TOT            TO HDR3-LN9-TOTAL4            
                                                                        
           PERFORM 8320-WRITE-OUTFILE3              THRU 8320-EXIT.     
                                                                        
           PERFORM 2800-END-OF-JOB                  THRU 2800-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2100-PROCESS-REPORT1.                                                  
      ******************************************************************        
      *                                                                         
       2100-PROCESS-REPORT1.                                            
      *                                                                         
      *    READ FILE                                                            
           DISPLAY 'MTR NBR = ' E-FMT12-METER-NO                        
           MOVE SPACES                    TO OUTFILE-REC                
           MOVE 'N'                       TO WS-METER-FOUND             
                                                                        
           MOVE E-FMT12-METER-NO          TO WS-METER-NO                
           MOVE WS-METER-NO(1:1)          TO WS-METER-CHK               
                                                                        
           IF WS-METER-CHK = '*'                                        
             MOVE '0'                     TO WS-METER-CHK               
           END-IF                                                       
                                                                        
           PERFORM 7100-GET-PERIODIC-TEST           THRU 7100-EXIT      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 'Y'                     TO WS-METER-FOUND             
             MOVE EQ-CRNT-LOC-NO          TO WS-PREMISE-NO-EQ           
                                                                        
             IF WS-DT-TEST-NULL < 0                                     
               MOVE SPACES                TO GM-DATE-LAST-TESTED        
             END-IF                                                     
                                                                        
             IF WS-DT-SEL-NULL < 0                                      
               MOVE SPACES                TO GM-LAST-TEST-SEL-DT        
             END-IF                                                     
           ELSE                                                         
             DISPLAY 'METER NOT FOUND ON CIS SYSTEM -'                  
             DISPLAY 'METER NBR = ' E-FMT12-METER-NO                    
           END-IF                                                       
                                                                        
           IF WS-METER-FOUND = 'Y'                                      
            IF GM-METER-SIZE-ID NOT = E-FMT12-METER-SIZE-ID             
      *       READ FILE                                                         
             MOVE 'Y'                     TO WS-SKIP-REC                
            ELSE                                                        
             MOVE 'N'                     TO WS-SKIP-REC                
             MOVE EQ-LOCAL-OFFICE         TO WS-MSF-CD                  
             MOVE E-FMT12-LOCAL-OFFICE    TO WS-LOCAL-OFC               
             PERFORM 7200-GET-LOCAL-OFFICE          THRU 7200-EXIT      
             PERFORM 2300-GET-LOCATION-DESC         THRU 2300-EXIT      
                                                                        
             IF GM-DATE-LAST-TESTED > E-FMT12-LAST-TEST-SEL-DT          
               PERFORM 2400-FORMAT-EQUIP-DATA       THRU 2400-EXIT      
               PERFORM 2500-FORMAT-OUTPUT1          THRU 2500-EXIT      
                                                                        
               IF E-FMT12-LOCAL-OFFICE NOT = WS-LOCAL-OFC-PREV1 OR      
                  GM-METER-SIZE-ID NOT = WS-MTR-SIZE-PREV1              
                                                                        
                 IF E-FMT12-LOCAL-OFFICE NOT = WS-LOCAL-OFC-PREV1       
                   ADD +1                 TO WS-FILE1-LOC-COUNT         
                 END-IF                                                 
                                                                        
                 MOVE 'Y'                 TO WS-VAL1-DIFFERS            
               ELSE                                                     
                 MOVE 'N'                 TO WS-VAL1-DIFFERS            
               END-IF                                                   
                                                                        
               IF WS-VAL1-DIFFERS = 'Y'                                 
                                                                        
                IF WS-VAL1-TRAILER = 'Y'                                
                  PERFORM 8120-WRITE-OUTFILE1       THRU 8120-EXIT      
                END-IF                                                  
                                                                        
                 MOVE WS-FILE1-PAGE-NO    TO HDR1-LN1-PAGE-NO           
                                                                        
                 PERFORM 8000-WRITE-OUTFILE1        THRU 8000-EXIT      
                 MOVE 'Y'                 TO WS-VAL1-TRAILER            
                 MOVE 0                   TO WS-FILE1-COUNT             
               END-IF                                                   
                                                                        
               PERFORM 8110-WRITE-OUTFILE1          THRU 8110-EXIT      
                                                                        
               MOVE WS-FILE1-COUNT        TO HDR1-LN10-TOTAL            
               MOVE E-FMT12-LOCAL-OFFICE  TO WS-LOCAL-OFC-PREV1         
               MOVE GM-METER-SIZE-ID      TO WS-MTR-SIZE-PREV1          
             ELSE                                                       
               DISPLAY 'EQ-CODE-CRNT-LOC: ' EQ-CODE-CRNT-LOC            
             END-IF                                                     
            END-IF                                                      
           END-IF.                                                      
                                                                        
           PERFORM 7500-READ-INFILE1                THRU 7500-EXIT.     
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2200-PROCESS-REPORT2.                                                  
      ******************************************************************        
      *                                                                         
       2200-PROCESS-REPORT2.                                            
      *                                                                         
           DISPLAY 'MTR NBR = ' E-FMT12-METER-NO                        
           MOVE SPACES                    TO OUTFILE-REC                
           MOVE 'N'                       TO WS-METER-FOUND             
                                                                        
           MOVE E-FMT12-METER-NO          TO WS-METER-NO                
           MOVE WS-METER-NO(1:1)          TO WS-METER-CHK               
                                                                        
           IF WS-METER-CHK = '*'                                        
             MOVE '0'                     TO WS-METER-CHK               
           END-IF                                                       
                                                                        
           PERFORM 7100-GET-PERIODIC-TEST           THRU 7100-EXIT      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 'Y'                     TO WS-METER-FOUND             
             MOVE EQ-CRNT-LOC-NO          TO WS-PREMISE-NO-EQ           
                                                                        
             IF WS-DT-TEST-NULL < 0                                     
               MOVE SPACES                TO GM-DATE-LAST-TESTED        
             END-IF                                                     
                                                                        
             IF WS-DT-SEL-NULL < 0                                      
               MOVE SPACES                TO GM-LAST-TEST-SEL-DT        
             END-IF                                                     
           ELSE                                                         
             DISPLAY 'METER NOT FOUND ON CIS SYSTEM -'                  
             DISPLAY 'METER NBR = ' E-FMT12-METER-NO                    
           END-IF                                                       
                                                                        
           IF WS-METER-FOUND = 'Y'                                      
            IF GM-METER-SIZE-ID NOT = E-FMT12-METER-SIZE-ID             
             MOVE 'Y'                     TO WS-SKIP-REC                
            ELSE                                                        
             MOVE 'N'                     TO WS-SKIP-REC                
             MOVE EQ-LOCAL-OFFICE         TO WS-MSF-CD                  
             MOVE E-FMT12-LOCAL-OFFICE    TO WS-LOCAL-OFC               
                                                                        
             PERFORM 7200-GET-LOCAL-OFFICE          THRU 7200-EXIT      
             PERFORM 2300-GET-LOCATION-DESC         THRU 2300-EXIT      
                                                                        
             IF GM-DATE-LAST-TESTED < E-FMT12-LAST-TEST-SEL-DT          
               MOVE E-FMT12-ACCT-NO       TO WS-ACCOUNT-NO              
               MOVE E-FMT12-READ-ROUTE    TO WS-READ-ROUTE              
               MOVE E-FMT12-READ-CYCLE    TO WS-READ-CYCLE              
                                                                        
               PERFORM 2600-FORMAT-OUTPUT2          THRU 2600-EXIT      
                                                                        
               IF E-FMT12-LOCAL-OFFICE NOT = WS-LOCAL-OFC-PREV1 OR      
                  GM-METER-SIZE-ID NOT = WS-MTR-SIZE-PREV1              
                                                                        
                 IF E-FMT12-LOCAL-OFFICE NOT = WS-LOCAL-OFC-PREV1       
                   ADD +1                 TO WS-FILE2-LOC-COUNT         
                 END-IF                                                 
                                                                        
                 MOVE 'Y'                 TO WS-VAL2-DIFFERS            
               ELSE                                                     
                 MOVE 'N'                 TO WS-VAL2-DIFFERS            
               END-IF                                                   
                                                                        
               IF WS-VAL2-DIFFERS = 'Y'                                 
                                                                        
                IF WS-VAL2-TRAILER = 'Y'                                
                  PERFORM 8220-WRITE-OUTFILE2       THRU 8220-EXIT      
                END-IF                                                  
                                                                        
                 MOVE WS-FILE2-PAGE-NO    TO HDR2-LN1-PAGE-NO           
                                                                        
                 PERFORM 8100-WRITE-OUTFILE2        THRU 8100-EXIT      
                 MOVE 'Y'                 TO WS-VAL2-TRAILER            
                 MOVE 0                   TO WS-FILE2-COUNT             
               END-IF                                                   
                                                                        
               PERFORM 8210-WRITE-OUTFILE2          THRU 8210-EXIT      
                                                                        
               MOVE WS-FILE2-COUNT        TO HDR2-LN12-TOTAL            
               MOVE E-FMT12-LOCAL-OFFICE  TO WS-LOCAL-OFC-PREV1         
               MOVE GM-METER-SIZE-ID      TO WS-MTR-SIZE-PREV1          
                                                                        
             END-IF                                                     
            END-IF                                                      
           END-IF.                                                      
                                                                        
           PERFORM 7600-READ-INFILE2                THRU 7600-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2250-PROCESS-REPORT3.                                                  
      ******************************************************************        
      *                                                                         
       2250-PROCESS-REPORT3.                                            
      *                                                                         
           DISPLAY 'MTR NBR = ' E-FMT12-METER-NO                        
           MOVE 'N'                       TO WS-METER-FOUND             
                                                                        
           MOVE E-FMT12-METER-NO          TO WS-METER-NO                
           MOVE WS-METER-NO(1:1)          TO WS-METER-CHK               
                                                                        
           IF WS-METER-CHK = '*'                                        
             MOVE '0'                     TO WS-METER-CHK               
           END-IF                                                       
                                                                        
           PERFORM 7100-GET-PERIODIC-TEST           THRU 7100-EXIT      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 'Y'                     TO WS-METER-FOUND             
             MOVE EQ-CRNT-LOC-NO          TO WS-PREMISE-NO-EQ           
                                                                        
             IF WS-DT-TEST-NULL < 0                                     
               MOVE SPACES                TO GM-DATE-LAST-TESTED        
             END-IF                                                     
                                                                        
             IF WS-DT-SEL-NULL < 0                                      
               MOVE SPACES                TO GM-LAST-TEST-SEL-DT        
             END-IF                                                     
           ELSE                                                         
             DISPLAY 'METER NOT FOUND ON CIS SYSTEM -'                  
             DISPLAY 'METER NBR = ' E-FMT12-METER-NO                    
           END-IF                                                       
                                                                        
           IF WS-METER-FOUND = 'Y'                                      
            IF GM-METER-SIZE-ID NOT = E-FMT12-METER-SIZE-ID             
             MOVE 'Y'                     TO WS-SKIP-REC                
            ELSE                                                        
             MOVE 'N'                     TO WS-SKIP-REC                
             MOVE EQ-LOCAL-OFFICE         TO WS-MSF-CD                  
             MOVE E-FMT12-LOCAL-OFFICE    TO WS-LOCAL-OFC               
                                                                        
             PERFORM 7200-GET-LOCAL-OFFICE          THRU 7200-EXIT      
             PERFORM 2300-GET-LOCATION-DESC         THRU 2300-EXIT      
                                                                        
             IF GM-DATE-LAST-TESTED < E-FMT12-LAST-TEST-SEL-DT          
               IF EQ-CODE-CRNT-LOC = 'J'                                
                                                                        
                 IF E-FMT12-LOCAL-OFFICE NOT = WS-LOCAL-OFC-PREV1       
                   MOVE 'Y'               TO WS-LOC3-DIFFERS            
                                                                        
                   COMPUTE WS-COUNT-1-TOT = WS-COUNT-1-TOT + WS-COUNT-1 
                   COMPUTE WS-COUNT-2-TOT = WS-COUNT-2-TOT + WS-COUNT-2 
                   COMPUTE WS-COUNT-3-TOT = WS-COUNT-3-TOT + WS-COUNT-3 
                                                                        
                   MOVE 0                 TO WS-COUNT-1                 
                   MOVE 0                 TO WS-COUNT-2                 
                   MOVE 0                 TO WS-COUNT-3                 
                                                                        
                   IF WS-VAL3-DIFFERS NOT = 'Y'                         
                     PERFORM 8310-WRITE-OUTFILE3    THRU 8310-EXIT      
                                                                        
                   COMPUTE WS-COUNT-4-TOT = WS-COUNT-4-TOT + WS-TOTAL   
                                                                        
                   END-IF                                               
                                                                        
                 ELSE                                                   
                   MOVE 'N'               TO WS-LOC3-DIFFERS            
                 END-IF                                                 
                                                                        
                 PERFORM 7300-GET-CF-PER-HR         THRU 7300-EXIT      
                 MOVE 'Y'                 TO WS-DATA-FOUND              
                                                                        
                 IF WS-CCF-CAP-PER-HR < 251                             
                   ADD +1                 TO WS-COUNT-1                 
                 ELSE                                                   
                   IF WS-CCF-CAP-PER-HR >= 251 AND                      
                      WS-CCF-CAP-PER-HR <= 1500                         
                     ADD +1               TO WS-COUNT-2                 
                   ELSE                                                 
                     ADD +1               TO WS-COUNT-3                 
                   END-IF                                               
                 END-IF                                                 
                                                                        
                 MOVE E-FMT12-LOCAL-OFFICE TO WS-LOCAL-OFC              
                                                                        
                 PERFORM 7200-GET-LOCAL-OFFICE      THRU 7200-EXIT      
                 PERFORM 2300-GET-LOCATION-DESC     THRU 2300-EXIT      
                 PERFORM 2700-FORMAT-OUTPUT3        THRU 2700-EXIT      
                                                                        
                 IF WS-VAL3-DIFFERS = 'Y'                               
                   PERFORM 8200-WRITE-OUTFILE3      THRU 8200-EXIT      
                   MOVE 'N'               TO WS-VAL3-DIFFERS            
                 END-IF                                                 
                                                                        
                 MOVE E-FMT12-LOCAL-OFFICE TO WS-LOCAL-OFC-PREV1        
               END-IF                                                   
             END-IF                                                     
            END-IF                                                      
           END-IF.                                                      
                                                                        
           PERFORM 7700-READ-INFILE3                THRU 7700-EXIT.     
      *                                                                         
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-GET-LOCATION-DESC.                                                
      ******************************************************************        
      *                                                                         
       2300-GET-LOCATION-DESC.                                          
      *                                                                         
           MOVE SPACES                    TO WS-LOCATION                
                                                                        
           IF EQ-CODE-CRNT-LOC = 'A'                                    
             MOVE 'INVENTORY'             TO WS-LOCATION                
           ELSE                                                         
             IF EQ-CODE-CRNT-LOC = 'B'                                  
               MOVE 'TEST SHOP'           TO WS-LOCATION                
             ELSE                                                       
               MOVE 'INSTALLED'           TO WS-LOCATION                
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2400-FORMAT-EQUIP-DATA.                                                
      ******************************************************************        
      *                                                                         
       2400-FORMAT-EQUIP-DATA.                                          
      *                                                                         
           MOVE EQ-DEVICE-NO              TO OUT-DEVICE-NO              
           MOVE EQ-SERIAL-NO              TO OUT-SERIAL-NO              
           MOVE EQ-CODE-CRNT-LOC          TO OUT-CODE-CRNT-LOC          
           MOVE EQ-CRNT-LOC-NO            TO OUT-PREMISE-NO-EQ          
           MOVE EQ-DATE-LAST-MOVE         TO OUT-DATE-LAST-MOVE         
           MOVE EQ-LOCAL-OFFICE           TO OUT-LOCAL-OFFICE           
           MOVE EQ-COMPANY-NO             TO OUT-COMPANY-NO             
           MOVE GM-DATE-LAST-TESTED       TO OUT-DATE-LAST-TESTED       
           MOVE GM-METER-SIZE-ID          TO OUT-METER-SIZE-ID          
           MOVE GM-TEST-SCHED-CD          TO OUT-TEST-SCHED-CD          
           MOVE E-FMT12-LAST-TEST-SEL-DT  TO OUT-LAST-TEST-SEL-DT       
           MOVE E-FMT12-TEST-SCH-CD       TO OUT-LAST-TEST-SEL-CD       
                                                                        
           COMPUTE WS-TOTAL-OUT = WS-TOTAL-OUT + 1                      
           PERFORM 8300-WRITE-OUTFILE4              THRU 8300-EXIT.     
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2500-FORMAT-OUTPUT1.                                                   
      ******************************************************************        
      *                                                                         
       2500-FORMAT-OUTPUT1.                                             
      *                                                                         
           MOVE WS-COMPANY-NAME           TO HDR1-LN1-COMPANY-NAME      
           MOVE WS-RUN-DATE               TO HDR1-LN1-DATE              
           MOVE 0                         TO HDR1-LN1-PAGE-NO           
           MOVE E-FMT12-LOCAL-OFFICE      TO HDR1-LN3-LOCAL-OFC         
           MOVE B1-LOCAL-OFFICE-DESC      TO HDR1-LN3-LOCAL-DESC        
           MOVE GM-METER-SIZE-ID          TO HDR1-LN4-METER-ID          
           MOVE EQ-DEVICE-NO              TO HDR1-LN9-DEVICE-NO         
           MOVE EQ-SERIAL-NO              TO HDR1-LN9-SERIAL-NO         
           MOVE WS-LOCATION               TO HDR1-LN9-LOCATION          
           MOVE WS-PREMISE-NO-X           TO HDR1-LN9-PREMISE           
           MOVE WS-MSF-CD                 TO HDR1-LN9-MSF-CD            
           MOVE GM-DATE-LAST-TESTED       TO HDR1-LN9-LAST-TESTED       
           MOVE E-FMT12-LAST-TEST-SEL-DT  TO HDR1-LN9-TEST-SEL-DT.      
                                                                        
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2600-FORMAT-OUTPUT2.                                                   
      ******************************************************************        
      *                                                                         
       2600-FORMAT-OUTPUT2.                                             
      *                                                                         
           MOVE WS-COMPANY-NAME           TO HDR2-LN1-COMPANY-NAME      
           MOVE WS-RUN-DATE               TO HDR2-LN1-DATE              
           MOVE 0                         TO HDR2-LN1-PAGE-NO           
           MOVE E-FMT12-LOCAL-OFFICE      TO HDR2-LN3-LOCAL-OFC         
           MOVE B1-LOCAL-OFFICE-DESC      TO HDR2-LN3-LOCAL-DESC        
           MOVE GM-METER-SIZE-ID          TO HDR2-LN4-METER-ID          
           MOVE EQ-DEVICE-NO              TO HDR2-LN9-DEVICE-NO         
           MOVE EQ-SERIAL-NO              TO HDR2-LN9-SERIAL-NO         
           MOVE WS-LOCATION               TO HDR2-LN9-LOCATION          
           MOVE WS-PREMISE-NO-X           TO HDR2-LN9-PREMISE           
           MOVE WS-MSF-CD                 TO HDR2-LN9-MSF-CD            
           MOVE GM-DATE-LAST-TESTED       TO HDR2-LN9-LAST-TESTED       
           MOVE E-FMT12-LAST-TEST-SEL-DT  TO HDR2-LN9-TEST-SEL-DT       
           MOVE WS-ACCOUNT-NOX            TO HDR2-LN10-ACCOUNT-NOX      
           MOVE WS-RTE-CYCLE              TO HDR2-LN10-RTE-CYCLE        
           MOVE E-FMT12-NAME              TO HDR2-LN10-NAME             
           MOVE E-FMT12-SERV-ADDR         TO HDR2-LN11-SERV-ADDR        
           MOVE E-FMT12-ADDR-CITY-STATE-ZIP TO HDR2-LN11-ADDR.          
                                                                        
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2700-FORMAT-OUTPUT3.                                                   
      ******************************************************************        
      *                                                                         
       2700-FORMAT-OUTPUT3.                                             
      *                                                                         
           MOVE WS-COMPANY-NAME           TO HDR3-LN1-COMPANY-NAME      
           MOVE WS-RUN-DATE(1:3)          TO HDR3-LN2-RPT-DT(1:3)       
           MOVE WS-RUN-DATE(7:4)          TO HDR3-LN2-RPT-DT(4:4)       
           MOVE WS-RUN-DATE(1:6)          TO HDR3-LN2-DATE(1:6)         
           MOVE WS-RUN-DATE(9:2)          TO HDR3-LN2-DATE(7:2)         
           MOVE WS-RUN-TIME               TO HDR3-LN3-TIME              
           MOVE E-FMT12-LOCAL-OFFICE      TO HDR3-LN8-LOCAL-OFC         
           MOVE B1-LOCAL-OFFICE-DESC      TO HDR3-LN8-LOCAL-DESC        
           MOVE WS-COUNT-1                TO HDR3-LN8-COUNT1            
           MOVE WS-COUNT-2                TO HDR3-LN8-COUNT2            
           MOVE WS-COUNT-3                TO HDR3-LN8-COUNT3            
                                                                        
           COMPUTE WS-TOTAL = WS-COUNT-1 + WS-COUNT-2 + WS-COUNT-3      
                                                                        
           MOVE WS-TOTAL                  TO HDR3-LN8-TOTAL.            
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 2800-END-OF-JOB.                                                       
      ******************************************************************        
      *                                                                         
       2800-END-OF-JOB.                                                 
      *                                                                         
           DISPLAY 'GMC041 STATISTICS'                                  
           DISPLAY 'TOTAL RECORDS IN  = ' WS-TOTAL-IN                   
           DISPLAY 'TOTAL RECORDS OUT = ' WS-TOTAL-OUT                  
                                                                        
           IF WS-DATA-FOUND = 'N'                                       
      *       PRINT REPORT4                                                     
              DISPLAY 'NO DATA FOUND'                                   
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7000-GET-COMPANY-NAMEE.                                                
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
                INTO :WS-COMPANY-NAME                                   
                    ,:WS-CURR-DATE-X                                    
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*             ,:WS-CURR-DATE-X                                            
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP651 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  C7-COMPANY-NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-GET-PERIODIC-TEST.                                                
      ******************************************************************        
      *                                                                         
       7100-GET-PERIODIC-TEST.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  EQ.DEVICE_NO                                      
                     ,EQ.SERIAL_NO                                      
                     ,EQ.CODE_CRNT_LOC                                  
                     ,EQ.CRNT_LOC_NO                                    
                     ,EQ.DATE_LAST_MOVE                                 
                     ,EQ.LOCAL_OFFICE                                   
                     ,EQ.COMPANY_NO                                     
                     ,GM.DATE_LAST_TESTED                               
                     ,GM.METER_SIZE_ID                                  
                     ,GM.TEST_SCHED_CD                                  
                     ,GM.LAST_TEST_SEL_DT                               
                     ,GM.LAST_TEST_SEL_CD                               
                INTO :EQ-DEVICE-NO                                      
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-DATE-LAST-MOVE :WS-DT-MOVE-NULL                 
                    ,:EQ-LOCAL-OFFICE                                   
                    ,:EQ-COMPANY-NO                                     
                    ,:GM-DATE-LAST-TESTED :WS-DT-TEST-NULL               
                    ,:GM-METER-SIZE-ID                                  
                    ,:GM-TEST-SCHED-CD                                  
                    ,:GM-LAST-TEST-SEL-DT :WS-DT-SEL-NULL                
                    ,:GM-LAST-TEST-SEL-CD                               
                FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE EQ.CODE_UTIL_TYPE = 'G'                            
                 AND GM.CODE_UTIL_TYPE = 'G'                            
                 AND EQ.DEVICE_NO = GM.METER_NO                         
                 AND EQ.DEVICE_NO = :WS-METER-NO                        
                 AND EQ.COMPANY_NO = GM.COMPANY_NO                      
                 AND EQ.COMPANY_NO = :WS-COMPANY-NO                     
                ORDER BY GM.METER_SIZE_ID                               
                        ,EQ.DEVICE_NO                                   
                        ,EQ.CODE_CRNT_LOC DESC                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  EQ.DEVICE_NO                                              
MFA-TR*              ,EQ.SERIAL_NO                                              
MFA-TR*              ,EQ.CODE_CRNT_LOC                                          
MFA-TR*              ,EQ.CRNT_LOC_NO                                            
MFA-TR*              ,EQ.DATE_LAST_MOVE                                         
MFA-TR*              ,EQ.LOCAL_OFFICE                                           
MFA-TR*              ,EQ.COMPANY_NO                                             
MFA-TR*              ,GM.DATE_LAST_TESTED                                       
MFA-TR*              ,GM.METER_SIZE_ID                                          
MFA-TR*              ,GM.TEST_SCHED_CD                                          
MFA-TR*              ,GM.LAST_TEST_SEL_DT                                       
MFA-TR*              ,GM.LAST_TEST_SEL_CD                                       
MFA-TR*         INTO :EQ-DEVICE-NO                                              
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EQ-DATE-LAST-MOVE:WS-DT-MOVE-NULL                         
MFA-TR*             ,:EQ-LOCAL-OFFICE                                           
MFA-TR*             ,:EQ-COMPANY-NO                                             
MFA-TR*             ,:GM-DATE-LAST-TESTED:WS-DT-TEST-NULL                       
MFA-TR*             ,:GM-METER-SIZE-ID                                          
MFA-TR*             ,:GM-TEST-SCHED-CD                                          
MFA-TR*             ,:GM-LAST-TEST-SEL-DT:WS-DT-SEL-NULL                        
MFA-TR*             ,:GM-LAST-TEST-SEL-CD                                       
MFA-TR*         FROM CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_EQUIPMENT EQ                                           
MFA-TR*        WHERE EQ.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND GM.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND EQ.DEVICE_NO = GM.METER_NO                                 
MFA-TR*          AND EQ.DEVICE_NO = :WS-METER-NO                                
MFA-TR*          AND EQ.COMPANY_NO = GM.COMPANY_NO                              
MFA-TR*          AND EQ.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         ORDER BY GM.METER_SIZE_ID                                       
MFA-TR*                 ,EQ.DEVICE_NO                                           
MFA-TR*                 ,EQ.CODE_CRNT_LOC DESC                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP651 ABORT *****'                   
              DISPLAY '**  7100-GET-PERIODIC-TEST **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  EQ.DEVICE_NO  = ' WS-METER-NO                
              DISPLAY '**  EQ.COMPANY_NO = ' WS-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-GET-LOCAL-OFFICE.                                                 
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE_DESC                                  
                INTO :B1-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE LOCAL_OFFICE  = :WS-LOCAL-OFC                      
                 AND COMPANY_NO    = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE_DESC                                          
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                                      
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE LOCAL_OFFICE  = :WS-LOCAL-OFC                              
MFA-TR*          AND COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP651 ABORT *****'                   
              DISPLAY '**  7200-GET-LOCAL-OFFICE  **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  COMPANY-NUMBER= ' WS-COMPANY-NO              
              DISPLAY '**  LOCAL OFFICE  = ' WS-LOCAL-OFC               
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-GET-CF-PER-HR.                                                    
      ******************************************************************        
      *                                                                         
       7300-GET-CF-PER-HR.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT CCF_CAP_PER_HR                                     
                INTO :WS-CCF-CAP-PER-HR                                 
                FROM CSS_GAS_METER_SIZE WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO    = :WS-COMPANY-NO                     
                 AND METER_SIZE_ID = :GM-METER-SIZE-ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CCF_CAP_PER_HR                                             
MFA-TR*         INTO :WS-CCF-CAP-PER-HR                                         
MFA-TR*         FROM CSS_GAS_METER_SIZE                                         
MFA-TR*        WHERE COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*          AND METER_SIZE_ID = :GM-METER-SIZE-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP651 ABORT *****'                   
              DISPLAY '**  7300-GET-CF-PER-HR     **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  COMPANY-NUMBER= ' WS-COMPANY-NO              
              DISPLAY '**  METER-SIZE-ID = ' GM-METER-SIZE-ID           
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7500-READ-INFILE1                                                      
      ******************************************************************        
       7500-READ-INFILE1.                                               
      *                                                                         
           READ INFILE1.                                                
                                                                        
           IF INFILE1-SUCCESSFUL  OR  END-OF-REC1                       
              MOVE INFILE1-REC            TO FIOMT12                    
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP041 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE1 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE1-STATUS           
               DISPLAY '** PROCESSING TERMINATED  **'                   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7600-READ-INFILE2                                                      
      ******************************************************************        
       7600-READ-INFILE2.                                               
      *                                                                         
           READ INFILE2.                                                
                                                                        
           IF INFILE2-SUCCESSFUL  OR  END-OF-REC2                       
              MOVE INFILE2-REC            TO FIOMT12                    
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP041 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE2 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE2-STATUS           
               DISPLAY '** PROCESSING TERMINATED  **'                   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7700-READ-INFILE3                                                      
      ******************************************************************        
       7700-READ-INFILE3.                                               
      *                                                                         
           READ INFILE3.                                                
                                                                        
           IF INFILE3-SUCCESSFUL  OR  END-OF-REC3                       
              MOVE INFILE3-REC            TO FIOMT12                    
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP041 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE3 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE3-STATUS           
               DISPLAY '** PROCESSING TERMINATED  **'                   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **   8000-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN1.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN2.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN3.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN4.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN5.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN6.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN7.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN8.               
           ADD +1 TO WS-FILE1-PAGE-NO.                                  
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8100-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN1.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN2.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN3.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN4.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN6.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN7.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN8.              
           ADD +1 TO WS-FILE2-PAGE-NO.                                  
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8110-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8110-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN9                
           ADD +1 TO WS-FILE1-COUNT.                                    
           ADD +1 TO WS-FILE1-TOT-COUNT.                                
      *                                                                 08335000
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8120-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8120-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN5.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN10.              
      *                                                                 08335000
       8120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8130-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8130-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN5.               
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN10.              
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN11.              
           WRITE PRT33-RECORD FROM WS-RP041-HDR1-REC-LN12.              
      *                                                                 08335000
       8130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8200-WRITE-OUTFILE3.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE3.                                             
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN1.              
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN2.              
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN3.              
      *    WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN4.                      
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN5.              
      *    WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN6.                      
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN7.              
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8210-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8210-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN9.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN10.             
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN11.             
           ADD +1 TO WS-FILE2-COUNT.                                    
           ADD +1 TO WS-FILE2-TOT-COUNT.                                
      *                                                                 08335000
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8220-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8220-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN12.             
      *                                                                 08335000
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8230-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8230-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN5.              
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN12.             
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN13.             
           WRITE PRT331-RECORD FROM WS-RP041-HDR2-REC-LN14.             
      *                                                                 08335000
       8230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8300-WRITE-OUTFILE4.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-OUTFILE4.                                             
      *                                                                 08230000
           WRITE OUTFILE-REC.                                           
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8310-WRITE-OUTFILE3.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8310-WRITE-OUTFILE3.                                             
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN8.              
      *                                                                 08335000
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8320-WRITE-OUTFILE3.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8320-WRITE-OUTFILE3.                                             
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN9.              
           WRITE PRT332-RECORD FROM WS-RP041-HDR3-REC-LN10.             
      *                                                                 08335000
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE OUTFILE1.                                              
                                                                        
           IF NOT FCA32-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING OUTFILE1          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA32-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
           IF NOT FCA33-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT33-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA33-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSPT332-FILE.                                         
                                                                        
           IF NOT FCA332-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA332-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
