       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP040.                                      
COB303 DATE-WRITTEN.     MAR 31, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- PRINTS A REPORT OF SAMPLE TEST METERS THAT WERE TORY WITH  --*        
      *-- SELECTED BUT HAVE NOT BEEN TESTED YET.                     --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  04/01/2016    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT054*--                            GMC040 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT INFILE1                                               
               ASSIGN TO UT-S-INFILE1                                   
               FILE STATUS IS WS-INFILE1-STATUS.                        
           SELECT INFILE2                                               
               ASSIGN TO UT-S-INFILE2                                   
               FILE STATUS IS WS-INFILE2-STATUS.                        
           SELECT INFILE3                                               
               ASSIGN TO UT-S-INFILE3                                   
               FILE STATUS IS WS-INFILE3-STATUS.                        
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN TO UT-S-FCSPT33                                   
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN TO UT-S-FCSPT331                                  
               FILE STATUS IS WS-FCSPT331-STATUS.                       
      *                                                                         
           SELECT FCSPT332-FILE                                         
               ASSIGN TO UT-S-FCSPT332                                  
               FILE STATUS IS WS-FCSPT332-STATUS.                       
      *                                                                         
           SELECT OUTFILE1                                              
               ASSIGN TO UT-S-OUTFILE1                                  
               FILE STATUS IS WS-OUTFILE1-STATUS.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  INFILE1                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE1-REC                     PIC X(572) VALUE SPACES.      
      *                                                                         
       FD  INFILE2                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE2-REC                     PIC X(572) VALUE SPACES.      
      *                                                                         
       FD  INFILE3                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01 INFILE3-REC                     PIC X(572) VALUE SPACES.      
      *                                                                         
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
       COPY CFDPT332.                                                           
      *                                                                         
       FD  OUTFILE1                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 OUTFILE1-REC.                                                 
          05 OUT-DEVICE-NO                PIC X(09) VALUE SPACES.       
          05 OUT-SERIAL-NO                PIC X(11) VALUE SPACES.       
          05 OUT-CODE-CRNT-LOC            PIC X(01) VALUE SPACES.       
          05 OUT-PREMISE-NO-EQ            PIC S9(11) COMP-3.            
          05 OUT-DATE-LAST-MOVE           PIC X(10) VALUE SPACES.       
          05 OUT-LOCAL-OFFICE             PIC X(03) VALUE SPACES.       
          05 OUT-COMPANY-NO               PIC X(02) VALUE SPACES.       
          05 OUT-DATE-LAST-TESTED         PIC X(10) VALUE SPACES.       
          05 OUT-METER-SIZE-ID            PIC X(08) VALUE SPACES.       
          05 OUT-TEST-SCHED-CD            PIC X(01) VALUE SPACES.       
          05 OUT-LAST-TEST-SEL-DT         PIC X(10) VALUE SPACES.       
          05 OUT-LAST-TEST-SEL-CD         PIC X(02) VALUE SPACES.       
          05 FILLER                       PIC X(127) VALUE SPACES.      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP040'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOCA66.                                                            
      ****************************************************************          
      *    DB2 INCLUDES                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER, GM                            *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_EQUIPMENT, EQ                            *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_COMPANY, C7                              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER_SIZE,M5                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_LOCAL_OFFICET, B1                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
      *                                                                         
           05 WS-TOTAL-MTR-SIZE-CNT   PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-OFFICE-CNT PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-OFFICE-CNT-2 PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-MTR-REPORT-CNT   PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-MTR-REPORT-CNT-2 PIC 9(06) VALUE ZEROES.         
           05 WS-TOTAL-MTR-LOC-CNT    PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-SIZE-CNT-2 PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-TEST-CNT   PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-INS-CNT    PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL-MTR-INV-CNT    PIC 9(06) VALUE ZEROES.           
           05 WS-COUNT-1              PIC 9(06) VALUE ZEROES.           
           05 WS-COUNT-2              PIC 9(06) VALUE ZEROES.           
           05 WS-COUNT-3              PIC 9(06) VALUE ZEROES.           
           05 WS-TOTAL                PIC 9(06) VALUE ZEROES.           
           05 WS-TOT-COUNT-1          PIC 9(06) VALUE ZEROES.           
           05 WS-TOT-COUNT-2          PIC 9(06) VALUE ZEROES.           
           05 WS-TOT-COUNT-3          PIC 9(06) VALUE ZEROES.           
           05 WS-TOT-TOTAL            PIC 9(06) VALUE ZEROES.           
           05 WS-ACCOUNT-NO           PIC 9(13) VALUE ZEROES.           
           05 WS-PREV-LOCAL-OFFICE    PIC X(03) VALUE SPACES.           
           05 WS-PREV-METER-SIZE-ID   PIC X(08) VALUE SPACES.           
           05 WS-PREV-CODE-CRNT-LOC   PIC X(01) VALUE SPACES.           
           05 WS-PREV-LOCAL-OFFICE-DESC PIC X(22) VALUE SPACES.         
           05 WS-RPT1-LINE-CNT        PIC 9(02) VALUE ZEROES.           
           05 WS-RPT2-LINE-CNT        PIC 9(02) VALUE ZEROES.           
           05 WS-RPT3-LINE-CNT        PIC 9(02) VALUE ZEROES.           
           05 WS-RPT1-PAGE-NUM        PIC 9(07) VALUE ZEROES.           
           05 WS-RPT2-PAGE-NUM        PIC 9(07) VALUE ZEROES.           
           05 WS-RPT3-PAGE-NUM        PIC 9(07) VALUE ZEROES.           
           05 WS-METER-FOUND          PIC X(01) VALUE SPACES.           
           05 WS-LOCATION             PIC X(10) VALUE SPACES.           
           05 WS-PREMISE-NO-EQ        PIC 9(10) VALUE ZEROES.           
           05 WS-DT-MOVE-NULL         PIC S9(04) COMP.                  
           05 WS-DT-TEST-NULL         PIC S9(04) COMP.                  
           05 WS-DT-SEL-NULL          PIC S9(04) COMP.                  
           05 WS-MSF-CD               PIC X(03) VALUE SPACES.           
           05 WS-RPT1-NO-DATA         PIC X(01) VALUE SPACES.           
           05 WS-RPT2-NO-DATA         PIC X(01) VALUE SPACES.           
           05 WS-RPT3-NO-DATA         PIC X(01) VALUE SPACES.           
           05 WS-RUN-TIME             PIC X(08) VALUE SPACES.           
           05 WS-RUN-DATE             PIC X(10) VALUE SPACES.           
           05 WS-RPT-DATE.                                              
              10 WS-RPT-MM            PIC X(02) VALUE SPACES.           
              10 FILLER               PIC X(01) VALUE '/'.              
              10 WS-RPT-DD            PIC X(02) VALUE SPACES.           
              10 FILLER               PIC X(01) VALUE '/'.              
              10 WS-RPT-YY            PIC X(04) VALUE SPACES.           
           05 WS-COMPANY-NO           PIC X(02) VALUE SPACES.           
           05  WS-TOTAL-IN1           PIC 9(05) VALUE ZEROES.           
           05  WS-TOTAL-IN2           PIC 9(05) VALUE ZEROES.           
           05  WS-TOTAL-IN3           PIC 9(05) VALUE ZEROES.           
           05  WS-TOTAL-OUT1          PIC 9(05) VALUE ZEROES.           
           05  WS-REPORT-INV          PIC 9(07) VALUE ZEROES.           
           05  WS-REPORT-INST         PIC 9(07) VALUE ZEROES.           
           05  WS-REPORT-SHOP         PIC 9(07) VALUE ZEROES.           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-DATA-FOUND          PIC X(01) VALUE 'N'.              
           05  WS-LOC-OFF-SW          PIC X(01) VALUE 'N'.              
           05  WS-MTR-SIZ-SW          PIC X(01) VALUE 'N'.              
           05  WS-RPT1-HDR-EXIST      PIC X(01) VALUE 'Y'.              
           05  WS-RPT2-HDR-EXIST      PIC X(01) VALUE 'Y'.              
           05  WS-RPT3-HDR-EXIST      PIC X(01) VALUE 'Y'.              
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-INFILE1-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE1-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC1                   VALUE '10'.             
           05  WS-INFILE2-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE2-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC2                   VALUE '10'.             
           05  WS-INFILE3-STATUS      PIC X(02) VALUE '00'.             
               88 INFILE3-SUCCESSFUL            VALUE '00'.             
               88 END-OF-REC3                   VALUE '10'.             
           05  WS-FCSPT33-STATUS      PIC X(02) VALUE '00'.             
               88 PT33-SUCCESSFUL               VALUE '00'.             
               88 END-OF-REC4                   VALUE '10'.             
           05  WS-FCSPT331-STATUS     PIC X(02) VALUE '00'.             
               88 PT331-SUCCESSFUL              VALUE '00'.             
               88 END-OF-REC5                   VALUE '10'.             
           05  WS-FCSPT332-STATUS     PIC X(02) VALUE '00'.             
               88 PT332-SUCCESSFUL              VALUE '00'.             
               88 END-OF-REC6                   VALUE '10'.             
           05  WS-OUTFILE1-STATUS     PIC X(02) VALUE '00'.             
               88 OUTFL-SUCCESSFUL              VALUE '00'.             
               88 END-OF-REC7                   VALUE '10'.             
      *REPORT HEADER FOR 1ST REPORT.                                            
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'PCSRP040-01'.    
               10  FILLER             PIC X(35) VALUE SPACES.           
               10  RPT1-COMPANY-NAME  PIC X(26) VALUE SPACES.           
               10  FILLER             PIC X(26) VALUE SPACES.           
               10  RPT1-RUN-DATE      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'PAGE'.           
               10  RPT1-PGNUM         PIC Z(06)9.                       
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER             PIC X(51) VALUE SPACES.           
               10  FILLER             PIC X(32)                         
                   VALUE 'GAS METERS ALREADY SAMPLE TESTED'.            
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER             PIC X(20) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'LOCAL OFFICE'.   
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT1-LOCAL-OFFICE  PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT1-LOCAL-OFFICE-DESC                               
                                      PIC X(22) VALUE SPACES.           
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10  FILLER             PIC X(20) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'METER SIZE:'.    
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT1-METER-SIZE-ID PIC X(08) VALUE SPACES.           
      *                                                                         
           05  WS-RPT1-HEADER-SPACES.                                   
               10  FILLER             PIC X(133) VALUE SPACES.          
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10  FILLER             PIC X(31) VALUE SPACES.           
               10  FILLER             PIC X(08) VALUE 'LOCATION'.       
      *                                                                         
           05  WS-RPT1-HEADER-6.                                        
               10  FILLER             PIC X(32) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE 'NAME/'.          
               10  FILLER             PIC X(36) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'DATE'.           
               10  FILLER             PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'DATE'.           
      *                                                                         
           05  WS-RPT1-HEADER-7.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(09) VALUE 'METER NBR'.      
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE 'SERIAL NBR'.     
               10  FILLER             PIC X(06) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'ADDRESS'.        
               10  FILLER             PIC X(08) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'PREMISE'.        
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  FILLER             PIC X(03) VALUE 'MSF'.            
               10  FILLER             PIC X(09) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE 'TESTED'.         
               10  FILLER             PIC X(08) VALUE SPACES.           
               10  FILLER             PIC X(08) VALUE 'SELECTED'.       
      *                                                                         
           05  WS-RPT1-HEADER-8.                                        
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(23)                         
                   VALUE 'TOTAL METERS SIZE    = '.                     
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT1-TOTAL-MTR-SIZE-CNT                              
                                      PIC Z,ZZ,ZZ9 VALUE ZEROES.        
      *                                                                         
           05  WS-RPT1-HEADER-9.                                        
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(23)                         
                   VALUE 'TOTAL METERS OFFICE  = '.                     
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT1-TOTAL-MTR-OFFICE-CNT                            
                                      PIC Z,ZZ,ZZ9 VALUE ZEROES.        
      *                                                                         
           05  WS-RPT1-HEADER-10.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(23)                         
                   VALUE 'TOTAL METERS REPORT  = '.                     
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT1-TOTAL-MTR-REPORT-CNT                            
                                      PIC Z,ZZ,ZZ9 VALUE ZEROES.        
      *                                                                         
           05  WS-RPT1-DETAIL.                                          
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  RPT1-DEVICE-NO     PIC X(09) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT1-SERIAL-NO     PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT1-LOCATION      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE SPACES.           
               10  RPT1-PREMISE-NO-X  PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE SPACES.           
               10  RPT1-MSF-CD        PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  RPT1-DATE-LAST-TESTED                                
                                      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE SPACES.           
               10  RPT1-LAST-TEST-SEL-DT                                
                                      PIC X(10) VALUE SPACES.           
      *REPORT HEADER FOR 2ND REPORT.                                            
      *                                                                         
           05  WS-RPT2-HEADER-1.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'PCSRP040-02'.    
               10  FILLER             PIC X(35) VALUE SPACES.           
               10  RPT2-COMPANY-NAME  PIC X(26) VALUE SPACES.           
               10  FILLER             PIC X(26) VALUE SPACES.           
               10  RPT2-RUN-DATE      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'PAGE'.           
               10  RPT2-PGNUM         PIC Z(06)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-2.                                        
               10  FILLER             PIC X(51) VALUE SPACES.           
               10  FILLER             PIC X(26)                         
                   VALUE 'SAMPLE TEST NOT YET TESTED'.                  
      *                                                                         
           05  WS-RPT2-HEADER-3.                                        
               10  FILLER             PIC X(20) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'LOCAL OFFICE'.   
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT2-LOCAL-OFFICE  PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT2-LOCAL-OFFICE-DESC                               
                                      PIC X(22) VALUE SPACES.           
      *                                                                         
           05  WS-RPT2-HEADER-4.                                        
               10  FILLER             PIC X(20) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'METER SIZE:'.    
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT2-METER-SIZE-ID PIC X(08) VALUE SPACES.           
      *                                                                         
           05  WS-RPT2-HEADER-SPACES.                                   
               10  FILLER             PIC X(133) VALUE SPACES.          
      *                                                                         
           05  WS-RPT2-HEADER-5.                                        
               10  FILLER             PIC X(31) VALUE SPACES.           
               10  FILLER             PIC X(08) VALUE 'LOCATION'.       
               10  FILLER             PIC X(49) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'DATE'.           
      *                                                                         
           05  WS-RPT2-HEADER-6.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE 'METER NBR/'.     
               10  FILLER             PIC X(05) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'SERIAL NBR/'.    
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE 'NAME/'.          
               10  FILLER             PIC X(36) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'DATE'.           
               10  FILLER             PIC X(08) VALUE SPACES.           
               10  FILLER             PIC X(09) VALUE 'SELECTED/'.      
      *                                                                         
           05  WS-RPT2-HEADER-7.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(08) VALUE 'ACCT NBR'.       
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'CYC/ RD RTE'.    
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'ADDRESS'.        
               10  FILLER             PIC X(08) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'PREMISE'.        
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  FILLER             PIC X(09) VALUE 'MSF'.            
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE 'TESTED'.         
               10  FILLER             PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'CITY'.           
      *                                                                         
           05  WS-RPT2-HEADER-8.                                        
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL METERS LOCATION  = '.                   
               10  RPT2-TOTAL-MTR-LOC-CNT                               
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-9.                                        
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL METERS SIZE      = '.                   
               10  RPT2-TOTAL-MTR-SIZE-CNT                              
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-10.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL METERS OFFICE    = '.                   
               10  RPT2-TOTAL-MTR-OFFICE-CNT                            
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-11.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL REPORT INVENTORY = '.                   
               10  RPT2-TOTAL-MTR-INV-CNT                               
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-12.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL REPORT INSTALLED = '.                   
               10  RPT2-TOTAL-MTR-INS-CNT                               
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-13.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL REPORT TEST SHOP = '.                   
               10  RPT2-TOTAL-MTR-TEST-CNT                              
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-HEADER-14.                                       
               10  FILLER             PIC X(25) VALUE SPACES.           
               10  FILLER             PIC X(25)                         
                   VALUE 'TOTAL METERS REPORT    = '.                   
               10  RPT2-TOTAL-MTR-REPORT-CNT                            
                                      PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT2-DETAIL-1.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  RPT2-DEVICE-NO     PIC X(09) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE SPACES.           
               10  RPT2-SERIAL-NO     PIC X(11) VALUE SPACES.           
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  RPT2-LOCATION      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE SPACES.           
               10  RPT2-PREMISE-NO-X  PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(05) VALUE SPACES.           
               10  RPT2-MSF-CD        PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  RPT2-DATE-LAST-TESTED                                
                                      PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE SPACES.           
               10  RPT2-LAST-TEST-SEL-DT                                
                                      PIC X(10) VALUE SPACES.           
      *                                                                         
           05  WS-RPT2-DETAIL-2.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  RPT2-ACCOUNT-NO    PIC X(13) VALUE SPACES.           
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT2-RTE-CYCLE.                                      
                   15  WS-READ-CYCLE  PIC X(02) VALUE SPACES.           
                   15  FILLER         PIC X(03) VALUE SPACES.           
                   15  WS-READ-ROUTE  PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(03) VALUE SPACES.           
               10  RPT2-FCA66-NAME    PIC X(96) VALUE SPACES.           
      *                                                                         
           05  WS-RPT2-DETAIL-3.                                        
               10  FILLER             PIC X(30) VALUE SPACES.           
               10  RPT2-FCA66-SERV-ADDR                                 
                                      PIC X(55) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  RPT2-FCA66-ADDR-CITY-ST-ZIP                          
                                      PIC X(41) VALUE SPACES.           
      *REPORT HEADERS FOR 3RD REPORT.                                           
      *                                                                         
           05  WS-RPT3-HEADER-1.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'PCSRP040-03'.    
               10  FILLER             PIC X(44) VALUE SPACES.           
               10  RPT3-COMPANY-NAME  PIC X(26) VALUE SPACES.           
               10  FILLER             PIC X(38) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE 'PAGE'.           
               10  RPT3-PGNUM         PIC Z(06)9.                       
      *                                                                         
           05  WS-RPT3-HEADER-2.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(14) VALUE 'REPORT DATE : '. 
               10  RPT3-DATE.                                           
                   15 RPT3-MM         PIC X(02) VALUE SPACES.           
                   15 FILLER          PIC X(01) VALUE '/'.              
                   15 RPT3-YY         PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(17) VALUE SPACES.           
               10  FILLER             PIC X(34)                         
                   VALUE 'SAMPLE TEST NOT YET TESTED-SUMMARY'.          
               10  FILLER             PIC X(39) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE 'RUN-DATE: '.     
               10  RPT3-RUN-DATE.                                       
                   15 RPT3-RUN-MM     PIC X(02) VALUE SPACES.           
                   15 FILLER          PIC X(01) VALUE '/'.              
                   15 RPT3-RUN-DD     PIC X(02) VALUE SPACES.           
                   15 FILLER          PIC X(01) VALUE '/'.              
                   15 RPT3-RUN-YY     PIC X(02) VALUE SPACES.           
      *                                                                         
           05  WS-RPT3-HEADER-3.                                        
               10  FILLER             PIC X(113) VALUE SPACES.          
               10  FILLER             PIC X(10) VALUE 'RUN-TIME: '.     
               10  RPT3-RUN-TIME      PIC X(08) VALUE SPACES.           
      *                                                                         
           05  WS-RPT3-HEADER-SPACES.                                   
               10  FILLER             PIC X(133) VALUE SPACES.          
      *                                                                         
           05  WS-RPT3-HEADER-4.                                        
               10  FILLER             PIC X(46) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'GROUP 1'.        
               10  FILLER             PIC X(16) VALUE SPACES.           
               10  FILLER             PIC X(07) VALUE 'GROUP 3'.        
               10  FILLER             PIC X(18) VALUE SPACES.           
               10  FILLER             PIC X(06) VALUE 'GROUP4'.         
      *                                                                         
           05  WS-RPT3-HEADER-5.                                        
               10  FILLER             PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(13) VALUE 'OFFICE NUMBER'.  
               10  FILLER             PIC X(10) VALUE SPACES.           
               10  FILLER             PIC X(11) VALUE 'OFFICE NAME'.    
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  FILLER             PIC X(13) VALUE '(< 251 CF/HR)'.  
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(26)                         
                   VALUE '(>= 251 AND <= 1500 CF/HR)'.                  
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(14) VALUE '(> 1500 CF/HR)'. 
               10  FILLER             PIC X(08) VALUE SPACES.           
               10  FILLER             PIC X(12) VALUE 'OFFICE TOTAL'.   
      *                                                                         
           05  WS-RPT3-DETAIL.                                          
               10  FILLER             PIC X(07) VALUE SPACES.           
               10  RPT3-LOCAL-OFFICE  PIC X(03) VALUE SPACES.           
               10  FILLER             PIC X(10) VALUE SPACES.           
               10  RPT3-LOCAL-OFFICE-DESC                               
                                      PIC X(22) VALUE SPACES.           
               10  FILLER             PIC X(04) VALUE SPACES.           
               10  RPT3-COUNT-1       PIC Z(05)9.                       
               10  FILLER             PIC X(18) VALUE SPACES.           
               10  RPT3-COUNT-2       PIC Z(05)9.                       
               10  FILLER             PIC X(18) VALUE SPACES.           
               10  RPT3-COUNT-3       PIC Z(05)9.                       
               10  FILLER             PIC X(12) VALUE SPACES.           
               10  RPT3-TOTAL         PIC Z(05)9.                       
      *                                                                         
           05  WS-RPT3-TRLR.                                            
               10  FILLER             PIC X(46) VALUE SPACES.           
               10  RPT3-TOT-COUNT-1   PIC Z(05)9.                       
               10  FILLER             PIC X(18) VALUE SPACES.           
               10  RPT3-TOT-COUNT-2   PIC Z(05)9.                       
               10  FILLER             PIC X(18) VALUE SPACES.           
               10  RPT3-TOT-COUNT-3   PIC Z(05)9.                       
               10  FILLER             PIC X(12) VALUE SPACES.           
               10  RPT3-TOT-TOTAL     PIC Z(05)9.                       
      *                                                                         
       01  WS-END-DATA.                                                 
           05  FILLER                 PIC X(55) VALUE SPACES.           
           05  FILLER                 PIC X(22) VALUE                   
                     '*** END OF REPORT ***'.                           
           05  FILLER                 PIC X(55) VALUE SPACES.           
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                 PIC X(54) VALUE SPACES.           
           05  FILLER                 PIC X(25) VALUE                   
                     '*** NO ACCOUNTS FOUND ***'.                       
           05  FILLER                 PIC X(45) VALUE SPACES.           
      ****************************************************************          
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU  0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT-FILE1      THRU  1000-EXIT.       
           PERFORM 1100-PROCESS-INPUT-FILE2      THRU  1100-EXIT.       
           PERFORM 1200-PROCESS-INPUT-FILE3      THRU  1200-EXIT.       
           DISPLAY 'PCSRP040 STATISTICS'.                               
           DISPLAY 'TOTAL RECORDS IN FILE1 = ' WS-TOTAL-IN1.            
           DISPLAY 'TOTAL RECORDS OUT IN FCSPT33  = ' WS-TOTAL-OUT1.    
           DISPLAY 'TOTAL RECORDS IN FILE2 = ' WS-TOTAL-IN2.            
           DISPLAY 'TOTAL RECORDS IN FILE3 = ' WS-TOTAL-IN3.            
           PERFORM 9000-TERMINATE                THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT  INFILE1.                                         
           IF NOT INFILE1-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE1.         **'          
               DISPLAY '**  FILE STATUS = ' WS-INFILE1-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN INPUT  INFILE2.                                         
           IF NOT INFILE2-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE2.         **'          
               DISPLAY '**  FILE STATUS = ' WS-INFILE2-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN INPUT  INFILE3.                                         
           IF NOT INFILE3-SUCCESSFUL                                    
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING INFILE3.         **'          
               DISPLAY '**  FILE STATUS = ' WS-INFILE3-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT PT33-SUCCESSFUL                                       
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT33.         **'          
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
           IF NOT PT331-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331         **'          
               DISPLAY '**  FILE STATUS = ' WS-FCSPT331-STATUS          
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT332-FILE.                                   
           IF NOT PT332-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT332         **'          
               DISPLAY '**  FILE STATUS = ' WS-FCSPT332-STATUS          
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT OUTFILE1.                                        
           IF NOT OUTFL-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP040 ABORT   ********'         
               DISPLAY '**  ERROR OPENING OUTFILE1         **'          
               DISPLAY '**  FILE STATUS = ' WS-OUTFILE1-STATUS          
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           PERFORM 7000-GET-CURR-DT-TIME         THRU 7000-EXIT.        
           MOVE WS-RUN-TIME               TO RPT3-RUN-TIME.             
           MOVE WS-RUN-DATE(1:4)          TO WS-RPT-YY                  
                                             RPT3-YY.                   
           MOVE WS-RUN-DATE(3:2)          TO RPT3-RUN-YY.               
           MOVE WS-RUN-DATE(6:2)          TO WS-RPT-MM                  
                                             RPT3-RUN-MM                
                                             RPT3-MM.                   
           MOVE WS-RUN-DATE(9:2)          TO WS-RPT-DD                  
                                             RPT3-RUN-DD.               
           MOVE WS-RPT-DATE               TO RPT1-RUN-DATE              
                                             RPT2-RUN-DATE.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT-FILE1.                                    **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT-FILE1.                                        
      *                                                                         
           PERFORM 7100-READ-INFILE1             THRU  7100-EXIT.       
           PERFORM 2000-PROCESS-OUTPUT-FILE1     THRU  2000-EXIT        
             UNTIL END-OF-REC1.                                         
           PERFORM 2800-RPT1-WRITE-TRLR          THRU  2800-EXIT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-PROCESS-INPUT-FILE2.                                    **        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-INPUT-FILE2.                                        
      *                                                                         
           MOVE SPACES                    TO WS-MSF-CD                  
                                             WS-COMPANY-NO              
                                             WS-METER-FOUND             
                                             WS-PREV-LOCAL-OFFICE       
                                             WS-PREV-METER-SIZE-ID.     
           PERFORM 7200-READ-INFILE2             THRU  7200-EXIT.       
           PERFORM 2100-PROCESS-OUTPUT-FILE2     THRU  2100-EXIT        
             UNTIL END-OF-REC2.                                         
           PERFORM 2920-RPT2-WRITE-TRLR          THRU  2920-EXIT.       
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-PROCESS-INPUT-FILE3.                                    **        
      ******************************************************************        
      *                                                                         
       1200-PROCESS-INPUT-FILE3.                                        
      *                                                                         
           MOVE SPACES                    TO WS-COMPANY-NO              
                                             WS-METER-FOUND             
                                             WS-PREV-LOCAL-OFFICE       
                                             WS-MSF-CD.                 
           PERFORM 7300-READ-INFILE3             THRU  7300-EXIT.       
           PERFORM 2200-PROCESS-OUTPUT-FILE3     THRU  2200-EXIT        
             UNTIL END-OF-REC3.                                         
           PERFORM 2950-RPT3-WRITE-TRLR          THRU  2950-EXIT.       
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT-FILE1.                                   **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT-FILE1.                                       
      *                                                                         
           MOVE INFILE1-REC               TO FIOCA66-HEADER-RECORD.     
      ***NO DATA SWITCH                                                         
           IF END-OF-REC1                                               
              MOVE WS-Y                   TO WS-RPT1-NO-DATA            
           END-IF.                                                      
      ***SKIP HEADER RECORD                                                     
           IF E-FCA66-HEADER-ID = 'H'                                   
              PERFORM 7100-READ-INFILE1          THRU 7100-EXIT         
              GO TO 2000-PROCESS-OUTPUT-FILE1                           
           END-IF.                                                      
      *                                                                         
           IF E-FCA66-COMPANY-NO = X'00' OR                             
              E-FCA66-COMPANY-NO = X'FF' OR                             
              E-FCA66-COMPANY-NO = '00'  OR                             
              E-FCA66-COMPANY-NO = ' '                                  
              MOVE '01'                   TO WS-COMPANY-NO              
           ELSE                                                         
              MOVE E-FCA66-COMPANY-NO     TO WS-COMPANY-NO              
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPANY-NO             TO C7-COMPANY-NO              
           PERFORM 7400-GET-COMPANY-NAME         THRU 7400-EXIT.        
           MOVE C7-COMPANY-NAME           TO RPT1-COMPANY-NAME.         
      *                                                                         
           DISPLAY 'MTR NBR IN INFILE1 = ' E-FCA66-METER-NO.            
           MOVE SPACES                    TO OUTFILE1-REC.              
           MOVE WS-N                      TO WS-METER-FOUND.            
           COMPUTE WS-TOTAL-IN1 = WS-TOTAL-IN1 + 1.                     
      *                                                                         
           MOVE E-FCA66-METER-NO          TO EQ-DEVICE-NO               
           MOVE WS-COMPANY-NO             TO EQ-COMPANY-NO              
                                             B1-COMPANY-NO              
           PERFORM 7500-FETCH-SAMPLE-TEST        THRU 7500-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y                   TO WS-METER-FOUND             
              MOVE EQ-CRNT-LOC-NO         TO WS-PREMISE-NO-EQ           
              IF WS-DT-MOVE-NULL < 0                                    
                 MOVE SPACES              TO EQ-DATE-LAST-MOVE          
              END-IF                                                    
              IF WS-DT-TEST-NULL < 0                                    
                 MOVE SPACES              TO GM-DATE-LAST-TESTED        
              END-IF                                                    
              IF WS-DT-SEL-NULL < 0                                     
                 MOVE SPACES              TO GM-LAST-TEST-SEL-DT        
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'METER NOT FOUND ON CIS SYSTEM - METER NBR FL1 = '
                      E-FCA66-METER-NO                                  
           END-IF.                                                      
      *                                                                         
           IF WS-METER-FOUND EQUAL WS-Y                                 
             IF GM-METER-SIZE-ID NOT EQUAL E-FCA66-METER-SIZE           
                PERFORM 7100-READ-INFILE1        THRU  7100-EXIT        
                GO TO 2000-PROCESS-OUTPUT-FILE1                         
             END-IF                                                     
             MOVE EQ-LOCAL-OFFICE         TO WS-MSF-CD                  
             MOVE E-FCA66-LOCAL-OFFICE    TO B1-LOCAL-OFFICE            
             PERFORM 7600-GET-LOCAL-OFFICE       THRU  7600-EXIT        
             MOVE B1-LOCAL-OFFICE-DESC    TO RPT1-LOCAL-OFFICE-DESC     
      *LOCATION-DESCRIPTION                                                     
             PERFORM 2400-LOCATION-DESCRIP       THRU 2400-EXIT         
             IF GM-DATE-LAST-TESTED > GM-LAST-TEST-SEL-DT               
               PERFORM 2300-FORMAT-EQUIP-DATA    THRU 2300-EXIT         
               MOVE E-FCA66-LOCAL-OFFICE  TO RPT1-LOCAL-OFFICE          
               MOVE GM-METER-SIZE-ID      TO RPT1-METER-SIZE-ID         
      *        PRINT RPT1                                                       
               PERFORM 2600-RPT1-WRITE-HEADER    THRU 2600-EXIT         
               PERFORM 2700-RPT1-WRITE-DETAIL    THRU 2700-EXIT         
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7100-READ-INFILE1             THRU  7100-EXIT.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-OUTPUT-FILE2.                                   **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-OUTPUT-FILE2.                                       
      *                                                                         
           MOVE SPACES                    TO FIOCA66-HEADER-RECORD.     
           MOVE INFILE2-REC               TO FIOCA66-HEADER-RECORD.     
      ***NO DATA SWITCH                                                         
           IF END-OF-REC2                                               
              MOVE WS-Y                   TO WS-RPT2-NO-DATA            
           END-IF.                                                      
      ***SKIP HEADER RECORD                                                     
           IF E-FCA66-HEADER-ID = 'H'                                   
              PERFORM 7200-READ-INFILE2          THRU 7200-EXIT         
              GO TO 2100-PROCESS-OUTPUT-FILE2                           
           END-IF.                                                      
      *                                                                         
           IF E-FCA66-COMPANY-NO = X'00' OR                             
              E-FCA66-COMPANY-NO = X'FF' OR                             
              E-FCA66-COMPANY-NO = '00'  OR                             
              E-FCA66-COMPANY-NO = ' '                                  
              MOVE '01'                   TO WS-COMPANY-NO              
           ELSE                                                         
              MOVE E-FCA66-COMPANY-NO     TO WS-COMPANY-NO              
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPANY-NO             TO C7-COMPANY-NO              
           PERFORM 7400-GET-COMPANY-NAME         THRU 7400-EXIT.        
           MOVE C7-COMPANY-NAME           TO RPT2-COMPANY-NAME.         
      *                                                                         
           DISPLAY 'MTR NBR IN INFILE2 = ' E-FCA66-METER-NO.            
           MOVE SPACES                    TO OUTFILE1-REC.              
           MOVE WS-N                      TO WS-METER-FOUND.            
           COMPUTE WS-TOTAL-IN2 = WS-TOTAL-IN2 + 1.                     
      *                                                                         
           MOVE E-FCA66-METER-NO          TO EQ-DEVICE-NO               
           MOVE WS-COMPANY-NO             TO EQ-COMPANY-NO              
                                             B1-COMPANY-NO              
           PERFORM 7500-FETCH-SAMPLE-TEST        THRU 7500-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y                   TO WS-METER-FOUND             
              MOVE EQ-CRNT-LOC-NO         TO WS-PREMISE-NO-EQ           
              MOVE GM-METER-SIZE-ID       TO RPT2-METER-SIZE-ID         
              IF WS-DT-MOVE-NULL < 0                                    
                 MOVE SPACES              TO EQ-DATE-LAST-MOVE          
              END-IF                                                    
              IF WS-DT-TEST-NULL < 0                                    
                 MOVE SPACES              TO GM-DATE-LAST-TESTED        
              END-IF                                                    
              IF WS-DT-SEL-NULL < 0                                     
                 MOVE SPACES              TO GM-LAST-TEST-SEL-DT        
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'METER NOT FOUND ON CIS SYSTEM - METER NBR FL2 = '
                      E-FCA66-METER-NO                                  
           END-IF.                                                      
      *                                                                         
           IF WS-METER-FOUND EQUAL WS-Y                                 
             IF GM-METER-SIZE-ID NOT EQUAL E-FCA66-METER-SIZE           
                PERFORM 7200-READ-INFILE2        THRU  7200-EXIT        
                GO TO 2100-PROCESS-OUTPUT-FILE2                         
             END-IF                                                     
             MOVE EQ-LOCAL-OFFICE         TO WS-MSF-CD                  
             MOVE E-FCA66-LOCAL-OFFICE    TO B1-LOCAL-OFFICE            
             PERFORM 7600-GET-LOCAL-OFFICE       THRU  7600-EXIT        
             MOVE B1-LOCAL-OFFICE-DESC    TO RPT2-LOCAL-OFFICE-DESC     
             PERFORM 2400-LOCATION-DESCRIP       THRU  2400-EXIT        
             IF GM-DATE-LAST-TESTED > GM-LAST-TEST-SEL-DT               
                CONTINUE                                                
             ELSE                                                       
               MOVE E-FCA66-ACCT-NO       TO WS-ACCOUNT-NO              
               MOVE E-FCA66-READ-ROUTE    TO WS-READ-ROUTE              
               MOVE E-FCA66-READ-CYCLE    TO WS-READ-CYCLE              
               MOVE E-FCA66-LOCAL-OFFICE  TO RPT2-LOCAL-OFFICE          
               PERFORM 2500-LOCATION-TOTALS      THRU  2500-EXIT        
      *        PRINT RPT2                                                       
               PERFORM 2900-RPT2-WRITE-HEADER    THRU  2900-EXIT        
               PERFORM 2910-RPT2-WRITE-DETAIL    THRU  2910-EXIT        
           END-IF
           END-IF.                                                      
           PERFORM 7200-READ-INFILE2             THRU  7200-EXIT.       
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-OUTPUT-FILE3.                                   **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-OUTPUT-FILE3.                                       
      *                                                                         
           MOVE SPACES                    TO FIOCA66-HEADER-RECORD.     
           MOVE INFILE3-REC               TO FIOCA66-HEADER-RECORD.     
      ***NO DATA SWITCH                                                         
           IF END-OF-REC3                                               
              MOVE WS-Y                   TO WS-RPT3-NO-DATA            
           END-IF.                                                      
      ***SKIP HEADER RECORD                                                     
           IF E-FCA66-HEADER-ID = 'H'                                   
              PERFORM 7300-READ-INFILE3          THRU 7300-EXIT         
              GO TO 2200-PROCESS-OUTPUT-FILE3                           
           END-IF.                                                      
      *                                                                         
           IF E-FCA66-COMPANY-NO = X'00' OR                             
              E-FCA66-COMPANY-NO = X'FF' OR                             
              E-FCA66-COMPANY-NO = '00'  OR                             
              E-FCA66-COMPANY-NO = ' '                                  
              MOVE '01'                   TO WS-COMPANY-NO              
           ELSE                                                         
              MOVE E-FCA66-COMPANY-NO     TO WS-COMPANY-NO              
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPANY-NO             TO C7-COMPANY-NO              
                                             B1-COMPANY-NO              
                                             M5-COMPANY-NO.             
           PERFORM 7400-GET-COMPANY-NAME         THRU 7400-EXIT.        
           MOVE C7-COMPANY-NAME           TO RPT3-COMPANY-NAME.         
      *                                                                         
           DISPLAY 'MTR NBR IN INFILE3 = ' E-FCA66-METER-NO.            
           MOVE SPACES                    TO OUTFILE1-REC.              
           MOVE WS-N                      TO WS-METER-FOUND.            
           COMPUTE WS-TOTAL-IN3 = WS-TOTAL-IN3 + 1.                     
      *                                                                         
           MOVE E-FCA66-METER-NO          TO EQ-DEVICE-NO.              
           MOVE WS-COMPANY-NO             TO EQ-COMPANY-NO.             
           PERFORM 7500-FETCH-SAMPLE-TEST        THRU 7500-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y                   TO WS-METER-FOUND             
              MOVE EQ-CRNT-LOC-NO         TO WS-PREMISE-NO-EQ           
              IF WS-DT-MOVE-NULL < 0                                    
                 MOVE SPACES              TO EQ-DATE-LAST-MOVE          
              END-IF                                                    
              IF WS-DT-TEST-NULL < 0                                    
                 MOVE SPACES              TO GM-DATE-LAST-TESTED        
              END-IF                                                    
              IF WS-DT-SEL-NULL < 0                                     
                 MOVE SPACES              TO GM-LAST-TEST-SEL-DT        
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'METER NOT FOUND ON CIS SYSTEM - METER NBR FL3 =' 
                      E-FCA66-METER-NO                                  
           END-IF.                                                      
      *                                                                         
           IF WS-METER-FOUND EQUAL WS-Y                                 
              IF GM-METER-SIZE-ID NOT EQUAL E-FCA66-METER-SIZE          
                 PERFORM 7300-READ-INFILE3       THRU  7300-EXIT        
                 GO TO 2200-PROCESS-OUTPUT-FILE3                        
              END-IF                                                    
      *       PERFORM 2940-RPT3-WRITE-DETAIL  THRU  2940-EXIT                   
              MOVE EQ-LOCAL-OFFICE        TO WS-MSF-CD                  
              MOVE E-FCA66-LOCAL-OFFICE   TO B1-LOCAL-OFFICE            
      *                                      RPT3-LOCAL-OFFICE                  
              PERFORM 2400-LOCATION-DESCRIP      THRU 2400-EXIT         
              IF GM-DATE-LAST-TESTED > GM-LAST-TEST-SEL-DT              
                 CONTINUE                                               
              ELSE                                                      
                IF EQ-CODE-CRNT-LOC = 'J'                               
                   PERFORM 2940-RPT3-WRITE-DETAIL THRU  2940-EXIT       
                   MOVE GM-METER-SIZE-ID  TO M5-METER-SIZE-ID           
                   PERFORM 7700-GET-CF-PER-HR     THRU 7700-EXIT        
                   MOVE WS-Y              TO WS-DATA-FOUND              
                   IF M5-CCF-CAP-PER-HR < 251                           
                      ADD +1              TO WS-COUNT-1                 
                                             WS-TOT-COUNT-1             
                   ELSE                                                 
                     IF M5-CCF-CAP-PER-HR >= 251 AND                    
                        M5-CCF-CAP-PER-HR <= 1500                       
                        ADD +1            TO WS-COUNT-2                 
                                             WS-TOT-COUNT-2             
                     ELSE                                               
                        ADD +1            TO WS-COUNT-3                 
                                             WS-TOT-COUNT-3             
                     END-IF                                             
                   END-IF                                               
                   ADD +1                 TO WS-TOTAL                   
                                             WS-TOT-TOTAL               
      *          PRINT RPT3                                                     
                   PERFORM 2930-RPT3-WRITE-HEADER  THRU  2930-EXIT      
      *            PERFORM 2940-RPT3-WRITE-DETAIL  THRU  2940-EXIT              
                   MOVE SPACES            TO EQ-CODE-CRNT-LOC           
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7300-READ-INFILE3             THRU  7300-EXIT.       
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-FORMAT-EQUIP-DATA.                                       *        
      ******************************************************************        
      *                                                                         
       2300-FORMAT-EQUIP-DATA.                                          
      *                                                                         
           MOVE EQ-DEVICE-NO              TO OUT-DEVICE-NO.             
           MOVE EQ-SERIAL-NO              TO OUT-SERIAL-NO.             
           MOVE EQ-CODE-CRNT-LOC          TO OUT-CODE-CRNT-LOC.         
           MOVE EQ-CRNT-LOC-NO            TO OUT-PREMISE-NO-EQ.         
           MOVE EQ-DATE-LAST-MOVE         TO OUT-DATE-LAST-MOVE.        
           MOVE EQ-LOCAL-OFFICE           TO OUT-LOCAL-OFFICE.          
           MOVE EQ-COMPANY-NO             TO OUT-COMPANY-NO.            
           MOVE GM-DATE-LAST-TESTED       TO OUT-DATE-LAST-TESTED.      
           MOVE GM-METER-SIZE-ID          TO OUT-METER-SIZE-ID.         
           MOVE GM-TEST-SCHED-CD          TO OUT-TEST-SCHED-CD.         
           MOVE GM-LAST-TEST-SEL-DT       TO OUT-LAST-TEST-SEL-DT.      
           MOVE GM-LAST-TEST-SEL-CD       TO OUT-LAST-TEST-SEL-CD.      
           COMPUTE WS-TOTAL-OUT1 = WS-TOTAL-OUT1 + 1                    
           WRITE OUTFILE1-REC.                                          
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-LOCATION-DESCRIP.                                       **        
      ******************************************************************        
      *                                                                         
       2400-LOCATION-DESCRIP.                                           
      *                                                                         
             MOVE SPACES                  TO WS-LOCATION                
             EVALUATE EQ-CODE-CRNT-LOC                                  
                WHEN 'A'                                                
                     MOVE 'INVENTORY'     TO WS-LOCATION                
                WHEN 'B'                                                
                     MOVE 'TEST SHOP'     TO WS-LOCATION                
                WHEN OTHER                                              
                     MOVE 'INSTALLED'     TO WS-LOCATION                
             END-EVALUATE.                                              
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-LOCATION-TOTALS.                                        **        
      ******************************************************************        
      *                                                                         
       2500-LOCATION-TOTALS.                                            
      *                                                                         
           MOVE ZEROES                      TO RPT2-TOTAL-MTR-INV-CNT   
                                               RPT2-TOTAL-MTR-TEST-CNT  
                                               RPT2-TOTAL-MTR-INS-CNT.  
           IF EQ-CODE-CRNT-LOC = 'A'                                    
                 ADD +1                     TO WS-TOTAL-MTR-INV-CNT     
                 MOVE WS-TOTAL-MTR-INV-CNT  TO RPT2-TOTAL-MTR-INV-CNT   
           ELSE                                                         
             IF EQ-CODE-CRNT-LOC = 'B'                                  
                 ADD +1                     TO WS-TOTAL-MTR-TEST-CNT    
                 MOVE WS-TOTAL-MTR-TEST-CNT TO RPT2-TOTAL-MTR-TEST-CNT  
             ELSE                                                       
                 ADD +1                     TO WS-TOTAL-MTR-INS-CNT     
                 MOVE WS-TOTAL-MTR-INS-CNT  TO RPT2-TOTAL-MTR-INS-CNT   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-RPT1-WRITE-HEADER.                                      **        
      ******************************************************************        
      *                                                                         
       2600-RPT1-WRITE-HEADER.                                          
      *                                                                         
           IF WS-RPT1-HDR-EXIST  EQUAL WS-Y      OR                     
              WS-RPT1-LINE-CNT  GREATER THAN 54 OR                      
              WS-PREV-LOCAL-OFFICE   NOT EQUAL E-FCA66-LOCAL-OFFICE OR  
              WS-PREV-METER-SIZE-ID  NOT EQUAL GM-METER-SIZE-ID         
      *WHEN LOCAL OFFICE CHANGES,                                               
      *PRINT TOTAL METER SIZE AND TOTAL METER OFFICE                            
              IF WS-RPT1-HDR-EXIST EQUAL WS-Y                           
                 MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE      
                 MOVE GM-METER-SIZE-ID     TO WS-PREV-METER-SIZE-ID     
              END-IF                                                    
              IF WS-PREV-LOCAL-OFFICE NOT EQUAL E-FCA66-LOCAL-OFFICE AND
                 WS-RPT1-HDR-EXIST EQUAL WS-N                           
                 MOVE ZEROES               TO WS-RPT1-PAGE-NUM          
                 MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE      
                 MOVE WS-RPT1-HEADER-8     TO PRT33-RECORD              
                 PERFORM 8000-WRITE-FCSPT33      THRU 8000-EXIT         
                 MOVE WS-RPT1-HEADER-9     TO PRT33-RECORD              
                 PERFORM 8200-WRITE-FCSPT33      THRU 8200-EXIT         
                 MOVE ZEROES               TO WS-TOTAL-MTR-SIZE-CNT     
                 MOVE ZEROES               TO WS-TOTAL-MTR-OFFICE-CNT   
               MOVE WS-TOTAL-MTR-SIZE-CNT   TO RPT1-TOTAL-MTR-SIZE-CNT  
               MOVE WS-TOTAL-MTR-OFFICE-CNT TO RPT1-TOTAL-MTR-OFFICE-CNT
                 MOVE WS-Y                 TO WS-LOC-OFF-SW             
              END-IF                                                    
      *WHEN METER SIZE CHANGES,                                                 
      *PRINT TOTAL METER SIZE                                                   
              IF WS-PREV-METER-SIZE-ID  NOT EQUAL GM-METER-SIZE-ID AND  
                 WS-RPT1-HDR-EXIST EQUAL WS-N AND                       
                 WS-LOC-OFF-SW     EQUAL WS-N                           
                 MOVE GM-METER-SIZE-ID     TO WS-PREV-METER-SIZE-ID     
                 MOVE WS-RPT1-HEADER-8     TO PRT33-RECORD              
                 PERFORM 8000-WRITE-FCSPT33      THRU 8000-EXIT         
                 MOVE ZEROES               TO WS-TOTAL-MTR-SIZE-CNT     
                 MOVE WS-TOTAL-MTR-SIZE-CNT   TO RPT1-TOTAL-MTR-SIZE-CNT
              END-IF                                                    
              MOVE ZEROES                  TO WS-RPT1-LINE-CNT          
              MOVE WS-N                    TO WS-RPT1-HDR-EXIST         
              ADD +1                       TO WS-RPT1-PAGE-NUM          
              MOVE WS-RPT1-PAGE-NUM        TO RPT1-PGNUM                
              MOVE WS-RPT1-HEADER-1        TO PRT33-RECORD              
              PERFORM 8100-WRITE-FCSPT33         THRU 8100-EXIT         
              MOVE WS-RPT1-HEADER-2        TO PRT33-RECORD              
              PERFORM 8000-WRITE-FCSPT33         THRU 8000-EXIT         
              MOVE WS-RPT1-HEADER-3        TO PRT33-RECORD              
              PERFORM 8300-WRITE-FCSPT33         THRU 8300-EXIT         
              MOVE WS-RPT1-HEADER-4        TO PRT33-RECORD              
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              MOVE WS-RPT1-HEADER-SPACES   TO PRT33-RECORD              
              PERFORM 8200-WRITE-FCSPT33        THRU 8200-EXIT          
              MOVE WS-RPT1-HEADER-5        TO PRT33-RECORD              
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              MOVE WS-RPT1-HEADER-6        TO PRT33-RECORD              
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
              MOVE WS-RPT1-HEADER-7        TO PRT33-RECORD              
              PERFORM 8000-WRITE-FCSPT33        THRU 8000-EXIT          
           END-IF.                                                      
           MOVE WS-N                      TO WS-LOC-OFF-SW.             
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2700-RPT1-WRITE-DETAIL.                                      **        
      ******************************************************************        
      *                                                                         
       2700-RPT1-WRITE-DETAIL.                                          
      *                                                                         
           MOVE EQ-DEVICE-NO               TO RPT1-DEVICE-NO.           
           MOVE EQ-SERIAL-NO               TO RPT1-SERIAL-NO.           
           MOVE WS-LOCATION                TO RPT1-LOCATION.            
           MOVE WS-PREMISE-NO-EQ           TO RPT1-PREMISE-NO-X.        
           MOVE WS-MSF-CD                  TO RPT1-MSF-CD.              
           MOVE GM-DATE-LAST-TESTED        TO RPT1-DATE-LAST-TESTED.    
           MOVE GM-LAST-TEST-SEL-DT        TO RPT1-LAST-TEST-SEL-DT.    
           MOVE WS-RPT1-DETAIL             TO PRT33-RECORD.             
           ADD  +1                         TO WS-TOTAL-MTR-SIZE-CNT     
                                              WS-TOTAL-MTR-OFFICE-CNT   
                                              WS-TOTAL-MTR-REPORT-CNT.  
           MOVE WS-TOTAL-MTR-SIZE-CNT     TO RPT1-TOTAL-MTR-SIZE-CNT.   
           MOVE WS-TOTAL-MTR-OFFICE-CNT   TO RPT1-TOTAL-MTR-OFFICE-CNT. 
           MOVE WS-TOTAL-MTR-REPORT-CNT   TO RPT1-TOTAL-MTR-REPORT-CNT. 
           PERFORM 8300-WRITE-FCSPT33            THRU 8300-EXIT.        
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-RPT1-WRITE-TRLR.                                          *        
      ******************************************************************        
      *                                                                         
       2800-RPT1-WRITE-TRLR.                                            
      *                                                                         
           IF WS-RPT1-NO-DATA = WS-Y                                    
              MOVE WS-RPT1-HEADER-SPACES  TO PRT33-RECORD               
              PERFORM 8000-WRITE-FCSPT33         THRU 8000-EXIT         
              MOVE WS-NO-DATA             TO PRT33-RECORD               
              PERFORM 8200-WRITE-FCSPT33         THRU 8200-EXIT         
           ELSE                                                         
              MOVE WS-RPT1-HEADER-8       TO PRT33-RECORD               
              PERFORM 8200-WRITE-FCSPT33         THRU 8200-EXIT         
              MOVE WS-RPT1-HEADER-9       TO PRT33-RECORD               
              PERFORM 8200-WRITE-FCSPT33         THRU 8200-EXIT         
              MOVE WS-RPT1-HEADER-10      TO PRT33-RECORD               
              PERFORM 8200-WRITE-FCSPT33         THRU 8200-EXIT         
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2900-RPT2-WRITE-HEADER.                                      **        
      ******************************************************************        
      *                                                                         
       2900-RPT2-WRITE-HEADER.                                          
      *                                                                         
           IF WS-RPT2-HDR-EXIST EQUAL WS-Y      OR                      
              WS-RPT2-LINE-CNT GREATER THAN 54  OR                      
              WS-PREV-LOCAL-OFFICE NOT EQUAL E-FCA66-LOCAL-OFFICE OR    
              WS-PREV-METER-SIZE-ID  NOT EQUAL GM-METER-SIZE-ID OR      
              WS-PREV-CODE-CRNT-LOC  NOT EQUAL EQ-CODE-CRNT-LOC         
              IF WS-RPT2-HDR-EXIST EQUAL WS-Y                           
                 MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE      
                 MOVE GM-METER-SIZE-ID     TO WS-PREV-METER-SIZE-ID     
                 MOVE EQ-CODE-CRNT-LOC     TO WS-PREV-CODE-CRNT-LOC     
              END-IF                                                    
                 MOVE EQ-CODE-CRNT-LOC     TO WS-PREV-CODE-CRNT-LOC     
      *WHEN LOCAL OFFICE CHANGES,                                               
      *PRINT TOTAL METERS LOCATION,TOTAL METERS SIZE,TOTAL METERS OFFICE        
              IF WS-PREV-LOCAL-OFFICE NOT EQUAL E-FCA66-LOCAL-OFFICE AND
                 WS-RPT2-HDR-EXIST EQUAL WS-N                           
                 MOVE ZEROES               TO WS-RPT2-PAGE-NUM          
                 MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE      
                 MOVE WS-RPT2-HEADER-8     TO PRT331-RECORD             
                 PERFORM 8500-WRITE-FCSPT331     THRU 8500-EXIT         
                 MOVE WS-RPT2-HEADER-9     TO PRT331-RECORD             
                 PERFORM 8400-WRITE-FCSPT331     THRU 8400-EXIT         
                 MOVE WS-RPT2-HEADER-10    TO PRT331-RECORD             
                 PERFORM 8400-WRITE-FCSPT331     THRU 8400-EXIT         
                 MOVE ZEROES               TO WS-TOTAL-MTR-LOC-CNT      
                 MOVE WS-TOTAL-MTR-LOC-CNT TO RPT2-TOTAL-MTR-LOC-CNT    
                 MOVE ZEROES               TO WS-TOTAL-MTR-SIZE-CNT-2   
                 MOVE WS-TOTAL-MTR-SIZE-CNT-2 TO                        
                      RPT2-TOTAL-MTR-SIZE-CNT                           
                 MOVE ZEROES               TO WS-TOTAL-MTR-OFFICE-CNT-2 
                 MOVE WS-TOTAL-MTR-OFFICE-CNT-2 TO                      
                      RPT2-TOTAL-MTR-OFFICE-CNT                         
                 MOVE WS-Y                 TO WS-LOC-OFF-SW             
              ELSE                                                      
      *WHEN METER SIZE CHANGES                                                  
      *PRINT TOTAL METER SIZE,METER LOCATION                                    
              IF WS-PREV-METER-SIZE-ID  NOT EQUAL GM-METER-SIZE-ID AND  
                 WS-RPT2-HDR-EXIST EQUAL WS-N AND                       
                 WS-LOC-OFF-SW EQUAL WS-N                               
                 MOVE GM-METER-SIZE-ID    TO WS-PREV-METER-SIZE-ID      
                 MOVE WS-RPT2-HEADER-8    TO PRT331-RECORD              
                 PERFORM 8400-WRITE-FCSPT331     THRU 8400-EXIT         
                 MOVE WS-RPT2-HEADER-9    TO PRT331-RECORD              
                 PERFORM 8400-WRITE-FCSPT331     THRU 8400-EXIT         
                 MOVE ZEROES              TO WS-TOTAL-MTR-SIZE-CNT-2    
                 MOVE WS-TOTAL-MTR-SIZE-CNT-2  TO                       
                      RPT2-TOTAL-MTR-SIZE-CNT                           
                 MOVE ZEROES              TO WS-TOTAL-MTR-LOC-CNT       
                 MOVE WS-TOTAL-MTR-LOC-CNT  TO RPT2-TOTAL-MTR-LOC-CNT   
                 MOVE WS-Y                 TO WS-MTR-SIZ-SW             
              ELSE                                                      
      *WHEN METER LOC CHANGES                                                   
      *PRINT TOTAL METER LOCATION                                               
              IF WS-PREV-CODE-CRNT-LOC  NOT EQUAL EQ-CODE-CRNT-LOC AND  
                 WS-RPT2-HDR-EXIST EQUAL WS-N                           
                 AND WS-LOC-OFF-SW EQUAL WS-N                           
                 AND WS-MTR-SIZ-SW EQUAL WS-N                           
                 MOVE EQ-CODE-CRNT-LOC    TO WS-PREV-CODE-CRNT-LOC      
                 MOVE WS-RPT2-HEADER-8    TO PRT331-RECORD              
                 PERFORM 8400-WRITE-FCSPT331     THRU 8400-EXIT         
                 MOVE ZEROES              TO WS-TOTAL-MTR-LOC-CNT       
                 MOVE WS-TOTAL-MTR-LOC-CNT TO RPT2-TOTAL-MTR-LOC-CNT    
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
              MOVE ZEROES                 TO WS-RPT2-LINE-CNT           
              MOVE WS-N                   TO WS-RPT2-HDR-EXIST          
              ADD +1                      TO WS-RPT2-PAGE-NUM           
              MOVE WS-RPT2-PAGE-NUM       TO RPT2-PGNUM                 
              MOVE WS-RPT2-HEADER-1       TO PRT331-RECORD              
              PERFORM 8500-WRITE-FCSPT331        THRU 8500-EXIT         
              MOVE WS-RPT2-HEADER-2       TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
              MOVE WS-RPT2-HEADER-3       TO PRT331-RECORD              
              PERFORM 8500-WRITE-FCSPT331        THRU 8500-EXIT         
              MOVE WS-RPT2-HEADER-4       TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
              MOVE WS-RPT2-HEADER-SPACES  TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-5       TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
              MOVE WS-RPT2-HEADER-6       TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
              MOVE WS-RPT2-HEADER-7       TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
           END-IF.                                                      
           MOVE WS-N                      TO WS-LOC-OFF-SW              
                                             WS-MTR-SIZ-SW.             
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2910-RPT2-WRITE-DETAIL.                                      **        
      ******************************************************************        
      *                                                                         
       2910-RPT2-WRITE-DETAIL.                                          
      *                                                                         
           MOVE EQ-DEVICE-NO              TO RPT2-DEVICE-NO.            
           MOVE EQ-SERIAL-NO              TO RPT2-SERIAL-NO.            
           MOVE WS-LOCATION               TO RPT2-LOCATION.             
           MOVE WS-PREMISE-NO-EQ          TO RPT2-PREMISE-NO-X.         
           MOVE WS-MSF-CD                 TO RPT2-MSF-CD.               
           MOVE GM-DATE-LAST-TESTED       TO RPT2-DATE-LAST-TESTED.     
           MOVE GM-LAST-TEST-SEL-DT       TO RPT2-LAST-TEST-SEL-DT.     
           MOVE WS-ACCOUNT-NO             TO RPT2-ACCOUNT-NO.           
           MOVE E-FCA66-NAME              TO RPT2-FCA66-NAME.           
           MOVE E-FCA66-SERV-ADDR         TO RPT2-FCA66-SERV-ADDR.      
           MOVE E-FCA66-ADDR-CITY-ST-ZIP TO RPT2-FCA66-ADDR-CITY-ST-ZIP.
           MOVE WS-RPT2-DETAIL-1          TO PRT331-RECORD.             
           PERFORM 8700-WRITE-FCSPT331           THRU 8700-EXIT.        
           MOVE WS-RPT2-DETAIL-2          TO PRT331-RECORD.             
           PERFORM 8700-WRITE-FCSPT331           THRU 8700-EXIT.        
           MOVE WS-RPT2-DETAIL-3          TO PRT331-RECORD.             
           PERFORM 8700-WRITE-FCSPT331           THRU 8700-EXIT.        
           ADD  +1                        TO WS-TOTAL-MTR-SIZE-CNT-2    
                                             WS-TOTAL-MTR-LOC-CNT       
                                             WS-TOTAL-MTR-OFFICE-CNT-2  
                                             WS-TOTAL-MTR-REPORT-CNT-2. 
           MOVE WS-TOTAL-MTR-LOC-CNT      TO RPT2-TOTAL-MTR-LOC-CNT.    
           MOVE WS-TOTAL-MTR-SIZE-CNT-2   TO RPT2-TOTAL-MTR-SIZE-CNT.   
           MOVE WS-TOTAL-MTR-OFFICE-CNT-2 TO RPT2-TOTAL-MTR-OFFICE-CNT. 
           MOVE WS-TOTAL-MTR-REPORT-CNT-2 TO RPT2-TOTAL-MTR-REPORT-CNT. 
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2920-RPT2-WRITE-TRLR.                                          *        
      ******************************************************************        
      *                                                                         
       2920-RPT2-WRITE-TRLR.                                            
      *                                                                         
           IF WS-RPT2-NO-DATA = WS-Y                                    
              MOVE WS-RPT2-HEADER-SPACES  TO PRT331-RECORD              
              PERFORM 8400-WRITE-FCSPT331        THRU 8400-EXIT         
              MOVE WS-NO-DATA             TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
           ELSE                                                         
              MOVE WS-RPT2-HEADER-8       TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-9       TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-10      TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-11      TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-12      TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-13      TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
              MOVE WS-RPT2-HEADER-14      TO PRT331-RECORD              
              PERFORM 8600-WRITE-FCSPT331        THRU 8600-EXIT         
           END-IF.                                                      
      *                                                                         
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2930-RPT3-WRITE-HEADER.                                      **        
      ******************************************************************        
      *                                                                         
       2930-RPT3-WRITE-HEADER.                                          
      *                                                                         
           IF WS-RPT3-HDR-EXIST EQUAL WS-Y      OR                      
              WS-RPT3-LINE-CNT GREATER THAN 54                          
              IF WS-RPT3-HDR-EXIST EQUAL WS-Y                           
                 MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE      
              END-IF                                                    
              MOVE ZEROES                 TO WS-RPT3-LINE-CNT           
              ADD +1                      TO WS-RPT3-PAGE-NUM           
              MOVE WS-N                   TO WS-RPT3-HDR-EXIST          
              MOVE WS-RPT3-PAGE-NUM       TO RPT3-PGNUM                 
              MOVE WS-RPT3-HEADER-1       TO PRT332-RECORD              
              PERFORM 8810-WRITE-FCSPT332        THRU 8810-EXIT         
              MOVE WS-RPT3-HEADER-2       TO PRT332-RECORD              
              PERFORM 8800-WRITE-FCSPT332        THRU 8800-EXIT         
              MOVE WS-RPT3-HEADER-3       TO PRT332-RECORD              
              PERFORM 8800-WRITE-FCSPT332        THRU 8800-EXIT         
              MOVE WS-RPT3-HEADER-SPACES  TO PRT332-RECORD              
              PERFORM 8820-WRITE-FCSPT332       THRU 8820-EXIT          
              MOVE WS-RPT3-HEADER-4       TO PRT332-RECORD              
              PERFORM 8800-WRITE-FCSPT332       THRU 8800-EXIT          
              MOVE WS-RPT3-HEADER-5       TO PRT332-RECORD              
              PERFORM 8800-WRITE-FCSPT332       THRU 8800-EXIT          
           END-IF.                                                      
      *                                                                         
       2930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2940-RPT3-WRITE-DETAIL.                                        *        
      ******************************************************************        
      *                                                                         
       2940-RPT3-WRITE-DETAIL.                                          
      *                                                                         
           IF WS-PREV-LOCAL-OFFICE NOT EQUAL E-FCA66-LOCAL-OFFICE       
              AND WS-RPT3-HDR-EXIST EQUAL WS-N                          
              MOVE WS-PREV-LOCAL-OFFICE TO B1-LOCAL-OFFICE              
                                           RPT3-LOCAL-OFFICE            
              PERFORM 7600-GET-LOCAL-OFFICE  THRU 7600-EXIT             
              MOVE B1-LOCAL-OFFICE-DESC TO RPT3-LOCAL-OFFICE-DESC       
              MOVE WS-COUNT-1           TO RPT3-COUNT-1                 
              MOVE WS-COUNT-2           TO RPT3-COUNT-2                 
              MOVE WS-COUNT-3           TO RPT3-COUNT-3                 
              MOVE WS-TOTAL             TO RPT3-TOTAL                   
              MOVE WS-RPT3-DETAIL       TO PRT332-RECORD                
              PERFORM 8830-WRITE-FCSPT332    THRU 8830-EXIT             
              MOVE E-FCA66-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE         
              MOVE ZEROES               TO WS-COUNT-1                   
                                           WS-COUNT-2                   
                                           WS-COUNT-3                   
                                           WS-TOTAL                     
           END-IF.                                                      
      *                                                                         
       2940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2950-RPT3-WRITE-TRLR.                                          *        
      ******************************************************************        
      *                                                                         
       2950-RPT3-WRITE-TRLR.                                            
      *                                                                         
      *PRINT LAST DETAIL RECORD.                                                
           PERFORM 2940-RPT3-WRITE-DETAIL       THRU 2940-EXIT.         
      *                                                                         
      *PRINT TRAILER RECORD.                                                    
           IF WS-DATA-FOUND = WS-N                                      
              MOVE WS-RPT3-HEADER-SPACES   TO PRT332-RECORD             
              PERFORM 8810-WRITE-FCSPT332       THRU 8810-EXIT          
              MOVE WS-NO-DATA              TO PRT332-RECORD             
              PERFORM 8830-WRITE-FCSPT332       THRU 8830-EXIT          
           ELSE                                                         
              MOVE WS-TOT-COUNT-1          TO RPT3-TOT-COUNT-1          
              MOVE WS-TOT-COUNT-2          TO RPT3-TOT-COUNT-2          
              MOVE WS-TOT-COUNT-3          TO RPT3-TOT-COUNT-3          
              MOVE WS-TOT-TOTAL            TO RPT3-TOT-TOTAL            
              MOVE WS-RPT3-TRLR            TO PRT332-RECORD             
              PERFORM 8830-WRITE-FCSPT332       THRU 8830-EXIT          
              MOVE WS-END-DATA             TO PRT332-RECORD             
              PERFORM 8820-WRITE-FCSPT332       THRU 8820-EXIT          
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7000-GET-CURR-DT-TIME                                  **              
      ************************************************************              
      *                                                                         
       7000-GET-CURR-DT-TIME.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-TIME,
              :WS-RUN-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RUN-TIME = CURRENT TIME                                 
MFA-TR*            ,:WS-RUN-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP040 ABORT *****'                   
              DISPLAY '**  7000-GET-CURR-DT-TIME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-RUN-TIME = ' WS-RUN-TIME                  
              DISPLAY '**  WS-RUN-DATE = ' WS-RUN-DATE                  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7100-READ-INFILE1                                                      
      ******************************************************************        
       7100-READ-INFILE1.                                               
      *                                                                         
           READ INFILE1.                                                
                                                                        
           IF INFILE1-SUCCESSFUL  OR  END-OF-REC1                       
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP040 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE1 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE1-STATUS           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7200-READ-INFILE2                                                      
      ******************************************************************        
       7200-READ-INFILE2.                                               
      *                                                                         
           READ INFILE2.                                                
                                                                        
           IF INFILE2-SUCCESSFUL  OR  END-OF-REC2                       
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP040 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE2 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE2-STATUS           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7300-READ-INFILE3                                                      
      ******************************************************************        
       7300-READ-INFILE3.                                               
      *                                                                         
           READ INFILE3.                                                
                                                                        
           IF INFILE3-SUCCESSFUL  OR  END-OF-REC3                       
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP040 ABORT *********'          
               DISPLAY '** ERROR IN READING INFILE3 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-INFILE3-STATUS           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **7400-GET-COMPANY-NAME                                         **        
      ******************************************************************        
      *                                                                         
       7400-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP040 ABORT *****'                   
              DISPLAY '**  7400-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** 7500-FETCH-SAMPLE-TEST.                                **              
      ************************************************************              
      *                                                                         
       7500-FETCH-SAMPLE-TEST.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT EQ.DEVICE_NO,                                    
                       EQ.SERIAL_NO,                                    
                       EQ.CODE_CRNT_LOC,                                
                       EQ.CRNT_LOC_NO,                                  
                       EQ.DATE_LAST_MOVE,                               
                       EQ.LOCAL_OFFICE,                                 
                       EQ.COMPANY_NO,                                   
                       GM.DATE_LAST_TESTED,                             
                       GM.METER_SIZE_ID,                                
                       GM.TEST_SCHED_CD,                                
                       GM.LAST_TEST_SEL_DT,                             
                       GM.LAST_TEST_SEL_CD                              
                  INTO :EQ-DEVICE-NO,                                   
                       :EQ-SERIAL-NO,                                   
                       :EQ-CODE-CRNT-LOC,                               
                       :EQ-CRNT-LOC-NO,                                 
                       :EQ-DATE-LAST-MOVE :WS-DT-MOVE-NULL,              
                       :EQ-LOCAL-OFFICE,                                
                       :EQ-COMPANY-NO,                                  
                       :GM-DATE-LAST-TESTED :WS-DT-TEST-NULL,            
                       :GM-METER-SIZE-ID,                               
                       :GM-TEST-SCHED-CD,                               
                       :GM-LAST-TEST-SEL-DT :WS-DT-SEL-NULL,             
                       :GM-LAST-TEST-SEL-CD                             
                  FROM CSS_GAS_METER GM,                                
                       CSS_EQUIPMENT EQ                                 
                 WHERE EQ.CODE_UTIL_TYPE = 'G'                          
                   AND GM.CODE_UTIL_TYPE = 'G'                          
                   AND EQ.DEVICE_NO = GM.METER_NO                       
                   AND EQ.DEVICE_NO = :EQ-DEVICE-NO                     
                   AND EQ.COMPANY_NO = GM.COMPANY_NO                    
                   AND EQ.COMPANY_NO = :EQ-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP040 ABORT *****'                   
              DISPLAY '**  7500-FETCH-SAMPLE-TEST **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  EQ-DEVICE-NO = ' EQ-DEVICE-NO                
              DISPLAY '**  EQ-COMPANY-NO = ' EQ-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-GET-LOCAL-OFFICE                                          *        
      ******************************************************************        
      *                                                                         
       7600-GET-LOCAL-OFFICE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE_DESC                                 
                 INTO :B1-LOCAL-OFFICE-DESC                             
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                WHERE LOCAL_OFFICE  = :B1-LOCAL-OFFICE                  
                  AND COMPANY_NO    = :B1-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE_DESC                                         
MFA-TR*          INTO :B1-LOCAL-OFFICE-DESC                                     
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE LOCAL_OFFICE  = :B1-LOCAL-OFFICE                          
MFA-TR*           AND COMPANY_NO    = :B1-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP040 ABORT *******'                 
              DISPLAY '**  7600-GET-LOCAL-OFFICE     *'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  B1-LOCAL-OFFICE = ' B1-LOCAL-OFFICE          
              DISPLAY '**  B1-COMPANY-NO = ' B1-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  ****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-CF-PER-HR.                                            *        
      ******************************************************************        
      *                                                                         
       7700-GET-CF-PER-HR.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT CCF_CAP_PER_HR                                    
                 INTO :M5-CCF-CAP-PER-HR                                
                 FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)               
                WHERE COMPANY_NO    = :M5-COMPANY-NO                    
                  AND METER_SIZE_ID = :M5-METER-SIZE-ID                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CCF_CAP_PER_HR                                            
MFA-TR*          INTO :M5-CCF-CAP-PER-HR                                        
MFA-TR*          FROM CSS_GAS_METER_SIZE M5                                     
MFA-TR*         WHERE COMPANY_NO    = :M5-COMPANY-NO                            
MFA-TR*           AND METER_SIZE_ID = :M5-METER-SIZE-ID                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP040 ABORT *******'                 
              DISPLAY '**  7700-GET-CF-PER-HR        *'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  M5-METER-SIZE-ID = ' M5-METER-SIZE-ID        
              DISPLAY '**  M5-COMPANY-NO = ' M5-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  ****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                         **         
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           ADD +1                         TO WS-RPT1-LINE-CNT.          
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8400-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8400-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8500-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8500-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8600-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8600-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8700-WRITE-FCSPT331.                                        **         
      ******************************************************************        
      *                                                                         
       8700-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT2-LINE-CNT.          
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8800-WRITE-FCSPT332.                                         **        
      ******************************************************************        
      *                                                                         
       8800-WRITE-FCSPT332.                                             
      *                                                                         
           WRITE PRT332-RECORD.                                         
           ADD +1                         TO WS-RPT3-LINE-CNT.          
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8810-WRITE-FCSPT332.                                         **        
      ******************************************************************        
      *                                                                         
       8810-WRITE-FCSPT332.                                             
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING PAGE.                    
           ADD +1                         TO WS-RPT3-LINE-CNT.          
      *                                                                         
       8810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8820-WRITE-FCSPT332.                                         **        
      ******************************************************************        
      *                                                                         
       8820-WRITE-FCSPT332.                                             
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING 3 LINES.                 
           ADD +1                         TO WS-RPT3-LINE-CNT.          
      *                                                                         
       8820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8830-WRITE-FCSPT332.                                        **         
      ******************************************************************        
      *                                                                         
       8830-WRITE-FCSPT332.                                             
      *                                                                         
           WRITE PRT332-RECORD AFTER ADVANCING 2 LINES.                 
           ADD +1                         TO WS-RPT3-LINE-CNT.          
      *                                                                         
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE INFILE1.                                               
           CLOSE INFILE2.                                               
           CLOSE INFILE3.                                               
           CLOSE OUTFILE1.                                              
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
           CLOSE FCSPT332-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
