       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSRP036.                                            
       AUTHOR. PRIYA.                                                   
       DATE-WRITTEN. NOV.2006.                                          
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                CUSTOMER INFORMATION SYSTEM                     *        
      ******************************************************************        
      *                     P R O G R A M S U M M A R Y                *        
      *                                                                *        
      *                                                                *        
      *    PURPOSE :                                                   *        
      * THIS PROGRAM LISTS OUT ALL THE ACCOUNTS OTHER THAN IBS AND     *        
      * SECURED RATE ACCOUNTS NOT BILLED FOR ALL PREVIOUS CYCLES.      *        
      * NON-UTILITY ACCOUNTS AND MASTERS ARE ON NONUTIL REPORT         *        
      * FIXED RATE ACCOUNTS THAT HAVE A BILLING CYCLE FOUND ON         *        
      * CSS_JOB_PARM (PCSCA107), WHERE THE CURRENT CYCLE IS LESS       *        
      * THAN THE RELEASE CYCLE DO NOT GO ON THE REPORT                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                PROGRAM  MODIFICATION  LOG                      *        
      *                                                                *        
      * DATE        INITIALS   TASK ID       REASON                    *        
      * -----       --------  ---------    --------------------------  *        
      * 11/13/2006   SP94986  CML 34924   RE WRITING TO COBOL(SEB036)  *        
      *                                                                *        
T34924* 12/07/2006   SP94986  34924-ACT1  PRD FIX                      *        
      *                                   THE ACCOUNTS SHOULD NOT      *        
      *                                   LIST IN REPORT FOR CYCLE 01  *        
      *                                   OR 02 WHICH ARE ON HOLD.     *        
T34924* 01/11/2007   VIJAY    34924-ACT3  PRD FIX - ADD DISPLAYS AND   *        
T34924*                                   FIX TO SELECT CORRECT ACCTS  *        
T34924*                                   WHICH ARE NOT BILLED.        *        
T34924* 01/17/2007   SP94986  34924-ACT4  PRD FIX - CHANGED THE JOBPARM*        
T34924*                                A. FIX TO RUN THE PROGRAM FOR   *        
T34924*                                   THE PCSRP036 FROM THE JOBPARM*        
T34924*                                B. REPLACED THE COMMONDATE TO   *        
T34924*                                   COMMON.                      *        
T35451* 03/06/2007   JJ95645  35451-ACT1  CREATE AN EXCEL SPREADSHEET  *        
T35451*                                   FOR REPORT PCSRP0363         *        
PROD10* 05/10/2007   VIJAY    PROD ISSUE  CODE FIXED TO SELECT CORRECT *        
PROD10*                                   ACCOUNT WHICH ARE NOT BILLED *        
PROD10*                                   IN PREVIOUS MONTH.           *        
T37261* 05/09/2008   MR97640  37251-ACT5  CHANGE REFERENCES TO STBWQITS*        
T37261*                                   TO TBWQITS AND ADDED WITH UR *        
T37261*                                   TO AVOID -911'S              *        
A02182* 02/25/2010   MS93554  A2182-ACT1  ADDED INITIAL BILLS WHCIH ARE*        
A02182*                                   NOT BILLED AND 60 DAYS OLD   *        
A02182*                                   FROM RUN DATE                *        
A02310* 04/21/2010   SP94986  A02310      NO BILL REPORTS TO INCLUDE*           
A02310*                       -ACT01      ACCOUNTS ONLY IN 2ND DAY OF  *        
A02310*                                   BILL WINDOW.                 *        
P00453* 09/21/2011   DB18339  P00453      ADDING PREPAY COLUMN         *        
A05460* 03/16/2015   MS7M727  ACT079      TO REMOVE A RELEATED CODE TO *        
A05460*                                   GENERATING EXCEL FILE        *        
ACT379* 12/09/2016   VIJAY    A05460      REMOVE UNUSED TABLES RELATED *        
ACT379* A05460                            CODE (TBRTATTR)              *        
      ******************************************************************        
            REMARKS.                                                    
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0999     MAIN CONTROL PATH                        
               1000 - 1999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
       COPY CSSPT33 REPLACING  FCSPT33-FILE BY FCSPT33B-FILE,                   
                               UT-S-FCSPT33 BY UT-S-FCSPT33B.                   
       COPY CSSPT33 REPLACING  FCSPT33-FILE BY FCSPT33C-FILE,                   
                               UT-S-FCSPT33 BY UT-S-FCSPT33C.                   
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
       COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33B-FILE,                    
                              PRT33-RECORD BY PRT33B-RECORD.                    
       COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33C-FILE,                    
                              PRT33-RECORD BY PRT33C-RECORD.                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP036'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP036 STARTS HERE'.                  
                                                                        
       01 WS-GENERAL-WORKING-STORAGE.                                   
          05 WS-PGRMNAME              PIC X(10) VALUE 'PCSRP036'.       
          05 WS-PGRNAME               PIC X(10) VALUE 'PCSRP036'.       
          05 WS-CURRENT-DATE          PIC X(10).                        
          05 WS-CUR-DATE-MINUS-7      PIC X(10) VALUE SPACES.           
          05 WS-CUR-DATE-PLUS-14      PIC X(10) VALUE SPACES.           
          05 WS-CURRENT-TIME.                                           
             10 WS-HH                 PIC 9(02)    VALUE 0.             
             10 WS-MM                 PIC 9(02)    VALUE 0.             
             10 WS-SS                 PIC 9(02)    VALUE 0.             
             10 WS-TT                 PIC 9(02)    VALUE 0.             
          05 WS-FMT-DATE.                                               
             10 WS-FMT-MON            PIC X(02)    VALUE SPACES.        
             10 FILLER                PIC X(01)    VALUE '/'.           
             10 WS-FMT-DAY            PIC X(02)    VALUE SPACES.        
             10 FILLER                PIC X(01)    VALUE '/'.           
             10 WS-FMT-CC             PIC X(02)    VALUE SPACES.        
             10 WS-FMT-YEAR           PIC X(02)    VALUE SPACES.        
          05 WS-LINE-COUNT1           PIC 9(02)    VALUE 0.             
          05 WS-LINE-COUNT2           PIC 9(02)    VALUE 0.             
          05 WS-LINE-COUNT3           PIC 9(02)    VALUE 0.             
          05 WS-MAX-LINES             PIC 9(02)    VALUE 55.            
          05 WS-PRT33-RECORD          PIC X(132)   VALUE SPACES.        
          05 WS-PAGE-COUNT1           PIC 9(04)    VALUE 0.             
          05 WS-PAGE-COUNT2           PIC 9(04)    VALUE 0.             
          05 WS-PAGE-COUNT3           PIC 9(04)    VALUE 0.             
          05 WS-SKIP-LINES-NUM        PIC 9(04)    VALUE 0.             
          05 WS-REPORT-TYPE           PIC 9(01)    VALUE 0.             
          05  WS-CYCLE-TAB.                                             
              10 WS-CYCLE-TABLE        OCCURS 21 TIMES.                 
                 15 WS-TABHOLD-CYCLE   PIC X(02).                       
                 15 WS-TABREL-CYCLE    PIC X(02).                       
                                                                        
          05 WS-PARM-DATA          PIC X(80) VALUE SPACES.              
          05 WS-HOLD-DATA.                                              
             10 WS-HOLD-LITERAL    PIC X(11) VALUE SPACES.              
             10 WS-HOLD-CYCLE      PIC X(2)  VALUE SPACES.              
             10 WS-HOLD-COMMA      PIC X(1)  VALUE SPACES.              
          05 WS-REL-DATA.                                               
             10 WS-REL-LITERAL     PIC X(14) VALUE SPACES.              
             10 WS-REL-CYCLE       PIC X(2)  VALUE SPACES.              
             10 WS-REL-COMMA       PIC X(1)  VALUE SPACES.              
                                                                        
          05  WS-DATE-NULLS            PIC S9(4) COMP.                  
          05  WS-ACCT-NULLS            PIC S9(4) COMP.                  
          05  WS-SUBA-NULLS            PIC S9(4) COMP.                  
          05  WS-PRINT-SW              PIC X(01) VALUE 'Y'.             
          05  WS-CYCLE-SW              PIC X(01) VALUE 'N'.             
          05  WS-SUB                   PIC 9(02) VALUE 0.               
          05  WS-WQ-ITEM-LIT           PIC X(02).                       
          05  WS-WQ-ITEM               PIC X(01).                       
P00453    05  WS-PREPAY-FL             PIC X(01).                       
          05  WS-ACCT-CREATE-DT        PIC X(10).                       
          05  WS-DATE-EXTRACT          PIC X(10).                       
T34924    05  WS-MAX-BILL-CYCLE        PIC X(02).                       
PROD10    05  WS-MAX-BILL-CYCLE-MIN    PIC X(02).                       
          05  WS-NO-REPORT             PIC X(01) VALUE 'Y'.             
          05  WS-SAVE-ACCT             PIC 9(13).                       
          05  WS-SAVE-ACCT-X           PIC X(13).                       
          05  WS-ACCT.                                                  
              10  FILLER               PIC X(02) VALUE SPACES.          
              10  WS-ACCOUNT1          PIC X(01) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-ACCOUNT2          PIC X(04) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-ACCOUNT3          PIC X(04) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-ACCOUNT4          PIC X(04) VALUE SPACES.          
A02182    05  WS-REVENUE-MONTH         PIC 9(6).                        
          05  WS-MAX-REV-MONTH         PIC S9(06) COMP-3 VALUE 0.       
          05  WS-MIN-REV-MONTH         PIC S9(06) COMP-3 VALUE 0.       
          05  WS-PREV-REV-MONTH        PIC S9(06) COMP-3 VALUE 0.       
          05  WS-PREV-REV-MONTH-N      PIC 9(06) VALUE 0.               
          05  WS-PREV-REV-MONTH-R REDEFINES WS-PREV-REV-MONTH-N.        
              10 WS-PREV-REV-CCYY      PIC 9(04) .                      
              10 WS-PREV-REV-MM        PIC 9(02) .                      
                                                                        
          05 WS-DATA-IND               PIC X(01) VALUE 'N'.             
          05 WS-DATA-NONUTIL           PIC X(01) VALUE 'N'.             
          05 WS-DATA-PEND              PIC X(01) VALUE 'N'.             
          05 WS-DATA-ACCOUNTS          PIC X(01) VALUE 'N'.             
          05 WS-TOTAL-AR-BALANCE       PIC S9(11)V99 USAGE COMP-3       
                                            VALUE +0.                   
                                                                        
          05  WS-END-OF-CURSOR         PIC X(01)  VALUE 'N'.            
              88  END-OF-CURSOR                   VALUE 'Y'.            
                                                                        
          05  WS-NO-MORE-RECORDS       PIC X(01)  VALUE 'N'.            
              88  NO-RECORDS                      VALUE 'Y'.            
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01)    VALUE 'Y'.           
           05  WS-N                   PIC X(01)    VALUE 'N'.           
                                                                        
                                                                        
      ****************************************************************          
      *           COMMON WORKING STORAGE FOR REPORT HEADERS         *           
      ****************************************************************          
       01 WS-HEADING-LINES.                                             
          05 WS-RPT-HEADER-01.                                          
             10  FILLER                PIC X(02)   VALUE SPACES.        
             10  RPT-HEADER            PIC X(11)   VALUE SPACES.        
             10  FILLER                PIC X(48)   VALUE SPACES.        
             10  RPT-COMPANY-NAME      PIC X(26)   VALUE 'SCANA ENERGY'.
             10  FILLER                PIC X(33)   VALUE SPACES.        
             10  FILLER                PIC X(07)   VALUE 'PAGE :'.      
             10  RPT-PAGE-NO           PIC ZZZZ.                        
          05 WS-RPT-HEADER-02.                                          
             10  FILLER                PIC X(02)   VALUE SPACES.        
             10  FILLER                PIC X(05)   VALUE 'DATE:'.       
             10  RPT-RUN-DATE1         PIC X(10)   VALUE SPACES.        
             10  FILLER                PIC X(24)   VALUE SPACES.        
             10  RPT-HDR-DESC          PIC X(18)   VALUE SPACES.        
             10  FILLER                PIC X(32)   VALUE                
                 ' DID NOT BILL(ALL PREV CYCLES) '.                     
             10  FILLER                PIC X(21)   VALUE SPACES.        
             10  FILLER                PIC X(10)   VALUE 'RUN DATE:'.   
             10  RPT-RUN-DATE2         PIC X(10)   VALUE SPACES.        
          05 WS-RPT-HEADER-03.                                          
             10  FILLER                PIC X(112)  VALUE SPACES.        
             10  FILLER                PIC X(09)   VALUE 'RUN TIME:'.   
             10  WS-RUN-TIME.                                           
                 15  FILLER            PIC X(03)   VALUE SPACES.        
                 15  WS-RT-HH          PIC X(02)   VALUE SPACES.        
                 15  FILLER            PIC X(01)   VALUE ':'.           
                 15  WS-RT-MM          PIC X(02)   VALUE SPACES.        
                 15  FILLER            PIC X(01)   VALUE ':'.           
                 15  WS-RT-SS          PIC X(02)   VALUE SPACES.        
          05 WS-RPT-HEADER-04.                                          
             10 FILLER                 PIC X(01) VALUE  SPACES.         
             10 FILLER                 PIC X(02) VALUE  'WQ'.           
             10 FILLER                 PIC X(04) VALUE  SPACES.         
             10 FILLER                 PIC X(05) VALUE 'CYCLE'.         
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(10) VALUE 'ACCOUNT NO'.    
             10 FILLER                 PIC X(06) VALUE  SPACES.         
P00453       10 FILLER                 PIC X(14) VALUE 'ACCT CREATE DT'.
P00453       10 FILLER                 PIC X(05) VALUE  SPACES.         
             10 FILLER                 PIC X(07) VALUE 'BALANCE'.       
P00453       10 FILLER                 PIC X(05) VALUE  SPACES.         
             10 FILLER                 PIC X(07) VALUE  'SUBACCT'.      
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(06) VALUE  'STATUS'.       
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(09) VALUE  'BILL DATE'.    
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(14) VALUE 'LAST REV MONTH'.
P00453       10 FILLER                 PIC X(02) VALUE  SPACES.         
P00453       10 FILLER                 PIC X(06) VALUE 'PREPAY'.        
          05 WS-RPT-HEADER-05.                                          
             10 FILLER                 PIC X(01) VALUE  SPACES.         
             10 FILLER                 PIC X(02) VALUE  'WQ'.           
             10 FILLER                 PIC X(04) VALUE  SPACES.         
             10 FILLER                 PIC X(05) VALUE 'CYCLE'.         
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(10) VALUE 'ACCOUNT NO'.    
             10 FILLER                 PIC X(06) VALUE  SPACES.         
P00453       10 FILLER                 PIC X(14) VALUE 'ACCT CREATE DT'.
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(07) VALUE 'BALANCE'.       
             10 FILLER                 PIC X(09) VALUE  SPACES.         
             10 FILLER                 PIC X(07) VALUE  'SUBACCT'.      
             10 FILLER                 PIC X(06) VALUE  SPACES.         
             10 FILLER                 PIC X(06) VALUE  'STATUS'.       
             10 FILLER                 PIC X(04) VALUE  SPACES.         
             10 FILLER                 PIC X(09) VALUE  'BILL DATE'.    
             10 FILLER                 PIC X(03) VALUE  SPACES.         
             10 FILLER                 PIC X(14) VALUE 'LAST REV MONTH'.
             10 FILLER                 PIC X(04) VALUE  SPACES.         
             10 FILLER                 PIC X(08) VALUE 'PEND OFF'.      
       01 WS-DATA-LINE.                                                 
             05 FILLER                PIC X(01)  VALUE SPACES.          
             05 WS-RPT-WQ-ITEM-LIT    PIC X(02)  VALUE SPACES.          
             05 FILLER                PIC X(05)  VALUE SPACES.          
             05 WS-RPT-BILL-CYCLE     PIC X(02)  VALUE SPACES.          
             05 FILLER                PIC X(04)  VALUE SPACES.          
             05 WS-RPT-ACCT-NO        PIC X(18)  VALUE SPACES.          
             05 FILLER                PIC X(04)  VALUE SPACES.          
             05 WS-RPT-ACCT-CRT-DT    PIC X(10)  VALUE SPACES.          
P00453       05 FILLER                PIC X(01)  VALUE SPACES.          
             05 WS-RPT-TOT-AR-BAL     PIC ZZZ,ZZZ,ZZZ.99-.              
             05 FILLER                PIC X(06)  VALUE SPACES.          
             05 WS-RPT-MST-IND        PIC X(01)  VALUE SPACES.          
             05 FILLER                PIC X(11)  VALUE SPACES.          
             05 WS-RPT-CODE-ACCT-ST   PIC X(01)  VALUE SPACES.          
             05 FILLER                PIC X(09)  VALUE SPACES.          
             05 WS-RPT-DT-BILL-00     PIC X(10)  VALUE SPACES.          
             05 FILLER                PIC X(11)  VALUE SPACES.          
             05 WS-RPT-REV-MTH        PIC ZZZZZ9.                       
P00453       05 FILLER                PIC X(06)  VALUE SPACES.          
P00453       05 WS-RPT-PREPAY-FL      PIC X(01)  VALUE SPACES.          
       01 WS-DATA-LINE1.                                                
             05 FILLER                PIC X(01)  VALUE SPACES.          
             05 WS-RPT-WQ-ITEM-LIT1   PIC X(02)  VALUE SPACES.          
             05 FILLER                PIC X(05)  VALUE SPACES.          
             05 WS-RPT-BILL-CYCLE1    PIC X(02)  VALUE SPACES.          
             05 FILLER                PIC X(04)  VALUE SPACES.          
             05 WS-RPT-ACCT-NO1       PIC X(18)  VALUE SPACES.          
             05 FILLER                PIC X(04)  VALUE SPACES.          
             05 WS-RPT-ACCT-CRT-DT1   PIC X(10)  VALUE SPACES.          
             05 FILLER                PIC X(06)  VALUE SPACES.          
             05 WS-RPT-TOT-AR-BAL1    PIC ZZZ,ZZZ,ZZZ.99-.              
             05 FILLER                PIC X(06)  VALUE SPACES.          
             05 WS-RPT-MST-IND1       PIC X(01)  VALUE SPACES.          
             05 FILLER                PIC X(11)  VALUE SPACES.          
             05 WS-RPT-CODE-ACCT-ST1  PIC X(01)  VALUE SPACES.          
             05 FILLER                PIC X(07)  VALUE SPACES.          
             05 WS-RPT-DT-BILL-001    PIC X(10)  VALUE SPACES.          
             05 FILLER                PIC X(06)  VALUE SPACES.          
             05 WS-RPT-REV-MTH1       PIC ZZZZZ9.                       
             05 FILLER                PIC X(07)  VALUE SPACES.          
             05 WS-RPT-PEND-DT        PIC X(10)  VALUE SPACES.          
       01 WS-NO-DATA-LINE.                                              
             05  FILLER               PIC X(52)  VALUE SPACES.          
             05  FILLER               PIC X(31)  VALUE                  
                 '**** NO DATA FOR THIS RUN  ****'.                     
             05  FILLER               PIC X(49)  VALUE SPACES.          
       01 WS-FOOTER-LINE.                                               
              05  FILLER              PIC X(35)  VALUE SPACES.          
              05  FILLER              PIC X(25)  VALUE                  
                  '* * * END OF REPORT * * *'.                          
              05  FILLER              PIC X(72)  VALUE SPACES.          
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
             COPY CWS00010.                                                     
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
             COPY FIOJC01.                                                      
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
             COPY CWS09900.                                                     
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
             COPY CWS00303.                                                     
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
             COPY CWS00038.                                                     
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                   *          
      *****************************************************************         
             COPY FIOCA00.                                                      
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT - AT                                          *             
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT - UT                                         *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREMISE - PR                                              *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_BILL_WINDOW - BN                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBBILWDW                                                
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_WQ_ITEM - WQ                                              *         
      *****************************************************************         
           EXEC SQL                                                             
T37261          INCLUDE TBWQITS                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_RATE_PLAN_DESC - RD                                       *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBRTDESC                                                
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_JOB_PARM - G6                                             *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
P00453*****************************************************************         
P00453* CSS_PREPAY_HIST PK                                            *         
P00453*****************************************************************         
P00453     EXEC SQL                                                             
P00453          INCLUDE TBPREHST                                                
P00453     END-EXEC.                                                            
      *****************************************************************         
      *   DECLARE THE DRIVING CURSOR                                  *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE GET_REC CURSOR FOR                                 
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.BILL_CYCLE                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.MST_SUB_ACCT_IND                               
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.COMPANY_NO                                     
                     ,AT.REV_MTH_LST_NRML                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') ACCT_CREATE_DT        
                     ,AT.ACCOUNT_TYPE_CODE                              
                     ,PR.PEND_OFF_ORD_DT                                
                 FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                WHERE  (AT.PREMISE_NO           = PR.PREMISE_NO         
                       AND (PR.PEND_OFF_ORD_DT IS NULL                  
                          OR PR.PEND_OFF_ORD_DT < IIF(TRY_CONVERT(DATE, 
                                                   :WS-CUR-DATE-MINUS-7
              ) IS NULL OR (PATINDEX('%.%', :WS-CUR-DATE-MINUS-7
              ) <> 0) OR (LEN(:WS-CUR-DATE-MINUS-7
              ) <> 10), CIS.CHAR2DATE(:WS-CUR-DATE-MINUS-7
              ), CONVERT(DATE, :WS-CUR-DATE-MINUS-7) )  
                          OR PR.PEND_OFF_ORD_DT > IIF(TRY_CONVERT(DATE, 
                                                   :WS-CUR-DATE-PLUS-14
              ) IS NULL OR (PATINDEX('%.%', :WS-CUR-DATE-PLUS-14
              ) <> 0) OR (LEN(:WS-CUR-DATE-PLUS-14
              ) <> 10), CIS.CHAR2DATE(:WS-CUR-DATE-PLUS-14
              ), CONVERT(DATE, :WS-CUR-DATE-PLUS-14) )) 
                       AND AT.ACCOUNT_NO NOT IN                         
                         (SELECT UT.ACCOUNT_NO                          
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                             ,CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                     
                        WHERE UT.ACCOUNT_NO     = AT.ACCOUNT_NO         
                          AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE     
                          AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO       
                          AND (UT.CODE_REVENUE_CLASS = '000'            
                              OR RD.SECURED_RATE_FL  = 'Y')))           
A02310            AND  (( AT.BILL_CYCLE        < :WS-MAX-BILL-CYCLE-MIN 
A02310                    AND AT.REV_MTH_LST_NRML  < :WS-MIN-REV-MONTH )
A02310                       OR                                         
A02310                    (AT.BILL_CYCLE < :WS-MAX-BILL-CYCLE           
A02310                    AND AT.REV_MTH_LST_NRML  < :WS-MAX-REV-MONTH )
A02310                       OR                                         
A02310                    (AT.BILL_CYCLE > :WS-MAX-BILL-CYCLE           
A02310                     AND AT.REV_MTH_LST_NRML                      
A02310                                          < :WS-PREV-REV-MONTH )) 
A02182            AND  (AT.REV_MTH_LST_NRML   <> 0 OR                   
A02182                 (AT.REV_MTH_LST_NRML    = 0 AND                  
A02182                 (CAST(ACCT_CREATE_DT AS DATE)  <=                        
A02182                             DATEADD( DAY, -60, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))))  
                  AND  AT.CODE_ACCT_STAT    = 'A'                       
                  AND  AT.CODE_ACCT_BILLED <> 'U'                       
                  ORDER  BY AT.BILL_CYCLE, AT.ACCOUNT_NO                
                  FOR READ ONLY                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_REC CURSOR FOR                                         
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.MST_SUB_ACCT_IND                                       
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.ACCT_CREATE_DT                                         
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,PR.PEND_OFF_ORD_DT                                        
MFA-TR*          FROM  CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_PREMISE PR                                           
MFA-TR*         WHERE  (AT.PREMISE_NO           = PR.PREMISE_NO                 
MFA-TR*                AND (PR.PEND_OFF_ORD_DT IS NULL                          
MFA-TR*                   OR PR.PEND_OFF_ORD_DT < :WS-CUR-DATE-MINUS-7          
MFA-TR*                   OR PR.PEND_OFF_ORD_DT > :WS-CUR-DATE-PLUS-14)         
MFA-TR*                AND AT.ACCOUNT_NO NOT IN                                 
MFA-TR*                  (SELECT UT.ACCOUNT_NO                                  
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                      ,CSS_RATE_PLAN_DESC RD                             
MFA-TR*                 WHERE UT.ACCOUNT_NO     = AT.ACCOUNT_NO                 
MFA-TR*                   AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE             
MFA-TR*                   AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO               
MFA-TR*                   AND (UT.CODE_REVENUE_CLASS = '000'                    
MFA-TR*                       OR RD.SECURED_RATE_FL  = 'Y')))                   
MFA-TR*           AND  (( AT.BILL_CYCLE        < :WS-MAX-BILL-CYCLE-MIN         
MFA-TR*                   AND AT.REV_MTH_LST_NRML  < :WS-MIN-REV-MONTH )        
MFA-TR*                      OR                                                 
MFA-TR*                   (AT.BILL_CYCLE < :WS-MAX-BILL-CYCLE                   
MFA-TR*                   AND AT.REV_MTH_LST_NRML  < :WS-MAX-REV-MONTH )        
MFA-TR*                      OR                                                 
MFA-TR*                   (AT.BILL_CYCLE > :WS-MAX-BILL-CYCLE                   
MFA-TR*                    AND AT.REV_MTH_LST_NRML                              
MFA-TR*                                         < :WS-PREV-REV-MONTH ))         
MFA-TR*           AND  (AT.REV_MTH_LST_NRML   <> 0 OR                           
MFA-TR*                (AT.REV_MTH_LST_NRML    = 0 AND                          
MFA-TR*                (DATE(ACCT_CREATE_DT)  <=                                
MFA-TR*                            DATE(:WS-CURRENT-DATE) - 60 DAYS)))          
MFA-TR*           AND  AT.CODE_ACCT_STAT    = 'A'                               
MFA-TR*           AND  AT.CODE_ACCT_BILLED <> 'U'                               
MFA-TR*           ORDER  BY AT.BILL_CYCLE, AT.ACCOUNT_NO                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC                                                             
                                                                        
       01  WS-END                        PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSRP036 ENDS HERE  '.                  
                                                                        
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
           PERFORM 0110-POPULATE-HEADERS  THRU 0110-EXIT.               
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN OUTPUT FCSPT33B-FILE.                                   
           OPEN OUTPUT FCSPT33C-FILE.                                   
T34924                                                                  
T34924     MOVE  WS-PGRMNAME            TO WS-PROGRAM.                  
T34924     PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT.                 
T34924     MOVE WS-INPUT-DATE           TO WS-DATE-EXTRACT.             
T34924                                                                  
           IF COMMON-DATE-NEEDED                                        
T34924        MOVE 'COMMON'                TO WS-PGRMNAME               
T34924        MOVE WS-DATE                 TO WS-COMMAND                
T34924        PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
T34924        MOVE WS-PGRNAME              TO WS-PGRMNAME               
T34924        MOVE WS-INPUT-DATE           TO WS-DATE-EXTRACT           
T34924     END-IF                                                       
                                                                        
T34924     DISPLAY 'WS-DATE-EXTRACT : ' WS-DATE-EXTRACT                 
                                                                        
           MOVE WS-DATE-EXTRACT(9:2)   TO WS-FMT-DAY.                   
           MOVE WS-DATE-EXTRACT(6:2)   TO WS-FMT-MON.                   
           MOVE WS-DATE-EXTRACT(3:2)   TO WS-FMT-YEAR.                  
           MOVE WS-DATE-EXTRACT(1:2)   TO WS-FMT-CC.                    
                                                                        
           ACCEPT WS-CURRENT-TIME      FROM TIME.                       
                                                                        
           PERFORM 2000-GET-CUR-DATE   THRU 2000-EXIT.                  
                                                                        
           PERFORM 2100-GET-REV-MONTH  THRU 2100-EXIT.                  
           PERFORM 2200-GET-BG-CYCLE   THRU 2200-EXIT.                  
PROD10     PERFORM 2250-GET-BG-CYCLE-FOR-MINMTH THRU 2250-EXIT.         
                                                                        
T34924     DISPLAY 'WS-MAX-BILL-CYCLE     : ' WS-MAX-BILL-CYCLE.        
PROD10     DISPLAY 'WS-MAX-BILL-CYCLE-MIN : ' WS-MAX-BILL-CYCLE-MIN.    
                                                                        
T34924     MOVE  'PCSCA107'            TO WS-PROGRAM.                   
T34924     MOVE  WS-PARM               TO WS-COMMAND.                   
T34924     MOVE  ZEROS                 TO WS-SEQUENCE.                  
T34924     MOVE  SPACES                TO WS-SYSIPT.                    
T34924     MOVE  WS-KEY-AREA           TO E-FJC01-KEY.                  
T34924                                                                  
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
           MOVE 1                      TO WS-SUB                        
ACT379     MOVE 'N'                    TO  WS-NO-MORE-RECORDS.          
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0110-POPULATE-HEADERS.                                                  
      ******************************************************************        
       0110-POPULATE-HEADERS.                                           
                                                                        
           MOVE    1                           TO WS-REPORT-TYPE.       
           ADD     1                           TO WS-PAGE-COUNT1.       
           PERFORM 3100-REPORT-HEADERS         THRU 3100-EXIT.          
                                                                        
           MOVE    2                           TO WS-REPORT-TYPE.       
           ADD     1                           TO WS-PAGE-COUNT2.       
           PERFORM 3100-REPORT-HEADERS         THRU 3100-EXIT.          
                                                                        
           MOVE    3                           TO WS-REPORT-TYPE.       
           ADD     1                           TO WS-PAGE-COUNT3.       
           PERFORM 3100-REPORT-HEADERS         THRU 3100-EXIT.          
                                                                        
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           PERFORM 7100-OPEN-GET-REC           THRU  7100-EXIT.         
           PERFORM 7110-FETCH-GET-REC          THRU  7110-EXIT.         
           PERFORM 6000-PROCESS-GET-REC        THRU  6000-EXIT          
                                               UNTIL END-OF-CURSOR.     
           PERFORM 7120-CLOSE-GET-REC          THRU  7120-EXIT.         
                                                                        
            IF WS-DATA-PEND = 'Y'                                       
               MOVE    3                        TO   WS-REPORT-TYPE     
               PERFORM 8100-PRINT-RPT-FOOTER    THRU 8100-EXIT          
            ELSE                                                        
               MOVE    3                        TO WS-REPORT-TYPE       
               PERFORM  8200-PRINT-NO-DATA       THRU 8200-EXIT         
            END-IF.                                                     
                                                                        
            IF WS-DATA-NONUTIL = 'Y'                                    
               MOVE    2                        TO WS-REPORT-TYPE       
               PERFORM 8100-PRINT-RPT-FOOTER    THRU 8100-EXIT          
            ELSE                                                        
               MOVE    2                        TO WS-REPORT-TYPE       
               PERFORM 8200-PRINT-NO-DATA       THRU 8200-EXIT          
            END-IF.                                                     
                                                                        
            IF WS-DATA-ACCOUNTS = 'Y'                                   
               MOVE    1                        TO WS-REPORT-TYPE       
               PERFORM 8100-PRINT-RPT-FOOTER    THRU 8100-EXIT          
            ELSE                                                        
               MOVE    1                        TO WS-REPORT-TYPE       
               PERFORM 8200-PRINT-NO-DATA       THRU 8200-EXIT          
            END-IF.                                                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-GET-CUR-DATE.                                             *        
      * GET THE CURRENT DATE - 7 DAYS AND CURRENT DATE PLUS 14 DAYS    *        
      ******************************************************************        
       2000-GET-CUR-DATE.                                               
                                                                        
            EXEC SQL                                                    
             SELECT
              DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) - 7)-1, CAST('00010101' AS DATE)),
              DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) + 14)-1, CAST('00010101' AS DATE))
            INTO
              :WS-CUR-DATE-MINUS-7,
              :WS-CUR-DATE-PLUS-14  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*      SET  :WS-CUR-DATE-MINUS-7 = DATE(DAYS(CURRENT DATE) - 7)           
MFA-TR*          ,:WS-CUR-DATE-PLUS-14 = DATE(DAYS(CURRENT DATE) + 14)          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE        
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A02310          NEXT SENTENCE                                           
            ELSE                                                        
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        2000-GET-CUR-DATE             *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
A02310        DISPLAY '* CUR-DATE-MINUS-7 : ' WS-CUR-DATE-MINUS-7       
A02310        DISPLAY '* CUR-DATE-PLUS-14: '  WS-CUR-DATE-PLUS-14       
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
            END-IF.                                                     
A02310*                                                                         
A02310      DISPLAY '* CUR-DATE-MINUS-7 : ' WS-CUR-DATE-MINUS-7         
A02310      DISPLAY '* CUR-DATE-PLUS-14: '  WS-CUR-DATE-PLUS-14         
A02310*                                                                         
                                                                        
A02182      EXEC SQL                                                    
A02182       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
A02182      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*      SET  :WS-CURRENT-DATE    = CURRENT DATE                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02182                                                                  
A02182      MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE        
A02182                                                                  
A02182      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A02182          NEXT SENTENCE                                           
A02182      ELSE                                                        
A02182        DISPLAY '********** PCSRP036 ABORT **************'        
A02182        DISPLAY '*        2000-GET-CUR-DATE             *'        
A02182        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A02182        DISPLAY '* PROGRAM ABORTING...                  *'        
A02182        DISPLAY '********** PCSRP036 ABORT **************'        
A02182        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02182      END-IF.                                                     
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2100-GET-REV-MONTH                                                      
      ******************************************************************        
       2100-GET-REV-MONTH.                                              
                                                                        
            EXEC SQL                                                    
               SELECT   MAX(REVENUE_MONTH)                              
                       ,MIN(REVENUE_MONTH)                              
               INTO    :WS-MAX-REV-MONTH                                
                      ,:WS-MIN-REV-MONTH                                
               FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
            WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                       
T37261                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT   MAX(REVENUE_MONTH)                                      
MFA-TR*                ,MIN(REVENUE_MONTH)                                      
MFA-TR*        INTO    :WS-MAX-REV-MONTH                                        
MFA-TR*               ,:WS-MIN-REV-MONTH                                        
MFA-TR*        FROM  CSS_BILL_WINDOW                                            
MFA-TR*     WHERE DATE_EXTRACT = :WS-DATE-EXTRACT                               
MFA-TR*      WITH UR                                                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        2100-GET-REV-MONTH            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* DATE EXTRACT   : ' WS-DATE-EXTRACT             
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T34924      DISPLAY 'WS-MAX-REV-MONTH : ' WS-MAX-REV-MONTH.             
T34924      DISPLAY 'WS-MIN-REV-MONTH : ' WS-MIN-REV-MONTH.             
T34924      MOVE WS-MAX-REV-MONTH TO WS-PREV-REV-MONTH-N.               
T34924      COMPUTE WS-PREV-REV-MM = WS-PREV-REV-MM - 1.                
                                                                        
            IF WS-PREV-REV-MM   = 0                                     
               MOVE  12                     TO      WS-PREV-REV-MM      
               COMPUTE WS-PREV-REV-CCYY = WS-PREV-REV-CCYY - 1          
            END-IF.                                                     
                                                                        
T34924      MOVE WS-PREV-REV-MONTH-N TO WS-PREV-REV-MONTH.              
T34924      DISPLAY 'WS-PREV-REV-MONTH : ' WS-PREV-REV-MONTH.           
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2200-GET-BG-CYCLE FOR WS-MAX-REV-MONTH                                  
      ******************************************************************        
       2200-GET-BG-CYCLE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT  MAX(BILL_CYCLE)                                 
T34924            INTO :WS-MAX-BILL-CYCLE                               
                  FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                   
                 WHERE  DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                
T34924             AND  REVENUE_MONTH = :WS-MAX-REV-MONTH               
T37261                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  MAX(BILL_CYCLE)                                         
MFA-TR*           INTO :WS-MAX-BILL-CYCLE                                       
MFA-TR*           FROM  CSS_BILL_WINDOW                                         
MFA-TR*          WHERE  DATE_EXTRACT  = :WS-DATE-EXTRACT                        
MFA-TR*            AND  REVENUE_MONTH = :WS-MAX-REV-MONTH                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        2200-GET-BG-CYCLE             *'        
              DISPLAY '* SQLCODE          : ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '* WS-DATE-EXTRACT  : ' WS-DATE-EXTRACT           
T34924        DISPLAY '* WS-MAX-REV-MONTH : ' WS-MAX-REV-MONTH          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
PROD10******************************************************************        
      * 2250-GET-BG-CYCLE FOR WS-MIN-REV-MONTH                                  
      ******************************************************************        
       2250-GET-BG-CYCLE-FOR-MINMTH.                                    
                                                                        
           EXEC SQL                                                     
                SELECT  MAX(BILL_CYCLE)                                 
                  INTO :WS-MAX-BILL-CYCLE-MIN                           
                  FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                   
                 WHERE  DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                
                   AND  REVENUE_MONTH = :WS-MIN-REV-MONTH               
T37261                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  MAX(BILL_CYCLE)                                         
MFA-TR*           INTO :WS-MAX-BILL-CYCLE-MIN                                   
MFA-TR*           FROM  CSS_BILL_WINDOW                                         
MFA-TR*          WHERE  DATE_EXTRACT  = :WS-DATE-EXTRACT                        
MFA-TR*            AND  REVENUE_MONTH = :WS-MIN-REV-MONTH                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        2250-GET-BG-CYCLE             *'        
              DISPLAY '* SQLCODE          : ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '* WS-DATE-EXTRACT  : ' WS-DATE-EXTRACT           
              DISPLAY '* WS-MIN-REV-MONTH : ' WS-MIN-REV-MONTH          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
PROD10 2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************           
      * SEE IF THERE IS AN ACTIVE WQ FOR THE ACCOUNT                *           
      ***************************************************************           
      *                                                                         
       2700-CHECK-WQ-PARA.                                              
      *                                                                         
           MOVE '  '                TO WS-WQ-ITEM-LIT                   
                                                                        
           MOVE AT-ACCOUNT-NO       TO WQ-ACCOUNT-NO                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) WQ.STATUS                                          
                INTO :WS-WQ-ITEM                                        
               FROM  CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
               WHERE WQ.ACCOUNT_NO = :WQ-ACCOUNT-NO                     
                 AND WQ.STATUS IN ('A','I')                             
                 AND WQ.RESP_AREA_ID = '637'                            
                                                    
T37261                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WQ.STATUS                                                  
MFA-TR*         INTO :WS-WQ-ITEM                                                
MFA-TR*        FROM  CSS_WQ_ITEMS WQ                                            
MFA-TR*        WHERE WQ.ACCOUNT_NO = :WQ-ACCOUNT-NO                             
MFA-TR*          AND WQ.STATUS IN ('A','I')                                     
MFA-TR*          AND WQ.RESP_AREA_ID = '637'                                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE 'WQ'              TO  WS-WQ-ITEM-LIT                 
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ' '            TO  WS-WQ-ITEM-LIT                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        2700-CHECK-WQ-PARA            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT-NO     : ' WQ-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * POPULATE PREPAY COLUMN                                      *           
      ***************************************************************           
      *                                                                         
P00453 2800-CHECK-PREPAY.                                               
P00453*                                                                         
P00453     MOVE ' '                 TO WS-PREPAY-FL                     
P00453                                                                  
P00453     MOVE AT-ACCOUNT-NO       TO PK-ACCOUNT-NO                    
P00453                                                                  
P00453     EXEC SQL                                                     
P00453        SELECT TOP(1) 'Y'                                                
P00453        INTO :WS-PREPAY-FL                                        
P00453        FROM   CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                   
P00453        WHERE  PK.ACCOUNT_NO        =:PK-ACCOUNT-NO               
P00453                                       
P00453     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-PREPAY-FL                                                
MFA-TR*       FROM   CSS_PREPAY_HIST PK                                         
MFA-TR*       WHERE  PK.ACCOUNT_NO        =:PK-ACCOUNT-NO                       
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453                                                                  
P00453     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
P00453                                                                  
P00453     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00453        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00453           MOVE ' '            TO  WS-PREPAY-FL                   
P00453        END-IF                                                    
P00453     ELSE                                                         
P00453        DISPLAY '********** PCSRP036 ABORT **************'        
P00453        DISPLAY '*        2800-CHECK-PREPAY             *'        
P00453        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00453        DISPLAY '* ACCOUNT-NO     : ' PK-ACCOUNT-NO               
P00453        DISPLAY '* PROGRAM ABORTING...                  *'        
P00453        DISPLAY '********** PCSRP036 ABORT **************'        
P00453        PERFORM 9900-ABEND               THRU 9900-EXIT           
P00453     END-IF.                                                      
P00453*                                                                         
P00453 2800-EXIT.                                                       
P00453     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3100-REPORT-HEADERS                                           *         
      ******************************************************************        
       3100-REPORT-HEADERS.                                             
                                                                        
           MOVE 1                              TO WS-SKIP-LINES-NUM.    
                                                                        
           MOVE WS-FMT-DATE                    TO RPT-RUN-DATE1         
                                                  RPT-RUN-DATE2.        
           MOVE WS-HH                          TO WS-RT-HH.             
           MOVE WS-MM                          TO WS-RT-MM.             
           MOVE WS-SS                          TO WS-RT-SS.             
                                                                        
           IF WS-REPORT-TYPE = 1                                        
              MOVE WS-PAGE-COUNT1              TO RPT-PAGE-NO           
              MOVE 'PCSRP036'                  TO RPT-HEADER            
              MOVE 'ACCOUNTS THAT  - '         TO RPT-HDR-DESC          
              MOVE WS-RPT-HEADER-01            TO WS-PRT33-RECORD       
              WRITE PRT33-RECORD               FROM WS-PRT33-RECORD     
                                    AFTER ADVANCING TOP-OF-PAGE         
           ELSE                                                         
              IF WS-REPORT-TYPE = 2                                     
                 MOVE WS-PAGE-COUNT2           TO RPT-PAGE-NO           
                 MOVE 'PCSRP036'               TO RPT-HEADER            
                 MOVE 'NON-UNIL ACCOUNTS'      TO RPT-HDR-DESC          
                 MOVE WS-RPT-HEADER-01         TO WS-PRT33-RECORD       
                 WRITE PRT33B-RECORD           FROM WS-PRT33-RECORD     
                                     AFTER ADVANCING TOP-OF-PAGE        
              ELSE                                                      
                MOVE WS-PAGE-COUNT3            TO RPT-PAGE-NO           
                MOVE 'PCSRP036'                TO RPT-HEADER            
                MOVE 'PENDING ACCOUNTS -'      TO RPT-HDR-DESC          
                MOVE WS-RPT-HEADER-01          TO WS-PRT33-RECORD       
                WRITE PRT33C-RECORD            FROM WS-PRT33-RECORD     
                                      AFTER ADVANCING TOP-OF-PAGE       
           END-IF
           END-IF.                                                      
                                                                        
           MOVE WS-RPT-HEADER-02               TO WS-PRT33-RECORD.      
           PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT.          
                                                                        
           MOVE WS-RPT-HEADER-03               TO WS-PRT33-RECORD.      
           PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT.          
                                                                        
           IF WS-REPORT-TYPE = 1 OR 2                                   
              MOVE 3                              TO WS-SKIP-LINES-NUM  
              MOVE WS-RPT-HEADER-04               TO WS-PRT33-RECORD    
              PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT        
           ELSE                                                         
              MOVE 3                              TO WS-SKIP-LINES-NUM  
              MOVE WS-RPT-HEADER-05               TO WS-PRT33-RECORD    
              PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT        
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * FORMAT THE PRINTED DATA                                     *           
      * 5000-MOVE-FORMAT-ACCT.                                      *           
      ***************************************************************           
                                                                        
       5000-MOVE-FORMAT-ACCT.                                           
      *                                                                         
            MOVE AT-ACCOUNT-NO          TO WS-SAVE-ACCT                 
            MOVE WS-SAVE-ACCT           TO WS-SAVE-ACCT-X               
      *                                                                         
            MOVE WS-SAVE-ACCT-X(1:1)    TO WS-ACCOUNT1                  
            MOVE WS-SAVE-ACCT-X(2:4)    TO WS-ACCOUNT2                  
            MOVE WS-SAVE-ACCT-X(6:4)    TO WS-ACCOUNT3                  
            MOVE WS-SAVE-ACCT-X(10:4)   TO WS-ACCOUNT4                  
            MOVE AT-REV-MTH-LST-NRML    TO WS-REVENUE-MONTH             
            MOVE AT-ACCT-CREATE-DT      TO WS-ACCT-CREATE-DT            
            MOVE 'N'                    TO WS-NO-REPORT.                
      *                                                                         
       5000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 6000-PROCESS-GET-REC PARA.                                     *        
      * PROCESS ALL THE PENDING, NON-UTILITY AND DETAIL ACCOUNTS       *        
      * THAT ARE NOT BILLED ON PREVIOUS BILL CYCLES.                   *        
      ******************************************************************        
       6000-PROCESS-GET-REC.                                            
                                                                        
           IF WS-DATE-NULLS = -1 OR PR-PEND-OFF-ORD-DT = SPACES         
             MOVE '0000-00-00'        TO   PR-PEND-OFF-ORD-DT           
           END-IF                                                       
                                                                        
           IF WS-SUBA-NULLS = -1                                        
              MOVE SPACES                TO AT-MST-SUB-ACCT-IND         
           END-IF                                                       
                                                                        
           MOVE 'Y'        TO WS-PRINT-SW                               
           MOVE 'Y'        TO WS-DATA-IND                               
                                                                        
           PERFORM 2700-CHECK-WQ-PARA     THRU 2700-EXIT                
P00453     PERFORM 2800-CHECK-PREPAY      THRU 2800-EXIT                
           PERFORM 5000-MOVE-FORMAT-ACCT  THRU 5000-EXIT                
                                                                        
           IF WS-PRINT-SW = 'Y'                                         
              IF PR-PEND-OFF-ORD-DT > '0000-00-00'                      
                 MOVE 3                      TO WS-REPORT-TYPE          
                 MOVE 'Y'                    TO WS-DATA-PEND            
                 PERFORM 6500-PRINT-DATA     THRU 6500-EXIT             
               ELSE                                                     
                  IF AT-ACCOUNT-TYPE-CODE = 'N'                         
                     MOVE 2                   TO WS-REPORT-TYPE         
                     PERFORM 6500-PRINT-DATA  THRU 6500-EXIT            
                     MOVE 'Y'                 TO WS-DATA-NONUTIL        
                  ELSE                                                  
                     IF AT-MST-SUB-ACCT-IND = 'M'                       
                        MOVE 2                   TO WS-REPORT-TYPE      
                        PERFORM 6500-PRINT-DATA  THRU 6500-EXIT         
                        MOVE 'Y'                 TO WS-DATA-NONUTIL     
                     ELSE                                               
                           MOVE 1                 TO WS-REPORT-TYPE     
                           MOVE 'Y'               TO WS-DATA-ACCOUNTS   
P00453                     MOVE 'Y'               TO WS-DATA-ACCOUNTS   
                           PERFORM 6500-PRINT-DATA    THRU 6500-EXIT    
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
            END-IF                                                      
           PERFORM 7110-FETCH-GET-REC          THRU  7110-EXIT.         
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6500-PRINT-DATA.                                                        
      ******************************************************************        
       6500-PRINT-DATA.                                                 
                                                                        
           MOVE WS-WQ-ITEM-LIT               TO WS-RPT-WQ-ITEM-LIT      
                                                WS-RPT-WQ-ITEM-LIT1.    
P00453     MOVE WS-PREPAY-FL                 TO WS-RPT-PREPAY-FL.       
           MOVE AT-BILL-CYCLE                TO WS-RPT-BILL-CYCLE       
                                                WS-RPT-BILL-CYCLE1.     
           MOVE WS-ACCT                      TO WS-RPT-ACCT-NO          
                                                WS-RPT-ACCT-NO1.        
           MOVE WS-ACCT-CREATE-DT            TO WS-RPT-ACCT-CRT-DT      
                                                WS-RPT-ACCT-CRT-DT1.    
                                                                        
           MOVE AT-TOTAL-AR-BALANCE          TO WS-TOTAL-AR-BALANCE.    
                                                                        
           MOVE WS-TOTAL-AR-BALANCE          TO WS-RPT-TOT-AR-BAL       
                                                WS-RPT-TOT-AR-BAL1.     
           MOVE AT-MST-SUB-ACCT-IND          TO WS-RPT-MST-IND          
                                                WS-RPT-MST-IND1.        
           MOVE AT-CODE-ACCT-STAT            TO WS-RPT-CODE-ACCT-ST     
                                                WS-RPT-CODE-ACCT-ST1.   
           MOVE AT-DATE-BILL-DAY-00          TO WS-RPT-DT-BILL-00       
                                                WS-RPT-DT-BILL-001.     
           MOVE WS-REVENUE-MONTH             TO WS-RPT-REV-MTH          
                                                WS-RPT-REV-MTH1.        
           IF WS-REPORT-TYPE = 1 AND WS-LINE-COUNT1 > WS-MAX-LINES      
                ADD     1                   TO WS-PAGE-COUNT1           
                MOVE    0                   TO WS-LINE-COUNT1           
                PERFORM 3100-REPORT-HEADERS THRU 3100-EXIT              
           ELSE                                                         
           IF WS-REPORT-TYPE = 2 AND WS-LINE-COUNT2 > WS-MAX-LINES      
                ADD     1                   TO WS-PAGE-COUNT2           
                MOVE    0                   TO WS-LINE-COUNT2           
                PERFORM 3100-REPORT-HEADERS THRU 3100-EXIT              
           ELSE                                                         
           IF  WS-REPORT-TYPE  = 3 AND WS-LINE-COUNT3 > WS-MAX-LINES    
                ADD     1                   TO WS-PAGE-COUNT3           
                MOVE    0                   TO WS-LINE-COUNT3           
                PERFORM 3100-REPORT-HEADERS THRU 3100-EXIT              
           END-IF
           END-IF
           END-IF.                                                      
           IF WS-REPORT-TYPE = 1 OR 2                                   
              MOVE WS-DATA-LINE                   TO WS-PRT33-RECORD    
              MOVE 2                              TO WS-SKIP-LINES-NUM  
              PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT        
           ELSE                                                         
T35451     IF WS-REPORT-TYPE = 3                                        
              MOVE PR-PEND-OFF-ORD-DT             TO WS-RPT-PEND-DT     
              MOVE WS-DATA-LINE1                  TO WS-PRT33-RECORD    
              MOVE 2                              TO WS-SKIP-LINES-NUM  
              PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT        
           END-IF
           END-IF.                                                      
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7100-OPEN-GET-REC.                                                      
      ******************************************************************        
       7100-OPEN-GET-REC.                                               
                                                                        
           EXEC SQL                                                     
              OPEN GET_REC                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*        7100-OPEN-GET-REC             *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036  ABORT **************'       
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-GET-REC.                                           *         
      ******************************************************************        
       7110-FETCH-GET-REC.                                              
                                                                        
           EXEC SQL                                                     
              FETCH GET_REC                                             
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-MST-SUB-ACCT-IND :WS-SUBA-NULLS                  
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-COMPANY-NO                                      
                   ,:AT-REV-MTH-LST-NRML                                
                   ,:AT-ACCT-CREATE-DT :WS-ACCT-NULLS                    
                   ,:AT-ACCOUNT-TYPE-CODE                               
                   ,:PR-PEND-OFF-ORD-DT :WS-DATE-NULLS                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                      TO WS-END-OF-CURSOR      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSRP036 ABORT **************'        
              DISPLAY '*       7110-FETCH-GET-REC           *'          
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT-NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* REVENUE MONTH  : ' WS-MAX-REV-MONTH            
              DISPLAY '* PREV.REV MONTH : ' WS-PREV-REV-MONTH           
              DISPLAY '* BILL CYCLE     : ' WS-MAX-BILL-CYCLE           
              DISPLAY '* CURRENT DATE   : ' WS-CUR-DATE-PLUS-14         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSRP036 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-GET-REC.                                                     
      ******************************************************************        
       7120-CLOSE-GET-REC.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE GET_REC                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSRP036 ABORT **************'       
               DISPLAY '*       7120-CLOSE-GET-REC             *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSRP036  ABORT **************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-WRITE-REPORT                                              *        
      ******************************************************************        
       8000-WRITE-REPORT.                                               
                                                                        
           IF WS-REPORT-TYPE = 1                                        
                WRITE    PRT33-RECORD   FROM   WS-PRT33-RECORD          
                               AFTER ADVANCING WS-SKIP-LINES-NUM        
                INITIALIZE WS-PRT33-RECORD                              
                ADD WS-SKIP-LINES-NUM          TO WS-LINE-COUNT1        
                ADD 1                          TO WS-LINE-COUNT1        
           ELSE                                                         
             IF WS-REPORT-TYPE = 2                                      
                WRITE    PRT33B-RECORD  FROM     WS-PRT33-RECORD        
                         AFTER ADVANCING  WS-SKIP-LINES-NUM             
                INITIALIZE WS-PRT33-RECORD                              
                ADD WS-SKIP-LINES-NUM          TO WS-LINE-COUNT2        
                ADD 1                          TO WS-LINE-COUNT2        
             ELSE                                                       
                IF WS-REPORT-TYPE = 3                                   
                WRITE   PRT33C-RECORD  FROM      WS-PRT33-RECORD        
                              AFTER ADVANCING    WS-SKIP-LINES-NUM      
                INITIALIZE WS-PRT33-RECORD                              
                ADD WS-SKIP-LINES-NUM          TO WS-LINE-COUNT3        
                ADD 1                          TO WS-LINE-COUNT3        
           END-IF                                                       
                                                                        
T35451     INITIALIZE WS-REPORT-TYPE
             END-IF
           END-IF.                                   
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8100-PRINT-RPT-FOOTER.                                                  
      ******************************************************************        
       8100-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE WS-FOOTER-LINE                 TO WS-PRT33-RECORD.      
           PERFORM 8000-WRITE-REPORT THRU 8000-EXIT.                    
                                                                        
       8100-EXIT.                                                       
      ******************************************************************        
      * 8200-PRINT-NO-DATA                                                      
      ******************************************************************        
       8200-PRINT-NO-DATA.                                              
                                                                        
           MOVE  WS-NO-DATA-LINE               TO  WS-PRT33-RECORD.     
           PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT.          
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                                        
      * 9000-TERMINATE                                            *             
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE  FCSPT33-FILE.                                         
           CLOSE  FCSPT33B-FILE.                                        
           CLOSE  FCSPT33C-FILE.                                        
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                                        
      * 9900-PROCESS-ABEND                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  6251-GET-FJC01-DATE                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7600-START-FCSJC01                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
