       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSRP032.                                        
       DATE-WRITTEN.   08/15/03.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      *******             CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________  _____________________________________ **         
      **  08/15/03     KSR       NEW PROGRAM TO CREATE REPORT FOR    **         
      **                         NON-PERFECT MATCH - NOT TRANSFER    **         
      **                         FOR SCEG & PSNC.                    **         
C34788**  04/12/07   RICK BLACK  CONCEALED FIRST 5 DIGITS OF SSN     **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSRP032 REPORT  ----      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSRP032-FILE                                         
               ASSIGN UT-S-FCSRP032                                     
               FILE STATUS IS WS-FRP032-STATUS.                         
      *                                                                         
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSRP032-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       COPY FIORP032.                                                           
       COPY CFDPT33.                                                            
      *COPY CFDPT331.                                                           
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT331-RECORD.                                               
           05  PRT331-CC                  PIC X(01).                    
           05  PRT331-DATA                PIC X(132).                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP032'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSRP032 STARTS HERE'.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1A PIC X(51)    VALUE               
               '   AUTOMATIC FINAL BILL/WRITE OFF TRANSFER - FAILED'.   
           05  WS-DEFAULT-RPT1-TITLE1B PIC X(45)    VALUE               
               '         NON-PERFECT MATCH - NOT TRANSFERRED '.         
      *                                                                         
           05  WS-REPORT-PARM-TYPE     PIC X(07).                       
                                                                        
           05  WS-DEFAULT-RPT1-TITLE2.                                  
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'CURRENT AS OF '.    
               10  WS-DEFAULT-RPT1-TITLE2-DT PIC X(10).                 
               10  FILLER              PIC X(13)    VALUE SPACES.       
      *                                                                         
           05  WS-SYSIN-EXIST          PIC X(01)    VALUE 'Y'.          
               88  SYSIN-DOES-NOT-EXIST             VALUE 'N'.          
               88  SYSIN-DOES-EXIST                 VALUE 'Y'.          
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
           05  WS-CHANGE-COMP-NO       PIC X(01)    VALUE 'N'.          
               88  COMPANY-CHANGED                  VALUE 'Y'.          
           05  WS-START-REPORT         PIC X(01)    VALUE 'N'.          
               88  REPORT-IS-NOT-STARTED            VALUE 'N'.          
           05  WS-END-OF-SYSIN-REC     PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-SYSIN                 VALUE 'N'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
               88  END-REC-WAS-PROCESSED            VALUE 'Y'.          
           05  WS-COMP-TOT-HEADER      PIC X(01)    VALUE 'N'.          
               88  COMPANY-HEADER                   VALUE 'Y'.          
      *                                                                         
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
           05  WS-FPT33-STATUS         PIC X(02).                       
           05  WS-SYSIN-COMP-REC-CNTR  PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-COMP-REC-CNTR        PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-FRP032-REC-CNTR      PIC 9(07)    VALUE ZERO COMP-3.  
           05  WS-RE-TOTAL-MAX-DEP     PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-RE-TOTAL-PD-DEP      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-RE-TOTAL-REFUND      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-CO-TOTAL-MAX-DEP     PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-CO-TOTAL-PD-DEP      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-CO-TOTAL-REFUND      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-GR-TOTAL-MAX-DEP     PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-GR-TOTAL-PD-DEP      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-GR-TOTAL-REFUND      PIC 9(11)    VALUE ZERO COMP-3.  
           05  WS-FRP032-STATUS        PIC X(02).                       
               88  FRP032-SUCCESSFUL                VALUE '00'.         
XXXXXX     05  WS-FCA331-STATUS        PIC X(02).                       
XXXXXX         88  FCA331-SUCCESSFUL                VALUE '00'.         
      *                                                                         
           05  WS-PREV-LOC-OFFICE      PIC X(03)    VALUE SPACES.       
           05  WS-COMPANY-NO           PIC X(02)    VALUE SPACES.       
           05  WS-TOTAL                PIC 9(9)V99  VALUE ZEROS.        
           05  WS-01-GRAND-TOTAL       PIC 9(9)V99  VALUE ZEROS.        
           05  WS-26-GRAND-TOTAL       PIC 9(9)V99  VALUE ZEROS.        
           05  WS-OUTPUT-ID            PIC X(4).                        
           05  WS-CREDIT-GRP           PIC X(1).                        
           05  WS-TOT-AR-BAL           PIC 9(9)V99  VALUE ZEROS.        
           05  WS-35-DAY-CT01          PIC 9(3)     VALUE ZEROS.        
           05  WS-55-DAY-CT01          PIC 9(3)     VALUE ZEROS.        
           05  WS-65-DAY-CT01          PIC 9(3)     VALUE ZEROS.        
           05  WS-115-DAY-CT01         PIC 9(3)     VALUE ZEROS.        
           05  WS-NEW-CREDIT-GRP-01    PIC 9(3)     VALUE ZEROS.        
           05  WS-NEW-XFER-AMT-01      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-ARR-CREDIT-GRP-01    PIC 9(3)     VALUE ZEROS.        
           05  WS-ARR-XFER-AMT-01      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-BAL-CREDIT-GRP-01    PIC 9(3)     VALUE ZEROS.        
           05  WS-BAL-XFER-AMT-01      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-EXPT-CREDIT-GRP-01   PIC 9(3)     VALUE ZEROS.        
           05  WS-EXPT-XFER-AMT-01     PIC 9(9)V99  VALUE ZEROS.        
           05  WS-35-DAY-CT26          PIC 9(3)     VALUE ZEROS.        
           05  WS-55-DAY-CT26          PIC 9(3)     VALUE ZEROS.        
           05  WS-65-DAY-CT26          PIC 9(3)     VALUE ZEROS.        
           05  WS-115-DAY-CT26         PIC 9(3)     VALUE ZEROS.        
           05  WS-NEW-CREDIT-GRP-26    PIC 9(3)     VALUE ZEROS.        
           05  WS-NEW-XFER-AMT-26      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-ARR-CREDIT-GRP-26    PIC 9(3)     VALUE ZEROS.        
           05  WS-ARR-XFER-AMT-26      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-BAL-CREDIT-GRP-26    PIC 9(3)     VALUE ZEROS.        
           05  WS-BAL-XFER-AMT-26      PIC 9(9)V99  VALUE ZEROS.        
           05  WS-EXPT-CREDIT-GRP-26   PIC 9(3)     VALUE ZEROS.        
           05  WS-EXPT-XFER-AMT-26     PIC 9(9)V99  VALUE ZEROS.        
           05  WS-TOT-TRANSFER         PIC 9(9)V99  VALUE ZEROS.        
           05  WS-ACCT-TYPE            PIC X(1)     VALUE SPACES.       
           05  WS-CUST-TYPE            PIC X(1)     VALUE SPACES.       
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
      ***************************************************************           
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
      ***************************************************************           
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 66   COMP-3.  
       01  WS-RPT2-LINE-NO             PIC 9(02)    VALUE 66   COMP-3.  
       01  WS-RPT1-PAGE-NO             PIC 9(04)    VALUE ZERO COMP-3.  
       01  WS-RPT2-PAGE-NO             PIC 9(04)    VALUE ZERO COMP-3.  
      *                                                                         
       01  WS-SSN.                                                      
           05  WS-SSN-1                PIC X(03).                       
           05  WS-SSN-2                PIC X(02).                       
           05  WS-SSN-3                PIC X(04).                       
      *                                                                         
       01  WS-FORMAT-SSN.                                               
           05  WS-SSN-FR1              PIC X(03).                       
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-SSN-FR2              PIC X(02).                       
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-SSN-FR3              PIC X(04).                       
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-MDY.                                                 
           05  WS-MDY-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-MDY-DD               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-MDY-CC               PIC X(02).                       
           05  WS-MDY-YY               PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSRP032'.   
           05  WS-53                   PIC 9(02)    VALUE 53.           
           05  WS-45                   PIC 9(02)    VALUE 45.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
           05  WS-66                   PIC 9(02)    VALUE 66.           
           05  WS-65                   PIC 9(02)    VALUE 65.           
           05  WS-68                   PIC 9(02)    VALUE 68.           
           05  WS-70                   PIC 9(02)    VALUE 70.           
           05  WS-80                   PIC 9(02)    VALUE 80.           
           05  WS-ZERO-DATE            PIC X(10)    VALUE '0000-00-00'. 
      *                                                                         
       01  WS-EXCEPTION-CODES.                                          
           05  WS-EC01                 PIC X(18)    VALUE               
                      'SAME NAME - NO SSN'.                             
           05  WS-EC02                 PIC X(33)    VALUE               
                      'SSN MATCH - DIFFERENT CUST NUMBER'.              
           05  WS-EC03                 PIC X(21)    VALUE               
                      'MISMATCH ACCOUNT TYPE'.                          
           05  WS-EC04                 PIC X(23)    VALUE               
                      'MISMATCH COMPANY NUMBER'.                        
           05  WS-EC05                 PIC X(38)    VALUE               
                      'TO ACCT:1ST POS OF CZ-ARREARS-HIST > 3'.         
           05  WS-EC06                 PIC X(38)    VALUE               
                      'TO ACCT:1ST POS OF CZ-ARREARS-HIST < 4'.         
           05  WS-EC07                 PIC X(21)    VALUE               
                      'MISMATCH ON NAME TYPE'.                          
           05  WS-EC08                 PIC X(38)    VALUE               
                      'NAME MATCH - DIFFERENT CUSTOMER NUMBER'.         
           05  WS-EC09                 PIC X(38)    VALUE               
                      '35 DAY & 55 DAY ACCOUNT ALREADY IN WO '.         
           05  WS-EC10                 PIC X(39)    VALUE               
                      'PRE-SELECTED MULTI-ACCOUNT IS NO LONGER'.        
           05  WS-EC11                 PIC X(33)    VALUE               
                      'NOT A UTILITY TO UTILITY TRANSFER'.              
           05  WS-EC12                 PIC X(40)    VALUE               
                      'COMM TO RES XFER FAILED WITH MISSING SSN'.       
           05  WS-EC13                 PIC X(40)    VALUE               
                      'RES TO COMM XFER FAILED WITH MISSING SSN'.       
      *                                                                         
       01  EXCEPTIONS.                                                  
           05  WS-EXCEPTIONS  OCCURS 20 TIMES    PIC X(40).             
       01  WS-SUB                            PIC 9(02) VALUE ZEROES.    
      *                                                                         
       01  P-EXCEPTION-4.                                               
           05  FILLER                        PIC X(92) VALUE SPACES.    
           05  WS-EXCEPTION-4                PIC X(40).                 
      *                                                                         
       01  P-EXCEPTION-5.                                               
           05  FILLER                        PIC X(92) VALUE SPACES.    
           05  WS-EXCEPTION-5                PIC X(40).                 
      *                                                                         
       01  P-EXCEPTION-6.                                               
           05  FILLER                        PIC X(92) VALUE SPACES.    
           05  WS-EXCEPTION-6                PIC X(40).                 
      *                                                                         
       01  P-EXCEPTION-10.                                              
           05  FILLER                        PIC X(92) VALUE SPACES.    
           05  WS-EXCEPTION-10               PIC X(40).                 
      *                                                                         
       01  P-EXCEPTION-11.                                              
           05  FILLER                        PIC X(92) VALUE SPACES.    
           05  WS-EXCEPTION-11               PIC X(40).                 
      *                                                                         
       01  WS-EXCEPTION-FLAGS.                                          
           05  WS-XFER-XEMPT-EF        PIC X(11)    VALUE               
                      'XFER EXEMPT'.                                    
           05  WS-BANKRUPT-EF          PIC X(08)    VALUE               
                      'BANKRUPT'.                                       
           05  WS-JUDGMENT-EF          PIC X(08)    VALUE               
                      'JUDGMENT'.                                       
           05  WS-MAJ-ACCT-EF          PIC X(05)    VALUE               
                      'MAJOR'.                                          
           05  WS-PEND-DNPFB-EF        PIC X(24)    VALUE               
                      'PENDING DNPFB ON XFER TO'.                       
           05  WS-MSTR-ACCT-EF         PIC X(06)    VALUE               
                      'MASTER'.                                         
           05  WS-SEC-RATE-EF          PIC X(12)    VALUE               
                      'SECURED RATE'.                                   
           05  WS-ACT-SURETY-EF        PIC X(11)    VALUE               
                      'SURETY BOND'.                                    
           05  WS-ACT-IRLOC-EF         PIC X(05)    VALUE               
                      'IRLOC'.                                          
           05  WS-WO-ARRANG-EF         PIC X(15)    VALUE               
                      'WO ARRANGEMENTS'.                                
           05  WS-MULTI-ACCT2-EF.                                       
               10  FILLER              PIC X(09)    VALUE               
                      'MULTIPLE '.                                      
               10  FILLER              PIC X        VALUE QUOTE.        
               10  FILLER              PIC X(02)    VALUE 'TO'.         
               10  FILLER              PIC X        VALUE QUOTE.        
               10  FILLER              PIC X(09)    VALUE               
                      ' ACCOUNTS'.                                      
      *                                                                         
      ***************** PCSRP032 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(01)    VALUE '-'.          
               10  P-RPT1-TITLE-FORM   PIC X(08).                       
               10  FILLER              PIC X(96)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(10).                       
               10  FILLER              PIC X(24)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(51).                       
               10  FILLER              PIC X(22)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(40)    VALUE SPACES.       
               10  P-RPT1-HEAD2        PIC X(50).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(01)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER              PIC X(57)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(26).                       
               10  FILLER              PIC X(49)    VALUE SPACES.       
                                                                        
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR LOCAL OFFICE HEADER       **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-31.                                       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE               
                                                   'LOCAL OFFICE'.      
               10  FILLER              PIC X(111)   VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-33.                                       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                 'ACCOUNT NUMBER    '.                  
               10  FILLER              PIC X(07)    VALUE ' DAY   '.    
               10  FILLER              PIC X(13)    VALUE               
                                 'CUSTOMER NAME'.                       
               10  FILLER              PIC X(85)    VALUE SPACES.       
                                                                        
           05  WS-RPT1-HEADER-34.                                       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                    'CUSTOMER NUMBER   '.               
               10  FILLER              PIC X(07)    VALUE 'CREDIT '.    
               10  FILLER              PIC X(13)    VALUE               
                                    'CUSTOMER SSN '.                    
               10  FILLER              PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE               
                                    'BALANCE'.                          
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE               
                                    'EXCEPTIONS'.                       
               10  FILLER              PIC X(30)    VALUE SPACES.       
                                                                        
           05  WS-RPT1-HEADER-35.                                       
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                    'ACCOUNT TYPE      '.               
               10  FILLER              PIC X(07)    VALUE 'ACTION '.    
               10  FILLER              PIC X(13)    VALUE               
                                    'CUSTOMER TYPE'.                    
               10  FILLER              PIC X(85)    VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-HEADER-1.                                        
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE               
                                    'SUMMARY:'.                         
               10  FILLER              PIC X(115)   VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-HEADER-2.                                        
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                    'TRANSFER TO'.                      
               10  FILLER              PIC X(83)    VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-HEADER-3.                                        
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(17)    VALUE               
                                    'DAY CREDIT ACTION'.                
               10  FILLER              PIC X(105)   VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-LINES.                                             
      *                                                                         
           05  WS-FROM-DETAIL-LINE-1.                                   
               10  FILLER              PIC X(09)    VALUE 'FROM:    '.  
               10  P-FROM-ACCOUNT-NO   PIC X(13).                       
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  P-DAY-CRED-ACTION   PIC X(03).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-FROM-NAME         PIC X(35).                       
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  P-FROM-TOT-AR-BAL   PIC ZZZ,ZZZ,ZZ9.99.              
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-EXCEPTION-1       PIC X(40)    VALUE SPACES.       
      *                                                                         
           05  WS-FROM-DETAIL-LINE-2.                                   
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-FROM-CUSTOMER-NO  PIC X(10).                       
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  P-FROM-SSN          PIC X(11)    VALUE SPACES.       
               10  FILLER              PIC X(47)    VALUE SPACES.       
               10  P-EXCEPTION-2       PIC X(40)    VALUE SPACES.       
                                                                        
           05  WS-FROM-DETAIL-LINE-3.                                   
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-FROM-ACCT-TYPE    PIC X(15).                       
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  P-FROM-CUST-TYPE    PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  P-EXCEPTION-3       PIC X(40)    VALUE SPACES.       
                                                                        
           05  WS-FROM-DETAIL-LINE-4.                                   
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-FROM-LOC-OFFICE   PIC X(03).                       
               10  FILLER              PIC X(80)    VALUE SPACES.       
XXXXXX         10  P-FROM-EXCEPTION-DL PIC X(40).                       
                                                                        
           05  WS-TO-DETAIL-LINE-1.                                     
               10  FILLER              PIC X(09)    VALUE 'TO:      '.  
               10  P-TO-ACCOUNT-NO     PIC X(13).                       
               10  FILLER              PIC X(12)    VALUE SPACES.       
               10  P-TO-NAME           PIC X(35).                       
               10  FILLER              PIC X(23)    VALUE SPACES.       
               10  P-EXCEPTION-7       PIC X(40)    VALUE SPACES.       
      *                                                                         
           05  WS-TO-DETAIL-LINE-2.                                     
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-TO-CUSTOMER-NO    PIC X(10).                       
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  P-TO-SSN            PIC X(11)    VALUE SPACES.       
               10  FILLER              PIC X(47)    VALUE SPACES.       
               10  P-EXCEPTION-8       PIC X(40)    VALUE SPACES.       
                                                                        
           05  WS-TO-DETAIL-LINE-3.                                     
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-TO-ACCT-TYPE      PIC X(15).                       
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  P-TO-CUST-TYPE      PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  P-EXCEPTION-9       PIC X(40)    VALUE SPACES.       
                                                                        
           05  WS-TO-DETAIL-LINE-4.                                     
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  P-TO-LOC-OFFICE     PIC X(03).                       
               10  FILLER              PIC X(80)    VALUE SPACES.       
               10  P-TO-EXCEPTION-DL   PIC X(40).                       
                                                                        
           05  WS-SEPARATOR-LINES.                                      
               10  WS-SL-1             PIC X(06)    VALUE ALL '-'.      
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  WS-SL-2             PIC X(15)    VALUE ALL '-'.      
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  WS-SL-3             PIC X(08)    VALUE ALL '-'.      
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  WS-SL-4             PIC X(35)    VALUE ALL '-'.      
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  WS-SL-5             PIC X(58)    VALUE ALL '-'.      
      *                                                                         
           05  WS-GRAND-TOT-HEADER.                                     
               10  FILLER              PIC X(74)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'TOTAL'.      
               10  FILLER              PIC X(53)    VALUE SPACES.       
      *                                                                         
           05  WS-GRAND-TOTAL-LINE.                                     
               10  FILLER              PIC X(73)    VALUE SPACES.       
               10  G-TOT-AR-BAL        PIC Z,ZZZ,ZZZ,ZZ9.99.            
               10  FILLER              PIC X(43)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       WORKING STORAGE FOR SUMMARY REPORT DETAIL LINES      **          
      ****************************************************************          
      *                                                                         
           05  WS-SUMM-DETAIL-1.                                        
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                    ' 35  DAY CREDIT'.                  
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  S-35-DAY-COUNT      PIC ZZ9.                         
               10  FILLER              PIC X(100)   VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-DETAIL-2.                                        
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                    ' 55  DAY CREDIT'.                  
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  S-55-DAY-COUNT      PIC ZZ9.                         
               10  FILLER              PIC X(100)   VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-DETAIL-3.                                        
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                    ' 65  DAY CREDIT'.                  
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  S-65-DAY-COUNT      PIC ZZ9.                         
               10  FILLER              PIC X(100)   VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-DETAIL-4.                                        
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                    ' 115 DAY CREDIT'.                  
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  S-115-DAY-COUNT     PIC ZZ9.                         
               10  FILLER              PIC X(100)   VALUE SPACES.       
      *                                                                         
           05  WS-SUMM-DETAIL-5.                                        
               10  FILLER              PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(16)    VALUE               
                                    'TOTAL TRANSFERS '.                 
               10  S-TOT-TRANSFER      PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(99)    VALUE SPACES.       
                                                                        
      *                                                                         
       01  WS-LINE.                                                     
           05  WS-LINE-1-131           PIC X(131)   VALUE ALL '-'.      
           05  WS-LINE-132-132         PIC X(01)    VALUE ALL ' '.      
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSRP032 ENDS HERE'.                    
       LINKAGE SECTION.                                                 
       01  REPORT-PARM.                                                 
           05  PARMLEN                 PIC 9(03)  USAGE COMP.           
           05  REPORT-PARM-TYPE        PIC X(07).                       
           05  REPORT-PARM-FORM1.                                       
               10  REPORT-PARM-FILLER1 PIC X(03).                       
               10  REPORT-PARM-FORM    PIC X(08).                       
               10  REPORT-PARM-FILLER2 PIC X(01).                       
                                                                        
                                                                        
      *                                                                         
       PROCEDURE DIVISION USING REPORT-PARM.                            
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   0000-MAINLINE                                           **           
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM         **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-BEGIN-REC        THRU 1000-EXIT.        
           PERFORM 7100-READ-FCSRP032            THRU 7100-EXIT.        
           PERFORM 1100-PRODUCE-REPORTS          THRU 1100-EXIT         
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
XXXXXX     IF WS-FRP032-REC-CNTR EQUAL ZERO                             
      *        MOVE '01'                   TO E-FRP032-COMPANY-NO               
               MOVE E-FRP032-COMPANY-NO    TO C7-COMPANY-NO             
                                              B1-COMPANY-NO             
               PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT             
               PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT             
               PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT             
               PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT             
               MOVE WS-NO-DATA-LINE   TO   PRT33-DATA                   
               MOVE WS-NO-DATA-LINE   TO   PRT331-DATA                  
XXXXXX*        IF E-FRP032-COMPANY-NO = '01'                                    
                  WRITE PRT33-RECORD                                    
                       AFTER ADVANCING 3 LINES                          
      *        ELSE                                                             
XXXXXX*           IF E-FRP032-COMPANY-NO = '26'                                 
                     WRITE PRT331-RECORD                                
                          AFTER ADVANCING 3 LINES                       
      *           END-IF                                                        
      *        END-IF                                                           
           ELSE                                                         
               IF WS-RPT1-LINE-NO GREATER THAN WS-68                    
                   MOVE '01'           TO  C7-COMPANY-NO                
                   PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT         
                   PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT         
                   PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT         
                   PERFORM 8300-PRINT-HEADERS    THRU 8300-EXIT         
               END-IF                                                   
               IF WS-RPT2-LINE-NO GREATER THAN WS-68                    
                   MOVE '26'           TO  C7-COMPANY-NO                
                   PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT         
                   PERFORM 8150-PRINT-COMP-NAME  THRU 8150-EXIT         
                   PERFORM 8250-PRINT-TITLE      THRU 8250-EXIT         
                   PERFORM 8350-PRINT-HEADERS    THRU 8350-EXIT         
               END-IF                                                   
               PERFORM 8500-PRINT-GRAND-TOTAL      THRU 8500-EXIT       
               PERFORM 8550-PRINT-GRAND-TOTAL      THRU 8550-EXIT       
               PERFORM 8400-PRINT-SUMMARY-REPORT   THRU 8400-EXIT       
               PERFORM 8450-PRINT-SUMMARY-REPORT   THRU 8450-EXIT       
               MOVE WS-END-DATA-LINE   TO  PRT33-DATA                   
               WRITE PRT33-RECORD                                       
                    AFTER ADVANCING 3 LINES                             
               MOVE WS-END-DATA-LINE   TO  PRT331-DATA                  
               WRITE PRT331-RECORD                                      
                    AFTER ADVANCING 3 LINES                             
           END-IF.                                                      
                                                                        
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSRP032 PROCESSING ERROR       **'    
               DISPLAY '** DID NOT HAVE AN ENDING CONTROL RECORD **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           DISPLAY 'RECORD COUNT==> ' WS-FRP032-REC-CNTR                
           DISPLAY 'SCEG GRAND TOTAL==> ' WS-01-GRAND-TOTAL             
           DISPLAY 'PSNC GRAND TOTAL==> ' WS-26-GRAND-TOTAL             
                                                                        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   0100-INITIALIZATION                                     **           
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES       **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       0100-INITIALIZATION.                                             
XXXXXX     MOVE SPACES                 TO EXCEPTIONS.                   
      *                                                                         
           MOVE '0100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
           OPEN INPUT FCSRP032-FILE.                                    
           IF FRP032-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       FCSRP032 PROCESSING ERROR       **'    
               DISPLAY '**  OPEN ERROR OF FCSRP032 - INPUT FILE  **'    
               DISPLAY '**    FILE STATUS = ' WS-FRP032-STATUS          
               DISPLAY '   **'                                          
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   1000-PROCESS-BEGIN-REC                                  **           
      **       CHECKS FOR THE BEGINNING OF THE FILE FCSRP032       **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7100-READ-FCSRP032            THRU 7100-EXIT.        
      *                                                                         
           IF E-FRP032-KEY-BREC EQUAL LOW-VALUES                        
               SUBTRACT 1 FROM WS-FRP032-REC-CNTR                       
               MOVE E-FRP032-CREATE-DATE-BREC                           
                                       TO WS-DATE-10                    
               MOVE WS-D10-MM          TO WS-MDY-MM                     
               MOVE WS-D10-DD          TO WS-MDY-DD                     
               MOVE WS-D10-YY          TO WS-MDY-YY                     
               MOVE WS-D10-CC          TO WS-MDY-CC                     
               MOVE WS-DATE-MDY        TO P-RPT1-DATE                   
               MOVE WS-DATE-MDY        TO WS-DEFAULT-RPT1-TITLE2-DT     
           ELSE                                                         
               DISPLAY '**       FCSRP032 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      **                                                           **           
      **   1100-PRODUCE-REPORTS                                    **           
      **       CONTROLS THE REPORT FORMAT WITH CONTROL BREAKS      **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
XXXXXX*    IF E-FRP032-MATCH-CODE EQUAL 'Y'                                     
      *       IF E-FRP032-KEY-EREC    EQUAL HIGH-VALUES                         
      *           PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT              
      *       END-IF                                                            
      *       CONTINUE                                                          
      *    ELSE                                                                 
           IF END-REC-WAS-PROCESSED                                     
               DISPLAY '**      FCSRP032 PROCESSING ERROR      **'      
               DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'      
               DISPLAY '**        PROCESSING TERMINATED        **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           ELSE                                                         
              IF E-FRP032-KEY-EREC    EQUAL HIGH-VALUES                 
                  PERFORM 1900-PROCESS-END-REC      THRU 1900-EXIT      
              ELSE                                                      
                  IF REPORT-IS-NOT-STARTED                              
                     MOVE WS-Y       TO WS-START-REPORT                 
                     MOVE E-FRP032-COMPANY-NO                           
                                     TO WS-COMPANY-NO                   
                                        C7-COMPANY-NO                   
                                        B1-COMPANY-NO                   
XXXXXX               IF E-FRP032-MATCH-CODE = 'N'                       
                        PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT    
                        PERFORM 7810-COMPUTE-TOTAL    THRU 7810-EXIT    
                        PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT    
XXXXXX               ELSE                                               
XXXXXX                  CONTINUE                                        
XXXXXX               END-IF                                             
                  ELSE                                                  
XXXXXX               IF E-FRP032-MATCH-CODE = 'N'                       
                        PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT    
                        PERFORM 7810-COMPUTE-TOTAL    THRU 7810-EXIT    
                        PERFORM 2200-PRODUCE-RPT      THRU 2200-EXIT    
XXXXXX               ELSE                                               
XXXXXX                  CONTINUE                                        
XXXXXX               END-IF                                             
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
      *    END-IF.                                                              
      *                                                                         
           PERFORM 7100-READ-FCSRP032            THRU 7100-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  1500-CHECK-EXCEPTIONS                                    **           
      **       CHECKS THE EXCEPTION CODE FOR EACH RECORD AND       **           
      **       WRITE THE CORRECT VERBIAGE TO THE REPORT.           **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       1500-CHECK-EXCEPTIONS.                                           
      *                                                                         
           EVALUATE E-FRP032-EXCPTION-CODE                              
              WHEN '01'    MOVE WS-EC01    TO   WS-EXCEPTIONS (1)       
              WHEN '02'    MOVE WS-EC02    TO   WS-EXCEPTIONS (1)       
              WHEN '03'    MOVE WS-EC03    TO   WS-EXCEPTIONS (1)       
              WHEN '04'    MOVE WS-EC04    TO   WS-EXCEPTIONS (1)       
              WHEN '05'    MOVE WS-EC05    TO   WS-EXCEPTIONS (1)       
              WHEN '06'    MOVE WS-EC06    TO   WS-EXCEPTIONS (1)       
              WHEN '07'    MOVE WS-EC07    TO   WS-EXCEPTIONS (1)       
              WHEN '08'    MOVE WS-EC08    TO   WS-EXCEPTIONS (1)       
              WHEN '09'    MOVE WS-EC09    TO   WS-EXCEPTIONS (1)       
              WHEN '10'    MOVE WS-EC10    TO   WS-EXCEPTIONS (1)       
              WHEN '11'    MOVE WS-EC11    TO   WS-EXCEPTIONS (1)       
              WHEN '12'    MOVE WS-EC12    TO   WS-EXCEPTIONS (1)       
              WHEN '13'    MOVE WS-EC13    TO   WS-EXCEPTIONS (1)       
              WHEN OTHER                                                
                 PERFORM 1600-CHECK-EXCEPTIONS-FLAG   THRU 1600-EXIT    
           END-EVALUATE.                                                
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  1600-CHECK-EXCEPTIONS-FLAG                               **           
      **                                                           **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       1600-CHECK-EXCEPTIONS-FLAG.                                      
      *                                                                         
           IF E-FRP032-EXCPTION-CODE = '99'                             
              IF E-FRP032-BANKRUPT-EITHER-FLAG = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-BANKRUPT-EF       TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-ACT-IRLOC-EITHER-FL = 'Y'                     
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-ACT-IRLOC-EF      TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-JUDGMENT-EITHER-FLAG = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-JUDGMENT-EF       TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-MAJ-ACCT-EITHER-FLAG = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-MAJ-ACCT-EF       TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-MSTR-ACCT-EITHER-FLAG = 'Y'                   
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-MSTR-ACCT-EF      TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-MULTI-ACCT2-FLAG = 'Y'                        
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-MULTI-ACCT2-EF    TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-PEND-DNPFB-ACCT2-FLAG = 'Y'                   
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-PEND-DNPFB-EF     TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-SEC-RATE-EITHER-FLAG = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-SEC-RATE-EF       TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-ACT-SURETY-EITHER-FL = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-ACT-SURETY-EF     TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-WO-ARRANG-ACCT1-FLAG = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-WO-ARRANG-EF      TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
              IF E-FRP032-XFER-XEMPT-EITHER-FL = 'Y'                    
                 ADD 1                     TO   WS-SUB                  
                 MOVE WS-XFER-XEMPT-EF     TO   WS-EXCEPTIONS (WS-SUB)  
              END-IF                                                    
                                                                        
              MOVE ZEROES                  TO   WS-SUB                  
           END-IF.                                                      
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  1900-PROCESS-END-REC                                     **           
      **       IT STOPS THE PROCESSING OF ALL RECORDS              **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FRP032-REC-CNTR.                          
      *                                                                         
           IF WS-FRP032-REC-CNTR EQUAL E-FRP032-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         FCSRP032 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FRP032-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FRP032-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  2200-PRODUCE-RPT                                         **           
      **      CONTROLS THE REPORT FORMAT WITH PAGE BREAKS          **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN WS-65                        
              IF E-FRP032-COMPANY-NO = '01'                             
                 PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT       
                 PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT       
                 PERFORM 8300-PRINT-HEADERS        THRU 8300-EXIT       
              END-IF                                                    
           END-IF                                                       
           IF WS-RPT2-LINE-NO GREATER THAN WS-65                        
              IF E-FRP032-COMPANY-NO = '26'                             
                 PERFORM 8150-PRINT-COMP-NAME      THRU 8150-EXIT       
                 PERFORM 8250-PRINT-TITLE          THRU 8250-EXIT       
                 PERFORM 8350-PRINT-HEADERS        THRU 8350-EXIT       
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           PERFORM 2300-FORMAT-DETAIL-LINE          THRU 2300-EXIT.     
           IF E-FRP032-COMPANY-NO = '01'                                
              PERFORM 8900-PRINT-DETAIL-LINE        THRU 8900-EXIT      
           ELSE                                                         
              IF E-FRP032-COMPANY-NO = '26'                             
                 PERFORM 8950-PRINT-DETAIL-LINE     THRU 8950-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FRP032-FROM-ACCOUNT-NO    TO P-FROM-ACCOUNT-NO.       
           MOVE E-FRP032-FROM-NAME          TO P-FROM-NAME.             
           MOVE E-FRP032-FROM-TOTAL-AR-BAL  TO P-FROM-TOT-AR-BAL.       
           MOVE E-FRP032-FROM-TOTAL-AR-BAL  TO WS-TOTAL.                
           MOVE E-FRP032-FROM-CUSTOMER-NO   TO P-FROM-CUSTOMER-NO.      
           IF E-FRP032-FROM-SSN NOT EQUAL TO ' '                        
              MOVE E-FRP032-FROM-SSN           TO WS-SSN                
C34788        IF WS-SSN-2 = 'FR'                                        
C34788            MOVE WS-SSN-1                    TO WS-SSN-FR1        
C34788            MOVE WS-SSN-2                    TO WS-SSN-FR2        
C34788        ELSE                                                      
C34788            MOVE '***'                       TO WS-SSN-FR1        
C34788            MOVE '**'                        TO WS-SSN-FR2        
C34788        END-IF                                                    
              MOVE WS-SSN-3                    TO WS-SSN-FR3            
              MOVE WS-FORMAT-SSN               TO P-FROM-SSN            
           ELSE                                                         
              MOVE E-FRP032-FROM-SSN           TO P-FROM-SSN            
           END-IF                                                       
           MOVE E-FRP032-FROM-ACCT-TYPE     TO WS-ACCT-TYPE.            
      *                                                                         
           EVALUATE WS-ACCT-TYPE                                        
              WHEN 'C'                                                  
                 MOVE 'COMMERCIAL'         TO  P-FROM-ACCT-TYPE         
              WHEN 'I'                                                  
                 MOVE 'INDUSTRIAL'         TO  P-FROM-ACCT-TYPE         
              WHEN 'R'                                                  
                 MOVE 'RESIDENTIAL'        TO  P-FROM-ACCT-TYPE         
              WHEN 'D'                                                  
                 MOVE 'COMPANY USAGE'      TO  P-FROM-ACCT-TYPE         
              WHEN 'M'                                                  
                 MOVE 'PUB/ST LIGHTING'    TO  P-FROM-ACCT-TYPE         
              WHEN 'W'                                                  
                 MOVE 'WHOLESALE'          TO  P-FROM-ACCT-TYPE         
              WHEN OTHER                                                
                 MOVE SPACES               TO  P-FROM-ACCT-TYPE         
           END-EVALUATE                                                 
      *                                                                         
           MOVE E-FRP032-FROM-CUST-TYPE     TO WS-CUST-TYPE.            
      *                                                                         
           EVALUATE WS-CUST-TYPE                                        
              WHEN 'R'                                                  
                 MOVE 'ROOMMATE'           TO  P-FROM-CUST-TYPE         
              WHEN 'C'                                                  
                 MOVE 'CUSTOMER'           TO  P-FROM-CUST-TYPE         
              WHEN 'S'                                                  
                 MOVE 'SPOUSE'             TO  P-FROM-CUST-TYPE         
              WHEN OTHER                                                
                 MOVE SPACES               TO  P-FROM-CUST-TYPE         
           END-EVALUATE                                                 
      *                                                                         
           MOVE E-FRP032-TO-ACCOUNT-NO      TO P-TO-ACCOUNT-NO.         
           MOVE E-FRP032-TO-NAME            TO P-TO-NAME.               
           MOVE E-FRP032-TO-CUSTOMER-NO     TO P-TO-CUSTOMER-NO.        
           IF E-FRP032-TO-SSN NOT EQUAL TO ' '                          
              MOVE E-FRP032-TO-SSN             TO WS-SSN                
C34788        MOVE '***'                       TO WS-SSN-FR1            
C34788        MOVE '**'                        TO WS-SSN-FR2            
              MOVE WS-SSN-3                    TO WS-SSN-FR3            
              MOVE WS-FORMAT-SSN               TO P-TO-SSN              
           ELSE                                                         
              MOVE E-FRP032-TO-SSN             TO P-TO-SSN              
           END-IF                                                       
           MOVE E-FRP032-TO-ACCT-TYPE       TO WS-ACCT-TYPE.            
      *                                                                         
           EVALUATE WS-ACCT-TYPE                                        
              WHEN 'C'                                                  
                 MOVE 'COMMERCIAL'         TO  P-TO-ACCT-TYPE           
              WHEN 'I'                                                  
                 MOVE 'INDUSTRIAL'         TO  P-TO-ACCT-TYPE           
              WHEN 'R'                                                  
                 MOVE 'RESIDENTIAL'        TO  P-TO-ACCT-TYPE           
              WHEN 'D'                                                  
                 MOVE 'COMPANY USAGE'      TO  P-TO-ACCT-TYPE           
              WHEN 'M'                                                  
                 MOVE 'PUB/ST LIGHTING'    TO  P-TO-ACCT-TYPE           
              WHEN 'W'                                                  
                 MOVE 'WHOLESALE'          TO  P-TO-ACCT-TYPE           
              WHEN OTHER                                                
                 MOVE SPACES               TO  P-TO-ACCT-TYPE           
           END-EVALUATE                                                 
      *                                                                         
           MOVE E-FRP032-TO-CUST-TYPE       TO WS-CUST-TYPE.            
      *                                                                         
           EVALUATE WS-CUST-TYPE                                        
              WHEN 'R'                                                  
                 MOVE 'ROOMMATE'           TO  P-TO-CUST-TYPE           
              WHEN 'C'                                                  
                 MOVE 'CUSTOMER'           TO  P-TO-CUST-TYPE           
              WHEN 'S'                                                  
                 MOVE 'SPOUSE'             TO  P-TO-CUST-TYPE           
              WHEN OTHER                                                
                 MOVE SPACES               TO  P-TO-CUST-TYPE           
           END-EVALUATE                                                 
      *                                                                         
           MOVE E-FRP032-LOCAL-OFFICE-ACCT1    TO P-FROM-LOC-OFFICE.    
           MOVE E-FRP032-LOCAL-OFFICE-ACCT2    TO P-TO-LOC-OFFICE.      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  7100-READ-FCSRP032                                       **           
      **       READS THE INPUT FILE FCSRP032-FILE                  **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7100-READ-FCSRP032.                                              
           READ FCSRP032-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FRP032-SUCCESSFUL                                         
               ADD 1                      TO WS-FRP032-REC-CNTR         
               MOVE E-FRP032-COMPANY-NO   TO C7-COMPANY-NO              
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSRP032 READ.  STATUS IS '       
                        WS-FRP032-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  7300-GET-CUST-TYPE                                       **           
      **       GETS CUSTOMER TYPE DESCRIPTION                      **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       7300-GET-CUST-TYPE.                                              
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 7800-GET-COMPANY-DESC                                      **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7800-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT   COMPANY_NAME                                    
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY                                         
               WHERE    COMPANY_NO = :C7-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME              
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO P-RPT1-COMP-NAME              
               ELSE                                                     
                   DISPLAY '* SELECT ERROR IN 7800-GET-COMPANY-DESC *'  
                   DISPLAY '*         RETURN CODE = ' SQLCODE           
                   DISPLAY '*         PROCESSING TERMINATED         *'  
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 7810-COMPUTE-TOTAL                                         **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7810-COMPUTE-TOTAL.                                              
      *                                                                         
           MOVE '7810' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF E-FRP032-COMPANY-NO = '01'                                
              ADD WS-TOTAL                   TO  WS-01-GRAND-TOTAL      
              PERFORM 7900-GET-SUMMARY-DATA     THRU 7900-EXIT          
           ELSE                                                         
              IF E-FRP032-COMPANY-NO = '26'                             
              ADD WS-TOTAL                   TO  WS-26-GRAND-TOTAL      
                 PERFORM 7950-GET-SUMMARY-DATA     THRU 7950-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 7900-GET-SUMMARY-DATA                                      **          
      **      GET DATA FOR THE SUMMARY REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7900-GET-SUMMARY-DATA.                                           
      *                                                                         
           MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP032-OUTPUT-ID            TO  WS-OUTPUT-ID.         
           MOVE E-FRP032-TO-CREDIT-GRP        TO  WS-CREDIT-GRP.        
           MOVE E-FRP032-FROM-TOTAL-AR-BAL    TO  WS-TOT-AR-BAL.        
      *                                                                         
           EVALUATE WS-OUTPUT-ID                                        
              WHEN 'FA08'    ADD 1            TO  WS-35-DAY-CT01        
                   MOVE '035'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA09'    ADD 1            TO  WS-55-DAY-CT01        
                   MOVE '055'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA10'    ADD 1            TO  WS-65-DAY-CT01        
                   MOVE '065'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA11'    ADD 1            TO  WS-115-DAY-CT01       
                   MOVE '115'                 TO  P-DAY-CRED-ACTION     
              WHEN OTHER                                                
                   MOVE SPACES                TO  P-DAY-CRED-ACTION     
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
           EVALUATE WS-CREDIT-GRP                                       
              WHEN 'N'                                                  
                 ADD 1                        TO  WS-NEW-CREDIT-GRP-01  
                 ADD WS-TOT-AR-BAL            TO  WS-NEW-XFER-AMT-01    
              WHEN 'A'                                                  
                 ADD 1                        TO  WS-ARR-CREDIT-GRP-01  
                 ADD WS-TOT-AR-BAL            TO  WS-ARR-XFER-AMT-01    
              WHEN 'B'                                                  
                 ADD 1                        TO  WS-BAL-CREDIT-GRP-01  
                 ADD WS-TOT-AR-BAL            TO  WS-BAL-XFER-AMT-01    
              WHEN 'C'                                                  
                 ADD 1                        TO  WS-EXPT-CREDIT-GRP-01 
                 ADD WS-TOT-AR-BAL            TO  WS-EXPT-XFER-AMT-01   
              WHEN OTHER  CONTINUE                                      
           END-EVALUATE.                                                
                                                                        
                                                                        
                                                                        
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      ** 7950-GET-SUMMARY-DATA                                      **          
      **      GET DATA FOR THE SUMMARY REPORT (PSNC)                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7950-GET-SUMMARY-DATA.                                           
      *                                                                         
           MOVE '7950' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           MOVE E-FRP032-OUTPUT-ID            TO  WS-OUTPUT-ID.         
           MOVE E-FRP032-TO-CREDIT-GRP        TO  WS-CREDIT-GRP.        
           MOVE E-FRP032-FROM-TOTAL-AR-BAL    TO  WS-TOT-AR-BAL.        
      *                                                                         
           EVALUATE WS-OUTPUT-ID                                        
              WHEN 'FA08'    ADD 1            TO  WS-35-DAY-CT26        
                   MOVE '035'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA09'    ADD 1            TO  WS-55-DAY-CT26        
                   MOVE '055'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA10'    ADD 1            TO  WS-65-DAY-CT26        
                   MOVE '065'                 TO  P-DAY-CRED-ACTION     
              WHEN 'FA11'    ADD 1            TO  WS-115-DAY-CT26       
                   MOVE '115'                 TO  P-DAY-CRED-ACTION     
              WHEN OTHER                                                
                   MOVE SPACES                TO  P-DAY-CRED-ACTION     
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE WS-CREDIT-GRP                                       
              WHEN 'N'                                                  
                 ADD 1                        TO  WS-NEW-CREDIT-GRP-26  
                 ADD WS-TOT-AR-BAL            TO  WS-NEW-XFER-AMT-26    
              WHEN 'A'                                                  
                 ADD 1                        TO  WS-ARR-CREDIT-GRP-26  
                 ADD WS-TOT-AR-BAL            TO  WS-ARR-XFER-AMT-26    
              WHEN 'B'                                                  
                 ADD 1                        TO  WS-BAL-CREDIT-GRP-26  
                 ADD WS-TOT-AR-BAL            TO  WS-BAL-XFER-AMT-26    
              WHEN 'C'                                                  
                 ADD 1                        TO  WS-EXPT-CREDIT-GRP-26 
                 ADD WS-TOT-AR-BAL            TO  WS-EXPT-XFER-AMT-26   
              WHEN OTHER  CONTINUE                                      
           END-EVALUATE.                                                
                                                                        
                                                                        
                                                                        
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8100-PRINT-COMP-NAME                                    **           
      **       PRINTS THE COMPANY NAME FOR THE REPORT              **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           MOVE 'PCSR0321'             TO P-RPT1-TITLE-FORM.            
      *    MOVE REPORT-PARM-FORM       TO P-RPT1-TITLE-FORM.                    
      *                                                                         
           MOVE WS-RPT1-TITLE   TO   PRT33-DATA                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8150-PRINT-COMP-NAME                                    **           
      **       PRINTS THE COMPANY NAME FOR THE REPORT (PSNC)       **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8150-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT2-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
           MOVE 'PCSR0322'             TO P-RPT1-TITLE-FORM.            
      *    MOVE REPORT-PARM-FORM       TO P-RPT1-TITLE-FORM.                    
      *                                                                         
           MOVE WS-RPT1-TITLE   TO   PRT331-DATA                        
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8200-PRINT-TITLE                                        **           
      **       PRINTS THE TITLE-HEADER OF THE REPORT               **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1A TO P-RPT1-HEAD1.                
      *                                                                         
           MOVE WS-RPT1-HEADER-1 TO  PRT33-DATA                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1B TO P-RPT1-HEAD2.                
           MOVE WS-RPT1-PAGE-NO         TO P-RPT1-PAGE-NO.              
           MOVE WS-RPT1-HEADER-2 TO  PRT33-DATA                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-RPT1-HEADER-3 TO  PRT33-DATA                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8250-PRINT-TITLE                                        **           
      **       PRINTS THE TITLE-HEADER OF THE REPORT (PSNC)        **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8250-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1A TO P-RPT1-HEAD1.                
      *                                                                         
           MOVE WS-RPT1-HEADER-1 TO  PRT331-DATA.                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1B TO P-RPT1-HEAD2.                
           MOVE WS-RPT2-PAGE-NO         TO P-RPT1-PAGE-NO.              
           MOVE WS-RPT1-HEADER-2 TO  PRT331-DATA                        
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-RPT1-HEADER-3 TO  PRT331-DATA                        
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 6                      TO WS-RPT2-LINE-NO.              
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8300-PRINT-HEADERS                                      **           
      **       PRINTS THE HEADERS FOR THE REPORT                   **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
           MOVE WS-RPT1-HEADER-33 TO  PRT33-DATA                        
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINE.                                 
           MOVE WS-RPT1-HEADER-34 TO  PRT33-DATA                        
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-RPT1-HEADER-35 TO  PRT33-DATA                        
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE SPACES            TO  PRT33-DATA                        
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 2 LINE.                                 
      *                                                                         
           ADD 13                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8350-PRINT-HEADERS                                      **           
      **       PRINTS THE HEADERS FOR THE REPORT (PSNC)            **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8350-PRINT-HEADERS.                                              
      *                                                                         
           MOVE WS-RPT1-HEADER-33 TO  PRT331-DATA                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 4 LINE.                                 
           MOVE WS-RPT1-HEADER-34 TO  PRT331-DATA                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-RPT1-HEADER-35 TO  PRT331-DATA                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-RPT1-HEADER-31 TO  PRT331-DATA                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE SPACES            TO  PRT331-DATA                       
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 2 LINE.                                 
      *                                                                         
           ADD 16                      TO WS-RPT2-LINE-NO.              
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8400-PRINT-SUMMARY-REPORT                               **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8400-PRINT-SUMMARY-REPORT.                                       
      *                                                                         
           MOVE '01'                   TO  C7-COMPANY-NO.               
           PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT.                
           PERFORM 8100-PRINT-COMP-NAME  THRU 8100-EXIT.                
           PERFORM 8200-PRINT-TITLE      THRU 8200-EXIT.                
      *                                                                         
           MOVE WS-SUMM-HEADER-1       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINE.                                 
           MOVE WS-SUMM-HEADER-3       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 2 LINE.                                 
           MOVE WS-35-DAY-CT01         TO S-35-DAY-COUNT                
           MOVE WS-55-DAY-CT01         TO S-55-DAY-COUNT                
           MOVE WS-65-DAY-CT01         TO S-65-DAY-COUNT                
           MOVE WS-115-DAY-CT01        TO S-115-DAY-COUNT               
           MOVE WS-SUMM-DETAIL-1       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-2       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-3       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-4       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE SPACES                 TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           COMPUTE WS-TOT-TRANSFER = WS-35-DAY-CT01 + WS-55-DAY-CT01 +  
                                     WS-65-DAY-CT01 + WS-115-DAY-CT01.  
           MOVE WS-TOT-TRANSFER        TO  S-TOT-TRANSFER.              
           MOVE WS-SUMM-DETAIL-5       TO  PRT33-DATA.                  
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8450-PRINT-SUMMARY-REPORT                               **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8450-PRINT-SUMMARY-REPORT.                                       
      *                                                                         
           MOVE '26'                   TO  C7-COMPANY-NO.               
           PERFORM 7800-GET-COMPANY-DESC THRU 7800-EXIT.                
           PERFORM 8150-PRINT-COMP-NAME  THRU 8150-EXIT.                
           PERFORM 8250-PRINT-TITLE      THRU 8250-EXIT.                
      *                                                                         
           MOVE WS-SUMM-HEADER-1       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 3 LINE.                                 
           MOVE WS-SUMM-HEADER-3       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 2 LINE.                                 
           MOVE WS-35-DAY-CT26         TO S-35-DAY-COUNT                
           MOVE WS-55-DAY-CT26         TO S-55-DAY-COUNT                
           MOVE WS-65-DAY-CT26         TO S-65-DAY-COUNT                
           MOVE WS-115-DAY-CT26        TO S-115-DAY-COUNT               
           MOVE WS-SUMM-DETAIL-1       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-2       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-3       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-SUMM-DETAIL-4       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE SPACES                 TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           COMPUTE WS-TOT-TRANSFER = WS-35-DAY-CT26 + WS-55-DAY-CT26 +  
                                     WS-65-DAY-CT26 + WS-115-DAY-CT26.  
           MOVE WS-TOT-TRANSFER        TO  S-TOT-TRANSFER.              
           MOVE WS-SUMM-DETAIL-5       TO  PRT331-DATA.                 
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8500-PRINT-GRAND-TOTAL                                  **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8500-PRINT-GRAND-TOTAL.                                          
      *                                                                         
           MOVE WS-GRAND-TOT-HEADER    TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 2 LINES                                 
           MOVE WS-01-GRAND-TOTAL      TO  G-TOT-AR-BAL                 
           MOVE WS-GRAND-TOTAL-LINE    TO  PRT33-DATA                   
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINES.                                
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8550-PRINT-GRAND-TOTAL                                  **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8550-PRINT-GRAND-TOTAL.                                          
      *                                                                         
           MOVE WS-GRAND-TOT-HEADER    TO  PRT331-DATA                  
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 2 LINES                                 
           MOVE WS-26-GRAND-TOTAL      TO  G-TOT-AR-BAL                 
           MOVE WS-GRAND-TOTAL-LINE    TO  PRT331-DATA                  
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINES.                                
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8900-PRINT-DETAIL-LINE                                  **           
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP032       **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
           IF E-FRP032-COMPANY-NO = '01'                                
              PERFORM 1500-CHECK-EXCEPTIONS         THRU 1500-EXIT      
              MOVE WS-EXCEPTIONS (1)            TO  P-EXCEPTION-1       
              MOVE WS-FROM-DETAIL-LINE-1        TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (2)            TO  P-EXCEPTION-2       
              MOVE WS-FROM-DETAIL-LINE-2        TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (3)            TO  P-EXCEPTION-3       
              MOVE WS-FROM-DETAIL-LINE-3        TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (4)            TO  WS-EXCEPTION-4      
              MOVE P-EXCEPTION-4                TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (5)            TO  WS-EXCEPTION-5      
              MOVE P-EXCEPTION-5                TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (6)            TO  WS-EXCEPTION-6      
              MOVE P-EXCEPTION-6                TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (7)            TO  P-EXCEPTION-7       
              MOVE WS-TO-DETAIL-LINE-1          TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (8)            TO  P-EXCEPTION-8       
              MOVE WS-TO-DETAIL-LINE-2          TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (9)            TO  P-EXCEPTION-9       
              MOVE WS-TO-DETAIL-LINE-3          TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (10)           TO  WS-EXCEPTION-10     
              MOVE P-EXCEPTION-10               TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-EXCEPTIONS (11)           TO  WS-EXCEPTION-11     
              MOVE P-EXCEPTION-11               TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE WS-SEPARATOR-LINES           TO  PRT33-DATA          
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
              MOVE SPACES                       TO  EXCEPTIONS          
      *                                                                         
              ADD 15                      TO WS-RPT1-LINE-NO            
           ELSE                                                         
              IF E-FRP032-COMPANY-NO = '26'                             
                 PERFORM 8950-PRINT-DETAIL-LINE                         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **   8950-PRINT-DETAIL-LINE                                  **           
      **       PRINTS THE DETAIL LINE OF THE REPORT PCSRP032       **           
      **       (PSNC)                                              **           
      ***************************************************************           
      *                                                                         
       8950-PRINT-DETAIL-LINE.                                          
           PERFORM 1500-CHECK-EXCEPTIONS         THRU 1500-EXIT.        
           MOVE WS-EXCEPTIONS (1)            TO  P-EXCEPTION-1          
           MOVE WS-FROM-DETAIL-LINE-1        TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (2)            TO  P-EXCEPTION-2          
           MOVE WS-FROM-DETAIL-LINE-2        TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (3)            TO  P-EXCEPTION-3          
           MOVE WS-FROM-DETAIL-LINE-3        TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (4)            TO  P-FROM-EXCEPTION-DL    
           MOVE WS-FROM-DETAIL-LINE-4        TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (5)            TO  WS-EXCEPTION-5         
           MOVE P-EXCEPTION-5                TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (6)            TO  WS-EXCEPTION-6         
           MOVE P-EXCEPTION-6                TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE.                                 
           MOVE WS-EXCEPTIONS (7)            TO  P-EXCEPTION-7          
           MOVE WS-TO-DETAIL-LINE-1          TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (8)            TO  P-EXCEPTION-8          
           MOVE WS-TO-DETAIL-LINE-2          TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (9)            TO  P-EXCEPTION-9          
           MOVE WS-TO-DETAIL-LINE-3          TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-EXCEPTIONS (10)           TO  P-TO-EXCEPTION-DL      
           MOVE WS-TO-DETAIL-LINE-4          TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
      *    MOVE SPACES                       TO  PRT331-DATA                    
           MOVE WS-EXCEPTIONS (11)           TO  WS-EXCEPTION-11        
           MOVE P-EXCEPTION-11               TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
           MOVE WS-SEPARATOR-LINES           TO  PRT331-DATA            
           WRITE PRT331-RECORD                                          
                AFTER ADVANCING 1 LINE                                  
      *                                                                         
           MOVE SPACES                       TO  EXCEPTIONS             
                                                                        
      *                                                                         
           ADD 11                      TO WS-RPT2-LINE-NO.              
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **  9000-TERMINATE                                           **           
      **      CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP032-FILE.                                         
           IF FRP032-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSRP032 PROCESSING ERROR        **'  
               DISPLAY '**  CLOSE ERROR FOR FCSRP032 - INPUT FILE  **'  
               DISPLAY '**     FILE STATUS = ' WS-FRP032-STATUS         
               DISPLAY '    **'                                         
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
