       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP026.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     JAN 09, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      *** TO PRODUCE LIST OF ACCOUNTS WHICH IS HAVING EACH SERVICE   ***        
      *** ATTACHED TO DIFFERENT REVENUE CLASS.                       ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
      ***  07/29/2015    VV7M728     EZY TO COBOL CONVERSION         ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP026'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_PLAN                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP026'.     
      *                                                                         
       01 WS-RP026-OUT-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05 FILLER                    PIC X(14) VALUE SPACES.         
           05 OUT-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(17) VALUE SPACES.         
           05 OUT-REVENUE-CLASS         PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(17) VALUE SPACES.         
           05 OUT-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN1.                                         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN1-NAME              PIC X(09) VALUE 'CSR026-01'.    
           05 FILLER                    PIC X(35) VALUE SPACES.         
           05 HDR-LN1-COMPANY-NAME      PIC X(31)                       
                       VALUE 'SOUTH CAROLINA ELECTRIC AND GAS'.         
           05 FILLER                    PIC X(43) VALUE SPACES.         
           05 HDR-LN1-PAGE              PIC X(05) VALUE 'PAGE '.        
           05 HDR-LN1-PAGE-NO           PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN2.                                         
           05 FILLER                    PIC X(34) VALUE SPACES.         
           05 HDR-LN2-DETAIL            PIC X(32)                       
                        VALUE 'ACCOUNTS HAVING SERVICE ATTACHED'.       
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-DETAILS           PIC X(26)                       
                        VALUE 'TO DIFFERENT REVENUE CLASS'.             
           05 FILLER                    PIC X(19) VALUE SPACES.         
           05 HDR-LN2-RUN-DATE          PIC X(11) VALUE 'RUN DATE : '.  
           05 HDR-LN2-SYS-DATE          PIC X(10) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN3.                                         
           05 FILLER                    PIC X(112) VALUE SPACES.        
           05 HDR-LN3-RUN-DATE          PIC X(11) VALUE 'RUN TIME : '.  
           05 HDR-LN3-SYS-TIME          PIC X(08) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN4.                                         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN4-LOCAL-OFC         PIC X(14)                       
                        VALUE 'LOCAL OFFICE :'.                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN4-LOCAL-OFFICE      PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN4-LOCAL-OFFICE-DESC PIC X(22) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN5.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN5-DETAIL1           PIC X(18)                       
                        VALUE  '  ACCOUNT NO      '.                    
           05 HDR-LN5-DETAIL2           PIC X(20)                       
                        VALUE  ' CODE UTIL TYPE     '.                  
           05 HDR-LN5-DETAIL3           PIC X(20)                       
                        VALUE  ' REVENUE CLASS      '.                  
           05 HDR-LN5-DETAIL4           PIC X(13)                       
                        VALUE  ' RATE PLAN NO'.                         
           05 FILLER                    PIC X(61) VALUE SPACES.         
                                                                        
       01 WS-RP026-HDR-REC-LN6.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP026-FTR-REC-LN1.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP026-FTR-REC-LN2.                                         
           05 FILLER                    PIC X(34)  VALUE SPACES.        
           05 FTR-LN2-DETAILS           PIC X(21)                       
                    VALUE '*** END OF REPORT ***'.                      
           05 FILLER                    PIC X(78)  VALUE SPACES.        
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-PARM-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-DATA-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ACCT-IND               PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
                                                                        
       01  WS-CHANGE-SWITCH.                                            
           05  WS-VALUE-DIFFER          PIC X(01) VALUE 'N'.            
           05  WS-FIRST-VALUE           PIC X(01) VALUE 'Y'.            
           05  WS-BEGIN-VALUE           PIC X(01) VALUE 'N'.            
           05  WS-NO-DATA               PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-LOCAL-COUNT           PIC 9(04) VALUE ZEROS.          
           05  WS-TOTAL-COUNT           PIC 9(06) VALUE ZEROS.          
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
      *                                                                         
       01 WS-MISC.                                                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-PREV-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-ACCOUNT-NO-Z          PIC ZZZZZZZZZZZZ9.              
           05  WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
           05  WS-REVENUE-CLASS         PIC X(03) VALUE SPACES.         
           05  WS-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
           05  WS-LOCAL-OFFICE          PIC X(03) VALUE SPACES.         
           05  WS-LOC-OFF-DESC          PIC X(22) VALUE SPACES.         
           05  WS-PREV-LOC-OFF          PIC X(03) VALUE SPACES.         
           05  WS-CURRENT-DATE-USA      PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-TIME-USA      PIC X(08) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ' '.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-REPORT-DATE.                                              
           05  WS-RPT-MM                PIC 9(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RPT-CCYY              PIC 9(04).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
                                                                        
      *                                                                         
      ***************************************************************           
      *CURSOR FOR RETRIEVING ROWS FOR METERS IN THE INVENTORY       *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE REVENUE_CLASS CURSOR FOR                           
                SELECT UT.ACCOUNT_NO                                    
                      ,UT.CODE_UTIL_TYPE                                
                      ,AT.LOCAL_OFFICE                                  
                      ,UT.CODE_REVENUE_CLASS                            
                      ,UT.RATE_PLAN_NO                                  
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
                  WHERE AT.ACCOUNT_NO = UT.ACCOUNT_NO                   
                    AND AT.CODE_ACCT_STAT = 'A'                         
                    AND CIS.SUBSTR3(UT.CODE_REVENUE_CLASS,2,1)               
                      IN ('1','2','8','0')                              
                    AND AT.ACCOUNT_NO = MN.ACCOUNT_NO                   
                    AND MN.CODE_METER_STATUS = 'A'                      
                    AND UT.IC_NO = MN.IC_NO                             
                    AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE           
                    AND UT.ACCOUNT_NO IN                                
                    (SELECT U1.ACCOUNT_NO                               
                       FROM CSS_UTIL_ENVRNMT U1 WITH(READUNCOMMITTED)           
                      WHERE U1.ACCOUNT_NO = UT.ACCOUNT_NO               
                    AND CIS.SUBSTR3(U1.CODE_REVENUE_CLASS,2,1)               
                      IN ('1','2','8','0')                              
                      AND CIS.SUBSTR3(U1.CODE_REVENUE_CLASS,2,1) <>          
                            CIS.SUBSTR3(UT.CODE_REVENUE_CLASS,2,1)           
                      AND ( EXISTS ( SELECT 1                           
                            FROM CSS_MTRD_ENVRNMT M1
                           WITH(READUNCOMMITTED)                    
                            WHERE U1.ACCOUNT_NO = M1.ACCOUNT_NO         
                             AND U1.IC_NO = M1.IC_NO                    
                             AND U1.CODE_UTIL_TYPE = M1.CODE_UTIL_TYPE  
                             AND M1.CODE_METER_STATUS = 'A')            
                            OR EXISTS                                   
                            ( SELECT 1                                  
                            FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)         
                            WHERE CP.ACCOUNT_NO = U1.ACCOUNT_NO         
                            AND CP.IC_NO = U1.IC_NO                     
                            AND CP.CODE_PLAN_STATUS = 'A')))            
                    ORDER BY AT.LOCAL_OFFICE                            
                            ,UT.ACCOUNT_NO                              
                            ,UT.CODE_UTIL_TYPE                          
                    FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE REVENUE_CLASS CURSOR FOR                                   
MFA-TR*         SELECT UT.ACCOUNT_NO                                            
MFA-TR*               ,UT.CODE_UTIL_TYPE                                        
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,UT.CODE_REVENUE_CLASS                                    
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_MTRD_ENVRNMT MN                                      
MFA-TR*           WHERE AT.ACCOUNT_NO = UT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND SUBSTR(UT.CODE_REVENUE_CLASS,2,1)                       
MFA-TR*               IN ('1','2','8','0')                                      
MFA-TR*             AND AT.ACCOUNT_NO = MN.ACCOUNT_NO                           
MFA-TR*             AND MN.CODE_METER_STATUS = 'A'                              
MFA-TR*             AND UT.IC_NO = MN.IC_NO                                     
MFA-TR*             AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                   
MFA-TR*             AND UT.ACCOUNT_NO IN                                        
MFA-TR*             (SELECT U1.ACCOUNT_NO                                       
MFA-TR*                FROM CSS_UTIL_ENVRNMT U1                                 
MFA-TR*               WHERE U1.ACCOUNT_NO = UT.ACCOUNT_NO                       
MFA-TR*             AND SUBSTR(U1.CODE_REVENUE_CLASS,2,1)                       
MFA-TR*               IN ('1','2','8','0')                                      
MFA-TR*               AND SUBSTR(U1.CODE_REVENUE_CLASS,2,1) <>                  
MFA-TR*                     SUBSTR(UT.CODE_REVENUE_CLASS,2,1)                   
MFA-TR*               AND ( EXISTS ( SELECT 1                                   
MFA-TR*                     FROM CSS_MTRD_ENVRNMT M1                            
MFA-TR*                     WHERE U1.ACCOUNT_NO = M1.ACCOUNT_NO                 
MFA-TR*                      AND U1.IC_NO = M1.IC_NO                            
MFA-TR*                      AND U1.CODE_UTIL_TYPE = M1.CODE_UTIL_TYPE          
MFA-TR*                      AND M1.CODE_METER_STATUS = 'A')                    
MFA-TR*                     OR EXISTS                                           
MFA-TR*                     ( SELECT 1                                          
MFA-TR*                     FROM CSS_CUST_PLAN CP                               
MFA-TR*                     WHERE CP.ACCOUNT_NO = U1.ACCOUNT_NO                 
MFA-TR*                     AND CP.IC_NO = U1.IC_NO                             
MFA-TR*                     AND CP.CODE_PLAN_STATUS = 'A')))                    
MFA-TR*             ORDER BY AT.LOCAL_OFFICE                                    
MFA-TR*                     ,UT.ACCOUNT_NO                                      
MFA-TR*                     ,UT.CODE_UTIL_TYPE                                  
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-OUTPUT              THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 8000-OPEN-OUTFILE                THRU  8000-EXIT.    
           INITIALIZE PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-OUTPUT.                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-DATE                    THRU  7000-EXIT.    
                                                                        
           MOVE WS-CURRENT-DATE-USA       TO HDR-LN2-SYS-DATE.          
           MOVE WS-CURRENT-TIME-USA       TO HDR-LN3-SYS-TIME.          
                                                                        
           PERFORM 7100-OPEN-REVENUE-CLASS          THRU  7100-EXIT.    
      *                                                                         
           PERFORM 7200-FETCH-REVENUE-CLASS         THRU  7200-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
             MOVE 'Y'                          TO WS-NO-DATA            
             MOVE 1                            TO WS-PAGE-NO            
             MOVE WS-PAGE-NO                   TO HDR-LN1-PAGE-NO       
             PERFORM 8100-WRITE-OUTFILE-HEADER      THRU  8100-EXIT     
           ELSE                                                         
                                                                        
           MOVE ZEROES                         TO WS-PREV-ACCT-NO       
           MOVE SPACES                         TO WS-PREV-LOC-OFF       
                                                                        
           PERFORM 2100-PROCESS-REVENUE-CLASS       THRU 2100-EXIT      
             UNTIL WS-ALL-ROWS-PROCESD = WS-Y                           
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7300-CLOSE-REVENUE-CLASS         THRU  7300-EXIT.    
                                                                        
           IF WS-ALL-ROWS-PROCESD = WS-Y OR WS-NO-DATA = WS-Y           
              PERFORM 8300-WRITE-FOOTER-DETAILS     THRU  8300-EXIT     
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-PROCESS-REVENUE-CLASS.                                     *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-REVENUE-CLASS.                                      
                                                                        
           IF WS-ACCOUNT-NO = WS-PREV-ACCT-NO                           
             MOVE SPACES                       TO OUT-ACCOUNT-NO        
             MOVE 'Y'                          TO WS-ACCT-IND           
           ELSE                                                         
             MOVE WS-ACCOUNT-NO                TO WS-PREV-ACCT-NO       
             MOVE 'N'                          TO WS-ACCT-IND           
           END-IF                                                       
                                                                        
                                                                        
           IF WS-LOCAL-OFFICE NOT EQUAL WS-PREV-LOC-OFF                 
             MOVE WS-LOCAL-OFFICE              TO WS-PREV-LOC-OFF       
             MOVE 'N'                          TO WS-VALUE-DIFFER       
                                                                        
             PERFORM 7400-GET-LOC-OFF-DESC          THRU  7400-EXIT     
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'N/A'                      TO WS-LOC-OFF-DESC       
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-ACCT-IND ='N'                                          
             MOVE WS-ACCOUNT-NO                TO WS-ACCOUNT-NO-Z       
             MOVE WS-ACCOUNT-NO-Z              TO OUT-ACCOUNT-NO        
           ELSE                                                         
             MOVE SPACES                       TO OUT-ACCOUNT-NO        
           END-IF                                                       
                                                                        
           MOVE WS-CODE-UTIL-TYPE              TO OUT-CODE-UTIL-TYPE    
           MOVE WS-REVENUE-CLASS               TO OUT-REVENUE-CLASS     
           MOVE WS-RATE-PLAN-NO                TO OUT-RATE-PLAN-NO      
           MOVE WS-LOCAL-OFFICE                TO HDR-LN4-LOCAL-OFFICE  
           MOVE WS-LOC-OFF-DESC            TO HDR-LN4-LOCAL-OFFICE-DESC 
                                                                        
           PERFORM 2500-WRITE-REPORT                THRU  2500-EXIT     
           PERFORM 7200-FETCH-REVENUE-CLASS         THRU  7200-EXIT     
           .                                                            
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2500-WRITE-REPORT.                                           *          
      ****************************************************************          
      *                                                                         
        2500-WRITE-REPORT.                                              
                                                                        
           IF WS-VALUE-DIFFER = WS-N OR WS-LOCAL-COUNT = 50             
              COMPUTE WS-PAGE-NO        = WS-PAGE-NO       + 1          
              MOVE WS-PAGE-NO                 TO HDR-LN1-PAGE-NO        
              MOVE 'Y'                        TO WS-VALUE-DIFFER        
              MOVE 'Y'                        TO WS-BEGIN-VALUE         
              PERFORM 8100-WRITE-OUTFILE-HEADER     THRU  8100-EXIT     
           END-IF                                                       
                                                                        
           IF WS-BEGIN-VALUE = WS-Y                                     
              PERFORM 8205-WRITE-OUTFILE-DETAIL     THRU  8205-EXIT     
           ELSE                                                         
              PERFORM 8200-WRITE-OUTFILE-DETAILS    THRU  8200-EXIT     
           END-IF                                                       
                                                                        
           MOVE 'N'                           TO WS-BEGIN-VALUE         
           .                                                            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7000-GET-DATE.                                               **        
      ******************************************************************        
      *                                                                         
       7000-GET-DATE.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT  CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() 
           AS DATE),'USA'),                           
                      CIS.CHAR2$TIME(CIS.CURRENT$TIME(),'USA')                  
                INTO :WS-CURRENT-DATE-USA,                              
                     :WS-CURRENT-TIME-USA                               
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CHAR(CURRENT DATE,USA),                                   
MFA-TR*               CHAR(CURRENT TIME,USA)                                    
MFA-TR*         INTO :WS-CURRENT-DATE-USA,                                      
MFA-TR*              :WS-CURRENT-TIME-USA                                       
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP026 ABORT *****'                   
              DISPLAY '**  7000-GET-DATE          **'                   
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7100-OPEN-REVENUE-CLASS.                                     **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-REVENUE-CLASS.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REVENUE_CLASS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP026 ABORT *****'                   
              DISPLAY '**OPEN MAIN CURSOR ERROR   **'                   
              DISPLAY '**7100-OPEN-REVENUE-CLASS  **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-FETCH-GET-MAIN                                          **        
      ******************************************************************        
      *                                                                         
       7200-FETCH-REVENUE-CLASS.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH REVENUE_CLASS                                       
               INTO :WS-ACCOUNT-NO                                      
                   ,:WS-CODE-UTIL-TYPE                                  
                   ,:WS-LOCAL-OFFICE                                    
                   ,:WS-REVENUE-CLASS                                   
                   ,:WS-RATE-PLAN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                   TO WS-ALL-ROWS-PROCESD        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP026 ABORT *****'                   
              DISPLAY '**  MAIN CURSOR FETCH ERROR**'                   
              DISPLAY '**7200-FETCH-REVENUE-CLASS **'                   
              DISPLAY '**ACCOUNT NO           =' AT-ACCOUNT-NO          
              DISPLAY '**CODE UTIL TYPE       =' UT-CODE-UTIL-TYPE      
              DISPLAY '**IC NO                =' UT-IC-NO               
              DISPLAY '**RETURN CODE          =' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-CLOSE-REVENUE-CLASS                                     **        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-REVENUE-CLASS.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REVENUE_CLASS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP026 ABORT *****'                   
              DISPLAY '**CLOSE MAIN   CURSOR ERROR**'                   
              DISPLAY '**7300-CLOSE-REVENUE-CLASS      **'              
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7400-GET-LOC-OFF-DESC.                                      **        
      ******************************************************************        
      *                                                                         
       7400-GET-LOC-OFF-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE_DESC                                  
                INTO :WS-LOC-OFF-DESC                                   
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE LOCAL_OFFICE = :WS-LOCAL-OFFICE                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE_DESC                                          
MFA-TR*         INTO :WS-LOC-OFF-DESC                                           
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE LOCAL_OFFICE = :WS-LOCAL-OFFICE                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSRP026 ABORT *****'                   
              DISPLAY '**7400-GET-LOC-OFF-DESC         **'              
              DISPLAY '**LOCAL OFFICE= ' WS-LOCAL-OFFICE                
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8000-OPEN-OUTFILE.                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-OPEN-OUTFILE.                                               
      *                                                                 08230000
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE-HEADER                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN1                
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN4.               
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN5.               
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN6                
                  AFTER ADVANCING 2 LINES.                              
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE-DETAILS                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-DETAILS.                                      
      *                                                                 08230000
                                                                        
           WRITE PRT331-RECORD FROM WS-RP026-OUT-REC.                   
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN6.               
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8205-WRITE-OUTFILE-DETAIL                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8205-WRITE-OUTFILE-DETAIL.                                       
      *                                                                 08230000
                                                                        
           WRITE PRT331-RECORD FROM WS-RP026-OUT-REC                    
                  AFTER ADVANCING 2 LINES.                              
           WRITE PRT331-RECORD FROM WS-RP026-HDR-REC-LN6.               
      *                                                                 08335000
       8205-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-FOOTER-DETAILS                                **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-FOOTER-DETAILS.                                       
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP026-FTR-REC-LN2                
                  AFTER ADVANCING 3 LINES.                              
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08060000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE    **'          
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
