       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP020.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     DEC 22,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      *** THIS  PROGRAM LISTS OUT ALL THE ACCOUNTS OTHER THAN IBS AND***        
      *** SECURED RATE ACCOUNTS NOT BILLED FOR ALL PREVIOUS CYCLES.  ***        
      *** (NON-UTILITY ACCOUNTS ARE EXCLUDED)                        ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    ---------------------------------**        
ACT037***  12/22/2015    MS7M727     EZT TO COBOL CONVERSION         ***        
ACT263***  08/24/2016    BD09555     DELETE TBWQMF COPYBOOK          ***        
ACT263*** A05460-ACT263  MS7M727                                     ***        
ACT360***  11/29/2016    TP7R341     ADD NEW COLUMN TO NO BILL       ***        
ACT360***    A05460                  REPORT                          ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN  TO UT-S-FCSPT33                                  
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
           SELECT FCSPT331-FILE                                         
               ASSIGN UT-S-FCSPT331                                     
               FILE STATUS IS WS-FCSPT331-STATUS.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       COPY CFDPT331 .                                                          
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP020'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT          (PREFIX = AT)                                   
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PREMISE          (PREFIX = PR)                                   
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT     (PREFIX = UT)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_RATE_PLAN_DESC   (PREFIX = RD)                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILL_WINDOW      (PREFIX = BN)                                   
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MODEL_SQL  MS    (PREFIX = MS)                                   
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_HDR      (PREFIX = BI)                                   
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MTRD_ENVRNMT     (PREFIX = MN)                                   
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_COMPANY                                                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_DET     (PREFIX = BG)                                    
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    ABEND SWITCH COPYBOOK                                                
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
       01 WS-LITERAL.                                                   
          05 WS-PGRMNAME                     PIC X(08) VALUE 'PCSRP020'.
          05 WS-FIRST-REC-PSNC               PIC X(01) VALUE 'Y'.       
          05 WS-FIRST-REC-SCEG               PIC X(01) VALUE 'Y'.       
          05 WS-FIRST-REC-SCEG1              PIC X(01) VALUE 'Y'.       
          05 WS-FIRST-REC-PSNC1              PIC X(01) VALUE 'Y'.       
      *                                                                         
       01 WS-SAVE-ACCT.                                                 
          05 WS-SAVE-ACCT1                   PIC X(01) VALUE ZERO.      
          05 WS-SAVE-ACCT2                   PIC X(04) VALUE ZERO.      
          05 WS-SAVE-ACCT3                   PIC X(04) VALUE ZERO.      
          05 WS-SAVE-ACCT4                   PIC X(04) VALUE ZERO.      
      *                                                                         
       01 WS-CURRENT-DATE                    PIC X(10) VALUE SPACES.    
       01 WS-MAX-REV-MONTH                   PIC S9(06)V                
                                             USAGE COMP-3 VALUE ZERO.   
       01 WS-MIN-REV-MONTH                   PIC S9(06)V                
                                             USAGE COMP-3 VALUE ZERO.   
       01 WS-PREV-REV-MONTH                  PIC S9(06)V                
                                             USAGE COMP-3 VALUE ZERO.   
       01 WS-PREV-REV-MONTH-N                PIC  9(06) VALUE ZERO.     
                                                                        
       01 WS-NULL-IND1                       PIC S9(02)                 
                                             USAGE COMP VALUE ZERO.     
ACT360 01 WS-NULL-IND2                       PIC S9(04) COMP VALUE 0.   
      *                                                                         
       01 WS-FILE-STATUS.                                               
           05 WS-FCSPT33-STATUS              PIC X(02) VALUE SPACES.    
              88 FCSPT33-SUCCESSFUL                    VALUE '00'.      
           05 WS-FCSPT331-STATUS             PIC X(02) VALUE SPACES.    
              88 FCSPT331-SUCCESSFUL                   VALUE '00'.      
                                                                        
       01 WS-ACCT.                                                      
           05 WS-ACCOUNT1                    PIC X(01) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCOUNT2                    PIC X(04) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCOUNT3                    PIC X(04) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCOUNT4                    PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-PREV-REV-MONTH-R.                                          
           05 WS-PREV-REV-CCYY               PIC 9(04) VALUE ZERO.      
           05 WS-PREV-REV-MM                 PIC 9(02) VALUE ZERO.      
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-WQ-ITEM-LIT                 PIC X(01) VALUE SPACES.    
           05 WS-ACCOUNT-NO                  PIC X(13) VALUE SPACES.    
           05 WS-RESP-AREA-ID                PIC X(03) VALUE SPACES.    
           05 WS-WQ-ITEM                     PIC X(01) VALUE SPACES.    
           05 WS-ACCT-CREATE-DT              PIC X(10) VALUE SPACES.    
           05 WS-DATE-EXTRACT                PIC X(10) VALUE SPACES.    
           05 WS-BILL-CYCLE1                 PIC X(02) VALUE SPACES.    
           05 WS-BILL-CYCLE2                 PIC X(02) VALUE SPACES.    
           05 WS-MIN-CYCLE                   PIC X(02) VALUE SPACES.    
           05 WS-Y                           PIC X(01) VALUE 'Y'.       
           05 WS-N                           PIC X(01) VALUE 'N'.       
           05 WS-NAME                        PIC X(20) VALUE SPACES.    
           05 WS-ADDRESS                     PIC X(30) VALUE SPACES.    
           05 WS-NO-REPORT                   PIC X(01) VALUE 'Y'.       
           05 WS-COMP-INFO-CRSR-IND          PIC X(01) VALUE SPACES.    
           05 WS-COMPANY-NAME                PIC X(26) VALUE SPACES.    
           05 WS-COMPANY-NO                  PIC X(02) VALUE SPACES.    
           05 WS-SCEG-COMP-NAME              PIC X(26) VALUE SPACES.    
           05 WS-PSNC-COMP-NAME              PIC X(26) VALUE SPACES.    
           05 WS-SCEG-DATA-IND               PIC X(01) VALUE 'N'.       
           05 WS-PNSC-DATA-IND               PIC X(01) VALUE 'N'.       
           05 WS-MTR-REMOVED                 PIC X(01) VALUE 'N'.       
           05 WS-PSNC-DATA-IND               PIC X(01) VALUE 'N'.       
           05 WS-MIN7-DATE                   PIC X(10) VALUE SPACES.    
           05 WS-PL14-DATE                   PIC X(10) VALUE SPACES.    
           05 WS-REVENUE-MONTH               PIC 999999 VALUE ZERO.     
           05 WS-MAX-REV-MONTH-C             PIC 999,999V VALUE ZERO.   
           05 WS-MIN-REV-MONTH-C             PIC 999,999V VALUE ZERO.   
           05 WS-MAX-REV-MONTH1              PIC 999,999V VALUE ZERO.   
           05 WS-PREV-REV-MONTH-C            PIC 999,999V VALUE ZERO.   
           05 WS-LINE-COUNT-PSNC             PIC 9(02) VALUE ZERO.      
           05 WS-LINE-COUNT-SCEG             PIC 9(02) VALUE ZERO.      
           05 WS-PAGE-NUM-SCEG               PIC 9(03) VALUE ZERO.      
           05 WS-PAGE-NUM-PSNC               PIC 9(03) VALUE ZERO.      
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                         PIC 9(02) VALUE ZERO.      
           05  WS-MM                         PIC 9(02) VALUE ZERO.      
           05  WS-SS                         PIC 9(02) VALUE ZERO.      
           05  WS-TT                         PIC 9(02) VALUE ZERO.      
      *                                                                         
       01 WS-RUN-TIME.                                                  
           05  WS-RT-HH                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '.'.       
           05  WS-RT-MM                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '.'.       
           05  WS-RT-SS                      PIC X(02) VALUE SPACES.    
      *                                                                         
       01 WS-RUN-DATE.                                                  
           05  WS-RD-MM                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '/'.       
           05  WS-RD-DD                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '/'.       
           05  WS-RD-YY                      PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-CURRENT-DATE1.                                             
           05  WS-CY                         PIC X(04) VALUE SPACES.    
           05  WS-CM                         PIC X(02) VALUE SPACES.    
           05  WS-CD                         PIC X(02) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-HDR1.                                               
           05 FILLER                         PIC X(03) VALUE SPACES.    
           05 P-RPT-PGM-NAME                 PIC X(09) VALUE 'PCSRP020'.
           05 FILLER                         PIC X(44) VALUE SPACES.    
           05 P-RPT-COMPANY-NAME             PIC X(26) VALUE SPACES.    
           05 FILLER                         PIC X(39) VALUE SPACES.    
           05 P-RPT-PAGE                     PIC X(04) VALUE 'PAGE'.    
           05 FILLER                         PIC X(04) VALUE SPACES.    
           05 P-RPT-PAGE-NUM                 PIC ZZZ   VALUE ZERO.      
      *                                                                         
       01 WS-REPORT-HDR2.                                               
           05 FILLER                         PIC X(03) VALUE SPACES.    
           05 P-RPT-SYS-DATE                 PIC X(05) VALUE 'DATE:'.   
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-SYS-DATE1                PIC X(10) VALUE SPACES.    
           05 FILLER                         PIC X(26) VALUE SPACES.    
           05 P-RPT-CYCLE-HDR                PIC X(43) VALUE            
                     'ACCOUNTS THAT DID NOT BILL(ALL PREV CYCLES)'.     
           05 FILLER                         PIC X(24) VALUE SPACES.    
           05 P-RPT-RUN-DATE                 PIC X(09) VALUE            
                                                       'RUN DATE:'.     
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-RUN-DATE1                PIC X(10) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-HDR3.                                               
           05 FILLER                         PIC X(112) VALUE SPACES.   
           05 P-RPT-RUN-TIME                 PIC X(09) VALUE            
                                                       'RUN TIME:'.     
           05 FILLER                         PIC X(03) VALUE SPACES.    
           05 P-RPT-RUN-TIME1                PIC X(08) VALUE SPACES.    
                                                                        
      *                                                                         
       01 WS-REPORT-HDR4.                                               
           05 FILLER                         PIC X(133) VALUE SPACES.   
      *                                                                         
       01 WS-REPORT-HDR5.                                               
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-WQ-ITEM-LIT              PIC X(02) VALUE 'WQ'.      
ACT360     05 FILLER                         PIC X(02) VALUE SPACES.    
ACT360     05 P-RPT-LOC-OFFICE               PIC X(07) VALUE 'LOC OFF'. 
ACT360     05 FILLER                         PIC X(04) VALUE SPACES.    
ACT360     05 P-RPT-ACCOUNT-NO               PIC X(10) VALUE            
ACT360                                                   'ACCOUNT NO'.  
ACT360     05 FILLER                         PIC X(06) VALUE SPACES.    
ACT360     05 P-RPT-ACCT-CREATE-DT           PIC X(14) VALUE            
ACT360                                               'ACCT CREATE-DT'.  
ACT360     05 FILLER                         PIC X(05) VALUE SPACES.    
ACT360     05 P-RPT-TOTAL-AR-BALAN           PIC X(07) VALUE            
ACT360                                                      'BALANCE'.  
ACT360     05 FILLER                         PIC X(08) VALUE SPACES.    
ACT360     05 P-RPT-MST-SUB-ACCT             PIC X(07) VALUE            
ACT360                                                      'SUBACCT'.  
ACT360     05 FILLER                         PIC X(03) VALUE SPACES.    
ACT360     05 P-RPT-ACCT-STATUS              PIC X(06) VALUE 'STATUS'.  
ACT360     05 FILLER                         PIC X(03) VALUE SPACES.    
ACT360     05 P-RPT-BILL-DATE                PIC X(09) VALUE            
ACT360                                                     'BILL DATE'. 
ACT360     05 FILLER                         PIC X(02) VALUE SPACES.    
ACT360     05 P-RPT-REVENUE-MNTH             PIC X(15) VALUE            
ACT360                                              'LAST REV. MONTH'.  
ACT360     05 FILLER                         PIC X(02) VALUE SPACES.    
ACT360     05 P-RPT-BILL-CYCLE               PIC X(05) VALUE 'CYCLE'.   
ACT360     05 FILLER                         PIC X(02) VALUE SPACES.    
ACT360     05 P-RPT-PEND-OFF-ORD-DT          PIC X(13) VALUE            
ACT360                                               'PEND OFF ORDR'.   
      *                                                                         
       01 WS-REPORT-HDR6.                                               
          05 FILLER                          PIC X(30) VALUE SPACES.    
          05 P-RPT-END-OF-RPT                PIC X(22) VALUE            
                                            '*** END OF REPORT ***'.    
          05 FILLER                          PIC X(81) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-DETAIL-INFO.                                        
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-WQ-ITEM-LIT1             PIC X(01) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(04) VALUE SPACES.    
ACT360     05 P-RPT-LOCAL-OFFICE1            PIC X(03) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(05) VALUE SPACES.    
ACT360     05 P-RPT-ACCT1                    PIC X(16) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(03) VALUE SPACES.    
ACT360     05 P-RPT-ACCT-CREATE-DT1          PIC X(10) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(04) VALUE SPACES.    
ACT360     05 P-RPT-TOTAL-AR-BALANCE1        PIC ZZ,ZZZ,ZZZ,ZZZ.99-     
ACT360                                                 VALUE ZERO.      
ACT360     05 FILLER                         PIC X(04) VALUE SPACES.    
ACT360     05 P-RPT-MST-SUB-ACCT-IND1        PIC X(01) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(08) VALUE SPACES.    
ACT360     05 P-RPT-CODE-ACCT-STAT1          PIC X(01) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(05) VALUE SPACES.    
ACT360     05 P-RPT-DATE-BILL-DAY1           PIC X(10) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(06) VALUE SPACES.    
ACT360     05 P-RPT-REVENUE-MONTH            PIC 999999 VALUE ZERO.     
ACT360     05 FILLER                         PIC X(09) VALUE SPACES.    
ACT360     05 P-RPT-BILL-CYCLE1              PIC X(02) VALUE SPACES.    
ACT360     05 FILLER                         PIC X(03) VALUE SPACES.    
ACT360     05 P-RPT-PEND-OFF-ORD-DT1         PIC X(10) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-NO-DATA.                                            
           05 FILLER                         PIC X(54) VALUE SPACES.    
           05 P-RPT-NO-DATA                  PIC X(25) VALUE            
                                         '*** NO ACCOUNTS FOUND ***'.   
           05 FILLER                         PIC X(49) VALUE SPACES.    
      *                                                                         
      *****************************************************************         
      * CURSOR FOR GETTING RECORDS                                              
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE GETREC CURSOR  FOR                                
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.BILL_CYCLE                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,COALESCE(AT.TOTAL_AR_BALANCE,0)                     
                     ,COALESCE(AT.DATE_BILL_DAY_00,
              IIF(TRY_CONVERT(DATE, '2000-01-01'
              ) IS NULL OR (PATINDEX('%.%', '2000-01-01'
              ) <> 0) OR (LEN('2000-01-01') <> 10), CIS.CHAR2DATE(
              '2000-01-01'), CONVERT(DATE, '2000-01-01') ))          
                     ,AT.MST_SUB_ACCT_IND                               
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.COMPANY_NO                                     
                     ,COALESCE(AT.REV_MTH_LST_NRML,201310)                
              ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AT.ACCT_CREATE_DT,CIS.CHAR2TIMESTAMP(
              '2000-01-01-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')   
ACT360               ,PR.PEND_OFF_ORD_DT                                
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
               WHERE  AT.PREMISE_NO = PR.PREMISE_NO                     
                 AND  AT.CREDIT_GROUP <> 'D'                            
                 AND (AT.REV_MTH_LST_NRML <> 0 OR                       
                     (AT.REV_MTH_LST_NRML    = 0 AND                    
                     (CAST(ACCT_CREATE_DT AS DATE)  <=                          
                          DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))))           
                 AND AT.CODE_ACCT_STAT = 'A'                            
                 AND AT.CODE_ACCT_BILLED <> 'U'                         
                 AND (PR.PEND_OFF_ORD_DT IS NULL                        
                  OR  PR.PEND_OFF_ORD_DT < IIF(TRY_CONVERT(DATE, 
                                                          :WS-MIN7-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN7-DATE
              ) <> 0) OR (LEN(:WS-MIN7-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-MIN7-DATE
              ), CONVERT(DATE, :WS-MIN7-DATE) )                
                  OR  PR.PEND_OFF_ORD_DT > IIF(TRY_CONVERT(DATE, 
                                                          :WS-PL14-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PL14-DATE
              ) <> 0) OR (LEN(:WS-PL14-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PL14-DATE
              ), CONVERT(DATE, :WS-PL14-DATE) ) )              
                 AND  AT.ACCOUNT_NO NOT IN                              
                   (SELECT UT.ACCOUNT_NO                                
                      FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)            
                          ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)          
                     WHERE UT.ACCOUNT_NO = AT.ACCOUNT_NO                
                     AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE          
                     AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO              
                     AND (UT.CODE_REVENUE_CLASS = '000'                 
                      OR RD.SECURED_RATE_FL = 'Y'))                     
                 AND (( AT.BILL_CYCLE    <= :WS-MIN-CYCLE               
                 AND  AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )         
                  OR (AT.BILL_CYCLE       < :WS-BILL-CYCLE1             
                 AND  AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )         
                  OR (AT.BILL_CYCLE       > :WS-BILL-CYCLE1             
                 AND  AT.REV_MTH_LST_NRML < :WS-PREV-REV-MONTH ))       
                ORDER BY AT.COMPANY_NO,                                 
                         AT.BILL_CYCLE,                                 
                         AT.REV_MTH_LST_NRML,                           
                         AT.ACCOUNT_NO                                  
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GETREC CURSOR  FOR                                        
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,IFNULL(AT.TOTAL_AR_BALANCE,0)                             
MFA-TR*              ,IFNULL(AT.DATE_BILL_DAY_00,'2000-01-01')                  
MFA-TR*              ,AT.MST_SUB_ACCT_IND                                       
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,IFNULL(AT.REV_MTH_LST_NRML,201310)                        
MFA-TR*       ,IFNULL(AT.ACCT_CREATE_DT,'2000-01-01-00.00.00.000000')           
MFA-TR*              ,PR.PEND_OFF_ORD_DT                                        
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*        WHERE  AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*          AND  AT.CREDIT_GROUP <> 'D'                                    
MFA-TR*          AND (AT.REV_MTH_LST_NRML <> 0 OR                               
MFA-TR*              (AT.REV_MTH_LST_NRML    = 0 AND                            
MFA-TR*              (DATE(ACCT_CREATE_DT)  <=                                  
MFA-TR*                   DATE(:WS-CURRENT-DATE) - 30 DAYS)))                   
MFA-TR*          AND AT.CODE_ACCT_STAT = 'A'                                    
MFA-TR*          AND AT.CODE_ACCT_BILLED <> 'U'                                 
MFA-TR*          AND (PR.PEND_OFF_ORD_DT IS NULL                                
MFA-TR*           OR  PR.PEND_OFF_ORD_DT < :WS-MIN7-DATE                        
MFA-TR*           OR  PR.PEND_OFF_ORD_DT > :WS-PL14-DATE )                      
MFA-TR*          AND  AT.ACCOUNT_NO NOT IN                                      
MFA-TR*            (SELECT UT.ACCOUNT_NO                                        
MFA-TR*               FROM CSS_UTIL_ENVRNMT UT                                  
MFA-TR*                   ,CSS_RATE_PLAN_DESC RD                                
MFA-TR*              WHERE UT.ACCOUNT_NO = AT.ACCOUNT_NO                        
MFA-TR*              AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                  
MFA-TR*              AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                      
MFA-TR*              AND (UT.CODE_REVENUE_CLASS = '000'                         
MFA-TR*               OR RD.SECURED_RATE_FL = 'Y'))                             
MFA-TR*          AND (( AT.BILL_CYCLE    <= :WS-MIN-CYCLE                       
MFA-TR*          AND  AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )                 
MFA-TR*           OR (AT.BILL_CYCLE       < :WS-BILL-CYCLE1                     
MFA-TR*          AND  AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )                 
MFA-TR*           OR (AT.BILL_CYCLE       > :WS-BILL-CYCLE1                     
MFA-TR*          AND  AT.REV_MTH_LST_NRML < :WS-PREV-REV-MONTH ))               
MFA-TR*         ORDER BY AT.COMPANY_NO,                                         
MFA-TR*                  AT.BILL_CYCLE,                                         
MFA-TR*                  AT.REV_MTH_LST_NRML,                                   
MFA-TR*                  AT.ACCOUNT_NO                                          
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                THRU  0100-EXIT.      
                                                                        
           PERFORM 1000-PROCESS-INPUT             THRU  1000-EXIT.      
                                                                        
           PERFORM 9000-TERMINATE                 THRU  9000-EXIT.      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME1.            
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                    TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE1.            
           MOVE WS-RUN-DATE              TO P-RPT-SYS-DATE1.            
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
           IF NOT FCSPT331-SUCCESSFUL                                   
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP020******************'         
               DISPLAY '**  0100-INITIALIZATION             **'         
               DISPLAY '**  ERROR OPENING FCSBW04 FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT331-STATUS          
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP020******************'         
               DISPLAY '**  ERROR OPENING FCSPT331          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
                                                                        
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
           MOVE SPACES                   TO WS-INPUT-DATA-BREAKDOWN     
           MOVE 'COMMON'                 TO WS-PGRMNAME                 
           PERFORM 6251-GET-FJC01-DATE            THRU 6251-EXIT.       
           MOVE WS-INPUT-DATE            TO WS-DATE-EXTRACT             
                                            WS-CURRENT-DATE.            
                                                                        
           DISPLAY 'RUN DATE = ' WS-CURRENT-DATE.                       
      *                                                                         
           PERFORM 7100-GET-DATE-RANGE            THRU 7100-EXIT.       
           DISPLAY 'WS-MIN7-DATE : ' WS-MIN7-DATE.                      
           DISPLAY 'WS-PL14-DATE : ' WS-PL14-DATE.                      
                                                                        
      *                                                                         
           PERFORM 7000-GET-MIN-MAX-REV-MONTH     THRU 7000-EXIT.       
      *                                                                         
           MOVE WS-MAX-REV-MONTH         TO WS-MAX-REV-MONTH-C.         
           MOVE WS-MIN-REV-MONTH         TO WS-MIN-REV-MONTH-C.         
           DISPLAY 'WS-MAX-REV-MONTH : ' WS-MAX-REV-MONTH-C.            
           DISPLAY 'WS-MIN-REV-MONTH : ' WS-MIN-REV-MONTH-C.            
      *                                                                         
           COMPUTE WS-PREV-REV-MONTH = WS-MAX-REV-MONTH - 1.            
           MOVE WS-PREV-REV-MONTH        TO WS-PREV-REV-MONTH-N.        
           MOVE WS-PREV-REV-MONTH-N      TO WS-PREV-REV-MONTH-R.        
      *                                                                         
           IF  WS-PREV-REV-MM = 0                                       
               MOVE 12                   TO WS-PREV-REV-MM              
               COMPUTE WS-PREV-REV-CCYY = WS-PREV-REV-CCYY - 1          
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREV-REV-MONTH-R      TO WS-PREV-REV-MONTH-N.        
           MOVE WS-PREV-REV-MONTH-N      TO WS-PREV-REV-MONTH.          
           MOVE WS-PREV-REV-MONTH        TO WS-PREV-REV-MONTH-C.        
           DISPLAY 'WS-PREV-REV-MONTH: ' WS-PREV-REV-MONTH-C.           
      *                                                                         
           MOVE WS-MIN-REV-MONTH         TO BN-REVENUE-MONTH.           
           PERFORM 7050-GET-MAX-CYCL-REV-MONTH    THRU 7050-EXIT.       
                                                                        
           MOVE BN-BILL-CYCLE            TO WS-MIN-CYCLE.               
      *                                                                         
                                                                        
           IF WS-NULL-IND1   <  0                                       
              MOVE '20'                  TO WS-MIN-CYCLE                
           END-IF                                                       
      *                                                                         
           DISPLAY 'WS-MIN-CYCLE: ' WS-MIN-CYCLE                        
      *                                                                         
           MOVE WS-MAX-REV-MONTH         TO BN-REVENUE-MONTH.           
           PERFORM 7050-GET-MAX-CYCL-REV-MONTH    THRU 7050-EXIT.       
                                                                        
           MOVE BN-BILL-CYCLE            TO WS-BILL-CYCLE1.             
           DISPLAY 'WS-BILL-CYCLE1 :' WS-BILL-CYCLE1.                   
                                                                        
           MOVE '01'                     TO WS-COMPANY-NO.              
           PERFORM 7150-GET-COMPANY-NAME          THRU 7150-EXIT.       
           MOVE WS-COMPANY-NAME          TO WS-SCEG-COMP-NAME.          
                                                                        
           MOVE '26'                     TO WS-COMPANY-NO.              
           PERFORM 7150-GET-COMPANY-NAME          THRU 7150-EXIT.       
           MOVE WS-COMPANY-NAME          TO WS-PSNC-COMP-NAME.          
                                                                        
           PERFORM 2000-PROCESS-ACCOUNTS          THRU 2000-EXIT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-ACCOUNTS                                                  
      ******************************************************************        
      *                                                                         
       2000-PROCESS-ACCOUNTS.                                           
      *                                                                         
                                                                        
           PERFORM 7250-OPEN-GETREC-CURSOR        THRU 7250-EXIT.       
           PERFORM 7300-FETCH-GETREC-CURSOR       THRU 7300-EXIT.       
      *                                                                         
           PERFORM 2100-PROCESS-ACCT-PREV-CYC     THRU 2100-EXIT        
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7350-CLOSE-GETREC-CURSOR       THRU 7350-EXIT.       
           PERFORM 2300-CHECK-REPORT              THRU 2300-EXIT.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-ACCT-PREV-CYC                                             
      ******************************************************************        
      *                                                                         
       2100-PROCESS-ACCT-PREV-CYC.                                      
      *                                                                         
           MOVE 'N'                      TO  WS-MTR-REMOVED.            
                                                                        
           IF AT-TOTAL-AR-BALANCE EQUAL 0                               
              PERFORM 7200-CHECK-REMOVED-METER    THRU 7200-EXIT        
      *                                                                         
              IF WS-MTR-REMOVED EQUAL 'Y'                               
                 MOVE AT-ACCOUNT-NO      TO WS-ACCOUNT-NO               
                 MOVE WS-ACCOUNT-NO(1:1) TO WS-SAVE-ACCT1               
                 MOVE WS-ACCOUNT-NO(2:4) TO WS-SAVE-ACCT2               
                 MOVE WS-ACCOUNT-NO(6:4) TO WS-SAVE-ACCT3               
                 MOVE WS-ACCOUNT-NO(10:4) TO WS-SAVE-ACCT4              
                 DISPLAY 'REMOVED MTR ACT : 'AT-ACCOUNT-NO              
              END-IF                                                    
      *                                                                         
           END-IF.                                                      
      *                                                                         
           IF WS-MTR-REMOVED EQUAL 'N'                                  
              IF WS-BILL-CYCLE1  = AT-BILL-CYCLE                        
                 IF WS-BILL-CYCLE1 >= '20'                              
                    PERFORM 2800-CHECK-WRITE-PROC-COMP                  
                                                  THRU 2800-EXIT        
                 END-IF                                                 
              ELSE                                                      
                  PERFORM 2800-CHECK-WRITE-PROC-COMP                    
                                                  THRU 2800-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7300-FETCH-GETREC-CURSOR       THRU 7300-EXIT.       
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-FORMAT-ACCOUNT                                          **        
      ******************************************************************        
      *                                                                         
       2200-FORMAT-ACCOUNT.                                             
      *                                                                         
           MOVE AT-ACCOUNT-NO            TO WS-ACCOUNT-NO.              
           MOVE WS-ACCOUNT-NO(1:1)       TO WS-SAVE-ACCT1.              
           MOVE WS-ACCOUNT-NO(2:4)       TO WS-SAVE-ACCT2.              
           MOVE WS-ACCOUNT-NO(6:4)       TO WS-SAVE-ACCT3.              
           MOVE WS-ACCOUNT-NO(10:4)      TO WS-SAVE-ACCT4.              
           MOVE WS-SAVE-ACCT1            TO WS-ACCOUNT1.                
           MOVE WS-SAVE-ACCT2            TO WS-ACCOUNT2.                
           MOVE WS-SAVE-ACCT3            TO WS-ACCOUNT3.                
           MOVE WS-SAVE-ACCT4            TO WS-ACCOUNT4.                
           MOVE AT-REV-MTH-LST-NRML      TO WS-REVENUE-MONTH.           
           MOVE AT-ACCT-CREATE-DT        TO WS-ACCT-CREATE-DT.          
           MOVE 'N'                      TO WS-NO-REPORT.               
      *                                                                         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-CHECK-REPORT.                                                     
      ******************************************************************        
      *                                                                         
       2300-CHECK-REPORT.                                               
      *                                                                         
           IF  WS-NO-REPORT = 'Y'                                       
               MOVE WS-SCEG-COMP-NAME                                   
                                         TO P-RPT-COMPANY-NAME          
               MOVE 1                    TO P-RPT-PAGE-NUM              
               PERFORM 2600-WRITE-NODATA-REPORT-SCEG                    
                                                  THRU 2600-EXIT        
               MOVE WS-PSNC-COMP-NAME    TO P-RPT-COMPANY-NAME          
               MOVE 1                    TO P-RPT-PAGE-NUM              
               PERFORM 2700-WRITE-NODATA-REPORT-PSNC                    
                                                  THRU 2700-EXIT        
           ELSE                                                         
               IF WS-SCEG-DATA-IND = 'N'                                
                  MOVE WS-SCEG-COMP-NAME                                
                                         TO P-RPT-COMPANY-NAME          
                  MOVE 1                 TO P-RPT-PAGE-NUM              
                  PERFORM 2600-WRITE-NODATA-REPORT-SCEG                 
                                                  THRU 2600-EXIT        
               ELSE                                                     
                  MOVE  WS-REPORT-HDR6   TO PRT331-RECORD               
                  PERFORM  8100-WRITE-FCSPT33     THRU 8100-EXIT        
               END-IF                                                   
               IF WS-PSNC-DATA-IND = 'N'                                
                  MOVE WS-PSNC-COMP-NAME TO P-RPT-COMPANY-NAME          
                  MOVE 1                 TO P-RPT-PAGE-NUM              
                  PERFORM 2700-WRITE-NODATA-REPORT-PSNC                 
                                                  THRU 2700-EXIT        
               ELSE                                                     
                  MOVE  WS-REPORT-HDR6   TO PRT33-RECORD                
                  PERFORM  8000-WRITE-FCSPT33     THRU 8000-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-WRITE-DETAIL-REPORT-SCEG.                                         
      ******************************************************************        
      *                                                                         
       2400-WRITE-DETAIL-REPORT-SCEG.                                   
      *                                                                         
           IF WS-LINE-COUNT-SCEG > 54 OR WS-FIRST-REC-SCEG = 'Y'        
              MOVE 'N'                   TO WS-FIRST-REC-SCEG           
              MOVE ZERO                  TO WS-LINE-COUNT-SCEG          
              MOVE 'Y'                   TO WS-FIRST-REC-SCEG1          
              ADD  1                     TO WS-PAGE-NUM-SCEG            
              MOVE WS-PAGE-NUM-SCEG      TO P-RPT-PAGE-NUM              
              MOVE WS-REPORT-HDR1        TO PRT331-RECORD               
              PERFORM  8200-WRITE-FCSPT33         THRU 8200-EXIT        
              MOVE WS-REPORT-HDR2        TO PRT331-RECORD               
              PERFORM  8100-WRITE-FCSPT33         THRU 8100-EXIT        
              MOVE WS-REPORT-HDR3        TO PRT331-RECORD               
              PERFORM  8100-WRITE-FCSPT33         THRU 8100-EXIT        
              MOVE WS-REPORT-HDR4        TO PRT331-RECORD               
              PERFORM  8300-WRITE-FCSPT33         THRU 8300-EXIT        
              MOVE WS-REPORT-HDR5        TO PRT331-RECORD               
              PERFORM  8100-WRITE-FCSPT33         THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
           MOVE WS-REPORT-DETAIL-INFO    TO PRT331-RECORD.              
      *                                                                         
           IF WS-FIRST-REC-SCEG1 = 'Y'                                  
              PERFORM  8700-WRITE-FCSPT33         THRU 8700-EXIT        
              MOVE 'N'                   TO WS-FIRST-REC-SCEG1          
           ELSE                                                         
              PERFORM  8100-WRITE-FCSPT33         THRU 8100-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE WS-REPORT-HDR4           TO PRT331-RECORD               
           PERFORM  8100-WRITE-FCSPT33            THRU 8100-EXIT.       
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-WRITE-DETAIL-REPORT-PSNC                                          
      ******************************************************************        
      *                                                                         
       2500-WRITE-DETAIL-REPORT-PSNC.                                   
      *                                                                         
           MOVE WS-LINE-COUNT-PSNC       TO P-RPT-PAGE-NUM.             
                                                                        
           IF WS-LINE-COUNT-PSNC > 54 OR WS-FIRST-REC-PSNC = 'Y'        
              MOVE 'N'                   TO WS-FIRST-REC-PSNC           
              MOVE ZERO                  TO WS-LINE-COUNT-PSNC          
              MOVE 'Y'                   TO WS-FIRST-REC-PSNC1          
              ADD  1                     TO WS-PAGE-NUM-PSNC            
              MOVE WS-PAGE-NUM-PSNC      TO P-RPT-PAGE-NUM              
              MOVE WS-REPORT-HDR1        TO PRT33-RECORD                
              PERFORM  8400-WRITE-FCSPT33         THRU 8400-EXIT        
              MOVE WS-REPORT-HDR2        TO PRT33-RECORD                
              PERFORM  8000-WRITE-FCSPT33         THRU 8000-EXIT        
              MOVE WS-REPORT-HDR3        TO PRT33-RECORD                
              PERFORM  8000-WRITE-FCSPT33         THRU 8000-EXIT        
              MOVE WS-REPORT-HDR4        TO PRT33-RECORD                
              PERFORM  8500-WRITE-FCSPT33         THRU 8500-EXIT        
              MOVE WS-REPORT-HDR5        TO PRT33-RECORD                
              PERFORM  8000-WRITE-FCSPT33         THRU 8000-EXIT        
           END-IF.                                                      
           MOVE WS-REPORT-DETAIL-INFO    TO PRT33-RECORD.               
      *                                                                         
           IF WS-FIRST-REC-PSNC1 = 'Y'                                  
              PERFORM  8600-WRITE-FCSPT33         THRU 8600-EXIT        
              MOVE 'N'                   TO WS-FIRST-REC-PSNC1          
           ELSE                                                         
              PERFORM  8000-WRITE-FCSPT33         THRU 8000-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE WS-REPORT-HDR4           TO PRT33-RECORD                
           PERFORM  8000-WRITE-FCSPT33            THRU 8000-EXIT.       
                                                                        
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-WRITE-NODATA-REPORT-SCEG                                          
      ******************************************************************        
      *                                                                         
       2600-WRITE-NODATA-REPORT-SCEG.                                   
      *                                                                         
           MOVE WS-REPORT-HDR1           TO PRT331-RECORD.              
           PERFORM  8200-WRITE-FCSPT33            THRU 8200-EXIT.       
           MOVE WS-REPORT-HDR2           TO PRT331-RECORD.              
           PERFORM  8100-WRITE-FCSPT33            THRU 8100-EXIT.       
           MOVE WS-REPORT-HDR3           TO PRT331-RECORD.              
           PERFORM  8100-WRITE-FCSPT33            THRU 8100-EXIT.       
           MOVE WS-REPORT-HDR4           TO PRT331-RECORD.              
           PERFORM  8300-WRITE-FCSPT33            THRU 8500-EXIT.       
           MOVE WS-REPORT-NO-DATA        TO PRT331-RECORD.              
           PERFORM  8300-WRITE-FCSPT33            THRU 8500-EXIT.       
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2700-WRITE-NODATA-REPORT-PSNC                                          
      ******************************************************************        
      *                                                                         
       2700-WRITE-NODATA-REPORT-PSNC.                                   
      *                                                                         
           MOVE WS-REPORT-HDR1           TO PRT33-RECORD.               
           PERFORM  8400-WRITE-FCSPT33            THRU 8400-EXIT.       
           MOVE WS-REPORT-HDR2           TO PRT33-RECORD.               
           PERFORM  8000-WRITE-FCSPT33            THRU 8000-EXIT.       
           MOVE WS-REPORT-HDR3           TO PRT33-RECORD.               
           PERFORM  8000-WRITE-FCSPT33            THRU 8000-EXIT.       
           MOVE WS-REPORT-HDR4           TO PRT33-RECORD.               
           PERFORM  8500-WRITE-FCSPT33            THRU 8500-EXIT.       
           MOVE WS-REPORT-NO-DATA        TO PRT33-RECORD.               
           PERFORM  8500-WRITE-FCSPT33            THRU 8500-EXIT.       
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2800-CHECK-WRITE-PROC-COMP                                             
      ******************************************************************        
      *                                                                         
       2800-CHECK-WRITE-PROC-COMP.                                      
      *                                                                         
              MOVE 637                   TO WS-RESP-AREA-ID             
              PERFORM 7400-CHECK-WQ-TABLE         THRU 7400-EXIT        
      *                                                                         
              PERFORM 2200-FORMAT-ACCOUNT         THRU 2200-EXIT        
              PERFORM 5000-MOVE-DETAIL-DATA       THRU 5000-EXIT        
      *                                                                         
              IF AT-COMPANY-NO = '01'                                   
                 MOVE 'Y'                TO WS-SCEG-DATA-IND            
                 MOVE WS-SCEG-COMP-NAME  TO P-RPT-COMPANY-NAME          
                 PERFORM 2400-WRITE-DETAIL-REPORT-SCEG                  
                                                  THRU 2400-EXIT        
              END-IF.                                                   
              IF AT-COMPANY-NO = '26'                                   
                 MOVE 'Y'                TO WS-PSNC-DATA-IND            
                 MOVE WS-PSNC-COMP-NAME  TO P-RPT-COMPANY-NAME          
                 PERFORM 2500-WRITE-DETAIL-REPORT-PSNC                  
                                                  THRU 2500-EXIT        
              END-IF.                                                   
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 5000-MOVE-DETAIL-DATA.                                                 
      ******************************************************************        
      *                                                                         
       5000-MOVE-DETAIL-DATA.                                           
      *                                                                         
           MOVE AT-LOCAL-OFFICE          TO P-RPT-LOCAL-OFFICE1.        
           MOVE WS-ACCT                  TO P-RPT-ACCT1.                
           MOVE WS-ACCT-CREATE-DT        TO P-RPT-ACCT-CREATE-DT1.      
           MOVE AT-TOTAL-AR-BALANCE      TO P-RPT-TOTAL-AR-BALANCE1.    
           MOVE AT-MST-SUB-ACCT-IND      TO P-RPT-MST-SUB-ACCT-IND1.    
           MOVE AT-CODE-ACCT-STAT        TO P-RPT-CODE-ACCT-STAT1.      
           MOVE AT-DATE-BILL-DAY-00      TO P-RPT-DATE-BILL-DAY1.       
           MOVE WS-REVENUE-MONTH         TO P-RPT-REVENUE-MONTH.        
           MOVE AT-BILL-CYCLE            TO P-RPT-BILL-CYCLE1.          
           MOVE WS-WQ-ITEM-LIT           TO P-RPT-WQ-ITEM-LIT1.         
ACT360     IF WS-NULL-IND2 < 0                                          
ACT360        MOVE SPACES                TO P-RPT-PEND-OFF-ORD-DT1      
ACT360     ELSE                                                         
ACT360        MOVE PR-PEND-OFF-ORD-DT    TO P-RPT-PEND-OFF-ORD-DT1      
ACT360     END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6251-GET-FJC01-DATE                                                    
      ******************************************************************        
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      ** 7000-GET-MIN-MAX-REV-MONTH.                                            
      ******************************************************************        
      *                                                                         
       7000-GET-MIN-MAX-REV-MONTH.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(REVENUE_MONTH)                                 
                    ,MIN(REVENUE_MONTH)                                 
                INTO :WS-MAX-REV-MONTH                                  
                    ,:WS-MIN-REV-MONTH                                  
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
               WHERE  DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                   
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*             ,MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :WS-MAX-REV-MONTH                                          
MFA-TR*             ,:WS-MIN-REV-MONTH                                          
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*        WHERE  DATE_EXTRACT = :WS-DATE-EXTRACT                           
MFA-TR*         WITH  UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP020 ABORT ******'                  
              DISPLAY '**  7000-GET-MIN-MAX-REV-MONTH **'               
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  DATE_EXTRACT        = ' WS-DATE-EXTRACT      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7050-GET-MAX-CYCL-REV-MONTH.                                           
      ******************************************************************        
      *                                                                         
       7050-GET-MAX-CYCL-REV-MONTH.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  MAX(BILL_CYCLE)                                   
                INTO :BN-BILL-CYCLE :WS-NULL-IND1                        
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
               WHERE  DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                  
                 AND  BILL_CYCLE   <> '21'                              
                 AND  REVENUE_MONTH = :BN-REVENUE-MONTH                 
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(BILL_CYCLE)                                           
MFA-TR*         INTO :BN-BILL-CYCLE:WS-NULL-IND1                                
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*        WHERE  DATE_EXTRACT  = :WS-DATE-EXTRACT                          
MFA-TR*          AND  BILL_CYCLE   <> '21'                                      
MFA-TR*          AND  REVENUE_MONTH = :BN-REVENUE-MONTH                         
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO  7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP020 ABORT ******'                  
              DISPLAY '**  7050-GET-MAX-CYCL-REV-MONTH **'              
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  DATE_EXTRACT        = ' WS-DATE-EXTRACT      
              DISPLAY '**  REVENUE MONTH       = ' BN-REVENUE-MONTH     
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-GET-DATE-RANGE.                                                   
      ******************************************************************        
      *                                                                         
       7100-GET-DATE-RANGE.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT (DATEADD( DAY, -7, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ))                            
                    ,(DATEADD( DAY, 14, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ))                           
                INTO :WS-MIN7-DATE                                      
                    ,:WS-PL14-DATE                                      
                FROM  CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT (CURRENT DATE - 7 DAYS)                                    
MFA-TR*             ,(CURRENT DATE + 14 DAYS)                                   
MFA-TR*         INTO :WS-MIN7-DATE                                              
MFA-TR*             ,:WS-PL14-DATE                                              
MFA-TR*         FROM  CSS_MODEL_SQL                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP020 ABORT ******'                  
              DISPLAY '**  7100-GET-DATE-RANGE **'                      
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7150-GET-COMPANY-NAME                                                  
      ******************************************************************        
      *                                                                         
       7150-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO = :WS-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*     QUERYNO 7150                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP020 ABORT ******'                  
              DISPLAY '**  7150-GET-COMPANY-NAME   **'                  
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  COMPANY NO          = ' WS-COMPANY-NO        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-CHECK-REMOVED-METER                                               
      ******************************************************************        
      *                                                                         
       7200-CHECK-REMOVED-METER.                                        
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-MTR-REMOVED                                     
               FROM CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                   
                  , CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
              WHERE BI.ACCOUNT_NO = :AT-ACCOUNT-NO                      
                AND BI.DATE_BILLED IS NOT NULL                          
                AND BI.BILL_NO = (SELECT MAX(BI1.BILL_NO)               
                                 FROM CSS_BILLING_HDR BI1
                           WITH(READUNCOMMITTED)               
                                 WHERE BI1.ACCOUNT_NO = BI.ACCOUNT_NO   
                                 AND   BI1.DATE_BILLED IS NOT NULL)     
                AND NOT EXISTS (SELECT 1                                
                               FROM CSS_BILLING_DET BG
                           WITH(READUNCOMMITTED)                  
                               WHERE BG.ACCOUNT_NO = BI.ACCOUNT_NO      
                               AND   BG.BILL_NO    = BI.BILL_NO)        
                AND BI.ACCOUNT_NO          = MN.ACCOUNT_NO              
                AND MN.CODE_METER_STATUS  <> 'A'                        
                AND MN.LAST_REG_READ_DATE <= (DATEADD( DAY, -45, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-MTR-REMOVED                                             
MFA-TR*        FROM CSS_BILLING_HDR  BI                                         
MFA-TR*           , CSS_MTRD_ENVRNMT MN                                         
MFA-TR*       WHERE BI.ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         AND BI.DATE_BILLED IS NOT NULL                                  
MFA-TR*         AND BI.BILL_NO = (SELECT MAX(BI1.BILL_NO)                       
MFA-TR*                          FROM CSS_BILLING_HDR BI1                       
MFA-TR*                          WHERE BI1.ACCOUNT_NO = BI.ACCOUNT_NO           
MFA-TR*                          AND   BI1.DATE_BILLED IS NOT NULL)             
MFA-TR*         AND NOT EXISTS (SELECT 1                                        
MFA-TR*                        FROM CSS_BILLING_DET BG                          
MFA-TR*                        WHERE BG.ACCOUNT_NO = BI.ACCOUNT_NO              
MFA-TR*                        AND   BG.BILL_NO    = BI.BILL_NO)                
MFA-TR*         AND BI.ACCOUNT_NO          = MN.ACCOUNT_NO                      
MFA-TR*         AND MN.CODE_METER_STATUS  <> 'A'                                
MFA-TR*         AND MN.LAST_REG_READ_DATE <= (CURRENT DATE - 45 DAYS)           
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7200                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP020   ABORT ******'                
              DISPLAY '**  7200-CHECK-REMOVED-METER **'                 
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  ACCOUNT NO          = ' AT-ACCOUNT-NO        
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7250-OPEN-GETREC-CURSOR                                                
      ******************************************************************        
      *                                                                         
       7250-OPEN-GETREC-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN GETREC                                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PPCSRP020  ABORT ******'                
              DISPLAY '**  7250-OPEN-GETREC-CURSOR **'                  
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7300-FETCH-GETREC-CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7300-FETCH-GETREC-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH GETREC  INTO                                        
                    :AT-ACCOUNT-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-MST-SUB-ACCT-IND                                
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-COMPANY-NO                                      
                   ,:AT-REV-MTH-LST-NRML                                
                   ,:AT-ACCT-CREATE-DT                                  
ACT360             ,:PR-PEND-OFF-ORD-DT :WS-NULL-IND2                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT ******'                  
              DISPLAY '**  7300-FETCH-GETREC-CURSOR**'                  
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  MINIMUM BILL CYCLE    = ' WS-MIN-CYCLE       
              DISPLAY '**  MINIMUM REVENUE MONTH = ' WS-MIN-REV-MONTH   
              DISPLAY '**  BILL CYCLE1           = ' WS-BILL-CYCLE1     
              DISPLAY '**  MAXIMUM REVENUE MONTH = ' WS-MAX-REV-MONTH-C 
              DISPLAY '**  BILL CYCLE1           = ' WS-BILL-CYCLE1     
              DISPLAY '**  PREV REVENUE MONTH    = ' WS-PREV-REV-MONTH  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7350-CLOSE-GETREC-CURSOR                                               
      ******************************************************************        
      *                                                                         
       7350-CLOSE-GETREC-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE GETREC                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP020   ABORT *****'                 
              DISPLAY '**  7350-CLOSEGETREC-CURSOR***'                  
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-CHECK-WQ-TABLE                                                    
      ******************************************************************        
      *                                                                         
       7400-CHECK-WQ-TABLE.                                             
      *                                                                         
           MOVE SPACES                   TO WS-WQ-ITEM-LIT              
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) STATUS                                             
               INTO :WS-WQ-ITEM                                         
               FROM  CSS_WQ_ITEMS WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND STATUS IN ('A','I')                                
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STATUS                                                     
MFA-TR*        INTO :WS-WQ-ITEM                                                 
MFA-TR*        FROM  CSS_WQ_ITEMS                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND STATUS IN ('A','I')                                        
MFA-TR*         WITH UR                                                         
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                TO WS-WQ-ITEM-LIT              
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP020   ABORT ******'                
              DISPLAY '**  7400-CHECK-WQ-TABLE   ***'                   
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  ACCOUNT NO          = ' AT-ACCOUNT-NO        
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           COMPUTE WS-LINE-COUNT-PSNC = WS-LINE-COUNT-PSNC + 1.         
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT331-RECORD.                                         
           COMPUTE WS-LINE-COUNT-SCEG = WS-LINE-COUNT-SCEG + 1.         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           COMPUTE WS-LINE-COUNT-SCEG = WS-LINE-COUNT-SCEG + 1.         
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 3 LINES.                 
           COMPUTE WS-LINE-COUNT-SCEG = WS-LINE-COUNT-SCEG + 1.         
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8400-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8400-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           COMPUTE WS-LINE-COUNT-PSNC = WS-LINE-COUNT-PSNC + 1.         
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8500-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8500-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           COMPUTE WS-LINE-COUNT-PSNC = WS-LINE-COUNT-PSNC + 1.         
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8600-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8600-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           COMPUTE WS-LINE-COUNT-PSNC = WS-LINE-COUNT-PSNC + 1.         
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 8700-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8700-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT331-RECORD AFTER ADVANCING 2 LINES.                 
           COMPUTE WS-LINE-COUNT-SCEG = WS-LINE-COUNT-SCEG + 1.         
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
