       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP019.                                      
COB303 DATE-WRITTEN.     AUG 14, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- THIS PROGRAM PRINTS NEW CUSTOMER LISTING BY RATE AND CLASS.--*        
      *-- READS A FILE CREATED IN 50160 CONTAINING NEW CUSTOMERS WITH--*        
      *-- ORDER TYPE OF '00', '02', '04', '06'.                      --*        
      *-- WRITE INTO 6 COLOR FILES                                   --*        
      *-- GREEN  FILE: DETIALS OF RESIDENTIAL ELEC AND GAS CUSTOMERS.--*        
      *-- BLUE   FILE: DETAILS OF RESIDENTIAL ELECTRIC CUSTOMERS.    --*        
      *-- RED    FILE: DETAILS OF RESIDENTIAL GAS CUSTOMERS.         --*        
      *-- ORANGE FILE: DETIALS OF COMMERCIAL ELEC AND GAS CUSTOMERS. --*        
      *-- BLACK  FILE: DETAILS OF COMMERCIAL ELECTRIC CUSTOMERS.     --*        
      *-- BROWN  FILE: DETAILS OF COMMERCIAL GAS CUSTOMERS.          --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  08/14/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT015*--                            CSR019 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *COPY CSSRT19.                                                            
      ******************************************************************        
      * CSSRT19 - SELECT STATEMENT FOR A 260 INPUT FILE                *        
      ******************************************************************        
           SELECT FCSRT19-FILE                                          
               ASSIGN UT-S-FCSRT19                                      
               FILE STATUS IS WS-FCS19-STATUS.                          
      *                                                                         
       COPY CSSPT331.                                                           
      *                                                                         
      ******************************************************************        
      * CSSRTBU - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTBU-FILE                                          
               ASSIGN UT-S-FILEBLUE.                                    
      *                                                                         
      ******************************************************************        
      * CSSRTRD - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTRD-FILE                                          
               ASSIGN UT-S-FILERED.                                     
      *                                                                         
      ******************************************************************        
      * CSSRTGR - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTGR-FILE                                          
               ASSIGN UT-S-FILGREEN.                                    
      *                                                                         
      ******************************************************************        
      * CSSRTBL - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTBL-FILE                                          
               ASSIGN UT-S-FILBLACK.                                    
      *                                                                         
      ******************************************************************        
      * CSSRTBR - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTBR-FILE                                          
               ASSIGN UT-S-FILBROWN.                                    
      *                                                                         
      ******************************************************************        
      * CSSRTOR - SELECT STATEMENT FOR A 50 CHAR/RECORD PRINT FILE     *        
      ******************************************************************        
           SELECT FCSRTOR-FILE                                          
               ASSIGN UT-S-FIORANGE.                                    
      *                                                                         
      ******************************************************************        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      ** CFDRT19 - FILE DESCRIPTION FOR THE FILE FIORT19           **           
      ***************************************************************           
       FD  FCSRT19-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
       01  FIORT19-RECORD.                                              
           05 CUST-NUMBER                    PIC 9(10) VALUE ZEROES.    
           05 CUST-NAME                      PIC X(50) VALUE SPACES.    
           05 CUST-NAMEO                     PIC X(22) VALUE SPACES.    
           05 CUST-ADDRESS                   PIC X(50) VALUE SPACES.    
           05 CUST-ADDRESSO                  PIC X(26) VALUE SPACES.    
           05 CUST-TOWN                      PIC X(41) VALUE SPACES.    
           05 CUST-ACCT-NUM                  PIC 9(13) VALUE ZEROES.    
           05 CUST-BILDATE                   PIC X(04) VALUE SPACES.    
           05 CUST-CLASS.                                               
              10 CUST-CLS-VR1                PIC X(01) VALUE SPACES.    
              10 CUST-CLS-TYP                PIC X(01) VALUE SPACES.    
              10 CUST-CLS-VR3                PIC X(01) VALUE SPACES.    
           05 CUST-RATE                      PIC X(03) VALUE SPACES.    
           05 CUST-CLASS2.                                              
              10 CUST-CLS2-VR1               PIC X(01) VALUE SPACES.    
              10 CUST-CLS-TYP2               PIC X(01) VALUE SPACES.    
              10 CUST-CLS2-VR3               PIC X(01) VALUE SPACES.    
           05 CUST-RATE2                     PIC X(03) VALUE SPACES.    
           05 CUST-CLASS3.                                              
              10 CUST-CLS3-VR1               PIC X(01) VALUE SPACES.    
              10 CUST-CLS-TYP3               PIC X(01) VALUE SPACES.    
              10 CUST-CLS3-VR3               PIC X(01) VALUE SPACES.    
           05 CUST-RATE3                     PIC X(03) VALUE SPACES.    
           05 CUST-DISTRICT                  PIC X(02) VALUE SPACES.    
           05 CUST-CYCLE                     PIC X(02) VALUE SPACES.    
           05 CUST-LOC-OFFICE                PIC X(03) VALUE SPACES.    
           05 CUST-DEPOSIT                   PIC 9(11)V9(02) VALUE ZERO.
           05 CUST-COMPANY-NO                PIC X(02) VALUE SPACES.    
           05 CUST-F4                        PIC X(04) VALUE SPACES.    
       COPY CFDPT331.                                                           
      ******************************************************************        
      * CFDRTBU - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTBU-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FILEBLUE-RECORD.                                             
           05  FILEBLUE-DATA             PIC X(50).                     
      ******************************************************************        
      * CFDRTRD - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTRD-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FILERED-RECORD.                                              
           05  FILERED-DATA             PIC X(50).                      
      ******************************************************************        
      * CFDRTGR - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTGR-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FILGREEN-RECORD.                                             
           05  FILGREEN-DATA             PIC X(50).                     
      ******************************************************************        
      * CFDRTBL - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTBL-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FILBLACK-RECORD.                                             
           05  FILBLACK-DATA             PIC X(50).                     
      ******************************************************************        
      * CFDRTBR - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTBR-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FILBROWN-RECORD.                                             
           05  FILBROWN-DATA             PIC X(50).                     
      ******************************************************************        
      * CFDRTOR - FD STATEMENT FOR A 50 CHAR                           *        
      ******************************************************************        
       FD  FCSRTOR-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIORANGE-RECORD.                                             
           05  FIORANGE-DATA             PIC X(50).                     
      ******************************************************************        
      *                                                                         
       WORKING-STORAGE SECTION.                                         
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP019'.     
           05 WS-INIT-FLAG              PIC X(01) VALUE 'Y'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-PREV-COMP-NO           PIC X(02) VALUE SPACES.         
           05 WS-CUST-NAME              PIC X(50) VALUE SPACES.         
           05 WS-CUST-ADDRESS           PIC X(50) VALUE SPACES.         
           05 WS-CUST-ADDRESSO          PIC X(26) VALUE SPACES.         
           05 WS-CUST-TOWN              PIC X(41) VALUE SPACES.         
           05 WS-PRT-CLASS              PIC X(03) VALUE SPACES.         
           05 WS-PRT-CLASS2             PIC X(03) VALUE SPACES.         
           05 WS-PRT-HEADING            PIC X(28) VALUE SPACES.         
           05 WS-OLD-CUST-NO            PIC 9(10) VALUE ZEROES.         
           05 WS-PRT-RATES.                                             
              10 WS-PRT-RATE            PIC X(03) VALUE SPACES.         
              10 WS-PRT-RATE2           PIC X(03) VALUE SPACES.         
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA331-STATUS         PIC X(02) VALUE SPACES.         
           05  WS-FCS19-STATUS          PIC X(02) VALUE '00'.           
               88 FCS19-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
           05 FIRST-TIME-SW             PIC X(01) VALUE 'Y'.            
           05 WS-RES-ELEC               PIC X(01) VALUE 'N'.            
           05 WS-RES-GAS                PIC X(01) VALUE 'N'.            
           05 WS-RES-ELEC-GAS           PIC X(01) VALUE 'N'.            
           05 WS-COMM-ELEC              PIC X(01) VALUE 'N'.            
           05 WS-COMM-GAS               PIC X(01) VALUE 'N'.            
           05 WS-COMM-ELEC-GAS          PIC X(01) VALUE 'N'.            
      *                                                                         
      ***************** PCSRP019 REPORT HEADERS ***********************         
      *                                                                         
      **************REPORT FOR MAILING LABELS***************************        
       01 WS-MAILING-LABELS.                                            
           05 WS-LINE1.                                                 
              10 WS-MARK                PIC X(01) VALUE '-'.            
              10 WS-PRT-CLS-TYP         PIC X(01) VALUE SPACES.         
              10 FILLER                 PIC X(07) VALUE SPACES.         
              10 WS-PRT-RATE-M          PIC X(03) VALUE SPACES.         
              10 WS-SLASH               PIC X(01) VALUE '/'.            
              10 WS-PRT-RATE2-M         PIC X(03) VALUE SPACES.         
           05 WS-CUST-NAME-M            PIC X(50) VALUE SPACES.         
           05 WS-CUST-ADDRESSO-M        PIC X(26) VALUE SPACES.         
           05 WS-CUST-ADDRESS-M         PIC X(50) VALUE SPACES.         
           05 WS-CUST-TOWN-M            PIC X(41) VALUE SPACES.         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT FCSRT19-FILE.                                     
           OPEN OUTPUT FCSPT331-FILE.                                   
           OPEN OUTPUT FCSRTBU-FILE.                                    
           OPEN OUTPUT FCSRTRD-FILE.                                    
           OPEN OUTPUT FCSRTGR-FILE.                                    
           OPEN OUTPUT FCSRTBL-FILE.                                    
           OPEN OUTPUT FCSRTBR-FILE.                                    
           OPEN OUTPUT FCSRTOR-FILE.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7200-READ-FCSRT19                THRU 7200-EXIT.     
           PERFORM 2000-PROCESS-DTLS                THRU 2000-EXIT      
             UNTIL END-OF-REC.                                          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS                                            **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           IF WS-INIT-FLAG EQUAL WS-YES OR                              
              WS-PREV-COMP-NO NOT EQUAL CUST-COMPANY-NO                 
              MOVE WS-NO                  TO WS-INIT-FLAG               
              MOVE CUST-COMPANY-NO        TO WS-PREV-COMP-NO            
           END-IF.                                                      
           IF FIRST-TIME-SW EQUAL WS-YES                                
              MOVE '0'                    TO WS-PRT-CLS-TYP             
              MOVE '000'                  TO WS-PRT-CLASS               
              MOVE '000'                  TO WS-PRT-CLASS2              
              MOVE '   '                  TO WS-PRT-RATES               
              MOVE 'XXXXXXXX'             TO WS-CUST-NAME               
                                             WS-CUST-NAME-M             
              MOVE 'XXXXXXXX'             TO WS-CUST-ADDRESS            
                                             WS-CUST-ADDRESS-M          
              MOVE 'XXXXXXXX'             TO WS-CUST-ADDRESSO           
                                             WS-CUST-ADDRESSO-M         
              MOVE 'XXXXXXXX'             TO WS-CUST-TOWN               
                                             WS-CUST-TOWN-M             
              PERFORM 2910-WRITE-MAIL-LABEL         THRU 2910-EXIT      
              MOVE WS-NO                  TO FIRST-TIME-SW              
           END-IF.                                                      
                                                                        
           MOVE  CUST-NAME                TO WS-CUST-NAME.              
           MOVE  CUST-ADDRESS             TO WS-CUST-ADDRESS            
                                             WS-CUST-ADDRESS-M.         
           MOVE  CUST-ADDRESSO            TO WS-CUST-ADDRESSO.          
           MOVE  CUST-TOWN                TO WS-CUST-TOWN.              
                                                                        
      *BGBG01                                                                   
           DISPLAY ' ' CUST-NAME ' ' CUST-ACCT-NUM                      
           DISPLAY ' ' CUST-CLS-TYP ' ' CUST-RATE ' ' CUST-RATE2        
           DISPLAY ' ' CUST-CLASS ' ' CUST-CLASS2 ' ' CUST-CLASS3       
                   ' ' CUST-CLS-TYP3                                    
      *BGBG01                                                                   
           MOVE '0'                       TO WS-PRT-CLS-TYP.            
           MOVE '000'                     TO WS-PRT-CLASS.              
           MOVE '000'                     TO WS-PRT-CLASS2.             
           MOVE '   '                     TO WS-PRT-RATES.              
           MOVE CUST-CLASS                TO WS-PRT-CLASS.              
           MOVE CUST-RATE                 TO WS-PRT-RATE.               
           MOVE CUST-CLASS2               TO WS-PRT-CLASS2.             
           MOVE CUST-RATE2                TO WS-PRT-RATE2               
                                             WS-PRT-RATE2-M.            
           IF CUST-CLS-TYP = '2'                                        
      *      'COMMERCIAL ELECTRIC AND GAS CUSTOMERS'                            
              MOVE '2'                    TO WS-PRT-CLS-TYP             
           ELSE                                                         
             IF CUST-CLS-TYP = '1'                                      
      *         'RESIDENTIAL ELECTRIC AND GAS CUSTOMERS'                        
                MOVE '1'  TO WS-PRT-CLS-TYP                             
             END-IF                                                     
           END-IF.                                                      
           IF CUST-CLS-TYP2 = '2'                                       
      *       'COMMERCIAL GAS CUSTOMERS'                                        
              MOVE '2'                    TO WS-PRT-CLS-TYP             
           ELSE                                                         
              IF CUST-CLS-TYP2 = '1'                                    
      *          'RESIDENTIAL GAS CUSTOMERS'                                    
                 MOVE '1'                 TO WS-PRT-CLS-TYP             
              END-IF                                                    
           END-IF.                                                      
           IF CUST-CLASS <= '000'                                       
              IF CUST-CLASS2 <= '000'                                   
                 IF CUST-CLASS3 > '000'                                 
                    MOVE CUST-CLASS3      TO WS-PRT-CLASS2              
                    MOVE CUST-RATE3       TO WS-PRT-RATE2               
                                             WS-PRT-RATE2-M             
                    IF CUST-CLS-TYP3 = '2'                              
      *                'COMMERCIAL PVT LIGHT CUSTOMERS'                         
                       MOVE '2'           TO WS-PRT-CLS-TYP             
                    ELSE                                                
      *                'RESIDENTIAL PVT LIGHT CUSTOMERS'                        
                       MOVE '1'           TO WS-PRT-CLS-TYP             
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *T24090 - WRITE OUT 4 RECORDS FOR EACH SPECIFIC FILE CHECK - BEGIN        
      *SWITCH FOR WS-RES-ELEC                                                   
           IF WS-PRT-CLS-TYP  EQUAL '1'                                 
              IF CUST-RATE > SPACES                                     
                 IF CUST-RATE2 EQUAL SPACES                             
                   IF WS-RES-ELEC NOT EQUAL WS-YES                      
                      MOVE WS-YES         TO WS-RES-ELEC                
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-RES-GAS                                                    
           IF WS-PRT-CLS-TYP EQUAL '1'                                  
              IF CUST-RATE EQUAL SPACES                                 
                 IF CUST-RATE2 > SPACES                                 
                    IF WS-RES-GAS NOT EQUAL WS-YES                      
                       MOVE WS-YES        TO WS-RES-GAS                 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-RES-ELEC-GAS                                               
           IF WS-PRT-CLS-TYP EQUAL '1'                                  
              IF CUST-RATE > SPACES                                     
                 IF CUST-RATE2 > SPACES                                 
                    IF WS-RES-ELEC-GAS NOT EQUAL WS-YES                 
                       MOVE WS-YES        TO WS-RES-ELEC-GAS            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-COMM-ELEC                                                  
           IF WS-PRT-CLS-TYP EQUAL '2'                                  
              IF CUST-RATE > SPACES                                     
                 IF CUST-RATE2 EQUAL SPACES                             
                    IF WS-COMM-ELEC NOT EQUAL WS-YES                    
                       MOVE WS-YES        TO WS-COMM-ELEC               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-COMM-GAS                                                   
           IF WS-PRT-CLS-TYP EQUAL '2'                                  
              IF CUST-RATE EQUAL SPACES                                 
                 IF CUST-RATE2 > SPACES                                 
                    IF WS-COMM-GAS NOT EQUAL WS-YES                     
                       MOVE WS-YES        TO WS-COMM-GAS                
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-COMM-ELEC-GAS                                              
           IF WS-PRT-CLS-TYP  EQUAL '2'                                 
              IF CUST-RATE > SPACES                                     
                 IF CUST-RATE2 > SPACES                                 
                    IF WS-COMM-ELEC-GAS NOT EQUAL WS-YES                
                       MOVE WS-YES        TO WS-COMM-ELEC-GAS           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *SWITCH FOR WS-COMM-GAS/WS-RES-GAS                                        
           IF CUST-CLASS <= '000'                                       
              IF CUST-CLASS2 <= '000'                                   
                 IF CUST-CLASS3 > '000'                                 
                    IF CUST-CLS-TYP3 = '2'                              
                       MOVE '2'           TO WS-PRT-CLS-TYP             
                       IF WS-COMM-GAS NOT EQUAL WS-YES                  
                          MOVE WS-YES     TO WS-COMM-GAS                
                       END-IF                                           
                    ELSE                                                
                       MOVE '1'           TO WS-PRT-CLS-TYP             
                       IF WS-RES-GAS NOT EQUAL WS-YES                   
                          MOVE WS-YES     TO WS-RES-GAS                 
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *BASED ON THE SWITCH WRITE INTO DIFF FILES                                
           IF WS-RES-ELEC-GAS EQUAL WS-YES                              
              PERFORM 2100-PROCESS-GREEN-FILE       THRU 2100-EXIT      
           ELSE                                                         
              IF WS-RES-ELEC EQUAL WS-YES                               
                 PERFORM 2200-PROCESS-BLUE-FILE     THRU 2200-EXIT      
              END-IF                                                    
              IF WS-RES-GAS EQUAL WS-YES                                
                 PERFORM 2300-PROCESS-RED-FILE      THRU 2300-EXIT      
              END-IF                                                    
           END-IF.                                                      
           IF WS-COMM-ELEC-GAS EQUAL WS-YES                             
              PERFORM 2400-PROCESS-ORANGE-FILE      THRU 2400-EXIT      
           ELSE                                                         
              IF WS-COMM-ELEC EQUAL WS-YES                              
                 PERFORM 2500-PROCESS-BLACK-FILE    THRU 2500-EXIT      
              END-IF                                                    
              IF WS-COMM-GAS EQUAL WS-YES                               
                 PERFORM 2600-PROCESS-BROWN-FILE    THRU 2600-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *T24090 END                                                               
           PERFORM 2910-WRITE-MAIL-LABEL            THRU 2910-EXIT.     
           MOVE WS-NO                     TO WS-RES-ELEC-GAS            
                                             WS-RES-ELEC                
                                             WS-RES-GAS                 
                                             WS-COMM-ELEC-GAS           
                                             WS-COMM-ELEC               
                                             WS-COMM-GAS.               
      *                                                                         
           PERFORM 7200-READ-FCSRT19                THRU 7200-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-GREEN-FILE                                      **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-GREEN-FILE.                                         
      *                                                                         
           MOVE SPACES                    TO FILGREEN-DATA.             
           MOVE WS-CUST-NAME              TO FILGREEN-DATA.             
           PERFORM 8400-WRITE-GREEN-FILE            THRU 8400-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES                 TO FILGREEN-DATA              
              MOVE WS-CUST-ADDRESSO       TO FILGREEN-DATA              
              PERFORM 8400-WRITE-GREEN-FILE         THRU 8400-EXIT      
           END-IF.                                                      
           MOVE SPACES                    TO FILGREEN-DATA.             
           MOVE WS-CUST-ADDRESS           TO FILGREEN-DATA.             
           PERFORM 8400-WRITE-GREEN-FILE            THRU 8400-EXIT.     
           MOVE SPACES                    TO FILGREEN-DATA.             
           MOVE WS-CUST-TOWN              TO FILGREEN-DATA.             
           PERFORM 8400-WRITE-GREEN-FILE            THRU 8400-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
              MOVE SPACES                 TO FILGREEN-DATA              
              PERFORM 8400-WRITE-GREEN-FILE         THRU 8400-EXIT      
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-BLUE-FILE                                       **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-BLUE-FILE.                                          
      *                                                                         
           MOVE SPACES                    TO FILEBLUE-DATA.             
           MOVE WS-CUST-NAME              TO FILEBLUE-DATA.             
           PERFORM 8500-WRITE-BLUE-FILE             THRU 8500-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES                 TO FILEBLUE-DATA              
              MOVE WS-CUST-ADDRESSO       TO FILEBLUE-DATA              
              PERFORM 8500-WRITE-BLUE-FILE          THRU 8500-EXIT      
           END-IF.                                                      
           MOVE SPACES                    TO FILEBLUE-DATA.             
           MOVE WS-CUST-ADDRESS           TO FILEBLUE-DATA.             
           PERFORM 8500-WRITE-BLUE-FILE             THRU 8500-EXIT.     
           MOVE SPACES                    TO FILEBLUE-DATA.             
           MOVE WS-CUST-TOWN              TO FILEBLUE-DATA.             
           PERFORM 8500-WRITE-BLUE-FILE             THRU 8500-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
               MOVE SPACES TO FILEBLUE-DATA                             
               PERFORM 8500-WRITE-BLUE-FILE         THRU 8500-EXIT      
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-PROCESS-RED-FILE.                                       **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-RED-FILE.                                           
      *                                                                         
           MOVE SPACES                    TO FILERED-DATA.              
           MOVE WS-CUST-NAME              TO FILERED-DATA.              
           PERFORM 8600-WRITE-RED-FILE              THRU 8600-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES                 TO FILERED-DATA               
              MOVE WS-CUST-ADDRESSO       TO FILERED-DATA               
              PERFORM 8600-WRITE-RED-FILE           THRU 8600-EXIT      
           END-IF.                                                      
           MOVE SPACES                    TO FILERED-DATA.              
           MOVE WS-CUST-ADDRESS           TO FILERED-DATA.              
           PERFORM 8600-WRITE-RED-FILE              THRU 8600-EXIT.     
           MOVE SPACES                    TO FILERED-DATA.              
           MOVE WS-CUST-TOWN              TO FILERED-DATA.              
           PERFORM 8600-WRITE-RED-FILE              THRU 8600-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
              MOVE SPACES                 TO FILERED-DATA               
              PERFORM 8600-WRITE-RED-FILE           THRU 8600-EXIT      
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-PROCESS-ORANGE-FILE                                     **        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-ORANGE-FILE.                                        
      *                                                                         
           MOVE SPACES                    TO FIORANGE-DATA.             
           MOVE WS-CUST-NAME              TO FIORANGE-DATA.             
           PERFORM 8700-WRITE-ORANGE-FILE           THRU 8700-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES                 TO FIORANGE-DATA              
              MOVE WS-CUST-ADDRESSO       TO FIORANGE-DATA              
              PERFORM 8700-WRITE-ORANGE-FILE        THRU 8700-EXIT      
           END-IF.                                                      
           MOVE SPACES                    TO FIORANGE-DATA.             
           MOVE WS-CUST-ADDRESS           TO FIORANGE-DATA.             
           PERFORM 8700-WRITE-ORANGE-FILE           THRU 8700-EXIT.     
           MOVE SPACES                    TO FIORANGE-DATA.             
           MOVE WS-CUST-TOWN              TO FIORANGE-DATA.             
           PERFORM 8700-WRITE-ORANGE-FILE           THRU 8700-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
              MOVE SPACES                 TO FIORANGE-DATA              
              PERFORM 8700-WRITE-ORANGE-FILE        THRU 8700-EXIT      
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-PROCESS-BLACK-FILE.                                     **        
      ******************************************************************        
      *                                                                         
       2500-PROCESS-BLACK-FILE.                                         
      *                                                                         
           MOVE SPACES                    TO FILBLACK-DATA.             
           MOVE WS-CUST-NAME              TO FILBLACK-DATA.             
           PERFORM 8800-WRITE-BLACK-FILE            THRU 8800-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES                 TO FILBLACK-DATA              
              MOVE WS-CUST-ADDRESSO       TO FILBLACK-DATA              
              PERFORM 8800-WRITE-BLACK-FILE         THRU 8800-EXIT      
           END-IF.                                                      
           MOVE SPACES                    TO FILBLACK-DATA.             
           MOVE WS-CUST-ADDRESS           TO FILBLACK-DATA.             
           PERFORM 8800-WRITE-BLACK-FILE            THRU 8800-EXIT.     
           MOVE SPACES                    TO FILBLACK-DATA.             
           MOVE WS-CUST-TOWN              TO FILBLACK-DATA.             
           PERFORM 8800-WRITE-BLACK-FILE            THRU 8800-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
              MOVE SPACES                 TO FILBLACK-DATA              
              PERFORM 8800-WRITE-BLACK-FILE         THRU 8800-EXIT      
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2600-PROCESS-BROWN-FILE                                      **        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-BROWN-FILE.                                         
      *                                                                         
           MOVE SPACES                    TO FILBROWN-DATA.             
           MOVE WS-CUST-NAME              TO FILBROWN-DATA.             
           PERFORM 8900-WRITE-BROWN-FILE            THRU 8900-EXIT.     
           IF WS-CUST-ADDRESSO NOT EQUAL SPACES                         
              MOVE SPACES TO FILBROWN-DATA                              
              MOVE WS-CUST-ADDRESSO       TO FILBROWN-DATA              
              PERFORM 8900-WRITE-BROWN-FILE         THRU 8900-EXIT      
           END-IF                                                       
           MOVE SPACES                    TO FILBROWN-DATA.             
           MOVE WS-CUST-ADDRESS           TO FILBROWN-DATA.             
           PERFORM 8900-WRITE-BROWN-FILE            THRU 8900-EXIT.     
           MOVE SPACES                    TO FILBROWN-DATA.             
           MOVE WS-CUST-TOWN              TO FILBROWN-DATA.             
           PERFORM 8900-WRITE-BROWN-FILE            THRU 8900-EXIT.     
           IF WS-CUST-ADDRESSO EQUAL SPACES                             
              MOVE SPACES                 TO FILBROWN-DATA              
              PERFORM 8900-WRITE-BROWN-FILE         THRU 8900-EXIT      
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2910-WRITE-MAIL-LABEL.                                       **        
      ******************************************************************        
      *                                                                         
       2910-WRITE-MAIL-LABEL.                                           
      *                                                                         
           MOVE WS-CUST-NAME              TO WS-CUST-NAME-M.            
           MOVE WS-CUST-TOWN              TO WS-CUST-TOWN-M.            
           MOVE WS-PRT-RATE               TO WS-PRT-RATE-M.             
           MOVE WS-CUST-ADDRESSO          TO WS-CUST-ADDRESSO-M.        
           MOVE WS-LINE1                  TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
           MOVE WS-CUST-NAME-M            TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
           MOVE WS-CUST-ADDRESSO-M        TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
           MOVE WS-CUST-ADDRESS-M         TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
           MOVE WS-CUST-TOWN-M            TO PRT331-RECORD.             
           PERFORM 8110-WRITE-PRT331                THRU 8110-EXIT.     
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSRT19 FILE FOR INPUT                                   *        
      ******************************************************************        
      *                                                                         
       7200-READ-FCSRT19.                                               
      *                                                                         
           READ FCSRT19-FILE                                            
                                                                        
           IF FCS19-SUCCESSFUL  OR  END-OF-REC                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP019 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSRT59 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCS19-STATUS             
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8110-WRITE-PRT331.                                           **        
      ******************************************************************        
      *                                                                         
       8110-WRITE-PRT331.                                               
      *                                                                         
           WRITE PRT331-RECORD.                                         
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8400-WRITE-GREEN-FILE.                                       **        
      ******************************************************************        
      *                                                                         
       8400-WRITE-GREEN-FILE.                                           
      *                                                                         
           WRITE FILGREEN-RECORD.                                       
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8500-WRITE-BLUE-FILE.                                        **        
      ******************************************************************        
      *                                                                         
       8500-WRITE-BLUE-FILE.                                            
      *                                                                         
           WRITE FILEBLUE-RECORD.                                       
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8600-WRITE-RED-FILE.                                         **        
      ******************************************************************        
      *                                                                         
       8600-WRITE-RED-FILE.                                             
      *                                                                         
           WRITE FILERED-RECORD.                                        
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8700-WRITE-ORANGE-FILE.                                      **        
      ******************************************************************        
      *                                                                         
       8700-WRITE-ORANGE-FILE.                                          
      *                                                                         
           WRITE FIORANGE-RECORD.                                       
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8800-WRITE-BLACK-FILE.                                       **        
      ******************************************************************        
      *                                                                         
       8800-WRITE-BLACK-FILE.                                           
      *                                                                         
           WRITE FILBLACK-RECORD.                                       
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8900-WRITE-BROWN-FILE.                                       **        
      ******************************************************************        
      *                                                                         
       8900-WRITE-BROWN-FILE.                                           
      *                                                                         
           WRITE FILBROWN-RECORD.                                       
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRT19-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
           CLOSE FCSRTBU-FILE.                                          
           CLOSE FCSRTRD-FILE.                                          
           CLOSE FCSRTGR-FILE.                                          
           CLOSE FCSRTBL-FILE.                                          
           CLOSE FCSRTBR-FILE.                                          
           CLOSE FCSRTOR-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
