       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP018.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     OCT 07, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***THIS PROGRAM PRINTS A CONSUMPTION COMPARISON REPORT FOR PSNC***        
      ***                                                            ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT024***  07/29/2015    VV7M728     PNC019 CONVERT EZT TO COBOL     ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSBW010-FILE                                         
               ASSIGN TO UT-S-FCSBW010                                  
               FILE STATUS IS WS-FBW010-STATUS.                         
           SELECT FCSBW011-FILE                                         
               ASSIGN TO UT-S-FCSBW011                                  
               FILE STATUS IS WS-FBW011-STATUS.                         
      *                                                                         
       COPY CSSPT331.                                                           
       COPY CSSPT332.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       FD  FCSBW010-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIOBW010-RECORD                      PIC X(105).             
       COPY FIOBW010.                                                           
      *                                                                         
       FD  FCSBW011-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIOBW011-RECORD                      PIC X(105).             
       COPY FIOBW011.                                                           
      *                                                                         
       COPY CFDPT331.                                                           
       COPY CFDPT332.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP018'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSRP018'.     
      *                                                                         
       01 WS-RP019-HDR-REC-LN1.                                         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN1-NAME              PIC X(09) VALUE 'PNC019-01'.    
           05 FILLER                    PIC X(46) VALUE SPACES.         
           05 HDR-LN1-COMPANY-NAME      PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR-LN1-PAGE              PIC X(05) VALUE 'PAGE '.        
           05 HDR-LN1-PAGE-NO           PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN2.                                         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN2-RPT-DT            PIC X(12) VALUE 'REPORT DATE:'. 
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-RPT-DATE          PIC X(06) VALUE SPACES.         
           05 FILLER                    PIC X(18) VALUE SPACES.         
           05 HDR-LN2-MJR-ACCT          PIC X(25)                       
                          VALUE 'FOR MAJOR ACCOUNTS IN +/-'.            
           05 HDR-LN2-PERCENT           PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-CUST-NAME         PIC X(16)                       
                          VALUE 'IN CUSTOMER NAME'.                     
           05 FILLER                    PIC X(31) VALUE SPACES.         
           05 HDR-LN2-RUN-DATE          PIC X(09)                       
                          VALUE 'RUN-DATE:'.                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-SYS-DT            PIC X(08) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN3.                                         
           05 FILLER                    PIC X(114) VALUE SPACES.        
           05 HDR-LN3-RUN-TIME          PIC X(09)                       
                          VALUE 'RUN-TIME:'.                            
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 HDR-LN3-SYS-TIME          PIC X(08)  VALUE SPACES.        
                                                                        
       01 WS-RP019-HDR-REC-LN4.                                         
           05 FILLER                    PIC X(60) VALUE SPACES.         
           05 HDR-LN4-DTL               PIC X(14)                       
                          VALUE 'LOCAL OFFICE: '.                       
           05 HDR-LN4-LOCAL-OFC         PIC X(03) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN5.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN5-ACC-NO            PIC X(14)                       
                          VALUE 'ACCOUNT NUMBER'.                       
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN5-CUST-NAME         PIC X(20)                       
                          VALUE '   CUSTOMER NAME    '.                 
                                                                        
       01 WS-RP019-HDR-REC-LN6.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN6-RATE-CLASS        PIC X(15)                       
                          VALUE 'RATE CLASS  ZIP'.                      
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN6-STATE-TAX         PIC X(20)                       
                          VALUE ' STATE TAX EXMPT NO '.                 
           05 FILLER                    PIC X(28) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN7.                                         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN7-SIC-RANGE         PIC X(15)                       
                          VALUE 'SIC STATUS  AFC'.                      
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN7-SERVICE-ADDR      PIC X(20)                       
                          VALUE '   SERVICE ADDRESS  '.                 
           05 FILLER                    PIC X(16) VALUE SPACES.         
           05 HDR-LN7-PREV-DT           PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 HDR-LN7-CURR-DT           PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 HDR-LN7-VARIANCE          PIC X(08)                       
                          VALUE 'VARIANCE'.                             
                                                                        
       01 WS-RP019-HDR-REC-LN8.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP019-FTR-REC-LN1.                                         
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP019-FTR-REC-LN2.                                         
           05 FILLER                    PIC X(51) VALUE SPACES.         
           05 FTR-LN2-VARIANCE          PIC X(21)                       
                          VALUE '*** END OF REPORT ***'.                
           05 FILLER                    PIC X(51) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN1-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-ACCOUNT-NO            PIC X(16) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CUST-NAME             PIC X(25) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-PRE-USAGE-DKTHRMS     PIC ZZZ,ZZZ,ZZZ-.               
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 OUT-CURR-USAGE-DKTHRMS    PIC ZZZ,ZZZ,ZZZ-.               
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-ACTUAL-VARIANCE       PIC ZZZ,ZZZ,ZZZ-.               
                                                                        
       01 WS-RP019-LN2-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-RATE-PLAN             PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-REV-CLASS             PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-ZIP-CODE              PIC X(05) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-STATE-TAX-EXMPT-NO    PIC X(13) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN3-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CODE-SIC              PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CODE-STAT             PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 OUT-AFC                   PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 OUT-SERV-ADDR             PIC X(25) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN4-REC.                                             
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-LINE-A1               PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A2               PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A3               PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A3               PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A2               PIC X(13)                       
                    VALUE '- - - - - - -'.                              
                                                                        
       01 WS-RP019-HDR-REC-LN01.                                        
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN1-NAME-X            PIC X(09) VALUE 'PNC019-02'.    
           05 FILLER                    PIC X(46) VALUE SPACES.         
           05 HDR-LN1-COMPANY-NAME-X    PIC X(26) VALUE 'PSNC ENERGY'.  
           05 FILLER                    PIC X(38) VALUE SPACES.         
           05 HDR-LN1-PAGE-X            PIC X(05) VALUE 'PAGE '.        
           05 HDR-LN1-PAGE-NO-X         PIC Z(06) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN02.                                        
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN2-RPT-DT-X          PIC X(12) VALUE 'REPORT DATE:'. 
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-RPT-DATE-X        PIC X(06) VALUE SPACES.         
           05 FILLER                    PIC X(18) VALUE SPACES.         
           05 HDR-LN2-MJR-ACCT-X        PIC X(25)                       
                          VALUE 'FOR MAJOR ACCOUNTS IN +/-'.            
           05 HDR-LN2-PERCENT-X         PIC 9(02) VALUE ZEROES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-CUST-NAME-X       PIC X(16)                       
                          VALUE 'IN CUSTOMER NAME'.                     
           05 FILLER                    PIC X(31) VALUE SPACES.         
           05 HDR-LN2-RUN-DATE-X        PIC X(09)                       
                          VALUE 'RUN-DATE:'.                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN2-SYS-DT-X          PIC X(08) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN03.                                        
           05 FILLER                    PIC X(114) VALUE SPACES.        
           05 HDR-LN3-RUN-TIME-X        PIC X(09)                       
                          VALUE 'RUN-TIME:'.                            
           05 FILLER                    PIC X(01)  VALUE SPACES.        
           05 HDR-LN3-SYS-TIME-X        PIC X(08)  VALUE SPACES.        
                                                                        
       01 WS-RP019-HDR-REC-LN04.                                        
           05 FILLER                    PIC X(60) VALUE SPACES.         
           05 HDR-LN4-DTL-X             PIC X(14)                       
                          VALUE 'LOCAL OFFICE: '.                       
           05 HDR-LN4-LOCAL-OFC-X       PIC X(03) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN05.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN5-ACC-NO-X          PIC X(14)                       
                          VALUE 'ACCOUNT NUMBER'.                       
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN5-CUST-NAME-X       PIC X(20)                       
                          VALUE '   CUSTOMER NAME    '.                 
                                                                        
       01 WS-RP019-HDR-REC-LN06.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN6-RATE-CLASS-X      PIC X(15)                       
                          VALUE 'RATE CLASS  ZIP'.                      
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN6-STATE-TAX-X       PIC X(20)                       
                          VALUE ' STATE TAX EXMPT NO '.                 
           05 FILLER                    PIC X(28) VALUE SPACES.         
                                                                        
       01 WS-RP019-HDR-REC-LN07.                                        
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 HDR-LN7-SIC-RANGE-X       PIC X(15)                       
                          VALUE 'SIC STATUS  AFC'.                      
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 HDR-LN7-SERVICE-ADDR-X    PIC X(20)                       
                          VALUE '   SERVICE ADDRESS  '.                 
           05 FILLER                    PIC X(12) VALUE SPACES.         
           05 HDR-LN7-FROM-PREV-DATE-X  PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 HDR-LN7-TO-PREV-DATE-X    PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN7-FROM-CURR-DATE-X  PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 HDR-LN7-TO-CURR-DATE-X    PIC X(07) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 HDR-LN7-VARIANCE-X        PIC X(08)                       
                          VALUE 'VARIANCE'.                             
                                                                        
       01 WS-RP019-HDR-REC-LN08.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
                                                                        
       01 WS-RP019-FTR-REC-LN01.                                        
           05 FILLER                    PIC X(133) VALUE SPACES.        
                                                                        
       01 WS-RP019-FTR-REC-LN02.                                        
           05 FILLER                    PIC X(51) VALUE SPACES.         
           05 FTR-LN02-VARIANCE         PIC X(21)                       
                          VALUE '*** END OF REPORT ***'.                
           05 FILLER                    PIC X(51) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN01-REC.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-ACCOUNT-NO-X          PIC X(16) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CUST-NAME-X           PIC X(25) VALUE SPACES.         
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-PRE-USAGE-DKTHRMS-X   PIC ZZZ,ZZZ,ZZZ-.               
           05 FILLER                    PIC X(06) VALUE SPACES.         
           05 OUT-CURR-USAGE-DKTHRMS-X  PIC ZZZ,ZZZ,ZZZ-.               
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 OUT-ACTUAL-VARIANCE-X     PIC ZZZ,ZZZ,ZZZ-.               
                                                                        
       01 WS-RP019-LN02-REC.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-RATE-PLAN-X           PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-REV-CLASS-X           PIC X(03) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-ZIP-CODE-X            PIC X(05) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE SPACES.         
           05 OUT-STATE-TAX-EXMPT-NO-X  PIC X(13) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN03-REC.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CODE-SIC-X            PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-CODE-STAT-X           PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(07) VALUE SPACES.         
           05 OUT-AFC-X                 PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 OUT-SERV-ADDR-X           PIC X(25) VALUE SPACES.         
                                                                        
       01 WS-RP019-LN04-REC.                                            
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 OUT-LINE-A1-X             PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A2-X             PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A3-X             PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A3-X             PIC X(30)                       
                    VALUE '- - - - - - - - - - - - - - - '.             
           05 OUT-LINE-A2-X             PIC X(13)                       
                    VALUE '- - - - - - -'.                              
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-PARM-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
           05 WS-DATA-FOUND             PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-CHANGE-SWITCH.                                            
           05  WS-VALUE-DIFFER          PIC X(01) VALUE 'N'.            
           05  WS-VALUE-DIFFER-X        PIC X(01) VALUE 'N'.            
           05  WS-FIRST-VALUE           PIC X(01) VALUE 'N'.            
           05  WS-FIRST-VALUE-X         PIC X(01) VALUE 'N'.            
           05  WS-BEGIN-VALUE           PIC X(01) VALUE 'N'.            
           05  WS-BEGIN-VALUE-X         PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-LOCAL-COUNT           PIC 9(04) VALUE ZEROS.          
           05  WS-LOCAL-COUNT-X         PIC 9(04) VALUE ZEROS.          
           05  WS-PAGE-NO               PIC 9(06) VALUE ZEROS.          
           05  WS-PAGE-NO-X             PIC 9(06) VALUE ZEROS.          
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-CT                    PIC 9(01) VALUE ZEROS.          
           05  WS-CT1                   PIC 9(01) VALUE ZEROS.          
           05  WS-ACCOUNT-NO-TEMP       PIC 9(13) VALUE ZEROS.          
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZEROS.          
           05  WS-SAVE-ACCOUNT REDEFINES WS-ACCOUNT-NO.                 
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
           05  WS-REPORT-DATE           PIC X(06) VALUE SPACES.         
           05  WS-CUST-NAME             PIC X(25) VALUE SPACES.         
           05  WS-RATE-PLAN             PIC X(03) VALUE SPACES.         
           05  WS-REV-CLASS             PIC X(03) VALUE SPACES.         
           05  WS-ZIP-CODE              PIC X(05) VALUE SPACES.         
           05  WS-STATE-TAX-EXMPT-NO    PIC X(13) VALUE SPACES.         
           05  WS-LOCAL-OFFICE          PIC X(03) VALUE SPACES.         
           05  WS-LOCAL-OFFICE-X        PIC X(03) VALUE SPACES.         
           05  WS-PREV-LOCAL-OFC        PIC X(03) VALUE SPACES.         
           05  WS-PREV-LOCAL-OFC-X      PIC X(03) VALUE SPACES.         
           05  WS-CODE-SIC              PIC X(04) VALUE SPACES.         
           05  WS-CODE-STAT             PIC X(01) VALUE SPACES.         
           05  WS-AFC                   PIC X(01) VALUE SPACES.         
           05  WS-SERV-ADDR             PIC X(25) VALUE SPACES.         
           05  WS-PERCENTAGE            PIC 9(02) VALUE ZEROES.         
           05  WS-PRE-USAGE-DKTHRMS     PIC 9(10) VALUE ZEROES.         
           05  WS-CURR-USAGE-DKTHRMS    PIC 9(10) VALUE ZEROES.         
           05  WS-ACTUAL-VARIANCE       PIC S9(9) VALUE 0.              
           05  WS-LINE-A                PIC X(66) VALUE SPACES.         
           05  WS-LINE-B                PIC X(66) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
                                                                        
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
                                                                        
       01  WS-PREV-DATE.                                                
           05  WS-PREV-DATE-Y           PIC X(04).                      
           05  WS-PREV-DATE-S           PIC X(01) VALUE '/'.            
           05  WS-PREV-DATE-M           PIC X(02).                      
                                                                        
       01  WS-CURR-DATE.                                                
           05  WS-CURR-DATE-Y           PIC X(04).                      
           05  WS-CURR-DATE-S           PIC X(01) VALUE '/'.            
           05  WS-CURR-DATE-M           PIC X(02).                      
                                                                        
       01  WS-FROM-CURR-DATE.                                           
           05  WS-FROM-CURR-YY          PIC X(04).                      
           05  WS-FROM-CURR-S           PIC X(01) VALUE '/'.            
           05  WS-FROM-CURR-MM          PIC X(02).                      
                                                                        
       01  WS-TO-CURR-DATE.                                             
           05  WS-TO-CURR-YY            PIC X(04).                      
           05  WS-TO-CURR-S             PIC X(01) VALUE '/'.            
           05  WS-TO-CURR-MM            PIC X(02).                      
                                                                        
       01  WS-FROM-PREV-DATE.                                           
           05  WS-FROM-PREV-YY          PIC X(04).                      
           05  WS-FROM-PREV-S           PIC X(01) VALUE '/'.            
           05  WS-FROM-PREV-MM          PIC X(02).                      
                                                                        
       01  WS-TO-PREV-DATE.                                             
           05  WS-TO-PREV-YY            PIC X(04).                      
           05  WS-TO-PREV-S             PIC X(01) VALUE '/'.            
           05  WS-TO-PREV-MM            PIC X(02).                      
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
           05  WS-FCA332-STATUS         PIC X(02).                      
               88 FCA332-SUCCESSFUL               VALUE '00'.           
           05  WS-FBW010-STATUS         PIC X(02) VALUE '00'.           
               88 FBW010-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC1                     VALUE '10'.           
           05  WS-FBW011-STATUS         PIC X(02) VALUE '00'.           
               88 FBW011-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC2                     VALUE '10'.           
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(02).                      
                                                                        
       01  WS-COMMON-DATE.                                              
           05 WS-COMMON-CCYY            PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01).                      
           05 WS-COMMON-MM              PIC X(02) VALUE SPACES.         
      *                                                                         
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-MAIN-CSR            THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO HDR-LN3-SYS-TIME           
                                             HDR-LN3-SYS-TIME-X.        
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
           MOVE WS-CY(3:2)                TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO HDR-LN2-SYS-DT             
                                             HDR-LN2-SYS-DT-X.          
                                                                        
           OPEN INPUT  FCSBW010-FILE.                                   
                                                                        
           IF NOT FBW010-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSBW010-FILE.    **'         
               DISPLAY '**  FILE STATUS = ' WS-FBW010-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN INPUT  FCSBW011-FILE.                                   
                                                                        
           IF NOT FBW011-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR OPENING  FCSBW011-FILE.   **'         
               DISPLAY '**  FILE STATUS = ' WS-FBW011-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
           OPEN OUTPUT FCSPT332-FILE.                                   
                                                                        
           IF NOT FCA332-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR OPENING FCSPT332-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA332-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
      *INITIALIZE THE FILE VARAIABLES AFTER WRITING THE HEADER RECORD           
           INITIALIZE FIOBW010-RECORD                                   
                      FIOBW011-RECORD                                   
                      PRT331-RECORD                                     
                      PRT332-RECORD.                                    
      *                                                                         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-MAIN-CSR.                                          *        
      ******************************************************************        
      *                                                                         
                                                                        
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           IF WS-CT  = 0                                                
              MOVE 1 TO WS-CT                                           
              PERFORM 7100-READ-FCSBW010-FILE       THRU 7100-EXIT      
              PERFORM 2050-REPORT1-DTLS-HDR         THRU 2050-EXIT      
              PERFORM 2100-REPORT1-DTLS             THRU 2100-EXIT      
                 UNTIL END-OF-REC1                                      
              PERFORM 8300-WRITE-OUTFILE1-FTR       THRU 8300-EXIT      
              COMPUTE WS-LOCAL-COUNT = WS-LOCAL-COUNT + 2               
           END-IF.                                                      
      *                                                                         
           IF WS-CT1 = 0                                                
              MOVE 1 TO WS-CT1                                          
              PERFORM 7200-READ-FCSBW011-FILE       THRU 7200-EXIT      
              PERFORM 2150-REPORT2-DTLS-HDR         THRU 2150-EXIT      
              PERFORM 2200-REPORT2-DTLS             THRU 2200-EXIT      
                 UNTIL END-OF-REC2                                      
              PERFORM 8400-WRITE-OUTFILE2-FTR       THRU 8400-EXIT      
              COMPUTE WS-LOCAL-COUNT-X = WS-LOCAL-COUNT-X + 2           
           END-IF.                                                      
      *                                                                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2050-REPORT1-DTLS-HDR.                                       *          
      ****************************************************************          
      *                                                                         
        2050-REPORT1-DTLS-HDR.                                          
                                                                        
           MOVE FIOBW010-RECORD              TO FIOBW010-BEGIN-REC      
           MOVE BW10-REPT-DT-BREC            TO WS-REPORT-DATE          
                                                HDR-LN2-RPT-DATE        
           MOVE BW10-PERCENTAGE-CNSMPTN      TO WS-PERCENTAGE           
                                                HDR-LN2-PERCENT         
           MOVE BW10-PREV-MM                 TO WS-PREV-DATE-M          
           MOVE BW10-PREV-YY                 TO WS-PREV-DATE-Y          
           MOVE WS-PREV-DATE                 TO HDR-LN7-PREV-DT         
           MOVE BW10-CURR-MM                 TO WS-CURR-DATE-M          
           MOVE BW10-CURR-YY                 TO WS-CURR-DATE-Y          
           MOVE WS-CURR-DATE                 TO HDR-LN7-CURR-DT         
           MOVE WS-Y                         TO WS-FIRST-VALUE.         
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2100-REPORT1-DTLS.                                           *          
      ****************************************************************          
      *                                                                         
        2100-REPORT1-DTLS.                                              
                                                                        
           IF WS-FIRST-VALUE = WS-Y                                     
             MOVE WS-N                       TO WS-FIRST-VALUE          
           ELSE                                                         
                                                                        
           IF WS-PREV-LOCAL-OFC NOT = BW10-LOCAL-OFFICE                 
             MOVE WS-Y                       TO WS-VALUE-DIFFER         
           ELSE                                                         
             MOVE WS-N                       TO WS-VALUE-DIFFER         
           END-IF                                                       
                                                                        
           MOVE FIOBW010-RECORD              TO FIOBW010-REC            
           MOVE BW10-ACCOUNT-NO              TO WS-ACCOUNT-NO-TEMP      
           MOVE WS-ACCOUNT-NO-TEMP           TO WS-SAVE-ACCOUNT         
           MOVE WS-SAVE-ACCT1                TO WS-ACCT1                
           MOVE WS-SAVE-ACCT2                TO WS-ACCT2                
           MOVE WS-SAVE-ACCT3                TO WS-ACCT3                
           MOVE WS-SAVE-ACCT4                TO WS-ACCT4                
           MOVE WS-ACCOUNT1                  TO OUT-ACCOUNT-NO          
           MOVE BW10-CUSTOMER-NAME           TO WS-CUST-NAME            
                                                OUT-CUST-NAME           
           MOVE BW10-PREV-MTH-USAGE-DKTHRMS  TO WS-PRE-USAGE-DKTHRMS    
           MOVE WS-PRE-USAGE-DKTHRMS         TO OUT-PRE-USAGE-DKTHRMS   
           MOVE BW10-CURR-MTH-USAGE-DKTHRMS  TO WS-CURR-USAGE-DKTHRMS   
           MOVE WS-CURR-USAGE-DKTHRMS        TO OUT-CURR-USAGE-DKTHRMS  
           MOVE BW10-RATE-PLAN-NO            TO WS-RATE-PLAN            
                                                OUT-RATE-PLAN           
           MOVE BW10-CODE-REV-CLASS          TO WS-REV-CLASS            
                                                OUT-REV-CLASS           
           MOVE BW10-LOCAL-OFFICE            TO WS-LOCAL-OFFICE         
                                                HDR-LN4-LOCAL-OFC       
                                                WS-PREV-LOCAL-OFC       
           MOVE BW10-ZIP-CODE                TO WS-ZIP-CODE             
                                                OUT-ZIP-CODE            
           MOVE BW10-STATE-TAX-EXMPT-NO      TO WS-STATE-TAX-EXMPT-NO   
                                                OUT-STATE-TAX-EXMPT-NO  
           MOVE BW10-CODE-SIC-NO             TO WS-CODE-SIC             
                                                OUT-CODE-SIC            
           MOVE BW10-CODE-ACCT-STAT          TO WS-CODE-STAT            
                                                OUT-CODE-STAT           
           MOVE BW10-MONTHLY-VARIANCE        TO WS-ACTUAL-VARIANCE      
           MOVE WS-ACTUAL-VARIANCE           TO OUT-ACTUAL-VARIANCE     
           MOVE BW10-ALTN-FUEL-CD            TO WS-AFC                  
                                                OUT-AFC                 
           MOVE BW10-SERVICE-ADDRESS         TO WS-SERV-ADDR            
                                                OUT-SERV-ADDR           
                                                                        
           IF WS-LOCAL-COUNT = 52                                       
             MOVE WS-Y                       TO WS-BEGIN-VALUE          
           ELSE                                                         
             MOVE WS-N                       TO WS-BEGIN-VALUE          
           END-IF                                                       
                                                                        
           IF WS-BEGIN-VALUE = WS-Y OR WS-VALUE-DIFFER = WS-Y           
                                                                        
            COMPUTE WS-PAGE-NO     = WS-PAGE-NO     + 1                 
            MOVE WS-PAGE-NO                  TO HDR-LN1-PAGE-NO         
            MOVE 0                           TO WS-LOCAL-COUNT          
                                                                        
            PERFORM 8100-WRITE-OUTFILE1-HDR        THRU  8100-EXIT      
            COMPUTE WS-LOCAL-COUNT = WS-LOCAL-COUNT + 8                 
                                                                        
           END-IF                                                       
                                                                        
           PERFORM 8150-WRITE-OUTFILE1             THRU 8150-EXIT       
           COMPUTE WS-LOCAL-COUNT = WS-LOCAL-COUNT + 4                  
           END-IF                                                       
                                                                        
           PERFORM 7100-READ-FCSBW010-FILE         THRU 7100-EXIT.      
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      * 2150-REPORT2-DTLS-HDR.                                       *          
      ****************************************************************          
      *                                                                         
        2150-REPORT2-DTLS-HDR.                                          
                                                                        
           MOVE FIOBW011-RECORD              TO FIOBW011-BEGIN-REC      
           MOVE BW11-REPT-DT-BREC            TO WS-REPORT-DATE          
                                                HDR-LN2-RPT-DATE-X      
           MOVE BW11-PERCENTAGE-CNSMPTN      TO WS-PERCENTAGE           
                                                HDR-LN2-PERCENT-X       
           MOVE BW11-FROM-CURR-YY            TO WS-FROM-CURR-YY         
           MOVE BW11-FROM-CURR-MM            TO WS-FROM-CURR-MM         
           MOVE BW11-TO-CURR-YY              TO WS-TO-CURR-YY           
           MOVE BW11-TO-CURR-MM              TO WS-TO-CURR-MM           
           MOVE BW11-FROM-PREV-YY            TO WS-FROM-PREV-YY         
           MOVE BW11-FROM-PREV-MM            TO WS-FROM-PREV-MM         
           MOVE BW11-TO-PREV-YY              TO WS-TO-PREV-YY           
           MOVE BW11-TO-PREV-MM              TO WS-TO-PREV-MM           
           MOVE WS-FROM-PREV-DATE            TO HDR-LN7-FROM-PREV-DATE-X
           MOVE WS-TO-PREV-DATE              TO HDR-LN7-TO-PREV-DATE-X  
           MOVE WS-FROM-CURR-DATE            TO HDR-LN7-FROM-CURR-DATE-X
           MOVE WS-TO-CURR-DATE              TO HDR-LN7-TO-CURR-DATE-X  
           MOVE WS-Y                         TO WS-FIRST-VALUE-X.       
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      * 2200-REPORT2-DTLS.                                           *          
      ****************************************************************          
      *                                                                         
        2200-REPORT2-DTLS.                                              
                                                                        
           IF WS-FIRST-VALUE-X = WS-Y                                   
             MOVE WS-N                       TO WS-FIRST-VALUE-X        
           ELSE                                                         
                                                                        
           IF WS-PREV-LOCAL-OFC-X NOT = BW11-LOCAL-OFFICE               
             MOVE WS-Y                       TO WS-VALUE-DIFFER-X       
           ELSE                                                         
             MOVE WS-N                       TO WS-VALUE-DIFFER-X       
           END-IF                                                       
                                                                        
           MOVE FIOBW011-RECORD              TO FIOBW011-REC            
           MOVE BW11-ACCOUNT-NO              TO WS-ACCOUNT-NO-TEMP      
           MOVE WS-ACCOUNT-NO-TEMP           TO WS-SAVE-ACCOUNT         
           MOVE WS-SAVE-ACCT1                TO WS-ACCT1                
           MOVE WS-SAVE-ACCT2                TO WS-ACCT2                
           MOVE WS-SAVE-ACCT3                TO WS-ACCT3                
           MOVE WS-SAVE-ACCT4                TO WS-ACCT4                
           MOVE WS-ACCOUNT1                  TO OUT-ACCOUNT-NO-X        
           MOVE BW11-CUSTOMER-NAME           TO WS-CUST-NAME            
                                                OUT-CUST-NAME-X         
           MOVE BW11-PREV-YEAR-USAGE-DKTHRMS TO WS-PRE-USAGE-DKTHRMS    
           MOVE WS-PRE-USAGE-DKTHRMS         TO OUT-PRE-USAGE-DKTHRMS-X 
           MOVE BW11-CURR-YEAR-USAGE-DKTHRMS TO WS-CURR-USAGE-DKTHRMS   
           MOVE WS-CURR-USAGE-DKTHRMS        TO OUT-CURR-USAGE-DKTHRMS-X
           MOVE BW11-RATE-PLAN-NO            TO WS-RATE-PLAN            
                                                OUT-RATE-PLAN-X         
           MOVE BW11-CODE-REV-CLASS          TO WS-REV-CLASS            
                                                OUT-REV-CLASS-X         
           MOVE BW11-LOCAL-OFFICE            TO WS-LOCAL-OFFICE-X       
                                                HDR-LN4-LOCAL-OFC-X     
                                                WS-PREV-LOCAL-OFC-X     
           MOVE BW11-ZIP-CODE                TO WS-ZIP-CODE             
                                                OUT-ZIP-CODE-X          
           MOVE BW11-STATE-TAX-EXMPT-NO      TO WS-STATE-TAX-EXMPT-NO   
                                                OUT-STATE-TAX-EXMPT-NO-X
           MOVE BW11-CODE-SIC-NO             TO WS-CODE-SIC             
                                                OUT-CODE-SIC-X          
           MOVE BW11-CODE-ACCT-STAT          TO WS-CODE-STAT            
                                                OUT-CODE-STAT-X         
           MOVE BW11-YEARLY-VARIANCE         TO WS-ACTUAL-VARIANCE      
           MOVE WS-ACTUAL-VARIANCE           TO OUT-ACTUAL-VARIANCE-X   
           MOVE BW11-ALTN-FUEL-CD            TO WS-AFC                  
                                                OUT-AFC-X               
           MOVE BW11-SERVICE-ADDRESS         TO WS-SERV-ADDR            
                                                OUT-SERV-ADDR-X         
                                                                        
           IF WS-LOCAL-COUNT-X = 52                                     
             MOVE WS-Y                       TO WS-BEGIN-VALUE-X        
           ELSE                                                         
             MOVE WS-N                       TO WS-BEGIN-VALUE-X        
           END-IF                                                       
                                                                        
                                                                        
           IF WS-BEGIN-VALUE-X = WS-Y OR WS-VALUE-DIFFER-X = WS-Y       
                                                                        
            COMPUTE WS-PAGE-NO-X   = WS-PAGE-NO-X   + 1                 
            MOVE WS-PAGE-NO-X                TO HDR-LN1-PAGE-NO-X       
            MOVE 0                           TO WS-LOCAL-COUNT-X        
                                                                        
            PERFORM 8200-WRITE-OUTFILE2-HDR        THRU  8200-EXIT      
            COMPUTE WS-LOCAL-COUNT-X = WS-LOCAL-COUNT-X + 8             
                                                                        
           END-IF                                                       
                                                                        
           PERFORM 8250-WRITE-OUTFILE2             THRU 8250-EXIT       
           COMPUTE WS-LOCAL-COUNT-X = WS-LOCAL-COUNT-X + 4              
           END-IF                                                       
                                                                        
           PERFORM 7200-READ-FCSBW011-FILE         THRU 7200-EXIT.      
                                                                        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *  READ FCSBW010-FILE FOR INPUT                                  *        
      ******************************************************************        
      *                                                                         
       7100-READ-FCSBW010-FILE.                                         
      *                                                                         
           READ FCSBW010-FILE                                           
                                                                        
           IF FBW010-SUCCESSFUL  OR  END-OF-REC1                        
              CONTINUE                                                  
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   *********'        
               DISPLAY '** ERROR IN READING FCSBW010 FIILE ****'        
               DISPLAY '** FILE STATUS IS ' WS-FBW010-STATUS            
               DISPLAY '*** PROCESSING TERMINATED       *******'        
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSBW011-FILE FOR INPUT                                  *        
      ******************************************************************        
      *                                                                         
       7200-READ-FCSBW011-FILE.                                         
      *                                                                         
           READ FCSBW011-FILE                                           
                                                                        
           IF FBW011-SUCCESSFUL  OR  END-OF-REC2                        
              CONTINUE                                                  
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   *********'        
               DISPLAY '** ERROR IN READING FCSBW011 FIILE ****'        
               DISPLAY '** FILE STATUS IS ' WS-FBW011-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     *********'        
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE1-HDR.                                 **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE1-HDR.                                         
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN1                
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN2.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN3.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN4.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN5.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN6.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN7.               
           WRITE PRT331-RECORD FROM WS-RP019-HDR-REC-LN8                
                  AFTER ADVANCING 3 LINES.                              
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8150-WRITE-OUTFILE1.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8150-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP019-LN1-REC.                   
           WRITE PRT331-RECORD FROM WS-RP019-LN2-REC.                   
           WRITE PRT331-RECORD FROM WS-RP019-LN3-REC.                   
           WRITE PRT331-RECORD FROM WS-RP019-LN4-REC.                   
      *                                                                 08335000
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE2-HDR.                                 **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE2-HDR.                                         
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN01               
                  AFTER ADVANCING PAGE.                                 
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN02.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN03.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN04.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN05.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN06.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN07.              
           WRITE PRT332-RECORD FROM WS-RP019-HDR-REC-LN08               
                  AFTER ADVANCING 3 LINES.                              
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8250-WRITE-OUTFILE2.                                     **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8250-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP019-LN01-REC.                  
           WRITE PRT332-RECORD FROM WS-RP019-LN02-REC.                  
           WRITE PRT332-RECORD FROM WS-RP019-LN03-REC.                  
           WRITE PRT332-RECORD FROM WS-RP019-LN04-REC.                  
      *                                                                 08335000
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-OUTFILE1-FTR.                                 **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-OUTFILE1-FTR.                                         
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-RP019-FTR-REC-LN1.               
           WRITE PRT331-RECORD FROM WS-RP019-FTR-REC-LN2.               
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8400-WRITE-OUTFILE2-FTR.                                 **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8400-WRITE-OUTFILE2-FTR.                                         
      *                                                                 08230000
           WRITE PRT332-RECORD FROM WS-RP019-FTR-REC-LN01.              
           WRITE PRT332-RECORD FROM WS-RP019-FTR-REC-LN02.              
      *                                                                 08335000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSBW010-FILE.                                         
                                                                        
           IF NOT FBW010-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING FCSBW010-FILE.    **'         
               DISPLAY '**  FILE STATUS = ' WS-FBW010-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           CLOSE FCSBW011-FILE.                                         
                                                                        
           IF NOT FBW011-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING  FCSBW011-FILE.   **'         
               DISPLAY '**  FILE STATUS = ' WS-FBW011-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSRP018 ABORT   ********'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '*** PROCESSING TERMINATED     ********'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
