       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP017.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     JUL 27,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT012***  07/27/2015    MS7M727     EZT TO COBOL CONVERSION         ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP017'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_EQUIPMENT                                                        
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE  TBEQUIP                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_GAS_METER                                                        
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_COMPANY                                                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MODEL_SQL                                                        
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_GAS_METER_SIZE                                                   
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   JOB PARM                                                              
      *****************************************************************         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-PGRMNAME                    PIC X(08) VALUE 'PCSRP017'. 
          05 WS-Y                           PIC X(01) VALUE 'Y'.        
          05 WS-N                           PIC X(01) VALUE 'N'.        
          05 WS-PSNC                        PIC X(02) VALUE '26'.       
      *                                                                         
       01 WS-METER-INFO.                                                
          05 WS-COMPANY-NO                  PIC X(02) VALUE '26'.       
          05 WS-COMPANY-NAME                PIC X(26) VALUE SPACES.     
          05 WS-EXP-DAYS                    PIC S9(04) USAGE COMP.      
          05 WS-EXP-DAYS-C                  PIC 9(03) VALUE 270.        
          05 WS-NO-DAYS                     PIC S9(04) USAGE COMP.      
          05 WS-NO-DAYS-C                   PIC 9(03) VALUE 210.        
          05 WS-PARM-TEST-DAYS              PIC 9(03) VALUE ZERO.       
          05 WS-TEST-DATE                   PIC X(10) VALUE SPACES.     
          05 WS-TEST-DATE-LOW               PIC X(13) VALUE SPACES.     
          05 WS-METER-FOUND                 PIC X(01) VALUE 'N'.        
          05 WS-TOTAL-IN                    PIC 9(05) VALUE ZERO.       
          05 WS-TOTAL-OUT                   PIC 9(05) VALUE ZERO.       
          05 WS-PREMISE-NO-EQ               PIC 9(10) VALUE ZERO.       
          05 WS-PREV-MSF-CD                 PIC X(03) VALUE SPACES.     
          05 WS-FIRST-FETCH                 PIC X(01) VALUE 'Y'.        
          05 WS-INVENTORY                   PIC X(09) VALUE 'INVENTORY'.
          05 WS-TEST-SHOP                   PIC X(09) VALUE 'TEST SHOP'.
          05 WS-INSTALLED                   PIC X(09) VALUE 'INSTALLED'.
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-LINE-COUNT                  PIC 9(06) VALUE ZERO.       
          05 WS-COUNT-METER                 PIC 9(06) VALUE ZERO.       
          05 WS-PAGE-NUM                    PIC 9(02) VALUE ZERO.       
          05 WS-TOTAL-METER-REC             PIC 9(06) VALUE ZERO.       
      *                                                                         
       01 WS-METER-INFO-DTL-DATA.                                       
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 WS-DEVICE-NO                   PIC X(09) VALUE SPACES.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 WS-SERIAL-NO                   PIC X(11) VALUE SPACES.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 WS-LOCATION                    PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 WS-MSF-CD                      PIC X(03) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE SPACES.     
          05 WS-METER-SIZE-ID               PIC X(08) VALUE SPACES.     
          05 FILLER                         PIC X(07) VALUE SPACES.     
          05 WS-METER-SIZE-DESC             PIC X(25) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 WS-DATE-LAST-TESTED            PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 WS-EXPIRE-DATE                 PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(10) VALUE SPACES.     
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-REPORT-CCYY               PIC X(04) VALUE SPACES.     
           05  WS-REPORT-MM                 PIC X(02) VALUE SPACES.     
           05  WS-REPORT-DD                 PIC X(02) VALUE SPACES.     
                                                                        
       01  WS-REPORT-DATE.                                              
           05  WS-RPT-MONTH                 PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RPT-DATE                  PIC X(02) VALUE SPACES.     
           05  FILLER                       PIC X(01) VALUE '/'.        
           05  WS-RPT-YEAR                  PIC X(04) VALUE SPACES.     
      *                                                                         
                                                                        
      ***************** PCSRP017 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  PR-RPT1-TITLE-PGM        PIC X(11)                   
                                                 VALUE 'PCSRP017-01'.   
               10  FILLER                   PIC X(37) VALUE SPACES.     
               10  PR-RPT1-COMPANY-NAME     PIC X(26).                  
               10  FILLER                   PIC X(26) VALUE SPACES.     
               10  PR-RPT1-DATE             PIC X(10) VALUE SPACES.     
               10  FILLER                   PIC X(11) VALUE SPACES.     
               10  FILLER                   PIC X(04) VALUE 'PAGE'.     
               10  FILLER                   PIC X(03) VALUE SPACES.     
               10  PR-RPT1-PAGE             PIC Z(02) VALUE ZERO.       
               10  FILLER                   PIC X(01) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10 FILLER                    PIC X(36) VALUE SPACES.     
               10 FILLER                    PIC X(25)                   
                                    VALUE '210-269 DAY MTR INVENTORY'.  
               10 FILLER                    PIC X(71) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10 FILLER                    PIC X(01) VALUE SPACES.     
               10 FILLER                    PIC X(18) VALUE SPACES.     
               10 FILLER                    PIC X(17)                   
                                    VALUE 'MSF/LOCAL OFFICE:'.          
               10 FILLER                    PIC X(4)  VALUE SPACES.     
               10 PR-RPT1-MSF-CD1           PIC X(3)  VALUE SPACES.     
               10 FILLER                    PIC X(89) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10 FILLER                    PIC X(133) VALUE SPACES.    
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10 FILLER                    PIC X(55) VALUE SPACES.     
               10 FILLER                    PIC X(05) VALUE 'METER'.    
               10 FILLER                    PIC X(16) VALUE SPACES.     
               10 FILLER                    PIC X(11)                   
                                    VALUE 'METER TYPE '.                
               10 FILLER                    PIC X(15) VALUE SPACES.     
               10 FILLER                    PIC X(04) VALUE 'DATE'.     
               10 FILLER                    PIC X(11) VALUE SPACES.     
               10 FILLER                    PIC X(04) VALUE 'DATE'.     
               10 FILLER                    PIC X(12) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-6.                                        
               10 FILLER                    PIC X(01) VALUE SPACES.     
               10 FILLER                    PIC X(09)                   
                                    VALUE 'METER NBR'.                  
               10 FILLER                    PIC X(04) VALUE SPACES.     
               10 FILLER                    PIC X(11)                   
                                    VALUE 'SERIAL NBR '.                
               10 FILLER                    PIC X(04) VALUE SPACES.     
               10 FILLER                    PIC X(09)                   
                                    VALUE ' LOCATION'.                  
               10 FILLER                    PIC X(06) VALUE SPACES.     
               10 FILLER                    PIC X(03) VALUE 'MSF'.      
               10 FILLER                    PIC X(07) VALUE SPACES.     
               10 FILLER                    PIC X(06)                   
                                    VALUE '  TYPE'.                     
               10 FILLER                    PIC X(16) VALUE SPACES.     
               10 FILLER                    PIC X(13)                   
                                            VALUE 'DESCRIPTION'.        
               10 FILLER                    PIC X(12) VALUE SPACES.     
               10 FILLER                    PIC X(06)                   
                                    VALUE 'TESTED'.                     
               10 FILLER                    PIC X(07) VALUE SPACES.     
               10 FILLER                    PIC X(09)                   
                                    VALUE ' EXPIRES '.                  
               10 FILLER                    PIC X(10) VALUE SPACES.     
     *                                                                  
           05  WS-RPT1-HEADER-7.                                        
               10 FILLER                    PIC X(01) VALUE SPACES.     
               10 PR-RPT1-DEVICE-NO         PIC X(09) VALUE SPACES.     
               10 FILLER                    PIC X(04) VALUE SPACES.     
               10 PR-RPT1-SERIAL-NO         PIC X(11) VALUE SPACES.     
               10 FILLER                    PIC X(04) VALUE SPACES.     
               10 PR-RPT1-LOCATION          PIC X(10) VALUE SPACES.     
               10 FILLER                    PIC X(05) VALUE SPACES.     
               10 PR-RPT1-MSF-CD            PIC X(3)  VALUE SPACES.     
               10 FILLER                    PIC X(07) VALUE SPACES.     
               10 PR-RPT1-METER-SIZE-ID     PIC X(8)  VALUE ZERO.       
               10 FILLER                    PIC X(07) VALUE SPACES.     
               10 PR-RPT1-METER-SIZE-DESC   PIC X(25) VALUE SPACES.     
               10 FILLER                    PIC X(05) VALUE SPACES.     
               10 PR-RPT1-DATE-LAST-TESTED  PIC X(10) VALUE SPACES.     
               10 FILLER                    PIC X(05) VALUE SPACES.     
               10 PR-RPT1-EXPIRE-DATE       PIC X(10) VALUE SPACES.     
               10 FILLER                    PIC X(10) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-8.                                        
               10 FILLER                    PIC X(24) VALUE SPACES.     
               10 FILLER                    PIC X(19)                   
                                    VALUE 'TOTAL METERS OFFICE'.        
               10 FILLER                    PIC X(02) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '='.        
               10 FILLER                    PIC X(05) VALUE SPACES.     
               10 PR-RPT1-COUNTER           PIC Z(06) VALUE ZERO.       
               10 FILLER                    PIC X(75) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-9.                                        
               10 FILLER                    PIC X(24) VALUE SPACES.     
               10 FILLER                    PIC X(19)                   
                                    VALUE 'TOTAL METERS REPORT'.        
               10 FILLER                    PIC X(02) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '='.        
               10 FILLER                    PIC X(05) VALUE SPACES.     
               10 PR-RPT1-METER-REC         PIC Z(06) VALUE ZERO.       
               10 FILLER                    PIC X(75) VALUE SPACES.     
      *                                                                         
           05  WS-RPT1-HEADER-10.                                       
               10 FILLER                    PIC X(132) VALUE SPACES.    
      *                                                                         
      *****************************************************************         
      *           COMMON WORKING STORAGE VARIABLE *                             
      *****************************************************************         
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-TEST-NULL                 PIC S9(04) COMP.            
           05  WS-TEST-LOW-NULL             PIC S9(04) COMP.            
           05  WS-INSTALL-NULL              PIC S9(04) COMP.            
           05  WS-DT-MOVE-NULL              PIC S9(04) COMP.            
           05  WS-DT-LAST-NULL              PIC S9(04) COMP.            
           05  WS-EXPIRE-NULL               PIC S9(04) COMP.            
       01  WS-YES-NULL                      PIC S9(04) VALUE -1.        
      *                                                                         
      *****************************************************************         
      ** THIS CURSOR FOR METER INFORMATION * **                       *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE METER_INFO CURSOR  FOR                            
               SELECT EQ.DEVICE_NO                                      
                     ,EQ.SERIAL_NO                                      
                     ,EQ.INSTALL_DT                                     
                     ,EQ.CODE_CRNT_LOC                                  
                     ,EQ.CRNT_LOC_NO                                    
                     ,EQ.DATE_LAST_MOVE                                 
                     ,EQ.LOCAL_OFFICE                                   
                     ,EQ.COMPANY_NO                                     
                     ,GM.METER_SIZE_ID                                  
                     ,GM.DATE_LAST_TESTED                               
                 FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                   
                      ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                   
                WHERE EQ.CODE_UTIL_TYPE = 'G'                           
                  AND EQ.COMPANY_NO     = :WS-COMPANY-NO                
                  AND GM.COMPANY_NO     = EQ.COMPANY_NO                 
                  AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE             
                  AND EQ.CODE_CRNT_LOC IN ('A')                         
                  AND GM.METER_NO = EQ.DEVICE_NO                        
                  AND GM.DATE_LAST_TESTED IS NOT NULL                   
                ORDER BY EQ.LOCAL_OFFICE,GM.METER_SIZE_ID,              
                      GM.DATE_LAST_TESTED,EQ.DEVICE_NO                  
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_INFO CURSOR  FOR                                    
MFA-TR*        SELECT EQ.DEVICE_NO                                              
MFA-TR*              ,EQ.SERIAL_NO                                              
MFA-TR*              ,EQ.INSTALL_DT                                             
MFA-TR*              ,EQ.CODE_CRNT_LOC                                          
MFA-TR*              ,EQ.CRNT_LOC_NO                                            
MFA-TR*              ,EQ.DATE_LAST_MOVE                                         
MFA-TR*              ,EQ.LOCAL_OFFICE                                           
MFA-TR*              ,EQ.COMPANY_NO                                             
MFA-TR*              ,GM.METER_SIZE_ID                                          
MFA-TR*              ,GM.DATE_LAST_TESTED                                       
MFA-TR*          FROM  CSS_EQUIPMENT EQ                                         
MFA-TR*               ,CSS_GAS_METER GM                                         
MFA-TR*         WHERE EQ.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND EQ.COMPANY_NO     = :WS-COMPANY-NO                        
MFA-TR*           AND GM.COMPANY_NO     = EQ.COMPANY_NO                         
MFA-TR*           AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                     
MFA-TR*           AND EQ.CODE_CRNT_LOC IN ('A')                                 
MFA-TR*           AND GM.METER_NO = EQ.DEVICE_NO                                
MFA-TR*           AND GM.DATE_LAST_TESTED IS NOT NULL                           
MFA-TR*         ORDER BY EQ.LOCAL_OFFICE,GM.METER_SIZE_ID,                      
MFA-TR*               GM.DATE_LAST_TESTED,EQ.DEVICE_NO                          
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 WS-PARM-DATA.                                                 
          03 WS-PARM-LENGTH                 PIC S9(4) COMP.             
          03 WS-PARM-COMPANY-NO             PIC X(2).                   
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION USING  WS-PARM-DATA.                          
      *                                                                         
      ******************************************************************        
      ** CONTROLS THE MAIN PATH OF THE PROGRAM                        **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
      *                                                                         
           PERFORM 2000-PROCESS-MAIN-CSR      THRU 2000-EXIT.           
      *                                                                         
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD.                   
                                                                        
           MOVE WS-REPORT-MM                TO WS-RPT-MONTH.            
           MOVE WS-REPORT-DD                TO WS-RPT-DATE.             
           MOVE WS-REPORT-CCYY              TO WS-RPT-YEAR.             
           MOVE WS-REPORT-DATE              TO PR-RPT1-DATE.            
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT.                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF WS-PARM-COMPANY-NO > SPACES                               
              MOVE WS-PARM-COMPANY-NO       TO WS-COMPANY-NO            
           ELSE                                                         
              MOVE WS-PSNC                  TO WS-COMPANY-NO            
           END-IF.                                                      
      *                                                                         
           PERFORM 1100-GET-PARM-TEST-DAYS     THRU 1100-EXIT.          
      *                                                                         
           MOVE WS-INPUT-DATA-BREAKDOWN(12:3)  TO WS-PARM-TEST-DAYS.    
      *                                                                         
           PERFORM 7100-GET-COMPANY-NAME       THRU 7100-EXIT.          
      *                                                                         
           DISPLAY 'WS-COMPANY-NO      = ' WS-COMPANY-NO.               
           DISPLAY 'WS-PARM-COMPANY-NO = ' WS-PARM-COMPANY-NO.          
           DISPLAY 'WS-PARM-TEST-DAYS  = ' WS-PARM-TEST-DAYS.           
           DISPLAY 'WS-CURRENT-DATE    = ' WS-CURRENT-DATE.             
                                                                        
           MOVE    WS-REPORT-CCYY           TO WS-RPT-YEAR.             
           MOVE    WS-REPORT-MM             TO WS-RPT-MONTH.            
                                                                        
           IF WS-PARM-TEST-DAYS > 0                                     
              MOVE WS-PARM-TEST-DAYS        TO WS-NO-DAYS-C             
           END-IF.                                                      
      *                                                                         
           PERFORM 1200-TEST-DATE-RANGE        THRU 1200-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  1100-GET-PARM-TEST-DAYS **                                             
      ****************************************************************          
      *                                                                         
       1100-GET-PARM-TEST-DAYS.                                         
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
           MOVE WS-PSNC                   TO G6-COMPANY-NO.             
      *                                                                         
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-TEST THE  DATE RANGE    **                                        
      ******************************************************************        
      *                                                                         
       1200-TEST-DATE-RANGE.                                            
      *                                                                         
           MOVE SPACES                      TO WS-TEST-DATE.            
           MOVE SPACES                      TO WS-TEST-DATE-LOW.        
           MOVE WS-NO-DAYS-C                TO WS-NO-DAYS.              
      *                                                                         
           PERFORM 7200-GET-DAYS               THRU 7200-EXIT.          
      *                                                                         
                                                                        
           MOVE WS-EXP-DAYS-C               TO WS-EXP-DAYS.             
      *                                                                         
           PERFORM 7300-GET-DAYS-LOW           THRU 7300-EXIT.          
      *                                                                         
                                                                        
           DISPLAY  'WS-TEST-DATE     = ' WS-TEST-DATE.                 
           DISPLAY  'WS-TEST-DATE-LOW = ' WS-TEST-DATE-LOW.             
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-MAIN-CSR **                                               
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MAIN-CSR.                                           
      *                                                                         
           PERFORM 7400-OPEN-METER-INFO        THRU 7400-EXIT.          
      *                                                                         
           PERFORM 7500-FETCH-METER-INFO       THRU 7500-EXIT.          
      *                                                                         
           PERFORM 2100-PROCESS-ACCOUNT-DTLS   THRU 2100-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           DISPLAY 'PCSRP017 STATISTICS'                                
           DISPLAY 'TOTAL RECORDS IN  = ' WS-TOTAL-IN                   
           DISPLAY 'TOTAL RECORDS OUT = ' WS-TOTAL-OUT                  
      *                                                                         
           IF WS-TOTAL-OUT > 0                                          
              PERFORM 2700-WRITE-SUMMARY       THRU 2700-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 7900-CLOSE-METER-INFO       THRU 7900-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-ACCOUNT-DTLS ** **                                        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-ACCOUNT-DTLS.                                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              MOVE EQ-DEVICE-NO           TO WS-DEVICE-NO               
              MOVE EQ-SERIAL-NO           TO WS-SERIAL-NO               
           END-IF.                                                      
           DISPLAY 'MTR NBR = ' EQ-DEVICE-NO.                           
           MOVE     WS-N                  TO WS-METER-FOUND.            
           COMPUTE  WS-TOTAL-IN = WS-TOTAL-IN + 1.                      
      *                                                                         
           IF GM-DATE-LAST-TESTED     <= WS-TEST-DATE                   
              AND GM-DATE-LAST-TESTED > WS-TEST-DATE-LOW                
                                                                        
              MOVE EQ-LOCAL-OFFICE          TO WS-MSF-CD                
              MOVE EQ-CRNT-LOC-NO           TO WS-PREMISE-NO-EQ         
              MOVE GM-METER-SIZE-ID         TO WS-METER-SIZE-ID         
              MOVE GM-DATE-LAST-TESTED      TO WS-DATE-LAST-TESTED      
      *                                                                         
              PERFORM 2200-LOCATION-DESCRIP    THRU 2200-EXIT           
      *                                                                         
              MOVE SPACES                   TO WS-EXPIRE-DATE           
      *                                                                         
              PERFORM 7700-EXPIRE-DATE         THRU 7700-EXIT           
      *                                                                         
              PERFORM 7800-SIZE-DESC           THRU 7800-EXIT           
      *                                                                         
              PERFORM 2300-WRITE-REPORT        THRU 2300-EXIT           
      *                                                                         
              COMPUTE WS-TOTAL-OUT = WS-TOTAL-OUT + 1                   
            END-IF.                                                     
      *                                                                         
            PERFORM 7500-FETCH-METER-INFO     THRU 7500-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-LOCATION-DESCRIPTION              **                              
      ******************************************************************        
      *                                                                         
       2200-LOCATION-DESCRIP.                                           
      *                                                                         
           MOVE SPACES                      TO WS-LOCATION              
      *                                                                         
           IF EQ-CODE-CRNT-LOC = 'A'                                    
              MOVE WS-INVENTORY             TO WS-LOCATION              
           ELSE                                                         
              IF EQ-CODE-CRNT-LOC = 'B'                                 
                 MOVE WS-TEST-SHOP          TO WS-LOCATION              
              ELSE                                                      
                 MOVE WS-INSTALLED          TO WS-LOCATION              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-WRITE-REPORT.                                           **        
      ******************************************************************        
      *                                                                         
       2300-WRITE-REPORT.                                               
      *                                                                         
           IF WS-FIRST-FETCH = WS-Y                                     
              MOVE WS-N                      TO WS-FIRST-FETCH          
              COMPUTE WS-PAGE-NUM = WS-PAGE-NUM  + 1                    
      *                                                                         
              PERFORM 2400-WRITE-HDR-DATA      THRU 2400-EXIT           
      *                                                                         
           ELSE                                                         
              IF WS-LINE-COUNT >= 33  OR WS-MSF-CD NOT EQUAL            
                                         WS-PREV-MSF-CD                 
                 IF WS-LINE-COUNT >= 33                                 
                    COMPUTE WS-PAGE-NUM = WS-PAGE-NUM + 1               
                END-IF                                                  
                                                                        
                 IF WS-MSF-CD NOT EQUAL WS-PREV-MSF-CD                  
                    MOVE WS-RPT1-HEADER-10   TO PRT33-DATA              
      *                                                                         
                    PERFORM 8200-WRITE-FCSPT33 THRU 8200-EXIT           
      *                                                                         
                    MOVE WS-COUNT-METER      TO PR-RPT1-COUNTER         
                    MOVE WS-RPT1-HEADER-8    TO PRT33-DATA              
                                                                        
                    PERFORM 8000-WRITE-FCSPT33 THRU  8000-EXIT          
      *                                                                         
                    MOVE  ZERO               TO WS-COUNT-METER          
                    MOVE  ZERO               TO WS-PAGE-NUM             
                    COMPUTE WS-PAGE-NUM = WS-PAGE-NUM + 1               
                 END-IF                                                 
      *                                                                         
              MOVE ZERO                      TO WS-LINE-COUNT           
      *                                                                         
              PERFORM 2400-WRITE-HDR-DATA      THRU 2400-EXIT           
      *                                                                         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-WRITE-DTL-DATA         THRU 2500-EXIT.          
      *                                                                         
           COMPUTE WS-COUNT-METER      = WS-COUNT-METER     + 1.        
           COMPUTE WS-TOTAL-METER-REC  = WS-TOTAL-METER-REC + 1.        
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 2400-WRITE HEADER DATA                                    **           
      ******************************************************************        
      *                                                                         
       2400-WRITE-HDR-DATA.                                             
      *                                                                         
           MOVE WS-COMPANY-NAME             TO PR-RPT1-COMPANY-NAME.    
           MOVE WS-PAGE-NUM                 TO PR-RPT1-PAGE.            
           MOVE WS-MSF-CD                   TO PR-RPT1-MSF-CD1.         
           MOVE WS-RPT1-HEADER-1            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8100-WRITE-FCSPT33          THRU 8100-EXIT.          
      *                                                                         
           MOVE WS-RPT1-HEADER-2            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8000-WRITE-FCSPT33          THRU 8000-EXIT.          
      *                                                                         
           MOVE WS-RPT1-HEADER-3            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.          
      *                                                                         
           MOVE WS-RPT1-HEADER-4            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.          
      *                                                                         
           MOVE WS-RPT1-HEADER-5            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8000-WRITE-FCSPT33          THRU 8000-EXIT.          
      *                                                                         
           MOVE WS-RPT1-HEADER-6            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8000-WRITE-FCSPT33          THRU 8000-EXIT.          
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-WRITE DETAILED DATA                                   **          
      ******************************************************************        
      *                                                                         
       2500-WRITE-DTL-DATA.                                             
      *                                                                         
           MOVE WS-METER-INFO-DTL-DATA      TO WS-RPT1-HEADER-7.        
           MOVE WS-RPT1-HEADER-7            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8300-WRITE-FCSPT33          THRU 8300-EXIT.          
      *                                                                         
           MOVE WS-MSF-CD                   TO WS-PREV-MSF-CD.          
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************&*************         
      ** 2700-WRITE-SUMMARY   **                                                
      ******************************************************************        
      *                                                                         
       2700-WRITE-SUMMARY.                                              
      *                                                                         
           MOVE WS-RPT1-HEADER-10           TO PRT33-DATA.              
      *                                                                         
           PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.          
      *                                                                         
           MOVE WS-COUNT-METER              TO PR-RPT1-COUNTER.         
           MOVE WS-RPT1-HEADER-8            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8000-WRITE-FCSPT33          THRU 8000-EXIT.          
      *                                                                         
           MOVE WS-TOTAL-METER-REC          TO PR-RPT1-METER-REC.       
           MOVE WS-RPT1-HEADER-9            TO PRT33-DATA.              
      *                                                                         
           PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.          
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7100-GET-COMPANY-NAME **                                               
      ******************************************************************        
      *                                                                         
       7100-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO = :WS-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NAME                                               
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT ******'                  
              DISPLAY '**  7100-GET-COMPANY-NAME  **'                   
              DISPLAY '**  COMPANY-NO  = ' WS-COMPANY-NO                
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-GET-DAYS ** **                                                    
      ******************************************************************        
      *                                                                         
       7200-GET-DAYS.                                                   
      *                                                                         
                                                                        
           EXEC SQL                                                     
              SELECT  (DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) - :WS-NO-DAYS)-1, CAST('00010101' AS DATE)))          
                INTO  :WS-TEST-DATE :WS-TEST-NULL                        
                FROM  CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  (DATE(DAYS(CURRENT DATE) - :WS-NO-DAYS))                  
MFA-TR*         INTO  :WS-TEST-DATE:WS-TEST-NULL                                
MFA-TR*         FROM  CSS_MODEL_SQL                                             
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO  7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF  WS-TEST-NULL      = WS-YES-NULL                    
                     MOVE SPACES            TO WS-TEST-DATE             
                 END-IF                                                 
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT ******'                  
              DISPLAY '**  7200-GET-DAYS **'                            
              DISPLAY '**  NO OF DAYS    **' WS-NO-DAYS                 
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7300-GET-DAYS-LOW **                                         **        
      ******************************************************************        
      *                                                                         
       7300-GET-DAYS-LOW.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  (DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) - :WS-EXP-DAYS)-1, CAST('00010101' AS DATE)))         
                INTO  :WS-TEST-DATE-LOW :WS-TEST-LOW-NULL                
                FROM  CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  (DATE(DAYS(CURRENT DATE) - :WS-EXP-DAYS))                 
MFA-TR*         INTO  :WS-TEST-DATE-LOW:WS-TEST-LOW-NULL                        
MFA-TR*         FROM  CSS_MODEL_SQL                                             
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO  7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF  WS-TEST-LOW-NULL  = WS-YES-NULL                    
                     MOVE SPACES            TO WS-TEST-DATE-LOW         
                 END-IF                                                 
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '******** PCSRP017 ABORT ******'                 
               DISPLAY '**  7300-GET-DAYS-LOW **'                       
               DISPLAY '**  EXPIRE DAYS       **' WS-EXP-DAYS           
               DISPLAY '**  RETURN CODE       = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-OPEN-METER-INFO                                         **        
      ******************************************************************        
      *                                                                         
       7400-OPEN-METER-INFO.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN METER_INFO                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT ******'                  
              DISPLAY '**  7400-OPEN-METER_INFO  **'                    
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  PROCESSING TERMINATED **'                    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7500-FETCH-METER-INFO                                       **        
      ******************************************************************        
      *                                                                         
       7500-FETCH-METER-INFO.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH METER_INFO INTO                                     
                    :EQ-DEVICE-NO                                       
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-INSTALL-DT :WS-INSTALL-NULL                      
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-DATE-LAST-MOVE :WS-DT-MOVE-NULL                  
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-COMPANY-NO                                      
                   ,:GM-METER-SIZE-ID                                   
                   ,:GM-DATE-LAST-TESTED :WS-DT-LAST-NULL                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF   WS-INSTALL-NULL  = WS-YES-NULL                    
                      MOVE SPACES           TO EQ-INSTALL-DT            
                 END-IF                                                 
                 IF   WS-DT-MOVE-NULL  = WS-YES-NULL                    
                      MOVE SPACES           TO EQ-DATE-LAST-MOVE        
                 END-IF                                                 
                 IF   WS-DT-LAST-NULL  = WS-YES-NULL                    
                      MOVE SPACES           TO GM-DATE-LAST-TESTED      
                 END-IF                                                 
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT ******'                  
              DISPLAY '**  7500-FETCH-METER_INFO  **'                   
              DISPLAY '**  COMPANY-NO             **'WS-COMPANY-NO      
              DISPLAY '**  RETURN CODE         = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7600-START-FCSJC01                                                     
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      ** 7700-GET THE EXPIRE DATE **                                            
      ******************************************************************        
      *                                                                         
       7700-EXPIRE-DATE.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT  (DATEADD(D, (CIS.DAYS(DATE_LAST_TESTED) + 
                                                           :WS-EXP-DAYS
              )-1, CAST('00010101' AS DATE)))     
                INTO  :WS-EXPIRE-DATE :WS-EXPIRE-NULL                    
                FROM  CSS_GAS_METER GM WITH(READUNCOMMITTED)                    
               WHERE  GM.CODE_UTIL_TYPE = 'G'                           
                 AND  GM.COMPANY_NO = :WS-COMPANY-NO                    
                 AND  GM.METER_NO = :EQ-DEVICE-NO                       
                 AND  GM.DATE_LAST_TESTED IS NOT NULL                   
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  (DATE(DAYS(DATE_LAST_TESTED) + :WS-EXP-DAYS))             
MFA-TR*         INTO  :WS-EXPIRE-DATE:WS-EXPIRE-NULL                            
MFA-TR*         FROM  CSS_GAS_METER GM                                          
MFA-TR*        WHERE  GM.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*          AND  GM.COMPANY_NO = :WS-COMPANY-NO                            
MFA-TR*          AND  GM.METER_NO = :EQ-DEVICE-NO                               
MFA-TR*          AND  GM.DATE_LAST_TESTED IS NOT NULL                           
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO  7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF   WS-EXPIRE-NULL   = WS-YES-NULL                    
                      MOVE SPACES           TO WS-EXPIRE-DATE           
                 END-IF                                                 
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT *****'                   
              DISPLAY '**  7700-EXPIRE-DATE  **'                        
              DISPLAY '**  EXPIRE DAYS       **' WS-EXP-DAYS            
              DISPLAY '**  COMPANY NO        **' WS-COMPANY-NO          
              DISPLAY '**  DEVICE NO         **' EQ-DEVICE-NO           
              DISPLAY '**  RETURN CODE       = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**  PROCESSING TERMINATED  **'                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 7800-SIZE-DESC                                               **        
      ******************************************************************        
      *                                                                         
       7800-SIZE-DESC.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT M5.METER_SIZE_DESC                                 
                INTO :WS-METER-SIZE-DESC                                
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE M5.METER_SIZE_ID = :GM-METER-SIZE-ID               
                 AND M5.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M5.METER_SIZE_DESC                                         
MFA-TR*         INTO :WS-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE M5.METER_SIZE_ID = :GM-METER-SIZE-ID                       
MFA-TR*          AND M5.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP017 ABORT *****'                   
              DISPLAY '**  7800-SIZE-DESC  ***'                         
              DISPLAY '**  METER SIZE ID   ***' GM-METER-SIZE-ID        
              DISPLAY '**  COMPANY NO      ***' WS-COMPANY-NO           
              DISPLAY '**  RETURN CODE     = '  WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7900-CLOSE-METER-INFO                                        **        
      ******************************************************************        
      *                                                                         
       7900-CLOSE-METER-INFO.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE METER_INFO                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP014 ABORT *****'                   
              DISPLAY '**  7900-CLOSE-METER-INFO  ***'                  
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSTP33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-CLOSE-FILES.                                            **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-ABEND                                                             
      ** COPYBOOK FOR ABEND ROUTINE                                   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
