       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP016.                                      
COB303 DATE-WRITTEN.     APR 28, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  05/25/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT002*--                            CSR016 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP016'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTRD_ENVRNMT, MN                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_NAME_ACCT_XREF, HT                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_NAME, DQ                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ADDR_FORMATTED, DY                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUST_PREM_HIST, CH                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_RATE_PLAN_DESC, RD                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BILL_WINDOW, BN                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMPANY, C7                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_RATE_COMP_DEF, J1                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM, G6                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSRP016'.     
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-NO-CIG-REPORT          PIC X(01) VALUE 'Y'.            
           05 WS-NO-REPORT              PIC X(01) VALUE 'Y'.            
           05 WS-PRINT-CIGRPT           PIC X(01) VALUE 'N'.            
           05 WS-PRINT-SECRPT           PIC X(01) VALUE 'N'.            
           05 WS-ONE                    PIC 9(01) VALUE 1.              
           05 WS-HDR-CIG                PIC X(74)                       
              VALUE 'CIG ACCOUNTS THAT DID NOT BILL(ALL PREV CYCS)'.    
           05 WS-HDR-SEC                PIC X(74)                       
              VALUE 'IBS ACCOUNTS THAT DID NOT BILL(ALL PREV CYCS)'.    
           05 WS-SCEG-TITLE             PIC X(21)                       
              VALUE 'S C ELECTRIC & GAS CO'.                            
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-DATE-EXTRACT           PIC X(10) VALUE SPACES.         
           05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.         
           05 WS-REVENUE-MONTH          PIC 9(06) VALUE ZEROES.         
           05 WS-COMPANY-NO-DTL         PIC X(02) VALUE SPACES.         
           05 WS-COMPANY-NO-CIG         PIC X(02) VALUE SPACES.         
           05 WS-NAME                   PIC X(20) VALUE SPACES.         
           05 WS-ADDRESS                PIC X(30) VALUE SPACES.         
           05 WS-CIG-ACCOUNT            PIC X(01) VALUE SPACES.         
           05 WS-FOURTH-DAY             PIC X(10) VALUE SPACES.         
           05 WS-SUB                    PIC 9(01) VALUE ZEROES.         
COB305     05 WS-MIN-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-MAX-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           05 WS-LINE-COUNT1            PIC 9(02)  VALUE ZEROES.        
           05 WS-LINE-COUNT2            PIC 9(02)  VALUE ZEROES.        
           05 WS-PAGE-NUM1              PIC 9(02)  VALUE ZEROES.        
           05 WS-PAGE-NUM2              PIC 9(02)  VALUE ZEROES.        
           05 WS-FCA331-STATUS          PIC X(02)  VALUE SPACES.        
                                                                        
      *                                                                         
           05 WS-SAVE-ACCT              PIC 9(13) VALUE ZEROES.         
           05 WS-SAVE-ACCOUNT1 REDEFINES WS-SAVE-ACCT.                  
              10 WS-SAVE-ACCT1          PIC X(01).                      
              10 WS-SAVE-ACCT2          PIC X(04).                      
              10 WS-SAVE-ACCT3          PIC X(04).                      
              10 WS-SAVE-ACCT4          PIC X(04).                      
      *                                                                         
           05 WS-ACCT                   PIC X(13) VALUE SPACES.         
           05 WS-ACCOUNT1.                                              
              10 WS-ACCT1               PIC X(01).                      
              10 WS-ACCT1D              PIC X(01) VALUE '-'.            
              10 WS-ACCT2               PIC X(04).                      
              10 WS-ACCT2D              PIC X(01) VALUE '-'.            
              10 WS-ACCT3               PIC X(04).                      
              10 WS-ACCT3D              PIC X(01) VALUE '-'.            
              10 WS-ACCT4               PIC X(04).                      
      *                                                                         
           05 WS-RECORD-COUNT           PIC 9(9)  VALUE ZEROES.         
           05 WS-BILL-CYCLE1            PIC X(02) VALUE SPACES.         
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
      *                                                                         
       01  WS-SWITCH.                                                   
           05  SR-TRLR-DATA-REQ-N       PIC X(01) VALUE 'N'.            
               88 SR-TRLR-DATA-REQ                VALUE 'Y'.            
           05  CG-TRLR-DATA-REQ-N       PIC X(01) VALUE 'N'.            
               88 CG-TRLR-DATA-REQ                VALUE 'Y'.            
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                    PIC 9(02).                      
           05  WS-MM                    PIC 9(02).                      
           05  WS-SS                    PIC 9(02).                      
           05  WS-TT                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE ':'.            
           05  WS-RT-SS                 PIC X(02).                      
      *                                                                         
       01  WS-CURRENT-DATE1.                                            
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-DD                 PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE '/'.            
           05  WS-RD-YY                 PIC X(04).                      
      *                                                                         
      ***************** PCSRP016 REPORT HEADERS ***********************         
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  P-RPT1-TITLE-PGM     PIC X(08).                      
               10  FILLER               PIC X(36) VALUE SPACES.         
               10  WS-HOLD-TITLE-1      PIC X(74).                      
               10  FILLER               PIC X(04) VALUE 'PAGE'.         
               10  FILLER               PIC X(05) VALUE SPACES.         
               10  P-RPT1-TITLE-PGNM    PIC X(02) VALUE SPACES.         
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(06) VALUE 'DATE: '.       
               10  P-RPT1-DATE          PIC X(10).                      
               10  FILLER               PIC X(19) VALUE SPACES.         
               10  P-RPT1-HEAD1         PIC X(74).                      
               10  FILLER               PIC X(10) VALUE 'RUN DATE: '.   
               10  P-RPT1-RUN-DATE      PIC X(10).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER               PIC X(112) VALUE SPACES.        
               10  FILLER               PIC X(12) VALUE 'RUN TIME:   '. 
               10  P-RPT1-RUN-TIME      PIC X(08).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
      *                                                                         
           05  WS-RPT1-HEADER-4.                                        
               10  FILLER               PIC X(132) VALUE SPACES.        
      *                                                                         
           05  WS-RPT1-HEADER-5.                                        
               10  FILLER               PIC X(04) VALUE SPACES.         
               10  FILLER               PIC X(10) VALUE 'ACCOUNT NO'.   
               10  FILLER               PIC X(06) VALUE SPACES.         
               10  FILLER               PIC X(05) VALUE 'CYCLE'.        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(15)                       
                                        VALUE 'LAST REV. MONTH'.        
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(12) VALUE 'LOCAL OFFICE'. 
               10  FILLER               PIC X(03) VALUE SPACES.         
               10  FILLER               PIC X(08) VALUE 'METER NO'.     
               10  FILLER               PIC X(12) VALUE SPACES.         
               10  FILLER               PIC X(04) VALUE 'NAME'.         
               10  FILLER               PIC X(19) VALUE SPACES.         
               10  FILLER               PIC X(11) VALUE 'STREET NAME'.  
               10  FILLER               PIC X(18) VALUE SPACES.         
      *                                                                         
       01  WS-SR-DTL.                                                   
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 SR-ACCOUNT-NO             PIC X(16).                      
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 SR-BILL-CYCLE             PIC X(02).                      
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 SR-REVENUE-MONTH          PIC 9(06).                      
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 SR-LOCAL-OFFICE           PIC X(03).                      
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 SR-METER-NO               PIC X(09).                      
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 SR-NAME                   PIC X(20).                      
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 SR-ADDRESS                PIC X(30).                      
           05 FILLER                    PIC X(06) VALUE SPACES.         
      *                                                                         
       01  WS-CG-DTL.                                                   
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 CG-ACCOUNT-NO             PIC X(16).                      
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 CG-BILL-CYCLE             PIC X(02).                      
           05 FILLER                    PIC X(11) VALUE SPACES.         
           05 CG-REVENUE-MONTH          PIC 9(06).                      
           05 FILLER                    PIC X(10) VALUE SPACES.         
           05 CG-LOCAL-OFFICE           PIC X(03).                      
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 CG-METER-NO               PIC X(09).                      
           05 FILLER                    PIC X(03) VALUE SPACES.         
           05 CG-NAME                   PIC X(20).                      
           05 FILLER                    PIC X(04) VALUE SPACES.         
           05 CG-ADDRESS                PIC X(30).                      
           05 FILLER                    PIC X(06) VALUE SPACES.         
      *                                                                         
       01  WS-END-DATA-LINE3.                                           
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     '*** END OF REPORT ***'.                           
           05  FILLER                   PIC X(55) VALUE SPACES.         
      *                                                                         
       01  WS-NO-DATA.                                                  
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(25) VALUE                 
                     '*** NO ACCOUNTS FOUND ***'.                       
           05  FILLER                   PIC X(52) VALUE SPACES.         
      *                                                                         
       01  WS-NO-CIG-DATA.                                              
           05  FILLER                   PIC X(55) VALUE SPACES.         
           05  FILLER                   PIC X(29) VALUE                 
                     '*** NO CIG ACCOUNTS FOUND ***'.                   
           05  FILLER                   PIC X(49) VALUE SPACES.         
      *                                                                         
       01  WS-SPACES.                                                   
           05  FILLER                   PIC X(133) VALUE SPACES.        
      *                                                                         
      ******************************************************************        
      * THIS IS THE DRIVING CURSOR OF THIS PROGRAM FETCHING DETAILS    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DTLS_CSR CURSOR FOR                               
                (SELECT AT.ACCOUNT_NO                                   
                       ,AT.BILL_CYCLE                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,MN.METER_NO                                     
                       ,MN.CODE_UTIL_TYPE                               
                       ,MN.IC_NO                                        
                       ,AT.COMPANY_NO                                   
                       ,AT.REV_MTH_LST_NRML                             
                       ,CIS.SUBSTR3(DQ.FULL_NAME,1,20)                       
                       ,(DY.HOUSE_NO + DY.STREET_NAME)                          
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_MTRD_ENVRNMT       MN WITH(READUNCOMMITTED)         
                       ,CSS_NAME_ACCT_XREF     HT WITH(READUNCOMMITTED)         
                       ,CSS_NAME               DQ WITH(READUNCOMMITTED)         
                       ,CSS_ADDR_FORMATTED     DY WITH(READUNCOMMITTED)         
                 WHERE AT.ACCOUNT_NO  = MN.ACCOUNT_NO                   
                   AND HT.ACCOUNT_NO  = MN.ACCOUNT_NO                   
                   AND HT.CUSTOMER_NO = AT.CUSTOMER_NO                  
                   AND HT.PREMISE_NO  = AT.PREMISE_NO                   
                   AND HT.NAME_ID     = DQ.NAME_ID                      
                   AND HT.ADDRESS_ID  = DY.ADDRESS_ID                   
                   AND DQ.NAME_TYPE   = 'CN'                            
                   AND MN.CODE_METER_STATUS IN ('A','B','I')            
                   AND AT.ACCOUNT_NO        IN (                        
                       SELECT UT.ACCOUNT_NO                             
                         FROM CSS_UTIL_ENVRNMT   UT
                           WITH(READUNCOMMITTED)                     
                             ,CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                     
                        WHERE UT.ACCOUNT_NO      = AT.ACCOUNT_NO        
                          AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO      
                          AND RD.SECURED_RATE_FL = 'Y')                 
                   AND (( AT.BILL_CYCLE <= (                            
                       SELECT MAX(BN.BILL_CYCLE)                        
                         FROM CSS_BILL_WINDOW    BN
                           WITH(READUNCOMMITTED)                     
                        WHERE BN.DATE_EXTRACT    = 
              IIF(TRY_CONVERT(DATE, :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )     
                          AND BN.REVENUE_MONTH   = :WS-MIN-REV-MONTH    
                          AND BN.BILL_CYCLE <> '21'                     
                    )                                                   
                   AND AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )        
                    OR (  AT.BILL_CYCLE =  (                            
                      SELECT MAX(BN.BILL_CYCLE)                         
                        FROM CSS_BILL_WINDOW     BN
                           WITH(READUNCOMMITTED)                     
                       WHERE BN.DATE_EXTRACT     = 
              IIF(TRY_CONVERT(DATE, :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )     
                         AND BN.REVENUE_MONTH    = :WS-MIN-REV-MONTH    
                         AND BN.BILL_CYCLE       =  '21'                
                    )                                                   
                   AND AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )        
                    OR ( AT.BILL_CYCLE <= (                             
                          SELECT MAX(BN.BILL_CYCLE)                     
                            FROM CSS_BILL_WINDOW BN
                           WITH(READUNCOMMITTED)                     
                           WHERE BN.DATE_EXTRACT  = 
              IIF(TRY_CONVERT(DATE, :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )    
                             AND BN.REVENUE_MONTH = :WS-MAX-REV-MONTH   
                             AND BN.BILL_CYCLE <> '21'                  
                     )                                                  
                   AND AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )        
                    OR ( AT.BILL_CYCLE =  (                             
                          SELECT MAX(BN.BILL_CYCLE)                     
                            FROM CSS_BILL_WINDOW BN
                           WITH(READUNCOMMITTED)                     
                           WHERE BN.DATE_EXTRACT  = 
              IIF(TRY_CONVERT(DATE, :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )    
                             AND BN.REVENUE_MONTH = :WS-MAX-REV-MONTH   
                             AND BN.BILL_CYCLE    =  '21'               
                     )                                                  
                   AND AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )        
                    )                                                   
                   AND (AT.REV_MTH_LST_NRML  <> 0 OR                    
                       (AT.REV_MTH_LST_NRML   = 0 AND                   
                       (CAST(ACCT_CREATE_DT AS DATE) <=                         
                        DATEADD( DAY, -60, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))))             
                   AND AT.CODE_ACCT_STAT      = 'A'                     
MAN003           )
                 ORDER BY AT.COMPANY_NO                                 
                         ,AT.BILL_CYCLE                                 
MAN003*          )                                                              
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTLS_CSR CURSOR FOR                                       
MFA-TR*         (SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.BILL_CYCLE                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.CODE_UTIL_TYPE                                       
MFA-TR*                ,MN.IC_NO                                                
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.REV_MTH_LST_NRML                                     
MFA-TR*                ,SUBSTR(DQ.FULL_NAME,1,20)                               
MFA-TR*                ,(DY.HOUSE_NO ||                                         
MFA-TR*                 DY.STREET_NAME)                                         
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_MTRD_ENVRNMT       MN                               
MFA-TR*                ,CSS_NAME_ACCT_XREF     HT                               
MFA-TR*                ,CSS_NAME               DQ                               
MFA-TR*                ,CSS_ADDR_FORMATTED     DY                               
MFA-TR*          WHERE AT.ACCOUNT_NO  = MN.ACCOUNT_NO                           
MFA-TR*            AND HT.ACCOUNT_NO  = MN.ACCOUNT_NO                           
MFA-TR*            AND HT.CUSTOMER_NO = AT.CUSTOMER_NO                          
MFA-TR*            AND HT.PREMISE_NO  = AT.PREMISE_NO                           
MFA-TR*            AND HT.NAME_ID     = DQ.NAME_ID                              
MFA-TR*            AND HT.ADDRESS_ID  = DY.ADDRESS_ID                           
MFA-TR*            AND DQ.NAME_TYPE   = 'CN'                                    
MFA-TR*            AND MN.CODE_METER_STATUS IN ('A','B','I')                    
MFA-TR*            AND AT.ACCOUNT_NO        IN (                                
MFA-TR*                SELECT UT.ACCOUNT_NO                                     
MFA-TR*                  FROM CSS_UTIL_ENVRNMT   UT                             
MFA-TR*                      ,CSS_RATE_PLAN_DESC RD                             
MFA-TR*                 WHERE UT.ACCOUNT_NO      = AT.ACCOUNT_NO                
MFA-TR*                   AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO              
MFA-TR*                   AND RD.SECURED_RATE_FL = 'Y')                         
MFA-TR*            AND (( AT.BILL_CYCLE <= (                                    
MFA-TR*                SELECT MAX(BN.BILL_CYCLE)                                
MFA-TR*                  FROM CSS_BILL_WINDOW    BN                             
MFA-TR*                 WHERE BN.DATE_EXTRACT    = :WS-DATE-EXTRACT             
MFA-TR*                   AND BN.REVENUE_MONTH   = :WS-MIN-REV-MONTH            
MFA-TR*                   AND BN.BILL_CYCLE <> '21'                             
MFA-TR*             )                                                           
MFA-TR*            AND AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )                
MFA-TR*             OR (  AT.BILL_CYCLE =  (                                    
MFA-TR*               SELECT MAX(BN.BILL_CYCLE)                                 
MFA-TR*                 FROM CSS_BILL_WINDOW     BN                             
MFA-TR*                WHERE BN.DATE_EXTRACT     = :WS-DATE-EXTRACT             
MFA-TR*                  AND BN.REVENUE_MONTH    = :WS-MIN-REV-MONTH            
MFA-TR*                  AND BN.BILL_CYCLE       =  '21'                        
MFA-TR*             )                                                           
MFA-TR*            AND AT.REV_MTH_LST_NRML < :WS-MIN-REV-MONTH )                
MFA-TR*             OR ( AT.BILL_CYCLE <= (                                     
MFA-TR*                   SELECT MAX(BN.BILL_CYCLE)                             
MFA-TR*                     FROM CSS_BILL_WINDOW BN                             
MFA-TR*                    WHERE BN.DATE_EXTRACT  = :WS-DATE-EXTRACT            
MFA-TR*                      AND BN.REVENUE_MONTH = :WS-MAX-REV-MONTH           
MFA-TR*                      AND BN.BILL_CYCLE <> '21'                          
MFA-TR*              )                                                          
MFA-TR*            AND AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )                
MFA-TR*             OR ( AT.BILL_CYCLE =  (                                     
MFA-TR*                   SELECT MAX(BN.BILL_CYCLE)                             
MFA-TR*                     FROM CSS_BILL_WINDOW BN                             
MFA-TR*                    WHERE BN.DATE_EXTRACT  = :WS-DATE-EXTRACT            
MFA-TR*                      AND BN.REVENUE_MONTH = :WS-MAX-REV-MONTH           
MFA-TR*                      AND BN.BILL_CYCLE    =  '21'                       
MFA-TR*              )                                                          
MFA-TR*            AND AT.REV_MTH_LST_NRML < :WS-MAX-REV-MONTH )                
MFA-TR*             )                                                           
MFA-TR*            AND (AT.REV_MTH_LST_NRML  <> 0 OR                            
MFA-TR*                (AT.REV_MTH_LST_NRML   = 0 AND                           
MFA-TR*                (DATE(ACCT_CREATE_DT) <=                                 
MFA-TR*                 DATE(:WS-CURRENT-DATE) - 60 DAYS)))                     
MFA-TR*            AND AT.CODE_ACCT_STAT      = 'A'                             
MFA-TR*          )
MFA-TR*          ORDER BY AT.COMPANY_NO                                         
MFA-TR*                  ,AT.BILL_CYCLE                                         
MFA-TR*          )                                                              
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE FOURTH_DAY_CSR CURSOR FOR                         
                SELECT DATE_EXTRACT                                     
                  FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                 WHERE BILL_CYCLE   = '21'                              
                   AND REVENUE_MONTH = :WS-MIN-REV-MONTH                
                 ORDER BY DATE_EXTRACT                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FOURTH_DAY_CSR CURSOR FOR                                 
MFA-TR*         SELECT DATE_EXTRACT                                             
MFA-TR*           FROM CSS_BILL_WINDOW                                          
MFA-TR*          WHERE BILL_CYCLE   = '21'                                      
MFA-TR*            AND REVENUE_MONTH = :WS-MIN-REV-MONTH                        
MFA-TR*          ORDER BY DATE_EXTRACT                                          
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7900                                                     
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
                                                                        
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
                                                                        
           PERFORM 2000-PROCESS-OUTPUT              THRU  2000-EXIT.    
                                                                        
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                     TO WS-RT-HH.                  
           MOVE WS-MM                     TO WS-RT-MM.                  
           MOVE WS-SS                     TO WS-RT-SS.                  
           MOVE WS-RUN-TIME               TO P-RPT1-RUN-TIME.           
      *                                                                         
           ACCEPT WS-CURRENT-DATE1 FROM DATE YYYYMMDD.                  
           MOVE WS-CY                     TO WS-RD-YY.                  
           MOVE WS-CM                     TO WS-RD-MM.                  
           MOVE WS-CD                     TO WS-RD-DD.                  
           MOVE WS-RUN-DATE               TO P-RPT1-RUN-DATE            
                                             P-RPT1-DATE.               
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT.                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7300-GET-COMMON-DATE             THRU 7300-EXIT.     
           MOVE WS-DATE-EXTRACT           TO WS-CURRENT-DATE.           
           DISPLAY 'RUN  DATE = ' WS-CURRENT-DATE.                      
      *                                                                         
           PERFORM 7400-GET-REVENUE-MONTH           THRU 7400-EXIT.     
           MOVE WS-MAX-REV-MONTH          TO WS-REV-MONTH.              
           DISPLAY 'MAX MONTH = ' WS-MAX-REV-MONTH.                     
           DISPLAY 'MIN MONTH = ' WS-MIN-REV-MONTH.                     
           DISPLAY 'REV MONTH = ' WS-REV-MONTH.                         
      *                                                                         
           PERFORM 7500-GET-MAX-BILL-CYCLE          THRU 7500-EXIT.     
           DISPLAY 'HONK-CYCLE = ' WS-BILL-CYCLE1.                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT                                          **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-OPEN-DTLS-CSR               THRU 7000-EXIT.     
      *                                                                         
           PERFORM 7100-FETCH-DTLS-CSR              THRU 7100-EXIT.     
      *                                                                         
           PERFORM 2200-PROCESS-ACCOUNT-DTLS        THRU 2200-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           PERFORM 7200-CLOSE-DTLS-CSR              THRU 7200-EXIT.     
      *                                                                         
           PERFORM 2800-MOVE-TRLR-DATA              THRU 2800-EXIT.     
           PERFORM 2910-NO-REPORT                   THRU 2910-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-ACCOUNT-DTLS                                    **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ACCOUNT-DTLS.                                       
      *                                                                         
           MOVE AT-ACCOUNT-NO             TO UT-ACCOUNT-NO.             
           MOVE AT-COMPANY-NO             TO C7-COMPANY-NO.             
           MOVE MN-CODE-UTIL-TYPE         TO UT-CODE-UTIL-TYPE          
                                             J1-CODE-UTIL-TYPE.         
           MOVE MN-IC-NO                  TO UT-IC-NO.                  
                                                                        
           MOVE WS-NO                     TO WS-CIG-ACCOUNT             
                                             WS-PRINT-SECRPT            
                                             WS-PRINT-CIGRPT.           
           MOVE SPACES                    TO WS-FOURTH-DAY.             
           PERFORM 2300-FORMAT-ACCOUNTS             THRU 2300-EXIT.     
      *                                                                         
           IF AT-BILL-CYCLE = '21'                                      
              PERFORM 7700-GET-RATE-PLAN-NO         THRU 7700-EXIT      
              MOVE UT-RATE-PLAN-NO        TO J1-RATE-PLAN-NO            
              PERFORM 7800-CHK-CIG-ACCOUNT          THRU 7800-EXIT      
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-BILL-CYCLE1  = AT-BILL-CYCLE                      
               AND WS-CIG-ACCOUNT  = WS-NO                              
                   MOVE WS-YES            TO WS-PRINT-SECRPT            
                   PERFORM 2900-WRITE-REPORT        THRU 2900-EXIT      
                                                                        
              WHEN WS-BILL-CYCLE1  NOT = AT-BILL-CYCLE                  
               AND WS-CIG-ACCOUNT  = WS-YES                             
                   MOVE WS-YES            TO WS-PRINT-CIGRPT            
                   PERFORM 2400-GET-FOURTH-DAY      THRU 2400-EXIT      
                   IF WS-DATE-EXTRACT >= WS-FOURTH-DAY                  
                      PERFORM 2900-WRITE-REPORT     THRU 2900-EXIT      
                   END-IF                                               
                                                                        
              WHEN WS-BILL-CYCLE1  NOT = AT-BILL-CYCLE                  
               AND WS-CIG-ACCOUNT  = WS-NO                              
                   MOVE WS-YES            TO WS-PRINT-SECRPT            
                   PERFORM 2900-WRITE-REPORT        THRU 2900-EXIT      
           END-EVALUATE                                                 
                                                                        
           PERFORM 7100-FETCH-DTLS-CSR              THRU 7100-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-FORMAT-ACCOUNTS.                                        **        
      ******************************************************************        
      *                                                                         
       2300-FORMAT-ACCOUNTS.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO             TO WS-SAVE-ACCT.              
           MOVE WS-SAVE-ACCT1             TO WS-ACCT1.                  
           MOVE WS-SAVE-ACCT2             TO WS-ACCT2.                  
           MOVE WS-SAVE-ACCT3             TO WS-ACCT3.                  
           MOVE WS-SAVE-ACCT4             TO WS-ACCT4.                  
           MOVE AT-REV-MTH-LST-NRML       TO WS-REVENUE-MONTH.          
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-GET-FOURTH-DAY.                                         **        
      ******************************************************************        
      *                                                                         
       2400-GET-FOURTH-DAY.                                             
      *                                                                         
           MOVE WS-ONE                    TO WS-SUB.                    
      *                                                                         
           PERFORM 7910-OPEN-FOURTH-DAY-CSR         THRU 7910-EXIT.     
           PERFORM 7920-FETCH-FOURTH-DAY-CSR        THRU 7920-EXIT.     
      *                                                                         
           PERFORM UNTIL WS-SUB >= 4                                    
              COMPUTE WS-SUB = WS-SUB + 1                               
              PERFORM 7920-FETCH-FOURTH-DAY-CSR     THRU 7920-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7930-CLOSE-FOURTH-DAY-CSR        THRU 7930-EXIT.     
           DISPLAY '4TH DATE = ' WS-FOURTH-DAY.                         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-GET-COMPANY-NAME.                                       **        
      ******************************************************************        
      *                                                                         
       2500-GET-COMPANY-NAME.                                           
      *                                                                         
           PERFORM 7600-GET-COMPANY-NAME            THRU 7600-EXIT.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME        TO WS-HOLD-TITLE-1            
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-MOVE-DTL-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2600-MOVE-DTL-DATA.                                              
      *                                                                         
           PERFORM 2700-MOVE-HDR-DATA               THRU 2700-EXIT.     
      *****DATA RECORDS FOR SECURED REPORT                                      
           IF WS-PRINT-SECRPT  = WS-YES                                 
              MOVE WS-ACCOUNT1            TO SR-ACCOUNT-NO              
              MOVE AT-BILL-CYCLE          TO SR-BILL-CYCLE              
              MOVE WS-REVENUE-MONTH       TO SR-REVENUE-MONTH           
              MOVE AT-LOCAL-OFFICE        TO SR-LOCAL-OFFICE            
              MOVE MN-METER-NO            TO SR-METER-NO                
              MOVE WS-NAME                TO SR-NAME                    
              MOVE WS-ADDRESS             TO SR-ADDRESS                 
              MOVE WS-SR-DTL              TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-SPACES              TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-NO                  TO WS-NO-REPORT               
           END-IF.                                                      
                                                                        
      *****DATA RECORDS FOR CIG REPORT                                          
           IF WS-PRINT-CIGRPT  = WS-YES                                 
              MOVE WS-ACCOUNT1            TO CG-ACCOUNT-NO              
              MOVE AT-BILL-CYCLE          TO CG-BILL-CYCLE              
              MOVE WS-REVENUE-MONTH       TO CG-REVENUE-MONTH           
              MOVE AT-LOCAL-OFFICE        TO CG-LOCAL-OFFICE            
              MOVE MN-METER-NO            TO CG-METER-NO                
              MOVE WS-NAME                TO CG-NAME                    
              MOVE WS-ADDRESS             TO CG-ADDRESS                 
              MOVE WS-CG-DTL              TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-SPACES              TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-NO                  TO WS-NO-CIG-REPORT           
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-MOVE-HDR-DATA.                                            *        
      ******************************************************************        
      *                                                                         
       2700-MOVE-HDR-DATA.                                              
      *                                                                         
           MOVE WS-PROGRAM                TO P-RPT1-TITLE-PGM.          
      *                                                                         
      *****HEADER RECORD FOR SECURED REPORT                                     
           IF WS-PRINT-SECRPT = WS-YES                                  
             IF C7-COMPANY-NO NOT EQUAL WS-COMPANY-NO-DTL OR            
                WS-LINE-COUNT1 GREATER THAN 52                          
                MOVE ZEROES               TO WS-LINE-COUNT1             
                ADD +1                    TO WS-PAGE-NUM1               
                MOVE WS-PAGE-NUM1         TO P-RPT1-TITLE-PGNM          
                PERFORM 2500-GET-COMPANY-NAME       THRU 2500-EXIT      
                MOVE C7-COMPANY-NO        TO WS-COMPANY-NO-DTL          
                MOVE WS-RPT1-HEADER-1     TO PRT33-RECORD               
                PERFORM 8000-WRITE-SR-ACCTS         THRU 8000-EXIT      
                MOVE WS-HDR-SEC           TO P-RPT1-HEAD1               
                MOVE WS-RPT1-HEADER-2     TO PRT33-RECORD               
                PERFORM 8000-WRITE-SR-ACCTS         THRU 8000-EXIT      
                MOVE WS-RPT1-HEADER-3     TO PRT33-RECORD               
                PERFORM 8000-WRITE-SR-ACCTS         THRU 8000-EXIT      
                MOVE WS-RPT1-HEADER-4     TO PRT33-RECORD               
                PERFORM 8000-WRITE-SR-ACCTS         THRU 8000-EXIT      
                MOVE WS-RPT1-HEADER-5     TO PRT33-RECORD               
                PERFORM 8000-WRITE-SR-ACCTS         THRU 8000-EXIT      
                SET SR-TRLR-DATA-REQ      TO TRUE                       
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *****HEADER RECORD FOR CIG REPORT                                         
           IF WS-PRINT-CIGRPT = WS-YES                                  
             IF C7-COMPANY-NO NOT EQUAL WS-COMPANY-NO-CIG OR            
                WS-LINE-COUNT2 GREATER THAN 52                          
                MOVE ZEROES               TO WS-LINE-COUNT2             
                ADD +1                    TO WS-PAGE-NUM2               
                MOVE WS-PAGE-NUM2         TO P-RPT1-TITLE-PGNM          
                PERFORM 2500-GET-COMPANY-NAME       THRU 2500-EXIT      
                MOVE C7-COMPANY-NO        TO WS-COMPANY-NO-CIG          
                MOVE WS-RPT1-HEADER-1     TO PRT331-RECORD              
                PERFORM 8100-WRITE-CG-ACCTS         THRU 8100-EXIT      
                MOVE WS-HDR-CIG           TO P-RPT1-HEAD1               
                MOVE WS-RPT1-HEADER-2     TO PRT331-RECORD              
                PERFORM 8100-WRITE-CG-ACCTS         THRU 8100-EXIT      
                MOVE WS-RPT1-HEADER-3     TO PRT331-RECORD              
                PERFORM 8100-WRITE-CG-ACCTS         THRU 8100-EXIT      
                MOVE WS-RPT1-HEADER-4     TO PRT331-RECORD              
                PERFORM 8100-WRITE-CG-ACCTS         THRU 8100-EXIT      
                MOVE WS-RPT1-HEADER-5     TO PRT331-RECORD              
                PERFORM 8100-WRITE-CG-ACCTS         THRU 8100-EXIT      
                SET CG-TRLR-DATA-REQ      TO TRUE                       
             END-IF                                                     
            END-IF.                                                     
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-MOVE-TRLR-DATA.                                           *        
      ******************************************************************        
      *                                                                         
       2800-MOVE-TRLR-DATA.                                             
      *                                                                         
      *****TRAILER RECORD FOR SECURED REPORT                                    
           IF SR-TRLR-DATA-REQ                                          
              MOVE WS-END-DATA-LINE3      TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
           END-IF.                                                      
      *                                                                         
      *****TRAILER RECORD FOR CIG REPORT                                        
           IF CG-TRLR-DATA-REQ                                          
              MOVE WS-END-DATA-LINE3      TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2900-WRITE-REPORT.                                             *        
      ******************************************************************        
      *                                                                         
       2900-WRITE-REPORT.                                               
      *                                                                         
           PERFORM 2700-MOVE-HDR-DATA               THRU 2700-EXIT.     
           PERFORM 2600-MOVE-DTL-DATA               THRU 2600-EXIT.     
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2910-NO-REPORT.                                                *        
      ******************************************************************        
      *                                                                         
       2910-NO-REPORT.                                                  
      *                                                                         
           MOVE WS-SCEG-TITLE             TO WS-HOLD-TITLE-1.           
           MOVE WS-PROGRAM                TO P-RPT1-TITLE-PGM.          
           MOVE WS-ONE                    TO P-RPT1-TITLE-PGNM.         
      *                                                                         
           IF WS-NO-REPORT = WS-YES                                     
              MOVE WS-RPT1-HEADER-1       TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-HDR-SEC             TO P-RPT1-HEAD1               
              MOVE WS-RPT1-HEADER-2       TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-RPT1-HEADER-3       TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-RPT1-HEADER-4       TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-NO-DATA             TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
              MOVE WS-SPACES              TO PRT33-RECORD               
              PERFORM 8000-WRITE-SR-ACCTS           THRU 8000-EXIT      
           END-IF.                                                      
      *                                                                         
           IF WS-NO-CIG-REPORT = WS-YES                                 
              MOVE WS-RPT1-HEADER-1       TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-HDR-CIG             TO P-RPT1-HEAD1               
              MOVE WS-RPT1-HEADER-2       TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-RPT1-HEADER-3       TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-RPT1-HEADER-4       TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-NO-CIG-DATA         TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
              MOVE WS-SPACES              TO PRT331-RECORD              
              PERFORM 8100-WRITE-CG-ACCTS           THRU 8100-EXIT      
           END-IF.                                                      
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-DTLS-CSR                                             *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-DTLS-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN DTLS_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT ******'                  
              DISPLAY '**  7000-OPEN-DTLS-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT ' WS-DATE-EXTRACT            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DTLS_CSR                                            
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-IC-NO                                           
                   ,:AT-COMPANY-NO                                      
                   ,:AT-REV-MTH-LST-NRML                                
                   ,:WS-NAME                                            
                   ,:WS-ADDRESS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7100-FETCH-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT = ' WS-DATE-EXTRACT          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DTLS_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7200-CLOSE-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT = ' WS-DATE-EXTRACT          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7300-GET-COMMON-DATE                                        **        
      ******************************************************************        
      *                                                                         
       7300-GET-COMMON-DATE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3(PARM_DATA,1,10) E) T)                       
                INTO :WS-DATE-EXTRACT                                   
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'COMMONDATE'                        
                 AND CMND_CODE    = 'CA00'                              
                 AND COMPANY_NO   = '01'                                
                 AND STATUS       = 'A'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(SUBSTR(PARM_DATA,1,10))                               
MFA-TR*         INTO :WS-DATE-EXTRACT                                           
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'COMMONDATE'                                
MFA-TR*          AND CMND_CODE    = 'CA00'                                      
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7300-GET-COMMON-DATE   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7400-GET-REVENUE-MONTH                                      **        
      ******************************************************************        
      *                                                                         
       7400-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(REVENUE_MONTH)                                 
                    ,MIN(REVENUE_MONTH)                                 
                INTO :WS-MAX-REV-MONTH                                  
                    ,:WS-MIN-REV-MONTH                                  
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*             ,MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :WS-MAX-REV-MONTH                                          
MFA-TR*             ,:WS-MIN-REV-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :WS-DATE-EXTRACT                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7400-GET-REVENUE-MONTH **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT = ' WS-DATE-EXTRACT          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7500-GET-MAX-BILL-CYCLE                                     **        
      ******************************************************************        
      *                                                                         
       7500-GET-MAX-BILL-CYCLE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(BILL_CYCLE)                                    
                INTO :WS-BILL-CYCLE1                                    
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-EXTRACT
              ), CONVERT(DATE, :WS-DATE-EXTRACT) )                   
                 AND BILL_CYCLE    <> '21'                              
                 AND REVENUE_MONTH = :WS-REV-MONTH                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BILL_CYCLE)                                            
MFA-TR*         INTO :WS-BILL-CYCLE1                                            
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT  = :WS-DATE-EXTRACT                           
MFA-TR*          AND BILL_CYCLE    <> '21'                                      
MFA-TR*          AND REVENUE_MONTH = :WS-REV-MONTH                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7500-GET-MAX-BILL-CYCLE**'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT = ' WS-DATE-EXTRACT          
              DISPLAY '**  WS-REV-MONTH = ' WS-REV-MONTH                
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7600-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7600-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7600-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7700-GET-RATE-PLAN-NO.                                      **        
      ******************************************************************        
      *                                                                         
       7700-GET-RATE-PLAN-NO.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT RATE_PLAN_NO                                       
                INTO :UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
                 AND IC_NO          = :UT-IC-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO                                               
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :UT-IC-NO                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7700-GET-RATE-PLAN-NO  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  UT-ACCOUNT-NO = ' UT-ACCOUNT-NO              
              DISPLAY '**  UT-CODE-UTIL-TYPE = ' UT-CODE-UTIL-TYPE      
              DISPLAY '**  UT-IC-NO = ' UT-IC-NO                        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7800-CHK-CIG-ACCOUNT.                                       **        
      ******************************************************************        
      *                                                                         
       7800-CHK-CIG-ACCOUNT.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CIG-ACCOUNT                                    
                FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
                 AND REG_TYPE_CD      = 'D'                             
                 AND VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)   
                FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO)               
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CIG-ACCOUNT                                            
MFA-TR*         FROM CSS_RATE_COMP_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                        
MFA-TR*          AND REG_TYPE_CD      = 'D'                                     
MFA-TR*          AND VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)           
MFA-TR*         FROM CSS_RATE_COMP_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO)                       
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7800-CHK-CIG-ACCOUNT   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  J1-RATE-PLAN-NO = ' J1-RATE-PLAN-NO          
              DISPLAY '**  J1-CODE-UTIL-TYPE = ' J1-CODE-UTIL-TYPE      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7910-OPEN-FOURTH-DAY-CSR.                                      *        
      ******************************************************************        
      *                                                                         
       7910-OPEN-FOURTH-DAY-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN FOURTH_DAY_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT ******'                  
              DISPLAY '**  7910-OPEN-FOURTH-DAY-CSR**'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT ' WS-DATE-EXTRACT            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7920-FETCH-FOURTH-DAY-CSR.                                  **        
      ******************************************************************        
      *                                                                         
       7920-FETCH-FOURTH-DAY-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH FOURTH_DAY_CSR                                      
               INTO :WS-FOURTH-DAY                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7920-FETCH-FOURTH-DAY-CSR**'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-MIN-REV-MONTH = ' WS-MIN-REV-MONTH        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7930-CLOSE-FOURTH-DAY-CSR.                                     *        
      ******************************************************************        
      *                                                                         
       7930-CLOSE-FOURTH-DAY-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE FOURTH_DAY_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSRP016 ABORT *****'                   
              DISPLAY '**  7930-CLOSE-FOURTH-DAY-CSR**'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-DATE-EXTRACT = ' WS-DATE-EXTRACT          
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSSR015                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-SR-ACCTS.                                             
      *                                                                         
           WRITE PRT33-RECORD.                                          
                                                                        
           ADD +1                         TO WS-LINE-COUNT1.            
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSCG16                                           **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-CG-ACCTS.                                             
      *                                                                         
           WRITE PRT331-RECORD.                                         
                                                                        
           ADD +1                         TO WS-LINE-COUNT2.            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
                                                                        
           CLOSE FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
