       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSRP015.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     OCT 19,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      *** THIS PROGRAM PRINTS A RATE REVIEW REPORT FOR PSNC.         ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT028***  10/19/2015    MS7M727     EZT TO COBOL CONVERSION         ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSBW04-FILE                                          
               ASSIGN TO UT-S-FCSBW04                                   
               FILE STATUS IS WS-FCSBW04-STATUS.                        
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN UT-S-FCSPT33                                      
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       FD  FCSBW04-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01 FIOBW04-RECORD                    PIC X(69).                  
      *                                                                         
       COPY FIOBW04.                                                            
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSRP015'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01 WS-LITERAL.                                                   
          05 WS-PROGRAM-NAME                 PIC X(08) VALUE 'PCSRP015'.
      *                                                                         
          05  WS-FINAL-BILLED-STATUS         PIC X(01) VALUE 'B'.       
          05  WS-WRITTEN-OFF-STATUS          PIC X(01) VALUE 'S'.       
      *                                                                         
       01 WS-FILE-STATUS-SW.                                            
          05  WS-FCSBW04-STATUS              PIC X(02).                 
              88 FCSBW04-SUCCESSFUL                    VALUE '00'.      
              88 END-OF-REC                            VALUE '10'.      
      *                                                                         
          05  WS-FCSPT33-STATUS              PIC  X(02).                
              88 FCSPT33-SUCCESSFUL                    VALUE '00'.      
      *                                                                         
       01 WS-RATE-PLAN-SW.                                              
          05  WS-PRINT-RATE-PLAN-STATUS      PIC X(01).                 
              88 PRINT-RATE-PLAN-NO                    VALUE 'Y'.       
      *                                                                         
       01 WS-MIN-MAX                         PIC S9(06)V VALUE ZERO.    
       01 WS-CURR-MIN-MAX                    PIC S9(06)V VALUE ZERO.    
       01 WS-MIN-MAX-C                       PIC 9(06)V  VALUE ZERO.    
       01 WS-THRM-HDG                        PIC S9(06)V VALUE ZERO.    
      *                                                                         
       01 WS-ACCOUNT-NO                      PIC S9(13)V VALUE ZERO.    
      *                                                                         
       01 WS-ACCT-NO.                                                   
           05 WS-ACCT-NO1                    PIC 9(01) VALUE ZERO.      
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCT-NO2                    PIC 9(04) VALUE ZERO.      
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCT-NO3                    PIC 9(04) VALUE ZERO.      
           05 FILLER                         PIC X(01) VALUE '-'.       
           05 WS-ACCT-NO4                    PIC 9(04)V VALUE ZERO.     
      *                                                                         
       01 WS-DATE.                                                      
           05 WS-DATE-Y                      PIC 9(04) VALUE ZERO.      
           05 WS-DATE-M                      PIC 9(02) VALUE ZERO.      
      *                                                                         
       01 WS-CURR-BEG.                                                  
           05 WS-CURR-BEG-Y                  PIC 9(04) VALUE ZERO.      
           05 WS-CURR-BEG-M                  PIC 9(02) VALUE ZERO.      
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-TOTAL-PREV-YR-THERMS        PIC S9(11) VALUE ZERO.     
           05 WS-TOTAL-CURR-YR-THERMS        PIC S9(11) VALUE ZERO.     
           05 WS-TOTAL-PREV-YR-THERMS-C      PIC 9(11) VALUE ZERO.      
           05 WS-TOTAL-CURR-YR-THERMS-C      PIC 9(11) VALUE ZERO.      
           05 WS-PREV-LOCAL-OFFICE           PIC X(03) VALUE SPACES.    
           05 WS-CURR-LOCAL-OFFICE           PIC X(03) VALUE SPACES.    
           05 WS-PAGE-NUM                    PIC 9(03) VALUE ZERO.      
           05 WS-CURR-HDG-RATE               PIC X(03) VALUE SPACES.    
           05 WS-CURR-SIGN-HDG               PIC X(01) VALUE SPACES.    
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                         PIC 9(02) VALUE ZERO.      
           05  WS-MM                         PIC 9(02) VALUE ZERO.      
           05  WS-SS                         PIC 9(02) VALUE ZERO.      
           05  WS-TT                         PIC 9(02) VALUE ZERO.      
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '.'.       
           05  WS-RT-MM                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '.'.       
           05  WS-RT-SS                      PIC X(02) VALUE SPACES.    
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                         PIC 9(04) VALUE ZERO.      
           05  WS-CM                         PIC 9(02) VALUE ZERO.      
           05  WS-CD                         PIC 9(02) VALUE ZERO.      
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '/'.       
           05  WS-RD-DD                      PIC X(02) VALUE SPACES.    
           05  FILLER                        PIC X(01) VALUE '/'.       
           05  WS-RD-YY                      PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-DATE.                                               
           05 WS-REPT-DATE-M                 PIC X(02) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '/'.       
           05 WS-REPT-DATE-Y                 PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-CURR-BEGINS.                                               
           05 WS-CURR-BEGINS-M               PIC X(02) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '/'.       
           05 WS-CURR-BEGINS-Y               PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-CURR-ENDS.                                                 
           05 WS-CURR-ENDS-M                 PIC X(02) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '/'.       
           05  WS-CURR-ENDS-Y                PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-PREV-BEGINS.                                               
           05 WS-PREV-BEGINS-M               PIC X(02) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '/'.       
           05 WS-PREV-BEGINS-Y               PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-PREV-ENDS.                                                 
           05 WS-PREV-ENDS-M                 PIC X(02) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE '/'.       
           05 WS-PREV-ENDS-Y                 PIC X(04) VALUE SPACES.    
      *                                                                         
       01 WS-RATE-HDG.                                                  
           05 WS-HDG-1                       PIC X(04) VALUE 'RATE'.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-HDG-RATE                    PIC X(03) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-HDG-2                       PIC X(34) VALUE            
                                   'ACCOUNTS WITH 12 MONTH CONSUMPTION'.
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-SIGN-HDG                    PIC X(01) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-THRM-HDG-C                  PIC 9(06)V                 
                                                        VALUE ZERO.     
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 WS-HDG-3                       PIC X(02) VALUE 'TH'.      
      *                                                                         
       01 P-REPORT-HDR1.                                                
           05 FILLER                         PIC X(02) VALUE SPACES.    
           05 P-RPT-RPT-PGM                  PIC X(11) VALUE            
                                                      'PCSRP015-01'.    
           05 FILLER                         PIC X(44) VALUE SPACES.    
           05 P-RPT-RPT-COMPANY              PIC X(11) VALUE            
                                                      'PSNC ENERGY'.    
           05 FILLER                         PIC X(53) VALUE SPACES.    
           05 P-RPT-RPT-PAGE                 PIC X(04) VALUE 'PAGE'.    
           05 FILLER                         PIC X(04) VALUE SPACES.    
           05 P-RPT-PAGE-COUNT               PIC Z(03) VALUE ZERO.      
           05 FILLER                         PIC X(01) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR2.                                                
           05 FILLER                         PIC X(02) VALUE SPACES.    
           05 P-RPT-DATE                     PIC X(12) VALUE            
                                                     'REPORT DATE:'.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-DATE1                    PIC X(07) VALUE SPACES.    
           05 FILLER                         PIC X(17) VALUE SPACES.    
           05 P-RPT-RATE-HDG                 PIC X(55) VALUE SPACES.    
           05 FILLER                         PIC X(20) VALUE SPACES.    
           05 P-RPT-RUN-DATE                 PIC X(09) VALUE            
                                                     'RUN-DATE:'.       
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-RUN-DATE1                PIC X(08) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR3.                                                
           05 FILLER                         PIC X(114) VALUE SPACES.   
           05 P-RPT-RUN-TIME                 PIC X(09) VALUE            
                                                     'RUN-TIME:'.       
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-RUN-TIME1                PIC X(08) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR4                      PIC X(133) VALUE SPACES.   
      *                                                                         
       01 P-REPORT-HDR5.                                                
           05 FILLER                         PIC X(60) VALUE SPACES.    
           05 P-RPT-OFFICE                   PIC X(07) VALUE            
                                                        'OFFICE:'.      
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-LOCAL-OFFICE             PIC X(03) VALUE SPACES.    
           05 FILLER                         PIC X(52) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR6                      PIC X(133) VALUE SPACES.   
      *                                                                         
       01 P-REPORT-HDR7                      PIC X(133) VALUE SPACES.   
      *                                                                         
       01 P-REPORT-HDR8.                                                
           05 FILLER                         PIC X(86) VALUE SPACES.    
           05 P-RPT-12-MONTHS                PIC X(09) VALUE            
                                                         '12 MONTHS'.   
           05 FILLER                         PIC X(11) VALUE SPACES.    
           05 P-RPT-12-MONTHS1               PIC X(09) VALUE            
                                                         '12 MONTHS'.   
           05 FILLER                         PIC X(18) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR9.                                                
           05 FILLER                         PIC X(72) VALUE SPACES.    
           05 P-RPT-REV                      PIC X(03) VALUE 'REV'.     
           05 FILLER                         PIC X(12) VALUE SPACES.    
           05 P-RPT-PREV-BEGINS              PIC X(07) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-HYPEN                    PIC X(01) VALUE '-'.       
           05 FILLER                         PIC X(11) VALUE SPACES.    
           05 P-RPT-CURR-BEGINS              PIC X(07) VALUE SPACES.    
           05 FILLER                         PIC X(01) VALUE SPACES.    
           05 P-RPT-HYPEN1                   PIC X(01) VALUE '-'.       
           05 FILLER                         PIC X(16) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR10.                                               
           05 FILLER                         PIC X(17) VALUE SPACES.    
           05 P-RPT-ACCOUNT-NO               PIC X(10) VALUE            
                                                     'ACCOUNT NO'.      
           05 FILLER                         PIC X(14) VALUE SPACES.    
           05 P-RPT-CUSTOMER-NAME            PIC X(13) VALUE            
                                                     'CUSTOMER NAME'.   
           05 FILLER                         PIC X(11) VALUE SPACES.    
           05 P-RPT-RATE                     PIC X(04) VALUE 'RATE'.    
           05 FILLER                         PIC X(02) VALUE SPACES.    
           05 P-RPT-CLASS                    PIC X(05) VALUE 'CLASS'.   
           05 FILLER                         PIC X(12) VALUE SPACES.    
           05 P-RPT-PREV-ENDS                PIC X(07) VALUE SPACES.    
           05 FILLER                         PIC X(13) VALUE SPACES.    
           05 P-RPT-CURR-ENDS                PIC X(07) VALUE SPACES.    
           05 FILLER                         PIC X(17) VALUE SPACES.    
      *                                                                         
       01 P-REPORT-HDR11                     PIC X(133) VALUE SPACES.   
      *                                                                         
       01 P-REPORT-HDR12.                                               
           05 FILLER                         PIC X(14) VALUE SPACES.    
           05 P-RPT-ACCT-NO                  PIC 9(16)V VALUE ZERO.     
           05 FILLER                         PIC X(08) VALUE SPACES.    
           05 P-RPT-CUST-NAME                PIC X(25) VALUE SPACES.    
           05 FILLER                         PIC X(03) VALUE SPACES.    
           05 P-RPT-RATE-PLAN-NO             PIC X(03) VALUE SPACES.    
           05 FILLER                         PIC X(03) VALUE SPACES.    
           05 P-RPT-CODE-REV-CLASS           PIC X(03) VALUE SPACES.    
           05 FILLER                         PIC X(06) VALUE SPACES.    
           05 P-RPT-TOTAL-PREV-YR-THERMS     PIC                        
                                          ZZ,ZZZ,ZZZ,ZZZ VALUE ZERO.    
           05 FILLER                         PIC X(06) VALUE SPACES.    
           05 P-RPT-TOTAL-CUR-YR-THERMS      PIC                        
                                          ZZ,ZZZ,ZZZ,ZZZ VALUE ZERO.    
           05 FILLER                         PIC X(17) VALUE SPACES.    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU  0100-EXIT.        
                                                                        
           PERFORM 1000-PROCESS-INPUT           THRU  1000-EXIT.        
                                                                        
           PERFORM 9000-TERMINATE               THRU  9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME1.            
      *                                                                         
           ACCEPT WS-CURRENT-DATE  FROM DATE YYYYMMDD.                  
           MOVE WS-CY(3:2)               TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE1.            
      *                                                                         
           OPEN INPUT  FCSBW04-FILE.                                    
           IF NOT FCSBW04-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP015******************'         
               DISPLAY '**  ERROR OPENING FCSBW04           **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSBW04-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSRP015******************'         
               DISPLAY '**  ERROR OPENING FCSPT33           **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7100-READ-FCSBW04            THRU 7100-EXIT.         
           PERFORM 2100-PROCESS-HEADER          THRU 2100-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT          
             UNTIL END-OF-REC.                                          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-OUTPUT                                          **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE FIOBW04-RECORD           TO FIOBW04-REC.                
      *                                                                         
           IF BW04-CODE-ACCT-STAT NOT EQUAL WS-FINAL-BILLED-STATUS      
                                  AND WS-WRITTEN-OFF-STATUS             
              MOVE BW04-RATE-PLAN-NO     TO WS-HDG-RATE                 
              MOVE BW04-REVIEW-SIGN      TO WS-SIGN-HDG                 
              MOVE BW04-REVIEW-MAX-MIN-THERMS                           
                                         TO WS-THRM-HDG                 
              MOVE WS-THRM-HDG           TO WS-THRM-HDG-C               
              MOVE BW04-REVIEW-MAX-MIN-THERMS                           
                                         TO WS-MIN-MAX                  
              MOVE WS-MIN-MAX            TO WS-MIN-MAX-C                
              MOVE BW04-ACCOUNT-NO       TO WS-ACCOUNT-NO               
              MOVE WS-ACCOUNT-NO(1:1)    TO WS-ACCT-NO1                 
              MOVE WS-ACCOUNT-NO(2:4)    TO WS-ACCT-NO2                 
              MOVE WS-ACCOUNT-NO(6:4)    TO WS-ACCT-NO3                 
              MOVE WS-ACCOUNT-NO(10:4)   TO WS-ACCT-NO4                 
              MOVE BW04-LOCAL-OFFICE     TO WS-PREV-LOCAL-OFFICE        
              PERFORM 2400-WRITE-PROCESS        THRU 2400-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-READ-FCSBW04         THRU 7100-EXIT.            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-PROCESS-HEADER                                          **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-HEADER.                                             
      *                                                                         
              MOVE FIOBW04-RECORD        TO FIOBW04-BEGIN-REC.          
              MOVE BW04-REV-DT-BREC      TO WS-DATE.                    
              MOVE WS-DATE-M             TO WS-REPT-DATE-M.             
              MOVE WS-DATE-Y             TO WS-REPT-DATE-Y.             
              MOVE BW04-CURR-BEGINS      TO WS-DATE.                    
              MOVE WS-DATE-M             TO WS-CURR-BEGINS-M.           
              MOVE WS-DATE-Y             TO WS-CURR-BEGINS-Y            
              MOVE BW04-CURR-ENDS        TO WS-DATE.                    
              MOVE WS-DATE-M             TO WS-CURR-ENDS-M.             
              MOVE WS-DATE-Y             TO WS-CURR-ENDS-Y.             
              MOVE BW04-PREV-BEGINS      TO WS-DATE..                   
              MOVE WS-DATE-M             TO WS-PREV-BEGINS-M.           
              MOVE WS-DATE-Y             TO WS-PREV-BEGINS-Y.           
              MOVE BW04-PREV-ENDS        TO WS-DATE.                    
              MOVE WS-DATE-M             TO WS-PREV-ENDS-M.             
              MOVE WS-DATE-Y             TO WS-PREV-ENDS-Y.             
              PERFORM 7100-READ-FCSBW04         THRU 7100-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2200-WRITE-HEADER                                                       
      ****************************************************************          
      *                                                                         
       2200-WRITE-HEADER.                                               
      *                                                                         
            MOVE WS-PAGE-NUM             TO P-RPT-PAGE-COUNT.           
            MOVE P-REPORT-HDR1           TO PRT33-RECORD.               
            PERFORM 8000-WRITE-FCSPT33           THRU 8000-EXIT.        
      *                                                                         
            MOVE WS-REPORT-DATE          TO P-RPT-DATE1.                
            MOVE WS-RATE-HDG             TO P-RPT-RATE-HDG.             
            MOVE P-REPORT-HDR2           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR3           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR4           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE BW04-LOCAL-OFFICE       TO P-RPT-LOCAL-OFFICE.         
            MOVE P-REPORT-HDR5           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR6           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR7           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR8           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE WS-PREV-BEGINS          TO P-RPT-PREV-BEGINS.          
            MOVE WS-CURR-BEGINS          TO P-RPT-CURR-BEGINS.          
            MOVE P-REPORT-HDR9           TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE WS-PREV-ENDS            TO P-RPT-PREV-ENDS.            
            MOVE WS-CURR-ENDS            TO P-RPT-CURR-ENDS.            
            MOVE P-REPORT-HDR10          TO PRT33-RECORD.               
            PERFORM 8200-WRITE-FCSPT33          THRU 8200-EXIT.         
      *                                                                         
            MOVE P-REPORT-HDR11          TO PRT33-RECORD.               
            PERFORM 8100-WRITE-FCSPT33          THRU 8100-EXIT.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2300-WRITE-DETAIL-RECORD                                                
      ****************************************************************          
      *                                                                         
       2300-WRITE-DETAIL-RECORD.                                        
      *                                                                         
           MOVE BW04-CODE-REV-CLASS      TO P-RPT-CODE-REV-CLASS.       
           MOVE BW04-TOTAL-PREV-YR-THERMS                               
                                         TO WS-TOTAL-PREV-YR-THERMS.    
           MOVE WS-TOTAL-PREV-YR-THERMS                                 
                                         TO WS-TOTAL-PREV-YR-THERMS-C.  
           MOVE WS-TOTAL-PREV-YR-THERMS-C                               
                                         TO P-RPT-TOTAL-PREV-YR-THERMS. 
           MOVE BW04-TOTAL-CURR-YR-THERMS                               
                                         TO WS-TOTAL-CURR-YR-THERMS.    
           MOVE WS-TOTAL-CURR-YR-THERMS                                 
                                         TO WS-TOTAL-CURR-YR-THERMS-C.  
           MOVE WS-TOTAL-CURR-YR-THERMS-C                               
                                         TO P-RPT-TOTAL-CUR-YR-THERMS.  
           MOVE P-REPORT-HDR12           TO PRT33-RECORD.               
      *                                                                         
           PERFORM 8200-WRITE-FCSPT33           THRU 8200-EXIT.         
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2400-WRITE-PROCESS                                           *          
      ****************************************************************          
      *                                                                         
       2400-WRITE-PROCESS.                                              
      *                                                                         
           IF WS-HDG-RATE    NOT EQUAL WS-CURR-HDG-RATE                 
              OR WS-PREV-LOCAL-OFFICE                                   
                             NOT EQUAL                                  
                                       WS-CURR-LOCAL-OFFICE             
              OR WS-SIGN-HDG NOT EQUAL WS-CURR-SIGN-HDG                 
              OR WS-MIN-MAX  NOT EQUAL WS-CURR-MIN-MAX                  
              ADD  1                     TO WS-PAGE-NUM                 
              MOVE 'Y'                   TO WS-PRINT-RATE-PLAN-STATUS   
              PERFORM 2200-WRITE-HEADER         THRU 2200-EXIT          
           ELSE                                                         
              MOVE 'N'                   TO WS-PRINT-RATE-PLAN-STATUS   
           END-IF.                                                      
      *                                                                         
           MOVE WS-MIN-MAX               TO WS-CURR-MIN-MAX.            
           MOVE WS-PREV-LOCAL-OFFICE     TO WS-CURR-LOCAL-OFFICE.       
           MOVE WS-SIGN-HDG              TO WS-CURR-SIGN-HDG.           
           MOVE WS-HDG-RATE              TO WS-CURR-HDG-RATE.           
           MOVE WS-ACCT-NO               TO P-RPT-ACCT-NO.              
           MOVE BW04-CUSTOMER-NAME       TO P-RPT-CUST-NAME.            
      *                                                                         
           IF PRINT-RATE-PLAN-NO                                        
              MOVE BW04-RATE-PLAN-NO     TO P-RPT-RATE-PLAN-NO          
           ELSE                                                         
              MOVE SPACES                TO P-RPT-RATE-PLAN-NO          
           END-IF.                                                      
      *                                                                         
           PERFORM 2300-WRITE-DETAIL-RECORD     THRU 2300-EXIT.         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-READ-FCSBW04                                                       
      ******************************************************************        
       7100-READ-FCSBW04.                                               
      *                                                                         
           READ FCSBW04-FILE                                            
                                                                        
           IF FCSBW04-SUCCESSFUL  OR END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSRP015 ABORT *********'          
               DISPLAY '**ERROR IN READING FCSBW04 FILE ****'           
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCSBW04-STATUS           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
                                                                        
           CLOSE FCSBW04-FILE.                                          
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
